// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	scheme "open-cluster-management.io/api/client/cluster/clientset/versioned/scheme"
	v1beta1 "open-cluster-management.io/api/cluster/v1beta1"
)

// ManagedClusterSetsGetter has a method to return a ManagedClusterSetInterface.
// A group's client should implement this interface.
type ManagedClusterSetsGetter interface {
	ManagedClusterSets() ManagedClusterSetInterface
}

// ManagedClusterSetInterface has methods to work with ManagedClusterSet resources.
type ManagedClusterSetInterface interface {
	Create(ctx context.Context, managedClusterSet *v1beta1.ManagedClusterSet, opts v1.CreateOptions) (*v1beta1.ManagedClusterSet, error)
	Update(ctx context.Context, managedClusterSet *v1beta1.ManagedClusterSet, opts v1.UpdateOptions) (*v1beta1.ManagedClusterSet, error)
	UpdateStatus(ctx context.Context, managedClusterSet *v1beta1.ManagedClusterSet, opts v1.UpdateOptions) (*v1beta1.ManagedClusterSet, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.ManagedClusterSet, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ManagedClusterSetList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ManagedClusterSet, err error)
	ManagedClusterSetExpansion
}

// managedClusterSets implements ManagedClusterSetInterface
type managedClusterSets struct {
	client rest.Interface
}

// newManagedClusterSets returns a ManagedClusterSets
func newManagedClusterSets(c *ClusterV1beta1Client) *managedClusterSets {
	return &managedClusterSets{
		client: c.RESTClient(),
	}
}

// Get takes name of the managedClusterSet, and returns the corresponding managedClusterSet object, and an error if there is any.
func (c *managedClusterSets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.ManagedClusterSet, err error) {
	result = &v1beta1.ManagedClusterSet{}
	err = c.client.Get().
		Resource("managedclustersets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ManagedClusterSets that match those selectors.
func (c *managedClusterSets) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ManagedClusterSetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.ManagedClusterSetList{}
	err = c.client.Get().
		Resource("managedclustersets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested managedClusterSets.
func (c *managedClusterSets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("managedclustersets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a managedClusterSet and creates it.  Returns the server's representation of the managedClusterSet, and an error, if there is any.
func (c *managedClusterSets) Create(ctx context.Context, managedClusterSet *v1beta1.ManagedClusterSet, opts v1.CreateOptions) (result *v1beta1.ManagedClusterSet, err error) {
	result = &v1beta1.ManagedClusterSet{}
	err = c.client.Post().
		Resource("managedclustersets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedClusterSet).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a managedClusterSet and updates it. Returns the server's representation of the managedClusterSet, and an error, if there is any.
func (c *managedClusterSets) Update(ctx context.Context, managedClusterSet *v1beta1.ManagedClusterSet, opts v1.UpdateOptions) (result *v1beta1.ManagedClusterSet, err error) {
	result = &v1beta1.ManagedClusterSet{}
	err = c.client.Put().
		Resource("managedclustersets").
		Name(managedClusterSet.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedClusterSet).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *managedClusterSets) UpdateStatus(ctx context.Context, managedClusterSet *v1beta1.ManagedClusterSet, opts v1.UpdateOptions) (result *v1beta1.ManagedClusterSet, err error) {
	result = &v1beta1.ManagedClusterSet{}
	err = c.client.Put().
		Resource("managedclustersets").
		Name(managedClusterSet.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedClusterSet).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the managedClusterSet and deletes it. Returns an error if one occurs.
func (c *managedClusterSets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("managedclustersets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *managedClusterSets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("managedclustersets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched managedClusterSet.
func (c *managedClusterSets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ManagedClusterSet, err error) {
	result = &v1beta1.ManagedClusterSet{}
	err = c.client.Patch(pt).
		Resource("managedclustersets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
