package costmanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ConnectorClient is the client for the Connector methods of the Costmanagement service.
type ConnectorClient struct {
	BaseClient
}

// NewConnectorClient creates an instance of the ConnectorClient client.
func NewConnectorClient(subscriptionID string) ConnectorClient {
	return NewConnectorClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewConnectorClientWithBaseURI creates an instance of the ConnectorClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewConnectorClientWithBaseURI(baseURI string, subscriptionID string) ConnectorClient {
	return ConnectorClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckEligibility check if a connector already exists and return it's definition
// Parameters:
// connectorCredentials - connector credentials
func (client ConnectorClient) CheckEligibility(ctx context.Context, connectorCredentials CheckEligibilityDefinition) (result ConnectorDefinition, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorClient.CheckEligibility")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CheckEligibilityPreparer(ctx, connectorCredentials)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ConnectorClient", "CheckEligibility", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckEligibilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ConnectorClient", "CheckEligibility", resp, "Failure sending request")
		return
	}

	result, err = client.CheckEligibilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ConnectorClient", "CheckEligibility", resp, "Failure responding to request")
		return
	}

	return
}

// CheckEligibilityPreparer prepares the CheckEligibility request.
func (client ConnectorClient) CheckEligibilityPreparer(ctx context.Context, connectorCredentials CheckEligibilityDefinition) (*http.Request, error) {
	const APIVersion = "2019-03-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.CostManagement/checkConnectorEligibility"),
		autorest.WithJSON(connectorCredentials),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckEligibilitySender sends the CheckEligibility request. The method will close the
// http.Response Body if it receives an error.
func (client ConnectorClient) CheckEligibilitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CheckEligibilityResponder handles the response to the CheckEligibility request. The method always
// closes the http.Response Body.
func (client ConnectorClient) CheckEligibilityResponder(resp *http.Response) (result ConnectorDefinition, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
