/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "sigs.k8s.io/cluster-api/pkg/apis/cluster/v1alpha1"
	scheme "sigs.k8s.io/cluster-api/pkg/client/clientset_generated/clientset/scheme"
)

// MachineDeploymentsGetter has a method to return a MachineDeploymentInterface.
// A group's client should implement this interface.
type MachineDeploymentsGetter interface {
	MachineDeployments(namespace string) MachineDeploymentInterface
}

// MachineDeploymentInterface has methods to work with MachineDeployment resources.
type MachineDeploymentInterface interface {
	Create(*v1alpha1.MachineDeployment) (*v1alpha1.MachineDeployment, error)
	Update(*v1alpha1.MachineDeployment) (*v1alpha1.MachineDeployment, error)
	UpdateStatus(*v1alpha1.MachineDeployment) (*v1alpha1.MachineDeployment, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.MachineDeployment, error)
	List(opts v1.ListOptions) (*v1alpha1.MachineDeploymentList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.MachineDeployment, err error)
	MachineDeploymentExpansion
}

// machineDeployments implements MachineDeploymentInterface
type machineDeployments struct {
	client rest.Interface
	ns     string
}

// newMachineDeployments returns a MachineDeployments
func newMachineDeployments(c *ClusterV1alpha1Client, namespace string) *machineDeployments {
	return &machineDeployments{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the machineDeployment, and returns the corresponding machineDeployment object, and an error if there is any.
func (c *machineDeployments) Get(name string, options v1.GetOptions) (result *v1alpha1.MachineDeployment, err error) {
	result = &v1alpha1.MachineDeployment{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("machinedeployments").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MachineDeployments that match those selectors.
func (c *machineDeployments) List(opts v1.ListOptions) (result *v1alpha1.MachineDeploymentList, err error) {
	result = &v1alpha1.MachineDeploymentList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("machinedeployments").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested machineDeployments.
func (c *machineDeployments) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("machinedeployments").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a machineDeployment and creates it.  Returns the server's representation of the machineDeployment, and an error, if there is any.
func (c *machineDeployments) Create(machineDeployment *v1alpha1.MachineDeployment) (result *v1alpha1.MachineDeployment, err error) {
	result = &v1alpha1.MachineDeployment{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("machinedeployments").
		Body(machineDeployment).
		Do().
		Into(result)
	return
}

// Update takes the representation of a machineDeployment and updates it. Returns the server's representation of the machineDeployment, and an error, if there is any.
func (c *machineDeployments) Update(machineDeployment *v1alpha1.MachineDeployment) (result *v1alpha1.MachineDeployment, err error) {
	result = &v1alpha1.MachineDeployment{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("machinedeployments").
		Name(machineDeployment.Name).
		Body(machineDeployment).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *machineDeployments) UpdateStatus(machineDeployment *v1alpha1.MachineDeployment) (result *v1alpha1.MachineDeployment, err error) {
	result = &v1alpha1.MachineDeployment{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("machinedeployments").
		Name(machineDeployment.Name).
		SubResource("status").
		Body(machineDeployment).
		Do().
		Into(result)
	return
}

// Delete takes name of the machineDeployment and deletes it. Returns an error if one occurs.
func (c *machineDeployments) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("machinedeployments").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *machineDeployments) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("machinedeployments").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched machineDeployment.
func (c *machineDeployments) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.MachineDeployment, err error) {
	result = &v1alpha1.MachineDeployment{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("machinedeployments").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
