/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1beta1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-generated-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE. DO NOT EDIT.
var map_PartialObjectMetadata = map[string]string{
	"":         "PartialObjectMetadata is a generic representation of any object with ObjectMeta. It allows clients to get access to a particular ObjectMeta schema without knowing the details of the version.",
	"metadata": "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
}

func (PartialObjectMetadata) SwaggerDoc() map[string]string {
	return map_PartialObjectMetadata
}

var map_PartialObjectMetadataList = map[string]string{
	"":         "PartialObjectMetadataList contains a list of objects containing only their metadata",
	"metadata": "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
	"items":    "items contains each of the included items.",
}

func (PartialObjectMetadataList) SwaggerDoc() map[string]string {
	return map_PartialObjectMetadataList
}

var map_Table = map[string]string{
	"":                  "Table is a tabular representation of a set of API resources. The server transforms the object into a set of preferred columns for quickly reviewing the objects.",
	"metadata":          "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
	"columnDefinitions": "columnDefinitions describes each column in the returned items array. The number of cells per row will always match the number of column definitions.",
	"rows":              "rows is the list of items in the table.",
}

func (Table) SwaggerDoc() map[string]string {
	return map_Table
}

var map_TableColumnDefinition = map[string]string{
	"":            "TableColumnDefinition contains information about a column returned in the Table.",
	"name":        "name is a human readable name for the column.",
	"type":        "type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.",
	"format":      "format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.",
	"description": "description is a human readable description of this column.",
	"priority":    "priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a higher priority.",
}

func (TableColumnDefinition) SwaggerDoc() map[string]string {
	return map_TableColumnDefinition
}

var map_TableOptions = map[string]string{
	"":              "TableOptions are used when a Table is requested by the caller.",
	"includeObject": "includeObject decides whether to include each object along with its columnar information. Specifying \"None\" will return no object, specifying \"Object\" will return the full object contents, and specifying \"Metadata\" (the default) will return the object's metadata in the PartialObjectMetadata kind in version v1beta1 of the meta.k8s.io API group.",
}

func (TableOptions) SwaggerDoc() map[string]string {
	return map_TableOptions
}

var map_TableRow = map[string]string{
	"":           "TableRow is an individual row in a table.",
	"cells":      "cells will be as wide as headers and may contain strings, numbers (float64 or int64), booleans, simple maps, or lists, or null. See the type field of the column definition for a more detailed description.",
	"conditions": "conditions describe additional status of a row that are relevant for a human user.",
	"object":     "This field contains the requested additional information about each object based on the includeObject policy when requesting the Table. If \"None\", this field is empty, if \"Object\" this will be the default serialization of the object for the current API version, and if \"Metadata\" (the default) will contain the object metadata. Check the returned kind and apiVersion of the object before parsing.",
}

func (TableRow) SwaggerDoc() map[string]string {
	return map_TableRow
}

var map_TableRowCondition = map[string]string{
	"":        "TableRowCondition allows a row to be marked with additional information.",
	"type":    "Type of row condition.",
	"status":  "Status of the condition, one of True, False, Unknown.",
	"reason":  "(brief) machine readable reason for the condition's last transition.",
	"message": "Human readable message indicating details about last transition.",
}

func (TableRowCondition) SwaggerDoc() map[string]string {
	return map_TableRowCondition
}

// AUTO-GENERATED FUNCTIONS END HERE
