/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.syndesis.common.model.extension;

import java.io.IOException;
import java.io.InputStream;

import io.syndesis.common.util.json.JsonUtils;

import org.junit.Test;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;

import static org.assertj.core.api.Assertions.assertThat;

public class ExtensionSerializationTest {
    @Test
    public void testSerializeDeserialize() throws IOException {
        final ObjectReader reader = JsonUtils.reader();
        final ObjectWriter writer = JsonUtils.writer();

        try (InputStream source = getClass().getResourceAsStream("syndesis-extension-definition.json")) {
            final Extension read = reader.forType(Extension.class).readValue(source);

            final Extension recreated = new Extension.Builder()
                .createFrom(read)
                .build();

            final String written = writer.writeValueAsString(recreated);

            final Extension reRead = reader.forType(Extension.class).readValue(written);

            assertThat(reRead)
                .isEqualTo(read)
                .isEqualTo(recreated);
        }
    }
}
