(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["default~app"],{

/***/ "./packages/grafana-data/src/dataframe/CircularDataFrame.ts":
/*!******************************************************************!*\
  !*** ./packages/grafana-data/src/dataframe/CircularDataFrame.ts ***!
  \******************************************************************/
/*! exports provided: CircularDataFrame */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CircularDataFrame", function() { return CircularDataFrame; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _MutableDataFrame__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MutableDataFrame */ "./packages/grafana-data/src/dataframe/MutableDataFrame.ts");
/* harmony import */ var _vector_CircularVector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../vector/CircularVector */ "./packages/grafana-data/src/vector/CircularVector.ts");



/**
 * This dataframe can have values constantly added, and will never
 * exceed the given capacity
 */
var CircularDataFrame = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](CircularDataFrame, _super);
    function CircularDataFrame(options) {
        return _super.call(this, undefined, function (buffer) {
            return new _vector_CircularVector__WEBPACK_IMPORTED_MODULE_2__["CircularVector"](tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, options, { buffer: buffer }));
        }) || this;
    }
    return CircularDataFrame;
}(_MutableDataFrame__WEBPACK_IMPORTED_MODULE_1__["MutableDataFrame"]));



/***/ }),

/***/ "./packages/grafana-data/src/dataframe/DataFrameView.ts":
/*!**************************************************************!*\
  !*** ./packages/grafana-data/src/dataframe/DataFrameView.ts ***!
  \**************************************************************/
/*! exports provided: DataFrameView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataFrameView", function() { return DataFrameView; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

/**
 * This abstraction will present the contents of a DataFrame as if
 * it were a well typed javascript object Vector.
 *
 * NOTE: The contents of the object returned from `view.get(index)`
 * are optimized for use in a loop.  All calls return the same object
 * but the index has changed.
 *
 * For example, the three objects:
 *   const first = view.get(0);
 *   const second = view.get(1);
 *   const third = view.get(2);
 * will point to the contents at index 2
 *
 * If you need three different objects, consider something like:
 *   const first = { ... view.get(0) };
 *   const second = { ... view.get(1) };
 *   const third = { ... view.get(2) };
 */
var DataFrameView = /** @class */ (function () {
    function DataFrameView(data) {
        var _this = this;
        this.data = data;
        this.index = 0;
        var obj = {};
        var _loop_1 = function (i) {
            var field = data.fields[i];
            var getter = function () {
                return field.values.get(_this.index);
            };
            if (!obj.hasOwnProperty(field.name)) {
                Object.defineProperty(obj, field.name, {
                    enumerable: true,
                    get: getter,
                });
            }
            Object.defineProperty(obj, i, {
                enumerable: false,
                get: getter,
            });
        };
        for (var i = 0; i < data.fields.length; i++) {
            _loop_1(i);
        }
        this.obj = obj;
    }
    Object.defineProperty(DataFrameView.prototype, "dataFrame", {
        get: function () {
            return this.data;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataFrameView.prototype, "length", {
        get: function () {
            return this.data.length;
        },
        enumerable: true,
        configurable: true
    });
    DataFrameView.prototype.get = function (idx) {
        this.index = idx;
        return this.obj;
    };
    DataFrameView.prototype.toArray = function () {
        var arr = [];
        for (var i = 0; i < this.data.length; i++) {
            arr.push(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, this.get(i)));
        }
        return arr;
    };
    DataFrameView.prototype.toJSON = function () {
        return this.toArray();
    };
    DataFrameView.prototype.forEachRow = function (iterator) {
        for (var i = 0; i < this.data.length; i++) {
            iterator(this.get(i));
        }
    };
    return DataFrameView;
}());



/***/ }),

/***/ "./packages/grafana-data/src/dataframe/FieldCache.ts":
/*!***********************************************************!*\
  !*** ./packages/grafana-data/src/dataframe/FieldCache.ts ***!
  \***********************************************************/
/*! exports provided: FieldCache */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FieldCache", function() { return FieldCache; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../index */ "./packages/grafana-data/src/index.ts");


var FieldCache = /** @class */ (function () {
    function FieldCache(data) {
        this.fields = [];
        this.fieldByName = {};
        this.fieldByType = {};
        this.fields = data.fields.map(function (field, idx) { return (tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field, { index: idx })); });
        for (var i = 0; i < data.fields.length; i++) {
            var field = data.fields[i];
            // Make sure it has a type
            if (field.type === _index__WEBPACK_IMPORTED_MODULE_1__["FieldType"].other) {
                var t = Object(_index__WEBPACK_IMPORTED_MODULE_1__["guessFieldTypeForField"])(field);
                if (t) {
                    field.type = t;
                }
            }
            if (!this.fieldByType[field.type]) {
                this.fieldByType[field.type] = [];
            }
            this.fieldByType[field.type].push(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field, { index: i }));
            if (this.fieldByName[field.name]) {
                console.warn('Duplicate field names in DataFrame: ', field.name);
            }
            else {
                this.fieldByName[field.name] = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field, { index: i });
            }
        }
    }
    FieldCache.prototype.getFields = function (type) {
        if (!type) {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](this.fields); // All fields
        }
        var fields = this.fieldByType[type];
        if (fields) {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](fields);
        }
        return [];
    };
    FieldCache.prototype.hasFieldOfType = function (type) {
        var types = this.fieldByType[type];
        return types && types.length > 0;
    };
    FieldCache.prototype.getFirstFieldOfType = function (type) {
        var arr = this.fieldByType[type];
        if (arr && arr.length > 0) {
            return arr[0];
        }
        return undefined;
    };
    FieldCache.prototype.hasFieldNamed = function (name) {
        return !!this.fieldByName[name];
    };
    /**
     * Returns the first field with the given name.
     */
    FieldCache.prototype.getFieldByName = function (name) {
        return this.fieldByName[name];
    };
    return FieldCache;
}());



/***/ }),

/***/ "./packages/grafana-data/src/dataframe/MutableDataFrame.ts":
/*!*****************************************************************!*\
  !*** ./packages/grafana-data/src/dataframe/MutableDataFrame.ts ***!
  \*****************************************************************/
/*! exports provided: MISSING_VALUE, MutableDataFrame */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MISSING_VALUE", function() { return MISSING_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MutableDataFrame", function() { return MutableDataFrame; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../types/dataFrame */ "./packages/grafana-data/src/types/dataFrame.ts");
/* harmony import */ var _processDataFrame__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./processDataFrame */ "./packages/grafana-data/src/dataframe/processDataFrame.ts");
/* harmony import */ var lodash_isArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isArray */ "./node_modules/lodash/isArray.js");
/* harmony import */ var lodash_isArray__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isArray__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/isString */ "./node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_fieldParser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/fieldParser */ "./packages/grafana-data/src/utils/fieldParser.ts");
/* harmony import */ var _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../vector/ArrayVector */ "./packages/grafana-data/src/vector/ArrayVector.ts");
/* harmony import */ var _vector_vectorToArray__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../vector/vectorToArray */ "./packages/grafana-data/src/vector/vectorToArray.ts");








var MISSING_VALUE = null;
var MutableDataFrame = /** @class */ (function () {
    function MutableDataFrame(source, creator) {
        var e_1, _a;
        var _this = this;
        this.fields = [];
        this.values = {};
        this.first = new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_6__["ArrayVector"]();
        // This creates the underlying storage buffers
        this.creator = creator
            ? creator
            : function (buffer) {
                return new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_6__["ArrayVector"](buffer);
            };
        // Copy values from
        if (source) {
            var name = source.name, labels = source.labels, refId = source.refId, meta = source.meta, fields = source.fields;
            if (name) {
                this.name = name;
            }
            if (labels) {
                this.labels = labels;
            }
            if (refId) {
                this.refId = refId;
            }
            if (meta) {
                this.meta = meta;
            }
            if (fields) {
                try {
                    for (var fields_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](fields), fields_1_1 = fields_1.next(); !fields_1_1.done; fields_1_1 = fields_1.next()) {
                        var f = fields_1_1.value;
                        this.addField(f);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (fields_1_1 && !fields_1_1.done && (_a = fields_1.return)) _a.call(fields_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
        }
        // Get Length to show up if you use spread
        Object.defineProperty(this, 'length', {
            enumerable: true,
            get: function () {
                return _this.first.length;
            },
        });
    }
    Object.defineProperty(MutableDataFrame.prototype, "length", {
        // Defined for Vector interface
        get: function () {
            return this.first.length;
        },
        enumerable: true,
        configurable: true
    });
    MutableDataFrame.prototype.addFieldFor = function (value, name) {
        return this.addField({
            name: name || '',
            type: Object(_processDataFrame__WEBPACK_IMPORTED_MODULE_2__["guessFieldTypeFromValue"])(value),
        });
    };
    MutableDataFrame.prototype.addField = function (f, startLength) {
        var buffer = undefined;
        if (f.values) {
            if (lodash_isArray__WEBPACK_IMPORTED_MODULE_3___default()(f.values)) {
                buffer = f.values;
            }
            else {
                buffer = f.values.toArray();
            }
        }
        var type = f.type;
        if (!type && ('time' === f.name || 'Time' === f.name)) {
            type = _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"].time;
        }
        else {
            if (!type && buffer && buffer.length) {
                type = Object(_processDataFrame__WEBPACK_IMPORTED_MODULE_2__["guessFieldTypeFromValue"])(buffer[0]);
            }
            if (!type) {
                type = _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"].other;
            }
        }
        // Make sure it has a name
        var name = f.name;
        if (!name) {
            if (type === _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"].time) {
                name = this.values['Time'] ? "Time " + (this.fields.length + 1) : 'Time';
            }
            else {
                name = "Field " + (this.fields.length + 1);
            }
        }
        var field = {
            name: name,
            type: type,
            config: f.config || {},
            values: this.creator(buffer),
        };
        if (type === _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"].other) {
            type = Object(_processDataFrame__WEBPACK_IMPORTED_MODULE_2__["guessFieldTypeForField"])(field);
            if (type) {
                field.type = type;
            }
        }
        this.fields.push(field);
        this.first = this.fields[0].values;
        // The Field Already exists
        if (this.values[name]) {
            console.warn("Duplicate field names found: " + name + ", only the first will be accessible");
        }
        else {
            this.values[name] = field.values;
        }
        // Make sure the field starts with a given length
        if (startLength) {
            while (field.values.length < startLength) {
                field.values.add(MISSING_VALUE);
            }
        }
        else {
            this.validate();
        }
        return field;
    };
    MutableDataFrame.prototype.validate = function () {
        var e_2, _a;
        // Make sure all arrays are the same length
        var length = this.fields.reduce(function (v, f) {
            return Math.max(v, f.values.length);
        }, 0);
        try {
            // Add empty elements until everything mastches
            for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.fields), _c = _b.next(); !_c.done; _c = _b.next()) {
                var field = _c.value;
                while (field.values.length !== length) {
                    field.values.add(MISSING_VALUE);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    MutableDataFrame.prototype.addMissingFieldsFor = function (value) {
        var e_3, _a;
        try {
            for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](Object.keys(value)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (!this.values[key]) {
                    this.addField({
                        name: key,
                        type: Object(_processDataFrame__WEBPACK_IMPORTED_MODULE_2__["guessFieldTypeFromValue"])(value[key]),
                    });
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    /**
     * Reverse all values
     */
    MutableDataFrame.prototype.reverse = function () {
        var e_4, _a;
        try {
            for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.fields), _c = _b.next(); !_c.done; _c = _b.next()) {
                var f = _c.value;
                f.values.reverse();
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
    };
    /**
     * This will add each value to the corresponding column
     */
    MutableDataFrame.prototype.appendRow = function (row) {
        // Add any extra columns
        for (var i = this.fields.length; i < row.length; i++) {
            this.addField({
                name: "Field " + (i + 1),
                type: Object(_processDataFrame__WEBPACK_IMPORTED_MODULE_2__["guessFieldTypeFromValue"])(row[i]),
            });
        }
        // The first line may change the field types
        if (this.length < 1) {
            for (var i = 0; i < this.fields.length; i++) {
                var f = this.fields[i];
                if (!f.type || f.type === _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"].other) {
                    f.type = Object(_processDataFrame__WEBPACK_IMPORTED_MODULE_2__["guessFieldTypeFromValue"])(row[i]);
                }
            }
        }
        for (var i = 0; i < this.fields.length; i++) {
            var f = this.fields[i];
            var v = row[i];
            if (f.type !== _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"].string && lodash_isString__WEBPACK_IMPORTED_MODULE_4___default()(v)) {
                if (!f.parse) {
                    f.parse = Object(_utils_fieldParser__WEBPACK_IMPORTED_MODULE_5__["makeFieldParser"])(v, f);
                }
                v = f.parse(v);
            }
            f.values.add(v);
        }
    };
    /**
     * Add all properties of the value as fields on the frame
     */
    MutableDataFrame.prototype.add = function (value, addMissingFields) {
        var e_5, _a;
        if (addMissingFields) {
            this.addMissingFieldsFor(value);
        }
        // Will add one value for every field
        var obj = value;
        try {
            for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.fields), _c = _b.next(); !_c.done; _c = _b.next()) {
                var field = _c.value;
                var val = obj[field.name];
                if (field.type !== _types_dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"].string && lodash_isString__WEBPACK_IMPORTED_MODULE_4___default()(val)) {
                    if (!field.parse) {
                        field.parse = Object(_utils_fieldParser__WEBPACK_IMPORTED_MODULE_5__["makeFieldParser"])(val, field);
                    }
                    val = field.parse(val);
                }
                if (val === undefined) {
                    val = MISSING_VALUE;
                }
                field.values.add(val);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
    };
    MutableDataFrame.prototype.set = function (index, value, addMissingFields) {
        var e_6, _a;
        if (index > this.length) {
            throw new Error('Unable ot set value beyond current length');
        }
        if (addMissingFields) {
            this.addMissingFieldsFor(value);
        }
        var obj = value || {};
        try {
            for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.fields), _c = _b.next(); !_c.done; _c = _b.next()) {
                var field = _c.value;
                field.values.set(index, obj[field.name]);
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_6) throw e_6.error; }
        }
    };
    /**
     * Get an object with a property for each field in the DataFrame
     */
    MutableDataFrame.prototype.get = function (idx) {
        var e_7, _a;
        var v = {};
        try {
            for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.fields), _c = _b.next(); !_c.done; _c = _b.next()) {
                var field = _c.value;
                v[field.name] = field.values.get(idx);
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_7) throw e_7.error; }
        }
        return v;
    };
    MutableDataFrame.prototype.toArray = function () {
        return Object(_vector_vectorToArray__WEBPACK_IMPORTED_MODULE_7__["vectorToArray"])(this);
    };
    /**
     * The simplified JSON values used in JSON.stringify()
     */
    MutableDataFrame.prototype.toJSON = function () {
        return Object(_processDataFrame__WEBPACK_IMPORTED_MODULE_2__["toDataFrameDTO"])(this);
    };
    return MutableDataFrame;
}());



/***/ }),

/***/ "./packages/grafana-data/src/dataframe/index.ts":
/*!******************************************************!*\
  !*** ./packages/grafana-data/src/dataframe/index.ts ***!
  \******************************************************/
/*! exports provided: DataFrameView, FieldCache, CircularDataFrame, MISSING_VALUE, MutableDataFrame, guessFieldTypeFromValue, guessFieldTypeForField, guessFieldTypes, isTableData, isDataFrame, toDataFrame, toLegacyResponseData, sortDataFrame, reverseDataFrame, getTimeField, getDataFrameRow, toDataFrameDTO */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _DataFrameView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DataFrameView */ "./packages/grafana-data/src/dataframe/DataFrameView.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataFrameView", function() { return _DataFrameView__WEBPACK_IMPORTED_MODULE_0__["DataFrameView"]; });

/* harmony import */ var _FieldCache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FieldCache */ "./packages/grafana-data/src/dataframe/FieldCache.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldCache", function() { return _FieldCache__WEBPACK_IMPORTED_MODULE_1__["FieldCache"]; });

/* harmony import */ var _CircularDataFrame__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircularDataFrame */ "./packages/grafana-data/src/dataframe/CircularDataFrame.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CircularDataFrame", function() { return _CircularDataFrame__WEBPACK_IMPORTED_MODULE_2__["CircularDataFrame"]; });

/* harmony import */ var _MutableDataFrame__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MutableDataFrame */ "./packages/grafana-data/src/dataframe/MutableDataFrame.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MISSING_VALUE", function() { return _MutableDataFrame__WEBPACK_IMPORTED_MODULE_3__["MISSING_VALUE"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MutableDataFrame", function() { return _MutableDataFrame__WEBPACK_IMPORTED_MODULE_3__["MutableDataFrame"]; });

/* harmony import */ var _processDataFrame__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./processDataFrame */ "./packages/grafana-data/src/dataframe/processDataFrame.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypeFromValue", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["guessFieldTypeFromValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypeForField", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["guessFieldTypeForField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypes", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["guessFieldTypes"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isTableData", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["isTableData"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isDataFrame", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["isDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toDataFrame", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["toDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toLegacyResponseData", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["toLegacyResponseData"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sortDataFrame", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["sortDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "reverseDataFrame", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["reverseDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getTimeField", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["getTimeField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDataFrameRow", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["getDataFrameRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toDataFrameDTO", function() { return _processDataFrame__WEBPACK_IMPORTED_MODULE_4__["toDataFrameDTO"]; });








/***/ }),

/***/ "./packages/grafana-data/src/dataframe/processDataFrame.ts":
/*!*****************************************************************!*\
  !*** ./packages/grafana-data/src/dataframe/processDataFrame.ts ***!
  \*****************************************************************/
/*! exports provided: guessFieldTypeFromValue, guessFieldTypeForField, guessFieldTypes, isTableData, isDataFrame, toDataFrame, toLegacyResponseData, sortDataFrame, reverseDataFrame, getTimeField, getDataFrameRow, toDataFrameDTO */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypeFromValue", function() { return guessFieldTypeFromValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypeForField", function() { return guessFieldTypeForField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypes", function() { return guessFieldTypes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isTableData", function() { return isTableData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDataFrame", function() { return isDataFrame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toDataFrame", function() { return toDataFrame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toLegacyResponseData", function() { return toLegacyResponseData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sortDataFrame", function() { return sortDataFrame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "reverseDataFrame", function() { return reverseDataFrame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTimeField", function() { return getTimeField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDataFrameRow", function() { return getDataFrameRow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toDataFrameDTO", function() { return toDataFrameDTO; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isNumber */ "./node_modules/lodash/isNumber.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isNumber__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isString */ "./node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isBoolean__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isBoolean */ "./node_modules/lodash/isBoolean.js");
/* harmony import */ var lodash_isBoolean__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isBoolean__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _types_index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../types/index */ "./packages/grafana-data/src/types/index.ts");
/* harmony import */ var _datetime_moment_wrapper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../datetime/moment_wrapper */ "./packages/grafana-data/src/datetime/moment_wrapper.ts");
/* harmony import */ var _utils_deprecationWarning__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/deprecationWarning */ "./packages/grafana-data/src/utils/deprecationWarning.ts");
/* harmony import */ var _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../vector/ArrayVector */ "./packages/grafana-data/src/vector/ArrayVector.ts");
/* harmony import */ var _MutableDataFrame__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./MutableDataFrame */ "./packages/grafana-data/src/dataframe/MutableDataFrame.ts");
/* harmony import */ var _vector_SortedVector__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../vector/SortedVector */ "./packages/grafana-data/src/vector/SortedVector.ts");

// Libraries



// Types






function convertTableToDataFrame(table) {
    var e_1, _a, e_2, _b;
    var fields = table.columns.map(function (c) {
        var text = c.text, disp = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](c, ["text"]);
        return {
            name: text,
            config: (disp || {}),
            values: new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__["ArrayVector"](),
            type: _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].other,
        };
    });
    try {
        for (var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](table.rows), _d = _c.next(); !_d.done; _d = _c.next()) {
            var row = _d.value;
            for (var i = 0; i < fields.length; i++) {
                fields[i].values.buffer.push(row[i]);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_1) throw e_1.error; }
    }
    try {
        for (var fields_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](fields), fields_1_1 = fields_1.next(); !fields_1_1.done; fields_1_1 = fields_1.next()) {
            var f = fields_1_1.value;
            var t = guessFieldTypeForField(f);
            if (t) {
                f.type = t;
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (fields_1_1 && !fields_1_1.done && (_b = fields_1.return)) _b.call(fields_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return {
        fields: fields,
        refId: table.refId,
        meta: table.meta,
        name: table.name,
        length: table.rows.length,
    };
}
function convertTimeSeriesToDataFrame(timeSeries) {
    var e_3, _a;
    var fields = [
        {
            name: timeSeries.target || 'Value',
            type: _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].number,
            config: {
                unit: timeSeries.unit,
            },
            values: new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__["ArrayVector"](),
        },
        {
            name: 'Time',
            type: _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].time,
            config: {
                unit: 'dateTimeAsIso',
            },
            values: new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__["ArrayVector"](),
        },
    ];
    try {
        for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](timeSeries.datapoints), _c = _b.next(); !_c.done; _c = _b.next()) {
            var point = _c.value;
            fields[0].values.buffer.push(point[0]);
            fields[1].values.buffer.push(point[1]);
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return {
        name: timeSeries.target,
        labels: timeSeries.tags,
        refId: timeSeries.refId,
        meta: timeSeries.meta,
        fields: fields,
        length: timeSeries.datapoints.length,
    };
}
/**
 * This is added temporarily while we convert the LogsModel
 * to DataFrame.  See: https://github.com/grafana/grafana/issues/18528
 */
function convertGraphSeriesToDataFrame(graphSeries) {
    var x = new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__["ArrayVector"]();
    var y = new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__["ArrayVector"]();
    for (var i = 0; i < graphSeries.data.length; i++) {
        var row = graphSeries.data[i];
        x.buffer.push(row[1]);
        y.buffer.push(row[0]);
    }
    return {
        name: graphSeries.label,
        fields: [
            {
                name: graphSeries.label || 'Value',
                type: _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].number,
                config: {},
                values: x,
            },
            {
                name: 'Time',
                type: _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].time,
                config: {
                    unit: 'dateTimeAsIso',
                },
                values: y,
            },
        ],
        length: x.buffer.length,
    };
}
function convertJSONDocumentDataToDataFrame(timeSeries) {
    var e_4, _a;
    var fields = [
        {
            name: timeSeries.target,
            type: _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].other,
            config: {
                unit: timeSeries.unit,
                filterable: timeSeries.filterable,
            },
            values: new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__["ArrayVector"](),
        },
    ];
    try {
        for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](timeSeries.datapoints), _c = _b.next(); !_c.done; _c = _b.next()) {
            var point = _c.value;
            fields[0].values.buffer.push(point);
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_4) throw e_4.error; }
    }
    return {
        name: timeSeries.target,
        labels: timeSeries.tags,
        refId: timeSeries.target,
        meta: { json: true },
        fields: fields,
        length: timeSeries.datapoints.length,
    };
}
// PapaParse Dynamic Typing regex:
// https://github.com/mholt/PapaParse/blob/master/papaparse.js#L998
var NUMBER = /^\s*-?(\d*\.?\d+|\d+\.?\d*)(e[-+]?\d+)?\s*$/i;
/**
 * Given a value this will guess the best column type
 *
 * TODO: better Date/Time support!  Look for standard date strings?
 */
function guessFieldTypeFromValue(v) {
    if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_1___default()(v)) {
        return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].number;
    }
    if (lodash_isString__WEBPACK_IMPORTED_MODULE_2___default()(v)) {
        if (NUMBER.test(v)) {
            return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].number;
        }
        if (v === 'true' || v === 'TRUE' || v === 'True' || v === 'false' || v === 'FALSE' || v === 'False') {
            return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].boolean;
        }
        return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].string;
    }
    if (lodash_isBoolean__WEBPACK_IMPORTED_MODULE_3___default()(v)) {
        return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].boolean;
    }
    if (v instanceof Date || Object(_datetime_moment_wrapper__WEBPACK_IMPORTED_MODULE_5__["isDateTime"])(v)) {
        return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].time;
    }
    return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].other;
}
/**
 * Looks at the data to guess the column type.  This ignores any existing setting
 */
function guessFieldTypeForField(field) {
    // 1. Use the column name to guess
    if (field.name) {
        var name = field.name.toLowerCase();
        if (name === 'date' || name === 'time') {
            return _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].time;
        }
    }
    // 2. Check the first non-null value
    for (var i = 0; i < field.values.length; i++) {
        var v = field.values.get(i);
        if (v !== null) {
            return guessFieldTypeFromValue(v);
        }
    }
    // Could not find anything
    return undefined;
}
/**
 * @returns a copy of the series with the best guess for each field type
 * If the series already has field types defined, they will be used
 */
var guessFieldTypes = function (series) {
    for (var i = 0; i < series.fields.length; i++) {
        if (!series.fields[i].type) {
            // Somethign is missing a type return a modified copy
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, series, { fields: series.fields.map(function (field) {
                    if (field.type && field.type !== _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].other) {
                        return field;
                    }
                    // Calculate a reasonable schema value
                    return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field, { type: guessFieldTypeForField(field) || _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].other });
                }) });
        }
    }
    // No changes necessary
    return series;
};
var isTableData = function (data) { return data && data.hasOwnProperty('columns'); };
var isDataFrame = function (data) { return data && data.hasOwnProperty('fields'); };
var toDataFrame = function (data) {
    if (data.hasOwnProperty('fields')) {
        // @deprecated -- remove in 6.5
        if (data.hasOwnProperty('rows')) {
            var v = new _MutableDataFrame__WEBPACK_IMPORTED_MODULE_8__["MutableDataFrame"](data);
            var rows = data.rows;
            for (var i = 0; i < rows.length; i++) {
                v.appendRow(rows[i]);
            }
            Object(_utils_deprecationWarning__WEBPACK_IMPORTED_MODULE_6__["deprecationWarning"])('DataFrame', '.rows', 'columnar format');
            return v;
        }
        // DataFrameDTO does not have length
        if (data.hasOwnProperty('length')) {
            return data;
        }
        // This will convert the array values into Vectors
        return new _MutableDataFrame__WEBPACK_IMPORTED_MODULE_8__["MutableDataFrame"](data);
    }
    // Handle legacy docs/json type
    if (data.hasOwnProperty('type') && data.type === 'docs') {
        return convertJSONDocumentDataToDataFrame(data);
    }
    if (data.hasOwnProperty('datapoints')) {
        return convertTimeSeriesToDataFrame(data);
    }
    if (data.hasOwnProperty('data')) {
        return convertGraphSeriesToDataFrame(data);
    }
    if (data.hasOwnProperty('columns')) {
        return convertTableToDataFrame(data);
    }
    console.warn('Can not convert', data);
    throw new Error('Unsupported data format');
};
var toLegacyResponseData = function (frame) {
    var fields = frame.fields;
    var rowCount = frame.length;
    var rows = [];
    for (var i = 0; i < rowCount; i++) {
        var row = [];
        for (var j = 0; j < fields.length; j++) {
            row.push(fields[j].values.get(i));
        }
        rows.push(row);
    }
    if (fields.length === 2) {
        var type = fields[1].type;
        if (!type) {
            type = guessFieldTypeForField(fields[1]) || _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].other;
        }
        if (type === _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].time) {
            return {
                alias: fields[0].name || frame.name,
                target: fields[0].name || frame.name,
                datapoints: rows,
                unit: fields[0].config ? fields[0].config.unit : undefined,
                refId: frame.refId,
                meta: frame.meta,
            };
        }
    }
    if (frame.meta && frame.meta.json) {
        return {
            alias: fields[0].name || frame.name,
            target: fields[0].name || frame.name,
            datapoints: fields[0].values.toArray(),
            filterable: fields[0].config ? fields[0].config.filterable : undefined,
            type: 'docs',
        };
    }
    return {
        columns: fields.map(function (f) {
            var name = f.name, config = f.config;
            if (config) {
                // keep unit etc
                var column = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](config, []);
                column.text = name;
                return column;
            }
            return { text: name };
        }),
        type: 'table',
        refId: frame.refId,
        meta: frame.meta,
        rows: rows,
    };
};
function sortDataFrame(data, sortIndex, reverse) {
    if (reverse === void 0) { reverse = false; }
    var field = data.fields[sortIndex];
    if (!field) {
        return data;
    }
    // Natural order
    var index = [];
    for (var i = 0; i < data.length; i++) {
        index.push(i);
    }
    var values = field.values;
    // Numeric Comparison
    var compare = function (a, b) {
        var vA = values.get(a);
        var vB = values.get(b);
        return vA - vB; // works for numbers!
    };
    // String Comparison
    if (field.type === _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].string) {
        compare = function (a, b) {
            var vA = values.get(a);
            var vB = values.get(b);
            return vA.localeCompare(vB);
        };
    }
    // Run the sort function
    index.sort(compare);
    if (reverse) {
        index.reverse();
    }
    // Return a copy that maps sorted values
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, data, { fields: data.fields.map(function (f) {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, f, { values: new _vector_SortedVector__WEBPACK_IMPORTED_MODULE_9__["SortedVector"](f.values, index) });
        }) });
}
/**
 * Returns a copy with all values reversed
 */
function reverseDataFrame(data) {
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, data, { fields: data.fields.map(function (f) {
            var copy = tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](f.values.toArray());
            copy.reverse();
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, f, { values: new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_7__["ArrayVector"](copy) });
        }) });
}
var getTimeField = function (series) {
    for (var i = 0; i < series.fields.length; i++) {
        if (series.fields[i].type === _types_index__WEBPACK_IMPORTED_MODULE_4__["FieldType"].time) {
            return {
                timeField: series.fields[i],
                timeIndex: i,
            };
        }
    }
    return {};
};
/**
 * Wrapper to get an array from each field value
 */
function getDataFrameRow(data, row) {
    var e_5, _a;
    var values = [];
    try {
        for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](data.fields), _c = _b.next(); !_c.done; _c = _b.next()) {
            var field = _c.value;
            values.push(field.values.get(row));
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_5) throw e_5.error; }
    }
    return values;
}
/**
 * Returns a copy that does not include functions
 */
function toDataFrameDTO(data) {
    var fields = data.fields.map(function (f) {
        return {
            name: f.name,
            type: f.type,
            config: f.config,
            values: f.values.toArray(),
        };
    });
    return {
        fields: fields,
        refId: data.refId,
        meta: data.meta,
        name: data.name,
        labels: data.labels,
    };
}


/***/ }),

/***/ "./packages/grafana-data/src/datetime/datemath.ts":
/*!********************************************************!*\
  !*** ./packages/grafana-data/src/datetime/datemath.ts ***!
  \********************************************************/
/*! exports provided: isMathString, parse, isValid, parseDateMath */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isMathString", function() { return isMathString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parse", function() { return parse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isValid", function() { return isValid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parseDateMath", function() { return parseDateMath; });
/* harmony import */ var lodash_includes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/includes */ "./node_modules/lodash/includes.js");
/* harmony import */ var lodash_includes__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_includes__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isDate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isDate */ "./node_modules/lodash/isDate.js");
/* harmony import */ var lodash_isDate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isDate__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./moment_wrapper */ "./packages/grafana-data/src/datetime/moment_wrapper.ts");



var units = ['y', 'M', 'w', 'd', 'h', 'm', 's'];
function isMathString(text) {
    if (!text) {
        return false;
    }
    if (typeof text === 'string' && (text.substring(0, 3) === 'now' || text.includes('||'))) {
        return true;
    }
    else {
        return false;
    }
}
/**
 * Parses different types input to a moment instance. There is a specific formatting language that can be used
 * if text arg is string. See unit tests for examples.
 * @param text
 * @param roundUp See parseDateMath function.
 * @param timezone Only string 'utc' is acceptable here, for anything else, local timezone is used.
 */
function parse(text, roundUp, timezone) {
    if (!text) {
        return undefined;
    }
    if (typeof text !== 'string') {
        if (Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["isDateTime"])(text)) {
            return text;
        }
        if (lodash_isDate__WEBPACK_IMPORTED_MODULE_1___default()(text)) {
            return Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["dateTime"])(text);
        }
        // We got some non string which is not a moment nor Date. TS should be able to check for that but not always.
        return undefined;
    }
    else {
        var time = void 0;
        var mathString = '';
        var index = void 0;
        var parseString = void 0;
        if (text.substring(0, 3) === 'now') {
            time = Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["dateTimeForTimeZone"])(timezone);
            mathString = text.substring('now'.length);
        }
        else {
            index = text.indexOf('||');
            if (index === -1) {
                parseString = text;
                mathString = ''; // nothing else
            }
            else {
                parseString = text.substring(0, index);
                mathString = text.substring(index + 2);
            }
            // We're going to just require ISO8601 timestamps, k?
            time = Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["dateTime"])(parseString, _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["ISO_8601"]);
        }
        if (!mathString.length) {
            return time;
        }
        return parseDateMath(mathString, time, roundUp);
    }
}
/**
 * Checks if text is a valid date which in this context means that it is either a Moment instance or it can be parsed
 * by parse function. See parse function to see what is considered acceptable.
 * @param text
 */
function isValid(text) {
    var date = parse(text);
    if (!date) {
        return false;
    }
    if (Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["isDateTime"])(date)) {
        return date.isValid();
    }
    return false;
}
/**
 * Parses math part of the time string and shifts supplied time according to that math. See unit tests for examples.
 * @param mathString
 * @param time
 * @param roundUp If true it will round the time to endOf time unit, otherwise to startOf time unit.
 */
// TODO: Had to revert Andrejs `time: moment.Moment` to `time: any`
function parseDateMath(mathString, time, roundUp) {
    var strippedMathString = mathString.replace(/\s/g, '');
    var dateTime = time;
    var i = 0;
    var len = strippedMathString.length;
    while (i < len) {
        var c = strippedMathString.charAt(i++);
        var type = void 0;
        var num = void 0;
        var unit = void 0;
        if (c === '/') {
            type = 0;
        }
        else if (c === '+') {
            type = 1;
        }
        else if (c === '-') {
            type = 2;
        }
        else {
            return undefined;
        }
        if (isNaN(parseInt(strippedMathString.charAt(i), 10))) {
            num = 1;
        }
        else if (strippedMathString.length === 2) {
            num = strippedMathString.charAt(i);
        }
        else {
            var numFrom = i;
            while (!isNaN(parseInt(strippedMathString.charAt(i), 10))) {
                i++;
                if (i > 10) {
                    return undefined;
                }
            }
            num = parseInt(strippedMathString.substring(numFrom, i), 10);
        }
        if (type === 0) {
            // rounding is only allowed on whole, single, units (eg M or 1M, not 0.5M or 2M)
            if (num !== 1) {
                return undefined;
            }
        }
        unit = strippedMathString.charAt(i++);
        if (!lodash_includes__WEBPACK_IMPORTED_MODULE_0___default()(units, unit)) {
            return undefined;
        }
        else {
            if (type === 0) {
                if (roundUp) {
                    dateTime.endOf(unit);
                }
                else {
                    dateTime.startOf(unit);
                }
            }
            else if (type === 1) {
                dateTime.add(num, unit);
            }
            else if (type === 2) {
                dateTime.subtract(num, unit);
            }
        }
    }
    return dateTime;
}


/***/ }),

/***/ "./packages/grafana-data/src/datetime/index.ts":
/*!*****************************************************!*\
  !*** ./packages/grafana-data/src/datetime/index.ts ***!
  \*****************************************************/
/*! exports provided: ISO_8601, setLocale, getLocaleData, isDateTime, toUtc, toDuration, dateTime, dateTimeAsMoment, dateTimeForTimeZone, getTimeZoneGroups, dateMath, rangeUtil */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _datemath__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./datemath */ "./packages/grafana-data/src/datetime/datemath.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "dateMath", function() { return _datemath__WEBPACK_IMPORTED_MODULE_0__; });
/* harmony import */ var _rangeutil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rangeutil */ "./packages/grafana-data/src/datetime/rangeutil.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "rangeUtil", function() { return _rangeutil__WEBPACK_IMPORTED_MODULE_1__; });
/* harmony import */ var _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./moment_wrapper */ "./packages/grafana-data/src/datetime/moment_wrapper.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ISO_8601", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["ISO_8601"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setLocale", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["setLocale"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLocaleData", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["getLocaleData"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isDateTime", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["isDateTime"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toUtc", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["toUtc"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toDuration", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["toDuration"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dateTime", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["dateTime"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dateTimeAsMoment", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["dateTimeAsMoment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dateTimeForTimeZone", function() { return _moment_wrapper__WEBPACK_IMPORTED_MODULE_2__["dateTimeForTimeZone"]; });

/* harmony import */ var _timezones__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./timezones */ "./packages/grafana-data/src/datetime/timezones.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getTimeZoneGroups", function() { return _timezones__WEBPACK_IMPORTED_MODULE_3__["getTimeZoneGroups"]; });

// Names are too general to export globally







/***/ }),

/***/ "./packages/grafana-data/src/datetime/moment_wrapper.ts":
/*!**************************************************************!*\
  !*** ./packages/grafana-data/src/datetime/moment_wrapper.ts ***!
  \**************************************************************/
/*! exports provided: ISO_8601, setLocale, getLocaleData, isDateTime, toUtc, toDuration, dateTime, dateTimeAsMoment, dateTimeForTimeZone */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ISO_8601", function() { return ISO_8601; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setLocale", function() { return setLocale; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLocaleData", function() { return getLocaleData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDateTime", function() { return isDateTime; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toUtc", function() { return toUtc; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toDuration", function() { return toDuration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dateTime", function() { return dateTime; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dateTimeAsMoment", function() { return dateTimeAsMoment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dateTimeForTimeZone", function() { return dateTimeForTimeZone; });
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* tslint:disable:import-blacklist ban ban-types */

var ISO_8601 = moment__WEBPACK_IMPORTED_MODULE_0___default.a.ISO_8601;
var setLocale = function (language) {
    moment__WEBPACK_IMPORTED_MODULE_0___default.a.locale(language);
};
var getLocaleData = function () {
    return moment__WEBPACK_IMPORTED_MODULE_0___default.a.localeData();
};
var isDateTime = function (value) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default.a.isMoment(value);
};
var toUtc = function (input, formatInput) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default.a.utc(input, formatInput);
};
var toDuration = function (input, unit) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default.a.duration(input, unit);
};
var dateTime = function (input, formatInput) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default()(input, formatInput);
};
var dateTimeAsMoment = function (input) {
    return dateTime(input);
};
var dateTimeForTimeZone = function (timezone, input, formatInput) {
    if (timezone === 'utc') {
        return toUtc(input, formatInput);
    }
    return dateTime(input, formatInput);
};


/***/ }),

/***/ "./packages/grafana-data/src/datetime/rangeutil.ts":
/*!*********************************************************!*\
  !*** ./packages/grafana-data/src/datetime/rangeutil.ts ***!
  \*********************************************************/
/*! exports provided: getRelativeTimesList, describeTextRange, describeTimeRange, isValidTimeSpan */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getRelativeTimesList", function() { return getRelativeTimesList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "describeTextRange", function() { return describeTextRange; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "describeTimeRange", function() { return describeTimeRange; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isValidTimeSpan", function() { return isValidTimeSpan; });
/* harmony import */ var lodash_each__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/each */ "./node_modules/lodash/each.js");
/* harmony import */ var lodash_each__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_each__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_groupBy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/groupBy */ "./node_modules/lodash/groupBy.js");
/* harmony import */ var lodash_groupBy__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_groupBy__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _datemath__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./datemath */ "./packages/grafana-data/src/datetime/datemath.ts");
/* harmony import */ var _moment_wrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./moment_wrapper */ "./packages/grafana-data/src/datetime/moment_wrapper.ts");




var spans = {
    s: { display: 'second' },
    m: { display: 'minute' },
    h: { display: 'hour' },
    d: { display: 'day' },
    w: { display: 'week' },
    M: { display: 'month' },
    y: { display: 'year' },
};
var rangeOptions = [
    { from: 'now/d', to: 'now/d', display: 'Today', section: 2 },
    { from: 'now/d', to: 'now', display: 'Today so far', section: 2 },
    { from: 'now/w', to: 'now/w', display: 'This week', section: 2 },
    { from: 'now/w', to: 'now', display: 'This week so far', section: 2 },
    { from: 'now/M', to: 'now/M', display: 'This month', section: 2 },
    { from: 'now/M', to: 'now', display: 'This month so far', section: 2 },
    { from: 'now/y', to: 'now/y', display: 'This year', section: 2 },
    { from: 'now/y', to: 'now', display: 'This year so far', section: 2 },
    { from: 'now-1d/d', to: 'now-1d/d', display: 'Yesterday', section: 1 },
    {
        from: 'now-2d/d',
        to: 'now-2d/d',
        display: 'Day before yesterday',
        section: 1,
    },
    {
        from: 'now-7d/d',
        to: 'now-7d/d',
        display: 'This day last week',
        section: 1,
    },
    { from: 'now-1w/w', to: 'now-1w/w', display: 'Previous week', section: 1 },
    { from: 'now-1M/M', to: 'now-1M/M', display: 'Previous month', section: 1 },
    { from: 'now-1y/y', to: 'now-1y/y', display: 'Previous year', section: 1 },
    { from: 'now-5m', to: 'now', display: 'Last 5 minutes', section: 3 },
    { from: 'now-15m', to: 'now', display: 'Last 15 minutes', section: 3 },
    { from: 'now-30m', to: 'now', display: 'Last 30 minutes', section: 3 },
    { from: 'now-1h', to: 'now', display: 'Last 1 hour', section: 3 },
    { from: 'now-3h', to: 'now', display: 'Last 3 hours', section: 3 },
    { from: 'now-6h', to: 'now', display: 'Last 6 hours', section: 3 },
    { from: 'now-12h', to: 'now', display: 'Last 12 hours', section: 3 },
    { from: 'now-24h', to: 'now', display: 'Last 24 hours', section: 3 },
    { from: 'now-2d', to: 'now', display: 'Last 2 days', section: 0 },
    { from: 'now-7d', to: 'now', display: 'Last 7 days', section: 0 },
    { from: 'now-30d', to: 'now', display: 'Last 30 days', section: 0 },
    { from: 'now-90d', to: 'now', display: 'Last 90 days', section: 0 },
    { from: 'now-6M', to: 'now', display: 'Last 6 months', section: 0 },
    { from: 'now-1y', to: 'now', display: 'Last 1 year', section: 0 },
    { from: 'now-2y', to: 'now', display: 'Last 2 years', section: 0 },
    { from: 'now-5y', to: 'now', display: 'Last 5 years', section: 0 },
];
var absoluteFormat = 'YYYY-MM-DD HH:mm:ss';
var rangeIndex = {};
lodash_each__WEBPACK_IMPORTED_MODULE_0___default()(rangeOptions, function (frame) {
    rangeIndex[frame.from + ' to ' + frame.to] = frame;
});
function getRelativeTimesList(timepickerSettings, currentDisplay) {
    var groups = lodash_groupBy__WEBPACK_IMPORTED_MODULE_1___default()(rangeOptions, function (option) {
        option.active = option.display === currentDisplay;
        return option.section;
    });
    // _.each(timepickerSettings.time_options, (duration: string) => {
    //   let info = describeTextRange(duration);
    //   if (info.section) {
    //     groups[info.section].push(info);
    //   }
    // });
    return groups;
}
function formatDate(date) {
    return date.format(absoluteFormat);
}
// handles expressions like
// 5m
// 5m to now/d
// now/d to now
// now/d
// if no to <expr> then to now is assumed
function describeTextRange(expr) {
    var isLast = expr.indexOf('+') !== 0;
    if (expr.indexOf('now') === -1) {
        expr = (isLast ? 'now-' : 'now') + expr;
    }
    var opt = rangeIndex[expr + ' to now'];
    if (opt) {
        return opt;
    }
    if (isLast) {
        opt = { from: expr, to: 'now' };
    }
    else {
        opt = { from: 'now', to: expr };
    }
    var parts = /^now([-+])(\d+)(\w)/.exec(expr);
    if (parts) {
        var unit = parts[3];
        var amount = parseInt(parts[2], 10);
        var span = spans[unit];
        if (span) {
            opt.display = isLast ? 'Last ' : 'Next ';
            opt.display += amount + ' ' + span.display;
            opt.section = span.section;
            if (amount > 1) {
                opt.display += 's';
            }
        }
    }
    else {
        opt.display = opt.from + ' to ' + opt.to;
        opt.invalid = true;
    }
    return opt;
}
function describeTimeRange(range) {
    var option = rangeIndex[range.from.toString() + ' to ' + range.to.toString()];
    if (option) {
        return option.display;
    }
    if (Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_3__["isDateTime"])(range.from) && Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_3__["isDateTime"])(range.to)) {
        return formatDate(range.from) + ' to ' + formatDate(range.to);
    }
    if (Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_3__["isDateTime"])(range.from)) {
        var toMoment = _datemath__WEBPACK_IMPORTED_MODULE_2__["parse"](range.to, true);
        return toMoment ? formatDate(range.from) + ' to ' + toMoment.fromNow() : '';
    }
    if (Object(_moment_wrapper__WEBPACK_IMPORTED_MODULE_3__["isDateTime"])(range.to)) {
        var from = _datemath__WEBPACK_IMPORTED_MODULE_2__["parse"](range.from, false);
        return from ? from.fromNow() + ' to ' + formatDate(range.to) : '';
    }
    if (range.to.toString() === 'now') {
        var res = describeTextRange(range.from);
        return res.display;
    }
    return range.from.toString() + ' to ' + range.to.toString();
}
var isValidTimeSpan = function (value) {
    if (value.indexOf('$') === 0 || value.indexOf('+$') === 0) {
        return true;
    }
    var info = describeTextRange(value);
    return info.invalid !== true;
};


/***/ }),

/***/ "./packages/grafana-data/src/datetime/timezones.ts":
/*!*********************************************************!*\
  !*** ./packages/grafana-data/src/datetime/timezones.ts ***!
  \*********************************************************/
/*! exports provided: getTimeZoneGroups */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTimeZoneGroups", function() { return getTimeZoneGroups; });
// List taken from https://stackoverflow.com/questions/38399465/how-to-get-list-of-all-timezones-in-javascript
var getTimeZoneGroups = function () {
    var europeZones = [
        'Europe/Amsterdam',
        'Europe/Andorra',
        'Europe/Astrakhan',
        'Europe/Athens',
        'Europe/Belgrade',
        'Europe/Berlin',
        'Europe/Brussels',
        'Europe/Bucharest',
        'Europe/Budapest',
        'Europe/Chisinau',
        'Europe/Copenhagen',
        'Europe/Dublin',
        'Europe/Gibraltar',
        'Europe/Helsinki',
        'Europe/Istanbul',
        'Europe/Kaliningrad',
        'Europe/Kiev',
        'Europe/Kirov',
        'Europe/Lisbon',
        'Europe/London',
        'Europe/Luxembourg',
        'Europe/Madrid',
        'Europe/Malta',
        'Europe/Minsk',
        'Europe/Monaco',
        'Europe/Moscow',
        'Europe/Oslo',
        'Europe/Paris',
        'Europe/Prague',
        'Europe/Riga',
        'Europe/Rome',
        'Europe/Samara',
        'Europe/Saratov',
        'Europe/Simferopol',
        'Europe/Sofia',
        'Europe/Stockholm',
        'Europe/Tallinn',
        'Europe/Tirane',
        'Europe/Ulyanovsk',
        'Europe/Uzhgorod',
        'Europe/Vienna',
        'Europe/Vilnius',
        'Europe/Volgograd',
        'Europe/Warsaw',
        'Europe/Zaporozhye',
        'Europe/Zurich',
    ];
    var africaZones = [
        'Africa/Abidjan',
        'Africa/Accra',
        'Africa/Algiers',
        'Africa/Bissau',
        'Africa/Cairo',
        'Africa/Casablanca',
        'Africa/Ceuta',
        'Africa/El_Aaiun',
        'Africa/Johannesburg',
        'Africa/Juba',
        'Africa/Khartoum',
        'Africa/Lagos',
        'Africa/Maputo',
        'Africa/Monrovia',
        'Africa/Nairobi',
        'Africa/Ndjamena',
        'Africa/Sao_Tome',
        'Africa/Tripoli',
        'Africa/Tunis',
        'Africa/Windhoek',
    ];
    var asiaZones = [
        'Asia/Almaty',
        'Asia/Amman',
        'Asia/Anadyr',
        'Asia/Aqtau',
        'Asia/Aqtobe',
        'Asia/Ashgabat',
        'Asia/Atyrau',
        'Asia/Baghdad',
        'Asia/Baku',
        'Asia/Bangkok',
        'Asia/Barnaul',
        'Asia/Beirut',
        'Asia/Bishkek',
        'Asia/Brunei',
        'Asia/Chita',
        'Asia/Choibalsan',
        'Asia/Colombo',
        'Asia/Damascus',
        'Asia/Dhaka',
        'Asia/Dili',
        'Asia/Dubai',
        'Asia/Dushanbe',
        'Asia/Famagusta',
        'Asia/Gaza',
        'Asia/Hebron',
        'Asia/Ho_Chi_Minh',
        'Asia/Hong_Kong',
        'Asia/Hovd',
        'Asia/Irkutsk',
        'Asia/Jakarta',
        'Asia/Jayapura',
        'Asia/Jerusalem',
        'Asia/Kabul',
        'Asia/Kamchatka',
        'Asia/Karachi',
        'Asia/Kathmandu',
        'Asia/Khandyga',
        'Asia/Kolkata',
        'Asia/Krasnoyarsk',
        'Asia/Kuala_Lumpur',
        'Asia/Kuching',
        'Asia/Macau',
        'Asia/Magadan',
        'Asia/Makassar',
        'Asia/Manila',
        'Asia/Nicosia',
        'Asia/Novokuznetsk',
        'Asia/Novosibirsk',
        'Asia/Omsk',
        'Asia/Oral',
        'Asia/Pontianak',
        'Asia/Pyongyang',
        'Asia/Qatar',
        'Asia/Qostanay',
        'Asia/Qyzylorda',
        'Asia/Riyadh',
        'Asia/Sakhalin',
        'Asia/Samarkand',
        'Asia/Seoul',
        'Asia/Shanghai',
        'Asia/Singapore',
        'Asia/Srednekolymsk',
        'Asia/Taipei',
        'Asia/Tashkent',
        'Asia/Tbilisi',
        'Asia/Tehran',
        'Asia/Thimphu',
        'Asia/Tokyo',
        'Asia/Tomsk',
        'Asia/Ulaanbaatar',
        'Asia/Urumqi',
        'Asia/Ust-Nera',
        'Asia/Vladivostok',
        'Asia/Yakutsk',
        'Asia/Yangon',
        'Asia/Yekaterinburg',
        'Asia/Yerevan',
    ];
    var antarcticaZones = [
        'Antarctica/Casey',
        'Antarctica/Davis',
        'Antarctica/DumontDUrville',
        'Antarctica/Macquarie',
        'Antarctica/Mawson',
        'Antarctica/Palmer',
        'Antarctica/Rothera',
        'Antarctica/Syowa',
        'Antarctica/Troll',
        'Antarctica/Vostok',
    ];
    var americaZones = [
        'America/Adak',
        'America/Anchorage',
        'America/Araguaina',
        'America/Argentina/Buenos_Aires',
        'America/Argentina/Catamarca',
        'America/Argentina/Cordoba',
        'America/Argentina/Jujuy',
        'America/Argentina/La_Rioja',
        'America/Argentina/Mendoza',
        'America/Argentina/Rio_Gallegos',
        'America/Argentina/Salta',
        'America/Argentina/San_Juan',
        'America/Argentina/San_Luis',
        'America/Argentina/Tucuman',
        'America/Argentina/Ushuaia',
        'America/Asuncion',
        'America/Atikokan',
        'America/Bahia',
        'America/Bahia_Banderas',
        'America/Barbados',
        'America/Belem',
        'America/Belize',
        'America/Blanc-Sablon',
        'America/Boa_Vista',
        'America/Bogota',
        'America/Boise',
        'America/Cambridge_Bay',
        'America/Campo_Grande',
        'America/Cancun',
        'America/Caracas',
        'America/Cayenne',
        'America/Chicago',
        'America/Chihuahua',
        'America/Costa_Rica',
        'America/Creston',
        'America/Cuiaba',
        'America/Curacao',
        'America/Danmarkshavn',
        'America/Dawson',
        'America/Dawson_Creek',
        'America/Denver',
        'America/Detroit',
        'America/Edmonton',
        'America/Eirunepe',
        'America/El_Salvador',
        'America/Fort_Nelson',
        'America/Fortaleza',
        'America/Glace_Bay',
        'America/Godthab',
        'America/Goose_Bay',
        'America/Grand_Turk',
        'America/Guatemala',
        'America/Guayaquil',
        'America/Guyana',
        'America/Halifax',
        'America/Havana',
        'America/Hermosillo',
        'America/Indiana/Indianapolis',
        'America/Indiana/Knox',
        'America/Indiana/Marengo',
        'America/Indiana/Petersburg',
        'America/Indiana/Tell_City',
        'America/Indiana/Vevay',
        'America/Indiana/Vincennes',
        'America/Indiana/Winamac',
        'America/Inuvik',
        'America/Iqaluit',
        'America/Jamaica',
        'America/Juneau',
        'America/Kentucky/Louisville',
        'America/Kentucky/Monticello',
        'America/La_Paz',
        'America/Lima',
        'America/Los_Angeles',
        'America/Maceio',
        'America/Managua',
        'America/Manaus',
        'America/Martinique',
        'America/Matamoros',
        'America/Mazatlan',
        'America/Menominee',
        'America/Merida',
        'America/Metlakatla',
        'America/Mexico_City',
        'America/Miquelon',
        'America/Moncton',
        'America/Monterrey',
        'America/Montevideo',
        'America/Nassau',
        'America/New_York',
        'America/Nipigon',
        'America/Nome',
        'America/Noronha',
        'America/North_Dakota/Beulah',
        'America/North_Dakota/Center',
        'America/North_Dakota/New_Salem',
        'America/Ojinaga',
        'America/Panama',
        'America/Pangnirtung',
        'America/Paramaribo',
        'America/Phoenix',
        'America/Port-au-Prince',
        'America/Port_of_Spain',
        'America/Porto_Velho',
        'America/Puerto_Rico',
        'America/Punta_Arenas',
        'America/Rainy_River',
        'America/Rankin_Inlet',
        'America/Recife',
        'America/Regina',
        'America/Resolute',
        'America/Rio_Branco',
        'America/Santarem',
        'America/Santiago',
        'America/Santo_Domingo',
        'America/Sao_Paulo',
        'America/Scoresbysund',
        'America/Sitka',
        'America/St_Johns',
        'America/Swift_Current',
        'America/Tegucigalpa',
        'America/Thule',
        'America/Thunder_Bay',
        'America/Tijuana',
        'America/Toronto',
        'America/Vancouver',
        'America/Whitehorse',
        'America/Winnipeg',
        'America/Yakutat',
        'America/Yellowknife',
    ];
    var pacificZones = [
        'Pacific/Apia',
        'Pacific/Auckland',
        'Pacific/Bougainville',
        'Pacific/Chatham',
        'Pacific/Chuuk',
        'Pacific/Easter',
        'Pacific/Efate',
        'Pacific/Enderbury',
        'Pacific/Fakaofo',
        'Pacific/Fiji',
        'Pacific/Funafuti',
        'Pacific/Galapagos',
        'Pacific/Gambier',
        'Pacific/Guadalcanal',
        'Pacific/Guam',
        'Pacific/Honolulu',
        'Pacific/Kiritimati',
        'Pacific/Kosrae',
        'Pacific/Kwajalein',
        'Pacific/Majuro',
        'Pacific/Marquesas',
        'Pacific/Nauru',
        'Pacific/Niue',
        'Pacific/Norfolk',
        'Pacific/Noumea',
        'Pacific/Pago_Pago',
        'Pacific/Palau',
        'Pacific/Pitcairn',
        'Pacific/Pohnpei',
        'Pacific/Port_Moresby',
        'Pacific/Rarotonga',
        'Pacific/Tahiti',
        'Pacific/Tarawa',
        'Pacific/Tongatapu',
        'Pacific/Wake',
        'Pacific/Wallis',
    ];
    var australiaZones = [
        'Australia/Adelaide',
        'Australia/Brisbane',
        'Australia/Broken_Hill',
        'Australia/Currie',
        'Australia/Darwin',
        'Australia/Eucla',
        'Australia/Hobart',
        'Australia/Lindeman',
        'Australia/Lord_Howe',
        'Australia/Melbourne',
        'Australia/Perth',
        'Australia/Sydney',
    ];
    var atlanticZones = [
        'Atlantic/Azores',
        'Atlantic/Bermuda',
        'Atlantic/Canary',
        'Atlantic/Cape_Verde',
        'Atlantic/Faroe',
        'Atlantic/Madeira',
        'Atlantic/Reykjavik',
        'Atlantic/South_Georgia',
        'Atlantic/Stanley',
    ];
    var indianZones = [
        'Indian/Chagos',
        'Indian/Christmas',
        'Indian/Cocos',
        'Indian/Kerguelen',
        'Indian/Mahe',
        'Indian/Maldives',
        'Indian/Mauritius',
        'Indian/Reunion',
    ];
    return [
        { label: 'Africa', options: africaZones },
        { label: 'America', options: americaZones },
        { label: 'Antarctica', options: antarcticaZones },
        { label: 'Asia', options: asiaZones },
        { label: 'Atlantic', options: atlanticZones },
        { label: 'Australia', options: australiaZones },
        { label: 'Europe', options: europeZones },
        { label: 'Indian', options: indianZones },
        { label: 'Pacific', options: pacificZones },
    ];
};


/***/ }),

/***/ "./packages/grafana-data/src/index.ts":
/*!********************************************!*\
  !*** ./packages/grafana-data/src/index.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./packages/grafana-data/src/utils/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Registry", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["Registry"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "deprecationWarning", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["deprecationWarning"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CSVHeaderStyle", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["CSVHeaderStyle"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readCSV", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["readCSV"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CSVReader", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["CSVReader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toCSV", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["toCSV"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLogLevel", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["getLogLevel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLogLevelFromKey", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["getLogLevelFromKey"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addLogLevelToSeries", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["addLogLevelToSeries"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "calculateLogsLabelStats", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["calculateLogsLabelStats"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogsParsers", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["LogsParsers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "calculateFieldStats", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["calculateFieldStats"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getParser", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["getParser"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseLabels", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["parseLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findCommonLabels", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["findCommonLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findUniqueLabels", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["findUniqueLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "formatLabels", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["formatLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "objRemoveUndefined", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["objRemoveUndefined"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getActiveThreshold", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["getActiveThreshold"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sortThresholds", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["sortThresholds"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMappedValue", function() { return _utils__WEBPACK_IMPORTED_MODULE_0__["getMappedValue"]; });

/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./types */ "./packages/grafana-data/src/types/index.ts");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _types__WEBPACK_IMPORTED_MODULE_1__) if(["Registry","deprecationWarning","CSVHeaderStyle","readCSV","CSVReader","toCSV","getLogLevel","getLogLevelFromKey","addLogLevelToSeries","calculateLogsLabelStats","LogsParsers","calculateFieldStats","getParser","parseLabels","findCommonLabels","findUniqueLabels","formatLabels","objRemoveUndefined","getActiveThreshold","sortThresholds","getMappedValue","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _types__WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vector */ "./packages/grafana-data/src/vector/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AppendedVectors", function() { return _vector__WEBPACK_IMPORTED_MODULE_2__["AppendedVectors"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayVector", function() { return _vector__WEBPACK_IMPORTED_MODULE_2__["ArrayVector"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CircularVector", function() { return _vector__WEBPACK_IMPORTED_MODULE_2__["CircularVector"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConstantVector", function() { return _vector__WEBPACK_IMPORTED_MODULE_2__["ConstantVector"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ScaledVector", function() { return _vector__WEBPACK_IMPORTED_MODULE_2__["ScaledVector"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SortedVector", function() { return _vector__WEBPACK_IMPORTED_MODULE_2__["SortedVector"]; });

/* harmony import */ var _dataframe__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dataframe */ "./packages/grafana-data/src/dataframe/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataFrameView", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["DataFrameView"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldCache", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["FieldCache"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CircularDataFrame", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["CircularDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MISSING_VALUE", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["MISSING_VALUE"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MutableDataFrame", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["MutableDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypeFromValue", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["guessFieldTypeFromValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypeForField", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["guessFieldTypeForField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "guessFieldTypes", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["guessFieldTypes"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isTableData", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["isTableData"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isDataFrame", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["isDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toDataFrame", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["toDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toLegacyResponseData", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["toLegacyResponseData"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sortDataFrame", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["sortDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "reverseDataFrame", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["reverseDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getTimeField", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["getTimeField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDataFrameRow", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["getDataFrameRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toDataFrameDTO", function() { return _dataframe__WEBPACK_IMPORTED_MODULE_3__["toDataFrameDTO"]; });

/* harmony import */ var _transformations__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./transformations */ "./packages/grafana-data/src/transformations/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatcherID", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["MatcherID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldMatcherID", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["FieldMatcherID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FrameMatcherID", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["FrameMatcherID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataTransformerID", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["DataTransformerID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "fieldMatchers", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["fieldMatchers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "frameMatchers", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["frameMatchers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFieldMatcher", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["getFieldMatcher"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFrameMatchers", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["getFrameMatchers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "transformDataFrame", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["transformDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "transformersRegistry", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["transformersRegistry"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReduceTransformerOptions", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["ReduceTransformerOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FilterFieldsByNameTransformerOptions", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["FilterFieldsByNameTransformerOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReducerID", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["ReducerID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "reduceField", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["reduceField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "fieldReducers", function() { return _transformations__WEBPACK_IMPORTED_MODULE_4__["fieldReducers"]; });

/* harmony import */ var _datetime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./datetime */ "./packages/grafana-data/src/datetime/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ISO_8601", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["ISO_8601"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setLocale", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["setLocale"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLocaleData", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["getLocaleData"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isDateTime", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["isDateTime"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toUtc", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["toUtc"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toDuration", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["toDuration"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dateTime", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["dateTime"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dateTimeAsMoment", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["dateTimeAsMoment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dateTimeForTimeZone", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["dateTimeForTimeZone"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getTimeZoneGroups", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["getTimeZoneGroups"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dateMath", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["dateMath"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "rangeUtil", function() { return _datetime__WEBPACK_IMPORTED_MODULE_5__["rangeUtil"]; });

/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./text */ "./packages/grafana-data/src/text/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stringToJsRegex", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["stringToJsRegex"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stringToMs", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["stringToMs"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toNumberString", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["toNumberString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toIntegerOrUndefined", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["toIntegerOrUndefined"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toFloatOrUndefined", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["toFloatOrUndefined"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setMarkdownOptions", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["setMarkdownOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "renderMarkdown", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["renderMarkdown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findHighlightChunksInText", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["findHighlightChunksInText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findMatchesInText", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["findMatchesInText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseFlags", function() { return _text__WEBPACK_IMPORTED_MODULE_6__["parseFlags"]; });










/***/ }),

/***/ "./packages/grafana-data/src/text/index.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-data/src/text/index.ts ***!
  \*************************************************/
/*! exports provided: stringToJsRegex, stringToMs, toNumberString, toIntegerOrUndefined, toFloatOrUndefined, setMarkdownOptions, renderMarkdown, findHighlightChunksInText, findMatchesInText, parseFlags */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./string */ "./packages/grafana-data/src/text/string.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stringToJsRegex", function() { return _string__WEBPACK_IMPORTED_MODULE_0__["stringToJsRegex"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stringToMs", function() { return _string__WEBPACK_IMPORTED_MODULE_0__["stringToMs"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toNumberString", function() { return _string__WEBPACK_IMPORTED_MODULE_0__["toNumberString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toIntegerOrUndefined", function() { return _string__WEBPACK_IMPORTED_MODULE_0__["toIntegerOrUndefined"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toFloatOrUndefined", function() { return _string__WEBPACK_IMPORTED_MODULE_0__["toFloatOrUndefined"]; });

/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./markdown */ "./packages/grafana-data/src/text/markdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setMarkdownOptions", function() { return _markdown__WEBPACK_IMPORTED_MODULE_1__["setMarkdownOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "renderMarkdown", function() { return _markdown__WEBPACK_IMPORTED_MODULE_1__["renderMarkdown"]; });

/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./text */ "./packages/grafana-data/src/text/text.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findHighlightChunksInText", function() { return _text__WEBPACK_IMPORTED_MODULE_2__["findHighlightChunksInText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findMatchesInText", function() { return _text__WEBPACK_IMPORTED_MODULE_2__["findMatchesInText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseFlags", function() { return _text__WEBPACK_IMPORTED_MODULE_2__["parseFlags"]; });






/***/ }),

/***/ "./packages/grafana-data/src/text/markdown.ts":
/*!****************************************************!*\
  !*** ./packages/grafana-data/src/text/markdown.ts ***!
  \****************************************************/
/*! exports provided: setMarkdownOptions, renderMarkdown */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setMarkdownOptions", function() { return setMarkdownOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "renderMarkdown", function() { return renderMarkdown; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var marked__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! marked */ "./node_modules/marked/lib/marked.js");
/* harmony import */ var marked__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(marked__WEBPACK_IMPORTED_MODULE_1__);


var defaultMarkedOptions = {
    renderer: new marked__WEBPACK_IMPORTED_MODULE_1___default.a.Renderer(),
    pedantic: false,
    gfm: true,
    tables: true,
    sanitize: true,
    smartLists: true,
    smartypants: false,
    xhtml: false,
};
function setMarkdownOptions(optionsOverride) {
    marked__WEBPACK_IMPORTED_MODULE_1___default.a.setOptions(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, defaultMarkedOptions, optionsOverride));
}
function renderMarkdown(str) {
    return marked__WEBPACK_IMPORTED_MODULE_1___default()(str || '');
}


/***/ }),

/***/ "./packages/grafana-data/src/text/string.ts":
/*!**************************************************!*\
  !*** ./packages/grafana-data/src/text/string.ts ***!
  \**************************************************/
/*! exports provided: stringToJsRegex, stringToMs, toNumberString, toIntegerOrUndefined, toFloatOrUndefined */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stringToJsRegex", function() { return stringToJsRegex; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stringToMs", function() { return stringToMs; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toNumberString", function() { return toNumberString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toIntegerOrUndefined", function() { return toIntegerOrUndefined; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toFloatOrUndefined", function() { return toFloatOrUndefined; });
function stringToJsRegex(str) {
    if (str[0] !== '/') {
        return new RegExp('^' + str + '$');
    }
    var match = str.match(new RegExp('^/(.*?)/(g?i?m?y?)$'));
    if (!match) {
        throw new Error("'" + str + "' is not a valid regular expression.");
    }
    return new RegExp(match[1], match[2]);
}
function stringToMs(str) {
    if (!str) {
        return 0;
    }
    var nr = parseInt(str, 10);
    var unit = str.substr(String(nr).length);
    var s = 1000;
    var m = s * 60;
    var h = m * 60;
    var d = h * 24;
    switch (unit) {
        case 's':
            return nr * s;
        case 'm':
            return nr * m;
        case 'h':
            return nr * h;
        case 'd':
            return nr * d;
        default:
            if (!unit) {
                return isNaN(nr) ? 0 : nr;
            }
            throw new Error('Not supported unit: ' + unit);
    }
}
function toNumberString(value) {
    if (value !== null && value !== undefined && Number.isFinite(value)) {
        return value.toString();
    }
    return '';
}
function toIntegerOrUndefined(value) {
    if (!value) {
        return undefined;
    }
    var v = parseInt(value, 10);
    return isNaN(v) ? undefined : v;
}
function toFloatOrUndefined(value) {
    if (!value) {
        return undefined;
    }
    var v = parseFloat(value);
    return isNaN(v) ? undefined : v;
}


/***/ }),

/***/ "./packages/grafana-data/src/text/text.ts":
/*!************************************************!*\
  !*** ./packages/grafana-data/src/text/text.ts ***!
  \************************************************/
/*! exports provided: findHighlightChunksInText, findMatchesInText, parseFlags */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findHighlightChunksInText", function() { return findHighlightChunksInText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findMatchesInText", function() { return findMatchesInText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parseFlags", function() { return parseFlags; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

/**
 * Adapt findMatchesInText for react-highlight-words findChunks handler.
 * See https://github.com/bvaughn/react-highlight-words#props
 */
function findHighlightChunksInText(_a) {
    var searchWords = _a.searchWords, textToHighlight = _a.textToHighlight;
    return searchWords.reduce(function (acc, term) { return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](acc, findMatchesInText(textToHighlight, term)); }, []);
}
var cleanNeedle = function (needle) {
    return needle.replace(/[[{(][\w,.-?:*+]+$/, '');
};
/**
 * Returns a list of substring regexp matches.
 */
function findMatchesInText(haystack, needle) {
    // Empty search can send re.exec() into infinite loop, exit early
    if (!haystack || !needle) {
        return [];
    }
    var matches = [];
    var _a = parseFlags(cleanNeedle(needle)), cleaned = _a.cleaned, flags = _a.flags;
    var regexp;
    try {
        regexp = new RegExp("(?:" + cleaned + ")", flags);
    }
    catch (error) {
        return matches;
    }
    haystack.replace(regexp, function (substring) {
        var rest = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            rest[_i - 1] = arguments[_i];
        }
        if (substring) {
            var offset = rest[rest.length - 2];
            matches.push({
                text: substring,
                start: offset,
                length: substring.length,
                end: offset + substring.length,
            });
        }
        return '';
    });
    return matches;
}
var CLEAR_FLAG = '-';
var FLAGS_REGEXP = /\(\?([ims-]+)\)/g;
/**
 * Converts any mode modifers in the text to the Javascript equivalent flag
 */
function parseFlags(text) {
    var flags = new Set(['g']);
    var cleaned = text.replace(FLAGS_REGEXP, function (str, group) {
        var clearAll = group.startsWith(CLEAR_FLAG);
        for (var i = 0; i < group.length; ++i) {
            var flag = group.charAt(i);
            if (clearAll || group.charAt(i - 1) === CLEAR_FLAG) {
                flags.delete(flag);
            }
            else if (flag !== CLEAR_FLAG) {
                flags.add(flag);
            }
        }
        return ''; // Remove flag from text
    });
    return {
        cleaned: cleaned,
        flags: Array.from(flags).join(''),
    };
}


/***/ }),

/***/ "./packages/grafana-data/src/transformations/fieldReducer.ts":
/*!*******************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/fieldReducer.ts ***!
  \*******************************************************************/
/*! exports provided: ReducerID, reduceField, fieldReducers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReducerID", function() { return ReducerID; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "reduceField", function() { return reduceField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fieldReducers", function() { return fieldReducers; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isNumber */ "./node_modules/lodash/isNumber.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isNumber__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _types_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../types/index */ "./packages/grafana-data/src/types/index.ts");
/* harmony import */ var _utils_Registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/Registry */ "./packages/grafana-data/src/utils/Registry.ts");

// Libraries



var ReducerID;
(function (ReducerID) {
    ReducerID["sum"] = "sum";
    ReducerID["max"] = "max";
    ReducerID["min"] = "min";
    ReducerID["logmin"] = "logmin";
    ReducerID["mean"] = "mean";
    ReducerID["last"] = "last";
    ReducerID["first"] = "first";
    ReducerID["count"] = "count";
    ReducerID["range"] = "range";
    ReducerID["diff"] = "diff";
    ReducerID["delta"] = "delta";
    ReducerID["step"] = "step";
    ReducerID["firstNotNull"] = "firstNotNull";
    ReducerID["lastNotNull"] = "lastNotNull";
    ReducerID["changeCount"] = "changeCount";
    ReducerID["distinctCount"] = "distinctCount";
    ReducerID["allIsZero"] = "allIsZero";
    ReducerID["allIsNull"] = "allIsNull";
})(ReducerID || (ReducerID = {}));
/**
 * @returns an object with a key for each selected stat
 */
function reduceField(options) {
    var e_1, _a, e_2, _b, e_3, _c;
    var field = options.field, reducers = options.reducers;
    if (!field || !reducers || reducers.length < 1) {
        return {};
    }
    if (field.calcs) {
        // Find the values we need to calculate
        var missing = [];
        try {
            for (var reducers_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](reducers), reducers_1_1 = reducers_1.next(); !reducers_1_1.done; reducers_1_1 = reducers_1.next()) {
                var s = reducers_1_1.value;
                if (!field.calcs.hasOwnProperty(s)) {
                    missing.push(s);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (reducers_1_1 && !reducers_1_1.done && (_a = reducers_1.return)) _a.call(reducers_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (missing.length < 1) {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field.calcs);
        }
    }
    var queue = fieldReducers.list(reducers);
    // Return early for empty series
    // This lets the concrete implementations assume at least one row
    var data = field.values;
    if (data.length < 1) {
        var calcs = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field.calcs);
        try {
            for (var queue_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](queue), queue_1_1 = queue_1.next(); !queue_1_1.done; queue_1_1 = queue_1.next()) {
                var reducer = queue_1_1.value;
                calcs[reducer.id] = reducer.emptyInputResult !== null ? reducer.emptyInputResult : null;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (queue_1_1 && !queue_1_1.done && (_b = queue_1.return)) _b.call(queue_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return (field.calcs = calcs);
    }
    var nullValueMode = field.config.nullValueMode;
    var ignoreNulls = nullValueMode === _types_index__WEBPACK_IMPORTED_MODULE_2__["NullValueMode"].Ignore;
    var nullAsZero = nullValueMode === _types_index__WEBPACK_IMPORTED_MODULE_2__["NullValueMode"].AsZero;
    // Avoid calculating all the standard stats if possible
    if (queue.length === 1 && queue[0].reduce) {
        var values_1 = queue[0].reduce(field, ignoreNulls, nullAsZero);
        field.calcs = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field.calcs, values_1);
        return values_1;
    }
    // For now everything can use the standard stats
    var values = doStandardCalcs(field, ignoreNulls, nullAsZero);
    try {
        for (var queue_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](queue), queue_2_1 = queue_2.next(); !queue_2_1.done; queue_2_1 = queue_2.next()) {
            var reducer = queue_2_1.value;
            if (!values.hasOwnProperty(reducer.id) && reducer.reduce) {
                values = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, values, reducer.reduce(field, ignoreNulls, nullAsZero));
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (queue_2_1 && !queue_2_1.done && (_c = queue_2.return)) _c.call(queue_2);
        }
        finally { if (e_3) throw e_3.error; }
    }
    field.calcs = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, field.calcs, values);
    return values;
}
// ------------------------------------------------------------------------------
//
//  No Exported symbols below here.
//
// ------------------------------------------------------------------------------
var fieldReducers = new _utils_Registry__WEBPACK_IMPORTED_MODULE_3__["Registry"](function () { return [
    {
        id: ReducerID.lastNotNull,
        name: 'Last (not null)',
        description: 'Last non-null value',
        standard: true,
        aliasIds: ['current'],
        reduce: calculateLastNotNull,
    },
    {
        id: ReducerID.last,
        name: 'Last',
        description: 'Last Value',
        standard: true,
        reduce: calculateLast,
    },
    { id: ReducerID.first, name: 'First', description: 'First Value', standard: true, reduce: calculateFirst },
    {
        id: ReducerID.firstNotNull,
        name: 'First (not null)',
        description: 'First non-null value',
        standard: true,
        reduce: calculateFirstNotNull,
    },
    { id: ReducerID.min, name: 'Min', description: 'Minimum Value', standard: true },
    { id: ReducerID.max, name: 'Max', description: 'Maximum Value', standard: true },
    { id: ReducerID.mean, name: 'Mean', description: 'Average Value', standard: true, aliasIds: ['avg'] },
    {
        id: ReducerID.sum,
        name: 'Total',
        description: 'The sum of all values',
        emptyInputResult: 0,
        standard: true,
        aliasIds: ['total'],
    },
    {
        id: ReducerID.count,
        name: 'Count',
        description: 'Number of values in response',
        emptyInputResult: 0,
        standard: true,
    },
    {
        id: ReducerID.range,
        name: 'Range',
        description: 'Difference between minimum and maximum values',
        standard: true,
    },
    {
        id: ReducerID.delta,
        name: 'Delta',
        description: 'Cumulative change in value',
        standard: true,
    },
    {
        id: ReducerID.step,
        name: 'Step',
        description: 'Minimum interval between values',
        standard: true,
    },
    {
        id: ReducerID.diff,
        name: 'Difference',
        description: 'Difference between first and last values',
        standard: true,
    },
    {
        id: ReducerID.logmin,
        name: 'Min (above zero)',
        description: 'Used for log min scale',
        standard: true,
    },
    {
        id: ReducerID.allIsZero,
        name: 'All Zeros',
        description: 'All values are zero',
        emptyInputResult: false,
        standard: true,
    },
    {
        id: ReducerID.allIsNull,
        name: 'All Nulls',
        description: 'All values are null',
        emptyInputResult: true,
        standard: true,
    },
    {
        id: ReducerID.changeCount,
        name: 'Change Count',
        description: 'Number of times the value changes',
        standard: false,
        reduce: calculateChangeCount,
    },
    {
        id: ReducerID.distinctCount,
        name: 'Distinct Count',
        description: 'Number of distinct values',
        standard: false,
        reduce: calculateDistinctCount,
    },
]; });
function doStandardCalcs(field, ignoreNulls, nullAsZero) {
    var calcs = {
        sum: 0,
        max: -Number.MAX_VALUE,
        min: Number.MAX_VALUE,
        logmin: Number.MAX_VALUE,
        mean: null,
        last: null,
        first: null,
        lastNotNull: null,
        firstNotNull: null,
        count: 0,
        nonNullCount: 0,
        allIsNull: true,
        allIsZero: true,
        range: null,
        diff: null,
        delta: 0,
        step: Number.MAX_VALUE,
        // Just used for calcutations -- not exposed as a stat
        previousDeltaUp: true,
    };
    var data = field.values;
    calcs.count = data.length;
    for (var i = 0; i < data.length; i++) {
        var currentValue = data.get(i);
        if (i === 0) {
            calcs.first = currentValue;
        }
        calcs.last = currentValue;
        if (currentValue === null) {
            if (ignoreNulls) {
                continue;
            }
            if (nullAsZero) {
                currentValue = 0;
            }
        }
        if (currentValue !== null && currentValue !== undefined) {
            var isFirst = calcs.firstNotNull === null;
            if (isFirst) {
                calcs.firstNotNull = currentValue;
            }
            if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_1___default()(currentValue)) {
                calcs.sum += currentValue;
                calcs.allIsNull = false;
                calcs.nonNullCount++;
                if (!isFirst) {
                    var step = currentValue - calcs.lastNotNull;
                    if (calcs.step > step) {
                        calcs.step = step; // the minimum interval
                    }
                    if (calcs.lastNotNull > currentValue) {
                        // counter reset
                        calcs.previousDeltaUp = false;
                        if (i === data.length - 1) {
                            // reset on last
                            calcs.delta += currentValue;
                        }
                    }
                    else {
                        if (calcs.previousDeltaUp) {
                            calcs.delta += step; // normal increment
                        }
                        else {
                            calcs.delta += currentValue; // account for counter reset
                        }
                        calcs.previousDeltaUp = true;
                    }
                }
                if (currentValue > calcs.max) {
                    calcs.max = currentValue;
                }
                if (currentValue < calcs.min) {
                    calcs.min = currentValue;
                }
                if (currentValue < calcs.logmin && currentValue > 0) {
                    calcs.logmin = currentValue;
                }
            }
            if (currentValue !== 0) {
                calcs.allIsZero = false;
            }
            calcs.lastNotNull = currentValue;
        }
    }
    if (calcs.max === -Number.MAX_VALUE) {
        calcs.max = null;
    }
    if (calcs.min === Number.MAX_VALUE) {
        calcs.min = null;
    }
    if (calcs.step === Number.MAX_VALUE) {
        calcs.step = null;
    }
    if (calcs.nonNullCount > 0) {
        calcs.mean = calcs.sum / calcs.nonNullCount;
    }
    if (calcs.allIsNull) {
        calcs.allIsZero = false;
    }
    if (calcs.max !== null && calcs.min !== null) {
        calcs.range = calcs.max - calcs.min;
    }
    if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_1___default()(calcs.firstNotNull) && lodash_isNumber__WEBPACK_IMPORTED_MODULE_1___default()(calcs.lastNotNull)) {
        calcs.diff = calcs.lastNotNull - calcs.firstNotNull;
    }
    return calcs;
}
function calculateFirst(field, ignoreNulls, nullAsZero) {
    return { first: field.values.get(0) };
}
function calculateFirstNotNull(field, ignoreNulls, nullAsZero) {
    var data = field.values;
    for (var idx = 0; idx < data.length; idx++) {
        var v = data.get(idx);
        if (v != null && v !== undefined) {
            return { firstNotNull: v };
        }
    }
    return { firstNotNull: null };
}
function calculateLast(field, ignoreNulls, nullAsZero) {
    var data = field.values;
    return { last: data.get(data.length - 1) };
}
function calculateLastNotNull(field, ignoreNulls, nullAsZero) {
    var data = field.values;
    var idx = data.length - 1;
    while (idx >= 0) {
        var v = data.get(idx--);
        if (v != null && v !== undefined) {
            return { lastNotNull: v };
        }
    }
    return { lastNotNull: null };
}
function calculateChangeCount(field, ignoreNulls, nullAsZero) {
    var data = field.values;
    var count = 0;
    var first = true;
    var last = null;
    for (var i = 0; i < data.length; i++) {
        var currentValue = data.get(i);
        if (currentValue === null) {
            if (ignoreNulls) {
                continue;
            }
            if (nullAsZero) {
                currentValue = 0;
            }
        }
        if (!first && last !== currentValue) {
            count++;
        }
        first = false;
        last = currentValue;
    }
    return { changeCount: count };
}
function calculateDistinctCount(field, ignoreNulls, nullAsZero) {
    var data = field.values;
    var distinct = new Set();
    for (var i = 0; i < data.length; i++) {
        var currentValue = data.get(i);
        if (currentValue === null) {
            if (ignoreNulls) {
                continue;
            }
            if (nullAsZero) {
                currentValue = 0;
            }
        }
        distinct.add(currentValue);
    }
    return { distinctCount: distinct.size };
}


/***/ }),

/***/ "./packages/grafana-data/src/transformations/index.ts":
/*!************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/index.ts ***!
  \************************************************************/
/*! exports provided: MatcherID, FieldMatcherID, FrameMatcherID, DataTransformerID, fieldMatchers, frameMatchers, getFieldMatcher, getFrameMatchers, transformDataFrame, transformersRegistry, ReduceTransformerOptions, FilterFieldsByNameTransformerOptions, ReducerID, reduceField, fieldReducers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _matchers_ids__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./matchers/ids */ "./packages/grafana-data/src/transformations/matchers/ids.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatcherID", function() { return _matchers_ids__WEBPACK_IMPORTED_MODULE_0__["MatcherID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldMatcherID", function() { return _matchers_ids__WEBPACK_IMPORTED_MODULE_0__["FieldMatcherID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FrameMatcherID", function() { return _matchers_ids__WEBPACK_IMPORTED_MODULE_0__["FrameMatcherID"]; });

/* harmony import */ var _transformers_ids__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./transformers/ids */ "./packages/grafana-data/src/transformations/transformers/ids.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataTransformerID", function() { return _transformers_ids__WEBPACK_IMPORTED_MODULE_1__["DataTransformerID"]; });

/* harmony import */ var _matchers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./matchers */ "./packages/grafana-data/src/transformations/matchers.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "fieldMatchers", function() { return _matchers__WEBPACK_IMPORTED_MODULE_2__["fieldMatchers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "frameMatchers", function() { return _matchers__WEBPACK_IMPORTED_MODULE_2__["frameMatchers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFieldMatcher", function() { return _matchers__WEBPACK_IMPORTED_MODULE_2__["getFieldMatcher"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFrameMatchers", function() { return _matchers__WEBPACK_IMPORTED_MODULE_2__["getFrameMatchers"]; });

/* harmony import */ var _transformers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transformers */ "./packages/grafana-data/src/transformations/transformers.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "transformDataFrame", function() { return _transformers__WEBPACK_IMPORTED_MODULE_3__["transformDataFrame"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "transformersRegistry", function() { return _transformers__WEBPACK_IMPORTED_MODULE_3__["transformersRegistry"]; });

/* harmony import */ var _fieldReducer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./fieldReducer */ "./packages/grafana-data/src/transformations/fieldReducer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReducerID", function() { return _fieldReducer__WEBPACK_IMPORTED_MODULE_4__["ReducerID"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "reduceField", function() { return _fieldReducer__WEBPACK_IMPORTED_MODULE_4__["reduceField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "fieldReducers", function() { return _fieldReducer__WEBPACK_IMPORTED_MODULE_4__["fieldReducers"]; });

/* harmony import */ var _transformers_filterByName__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./transformers/filterByName */ "./packages/grafana-data/src/transformations/transformers/filterByName.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FilterFieldsByNameTransformerOptions", function() { return _transformers_filterByName__WEBPACK_IMPORTED_MODULE_5__["FilterFieldsByNameTransformerOptions"]; });

/* harmony import */ var _transformers_reduce__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./transformers/reduce */ "./packages/grafana-data/src/transformations/transformers/reduce.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReduceTransformerOptions", function() { return _transformers_reduce__WEBPACK_IMPORTED_MODULE_6__["ReduceTransformerOptions"]; });










/***/ }),

/***/ "./packages/grafana-data/src/transformations/matchers.ts":
/*!***************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/matchers.ts ***!
  \***************************************************************/
/*! exports provided: fieldMatchers, frameMatchers, getFieldMatcher, getFrameMatchers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fieldMatchers", function() { return fieldMatchers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "frameMatchers", function() { return frameMatchers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFieldMatcher", function() { return getFieldMatcher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFrameMatchers", function() { return getFrameMatchers; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _matchers_predicates__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./matchers/predicates */ "./packages/grafana-data/src/transformations/matchers/predicates.ts");
/* harmony import */ var _matchers_nameMatcher__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./matchers/nameMatcher */ "./packages/grafana-data/src/transformations/matchers/nameMatcher.ts");
/* harmony import */ var _matchers_fieldTypeMatcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./matchers/fieldTypeMatcher */ "./packages/grafana-data/src/transformations/matchers/fieldTypeMatcher.ts");
/* harmony import */ var _matchers_refIdMatcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./matchers/refIdMatcher */ "./packages/grafana-data/src/transformations/matchers/refIdMatcher.ts");
/* harmony import */ var _utils_Registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/Registry */ "./packages/grafana-data/src/utils/Registry.ts");

// Load the Buildtin matchers





var fieldMatchers = new _utils_Registry__WEBPACK_IMPORTED_MODULE_5__["Registry"](function () {
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](Object(_matchers_predicates__WEBPACK_IMPORTED_MODULE_1__["getFieldPredicateMatchers"])(), Object(_matchers_fieldTypeMatcher__WEBPACK_IMPORTED_MODULE_3__["getFieldTypeMatchers"])(), Object(_matchers_nameMatcher__WEBPACK_IMPORTED_MODULE_2__["getFieldNameMatchers"])());
});
var frameMatchers = new _utils_Registry__WEBPACK_IMPORTED_MODULE_5__["Registry"](function () {
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](Object(_matchers_predicates__WEBPACK_IMPORTED_MODULE_1__["getFramePredicateMatchers"])(), Object(_matchers_nameMatcher__WEBPACK_IMPORTED_MODULE_2__["getFrameNameMatchers"])(), Object(_matchers_refIdMatcher__WEBPACK_IMPORTED_MODULE_4__["getRefIdMatchers"])());
});
function getFieldMatcher(config) {
    var info = fieldMatchers.get(config.id);
    if (!info) {
        throw new Error('Unknown Matcher: ' + config.id);
    }
    return info.get(config.options);
}
function getFrameMatchers(config) {
    var info = frameMatchers.get(config.id);
    if (!info) {
        throw new Error('Unknown Matcher: ' + config.id);
    }
    return info.get(config.options);
}


/***/ }),

/***/ "./packages/grafana-data/src/transformations/matchers/fieldTypeMatcher.ts":
/*!********************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/matchers/fieldTypeMatcher.ts ***!
  \********************************************************************************/
/*! exports provided: getFieldTypeMatchers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFieldTypeMatchers", function() { return getFieldTypeMatchers; });
/* harmony import */ var _types_dataFrame__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../types/dataFrame */ "./packages/grafana-data/src/types/dataFrame.ts");
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/matchers/ids.ts");


// General Field matcher
var fieldTypeMacher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["FieldMatcherID"].byType,
    name: 'Field Type',
    description: 'match based on the field type',
    defaultOptions: _types_dataFrame__WEBPACK_IMPORTED_MODULE_0__["FieldType"].number,
    get: function (type) {
        return function (field) {
            return type === field.type;
        };
    },
    getOptionsDisplayText: function (type) {
        return "Field type: " + type;
    },
};
// Numeric Field matcher
// This gets its own entry so it shows up in the dropdown
var numericMacher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["FieldMatcherID"].numeric,
    name: 'Numeric Fields',
    description: 'Fields with type number',
    get: function () {
        return fieldTypeMacher.get(_types_dataFrame__WEBPACK_IMPORTED_MODULE_0__["FieldType"].number);
    },
    getOptionsDisplayText: function () {
        return 'Numeric Fields';
    },
};
// Time Field matcher
var timeMacher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["FieldMatcherID"].time,
    name: 'Time Fields',
    description: 'Fields with type time',
    get: function () {
        return fieldTypeMacher.get(_types_dataFrame__WEBPACK_IMPORTED_MODULE_0__["FieldType"].time);
    },
    getOptionsDisplayText: function () {
        return 'Time Fields';
    },
};
/**
 * Registry Initalization
 */
function getFieldTypeMatchers() {
    return [fieldTypeMacher, numericMacher, timeMacher];
}


/***/ }),

/***/ "./packages/grafana-data/src/transformations/matchers/ids.ts":
/*!*******************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/matchers/ids.ts ***!
  \*******************************************************************/
/*! exports provided: MatcherID, FieldMatcherID, FrameMatcherID */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MatcherID", function() { return MatcherID; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FieldMatcherID", function() { return FieldMatcherID; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FrameMatcherID", function() { return FrameMatcherID; });
// This needs to be in its own file to avoid circular references
// Builtin Predicates
// not using 'any' and 'never' since they are reservered keywords
var MatcherID;
(function (MatcherID) {
    MatcherID["anyMatch"] = "anyMatch";
    MatcherID["allMatch"] = "allMatch";
    MatcherID["invertMatch"] = "invertMatch";
    MatcherID["alwaysMatch"] = "alwaysMatch";
    MatcherID["neverMatch"] = "neverMatch";
})(MatcherID || (MatcherID = {}));
var FieldMatcherID;
(function (FieldMatcherID) {
    // Specific Types
    FieldMatcherID["numeric"] = "numeric";
    FieldMatcherID["time"] = "time";
    // With arguments
    FieldMatcherID["byType"] = "byType";
    FieldMatcherID["byName"] = "byName";
    // byIndex = 'byIndex',
    // byLabel = 'byLabel',
})(FieldMatcherID || (FieldMatcherID = {}));
/**
 * Field name matchers
 */
var FrameMatcherID;
(function (FrameMatcherID) {
    FrameMatcherID["byName"] = "byName";
    FrameMatcherID["byRefId"] = "byRefId";
    FrameMatcherID["byIndex"] = "byIndex";
    FrameMatcherID["byLabel"] = "byLabel";
})(FrameMatcherID || (FrameMatcherID = {}));


/***/ }),

/***/ "./packages/grafana-data/src/transformations/matchers/nameMatcher.ts":
/*!***************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/matchers/nameMatcher.ts ***!
  \***************************************************************************/
/*! exports provided: getFieldNameMatchers, getFrameNameMatchers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFieldNameMatchers", function() { return getFieldNameMatchers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFrameNameMatchers", function() { return getFrameNameMatchers; });
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/matchers/ids.ts");
/* harmony import */ var _text_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../text/string */ "./packages/grafana-data/src/text/string.ts");


// General Field matcher
var fieldNameMacher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_0__["FieldMatcherID"].byName,
    name: 'Field Name',
    description: 'match the field name',
    defaultOptions: '/.*/',
    get: function (pattern) {
        var regex = Object(_text_string__WEBPACK_IMPORTED_MODULE_1__["stringToJsRegex"])(pattern);
        return function (field) {
            return regex.test(field.name);
        };
    },
    getOptionsDisplayText: function (pattern) {
        return "Field name: " + pattern;
    },
};
// General Field matcher
var frameNameMacher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_0__["FrameMatcherID"].byName,
    name: 'Frame Name',
    description: 'match the frame name',
    defaultOptions: '/.*/',
    get: function (pattern) {
        var regex = Object(_text_string__WEBPACK_IMPORTED_MODULE_1__["stringToJsRegex"])(pattern);
        return function (frame) {
            return regex.test(frame.name || '');
        };
    },
    getOptionsDisplayText: function (pattern) {
        return "Frame name: " + pattern;
    },
};
/**
 * Registry Initalization
 */
function getFieldNameMatchers() {
    return [fieldNameMacher];
}
function getFrameNameMatchers() {
    return [frameNameMacher];
}


/***/ }),

/***/ "./packages/grafana-data/src/transformations/matchers/predicates.ts":
/*!**************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/matchers/predicates.ts ***!
  \**************************************************************************/
/*! exports provided: alwaysFieldMatcher, alwaysFrameMatcher, neverFieldMatcher, neverFrameMatcher, getFieldPredicateMatchers, getFramePredicateMatchers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "alwaysFieldMatcher", function() { return alwaysFieldMatcher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "alwaysFrameMatcher", function() { return alwaysFrameMatcher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "neverFieldMatcher", function() { return neverFieldMatcher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "neverFrameMatcher", function() { return neverFrameMatcher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFieldPredicateMatchers", function() { return getFieldPredicateMatchers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFramePredicateMatchers", function() { return getFramePredicateMatchers; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/matchers/ids.ts");
/* harmony import */ var _matchers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../matchers */ "./packages/grafana-data/src/transformations/matchers.ts");



var anyFieldMatcher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].anyMatch,
    name: 'Any',
    description: 'Any child matches (OR)',
    excludeFromPicker: true,
    defaultOptions: [],
    get: function (options) {
        var children = options.map(function (option) {
            return Object(_matchers__WEBPACK_IMPORTED_MODULE_2__["getFieldMatcher"])(option);
        });
        return function (field) {
            var e_1, _a;
            try {
                for (var children_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                    var child = children_1_1.value;
                    if (child(field)) {
                        return true;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (children_1_1 && !children_1_1.done && (_a = children_1.return)) _a.call(children_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return false;
        };
    },
    getOptionsDisplayText: function (options) {
        var e_2, _a;
        var text = '';
        try {
            for (var options_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](options), options_1_1 = options_1.next(); !options_1_1.done; options_1_1 = options_1.next()) {
                var sub = options_1_1.value;
                if (text.length > 0) {
                    text += ' OR ';
                }
                var matcher = _matchers__WEBPACK_IMPORTED_MODULE_2__["fieldMatchers"].get(sub.id);
                text += matcher.getOptionsDisplayText ? matcher.getOptionsDisplayText(sub) : matcher.name;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (options_1_1 && !options_1_1.done && (_a = options_1.return)) _a.call(options_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return text;
    },
};
var anyFrameMatcher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].anyMatch,
    name: 'Any',
    description: 'Any child matches (OR)',
    excludeFromPicker: true,
    defaultOptions: [],
    get: function (options) {
        var children = options.map(function (option) {
            return Object(_matchers__WEBPACK_IMPORTED_MODULE_2__["getFrameMatchers"])(option);
        });
        return function (frame) {
            var e_3, _a;
            try {
                for (var children_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](children), children_2_1 = children_2.next(); !children_2_1.done; children_2_1 = children_2.next()) {
                    var child = children_2_1.value;
                    if (child(frame)) {
                        return true;
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (children_2_1 && !children_2_1.done && (_a = children_2.return)) _a.call(children_2);
                }
                finally { if (e_3) throw e_3.error; }
            }
            return false;
        };
    },
    getOptionsDisplayText: function (options) {
        var e_4, _a;
        var text = '';
        try {
            for (var options_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](options), options_2_1 = options_2.next(); !options_2_1.done; options_2_1 = options_2.next()) {
                var sub = options_2_1.value;
                if (text.length > 0) {
                    text += ' OR ';
                }
                var matcher = _matchers__WEBPACK_IMPORTED_MODULE_2__["frameMatchers"].get(sub.id);
                text += matcher.getOptionsDisplayText ? matcher.getOptionsDisplayText(sub) : matcher.name;
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (options_2_1 && !options_2_1.done && (_a = options_2.return)) _a.call(options_2);
            }
            finally { if (e_4) throw e_4.error; }
        }
        return text;
    },
};
var allFieldsMatcher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].allMatch,
    name: 'All',
    description: 'Everything matches (AND)',
    excludeFromPicker: true,
    defaultOptions: [],
    get: function (options) {
        var children = options.map(function (option) {
            return Object(_matchers__WEBPACK_IMPORTED_MODULE_2__["getFieldMatcher"])(option);
        });
        return function (field) {
            var e_5, _a;
            try {
                for (var children_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](children), children_3_1 = children_3.next(); !children_3_1.done; children_3_1 = children_3.next()) {
                    var child = children_3_1.value;
                    if (!child(field)) {
                        return false;
                    }
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (children_3_1 && !children_3_1.done && (_a = children_3.return)) _a.call(children_3);
                }
                finally { if (e_5) throw e_5.error; }
            }
            return true;
        };
    },
    getOptionsDisplayText: function (options) {
        var e_6, _a;
        var text = '';
        try {
            for (var options_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](options), options_3_1 = options_3.next(); !options_3_1.done; options_3_1 = options_3.next()) {
                var sub = options_3_1.value;
                if (text.length > 0) {
                    text += ' AND ';
                }
                var matcher = _matchers__WEBPACK_IMPORTED_MODULE_2__["fieldMatchers"].get(sub.id); // Ugho what about frame
                text += matcher.getOptionsDisplayText ? matcher.getOptionsDisplayText(sub) : matcher.name;
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (options_3_1 && !options_3_1.done && (_a = options_3.return)) _a.call(options_3);
            }
            finally { if (e_6) throw e_6.error; }
        }
        return text;
    },
};
var allFramesMatcher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].allMatch,
    name: 'All',
    description: 'Everything matches (AND)',
    excludeFromPicker: true,
    defaultOptions: [],
    get: function (options) {
        var children = options.map(function (option) {
            return Object(_matchers__WEBPACK_IMPORTED_MODULE_2__["getFrameMatchers"])(option);
        });
        return function (frame) {
            var e_7, _a;
            try {
                for (var children_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](children), children_4_1 = children_4.next(); !children_4_1.done; children_4_1 = children_4.next()) {
                    var child = children_4_1.value;
                    if (!child(frame)) {
                        return false;
                    }
                }
            }
            catch (e_7_1) { e_7 = { error: e_7_1 }; }
            finally {
                try {
                    if (children_4_1 && !children_4_1.done && (_a = children_4.return)) _a.call(children_4);
                }
                finally { if (e_7) throw e_7.error; }
            }
            return true;
        };
    },
    getOptionsDisplayText: function (options) {
        var e_8, _a;
        var text = '';
        try {
            for (var options_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](options), options_4_1 = options_4.next(); !options_4_1.done; options_4_1 = options_4.next()) {
                var sub = options_4_1.value;
                if (text.length > 0) {
                    text += ' AND ';
                }
                var matcher = _matchers__WEBPACK_IMPORTED_MODULE_2__["frameMatchers"].get(sub.id);
                text += matcher.getOptionsDisplayText ? matcher.getOptionsDisplayText(sub) : matcher.name;
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (options_4_1 && !options_4_1.done && (_a = options_4.return)) _a.call(options_4);
            }
            finally { if (e_8) throw e_8.error; }
        }
        return text;
    },
};
var notFieldMatcher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].invertMatch,
    name: 'NOT',
    description: 'Inverts other matchers',
    excludeFromPicker: true,
    get: function (option) {
        var check = Object(_matchers__WEBPACK_IMPORTED_MODULE_2__["getFieldMatcher"])(option);
        return function (field) {
            return !check(field);
        };
    },
    getOptionsDisplayText: function (options) {
        var matcher = _matchers__WEBPACK_IMPORTED_MODULE_2__["fieldMatchers"].get(options.id);
        var text = matcher.getOptionsDisplayText ? matcher.getOptionsDisplayText(options.options) : matcher.name;
        return 'NOT ' + text;
    },
};
var notFrameMatcher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].invertMatch,
    name: 'NOT',
    description: 'Inverts other matchers',
    excludeFromPicker: true,
    get: function (option) {
        var check = Object(_matchers__WEBPACK_IMPORTED_MODULE_2__["getFrameMatchers"])(option);
        return function (frame) {
            return !check(frame);
        };
    },
    getOptionsDisplayText: function (options) {
        var matcher = _matchers__WEBPACK_IMPORTED_MODULE_2__["frameMatchers"].get(options.id);
        var text = matcher.getOptionsDisplayText ? matcher.getOptionsDisplayText(options.options) : matcher.name;
        return 'NOT ' + text;
    },
};
var alwaysFieldMatcher = function (field) {
    return true;
};
var alwaysFrameMatcher = function (frame) {
    return true;
};
var neverFieldMatcher = function (field) {
    return false;
};
var neverFrameMatcher = function (frame) {
    return false;
};
var alwaysFieldMatcherInfo = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].alwaysMatch,
    name: 'All Fields',
    description: 'Always Match',
    get: function (option) {
        return alwaysFieldMatcher;
    },
    getOptionsDisplayText: function (options) {
        return 'Always';
    },
};
var alwaysFrameMatcherInfo = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].alwaysMatch,
    name: 'All Frames',
    description: 'Always Match',
    get: function (option) {
        return alwaysFrameMatcher;
    },
    getOptionsDisplayText: function (options) {
        return 'Always';
    },
};
var neverFieldMatcherInfo = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].neverMatch,
    name: 'No Fields',
    description: 'Never Match',
    excludeFromPicker: true,
    get: function (option) {
        return neverFieldMatcher;
    },
    getOptionsDisplayText: function (options) {
        return 'Never';
    },
};
var neverFrameMatcherInfo = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["MatcherID"].neverMatch,
    name: 'No Frames',
    description: 'Never Match',
    get: function (option) {
        return neverFrameMatcher;
    },
    getOptionsDisplayText: function (options) {
        return 'Never';
    },
};
function getFieldPredicateMatchers() {
    return [anyFieldMatcher, allFieldsMatcher, notFieldMatcher, alwaysFieldMatcherInfo, neverFieldMatcherInfo];
}
function getFramePredicateMatchers() {
    return [anyFrameMatcher, allFramesMatcher, notFrameMatcher, alwaysFrameMatcherInfo, neverFrameMatcherInfo];
}


/***/ }),

/***/ "./packages/grafana-data/src/transformations/matchers/refIdMatcher.ts":
/*!****************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/matchers/refIdMatcher.ts ***!
  \****************************************************************************/
/*! exports provided: getRefIdMatchers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getRefIdMatchers", function() { return getRefIdMatchers; });
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/matchers/ids.ts");

// General Field matcher
var refIdMacher = {
    id: _ids__WEBPACK_IMPORTED_MODULE_0__["FrameMatcherID"].byRefId,
    name: 'Query refId',
    description: 'match the refId',
    defaultOptions: 'A',
    get: function (pattern) {
        return function (frame) {
            return pattern === frame.refId;
        };
    },
    getOptionsDisplayText: function (pattern) {
        return "RefID: " + pattern;
    },
};
function getRefIdMatchers() {
    return [refIdMacher];
}


/***/ }),

/***/ "./packages/grafana-data/src/transformations/transformers.ts":
/*!*******************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/transformers.ts ***!
  \*******************************************************************/
/*! exports provided: transformDataFrame, transformersRegistry, ReduceTransformerOptions, FilterFieldsByNameTransformerOptions */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "transformDataFrame", function() { return transformDataFrame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "transformersRegistry", function() { return transformersRegistry; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _utils_Registry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/Registry */ "./packages/grafana-data/src/utils/Registry.ts");
/* harmony import */ var _transformers_append__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./transformers/append */ "./packages/grafana-data/src/transformations/transformers/append.ts");
/* harmony import */ var _transformers_reduce__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transformers/reduce */ "./packages/grafana-data/src/transformations/transformers/reduce.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReduceTransformerOptions", function() { return _transformers_reduce__WEBPACK_IMPORTED_MODULE_3__["ReduceTransformerOptions"]; });

/* harmony import */ var _transformers_filter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./transformers/filter */ "./packages/grafana-data/src/transformations/transformers/filter.ts");
/* harmony import */ var _transformers_filterByName__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./transformers/filterByName */ "./packages/grafana-data/src/transformations/transformers/filterByName.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FilterFieldsByNameTransformerOptions", function() { return _transformers_filterByName__WEBPACK_IMPORTED_MODULE_5__["FilterFieldsByNameTransformerOptions"]; });

/* harmony import */ var _transformers_noop__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./transformers/noop */ "./packages/grafana-data/src/transformations/transformers/noop.ts");


// Initalize the Registry





/**
 * Apply configured transformations to the input data
 */
function transformDataFrame(options, data) {
    var e_1, _a, e_2, _b;
    var processed = data;
    try {
        for (var options_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](options), options_1_1 = options_1.next(); !options_1_1.done; options_1_1 = options_1.next()) {
            var config = options_1_1.value;
            var info = transformersRegistry.get(config.id);
            var transformer = info.transformer(config.options);
            var after = transformer(processed);
            // Add a key to the metadata if the data changed
            if (after && after !== processed) {
                try {
                    for (var after_1 = (e_2 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](after)), after_1_1 = after_1.next(); !after_1_1.done; after_1_1 = after_1.next()) {
                        var series = after_1_1.value;
                        if (!series.meta) {
                            series.meta = {};
                        }
                        if (!series.meta.transformations) {
                            series.meta.transformations = [info.id];
                        }
                        else {
                            series.meta.transformations = tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](series.meta.transformations, [info.id]);
                        }
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (after_1_1 && !after_1_1.done && (_b = after_1.return)) _b.call(after_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                processed = after;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (options_1_1 && !options_1_1.done && (_a = options_1.return)) _a.call(options_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return processed;
}
/**
 * Registry of transformation options that can be driven by
 * stored configuration files.
 */
var TransformerRegistry = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TransformerRegistry, _super);
    function TransformerRegistry() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    // ------------------------------------------------------------
    // Nacent options for more functional programming
    // The API to these functions should change to match the actual
    // needs of people trying to use it.
    //  filterFields|Frames is left off since it is likely easier to
    //  support with `frames.filter( f => {...} )`
    // ------------------------------------------------------------
    TransformerRegistry.prototype.append = function (data, options) {
        return _transformers_append__WEBPACK_IMPORTED_MODULE_2__["appendTransformer"].transformer(options || _transformers_append__WEBPACK_IMPORTED_MODULE_2__["appendTransformer"].defaultOptions)(data)[0];
    };
    TransformerRegistry.prototype.reduce = function (data, options) {
        return _transformers_reduce__WEBPACK_IMPORTED_MODULE_3__["reduceTransformer"].transformer(options)(data);
    };
    return TransformerRegistry;
}(_utils_Registry__WEBPACK_IMPORTED_MODULE_1__["Registry"]));
var transformersRegistry = new TransformerRegistry(function () { return [
    _transformers_noop__WEBPACK_IMPORTED_MODULE_6__["noopTransformer"],
    _transformers_filter__WEBPACK_IMPORTED_MODULE_4__["filterFieldsTransformer"],
    _transformers_filterByName__WEBPACK_IMPORTED_MODULE_5__["filterFieldsByNameTransformer"],
    _transformers_filter__WEBPACK_IMPORTED_MODULE_4__["filterFramesTransformer"],
    _transformers_append__WEBPACK_IMPORTED_MODULE_2__["appendTransformer"],
    _transformers_reduce__WEBPACK_IMPORTED_MODULE_3__["reduceTransformer"],
]; });



/***/ }),

/***/ "./packages/grafana-data/src/transformations/transformers/append.ts":
/*!**************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/transformers/append.ts ***!
  \**************************************************************************/
/*! exports provided: appendTransformer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "appendTransformer", function() { return appendTransformer; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/transformers/ids.ts");
/* harmony import */ var _dataframe_MutableDataFrame__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../dataframe/MutableDataFrame */ "./packages/grafana-data/src/dataframe/MutableDataFrame.ts");



var appendTransformer = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["DataTransformerID"].append,
    name: 'Append',
    description: 'Append values into a single DataFrame.  This uses the name as the key',
    defaultOptions: {},
    /**
     * Return a modified copy of the series.  If the transform is not or should not
     * be applied, just return the input series
     */
    transformer: function (options) {
        return function (data) {
            var e_1, _a;
            if (data.length < 2) {
                return data;
            }
            // Add the first row
            var processed = new _dataframe_MutableDataFrame__WEBPACK_IMPORTED_MODULE_2__["MutableDataFrame"]();
            try {
                for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](data[0].fields), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var f = _c.value;
                    processed.addField(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, f, { values: tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](f.values.toArray()) }));
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            for (var i = 1; i < data.length; i++) {
                var frame = data[i];
                var startLength = frame.length;
                for (var j = 0; j < frame.fields.length; j++) {
                    var src = frame.fields[j];
                    var vals = processed.values[src.name];
                    if (!vals) {
                        vals = processed.addField(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, src, { values: [] }), startLength).values;
                    }
                    // Add each row
                    for (var k = 0; k < frame.length; k++) {
                        vals.add(src.values.get(k));
                    }
                }
                processed.validate();
            }
            return [processed];
        };
    },
};


/***/ }),

/***/ "./packages/grafana-data/src/transformations/transformers/filter.ts":
/*!**************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/transformers/filter.ts ***!
  \**************************************************************************/
/*! exports provided: filterFieldsTransformer, filterFramesTransformer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "filterFieldsTransformer", function() { return filterFieldsTransformer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "filterFramesTransformer", function() { return filterFramesTransformer; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _noop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./noop */ "./packages/grafana-data/src/transformations/transformers/noop.ts");
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/transformers/ids.ts");
/* harmony import */ var _matchers_ids__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../matchers/ids */ "./packages/grafana-data/src/transformations/matchers/ids.ts");
/* harmony import */ var _matchers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../matchers */ "./packages/grafana-data/src/transformations/matchers.ts");





var filterFieldsTransformer = {
    id: _ids__WEBPACK_IMPORTED_MODULE_2__["DataTransformerID"].filterFields,
    name: 'Filter Fields',
    description: 'select a subset of fields',
    defaultOptions: {
        include: { id: _matchers_ids__WEBPACK_IMPORTED_MODULE_3__["FieldMatcherID"].numeric },
    },
    /**
     * Return a modified copy of the series.  If the transform is not or should not
     * be applied, just return the input series
     */
    transformer: function (options) {
        if (!options.include && !options.exclude) {
            return _noop__WEBPACK_IMPORTED_MODULE_1__["noopTransformer"].transformer({});
        }
        var include = options.include ? Object(_matchers__WEBPACK_IMPORTED_MODULE_4__["getFieldMatcher"])(options.include) : null;
        var exclude = options.exclude ? Object(_matchers__WEBPACK_IMPORTED_MODULE_4__["getFieldMatcher"])(options.exclude) : null;
        return function (data) {
            var e_1, _a;
            var processed = [];
            try {
                for (var data_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](data), data_1_1 = data_1.next(); !data_1_1.done; data_1_1 = data_1.next()) {
                    var series = data_1_1.value;
                    // Find the matching field indexes
                    var fields = [];
                    for (var i = 0; i < series.fields.length; i++) {
                        var field = series.fields[i];
                        if (exclude) {
                            if (exclude(field)) {
                                continue;
                            }
                            if (!include) {
                                fields.push(field);
                            }
                        }
                        if (include && include(field)) {
                            fields.push(field);
                        }
                    }
                    if (!fields.length) {
                        continue;
                    }
                    var copy = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, series, { // all the other properties
                        fields: fields });
                    processed.push(copy);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (data_1_1 && !data_1_1.done && (_a = data_1.return)) _a.call(data_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return processed;
        };
    },
};
var filterFramesTransformer = {
    id: _ids__WEBPACK_IMPORTED_MODULE_2__["DataTransformerID"].filterFrames,
    name: 'Filter Frames',
    description: 'select a subset of frames',
    defaultOptions: {},
    /**
     * Return a modified copy of the series.  If the transform is not or should not
     * be applied, just return the input series
     */
    transformer: function (options) {
        if (!options.include && !options.exclude) {
            return _noop__WEBPACK_IMPORTED_MODULE_1__["noopTransformer"].transformer({});
        }
        var include = options.include ? Object(_matchers__WEBPACK_IMPORTED_MODULE_4__["getFrameMatchers"])(options.include) : null;
        var exclude = options.exclude ? Object(_matchers__WEBPACK_IMPORTED_MODULE_4__["getFrameMatchers"])(options.exclude) : null;
        return function (data) {
            var e_2, _a;
            var processed = [];
            try {
                for (var data_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](data), data_2_1 = data_2.next(); !data_2_1.done; data_2_1 = data_2.next()) {
                    var series = data_2_1.value;
                    if (exclude) {
                        if (exclude(series)) {
                            continue;
                        }
                        if (!include) {
                            processed.push(series);
                        }
                    }
                    if (include && include(series)) {
                        processed.push(series);
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (data_2_1 && !data_2_1.done && (_a = data_2.return)) _a.call(data_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
            return processed;
        };
    },
};


/***/ }),

/***/ "./packages/grafana-data/src/transformations/transformers/filterByName.ts":
/*!********************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/transformers/filterByName.ts ***!
  \********************************************************************************/
/*! exports provided: filterFieldsByNameTransformer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "filterFieldsByNameTransformer", function() { return filterFieldsByNameTransformer; });
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/transformers/ids.ts");
/* harmony import */ var _filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filter */ "./packages/grafana-data/src/transformations/transformers/filter.ts");
/* harmony import */ var _matchers_ids__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../matchers/ids */ "./packages/grafana-data/src/transformations/matchers/ids.ts");



var filterFieldsByNameTransformer = {
    id: _ids__WEBPACK_IMPORTED_MODULE_0__["DataTransformerID"].filterFieldsByName,
    name: 'Filter fields by name',
    description: 'select a subset of fields',
    defaultOptions: {},
    /**
     * Return a modified copy of the series.  If the transform is not or should not
     * be applied, just return the input series
     */
    transformer: function (options) {
        var filterOptions = {};
        if (options.include) {
            filterOptions.include = {
                id: _matchers_ids__WEBPACK_IMPORTED_MODULE_2__["FieldMatcherID"].byName,
                options: options.include,
            };
        }
        if (options.exclude) {
            filterOptions.exclude = {
                id: _matchers_ids__WEBPACK_IMPORTED_MODULE_2__["FieldMatcherID"].byName,
                options: options.exclude,
            };
        }
        return _filter__WEBPACK_IMPORTED_MODULE_1__["filterFieldsTransformer"].transformer(filterOptions);
    },
};


/***/ }),

/***/ "./packages/grafana-data/src/transformations/transformers/ids.ts":
/*!***********************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/transformers/ids.ts ***!
  \***********************************************************************/
/*! exports provided: DataTransformerID */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataTransformerID", function() { return DataTransformerID; });
var DataTransformerID;
(function (DataTransformerID) {
    //  join = 'join', // Pick a field and merge all series based on that field
    DataTransformerID["append"] = "append";
    //  rotate = 'rotate', // Columns to rows
    DataTransformerID["reduce"] = "reduce";
    DataTransformerID["filterFields"] = "filterFields";
    DataTransformerID["filterFieldsByName"] = "filterFieldsByName";
    DataTransformerID["filterFrames"] = "filterFrames";
    DataTransformerID["noop"] = "noop";
})(DataTransformerID || (DataTransformerID = {}));


/***/ }),

/***/ "./packages/grafana-data/src/transformations/transformers/noop.ts":
/*!************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/transformers/noop.ts ***!
  \************************************************************************/
/*! exports provided: noopTransformer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "noopTransformer", function() { return noopTransformer; });
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/transformers/ids.ts");

var noopTransformer = {
    id: _ids__WEBPACK_IMPORTED_MODULE_0__["DataTransformerID"].noop,
    name: 'noop',
    description: 'No-operation transformer',
    defaultOptions: {},
    /**
     * Return a modified copy of the series.  If the transform is not or should not
     * be applied, just return the input series
     */
    transformer: function (options) {
        return function (data) { return data; };
    },
};


/***/ }),

/***/ "./packages/grafana-data/src/transformations/transformers/reduce.ts":
/*!**************************************************************************!*\
  !*** ./packages/grafana-data/src/transformations/transformers/reduce.ts ***!
  \**************************************************************************/
/*! exports provided: reduceTransformer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "reduceTransformer", function() { return reduceTransformer; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _ids__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ids */ "./packages/grafana-data/src/transformations/transformers/ids.ts");
/* harmony import */ var _fieldReducer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../fieldReducer */ "./packages/grafana-data/src/transformations/fieldReducer.ts");
/* harmony import */ var _matchers_predicates__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../matchers/predicates */ "./packages/grafana-data/src/transformations/matchers/predicates.ts");
/* harmony import */ var _types_dataFrame__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../types/dataFrame */ "./packages/grafana-data/src/types/dataFrame.ts");
/* harmony import */ var _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vector/ArrayVector */ "./packages/grafana-data/src/vector/ArrayVector.ts");
/* harmony import */ var _dataframe_processDataFrame__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../dataframe/processDataFrame */ "./packages/grafana-data/src/dataframe/processDataFrame.ts");
/* harmony import */ var _matchers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../matchers */ "./packages/grafana-data/src/transformations/matchers.ts");








var reduceTransformer = {
    id: _ids__WEBPACK_IMPORTED_MODULE_1__["DataTransformerID"].reduce,
    name: 'Reducer',
    description: 'Return a DataFrame with the reduction results',
    defaultOptions: {
        reducers: [_fieldReducer__WEBPACK_IMPORTED_MODULE_2__["ReducerID"].min, _fieldReducer__WEBPACK_IMPORTED_MODULE_2__["ReducerID"].max, _fieldReducer__WEBPACK_IMPORTED_MODULE_2__["ReducerID"].mean, _fieldReducer__WEBPACK_IMPORTED_MODULE_2__["ReducerID"].last],
    },
    /**
     * Return a modified copy of the series.  If the transform is not or should not
     * be applied, just return the input series
     */
    transformer: function (options) {
        var matcher = options.fields ? Object(_matchers__WEBPACK_IMPORTED_MODULE_7__["getFieldMatcher"])(options.fields) : _matchers_predicates__WEBPACK_IMPORTED_MODULE_3__["alwaysFieldMatcher"];
        var calculators = options.reducers && options.reducers.length ? _fieldReducer__WEBPACK_IMPORTED_MODULE_2__["fieldReducers"].list(options.reducers) : [];
        var reducers = calculators.map(function (c) { return c.id; });
        return function (data) {
            var e_1, _a, e_2, _b, e_3, _c, e_4, _d;
            var processed = [];
            try {
                for (var data_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](data), data_1_1 = data_1.next(); !data_1_1.done; data_1_1 = data_1.next()) {
                    var series = data_1_1.value;
                    var values = [];
                    var fields = [];
                    var byId = {};
                    values.push(new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_5__["ArrayVector"]()); // The name
                    fields.push({
                        name: 'Field',
                        type: _types_dataFrame__WEBPACK_IMPORTED_MODULE_4__["FieldType"].string,
                        values: values[0],
                        config: {},
                    });
                    try {
                        for (var calculators_1 = (e_2 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](calculators)), calculators_1_1 = calculators_1.next(); !calculators_1_1.done; calculators_1_1 = calculators_1.next()) {
                            var info = calculators_1_1.value;
                            var vals = new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_5__["ArrayVector"]();
                            byId[info.id] = vals;
                            values.push(vals);
                            fields.push({
                                name: info.id,
                                type: _types_dataFrame__WEBPACK_IMPORTED_MODULE_4__["FieldType"].other,
                                values: values[values.length - 1],
                                config: {
                                    title: info.name,
                                },
                            });
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (calculators_1_1 && !calculators_1_1.done && (_b = calculators_1.return)) _b.call(calculators_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                    for (var i = 0; i < series.fields.length; i++) {
                        var field = series.fields[i];
                        if (matcher(field)) {
                            var results = Object(_fieldReducer__WEBPACK_IMPORTED_MODULE_2__["reduceField"])({
                                field: field,
                                reducers: reducers,
                            });
                            // Update the name list
                            values[0].buffer.push(field.name);
                            try {
                                for (var calculators_2 = (e_3 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](calculators)), calculators_2_1 = calculators_2.next(); !calculators_2_1.done; calculators_2_1 = calculators_2.next()) {
                                    var info = calculators_2_1.value;
                                    var v = results[info.id];
                                    byId[info.id].buffer.push(v);
                                }
                            }
                            catch (e_3_1) { e_3 = { error: e_3_1 }; }
                            finally {
                                try {
                                    if (calculators_2_1 && !calculators_2_1.done && (_c = calculators_2.return)) _c.call(calculators_2);
                                }
                                finally { if (e_3) throw e_3.error; }
                            }
                        }
                    }
                    try {
                        for (var fields_1 = (e_4 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](fields)), fields_1_1 = fields_1.next(); !fields_1_1.done; fields_1_1 = fields_1.next()) {
                            var f = fields_1_1.value;
                            var t = Object(_dataframe_processDataFrame__WEBPACK_IMPORTED_MODULE_6__["guessFieldTypeForField"])(f);
                            if (t) {
                                f.type = t;
                            }
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (fields_1_1 && !fields_1_1.done && (_d = fields_1.return)) _d.call(fields_1);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                    processed.push(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, series, { // Same properties, different fields
                        fields: fields, length: values[0].length }));
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (data_1_1 && !data_1_1.done && (_a = data_1.return)) _a.call(data_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return processed;
        };
    },
};


/***/ }),

/***/ "./packages/grafana-data/src/types/ScopedVars.ts":
/*!*******************************************************!*\
  !*** ./packages/grafana-data/src/types/ScopedVars.ts ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/data.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-data/src/types/data.ts ***!
  \*************************************************/
/*! exports provided: LoadingState, NullValueMode */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoadingState", function() { return LoadingState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NullValueMode", function() { return NullValueMode; });
var LoadingState;
(function (LoadingState) {
    LoadingState["NotStarted"] = "NotStarted";
    LoadingState["Loading"] = "Loading";
    LoadingState["Streaming"] = "Streaming";
    LoadingState["Done"] = "Done";
    LoadingState["Error"] = "Error";
})(LoadingState || (LoadingState = {}));
var NullValueMode;
(function (NullValueMode) {
    NullValueMode["Null"] = "null";
    NullValueMode["Ignore"] = "connected";
    NullValueMode["AsZero"] = "null as zero";
})(NullValueMode || (NullValueMode = {}));


/***/ }),

/***/ "./packages/grafana-data/src/types/dataFrame.ts":
/*!******************************************************!*\
  !*** ./packages/grafana-data/src/types/dataFrame.ts ***!
  \******************************************************/
/*! exports provided: FieldType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FieldType", function() { return FieldType; });
var FieldType;
(function (FieldType) {
    FieldType["time"] = "time";
    FieldType["number"] = "number";
    FieldType["string"] = "string";
    FieldType["boolean"] = "boolean";
    FieldType["other"] = "other";
})(FieldType || (FieldType = {}));


/***/ }),

/***/ "./packages/grafana-data/src/types/dataLink.ts":
/*!*****************************************************!*\
  !*** ./packages/grafana-data/src/types/dataLink.ts ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/displayValue.ts":
/*!*********************************************************!*\
  !*** ./packages/grafana-data/src/types/displayValue.ts ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/graph.ts":
/*!**************************************************!*\
  !*** ./packages/grafana-data/src/types/graph.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/index.ts":
/*!**************************************************!*\
  !*** ./packages/grafana-data/src/types/index.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./data */ "./packages/grafana-data/src/types/data.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LoadingState", function() { return _data__WEBPACK_IMPORTED_MODULE_0__["LoadingState"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NullValueMode", function() { return _data__WEBPACK_IMPORTED_MODULE_0__["NullValueMode"]; });

/* harmony import */ var _dataFrame__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dataFrame */ "./packages/grafana-data/src/types/dataFrame.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldType", function() { return _dataFrame__WEBPACK_IMPORTED_MODULE_1__["FieldType"]; });

/* harmony import */ var _dataLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dataLink */ "./packages/grafana-data/src/types/dataLink.ts");
/* harmony import */ var _dataLink__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_dataLink__WEBPACK_IMPORTED_MODULE_2__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _dataLink__WEBPACK_IMPORTED_MODULE_2__) if(["LoadingState","NullValueMode","FieldType","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _dataLink__WEBPACK_IMPORTED_MODULE_2__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _logs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./logs */ "./packages/grafana-data/src/types/logs.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogLevel", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["LogLevel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogsMetaKind", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["LogsMetaKind"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogsDedupStrategy", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["LogsDedupStrategy"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogsDedupDescription", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["LogsDedupDescription"]; });

/* harmony import */ var _navModel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./navModel */ "./packages/grafana-data/src/types/navModel.ts");
/* harmony import */ var _navModel__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_navModel__WEBPACK_IMPORTED_MODULE_4__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _navModel__WEBPACK_IMPORTED_MODULE_4__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _navModel__WEBPACK_IMPORTED_MODULE_4__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./select */ "./packages/grafana-data/src/types/select.ts");
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_select__WEBPACK_IMPORTED_MODULE_5__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _select__WEBPACK_IMPORTED_MODULE_5__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _select__WEBPACK_IMPORTED_MODULE_5__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./time */ "./packages/grafana-data/src/types/time.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTimeZone", function() { return _time__WEBPACK_IMPORTED_MODULE_6__["DefaultTimeZone"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TIME_FORMAT", function() { return _time__WEBPACK_IMPORTED_MODULE_6__["TIME_FORMAT"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTimeRange", function() { return _time__WEBPACK_IMPORTED_MODULE_6__["DefaultTimeRange"]; });

/* harmony import */ var _threshold__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./threshold */ "./packages/grafana-data/src/types/threshold.ts");
/* harmony import */ var _threshold__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_threshold__WEBPACK_IMPORTED_MODULE_7__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _threshold__WEBPACK_IMPORTED_MODULE_7__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","DefaultTimeZone","TIME_FORMAT","DefaultTimeRange","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _threshold__WEBPACK_IMPORTED_MODULE_7__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils */ "./packages/grafana-data/src/types/utils.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_utils__WEBPACK_IMPORTED_MODULE_8__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _utils__WEBPACK_IMPORTED_MODULE_8__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","DefaultTimeZone","TIME_FORMAT","DefaultTimeRange","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _utils__WEBPACK_IMPORTED_MODULE_8__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _valueMapping__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./valueMapping */ "./packages/grafana-data/src/types/valueMapping.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MappingType", function() { return _valueMapping__WEBPACK_IMPORTED_MODULE_9__["MappingType"]; });

/* harmony import */ var _displayValue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./displayValue */ "./packages/grafana-data/src/types/displayValue.ts");
/* harmony import */ var _displayValue__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_displayValue__WEBPACK_IMPORTED_MODULE_10__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _displayValue__WEBPACK_IMPORTED_MODULE_10__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","DefaultTimeZone","TIME_FORMAT","DefaultTimeRange","MappingType","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _displayValue__WEBPACK_IMPORTED_MODULE_10__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _graph__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./graph */ "./packages/grafana-data/src/types/graph.ts");
/* harmony import */ var _graph__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_graph__WEBPACK_IMPORTED_MODULE_11__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _graph__WEBPACK_IMPORTED_MODULE_11__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","DefaultTimeZone","TIME_FORMAT","DefaultTimeRange","MappingType","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _graph__WEBPACK_IMPORTED_MODULE_11__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _ScopedVars__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./ScopedVars */ "./packages/grafana-data/src/types/ScopedVars.ts");
/* harmony import */ var _ScopedVars__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_ScopedVars__WEBPACK_IMPORTED_MODULE_12__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _ScopedVars__WEBPACK_IMPORTED_MODULE_12__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","DefaultTimeZone","TIME_FORMAT","DefaultTimeRange","MappingType","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _ScopedVars__WEBPACK_IMPORTED_MODULE_12__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _transformations__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./transformations */ "./packages/grafana-data/src/types/transformations.ts");
/* harmony import */ var _transformations__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_transformations__WEBPACK_IMPORTED_MODULE_13__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _transformations__WEBPACK_IMPORTED_MODULE_13__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","DefaultTimeZone","TIME_FORMAT","DefaultTimeRange","MappingType","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _transformations__WEBPACK_IMPORTED_MODULE_13__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _vector__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./vector */ "./packages/grafana-data/src/types/vector.ts");
/* harmony import */ var _vector__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_vector__WEBPACK_IMPORTED_MODULE_14__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _vector__WEBPACK_IMPORTED_MODULE_14__) if(["LoadingState","NullValueMode","FieldType","LogLevel","LogsMetaKind","LogsDedupStrategy","LogsDedupDescription","DefaultTimeZone","TIME_FORMAT","DefaultTimeRange","MappingType","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _vector__WEBPACK_IMPORTED_MODULE_14__[key]; }) }(__WEBPACK_IMPORT_KEY__));

















/***/ }),

/***/ "./packages/grafana-data/src/types/logs.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-data/src/types/logs.ts ***!
  \*************************************************/
/*! exports provided: LogLevel, LogsMetaKind, LogsDedupStrategy, LogsDedupDescription */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogLevel", function() { return LogLevel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogsMetaKind", function() { return LogsMetaKind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogsDedupStrategy", function() { return LogsDedupStrategy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogsDedupDescription", function() { return LogsDedupDescription; });
/**
 * Mapping of log level abbreviation to canonical log level.
 * Supported levels are reduce to limit color variation.
 */
var LogLevel;
(function (LogLevel) {
    LogLevel["emerg"] = "critical";
    LogLevel["alert"] = "critical";
    LogLevel["crit"] = "critical";
    LogLevel["critical"] = "critical";
    LogLevel["warn"] = "warning";
    LogLevel["warning"] = "warning";
    LogLevel["err"] = "error";
    LogLevel["eror"] = "error";
    LogLevel["error"] = "error";
    LogLevel["info"] = "info";
    LogLevel["notice"] = "info";
    LogLevel["dbug"] = "debug";
    LogLevel["debug"] = "debug";
    LogLevel["trace"] = "trace";
    LogLevel["unknown"] = "unknown";
})(LogLevel || (LogLevel = {}));
var LogsMetaKind;
(function (LogsMetaKind) {
    LogsMetaKind[LogsMetaKind["Number"] = 0] = "Number";
    LogsMetaKind[LogsMetaKind["String"] = 1] = "String";
    LogsMetaKind[LogsMetaKind["LabelsMap"] = 2] = "LabelsMap";
})(LogsMetaKind || (LogsMetaKind = {}));
var LogsDedupStrategy;
(function (LogsDedupStrategy) {
    LogsDedupStrategy["none"] = "none";
    LogsDedupStrategy["exact"] = "exact";
    LogsDedupStrategy["numbers"] = "numbers";
    LogsDedupStrategy["signature"] = "signature";
})(LogsDedupStrategy || (LogsDedupStrategy = {}));
var LogsDedupDescription;
(function (LogsDedupDescription) {
    LogsDedupDescription["none"] = "No de-duplication";
    LogsDedupDescription["exact"] = "De-duplication of successive lines that are identical, ignoring ISO datetimes.";
    LogsDedupDescription["numbers"] = "De-duplication of successive lines that are identical when ignoring numbers, e.g., IP addresses, latencies.";
    LogsDedupDescription["signature"] = "De-duplication of successive lines that have identical punctuation and whitespace.";
})(LogsDedupDescription || (LogsDedupDescription = {}));


/***/ }),

/***/ "./packages/grafana-data/src/types/navModel.ts":
/*!*****************************************************!*\
  !*** ./packages/grafana-data/src/types/navModel.ts ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/select.ts":
/*!***************************************************!*\
  !*** ./packages/grafana-data/src/types/select.ts ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/threshold.ts":
/*!******************************************************!*\
  !*** ./packages/grafana-data/src/types/threshold.ts ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/time.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-data/src/types/time.ts ***!
  \*************************************************/
/*! exports provided: DefaultTimeZone, TIME_FORMAT, DefaultTimeRange */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DefaultTimeZone", function() { return DefaultTimeZone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TIME_FORMAT", function() { return TIME_FORMAT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DefaultTimeRange", function() { return DefaultTimeRange; });
var DefaultTimeZone = 'browser';
var TIME_FORMAT = 'YYYY-MM-DD HH:mm:ss';
var DefaultTimeRange = {
    from: {},
    to: {},
    raw: { from: '6h', to: 'now' },
};


/***/ }),

/***/ "./packages/grafana-data/src/types/transformations.ts":
/*!************************************************************!*\
  !*** ./packages/grafana-data/src/types/transformations.ts ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/utils.ts":
/*!**************************************************!*\
  !*** ./packages/grafana-data/src/types/utils.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/types/valueMapping.ts":
/*!*********************************************************!*\
  !*** ./packages/grafana-data/src/types/valueMapping.ts ***!
  \*********************************************************/
/*! exports provided: MappingType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MappingType", function() { return MappingType; });
var MappingType;
(function (MappingType) {
    MappingType[MappingType["ValueToText"] = 1] = "ValueToText";
    MappingType[MappingType["RangeToText"] = 2] = "RangeToText";
})(MappingType || (MappingType = {}));


/***/ }),

/***/ "./packages/grafana-data/src/types/vector.ts":
/*!***************************************************!*\
  !*** ./packages/grafana-data/src/types/vector.ts ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-data/src/utils/Registry.ts":
/*!*****************************************************!*\
  !*** ./packages/grafana-data/src/utils/Registry.ts ***!
  \*****************************************************/
/*! exports provided: Registry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Registry", function() { return Registry; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

var Registry = /** @class */ (function () {
    function Registry(init) {
        this.init = init;
        this.ordered = [];
        this.byId = new Map();
        this.initalized = false;
    }
    Registry.prototype.getIfExists = function (id) {
        var e_1, _a;
        if (!this.initalized) {
            if (this.init) {
                try {
                    for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.init()), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var ext = _c.value;
                        this.register(ext);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            this.sort();
            this.initalized = true;
        }
        if (id) {
            return this.byId.get(id);
        }
        return undefined;
    };
    Registry.prototype.get = function (id) {
        var v = this.getIfExists(id);
        if (!v) {
            throw new Error('Undefined: ' + id);
        }
        return v;
    };
    Registry.prototype.selectOptions = function (current, filter) {
        var e_2, _a, e_3, _b;
        if (!this.initalized) {
            this.getIfExists('xxx'); // will trigger init
        }
        var select = {
            options: [],
            current: [],
        };
        var currentIds = {};
        if (current) {
            try {
                for (var current_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](current), current_1_1 = current_1.next(); !current_1_1.done; current_1_1 = current_1.next()) {
                    var id = current_1_1.value;
                    currentIds[id] = true;
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (current_1_1 && !current_1_1.done && (_a = current_1.return)) _a.call(current_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        try {
            for (var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.ordered), _d = _c.next(); !_d.done; _d = _c.next()) {
                var ext = _d.value;
                if (ext.excludeFromPicker) {
                    continue;
                }
                if (filter && !filter(ext)) {
                    continue;
                }
                var option = {
                    value: ext.id,
                    label: ext.name,
                    description: ext.description,
                };
                select.options.push(option);
                if (currentIds[ext.id]) {
                    select.current.push(option);
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return select;
    };
    /**
     * Return a list of values by ID, or all values if not specified
     */
    Registry.prototype.list = function (ids) {
        var e_4, _a;
        if (ids) {
            var found = [];
            try {
                for (var ids_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](ids), ids_1_1 = ids_1.next(); !ids_1_1.done; ids_1_1 = ids_1.next()) {
                    var id = ids_1_1.value;
                    var v = this.getIfExists(id);
                    if (v) {
                        found.push(v);
                    }
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (ids_1_1 && !ids_1_1.done && (_a = ids_1.return)) _a.call(ids_1);
                }
                finally { if (e_4) throw e_4.error; }
            }
            return found;
        }
        if (!this.initalized) {
            this.getIfExists('xxx'); // will trigger init
        }
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](this.ordered); // copy of everythign just in case
    };
    Registry.prototype.register = function (ext) {
        var e_5, _a;
        if (this.byId.has(ext.id)) {
            throw new Error('Duplicate Key:' + ext.id);
        }
        this.byId.set(ext.id, ext);
        this.ordered.push(ext);
        if (ext.aliasIds) {
            try {
                for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](ext.aliasIds), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var alias = _c.value;
                    if (!this.byId.has(alias)) {
                        this.byId.set(alias, ext);
                    }
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_5) throw e_5.error; }
            }
        }
        if (this.initalized) {
            this.sort();
        }
    };
    Registry.prototype.sort = function () {
        // TODO sort the list
    };
    return Registry;
}());



/***/ }),

/***/ "./packages/grafana-data/src/utils/csv.ts":
/*!************************************************!*\
  !*** ./packages/grafana-data/src/utils/csv.ts ***!
  \************************************************/
/*! exports provided: CSVHeaderStyle, readCSV, CSVReader, toCSV */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CSVHeaderStyle", function() { return CSVHeaderStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "readCSV", function() { return readCSV; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CSVReader", function() { return CSVReader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toCSV", function() { return toCSV; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var papaparse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! papaparse */ "./node_modules/papaparse/papaparse.min.js");
/* harmony import */ var papaparse__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(papaparse__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_defaults__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/defaults */ "./node_modules/lodash/defaults.js");
/* harmony import */ var lodash_defaults__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_defaults__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isNumber */ "./node_modules/lodash/isNumber.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isNumber__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../types */ "./packages/grafana-data/src/types/index.ts");
/* harmony import */ var _dataframe_processDataFrame__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dataframe/processDataFrame */ "./packages/grafana-data/src/dataframe/processDataFrame.ts");
/* harmony import */ var _dataframe_MutableDataFrame__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dataframe/MutableDataFrame */ "./packages/grafana-data/src/dataframe/MutableDataFrame.ts");

// Libraries



// Types



var CSVHeaderStyle;
(function (CSVHeaderStyle) {
    CSVHeaderStyle[CSVHeaderStyle["full"] = 0] = "full";
    CSVHeaderStyle[CSVHeaderStyle["name"] = 1] = "name";
    CSVHeaderStyle[CSVHeaderStyle["none"] = 2] = "none";
})(CSVHeaderStyle || (CSVHeaderStyle = {}));
function readCSV(csv, options) {
    return new CSVReader(options).readCSV(csv);
}
var ParseState;
(function (ParseState) {
    ParseState[ParseState["Starting"] = 0] = "Starting";
    ParseState[ParseState["InHeader"] = 1] = "InHeader";
    ParseState[ParseState["ReadingRows"] = 2] = "ReadingRows";
})(ParseState || (ParseState = {}));
var CSVReader = /** @class */ (function () {
    function CSVReader(options) {
        var _this = this;
        // PapaParse callback on each line
        this.step = function (results, parser) {
            var e_1, _a;
            for (var i = 0; i < results.data.length; i++) {
                var line = results.data[i];
                if (line.length < 1) {
                    continue;
                }
                var first = line[0]; // null or value, papaparse does not return ''
                if (first) {
                    // Comment or header queue
                    if (first.startsWith('#')) {
                        // Look for special header column
                        // #{columkey}#a,b,c
                        var idx = first.indexOf('#', 2);
                        if (idx > 0) {
                            var k = first.substr(1, idx - 1);
                            var isName = 'name' === k;
                            // Simple object used to check if headers match
                            var headerKeys = {
                                unit: '#',
                            };
                            // Check if it is a known/supported column
                            if (isName || headerKeys.hasOwnProperty(k)) {
                                // Starting a new table after reading rows
                                if (_this.state === ParseState.ReadingRows) {
                                    _this.current = new _dataframe_MutableDataFrame__WEBPACK_IMPORTED_MODULE_6__["MutableDataFrame"]({ fields: [] });
                                    _this.data.push(_this.current);
                                }
                                var v = first.substr(idx + 1);
                                if (isName) {
                                    _this.current.addFieldFor(undefined, v);
                                    for (var j = 1; j < line.length; j++) {
                                        _this.current.addFieldFor(undefined, line[j]);
                                    }
                                }
                                else {
                                    var fields = _this.current.fields;
                                    for (var j = 0; j < fields.length; j++) {
                                        if (!fields[j].config) {
                                            fields[j].config = {};
                                        }
                                        var disp = fields[j].config; // any lets name lookup
                                        disp[k] = j === 0 ? v : line[j];
                                    }
                                }
                                _this.state = ParseState.InHeader;
                                continue;
                            }
                        }
                        else if (_this.state === ParseState.Starting) {
                            _this.state = ParseState.InHeader;
                            continue;
                        }
                        // Ignore comment lines
                        continue;
                    }
                    if (_this.state === ParseState.Starting) {
                        var type = Object(_dataframe_processDataFrame__WEBPACK_IMPORTED_MODULE_5__["guessFieldTypeFromValue"])(first);
                        if (type === _types__WEBPACK_IMPORTED_MODULE_4__["FieldType"].string) {
                            try {
                                for (var line_1 = (e_1 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](line)), line_1_1 = line_1.next(); !line_1_1.done; line_1_1 = line_1.next()) {
                                    var s = line_1_1.value;
                                    _this.current.addFieldFor(undefined, s);
                                }
                            }
                            catch (e_1_1) { e_1 = { error: e_1_1 }; }
                            finally {
                                try {
                                    if (line_1_1 && !line_1_1.done && (_a = line_1.return)) _a.call(line_1);
                                }
                                finally { if (e_1) throw e_1.error; }
                            }
                            _this.state = ParseState.InHeader;
                            continue;
                        }
                        _this.state = ParseState.InHeader; // fall through to read rows
                    }
                }
                // Add the current results to the data
                if (_this.state !== ParseState.ReadingRows) {
                    // anything???
                }
                _this.state = ParseState.ReadingRows;
                // Make sure colum structure is valid
                if (line.length > _this.current.fields.length) {
                    var fields = _this.current.fields;
                    for (var f = fields.length; f < line.length; f++) {
                        _this.current.addFieldFor(line[f]);
                    }
                    if (_this.callback) {
                        _this.callback.onHeader(_this.current.fields);
                    }
                }
                _this.current.appendRow(line);
                if (_this.callback) {
                    // // Send the header after we guess the type
                    // if (this.series.rows.length === 0) {
                    //   this.callback.onHeader(this.series);
                    // }
                    _this.callback.onRow(line);
                }
            }
        };
        if (!options) {
            options = {};
        }
        this.config = options.config || {};
        this.callback = options.callback;
        this.current = new _dataframe_MutableDataFrame__WEBPACK_IMPORTED_MODULE_6__["MutableDataFrame"]({ fields: [] });
        this.state = ParseState.Starting;
        this.data = [];
    }
    CSVReader.prototype.readCSV = function (text) {
        this.current = new _dataframe_MutableDataFrame__WEBPACK_IMPORTED_MODULE_6__["MutableDataFrame"]({ fields: [] });
        this.data = [this.current];
        var papacfg = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, this.config, { dynamicTyping: false, skipEmptyLines: true, comments: false, step: this.step });
        papaparse__WEBPACK_IMPORTED_MODULE_1___default.a.parse(text, papacfg);
        return this.data;
    };
    return CSVReader;
}());

function writeValue(value, config) {
    var str = value.toString();
    if (str.includes('"')) {
        // Escape the double quote characters
        return config.quoteChar + str.replace(/"/gi, '""') + config.quoteChar;
    }
    if (str.includes('\n') || str.includes(config.delimiter)) {
        return config.quoteChar + str + config.quoteChar;
    }
    return str;
}
function makeFieldWriter(field, config) {
    if (field.type) {
        if (field.type === _types__WEBPACK_IMPORTED_MODULE_4__["FieldType"].boolean) {
            return function (value) {
                return value ? 'true' : 'false';
            };
        }
        if (field.type === _types__WEBPACK_IMPORTED_MODULE_4__["FieldType"].number) {
            return function (value) {
                if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_3___default()(value)) {
                    return value.toString();
                }
                return writeValue(value, config);
            };
        }
    }
    return function (value) { return writeValue(value, config); };
}
function getHeaderLine(key, fields, config) {
    var e_2, _a;
    var isName = 'name' === key;
    var isType = 'type' === key;
    try {
        for (var fields_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](fields), fields_1_1 = fields_1.next(); !fields_1_1.done; fields_1_1 = fields_1.next()) {
            var f = fields_1_1.value;
            var display = f.config;
            if (isName || isType || (display && display.hasOwnProperty(key))) {
                var line = '#' + key + '#';
                for (var i = 0; i < fields.length; i++) {
                    if (i > 0) {
                        line = line + config.delimiter;
                    }
                    var v = fields[i].name;
                    if (isType) {
                        v = fields[i].type;
                    }
                    else if (isName) {
                        // already name
                    }
                    else {
                        v = fields[i].config[key];
                    }
                    if (v) {
                        line = line + writeValue(v, config);
                    }
                }
                return line + config.newline;
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (fields_1_1 && !fields_1_1.done && (_a = fields_1.return)) _a.call(fields_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return '';
}
function toCSV(data, config) {
    var e_3, _a;
    if (!data) {
        return '';
    }
    var csv = '';
    config = lodash_defaults__WEBPACK_IMPORTED_MODULE_2___default()(config, {
        delimiter: ',',
        newline: '\r\n',
        quoteChar: '"',
        encoding: '',
        headerStyle: CSVHeaderStyle.name,
    });
    try {
        for (var data_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](data), data_1_1 = data_1.next(); !data_1_1.done; data_1_1 = data_1.next()) {
            var series = data_1_1.value;
            var fields = series.fields;
            if (config.headerStyle === CSVHeaderStyle.full) {
                csv =
                    csv +
                        getHeaderLine('name', fields, config) +
                        getHeaderLine('type', fields, config) +
                        getHeaderLine('unit', fields, config) +
                        getHeaderLine('dateFormat', fields, config);
            }
            else if (config.headerStyle === CSVHeaderStyle.name) {
                for (var i = 0; i < fields.length; i++) {
                    if (i > 0) {
                        csv += config.delimiter;
                    }
                    csv += fields[i].name;
                }
                csv += config.newline;
            }
            var length = fields[0].values.length;
            if (length > 0) {
                var writers = fields.map(function (field) { return makeFieldWriter(field, config); });
                for (var i = 0; i < length; i++) {
                    for (var j = 0; j < fields.length; j++) {
                        if (j > 0) {
                            csv = csv + config.delimiter;
                        }
                        var v = fields[j].values.get(i);
                        if (v !== null) {
                            csv = csv + writers[j](v);
                        }
                    }
                    csv = csv + config.newline;
                }
            }
            csv = csv + config.newline;
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (data_1_1 && !data_1_1.done && (_a = data_1.return)) _a.call(data_1);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return csv;
}


/***/ }),

/***/ "./packages/grafana-data/src/utils/deprecationWarning.ts":
/*!***************************************************************!*\
  !*** ./packages/grafana-data/src/utils/deprecationWarning.ts ***!
  \***************************************************************/
/*! exports provided: deprecationWarning */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deprecationWarning", function() { return deprecationWarning; });
// Avoid writing the warning message more than once every 10s
var history = {};
var deprecationWarning = function (file, oldName, newName) {
    var message = "[Deprecation warning] " + file + ": " + oldName + " is deprecated";
    if (newName) {
        message += ".  Use " + newName + " instead";
    }
    var now = Date.now();
    var last = history[message];
    if (!last || now - last > 10000) {
        console.warn(message);
        history[message] = now;
    }
};


/***/ }),

/***/ "./packages/grafana-data/src/utils/fieldParser.ts":
/*!********************************************************!*\
  !*** ./packages/grafana-data/src/utils/fieldParser.ts ***!
  \********************************************************/
/*! exports provided: makeFieldParser */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "makeFieldParser", function() { return makeFieldParser; });
/* harmony import */ var _types_dataFrame__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../types/dataFrame */ "./packages/grafana-data/src/types/dataFrame.ts");
/* harmony import */ var _dataframe_processDataFrame__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dataframe/processDataFrame */ "./packages/grafana-data/src/dataframe/processDataFrame.ts");


function makeFieldParser(value, field) {
    if (!field.type) {
        if (field.name === 'time' || field.name === 'Time') {
            field.type = _types_dataFrame__WEBPACK_IMPORTED_MODULE_0__["FieldType"].time;
        }
        else {
            field.type = Object(_dataframe_processDataFrame__WEBPACK_IMPORTED_MODULE_1__["guessFieldTypeFromValue"])(value);
        }
    }
    if (field.type === _types_dataFrame__WEBPACK_IMPORTED_MODULE_0__["FieldType"].number) {
        return function (value) {
            return parseFloat(value);
        };
    }
    // Will convert anything that starts with "T" to true
    if (field.type === _types_dataFrame__WEBPACK_IMPORTED_MODULE_0__["FieldType"].boolean) {
        return function (value) {
            return !(value[0] === 'F' || value[0] === 'f' || value[0] === '0');
        };
    }
    // Just pass the string back
    return function (value) { return value; };
}


/***/ }),

/***/ "./packages/grafana-data/src/utils/index.ts":
/*!**************************************************!*\
  !*** ./packages/grafana-data/src/utils/index.ts ***!
  \**************************************************/
/*! exports provided: Registry, deprecationWarning, CSVHeaderStyle, readCSV, CSVReader, toCSV, getLogLevel, getLogLevelFromKey, addLogLevelToSeries, calculateLogsLabelStats, LogsParsers, calculateFieldStats, getParser, parseLabels, findCommonLabels, findUniqueLabels, formatLabels, objRemoveUndefined, getActiveThreshold, sortThresholds, getMappedValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Registry__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Registry */ "./packages/grafana-data/src/utils/Registry.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Registry", function() { return _Registry__WEBPACK_IMPORTED_MODULE_0__["Registry"]; });

/* harmony import */ var _deprecationWarning__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./deprecationWarning */ "./packages/grafana-data/src/utils/deprecationWarning.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "deprecationWarning", function() { return _deprecationWarning__WEBPACK_IMPORTED_MODULE_1__["deprecationWarning"]; });

/* harmony import */ var _csv__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./csv */ "./packages/grafana-data/src/utils/csv.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CSVHeaderStyle", function() { return _csv__WEBPACK_IMPORTED_MODULE_2__["CSVHeaderStyle"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readCSV", function() { return _csv__WEBPACK_IMPORTED_MODULE_2__["readCSV"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CSVReader", function() { return _csv__WEBPACK_IMPORTED_MODULE_2__["CSVReader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toCSV", function() { return _csv__WEBPACK_IMPORTED_MODULE_2__["toCSV"]; });

/* harmony import */ var _logs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./logs */ "./packages/grafana-data/src/utils/logs.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLogLevel", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["getLogLevel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLogLevelFromKey", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["getLogLevelFromKey"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addLogLevelToSeries", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["addLogLevelToSeries"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "calculateLogsLabelStats", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["calculateLogsLabelStats"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogsParsers", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["LogsParsers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "calculateFieldStats", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["calculateFieldStats"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getParser", function() { return _logs__WEBPACK_IMPORTED_MODULE_3__["getParser"]; });

/* harmony import */ var _labels__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./labels */ "./packages/grafana-data/src/utils/labels.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseLabels", function() { return _labels__WEBPACK_IMPORTED_MODULE_4__["parseLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findCommonLabels", function() { return _labels__WEBPACK_IMPORTED_MODULE_4__["findCommonLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findUniqueLabels", function() { return _labels__WEBPACK_IMPORTED_MODULE_4__["findUniqueLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "formatLabels", function() { return _labels__WEBPACK_IMPORTED_MODULE_4__["formatLabels"]; });

/* empty/unused harmony star reexport *//* harmony import */ var _object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./object */ "./packages/grafana-data/src/utils/object.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "objRemoveUndefined", function() { return _object__WEBPACK_IMPORTED_MODULE_5__["objRemoveUndefined"]; });

/* harmony import */ var _thresholds__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./thresholds */ "./packages/grafana-data/src/utils/thresholds.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getActiveThreshold", function() { return _thresholds__WEBPACK_IMPORTED_MODULE_6__["getActiveThreshold"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sortThresholds", function() { return _thresholds__WEBPACK_IMPORTED_MODULE_6__["sortThresholds"]; });

/* harmony import */ var _valueMappings__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./valueMappings */ "./packages/grafana-data/src/utils/valueMappings.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMappedValue", function() { return _valueMappings__WEBPACK_IMPORTED_MODULE_7__["getMappedValue"]; });












/***/ }),

/***/ "./packages/grafana-data/src/utils/labels.ts":
/*!***************************************************!*\
  !*** ./packages/grafana-data/src/utils/labels.ts ***!
  \***************************************************/
/*! exports provided: parseLabels, findCommonLabels, findUniqueLabels, formatLabels */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parseLabels", function() { return parseLabels; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findCommonLabels", function() { return findCommonLabels; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findUniqueLabels", function() { return findUniqueLabels; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "formatLabels", function() { return formatLabels; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

/**
 * Regexp to extract Prometheus-style labels
 */
var labelRegexp = /\b(\w+)(!?=~?)"([^"\n]*?)"/g;
/**
 * Returns a map of label keys to value from an input selector string.
 *
 * Example: `parseLabels('{job="foo", instance="bar"}) // {job: "foo", instance: "bar"}`
 */
function parseLabels(labels) {
    var labelsByKey = {};
    labels.replace(labelRegexp, function (_, key, operator, value) {
        labelsByKey[key] = value;
        return '';
    });
    return labelsByKey;
}
/**
 * Returns a map labels that are common to the given label sets.
 */
function findCommonLabels(labelsSets) {
    return labelsSets.reduce(function (acc, labels) {
        if (!labels) {
            throw new Error('Need parsed labels to find common labels.');
        }
        if (!acc) {
            // Initial set
            acc = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, labels);
        }
        else {
            // Remove incoming labels that are missing or not matching in value
            Object.keys(labels).forEach(function (key) {
                if (acc[key] === undefined || acc[key] !== labels[key]) {
                    delete acc[key];
                }
            });
            // Remove common labels that are missing from incoming label set
            Object.keys(acc).forEach(function (key) {
                if (labels[key] === undefined) {
                    delete acc[key];
                }
            });
        }
        return acc;
    }, undefined);
}
/**
 * Returns a map of labels that are in `labels`, but not in `commonLabels`.
 */
function findUniqueLabels(labels, commonLabels) {
    var uncommonLabels = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, labels);
    Object.keys(commonLabels).forEach(function (key) {
        delete uncommonLabels[key];
    });
    return uncommonLabels;
}
/**
 * Serializes the given labels to a string.
 */
function formatLabels(labels, defaultValue) {
    if (defaultValue === void 0) { defaultValue = ''; }
    if (!labels || Object.keys(labels).length === 0) {
        return defaultValue;
    }
    var labelKeys = Object.keys(labels).sort();
    var cleanSelector = labelKeys.map(function (key) { return key + "=\"" + labels[key] + "\""; }).join(', ');
    return ['{', cleanSelector, '}'].join('');
}


/***/ }),

/***/ "./packages/grafana-data/src/utils/logs.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-data/src/utils/logs.ts ***!
  \*************************************************/
/*! exports provided: getLogLevel, getLogLevelFromKey, addLogLevelToSeries, calculateLogsLabelStats, LogsParsers, calculateFieldStats, getParser */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLogLevel", function() { return getLogLevel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLogLevelFromKey", function() { return getLogLevelFromKey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addLogLevelToSeries", function() { return addLogLevelToSeries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "calculateLogsLabelStats", function() { return calculateLogsLabelStats; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogsParsers", function() { return LogsParsers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "calculateFieldStats", function() { return calculateFieldStats; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getParser", function() { return getParser; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _types_logs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../types/logs */ "./packages/grafana-data/src/types/logs.ts");
/* harmony import */ var _types_index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../types/index */ "./packages/grafana-data/src/types/index.ts");
/* harmony import */ var _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vector/ArrayVector */ "./packages/grafana-data/src/vector/ArrayVector.ts");





var LOGFMT_REGEXP = /(?:^|\s)(\w+)=("[^"]*"|\S+)/;
/**
 * Returns the log level of a log line.
 * Parse the line for level words. If no level is found, it returns `LogLevel.unknown`.
 *
 * Example: `getLogLevel('WARN 1999-12-31 this is great') // LogLevel.warn`
 */
function getLogLevel(line) {
    var e_1, _a;
    if (!line) {
        return _types_logs__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].unknown;
    }
    try {
        for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](Object.keys(_types_logs__WEBPACK_IMPORTED_MODULE_2__["LogLevel"])), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            var regexp = new RegExp("\\b" + key + "\\b", 'i');
            if (regexp.test(line)) {
                var level = _types_logs__WEBPACK_IMPORTED_MODULE_2__["LogLevel"][key];
                if (level) {
                    return level;
                }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return _types_logs__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].unknown;
}
function getLogLevelFromKey(key) {
    var level = _types_logs__WEBPACK_IMPORTED_MODULE_2__["LogLevel"][key];
    if (level) {
        return level;
    }
    return _types_logs__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].unknown;
}
function addLogLevelToSeries(series, lineIndex) {
    var levels = new _vector_ArrayVector__WEBPACK_IMPORTED_MODULE_4__["ArrayVector"]();
    var lines = series.fields[lineIndex];
    for (var i = 0; i < lines.values.length; i++) {
        var line = lines.values.get(lineIndex);
        levels.buffer.push(getLogLevel(line));
    }
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, series, { fields: tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](series.fields, [
            {
                name: 'LogLevel',
                type: _types_index__WEBPACK_IMPORTED_MODULE_3__["FieldType"].string,
                values: levels,
                config: {},
            },
        ]) });
}
function calculateLogsLabelStats(rows, label) {
    // Consider only rows that have the given label
    var rowsWithLabel = rows.filter(function (row) { return row.labels[label] !== undefined; });
    var rowCount = rowsWithLabel.length;
    // Get label value counts for eligible rows
    var countsByValue = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["countBy"])(rowsWithLabel, function (row) { return row.labels[label]; });
    var sortedCounts = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["chain"])(countsByValue)
        .map(function (count, value) { return ({ count: count, value: value, proportion: count / rowCount }); })
        .sortBy('count')
        .reverse()
        .value();
    return sortedCounts;
}
var LogsParsers = {
    JSON: {
        buildMatcher: function (label) { return new RegExp("(?:{|,)\\s*\"" + label + "\"\\s*:\\s*\"?([\\d\\.]+|[^\"]*)\"?"); },
        getFields: function (line) {
            var fields = [];
            try {
                var parsed = JSON.parse(line);
                Object(lodash__WEBPACK_IMPORTED_MODULE_1__["map"])(parsed, function (value, key) {
                    var fieldMatcher = new RegExp("\"" + key + "\"\\s*:\\s*\"?" + Object(lodash__WEBPACK_IMPORTED_MODULE_1__["escapeRegExp"])(JSON.stringify(value)) + "\"?");
                    var match = line.match(fieldMatcher);
                    if (match) {
                        fields.push(match[0]);
                    }
                });
            }
            catch (_a) { }
            return fields;
        },
        getLabelFromField: function (field) { return (field.match(/^"(\w+)"\s*:/) || [])[1]; },
        getValueFromField: function (field) { return (field.match(/:\s*(.*)$/) || [])[1]; },
        test: function (line) {
            try {
                return JSON.parse(line);
            }
            catch (error) { }
        },
    },
    logfmt: {
        buildMatcher: function (label) { return new RegExp("(?:^|\\s)" + label + "=(\"[^\"]*\"|\\S+)"); },
        getFields: function (line) {
            var fields = [];
            line.replace(new RegExp(LOGFMT_REGEXP, 'g'), function (substring) {
                fields.push(substring.trim());
                return '';
            });
            return fields;
        },
        getLabelFromField: function (field) { return (field.match(LOGFMT_REGEXP) || [])[1]; },
        getValueFromField: function (field) { return (field.match(LOGFMT_REGEXP) || [])[2]; },
        test: function (line) { return LOGFMT_REGEXP.test(line); },
    },
};
function calculateFieldStats(rows, extractor) {
    // Consider only rows that satisfy the matcher
    var rowsWithField = rows.filter(function (row) { return extractor.test(row.entry); });
    var rowCount = rowsWithField.length;
    // Get field value counts for eligible rows
    var countsByValue = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["countBy"])(rowsWithField, function (r) {
        var row = r;
        var match = row.entry.match(extractor);
        return match ? match[1] : null;
    });
    var sortedCounts = Object(lodash__WEBPACK_IMPORTED_MODULE_1__["chain"])(countsByValue)
        .map(function (count, value) { return ({ count: count, value: value, proportion: count / rowCount }); })
        .sortBy('count')
        .reverse()
        .value();
    return sortedCounts;
}
function getParser(line) {
    var parser;
    try {
        if (LogsParsers.JSON.test(line)) {
            parser = LogsParsers.JSON;
        }
    }
    catch (error) { }
    if (!parser && LogsParsers.logfmt.test(line)) {
        parser = LogsParsers.logfmt;
    }
    return parser;
}


/***/ }),

/***/ "./packages/grafana-data/src/utils/object.ts":
/*!***************************************************!*\
  !*** ./packages/grafana-data/src/utils/object.ts ***!
  \***************************************************/
/*! exports provided: objRemoveUndefined */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "objRemoveUndefined", function() { return objRemoveUndefined; });
var objRemoveUndefined = function (obj) {
    return Object.keys(obj).reduce(function (acc, key) {
        if (obj[key] !== undefined) {
            acc[key] = obj[key];
        }
        return acc;
    }, {});
};


/***/ }),

/***/ "./packages/grafana-data/src/utils/thresholds.ts":
/*!*******************************************************!*\
  !*** ./packages/grafana-data/src/utils/thresholds.ts ***!
  \*******************************************************/
/*! exports provided: getActiveThreshold, sortThresholds */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getActiveThreshold", function() { return getActiveThreshold; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sortThresholds", function() { return sortThresholds; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

function getActiveThreshold(value, thresholds) {
    var e_1, _a;
    var active = thresholds[0];
    try {
        for (var thresholds_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](thresholds), thresholds_1_1 = thresholds_1.next(); !thresholds_1_1.done; thresholds_1_1 = thresholds_1.next()) {
            var threshold = thresholds_1_1.value;
            if (value >= threshold.value) {
                active = threshold;
            }
            else {
                break;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (thresholds_1_1 && !thresholds_1_1.done && (_a = thresholds_1.return)) _a.call(thresholds_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return active;
}
/**
 * Sorts the thresholds
 */
function sortThresholds(thresholds) {
    return thresholds.sort(function (t1, t2) {
        return t1.value - t2.value;
    });
}


/***/ }),

/***/ "./packages/grafana-data/src/utils/valueMappings.ts":
/*!**********************************************************!*\
  !*** ./packages/grafana-data/src/utils/valueMappings.ts ***!
  \**********************************************************/
/*! exports provided: getMappedValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMappedValue", function() { return getMappedValue; });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../types */ "./packages/grafana-data/src/types/index.ts");

var addValueToTextMappingText = function (allValueMappings, valueToTextMapping, value) {
    if (valueToTextMapping.value === undefined) {
        return allValueMappings;
    }
    if (value === null && valueToTextMapping.value && valueToTextMapping.value.toLowerCase() === 'null') {
        return allValueMappings.concat(valueToTextMapping);
    }
    var valueAsNumber = parseFloat(value);
    var valueToTextMappingAsNumber = parseFloat(valueToTextMapping.value);
    if (isNaN(valueAsNumber) || isNaN(valueToTextMappingAsNumber)) {
        return allValueMappings;
    }
    if (valueAsNumber !== valueToTextMappingAsNumber) {
        return allValueMappings;
    }
    return allValueMappings.concat(valueToTextMapping);
};
var addRangeToTextMappingText = function (allValueMappings, rangeToTextMapping, value) {
    if (rangeToTextMapping.from === undefined || rangeToTextMapping.to === undefined || value === undefined) {
        return allValueMappings;
    }
    if (value === null &&
        rangeToTextMapping.from &&
        rangeToTextMapping.to &&
        rangeToTextMapping.from.toLowerCase() === 'null' &&
        rangeToTextMapping.to.toLowerCase() === 'null') {
        return allValueMappings.concat(rangeToTextMapping);
    }
    var valueAsNumber = parseFloat(value);
    var fromAsNumber = parseFloat(rangeToTextMapping.from);
    var toAsNumber = parseFloat(rangeToTextMapping.to);
    if (isNaN(valueAsNumber) || isNaN(fromAsNumber) || isNaN(toAsNumber)) {
        return allValueMappings;
    }
    if (valueAsNumber >= fromAsNumber && valueAsNumber <= toAsNumber) {
        return allValueMappings.concat(rangeToTextMapping);
    }
    return allValueMappings;
};
var getAllFormattedValueMappings = function (valueMappings, value) {
    var allFormattedValueMappings = valueMappings.reduce(function (allValueMappings, valueMapping) {
        if (valueMapping.type === _types__WEBPACK_IMPORTED_MODULE_0__["MappingType"].ValueToText) {
            allValueMappings = addValueToTextMappingText(allValueMappings, valueMapping, value);
        }
        else if (valueMapping.type === _types__WEBPACK_IMPORTED_MODULE_0__["MappingType"].RangeToText) {
            allValueMappings = addRangeToTextMappingText(allValueMappings, valueMapping, value);
        }
        return allValueMappings;
    }, []);
    allFormattedValueMappings.sort(function (t1, t2) {
        return t1.id - t2.id;
    });
    return allFormattedValueMappings;
};
var getMappedValue = function (valueMappings, value) {
    return getAllFormattedValueMappings(valueMappings, value)[0];
};


/***/ }),

/***/ "./packages/grafana-data/src/vector/AppendedVectors.ts":
/*!*************************************************************!*\
  !*** ./packages/grafana-data/src/vector/AppendedVectors.ts ***!
  \*************************************************************/
/*! exports provided: AppendedVectors */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppendedVectors", function() { return AppendedVectors; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _vectorToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./vectorToArray */ "./packages/grafana-data/src/vector/vectorToArray.ts");


/**
 * This may be more trouble than it is worth.  This trades some computation time for
 * RAM -- rather than allocate a new array the size of all previous arrays, this just
 * points the correct index to their original array values
 */
var AppendedVectors = /** @class */ (function () {
    function AppendedVectors(startAt) {
        if (startAt === void 0) { startAt = 0; }
        this.length = 0;
        this.source = new Array();
        this.length = startAt;
    }
    /**
     * Make the vector look like it is this long
     */
    AppendedVectors.prototype.setLength = function (length) {
        var e_1, _a;
        if (length > this.length) {
            // make the vector longer (filling with undefined)
            this.length = length;
        }
        else if (length < this.length) {
            // make the array shorter
            var sources = new Array();
            try {
                for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.source), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var src = _c.value;
                    sources.push(src);
                    if (src.end > length) {
                        src.end = length;
                        break;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            this.source = sources;
            this.length = length;
        }
    };
    AppendedVectors.prototype.append = function (v) {
        var info = {
            start: this.length,
            end: this.length + v.length,
            values: v,
        };
        this.length = info.end;
        this.source.push(info);
        return info;
    };
    AppendedVectors.prototype.get = function (index) {
        for (var i = 0; i < this.source.length; i++) {
            var src = this.source[i];
            if (index >= src.start && index < src.end) {
                return src.values.get(index - src.start);
            }
        }
        return undefined;
    };
    AppendedVectors.prototype.toArray = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_1__["vectorToArray"])(this);
    };
    AppendedVectors.prototype.toJSON = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_1__["vectorToArray"])(this);
    };
    return AppendedVectors;
}());



/***/ }),

/***/ "./packages/grafana-data/src/vector/ArrayVector.ts":
/*!*********************************************************!*\
  !*** ./packages/grafana-data/src/vector/ArrayVector.ts ***!
  \*********************************************************/
/*! exports provided: ArrayVector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArrayVector", function() { return ArrayVector; });
var ArrayVector = /** @class */ (function () {
    function ArrayVector(buffer) {
        this.buffer = buffer ? buffer : [];
    }
    Object.defineProperty(ArrayVector.prototype, "length", {
        get: function () {
            return this.buffer.length;
        },
        enumerable: true,
        configurable: true
    });
    ArrayVector.prototype.add = function (value) {
        this.buffer.push(value);
    };
    ArrayVector.prototype.get = function (index) {
        return this.buffer[index];
    };
    ArrayVector.prototype.set = function (index, value) {
        this.buffer[index] = value;
    };
    ArrayVector.prototype.reverse = function () {
        this.buffer.reverse();
    };
    ArrayVector.prototype.toArray = function () {
        return this.buffer;
    };
    ArrayVector.prototype.toJSON = function () {
        return this.buffer;
    };
    return ArrayVector;
}());



/***/ }),

/***/ "./packages/grafana-data/src/vector/CircularVector.ts":
/*!************************************************************!*\
  !*** ./packages/grafana-data/src/vector/CircularVector.ts ***!
  \************************************************************/
/*! exports provided: CircularVector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CircularVector", function() { return CircularVector; });
/* harmony import */ var _vectorToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./vectorToArray */ "./packages/grafana-data/src/vector/vectorToArray.ts");

/**
 * Circular vector uses a single buffer to capture a stream of values
 * overwriting the oldest value on add.
 *
 * This supports addting to the 'head' or 'tail' and will grow the buffer
 * to match a configured capacity.
 */
var CircularVector = /** @class */ (function () {
    function CircularVector(options) {
        this.buffer = options.buffer || [];
        this.capacity = this.buffer.length;
        this.tail = 'head' !== options.append;
        this.index = 0;
        this.add = this.getAddFunction();
        if (options.capacity) {
            this.setCapacity(options.capacity);
        }
    }
    /**
     * This gets the appropriate add function depending on the buffer state:
     *  * head vs tail
     *  * growing buffer vs overwriting values
     */
    CircularVector.prototype.getAddFunction = function () {
        var _this = this;
        // When we are not at capacity, it should actually modify the buffer
        if (this.capacity > this.buffer.length) {
            if (this.tail) {
                return function (value) {
                    _this.buffer.push(value);
                    if (_this.buffer.length >= _this.capacity) {
                        _this.add = _this.getAddFunction();
                    }
                };
            }
            else {
                return function (value) {
                    _this.buffer.unshift(value);
                    if (_this.buffer.length >= _this.capacity) {
                        _this.add = _this.getAddFunction();
                    }
                };
            }
        }
        if (this.tail) {
            return function (value) {
                _this.buffer[_this.index] = value;
                _this.index = (_this.index + 1) % _this.buffer.length;
            };
        }
        // Append values to the head
        return function (value) {
            var idx = _this.index - 1;
            if (idx < 0) {
                idx = _this.buffer.length - 1;
            }
            _this.buffer[idx] = value;
            _this.index = idx;
        };
    };
    CircularVector.prototype.setCapacity = function (v) {
        if (this.capacity === v) {
            return;
        }
        // Make a copy so it is in order and new additions can be at the head or tail
        var copy = this.toArray();
        if (v > this.length) {
            this.buffer = copy;
        }
        else if (v < this.capacity) {
            // Shrink the buffer
            var delta = this.length - v;
            if (this.tail) {
                this.buffer = copy.slice(delta, copy.length); // Keep last items
            }
            else {
                this.buffer = copy.slice(0, copy.length - delta); // Keep first items
            }
        }
        this.capacity = v;
        this.index = 0;
        this.add = this.getAddFunction();
    };
    CircularVector.prototype.setAppendMode = function (mode) {
        var tail = 'head' !== mode;
        if (tail !== this.tail) {
            this.buffer = this.toArray().reverse();
            this.index = 0;
            this.tail = tail;
            this.add = this.getAddFunction();
        }
    };
    CircularVector.prototype.reverse = function () {
        this.buffer.reverse();
    };
    CircularVector.prototype.get = function (index) {
        return this.buffer[(index + this.index) % this.buffer.length];
    };
    CircularVector.prototype.set = function (index, value) {
        this.buffer[(index + this.index) % this.buffer.length] = value;
    };
    Object.defineProperty(CircularVector.prototype, "length", {
        get: function () {
            return this.buffer.length;
        },
        enumerable: true,
        configurable: true
    });
    CircularVector.prototype.toArray = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_0__["vectorToArray"])(this);
    };
    CircularVector.prototype.toJSON = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_0__["vectorToArray"])(this);
    };
    return CircularVector;
}());



/***/ }),

/***/ "./packages/grafana-data/src/vector/ConstantVector.ts":
/*!************************************************************!*\
  !*** ./packages/grafana-data/src/vector/ConstantVector.ts ***!
  \************************************************************/
/*! exports provided: ConstantVector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConstantVector", function() { return ConstantVector; });
var ConstantVector = /** @class */ (function () {
    function ConstantVector(value, len) {
        this.value = value;
        this.len = len;
    }
    Object.defineProperty(ConstantVector.prototype, "length", {
        get: function () {
            return this.len;
        },
        enumerable: true,
        configurable: true
    });
    ConstantVector.prototype.get = function (index) {
        return this.value;
    };
    ConstantVector.prototype.toArray = function () {
        var arr = new Array(this.length);
        return arr.fill(this.value);
    };
    ConstantVector.prototype.toJSON = function () {
        return this.toArray();
    };
    return ConstantVector;
}());



/***/ }),

/***/ "./packages/grafana-data/src/vector/ScaledVector.ts":
/*!**********************************************************!*\
  !*** ./packages/grafana-data/src/vector/ScaledVector.ts ***!
  \**********************************************************/
/*! exports provided: ScaledVector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ScaledVector", function() { return ScaledVector; });
/* harmony import */ var _vectorToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./vectorToArray */ "./packages/grafana-data/src/vector/vectorToArray.ts");

var ScaledVector = /** @class */ (function () {
    function ScaledVector(source, scale) {
        this.source = source;
        this.scale = scale;
    }
    Object.defineProperty(ScaledVector.prototype, "length", {
        get: function () {
            return this.source.length;
        },
        enumerable: true,
        configurable: true
    });
    ScaledVector.prototype.get = function (index) {
        return this.source.get(index) * this.scale;
    };
    ScaledVector.prototype.toArray = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_0__["vectorToArray"])(this);
    };
    ScaledVector.prototype.toJSON = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_0__["vectorToArray"])(this);
    };
    return ScaledVector;
}());



/***/ }),

/***/ "./packages/grafana-data/src/vector/SortedVector.ts":
/*!**********************************************************!*\
  !*** ./packages/grafana-data/src/vector/SortedVector.ts ***!
  \**********************************************************/
/*! exports provided: SortedVector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SortedVector", function() { return SortedVector; });
/* harmony import */ var _vectorToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./vectorToArray */ "./packages/grafana-data/src/vector/vectorToArray.ts");

/**
 * Values are returned in the order defined by the input parameter
 */
var SortedVector = /** @class */ (function () {
    function SortedVector(source, order) {
        this.source = source;
        this.order = order;
    }
    Object.defineProperty(SortedVector.prototype, "length", {
        get: function () {
            return this.source.length;
        },
        enumerable: true,
        configurable: true
    });
    SortedVector.prototype.get = function (index) {
        return this.source.get(this.order[index]);
    };
    SortedVector.prototype.toArray = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_0__["vectorToArray"])(this);
    };
    SortedVector.prototype.toJSON = function () {
        return Object(_vectorToArray__WEBPACK_IMPORTED_MODULE_0__["vectorToArray"])(this);
    };
    return SortedVector;
}());



/***/ }),

/***/ "./packages/grafana-data/src/vector/index.ts":
/*!***************************************************!*\
  !*** ./packages/grafana-data/src/vector/index.ts ***!
  \***************************************************/
/*! exports provided: AppendedVectors, ArrayVector, CircularVector, ConstantVector, ScaledVector, SortedVector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _AppendedVectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AppendedVectors */ "./packages/grafana-data/src/vector/AppendedVectors.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AppendedVectors", function() { return _AppendedVectors__WEBPACK_IMPORTED_MODULE_0__["AppendedVectors"]; });

/* harmony import */ var _ArrayVector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ArrayVector */ "./packages/grafana-data/src/vector/ArrayVector.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayVector", function() { return _ArrayVector__WEBPACK_IMPORTED_MODULE_1__["ArrayVector"]; });

/* harmony import */ var _CircularVector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircularVector */ "./packages/grafana-data/src/vector/CircularVector.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CircularVector", function() { return _CircularVector__WEBPACK_IMPORTED_MODULE_2__["CircularVector"]; });

/* harmony import */ var _ConstantVector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ConstantVector */ "./packages/grafana-data/src/vector/ConstantVector.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConstantVector", function() { return _ConstantVector__WEBPACK_IMPORTED_MODULE_3__["ConstantVector"]; });

/* harmony import */ var _ScaledVector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ScaledVector */ "./packages/grafana-data/src/vector/ScaledVector.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ScaledVector", function() { return _ScaledVector__WEBPACK_IMPORTED_MODULE_4__["ScaledVector"]; });

/* harmony import */ var _SortedVector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SortedVector */ "./packages/grafana-data/src/vector/SortedVector.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SortedVector", function() { return _SortedVector__WEBPACK_IMPORTED_MODULE_5__["SortedVector"]; });









/***/ }),

/***/ "./packages/grafana-data/src/vector/vectorToArray.ts":
/*!***********************************************************!*\
  !*** ./packages/grafana-data/src/vector/vectorToArray.ts ***!
  \***********************************************************/
/*! exports provided: vectorToArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "vectorToArray", function() { return vectorToArray; });
function vectorToArray(v) {
    var arr = [];
    for (var i = 0; i < v.length; i++) {
        arr[i] = v.get(i);
    }
    return arr;
}


/***/ }),

/***/ "./packages/grafana-runtime/src/config.ts":
/*!************************************************!*\
  !*** ./packages/grafana-runtime/src/config.ts ***!
  \************************************************/
/*! exports provided: GrafanaBootConfig, config */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GrafanaBootConfig", function() { return GrafanaBootConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "config", function() { return config; });
/* harmony import */ var lodash_extend__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/extend */ "./node_modules/lodash/extend.js");
/* harmony import */ var lodash_extend__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_extend__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _grafana_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @grafana/ui */ "./packages/grafana-ui/src/index.ts");


var GrafanaBootConfig = /** @class */ (function () {
    function GrafanaBootConfig(options) {
        this.datasources = {};
        this.panels = {};
        this.appSubUrl = '';
        this.windowTitlePrefix = '';
        this.buildInfo = {};
        this.newPanelTitle = '';
        this.externalUserMngLinkUrl = '';
        this.externalUserMngLinkName = '';
        this.externalUserMngInfo = '';
        this.allowOrgCreate = false;
        this.disableLoginForm = false;
        this.defaultDatasource = '';
        this.alertingEnabled = false;
        this.alertingErrorOrTimeout = '';
        this.alertingNoDataOrNullValues = '';
        this.authProxyEnabled = false;
        this.exploreEnabled = false;
        this.ldapEnabled = false;
        this.samlEnabled = false;
        this.disableUserSignUp = false;
        this.viewersCanEdit = false;
        this.editorsCanAdmin = false;
        this.disableSanitizeHtml = false;
        this.pluginsToPreload = [];
        this.featureToggles = {
            transformations: false,
        };
        this.theme = options.bootData.user.lightTheme ? Object(_grafana_ui__WEBPACK_IMPORTED_MODULE_1__["getTheme"])(_grafana_ui__WEBPACK_IMPORTED_MODULE_1__["GrafanaThemeType"].Light) : Object(_grafana_ui__WEBPACK_IMPORTED_MODULE_1__["getTheme"])(_grafana_ui__WEBPACK_IMPORTED_MODULE_1__["GrafanaThemeType"].Dark);
        var defaults = {
            datasources: {},
            windowTitlePrefix: 'Grafana - ',
            panels: {},
            newPanelTitle: 'Panel Title',
            playlist_timespan: '1m',
            unsaved_changes_warning: true,
            appSubUrl: '',
            buildInfo: {
                version: 'v1.0',
                commit: '1',
                env: 'production',
                isEnterprise: false,
            },
            viewersCanEdit: false,
            editorsCanAdmin: false,
            disableSanitizeHtml: false,
        };
        lodash_extend__WEBPACK_IMPORTED_MODULE_0___default()(this, defaults, options);
    }
    return GrafanaBootConfig;
}());

var bootData = window.grafanaBootData || {
    settings: {},
    user: {},
};
var options = bootData.settings;
options.bootData = bootData;
var config = new GrafanaBootConfig(options);


/***/ }),

/***/ "./packages/grafana-runtime/src/index.ts":
/*!***********************************************!*\
  !*** ./packages/grafana-runtime/src/index.ts ***!
  \***********************************************/
/*! exports provided: GrafanaBootConfig, config, loadPluginCss, SystemJS, setBackendSrv, getBackendSrv, setAngularLoader, getAngularLoader, setDataSourceSrv, getDataSourceSrv, setLocationSrv, getLocationSrv */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./services */ "./packages/grafana-runtime/src/services/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setBackendSrv", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["setBackendSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getBackendSrv", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["getBackendSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setAngularLoader", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["setAngularLoader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getAngularLoader", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["getAngularLoader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setDataSourceSrv", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["setDataSourceSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDataSourceSrv", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["getDataSourceSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setLocationSrv", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["setLocationSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLocationSrv", function() { return _services__WEBPACK_IMPORTED_MODULE_0__["getLocationSrv"]; });

/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./config */ "./packages/grafana-runtime/src/config.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GrafanaBootConfig", function() { return _config__WEBPACK_IMPORTED_MODULE_1__["GrafanaBootConfig"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "config", function() { return _config__WEBPACK_IMPORTED_MODULE_1__["config"]; });

/* harmony import */ var _utils_plugin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/plugin */ "./packages/grafana-runtime/src/utils/plugin.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadPluginCss", function() { return _utils_plugin__WEBPACK_IMPORTED_MODULE_2__["loadPluginCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SystemJS", function() { return _utils_plugin__WEBPACK_IMPORTED_MODULE_2__["SystemJS"]; });






/***/ }),

/***/ "./packages/grafana-runtime/src/services/AngularLoader.ts":
/*!****************************************************************!*\
  !*** ./packages/grafana-runtime/src/services/AngularLoader.ts ***!
  \****************************************************************/
/*! exports provided: setAngularLoader, getAngularLoader */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAngularLoader", function() { return setAngularLoader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getAngularLoader", function() { return getAngularLoader; });
var instance;
function setAngularLoader(v) {
    instance = v;
}
function getAngularLoader() {
    return instance;
}


/***/ }),

/***/ "./packages/grafana-runtime/src/services/LocationSrv.ts":
/*!**************************************************************!*\
  !*** ./packages/grafana-runtime/src/services/LocationSrv.ts ***!
  \**************************************************************/
/*! exports provided: setLocationSrv, getLocationSrv */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setLocationSrv", function() { return setLocationSrv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLocationSrv", function() { return getLocationSrv; });
var singletonInstance;
function setLocationSrv(instance) {
    singletonInstance = instance;
}
function getLocationSrv() {
    return singletonInstance;
}


/***/ }),

/***/ "./packages/grafana-runtime/src/services/backendSrv.ts":
/*!*************************************************************!*\
  !*** ./packages/grafana-runtime/src/services/backendSrv.ts ***!
  \*************************************************************/
/*! exports provided: setBackendSrv, getBackendSrv */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setBackendSrv", function() { return setBackendSrv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getBackendSrv", function() { return getBackendSrv; });
var singletonInstance;
function setBackendSrv(instance) {
    singletonInstance = instance;
}
function getBackendSrv() {
    return singletonInstance;
}


/***/ }),

/***/ "./packages/grafana-runtime/src/services/dataSourceSrv.ts":
/*!****************************************************************!*\
  !*** ./packages/grafana-runtime/src/services/dataSourceSrv.ts ***!
  \****************************************************************/
/*! exports provided: setDataSourceSrv, getDataSourceSrv */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setDataSourceSrv", function() { return setDataSourceSrv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDataSourceSrv", function() { return getDataSourceSrv; });
var singletonInstance;
function setDataSourceSrv(instance) {
    singletonInstance = instance;
}
function getDataSourceSrv() {
    return singletonInstance;
}


/***/ }),

/***/ "./packages/grafana-runtime/src/services/index.ts":
/*!********************************************************!*\
  !*** ./packages/grafana-runtime/src/services/index.ts ***!
  \********************************************************/
/*! exports provided: setBackendSrv, getBackendSrv, setAngularLoader, getAngularLoader, setDataSourceSrv, getDataSourceSrv, setLocationSrv, getLocationSrv */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _backendSrv__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./backendSrv */ "./packages/grafana-runtime/src/services/backendSrv.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setBackendSrv", function() { return _backendSrv__WEBPACK_IMPORTED_MODULE_0__["setBackendSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getBackendSrv", function() { return _backendSrv__WEBPACK_IMPORTED_MODULE_0__["getBackendSrv"]; });

/* harmony import */ var _AngularLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AngularLoader */ "./packages/grafana-runtime/src/services/AngularLoader.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setAngularLoader", function() { return _AngularLoader__WEBPACK_IMPORTED_MODULE_1__["setAngularLoader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getAngularLoader", function() { return _AngularLoader__WEBPACK_IMPORTED_MODULE_1__["getAngularLoader"]; });

/* harmony import */ var _dataSourceSrv__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dataSourceSrv */ "./packages/grafana-runtime/src/services/dataSourceSrv.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setDataSourceSrv", function() { return _dataSourceSrv__WEBPACK_IMPORTED_MODULE_2__["setDataSourceSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDataSourceSrv", function() { return _dataSourceSrv__WEBPACK_IMPORTED_MODULE_2__["getDataSourceSrv"]; });

/* harmony import */ var _LocationSrv__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./LocationSrv */ "./packages/grafana-runtime/src/services/LocationSrv.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setLocationSrv", function() { return _LocationSrv__WEBPACK_IMPORTED_MODULE_3__["setLocationSrv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLocationSrv", function() { return _LocationSrv__WEBPACK_IMPORTED_MODULE_3__["getLocationSrv"]; });







/***/ }),

/***/ "./packages/grafana-runtime/src/utils/plugin.ts":
/*!******************************************************!*\
  !*** ./packages/grafana-runtime/src/utils/plugin.ts ***!
  \******************************************************/
/*! exports provided: SystemJS, loadPluginCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SystemJS", function() { return SystemJS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadPluginCss", function() { return loadPluginCss; });
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../config */ "./packages/grafana-runtime/src/config.ts");
/* harmony import */ var systemjs_dist_system_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! systemjs/dist/system.js */ "./node_modules/systemjs/dist/system.js");
/* harmony import */ var systemjs_dist_system_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(systemjs_dist_system_js__WEBPACK_IMPORTED_MODULE_1__);

// @ts-ignore

var SystemJS = systemjs_dist_system_js__WEBPACK_IMPORTED_MODULE_1___default.a;
function loadPluginCss(options) {
    var theme = _config__WEBPACK_IMPORTED_MODULE_0__["config"].bootData.user.lightTheme ? options.light : options.dark;
    return SystemJS.import(theme + "!css");
}


/***/ }),

/***/ "./packages/grafana-ui/src/components/Alert/Alert.tsx":
/*!************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Alert/Alert.tsx ***!
  \************************************************************/
/*! exports provided: Alert */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Alert", function() { return Alert; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var Alert = function (props) {
    var title = props.title, button = props.button, children = props.children;
    return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "alert-container" },
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "alert-error alert" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "alert-icon" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", { className: "fa fa-exclamation-triangle" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "alert-body" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "alert-title" }, title),
                children && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "alert-text" }, children)),
            button && (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "alert-button" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-outline-danger", onClick: button.onClick }, button.text))))));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/AlphaNotice/AlphaNotice.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/AlphaNotice/AlphaNotice.tsx ***!
  \************************************************************************/
/*! exports provided: AlphaNotice */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AlphaNotice", function() { return AlphaNotice; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../index */ "./packages/grafana-ui/src/index.ts");




var AlphaNotice = function (_a) {
    var state = _a.state, text = _a.text, className = _a.className;
    var tooltipContent = text || 'This feature is a work in progress and updates may include breaking changes';
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]);
    var styles = Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])(className, Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      background: linear-gradient(to bottom, ", ", ", ");\n      color: ", ";\n      white-space: nowrap;\n      border-radius: 3px;\n      text-shadow: none;\n      font-size: 13px;\n      padding: 4px 8px;\n      cursor: help;\n      display: inline-block;\n    "], ["\n      background: linear-gradient(to bottom, ", ", ", ");\n      color: ", ";\n      white-space: nowrap;\n      border-radius: 3px;\n      text-shadow: none;\n      font-size: 13px;\n      padding: 4px 8px;\n      cursor: help;\n      display: inline-block;\n    "])), theme.colors.blueBase, theme.colors.blueShade, theme.colors.gray7));
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles, title: tooltipContent },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-warning" }),
        " ",
        state));
};
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/BarGauge/BarGauge.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/BarGauge/BarGauge.tsx ***!
  \******************************************************************/
/*! exports provided: BarGauge, getTitleStyles, getValuePercent, getBasicAndGradientStyles, getBarGradient, getValueColor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BarGauge", function() { return BarGauge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTitleStyles", function() { return getTitleStyles; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getValuePercent", function() { return getValuePercent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getBasicAndGradientStyles", function() { return getBasicAndGradientStyles; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getBarGradient", function() { return getBarGradient; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getValueColor", function() { return getValueColor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(tinycolor2__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils */ "./packages/grafana-ui/src/utils/index.ts");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../types */ "./packages/grafana-ui/src/types/index.ts");

// Library



// Utils

// Types

var MIN_VALUE_HEIGHT = 18;
var MAX_VALUE_HEIGHT = 50;
var MIN_VALUE_WIDTH = 50;
var MAX_VALUE_WIDTH = 150;
var TITLE_LINE_HEIGHT = 1.5;
var VALUE_LINE_HEIGHT = 1;
var BarGauge = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](BarGauge, _super);
    function BarGauge() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BarGauge.prototype.render = function () {
        var _a = this.props, onClick = _a.onClick, className = _a.className;
        var title = this.props.value.title;
        var styles = getTitleStyles(this.props);
        if (!title) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: styles.wrapper, onClick: onClick, className: className }, this.renderBarAndValue()));
        }
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: styles.wrapper, onClick: onClick, className: className },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: styles.title }, title),
            this.renderBarAndValue()));
    };
    BarGauge.prototype.renderBarAndValue = function () {
        switch (this.props.displayMode) {
            case 'lcd':
                return this.renderRetroBars();
            case 'basic':
            case 'gradient':
            default:
                return this.renderBasicAndGradientBars();
        }
    };
    BarGauge.prototype.renderBasicAndGradientBars = function () {
        var value = this.props.value;
        var styles = getBasicAndGradientStyles(this.props);
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: styles.wrapper },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "bar-gauge__value", style: styles.value }, value.text),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: styles.bar })));
    };
    BarGauge.prototype.getCellColor = function (positionValue) {
        var _a = this.props, thresholds = _a.thresholds, theme = _a.theme, value = _a.value;
        if (positionValue === null) {
            return {
                background: 'gray',
                border: 'gray',
            };
        }
        var activeThreshold = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["getActiveThreshold"])(positionValue, thresholds);
        if (activeThreshold !== null) {
            var color = Object(_utils__WEBPACK_IMPORTED_MODULE_4__["getColorFromHexRgbOrName"])(activeThreshold.color, theme.type);
            // if we are past real value the cell is not "on"
            if (value === null || (positionValue !== null && positionValue > value.numeric)) {
                return {
                    background: tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(color)
                        .setAlpha(0.18)
                        .toRgbString(),
                    border: 'transparent',
                    isLit: false,
                };
            }
            else {
                return {
                    background: tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(color)
                        .setAlpha(0.95)
                        .toRgbString(),
                    backgroundShade: tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(color)
                        .setAlpha(0.55)
                        .toRgbString(),
                    border: tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(color)
                        .setAlpha(0.9)
                        .toRgbString(),
                    isLit: true,
                };
            }
        }
        return {
            background: 'gray',
            border: 'gray',
        };
    };
    BarGauge.prototype.renderRetroBars = function () {
        var _a = this.props, maxValue = _a.maxValue, minValue = _a.minValue, value = _a.value, itemSpacing = _a.itemSpacing;
        var _b = calculateBarAndValueDimensions(this.props), valueHeight = _b.valueHeight, valueWidth = _b.valueWidth, maxBarHeight = _b.maxBarHeight, maxBarWidth = _b.maxBarWidth, wrapperWidth = _b.wrapperWidth, wrapperHeight = _b.wrapperHeight;
        var isVert = isVertical(this.props);
        var valueRange = maxValue - minValue;
        var maxSize = isVert ? maxBarHeight : maxBarWidth;
        var cellSpacing = itemSpacing;
        var cellWidth = 12;
        var cellCount = Math.floor(maxSize / cellWidth);
        var cellSize = Math.floor((maxSize - cellSpacing * cellCount) / cellCount);
        var valueColor = getValueColor(this.props);
        var valueStyles = getValueStyles(value.text, valueColor, valueWidth, valueHeight);
        var containerStyles = {
            width: wrapperWidth + "px",
            height: wrapperHeight + "px",
            display: 'flex',
        };
        if (isVert) {
            containerStyles.flexDirection = 'column-reverse';
            containerStyles.alignItems = 'center';
            valueStyles.justifyContent = 'center';
        }
        else {
            containerStyles.flexDirection = 'row';
            containerStyles.alignItems = 'center';
            valueStyles.justifyContent = 'flex-end';
        }
        var cells = [];
        for (var i = 0; i < cellCount; i++) {
            var currentValue = minValue + (valueRange / cellCount) * i;
            var cellColor = this.getCellColor(currentValue);
            var cellStyles = {
                borderRadius: '2px',
            };
            if (cellColor.isLit) {
                cellStyles.backgroundImage = "radial-gradient(" + cellColor.background + " 10%, " + cellColor.backgroundShade + ")";
            }
            else {
                cellStyles.backgroundColor = cellColor.background;
            }
            if (isVert) {
                cellStyles.height = cellSize + "px";
                cellStyles.width = maxBarWidth + "px";
                cellStyles.marginTop = cellSpacing + "px";
            }
            else {
                cellStyles.width = cellSize + "px";
                cellStyles.height = maxBarHeight + "px";
                cellStyles.marginRight = cellSpacing + "px";
            }
            cells.push(react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { key: i.toString(), style: cellStyles }));
        }
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: containerStyles },
            cells,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "bar-gauge__value", style: valueStyles }, value.text)));
    };
    BarGauge.defaultProps = {
        maxValue: 100,
        minValue: 0,
        value: {
            text: '100',
            numeric: 100,
        },
        displayMode: 'lcd',
        orientation: _types__WEBPACK_IMPORTED_MODULE_5__["VizOrientation"].Horizontal,
        thresholds: [],
        itemSpacing: 10,
    };
    return BarGauge;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

function isVertical(props) {
    return props.orientation === _types__WEBPACK_IMPORTED_MODULE_5__["VizOrientation"].Vertical;
}
function calculateTitleDimensions(props) {
    var title = props.value.title;
    var height = props.height, width = props.width;
    if (!title) {
        return { fontSize: 0, width: 0, height: 0, placement: 'above' };
    }
    if (isVertical(props)) {
        return {
            fontSize: 14,
            width: width,
            height: 14 * TITLE_LINE_HEIGHT,
            placement: 'below',
        };
    }
    // if height above 40 put text to above bar
    if (height > 40) {
        var maxTitleHeightRatio_1 = 0.35;
        var titleHeight_1 = Math.max(Math.min(height * maxTitleHeightRatio_1, MAX_VALUE_HEIGHT), 17);
        return {
            fontSize: titleHeight_1 / TITLE_LINE_HEIGHT,
            width: 0,
            height: titleHeight_1,
            placement: 'above',
        };
    }
    // title to left of bar scenario
    var maxTitleHeightRatio = 0.6;
    var maxTitleWidthRatio = 0.2;
    var titleHeight = Math.max(height * maxTitleHeightRatio, MIN_VALUE_HEIGHT);
    return {
        fontSize: titleHeight / TITLE_LINE_HEIGHT,
        height: 0,
        width: Math.min(Math.max(width * maxTitleWidthRatio, 50), 200),
        placement: 'left',
    };
}
function getTitleStyles(props) {
    var wrapperStyles = {
        display: 'flex',
        overflow: 'hidden',
    };
    var titleDim = calculateTitleDimensions(props);
    var titleStyles = {
        fontSize: titleDim.fontSize + "px",
        whiteSpace: 'nowrap',
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        width: '100%',
        alignItems: 'center',
        alignSelf: 'center',
    };
    if (isVertical(props)) {
        wrapperStyles.flexDirection = 'column-reverse';
        titleStyles.textAlign = 'center';
    }
    else {
        if (titleDim.placement === 'above') {
            wrapperStyles.flexDirection = 'column';
        }
        else {
            wrapperStyles.flexDirection = 'row';
            titleStyles.width = titleDim.width + "px";
            titleStyles.textAlign = 'right';
            titleStyles.paddingRight = '10px';
        }
    }
    return {
        wrapper: wrapperStyles,
        title: titleStyles,
    };
}
function calculateBarAndValueDimensions(props) {
    var height = props.height, width = props.width;
    var titleDim = calculateTitleDimensions(props);
    var maxBarHeight = 0;
    var maxBarWidth = 0;
    var valueHeight = 0;
    var valueWidth = 0;
    var wrapperWidth = 0;
    var wrapperHeight = 0;
    if (isVertical(props)) {
        valueHeight = Math.min(Math.max(height * 0.1, MIN_VALUE_HEIGHT), MAX_VALUE_HEIGHT);
        valueWidth = width;
        maxBarHeight = height - (titleDim.height + valueHeight);
        maxBarWidth = width;
        wrapperWidth = width;
        wrapperHeight = height - titleDim.height;
    }
    else {
        valueHeight = height - titleDim.height;
        valueWidth = Math.max(Math.min(width * 0.2, MAX_VALUE_WIDTH), MIN_VALUE_WIDTH);
        maxBarHeight = height - titleDim.height;
        maxBarWidth = width - valueWidth - titleDim.width;
        if (titleDim.placement === 'above') {
            wrapperWidth = width;
            wrapperHeight = height - titleDim.height;
        }
        else {
            wrapperWidth = width - titleDim.width;
            wrapperHeight = height;
        }
    }
    return {
        valueWidth: valueWidth,
        valueHeight: valueHeight,
        maxBarWidth: maxBarWidth,
        maxBarHeight: maxBarHeight,
        wrapperHeight: wrapperHeight,
        wrapperWidth: wrapperWidth,
    };
}
function getValuePercent(value, minValue, maxValue) {
    return Math.min((value - minValue) / (maxValue - minValue), 1);
}
/**
 * Only exported to for unit test
 */
function getBasicAndGradientStyles(props) {
    var displayMode = props.displayMode, maxValue = props.maxValue, minValue = props.minValue, value = props.value;
    var _a = calculateBarAndValueDimensions(props), valueWidth = _a.valueWidth, valueHeight = _a.valueHeight, maxBarHeight = _a.maxBarHeight, maxBarWidth = _a.maxBarWidth;
    var valuePercent = getValuePercent(value.numeric, minValue, maxValue);
    var valueColor = getValueColor(props);
    var valueStyles = getValueStyles(value.text, valueColor, valueWidth, valueHeight);
    var isBasic = displayMode === 'basic';
    var wrapperStyles = {
        display: 'flex',
    };
    var barStyles = {
        borderRadius: '3px',
    };
    if (isVertical(props)) {
        var barHeight = Math.max(valuePercent * maxBarHeight, 1);
        // vertical styles
        wrapperStyles.flexDirection = 'column';
        wrapperStyles.justifyContent = 'flex-end';
        barStyles.transition = 'height 1s';
        barStyles.height = barHeight + "px";
        barStyles.width = maxBarWidth + "px";
        // value styles centered
        valueStyles.justifyContent = 'center';
        if (isBasic) {
            // Basic styles
            barStyles.background = "" + tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(valueColor)
                .setAlpha(0.25)
                .toRgbString();
            barStyles.borderTop = "2px solid " + valueColor;
        }
        else {
            // Gradient styles
            barStyles.background = getBarGradient(props, maxBarHeight);
        }
    }
    else {
        var barWidth = Math.max(valuePercent * maxBarWidth, 1);
        // Custom styles for horizontal orientation
        wrapperStyles.flexDirection = 'row-reverse';
        wrapperStyles.justifyContent = 'flex-end';
        wrapperStyles.alignItems = 'center';
        barStyles.transition = 'width 1s';
        barStyles.height = maxBarHeight + "px";
        barStyles.width = barWidth + "px";
        valueStyles.paddingLeft = '10px';
        if (isBasic) {
            // Basic styles
            barStyles.background = "" + tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(valueColor)
                .setAlpha(0.25)
                .toRgbString();
            barStyles.borderRight = "2px solid " + valueColor;
        }
        else {
            // Gradient styles
            barStyles.background = getBarGradient(props, maxBarWidth);
        }
    }
    return {
        wrapper: wrapperStyles,
        bar: barStyles,
        value: valueStyles,
    };
}
/**
 * Only exported to for unit test
 */
function getBarGradient(props, maxSize) {
    var minValue = props.minValue, maxValue = props.maxValue, thresholds = props.thresholds, value = props.value;
    var cssDirection = isVertical(props) ? '0deg' : '90deg';
    var gradient = '';
    var lastpos = 0;
    for (var i = 0; i < thresholds.length; i++) {
        var threshold = thresholds[i];
        var color = Object(_utils__WEBPACK_IMPORTED_MODULE_4__["getColorFromHexRgbOrName"])(threshold.color);
        var valuePercent = getValuePercent(threshold.value, minValue, maxValue);
        var pos = valuePercent * maxSize;
        var offset = Math.round(pos - (pos - lastpos) / 2);
        if (gradient === '') {
            gradient = "linear-gradient(" + cssDirection + ", " + color + ", " + color;
        }
        else if (value.numeric < threshold.value) {
            break;
        }
        else {
            lastpos = pos;
            gradient += " " + offset + "px, " + color;
        }
    }
    return gradient + ')';
}
/**
 * Only exported to for unit test
 */
function getValueColor(props) {
    var thresholds = props.thresholds, theme = props.theme, value = props.value;
    var activeThreshold = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["getActiveThreshold"])(value.numeric, thresholds);
    if (activeThreshold !== null) {
        return Object(_utils__WEBPACK_IMPORTED_MODULE_4__["getColorFromHexRgbOrName"])(activeThreshold.color, theme.type);
    }
    return Object(_utils__WEBPACK_IMPORTED_MODULE_4__["getColorFromHexRgbOrName"])('gray', theme.type);
}
/**
 * Only exported to for unit test
 */
function getValueStyles(value, color, width, height) {
    var heightFont = height / VALUE_LINE_HEIGHT;
    var guess = width / (value.length * 1.1);
    var fontSize = Math.min(Math.max(guess, 14), heightFont);
    return {
        color: color,
        height: height + "px",
        width: width + "px",
        display: 'flex',
        alignItems: 'center',
        lineHeight: VALUE_LINE_HEIGHT,
        fontSize: fontSize.toFixed(4) + 'px',
    };
}
// function getTextWidth(text: string): number {
//   const canvas = getTextWidth.canvas || (getTextWidth.canvas = document.createElement("canvas"));
//   var context = canvas.getContext("2d");
//   context.font = "'Roboto', 'Helvetica Neue', Arial, sans-serif";
//   var metrics = context.measureText(text);
//   return metrics.width;
// }


/***/ }),

/***/ "./packages/grafana-ui/src/components/BigValue/BigValue.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/BigValue/BigValue.tsx ***!
  \******************************************************************/
/*! exports provided: BigValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BigValue", function() { return BigValue; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils */ "./packages/grafana-ui/src/utils/index.ts");
/* harmony import */ var _themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/stylesFactory */ "./packages/grafana-ui/src/themes/stylesFactory.ts");

// Library



// Utils


var getStyles = Object(_themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__["stylesFactory"])(function () {
    return {
        wrapper: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      position: 'relative';\n      display: 'table';\n    "], ["\n      position: 'relative';\n      display: 'table';\n    "]))),
        title: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      line-height: 1;\n      text-align: 'center';\n      z-index: 1;\n      display: 'block';\n      width: '100%';\n      position: 'absolute';\n    "], ["\n      line-height: 1;\n      text-align: 'center';\n      z-index: 1;\n      display: 'block';\n      width: '100%';\n      position: 'absolute';\n    "]))),
        value: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      line-height: 1;\n      text-align: 'center';\n      z-index: 1;\n      display: 'table-cell';\n      vertical-align: 'middle';\n      position: 'relative';\n      font-size: '3em';\n      font-weight: 500;\n    "], ["\n      line-height: 1;\n      text-align: 'center';\n      z-index: 1;\n      display: 'table-cell';\n      vertical-align: 'middle';\n      position: 'relative';\n      font-size: '3em';\n      font-weight: 500;\n    "]))),
    };
});
/*
 * This visualization is still in POC state, needed more tests & better structure
 */
var BigValue = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](BigValue, _super);
    function BigValue() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderText = function (value, padding) {
            if (!value || !value.text) {
                return null;
            }
            var css = {};
            if (padding) {
                css.padding = padding;
            }
            if (value.color) {
                css.color = value.color;
            }
            if (value.fontSize) {
                css.fontSize = value.fontSize;
            }
            return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { style: css }, value.text);
        };
        return _this;
    }
    BigValue.prototype.componentDidMount = function () {
        this.draw();
    };
    BigValue.prototype.componentDidUpdate = function () {
        this.draw();
    };
    BigValue.prototype.draw = function () {
        var _a = this.props, sparkline = _a.sparkline, theme = _a.theme;
        if (sparkline && this.canvasElement) {
            var data = sparkline.data, minX = sparkline.minX, maxX = sparkline.maxX, fillColor = sparkline.fillColor, lineColor = sparkline.lineColor;
            var options = {
                legend: { show: false },
                series: {
                    lines: {
                        show: true,
                        fill: 1,
                        zero: false,
                        lineWidth: 1,
                        fillColor: Object(_utils__WEBPACK_IMPORTED_MODULE_4__["getColorFromHexRgbOrName"])(fillColor, theme.type),
                    },
                },
                yaxes: { show: false },
                xaxis: {
                    show: false,
                    min: minX,
                    max: maxX,
                },
                grid: { hoverable: false, show: false },
            };
            var plotSeries = {
                data: data,
                color: Object(_utils__WEBPACK_IMPORTED_MODULE_4__["getColorFromHexRgbOrName"])(lineColor, theme.type),
            };
            try {
                jquery__WEBPACK_IMPORTED_MODULE_2___default.a.plot(this.canvasElement, [plotSeries], options);
            }
            catch (err) {
                console.log('sparkline rendering error', err, options);
            }
        }
    };
    BigValue.prototype.renderSparkline = function (sparkline) {
        var _this = this;
        var _a = this.props, height = _a.height, width = _a.width;
        var plotCss = {};
        plotCss.position = 'absolute';
        plotCss.bottom = '0px';
        plotCss.left = '0px';
        plotCss.width = width + 'px';
        if (sparkline.full) {
            var dynamicHeightMargin = height <= 100 ? 5 : Math.round(height / 100) * 15 + 5;
            plotCss.height = height - dynamicHeightMargin + 'px';
        }
        else {
            plotCss.height = Math.floor(height * 0.25) + 'px';
        }
        return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: plotCss, ref: function (element) { return (_this.canvasElement = element); } });
    };
    BigValue.prototype.render = function () {
        var _a = this.props, height = _a.height, width = _a.width, value = _a.value, prefix = _a.prefix, suffix = _a.suffix, sparkline = _a.sparkline, backgroundColor = _a.backgroundColor, onClick = _a.onClick, className = _a.className;
        var styles = getStyles();
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["cx"])(styles.wrapper, className), style: { width: width, height: height, backgroundColor: backgroundColor }, onClick: onClick },
            value.title && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.title }, value.title),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: styles.value },
                this.renderText(prefix, '0px 2px 0px 0px'),
                this.renderText(value),
                this.renderText(suffix)),
            sparkline && this.renderSparkline(sparkline)));
    };
    return BigValue;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

var templateObject_1, templateObject_2, templateObject_3;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Button/AbstractButton.tsx":
/*!**********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Button/AbstractButton.tsx ***!
  \**********************************************************************/
/*! exports provided: AbstractButton */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AbstractButton", function() { return AbstractButton; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(tinycolor2__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");
/* harmony import */ var _themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/stylesFactory */ "./packages/grafana-ui/src/themes/stylesFactory.ts");






var buttonVariantStyles = function (from, to, textColor, textShadowColor, invert) {
    if (textShadowColor === void 0) { textShadowColor = 'rgba(0, 0, 0, 0.1)'; }
    if (invert === void 0) { invert = false; }
    return Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n  background: linear-gradient(to bottom, ", ", ", ");\n  color: ", ";\n  text-shadow: 0 ", " ", ";\n  &:hover {\n    background: ", ";\n    color: ", ";\n  }\n\n  &:focus {\n    background: ", ";\n    outline: none;\n  }\n"], ["\n  background: linear-gradient(to bottom, ", ", ", ");\n  color: ", ";\n  text-shadow: 0 ", " ", ";\n  &:hover {\n    background: ", ";\n    color: ", ";\n  }\n\n  &:focus {\n    background: ", ";\n    outline: none;\n  }\n"])), from, to, textColor, invert ? '1px' : '-1px', textShadowColor, from, textColor, from);
};
var getButtonStyles = Object(_themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__["stylesFactory"])(function (_a) {
    var theme = _a.theme, size = _a.size, variant = _a.variant, withIcon = _a.withIcon;
    var borderRadius = theme.border.radius.sm;
    var padding, background, fontSize, iconDistance, height, fontWeight = theme.typography.weight.semibold;
    switch (size) {
        case 'sm':
            padding = theme.spacing.xs + " " + theme.spacing.sm;
            fontSize = theme.typography.size.sm;
            iconDistance = theme.spacing.xs;
            height = theme.height.sm;
            break;
        case 'md':
            padding = theme.spacing.sm + " " + theme.spacing.md;
            fontSize = theme.typography.size.md;
            iconDistance = theme.spacing.sm;
            height = theme.height.md;
            break;
        case 'lg':
            padding = theme.spacing.md + " " + theme.spacing.lg;
            fontSize = theme.typography.size.lg;
            fontWeight = theme.typography.weight.regular;
            iconDistance = theme.spacing.sm;
            height = theme.height.lg;
            break;
        default:
            padding = theme.spacing.sm + " " + theme.spacing.md;
            iconDistance = theme.spacing.sm;
            fontSize = theme.typography.size.base;
            height = theme.height.md;
    }
    switch (variant) {
        case 'primary':
            background = buttonVariantStyles(theme.colors.greenBase, theme.colors.greenShade, theme.colors.white);
            break;
        case 'secondary':
            background = buttonVariantStyles(theme.colors.blueBase, theme.colors.blueShade, theme.colors.white);
            break;
        case 'danger':
            background = buttonVariantStyles(theme.colors.redBase, theme.colors.redShade, theme.colors.white);
            break;
        case 'inverse':
            var from = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({ light: theme.colors.gray5, dark: theme.colors.dark6 }, theme.type);
            var to = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
                light: tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(from)
                    .darken(5)
                    .toString(),
                dark: tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(from)
                    .lighten(4)
                    .toString(),
            }, theme.type);
            background = buttonVariantStyles(from, to, theme.colors.link, 'rgba(0, 0, 0, 0.1)', true);
            break;
        case 'transparent':
            background = Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n        ", ";\n        background: transparent;\n      "], ["\n        ", ";\n        background: transparent;\n      "])), buttonVariantStyles('', '', theme.colors.link, 'rgba(0, 0, 0, 0.1)', true));
            break;
    }
    return {
        button: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: button;\n      display: inline-flex;\n      align-items: center;\n      font-weight: ", ";\n      font-size: ", ";\n      font-family: ", ";\n      line-height: ", ";\n      padding: ", ";\n      text-align: ", ";\n      vertical-align: middle;\n      cursor: pointer;\n      border: none;\n      height: ", ";\n      border-radius: ", ";\n      ", ";\n\n      &[disabled],\n      &:disabled {\n        cursor: not-allowed;\n        opacity: 0.65;\n        box-shadow: none;\n      }\n    "], ["\n      label: button;\n      display: inline-flex;\n      align-items: center;\n      font-weight: ", ";\n      font-size: ", ";\n      font-family: ", ";\n      line-height: ", ";\n      padding: ", ";\n      text-align: ", ";\n      vertical-align: middle;\n      cursor: pointer;\n      border: none;\n      height: ", ";\n      border-radius: ", ";\n      ", ";\n\n      &[disabled],\n      &:disabled {\n        cursor: not-allowed;\n        opacity: 0.65;\n        box-shadow: none;\n      }\n    "])), fontWeight, fontSize, theme.typography.fontFamily.sansSerif, theme.typography.lineHeight.xs, padding, withIcon ? 'left' : 'center', height, borderRadius, background),
        iconWrap: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: button-icon-wrap;\n      display: flex;\n      align-items: center;\n    "], ["\n      label: button-icon-wrap;\n      display: flex;\n      align-items: center;\n    "]))),
        icon: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: button-icon;\n      margin-right: ", ";\n      filter: brightness(100);\n    "], ["\n      label: button-icon;\n      margin-right: ", ";\n      filter: brightness(100);\n    "])), iconDistance),
    };
});
var AbstractButton = function (_a) {
    var renderAs = _a.renderAs, theme = _a.theme, _b = _a.size, size = _b === void 0 ? 'md' : _b, _c = _a.variant, variant = _c === void 0 ? 'primary' : _c, className = _a.className, icon = _a.icon, children = _a.children, otherProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["renderAs", "theme", "size", "variant", "className", "icon", "children"]);
    var buttonStyles = getButtonStyles({ theme: theme, size: size, variant: variant, withIcon: !!icon });
    var nonHtmlProps = {
        theme: theme,
        size: size,
        variant: variant,
    };
    var finalClassName = Object(emotion__WEBPACK_IMPORTED_MODULE_3__["cx"])(buttonStyles.button, className);
    var finalChildren = icon ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: buttonStyles.iconWrap },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["cx"])([icon, buttonStyles.icon]) }),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, children))) : (children);
    var finalProps = typeof renderAs === 'string'
        ? tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, otherProps, { className: finalClassName, children: finalChildren }) : tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, otherProps, nonHtmlProps, { className: finalClassName, children: finalChildren });
    return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(renderAs, finalProps);
};
AbstractButton.displayName = 'AbstractButton';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Button/Button.tsx":
/*!**************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Button/Button.tsx ***!
  \**************************************************************/
/*! exports provided: Button, LinkButton */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Button", function() { return Button; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LinkButton", function() { return LinkButton; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _AbstractButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AbstractButton */ "./packages/grafana-ui/src/components/Button/AbstractButton.tsx");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");




var Button = function (props) {
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]);
    return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_AbstractButton__WEBPACK_IMPORTED_MODULE_2__["AbstractButton"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props, { renderAs: "button", theme: theme }));
};
Button.displayName = 'Button';
var LinkButton = function (props) {
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]);
    return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_AbstractButton__WEBPACK_IMPORTED_MODULE_2__["AbstractButton"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props, { renderAs: "a", theme: theme }));
};
LinkButton.displayName = 'LinkButton';


/***/ }),

/***/ "./packages/grafana-ui/src/components/CallToActionCard/CallToActionCard.tsx":
/*!**********************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/CallToActionCard/CallToActionCard.tsx ***!
  \**********************************************************************************/
/*! exports provided: CallToActionCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CallToActionCard", function() { return CallToActionCard; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");





var getCallToActionCardStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_4__["stylesFactory"])(function (theme) { return ({
    wrapper: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: call-to-action-card;\n    padding: ", ";\n    background: ", ";\n    border-radius: ", ";\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n  "], ["\n    label: call-to-action-card;\n    padding: ", ";\n    background: ", ";\n    border-radius: ", ";\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n  "])), theme.spacing.lg, Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_2__["selectThemeVariant"])({ light: theme.colors.gray6, dark: theme.colors.grayBlue }, theme.type), theme.border.radius.md),
    message: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    margin-bottom: ", ";\n    font-style: italic;\n  "], ["\n    margin-bottom: ", ";\n    font-style: italic;\n  "])), theme.spacing.lg),
    footer: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    margin-top: ", ";\n  "], ["\n    margin-top: ", ";\n  "])), theme.spacing.lg),
}); });
var CallToActionCard = function (_a) {
    var message = _a.message, callToActionElement = _a.callToActionElement, footer = _a.footer, theme = _a.theme, className = _a.className;
    var css = getCallToActionCardStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["cx"])([css.wrapper, className]) },
        message && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: css.message }, message),
        callToActionElement,
        footer && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: css.footer }, footer)));
};
var templateObject_1, templateObject_2, templateObject_3;


/***/ }),

/***/ "./packages/grafana-ui/src/components/ClickOutsideWrapper/ClickOutsideWrapper.tsx":
/*!****************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ClickOutsideWrapper/ClickOutsideWrapper.tsx ***!
  \****************************************************************************************/
/*! exports provided: ClickOutsideWrapper */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ClickOutsideWrapper", function() { return ClickOutsideWrapper; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_2__);



var ClickOutsideWrapper = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ClickOutsideWrapper, _super);
    function ClickOutsideWrapper() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            hasEventListener: false,
        };
        _this.onOutsideClick = function (event) {
            var domNode = react_dom__WEBPACK_IMPORTED_MODULE_2___default.a.findDOMNode(_this);
            if (!domNode || !domNode.contains(event.target)) {
                _this.props.onClick();
            }
        };
        return _this;
    }
    ClickOutsideWrapper.prototype.componentDidMount = function () {
        window.addEventListener('click', this.onOutsideClick, false);
    };
    ClickOutsideWrapper.prototype.componentWillUnmount = function () {
        window.removeEventListener('click', this.onOutsideClick, false);
    };
    ClickOutsideWrapper.prototype.render = function () {
        return this.props.children;
    };
    return ClickOutsideWrapper;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Collapse/Collapse.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Collapse/Collapse.tsx ***!
  \******************************************************************/
/*! exports provided: Collapse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Collapse", function() { return Collapse; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var _themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/stylesFactory */ "./packages/grafana-ui/src/themes/stylesFactory.ts");






var getStyles = Object(_themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__["stylesFactory"])(function (theme) { return ({
    collapse: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse;\n    margin-top: ", ";\n  "], ["\n    label: collapse;\n    margin-top: ", ";\n  "])), theme.spacing.sm),
    collapseBody: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__body;\n    padding: ", "px;\n  "], ["\n    label: collapse__body;\n    padding: ", "px;\n  "])), theme.panelPadding),
    loader: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__loader;\n    height: 2px;\n    position: relative;\n    overflow: hidden;\n    background: none;\n    margin: ", ";\n  "], ["\n    label: collapse__loader;\n    height: 2px;\n    position: relative;\n    overflow: hidden;\n    background: none;\n    margin: ", ";\n  "])), theme.spacing.xs),
    loaderActive: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__loader_active;\n    &:after {\n      content: ' ';\n      display: block;\n      width: 25%;\n      top: 0;\n      top: -50%;\n      height: 250%;\n      position: absolute;\n      animation: loader 2s cubic-bezier(0.17, 0.67, 0.83, 0.67) 500ms;\n      animation-iteration-count: 100;\n      left: -25%;\n      background: ", ";\n    }\n    @keyframes loader {\n      from {\n        left: -25%;\n        opacity: 0.1;\n      }\n      to {\n        left: 100%;\n        opacity: 1;\n      }\n    }\n  "], ["\n    label: collapse__loader_active;\n    &:after {\n      content: ' ';\n      display: block;\n      width: 25%;\n      top: 0;\n      top: -50%;\n      height: 250%;\n      position: absolute;\n      animation: loader 2s cubic-bezier(0.17, 0.67, 0.83, 0.67) 500ms;\n      animation-iteration-count: 100;\n      left: -25%;\n      background: ", ";\n    }\n    @keyframes loader {\n      from {\n        left: -25%;\n        opacity: 0.1;\n      }\n      to {\n        left: 100%;\n        opacity: 1;\n      }\n    }\n  "])), theme.colors.blue),
    header: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__header;\n    padding: ", " ", " 0 ", ";\n    display: flex;\n    cursor: inherit;\n    transition: all 0.1s linear;\n    cursor: pointer;\n  "], ["\n    label: collapse__header;\n    padding: ", " ", " 0 ", ";\n    display: flex;\n    cursor: inherit;\n    transition: all 0.1s linear;\n    cursor: pointer;\n  "])), theme.spacing.sm, theme.spacing.md, theme.spacing.md),
    headerCollapsed: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__header--collapsed;\n    cursor: pointer;\n    padding: ", " ", " 0 ", ";\n  "], ["\n    label: collapse__header--collapsed;\n    cursor: pointer;\n    padding: ", " ", " 0 ", ";\n  "])), theme.spacing.sm, theme.spacing.md, theme.spacing.md),
    headerButtons: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_7 || (templateObject_7 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__header-buttons;\n    margin-right: ", ";\n    font-size: ", ";\n    line-height: ", ";\n    display: inherit;\n  "], ["\n    label: collapse__header-buttons;\n    margin-right: ", ";\n    font-size: ", ";\n    line-height: ", ";\n    display: inherit;\n  "])), theme.spacing.sm, theme.typography.size.lg, theme.typography.heading.h6),
    headerButtonsCollapsed: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_8 || (templateObject_8 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__header-buttons--collapsed;\n    display: none;\n  "], ["\n    label: collapse__header-buttons--collapsed;\n    display: none;\n  "]))),
    headerLabel: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_9 || (templateObject_9 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: collapse__header-label;\n    font-weight: ", ";\n    margin-right: ", ";\n    font-size: ", ";\n    box-shadow: ", ";\n  "], ["\n    label: collapse__header-label;\n    font-weight: ", ";\n    margin-right: ", ";\n    font-size: ", ";\n    box-shadow: ", ";\n  "])), theme.typography.weight.semibold, theme.spacing.sm, theme.typography.heading.h6, Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_3__["selectThemeVariant"])({ light: 'none', dark: '1px 1px 4px rgb(45, 45, 45)' }, theme.type)),
}); });
var Collapse = function (_a) {
    var isOpen = _a.isOpen, label = _a.label, loading = _a.loading, collapsible = _a.collapsible, onToggle = _a.onToggle, children = _a.children;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"]);
    var style = getStyles(theme);
    var onClickToggle = function () {
        if (onToggle) {
            onToggle(!isOpen);
        }
    };
    var panelClass = Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.collapse, 'panel-container']);
    var iconClass = isOpen ? 'fa fa-caret-up' : 'fa fa-caret-down';
    var loaderClass = loading ? Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.loader, style.loaderActive]) : Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.loader]);
    var headerClass = collapsible ? Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.header]) : Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.headerCollapsed]);
    var headerButtonsClass = collapsible ? Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.headerButtons]) : Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.headerButtonsCollapsed]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: panelClass },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: headerClass, onClick: onClickToggle },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: headerButtonsClass },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: iconClass })),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.headerLabel]) }, label)),
        isOpen && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.collapseBody]) },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: loaderClass }),
            children))));
};
Collapse.displayName = 'Collapse';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7, templateObject_8, templateObject_9;


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/ColorInput.tsx":
/*!***********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/ColorInput.tsx ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(tinycolor2__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/debounce */ "./node_modules/lodash/debounce.js");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Input_Input__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Input/Input */ "./packages/grafana-ui/src/components/Input/Input.tsx");





var ColorInput = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ColorInput, _super);
    function ColorInput(props) {
        var _this = _super.call(this, props) || this;
        _this.updateColor = function (color) {
            _this.props.onChange(color);
        };
        _this.onChange = function (event) {
            var newColor = tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(event.currentTarget.value);
            _this.setState({
                value: event.currentTarget.value,
            });
            if (newColor.isValid()) {
                _this.updateColor(newColor.toString());
            }
        };
        _this.onBlur = function () {
            var newColor = tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(_this.state.value);
            if (!newColor.isValid()) {
                _this.setState({
                    value: _this.props.color,
                });
            }
        };
        _this.state = {
            previousColor: props.color,
            value: props.color,
        };
        _this.updateColor = lodash_debounce__WEBPACK_IMPORTED_MODULE_3___default()(_this.updateColor, 100);
        return _this;
    }
    ColorInput.getDerivedStateFromProps = function (props, state) {
        var newColor = tinycolor2__WEBPACK_IMPORTED_MODULE_2___default()(props.color);
        if (newColor.isValid() && props.color !== state.previousColor) {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, state, { previousColor: props.color, value: newColor.toString() });
        }
        return state;
    };
    ColorInput.prototype.render = function () {
        var value = this.state.value;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ display: 'flex' }, this.props.style) },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                    background: this.props.color,
                    width: '35px',
                    height: '35px',
                    flexGrow: 0,
                    borderRadius: '3px 0 0 3px',
                } }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                    flexGrow: 1,
                } },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Input_Input__WEBPACK_IMPORTED_MODULE_4__["Input"], { className: "gf-form-input", value: value, onChange: this.onChange, onBlur: this.onBlur }))));
    };
    return ColorInput;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));
/* harmony default export */ __webpack_exports__["default"] = (ColorInput);


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/ColorPicker.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/ColorPicker.tsx ***!
  \************************************************************************/
/*! exports provided: colorPickerFactory, ColorPicker, SeriesColorPicker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "colorPickerFactory", function() { return colorPickerFactory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColorPicker", function() { return ColorPicker; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPicker", function() { return SeriesColorPicker; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/omit */ "./node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Tooltip_PopoverController__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Tooltip/PopoverController */ "./packages/grafana-ui/src/components/Tooltip/PopoverController.tsx");
/* harmony import */ var _Tooltip_Popover__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Tooltip/Popover */ "./packages/grafana-ui/src/components/Tooltip/Popover.tsx");
/* harmony import */ var _ColorPickerPopover__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ColorPickerPopover */ "./packages/grafana-ui/src/components/ColorPicker/ColorPickerPopover.tsx");
/* harmony import */ var _utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/namedColorsPalette */ "./packages/grafana-ui/src/utils/namedColorsPalette.ts");
/* harmony import */ var _SeriesColorPickerPopover__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SeriesColorPickerPopover */ "./packages/grafana-ui/src/components/ColorPicker/SeriesColorPickerPopover.tsx");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var _ColorPickerTrigger__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ColorPickerTrigger */ "./packages/grafana-ui/src/components/ColorPicker/ColorPickerTrigger.tsx");










var colorPickerFactory = function (popover, displayName) {
    if (displayName === void 0) { displayName = 'ColorPicker'; }
    var _a;
    return _a = /** @class */ (function (_super) {
            tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ColorPicker, _super);
            function ColorPicker() {
                var _this = _super !== null && _super.apply(this, arguments) || this;
                _this.pickerTriggerRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["createRef"])();
                _this.onColorChange = function (color) {
                    var _a = _this.props, onColorChange = _a.onColorChange, onChange = _a.onChange;
                    var changeHandler = (onColorChange || onChange);
                    return changeHandler(color);
                };
                return _this;
            }
            ColorPicker.prototype.render = function () {
                var _this = this;
                var _a = this.props, theme = _a.theme, children = _a.children;
                var popoverElement = react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(popover, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, lodash_omit__WEBPACK_IMPORTED_MODULE_2___default()(this.props, 'children'), { onChange: this.onColorChange }));
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Tooltip_PopoverController__WEBPACK_IMPORTED_MODULE_3__["PopoverController"], { content: popoverElement, hideAfter: 300 }, function (showPopper, hidePopper, popperProps) {
                    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
                        _this.pickerTriggerRef.current && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Tooltip_Popover__WEBPACK_IMPORTED_MODULE_4__["Popover"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, popperProps, { referenceElement: _this.pickerTriggerRef.current, wrapperClassName: "ColorPicker", onMouseLeave: hidePopper, onMouseEnter: showPopper }))),
                        children ? (
                        // Children have a bit weird type due to intersection used in the definition so we need to cast here,
                        // but the definition is correct and should not allow to pass a children that does not conform to
                        // ColorPickerTriggerRenderer type.
                        children({
                            ref: _this.pickerTriggerRef,
                            showColorPicker: showPopper,
                            hideColorPicker: hidePopper,
                        })) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ColorPickerTrigger__WEBPACK_IMPORTED_MODULE_9__["ColorPickerTrigger"], { ref: _this.pickerTriggerRef, onClick: showPopper, onMouseLeave: hidePopper, color: Object(_utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_6__["getColorFromHexRgbOrName"])(_this.props.color || '#000000', theme.type) }))));
                }));
            };
            return ColorPicker;
        }(react__WEBPACK_IMPORTED_MODULE_1__["Component"])),
        _a.displayName = displayName,
        _a;
};
var ColorPicker = Object(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_8__["withTheme"])(colorPickerFactory(_ColorPickerPopover__WEBPACK_IMPORTED_MODULE_5__["ColorPickerPopover"], 'ColorPicker'));
var SeriesColorPicker = Object(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_8__["withTheme"])(colorPickerFactory(_SeriesColorPickerPopover__WEBPACK_IMPORTED_MODULE_7__["SeriesColorPickerPopover"], 'SeriesColorPicker'));


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/ColorPickerPopover.tsx":
/*!*******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/ColorPickerPopover.tsx ***!
  \*******************************************************************************/
/*! exports provided: ColorPickerPopover */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColorPickerPopover", function() { return ColorPickerPopover; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _NamedColorsPalette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./NamedColorsPalette */ "./packages/grafana-ui/src/components/ColorPicker/NamedColorsPalette.tsx");
/* harmony import */ var _utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/namedColorsPalette */ "./packages/grafana-ui/src/utils/namedColorsPalette.ts");
/* harmony import */ var _SpectrumPalette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SpectrumPalette */ "./packages/grafana-ui/src/components/ColorPicker/SpectrumPalette.tsx");
/* harmony import */ var _types_theme__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../types/theme */ "./packages/grafana-ui/src/types/theme.ts");
/* harmony import */ var _warnAboutColorPickerPropsDeprecation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./warnAboutColorPickerPropsDeprecation */ "./packages/grafana-ui/src/components/ColorPicker/warnAboutColorPickerPropsDeprecation.ts");







var ColorPickerPopover = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ColorPickerPopover, _super);
    function ColorPickerPopover(props) {
        var _this = _super.call(this, props) || this;
        _this.getTabClassName = function (tabName) {
            var activePicker = _this.state.activePicker;
            return "ColorPickerPopover__tab " + (activePicker === tabName && 'ColorPickerPopover__tab--active');
        };
        _this.handleChange = function (color) {
            var _a = _this.props, onColorChange = _a.onColorChange, onChange = _a.onChange, enableNamedColors = _a.enableNamedColors, theme = _a.theme;
            var changeHandler = onColorChange || onChange;
            if (enableNamedColors) {
                return changeHandler(color);
            }
            changeHandler(Object(_utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(color, theme.type));
        };
        _this.onTabChange = function (tab) {
            return function () { return _this.setState({ activePicker: tab }); };
        };
        _this.renderPicker = function () {
            var activePicker = _this.state.activePicker;
            var _a = _this.props, color = _a.color, theme = _a.theme;
            switch (activePicker) {
                case 'spectrum':
                    return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_SpectrumPalette__WEBPACK_IMPORTED_MODULE_4__["default"], { color: color, onChange: _this.handleChange, theme: theme });
                case 'palette':
                    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_NamedColorsPalette__WEBPACK_IMPORTED_MODULE_2__["NamedColorsPalette"], { color: Object(_utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__["getColorName"])(color, theme.type), onChange: _this.handleChange, theme: theme }));
                default:
                    return _this.renderCustomPicker(activePicker);
            }
        };
        _this.renderCustomPicker = function (tabKey) {
            var _a = _this.props, customPickers = _a.customPickers, color = _a.color, theme = _a.theme;
            if (!customPickers) {
                return null;
            }
            return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(customPickers[tabKey].tabComponent, {
                color: color,
                theme: theme,
                onChange: _this.handleChange,
            });
        };
        _this.renderCustomPickerTabs = function () {
            var customPickers = _this.props.customPickers;
            if (!customPickers) {
                return null;
            }
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null, Object.keys(customPickers).map(function (key) {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: _this.getTabClassName(key), onClick: _this.onTabChange(key), key: key }, customPickers[key].name));
            })));
        };
        _this.state = {
            activePicker: 'palette',
        };
        Object(_warnAboutColorPickerPropsDeprecation__WEBPACK_IMPORTED_MODULE_6__["warnAboutColorPickerPropsDeprecation"])('ColorPickerPopover', props);
        return _this;
    }
    ColorPickerPopover.prototype.render = function () {
        var theme = this.props.theme;
        var colorPickerTheme = theme.type || _types_theme__WEBPACK_IMPORTED_MODULE_5__["GrafanaThemeType"].Dark;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "ColorPickerPopover ColorPickerPopover--" + colorPickerTheme },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "ColorPickerPopover__tabs" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: this.getTabClassName('palette'), onClick: this.onTabChange('palette') }, "Colors"),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: this.getTabClassName('spectrum'), onClick: this.onTabChange('spectrum') }, "Custom"),
                this.renderCustomPickerTabs()),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "ColorPickerPopover__content" }, this.renderPicker())));
    };
    return ColorPickerPopover;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.Component));



/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/ColorPickerTrigger.tsx":
/*!*******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/ColorPickerTrigger.tsx ***!
  \*******************************************************************************/
/*! exports provided: ColorPickerTrigger */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColorPickerTrigger", function() { return ColorPickerTrigger; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var ColorPickerTrigger = Object(react__WEBPACK_IMPORTED_MODULE_0__["forwardRef"])(function ColorPickerTrigger(props, ref) {
    return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { ref: ref, onClick: props.onClick, onMouseLeave: props.onMouseLeave, style: {
            overflow: 'hidden',
            background: 'inherit',
            border: 'none',
            color: 'inherit',
            padding: 0,
            borderRadius: 10,
            cursor: 'pointer',
        } },
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: {
                position: 'relative',
                width: 15,
                height: 15,
                border: 'none',
                margin: 0,
                float: 'left',
                zIndex: 0,
                backgroundImage: 
                // tslint:disable-next-line:max-line-length
                'url(data:image/png,base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAIAAADZF8uwAAAAGUlEQVQYV2M4gwH+YwCGIasIUwhT25BVBADtzYNYrHvv4gAAAABJRU5ErkJggg==)',
            } },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: {
                    backgroundColor: props.color,
                    display: 'block',
                    position: 'absolute',
                    top: 0,
                    left: 0,
                    bottom: 0,
                    right: 0,
                } }))));
});


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/NamedColorsGroup.tsx":
/*!*****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/NamedColorsGroup.tsx ***!
  \*****************************************************************************/
/*! exports provided: ColorSwatchVariant, ColorSwatch, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColorSwatchVariant", function() { return ColorSwatchVariant; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColorSwatch", function() { return ColorSwatch; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/namedColorsPalette */ "./packages/grafana-ui/src/utils/namedColorsPalette.ts");
/* harmony import */ var lodash_upperFirst__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/upperFirst */ "./node_modules/lodash/upperFirst.js");
/* harmony import */ var lodash_upperFirst__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_upperFirst__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_find__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/find */ "./node_modules/lodash/find.js");
/* harmony import */ var lodash_find__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_find__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");






var ColorSwatchVariant;
(function (ColorSwatchVariant) {
    ColorSwatchVariant["Small"] = "small";
    ColorSwatchVariant["Large"] = "large";
})(ColorSwatchVariant || (ColorSwatchVariant = {}));
var ColorSwatch = function (_a) {
    var color = _a.color, label = _a.label, _b = _a.variant, variant = _b === void 0 ? ColorSwatchVariant.Small : _b, isSelected = _a.isSelected, theme = _a.theme, otherProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["color", "label", "variant", "isSelected", "theme"]);
    var isSmall = variant === ColorSwatchVariant.Small;
    var swatchSize = isSmall ? '16px' : '32px';
    var selectedSwatchBorder = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_5__["selectThemeVariant"])({
        light: theme.colors.white,
        dark: theme.colors.black,
    }, theme.type);
    var swatchStyles = {
        width: swatchSize,
        height: swatchSize,
        borderRadius: '50%',
        background: "" + color,
        marginRight: isSmall ? '0px' : '8px',
        boxShadow: isSelected ? "inset 0 0 0 2px " + color + ", inset 0 0 0 4px " + selectedSwatchBorder : 'none',
    };
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ style: {
            display: 'flex',
            alignItems: 'center',
            cursor: 'pointer',
        } }, otherProps),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: swatchStyles }),
        variant === ColorSwatchVariant.Large && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, label)));
};
var NamedColorsGroup = function (_a) {
    var colors = _a.colors, selectedColor = _a.selectedColor, onColorSelect = _a.onColorSelect, theme = _a.theme, otherProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["colors", "selectedColor", "onColorSelect", "theme"]);
    var primaryColor = lodash_find__WEBPACK_IMPORTED_MODULE_4___default()(colors, function (color) { return !!color.isPrimary; });
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, otherProps, { style: { display: 'flex', flexDirection: 'column' } }),
        primaryColor && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ColorSwatch, { key: primaryColor.name, isSelected: primaryColor.name === selectedColor, variant: ColorSwatchVariant.Large, color: Object(_utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_2__["getColorForTheme"])(primaryColor, theme.type), label: lodash_upperFirst__WEBPACK_IMPORTED_MODULE_3___default()(primaryColor.hue), onClick: function () { return onColorSelect(primaryColor); }, theme: theme })),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                display: 'flex',
                marginTop: '8px',
            } }, colors.map(function (color) {
            return !color.isPrimary && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { key: color.name, style: { marginRight: '4px' } },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ColorSwatch, { key: color.name, isSelected: color.name === selectedColor, color: Object(_utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_2__["getColorForTheme"])(color, theme.type), onClick: function () { return onColorSelect(color); }, theme: theme })));
        }))));
};
/* harmony default export */ __webpack_exports__["default"] = (NamedColorsGroup);


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/NamedColorsPalette.tsx":
/*!*******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/NamedColorsPalette.tsx ***!
  \*******************************************************************************/
/*! exports provided: NamedColorsPalette */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NamedColorsPalette", function() { return NamedColorsPalette; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/namedColorsPalette */ "./packages/grafana-ui/src/utils/namedColorsPalette.ts");
/* harmony import */ var _NamedColorsGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./NamedColorsGroup */ "./packages/grafana-ui/src/components/ColorPicker/NamedColorsGroup.tsx");



var NamedColorsPalette = function (_a) {
    var color = _a.color, onChange = _a.onChange, theme = _a.theme;
    var swatches = [];
    Object(_utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_1__["getNamedColorPalette"])().forEach(function (colors, hue) {
        swatches.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_NamedColorsGroup__WEBPACK_IMPORTED_MODULE_2__["default"], { key: hue, theme: theme, selectedColor: color, colors: colors, onColorSelect: function (color) {
                onChange(color.name);
            } }));
    });
    return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: {
            display: 'grid',
            gridTemplateColumns: 'repeat(3, 1fr)',
            gridRowGap: '24px',
            gridColumnGap: '24px',
        } }, swatches));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/SeriesColorPickerPopover.tsx":
/*!*************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/SeriesColorPickerPopover.tsx ***!
  \*************************************************************************************/
/*! exports provided: SeriesColorPickerPopover, AxisSelector, SeriesColorPickerPopoverWithTheme */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPickerPopover", function() { return SeriesColorPickerPopover; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AxisSelector", function() { return AxisSelector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPickerPopoverWithTheme", function() { return SeriesColorPickerPopoverWithTheme; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ColorPickerPopover__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ColorPickerPopover */ "./packages/grafana-ui/src/components/ColorPicker/ColorPickerPopover.tsx");
/* harmony import */ var _Switch_Switch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Switch/Switch */ "./packages/grafana-ui/src/components/Switch/Switch.tsx");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");





var SeriesColorPickerPopover = function (props) {
    var yaxis = props.yaxis, onToggleAxis = props.onToggleAxis, color = props.color, colorPickerProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](props, ["yaxis", "onToggleAxis", "color"]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ColorPickerPopover__WEBPACK_IMPORTED_MODULE_2__["ColorPickerPopover"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, colorPickerProps, { color: color || '#000000', customPickers: {
            yaxis: {
                name: 'Y-Axis',
                tabComponent: function () { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Switch_Switch__WEBPACK_IMPORTED_MODULE_3__["Switch"], { key: "yaxisSwitch", label: "Use right y-axis", className: "ColorPicker__axisSwitch", labelClass: "ColorPicker__axisSwitchLabel", checked: yaxis === 2, onChange: function () {
                        if (onToggleAxis) {
                            onToggleAxis();
                        }
                    } })); },
            },
        } })));
};
var AxisSelector = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](AxisSelector, _super);
    function AxisSelector(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            yaxis: _this.props.yaxis,
        };
        _this.onToggleAxis = _this.onToggleAxis.bind(_this);
        return _this;
    }
    AxisSelector.prototype.onToggleAxis = function () {
        this.setState({
            yaxis: this.state.yaxis === 2 ? 1 : 2,
        });
        if (this.props.onToggleAxis) {
            this.props.onToggleAxis();
        }
    };
    AxisSelector.prototype.render = function () {
        var leftButtonClass = this.state.yaxis === 1 ? 'btn-primary' : 'btn-inverse';
        var rightButtonClass = this.state.yaxis === 2 ? 'btn-primary' : 'btn-inverse';
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "p-b-1" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("label", { className: "small p-r-1" }, "Y Axis:"),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { onClick: this.onToggleAxis, className: 'btn btn-small ' + leftButtonClass }, "Left"),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { onClick: this.onToggleAxis, className: 'btn btn-small ' + rightButtonClass }, "Right")));
    };
    return AxisSelector;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));

// This component is to enable SeriecColorPickerPopover usage via series-color-picker-popover directive
var SeriesColorPickerPopoverWithTheme = Object(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_4__["withTheme"])(SeriesColorPickerPopover);


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/SpectrumPalette.tsx":
/*!****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/SpectrumPalette.tsx ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-color */ "./node_modules/react-color/lib/index.js");
/* harmony import */ var react_color__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_color__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_color_lib_components_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-color/lib/components/common */ "./node_modules/react-color/lib/components/common/index.js");
/* harmony import */ var react_color_lib_components_common__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_color_lib_components_common__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/namedColorsPalette */ "./packages/grafana-ui/src/utils/namedColorsPalette.ts");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(tinycolor2__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _ColorInput__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ColorInput */ "./packages/grafana-ui/src/components/ColorPicker/ColorInput.tsx");
/* harmony import */ var _SpectrumPalettePointer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SpectrumPalettePointer */ "./packages/grafana-ui/src/components/ColorPicker/SpectrumPalettePointer.tsx");








var renderPointer = function (theme) { return function (props) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_SpectrumPalettePointer__WEBPACK_IMPORTED_MODULE_7__["default"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props, { theme: theme }))); }; };
// @ts-ignore
var SpectrumPicker = Object(react_color__WEBPACK_IMPORTED_MODULE_2__["CustomPicker"])(function (_a) {
    var rgb = _a.rgb, hsl = _a.hsl, onChange = _a.onChange, theme = _a.theme;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
            display: 'flex',
            width: '100%',
            flexDirection: 'column',
        } },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                display: 'flex',
            } },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                    display: 'flex',
                    flexGrow: 1,
                    flexDirection: 'column',
                } },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                        position: 'relative',
                        height: '100px',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_color_lib_components_common__WEBPACK_IMPORTED_MODULE_3__["Saturation"], { onChange: onChange, hsl: hsl, hsv: tinycolor2__WEBPACK_IMPORTED_MODULE_5___default()(hsl).toHsv() })),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                        width: '100%',
                        height: '16px',
                        marginTop: '16px',
                        position: 'relative',
                        background: 'white',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_color_lib_components_common__WEBPACK_IMPORTED_MODULE_3__["Alpha"], { rgb: rgb, hsl: hsl, a: rgb.a, onChange: onChange, pointer: renderPointer(theme) }))),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                    position: 'relative',
                    width: '16px',
                    height: '100px',
                    marginLeft: '16px',
                } },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_color_lib_components_common__WEBPACK_IMPORTED_MODULE_3__["Hue"], { onChange: onChange, hsl: hsl, direction: "vertical", pointer: renderPointer(theme) })))));
});
var SpectrumPalette = function (_a) {
    var color = _a.color, onChange = _a.onChange, theme = _a.theme;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(SpectrumPicker, { color: tinycolor2__WEBPACK_IMPORTED_MODULE_5___default()(Object(_utils_namedColorsPalette__WEBPACK_IMPORTED_MODULE_4__["getColorFromHexRgbOrName"])(color)).toRgb(), onChange: function (a) {
                onChange(tinycolor2__WEBPACK_IMPORTED_MODULE_5___default()(a.rgb).toString());
            }, theme: theme }),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ColorInput__WEBPACK_IMPORTED_MODULE_6__["default"], { theme: theme, color: color, onChange: onChange, style: { marginTop: '16px' } })));
};
/* harmony default export */ __webpack_exports__["default"] = (SpectrumPalette);


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/SpectrumPalettePointer.tsx":
/*!***********************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/SpectrumPalettePointer.tsx ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");



var SpectrumPalettePointer = function (_a) {
    var theme = _a.theme, direction = _a.direction;
    var styles = {
        picker: {
            width: '16px',
            height: '16px',
            transform: direction === 'vertical' ? 'translate(0, -8px)' : 'translate(-8px, 0)',
        },
    };
    var pointerColor = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_2__["selectThemeVariant"])({
        light: theme.colors.dark3,
        dark: theme.colors.gray2,
    }, theme.type);
    var pointerStyles = {
        position: 'absolute',
        left: '6px',
        width: '0',
        height: '0',
        borderStyle: 'solid',
        background: 'none',
    };
    var topArrowStyles = {
        top: '-7px',
        borderWidth: '6px 3px 0px 3px',
        borderColor: pointerColor + " transparent transparent transparent",
    };
    var bottomArrowStyles = {
        bottom: '-7px',
        borderWidth: '0px 3px 6px 3px',
        borderColor: " transparent transparent " + pointerColor + " transparent",
    };
    if (direction === 'vertical') {
        pointerStyles = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, pointerStyles, { left: 'auto' });
        topArrowStyles = {
            borderWidth: '3px 0px 3px 6px',
            borderColor: "transparent transparent transparent " + pointerColor,
            left: '-7px',
            top: '7px',
        };
        bottomArrowStyles = {
            borderWidth: '3px 6px 3px 0px',
            borderColor: "transparent " + pointerColor + " transparent transparent",
            right: '-7px',
            top: '7px',
        };
    }
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: styles.picker },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, pointerStyles, topArrowStyles) }),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, pointerStyles, bottomArrowStyles) })));
};
/* harmony default export */ __webpack_exports__["default"] = (SpectrumPalettePointer);


/***/ }),

/***/ "./packages/grafana-ui/src/components/ColorPicker/warnAboutColorPickerPropsDeprecation.ts":
/*!************************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ColorPicker/warnAboutColorPickerPropsDeprecation.ts ***!
  \************************************************************************************************/
/*! exports provided: warnAboutColorPickerPropsDeprecation */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "warnAboutColorPickerPropsDeprecation", function() { return warnAboutColorPickerPropsDeprecation; });
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");

var warnAboutColorPickerPropsDeprecation = function (componentName, props) {
    var onColorChange = props.onColorChange;
    if (onColorChange) {
        Object(_grafana_data__WEBPACK_IMPORTED_MODULE_0__["deprecationWarning"])(componentName, 'onColorChange', 'onChange');
    }
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/ContextMenu/ContextMenu.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ContextMenu/ContextMenu.tsx ***!
  \************************************************************************/
/*! exports provided: ContextMenu */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ContextMenu", function() { return ContextMenu; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-use/lib/useClickAway */ "./node_modules/react-use/lib/useClickAway.js");
/* harmony import */ var react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../index */ "./packages/grafana-ui/src/index.ts");
/* harmony import */ var _themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/stylesFactory */ "./packages/grafana-ui/src/themes/stylesFactory.ts");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../index */ "./packages/grafana-ui/src/components/index.ts");







var getContextMenuStyles = Object(_themes_stylesFactory__WEBPACK_IMPORTED_MODULE_5__["stylesFactory"])(function (theme) {
    var linkColor = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.dark2,
        dark: theme.colors.text,
    }, theme.type);
    var linkColorHover = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.link,
        dark: theme.colors.white,
    }, theme.type);
    var wrapperBg = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.gray7,
        dark: theme.colors.dark2,
    }, theme.type);
    var wrapperShadow = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.gray3,
        dark: theme.colors.black,
    }, theme.type);
    var itemColor = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.black,
        dark: theme.colors.white,
    }, theme.type);
    var groupLabelColor = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.gray1,
        dark: theme.colors.textWeak,
    }, theme.type);
    var itemBgHover = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.gray5,
        dark: theme.colors.dark7,
    }, theme.type);
    var headerBg = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.white,
        dark: theme.colors.dark1,
    }, theme.type);
    var headerSeparator = Object(_index__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.white,
        dark: theme.colors.dark7,
    }, theme.type);
    return {
        header: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      padding: 4px;\n      border-bottom: 1px solid ", ";\n      background: ", ";\n      margin-bottom: ", ";\n      border-radius: ", " ", " 0 0;\n    "], ["\n      padding: 4px;\n      border-bottom: 1px solid ", ";\n      background: ", ";\n      margin-bottom: ", ";\n      border-radius: ", " ", " 0 0;\n    "])), headerSeparator, headerBg, theme.spacing.xs, theme.border.radius.sm, theme.border.radius.sm),
        wrapper: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      background: ", ";\n      z-index: 1;\n      box-shadow: 0 2px 5px 0 ", ";\n      min-width: 200px;\n      display: inline-block;\n      border-radius: ", ";\n    "], ["\n      background: ", ";\n      z-index: 1;\n      box-shadow: 0 2px 5px 0 ", ";\n      min-width: 200px;\n      display: inline-block;\n      border-radius: ", ";\n    "])), wrapperBg, wrapperShadow, theme.border.radius.sm),
        link: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      color: ", ";\n      display: flex;\n      cursor: pointer;\n      &:hover {\n        color: ", ";\n        text-decoration: none;\n      }\n    "], ["\n      color: ", ";\n      display: flex;\n      cursor: pointer;\n      &:hover {\n        color: ", ";\n        text-decoration: none;\n      }\n    "])), linkColor, linkColorHover),
        item: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      background: none;\n      padding: 4px 8px;\n      color: ", ";\n      border-left: 2px solid transparent;\n      cursor: pointer;\n      &:hover {\n        background: ", ";\n        border-image: linear-gradient(#f05a28 30%, #fbca0a 99%);\n        border-image-slice: 1;\n      }\n    "], ["\n      background: none;\n      padding: 4px 8px;\n      color: ", ";\n      border-left: 2px solid transparent;\n      cursor: pointer;\n      &:hover {\n        background: ", ";\n        border-image: linear-gradient(#f05a28 30%, #fbca0a 99%);\n        border-image-slice: 1;\n      }\n    "])), itemColor, itemBgHover),
        groupLabel: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      color: ", ";\n      font-size: ", ";\n      line-height: ", ";\n      padding: ", " ", ";\n    "], ["\n      color: ", ";\n      font-size: ", ";\n      line-height: ", ";\n      padding: ", " ", ";\n    "])), groupLabelColor, theme.typography.size.sm, theme.typography.lineHeight.lg, theme.spacing.xs, theme.spacing.sm),
        icon: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      opacity: 0.7;\n      width: 12px;\n      height: 12px;\n      display: inline-block;\n      margin-right: 10px;\n      color: ", ";\n      position: relative;\n      top: 4px;\n    "], ["\n      opacity: 0.7;\n      width: 12px;\n      height: 12px;\n      display: inline-block;\n      margin-right: 10px;\n      color: ", ";\n      position: relative;\n      top: 4px;\n    "])), theme.colors.linkDisabled),
    };
});
var ContextMenu = react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(function (_a) {
    var x = _a.x, y = _a.y, onClose = _a.onClose, items = _a.items, renderHeader = _a.renderHeader;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"]);
    var menuRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["useRef"])(null);
    var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])({}), 2), positionStyles = _b[0], setPositionStyles = _b[1];
    Object(react__WEBPACK_IMPORTED_MODULE_1__["useLayoutEffect"])(function () {
        var menuElement = menuRef.current;
        if (menuElement) {
            var rect = menuElement.getBoundingClientRect();
            var OFFSET = 5;
            var collisions = {
                right: window.innerWidth < x + rect.width,
                bottom: window.innerHeight < rect.bottom + rect.height + OFFSET,
            };
            setPositionStyles({
                position: 'fixed',
                left: collisions.right ? x - rect.width - OFFSET : x - OFFSET,
                top: collisions.bottom ? y - rect.height - OFFSET : y + OFFSET,
            });
        }
    }, [menuRef.current]);
    react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_3___default()(menuRef, function () {
        if (onClose) {
            onClose();
        }
    });
    var styles = getContextMenuStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_6__["Portal"], null,
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { ref: menuRef, style: positionStyles, className: styles.wrapper },
            renderHeader && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.header }, renderHeader()),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_6__["List"], { items: items || [], renderItem: function (item, index) {
                    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ContextMenuGroup, { group: item, onItemClick: onClose })));
                } }))));
});
var ContextMenuItem = react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(function (_a) {
    var url = _a.url, icon = _a.icon, label = _a.label, target = _a.target, onClick = _a.onClick, className = _a.className;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"]);
    var styles = getContextMenuStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.item },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("a", { href: url, target: target || '_self', className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])(className, styles.link), onClick: function (e) {
                if (onClick) {
                    onClick(e);
                }
            } },
            icon && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])("" + icon, styles.icon) }),
            " ",
            label)));
});
var ContextMenuGroup = function (_a) {
    var group = _a.group, onItemClick = _a.onItemClick;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"]);
    var styles = getContextMenuStyles(theme);
    if (group.items.length === 0) {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null,
        group.label && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.groupLabel }, group.label),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_6__["List"], { items: group.items || [], renderItem: function (item) {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ContextMenuItem, { url: item.url, label: item.label, target: item.target, icon: item.icon, onClick: function (e) {
                        if (item.onClick) {
                            item.onClick(e);
                        }
                        if (onItemClick) {
                            onItemClick();
                        }
                    } }));
            } })));
};
ContextMenu.displayName = 'ContextMenu';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6;


/***/ }),

/***/ "./packages/grafana-ui/src/components/ContextMenu/WithContextMenu.tsx":
/*!****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ContextMenu/WithContextMenu.tsx ***!
  \****************************************************************************/
/*! exports provided: WithContextMenu */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WithContextMenu", function() { return WithContextMenu; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ContextMenu_ContextMenu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ContextMenu/ContextMenu */ "./packages/grafana-ui/src/components/ContextMenu/ContextMenu.tsx");



var WithContextMenu = function (_a) {
    var children = _a.children, getContextMenuItems = _a.getContextMenuItems;
    var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false), 2), isMenuOpen = _b[0], setIsMenuOpen = _b[1];
    var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])({ x: 0, y: 0 }), 2), menuPosition = _c[0], setMenuPositon = _c[1];
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
        children({
            openMenu: function (e) {
                setIsMenuOpen(true);
                setMenuPositon({
                    x: e.pageX,
                    y: e.pageY,
                });
            },
        }),
        isMenuOpen && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ContextMenu_ContextMenu__WEBPACK_IMPORTED_MODULE_2__["ContextMenu"], { onClose: function () { return setIsMenuOpen(false); }, x: menuPosition.x, y: menuPosition.y, items: getContextMenuItems() }))));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/CustomScrollbar/CustomScrollbar.tsx":
/*!********************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/CustomScrollbar/CustomScrollbar.tsx ***!
  \********************************************************************************/
/*! exports provided: CustomScrollbar, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomScrollbar", function() { return CustomScrollbar; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isNil */ "./node_modules/lodash/isNil.js");
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isNil__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_custom_scrollbars__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-custom-scrollbars */ "./node_modules/react-custom-scrollbars/lib/index.js");
/* harmony import */ var react_custom_scrollbars__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_custom_scrollbars__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");






/**
 * Wraps component into <Scrollbars> component from `react-custom-scrollbars`
 */
var CustomScrollbar = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](CustomScrollbar, _super);
    function CustomScrollbar(props) {
        var _this = _super.call(this, props) || this;
        _this.renderTrack = function (track, hideTrack, passedProps) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, passedProps, { className: Object(emotion__WEBPACK_IMPORTED_MODULE_5__["cx"])(Object(emotion__WEBPACK_IMPORTED_MODULE_5__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n            visibility: ", ";\n          "], ["\n            visibility: ", ";\n          "])), hideTrack ? 'hidden' : 'visible'), track) })));
        };
        _this.renderThumb = function (thumb, passedProps) {
            return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, passedProps, { className: thumb }));
        };
        _this.renderTrackHorizontal = function (passedProps) {
            return _this.renderTrack('track-horizontal', _this.props.hideHorizontalTrack, passedProps);
        };
        _this.renderTrackVertical = function (passedProps) {
            return _this.renderTrack('track-vertical', _this.props.hideVerticalTrack, passedProps);
        };
        _this.renderThumbHorizontal = function (passedProps) {
            return _this.renderThumb('thumb-horizontal', passedProps);
        };
        _this.renderThumbVertical = function (passedProps) {
            return _this.renderThumb('thumb-vertical', passedProps);
        };
        _this.renderView = function (passedProps) {
            return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, passedProps, { className: "view" }));
        };
        _this.ref = react__WEBPACK_IMPORTED_MODULE_1___default.a.createRef();
        return _this;
    }
    CustomScrollbar.prototype.updateScroll = function () {
        var ref = this.ref.current;
        var scrollTop = this.props.scrollTop;
        if (ref && !lodash_isNil__WEBPACK_IMPORTED_MODULE_2___default()(scrollTop)) {
            ref.scrollTop(scrollTop);
        }
    };
    CustomScrollbar.prototype.componentDidMount = function () {
        var _this = this;
        this.updateScroll();
        // this logic is to make scrollbar visible when content is added body after mount
        if (this.props.updateAfterMountMs) {
            setTimeout(function () { return _this.updateAfterMount(); }, this.props.updateAfterMountMs);
        }
    };
    CustomScrollbar.prototype.updateAfterMount = function () {
        if (this.ref && this.ref.current) {
            var scrollbar = this.ref.current;
            if (scrollbar.update) {
                scrollbar.update();
            }
        }
    };
    CustomScrollbar.prototype.componentDidUpdate = function () {
        this.updateScroll();
    };
    CustomScrollbar.prototype.render = function () {
        var _a = this.props, className = _a.className, children = _a.children, autoHeightMax = _a.autoHeightMax, autoHeightMin = _a.autoHeightMin, setScrollTop = _a.setScrollTop, autoHide = _a.autoHide, autoHideTimeout = _a.autoHideTimeout, hideTracksWhenNotNeeded = _a.hideTracksWhenNotNeeded;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_custom_scrollbars__WEBPACK_IMPORTED_MODULE_4___default.a, { ref: this.ref, className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('custom-scrollbar', className), onScroll: setScrollTop, autoHeight: true, autoHide: autoHide, autoHideTimeout: autoHideTimeout, hideTracksWhenNotNeeded: hideTracksWhenNotNeeded, 
            // These autoHeightMin & autoHeightMax options affect firefox and chrome differently.
            // Before these where set to inhert but that caused problems with cut of legends in firefox
            autoHeightMax: autoHeightMax, autoHeightMin: autoHeightMin, renderTrackHorizontal: this.renderTrackHorizontal, renderTrackVertical: this.renderTrackVertical, renderThumbHorizontal: this.renderThumbHorizontal, renderThumbVertical: this.renderThumbVertical, renderView: this.renderView }, children));
    };
    CustomScrollbar.defaultProps = {
        autoHide: false,
        autoHideTimeout: 200,
        autoHideDuration: 200,
        setScrollTop: function () { },
        hideTracksWhenNotNeeded: false,
        autoHeightMin: '0',
        autoHeightMax: '100%',
    };
    return CustomScrollbar;
}(react__WEBPACK_IMPORTED_MODULE_1__["Component"]));

/* harmony default export */ __webpack_exports__["default"] = (CustomScrollbar);
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/DataLinks/DataLinkEditor.tsx":
/*!*************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/DataLinks/DataLinkEditor.tsx ***!
  \*************************************************************************/
/*! exports provided: DataLinkEditor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataLinkEditor", function() { return DataLinkEditor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../index */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes_index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes/index */ "./packages/grafana-ui/src/themes/index.ts");
/* harmony import */ var _DataLinkInput__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DataLinkInput */ "./packages/grafana-ui/src/components/DataLinks/DataLinkInput.tsx");






var getStyles = Object(_themes_index__WEBPACK_IMPORTED_MODULE_4__["stylesFactory"])(function (theme) { return ({
    listItem: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    margin-bottom: ", ";\n  "], ["\n    margin-bottom: ", ";\n  "])), theme.spacing.sm),
    infoText: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    padding-bottom: ", ";\n    margin-left: 66px;\n    color: ", ";\n  "], ["\n    padding-bottom: ", ";\n    margin-left: 66px;\n    color: ", ";\n  "])), theme.spacing.md, theme.colors.textWeak),
}); });
var DataLinkEditor = react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(function (_a) {
    var index = _a.index, value = _a.value, onChange = _a.onChange, onRemove = _a.onRemove, suggestions = _a.suggestions, isLast = _a.isLast;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_index__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"]);
    var styles = getStyles(theme);
    var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(value.title), 2), title = _b[0], setTitle = _b[1];
    var onUrlChange = function (url, callback) {
        onChange(index, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, value, { url: url }), callback);
    };
    var onTitleChange = function (event) {
        setTitle(event.target.value);
    };
    var onTitleBlur = function () {
        onChange(index, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, value, { title: title }));
    };
    var onRemoveClick = function () {
        onRemove(value);
    };
    var onOpenInNewTabChanged = function () {
        onChange(index, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, value, { targetBlank: !value.targetBlank }));
    };
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.listItem },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form gf-form--inline" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_2__["FormField"], { className: "gf-form--grow", label: "Title", value: title, onChange: onTitleChange, onBlur: onTitleBlur, inputWidth: 0, labelWidth: 5, placeholder: "Show details" }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_2__["Switch"], { label: "Open in new tab", checked: value.targetBlank || false, onChange: onOpenInNewTabChanged }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { className: "gf-form-label gf-form-label--btn", onClick: onRemoveClick, title: "Remove link" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-times" }))),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "URL", labelWidth: 5, inputEl: react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_DataLinkInput__WEBPACK_IMPORTED_MODULE_5__["DataLinkInput"], { value: value.url, onChange: onUrlChange, suggestions: suggestions }), className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n            width: 100%;\n          "], ["\n            width: 100%;\n          "]))) }),
        isLast && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.infoText }, "With data links you can reference data variables like series name, labels and values. Type CMD+Space, CTRL+Space, or $ to open variable suggestions."))));
});
DataLinkEditor.displayName = 'DataLinkEditor';
var templateObject_1, templateObject_2, templateObject_3;


/***/ }),

/***/ "./packages/grafana-ui/src/components/DataLinks/DataLinkInput.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/DataLinks/DataLinkInput.tsx ***!
  \************************************************************************/
/*! exports provided: DataLinkInput */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataLinkInput", function() { return DataLinkInput; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _DataLinkSuggestions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DataLinkSuggestions */ "./packages/grafana-ui/src/components/DataLinks/DataLinkSuggestions.tsx");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../index */ "./packages/grafana-ui/src/index.ts");
/* harmony import */ var _SelectionReference__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SelectionReference */ "./packages/grafana-ui/src/components/DataLinks/SelectionReference.ts");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../index */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var _grafana_slate_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @grafana/slate-react */ "./node_modules/@grafana/slate-react/lib/slate-react.es.js");
/* harmony import */ var slate_plain_serializer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! slate-plain-serializer */ "./node_modules/slate-plain-serializer/lib/slate-plain-serializer.es.js");
/* harmony import */ var react_popper__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-popper */ "./node_modules/react-popper/lib/esm/index.js");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _slate_plugins__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../slate-plugins */ "./packages/grafana-ui/src/slate-plugins/index.ts");
/* harmony import */ var _utils_slate__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/slate */ "./packages/grafana-ui/src/utils/slate.ts");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");













var modulo = function (a, n) { return a - n * Math.floor(a / n); };
var plugins = [
    Object(_slate_plugins__WEBPACK_IMPORTED_MODULE_10__["SlatePrism"])({
        onlyIn: function (node) { return node.type === 'code_block'; },
        getSyntax: function () { return 'links'; },
    }),
];
var getStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_12__["stylesFactory"])(function (theme) { return ({
    editor: Object(emotion__WEBPACK_IMPORTED_MODULE_9__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    .token.builtInVariable {\n      color: ", ";\n    }\n    .token.variable {\n      color: ", ";\n    }\n  "], ["\n    .token.builtInVariable {\n      color: ", ";\n    }\n    .token.variable {\n      color: ", ";\n    }\n  "])), theme.colors.queryGreen, theme.colors.queryKeyword),
}); });
// This memoised also because rerendering the slate editor grabs focus which created problem in some cases this
// was used and changes to different state were propagated here.
var DataLinkInput = Object(react__WEBPACK_IMPORTED_MODULE_1__["memo"])(function (_a) {
    var value = _a.value, onChange = _a.onChange, suggestions = _a.suggestions;
    var editorRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["useRef"])();
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]);
    var styles = getStyles(theme);
    var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false), 2), showingSuggestions = _b[0], setShowingSuggestions = _b[1];
    var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(0), 2), suggestionsIndex = _c[0], setSuggestionsIndex = _c[1];
    var _d = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(Object(_index__WEBPACK_IMPORTED_MODULE_3__["makeValue"])(value)), 2), linkUrl = _d[0], setLinkUrl = _d[1];
    // Workaround for https://github.com/ianstormtaylor/slate/issues/2927
    var stateRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["useRef"])({ showingSuggestions: showingSuggestions, suggestions: suggestions, suggestionsIndex: suggestionsIndex, linkUrl: linkUrl, onChange: onChange });
    stateRef.current = { showingSuggestions: showingSuggestions, suggestions: suggestions, suggestionsIndex: suggestionsIndex, linkUrl: linkUrl, onChange: onChange };
    // SelectionReference is used to position the variables suggestion relatively to current DOM selection
    var selectionRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(function () { return new _SelectionReference__WEBPACK_IMPORTED_MODULE_4__["SelectionReference"](); }, [setShowingSuggestions, linkUrl]);
    var onKeyDown = react__WEBPACK_IMPORTED_MODULE_1___default.a.useCallback(function (event, next) {
        if (!stateRef.current.showingSuggestions) {
            if (event.key === '=' || event.key === '$' || (event.keyCode === 32 && event.ctrlKey)) {
                return setShowingSuggestions(true);
            }
            return next();
        }
        switch (event.key) {
            case 'Backspace':
            case 'Escape':
                setShowingSuggestions(false);
                return setSuggestionsIndex(0);
            case 'Enter':
                event.preventDefault();
                return onVariableSelect(stateRef.current.suggestions[stateRef.current.suggestionsIndex]);
            case 'ArrowDown':
            case 'ArrowUp':
                event.preventDefault();
                var direction_1 = event.key === 'ArrowDown' ? 1 : -1;
                return setSuggestionsIndex(function (index) { return modulo(index + direction_1, stateRef.current.suggestions.length); });
            default:
                return next();
        }
    }, []);
    var onUrlChange = react__WEBPACK_IMPORTED_MODULE_1___default.a.useCallback(function (_a) {
        var value = _a.value;
        setLinkUrl(value);
    }, []);
    var onUrlBlur = react__WEBPACK_IMPORTED_MODULE_1___default.a.useCallback(function (event, editor, next) {
        // Callback needed for blur to work correctly
        stateRef.current.onChange(slate_plain_serializer__WEBPACK_IMPORTED_MODULE_7__["default"].serialize(stateRef.current.linkUrl), function () {
            // This needs to be called after state is updated.
            editorRef.current.blur();
        });
    }, []);
    var onVariableSelect = function (item, editor) {
        if (editor === void 0) { editor = editorRef.current; }
        var includeDollarSign = slate_plain_serializer__WEBPACK_IMPORTED_MODULE_7__["default"].serialize(editor.value).slice(-1) !== '$';
        if (item.origin !== _DataLinkSuggestions__WEBPACK_IMPORTED_MODULE_2__["VariableOrigin"].Template || item.value === _index__WEBPACK_IMPORTED_MODULE_3__["DataLinkBuiltInVars"].includeVars) {
            editor.insertText((includeDollarSign ? '$' : '') + "{" + item.value + "}");
        }
        else {
            editor.insertText("var-" + item.value + "=${" + item.value + "}");
        }
        setLinkUrl(editor.value);
        setShowingSuggestions(false);
        setSuggestionsIndex(0);
        onChange(slate_plain_serializer__WEBPACK_IMPORTED_MODULE_7__["default"].serialize(editor.value));
    };
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_9__["cx"])('gf-form-input', Object(emotion__WEBPACK_IMPORTED_MODULE_9__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n          position: relative;\n          height: auto;\n        "], ["\n          position: relative;\n          height: auto;\n        "])))) },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "slate-query-field" },
            showingSuggestions && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_5__["Portal"], null,
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_popper__WEBPACK_IMPORTED_MODULE_8__["Popper"], { referenceElement: selectionRef, placement: "top-end", modifiers: {
                        preventOverflow: { enabled: true, boundariesElement: 'window' },
                        arrow: { enabled: false },
                        offset: { offset: 250 },
                    } }, function (_a) {
                    var ref = _a.ref, style = _a.style, placement = _a.placement;
                    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { ref: ref, style: style, "data-placement": placement },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_DataLinkSuggestions__WEBPACK_IMPORTED_MODULE_2__["DataLinkSuggestions"], { suggestions: stateRef.current.suggestions, onSuggestionSelect: onVariableSelect, onClose: function () { return setShowingSuggestions(false); }, activeIndex: suggestionsIndex })));
                }))),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_grafana_slate_react__WEBPACK_IMPORTED_MODULE_6__["Editor"], { schema: _utils_slate__WEBPACK_IMPORTED_MODULE_11__["SCHEMA"], ref: editorRef, placeholder: "http://your-grafana.com/d/000000010/annotations", value: stateRef.current.linkUrl, onChange: onUrlChange, onBlur: onUrlBlur, onKeyDown: function (event, _editor, next) { return onKeyDown(event, next); }, plugins: plugins, className: styles.editor }))));
});
DataLinkInput.displayName = 'DataLinkInput';
var templateObject_1, templateObject_2;


/***/ }),

/***/ "./packages/grafana-ui/src/components/DataLinks/DataLinkSuggestions.tsx":
/*!******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/DataLinks/DataLinkSuggestions.tsx ***!
  \******************************************************************************/
/*! exports provided: VariableOrigin, DataLinkSuggestions */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VariableOrigin", function() { return VariableOrigin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataLinkSuggestions", function() { return DataLinkSuggestions; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../index */ "./packages/grafana-ui/src/index.ts");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use/lib/useClickAway */ "./node_modules/react-use/lib/useClickAway.js");
/* harmony import */ var react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../index */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(tinycolor2__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");









var VariableOrigin;
(function (VariableOrigin) {
    VariableOrigin["Series"] = "series";
    VariableOrigin["Field"] = "field";
    VariableOrigin["Value"] = "value";
    VariableOrigin["BuiltIn"] = "built-in";
    VariableOrigin["Template"] = "template";
})(VariableOrigin || (VariableOrigin = {}));
var getStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_8__["stylesFactory"])(function (theme) {
    var wrapperBg = Object(_index__WEBPACK_IMPORTED_MODULE_1__["selectThemeVariant"])({
        light: theme.colors.white,
        dark: theme.colors.dark2,
    }, theme.type);
    var wrapperShadow = Object(_index__WEBPACK_IMPORTED_MODULE_1__["selectThemeVariant"])({
        light: theme.colors.gray5,
        dark: theme.colors.black,
    }, theme.type);
    var itemColor = Object(_index__WEBPACK_IMPORTED_MODULE_1__["selectThemeVariant"])({
        light: theme.colors.black,
        dark: theme.colors.white,
    }, theme.type);
    var itemDocsColor = Object(_index__WEBPACK_IMPORTED_MODULE_1__["selectThemeVariant"])({
        light: theme.colors.dark3,
        dark: theme.colors.gray2,
    }, theme.type);
    var itemBgHover = Object(_index__WEBPACK_IMPORTED_MODULE_1__["selectThemeVariant"])({
        light: theme.colors.gray5,
        dark: theme.colors.dark7,
    }, theme.type);
    var itemBgActive = Object(_index__WEBPACK_IMPORTED_MODULE_1__["selectThemeVariant"])({
        light: theme.colors.gray6,
        dark: theme.colors.dark9,
    }, theme.type);
    var separatorColor = Object(_index__WEBPACK_IMPORTED_MODULE_1__["selectThemeVariant"])({
        light: tinycolor2__WEBPACK_IMPORTED_MODULE_7___default()(wrapperBg.toString())
            .darken(10)
            .toString(),
        dark: tinycolor2__WEBPACK_IMPORTED_MODULE_7___default()(wrapperBg.toString())
            .lighten(10)
            .toString(),
    }, theme.type);
    return {
        list: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      border-bottom: 1px solid ", ";\n      &:last-child {\n        border: none;\n      }\n    "], ["\n      border-bottom: 1px solid ", ";\n      &:last-child {\n        border: none;\n      }\n    "])), separatorColor),
        wrapper: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      background: ", ";\n      z-index: 1;\n      width: 250px;\n      box-shadow: 0 5px 10px 0 ", ";\n    "], ["\n      background: ", ";\n      z-index: 1;\n      width: 250px;\n      box-shadow: 0 5px 10px 0 ", ";\n    "])), wrapperBg, wrapperShadow),
        item: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      background: none;\n      padding: 2px 8px;\n      color: ", ";\n      cursor: pointer;\n      &:hover {\n        background: ", ";\n      }\n    "], ["\n      background: none;\n      padding: 2px 8px;\n      color: ", ";\n      cursor: pointer;\n      &:hover {\n        background: ", ";\n      }\n    "])), itemColor, itemBgHover),
        label: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      color: ", ";\n    "], ["\n      color: ", ";\n    "])), theme.colors.textWeak),
        activeItem: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      background: ", ";\n      &:hover {\n        background: ", ";\n      }\n    "], ["\n      background: ", ";\n      &:hover {\n        background: ", ";\n      }\n    "])), itemBgActive, itemBgActive),
        itemValue: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      font-family: ", ";\n      font-size: ", ";\n    "], ["\n      font-family: ", ";\n      font-size: ", ";\n    "])), theme.typography.fontFamily.monospace, theme.typography.size.sm),
        itemDocs: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_7 || (templateObject_7 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      margin-top: ", ";\n      color: ", ";\n    "], ["\n      margin-top: ", ";\n      color: ", ";\n    "])), theme.spacing.xs, itemDocsColor),
    };
});
var DataLinkSuggestions = function (_a) {
    var suggestions = _a.suggestions, otherProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["suggestions"]);
    var ref = Object(react__WEBPACK_IMPORTED_MODULE_4__["useRef"])(null);
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_4__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_1__["ThemeContext"]);
    react_use_lib_useClickAway__WEBPACK_IMPORTED_MODULE_5___default()(ref, function () {
        if (otherProps.onClose) {
            otherProps.onClose();
        }
    });
    var groupedSuggestions = Object(react__WEBPACK_IMPORTED_MODULE_4__["useMemo"])(function () {
        return lodash__WEBPACK_IMPORTED_MODULE_3___default.a.groupBy(suggestions, function (s) { return s.origin; });
    }, [suggestions]);
    var styles = getStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("div", { ref: ref, className: styles.wrapper }, Object.keys(groupedSuggestions).map(function (key, i) {
        var indexOffset = i === 0
            ? 0
            : Object.keys(groupedSuggestions).reduce(function (acc, current, index) {
                if (index >= i) {
                    return acc;
                }
                return acc + groupedSuggestions[current].length;
            }, 0);
        return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(DataLinkSuggestionsList, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, otherProps, { suggestions: groupedSuggestions[key], label: "" + lodash__WEBPACK_IMPORTED_MODULE_3___default.a.capitalize(key), activeIndex: otherProps.activeIndex, activeIndexOffset: indexOffset, key: key })));
    })));
};
DataLinkSuggestions.displayName = 'DataLinkSuggestions';
var DataLinkSuggestionsList = react__WEBPACK_IMPORTED_MODULE_4___default.a.memo(function (_a) {
    var activeIndex = _a.activeIndex, activeIndexOffset = _a.activeIndexOffset, label = _a.label, onClose = _a.onClose, onSuggestionSelect = _a.onSuggestionSelect, suggestions = _a.suggestions;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_4__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_1__["ThemeContext"]);
    var styles = getStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_4___default.a.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_6__["List"], { className: styles.list, items: suggestions, renderItem: function (item, index) {
                return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])(styles.item, index + activeIndexOffset === activeIndex && styles.activeItem), onClick: function () {
                        onSuggestionSelect(item);
                    }, title: item.documentation },
                    react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("span", { className: styles.itemValue },
                        react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("span", { className: styles.label }, label),
                        " ",
                        item.label)));
            } })));
});
DataLinkSuggestionsList.displayName = 'DataLinkSuggestionsList';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7;


/***/ }),

/***/ "./packages/grafana-ui/src/components/DataLinks/DataLinksContextMenu.tsx":
/*!*******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/DataLinks/DataLinksContextMenu.tsx ***!
  \*******************************************************************************/
/*! exports provided: DataLinksContextMenu */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataLinksContextMenu", function() { return DataLinksContextMenu; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ContextMenu_WithContextMenu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ContextMenu/WithContextMenu */ "./packages/grafana-ui/src/components/ContextMenu/WithContextMenu.tsx");
/* harmony import */ var _utils_dataLinks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/dataLinks */ "./packages/grafana-ui/src/utils/dataLinks.ts");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");





var DataLinksContextMenu = function (_a) {
    var children = _a.children, links = _a.links;
    if (!links) {
        return children({});
    }
    var getDataLinksContextMenuItems = function () {
        return [{ items: Object(_utils_dataLinks__WEBPACK_IMPORTED_MODULE_3__["linkModelToContextMenuItems"])(links), label: 'Data links' }];
    };
    // Use this class name (exposed via render prop) to add context menu indicator to the click target of the visualization
    var targetClassName = Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    cursor: context-menu;\n  "], ["\n    cursor: context-menu;\n  "])));
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ContextMenu_WithContextMenu__WEBPACK_IMPORTED_MODULE_2__["WithContextMenu"], { getContextMenuItems: getDataLinksContextMenuItems }, function (_a) {
        var openMenu = _a.openMenu;
        return children({ openMenu: openMenu, targetClassName: targetClassName });
    }));
};
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/DataLinks/DataLinksEditor.tsx":
/*!**************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/DataLinks/DataLinksEditor.tsx ***!
  \**************************************************************************/
/*! exports provided: DataLinksEditor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataLinksEditor", function() { return DataLinksEditor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prismjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prismjs */ "./node_modules/prismjs/prism.js");
/* harmony import */ var prismjs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prismjs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../index */ "./packages/grafana-ui/src/index.ts");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../index */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var _DataLinkEditor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DataLinkEditor */ "./packages/grafana-ui/src/components/DataLinks/DataLinkEditor.tsx");

// Libraries

// @ts-ignore

// Components




prismjs__WEBPACK_IMPORTED_MODULE_2___default.a.languages['links'] = {
    builtInVariable: {
        pattern: /(\${\S+?})/,
    },
};
var DataLinksEditor = react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(function (_a) {
    var value = _a.value, onChange = _a.onChange, suggestions = _a.suggestions, maxLinks = _a.maxLinks;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"]);
    var onAdd = function () {
        onChange(value ? tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](value, [{ url: '', title: '' }]) : [{ url: '', title: '' }]);
    };
    var onLinkChanged = function (linkIndex, newLink, callback) {
        onChange(value.map(function (item, listIndex) {
            if (linkIndex === listIndex) {
                return newLink;
            }
            return item;
        }), callback);
    };
    var onRemove = function (link) {
        onChange(value.filter(function (item) { return item !== link; }));
    };
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
        value && value.length > 0 && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n            margin-bottom: ", ";\n          "], ["\n            margin-bottom: ", ";\n          "])), theme.spacing.sm) }, value.map(function (link, index) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_DataLinkEditor__WEBPACK_IMPORTED_MODULE_6__["DataLinkEditor"], { key: index.toString(), index: index, isLast: index === value.length - 1, value: link, onChange: onLinkChanged, onRemove: onRemove, suggestions: suggestions })); }))),
        (!value || (value && value.length < (maxLinks || Infinity))) && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_5__["Button"], { variant: "inverse", icon: "fa fa-plus", onClick: function () { return onAdd(); } }, "Add link"))));
});
DataLinksEditor.displayName = 'DataLinksEditor';
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/DataLinks/SelectionReference.ts":
/*!****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/DataLinks/SelectionReference.ts ***!
  \****************************************************************************/
/*! exports provided: SelectionReference */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SelectionReference", function() { return SelectionReference; });
var SelectionReference = /** @class */ (function () {
    function SelectionReference() {
    }
    SelectionReference.prototype.getBoundingClientRect = function () {
        var selection = window.getSelection();
        var node = selection && selection.anchorNode;
        if (node && node.parentElement) {
            var rect = node.parentElement.getBoundingClientRect();
            return rect;
        }
        return {
            top: 0,
            left: 0,
            bottom: 0,
            right: 0,
            width: 0,
            height: 0,
        };
    };
    Object.defineProperty(SelectionReference.prototype, "clientWidth", {
        get: function () {
            return this.getBoundingClientRect().width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelectionReference.prototype, "clientHeight", {
        get: function () {
            return this.getBoundingClientRect().height;
        },
        enumerable: true,
        configurable: true
    });
    return SelectionReference;
}());



/***/ }),

/***/ "./packages/grafana-ui/src/components/DeleteButton/DeleteButton.tsx":
/*!**************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/DeleteButton/DeleteButton.tsx ***!
  \**************************************************************************/
/*! exports provided: DeleteButton */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DeleteButton", function() { return DeleteButton; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


var DeleteButton = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](DeleteButton, _super);
    function DeleteButton() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            showConfirm: false,
        };
        _this.onClickDelete = function (event) {
            if (event) {
                event.preventDefault();
            }
            _this.setState({
                showConfirm: true,
            });
        };
        _this.onClickCancel = function (event) {
            if (event) {
                event.preventDefault();
            }
            _this.setState({
                showConfirm: false,
            });
        };
        return _this;
    }
    DeleteButton.prototype.render = function () {
        var _a = this.props, onConfirm = _a.onConfirm, disabled = _a.disabled;
        var showConfirmClass = this.state.showConfirm ? 'show' : 'hide';
        var showDeleteButtonClass = this.state.showConfirm ? 'hide' : 'show';
        var disabledClass = disabled ? 'disabled btn-inverse' : '';
        var onClick = disabled ? function () { } : this.onClickDelete;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "delete-button-container" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("a", { className: "delete-button " + showDeleteButtonClass + " btn btn-danger btn-small " + disabledClass, onClick: onClick },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-remove" })),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "confirm-delete-container" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "confirm-delete " + showConfirmClass },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("a", { className: "btn btn-small", onClick: this.onClickCancel }, "Cancel"),
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("a", { className: "btn btn-danger btn-small", onClick: onConfirm }, "Confirm Delete")))));
    };
    return DeleteButton;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/EmptySearchResult/EmptySearchResult.tsx":
/*!************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/EmptySearchResult/EmptySearchResult.tsx ***!
  \************************************************************************************/
/*! exports provided: EmptySearchResult */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EmptySearchResult", function() { return EmptySearchResult; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var EmptySearchResult = function (_a) {
    var children = _a.children;
    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "empty-search-result" }, children);
};



/***/ }),

/***/ "./packages/grafana-ui/src/components/ErrorBoundary/ErrorBoundary.tsx":
/*!****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ErrorBoundary/ErrorBoundary.tsx ***!
  \****************************************************************************/
/*! exports provided: ErrorBoundary, ErrorBoundaryAlert */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ErrorBoundary", function() { return ErrorBoundary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ErrorBoundaryAlert", function() { return ErrorBoundaryAlert; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Alert_Alert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Alert/Alert */ "./packages/grafana-ui/src/components/Alert/Alert.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");





var ErrorBoundary = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ErrorBoundary, _super);
    function ErrorBoundary() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            error: null,
            errorInfo: null,
        };
        return _this;
    }
    ErrorBoundary.prototype.componentDidCatch = function (error, errorInfo) {
        this.setState({
            error: error,
            errorInfo: errorInfo,
        });
    };
    ErrorBoundary.prototype.render = function () {
        var children = this.props.children;
        var _a = this.state, error = _a.error, errorInfo = _a.errorInfo;
        return children({
            error: error,
            errorInfo: errorInfo,
        });
    };
    return ErrorBoundary;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

var getStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_4__["stylesFactory"])(function () {
    return Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    width: 500px;\n    margin: 64px auto;\n  "], ["\n    width: 500px;\n    margin: 64px auto;\n  "])));
});
var ErrorBoundaryAlert = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ErrorBoundaryAlert, _super);
    function ErrorBoundaryAlert() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ErrorBoundaryAlert.prototype.render = function () {
        var _a = this.props, title = _a.title, children = _a.children, style = _a.style;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ErrorBoundary, null, function (_a) {
            var error = _a.error, errorInfo = _a.errorInfo;
            if (!errorInfo) {
                return children;
            }
            if (style === 'alertbox') {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Alert_Alert__WEBPACK_IMPORTED_MODULE_2__["Alert"], { title: title || '' },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("details", { style: { whiteSpace: 'pre-wrap' } },
                        error && error.toString(),
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("br", null),
                        errorInfo.componentStack)));
            }
            else {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: getStyles() },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("h2", null, title),
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("details", { style: { whiteSpace: 'pre-wrap' } },
                        error && error.toString(),
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("br", null),
                        errorInfo.componentStack)));
            }
        }));
    };
    ErrorBoundaryAlert.defaultProps = {
        title: 'An unexpected error happened',
        style: 'alertbox',
    };
    return ErrorBoundaryAlert;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/FormField/FormField.tsx":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/FormField/FormField.tsx ***!
  \********************************************************************/
/*! exports provided: FormField */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormField", function() { return FormField; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../FormLabel/FormLabel */ "./packages/grafana-ui/src/components/FormLabel/FormLabel.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");




var defaultProps = {
    labelWidth: 6,
    inputWidth: 12,
};
/**
 * Default form field including label used in Grafana UI. Default input element is simple <input />. You can also pass
 * custom inputEl if required in which case inputWidth and inputProps are ignored.
 */
var FormField = function (_a) {
    var label = _a.label, tooltip = _a.tooltip, labelWidth = _a.labelWidth, inputWidth = _a.inputWidth, inputEl = _a.inputEl, className = _a.className, inputProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["label", "tooltip", "labelWidth", "inputWidth", "inputEl", "className"]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["cx"])('form-field', className) },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_2__["FormLabel"], { width: labelWidth, tooltip: tooltip }, label),
        inputEl || (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("input", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ type: "text", className: "gf-form-input " + (inputWidth ? "width-" + inputWidth : '') }, inputProps)))));
};
FormField.displayName = 'FormField';
FormField.defaultProps = defaultProps;


/***/ }),

/***/ "./packages/grafana-ui/src/components/FormLabel/FormLabel.tsx":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/FormLabel/FormLabel.tsx ***!
  \********************************************************************/
/*! exports provided: FormLabel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormLabel", function() { return FormLabel; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Tooltip/Tooltip */ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx");




var FormLabel = function (_a) {
    var children = _a.children, isFocused = _a.isFocused, isInvalid = _a.isInvalid, className = _a.className, htmlFor = _a.htmlFor, tooltip = _a.tooltip, width = _a.width, rest = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["children", "isFocused", "isInvalid", "className", "htmlFor", "tooltip", "width"]);
    var classes = classnames__WEBPACK_IMPORTED_MODULE_2___default()("gf-form-label width-" + (width ? width : '10'), className, {
        'gf-form-label--is-focused': isFocused,
        'gf-form-label--is-invalid': isInvalid,
    });
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("label", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ className: classes }, rest, { htmlFor: htmlFor }),
        children,
        tooltip && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_3__["Tooltip"], { placement: "top", content: tooltip, theme: 'info' },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-help-icon gf-form-help-icon--right-normal" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-info-circle" }))))));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/Gauge/Gauge.tsx":
/*!************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Gauge/Gauge.tsx ***!
  \************************************************************/
/*! exports provided: Gauge */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Gauge", function() { return Gauge; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "./packages/grafana-ui/src/utils/index.ts");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");





var FONT_SCALE = 1;
var Gauge = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Gauge, _super);
    function Gauge() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderVisualization = function () {
            var _a = _this.props, width = _a.width, value = _a.value, height = _a.height, onClick = _a.onClick;
            var autoProps = calculateGaugeAutoProps(width, height, value.title);
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: { height: autoProps.gaugeHeight + "px", width: '100%' }, ref: function (element) { return (_this.canvasElement = element); }, onClick: onClick }),
                autoProps.showLabel && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                        textAlign: 'center',
                        fontSize: autoProps.titleFontSize,
                        overflow: 'hidden',
                        textOverflow: 'ellipsis',
                        whiteSpace: 'nowrap',
                        position: 'relative',
                        width: '100%',
                        top: '-4px',
                        cursor: 'default',
                    } }, value.title))));
        };
        return _this;
    }
    Gauge.prototype.componentDidMount = function () {
        this.draw();
    };
    Gauge.prototype.componentDidUpdate = function () {
        this.draw();
    };
    Gauge.prototype.getFormattedThresholds = function () {
        var _a = this.props, maxValue = _a.maxValue, minValue = _a.minValue, thresholds = _a.thresholds, theme = _a.theme;
        var lastThreshold = thresholds[thresholds.length - 1];
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](thresholds.map(function (threshold, index) {
            if (index === 0) {
                return { value: minValue, color: Object(_utils__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(threshold.color, theme.type) };
            }
            var previousThreshold = thresholds[index - 1];
            return { value: threshold.value, color: Object(_utils__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(previousThreshold.color, theme.type) };
        }), [
            { value: maxValue, color: Object(_utils__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(lastThreshold.color, theme.type) },
        ]);
    };
    Gauge.prototype.getFontScale = function (length) {
        if (length > 12) {
            return FONT_SCALE - (length * 5) / 110;
        }
        return FONT_SCALE - (length * 5) / 101;
    };
    Gauge.prototype.draw = function () {
        var _a = this.props, maxValue = _a.maxValue, minValue = _a.minValue, showThresholdLabels = _a.showThresholdLabels, showThresholdMarkers = _a.showThresholdMarkers, width = _a.width, height = _a.height, theme = _a.theme, value = _a.value;
        var autoProps = calculateGaugeAutoProps(width, height, value.title);
        var dimension = Math.min(width, autoProps.gaugeHeight);
        var backgroundColor = Object(_themes__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
            dark: theme.colors.dark8,
            light: theme.colors.gray6,
        }, theme.type);
        var gaugeWidthReduceRatio = showThresholdLabels ? 1.5 : 1;
        var gaugeWidth = Math.min(dimension / 5.5, 40) / gaugeWidthReduceRatio;
        var thresholdMarkersWidth = gaugeWidth / 5;
        var fontSize = Math.min(dimension / 4, 100) * (value.text !== null ? this.getFontScale(value.text.length) : 1);
        var thresholdLabelFontSize = fontSize / 2.5;
        var options = {
            series: {
                gauges: {
                    gauge: {
                        min: minValue,
                        max: maxValue,
                        background: { color: backgroundColor },
                        border: { color: null },
                        shadow: { show: false },
                        width: gaugeWidth,
                    },
                    frame: { show: false },
                    label: { show: false },
                    layout: { margin: 0, thresholdWidth: 0, vMargin: 0 },
                    cell: { border: { width: 0 } },
                    threshold: {
                        values: this.getFormattedThresholds(),
                        label: {
                            show: showThresholdLabels,
                            margin: thresholdMarkersWidth + 1,
                            font: { size: thresholdLabelFontSize },
                        },
                        show: showThresholdMarkers,
                        width: thresholdMarkersWidth,
                    },
                    value: {
                        color: value.color,
                        formatter: function () {
                            return value.text;
                        },
                        font: { size: fontSize, family: theme.typography.fontFamily.sansSerif },
                    },
                    show: true,
                },
            },
        };
        var plotSeries = {
            data: [[0, value.numeric]],
            label: value.title,
        };
        try {
            jquery__WEBPACK_IMPORTED_MODULE_2___default.a.plot(this.canvasElement, [plotSeries], options);
        }
        catch (err) {
            console.log('Gauge rendering error', err, options, value);
        }
    };
    Gauge.prototype.render = function () {
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: {
                width: '100%',
                height: '100%',
                display: 'flex',
                flexDirection: 'column',
                justifyContent: 'center',
                overflow: 'hidden',
            }, className: this.props.className }, this.renderVisualization()));
    };
    Gauge.defaultProps = {
        maxValue: 100,
        minValue: 0,
        showThresholdMarkers: true,
        showThresholdLabels: false,
        thresholds: [],
    };
    return Gauge;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

function calculateGaugeAutoProps(width, height, title) {
    var showLabel = title !== null && title !== undefined;
    var titleFontSize = Math.min((width * 0.15) / 1.5, 20); // 20% of height * line-height, max 40px
    var titleHeight = titleFontSize * 1.5;
    var availableHeight = showLabel ? height - titleHeight : height;
    var gaugeHeight = Math.min(availableHeight, width);
    return {
        showLabel: showLabel,
        gaugeHeight: gaugeHeight,
        titleFontSize: titleFontSize,
    };
}


/***/ }),

/***/ "./packages/grafana-ui/src/components/Graph/Graph.tsx":
/*!************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Graph/Graph.tsx ***!
  \************************************************************/
/*! exports provided: Graph, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Graph", function() { return Graph; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_uniqBy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/uniqBy */ "./node_modules/lodash/uniqBy.js");
/* harmony import */ var lodash_uniqBy__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_uniqBy__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");

// Libraries



// Types

var Graph = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Graph, _super);
    function Graph() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.element = null;
        _this.onPlotSelected = function (event, ranges) {
            var onHorizontalRegionSelected = _this.props.onHorizontalRegionSelected;
            if (onHorizontalRegionSelected) {
                onHorizontalRegionSelected(ranges.xaxis.from, ranges.xaxis.to);
            }
        };
        return _this;
    }
    Graph.prototype.componentDidUpdate = function () {
        this.draw();
    };
    Graph.prototype.componentDidMount = function () {
        this.draw();
        if (this.element) {
            this.$element = jquery__WEBPACK_IMPORTED_MODULE_1___default()(this.element);
            this.$element.bind('plotselected', this.onPlotSelected);
        }
    };
    Graph.prototype.componentWillUnmount = function () {
        this.$element.unbind('plotselected', this.onPlotSelected);
    };
    Graph.prototype.getYAxes = function (series) {
        if (series.length === 0) {
            return [{ show: true, min: -1, max: 1 }];
        }
        return lodash_uniqBy__WEBPACK_IMPORTED_MODULE_3___default()(series.map(function (s) {
            var index = s.yAxis ? s.yAxis.index : 1;
            var min = s.yAxis && !isNaN(s.yAxis.min) ? s.yAxis.min : null;
            var tickDecimals = s.yAxis && !isNaN(s.yAxis.tickDecimals) ? s.yAxis.tickDecimals : null;
            return {
                show: true,
                index: index,
                position: index === 1 ? 'left' : 'right',
                min: min,
                tickDecimals: tickDecimals,
            };
        }), function (yAxisConfig) { return yAxisConfig.index; });
    };
    Graph.prototype.draw = function () {
        if (this.element === null) {
            return;
        }
        var _a = this.props, width = _a.width, series = _a.series, timeRange = _a.timeRange, showLines = _a.showLines, showBars = _a.showBars, showPoints = _a.showPoints, isStacked = _a.isStacked, lineWidth = _a.lineWidth, timeZone = _a.timeZone, onHorizontalRegionSelected = _a.onHorizontalRegionSelected;
        if (!width) {
            return;
        }
        var ticks = width / 100;
        var min = timeRange.from.valueOf();
        var max = timeRange.to.valueOf();
        var yaxes = this.getYAxes(series);
        var flotOptions = {
            legend: {
                show: false,
            },
            series: {
                stack: isStacked,
                lines: {
                    show: showLines,
                    linewidth: lineWidth,
                    zero: false,
                },
                points: {
                    show: showPoints,
                    fill: 1,
                    fillColor: false,
                    radius: 2,
                },
                bars: {
                    show: showBars,
                    fill: 1,
                    barWidth: 1,
                    zero: false,
                    lineWidth: lineWidth,
                },
                shadowSize: 0,
            },
            xaxis: {
                show: true,
                mode: 'time',
                min: min,
                max: max,
                label: 'Datetime',
                ticks: ticks,
                timeformat: timeFormat(ticks, min, max),
                timezone: timeZone ? timeZone : _grafana_data__WEBPACK_IMPORTED_MODULE_4__["DefaultTimeZone"],
            },
            yaxes: yaxes,
            grid: {
                minBorderMargin: 0,
                markings: [],
                backgroundColor: null,
                borderWidth: 0,
                // hoverable: true,
                clickable: true,
                color: '#a1a1a1',
                margin: { left: 0, right: 0 },
                labelMarginX: 0,
            },
            selection: {
                mode: onHorizontalRegionSelected ? 'x' : null,
                color: '#666',
            },
        };
        try {
            jquery__WEBPACK_IMPORTED_MODULE_1___default.a.plot(this.element, series, flotOptions);
        }
        catch (err) {
            console.log('Graph rendering error', err, flotOptions, series);
            throw new Error('Error rendering panel');
        }
    };
    Graph.prototype.render = function () {
        var _this = this;
        var _a = this.props, height = _a.height, series = _a.series;
        var noDataToBeDisplayed = series.length === 0;
        return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", { className: "graph-panel" },
            react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", { className: "graph-panel__chart", ref: function (e) { return (_this.element = e); }, style: { height: height } }),
            noDataToBeDisplayed && react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", { className: "datapoints-warning" }, "No data")));
    };
    Graph.defaultProps = {
        showLines: true,
        showPoints: false,
        showBars: false,
        isStacked: false,
        lineWidth: 1,
    };
    return Graph;
}(react__WEBPACK_IMPORTED_MODULE_2__["PureComponent"]));

// Copied from graph.ts
function timeFormat(ticks, min, max) {
    if (min && max && ticks) {
        var range = max - min;
        var secPerTick = range / ticks / 1000;
        var oneDay = 86400000;
        var oneYear = 31536000000;
        if (secPerTick <= 45) {
            return '%H:%M:%S';
        }
        if (secPerTick <= 7200 || range <= oneDay) {
            return '%H:%M';
        }
        if (secPerTick <= 80000) {
            return '%m/%d %H:%M';
        }
        if (secPerTick <= 2419200 || range <= oneYear) {
            return '%m/%d';
        }
        return '%Y-%m';
    }
    return '%H:%M';
}
/* harmony default export */ __webpack_exports__["default"] = (Graph);


/***/ }),

/***/ "./packages/grafana-ui/src/components/Graph/GraphLegend.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Graph/GraphLegend.tsx ***!
  \******************************************************************/
/*! exports provided: GraphLegend */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GraphLegend", function() { return GraphLegend; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Legend_Legend__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Legend/Legend */ "./packages/grafana-ui/src/components/Legend/Legend.tsx");
/* harmony import */ var _GraphLegendItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./GraphLegendItem */ "./packages/grafana-ui/src/components/Graph/GraphLegendItem.tsx");
/* harmony import */ var _Legend_LegendTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Legend/LegendTable */ "./packages/grafana-ui/src/components/Legend/LegendTable.tsx");
/* harmony import */ var _Legend_LegendList__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Legend/LegendList */ "./packages/grafana-ui/src/components/Legend/LegendList.tsx");
/* harmony import */ var lodash_union__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/union */ "./node_modules/lodash/union.js");
/* harmony import */ var lodash_union__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_union__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var lodash_sortBy__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash/sortBy */ "./node_modules/lodash/sortBy.js");
/* harmony import */ var lodash_sortBy__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash_sortBy__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes_index__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../themes/index */ "./packages/grafana-ui/src/themes/index.ts");











var GraphLegend = function (_a) {
    var items = _a.items, displayMode = _a.displayMode, sortKey = _a.sortBy, sortDesc = _a.sortDesc, onToggleSort = _a.onToggleSort, onSeriesAxisToggle = _a.onSeriesAxisToggle, placement = _a.placement, className = _a.className, graphLegendItemProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["items", "displayMode", "sortBy", "sortDesc", "onToggleSort", "onSeriesAxisToggle", "placement", "className"]);
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_8__["ThemeContext"]);
    if (displayMode === _Legend_Legend__WEBPACK_IMPORTED_MODULE_2__["LegendDisplayMode"].Table) {
        var columns = items
            .map(function (item) {
            if (item.displayValues) {
                return item.displayValues.map(function (i) { return i.title; });
            }
            return [];
        })
            .reduce(function (acc, current) {
            return lodash_union__WEBPACK_IMPORTED_MODULE_6___default()(acc, current.filter(function (item) { return !!item; }));
        }, ['']);
        var sortedItems = sortKey
            ? lodash_sortBy__WEBPACK_IMPORTED_MODULE_7___default()(items, function (item) {
                if (item.displayValues) {
                    var stat = item.displayValues.filter(function (stat) { return stat.title === sortKey; })[0];
                    return stat && stat.numeric;
                }
                return undefined;
            })
            : items;
        var legendTableEvenRowBackground_1 = Object(_themes_index__WEBPACK_IMPORTED_MODULE_10__["selectThemeVariant"])({
            dark: theme.colors.dark6,
            light: theme.colors.gray5,
        }, theme.type);
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Legend_LegendTable__WEBPACK_IMPORTED_MODULE_4__["LegendTable"], { className: Object(emotion__WEBPACK_IMPORTED_MODULE_9__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n          font-size: ", ";\n          th {\n            padding: ", " ", ";\n          }\n        "], ["\n          font-size: ", ";\n          th {\n            padding: ", " ", ";\n          }\n        "])), theme.typography.size.sm, theme.spacing.xxs, theme.spacing.sm), items: sortDesc ? sortedItems.reverse() : sortedItems, columns: columns, placement: placement, sortBy: sortKey, sortDesc: sortDesc, itemRenderer: function (item, index) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_GraphLegendItem__WEBPACK_IMPORTED_MODULE_3__["GraphLegendTableRow"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ key: item.label + "-" + index, item: item, onToggleAxis: function () {
                    if (onSeriesAxisToggle) {
                        onSeriesAxisToggle(item.label, item.yAxis === 1 ? 2 : 1);
                    }
                }, className: Object(emotion__WEBPACK_IMPORTED_MODULE_9__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n              background: ", ";\n            "], ["\n              background: ", ";\n            "])), index % 2 === 0 ? legendTableEvenRowBackground_1 : 'none') }, graphLegendItemProps))); }, onToggleSort: onToggleSort }));
    }
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Legend_LegendList__WEBPACK_IMPORTED_MODULE_5__["LegendList"], { items: items, placement: placement, itemRenderer: function (item) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_GraphLegendItem__WEBPACK_IMPORTED_MODULE_3__["GraphLegendListItem"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ item: item, onToggleAxis: function () {
                if (onSeriesAxisToggle) {
                    onSeriesAxisToggle(item.label, item.yAxis === 1 ? 2 : 1);
                }
            } }, graphLegendItemProps))); } }));
};
GraphLegend.displayName = 'GraphLegend';
var templateObject_1, templateObject_2;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Graph/GraphLegendItem.tsx":
/*!**********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Graph/GraphLegendItem.tsx ***!
  \**********************************************************************/
/*! exports provided: GraphLegendListItem, GraphLegendTableRow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GraphLegendListItem", function() { return GraphLegendListItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GraphLegendTableRow", function() { return GraphLegendTableRow; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _Legend_LegendSeriesIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Legend/LegendSeriesIcon */ "./packages/grafana-ui/src/components/Legend/LegendSeriesIcon.tsx");
/* harmony import */ var _Legend_LegendStatsList__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Legend/LegendStatsList */ "./packages/grafana-ui/src/components/Legend/LegendStatsList.tsx");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");







var GraphLegendListItem = function (_a) {
    var item = _a.item, onSeriesColorChange = _a.onSeriesColorChange, onToggleAxis = _a.onToggleAxis, onLabelClick = _a.onLabelClick;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__["ThemeContext"]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Legend_LegendSeriesIcon__WEBPACK_IMPORTED_MODULE_3__["LegendSeriesIcon"], { disabled: !onSeriesColorChange, color: item.color, onColorChange: function (color) {
                if (onSeriesColorChange) {
                    onSeriesColorChange(item.label, color);
                }
            }, onToggleAxis: onToggleAxis, yAxis: item.yAxis }),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { onClick: function (event) {
                if (onLabelClick) {
                    onLabelClick(item, event);
                }
            }, className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n          cursor: pointer;\n          white-space: pre-wrap;\n          color: ", ";\n        "], ["\n          cursor: pointer;\n          white-space: pre-wrap;\n          color: ", ";\n        "])), !item.isVisible && theme.colors.linkDisabled) }, item.label),
        item.displayValues && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Legend_LegendStatsList__WEBPACK_IMPORTED_MODULE_4__["LegendStatsList"], { stats: item.displayValues })));
};
var getStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_6__["stylesFactory"])(function (theme) {
    return {
        row: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      font-size: ", ";\n      td {\n        padding: ", " ", ";\n        white-space: nowrap;\n      }\n    "], ["\n      font-size: ", ";\n      td {\n        padding: ", " ", ";\n        white-space: nowrap;\n      }\n    "])), theme.typography.size.sm, theme.spacing.xxs, theme.spacing.sm),
        label: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      cursor: pointer;\n      white-space: nowrap;\n    "], ["\n      cursor: pointer;\n      white-space: nowrap;\n    "]))),
        itemWrapper: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      display: flex;\n      white-space: nowrap;\n    "], ["\n      display: flex;\n      white-space: nowrap;\n    "]))),
        value: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      text-align: right;\n    "], ["\n      text-align: right;\n    "]))),
        yAxisLabel: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      color: ", ";\n    "], ["\n      color: ", ";\n    "])), theme.colors.gray2),
    };
});
var GraphLegendTableRow = function (_a) {
    var item = _a.item, onSeriesColorChange = _a.onSeriesColorChange, onToggleAxis = _a.onToggleAxis, onLabelClick = _a.onLabelClick, className = _a.className;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__["ThemeContext"]);
    var styles = getStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])(styles.row, className) },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: styles.itemWrapper },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Legend_LegendSeriesIcon__WEBPACK_IMPORTED_MODULE_3__["LegendSeriesIcon"], { disabled: !!onSeriesColorChange, color: item.color, onColorChange: function (color) {
                        if (onSeriesColorChange) {
                            onSeriesColorChange(item.label, color);
                        }
                    }, onToggleAxis: onToggleAxis, yAxis: item.yAxis }),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { onClick: function (event) {
                        if (onLabelClick) {
                            onLabelClick(item, event);
                        }
                    }, className: styles.label },
                    item.label,
                    " ",
                    item.yAxis === 2 && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: styles.yAxisLabel }, "(right y-axis)")))),
        item.displayValues &&
            item.displayValues.map(function (stat, index) {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", { className: styles.value, key: stat.title + "-" + index }, stat.text));
            })));
};
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Graph/GraphSeriesToggler.tsx":
/*!*************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Graph/GraphSeriesToggler.tsx ***!
  \*************************************************************************/
/*! exports provided: GraphSeriesToggler */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GraphSeriesToggler", function() { return GraphSeriesToggler; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_difference__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/difference */ "./node_modules/lodash/difference.js");
/* harmony import */ var lodash_difference__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_difference__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_3__);




var GraphSeriesToggler = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](GraphSeriesToggler, _super);
    function GraphSeriesToggler(props) {
        var _this = _super.call(this, props) || this;
        _this.onSeriesToggle = _this.onSeriesToggle.bind(_this);
        _this.state = {
            hiddenSeries: [],
            toggledSeries: props.series,
        };
        return _this;
    }
    GraphSeriesToggler.prototype.componentDidUpdate = function (prevProps) {
        var series = this.props.series;
        if (!lodash_isEqual__WEBPACK_IMPORTED_MODULE_3___default()(prevProps.series, series)) {
            this.setState({ hiddenSeries: [], toggledSeries: series });
        }
    };
    GraphSeriesToggler.prototype.onSeriesToggle = function (label, event) {
        var _a = this.props, series = _a.series, onHiddenSeriesChanged = _a.onHiddenSeriesChanged;
        var hiddenSeries = this.state.hiddenSeries;
        if (event.ctrlKey || event.metaKey || event.shiftKey) {
            // Toggling series with key makes the series itself to toggle
            var newHiddenSeries_1 = hiddenSeries.indexOf(label) > -1
                ? hiddenSeries.filter(function (series) { return series !== label; })
                : hiddenSeries.concat([label]);
            var toggledSeries_1 = series.map(function (series) { return (tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, series, { isVisible: newHiddenSeries_1.indexOf(series.label) === -1 })); });
            this.setState({ hiddenSeries: newHiddenSeries_1, toggledSeries: toggledSeries_1 }, function () {
                return onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries_1) : undefined;
            });
            return;
        }
        // Toggling series with out key toggles all the series but the clicked one
        var allSeriesLabels = series.map(function (series) { return series.label; });
        var newHiddenSeries = hiddenSeries.length + 1 === allSeriesLabels.length ? [] : lodash_difference__WEBPACK_IMPORTED_MODULE_2___default()(allSeriesLabels, [label]);
        var toggledSeries = series.map(function (series) { return (tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, series, { isVisible: newHiddenSeries.indexOf(series.label) === -1 })); });
        this.setState({ hiddenSeries: newHiddenSeries, toggledSeries: toggledSeries }, function () {
            return onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries) : undefined;
        });
    };
    GraphSeriesToggler.prototype.render = function () {
        var children = this.props.children;
        var toggledSeries = this.state.toggledSeries;
        return children({
            onSeriesToggle: this.onSeriesToggle,
            toggledSeries: toggledSeries,
        });
    };
    return GraphSeriesToggler;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.Component));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Graph/GraphWithLegend.tsx":
/*!**********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Graph/GraphWithLegend.tsx ***!
  \**********************************************************************/
/*! exports provided: GraphWithLegend */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GraphWithLegend", function() { return GraphWithLegend; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _Graph__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Graph */ "./packages/grafana-ui/src/components/Graph/Graph.tsx");
/* harmony import */ var _GraphLegend__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./GraphLegend */ "./packages/grafana-ui/src/components/Graph/GraphLegend.tsx");
/* harmony import */ var _CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../CustomScrollbar/CustomScrollbar */ "./packages/grafana-ui/src/components/CustomScrollbar/CustomScrollbar.tsx");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");
// Libraries







var getGraphWithLegendStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_6__["stylesFactory"])(function (_a) {
    var placement = _a.placement;
    return ({
        wrapper: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    display: flex;\n    flex-direction: ", ";\n    height: 100%;\n  "], ["\n    display: flex;\n    flex-direction: ", ";\n    height: 100%;\n  "])), placement === 'under' ? 'column' : 'row'),
        graphContainer: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    min-height: 65%;\n    flex-grow: 1;\n  "], ["\n    min-height: 65%;\n    flex-grow: 1;\n  "]))),
        legendContainer: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    padding: 10px 0;\n    max-height: ", ";\n  "], ["\n    padding: 10px 0;\n    max-height: ", ";\n  "])), placement === 'under' ? '35%' : 'none'),
    });
});
var shouldHideLegendItem = function (data, hideEmpty, hideZero) {
    if (hideEmpty === void 0) { hideEmpty = false; }
    if (hideZero === void 0) { hideZero = false; }
    var isZeroOnlySeries = data.reduce(function (acc, current) { return acc + (current[1] || 0); }, 0) === 0;
    var isNullOnlySeries = !data.reduce(function (acc, current) { return acc && current[1] !== null; }, true);
    return (hideEmpty && isNullOnlySeries) || (hideZero && isZeroOnlySeries);
};
var GraphWithLegend = function (props) {
    var series = props.series, timeRange = props.timeRange, width = props.width, height = props.height, showBars = props.showBars, showLines = props.showLines, showPoints = props.showPoints, sortLegendBy = props.sortLegendBy, sortLegendDesc = props.sortLegendDesc, isLegendVisible = props.isLegendVisible, displayMode = props.displayMode, placement = props.placement, onSeriesAxisToggle = props.onSeriesAxisToggle, onSeriesColorChange = props.onSeriesColorChange, onSeriesToggle = props.onSeriesToggle, onToggleSort = props.onToggleSort, hideEmpty = props.hideEmpty, hideZero = props.hideZero, isStacked = props.isStacked, lineWidth = props.lineWidth, onHorizontalRegionSelected = props.onHorizontalRegionSelected, timeZone = props.timeZone;
    var _a = getGraphWithLegendStyles(props), graphContainer = _a.graphContainer, wrapper = _a.wrapper, legendContainer = _a.legendContainer;
    var legendItems = series.reduce(function (acc, s) {
        return shouldHideLegendItem(s.data, hideEmpty, hideZero)
            ? acc
            : acc.concat([
                {
                    label: s.label,
                    color: s.color,
                    isVisible: s.isVisible,
                    yAxis: s.yAxis.index,
                    displayValues: s.info || [],
                },
            ]);
    }, []);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: wrapper },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: graphContainer },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Graph__WEBPACK_IMPORTED_MODULE_3__["Graph"], { series: series.filter(function (s) { return !!s.isVisible; }), timeRange: timeRange, timeZone: timeZone, showLines: showLines, showPoints: showPoints, showBars: showBars, width: width, height: height, key: isLegendVisible ? 'legend-visible' : 'legend-invisible', isStacked: isStacked, lineWidth: lineWidth, onHorizontalRegionSelected: onHorizontalRegionSelected })),
        isLegendVisible && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: legendContainer },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_5__["CustomScrollbar"], { hideHorizontalTrack: true },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_GraphLegend__WEBPACK_IMPORTED_MODULE_4__["GraphLegend"], { items: legendItems, displayMode: displayMode, placement: placement, sortBy: sortLegendBy, sortDesc: sortLegendDesc, onLabelClick: function (item, event) {
                        if (onSeriesToggle) {
                            onSeriesToggle(item.label, event);
                        }
                    }, onSeriesColorChange: onSeriesColorChange, onSeriesAxisToggle: onSeriesAxisToggle, onToggleSort: onToggleSort }))))));
};
var templateObject_1, templateObject_2, templateObject_3;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Input/Input.tsx":
/*!************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Input/Input.tsx ***!
  \************************************************************/
/*! exports provided: InputStatus, Input */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "InputStatus", function() { return InputStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Input", function() { return Input; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "./packages/grafana-ui/src/utils/index.ts");




var InputStatus;
(function (InputStatus) {
    InputStatus["Invalid"] = "invalid";
    InputStatus["Valid"] = "valid";
})(InputStatus || (InputStatus = {}));
var Input = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Input, _super);
    function Input() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            error: null,
        };
        _this.validatorAsync = function (validationRules) {
            return function (evt) {
                var errors = Object(_utils__WEBPACK_IMPORTED_MODULE_3__["validate"])(evt.target.value, validationRules);
                _this.setState(function (prevState) {
                    return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, prevState, { error: errors ? errors[0] : null });
                });
            };
        };
        _this.populateEventPropsWithStatus = function (restProps, validationEvents) {
            var inputElementProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, restProps);
            if (!validationEvents) {
                return inputElementProps;
            }
            Object.keys(_utils__WEBPACK_IMPORTED_MODULE_3__["EventsWithValidation"]).forEach(function (eventName) {
                if (Object(_utils__WEBPACK_IMPORTED_MODULE_3__["hasValidationEvent"])(eventName, validationEvents) || restProps[eventName]) {
                    inputElementProps[eventName] = function (evt) { return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](_this, void 0, void 0, function () {
                        return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    evt.persist(); // Needed for async. https://reactjs.org/docs/events.html#event-pooling
                                    if (!Object(_utils__WEBPACK_IMPORTED_MODULE_3__["hasValidationEvent"])(eventName, validationEvents)) return [3 /*break*/, 2];
                                    return [4 /*yield*/, this.validatorAsync(validationEvents[eventName]).apply(this, [evt])];
                                case 1:
                                    _a.sent();
                                    _a.label = 2;
                                case 2:
                                    if (restProps[eventName]) {
                                        restProps[eventName].apply(null, [evt, this.status]);
                                    }
                                    return [2 /*return*/];
                            }
                        });
                    }); };
                }
            });
            return inputElementProps;
        };
        return _this;
    }
    Object.defineProperty(Input.prototype, "status", {
        get: function () {
            return this.state.error ? InputStatus.Invalid : InputStatus.Valid;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Input.prototype, "isInvalid", {
        get: function () {
            return this.status === InputStatus.Invalid;
        },
        enumerable: true,
        configurable: true
    });
    Input.prototype.render = function () {
        var _a = this.props, validationEvents = _a.validationEvents, className = _a.className, hideErrorMessage = _a.hideErrorMessage, restProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["validationEvents", "className", "hideErrorMessage"]);
        var error = this.state.error;
        var inputClassName = classnames__WEBPACK_IMPORTED_MODULE_2___default()('gf-form-input', { invalid: this.isInvalid }, className);
        var inputElementProps = this.populateEventPropsWithStatus(restProps, validationEvents);
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: { flexGrow: 1 } },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("input", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, inputElementProps, { className: inputClassName })),
            error && !hideErrorMessage && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, error)));
    };
    Input.defaultProps = {
        className: '',
    };
    return Input;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/JSONFormatter/JSONFormatter.tsx":
/*!****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/JSONFormatter/JSONFormatter.tsx ***!
  \****************************************************************************/
/*! exports provided: JSONFormatter */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JSONFormatter", function() { return JSONFormatter; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _json_explorer_json_explorer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./json_explorer/json_explorer */ "./packages/grafana-ui/src/components/JSONFormatter/json_explorer/json_explorer.ts");


 // We have made some monkey-patching of json-formatter-js so we can't switch right now
var JSONFormatter = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](JSONFormatter, _super);
    function JSONFormatter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.wrapperRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["createRef"])();
        _this.renderJson = function () {
            var _a = _this.props, json = _a.json, config = _a.config, open = _a.open, onDidRender = _a.onDidRender;
            var wrapperEl = _this.wrapperRef.current;
            var formatter = new _json_explorer_json_explorer__WEBPACK_IMPORTED_MODULE_2__["JsonExplorer"](json, open, config);
            // @ts-ignore
            var hasChildren = wrapperEl.hasChildNodes();
            if (hasChildren) {
                // @ts-ignore
                wrapperEl.replaceChild(formatter.render(), wrapperEl.lastChild);
            }
            else {
                // @ts-ignore
                wrapperEl.appendChild(formatter.render());
            }
            if (onDidRender) {
                onDidRender(formatter.json);
            }
        };
        return _this;
    }
    JSONFormatter.prototype.componentDidMount = function () {
        this.renderJson();
    };
    JSONFormatter.prototype.componentDidUpdate = function () {
        this.renderJson();
    };
    JSONFormatter.prototype.render = function () {
        var className = this.props.className;
        return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: className, ref: this.wrapperRef });
    };
    JSONFormatter.defaultProps = {
        open: 3,
        config: {
            animateOpen: true,
        },
    };
    return JSONFormatter;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/JSONFormatter/json_explorer/helpers.ts":
/*!***********************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/JSONFormatter/json_explorer/helpers.ts ***!
  \***********************************************************************************/
/*! exports provided: isObject, getObjectName, getType, getValuePreview, getPreview, cssClass, createElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isObject", function() { return isObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getObjectName", function() { return getObjectName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getType", function() { return getType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getValuePreview", function() { return getValuePreview; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getPreview", function() { return getPreview; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cssClass", function() { return cssClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createElement", function() { return createElement; });
// Based on work https://github.com/mohsen1/json-formatter-js
// License MIT, Copyright (c) 2015 Mohsen Azimi
/*
 * Escapes `"` characters from string
 */
function escapeString(str) {
    return str.replace('"', '"');
}
/*
 * Determines if a value is an object
 */
function isObject(value) {
    var type = typeof value;
    return !!value && type === 'object';
}
/*
 * Gets constructor name of an object.
 * From http://stackoverflow.com/a/332429
 *
 */
function getObjectName(object) {
    if (object === undefined) {
        return '';
    }
    if (object === null) {
        return 'Object';
    }
    if (typeof object === 'object' && !object.constructor) {
        return 'Object';
    }
    var funcNameRegex = /function ([^(]*)/;
    var results = funcNameRegex.exec(object.constructor.toString());
    if (results && results.length > 1) {
        return results[1];
    }
    else {
        return '';
    }
}
/*
 * Gets type of an object. Returns "null" for null objects
 */
function getType(object) {
    if (object === null) {
        return 'null';
    }
    return typeof object;
}
/*
 * Generates inline preview for a JavaScript object based on a value
 */
function getValuePreview(object, value) {
    var type = getType(object);
    if (type === 'null' || type === 'undefined') {
        return type;
    }
    if (type === 'string') {
        value = '"' + escapeString(value) + '"';
    }
    if (type === 'function') {
        // Remove content of the function
        return (object
            .toString()
            .replace(/[\r\n]/g, '')
            .replace(/\{.*\}/, '') + '{…}');
    }
    return value;
}
/*
 * Generates inline preview for a JavaScript object
 */
var value = '';
function getPreview(obj) {
    if (isObject(obj)) {
        value = getObjectName(obj);
        if (Array.isArray(obj)) {
            value += '[' + obj.length + ']';
        }
    }
    else {
        value = getValuePreview(obj, obj.toString());
    }
    return value;
}
/*
 * Generates a prefixed CSS class name
 */
function cssClass(className) {
    return "json-formatter-" + className;
}
/*
 * Creates a new DOM element with given type and class
 * TODO: move me to helpers
 */
function createElement(type, className, content) {
    var el = document.createElement(type);
    if (className) {
        el.classList.add(cssClass(className));
    }
    if (content !== undefined) {
        if (content instanceof Node) {
            el.appendChild(content);
        }
        else {
            el.appendChild(document.createTextNode(String(content)));
        }
    }
    return el;
}


/***/ }),

/***/ "./packages/grafana-ui/src/components/JSONFormatter/json_explorer/json_explorer.ts":
/*!*****************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/JSONFormatter/json_explorer/json_explorer.ts ***!
  \*****************************************************************************************/
/*! exports provided: JsonExplorer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonExplorer", function() { return JsonExplorer; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./packages/grafana-ui/src/components/JSONFormatter/json_explorer/helpers.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
// Based on work https://github.com/mohsen1/json-formatter-js
// License MIT, Copyright (c) 2015 Mohsen Azimi


var DATE_STRING_REGEX = /(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;
var PARTIAL_DATE_REGEX = /\d{2}:\d{2}:\d{2} GMT-\d{4}/;
var JSON_DATE_REGEX = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/;
// When toggleing, don't animated removal or addition of more than a few items
var MAX_ANIMATED_TOGGLE_ITEMS = 10;
var requestAnimationFrame = window.requestAnimationFrame ||
    (function (cb) {
        cb();
        return 0;
    });
var _defaultConfig = {
    animateOpen: true,
    animateClose: true,
};
/**
 * @class JsonExplorer
 *
 * JsonExplorer allows you to render JSON objects in HTML with a
 * **collapsible** navigation.
 */
var JsonExplorer = /** @class */ (function () {
    /**
     * @param {object} json The JSON object you want to render. It has to be an
     * object or array. Do NOT pass raw JSON string.
     *
     * @param {number} [open=1] his number indicates up to how many levels the
     * rendered tree should expand. Set it to `0` to make the whole tree collapsed
     * or set it to `Infinity` to expand the tree deeply
     *
     * @param {object} [config=defaultConfig] -
     *  defaultConfig = {
     *   hoverPreviewEnabled: false,
     *   hoverPreviewArrayCount: 100,
     *   hoverPreviewFieldCount: 5
     * }
     *
     * Available configurations:
     *  #####Hover Preview
     * * `hoverPreviewEnabled`:  enable preview on hover
     * * `hoverPreviewArrayCount`: number of array items to show in preview Any
     *    array larger than this number will be shown as `Array[XXX]` where `XXX`
     *    is length of the array.
     * * `hoverPreviewFieldCount`: number of object properties to show for object
     *   preview. Any object with more properties that thin number will be
     *   truncated.
     *
     * @param {string} [key=undefined] The key that this object in it's parent
     * context
     */
    function JsonExplorer(json, open, config, key) {
        if (open === void 0) { open = 1; }
        if (config === void 0) { config = _defaultConfig; }
        this.json = json;
        this.open = open;
        this.config = config;
        this.key = key;
        // Hold the open state after the toggler is used
        this._isOpen = null;
        // A reference to the element that we render to
        this.element = null;
        this.skipChildren = false;
    }
    Object.defineProperty(JsonExplorer.prototype, "isOpen", {
        /*
         * is formatter open?
         */
        get: function () {
            if (this._isOpen !== null) {
                return this._isOpen;
            }
            else {
                return this.open > 0;
            }
        },
        /*
         * set open state (from toggler)
         */
        set: function (value) {
            this._isOpen = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "isDate", {
        /*
         * is this a date string?
         */
        get: function () {
            return (this.type === 'string' &&
                (DATE_STRING_REGEX.test(this.json) || JSON_DATE_REGEX.test(this.json) || PARTIAL_DATE_REGEX.test(this.json)));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "isUrl", {
        /*
         * is this a URL string?
         */
        get: function () {
            return this.type === 'string' && this.json.indexOf('http') === 0;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "isArray", {
        /*
         * is this an array?
         */
        get: function () {
            return Array.isArray(this.json);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "isObject", {
        /*
         * is this an object?
         * Note: In this context arrays are object as well
         */
        get: function () {
            return Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["isObject"])(this.json);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "isEmptyObject", {
        /*
         * is this an empty object with no properties?
         */
        get: function () {
            return !this.keys.length && !this.isArray;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "isEmpty", {
        /*
         * is this an empty object or array?
         */
        get: function () {
            return this.isEmptyObject || (this.keys && !this.keys.length && this.isArray);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "hasKey", {
        /*
         * did we receive a key argument?
         * This means that the formatter was called as a sub formatter of a parent formatter
         */
        get: function () {
            return typeof this.key !== 'undefined';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "constructorName", {
        /*
         * if this is an object, get constructor function name
         */
        get: function () {
            return Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["getObjectName"])(this.json);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "type", {
        /*
         * get type of this value
         * Possible values: all JavaScript primitive types plus "array" and "null"
         */
        get: function () {
            return Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["getType"])(this.json);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(JsonExplorer.prototype, "keys", {
        /*
         * get object keys
         * If there is an empty key we pad it wit quotes to make it visible
         */
        get: function () {
            if (this.isObject) {
                return Object.keys(this.json).map(function (key) { return (key ? key : '""'); });
            }
            else {
                return [];
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Toggles `isOpen` state
     *
     */
    JsonExplorer.prototype.toggleOpen = function () {
        this.isOpen = !this.isOpen;
        if (this.element) {
            if (this.isOpen) {
                this.appendChildren(this.config.animateOpen);
            }
            else {
                this.removeChildren(this.config.animateClose);
            }
            this.element.classList.toggle(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('open'));
        }
    };
    /**
     * Open all children up to a certain depth.
     * Allows actions such as expand all/collapse all
     *
     */
    JsonExplorer.prototype.openAtDepth = function (depth) {
        if (depth === void 0) { depth = 1; }
        if (depth < 0) {
            return;
        }
        this.open = depth;
        this.isOpen = depth !== 0;
        if (this.element) {
            this.removeChildren(false);
            if (depth === 0) {
                this.element.classList.remove(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('open'));
            }
            else {
                this.appendChildren(this.config.animateOpen);
                this.element.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('open'));
            }
        }
    };
    JsonExplorer.prototype.isNumberArray = function () {
        return this.json.length > 0 && this.json.length < 4 && (lodash__WEBPACK_IMPORTED_MODULE_1___default.a.isNumber(this.json[0]) || lodash__WEBPACK_IMPORTED_MODULE_1___default.a.isNumber(this.json[1]));
    };
    JsonExplorer.prototype.renderArray = function () {
        var arrayWrapperSpan = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span');
        arrayWrapperSpan.appendChild(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'bracket', '['));
        // some pretty handling of number arrays
        if (this.isNumberArray()) {
            this.json.forEach(function (val, index) {
                if (index > 0) {
                    arrayWrapperSpan.appendChild(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'array-comma', ','));
                }
                arrayWrapperSpan.appendChild(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'number', val));
            });
            this.skipChildren = true;
        }
        else {
            arrayWrapperSpan.appendChild(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'number', this.json.length));
        }
        arrayWrapperSpan.appendChild(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'bracket', ']'));
        return arrayWrapperSpan;
    };
    /**
     * Renders an HTML element and installs event listeners
     *
     * @returns {HTMLDivElement}
     */
    JsonExplorer.prototype.render = function (skipRoot) {
        if (skipRoot === void 0) { skipRoot = false; }
        // construct the root element and assign it to this.element
        this.element = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('div', 'row');
        // construct the toggler link
        var togglerLink = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('a', 'toggler-link');
        var togglerIcon = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'toggler');
        // if this is an object we need a wrapper span (toggler)
        if (this.isObject) {
            togglerLink.appendChild(togglerIcon);
        }
        // if this is child of a parent formatter we need to append the key
        if (this.hasKey) {
            togglerLink.appendChild(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'key', this.key + ":"));
        }
        // Value for objects and arrays
        if (this.isObject) {
            // construct the value holder element
            var value = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'value');
            // we need a wrapper span for objects
            var objectWrapperSpan = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span');
            // get constructor name and append it to wrapper span
            var constructorName = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span', 'constructor-name', this.constructorName);
            objectWrapperSpan.appendChild(constructorName);
            // if it's an array append the array specific elements like brackets and length
            if (this.isArray) {
                var arrayWrapperSpan = this.renderArray();
                objectWrapperSpan.appendChild(arrayWrapperSpan);
            }
            // append object wrapper span to toggler link
            value.appendChild(objectWrapperSpan);
            togglerLink.appendChild(value);
            // Primitive values
        }
        else {
            // make a value holder element
            var value = this.isUrl ? Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('a') : Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('span');
            // add type and other type related CSS classes
            value.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])(this.type));
            if (this.isDate) {
                value.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('date'));
            }
            if (this.isUrl) {
                value.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('url'));
                value.setAttribute('href', this.json);
            }
            // Append value content to value element
            var valuePreview = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["getValuePreview"])(this.json, this.json);
            value.appendChild(document.createTextNode(valuePreview));
            // append the value element to toggler link
            togglerLink.appendChild(value);
        }
        // construct a children element
        var children = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["createElement"])('div', 'children');
        // set CSS classes for children
        if (this.isObject) {
            children.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('object'));
        }
        if (this.isArray) {
            children.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('array'));
        }
        if (this.isEmpty) {
            children.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('empty'));
        }
        // set CSS classes for root element
        if (this.config && this.config.theme) {
            this.element.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])(this.config.theme));
        }
        if (this.isOpen) {
            this.element.classList.add(Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('open'));
        }
        // append toggler and children elements to root element
        if (!skipRoot) {
            this.element.appendChild(togglerLink);
        }
        if (!this.skipChildren) {
            this.element.appendChild(children);
        }
        else {
            // remove togglerIcon
            togglerLink.removeChild(togglerIcon);
        }
        // if formatter is set to be open call appendChildren
        if (this.isObject && this.isOpen) {
            this.appendChildren();
        }
        // add event listener for toggling
        if (this.isObject) {
            togglerLink.addEventListener('click', this.toggleOpen.bind(this));
        }
        return this.element;
    };
    /**
     * Appends all the children to children element
     * Animated option is used when user triggers this via a click
     */
    JsonExplorer.prototype.appendChildren = function (animated) {
        var _this = this;
        if (animated === void 0) { animated = false; }
        var children = this.element && this.element.querySelector("div." + Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('children'));
        if (!children || this.isEmpty) {
            return;
        }
        if (animated) {
            var index_1 = 0;
            var addAChild_1 = function () {
                var key = _this.keys[index_1];
                var formatter = new JsonExplorer(_this.json[key], _this.open - 1, _this.config, key);
                children.appendChild(formatter.render());
                index_1 += 1;
                if (index_1 < _this.keys.length) {
                    if (index_1 > MAX_ANIMATED_TOGGLE_ITEMS) {
                        addAChild_1();
                    }
                    else {
                        requestAnimationFrame(addAChild_1);
                    }
                }
            };
            requestAnimationFrame(addAChild_1);
        }
        else {
            this.keys.forEach(function (key) {
                var formatter = new JsonExplorer(_this.json[key], _this.open - 1, _this.config, key);
                children.appendChild(formatter.render());
            });
        }
    };
    /**
     * Removes all the children from children element
     * Animated option is used when user triggers this via a click
     */
    JsonExplorer.prototype.removeChildren = function (animated) {
        if (animated === void 0) { animated = false; }
        var childrenElement = this.element && this.element.querySelector("div." + Object(_helpers__WEBPACK_IMPORTED_MODULE_0__["cssClass"])('children'));
        if (animated) {
            var childrenRemoved_1 = 0;
            var removeAChild_1 = function () {
                if (childrenElement && childrenElement.children.length) {
                    childrenElement.removeChild(childrenElement.children[0]);
                    childrenRemoved_1 += 1;
                    if (childrenRemoved_1 > MAX_ANIMATED_TOGGLE_ITEMS) {
                        removeAChild_1();
                    }
                    else {
                        requestAnimationFrame(removeAChild_1);
                    }
                }
            };
            requestAnimationFrame(removeAChild_1);
        }
        else {
            if (childrenElement) {
                childrenElement.innerHTML = '';
            }
        }
    };
    return JsonExplorer;
}());



/***/ }),

/***/ "./packages/grafana-ui/src/components/Legend/Legend.tsx":
/*!**************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Legend/Legend.tsx ***!
  \**************************************************************/
/*! exports provided: LegendDisplayMode, LegendList, LegendTable */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegendDisplayMode", function() { return LegendDisplayMode; });
/* harmony import */ var _LegendList__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LegendList */ "./packages/grafana-ui/src/components/Legend/LegendList.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendList", function() { return _LegendList__WEBPACK_IMPORTED_MODULE_0__["LegendList"]; });

/* harmony import */ var _LegendTable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LegendTable */ "./packages/grafana-ui/src/components/Legend/LegendTable.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendTable", function() { return _LegendTable__WEBPACK_IMPORTED_MODULE_1__["LegendTable"]; });



var LegendDisplayMode;
(function (LegendDisplayMode) {
    LegendDisplayMode["List"] = "list";
    LegendDisplayMode["Table"] = "table";
})(LegendDisplayMode || (LegendDisplayMode = {}));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Legend/LegendList.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Legend/LegendList.tsx ***!
  \******************************************************************/
/*! exports provided: LegendList */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegendList", function() { return LegendList; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _List_InlineList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../List/InlineList */ "./packages/grafana-ui/src/components/List/InlineList.tsx");
/* harmony import */ var _List_List__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../List/List */ "./packages/grafana-ui/src/components/List/List.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");







var getStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_6__["stylesFactory"])(function (theme) { return ({
    item: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    padding-left: 10px;\n    display: flex;\n    font-size: ", ";\n    white-space: nowrap;\n  "], ["\n    padding-left: 10px;\n    display: flex;\n    font-size: ", ";\n    white-space: nowrap;\n  "])), theme.typography.size.sm),
    wrapper: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    display: flex;\n    flex-wrap: wrap;\n    justify-content: space-between;\n    width: 100%;\n  "], ["\n    display: flex;\n    flex-wrap: wrap;\n    justify-content: space-between;\n    width: 100%;\n  "]))),
    section: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    display: flex;\n  "], ["\n    display: flex;\n  "]))),
    sectionRight: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    justify-content: flex-end;\n    flex-grow: 1;\n  "], ["\n    justify-content: flex-end;\n    flex-grow: 1;\n  "]))),
}); });
var LegendList = function (_a) {
    var items = _a.items, itemRenderer = _a.itemRenderer, placement = _a.placement, className = _a.className;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__["ThemeContext"]);
    var styles = getStyles(theme);
    var renderItem = function (item, index) {
        return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: styles.item }, itemRenderer ? itemRenderer(item, index) : item.label);
    };
    var getItemKey = function (item) { return "" + item.label; };
    return placement === 'under' ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["cx"])(styles.wrapper, className) },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.section },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_List_InlineList__WEBPACK_IMPORTED_MODULE_2__["InlineList"], { items: items.filter(function (item) { return item.yAxis === 1; }), renderItem: renderItem, getItemKey: getItemKey })),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["cx"])(styles.section, styles.sectionRight) },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_List_InlineList__WEBPACK_IMPORTED_MODULE_2__["InlineList"], { items: items.filter(function (item) { return item.yAxis !== 1; }), renderItem: renderItem, getItemKey: getItemKey })))) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_List_List__WEBPACK_IMPORTED_MODULE_3__["List"], { items: items, renderItem: renderItem, getItemKey: getItemKey, className: className }));
};
LegendList.displayName = 'LegendList';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Legend/LegendSeriesIcon.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Legend/LegendSeriesIcon.tsx ***!
  \************************************************************************/
/*! exports provided: LegendSeriesIcon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegendSeriesIcon", function() { return LegendSeriesIcon; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _ColorPicker_ColorPicker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ColorPicker/ColorPicker */ "./packages/grafana-ui/src/components/ColorPicker/ColorPicker.tsx");
/* harmony import */ var _SeriesIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SeriesIcon */ "./packages/grafana-ui/src/components/Legend/SeriesIcon.tsx");





var LegendSeriesIcon = function (_a) {
    var disabled = _a.disabled, yAxis = _a.yAxis, color = _a.color, onColorChange = _a.onColorChange, onToggleAxis = _a.onToggleAxis;
    var iconProps = {
        color: color,
    };
    if (!disabled) {
        iconProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, iconProps, { className: 'pointer' });
    }
    return disabled ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])('graph-legend-icon', disabled && Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n            cursor: default;\n          "], ["\n            cursor: default;\n          "])))) },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_SeriesIcon__WEBPACK_IMPORTED_MODULE_4__["SeriesIcon"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, iconProps)))) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ColorPicker_ColorPicker__WEBPACK_IMPORTED_MODULE_3__["SeriesColorPicker"], { yaxis: yAxis, color: color, onChange: onColorChange, onToggleAxis: onToggleAxis, enableNamedColors: true }, function (_a) {
        var ref = _a.ref, showColorPicker = _a.showColorPicker, hideColorPicker = _a.hideColorPicker;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { ref: ref, onClick: showColorPicker, onMouseLeave: hideColorPicker, className: "graph-legend-icon" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_SeriesIcon__WEBPACK_IMPORTED_MODULE_4__["SeriesIcon"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, iconProps))));
    }));
};
LegendSeriesIcon.displayName = 'LegendSeriesIcon';
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Legend/LegendStatsList.tsx":
/*!***********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Legend/LegendStatsList.tsx ***!
  \***********************************************************************/
/*! exports provided: LegendStatsList */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegendStatsList", function() { return LegendStatsList; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _List_InlineList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../List/InlineList */ "./packages/grafana-ui/src/components/List/InlineList.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var lodash_capitalize__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/capitalize */ "./node_modules/lodash/capitalize.js");
/* harmony import */ var lodash_capitalize__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_capitalize__WEBPACK_IMPORTED_MODULE_4__);





var LegendItemStat = function (_a) {
    var stat = _a.stat;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n        margin-left: 6px;\n      "], ["\n        margin-left: 6px;\n      "]))) },
        stat.title && lodash_capitalize__WEBPACK_IMPORTED_MODULE_4___default()(stat.title) + ":",
        " ",
        stat.text));
};
LegendItemStat.displayName = 'LegendItemStat';
var LegendStatsList = function (_a) {
    var stats = _a.stats;
    if (stats.length === 0) {
        return null;
    }
    return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_List_InlineList__WEBPACK_IMPORTED_MODULE_2__["InlineList"], { items: stats, renderItem: function (stat) { return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(LegendItemStat, { stat: stat }); } });
};
LegendStatsList.displayName = 'LegendStatsList';
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Legend/LegendTable.tsx":
/*!*******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Legend/LegendTable.tsx ***!
  \*******************************************************************/
/*! exports provided: LegendTable */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegendTable", function() { return LegendTable; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");




var LegendTable = function (_a) {
    var items = _a.items, columns = _a.columns, sortBy = _a.sortBy, sortDesc = _a.sortDesc, itemRenderer = _a.itemRenderer, className = _a.className, onToggleSort = _a.onToggleSort;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("table", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])(Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n          width: 100%;\n          td {\n            padding: 2px 10px;\n          }\n        "], ["\n          width: 100%;\n          td {\n            padding: 2px 10px;\n          }\n        "]))), className) },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("thead", null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", null, columns.map(function (columnHeader) {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("th", { key: columnHeader, className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n                  color: ", ";\n                  font-weight: bold;\n                  text-align: right;\n                  cursor: pointer;\n                "], ["\n                  color: ", ";\n                  font-weight: bold;\n                  text-align: right;\n                  cursor: pointer;\n                "])), theme.colors.blue), onClick: function () {
                        if (onToggleSort) {
                            onToggleSort(columnHeader);
                        }
                    } },
                    columnHeader,
                    sortBy === columnHeader && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])("fa fa-caret-" + (sortDesc ? 'down' : 'up'), Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n                        margin-left: ", ";\n                      "], ["\n                        margin-left: ", ";\n                      "])), theme.spacing.sm)) }))));
            }))),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tbody", null, items.map(function (item, index) {
            return itemRenderer ? (itemRenderer(item, index)) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", { key: item.label + "-" + index },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null, item.label)));
        }))));
};
var templateObject_1, templateObject_2, templateObject_3;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Legend/SeriesIcon.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Legend/SeriesIcon.tsx ***!
  \******************************************************************/
/*! exports provided: SeriesIcon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SeriesIcon", function() { return SeriesIcon; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");


var SeriesIcon = function (_a) {
    var color = _a.color, className = _a.className;
    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["cx"])('fa', 'fa-minus', className), style: { color: color } });
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/List/AbstractList.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/List/AbstractList.tsx ***!
  \******************************************************************/
/*! exports provided: AbstractList */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AbstractList", function() { return AbstractList; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");




var getStyles = Object(_themes__WEBPACK_IMPORTED_MODULE_3__["stylesFactory"])(function (inlineList) {
    if (inlineList === void 0) { inlineList = false; }
    return ({
        list: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    list-style-type: none;\n    margin: 0;\n    padding: 0;\n  "], ["\n    list-style-type: none;\n    margin: 0;\n    padding: 0;\n  "]))),
        item: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    display: ", ";\n  "], ["\n    display: ", ";\n  "])), (inlineList && 'inline-block') || 'block'),
    });
});
var AbstractList = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](AbstractList, _super);
    function AbstractList(props) {
        return _super.call(this, props) || this;
    }
    AbstractList.prototype.render = function () {
        var _a = this.props, items = _a.items, renderItem = _a.renderItem, getItemKey = _a.getItemKey, className = _a.className, inline = _a.inline;
        var styles = getStyles(inline);
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("ul", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])(styles.list, className) }, items.map(function (item, i) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("li", { className: styles.item, key: getItemKey ? getItemKey(item) : i }, renderItem(item, i)));
        })));
    };
    return AbstractList;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));

var templateObject_1, templateObject_2;


/***/ }),

/***/ "./packages/grafana-ui/src/components/List/InlineList.tsx":
/*!****************************************************************!*\
  !*** ./packages/grafana-ui/src/components/List/InlineList.tsx ***!
  \****************************************************************/
/*! exports provided: InlineList */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "InlineList", function() { return InlineList; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _AbstractList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AbstractList */ "./packages/grafana-ui/src/components/List/AbstractList.tsx");



var InlineList = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](InlineList, _super);
    function InlineList() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    InlineList.prototype.render = function () {
        return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_AbstractList__WEBPACK_IMPORTED_MODULE_2__["AbstractList"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ inline: true }, this.props));
    };
    return InlineList;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));



/***/ }),

/***/ "./packages/grafana-ui/src/components/List/List.tsx":
/*!**********************************************************!*\
  !*** ./packages/grafana-ui/src/components/List/List.tsx ***!
  \**********************************************************/
/*! exports provided: List */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "List", function() { return List; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _AbstractList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AbstractList */ "./packages/grafana-ui/src/components/List/AbstractList.tsx");



var List = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](List, _super);
    function List() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    List.prototype.render = function () {
        return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_AbstractList__WEBPACK_IMPORTED_MODULE_2__["AbstractList"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, this.props));
    };
    return List;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));



/***/ }),

/***/ "./packages/grafana-ui/src/components/LoadingPlaceholder/LoadingPlaceholder.tsx":
/*!**************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/LoadingPlaceholder/LoadingPlaceholder.tsx ***!
  \**************************************************************************************/
/*! exports provided: LoadingPlaceholder */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoadingPlaceholder", function() { return LoadingPlaceholder; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var LoadingPlaceholder = function (_a) {
    var text = _a.text;
    return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "gf-form-group" },
        text,
        " ",
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", { className: "fa fa-spinner fa-spin" })));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogLabel.tsx":
/*!**************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogLabel.tsx ***!
  \**************************************************************/
/*! exports provided: LogLabel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogLabel", function() { return LogLabel; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _LogLabelStats__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./LogLabelStats */ "./packages/grafana-ui/src/components/Logs/LogLabelStats.tsx");
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");







var getStyles = function (theme) {
    return {
        logsLabel: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-label;\n      display: flex;\n      padding: 0 2px;\n      background-color: ", ";\n      border-radius: ", ";\n      margin: 0 4px 2px 0;\n      text-overflow: ellipsis;\n      white-space: nowrap;\n      overflow: hidden;\n    "], ["\n      label: logs-label;\n      display: flex;\n      padding: 0 2px;\n      background-color: ", ";\n      border-radius: ", ";\n      margin: 0 4px 2px 0;\n      text-overflow: ellipsis;\n      white-space: nowrap;\n      overflow: hidden;\n    "])), Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_5__["selectThemeVariant"])({ light: theme.colors.gray5, dark: theme.colors.dark6 }, theme.type), theme.border.radius),
        logsLabelValue: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-label__value;\n      display: inline-block;\n      max-width: 20em;\n      text-overflow: ellipsis;\n      overflow: hidden;\n    "], ["\n      label: logs-label__value;\n      display: inline-block;\n      max-width: 20em;\n      text-overflow: ellipsis;\n      overflow: hidden;\n    "]))),
        logsLabelIcon: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-label__icon;\n      border-left: solid 1px ", ";\n      padding: 0 2px;\n      cursor: pointer;\n      margin-left: 2px;\n    "], ["\n      label: logs-label__icon;\n      border-left: solid 1px ", ";\n      padding: 0 2px;\n      cursor: pointer;\n      margin-left: 2px;\n    "])), Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_5__["selectThemeVariant"])({ light: theme.colors.gray5, dark: theme.colors.dark1 }, theme.type)),
        logsLabelStats: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      position: absolute;\n      top: 1.25em;\n      left: -10px;\n      z-index: 100;\n      justify-content: space-between;\n      box-shadow: 0 0 20px ", ";\n    "], ["\n      position: absolute;\n      top: 1.25em;\n      left: -10px;\n      z-index: 100;\n      justify-content: space-between;\n      box-shadow: 0 0 20px ", ";\n    "])), Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_5__["selectThemeVariant"])({ light: theme.colors.white, dark: theme.colors.black }, theme.type)),
    };
};
var UnThemedLogLabel = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](UnThemedLogLabel, _super);
    function UnThemedLogLabel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            stats: [],
            showStats: false,
        };
        _this.onClickClose = function () {
            _this.setState({ showStats: false });
        };
        _this.onClickLabel = function () {
            var _a = _this.props, onClickLabel = _a.onClickLabel, label = _a.label, value = _a.value;
            if (onClickLabel) {
                onClickLabel(label, value);
            }
        };
        _this.onClickStats = function () {
            _this.setState(function (state) {
                if (state.showStats) {
                    return { showStats: false, stats: [] };
                }
                var allRows = _this.props.getRows();
                var stats = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["calculateLogsLabelStats"])(allRows, _this.props.label);
                return { showStats: true, stats: stats };
            });
        };
        return _this;
    }
    UnThemedLogLabel.prototype.render = function () {
        var _a = this.props, getRows = _a.getRows, label = _a.label, plain = _a.plain, value = _a.value, theme = _a.theme;
        var styles = getStyles(theme);
        var _b = this.state, showStats = _b.showStats, stats = _b.stats;
        var tooltip = label + ": " + value;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([styles.logsLabel]) },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([styles.logsLabelValue]), title: tooltip }, value),
            !plain && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { title: "Filter for label", onClick: this.onClickLabel, className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([styles.logsLabelIcon, 'fa fa-search-plus']) })),
            !plain && getRows && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { onClick: this.onClickStats, className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([styles.logsLabelIcon, 'fa fa-signal']) })),
            showStats && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([styles.logsLabelStats]) },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogLabelStats__WEBPACK_IMPORTED_MODULE_4__["LogLabelStats"], { stats: stats, rowCount: getRows().length, label: label, value: value, onClickClose: this.onClickClose })))));
    };
    return UnThemedLogLabel;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));
var LogLabel = Object(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_6__["withTheme"])(UnThemedLogLabel);
LogLabel.displayName = 'LogLabel';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogLabelStats.tsx":
/*!*******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogLabelStats.tsx ***!
  \*******************************************************************/
/*! exports provided: LogLabelStats */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogLabelStats", function() { return LogLabelStats; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _LogLabelStatsRow__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./LogLabelStatsRow */ "./packages/grafana-ui/src/components/Logs/LogLabelStatsRow.tsx");
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");
/* harmony import */ var _themes_index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/index */ "./packages/grafana-ui/src/themes/index.ts");






var STATS_ROW_LIMIT = 5;
var getStyles = function (theme) { return ({
    logsStats: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats;\n    background-color: ", ";\n    color: ", ";\n    border: 1px solid ", ";\n    border-radius: ", ";\n    max-width: 500px;\n  "], ["\n    label: logs-stats;\n    background-color: ", ";\n    color: ", ";\n    border: 1px solid ", ";\n    border-radius: ", ";\n    max-width: 500px;\n  "])), Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({ light: theme.colors.pageBg, dark: theme.colors.dark2 }, theme.type), theme.colors.text, Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({ light: theme.colors.gray5, dark: theme.colors.dark9 }, theme.type), theme.border.radius.md),
    logsStatsHeader: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats__header;\n    background: ", ";\n    padding: 6px 10px;\n    display: flex;\n  "], ["\n    label: logs-stats__header;\n    background: ", ";\n    padding: 6px 10px;\n    display: flex;\n  "])), Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({ light: theme.colors.gray5, dark: theme.colors.dark9 }, theme.type)),
    logsStatsTitle: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats__title;\n    font-weight: ", ";\n    padding-right: ", ";\n    overflow: hidden;\n    display: inline-block;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    flex-grow: 1;\n  "], ["\n    label: logs-stats__title;\n    font-weight: ", ";\n    padding-right: ", ";\n    overflow: hidden;\n    display: inline-block;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    flex-grow: 1;\n  "])), theme.typography.weight.semibold, theme.spacing.d),
    logsStatsClose: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats__close;\n    cursor: pointer;\n  "], ["\n    label: logs-stats__close;\n    cursor: pointer;\n  "]))),
    logsStatsBody: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats__body;\n    padding: 20px 10px 10px 10px;\n  "], ["\n    label: logs-stats__body;\n    padding: 20px 10px 10px 10px;\n  "]))),
}); };
var UnThemedLogLabelStats = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](UnThemedLogLabelStats, _super);
    function UnThemedLogLabelStats() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnThemedLogLabelStats.prototype.render = function () {
        var _a = this.props, label = _a.label, rowCount = _a.rowCount, stats = _a.stats, value = _a.value, onClickClose = _a.onClickClose, theme = _a.theme;
        var style = getStyles(theme);
        var topRows = stats.slice(0, STATS_ROW_LIMIT);
        var activeRow = topRows.find(function (row) { return row.value === value; });
        var otherRows = stats.slice(STATS_ROW_LIMIT);
        var insertActiveRow = !activeRow;
        // Remove active row from other to show extra
        if (insertActiveRow) {
            activeRow = otherRows.find(function (row) { return row.value === value; });
            otherRows = otherRows.filter(function (row) { return row.value !== value; });
        }
        var otherCount = otherRows.reduce(function (sum, row) { return sum + row.count; }, 0);
        var topCount = topRows.reduce(function (sum, row) { return sum + row.count; }, 0);
        var total = topCount + otherCount;
        var otherProportion = otherCount / total;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStats]) },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsHeader]) },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsTitle]) },
                    label,
                    ": ",
                    total,
                    " of ",
                    rowCount,
                    " rows have that label"),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsClose, 'fa fa-remove']), onClick: onClickClose })),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsBody]) },
                topRows.map(function (stat) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogLabelStatsRow__WEBPACK_IMPORTED_MODULE_3__["LogLabelStatsRow"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ key: stat.value }, stat, { active: stat.value === value }))); }),
                insertActiveRow && activeRow && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogLabelStatsRow__WEBPACK_IMPORTED_MODULE_3__["LogLabelStatsRow"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ key: activeRow.value }, activeRow, { active: true })),
                otherCount > 0 && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogLabelStatsRow__WEBPACK_IMPORTED_MODULE_3__["LogLabelStatsRow"], { key: "__OTHERS__", count: otherCount, value: "Other", proportion: otherProportion })))));
    };
    return UnThemedLogLabelStats;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));
var LogLabelStats = Object(_themes_index__WEBPACK_IMPORTED_MODULE_5__["withTheme"])(UnThemedLogLabelStats);
LogLabelStats.displayName = 'LogLabelStats';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogLabelStatsRow.tsx":
/*!**********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogLabelStatsRow.tsx ***!
  \**********************************************************************/
/*! exports provided: LogLabelStatsRow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogLabelStatsRow", function() { return LogLabelStatsRow; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");




var getStyles = function (theme) { return ({
    logsStatsRow: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row;\n    margin: ", "px 0;\n  "], ["\n    label: logs-stats-row;\n    margin: ", "px 0;\n  "])), parseInt(theme.spacing.d, 10) / 1.75),
    logsStatsRowActive: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row--active;\n    color: ", ";\n    position: relative;\n\n    ::after {\n      display: inline;\n      content: '*';\n      position: absolute;\n      top: 0;\n      left: -8px;\n    }\n  "], ["\n    label: logs-stats-row--active;\n    color: ", ";\n    position: relative;\n\n    ::after {\n      display: inline;\n      content: '*';\n      position: absolute;\n      top: 0;\n      left: -8px;\n    }\n  "])), theme.colors.blue),
    logsStatsRowLabel: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row__label;\n    display: flex;\n    margin-bottom: 1px;\n  "], ["\n    label: logs-stats-row__label;\n    display: flex;\n    margin-bottom: 1px;\n  "]))),
    logsStatsRowValue: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row__value;\n    flex: 1;\n    text-overflow: ellipsis;\n    overflow: hidden;\n  "], ["\n    label: logs-stats-row__value;\n    flex: 1;\n    text-overflow: ellipsis;\n    overflow: hidden;\n  "]))),
    logsStatsRowCount: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row__count;\n    text-align: right;\n    margin-left: 0.5em;\n  "], ["\n    label: logs-stats-row__count;\n    text-align: right;\n    margin-left: 0.5em;\n  "]))),
    logsStatsRowPercent: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row__percent;\n    text-align: right;\n    margin-left: 0.5em;\n    width: 3em;\n  "], ["\n    label: logs-stats-row__percent;\n    text-align: right;\n    margin-left: 0.5em;\n    width: 3em;\n  "]))),
    logsStatsRowBar: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_7 || (templateObject_7 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row__bar;\n    height: 4px;\n    overflow: hidden;\n    background: ", ";\n  "], ["\n    label: logs-stats-row__bar;\n    height: 4px;\n    overflow: hidden;\n    background: ", ";\n  "])), theme.colors.textFaint),
    logsStatsRowInnerBar: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_8 || (templateObject_8 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    label: logs-stats-row__innerbar;\n    height: 4px;\n    overflow: hidden;\n    background: ", ";\n    background: ", ";\n  "], ["\n    label: logs-stats-row__innerbar;\n    height: 4px;\n    overflow: hidden;\n    background: ", ";\n    background: ", ";\n  "])), theme.colors.textFaint, theme.colors.blue),
}); };
var LogLabelStatsRow = function (_a) {
    var active = _a.active, count = _a.count, proportion = _a.proportion, value = _a.value;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]);
    var style = getStyles(theme);
    var percent = Math.round(proportion * 100) + "%";
    var barStyle = { width: percent };
    var className = active ? Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRow, style.logsStatsRowActive]) : Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRow]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: className },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRowLabel]) },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRowValue]), title: value }, value),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRowCount]) }, count),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRowPercent]) }, percent)),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRowBar]) },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([style.logsStatsRowInnerBar]), style: barStyle }))));
};
LogLabelStatsRow.displayName = 'LogLabelStatsRow';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7, templateObject_8;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogLabels.tsx":
/*!***************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogLabels.tsx ***!
  \***************************************************************/
/*! exports provided: LogLabels */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogLabels", function() { return LogLabels; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _LogLabel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./LogLabel */ "./packages/grafana-ui/src/components/Logs/LogLabel.tsx");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");





var getStyles = function (theme) { return ({
    logsLabels: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    display: flex;\n    flex-wrap: wrap;\n  "], ["\n    display: flex;\n    flex-wrap: wrap;\n  "]))),
}); };
var LogLabels = function (_a) {
    var getRows = _a.getRows, labels = _a.labels, onClickLabel = _a.onClickLabel, plain = _a.plain;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"]);
    var styles = getStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([styles.logsLabels]) }, Object.keys(labels).map(function (key) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogLabel__WEBPACK_IMPORTED_MODULE_3__["LogLabel"], { key: key, getRows: getRows, label: key, value: labels[key], plain: plain, onClickLabel: onClickLabel })); })));
};
LogLabels.displayName = 'LogLabels';
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogMessageAnsi.tsx":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogMessageAnsi.tsx ***!
  \********************************************************************/
/*! exports provided: LogMessageAnsi */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogMessageAnsi", function() { return LogMessageAnsi; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_ansicolor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/ansicolor */ "./packages/grafana-ui/src/utils/ansicolor.ts");



function convertCSSToStyle(css) {
    return css.split(/;\s*/).reduce(function (accumulated, line) {
        var match = line.match(/([^:\s]+)\s*:\s*(.+)/);
        if (match && match[1] && match[2]) {
            var key = match[1].replace(/-(a-z)/g, function (_, character) { return character.toUpperCase(); });
            // @ts-ignore
            accumulated[key] = match[2];
        }
        return accumulated;
    }, {});
}
var LogMessageAnsi = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](LogMessageAnsi, _super);
    function LogMessageAnsi() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            chunks: [],
            prevValue: '',
        };
        return _this;
    }
    LogMessageAnsi.getDerivedStateFromProps = function (props, state) {
        if (props.value === state.prevValue) {
            return null;
        }
        var parsed = _utils_ansicolor__WEBPACK_IMPORTED_MODULE_2__["default"].parse(props.value);
        return {
            chunks: parsed.spans.map(function (span) {
                return span.css
                    ? {
                        style: convertCSSToStyle(span.css),
                        text: span.text,
                    }
                    : { text: span.text };
            }),
            prevValue: props.value,
        };
    };
    LogMessageAnsi.prototype.render = function () {
        var chunks = this.state.chunks;
        return chunks.map(function (chunk, index) {
            return chunk.style ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { key: index, style: chunk.style }, chunk.text)) : (chunk.text);
        });
    };
    return LogMessageAnsi;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogRow.tsx":
/*!************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogRow.tsx ***!
  \************************************************************/
/*! exports provided: LogRow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogRow", function() { return LogRow; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_highlight_words__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-highlight-words */ "./node_modules/react-highlight-words/dist/main.js");
/* harmony import */ var react_highlight_words__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_highlight_words__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(tinycolor2__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../index */ "./packages/grafana-ui/src/index.ts");
/* harmony import */ var _LogRowContextProvider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./LogRowContextProvider */ "./packages/grafana-ui/src/components/Logs/LogRowContextProvider.tsx");
/* harmony import */ var _LogRowContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./LogRowContext */ "./packages/grafana-ui/src/components/Logs/LogRowContext.tsx");
/* harmony import */ var _LogLabels__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./LogLabels */ "./packages/grafana-ui/src/components/Logs/LogLabels.tsx");
/* harmony import */ var _LogMessageAnsi__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./LogMessageAnsi */ "./packages/grafana-ui/src/components/Logs/LogMessageAnsi.tsx");
/* harmony import */ var _LogLabelStats__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./LogLabelStats */ "./packages/grafana-ui/src/components/Logs/LogLabelStats.tsx");
/* harmony import */ var _themes_index__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../themes/index */ "./packages/grafana-ui/src/themes/index.ts");
/* harmony import */ var _getLogRowStyles__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./getLogRowStyles */ "./packages/grafana-ui/src/components/Logs/getLogRowStyles.ts");



// @ts-ignore












/**
 * Renders a highlighted field.
 * When hovering, a stats icon is shown.
 */
var FieldHighlight = function (onClick) { return function (props) {
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_index__WEBPACK_IMPORTED_MODULE_7__["ThemeContext"]);
    var style = Object(_getLogRowStyles__WEBPACK_IMPORTED_MODULE_14__["getLogRowStyles"])(theme);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: props.className, style: props.style },
        props.children,
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style, 'logs-row__field-highlight--icon', 'fa fa-signal']), onClick: function () { return onClick(props.children); } })));
}; };
var logRowStyles = Object(emotion__WEBPACK_IMPORTED_MODULE_6__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n  position: relative;\n  /* z-index: 0; */\n  /* outline: none; */\n"], ["\n  position: relative;\n  /* z-index: 0; */\n  /* outline: none; */\n"])));
var getLogRowWithContextStyles = function (theme, state) {
    var outlineColor = Object(_index__WEBPACK_IMPORTED_MODULE_7__["selectThemeVariant"])({
        light: theme.colors.white,
        dark: theme.colors.black,
    }, theme.type);
    return {
        row: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      z-index: 1;\n      outline: 9999px solid\n        ", ";\n    "], ["\n      z-index: 1;\n      outline: 9999px solid\n        ",
            ";\n    "])), tinycolor2__WEBPACK_IMPORTED_MODULE_5___default()(outlineColor)
            .setAlpha(0.7)
            .toRgbString()),
    };
};
/**
 * Renders a log line.
 *
 * When user hovers over it for a certain time, it lazily parses the log line.
 * Once a parser is found, it will determine fields, that will be highlighted.
 * When the user requests stats for a field, they will be calculated and rendered below the row.
 */
var UnThemedLogRow = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](UnThemedLogRow, _super);
    function UnThemedLogRow() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.mouseMessageTimer = null;
        _this.state = {
            fieldCount: 0,
            fieldLabel: null,
            fieldStats: null,
            fieldValue: null,
            parsed: false,
            parser: undefined,
            parsedFieldHighlights: [],
            showFieldStats: false,
            showContext: false,
        };
        _this.onClickClose = function () {
            _this.setState({ showFieldStats: false });
        };
        _this.onClickHighlight = function (fieldText) {
            var getRows = _this.props.getRows;
            var parser = _this.state.parser;
            var allRows = getRows();
            // Build value-agnostic row matcher based on the field label
            var fieldLabel = parser.getLabelFromField(fieldText);
            var fieldValue = parser.getValueFromField(fieldText);
            var matcher = parser.buildMatcher(fieldLabel);
            var fieldStats = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_4__["calculateFieldStats"])(allRows, matcher);
            var fieldCount = fieldStats.reduce(function (sum, stat) { return sum + stat.count; }, 0);
            _this.setState({ fieldCount: fieldCount, fieldLabel: fieldLabel, fieldStats: fieldStats, fieldValue: fieldValue, showFieldStats: true });
        };
        _this.onMouseOverMessage = function () {
            if (_this.state.showContext || _this.isTextSelected()) {
                // When showing context we don't want to the LogRow rerender as it will mess up state of context block
                // making the "after" context to be scrolled to the top, what is desired only on open
                // The log row message needs to be refactored to separate component that encapsulates parsing and parsed message state
                return;
            }
            // Don't parse right away, user might move along
            _this.mouseMessageTimer = window.setTimeout(_this.parseMessage, 500);
        };
        _this.onMouseOutMessage = function () {
            if (_this.state.showContext) {
                // See comment in onMouseOverMessage method
                return;
            }
            _this.clearMouseMessageTimer();
            _this.setState({ parsed: false });
        };
        _this.clearMouseMessageTimer = function () {
            if (_this.mouseMessageTimer) {
                clearTimeout(_this.mouseMessageTimer);
            }
        };
        _this.parseMessage = function () {
            if (!_this.state.parsed) {
                var row = _this.props.row;
                var parser = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_4__["getParser"])(row.entry);
                if (parser) {
                    // Use parser to highlight detected fields
                    var parsedFieldHighlights = parser.getFields(_this.props.row.entry);
                    _this.setState({ parsedFieldHighlights: parsedFieldHighlights, parsed: true, parser: parser });
                }
            }
        };
        _this.toggleContext = function () {
            _this.setState(function (state) {
                return {
                    showContext: !state.showContext,
                };
            });
        };
        _this.onContextToggle = function (e) {
            e.stopPropagation();
            _this.toggleContext();
        };
        return _this;
    }
    UnThemedLogRow.prototype.componentWillUnmount = function () {
        this.clearMouseMessageTimer();
    };
    UnThemedLogRow.prototype.isTextSelected = function () {
        if (!window.getSelection) {
            return false;
        }
        var selection = window.getSelection();
        if (!selection) {
            return false;
        }
        return selection.anchorNode !== null && selection.isCollapsed === false;
    };
    UnThemedLogRow.prototype.renderLogRow = function (context, errors, hasMoreContextRows, updateLimit) {
        var _this = this;
        var _a = this.props, getRows = _a.getRows, highlighterExpressions = _a.highlighterExpressions, onClickLabel = _a.onClickLabel, row = _a.row, showDuplicates = _a.showDuplicates, showLabels = _a.showLabels, timeZone = _a.timeZone, showTime = _a.showTime, theme = _a.theme;
        var _b = this.state, fieldCount = _b.fieldCount, fieldLabel = _b.fieldLabel, fieldStats = _b.fieldStats, fieldValue = _b.fieldValue, parsed = _b.parsed, parsedFieldHighlights = _b.parsedFieldHighlights, showFieldStats = _b.showFieldStats, showContext = _b.showContext;
        var style = Object(_getLogRowStyles__WEBPACK_IMPORTED_MODULE_14__["getLogRowStyles"])(theme, row.logLevel);
        var entry = row.entry, hasAnsi = row.hasAnsi, raw = row.raw;
        var previewHighlights = highlighterExpressions && !lodash__WEBPACK_IMPORTED_MODULE_2___default.a.isEqual(highlighterExpressions, row.searchWords);
        var highlights = previewHighlights ? highlighterExpressions : row.searchWords;
        var needsHighlighter = highlights && highlights.length > 0 && highlights[0] && highlights[0].length > 0;
        var highlightClassName = previewHighlights
            ? Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowMatchHighLight, style.logsRowMatchHighLightPreview])
            : Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowMatchHighLight]);
        var showUtc = timeZone === 'utc';
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_7__["ThemeContext"].Consumer, null, function (theme) {
            var styles = _this.state.showContext
                ? Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])(logRowStyles, getLogRowWithContextStyles(theme, _this.state).row)
                : logRowStyles;
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRow]) },
                showDuplicates && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowDuplicates]) }, row.duplicates && row.duplicates > 0 ? row.duplicates + 1 + "x" : null)),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowLevel]) }),
                showTime && showUtc && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowLocalTime]), title: "Local: " + row.timeLocal + " (" + row.timeFromNow + ")" }, row.timeUtc)),
                showTime && !showUtc && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowLocalTime]), title: row.timeUtc + " (" + row.timeFromNow + ")" }, row.timeLocal)),
                showLabels && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowLabels]) },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogLabels__WEBPACK_IMPORTED_MODULE_10__["LogLabels"], { getRows: getRows, labels: row.uniqueLabels ? row.uniqueLabels : {}, onClickLabel: onClickLabel }))),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowMessage]), onMouseEnter: _this.onMouseOverMessage, onMouseLeave: _this.onMouseOutMessage },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n                    position: relative;\n                  "], ["\n                    position: relative;\n                  "]))) },
                        showContext && context && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogRowContext__WEBPACK_IMPORTED_MODULE_9__["LogRowContext"], { row: row, context: context, errors: errors, hasMoreContextRows: hasMoreContextRows, onOutsideClick: _this.toggleContext, onLoadMoreContext: function () {
                                if (updateLimit) {
                                    updateLimit();
                                }
                            } })),
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: styles },
                            parsed && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_highlight_words__WEBPACK_IMPORTED_MODULE_3___default.a, { style: { whiteSpace: 'pre-wrap' }, autoEscape: true, highlightTag: FieldHighlight(_this.onClickHighlight), textToHighlight: entry, searchWords: parsedFieldHighlights, highlightClassName: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowFieldHighLight]) })),
                            !parsed && needsHighlighter && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_highlight_words__WEBPACK_IMPORTED_MODULE_3___default.a, { style: { whiteSpace: 'pre-wrap' }, textToHighlight: entry, searchWords: highlights, findChunks: _grafana_data__WEBPACK_IMPORTED_MODULE_4__["findHighlightChunksInText"], highlightClassName: highlightClassName })),
                            hasAnsi && !parsed && !needsHighlighter && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogMessageAnsi__WEBPACK_IMPORTED_MODULE_11__["LogMessageAnsi"], { value: raw }),
                            !hasAnsi && !parsed && !needsHighlighter && entry,
                            showFieldStats && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["cx"])([style.logsRowStats]) },
                                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogLabelStats__WEBPACK_IMPORTED_MODULE_12__["LogLabelStats"], { stats: fieldStats, label: fieldLabel, value: fieldValue, onClickClose: _this.onClickClose, rowCount: fieldCount })))),
                        row.searchWords && row.searchWords.length > 0 && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { onClick: _this.onContextToggle, className: Object(emotion__WEBPACK_IMPORTED_MODULE_6__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n                        visibility: hidden;\n                        white-space: nowrap;\n                        position: relative;\n                        z-index: ", ";\n                        cursor: pointer;\n                        .", ":hover & {\n                          visibility: visible;\n                          margin-left: 10px;\n                          text-decoration: underline;\n                        }\n                      "], ["\n                        visibility: hidden;\n                        white-space: nowrap;\n                        position: relative;\n                        z-index: ", ";\n                        cursor: pointer;\n                        .", ":hover & {\n                          visibility: visible;\n                          margin-left: 10px;\n                          text-decoration: underline;\n                        }\n                      "])), showContext ? 1 : 0, style.logsRow) },
                            showContext ? 'Hide' : 'Show',
                            " context"))))));
        }));
    };
    UnThemedLogRow.prototype.render = function () {
        var _this = this;
        var showContext = this.state.showContext;
        if (showContext) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogRowContextProvider__WEBPACK_IMPORTED_MODULE_8__["LogRowContextProvider"], { row: this.props.row, getRowContext: this.props.getRowContext }, function (_a) {
                    var result = _a.result, errors = _a.errors, hasMoreContextRows = _a.hasMoreContextRows, updateLimit = _a.updateLimit;
                    return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null, _this.renderLogRow(result, errors, hasMoreContextRows, updateLimit));
                })));
        }
        return this.renderLogRow();
    };
    return UnThemedLogRow;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));
var LogRow = Object(_themes_index__WEBPACK_IMPORTED_MODULE_13__["withTheme"])(UnThemedLogRow);
LogRow.displayName = 'LogRow';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogRowContext.tsx":
/*!*******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogRowContext.tsx ***!
  \*******************************************************************/
/*! exports provided: LogRowContext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogRowContext", function() { return LogRowContext; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _Alert_Alert__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Alert/Alert */ "./packages/grafana-ui/src/components/Alert/Alert.tsx");
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var _CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../CustomScrollbar/CustomScrollbar */ "./packages/grafana-ui/src/components/CustomScrollbar/CustomScrollbar.tsx");
/* harmony import */ var _List_List__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../List/List */ "./packages/grafana-ui/src/components/List/List.tsx");
/* harmony import */ var _ClickOutsideWrapper_ClickOutsideWrapper__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ClickOutsideWrapper/ClickOutsideWrapper */ "./packages/grafana-ui/src/components/ClickOutsideWrapper/ClickOutsideWrapper.tsx");









var getLogRowContextStyles = function (theme) {
    var gradientTop = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.white,
        dark: theme.colors.dark1,
    }, theme.type);
    var gradientBottom = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.gray7,
        dark: theme.colors.dark2,
    }, theme.type);
    var boxShadowColor = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.gray5,
        dark: theme.colors.black,
    }, theme.type);
    var borderColor = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_4__["selectThemeVariant"])({
        light: theme.colors.gray5,
        dark: theme.colors.dark9,
    }, theme.type);
    return {
        commonStyles: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      position: absolute;\n      width: calc(100% + 20px);\n      left: -10px;\n      height: 250px;\n      z-index: 2;\n      overflow: hidden;\n      background: ", ";\n      background: linear-gradient(180deg, ", " 0%, ", " 104.25%);\n      box-shadow: 0px 2px 4px ", ", 0px 0px 2px ", ";\n      border: 1px solid ", ";\n      border-radius: ", ";\n    "], ["\n      position: absolute;\n      width: calc(100% + 20px);\n      left: -10px;\n      height: 250px;\n      z-index: 2;\n      overflow: hidden;\n      background: ", ";\n      background: linear-gradient(180deg, ", " 0%, ", " 104.25%);\n      box-shadow: 0px 2px 4px ", ", 0px 0px 2px ", ";\n      border: 1px solid ", ";\n      border-radius: ", ";\n    "])), theme.colors.pageBg, gradientTop, gradientBottom, boxShadowColor, boxShadowColor, borderColor, theme.border.radius.md),
        header: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      height: 30px;\n      padding: 0 10px;\n      display: flex;\n      align-items: center;\n      background: ", ";\n    "], ["\n      height: 30px;\n      padding: 0 10px;\n      display: flex;\n      align-items: center;\n      background: ", ";\n    "])), borderColor),
        logs: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      height: 220px;\n      padding: 10px;\n    "], ["\n      height: 220px;\n      padding: 10px;\n    "]))),
    };
};
var LogRowContextGroupHeader = function (_a) {
    var row = _a.row, rows = _a.rows, onLoadMoreContext = _a.onLoadMoreContext, canLoadMoreRows = _a.canLoadMoreRows;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__["ThemeContext"]);
    var header = getLogRowContextStyles(theme).header;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: header },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n          opacity: 0.6;\n        "], ["\n          opacity: 0.6;\n        "]))) },
            "Found ",
            rows.length,
            " rows."),
        (rows.length >= 10 || (rows.length > 10 && rows.length % 10 !== 0)) && canLoadMoreRows && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n            margin-left: 10px;\n            &:hover {\n              text-decoration: underline;\n              cursor: pointer;\n            }\n          "], ["\n            margin-left: 10px;\n            &:hover {\n              text-decoration: underline;\n              cursor: pointer;\n            }\n          "]))), onClick: function () { return onLoadMoreContext(); } }, "Load 10 more"))));
};
var LogRowContextGroup = function (_a) {
    var row = _a.row, rows = _a.rows, error = _a.error, className = _a.className, shouldScrollToBottom = _a.shouldScrollToBottom, canLoadMoreRows = _a.canLoadMoreRows, onLoadMoreContext = _a.onLoadMoreContext;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_5__["ThemeContext"]);
    var _b = getLogRowContextStyles(theme), commonStyles = _b.commonStyles, logs = _b.logs;
    var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(0), 2), scrollTop = _c[0], setScrollTop = _c[1];
    var listContainerRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["useRef"])();
    Object(react__WEBPACK_IMPORTED_MODULE_1__["useLayoutEffect"])(function () {
        if (shouldScrollToBottom && listContainerRef.current) {
            setScrollTop(listContainerRef.current.offsetHeight);
        }
    });
    var headerProps = {
        row: row,
        rows: rows,
        onLoadMoreContext: onLoadMoreContext,
        canLoadMoreRows: canLoadMoreRows,
    };
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])(className, commonStyles) },
        shouldScrollToBottom && !error && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(LogRowContextGroupHeader, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, headerProps)),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: logs },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_6__["CustomScrollbar"], { autoHide: true, scrollTop: scrollTop },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { ref: listContainerRef },
                    !error && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_List_List__WEBPACK_IMPORTED_MODULE_7__["List"], { items: rows, renderItem: function (item) {
                            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n                        padding: 5px 0;\n                      "], ["\n                        padding: 5px 0;\n                      "]))) }, item));
                        } })),
                    error && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Alert_Alert__WEBPACK_IMPORTED_MODULE_3__["Alert"], { title: error })))),
        !shouldScrollToBottom && !error && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(LogRowContextGroupHeader, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, headerProps))));
};
var LogRowContext = function (_a) {
    var row = _a.row, context = _a.context, errors = _a.errors, onOutsideClick = _a.onOutsideClick, onLoadMoreContext = _a.onLoadMoreContext, hasMoreContextRows = _a.hasMoreContextRows;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ClickOutsideWrapper_ClickOutsideWrapper__WEBPACK_IMPORTED_MODULE_8__["ClickOutsideWrapper"], { onClick: onOutsideClick },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null,
            context.after && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(LogRowContextGroup, { rows: context.after, error: errors && errors.after, row: row, className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_7 || (templateObject_7 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n              top: -250px;\n            "], ["\n              top: -250px;\n            "]))), shouldScrollToBottom: true, canLoadMoreRows: hasMoreContextRows ? hasMoreContextRows.after : false, onLoadMoreContext: onLoadMoreContext })),
            context.before && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(LogRowContextGroup, { onLoadMoreContext: onLoadMoreContext, canLoadMoreRows: hasMoreContextRows ? hasMoreContextRows.before : false, row: row, rows: context.before, error: errors && errors.before, className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["css"])(templateObject_8 || (templateObject_8 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n              top: 100%;\n            "], ["\n              top: 100%;\n            "]))) })))));
};
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7, templateObject_8;


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogRowContextProvider.tsx":
/*!***************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogRowContextProvider.tsx ***!
  \***************************************************************************/
/*! exports provided: getRowContexts, LogRowContextProvider */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getRowContexts", function() { return getRowContexts; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogRowContextProvider", function() { return LogRowContextProvider; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_flatten__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/flatten */ "./node_modules/lodash/flatten.js");
/* harmony import */ var lodash_flatten__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_flatten__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_use_lib_useAsync__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-use/lib/useAsync */ "./node_modules/react-use/lib/useAsync.js");
/* harmony import */ var react_use_lib_useAsync__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_use_lib_useAsync__WEBPACK_IMPORTED_MODULE_4__);
var _this = undefined;





var getRowContexts = function (getRowContext, row, limit) { return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](_this, void 0, void 0, function () {
    var promises, results;
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
        switch (_a.label) {
            case 0:
                promises = [
                    getRowContext(row, {
                        limit: limit,
                    }),
                    getRowContext(row, {
                        limit: limit + 1,
                        direction: 'FORWARD',
                    }),
                ];
                return [4 /*yield*/, Promise.all(promises.map(function (p) { return p.catch(function (e) { return e; }); }))];
            case 1:
                results = _a.sent();
                return [2 /*return*/, {
                        data: results.map(function (result) {
                            var dataResult = result;
                            if (!dataResult.data) {
                                return [];
                            }
                            var data = [];
                            for (var index = 0; index < dataResult.data.length; index++) {
                                var dataFrame = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_1__["toDataFrame"])(dataResult.data[index]);
                                var timestampField = dataFrame.fields.filter(function (field) { return field.name === 'ts'; })[0];
                                for (var fieldIndex = 0; fieldIndex < timestampField.values.length; fieldIndex++) {
                                    var timestamp = timestampField.values.get(fieldIndex);
                                    // We need to filter out the row we're basing our search from because of how start/end params work in Loki API
                                    // see https://github.com/grafana/loki/issues/597#issuecomment-506408980
                                    // the alternative to create our own add 1 nanosecond method to the a timestamp string would be quite complex
                                    if (timestamp === row.timestamp) {
                                        continue;
                                    }
                                    var lineField = dataFrame.fields.filter(function (field) { return field.name === 'line'; })[0];
                                    var line = lineField.values.get(fieldIndex); // assuming that both fields have same length
                                    if (data.length === 0) {
                                        data[0] = [line];
                                    }
                                    else {
                                        data[0].push(line);
                                    }
                                }
                            }
                            return data;
                        }),
                        errors: results.map(function (result) {
                            var errorResult = result;
                            if (!errorResult.message) {
                                return '';
                            }
                            return errorResult.message;
                        }),
                    }];
        }
    });
}); };
var LogRowContextProvider = function (_a) {
    var getRowContext = _a.getRowContext, row = _a.row, children = _a.children;
    // React Hook that creates a number state value called limit to component state and a setter function called setLimit
    // The intial value for limit is 10
    // Used for the number of rows to retrieve from backend from a specific point in time
    var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(10), 2), limit = _b[0], setLimit = _b[1];
    // React Hook that creates an object state value called result to component state and a setter function called setResult
    // The intial value for result is null
    // Used for sorting the response from backend
    var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null), 2), result = _c[0], setResult = _c[1];
    // React Hook that creates an object state value called hasMoreContextRows to component state and a setter function called setHasMoreContextRows
    // The intial value for hasMoreContextRows is {before: true, after: true}
    // Used for indicating in UI if there are more rows to load in a given direction
    var _d = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])({
        before: true,
        after: true,
    }), 2), hasMoreContextRows = _d[0], setHasMoreContextRows = _d[1];
    // React Hook that resolves two promises every time the limit prop changes
    // First promise fetches limit number of rows backwards in time from a specific point in time
    // Second promise fetches limit number of rows forwards in time from a specific point in time
    var value = react_use_lib_useAsync__WEBPACK_IMPORTED_MODULE_4___default()(function () { return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](_this, void 0, void 0, function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getRowContexts(getRowContext, row, limit)];
                case 1: return [2 /*return*/, _a.sent()]; // Moved it to a separate function for debugging purposes
            }
        });
    }); }, [limit]).value;
    // React Hook that performs a side effect every time the value (from useAsync hook) prop changes
    // The side effect changes the result state with the response from the useAsync hook
    // The side effect changes the hasMoreContextRows state if there are more context rows before or after the current result
    Object(react__WEBPACK_IMPORTED_MODULE_2__["useEffect"])(function () {
        if (value) {
            setResult(function (currentResult) {
                var hasMoreLogsBefore = true, hasMoreLogsAfter = true;
                if (currentResult && currentResult.data[0].length === value.data[0].length) {
                    hasMoreLogsBefore = false;
                }
                if (currentResult && currentResult.data[1].length === value.data[1].length) {
                    hasMoreLogsAfter = false;
                }
                setHasMoreContextRows({
                    before: hasMoreLogsBefore,
                    after: hasMoreLogsAfter,
                });
                return value;
            });
        }
    }, [value]);
    return children({
        result: {
            before: result ? lodash_flatten__WEBPACK_IMPORTED_MODULE_3___default()(result.data[0]) : [],
            after: result ? lodash_flatten__WEBPACK_IMPORTED_MODULE_3___default()(result.data[1]) : [],
        },
        errors: {
            before: result ? result.errors[0] : undefined,
            after: result ? result.errors[1] : undefined,
        },
        hasMoreContextRows: hasMoreContextRows,
        updateLimit: function () { return setLimit(limit + 10); },
    });
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/LogRows.tsx":
/*!*************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/LogRows.tsx ***!
  \*************************************************************/
/*! exports provided: LogRows */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogRows", function() { return LogRows; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _LogRow__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./LogRow */ "./packages/grafana-ui/src/components/Logs/LogRow.tsx");
/* harmony import */ var _themes_index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../themes/index */ "./packages/grafana-ui/src/themes/index.ts");
/* harmony import */ var _getLogRowStyles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getLogRowStyles */ "./packages/grafana-ui/src/components/Logs/getLogRowStyles.ts");







var PREVIEW_LIMIT = 100;
var RENDER_LIMIT = 500;
var UnThemedLogRows = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](UnThemedLogRows, _super);
    function UnThemedLogRows() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.deferLogsTimer = null;
        _this.renderAllTimer = null;
        _this.state = {
            deferLogs: true,
            renderAll: false,
        };
        return _this;
    }
    UnThemedLogRows.prototype.componentDidMount = function () {
        var _this = this;
        // Staged rendering
        if (this.state.deferLogs) {
            var data = this.props.data;
            var rowCount = data && data.rows ? data.rows.length : 0;
            // Render all right away if not too far over the limit
            var renderAll_1 = rowCount <= PREVIEW_LIMIT * 2;
            this.deferLogsTimer = window.setTimeout(function () { return _this.setState({ deferLogs: false, renderAll: renderAll_1 }); }, rowCount);
        }
    };
    UnThemedLogRows.prototype.componentDidUpdate = function (prevProps, prevState) {
        var _this = this;
        // Staged rendering
        if (prevState.deferLogs && !this.state.deferLogs && !this.state.renderAll) {
            this.renderAllTimer = window.setTimeout(function () { return _this.setState({ renderAll: true }); }, 2000);
        }
    };
    UnThemedLogRows.prototype.componentWillUnmount = function () {
        if (this.deferLogsTimer) {
            clearTimeout(this.deferLogsTimer);
        }
        if (this.renderAllTimer) {
            clearTimeout(this.renderAllTimer);
        }
    };
    UnThemedLogRows.prototype.render = function () {
        var _a = this.props, dedupStrategy = _a.dedupStrategy, showTime = _a.showTime, data = _a.data, deduplicatedData = _a.deduplicatedData, highlighterExpressions = _a.highlighterExpressions, showLabels = _a.showLabels, timeZone = _a.timeZone, onClickLabel = _a.onClickLabel, rowLimit = _a.rowLimit, theme = _a.theme;
        var _b = this.state, deferLogs = _b.deferLogs, renderAll = _b.renderAll;
        var dedupedData = deduplicatedData ? deduplicatedData : data;
        var hasData = data && data.rows && data.rows.length > 0;
        var hasLabel = hasData && dedupedData && dedupedData.hasUniqueLabels ? true : false;
        var dedupCount = dedupedData
            ? dedupedData.rows.reduce(function (sum, row) { return (row.duplicates ? sum + row.duplicates : sum); }, 0)
            : 0;
        var showDuplicates = dedupStrategy !== _grafana_data__WEBPACK_IMPORTED_MODULE_3__["LogsDedupStrategy"].none && dedupCount > 0;
        // Staged rendering
        var processedRows = dedupedData ? dedupedData.rows : [];
        var firstRows = processedRows.slice(0, PREVIEW_LIMIT);
        var renderLimit = rowLimit || RENDER_LIMIT;
        var rowCount = Math.min(processedRows.length, renderLimit);
        var lastRows = processedRows.slice(PREVIEW_LIMIT, rowCount);
        // React profiler becomes unusable if we pass all rows to all rows and their labels, using getter instead
        var getRows = function () { return processedRows; };
        var getRowContext = this.props.getRowContext ? this.props.getRowContext : function () { return Promise.resolve([]); };
        var logsRows = Object(_getLogRowStyles__WEBPACK_IMPORTED_MODULE_6__["getLogRowStyles"])(theme).logsRows;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_2__["cx"])([logsRows]) },
            hasData &&
                !deferLogs && // Only inject highlighterExpression in the first set for performance reasons
                firstRows.map(function (row, index) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogRow__WEBPACK_IMPORTED_MODULE_4__["LogRow"], { key: index, getRows: getRows, getRowContext: getRowContext, highlighterExpressions: highlighterExpressions, row: row, showDuplicates: showDuplicates, showLabels: showLabels && hasLabel, showTime: showTime, timeZone: timeZone, onClickLabel: onClickLabel })); }),
            hasData &&
                !deferLogs &&
                renderAll &&
                lastRows.map(function (row, index) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_LogRow__WEBPACK_IMPORTED_MODULE_4__["LogRow"], { key: PREVIEW_LIMIT + index, getRows: getRows, getRowContext: getRowContext, row: row, showDuplicates: showDuplicates, showLabels: showLabels && hasLabel, showTime: showTime, timeZone: timeZone, onClickLabel: onClickLabel })); }),
            hasData && deferLogs && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null,
                "Rendering ",
                rowCount,
                " rows...")));
    };
    return UnThemedLogRows;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));
var LogRows = Object(_themes_index__WEBPACK_IMPORTED_MODULE_5__["withTheme"])(UnThemedLogRows);
LogRows.displayName = 'LogsRows';


/***/ }),

/***/ "./packages/grafana-ui/src/components/Logs/getLogRowStyles.ts":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Logs/getLogRowStyles.ts ***!
  \********************************************************************/
/*! exports provided: getLogRowStyles */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLogRowStyles", function() { return getLogRowStyles; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../themes/selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");




var getLogRowStyles = function (theme, logLevel) {
    var logColor = Object(_themes_selectThemeVariant__WEBPACK_IMPORTED_MODULE_3__["selectThemeVariant"])({ light: theme.colors.gray5, dark: theme.colors.gray2 }, theme.type);
    switch (logLevel) {
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].crit:
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].critical:
            logColor = '#705da0';
            break;
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].error:
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].err:
            logColor = '#e24d42';
            break;
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].warning:
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].warn:
            logColor = theme.colors.yellow;
            break;
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].info:
            logColor = '#7eb26d';
            break;
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].debug:
            logColor = '#1f78c1';
            break;
        case _grafana_data__WEBPACK_IMPORTED_MODULE_2__["LogLevel"].trace:
            logColor = '#6ed0e0';
            break;
    }
    return {
        logsRowFieldHighLight: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__field-highlight;\n      background: inherit;\n      padding: inherit;\n      border-bottom: 1px dotted ", ";\n\n      .logs-row__field-highlight--icon {\n        margin-left: 0.5em;\n        cursor: pointer;\n        display: none;\n      }\n\n      &:hover {\n        color: ", ";\n        border-bottom-style: solid;\n\n        .logs-row__field-highlight--icon {\n          display: inline;\n        }\n      }\n    "], ["\n      label: logs-row__field-highlight;\n      background: inherit;\n      padding: inherit;\n      border-bottom: 1px dotted ", ";\n\n      .logs-row__field-highlight--icon {\n        margin-left: 0.5em;\n        cursor: pointer;\n        display: none;\n      }\n\n      &:hover {\n        color: ", ";\n        border-bottom-style: solid;\n\n        .logs-row__field-highlight--icon {\n          display: inline;\n        }\n      }\n    "])), theme.colors.yellow, theme.colors.yellow),
        logsRowMatchHighLight: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__match-highlight;\n      background: inherit;\n      padding: inherit;\n\n      color: ", ";\n      border-bottom: 1px solid ", ";\n      background-color: rgba(", ", 0.1);\n    "], ["\n      label: logs-row__match-highlight;\n      background: inherit;\n      padding: inherit;\n\n      color: ", ";\n      border-bottom: 1px solid ", ";\n      background-color: rgba(", ", 0.1);\n    "])), theme.colors.yellow, theme.colors.yellow, theme.colors.yellow),
        logsRowMatchHighLightPreview: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__match-highlight--preview;\n      background-color: rgba(", ", 0.2);\n      border-bottom-style: dotted;\n    "], ["\n      label: logs-row__match-highlight--preview;\n      background-color: rgba(", ", 0.2);\n      border-bottom-style: dotted;\n    "])), theme.colors.yellow),
        logsRows: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-rows;\n      font-family: ", ";\n      font-size: ", ";\n      display: table;\n      table-layout: fixed;\n      width: 100%;\n    "], ["\n      label: logs-rows;\n      font-family: ", ";\n      font-size: ", ";\n      display: table;\n      table-layout: fixed;\n      width: 100%;\n    "])), theme.typography.fontFamily.monospace, theme.typography.size.sm),
        logsRow: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row;\n      display: table-row;\n\n      > div {\n        display: table-cell;\n        padding-right: 10px;\n        border-top: 1px solid transparent;\n        border-bottom: 1px solid transparent;\n        height: 100%;\n      }\n\n      &:hover {\n        background: ", ";\n      }\n    "], ["\n      label: logs-row;\n      display: table-row;\n\n      > div {\n        display: table-cell;\n        padding-right: 10px;\n        border-top: 1px solid transparent;\n        border-bottom: 1px solid transparent;\n        height: 100%;\n      }\n\n      &:hover {\n        background: ", ";\n      }\n    "])), theme.colors.pageBg),
        logsRowDuplicates: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__duplicates;\n      text-align: right;\n      width: 4em;\n    "], ["\n      label: logs-row__duplicates;\n      text-align: right;\n      width: 4em;\n    "]))),
        logsRowLevel: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_7 || (templateObject_7 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__level;\n      position: relative;\n      width: 10px;\n\n      &::after {\n        content: '';\n        display: block;\n        position: absolute;\n        top: 1px;\n        bottom: 1px;\n        width: 3px;\n        background-color: ", ";\n      }\n    "], ["\n      label: logs-row__level;\n      position: relative;\n      width: 10px;\n\n      &::after {\n        content: '';\n        display: block;\n        position: absolute;\n        top: 1px;\n        bottom: 1px;\n        width: 3px;\n        background-color: ", ";\n      }\n    "])), logColor),
        logsRowLocalTime: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_8 || (templateObject_8 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__localtime;\n      white-space: nowrap;\n      width: 12.5em;\n    "], ["\n      label: logs-row__localtime;\n      white-space: nowrap;\n      width: 12.5em;\n    "]))),
        logsRowLabels: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_9 || (templateObject_9 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__labels;\n      width: 20%;\n      line-height: 1.2;\n      position: relative;\n    "], ["\n      label: logs-row__labels;\n      width: 20%;\n      line-height: 1.2;\n      position: relative;\n    "]))),
        logsRowMessage: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_10 || (templateObject_10 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__message;\n      word-break: break-all;\n    "], ["\n      label: logs-row__message;\n      word-break: break-all;\n    "]))),
        logsRowStats: Object(emotion__WEBPACK_IMPORTED_MODULE_1__["css"])(templateObject_11 || (templateObject_11 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: logs-row__stats;\n      margin: 5px 0;\n    "], ["\n      label: logs-row__stats;\n      margin: 5px 0;\n    "]))),
    };
};
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7, templateObject_8, templateObject_9, templateObject_10, templateObject_11;


/***/ }),

/***/ "./packages/grafana-ui/src/components/PanelOptionsGrid/PanelOptionsGrid.tsx":
/*!**********************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/PanelOptionsGrid/PanelOptionsGrid.tsx ***!
  \**********************************************************************************/
/*! exports provided: PanelOptionsGrid */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PanelOptionsGrid", function() { return PanelOptionsGrid; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var PanelOptionsGrid = function (_a) {
    var children = _a.children;
    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "panel-options-grid" }, children);
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/PanelOptionsGroup/PanelOptionsGroup.tsx":
/*!************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/PanelOptionsGroup/PanelOptionsGroup.tsx ***!
  \************************************************************************************/
/*! exports provided: PanelOptionsGroup */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PanelOptionsGroup", function() { return PanelOptionsGroup; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Libraries

var PanelOptionsGroup = function (props) {
    return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "panel-options-group" },
        props.onAdd ? (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "panel-options-group__header" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "panel-options-group__add-btn", onClick: props.onAdd },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "panel-options-group__add-circle" },
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", { className: "fa fa-plus" })),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "panel-options-group__title" }, props.title)))) : (props.title && (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "panel-options-group__header" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "panel-options-group__title" }, props.title),
            props.onClose && (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-link", onClick: props.onClose },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", { className: "fa fa-remove" })))))),
        props.children && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "panel-options-group__body" }, props.children)));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/PieChart/PieChart.tsx":
/*!******************************************************************!*\
  !*** ./packages/grafana-ui/src/components/PieChart/PieChart.tsx ***!
  \******************************************************************/
/*! exports provided: PieChartType, PieChart */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PieChartType", function() { return PieChartType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PieChart", function() { return PieChart; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3 */ "./node_modules/d3/index.js");
/* harmony import */ var lodash_sum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/sum */ "./node_modules/lodash/sum.js");
/* harmony import */ var lodash_sum__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_sum__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../types */ "./packages/grafana-ui/src/types/index.ts");
/* harmony import */ var _utils_index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/index */ "./packages/grafana-ui/src/utils/index.ts");






var PieChartType;
(function (PieChartType) {
    PieChartType["PIE"] = "pie";
    PieChartType["DONUT"] = "donut";
})(PieChartType || (PieChartType = {}));
var PieChart = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](PieChart, _super);
    function PieChart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PieChart.prototype.componentDidMount = function () {
        this.draw();
    };
    PieChart.prototype.componentDidUpdate = function () {
        this.draw();
    };
    PieChart.prototype.draw = function () {
        var _this = this;
        var _a = this.props, values = _a.values, pieType = _a.pieType, strokeWidth = _a.strokeWidth;
        if (values.length === 0) {
            return;
        }
        var data = values.map(function (datapoint) { return datapoint.numeric; });
        var names = values.map(function (datapoint) { return datapoint.text; });
        var colors = values.map(function (p, idx) {
            if (p.color) {
                return p.color;
            }
            return _utils_index__WEBPACK_IMPORTED_MODULE_5__["colors"][idx % _utils_index__WEBPACK_IMPORTED_MODULE_5__["colors"].length];
        });
        var total = lodash_sum__WEBPACK_IMPORTED_MODULE_3___default()(data) || 1;
        var percents = data.map(function (item) { return (item / total) * 100; });
        var width = this.containerElement.offsetWidth;
        var height = this.containerElement.offsetHeight;
        var radius = Math.min(width, height) / 2;
        var outerRadius = radius - radius / 10;
        var innerRadius = pieType === PieChartType.PIE ? 0 : radius - radius / 3;
        var svg = Object(d3__WEBPACK_IMPORTED_MODULE_2__["select"])(this.svgElement)
            .html('')
            .attr('width', width)
            .attr('height', height)
            .append('g')
            .attr('transform', "translate(" + width / 2 + "," + height / 2 + ")");
        var pieChart = Object(d3__WEBPACK_IMPORTED_MODULE_2__["pie"])();
        var customArc = Object(d3__WEBPACK_IMPORTED_MODULE_2__["arc"])()
            .outerRadius(outerRadius)
            .innerRadius(innerRadius)
            .padAngle(0);
        svg
            .selectAll('path')
            .data(pieChart(data))
            .enter()
            .append('path')
            .attr('d', customArc)
            .attr('fill', function (d, idx) { return colors[idx]; })
            .style('fill-opacity', 0.15)
            .style('stroke', function (d, idx) { return colors[idx]; })
            .style('stroke-width', strokeWidth + "px")
            .on('mouseover', function (d, idx) {
            Object(d3__WEBPACK_IMPORTED_MODULE_2__["select"])(_this.tooltipElement).style('opacity', 1);
            Object(d3__WEBPACK_IMPORTED_MODULE_2__["select"])(_this.tooltipValueElement).text(names[idx] + " (" + percents[idx].toFixed(2) + "%)");
        })
            .on('mousemove', function () {
            Object(d3__WEBPACK_IMPORTED_MODULE_2__["select"])(_this.tooltipElement)
                .style('top', d3__WEBPACK_IMPORTED_MODULE_2__["event"].pageY - height / 2 + "px")
                .style('left', d3__WEBPACK_IMPORTED_MODULE_2__["event"].pageX + "px");
        })
            .on('mouseout', function () {
            Object(d3__WEBPACK_IMPORTED_MODULE_2__["select"])(_this.tooltipElement).style('opacity', 0);
        });
    };
    PieChart.prototype.render = function () {
        var _this = this;
        var _a = this.props, height = _a.height, width = _a.width, values = _a.values;
        if (values.length > 0) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "piechart-panel" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { ref: function (element) { return (_this.containerElement = element); }, className: "piechart-container", style: {
                        height: height * 0.9 + "px",
                        width: Math.min(width, height * 1.3) + "px",
                    } },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("svg", { ref: function (element) { return (_this.svgElement = element); } })),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "piechart-tooltip", ref: function (element) { return (_this.tooltipElement = element); } },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "piechart-tooltip-time" },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { id: "tooltip-value", className: "piechart-tooltip-value", ref: function (element) { return (_this.tooltipValueElement = element); } })))));
        }
        else {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "piechart-panel" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "datapoints-warning" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "small" }, "No data points"))));
        }
    };
    PieChart.defaultProps = {
        pieType: 'pie',
        format: 'short',
        stat: 'current',
        strokeWidth: 1,
        theme: _types__WEBPACK_IMPORTED_MODULE_4__["GrafanaThemeType"].Dark,
    };
    return PieChart;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Portal/Portal.tsx":
/*!**************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Portal/Portal.tsx ***!
  \**************************************************************/
/*! exports provided: Portal */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Portal", function() { return Portal; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_2__);



var Portal = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Portal, _super);
    function Portal(props) {
        var _this = _super.call(this, props) || this;
        _this.node = document.createElement('div');
        var _a = _this.props, className = _a.className, _b = _a.root, root = _b === void 0 ? document.body : _b;
        if (className) {
            _this.node.classList.add(className);
        }
        _this.portalRoot = root;
        _this.portalRoot.appendChild(_this.node);
        return _this;
    }
    Portal.prototype.componentWillUnmount = function () {
        this.portalRoot.removeChild(this.node);
    };
    Portal.prototype.render = function () {
        return react_dom__WEBPACK_IMPORTED_MODULE_2___default.a.createPortal(this.props.children, this.node);
    };
    return Portal;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/RefreshPicker/RefreshPicker.tsx":
/*!****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/RefreshPicker/RefreshPicker.tsx ***!
  \****************************************************************************/
/*! exports provided: offOption, liveOption, defaultIntervals, isLive, RefreshPickerBase, RefreshPicker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "offOption", function() { return offOption; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "liveOption", function() { return liveOption; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultIntervals", function() { return defaultIntervals; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isLive", function() { return isLive; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RefreshPickerBase", function() { return RefreshPickerBase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RefreshPicker", function() { return RefreshPicker; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Tooltip/Tooltip */ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx");
/* harmony import */ var _Select_ButtonSelect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Select/ButtonSelect */ "./packages/grafana-ui/src/components/Select/ButtonSelect.tsx");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! memoize-one */ "./node_modules/memoize-one/dist/memoize-one.esm.js");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");








var offOption = { label: 'Off', value: '' };
var liveOption = { label: 'Live', value: 'LIVE' };
var defaultIntervals = ['5s', '10s', '30s', '1m', '5m', '15m', '30m', '1h', '2h', '1d'];
var isLive = function (refreshInterval) { return refreshInterval === liveOption.value; };
var getStyles = Object(memoize_one__WEBPACK_IMPORTED_MODULE_6__["default"])(function (theme) {
    return {
        selectButton: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n      label: selectButton;\n      .select-button-value {\n        color: ", ";\n      }\n    "], ["\n      label: selectButton;\n      .select-button-value {\n        color: ", ";\n      }\n    "])), theme.colors.orange),
    };
});
var RefreshPickerBase = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](RefreshPickerBase, _super);
    function RefreshPickerBase(props) {
        var _this = _super.call(this, props) || this;
        _this.intervalsToOptions = function (intervals) {
            var intervalsOrDefault = intervals || defaultIntervals;
            var options = intervalsOrDefault
                .filter(function (str) { return str !== ''; })
                .map(function (interval) { return ({ label: interval, value: interval }); });
            if (_this.props.hasLiveOption) {
                options.unshift(liveOption);
            }
            options.unshift(offOption);
            return options;
        };
        _this.onChangeSelect = function (item) {
            var onIntervalChanged = _this.props.onIntervalChanged;
            if (onIntervalChanged) {
                // @ts-ignore
                onIntervalChanged(item.value);
            }
        };
        return _this;
    }
    RefreshPickerBase.prototype.render = function () {
        var _a = this.props, onRefresh = _a.onRefresh, intervals = _a.intervals, tooltip = _a.tooltip, value = _a.value, refreshButton = _a.refreshButton, buttonSelectClassName = _a.buttonSelectClassName, theme = _a.theme;
        var options = this.intervalsToOptions(intervals);
        var currentValue = value || '';
        var selectedValue = options.find(function (item) { return item.value === currentValue; }) || offOption;
        var styles = getStyles(theme);
        var cssClasses = classnames__WEBPACK_IMPORTED_MODULE_2___default()({
            'refresh-picker': true,
            'refresh-picker--off': selectedValue.label === offOption.label,
            'refresh-picker--live': selectedValue === liveOption,
        });
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: cssClasses },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "refresh-picker-buttons" },
                refreshButton ? (refreshButton) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_4__["Tooltip"], { placement: "top", content: tooltip },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { className: "btn btn--radius-right-0 navbar-button navbar-button--border-right-0", onClick: onRefresh },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-refresh" })))),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Select_ButtonSelect__WEBPACK_IMPORTED_MODULE_5__["ButtonSelect"], { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('navbar-button--attached', styles.selectButton, buttonSelectClassName), value: selectedValue, label: selectedValue.label, options: options, onChange: this.onChangeSelect, maxMenuHeight: 380 }))));
    };
    // Make it exported as static properties to be easier to access. The global exports need to be accessed by direct
    // import of this source file which won't work if this was installed as package.
    RefreshPickerBase.offOption = offOption;
    RefreshPickerBase.liveOption = liveOption;
    return RefreshPickerBase;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

var RefreshPicker = Object(_themes__WEBPACK_IMPORTED_MODULE_7__["withTheme"])(RefreshPickerBase);
var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/SecretFormFied/SecretFormField.tsx":
/*!*******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/SecretFormFied/SecretFormField.tsx ***!
  \*******************************************************************************/
/*! exports provided: SecretFormField */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SecretFormField", function() { return SecretFormField; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/omit */ "./node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! .. */ "./packages/grafana-ui/src/components/index.ts");




var defaultProps = {
    inputWidth: 12,
    placeholder: 'Password',
    label: 'Password',
};
/**
 * Form field that has 2 states configured and not configured. If configured it will not show its contents and adds
 * a reset button that will clear the input and makes it accessible. In non configured state it behaves like normal
 * form field. This is used for passwords or anything that is encrypted on the server and is later returned encrypted
 * to the user (like datasource passwords).
 */
var SecretFormField = function (_a) {
    var label = _a.label, labelWidth = _a.labelWidth, inputWidth = _a.inputWidth, onReset = _a.onReset, isConfigured = _a.isConfigured, placeholder = _a.placeholder, inputProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["label", "labelWidth", "inputWidth", "onReset", "isConfigured", "placeholder"]);
    return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(___WEBPACK_IMPORTED_MODULE_3__["FormField"], { label: label, labelWidth: labelWidth, inputEl: isConfigured ? (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("input", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ type: "text", className: "gf-form-input width-" + (inputWidth - 2), disabled: true, value: "configured" }, lodash_omit__WEBPACK_IMPORTED_MODULE_1___default()(inputProps, 'value'))),
            react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("button", { className: "btn btn-secondary gf-form-btn", onClick: onReset }, "reset"))) : (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("input", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ type: "password", className: "gf-form-input width-" + inputWidth, placeholder: placeholder }, inputProps))) }));
};
SecretFormField.defaultProps = defaultProps;
SecretFormField.displayName = 'SecretFormField';


/***/ }),

/***/ "./packages/grafana-ui/src/components/Select/ButtonSelect.tsx":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Select/ButtonSelect.tsx ***!
  \********************************************************************/
/*! exports provided: ButtonSelect */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ButtonSelect", function() { return ButtonSelect; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Select */ "./packages/grafana-ui/src/components/Select/Select.tsx");



var ButtonComponent = function (buttonProps) { return function (props) {
    var label = buttonProps.label, className = buttonProps.className, iconClass = buttonProps.iconClass;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { ref: props.innerRef, className: "btn navbar-button navbar-button--tight " + className, onClick: props.selectProps.menuIsOpen ? props.selectProps.onMenuClose : props.selectProps.onMenuOpen, onBlur: props.selectProps.onMenuClose, tabIndex: 0 },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "select-button" },
            iconClass && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "select-button-icon " + iconClass }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "select-button-value" }, label ? label : ''),
            !props.menuIsOpen && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-caret-down fa-fw" }),
            props.menuIsOpen && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-caret-up fa-fw" }))));
}; };
var ButtonSelect = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ButtonSelect, _super);
    function ButtonSelect() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onChange = function (item) {
            var onChange = _this.props.onChange;
            onChange(item);
        };
        return _this;
    }
    ButtonSelect.prototype.render = function () {
        var _a = this.props, className = _a.className, options = _a.options, value = _a.value, label = _a.label, iconClass = _a.iconClass, components = _a.components, maxMenuHeight = _a.maxMenuHeight, tooltipContent = _a.tooltipContent, isMenuOpen = _a.isMenuOpen, onOpenMenu = _a.onOpenMenu, onCloseMenu = _a.onCloseMenu, tabSelectsValue = _a.tabSelectsValue, _b = _a.autoFocus, autoFocus = _b === void 0 ? true : _b;
        var combinedComponents = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, components, { Control: ButtonComponent({ label: label, className: className, iconClass: iconClass }) });
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Select__WEBPACK_IMPORTED_MODULE_2__["default"], { autoFocus: autoFocus, backspaceRemovesValue: false, isClearable: false, isSearchable: false, options: options, onChange: this.onChange, value: value, isOpen: isMenuOpen, onOpenMenu: onOpenMenu, onCloseMenu: onCloseMenu, maxMenuHeight: maxMenuHeight, components: combinedComponents, className: "gf-form-select-box-button-select", tooltipContent: tooltipContent, tabSelectsValue: tabSelectsValue }));
    };
    return ButtonSelect;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Select/IndicatorsContainer.tsx":
/*!***************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Select/IndicatorsContainer.tsx ***!
  \***************************************************************************/
/*! exports provided: IndicatorsContainer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "IndicatorsContainer", function() { return IndicatorsContainer; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _torkelo_react_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @torkelo/react-select */ "./node_modules/@torkelo/react-select/dist/react-select.esm.js");


// Ignoring because I couldn't get @types/react-select work wih Torkel's fork
// @ts-ignore

var IndicatorsContainer = function (props) {
    var isOpen = props.selectProps.menuIsOpen;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_torkelo_react_select__WEBPACK_IMPORTED_MODULE_2__["components"].IndicatorsContainer, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "gf-form-select-box__select-arrow " + (isOpen ? "gf-form-select-box__select-arrow--reversed" : '') })));
};
/* harmony default export */ __webpack_exports__["default"] = (IndicatorsContainer);


/***/ }),

/***/ "./packages/grafana-ui/src/components/Select/NoOptionsMessage.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Select/NoOptionsMessage.tsx ***!
  \************************************************************************/
/*! exports provided: NoOptionsMessage, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NoOptionsMessage", function() { return NoOptionsMessage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _torkelo_react_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @torkelo/react-select */ "./node_modules/@torkelo/react-select/dist/react-select.esm.js");


// Ignoring because I couldn't get @types/react-select work wih Torkel's fork
// @ts-ignore

var NoOptionsMessage = function (props) {
    var children = props.children;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_torkelo_react_select__WEBPACK_IMPORTED_MODULE_2__["components"].Option, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__desc-option" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__desc-option__body" }, children))));
};
/* harmony default export */ __webpack_exports__["default"] = (NoOptionsMessage);


/***/ }),

/***/ "./packages/grafana-ui/src/components/Select/Select.tsx":
/*!**************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Select/Select.tsx ***!
  \**************************************************************/
/*! exports provided: MenuList, Select, AsyncSelect, WrapInTooltip, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MenuList", function() { return MenuList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Select", function() { return Select; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AsyncSelect", function() { return AsyncSelect; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WrapInTooltip", function() { return WrapInTooltip; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _torkelo_react_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @torkelo/react-select */ "./node_modules/@torkelo/react-select/dist/react-select.esm.js");
/* harmony import */ var _torkelo_react_select_lib_Async__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @torkelo/react-select/lib/Async */ "./node_modules/@torkelo/react-select/lib/Async.js");
/* harmony import */ var _torkelo_react_select_lib_Async__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_torkelo_react_select_lib_Async__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _SelectOption__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SelectOption */ "./packages/grafana-ui/src/components/Select/SelectOption.tsx");
/* harmony import */ var _SelectOptionGroup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SelectOptionGroup */ "./packages/grafana-ui/src/components/Select/SelectOptionGroup.tsx");
/* harmony import */ var _IndicatorsContainer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./IndicatorsContainer */ "./packages/grafana-ui/src/components/Select/IndicatorsContainer.tsx");
/* harmony import */ var _NoOptionsMessage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./NoOptionsMessage */ "./packages/grafana-ui/src/components/Select/NoOptionsMessage.tsx");
/* harmony import */ var _resetSelectStyles__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./resetSelectStyles */ "./packages/grafana-ui/src/components/Select/resetSelectStyles.ts");
/* harmony import */ var _CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../CustomScrollbar/CustomScrollbar */ "./packages/grafana-ui/src/components/CustomScrollbar/CustomScrollbar.tsx");
/* harmony import */ var _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Tooltip/Tooltip */ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx");

// Libraries


// Ignoring because I couldn't get @types/react-select work wih Torkel's fork
// @ts-ignore

// @ts-ignore

// @ts-ignore

// Components







var MenuList = function (props) {
    return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_torkelo_react_select__WEBPACK_IMPORTED_MODULE_3__["components"].MenuList, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props),
        react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_10__["CustomScrollbar"], { autoHide: false, autoHeightMax: "inherit" }, props.children)));
};
var Select = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Select, _super);
    function Select() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Select.prototype.render = function () {
        var _a = this.props, defaultValue = _a.defaultValue, getOptionLabel = _a.getOptionLabel, getOptionValue = _a.getOptionValue, onChange = _a.onChange, options = _a.options, placeholder = _a.placeholder, width = _a.width, value = _a.value, className = _a.className, isDisabled = _a.isDisabled, isLoading = _a.isLoading, isSearchable = _a.isSearchable, isClearable = _a.isClearable, backspaceRemovesValue = _a.backspaceRemovesValue, isMulti = _a.isMulti, autoFocus = _a.autoFocus, openMenuOnFocus = _a.openMenuOnFocus, onBlur = _a.onBlur, maxMenuHeight = _a.maxMenuHeight, noOptionsMessage = _a.noOptionsMessage, isOpen = _a.isOpen, components = _a.components, tooltipContent = _a.tooltipContent, tabSelectsValue = _a.tabSelectsValue, onCloseMenu = _a.onCloseMenu, onOpenMenu = _a.onOpenMenu;
        var widthClass = '';
        if (width) {
            widthClass = 'width-' + width;
        }
        var selectClassNames = classnames__WEBPACK_IMPORTED_MODULE_1___default()('gf-form-input', 'gf-form-input--form-dropdown', widthClass, className);
        var selectComponents = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, Select.defaultProps.components, components);
        return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(WrapInTooltip, { onCloseMenu: onCloseMenu, onOpenMenu: onOpenMenu, tooltipContent: tooltipContent, isOpen: isOpen }, function (onOpenMenuInternal, onCloseMenuInternal) {
            return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_torkelo_react_select__WEBPACK_IMPORTED_MODULE_3__["default"], { classNamePrefix: "gf-form-select-box", className: selectClassNames, components: selectComponents, defaultValue: defaultValue, value: value, getOptionLabel: getOptionLabel, getOptionValue: getOptionValue, menuShouldScrollIntoView: false, isSearchable: isSearchable, onChange: onChange, options: options, placeholder: placeholder || 'Choose', styles: Object(_resetSelectStyles__WEBPACK_IMPORTED_MODULE_9__["default"])(), isDisabled: isDisabled, isLoading: isLoading, isClearable: isClearable, autoFocus: autoFocus, onBlur: onBlur, openMenuOnFocus: openMenuOnFocus, maxMenuHeight: maxMenuHeight, noOptionsMessage: noOptionsMessage, isMulti: isMulti, backspaceRemovesValue: backspaceRemovesValue, menuIsOpen: isOpen, onMenuOpen: onOpenMenuInternal, onMenuClose: onCloseMenuInternal, tabSelectsValue: tabSelectsValue }));
        }));
    };
    Select.defaultProps = {
        className: '',
        isDisabled: false,
        isSearchable: true,
        isClearable: false,
        isMulti: false,
        openMenuOnFocus: false,
        autoFocus: false,
        isLoading: false,
        backspaceRemovesValue: true,
        maxMenuHeight: 300,
        tabSelectsValue: true,
        components: {
            Option: _SelectOption__WEBPACK_IMPORTED_MODULE_5__["SelectOption"],
            SingleValue: _SelectOption__WEBPACK_IMPORTED_MODULE_5__["SingleValue"],
            IndicatorsContainer: _IndicatorsContainer__WEBPACK_IMPORTED_MODULE_7__["default"],
            MenuList: MenuList,
            Group: _SelectOptionGroup__WEBPACK_IMPORTED_MODULE_6__["default"],
        },
    };
    return Select;
}(react__WEBPACK_IMPORTED_MODULE_2__["PureComponent"]));

var AsyncSelect = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](AsyncSelect, _super);
    function AsyncSelect() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AsyncSelect.prototype.render = function () {
        var _a = this.props, defaultValue = _a.defaultValue, getOptionLabel = _a.getOptionLabel, getOptionValue = _a.getOptionValue, onChange = _a.onChange, placeholder = _a.placeholder, width = _a.width, value = _a.value, className = _a.className, loadOptions = _a.loadOptions, defaultOptions = _a.defaultOptions, isLoading = _a.isLoading, loadingMessage = _a.loadingMessage, noOptionsMessage = _a.noOptionsMessage, isDisabled = _a.isDisabled, isSearchable = _a.isSearchable, isClearable = _a.isClearable, backspaceRemovesValue = _a.backspaceRemovesValue, autoFocus = _a.autoFocus, onBlur = _a.onBlur, openMenuOnFocus = _a.openMenuOnFocus, maxMenuHeight = _a.maxMenuHeight, isMulti = _a.isMulti, tooltipContent = _a.tooltipContent, onCloseMenu = _a.onCloseMenu, onOpenMenu = _a.onOpenMenu, isOpen = _a.isOpen;
        var widthClass = '';
        if (width) {
            widthClass = 'width-' + width;
        }
        var selectClassNames = classnames__WEBPACK_IMPORTED_MODULE_1___default()('gf-form-input', 'gf-form-input--form-dropdown', widthClass, className);
        return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(WrapInTooltip, { onCloseMenu: onCloseMenu, onOpenMenu: onOpenMenu, tooltipContent: tooltipContent, isOpen: isOpen }, function (onOpenMenuInternal, onCloseMenuInternal) {
            return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_torkelo_react_select_lib_Async__WEBPACK_IMPORTED_MODULE_4___default.a, { classNamePrefix: "gf-form-select-box", className: selectClassNames, components: {
                    Option: _SelectOption__WEBPACK_IMPORTED_MODULE_5__["SelectOption"],
                    SingleValue: _SelectOption__WEBPACK_IMPORTED_MODULE_5__["SingleValue"],
                    IndicatorsContainer: _IndicatorsContainer__WEBPACK_IMPORTED_MODULE_7__["default"],
                    NoOptionsMessage: _NoOptionsMessage__WEBPACK_IMPORTED_MODULE_8__["default"],
                }, defaultValue: defaultValue, value: value, getOptionLabel: getOptionLabel, getOptionValue: getOptionValue, menuShouldScrollIntoView: false, onChange: onChange, loadOptions: loadOptions, isLoading: isLoading, defaultOptions: defaultOptions, placeholder: placeholder || 'Choose', styles: Object(_resetSelectStyles__WEBPACK_IMPORTED_MODULE_9__["default"])(), loadingMessage: loadingMessage, noOptionsMessage: noOptionsMessage, isDisabled: isDisabled, isSearchable: isSearchable, isClearable: isClearable, autoFocus: autoFocus, onBlur: onBlur, openMenuOnFocus: openMenuOnFocus, maxMenuHeight: maxMenuHeight, isMulti: isMulti, backspaceRemovesValue: backspaceRemovesValue }));
        }));
    };
    AsyncSelect.defaultProps = {
        className: '',
        components: {},
        loadingMessage: function () { return 'Loading...'; },
        isDisabled: false,
        isClearable: false,
        isMulti: false,
        isSearchable: true,
        backspaceRemovesValue: true,
        autoFocus: false,
        openMenuOnFocus: false,
        maxMenuHeight: 300,
    };
    return AsyncSelect;
}(react__WEBPACK_IMPORTED_MODULE_2__["PureComponent"]));

var WrapInTooltip = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](WrapInTooltip, _super);
    function WrapInTooltip() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isOpenInternal: false,
        };
        _this.onOpenMenu = function () {
            var onOpenMenu = _this.props.onOpenMenu;
            if (onOpenMenu) {
                onOpenMenu();
            }
            _this.setState({ isOpenInternal: true });
        };
        _this.onCloseMenu = function () {
            var onCloseMenu = _this.props.onCloseMenu;
            if (onCloseMenu) {
                onCloseMenu();
            }
            _this.setState({ isOpenInternal: false });
        };
        return _this;
    }
    WrapInTooltip.prototype.render = function () {
        var _a = this.props, children = _a.children, isOpen = _a.isOpen, tooltipContent = _a.tooltipContent;
        var isOpenInternal = this.state.isOpenInternal;
        var showTooltip = undefined;
        if (isOpenInternal || isOpen) {
            showTooltip = false;
        }
        if (tooltipContent) {
            return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_11__["Tooltip"], { show: showTooltip, content: tooltipContent, placement: "bottom" },
                react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", null, children(this.onOpenMenu, this.onCloseMenu))));
        }
        else {
            return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", null, children(this.onOpenMenu, this.onCloseMenu));
        }
    };
    return WrapInTooltip;
}(react__WEBPACK_IMPORTED_MODULE_2__["PureComponent"]));

/* harmony default export */ __webpack_exports__["default"] = (Select);


/***/ }),

/***/ "./packages/grafana-ui/src/components/Select/SelectOption.tsx":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Select/SelectOption.tsx ***!
  \********************************************************************/
/*! exports provided: SelectOption, SingleValue, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SelectOption", function() { return SelectOption; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SingleValue", function() { return SingleValue; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _torkelo_react_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @torkelo/react-select */ "./node_modules/@torkelo/react-select/dist/react-select.esm.js");


// Ignoring because I couldn't get @types/react-select work wih Torkel's fork
// @ts-ignore

var SelectOption = function (props) {
    var children = props.children, isSelected = props.isSelected, data = props.data;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_torkelo_react_select__WEBPACK_IMPORTED_MODULE_2__["components"].Option, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__desc-option" },
            data.imgUrl && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__desc-option__body" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null, children),
                data.description && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__desc-option__desc" }, data.description)),
            isSelected && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-check", "aria-hidden": "true" }))));
};
// was not able to type this without typescript error
var SingleValue = function (props) {
    var children = props.children, data = props.data;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_torkelo_react_select__WEBPACK_IMPORTED_MODULE_2__["components"].SingleValue, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__img-value" },
            data.imgUrl && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl }),
            children)));
};
/* harmony default export */ __webpack_exports__["default"] = (SelectOption);


/***/ }),

/***/ "./packages/grafana-ui/src/components/Select/SelectOptionGroup.tsx":
/*!*************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Select/SelectOptionGroup.tsx ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


var SelectOptionGroup = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](SelectOptionGroup, _super);
    function SelectOptionGroup() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            expanded: false,
        };
        _this.onToggleChildren = function () {
            _this.setState(function (prevState) { return ({
                expanded: !prevState.expanded,
            }); });
        };
        return _this;
    }
    SelectOptionGroup.prototype.componentDidMount = function () {
        if (this.props.data.expanded) {
            this.setState({ expanded: true });
        }
        else if (this.props.selectProps && this.props.selectProps.value) {
            var value_1 = this.props.selectProps.value.value;
            if (value_1 && this.props.options.some(function (option) { return option.value === value_1; })) {
                this.setState({ expanded: true });
            }
        }
    };
    SelectOptionGroup.prototype.componentDidUpdate = function (nextProps) {
        if (nextProps.selectProps.inputValue !== '') {
            this.setState({ expanded: true });
        }
    };
    SelectOptionGroup.prototype.render = function () {
        var _a = this.props, children = _a.children, label = _a.label;
        var expanded = this.state.expanded;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__option-group" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-select-box__option-group__header", onClick: this.onToggleChildren },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "flex-grow-1" }, label),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa " + (expanded ? 'fa-caret-left' : 'fa-caret-down') }),
                ' '),
            expanded && children));
    };
    return SelectOptionGroup;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));
/* harmony default export */ __webpack_exports__["default"] = (SelectOptionGroup);


/***/ }),

/***/ "./packages/grafana-ui/src/components/Select/resetSelectStyles.ts":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Select/resetSelectStyles.ts ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return resetSelectStyles; });
function resetSelectStyles() {
    return {
        clearIndicator: function () { return ({}); },
        container: function () { return ({}); },
        control: function () { return ({}); },
        dropdownIndicator: function () { return ({}); },
        group: function () { return ({}); },
        groupHeading: function () { return ({}); },
        indicatorsContainer: function () { return ({}); },
        indicatorSeparator: function () { return ({}); },
        input: function () { return ({}); },
        loadingIndicator: function () { return ({}); },
        loadingMessage: function () { return ({}); },
        menu: function () { return ({}); },
        menuList: function (_a) {
            var maxHeight = _a.maxHeight;
            return ({
                maxHeight: maxHeight,
            });
        },
        multiValue: function () { return ({}); },
        multiValueLabel: function () { return ({}); },
        multiValueRemove: function () { return ({}); },
        noOptionsMessage: function () { return ({}); },
        option: function () { return ({}); },
        placeholder: function () { return ({}); },
        singleValue: function () { return ({}); },
        valueContainer: function () { return ({}); },
    };
}


/***/ }),

/***/ "./packages/grafana-ui/src/components/SetInterval/SetInterval.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/SetInterval/SetInterval.tsx ***!
  \************************************************************************/
/*! exports provided: getIntervalFromString, SetInterval */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getIntervalFromString", function() { return getIntervalFromString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SetInterval", function() { return SetInterval; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm5/index.js");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm5/operators/index.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _RefreshPicker_RefreshPicker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../RefreshPicker/RefreshPicker */ "./packages/grafana-ui/src/components/RefreshPicker/RefreshPicker.tsx");







function getIntervalFromString(strInterval) {
    return {
        label: strInterval,
        value: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_5__["stringToMs"])(strInterval),
    };
}
var SetInterval = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](SetInterval, _super);
    function SetInterval(props) {
        var _this = _super.call(this, props) || this;
        _this.propsSubject = new rxjs__WEBPACK_IMPORTED_MODULE_2__["Subject"]();
        _this.subscription = null;
        return _this;
    }
    SetInterval.prototype.componentDidMount = function () {
        var _this = this;
        // Creating a subscription to propsSubject. This subject pushes values every time
        // SetInterval's props change
        this.subscription = this.propsSubject
            .pipe(
        // switchMap creates a new observables based on the input stream,
        // which becomes part of the propsSubject stream
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["switchMap"])(function (props) {
            // If the query is live, empty value is emited. `of` creates single value,
            // which is merged to propsSubject stream
            if (Object(_RefreshPicker_RefreshPicker__WEBPACK_IMPORTED_MODULE_6__["isLive"])(props.interval)) {
                return Object(rxjs__WEBPACK_IMPORTED_MODULE_2__["of"])({});
            }
            // When query is loading, a new stream is merged. But it's a stream that emits no values(NEVER),
            // hence next call of this function will happen when query changes, and new props are passed into this component
            // When query is NOT loading, a new value is emited, this time it's an interval value,
            // which makes tap function below execute on that interval basis.
            return props.loading ? rxjs__WEBPACK_IMPORTED_MODULE_2__["NEVER"] : Object(rxjs__WEBPACK_IMPORTED_MODULE_2__["interval"])(Object(_grafana_data__WEBPACK_IMPORTED_MODULE_5__["stringToMs"])(props.interval));
        }), 
        // tap will execute function passed via func prop
        // * on value from `of` stream merged if query is live
        // * on specified interval (triggered by values emited by interval)
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["tap"])(function () { return _this.props.func(); }))
            .subscribe();
        // When component has mounted, propsSubject emits it's first value
        this.propsSubject.next(this.props);
    };
    SetInterval.prototype.componentDidUpdate = function (prevProps) {
        if ((Object(_RefreshPicker_RefreshPicker__WEBPACK_IMPORTED_MODULE_6__["isLive"])(prevProps.interval) && Object(_RefreshPicker_RefreshPicker__WEBPACK_IMPORTED_MODULE_6__["isLive"])(this.props.interval)) || lodash__WEBPACK_IMPORTED_MODULE_4___default.a.isEqual(prevProps, this.props)) {
            return;
        }
        // if props changed, a new value is emited from propsSubject
        this.propsSubject.next(this.props);
    };
    SetInterval.prototype.componentWillUnmount = function () {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
        this.propsSubject.unsubscribe();
    };
    SetInterval.prototype.render = function () {
        return null;
    };
    return SetInterval;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/SingleStatShared/FieldDisplayEditor.tsx":
/*!************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/SingleStatShared/FieldDisplayEditor.tsx ***!
  \************************************************************************************/
/*! exports provided: FieldDisplayEditor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FieldDisplayEditor", function() { return FieldDisplayEditor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../FormLabel/FormLabel */ "./packages/grafana-ui/src/components/FormLabel/FormLabel.tsx");
/* harmony import */ var _FormField_FormField__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../FormField/FormField */ "./packages/grafana-ui/src/components/FormField/FormField.tsx");
/* harmony import */ var _StatsPicker_StatsPicker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../StatsPicker/StatsPicker */ "./packages/grafana-ui/src/components/StatsPicker/StatsPicker.tsx");
/* harmony import */ var _utils_fieldDisplay__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/fieldDisplay */ "./packages/grafana-ui/src/utils/fieldDisplay.ts");
/* harmony import */ var _Select_Select__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Select/Select */ "./packages/grafana-ui/src/components/Select/Select.tsx");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");

// Libraries

// Components



// Types



var showOptions = [
    {
        value: true,
        label: 'All Values',
        description: 'Each row in the response data',
    },
    {
        value: false,
        label: 'Calculation',
        description: 'Calculate a value based on the response',
    },
];
var FieldDisplayEditor = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](FieldDisplayEditor, _super);
    function FieldDisplayEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onShowValuesChange = function (item) {
            var val = item.value === true;
            _this.props.onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _this.props.value, { values: val }));
        };
        _this.onCalcsChange = function (calcs) {
            _this.props.onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _this.props.value, { calcs: calcs }));
        };
        _this.onDefaultsChange = function (value) {
            _this.props.onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _this.props.value, { defaults: value }));
        };
        _this.onLimitChange = function (event) {
            _this.props.onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _this.props.value, { limit: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_7__["toIntegerOrUndefined"])(event.target.value) }));
        };
        return _this;
    }
    FieldDisplayEditor.prototype.render = function () {
        var value = this.props.value;
        var calcs = value.calcs, values = value.values, limit = value.limit;
        var labelWidth = this.props.labelWidth || 5;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_2__["FormLabel"], { width: labelWidth }, "Show"),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Select_Select__WEBPACK_IMPORTED_MODULE_6__["default"], { options: showOptions, value: values ? showOptions[0] : showOptions[1], onChange: this.onShowValuesChange })),
            values ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormField_FormField__WEBPACK_IMPORTED_MODULE_3__["FormField"], { label: "Limit", labelWidth: labelWidth, placeholder: "" + _utils_fieldDisplay__WEBPACK_IMPORTED_MODULE_5__["DEFAULT_FIELD_DISPLAY_VALUES_LIMIT"], onChange: this.onLimitChange, value: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_7__["toNumberString"])(limit), type: "number" })) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_2__["FormLabel"], { width: labelWidth }, "Calc"),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_StatsPicker_StatsPicker__WEBPACK_IMPORTED_MODULE_4__["StatsPicker"], { width: 12, placeholder: "Choose Stat", defaultStat: _grafana_data__WEBPACK_IMPORTED_MODULE_7__["ReducerID"].mean, allowMultiple: false, stats: calcs, onChange: this.onCalcsChange })))));
    };
    return FieldDisplayEditor;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/SingleStatShared/FieldPropertiesEditor.tsx":
/*!***************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/SingleStatShared/FieldPropertiesEditor.tsx ***!
  \***************************************************************************************/
/*! exports provided: FieldPropertiesEditor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FieldPropertiesEditor", function() { return FieldPropertiesEditor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _FormField_FormField__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../FormField/FormField */ "./packages/grafana-ui/src/components/FormField/FormField.tsx");
/* harmony import */ var _FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../FormLabel/FormLabel */ "./packages/grafana-ui/src/components/FormLabel/FormLabel.tsx");
/* harmony import */ var _UnitPicker_UnitPicker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../UnitPicker/UnitPicker */ "./packages/grafana-ui/src/components/UnitPicker/UnitPicker.tsx");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _utils_fieldDisplay__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/fieldDisplay */ "./packages/grafana-ui/src/utils/fieldDisplay.ts");

// Libraries

// Components



// Types


var labelWidth = 6;
var FieldPropertiesEditor = function (_a) {
    var value = _a.value, onChange = _a.onChange, showMinMax = _a.showMinMax;
    var unit = value.unit, title = value.title;
    var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(value.decimals !== undefined && value.decimals !== null ? value.decimals.toString() : ''), 2), decimals = _b[0], setDecimals = _b[1];
    var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(Object(_grafana_data__WEBPACK_IMPORTED_MODULE_5__["toNumberString"])(value.min)), 2), min = _c[0], setMin = _c[1];
    var _d = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(Object(_grafana_data__WEBPACK_IMPORTED_MODULE_5__["toNumberString"])(value.max)), 2), max = _d[0], setMax = _d[1];
    var onTitleChange = function (event) {
        onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, value, { title: event.target.value }));
    };
    var onDecimalChange = Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(function (event) {
        setDecimals(event.target.value);
    }, [value.decimals, onChange]);
    var onMinChange = Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(function (event) {
        setMin(event.target.value);
    }, [value.min, onChange]);
    var onMaxChange = Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(function (event) {
        setMax(event.target.value);
    }, [value.max, onChange]);
    var onUnitChange = function (unit) {
        onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, value, { unit: unit.value }));
    };
    var commitChanges = Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(function () {
        onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, value, { decimals: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_5__["toIntegerOrUndefined"])(decimals), min: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_5__["toFloatOrUndefined"])(min), max: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_5__["toFloatOrUndefined"])(max) }));
    }, [min, max, decimals]);
    var titleTooltip = (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null,
        "Template Variables:",
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("br", null),
        '${' + _utils_fieldDisplay__WEBPACK_IMPORTED_MODULE_6__["VAR_SERIES_NAME"] + '}',
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("br", null),
        '${' + _utils_fieldDisplay__WEBPACK_IMPORTED_MODULE_6__["VAR_FIELD_NAME"] + '}',
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("br", null),
        '$' + _utils_fieldDisplay__WEBPACK_IMPORTED_MODULE_6__["VAR_CELL_PREFIX"] + '{N}',
        " / ",
        '$' + _utils_fieldDisplay__WEBPACK_IMPORTED_MODULE_6__["VAR_CALC"]));
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormField_FormField__WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "Title", labelWidth: labelWidth, onChange: onTitleChange, value: title, tooltip: titleTooltip, placeholder: "Auto" }),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_3__["FormLabel"], { width: labelWidth }, "Unit"),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_UnitPicker_UnitPicker__WEBPACK_IMPORTED_MODULE_4__["UnitPicker"], { defaultValue: unit, onChange: onUnitChange })),
        showMinMax && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormField_FormField__WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "Min", labelWidth: labelWidth, onChange: onMinChange, onBlur: commitChanges, value: min, type: "number" }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormField_FormField__WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "Max", labelWidth: labelWidth, onChange: onMaxChange, onBlur: commitChanges, value: max, type: "number" }))),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FormField_FormField__WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "Decimals", labelWidth: labelWidth, placeholder: "auto", onChange: onDecimalChange, onBlur: commitChanges, value: decimals, type: "number" })));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/SingleStatShared/SingleStatBaseOptions.ts":
/*!**************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/SingleStatShared/SingleStatBaseOptions.ts ***!
  \**************************************************************************************/
/*! exports provided: sharedSingleStatPanelChangedHandler, sharedSingleStatMigrationHandler, moveThresholdsAndMappingsToField, migrateFromValueOptions, migrateOldThresholds, convertOldAngulrValueMapping */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatPanelChangedHandler", function() { return sharedSingleStatPanelChangedHandler; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatMigrationHandler", function() { return sharedSingleStatMigrationHandler; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "moveThresholdsAndMappingsToField", function() { return moveThresholdsAndMappingsToField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "migrateFromValueOptions", function() { return migrateFromValueOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "migrateOldThresholds", function() { return migrateOldThresholds; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "convertOldAngulrValueMapping", function() { return convertOldAngulrValueMapping; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/cloneDeep */ "./node_modules/lodash/cloneDeep.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/omit */ "./node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _types_panel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../types/panel */ "./packages/grafana-ui/src/types/panel.ts");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");





var optionsToKeep = ['fieldOptions', 'orientation'];
function sharedSingleStatPanelChangedHandler(options, prevPluginId, prevOptions) {
    var e_1, _a, e_2, _b;
    // Migrating from angular singlestat
    if (prevPluginId === 'singlestat' && prevOptions.angular) {
        var panel = prevOptions.angular;
        var reducer = _grafana_data__WEBPACK_IMPORTED_MODULE_4__["fieldReducers"].getIfExists(panel.valueName);
        var options_1 = {
            fieldOptions: {
                defaults: {},
                override: {},
                calcs: [reducer ? reducer.id : _grafana_data__WEBPACK_IMPORTED_MODULE_4__["ReducerID"].mean],
            },
            orientation: _types_panel__WEBPACK_IMPORTED_MODULE_3__["VizOrientation"].Horizontal,
        };
        var defaults = options_1.fieldOptions.defaults;
        if (panel.format) {
            defaults.unit = panel.format;
        }
        if (panel.nullPointMode) {
            defaults.nullValueMode = panel.nullPointMode;
        }
        if (panel.nullText) {
            defaults.noValue = panel.nullText;
        }
        if (panel.decimals || panel.decimals === 0) {
            defaults.decimals = panel.decimals;
        }
        // Convert thresholds and color values
        if (panel.thresholds && panel.colors) {
            var levels = panel.thresholds.split(',').map(function (strVale) {
                return Number(strVale.trim());
            });
            // One more color than threshold
            var thresholds = [];
            try {
                for (var _c = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](panel.colors), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var color = _d.value;
                    var idx = thresholds.length - 1;
                    if (idx >= 0) {
                        thresholds.push({ value: levels[idx], color: color });
                    }
                    else {
                        thresholds.push({ value: -Infinity, color: color });
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_1) throw e_1.error; }
            }
            defaults.thresholds = thresholds;
        }
        // Convert value mappings
        var mappings = convertOldAngulrValueMapping(panel);
        if (mappings && mappings.length) {
            defaults.mappings = mappings;
        }
        if (panel.gauge) {
            defaults.min = panel.gauge.minValue;
            defaults.max = panel.gauge.maxValue;
        }
        return options_1;
    }
    try {
        for (var optionsToKeep_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](optionsToKeep), optionsToKeep_1_1 = optionsToKeep_1.next(); !optionsToKeep_1_1.done; optionsToKeep_1_1 = optionsToKeep_1.next()) {
            var k = optionsToKeep_1_1.value;
            if (prevOptions.hasOwnProperty(k)) {
                options[k] = lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1___default()(prevOptions[k]);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (optionsToKeep_1_1 && !optionsToKeep_1_1.done && (_b = optionsToKeep_1.return)) _b.call(optionsToKeep_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return options;
}
function sharedSingleStatMigrationHandler(panel) {
    if (!panel.options) {
        // This happens on the first load or when migrating from angular
        return {};
    }
    var previousVersion = parseFloat(panel.pluginVersion || '6.1');
    var options = panel.options;
    if (previousVersion < 6.2) {
        options = migrateFromValueOptions(options);
    }
    if (previousVersion < 6.3) {
        options = moveThresholdsAndMappingsToField(options);
    }
    return options;
}
function moveThresholdsAndMappingsToField(old) {
    var fieldOptions = old.fieldOptions;
    if (!fieldOptions) {
        return old;
    }
    var _a = old.fieldOptions, mappings = _a.mappings, thresholds = _a.thresholds, rest = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["mappings", "thresholds"]);
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, old, { fieldOptions: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, rest, { defaults: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, fieldOptions.defaults, { mappings: mappings, thresholds: migrateOldThresholds(thresholds) }) }) });
}
/*
 * Moves valueMappings and thresholds from root to new fieldOptions object
 * Renames valueOptions to to defaults and moves it under fieldOptions
 */
function migrateFromValueOptions(old) {
    var valueOptions = old.valueOptions;
    if (!valueOptions) {
        return old;
    }
    var fieldOptions = {};
    var fieldDefaults = {};
    fieldOptions.mappings = old.valueMappings;
    fieldOptions.thresholds = old.thresholds;
    fieldOptions.defaults = fieldDefaults;
    fieldDefaults.unit = valueOptions.unit;
    fieldDefaults.decimals = valueOptions.decimals;
    // Make sure the stats have a valid name
    if (valueOptions.stat) {
        var reducer = _grafana_data__WEBPACK_IMPORTED_MODULE_4__["fieldReducers"].get(valueOptions.stat);
        if (reducer) {
            fieldOptions.calcs = [reducer.id];
        }
    }
    fieldDefaults.min = old.minValue;
    fieldDefaults.max = old.maxValue;
    var newOptions = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, old, { fieldOptions: fieldOptions });
    return lodash_omit__WEBPACK_IMPORTED_MODULE_2___default()(newOptions, 'valueMappings', 'thresholds', 'valueOptions', 'minValue', 'maxValue');
}
function migrateOldThresholds(thresholds) {
    if (!thresholds || !thresholds.length) {
        return undefined;
    }
    var copy = thresholds.map(function (t) {
        return {
            // Drops 'index'
            value: t.value === null ? -Infinity : t.value,
            color: t.color,
        };
    });
    Object(_grafana_data__WEBPACK_IMPORTED_MODULE_4__["sortThresholds"])(copy);
    copy[0].value = -Infinity;
    return copy;
}
/**
 * Convert the angular single stat mapping to new react style
 */
function convertOldAngulrValueMapping(panel) {
    var mappings = [];
    // Guess the right type based on options
    var mappingType = panel.mappingType;
    if (!panel.mappingType) {
        if (panel.valueMaps && panel.valueMaps.length) {
            mappingType = 1;
        }
        else if (panel.rangeMaps && panel.rangeMaps.length) {
            mappingType = 2;
        }
    }
    // check value to text mappings if its enabled
    if (mappingType === 1) {
        for (var i = 0; i < panel.valueMaps.length; i++) {
            var map = panel.valueMaps[i];
            mappings.push(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, map, { id: i, type: _grafana_data__WEBPACK_IMPORTED_MODULE_4__["MappingType"].ValueToText }));
        }
    }
    else if (mappingType === 2) {
        for (var i = 0; i < panel.rangeMaps.length; i++) {
            var map = panel.rangeMaps[i];
            mappings.push(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, map, { id: i, type: _grafana_data__WEBPACK_IMPORTED_MODULE_4__["MappingType"].RangeToText }));
        }
    }
    return mappings;
}


/***/ }),

/***/ "./packages/grafana-ui/src/components/SingleStatShared/index.ts":
/*!**********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/SingleStatShared/index.ts ***!
  \**********************************************************************/
/*! exports provided: FieldDisplayEditor, FieldPropertiesEditor, SingleStatBaseOptions, sharedSingleStatPanelChangedHandler, sharedSingleStatMigrationHandler, convertOldAngulrValueMapping */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _FieldDisplayEditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FieldDisplayEditor */ "./packages/grafana-ui/src/components/SingleStatShared/FieldDisplayEditor.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldDisplayEditor", function() { return _FieldDisplayEditor__WEBPACK_IMPORTED_MODULE_0__["FieldDisplayEditor"]; });

/* harmony import */ var _FieldPropertiesEditor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FieldPropertiesEditor */ "./packages/grafana-ui/src/components/SingleStatShared/FieldPropertiesEditor.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldPropertiesEditor", function() { return _FieldPropertiesEditor__WEBPACK_IMPORTED_MODULE_1__["FieldPropertiesEditor"]; });

/* harmony import */ var _SingleStatBaseOptions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SingleStatBaseOptions */ "./packages/grafana-ui/src/components/SingleStatShared/SingleStatBaseOptions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SingleStatBaseOptions", function() { return _SingleStatBaseOptions__WEBPACK_IMPORTED_MODULE_2__["SingleStatBaseOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatPanelChangedHandler", function() { return _SingleStatBaseOptions__WEBPACK_IMPORTED_MODULE_2__["sharedSingleStatPanelChangedHandler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatMigrationHandler", function() { return _SingleStatBaseOptions__WEBPACK_IMPORTED_MODULE_2__["sharedSingleStatMigrationHandler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "convertOldAngulrValueMapping", function() { return _SingleStatBaseOptions__WEBPACK_IMPORTED_MODULE_2__["convertOldAngulrValueMapping"]; });






/***/ }),

/***/ "./packages/grafana-ui/src/components/StatsPicker/StatsPicker.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/StatsPicker/StatsPicker.tsx ***!
  \************************************************************************/
/*! exports provided: StatsPicker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StatsPicker", function() { return StatsPicker; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isArray */ "./node_modules/lodash/isArray.js");
/* harmony import */ var lodash_isArray__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isArray__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_difference__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/difference */ "./node_modules/lodash/difference.js");
/* harmony import */ var lodash_difference__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_difference__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../index */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");






var StatsPicker = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](StatsPicker, _super);
    function StatsPicker() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.checkInput = function () {
            var _a = _this.props, stats = _a.stats, allowMultiple = _a.allowMultiple, defaultStat = _a.defaultStat, onChange = _a.onChange;
            var current = _grafana_data__WEBPACK_IMPORTED_MODULE_5__["fieldReducers"].list(stats);
            if (current.length !== stats.length) {
                var found = current.map(function (v) { return v.id; });
                var notFound = lodash_difference__WEBPACK_IMPORTED_MODULE_3___default()(stats, found);
                console.warn('Unknown stats', notFound, stats);
                onChange(current.map(function (stat) { return stat.id; }));
            }
            // Make sure there is only one
            if (!allowMultiple && stats.length > 1) {
                console.warn('Removing extra stat', stats);
                onChange([stats[0]]);
            }
            // Set the reducer from callback
            if (defaultStat && stats.length < 1) {
                onChange([defaultStat]);
            }
        };
        _this.onSelectionChange = function (item) {
            var onChange = _this.props.onChange;
            if (lodash_isArray__WEBPACK_IMPORTED_MODULE_2___default()(item)) {
                onChange(item.map(function (v) { return v.value; }));
            }
            else {
                onChange(item.value ? [item.value] : []);
            }
        };
        return _this;
    }
    StatsPicker.prototype.componentDidMount = function () {
        this.checkInput();
    };
    StatsPicker.prototype.componentDidUpdate = function (prevProps) {
        this.checkInput();
    };
    StatsPicker.prototype.render = function () {
        var _a = this.props, width = _a.width, stats = _a.stats, allowMultiple = _a.allowMultiple, defaultStat = _a.defaultStat, placeholder = _a.placeholder;
        var select = _grafana_data__WEBPACK_IMPORTED_MODULE_5__["fieldReducers"].selectOptions(stats);
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_4__["Select"], { width: width, value: select.current, isClearable: !defaultStat, isMulti: allowMultiple, isSearchable: true, options: select.options, placeholder: placeholder, onChange: this.onSelectionChange }));
    };
    StatsPicker.defaultProps = {
        width: 12,
        allowMultiple: false,
    };
    return StatsPicker;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Switch/Switch.tsx":
/*!**************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Switch/Switch.tsx ***!
  \**************************************************************/
/*! exports provided: Switch */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Switch", function() { return Switch; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_uniqueId__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/uniqueId */ "./node_modules/lodash/uniqueId.js");
/* harmony import */ var lodash_uniqueId__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_uniqueId__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Tooltip/Tooltip */ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx");




var Switch = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Switch, _super);
    function Switch() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            id: lodash_uniqueId__WEBPACK_IMPORTED_MODULE_2___default()(),
        };
        _this.internalOnChange = function (event) {
            event.stopPropagation();
            _this.props.onChange(event);
        };
        return _this;
    }
    Switch.prototype.render = function () {
        var _a = this.props, _b = _a.labelClass, labelClass = _b === void 0 ? '' : _b, _c = _a.switchClass, switchClass = _c === void 0 ? '' : _c, label = _a.label, checked = _a.checked, transparent = _a.transparent, className = _a.className, tooltip = _a.tooltip, tooltipPlacement = _a.tooltipPlacement;
        var labelId = this.state.id;
        var labelClassName = "gf-form-label " + labelClass + " " + (transparent ? 'gf-form-label--transparent' : '') + " pointer";
        var switchClassName = "gf-form-switch " + switchClass + " " + (transparent ? 'gf-form-switch--transparent' : '');
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-switch-container-react" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("label", { htmlFor: labelId, className: "gf-form gf-form-switch-container " + (className || '') },
                label && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: labelClassName },
                    label,
                    tooltip && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_3__["Tooltip"], { placement: tooltipPlacement ? tooltipPlacement : 'auto', content: tooltip, theme: 'info' },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-help-icon gf-form-help-icon--right-normal" },
                            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-info-circle" })))))),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: switchClassName },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("input", { id: labelId, type: "checkbox", checked: checked, onChange: this.internalOnChange }),
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "gf-form-switch__slider" })))));
    };
    return Switch;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Table/Table.tsx":
/*!************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Table/Table.tsx ***!
  \************************************************************/
/*! exports provided: Table, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Table", function() { return Table; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_virtualized__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-virtualized */ "./node_modules/react-virtualized/dist/es/index.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _TableCellBuilder__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./TableCellBuilder */ "./packages/grafana-ui/src/components/Table/TableCellBuilder.tsx");





var Table = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Table, _super);
    function Table(props) {
        var _this = _super.call(this, props) || this;
        _this.scrollToTop = false;
        _this.rotateWidth = 100;
        //----------------------------------------------------------------------
        //----------------------------------------------------------------------
        _this.doSort = function (columnIndex) {
            var sort = _this.state.sortBy;
            var dir = _this.state.sortDirection;
            if (sort !== columnIndex) {
                dir = 'DESC';
                sort = columnIndex;
            }
            else if (dir === 'DESC') {
                dir = 'ASC';
            }
            else {
                sort = null;
            }
            _this.setState({ sortBy: sort, sortDirection: dir });
        };
        /** Converts the grid coordinates to DataFrame coordinates */
        _this.getCellRef = function (rowIndex, columnIndex) {
            var _a = _this.props, showHeader = _a.showHeader, rotate = _a.rotate;
            var rowOffset = showHeader ? -1 : 0;
            if (rotate) {
                return { column: rowIndex, row: columnIndex + rowOffset };
            }
            else {
                return { column: columnIndex, row: rowIndex + rowOffset };
            }
        };
        _this.onCellClick = function (rowIndex, columnIndex) {
            var _a = _this.getCellRef(rowIndex, columnIndex), row = _a.row, column = _a.column;
            if (row < 0) {
                _this.doSort(column);
            }
            else {
                var field = _this.state.data.fields[columnIndex];
                var value = field.values.get(rowIndex);
                console.log('CLICK', value, field.name);
            }
        };
        _this.headerBuilder = function (cell) {
            var _a = _this.state, data = _a.data, sortBy = _a.sortBy, sortDirection = _a.sortDirection;
            var _b = cell.props, columnIndex = _b.columnIndex, rowIndex = _b.rowIndex, style = _b.style;
            var column = _this.getCellRef(rowIndex, columnIndex).column;
            var col = data.fields[column];
            var sorting = sortBy === column;
            if (!col) {
                col = {
                    name: '??' + columnIndex + '???',
                    config: {},
                    values: new _grafana_data__WEBPACK_IMPORTED_MODULE_3__["ArrayVector"](),
                    type: _grafana_data__WEBPACK_IMPORTED_MODULE_3__["FieldType"].other,
                };
            }
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-table-header", style: style, onClick: function () { return _this.onCellClick(rowIndex, columnIndex); } },
                col.name,
                sorting && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_virtualized__WEBPACK_IMPORTED_MODULE_2__["SortIndicator"], { sortDirection: sortDirection })));
        };
        _this.getTableCellBuilder = function (column) {
            var render = _this.renderer[column];
            if (render && render.builder) {
                return render.builder;
            }
            return _TableCellBuilder__WEBPACK_IMPORTED_MODULE_4__["simpleCellBuilder"]; // the default
        };
        _this.cellRenderer = function (props) {
            var rowIndex = props.rowIndex, columnIndex = props.columnIndex, key = props.key, parent = props.parent;
            var _a = _this.getCellRef(rowIndex, columnIndex), row = _a.row, column = _a.column;
            var data = _this.state.data;
            var isHeader = row < 0;
            var rowData = isHeader ? data.fields : Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["getDataFrameRow"])(data, row); // TODO! improve
            var value = rowData ? rowData[column] : '';
            var builder = isHeader ? _this.headerBuilder : _this.getTableCellBuilder(column);
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_virtualized__WEBPACK_IMPORTED_MODULE_2__["CellMeasurer"], { cache: _this.measurer, columnIndex: columnIndex, key: key, parent: parent, rowIndex: rowIndex }, builder({
                value: value,
                row: rowData,
                column: data.fields[column],
                table: _this,
                props: props,
            })));
        };
        _this.getColumnWidth = function (col) {
            if (_this.props.rotate) {
                return _this.rotateWidth; // fixed for now
            }
            return _this.renderer[col.index].width;
        };
        _this.state = {
            data: props.data,
        };
        _this.renderer = _this.initColumns(props);
        _this.measurer = new react_virtualized__WEBPACK_IMPORTED_MODULE_2__["CellMeasurerCache"]({
            defaultHeight: 30,
            fixedWidth: true,
        });
        return _this;
    }
    Table.prototype.componentDidUpdate = function (prevProps, prevState) {
        var _a = this.props, data = _a.data, styles = _a.styles, showHeader = _a.showHeader, rotate = _a.rotate;
        var _b = this.state, sortBy = _b.sortBy, sortDirection = _b.sortDirection;
        var dataChanged = data !== prevProps.data;
        var configsChanged = showHeader !== prevProps.showHeader ||
            this.props.rotate !== prevProps.rotate ||
            this.props.fixedColumns !== prevProps.fixedColumns ||
            this.props.fixedHeader !== prevProps.fixedHeader;
        // Reset the size cache
        if (dataChanged || configsChanged) {
            this.measurer.clearAll();
        }
        // Update the renderer if options change
        // We only *need* do to this if the header values changes, but this does every data update
        if (dataChanged || styles !== prevProps.styles) {
            this.renderer = this.initColumns(this.props);
        }
        if (dataChanged || rotate !== prevProps.rotate) {
            var _c = this.props, width = _c.width, minColumnWidth = _c.minColumnWidth;
            this.rotateWidth = Math.max(width / data.length, minColumnWidth);
        }
        // Update the data when data or sort changes
        if (dataChanged || sortBy !== prevState.sortBy || sortDirection !== prevState.sortDirection) {
            this.scrollToTop = true;
            this.setState({ data: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["sortDataFrame"])(data, sortBy, sortDirection === 'DESC') });
        }
    };
    /** Given the configuration, setup how each column gets rendered */
    Table.prototype.initColumns = function (props) {
        var _this = this;
        var styles = props.styles, data = props.data, width = props.width, minColumnWidth = props.minColumnWidth;
        if (!data || !data.fields || !data.fields.length || !styles) {
            return [];
        }
        var columnWidth = Math.max(width / data.fields.length, minColumnWidth);
        return data.fields.map(function (col, index) {
            var title = col.name;
            var style = null; // ColumnStyle
            // Find the style based on the text
            for (var i = 0; i < styles.length; i++) {
                var s = styles[i];
                var regex = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["stringToJsRegex"])(s.pattern);
                if (title.match(regex)) {
                    style = s;
                    if (s.alias) {
                        title = title.replace(regex, s.alias);
                    }
                    break;
                }
            }
            return {
                header: title,
                width: columnWidth,
                builder: Object(_TableCellBuilder__WEBPACK_IMPORTED_MODULE_4__["getCellBuilder"])(col.config || {}, style, _this.props),
            };
        });
    };
    Table.prototype.render = function () {
        var _a = this.props, showHeader = _a.showHeader, fixedHeader = _a.fixedHeader, fixedColumns = _a.fixedColumns, rotate = _a.rotate, width = _a.width, height = _a.height;
        var data = this.state.data;
        if (!data || !data.fields || !data.fields.length) {
            return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, "Missing Fields"); // nothing
        }
        var columnCount = data.fields.length;
        var rowCount = data.length + (showHeader ? 1 : 0);
        var fixedColumnCount = Math.min(fixedColumns, columnCount);
        var fixedRowCount = showHeader && fixedHeader ? 1 : 0;
        if (rotate) {
            var temp = columnCount;
            columnCount = rowCount;
            rowCount = temp;
            fixedRowCount = 0;
            fixedColumnCount = Math.min(fixedColumns, rowCount) + (showHeader && fixedHeader ? 1 : 0);
        }
        // Called after sort or the data changes
        var scroll = this.scrollToTop ? 1 : -1;
        var scrollToRow = rotate ? -1 : scroll;
        var scrollToColumn = rotate ? scroll : -1;
        if (this.scrollToTop) {
            this.scrollToTop = false;
        }
        // Force MultiGrid to rerender if these options change
        // See: https://github.com/bvaughn/react-virtualized#pass-thru-props
        var refreshKeys = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, this.state, { d1: this.props.data, s0: this.props.styles });
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_virtualized__WEBPACK_IMPORTED_MODULE_2__["MultiGrid"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, refreshKeys, { scrollToRow: scrollToRow, columnCount: columnCount, scrollToColumn: scrollToColumn, rowCount: rowCount, overscanColumnCount: 8, overscanRowCount: 8, columnWidth: this.getColumnWidth, deferredMeasurementCache: this.measurer, cellRenderer: this.cellRenderer, rowHeight: this.measurer.rowHeight, width: width, height: height, fixedColumnCount: fixedColumnCount, fixedRowCount: fixedRowCount, classNameTopLeftGrid: "gf-table-fixed-column", classNameBottomLeftGrid: "gf-table-fixed-column" })));
    };
    Table.defaultProps = {
        showHeader: true,
        fixedHeader: true,
        fixedColumns: 0,
        rotate: false,
        minColumnWidth: 150,
    };
    return Table;
}(react__WEBPACK_IMPORTED_MODULE_1__["Component"]));

/* harmony default export */ __webpack_exports__["default"] = (Table);


/***/ }),

/***/ "./packages/grafana-ui/src/components/Table/TableCellBuilder.tsx":
/*!***********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Table/TableCellBuilder.tsx ***!
  \***********************************************************************/
/*! exports provided: simpleCellBuilder, getCellBuilder */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "simpleCellBuilder", function() { return simpleCellBuilder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCellBuilder", function() { return getCellBuilder; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/index */ "./packages/grafana-ui/src/utils/index.ts");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");

// Libraries




/** Simplest cell that just spits out the value */
var simpleCellBuilder = function (cell) {
    var props = cell.props, value = cell.value, className = cell.className;
    var style = props.style;
    return (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", { style: style, className: 'gf-table-cell ' + className }, value));
};
// private mapper:ValueMapper,
// private style:ColumnStyle,
// private theme:GrafanaTheme,
// private column:Column,
// private replaceVariables: InterpolateFunction,
// private fmt?:ValueFormatter) {
function getCellBuilder(schema, style, props) {
    if (!style) {
        return simpleCellBuilder;
    }
    if (style.type === 'hidden') {
        // TODO -- for hidden, we either need to:
        // 1. process the Table and remove hidden fields
        // 2. do special math to pick the right column skipping hidden fields
        throw new Error('hidden not supported!');
    }
    if (style.type === 'date') {
        return new CellBuilderWithStyle(function (v) {
            if (v === undefined || v === null) {
                return '-';
            }
            if (lodash__WEBPACK_IMPORTED_MODULE_1___default.a.isArray(v)) {
                v = v[0];
            }
            var date = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_4__["dateTime"])(v);
            if (false) {}
            return date.format(style.dateFormat);
        }, style, props.theme, schema, props.replaceVariables).build;
    }
    if (style.type === 'string') {
        return new CellBuilderWithStyle(function (v) {
            if (lodash__WEBPACK_IMPORTED_MODULE_1___default.a.isArray(v)) {
                v = v.join(', ');
            }
            return v;
        }, style, props.theme, schema, props.replaceVariables).build;
        // TODO!!!!  all the mapping stuff!!!!
    }
    if (style.type === 'number') {
        var valueFormatter = Object(_utils_index__WEBPACK_IMPORTED_MODULE_3__["getValueFormat"])(style.unit || schema.unit || 'none');
        return new CellBuilderWithStyle(function (v) {
            if (v === null || v === void 0) {
                return '-';
            }
            return v;
        }, style, props.theme, schema, props.replaceVariables, valueFormatter).build;
    }
    return simpleCellBuilder;
}
// Runs the value through a formatter and adds colors to the cell properties
var CellBuilderWithStyle = /** @class */ (function () {
    function CellBuilderWithStyle(mapper, style, theme, schema, replaceVariables, fmt) {
        var _this = this;
        this.mapper = mapper;
        this.style = style;
        this.theme = theme;
        this.schema = schema;
        this.replaceVariables = replaceVariables;
        this.fmt = fmt;
        this.getColorForValue = function (value) {
            var _a = _this.style, thresholds = _a.thresholds, colors = _a.colors;
            if (!thresholds || !colors) {
                return null;
            }
            for (var i = thresholds.length; i > 0; i--) {
                if (value >= thresholds[i - 1]) {
                    return Object(_utils_index__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(colors[i], _this.theme.type);
                }
            }
            return Object(_utils_index__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(lodash__WEBPACK_IMPORTED_MODULE_1___default.a.first(colors), _this.theme.type);
        };
        this.build = function (cell) {
            var props = cell.props;
            var value = _this.mapper(cell.value);
            if (lodash__WEBPACK_IMPORTED_MODULE_1___default.a.isNumber(value)) {
                if (_this.fmt) {
                    value = _this.fmt(value, _this.style.decimals);
                }
                // For numeric values set the color
                var colorMode = _this.style.colorMode;
                if (colorMode) {
                    var color = _this.getColorForValue(Number(value));
                    if (color) {
                        if (colorMode === 'cell') {
                            props = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props, { style: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props.style, { backgroundColor: color, color: 'white' }) });
                        }
                        else if (colorMode === 'value') {
                            props = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props, { style: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props.style, { color: color }) });
                        }
                    }
                }
            }
            var cellClasses = [];
            if (_this.style.preserveFormat) {
                cellClasses.push('table-panel-cell-pre');
            }
            if (_this.style.link) {
                // Render cell as link
                var row = cell.row;
                var scopedVars = {};
                if (row) {
                    for (var i = 0; i < row.length; i++) {
                        scopedVars["__cell_" + i] = { value: row[i] };
                    }
                }
                scopedVars['__cell'] = { value: value };
                var cellLink = _this.replaceVariables(_this.style.linkUrl, scopedVars, encodeURIComponent);
                var cellLinkTooltip = _this.replaceVariables(_this.style.linkTooltip, scopedVars);
                var cellTarget = _this.style.linkTargetBlank ? '_blank' : '';
                cellClasses.push('table-panel-cell-link');
                value = (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("a", { href: cellLink, target: cellTarget, "data-link-tooltip": true, "data-original-title": cellLinkTooltip, "data-placement": "right" }, value));
            }
            // ??? I don't think this will still work!
            if (_this.schema.filterable) {
                cellClasses.push('table-panel-cell-filterable');
                value = (react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment, null,
                    value,
                    react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("span", null,
                        react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("a", { className: "table-panel-filter-link", "data-link-tooltip": true, "data-original-title": "Filter out value", "data-placement": "bottom", "data-row": props.rowIndex, "data-column": props.columnIndex, "data-operator": "!=" },
                            react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("i", { className: "fa fa-search-minus" })),
                        react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("a", { className: "table-panel-filter-link", "data-link-tooltip": true, "data-original-title": "Filter for value", "data-placement": "bottom", "data-row": props.rowIndex, "data-column": props.columnIndex, "data-operator": "=" },
                            react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("i", { className: "fa fa-search-plus" })))));
            }
            var className;
            if (cellClasses.length) {
                className = cellClasses.join(' ');
            }
            return simpleCellBuilder({ value: value, props: props, className: className });
        };
    }
    return CellBuilderWithStyle;
}());


/***/ }),

/***/ "./packages/grafana-ui/src/components/Table/TableInputCSV.tsx":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Table/TableInputCSV.tsx ***!
  \********************************************************************/
/*! exports provided: TableInputCSV, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TableInputCSV", function() { return TableInputCSV; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/debounce */ "./node_modules/lodash/debounce.js");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");




/**
 * Expects the container div to have size set and will fill it 100%
 */
var TableInputCSV = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TableInputCSV, _super);
    function TableInputCSV(props) {
        var _this = _super.call(this, props) || this;
        _this.readCSV = lodash_debounce__WEBPACK_IMPORTED_MODULE_2___default()(function () {
            var config = _this.props.config;
            var text = _this.state.text;
            _this.setState({ data: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["readCSV"])(text, { config: config }) });
        }, 150);
        _this.onTextChange = function (event) {
            _this.setState({ text: event.target.value });
        };
        var text = props.text, config = props.config;
        _this.state = {
            text: text,
            data: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["readCSV"])(text, { config: config }),
        };
        return _this;
    }
    TableInputCSV.prototype.componentDidUpdate = function (prevProps, prevState) {
        var text = this.state.text;
        if (text !== prevState.text || this.props.config !== prevProps.config) {
            this.readCSV();
        }
        // If the props text has changed, replace our local version
        if (this.props.text !== prevProps.text && this.props.text !== text) {
            this.setState({ text: this.props.text });
        }
        if (this.state.data !== prevState.data) {
            this.props.onSeriesParsed(this.state.data, this.state.text);
        }
    };
    TableInputCSV.prototype.render = function () {
        var _a = this.props, width = _a.width, height = _a.height;
        var data = this.state.data;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-table-input-csv" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("textarea", { style: { width: width, height: height }, placeholder: "Enter CSV here...", value: this.state.text, onChange: this.onTextChange, className: "gf-form-input" }),
            data && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("footer", null, data.map(function (frame, index) {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { key: index },
                    "Rows:",
                    frame.length,
                    ", Columns:",
                    frame.fields.length,
                    " \u00A0",
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-check-circle" })));
            })))));
    };
    return TableInputCSV;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));

/* harmony default export */ __webpack_exports__["default"] = (TableInputCSV);


/***/ }),

/***/ "./packages/grafana-ui/src/components/ThresholdsEditor/ThresholdsEditor.tsx":
/*!**********************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ThresholdsEditor/ThresholdsEditor.tsx ***!
  \**********************************************************************************/
/*! exports provided: ThresholdsEditor, thresholdsWithoutKey */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ThresholdsEditor", function() { return ThresholdsEditor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "thresholdsWithoutKey", function() { return thresholdsWithoutKey; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "./packages/grafana-ui/src/utils/index.ts");
/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../themes */ "./packages/grafana-ui/src/themes/index.ts");
/* harmony import */ var _Input_Input__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Input/Input */ "./packages/grafana-ui/src/components/Input/Input.tsx");
/* harmony import */ var _ColorPicker_ColorPicker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../ColorPicker/ColorPicker */ "./packages/grafana-ui/src/components/ColorPicker/ColorPicker.tsx");
/* harmony import */ var _PanelOptionsGroup_PanelOptionsGroup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../PanelOptionsGroup/PanelOptionsGroup */ "./packages/grafana-ui/src/components/PanelOptionsGroup/PanelOptionsGroup.tsx");









var counter = 100;
function toThresholdsWithKey(thresholds) {
    if (!thresholds || thresholds.length === 0) {
        thresholds = [{ value: -Infinity, color: 'green' }];
    }
    return thresholds.map(function (t) {
        return {
            color: t.color,
            value: t.value === null ? -Infinity : t.value,
            key: counter++,
        };
    });
}
var ThresholdsEditor = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ThresholdsEditor, _super);
    function ThresholdsEditor(props) {
        var _this = _super.call(this, props) || this;
        _this.onAddThresholdAfter = function (threshold) {
            var e_1, _a;
            var thresholds = _this.state.thresholds;
            var maxValue = 100;
            var minValue = 0;
            var prev = undefined;
            var next = undefined;
            try {
                for (var thresholds_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](thresholds), thresholds_1_1 = thresholds_1.next(); !thresholds_1_1.done; thresholds_1_1 = thresholds_1.next()) {
                    var t = thresholds_1_1.value;
                    if (prev && prev.key === threshold.key) {
                        next = t;
                        break;
                    }
                    prev = t;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (thresholds_1_1 && !thresholds_1_1.done && (_a = thresholds_1.return)) _a.call(thresholds_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            var prevValue = prev && isFinite(prev.value) ? prev.value : minValue;
            var nextValue = next && isFinite(next.value) ? next.value : maxValue;
            var color = _utils__WEBPACK_IMPORTED_MODULE_3__["colors"].filter(function (c) { return !thresholds.some(function (t) { return t.color === c; }); })[1];
            var add = {
                value: prevValue + (nextValue - prevValue) / 2.0,
                color: color,
                key: counter++,
            };
            var newThresholds = tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](thresholds, [add]);
            Object(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["sortThresholds"])(newThresholds);
            _this.setState({
                thresholds: newThresholds,
            }, function () { return _this.onChange(); });
        };
        _this.onRemoveThreshold = function (threshold) {
            var thresholds = _this.state.thresholds;
            if (!thresholds.length) {
                return;
            }
            // Don't remove index 0
            if (threshold.key === thresholds[0].key) {
                return;
            }
            _this.setState({
                thresholds: thresholds.filter(function (t) { return t.key !== threshold.key; }),
            }, function () { return _this.onChange(); });
        };
        _this.onChangeThresholdValue = function (event, threshold) {
            var cleanValue = event.target.value.replace(/,/g, '.');
            var parsedValue = parseFloat(cleanValue);
            var value = isNaN(parsedValue) ? '' : parsedValue;
            var thresholds = _this.state.thresholds.map(function (t) {
                if (t.key === threshold.key) {
                    t = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, t, { value: value });
                }
                return t;
            });
            if (thresholds.length) {
                thresholds[0].value = -Infinity;
            }
            _this.setState({ thresholds: thresholds });
        };
        _this.onChangeThresholdColor = function (threshold, color) {
            var thresholds = _this.state.thresholds;
            var newThresholds = thresholds.map(function (t) {
                if (t.key === threshold.key) {
                    t = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, t, { color: color });
                }
                return t;
            });
            _this.setState({
                thresholds: newThresholds,
            }, function () { return _this.onChange(); });
        };
        _this.onBlur = function () {
            var thresholds = tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](_this.state.thresholds);
            Object(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["sortThresholds"])(thresholds);
            _this.setState({
                thresholds: thresholds,
            }, function () { return _this.onChange(); });
        };
        _this.onChange = function () {
            var thresholds = _this.state.thresholds;
            _this.props.onChange(thresholdsWithoutKey(thresholds));
        };
        _this.renderInput = function (threshold) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-input-inner" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "thresholds-row-input-inner-arrow" }),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-input-inner-color" }, threshold.color && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-input-inner-color-colorpicker" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ColorPicker_ColorPicker__WEBPACK_IMPORTED_MODULE_6__["ColorPicker"], { color: threshold.color, onChange: function (color) { return _this.onChangeThresholdColor(threshold, color); }, enableNamedColors: true })))),
                !isFinite(threshold.value) ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-input-inner-value" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Input_Input__WEBPACK_IMPORTED_MODULE_5__["Input"], { type: "text", value: "Base", readOnly: true }))) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-input-inner-value" },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Input_Input__WEBPACK_IMPORTED_MODULE_5__["Input"], { type: "number", step: "0.0001", onChange: function (event) { return _this.onChangeThresholdValue(event, threshold); }, value: threshold.value, onBlur: _this.onBlur })),
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-input-inner-remove", onClick: function () { return _this.onRemoveThreshold(threshold); } },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-times" }))))));
        };
        var thresholds = toThresholdsWithKey(props.thresholds);
        thresholds[0].value = -Infinity;
        _this.state = { thresholds: thresholds };
        return _this;
    }
    ThresholdsEditor.prototype.render = function () {
        var _this = this;
        var thresholds = this.state.thresholds;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_themes__WEBPACK_IMPORTED_MODULE_4__["ThemeContext"].Consumer, null, function (theme) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_PanelOptionsGroup_PanelOptionsGroup__WEBPACK_IMPORTED_MODULE_7__["PanelOptionsGroup"], { title: "Thresholds" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds" }, thresholds
                    .slice(0)
                    .reverse()
                    .map(function (threshold) {
                    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row", key: "" + threshold.key },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-add-button", onClick: function () { return _this.onAddThresholdAfter(threshold); } },
                            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-plus" })),
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-color-indicator", style: { backgroundColor: Object(_utils__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(threshold.color, theme.type) } }),
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "thresholds-row-input" }, _this.renderInput(threshold))));
                }))));
        }));
    };
    return ThresholdsEditor;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

function thresholdsWithoutKey(thresholds) {
    return thresholds.map(function (t) {
        var key = t.key, rest = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](t, ["key"]);
        return rest; // everything except key
    });
}


/***/ }),

/***/ "./packages/grafana-ui/src/components/TimePicker/TimeOfDayPicker.tsx":
/*!***************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TimePicker/TimeOfDayPicker.tsx ***!
  \***************************************************************************/
/*! exports provided: TimeOfDayPicker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TimeOfDayPicker", function() { return TimeOfDayPicker; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var rc_time_picker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rc-time-picker */ "./node_modules/rc-time-picker/es/index.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");



var TimeOfDayPicker = function (_a) {
    var _b = _a.minuteStep, minuteStep = _b === void 0 ? 1 : _b, _c = _a.showHour, showHour = _c === void 0 ? true : _c, onChange = _a.onChange, value = _a.value;
    return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(rc_time_picker__WEBPACK_IMPORTED_MODULE_1__["default"], { defaultValue: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["dateTimeAsMoment"])(), onChange: function (value) { return onChange(Object(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["dateTime"])(value)); }, allowEmpty: false, showSecond: false, value: Object(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["dateTimeAsMoment"])(value), showHour: showHour, minuteStep: minuteStep })));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/TimePicker/TimePicker.tsx":
/*!**********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TimePicker/TimePicker.tsx ***!
  \**********************************************************************/
/*! exports provided: defaultSelectOptions, TimePicker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultSelectOptions", function() { return defaultSelectOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TimePicker", function() { return TimePicker; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Select_ButtonSelect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Select/ButtonSelect */ "./packages/grafana-ui/src/components/Select/ButtonSelect.tsx");
/* harmony import */ var _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Tooltip/Tooltip */ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx");
/* harmony import */ var _TimePickerPopover__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./TimePickerPopover */ "./packages/grafana-ui/src/components/TimePicker/TimePickerPopover.tsx");
/* harmony import */ var _ClickOutsideWrapper_ClickOutsideWrapper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../ClickOutsideWrapper/ClickOutsideWrapper */ "./packages/grafana-ui/src/components/ClickOutsideWrapper/ClickOutsideWrapper.tsx");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./time */ "./packages/grafana-ui/src/components/TimePicker/time.ts");

// Libraries

// Components




// Utils & Services



// Types


var defaultSelectOptions = [
    { from: 'now-5m', to: 'now', display: 'Last 5 minutes', section: 3 },
    { from: 'now-15m', to: 'now', display: 'Last 15 minutes', section: 3 },
    { from: 'now-30m', to: 'now', display: 'Last 30 minutes', section: 3 },
    { from: 'now-1h', to: 'now', display: 'Last 1 hour', section: 3 },
    { from: 'now-3h', to: 'now', display: 'Last 3 hours', section: 3 },
    { from: 'now-6h', to: 'now', display: 'Last 6 hours', section: 3 },
    { from: 'now-12h', to: 'now', display: 'Last 12 hours', section: 3 },
    { from: 'now-24h', to: 'now', display: 'Last 24 hours', section: 3 },
    { from: 'now-2d', to: 'now', display: 'Last 2 days', section: 3 },
    { from: 'now-7d', to: 'now', display: 'Last 7 days', section: 3 },
    { from: 'now-30d', to: 'now', display: 'Last 30 days', section: 3 },
    { from: 'now-90d', to: 'now', display: 'Last 90 days', section: 3 },
    { from: 'now-6M', to: 'now', display: 'Last 6 months', section: 3 },
    { from: 'now-1y', to: 'now', display: 'Last 1 year', section: 3 },
    { from: 'now-2y', to: 'now', display: 'Last 2 years', section: 3 },
    { from: 'now-5y', to: 'now', display: 'Last 5 years', section: 3 },
    { from: 'now-1d/d', to: 'now-1d/d', display: 'Yesterday', section: 3 },
    { from: 'now-2d/d', to: 'now-2d/d', display: 'Day before yesterday', section: 3 },
    { from: 'now-7d/d', to: 'now-7d/d', display: 'This day last week', section: 3 },
    { from: 'now-1w/w', to: 'now-1w/w', display: 'Previous week', section: 3 },
    { from: 'now-1M/M', to: 'now-1M/M', display: 'Previous month', section: 3 },
    { from: 'now-1y/y', to: 'now-1y/y', display: 'Previous year', section: 3 },
    { from: 'now/d', to: 'now/d', display: 'Today', section: 3 },
    { from: 'now/d', to: 'now', display: 'Today so far', section: 3 },
    { from: 'now/w', to: 'now/w', display: 'This week', section: 3 },
    { from: 'now/w', to: 'now', display: 'This week so far', section: 3 },
    { from: 'now/M', to: 'now/M', display: 'This month', section: 3 },
    { from: 'now/M', to: 'now', display: 'This month so far', section: 3 },
    { from: 'now/y', to: 'now/y', display: 'This year', section: 3 },
    { from: 'now/y', to: 'now', display: 'This year so far', section: 3 },
];
var defaultZoomOutTooltip = function () {
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
        "Time range zoom out ",
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("br", null),
        " CTRL+Z"));
};
var TimePicker = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TimePicker, _super);
    function TimePicker() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pickerTriggerRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["createRef"])();
        _this.state = {
            isCustomOpen: false,
        };
        _this.mapTimeOptionsToSelectableValues = function (selectOptions) {
            var options = selectOptions.map(function (timeOption) {
                return {
                    label: timeOption.display,
                    value: timeOption,
                };
            });
            options.unshift({
                label: 'Custom time range',
                value: { from: 'custom', to: 'custom', display: 'Custom', section: 1 },
            });
            return options;
        };
        _this.onSelectChanged = function (item) {
            var _a = _this.props, onChange = _a.onChange, timeZone = _a.timeZone;
            if (item.value && item.value.from === 'custom') {
                // this is to prevent the ClickOutsideWrapper from directly closing the popover
                setTimeout(function () {
                    _this.setState({ isCustomOpen: true });
                }, 1);
                return;
            }
            if (item.value) {
                onChange(Object(_time__WEBPACK_IMPORTED_MODULE_7__["rawToTimeRange"])({ from: item.value.from, to: item.value.to }, timeZone));
            }
        };
        _this.onCustomChange = function (timeRange) {
            var onChange = _this.props.onChange;
            onChange(timeRange);
            _this.setState({ isCustomOpen: false });
        };
        _this.onCloseCustom = function () {
            _this.setState({ isCustomOpen: false });
        };
        return _this;
    }
    TimePicker.prototype.render = function () {
        var _a = this.props, selectTimeOptions = _a.selectOptions, value = _a.value, onMoveBackward = _a.onMoveBackward, onMoveForward = _a.onMoveForward, onZoom = _a.onZoom, timeZone = _a.timeZone;
        var isCustomOpen = this.state.isCustomOpen;
        var options = this.mapTimeOptionsToSelectableValues(selectTimeOptions);
        var currentOption = options.find(function (item) { return isTimeOptionEqualToTimeRange(item.value, value); });
        var isUTC = timeZone === 'utc';
        var adjustedTime = function (time) { return (isUTC ? time.utc() : time.local()) || null; };
        var adjustedTimeRange = {
            to: _grafana_data__WEBPACK_IMPORTED_MODULE_6__["dateMath"].isMathString(value.raw.to) ? value.raw.to : adjustedTime(value.to),
            from: _grafana_data__WEBPACK_IMPORTED_MODULE_6__["dateMath"].isMathString(value.raw.from) ? value.raw.from : adjustedTime(value.from),
        };
        var rangeString = _grafana_data__WEBPACK_IMPORTED_MODULE_6__["rangeUtil"].describeTimeRange(adjustedTimeRange);
        var label = (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
            isCustomOpen && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, "Custom time range"),
            !isCustomOpen && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, rangeString),
            isUTC && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "time-picker-utc" }, "UTC")));
        var isAbsolute = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_6__["isDateTime"])(value.raw.to);
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker", ref: this.pickerTriggerRef },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-buttons" },
                isAbsolute && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { className: "btn navbar-button navbar-button--tight", onClick: onMoveBackward },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-chevron-left" }))),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Select_ButtonSelect__WEBPACK_IMPORTED_MODULE_2__["ButtonSelect"], { className: "time-picker-button-select", value: currentOption, label: label, options: options, maxMenuHeight: 600, onChange: this.onSelectChanged, iconClass: 'fa fa-clock-o fa-fw', tooltipContent: react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(TimePickerTooltipContent, { timeRange: value }) }),
                isAbsolute && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { className: "btn navbar-button navbar-button--tight", onClick: onMoveForward },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-chevron-right" }))),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_3__["Tooltip"], { content: defaultZoomOutTooltip, placement: "bottom" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { className: "btn navbar-button navbar-button--zoom", onClick: onZoom },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-search-minus" }))),
                isCustomOpen && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ClickOutsideWrapper_ClickOutsideWrapper__WEBPACK_IMPORTED_MODULE_5__["ClickOutsideWrapper"], { onClick: this.onCloseCustom },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TimePickerPopover__WEBPACK_IMPORTED_MODULE_4__["TimePickerPopover"], { value: value, timeZone: timeZone, onChange: this.onCustomChange }))))));
    };
    return TimePicker;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

var TimePickerTooltipContent = function (_a) {
    var timeRange = _a.timeRange;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
        timeRange.from.format(_grafana_data__WEBPACK_IMPORTED_MODULE_6__["TIME_FORMAT"]),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "text-center" }, "to"),
        timeRange.to.format(_grafana_data__WEBPACK_IMPORTED_MODULE_6__["TIME_FORMAT"])));
};
function isTimeOptionEqualToTimeRange(option, range) {
    return range.raw.from === option.from && range.raw.to === option.to;
}


/***/ }),

/***/ "./packages/grafana-ui/src/components/TimePicker/TimePickerCalendar.tsx":
/*!******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TimePicker/TimePickerCalendar.tsx ***!
  \******************************************************************************/
/*! exports provided: TimePickerCalendar */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TimePickerCalendar", function() { return TimePickerCalendar; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_calendar_dist_entry_nostyle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-calendar/dist/entry.nostyle */ "./node_modules/react-calendar/dist/entry.nostyle.js");
/* harmony import */ var react_calendar_dist_entry_nostyle__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_calendar_dist_entry_nostyle__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _time__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./time */ "./packages/grafana-ui/src/components/TimePicker/time.ts");






var TimePickerCalendar = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TimePickerCalendar, _super);
    function TimePickerCalendar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onCalendarChange = function (date) {
            var _a = _this.props, onChange = _a.onChange, timeZone = _a.timeZone;
            if (Array.isArray(date)) {
                return;
            }
            var newDate = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["dateTime"])(date);
            if (timeZone === 'utc') {
                newDate = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["toUtc"])(newDate.format(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["TIME_FORMAT"]));
            }
            onChange(newDate);
        };
        _this.onDrilldown = function (props) {
            // this is to prevent clickout side wrapper from triggering when drilling down
            if (window.event) {
                // @ts-ignore
                window.event.stopPropagation();
            }
        };
        return _this;
    }
    TimePickerCalendar.prototype.render = function () {
        var _a = this.props, value = _a.value, roundup = _a.roundup, timeZone = _a.timeZone;
        var date = Object(_time__WEBPACK_IMPORTED_MODULE_4__["stringToDateTimeType"])(value, roundup, timeZone);
        if (!date.isValid()) {
            date = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["dateTime"])();
        }
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_calendar_dist_entry_nostyle__WEBPACK_IMPORTED_MODULE_2___default.a, { value: date.toDate(), next2Label: null, prev2Label: null, className: "time-picker-calendar", tileClassName: "time-picker-calendar-tile", onChange: this.onCalendarChange, onDrillDown: this.onDrilldown, nextLabel: react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "fa fa-angle-right" }), prevLabel: react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "fa fa-angle-left" }) }));
    };
    return TimePickerCalendar;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/TimePicker/TimePickerInput.tsx":
/*!***************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TimePicker/TimePickerInput.tsx ***!
  \***************************************************************************/
/*! exports provided: TimePickerInput */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TimePickerInput", function() { return TimePickerInput; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _Input_Input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Input/Input */ "./packages/grafana-ui/src/components/Input/Input.tsx");
/* harmony import */ var _time__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./time */ "./packages/grafana-ui/src/components/TimePicker/time.ts");





var TimePickerInput = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TimePickerInput, _super);
    function TimePickerInput() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isValid = function (value) {
            var _a = _this.props, timeZone = _a.timeZone, roundup = _a.roundup;
            if (value.indexOf('now') !== -1) {
                var isValid_1 = Object(_time__WEBPACK_IMPORTED_MODULE_4__["isValidTimeString"])(value);
                return isValid_1;
            }
            var parsed = Object(_time__WEBPACK_IMPORTED_MODULE_4__["stringToDateTimeType"])(value, roundup, timeZone);
            var isValid = parsed.isValid();
            return isValid;
        };
        _this.onChange = function (event) {
            var onChange = _this.props.onChange;
            var value = event.target.value;
            onChange(value, _this.isValid(value));
        };
        _this.valueToString = function (value) {
            if (Object(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["isDateTime"])(value)) {
                return value.format(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["TIME_FORMAT"]);
            }
            else {
                return value;
            }
        };
        return _this;
    }
    TimePickerInput.prototype.render = function () {
        var _a = this.props, value = _a.value, tabIndex = _a.tabIndex;
        var valueString = this.valueToString(value);
        var error = !this.isValid(valueString);
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Input_Input__WEBPACK_IMPORTED_MODULE_3__["Input"], { type: "text", onChange: this.onChange, onBlur: this.onChange, hideErrorMessage: true, value: valueString, className: "time-picker-input" + (error ? '-error' : ''), tabIndex: tabIndex }));
    };
    return TimePickerInput;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/TimePicker/TimePickerPopover.tsx":
/*!*****************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TimePicker/TimePickerPopover.tsx ***!
  \*****************************************************************************/
/*! exports provided: TimePickerPopover */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TimePickerPopover", function() { return TimePickerPopover; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _TimePickerCalendar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TimePickerCalendar */ "./packages/grafana-ui/src/components/TimePicker/TimePickerCalendar.tsx");
/* harmony import */ var _TimePickerInput__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TimePickerInput */ "./packages/grafana-ui/src/components/TimePicker/TimePickerInput.tsx");
/* harmony import */ var _time__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./time */ "./packages/grafana-ui/src/components/TimePicker/time.ts");

// Libraries

// Components



var TimePickerPopover = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TimePickerPopover, _super);
    function TimePickerPopover(props) {
        var _this = _super.call(this, props) || this;
        _this.onFromInputChanged = function (value, valid) {
            _this.setState({ from: value, isFromInputValid: valid });
        };
        _this.onToInputChanged = function (value, valid) {
            _this.setState({ to: value, isToInputValid: valid });
        };
        _this.onFromCalendarChanged = function (value) {
            _this.setState({ from: value });
        };
        _this.onToCalendarChanged = function (value) {
            value.set('h', 23);
            value.set('m', 59);
            value.set('s', 59);
            _this.setState({ to: value });
        };
        _this.onApplyClick = function () {
            var _a = _this.props, onChange = _a.onChange, timeZone = _a.timeZone;
            var _b = _this.state, from = _b.from, to = _b.to;
            onChange(Object(_time__WEBPACK_IMPORTED_MODULE_4__["rawToTimeRange"])({ from: from, to: to }, timeZone));
        };
        _this.state = {
            from: props.value.raw.from,
            to: props.value.raw.to,
            isFromInputValid: true,
            isToInputValid: true,
        };
        return _this;
    }
    TimePickerPopover.prototype.render = function () {
        var timeZone = this.props.timeZone;
        var _a = this.state, isFromInputValid = _a.isFromInputValid, isToInputValid = _a.isToInputValid, from = _a.from, to = _a.to;
        var isValid = isFromInputValid && isToInputValid;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: TimePickerPopover.popoverClassName },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-body" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-body-custom-ranges" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-body-custom-ranges-input" },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form" },
                            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("label", { className: "gf-form-label" }, "From"),
                            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TimePickerInput__WEBPACK_IMPORTED_MODULE_3__["TimePickerInput"], { roundup: false, timeZone: timeZone, value: from, onChange: this.onFromInputChanged, tabIndex: 1 }))),
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-body-custom-ranges-calendar" },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TimePickerCalendar__WEBPACK_IMPORTED_MODULE_2__["TimePickerCalendar"], { timeZone: timeZone, roundup: false, value: from, onChange: this.onFromCalendarChanged }))),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-body-custom-ranges" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-body-custom-ranges-input" },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form" },
                            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("label", { className: "gf-form-label" }, "To"),
                            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TimePickerInput__WEBPACK_IMPORTED_MODULE_3__["TimePickerInput"], { roundup: true, timeZone: timeZone, value: to, onChange: this.onToInputChanged, tabIndex: 2 }))),
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-body-custom-ranges-calendar" },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TimePickerCalendar__WEBPACK_IMPORTED_MODULE_2__["TimePickerCalendar"], { roundup: true, timeZone: timeZone, value: to, onChange: this.onToCalendarChanged })))),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "time-picker-popover-footer" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { type: "submit", className: "btn btn-success", disabled: !isValid, onClick: this.onApplyClick }, "Apply"))));
    };
    TimePickerPopover.popoverClassName = 'time-picker-popover';
    return TimePickerPopover;
}(react__WEBPACK_IMPORTED_MODULE_1__["Component"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/TimePicker/time.ts":
/*!***************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TimePicker/time.ts ***!
  \***************************************************************/
/*! exports provided: rawToTimeRange, stringToDateTimeType, mapTimeRangeToRangeString, isValidTimeString */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "rawToTimeRange", function() { return rawToTimeRange; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stringToDateTimeType", function() { return stringToDateTimeType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mapTimeRangeToRangeString", function() { return mapTimeRangeToRangeString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isValidTimeString", function() { return isValidTimeString; });
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");

var rawToTimeRange = function (raw, timeZone) {
    var from = stringToDateTimeType(raw.from, false, timeZone);
    var to = stringToDateTimeType(raw.to, true, timeZone);
    return { from: from, to: to, raw: raw };
};
var stringToDateTimeType = function (value, roundUp, timeZone) {
    if (Object(_grafana_data__WEBPACK_IMPORTED_MODULE_0__["isDateTime"])(value)) {
        return value;
    }
    if (value.indexOf('now') !== -1) {
        if (!_grafana_data__WEBPACK_IMPORTED_MODULE_0__["dateMath"].isValid(value)) {
            return Object(_grafana_data__WEBPACK_IMPORTED_MODULE_0__["dateTime"])();
        }
        var parsed = _grafana_data__WEBPACK_IMPORTED_MODULE_0__["dateMath"].parse(value, roundUp, timeZone);
        return parsed || Object(_grafana_data__WEBPACK_IMPORTED_MODULE_0__["dateTime"])();
    }
    return Object(_grafana_data__WEBPACK_IMPORTED_MODULE_0__["dateTimeForTimeZone"])(timeZone, value, _grafana_data__WEBPACK_IMPORTED_MODULE_0__["TIME_FORMAT"]);
};
var mapTimeRangeToRangeString = function (timeRange) {
    return _grafana_data__WEBPACK_IMPORTED_MODULE_0__["rangeUtil"].describeTimeRange(timeRange);
};
var isValidTimeString = function (text) { return _grafana_data__WEBPACK_IMPORTED_MODULE_0__["dateMath"].isValid(text); };


/***/ }),

/***/ "./packages/grafana-ui/src/components/ToggleButtonGroup/ToggleButtonGroup.tsx":
/*!************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ToggleButtonGroup/ToggleButtonGroup.tsx ***!
  \************************************************************************************/
/*! exports provided: ToggleButtonGroup, ToggleButton */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ToggleButtonGroup", function() { return ToggleButtonGroup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ToggleButton", function() { return ToggleButton; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Tooltip/Tooltip */ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx");



var ToggleButtonGroup = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ToggleButtonGroup, _super);
    function ToggleButtonGroup() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleButtonGroup.prototype.render = function () {
        var _a = this.props, children = _a.children, label = _a.label, transparent = _a.transparent;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form gf-form--align-center" },
            label && react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("label", { className: "gf-form-label " + (transparent ? 'gf-form-label--transparent' : '') }, label),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "toggle-button-group " + (transparent ? 'toggle-button-group--transparent' : '') }, children)));
    };
    return ToggleButtonGroup;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));

var ToggleButton = function (_a) {
    var children = _a.children, selected = _a.selected, _b = _a.className, className = _b === void 0 ? '' : _b, _c = _a.value, value = _c === void 0 ? null : _c, tooltip = _a.tooltip, onChange = _a.onChange;
    var onClick = function (event) {
        event.stopPropagation();
        if (!selected && onChange) {
            onChange(value);
        }
    };
    var btnClassName = "btn " + className + (selected ? ' active' : '');
    var button = (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { className: btnClassName, onClick: onClick },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null, children)));
    if (tooltip) {
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_2__["Tooltip"], { content: tooltip, placement: "bottom" }, button));
    }
    else {
        return button;
    }
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/Tooltip/Popover.tsx":
/*!****************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Tooltip/Popover.tsx ***!
  \****************************************************************/
/*! exports provided: Popover */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Popover", function() { return Popover; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_popper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-popper */ "./node_modules/react-popper/lib/esm/index.js");
/* harmony import */ var _Portal_Portal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Portal/Portal */ "./packages/grafana-ui/src/components/Portal/Portal.tsx");
/* harmony import */ var react_transition_group_Transition__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-transition-group/Transition */ "./node_modules/react-transition-group/Transition.js");
/* harmony import */ var react_transition_group_Transition__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_transition_group_Transition__WEBPACK_IMPORTED_MODULE_4__);





var defaultTransitionStyles = {
    transition: 'opacity 200ms linear',
    opacity: 0,
};
var transitionStyles = {
    exited: { opacity: 0 },
    entering: { opacity: 0 },
    entered: { opacity: 1, transitionDelay: '0s' },
    exiting: { opacity: 0, transitionDelay: '500ms' },
};
var Popover = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Popover, _super);
    function Popover() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Popover.prototype.render = function () {
        var _a = this.props, content = _a.content, show = _a.show, placement = _a.placement, onMouseEnter = _a.onMouseEnter, onMouseLeave = _a.onMouseLeave, className = _a.className, wrapperClassName = _a.wrapperClassName, renderArrow = _a.renderArrow, referenceElement = _a.referenceElement, eventsEnabled = _a.eventsEnabled;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_popper__WEBPACK_IMPORTED_MODULE_2__["Manager"], null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_transition_group_Transition__WEBPACK_IMPORTED_MODULE_4___default.a, { in: show, timeout: 100, mountOnEnter: true, unmountOnExit: true }, function (transitionState) {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Portal_Portal__WEBPACK_IMPORTED_MODULE_3__["Portal"], null,
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_popper__WEBPACK_IMPORTED_MODULE_2__["Popper"], { placement: placement, referenceElement: referenceElement, eventsEnabled: eventsEnabled, 
                        // TODO: move modifiers config to popper controller
                        modifiers: { preventOverflow: { enabled: true, boundariesElement: 'window' } } }, function (_a) {
                        var ref = _a.ref, style = _a.style, placement = _a.placement, arrowProps = _a.arrowProps, scheduleUpdate = _a.scheduleUpdate;
                        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { onMouseEnter: onMouseEnter, onMouseLeave: onMouseLeave, ref: ref, style: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, style, defaultTransitionStyles, transitionStyles[transitionState]), "data-placement": placement, className: "" + wrapperClassName },
                            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: className },
                                typeof content === 'string' && content,
                                react__WEBPACK_IMPORTED_MODULE_1___default.a.isValidElement(content) && react__WEBPACK_IMPORTED_MODULE_1___default.a.cloneElement(content),
                                typeof content === 'function' &&
                                    content({
                                        updatePopperPosition: scheduleUpdate,
                                    }),
                                renderArrow &&
                                    renderArrow({
                                        arrowProps: arrowProps,
                                        placement: placement,
                                    }))));
                    })));
            })));
    };
    Popover.defaultProps = {
        eventsEnabled: true,
    };
    return Popover;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Tooltip/PopoverController.tsx":
/*!**************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Tooltip/PopoverController.tsx ***!
  \**************************************************************************/
/*! exports provided: PopoverController */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PopoverController", function() { return PopoverController; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


var PopoverController = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](PopoverController, _super);
    function PopoverController(props) {
        var _this = _super.call(this, props) || this;
        _this.showPopper = function () {
            if (_this.hideTimeout) {
                clearTimeout(_this.hideTimeout);
            }
            _this.setState(function (prevState) { return (tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, prevState, { show: true })); });
        };
        _this.hidePopper = function () {
            if (_this.props.hideAfter !== 0) {
                _this.hideTimeout = setTimeout(function () {
                    _this.setState(function (prevState) { return (tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, prevState, { show: false })); });
                }, _this.props.hideAfter);
                return;
            }
            _this.setState(function (prevState) { return (tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, prevState, { show: false })); });
        };
        _this.state = {
            placement: _this.props.placement || 'auto',
            show: false,
        };
        return _this;
    }
    PopoverController.prototype.UNSAFE_componentWillReceiveProps = function (nextProps) {
        if (nextProps.placement && nextProps.placement !== this.state.placement) {
            this.setState(function (prevState) {
                return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, prevState, { placement: nextProps.placement || 'auto' });
            });
        }
    };
    PopoverController.prototype.render = function () {
        var _a = this.props, children = _a.children, content = _a.content;
        var _b = this.state, show = _b.show, placement = _b.placement;
        return children(this.showPopper, this.hidePopper, {
            show: show,
            placement: placement,
            content: content,
        });
    };
    return PopoverController;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.Component));



/***/ }),

/***/ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx":
/*!****************************************************************!*\
  !*** ./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx ***!
  \****************************************************************/
/*! exports provided: Tooltip */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Tooltip", function() { return Tooltip; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Popover__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Popover */ "./packages/grafana-ui/src/components/Tooltip/Popover.tsx");
/* harmony import */ var _PopoverController__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PopoverController */ "./packages/grafana-ui/src/components/Tooltip/PopoverController.tsx");




var Tooltip = function (_a) {
    var children = _a.children, theme = _a.theme, controllerProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__rest"](_a, ["children", "theme"]);
    var tooltipTriggerRef = Object(react__WEBPACK_IMPORTED_MODULE_1__["createRef"])();
    var popperBackgroundClassName = 'popper__background' + (theme ? ' popper__background--' + theme : '');
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_PopoverController__WEBPACK_IMPORTED_MODULE_3__["PopoverController"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, controllerProps), function (showPopper, hidePopper, popperProps) {
        {
            /* Override internal 'show' state if passed in as prop */
        }
        var payloadProps = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, popperProps, { show: controllerProps.show !== undefined ? controllerProps.show : popperProps.show });
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
            tooltipTriggerRef.current && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Popover__WEBPACK_IMPORTED_MODULE_2__["Popover"], tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, payloadProps, { onMouseEnter: showPopper, onMouseLeave: hidePopper, referenceElement: tooltipTriggerRef.current, wrapperClassName: "popper", className: popperBackgroundClassName, renderArrow: function (_a) {
                    var arrowProps = _a.arrowProps, placement = _a.placement;
                    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({ className: "popper__arrow", "data-placement": placement }, arrowProps)));
                } }))),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.cloneElement(children, {
                ref: tooltipTriggerRef,
                onMouseEnter: showPopper,
                onMouseLeave: hidePopper,
            })));
    }));
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/TransformersUI/FilterByNameTransformerEditor.tsx":
/*!*********************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TransformersUI/FilterByNameTransformerEditor.tsx ***!
  \*********************************************************************************************/
/*! exports provided: FilterByNameTransformerEditor, filterFieldsByNameTransformRegistryItem */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilterByNameTransformerEditor", function() { return FilterByNameTransformerEditor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "filterFieldsByNameTransformRegistryItem", function() { return filterFieldsByNameTransformRegistryItem; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _List_InlineList__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../List/InlineList */ "./packages/grafana-ui/src/components/List/InlineList.tsx");






var FilterByNameTransformerEditor = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](FilterByNameTransformerEditor, _super);
    function FilterByNameTransformerEditor(props) {
        var _this = _super.call(this, props) || this;
        _this.onFieldToggle = function (fieldName) {
            var selected = _this.state.selected;
            if (selected.indexOf(fieldName) > -1) {
                _this.onChange(selected.filter(function (s) { return s !== fieldName; }));
            }
            else {
                _this.onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](selected, [fieldName]));
            }
        };
        _this.onChange = function (selected) {
            _this.setState({ selected: selected });
            _this.props.onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _this.props.options, { include: selected.join('|') }));
        };
        _this.state = {
            include: props.options.include || '',
            options: [],
            selected: [],
        };
        return _this;
    }
    FilterByNameTransformerEditor.prototype.componentDidMount = function () {
        this.initOptions();
    };
    FilterByNameTransformerEditor.prototype.initOptions = function () {
        var e_1, _a, e_2, _b, e_3, _c;
        var _d = this.props, input = _d.input, options = _d.options;
        var configuredOptions = options.include ? options.include.split('|') : [];
        var allNames = [];
        var byName = {};
        try {
            for (var input_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](input), input_1_1 = input_1.next(); !input_1_1.done; input_1_1 = input_1.next()) {
                var frame = input_1_1.value;
                try {
                    for (var _e = (e_2 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](frame.fields)), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var field = _f.value;
                        var v = byName[field.name];
                        if (!v) {
                            v = byName[field.name] = {
                                name: field.name,
                                count: 0,
                            };
                            allNames.push(v);
                        }
                        v.count++;
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (input_1_1 && !input_1_1.done && (_a = input_1.return)) _a.call(input_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (configuredOptions.length) {
            var options_1 = [];
            var selected = [];
            try {
                for (var allNames_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](allNames), allNames_1_1 = allNames_1.next(); !allNames_1_1.done; allNames_1_1 = allNames_1.next()) {
                    var v = allNames_1_1.value;
                    if (configuredOptions.includes(v.name)) {
                        selected.push(v);
                    }
                    options_1.push(v);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (allNames_1_1 && !allNames_1_1.done && (_c = allNames_1.return)) _c.call(allNames_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
            this.setState({
                options: options_1,
                selected: selected.map(function (s) { return s.name; }),
            });
        }
        else {
            this.setState({ options: allNames, selected: [] });
        }
    };
    FilterByNameTransformerEditor.prototype.render = function () {
        var _this = this;
        var _a = this.state, options = _a.options, selected = _a.selected;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_List_InlineList__WEBPACK_IMPORTED_MODULE_5__["InlineList"], { items: options, renderItem: function (o, i) {
                    var label = "" + o.name + (o.count > 1 ? ' (' + o.count + ')' : '');
                    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n                  margin-right: ", ";\n                "], ["\n                  margin-right: ", ";\n                "])), i === options.length - 1 ? '0' : '10px') },
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(FilterPill, { onClick: function () {
                                _this.onFieldToggle(o.name);
                            }, label: label, selected: selected.indexOf(o.name) > -1 })));
                } })));
    };
    return FilterByNameTransformerEditor;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));

var FilterPill = function (_a) {
    var label = _a.label, selected = _a.selected, onClick = _a.onClick;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n        padding: ", " ", ";\n        color: white;\n        background: ", ";\n        border-radius: 16px;\n        display: inline-block;\n        cursor: pointer;\n      "], ["\n        padding: ", " ", ";\n        color: white;\n        background: ", ";\n        border-radius: 16px;\n        display: inline-block;\n        cursor: pointer;\n      "])), theme.spacing.xxs, theme.spacing.sm, selected ? theme.colors.blueLight : theme.colors.blueShade), onClick: onClick },
        selected && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_4__["cx"])('fa fa-check', Object(emotion__WEBPACK_IMPORTED_MODULE_4__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n              margin-right: 4px;\n            "], ["\n              margin-right: 4px;\n            "])))) })),
        label));
};
var filterFieldsByNameTransformRegistryItem = {
    id: _grafana_data__WEBPACK_IMPORTED_MODULE_2__["DataTransformerID"].filterFieldsByName,
    component: FilterByNameTransformerEditor,
    transformer: _grafana_data__WEBPACK_IMPORTED_MODULE_2__["transformersRegistry"].get(_grafana_data__WEBPACK_IMPORTED_MODULE_2__["DataTransformerID"].filterFieldsByName),
    name: 'Filter by name',
    description: 'UI for filter by name transformation',
};
var templateObject_1, templateObject_2, templateObject_3;


/***/ }),

/***/ "./packages/grafana-ui/src/components/TransformersUI/ReduceTransformerEditor.tsx":
/*!***************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TransformersUI/ReduceTransformerEditor.tsx ***!
  \***************************************************************************************/
/*! exports provided: ReduceTransformerEditor, reduceTransformRegistryItem */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ReduceTransformerEditor", function() { return ReduceTransformerEditor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "reduceTransformRegistryItem", function() { return reduceTransformRegistryItem; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _StatsPicker_StatsPicker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../StatsPicker/StatsPicker */ "./packages/grafana-ui/src/components/StatsPicker/StatsPicker.tsx");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");




// TODO:  Minimal implementation, needs some <3
var ReduceTransformerEditor = function (_a) {
    var options = _a.options, onChange = _a.onChange, input = _a.input;
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_StatsPicker_StatsPicker__WEBPACK_IMPORTED_MODULE_2__["StatsPicker"], { width: 25, placeholder: "Choose Stat", allowMultiple: true, stats: options.reducers || [], onChange: function (stats) {
            onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, options, { reducers: stats }));
        } }));
};
var reduceTransformRegistryItem = {
    id: _grafana_data__WEBPACK_IMPORTED_MODULE_3__["DataTransformerID"].reduce,
    component: ReduceTransformerEditor,
    transformer: _grafana_data__WEBPACK_IMPORTED_MODULE_3__["transformersRegistry"].get(_grafana_data__WEBPACK_IMPORTED_MODULE_3__["DataTransformerID"].reduce),
    name: 'Reduce',
    description: 'UI for reduce transformation',
};


/***/ }),

/***/ "./packages/grafana-ui/src/components/TransformersUI/TransformationRow.tsx":
/*!*********************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TransformersUI/TransformationRow.tsx ***!
  \*********************************************************************************/
/*! exports provided: TransformationRow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TransformationRow", function() { return TransformationRow; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _themes_ThemeContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../themes/ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");
/* harmony import */ var _JSONFormatter_JSONFormatter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../JSONFormatter/JSONFormatter */ "./packages/grafana-ui/src/components/JSONFormatter/JSONFormatter.tsx");





var getStyles = function (theme) { return ({
    title: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    display: flex;\n    padding: 4px 8px 4px 8px;\n    position: relative;\n    height: 35px;\n    background: ", ";\n    border-radius: 4px 4px 0 0;\n    flex-wrap: nowrap;\n    justify-content: space-between;\n    align-items: center;\n  "], ["\n    display: flex;\n    padding: 4px 8px 4px 8px;\n    position: relative;\n    height: 35px;\n    background: ", ";\n    border-radius: 4px 4px 0 0;\n    flex-wrap: nowrap;\n    justify-content: space-between;\n    align-items: center;\n  "])), theme.colors.textFaint),
    name: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_2 || (templateObject_2 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    font-weight: ", ";\n    color: ", ";\n  "], ["\n    font-weight: ", ";\n    color: ", ";\n  "])), theme.typography.weight.semibold, theme.colors.blue),
    iconRow: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_3 || (templateObject_3 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    display: flex;\n  "], ["\n    display: flex;\n  "]))),
    icon: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_4 || (templateObject_4 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    background: transparent;\n    border: none;\n    box-shadow: none;\n    cursor: pointer;\n    color: ", ";\n    margin-left: ", ";\n    &:hover {\n      color: ", ";\n    }\n  "], ["\n    background: transparent;\n    border: none;\n    box-shadow: none;\n    cursor: pointer;\n    color: ", ";\n    margin-left: ", ";\n    &:hover {\n      color: ", ";\n    }\n  "])), theme.colors.textWeak, theme.spacing.sm, theme.colors.text),
    editor: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_5 || (templateObject_5 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n    border: 2px dashed ", ";\n    border-top: none;\n    border-radius: 0 0 4px 4px;\n    padding: 8px;\n  "], ["\n    border: 2px dashed ", ";\n    border-top: none;\n    border-radius: 0 0 4px 4px;\n    padding: 8px;\n  "])), theme.colors.textFaint),
}); };
var TransformationRow = function (_a) {
    var onRemove = _a.onRemove, editor = _a.editor, name = _a.name, input = _a.input;
    var theme = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_themes_ThemeContext__WEBPACK_IMPORTED_MODULE_2__["ThemeContext"]);
    var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false), 2), viewDebug = _b[0], setViewDebug = _b[1];
    var styles = getStyles(theme);
    return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: Object(emotion__WEBPACK_IMPORTED_MODULE_3__["css"])(templateObject_6 || (templateObject_6 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n        margin-bottom: 10px;\n      "], ["\n        margin-bottom: 10px;\n      "]))) },
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.title },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.name }, name),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.iconRow },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { onClick: function () { return setViewDebug(!viewDebug); }, className: styles.icon },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-fw fa-bug" })),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { onClick: onRemove, className: styles.icon },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-fw fa-trash" })))),
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: styles.editor },
            editor,
            viewDebug && (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_JSONFormatter_JSONFormatter__WEBPACK_IMPORTED_MODULE_4__["JSONFormatter"], { json: input }))))));
};
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6;


/***/ }),

/***/ "./packages/grafana-ui/src/components/TransformersUI/TransformationsEditor.tsx":
/*!*************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TransformersUI/TransformationsEditor.tsx ***!
  \*************************************************************************************/
/*! exports provided: TransformationsEditor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TransformationsEditor", function() { return TransformationsEditor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _Select_Select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Select/Select */ "./packages/grafana-ui/src/components/Select/Select.tsx");
/* harmony import */ var _transformers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transformers */ "./packages/grafana-ui/src/components/TransformersUI/transformers.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _TransformationRow__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TransformationRow */ "./packages/grafana-ui/src/components/TransformersUI/TransformationRow.tsx");
/* harmony import */ var _Button_Button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Button/Button */ "./packages/grafana-ui/src/components/Button/Button.tsx");
/* harmony import */ var emotion__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! emotion */ "./node_modules/emotion/dist/index.esm.js");








var TransformationsEditor = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](TransformationsEditor, _super);
    function TransformationsEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = { updateCounter: 0 };
        _this.onTransformationAdd = function () {
            var _a = _this.props, transformations = _a.transformations, onChange = _a.onChange;
            onChange(tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](transformations, [
                {
                    id: _grafana_data__WEBPACK_IMPORTED_MODULE_1__["DataTransformerID"].noop,
                    options: {},
                },
            ]));
            _this.setState({ updateCounter: _this.state.updateCounter + 1 });
        };
        _this.onTransformationChange = function (idx, config) {
            var _a = _this.props, transformations = _a.transformations, onChange = _a.onChange;
            transformations[idx] = config;
            onChange(transformations);
            _this.setState({ updateCounter: _this.state.updateCounter + 1 });
        };
        _this.onTransformationRemove = function (idx) {
            var _a = _this.props, transformations = _a.transformations, onChange = _a.onChange;
            transformations.splice(idx, 1);
            onChange(transformations);
            _this.setState({ updateCounter: _this.state.updateCounter + 1 });
        };
        _this.renderTransformationEditors = function () {
            var _a = _this.props, transformations = _a.transformations, dataFrames = _a.dataFrames;
            var hasTransformations = transformations.length > 0;
            var preTransformData = dataFrames;
            if (!hasTransformations) {
                return undefined;
            }
            var availableTransformers = _transformers__WEBPACK_IMPORTED_MODULE_3__["transformersUIRegistry"].list().map(function (t) {
                return {
                    value: t.transformer.id,
                    label: t.transformer.name,
                };
            });
            return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_4___default.a.Fragment, null, transformations.map(function (t, i) {
                var editor, input;
                if (t.id === _grafana_data__WEBPACK_IMPORTED_MODULE_1__["DataTransformerID"].noop) {
                    return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(_Select_Select__WEBPACK_IMPORTED_MODULE_2__["Select"], { className: Object(emotion__WEBPACK_IMPORTED_MODULE_7__["css"])(templateObject_1 || (templateObject_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__makeTemplateObject"](["\n                  margin-bottom: 10px;\n                "], ["\n                  margin-bottom: 10px;\n                "]))), key: t.id + "-" + i, options: availableTransformers, placeholder: "Select transformation", onChange: function (v) {
                            _this.onTransformationChange(i, {
                                id: v.value,
                                options: {},
                            });
                        } }));
                }
                var transformationUI = _transformers__WEBPACK_IMPORTED_MODULE_3__["transformersUIRegistry"].getIfExists(t.id);
                input = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_1__["transformDataFrame"])(transformations.slice(0, i), preTransformData);
                if (transformationUI) {
                    editor = react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(transformationUI.component, {
                        options: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, transformationUI.transformer.defaultOptions, t.options),
                        input: input,
                        onChange: function (options) {
                            _this.onTransformationChange(i, {
                                id: t.id,
                                options: options,
                            });
                        },
                    });
                }
                return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(_TransformationRow__WEBPACK_IMPORTED_MODULE_5__["TransformationRow"], { key: t.id + "-" + i, input: input || [], onRemove: function () { return _this.onTransformationRemove(i); }, editor: editor, name: transformationUI ? transformationUI.name : '', description: transformationUI ? transformationUI.description : '' }));
            })));
        };
        return _this;
    }
    TransformationsEditor.prototype.render = function () {
        return (react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_4___default.a.Fragment, null,
            this.renderTransformationEditors(),
            react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement(_Button_Button__WEBPACK_IMPORTED_MODULE_6__["Button"], { variant: "inverse", icon: "fa fa-plus", onClick: this.onTransformationAdd }, "Add transformation")));
    };
    return TransformationsEditor;
}(react__WEBPACK_IMPORTED_MODULE_4___default.a.PureComponent));

var templateObject_1;


/***/ }),

/***/ "./packages/grafana-ui/src/components/TransformersUI/transformers.ts":
/*!***************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/TransformersUI/transformers.ts ***!
  \***************************************************************************/
/*! exports provided: transformersUIRegistry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "transformersUIRegistry", function() { return transformersUIRegistry; });
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _ReduceTransformerEditor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ReduceTransformerEditor */ "./packages/grafana-ui/src/components/TransformersUI/ReduceTransformerEditor.tsx");
/* harmony import */ var _FilterByNameTransformerEditor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FilterByNameTransformerEditor */ "./packages/grafana-ui/src/components/TransformersUI/FilterByNameTransformerEditor.tsx");



var transformersUIRegistry = new _grafana_data__WEBPACK_IMPORTED_MODULE_0__["Registry"](function () {
    return [_ReduceTransformerEditor__WEBPACK_IMPORTED_MODULE_1__["reduceTransformRegistryItem"], _FilterByNameTransformerEditor__WEBPACK_IMPORTED_MODULE_2__["filterFieldsByNameTransformRegistryItem"]];
});


/***/ }),

/***/ "./packages/grafana-ui/src/components/UnitPicker/UnitPicker.tsx":
/*!**********************************************************************!*\
  !*** ./packages/grafana-ui/src/components/UnitPicker/UnitPicker.tsx ***!
  \**********************************************************************/
/*! exports provided: UnitPicker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UnitPicker", function() { return UnitPicker; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "./packages/grafana-ui/src/utils/index.ts");




var UnitPicker = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](UnitPicker, _super);
    function UnitPicker() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnitPicker.prototype.render = function () {
        var _a = this.props, defaultValue = _a.defaultValue, onChange = _a.onChange, width = _a.width;
        var unitGroups = Object(_utils__WEBPACK_IMPORTED_MODULE_3__["getValueFormats"])();
        // Need to transform the data structure to work well with Select
        var groupOptions = unitGroups.map(function (group) {
            var options = group.submenu.map(function (unit) {
                return {
                    label: unit.text,
                    value: unit.value,
                };
            });
            return {
                label: group.text,
                options: options,
            };
        });
        var value = groupOptions.map(function (group) {
            return group.options.find(function (option) { return option.value === defaultValue; });
        });
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["Select"], { width: width, defaultValue: value, isSearchable: true, options: groupOptions, placeholder: "Choose", onChange: onChange }));
    };
    UnitPicker.defaultProps = {
        width: 12,
    };
    return UnitPicker;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/ValueMappingsEditor/MappingRow.tsx":
/*!*******************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ValueMappingsEditor/MappingRow.tsx ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");




var mappingOptions = [
    { value: _grafana_data__WEBPACK_IMPORTED_MODULE_3__["MappingType"].ValueToText, label: 'Value' },
    { value: _grafana_data__WEBPACK_IMPORTED_MODULE_3__["MappingType"].RangeToText, label: 'Range' },
];
var MappingRow = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](MappingRow, _super);
    function MappingRow(props) {
        var _this = _super.call(this, props) || this;
        _this.onMappingValueChange = function (event) {
            _this.setState({ value: event.target.value });
        };
        _this.onMappingFromChange = function (event) {
            _this.setState({ from: event.target.value });
        };
        _this.onMappingToChange = function (event) {
            _this.setState({ to: event.target.value });
        };
        _this.onMappingTextChange = function (event) {
            _this.setState({ text: event.target.value });
        };
        _this.onMappingTypeChange = function (mappingType) {
            _this.setState({ type: mappingType });
        };
        _this.updateMapping = function () {
            _this.props.updateValueMapping(tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _this.state));
        };
        _this.state = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props.valueMapping);
        return _this;
    }
    MappingRow.prototype.renderRow = function () {
        var _a = this.state, from = _a.from, text = _a.text, to = _a.to, type = _a.type, value = _a.value;
        if (type === _grafana_data__WEBPACK_IMPORTED_MODULE_3__["MappingType"].RangeToText) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "From", labelWidth: 4, inputWidth: 8, onBlur: this.updateMapping, onChange: this.onMappingFromChange, value: from }),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "To", labelWidth: 4, inputWidth: 8, onBlur: this.updateMapping, onChange: this.onMappingToChange, value: to }),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form gf-form--grow" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["FormLabel"], { width: 4 }, "Text"),
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["Input"], { className: "gf-form-input", onBlur: this.updateMapping, value: text, onChange: this.onMappingTextChange }))));
        }
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["FormField"], { label: "Value", labelWidth: 4, onBlur: this.updateMapping, onChange: this.onMappingValueChange, value: value, inputWidth: 8 }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form gf-form--grow" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["FormLabel"], { width: 4 }, "Text"),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["Input"], { className: "gf-form-input", onBlur: this.updateMapping, value: text, onChange: this.onMappingTextChange }))));
    };
    MappingRow.prototype.render = function () {
        var _this = this;
        var type = this.state.type;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form-inline" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["FormLabel"], { width: 5 }, "Type"),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(___WEBPACK_IMPORTED_MODULE_2__["Select"], { placeholder: "Choose type", isSearchable: false, options: mappingOptions, value: mappingOptions.find(function (o) { return o.value === type; }), 
                    // @ts-ignore
                    onChange: function (type) { return _this.onMappingTypeChange(type.value); }, width: 7 })),
            this.renderRow(),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "gf-form" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button", { onClick: this.props.removeValueMapping, className: "gf-form-label gf-form-label--btn" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("i", { className: "fa fa-times" })))));
    };
    return MappingRow;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));
/* harmony default export */ __webpack_exports__["default"] = (MappingRow);


/***/ }),

/***/ "./packages/grafana-ui/src/components/ValueMappingsEditor/ValueMappingsEditor.tsx":
/*!****************************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/ValueMappingsEditor/ValueMappingsEditor.tsx ***!
  \****************************************************************************************/
/*! exports provided: ValueMappingsEditor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ValueMappingsEditor", function() { return ValueMappingsEditor; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MappingRow__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MappingRow */ "./packages/grafana-ui/src/components/ValueMappingsEditor/MappingRow.tsx");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../index */ "./packages/grafana-ui/src/components/index.ts");
/* harmony import */ var _PanelOptionsGroup_PanelOptionsGroup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../PanelOptionsGroup/PanelOptionsGroup */ "./packages/grafana-ui/src/components/PanelOptionsGroup/PanelOptionsGroup.tsx");






var ValueMappingsEditor = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](ValueMappingsEditor, _super);
    function ValueMappingsEditor(props) {
        var _this = _super.call(this, props) || this;
        _this.onAddMapping = function () {
            return _this.setState(function (prevState) { return ({
                valueMappings: tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](prevState.valueMappings, [
                    {
                        id: prevState.nextIdToAdd,
                        operator: '',
                        value: '',
                        text: '',
                        type: _grafana_data__WEBPACK_IMPORTED_MODULE_3__["MappingType"].ValueToText,
                        from: '',
                        to: '',
                    },
                ]),
                nextIdToAdd: prevState.nextIdToAdd + 1,
            }); });
        };
        _this.onRemoveMapping = function (id) {
            _this.setState(function (prevState) { return ({
                valueMappings: prevState.valueMappings.filter(function (m) {
                    return m.id !== id;
                }),
            }); }, function () {
                _this.props.onChange(_this.state.valueMappings);
            });
        };
        _this.updateGauge = function (mapping) {
            _this.setState(function (prevState) { return ({
                valueMappings: prevState.valueMappings.map(function (m) {
                    if (m.id === mapping.id) {
                        return tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, mapping);
                    }
                    return m;
                }),
            }); }, function () {
                _this.props.onChange(_this.state.valueMappings);
            });
        };
        var mappings = props.valueMappings || [];
        _this.state = {
            valueMappings: mappings,
            nextIdToAdd: mappings.length > 0 ? _this.getMaxIdFromValueMappings(mappings) : 1,
        };
        return _this;
    }
    ValueMappingsEditor.prototype.getMaxIdFromValueMappings = function (mappings) {
        return Math.max.apply(null, mappings.map(function (mapping) { return mapping.id; }).map(function (m) { return m; })) + 1;
    };
    ValueMappingsEditor.prototype.render = function () {
        var _this = this;
        var valueMappings = this.state.valueMappings;
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_PanelOptionsGroup_PanelOptionsGroup__WEBPACK_IMPORTED_MODULE_5__["PanelOptionsGroup"], { title: "Value mappings" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null,
                valueMappings.length > 0 &&
                    valueMappings.map(function (valueMapping, index) { return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_MappingRow__WEBPACK_IMPORTED_MODULE_2__["default"], { key: valueMapping.text + "-" + index, valueMapping: valueMapping, updateValueMapping: _this.updateGauge, removeValueMapping: function () { return _this.onRemoveMapping(valueMapping.id); } })); }),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_index__WEBPACK_IMPORTED_MODULE_4__["Button"], { variant: "inverse", icon: "fa fa-plus", onClick: this.onAddMapping }, "Add mapping"))));
    };
    return ValueMappingsEditor;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/VizRepeater/VizRepeater.tsx":
/*!************************************************************************!*\
  !*** ./packages/grafana-ui/src/components/VizRepeater/VizRepeater.tsx ***!
  \************************************************************************/
/*! exports provided: VizRepeater */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VizRepeater", function() { return VizRepeater; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../types */ "./packages/grafana-ui/src/types/index.ts");



var VizRepeater = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](VizRepeater, _super);
    function VizRepeater(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            values: props.getValues(),
        };
        return _this;
    }
    VizRepeater.prototype.componentDidUpdate = function (prevProps) {
        var _a = this.props, renderCounter = _a.renderCounter, source = _a.source;
        if (renderCounter !== prevProps.renderCounter || source !== prevProps.source) {
            this.setState({ values: this.props.getValues() });
        }
    };
    VizRepeater.prototype.getOrientation = function () {
        var _a = this.props, orientation = _a.orientation, width = _a.width, height = _a.height;
        if (orientation === _types__WEBPACK_IMPORTED_MODULE_2__["VizOrientation"].Auto) {
            if (width > height) {
                return _types__WEBPACK_IMPORTED_MODULE_2__["VizOrientation"].Vertical;
            }
            else {
                return _types__WEBPACK_IMPORTED_MODULE_2__["VizOrientation"].Horizontal;
            }
        }
        return orientation;
    };
    VizRepeater.prototype.render = function () {
        var _a = this.props, renderValue = _a.renderValue, height = _a.height, width = _a.width, itemSpacing = _a.itemSpacing;
        var values = this.state.values;
        var orientation = this.getOrientation();
        var itemStyles = {
            display: 'flex',
        };
        var repeaterStyle = {
            display: 'flex',
        };
        var vizHeight = height;
        var vizWidth = width;
        if (orientation === _types__WEBPACK_IMPORTED_MODULE_2__["VizOrientation"].Horizontal) {
            repeaterStyle.flexDirection = 'column';
            itemStyles.marginBottom = itemSpacing + "px";
            vizWidth = width;
            vizHeight = height / values.length - itemSpacing;
        }
        else {
            repeaterStyle.flexDirection = 'row';
            itemStyles.marginRight = itemSpacing + "px";
            vizHeight = height;
            vizWidth = width / values.length - itemSpacing;
        }
        itemStyles.width = vizWidth + "px";
        itemStyles.height = vizHeight + "px";
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { style: repeaterStyle }, values.map(function (value, index) {
            return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { key: index, style: itemStyles }, renderValue(value, vizWidth, vizHeight)));
        })));
    };
    VizRepeater.defaultProps = {
        itemSpacing: 10,
    };
    return VizRepeater;
}(react__WEBPACK_IMPORTED_MODULE_1__["PureComponent"]));



/***/ }),

/***/ "./packages/grafana-ui/src/components/index.ts":
/*!*****************************************************!*\
  !*** ./packages/grafana-ui/src/components/index.ts ***!
  \*****************************************************/
/*! exports provided: DeleteButton, Tooltip, PopoverContent, PopoverController, Popover, Portal, CustomScrollbar, Button, LinkButton, ButtonVariant, Select, AsyncSelect, IndicatorsContainer, NoOptionsMessage, resetSelectStyles, ButtonSelect, FormLabel, FormField, SecretFormField, LoadingPlaceholder, ColorPicker, SeriesColorPicker, SeriesColorPickerPopover, SeriesColorPickerPopoverWithTheme, PanelOptionsGroup, PanelOptionsGrid, ValueMappingsEditor, Switch, EmptySearchResult, PieChart, PieChartType, UnitPicker, StatsPicker, Input, InputStatus, RefreshPicker, TimePicker, TimeOfDayPicker, List, SetInterval, Table, TableInputCSV, BigValue, Gauge, Graph, GraphLegend, GraphWithLegend, BarGauge, VizRepeater, LegendOptions, LegendBasicOptions, LegendRenderOptions, LegendList, LegendTable, LegendItem, LegendPlacement, LegendDisplayMode, Alert, GraphSeriesToggler, GraphSeriesTogglerAPI, Collapse, LogLabels, LogRows, getLogRowStyles, ToggleButtonGroup, ToggleButton, ThresholdsEditor, ClickOutsideWrapper, FieldDisplayEditor, FieldPropertiesEditor, SingleStatBaseOptions, sharedSingleStatPanelChangedHandler, sharedSingleStatMigrationHandler, convertOldAngulrValueMapping, CallToActionCard, ContextMenu, ContextMenuItem, ContextMenuGroup, ContextMenuProps, VariableSuggestion, VariableOrigin, DataLinksEditor, DataLinksContextMenu, SeriesIcon, transformersUIRegistry, TransformationRow, TransformationsEditor, JSONFormatter, JsonExplorer, ErrorBoundary, ErrorBoundaryAlert, AlphaNotice */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _DeleteButton_DeleteButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DeleteButton/DeleteButton */ "./packages/grafana-ui/src/components/DeleteButton/DeleteButton.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DeleteButton", function() { return _DeleteButton_DeleteButton__WEBPACK_IMPORTED_MODULE_0__["DeleteButton"]; });

/* harmony import */ var _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Tooltip/Tooltip */ "./packages/grafana-ui/src/components/Tooltip/Tooltip.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Tooltip", function() { return _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_1__["Tooltip"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopoverContent", function() { return _Tooltip_Tooltip__WEBPACK_IMPORTED_MODULE_1__["PopoverContent"]; });

/* harmony import */ var _Tooltip_PopoverController__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Tooltip/PopoverController */ "./packages/grafana-ui/src/components/Tooltip/PopoverController.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopoverController", function() { return _Tooltip_PopoverController__WEBPACK_IMPORTED_MODULE_2__["PopoverController"]; });

/* harmony import */ var _Tooltip_Popover__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Tooltip/Popover */ "./packages/grafana-ui/src/components/Tooltip/Popover.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Popover", function() { return _Tooltip_Popover__WEBPACK_IMPORTED_MODULE_3__["Popover"]; });

/* harmony import */ var _Portal_Portal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Portal/Portal */ "./packages/grafana-ui/src/components/Portal/Portal.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Portal", function() { return _Portal_Portal__WEBPACK_IMPORTED_MODULE_4__["Portal"]; });

/* harmony import */ var _CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CustomScrollbar/CustomScrollbar */ "./packages/grafana-ui/src/components/CustomScrollbar/CustomScrollbar.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomScrollbar", function() { return _CustomScrollbar_CustomScrollbar__WEBPACK_IMPORTED_MODULE_5__["CustomScrollbar"]; });

/* harmony import */ var _Button_Button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Button/Button */ "./packages/grafana-ui/src/components/Button/Button.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Button", function() { return _Button_Button__WEBPACK_IMPORTED_MODULE_6__["Button"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LinkButton", function() { return _Button_Button__WEBPACK_IMPORTED_MODULE_6__["LinkButton"]; });

/* harmony import */ var _Button_AbstractButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Button/AbstractButton */ "./packages/grafana-ui/src/components/Button/AbstractButton.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonVariant", function() { return _Button_AbstractButton__WEBPACK_IMPORTED_MODULE_7__["ButtonVariant"]; });

/* harmony import */ var _Select_Select__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Select/Select */ "./packages/grafana-ui/src/components/Select/Select.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Select", function() { return _Select_Select__WEBPACK_IMPORTED_MODULE_8__["Select"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AsyncSelect", function() { return _Select_Select__WEBPACK_IMPORTED_MODULE_8__["AsyncSelect"]; });

/* harmony import */ var _Select_IndicatorsContainer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Select/IndicatorsContainer */ "./packages/grafana-ui/src/components/Select/IndicatorsContainer.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IndicatorsContainer", function() { return _Select_IndicatorsContainer__WEBPACK_IMPORTED_MODULE_9__["IndicatorsContainer"]; });

/* harmony import */ var _Select_NoOptionsMessage__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Select/NoOptionsMessage */ "./packages/grafana-ui/src/components/Select/NoOptionsMessage.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NoOptionsMessage", function() { return _Select_NoOptionsMessage__WEBPACK_IMPORTED_MODULE_10__["NoOptionsMessage"]; });

/* harmony import */ var _Select_resetSelectStyles__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Select/resetSelectStyles */ "./packages/grafana-ui/src/components/Select/resetSelectStyles.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "resetSelectStyles", function() { return _Select_resetSelectStyles__WEBPACK_IMPORTED_MODULE_11__["default"]; });

/* harmony import */ var _Select_ButtonSelect__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Select/ButtonSelect */ "./packages/grafana-ui/src/components/Select/ButtonSelect.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonSelect", function() { return _Select_ButtonSelect__WEBPACK_IMPORTED_MODULE_12__["ButtonSelect"]; });

/* harmony import */ var _FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./FormLabel/FormLabel */ "./packages/grafana-ui/src/components/FormLabel/FormLabel.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FormLabel", function() { return _FormLabel_FormLabel__WEBPACK_IMPORTED_MODULE_13__["FormLabel"]; });

/* harmony import */ var _FormField_FormField__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./FormField/FormField */ "./packages/grafana-ui/src/components/FormField/FormField.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FormField", function() { return _FormField_FormField__WEBPACK_IMPORTED_MODULE_14__["FormField"]; });

/* harmony import */ var _SecretFormFied_SecretFormField__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./SecretFormFied/SecretFormField */ "./packages/grafana-ui/src/components/SecretFormFied/SecretFormField.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SecretFormField", function() { return _SecretFormFied_SecretFormField__WEBPACK_IMPORTED_MODULE_15__["SecretFormField"]; });

/* harmony import */ var _LoadingPlaceholder_LoadingPlaceholder__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./LoadingPlaceholder/LoadingPlaceholder */ "./packages/grafana-ui/src/components/LoadingPlaceholder/LoadingPlaceholder.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LoadingPlaceholder", function() { return _LoadingPlaceholder_LoadingPlaceholder__WEBPACK_IMPORTED_MODULE_16__["LoadingPlaceholder"]; });

/* harmony import */ var _ColorPicker_ColorPicker__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./ColorPicker/ColorPicker */ "./packages/grafana-ui/src/components/ColorPicker/ColorPicker.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ColorPicker", function() { return _ColorPicker_ColorPicker__WEBPACK_IMPORTED_MODULE_17__["ColorPicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPicker", function() { return _ColorPicker_ColorPicker__WEBPACK_IMPORTED_MODULE_17__["SeriesColorPicker"]; });

/* harmony import */ var _ColorPicker_SeriesColorPickerPopover__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./ColorPicker/SeriesColorPickerPopover */ "./packages/grafana-ui/src/components/ColorPicker/SeriesColorPickerPopover.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPickerPopover", function() { return _ColorPicker_SeriesColorPickerPopover__WEBPACK_IMPORTED_MODULE_18__["SeriesColorPickerPopover"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPickerPopoverWithTheme", function() { return _ColorPicker_SeriesColorPickerPopover__WEBPACK_IMPORTED_MODULE_18__["SeriesColorPickerPopoverWithTheme"]; });

/* harmony import */ var _PanelOptionsGroup_PanelOptionsGroup__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./PanelOptionsGroup/PanelOptionsGroup */ "./packages/grafana-ui/src/components/PanelOptionsGroup/PanelOptionsGroup.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelOptionsGroup", function() { return _PanelOptionsGroup_PanelOptionsGroup__WEBPACK_IMPORTED_MODULE_19__["PanelOptionsGroup"]; });

/* harmony import */ var _PanelOptionsGrid_PanelOptionsGrid__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./PanelOptionsGrid/PanelOptionsGrid */ "./packages/grafana-ui/src/components/PanelOptionsGrid/PanelOptionsGrid.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelOptionsGrid", function() { return _PanelOptionsGrid_PanelOptionsGrid__WEBPACK_IMPORTED_MODULE_20__["PanelOptionsGrid"]; });

/* harmony import */ var _ValueMappingsEditor_ValueMappingsEditor__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./ValueMappingsEditor/ValueMappingsEditor */ "./packages/grafana-ui/src/components/ValueMappingsEditor/ValueMappingsEditor.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValueMappingsEditor", function() { return _ValueMappingsEditor_ValueMappingsEditor__WEBPACK_IMPORTED_MODULE_21__["ValueMappingsEditor"]; });

/* harmony import */ var _Switch_Switch__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Switch/Switch */ "./packages/grafana-ui/src/components/Switch/Switch.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Switch", function() { return _Switch_Switch__WEBPACK_IMPORTED_MODULE_22__["Switch"]; });

/* harmony import */ var _EmptySearchResult_EmptySearchResult__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./EmptySearchResult/EmptySearchResult */ "./packages/grafana-ui/src/components/EmptySearchResult/EmptySearchResult.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmptySearchResult", function() { return _EmptySearchResult_EmptySearchResult__WEBPACK_IMPORTED_MODULE_23__["EmptySearchResult"]; });

/* harmony import */ var _PieChart_PieChart__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./PieChart/PieChart */ "./packages/grafana-ui/src/components/PieChart/PieChart.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PieChart", function() { return _PieChart_PieChart__WEBPACK_IMPORTED_MODULE_24__["PieChart"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PieChartType", function() { return _PieChart_PieChart__WEBPACK_IMPORTED_MODULE_24__["PieChartType"]; });

/* harmony import */ var _UnitPicker_UnitPicker__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./UnitPicker/UnitPicker */ "./packages/grafana-ui/src/components/UnitPicker/UnitPicker.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UnitPicker", function() { return _UnitPicker_UnitPicker__WEBPACK_IMPORTED_MODULE_25__["UnitPicker"]; });

/* harmony import */ var _StatsPicker_StatsPicker__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./StatsPicker/StatsPicker */ "./packages/grafana-ui/src/components/StatsPicker/StatsPicker.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StatsPicker", function() { return _StatsPicker_StatsPicker__WEBPACK_IMPORTED_MODULE_26__["StatsPicker"]; });

/* harmony import */ var _Input_Input__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./Input/Input */ "./packages/grafana-ui/src/components/Input/Input.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Input", function() { return _Input_Input__WEBPACK_IMPORTED_MODULE_27__["Input"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "InputStatus", function() { return _Input_Input__WEBPACK_IMPORTED_MODULE_27__["InputStatus"]; });

/* harmony import */ var _RefreshPicker_RefreshPicker__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./RefreshPicker/RefreshPicker */ "./packages/grafana-ui/src/components/RefreshPicker/RefreshPicker.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RefreshPicker", function() { return _RefreshPicker_RefreshPicker__WEBPACK_IMPORTED_MODULE_28__["RefreshPicker"]; });

/* harmony import */ var _TimePicker_TimePicker__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./TimePicker/TimePicker */ "./packages/grafana-ui/src/components/TimePicker/TimePicker.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TimePicker", function() { return _TimePicker_TimePicker__WEBPACK_IMPORTED_MODULE_29__["TimePicker"]; });

/* harmony import */ var _TimePicker_TimeOfDayPicker__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./TimePicker/TimeOfDayPicker */ "./packages/grafana-ui/src/components/TimePicker/TimeOfDayPicker.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TimeOfDayPicker", function() { return _TimePicker_TimeOfDayPicker__WEBPACK_IMPORTED_MODULE_30__["TimeOfDayPicker"]; });

/* harmony import */ var _List_List__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./List/List */ "./packages/grafana-ui/src/components/List/List.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "List", function() { return _List_List__WEBPACK_IMPORTED_MODULE_31__["List"]; });

/* harmony import */ var _SetInterval_SetInterval__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./SetInterval/SetInterval */ "./packages/grafana-ui/src/components/SetInterval/SetInterval.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SetInterval", function() { return _SetInterval_SetInterval__WEBPACK_IMPORTED_MODULE_32__["SetInterval"]; });

/* harmony import */ var _Table_Table__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./Table/Table */ "./packages/grafana-ui/src/components/Table/Table.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Table", function() { return _Table_Table__WEBPACK_IMPORTED_MODULE_33__["Table"]; });

/* harmony import */ var _Table_TableInputCSV__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./Table/TableInputCSV */ "./packages/grafana-ui/src/components/Table/TableInputCSV.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TableInputCSV", function() { return _Table_TableInputCSV__WEBPACK_IMPORTED_MODULE_34__["TableInputCSV"]; });

/* harmony import */ var _BigValue_BigValue__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./BigValue/BigValue */ "./packages/grafana-ui/src/components/BigValue/BigValue.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BigValue", function() { return _BigValue_BigValue__WEBPACK_IMPORTED_MODULE_35__["BigValue"]; });

/* harmony import */ var _Gauge_Gauge__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./Gauge/Gauge */ "./packages/grafana-ui/src/components/Gauge/Gauge.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Gauge", function() { return _Gauge_Gauge__WEBPACK_IMPORTED_MODULE_36__["Gauge"]; });

/* harmony import */ var _Graph_Graph__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./Graph/Graph */ "./packages/grafana-ui/src/components/Graph/Graph.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Graph", function() { return _Graph_Graph__WEBPACK_IMPORTED_MODULE_37__["Graph"]; });

/* harmony import */ var _Graph_GraphLegend__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./Graph/GraphLegend */ "./packages/grafana-ui/src/components/Graph/GraphLegend.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphLegend", function() { return _Graph_GraphLegend__WEBPACK_IMPORTED_MODULE_38__["GraphLegend"]; });

/* harmony import */ var _Graph_GraphWithLegend__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./Graph/GraphWithLegend */ "./packages/grafana-ui/src/components/Graph/GraphWithLegend.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphWithLegend", function() { return _Graph_GraphWithLegend__WEBPACK_IMPORTED_MODULE_39__["GraphWithLegend"]; });

/* harmony import */ var _BarGauge_BarGauge__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./BarGauge/BarGauge */ "./packages/grafana-ui/src/components/BarGauge/BarGauge.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BarGauge", function() { return _BarGauge_BarGauge__WEBPACK_IMPORTED_MODULE_40__["BarGauge"]; });

/* harmony import */ var _VizRepeater_VizRepeater__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./VizRepeater/VizRepeater */ "./packages/grafana-ui/src/components/VizRepeater/VizRepeater.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VizRepeater", function() { return _VizRepeater_VizRepeater__WEBPACK_IMPORTED_MODULE_41__["VizRepeater"]; });

/* harmony import */ var _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./Legend/Legend */ "./packages/grafana-ui/src/components/Legend/Legend.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendOptions", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendBasicOptions", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendBasicOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendRenderOptions", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendRenderOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendList", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendList"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendTable", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendTable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendItem", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendPlacement", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendPlacement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendDisplayMode", function() { return _Legend_Legend__WEBPACK_IMPORTED_MODULE_42__["LegendDisplayMode"]; });

/* harmony import */ var _Alert_Alert__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./Alert/Alert */ "./packages/grafana-ui/src/components/Alert/Alert.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Alert", function() { return _Alert_Alert__WEBPACK_IMPORTED_MODULE_43__["Alert"]; });

/* harmony import */ var _Graph_GraphSeriesToggler__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./Graph/GraphSeriesToggler */ "./packages/grafana-ui/src/components/Graph/GraphSeriesToggler.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphSeriesToggler", function() { return _Graph_GraphSeriesToggler__WEBPACK_IMPORTED_MODULE_44__["GraphSeriesToggler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphSeriesTogglerAPI", function() { return _Graph_GraphSeriesToggler__WEBPACK_IMPORTED_MODULE_44__["GraphSeriesTogglerAPI"]; });

/* harmony import */ var _Collapse_Collapse__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./Collapse/Collapse */ "./packages/grafana-ui/src/components/Collapse/Collapse.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Collapse", function() { return _Collapse_Collapse__WEBPACK_IMPORTED_MODULE_45__["Collapse"]; });

/* harmony import */ var _Logs_LogLabels__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./Logs/LogLabels */ "./packages/grafana-ui/src/components/Logs/LogLabels.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogLabels", function() { return _Logs_LogLabels__WEBPACK_IMPORTED_MODULE_46__["LogLabels"]; });

/* harmony import */ var _Logs_LogRows__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./Logs/LogRows */ "./packages/grafana-ui/src/components/Logs/LogRows.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogRows", function() { return _Logs_LogRows__WEBPACK_IMPORTED_MODULE_47__["LogRows"]; });

/* harmony import */ var _Logs_getLogRowStyles__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./Logs/getLogRowStyles */ "./packages/grafana-ui/src/components/Logs/getLogRowStyles.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLogRowStyles", function() { return _Logs_getLogRowStyles__WEBPACK_IMPORTED_MODULE_48__["getLogRowStyles"]; });

/* harmony import */ var _ToggleButtonGroup_ToggleButtonGroup__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./ToggleButtonGroup/ToggleButtonGroup */ "./packages/grafana-ui/src/components/ToggleButtonGroup/ToggleButtonGroup.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ToggleButtonGroup", function() { return _ToggleButtonGroup_ToggleButtonGroup__WEBPACK_IMPORTED_MODULE_49__["ToggleButtonGroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ToggleButton", function() { return _ToggleButtonGroup_ToggleButtonGroup__WEBPACK_IMPORTED_MODULE_49__["ToggleButton"]; });

/* harmony import */ var _ThresholdsEditor_ThresholdsEditor__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./ThresholdsEditor/ThresholdsEditor */ "./packages/grafana-ui/src/components/ThresholdsEditor/ThresholdsEditor.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ThresholdsEditor", function() { return _ThresholdsEditor_ThresholdsEditor__WEBPACK_IMPORTED_MODULE_50__["ThresholdsEditor"]; });

/* harmony import */ var _ClickOutsideWrapper_ClickOutsideWrapper__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./ClickOutsideWrapper/ClickOutsideWrapper */ "./packages/grafana-ui/src/components/ClickOutsideWrapper/ClickOutsideWrapper.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ClickOutsideWrapper", function() { return _ClickOutsideWrapper_ClickOutsideWrapper__WEBPACK_IMPORTED_MODULE_51__["ClickOutsideWrapper"]; });

/* harmony import */ var _SingleStatShared_index__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./SingleStatShared/index */ "./packages/grafana-ui/src/components/SingleStatShared/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldDisplayEditor", function() { return _SingleStatShared_index__WEBPACK_IMPORTED_MODULE_52__["FieldDisplayEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldPropertiesEditor", function() { return _SingleStatShared_index__WEBPACK_IMPORTED_MODULE_52__["FieldPropertiesEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SingleStatBaseOptions", function() { return _SingleStatShared_index__WEBPACK_IMPORTED_MODULE_52__["SingleStatBaseOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatPanelChangedHandler", function() { return _SingleStatShared_index__WEBPACK_IMPORTED_MODULE_52__["sharedSingleStatPanelChangedHandler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatMigrationHandler", function() { return _SingleStatShared_index__WEBPACK_IMPORTED_MODULE_52__["sharedSingleStatMigrationHandler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "convertOldAngulrValueMapping", function() { return _SingleStatShared_index__WEBPACK_IMPORTED_MODULE_52__["convertOldAngulrValueMapping"]; });

/* harmony import */ var _CallToActionCard_CallToActionCard__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./CallToActionCard/CallToActionCard */ "./packages/grafana-ui/src/components/CallToActionCard/CallToActionCard.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CallToActionCard", function() { return _CallToActionCard_CallToActionCard__WEBPACK_IMPORTED_MODULE_53__["CallToActionCard"]; });

/* harmony import */ var _ContextMenu_ContextMenu__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./ContextMenu/ContextMenu */ "./packages/grafana-ui/src/components/ContextMenu/ContextMenu.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenu", function() { return _ContextMenu_ContextMenu__WEBPACK_IMPORTED_MODULE_54__["ContextMenu"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenuItem", function() { return _ContextMenu_ContextMenu__WEBPACK_IMPORTED_MODULE_54__["ContextMenuItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenuGroup", function() { return _ContextMenu_ContextMenu__WEBPACK_IMPORTED_MODULE_54__["ContextMenuGroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenuProps", function() { return _ContextMenu_ContextMenu__WEBPACK_IMPORTED_MODULE_54__["ContextMenuProps"]; });

/* harmony import */ var _DataLinks_DataLinkSuggestions__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./DataLinks/DataLinkSuggestions */ "./packages/grafana-ui/src/components/DataLinks/DataLinkSuggestions.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VariableSuggestion", function() { return _DataLinks_DataLinkSuggestions__WEBPACK_IMPORTED_MODULE_55__["VariableSuggestion"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VariableOrigin", function() { return _DataLinks_DataLinkSuggestions__WEBPACK_IMPORTED_MODULE_55__["VariableOrigin"]; });

/* harmony import */ var _DataLinks_DataLinksEditor__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./DataLinks/DataLinksEditor */ "./packages/grafana-ui/src/components/DataLinks/DataLinksEditor.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataLinksEditor", function() { return _DataLinks_DataLinksEditor__WEBPACK_IMPORTED_MODULE_56__["DataLinksEditor"]; });

/* harmony import */ var _DataLinks_DataLinksContextMenu__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./DataLinks/DataLinksContextMenu */ "./packages/grafana-ui/src/components/DataLinks/DataLinksContextMenu.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataLinksContextMenu", function() { return _DataLinks_DataLinksContextMenu__WEBPACK_IMPORTED_MODULE_57__["DataLinksContextMenu"]; });

/* harmony import */ var _Legend_SeriesIcon__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./Legend/SeriesIcon */ "./packages/grafana-ui/src/components/Legend/SeriesIcon.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesIcon", function() { return _Legend_SeriesIcon__WEBPACK_IMPORTED_MODULE_58__["SeriesIcon"]; });

/* harmony import */ var _TransformersUI_transformers__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./TransformersUI/transformers */ "./packages/grafana-ui/src/components/TransformersUI/transformers.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "transformersUIRegistry", function() { return _TransformersUI_transformers__WEBPACK_IMPORTED_MODULE_59__["transformersUIRegistry"]; });

/* harmony import */ var _TransformersUI_TransformationRow__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./TransformersUI/TransformationRow */ "./packages/grafana-ui/src/components/TransformersUI/TransformationRow.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TransformationRow", function() { return _TransformersUI_TransformationRow__WEBPACK_IMPORTED_MODULE_60__["TransformationRow"]; });

/* harmony import */ var _TransformersUI_TransformationsEditor__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./TransformersUI/TransformationsEditor */ "./packages/grafana-ui/src/components/TransformersUI/TransformationsEditor.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TransformationsEditor", function() { return _TransformersUI_TransformationsEditor__WEBPACK_IMPORTED_MODULE_61__["TransformationsEditor"]; });

/* harmony import */ var _JSONFormatter_JSONFormatter__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./JSONFormatter/JSONFormatter */ "./packages/grafana-ui/src/components/JSONFormatter/JSONFormatter.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JSONFormatter", function() { return _JSONFormatter_JSONFormatter__WEBPACK_IMPORTED_MODULE_62__["JSONFormatter"]; });

/* harmony import */ var _JSONFormatter_json_explorer_json_explorer__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./JSONFormatter/json_explorer/json_explorer */ "./packages/grafana-ui/src/components/JSONFormatter/json_explorer/json_explorer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonExplorer", function() { return _JSONFormatter_json_explorer_json_explorer__WEBPACK_IMPORTED_MODULE_63__["JsonExplorer"]; });

/* harmony import */ var _ErrorBoundary_ErrorBoundary__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./ErrorBoundary/ErrorBoundary */ "./packages/grafana-ui/src/components/ErrorBoundary/ErrorBoundary.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ErrorBoundary", function() { return _ErrorBoundary_ErrorBoundary__WEBPACK_IMPORTED_MODULE_64__["ErrorBoundary"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ErrorBoundaryAlert", function() { return _ErrorBoundary_ErrorBoundary__WEBPACK_IMPORTED_MODULE_64__["ErrorBoundaryAlert"]; });

/* harmony import */ var _AlphaNotice_AlphaNotice__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./AlphaNotice/AlphaNotice */ "./packages/grafana-ui/src/components/AlphaNotice/AlphaNotice.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AlphaNotice", function() { return _AlphaNotice_AlphaNotice__WEBPACK_IMPORTED_MODULE_65__["AlphaNotice"]; });









// Select





// Forms



















// Renderless



// Visualizations















// Panel editors


















/***/ }),

/***/ "./packages/grafana-ui/src/index.ts":
/*!******************************************!*\
  !*** ./packages/grafana-ui/src/index.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components */ "./packages/grafana-ui/src/components/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DeleteButton", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["DeleteButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Tooltip", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Tooltip"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopoverContent", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["PopoverContent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopoverController", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["PopoverController"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Popover", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Popover"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Portal", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Portal"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomScrollbar", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["CustomScrollbar"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Button", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Button"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LinkButton", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LinkButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonVariant", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ButtonVariant"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Select", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Select"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AsyncSelect", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["AsyncSelect"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IndicatorsContainer", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["IndicatorsContainer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NoOptionsMessage", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["NoOptionsMessage"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "resetSelectStyles", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["resetSelectStyles"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonSelect", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ButtonSelect"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FormLabel", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["FormLabel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FormField", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["FormField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SecretFormField", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["SecretFormField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LoadingPlaceholder", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LoadingPlaceholder"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ColorPicker", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ColorPicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPicker", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["SeriesColorPicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPickerPopover", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["SeriesColorPickerPopover"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesColorPickerPopoverWithTheme", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["SeriesColorPickerPopoverWithTheme"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelOptionsGroup", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["PanelOptionsGroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelOptionsGrid", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["PanelOptionsGrid"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValueMappingsEditor", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ValueMappingsEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Switch", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Switch"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmptySearchResult", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["EmptySearchResult"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PieChart", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["PieChart"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PieChartType", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["PieChartType"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UnitPicker", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["UnitPicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StatsPicker", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["StatsPicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Input", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Input"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "InputStatus", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["InputStatus"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RefreshPicker", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["RefreshPicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TimePicker", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["TimePicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TimeOfDayPicker", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["TimeOfDayPicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "List", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["List"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SetInterval", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["SetInterval"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Table", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Table"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TableInputCSV", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["TableInputCSV"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BigValue", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["BigValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Gauge", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Gauge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Graph", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Graph"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphLegend", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["GraphLegend"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphWithLegend", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["GraphWithLegend"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BarGauge", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["BarGauge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VizRepeater", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["VizRepeater"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendOptions", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendBasicOptions", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendBasicOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendRenderOptions", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendRenderOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendList", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendList"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendTable", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendTable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendItem", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendPlacement", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendPlacement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LegendDisplayMode", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LegendDisplayMode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Alert", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Alert"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphSeriesToggler", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["GraphSeriesToggler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GraphSeriesTogglerAPI", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["GraphSeriesTogglerAPI"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Collapse", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["Collapse"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogLabels", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LogLabels"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogRows", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["LogRows"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLogRowStyles", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["getLogRowStyles"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ToggleButtonGroup", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ToggleButtonGroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ToggleButton", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ToggleButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ThresholdsEditor", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ThresholdsEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ClickOutsideWrapper", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ClickOutsideWrapper"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldDisplayEditor", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["FieldDisplayEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FieldPropertiesEditor", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["FieldPropertiesEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SingleStatBaseOptions", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["SingleStatBaseOptions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatPanelChangedHandler", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["sharedSingleStatPanelChangedHandler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sharedSingleStatMigrationHandler", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["sharedSingleStatMigrationHandler"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "convertOldAngulrValueMapping", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["convertOldAngulrValueMapping"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CallToActionCard", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["CallToActionCard"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenu", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ContextMenu"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenuItem", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ContextMenuItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenuGroup", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ContextMenuGroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ContextMenuProps", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ContextMenuProps"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VariableSuggestion", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["VariableSuggestion"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VariableOrigin", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["VariableOrigin"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataLinksEditor", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["DataLinksEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataLinksContextMenu", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["DataLinksContextMenu"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SeriesIcon", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["SeriesIcon"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "transformersUIRegistry", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["transformersUIRegistry"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TransformationRow", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["TransformationRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TransformationsEditor", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["TransformationsEditor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JSONFormatter", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["JSONFormatter"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonExplorer", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["JsonExplorer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ErrorBoundary", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ErrorBoundary"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ErrorBoundaryAlert", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["ErrorBoundaryAlert"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AlphaNotice", function() { return _components__WEBPACK_IMPORTED_MODULE_0__["AlphaNotice"]; });

/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./types */ "./packages/grafana-ui/src/types/index.ts");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _types__WEBPACK_IMPORTED_MODULE_1__) if(["DeleteButton","Tooltip","PopoverContent","PopoverController","Popover","Portal","CustomScrollbar","Button","LinkButton","ButtonVariant","Select","AsyncSelect","IndicatorsContainer","NoOptionsMessage","resetSelectStyles","ButtonSelect","FormLabel","FormField","SecretFormField","LoadingPlaceholder","ColorPicker","SeriesColorPicker","SeriesColorPickerPopover","SeriesColorPickerPopoverWithTheme","PanelOptionsGroup","PanelOptionsGrid","ValueMappingsEditor","Switch","EmptySearchResult","PieChart","PieChartType","UnitPicker","StatsPicker","Input","InputStatus","RefreshPicker","TimePicker","TimeOfDayPicker","List","SetInterval","Table","TableInputCSV","BigValue","Gauge","Graph","GraphLegend","GraphWithLegend","BarGauge","VizRepeater","LegendOptions","LegendBasicOptions","LegendRenderOptions","LegendList","LegendTable","LegendItem","LegendPlacement","LegendDisplayMode","Alert","GraphSeriesToggler","GraphSeriesTogglerAPI","Collapse","LogLabels","LogRows","getLogRowStyles","ToggleButtonGroup","ToggleButton","ThresholdsEditor","ClickOutsideWrapper","FieldDisplayEditor","FieldPropertiesEditor","SingleStatBaseOptions","sharedSingleStatPanelChangedHandler","sharedSingleStatMigrationHandler","convertOldAngulrValueMapping","CallToActionCard","ContextMenu","ContextMenuItem","ContextMenuGroup","ContextMenuProps","VariableSuggestion","VariableOrigin","DataLinksEditor","DataLinksContextMenu","SeriesIcon","transformersUIRegistry","TransformationRow","TransformationsEditor","JSONFormatter","JsonExplorer","ErrorBoundary","ErrorBoundaryAlert","AlphaNotice","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _types__WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./packages/grafana-ui/src/utils/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toFixed", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["toFixed"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toFixedScaled", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["toFixedScaled"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toFixedUnit", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["toFixedUnit"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "scaledUnits", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["scaledUnits"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "locale", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["locale"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "simpleCountUnit", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["simpleCountUnit"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getValueFormat", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getValueFormat"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getValueFormatterIndex", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getValueFormatterIndex"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getValueFormats", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getValueFormats"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PALETTE_ROWS", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["PALETTE_ROWS"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PALETTE_COLUMNS", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["PALETTE_COLUMNS"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DEFAULT_ANNOTATION_COLOR", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["DEFAULT_ANNOTATION_COLOR"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OK_COLOR", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["OK_COLOR"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ALERTING_COLOR", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["ALERTING_COLOR"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NO_DATA_COLOR", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["NO_DATA_COLOR"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PENDING_COLOR", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["PENDING_COLOR"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "REGION_FILL_ALPHA", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["REGION_FILL_ALPHA"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "colors", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["colors"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sortedColors", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["sortedColors"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getColorDefinitionByName", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getColorDefinitionByName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getColorDefinition", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getColorDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getColorName", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getColorName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getColorByName", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getColorByName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getColorFromHexRgbOrName", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getColorFromHexRgbOrName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getColorForTheme", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getColorForTheme"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getNamedColorPalette", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getNamedColorPalette"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDisplayProcessor", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getDisplayProcessor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getColorFromThreshold", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getColorFromThreshold"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDecimalsForValue", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getDecimalsForValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VAR_SERIES_NAME", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["VAR_SERIES_NAME"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VAR_FIELD_NAME", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["VAR_FIELD_NAME"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VAR_CALC", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["VAR_CALC"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VAR_CELL_PREFIX", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["VAR_CELL_PREFIX"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DEFAULT_FIELD_DISPLAY_VALUES_LIMIT", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["DEFAULT_FIELD_DISPLAY_VALUES_LIMIT"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFieldDisplayValues", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getFieldDisplayValues"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "applyFieldProperties", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["applyFieldProperties"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFieldProperties", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getFieldProperties"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EventsWithValidation", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["EventsWithValidation"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "validate", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["validate"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "hasValidationEvent", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["hasValidationEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFlotPairs", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getFlotPairs"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFlotPairsConstant", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["getFlotPairsConstant"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SCHEMA", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["SCHEMA"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "makeFragment", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["makeFragment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "makeValue", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["makeValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataLinkBuiltInVars", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["DataLinkBuiltInVars"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "linkModelToContextMenuItems", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["linkModelToContextMenuItems"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ansicolor", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["ansicolor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DOMUtil", function() { return _utils__WEBPACK_IMPORTED_MODULE_2__["DOMUtil"]; });

/* harmony import */ var _themes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./themes */ "./packages/grafana-ui/src/themes/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stylesFactory", function() { return _themes__WEBPACK_IMPORTED_MODULE_3__["stylesFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ThemeContext", function() { return _themes__WEBPACK_IMPORTED_MODULE_3__["ThemeContext"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "withTheme", function() { return _themes__WEBPACK_IMPORTED_MODULE_3__["withTheme"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "mockTheme", function() { return _themes__WEBPACK_IMPORTED_MODULE_3__["mockTheme"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getTheme", function() { return _themes__WEBPACK_IMPORTED_MODULE_3__["getTheme"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "selectThemeVariant", function() { return _themes__WEBPACK_IMPORTED_MODULE_3__["selectThemeVariant"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "useTheme", function() { return _themes__WEBPACK_IMPORTED_MODULE_3__["useTheme"]; });

/* harmony import */ var _slate_plugins__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./slate-plugins */ "./packages/grafana-ui/src/slate-plugins/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SlatePrism", function() { return _slate_plugins__WEBPACK_IMPORTED_MODULE_4__["SlatePrism"]; });








/***/ }),

/***/ "./packages/grafana-ui/src/slate-plugins/index.ts":
/*!********************************************************!*\
  !*** ./packages/grafana-ui/src/slate-plugins/index.ts ***!
  \********************************************************/
/*! exports provided: SlatePrism */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _slate_prism__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./slate-prism */ "./packages/grafana-ui/src/slate-plugins/slate-prism/index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SlatePrism", function() { return _slate_prism__WEBPACK_IMPORTED_MODULE_0__["SlatePrism"]; });




/***/ }),

/***/ "./packages/grafana-ui/src/slate-plugins/slate-prism/TOKEN_MARK.ts":
/*!*************************************************************************!*\
  !*** ./packages/grafana-ui/src/slate-plugins/slate-prism/TOKEN_MARK.ts ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var TOKEN_MARK = 'prism-token';
/* harmony default export */ __webpack_exports__["default"] = (TOKEN_MARK);


/***/ }),

/***/ "./packages/grafana-ui/src/slate-plugins/slate-prism/index.ts":
/*!********************************************************************!*\
  !*** ./packages/grafana-ui/src/slate-plugins/slate-prism/index.ts ***!
  \********************************************************************/
/*! exports provided: SlatePrism */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SlatePrism", function() { return SlatePrism; });
/* harmony import */ var prismjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prismjs */ "./node_modules/prismjs/prism.js");
/* harmony import */ var prismjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prismjs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var slate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! slate */ "./node_modules/slate/lib/slate.es.js");
/* harmony import */ var _options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./options */ "./packages/grafana-ui/src/slate-plugins/slate-prism/options.tsx");
/* harmony import */ var _TOKEN_MARK__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TOKEN_MARK */ "./packages/grafana-ui/src/slate-plugins/slate-prism/TOKEN_MARK.ts");




/**
 * A Slate plugin to highlight code syntax.
 */
function SlatePrism(optsParam) {
    if (optsParam === void 0) { optsParam = {}; }
    var opts = new _options__WEBPACK_IMPORTED_MODULE_2__["default"](optsParam);
    return {
        decorateNode: function (node, editor, next) {
            if (!opts.onlyIn(node)) {
                return next();
            }
            return decorateNode(opts, slate__WEBPACK_IMPORTED_MODULE_1__["Block"].create(node));
        },
        renderDecoration: function (props, editor, next) {
            return opts.renderDecoration({
                children: props.children,
                decoration: props.decoration,
            }, editor, next);
        },
    };
}
/**
 * Returns the decoration for a node
 */
function decorateNode(opts, block) {
    var grammarName = opts.getSyntax(block);
    var grammar = prismjs__WEBPACK_IMPORTED_MODULE_0___default.a.languages[grammarName];
    if (!grammar) {
        // Grammar not loaded
        return [];
    }
    // Tokenize the whole block text
    var texts = block.getTexts();
    var blockText = texts.map(function (text) { return text && text.getText(); }).join('\n');
    var tokens = prismjs__WEBPACK_IMPORTED_MODULE_0___default.a.tokenize(blockText, grammar);
    // The list of decorations to return
    var decorations = [];
    var textStart = 0;
    var textEnd = 0;
    texts.forEach(function (text) {
        textEnd = textStart + text.getText().length;
        var offset = 0;
        function processToken(token, accu) {
            if (typeof token === 'string') {
                if (accu) {
                    var decoration = createDecoration({
                        text: text,
                        textStart: textStart,
                        textEnd: textEnd,
                        start: offset,
                        end: offset + token.length,
                        className: "prism-token token " + accu,
                        block: block,
                    });
                    if (decoration) {
                        decorations.push(decoration);
                    }
                }
                offset += token.length;
            }
            else {
                accu = accu + " " + token.type + " " + (token.alias || '');
                if (typeof token.content === 'string') {
                    var decoration = createDecoration({
                        text: text,
                        textStart: textStart,
                        textEnd: textEnd,
                        start: offset,
                        end: offset + token.content.length,
                        className: "prism-token token " + accu,
                        block: block,
                    });
                    if (decoration) {
                        decorations.push(decoration);
                    }
                    offset += token.content.length;
                }
                else {
                    // When using token.content instead of token.matchedStr, token can be deep
                    for (var i = 0; i < token.content.length; i += 1) {
                        // @ts-ignore
                        processToken(token.content[i], accu);
                    }
                }
            }
        }
        tokens.forEach(processToken);
        textStart = textEnd + 1; // account for added `\n`
    });
    return decorations;
}
/**
 * Return a decoration range for the given text.
 */
function createDecoration(_a) {
    var text = _a.text, textStart = _a.textStart, textEnd = _a.textEnd, start = _a.start, end = _a.end, className = _a.className, block = _a.block;
    if (start >= textEnd || end <= textStart) {
        // Ignore, the token is not in the text
        return null;
    }
    // Shrink to this text boundaries
    start = Math.max(start, textStart);
    end = Math.min(end, textEnd);
    // Now shift offsets to be relative to this text
    start -= textStart;
    end -= textStart;
    var myDec = block.createDecoration({
        object: 'decoration',
        anchor: {
            key: text.key,
            offset: start,
            object: 'point',
        },
        focus: {
            key: text.key,
            offset: end,
            object: 'point',
        },
        type: _TOKEN_MARK__WEBPACK_IMPORTED_MODULE_3__["default"],
        data: { className: className },
    });
    return myDec;
}


/***/ }),

/***/ "./packages/grafana-ui/src/slate-plugins/slate-prism/options.tsx":
/*!***********************************************************************!*\
  !*** ./packages/grafana-ui/src/slate-plugins/slate-prism/options.tsx ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var immutable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! immutable */ "./node_modules/immutable/dist/immutable.js");
/* harmony import */ var immutable__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(immutable__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _TOKEN_MARK__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TOKEN_MARK */ "./packages/grafana-ui/src/slate-plugins/slate-prism/TOKEN_MARK.ts");




/**
 * Default filter for code blocks
 */
function defaultOnlyIn(node) {
    return node.object === 'block' && node.type === 'code_block';
}
/**
 * Default getter for syntax
 */
function defaultGetSyntax(node) {
    return 'javascript';
}
/**
 * Default rendering for decorations
 */
function defaultRenderDecoration(props, editor, next) {
    var decoration = props.decoration;
    if (decoration.type !== _TOKEN_MARK__WEBPACK_IMPORTED_MODULE_3__["default"]) {
        return next();
    }
    var className = decoration.data.get('className');
    return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: className }, props.children);
}
/**
 * The plugin options
 */
var Options = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](Options, _super);
    function Options(props) {
        return _super.call(this, props) || this;
    }
    return Options;
}(Object(immutable__WEBPACK_IMPORTED_MODULE_2__["Record"])({
    onlyIn: defaultOnlyIn,
    getSyntax: defaultGetSyntax,
    renderDecoration: defaultRenderDecoration,
})));
/* harmony default export */ __webpack_exports__["default"] = (Options);


/***/ }),

/***/ "./packages/grafana-ui/src/themes/ThemeContext.tsx":
/*!*********************************************************!*\
  !*** ./packages/grafana-ui/src/themes/ThemeContext.tsx ***!
  \*********************************************************/
/*! exports provided: ThemeContext, withTheme, useTheme */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ThemeContext", function() { return ThemeContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "withTheme", function() { return withTheme; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "useTheme", function() { return useTheme; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! hoist-non-react-statics */ "./node_modules/hoist-non-react-statics/dist/hoist-non-react-statics.cjs.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _getTheme__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getTheme */ "./packages/grafana-ui/src/themes/getTheme.ts");
/* harmony import */ var _types_theme__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../types/theme */ "./packages/grafana-ui/src/types/theme.ts");





// Use Grafana Dark theme by default
var ThemeContext = react__WEBPACK_IMPORTED_MODULE_1___default.a.createContext(Object(_getTheme__WEBPACK_IMPORTED_MODULE_3__["getTheme"])(_types_theme__WEBPACK_IMPORTED_MODULE_4__["GrafanaThemeType"].Dark));
var withTheme = function (Component) {
    var WithTheme = function (props) {
        // @ts-ignore
        return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ThemeContext.Consumer, null, function (theme) { return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Component, tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, props, { theme: theme })); });
    };
    WithTheme.displayName = "WithTheme(" + Component.displayName + ")";
    hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_2___default()(WithTheme, Component);
    return WithTheme;
};
function useTheme() {
    return Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(ThemeContext);
}


/***/ }),

/***/ "./packages/grafana-ui/src/themes/dark.ts":
/*!************************************************!*\
  !*** ./packages/grafana-ui/src/themes/dark.ts ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _default__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./default */ "./packages/grafana-ui/src/themes/default.ts");
/* harmony import */ var _types_theme__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../types/theme */ "./packages/grafana-ui/src/types/theme.ts");



var basicColors = {
    black: '#000000',
    white: '#ffffff',
    dark1: '#141414',
    dark2: '#161719',
    dark3: '#1f1f20',
    dark4: '#212124',
    dark5: '#222426',
    dark6: '#262628',
    dark7: '#292a2d',
    dark8: '#2f2f32',
    dark9: '#343436',
    dark10: '#424345',
    gray1: '#555555',
    gray2: '#8e8e8e',
    gray3: '#b3b3b3',
    gray4: '#d8d9da',
    gray5: '#ececec',
    gray6: '#f4f5f8',
    gray7: '#fbfbfb',
    grayBlue: '#212327',
    blueBase: '#3274d9',
    blueShade: '#1f60c4',
    blueLight: '#5794f2',
    blueFaint: '#041126',
    redBase: '#e02f44',
    redShade: '#c4162a',
    greenBase: '#299c46',
    greenShade: '#23843b',
    blue: '#33b5e5',
    red: '#d44a3a',
    yellow: '#ecbb13',
    purple: '#9933cc',
    variable: '#32d1df',
    orange: '#eb7b18',
};
var darkTheme = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _default__WEBPACK_IMPORTED_MODULE_1__["default"], { type: _types_theme__WEBPACK_IMPORTED_MODULE_2__["GrafanaThemeType"].Dark, name: 'Grafana Dark', colors: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, basicColors, { inputBlack: '#09090b', brandPrimary: basicColors.orange, brandSuccess: basicColors.greenBase, brandWarning: basicColors.orange, brandDanger: basicColors.redBase, queryRed: basicColors.redBase, queryGreen: '#74e680', queryPurple: '#fe85fc', queryKeyword: '#66d9ef', queryOrange: basicColors.orange, online: basicColors.greenBase, warn: '#f79520', critical: basicColors.redBase, bodyBg: basicColors.dark2, pageBg: basicColors.dark2, body: basicColors.gray4, text: basicColors.gray4, textStrong: basicColors.white, textWeak: basicColors.gray2, textEmphasis: basicColors.gray5, textFaint: basicColors.dark5, link: basicColors.gray4, linkDisabled: basicColors.gray2, linkHover: basicColors.white, linkExternal: basicColors.blue, headingColor: basicColors.gray4 }), background: {
        dropdown: basicColors.dark3,
        scrollbar: basicColors.dark9,
        scrollbar2: basicColors.dark9,
    } });
/* harmony default export */ __webpack_exports__["default"] = (darkTheme);


/***/ }),

/***/ "./packages/grafana-ui/src/themes/default.ts":
/*!***************************************************!*\
  !*** ./packages/grafana-ui/src/themes/default.ts ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var theme = {
    name: 'Grafana Default',
    typography: {
        fontFamily: {
            sansSerif: "'Roboto', 'Helvetica Neue', Arial, sans-serif",
            monospace: "Menlo, Monaco, Consolas, 'Courier New', monospace",
        },
        size: {
            root: '14px',
            base: '13px',
            xs: '10px',
            sm: '12px',
            md: '14px',
            lg: '18px',
        },
        heading: {
            h1: '28px',
            h2: '24px',
            h3: '21px',
            h4: '18px',
            h5: '16px',
            h6: '14px',
        },
        weight: {
            light: 300,
            regular: 400,
            semibold: 500,
        },
        lineHeight: {
            xs: 1,
            sm: 1.1,
            md: 4 / 3,
            lg: 1.5,
        },
        link: {
            decoration: 'none',
            hoverDecoration: 'none',
        },
    },
    breakpoints: {
        xs: '0',
        sm: '544px',
        md: '769px',
        lg: '992px',
        xl: '1200px',
    },
    spacing: {
        insetSquishMd: '4px 8px',
        d: '14px',
        xxs: '2px',
        xs: '4px',
        sm: '8px',
        md: '16px',
        lg: '24px',
        xl: '32px',
        gutter: '30px',
    },
    border: {
        radius: {
            sm: '2px',
            md: '3px',
            lg: '5px',
        },
        width: {
            sm: '1px',
        },
    },
    height: {
        sm: '24px',
        md: '32px',
        lg: '48px',
    },
    panelPadding: 8,
    panelHeaderHeight: 28,
    zIndex: {
        dropdown: '1000',
        navbarFixed: '1020',
        sidemenu: '1025',
        tooltip: '1030',
        modalBackdrop: '1040',
        modal: '1050',
        typeahead: '1060',
    },
};
/* harmony default export */ __webpack_exports__["default"] = (theme);


/***/ }),

/***/ "./packages/grafana-ui/src/themes/getTheme.ts":
/*!****************************************************!*\
  !*** ./packages/grafana-ui/src/themes/getTheme.ts ***!
  \****************************************************/
/*! exports provided: getTheme, mockTheme */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTheme", function() { return getTheme; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mockTheme", function() { return mockTheme; });
/* harmony import */ var _dark__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dark */ "./packages/grafana-ui/src/themes/dark.ts");
/* harmony import */ var _light__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./light */ "./packages/grafana-ui/src/themes/light.ts");


var themeMock;
var getTheme = function (name) {
    return (themeMock && themeMock(name)) || (name === 'light' ? _light__WEBPACK_IMPORTED_MODULE_1__["default"] : _dark__WEBPACK_IMPORTED_MODULE_0__["default"]);
};
var mockTheme = function (mock) {
    themeMock = mock;
    return function () {
        themeMock = null;
    };
};


/***/ }),

/***/ "./packages/grafana-ui/src/themes/index.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-ui/src/themes/index.ts ***!
  \*************************************************/
/*! exports provided: stylesFactory, ThemeContext, withTheme, mockTheme, getTheme, selectThemeVariant, useTheme */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ThemeContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ThemeContext */ "./packages/grafana-ui/src/themes/ThemeContext.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ThemeContext", function() { return _ThemeContext__WEBPACK_IMPORTED_MODULE_0__["ThemeContext"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "withTheme", function() { return _ThemeContext__WEBPACK_IMPORTED_MODULE_0__["withTheme"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "useTheme", function() { return _ThemeContext__WEBPACK_IMPORTED_MODULE_0__["useTheme"]; });

/* harmony import */ var _getTheme__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getTheme */ "./packages/grafana-ui/src/themes/getTheme.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "mockTheme", function() { return _getTheme__WEBPACK_IMPORTED_MODULE_1__["mockTheme"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getTheme", function() { return _getTheme__WEBPACK_IMPORTED_MODULE_1__["getTheme"]; });

/* harmony import */ var _selectThemeVariant__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./selectThemeVariant */ "./packages/grafana-ui/src/themes/selectThemeVariant.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "selectThemeVariant", function() { return _selectThemeVariant__WEBPACK_IMPORTED_MODULE_2__["selectThemeVariant"]; });

/* harmony import */ var _stylesFactory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stylesFactory */ "./packages/grafana-ui/src/themes/stylesFactory.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stylesFactory", function() { return _stylesFactory__WEBPACK_IMPORTED_MODULE_3__["stylesFactory"]; });








/***/ }),

/***/ "./packages/grafana-ui/src/themes/light.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-ui/src/themes/light.ts ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _default__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./default */ "./packages/grafana-ui/src/themes/default.ts");
/* harmony import */ var _types_theme__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../types/theme */ "./packages/grafana-ui/src/types/theme.ts");



var basicColors = {
    black: '#000000',
    white: '#ffffff',
    dark1: '#1e2028',
    dark2: '#41444b',
    dark3: '#303133',
    dark4: '#35373f',
    dark5: '#41444b',
    dark6: '#41444b',
    dark7: '#41444b',
    dark8: '#2f2f32',
    dark9: '#343436',
    dark10: '#424345',
    gray1: '#52545c',
    gray2: '#767980',
    gray3: '#acb6bf',
    gray4: '#c7d0d9',
    gray5: '#dde4ed',
    gray6: '#e9edf2',
    gray7: '#f7f8fa',
    grayBlue: '#212327',
    blueBase: '#3274d9',
    blueShade: '#1f60c4',
    blueLight: '#5794f2',
    blueFaint: '#f5f9ff',
    redBase: '#e02f44',
    redShade: '#c4162a',
    greenBase: '#3eb15b',
    greenShade: '#369b4f',
    blue: '#0083b3',
    red: '#d44939',
    yellow: '#ff851b',
    purple: '#9954bb',
    variable: '#007580',
    orange: '#ff7941',
};
var lightTheme = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, _default__WEBPACK_IMPORTED_MODULE_1__["default"], { type: _types_theme__WEBPACK_IMPORTED_MODULE_2__["GrafanaThemeType"].Light, name: 'Grafana Light', colors: tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, basicColors, { variable: basicColors.blue, inputBlack: '#09090b', brandPrimary: basicColors.orange, brandSuccess: basicColors.greenBase, brandWarning: basicColors.orange, brandDanger: basicColors.redBase, queryRed: basicColors.redBase, queryGreen: basicColors.greenBase, queryPurple: basicColors.purple, queryKeyword: basicColors.blueBase, queryOrange: basicColors.orange, online: basicColors.greenShade, warn: '#f79520', critical: basicColors.redShade, bodyBg: basicColors.gray7, pageBg: basicColors.gray7, body: basicColors.gray1, text: basicColors.gray1, textStrong: basicColors.dark2, textWeak: basicColors.gray2, textEmphasis: basicColors.dark5, textFaint: basicColors.dark4, link: basicColors.gray1, linkDisabled: basicColors.gray3, linkHover: basicColors.dark1, linkExternal: basicColors.blueLight, headingColor: basicColors.gray1 }), background: {
        dropdown: basicColors.white,
        scrollbar: basicColors.gray5,
        scrollbar2: basicColors.gray5,
    } });
/* harmony default export */ __webpack_exports__["default"] = (lightTheme);


/***/ }),

/***/ "./packages/grafana-ui/src/themes/selectThemeVariant.ts":
/*!**************************************************************!*\
  !*** ./packages/grafana-ui/src/themes/selectThemeVariant.ts ***!
  \**************************************************************/
/*! exports provided: selectThemeVariant */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "selectThemeVariant", function() { return selectThemeVariant; });
/* harmony import */ var _types_theme__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../types/theme */ "./packages/grafana-ui/src/types/theme.ts");

var selectThemeVariant = function (variants, currentTheme) {
    return variants[currentTheme || _types_theme__WEBPACK_IMPORTED_MODULE_0__["GrafanaThemeType"].Dark];
};


/***/ }),

/***/ "./packages/grafana-ui/src/themes/stylesFactory.ts":
/*!*********************************************************!*\
  !*** ./packages/grafana-ui/src/themes/stylesFactory.ts ***!
  \*********************************************************/
/*! exports provided: stylesFactory */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stylesFactory", function() { return stylesFactory; });
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! memoize-one */ "./node_modules/memoize-one/dist/memoize-one.esm.js");

// import { KeyValue } from '@grafana/data';
/**
 *  Creates memoized version of styles creator
 * @param stylesCreator function accepting dependencies based on which styles are created
 */
function stylesFactory(stylesCreator) {
    return Object(memoize_one__WEBPACK_IMPORTED_MODULE_0__["default"])(stylesCreator);
}


/***/ }),

/***/ "./packages/grafana-ui/src/types/app.ts":
/*!**********************************************!*\
  !*** ./packages/grafana-ui/src/types/app.ts ***!
  \**********************************************/
/*! exports provided: AppPlugin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppPlugin", function() { return AppPlugin; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _plugin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugin */ "./packages/grafana-ui/src/types/plugin.ts");


var AppPlugin = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](AppPlugin, _super);
    function AppPlugin() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Called after the module has loaded, and before the app is used.
     * This function may be called multiple times on the same instance.
     * The first time, `this.meta` will be undefined
     */
    AppPlugin.prototype.init = function (meta) { };
    /**
     * Set the component displayed under:
     *   /a/${plugin-id}/*
     */
    AppPlugin.prototype.setRootPage = function (root, rootNav) {
        this.root = root;
        this.rootNav = rootNav;
        return this;
    };
    AppPlugin.prototype.setComponentsFromLegacyExports = function (pluginExports) {
        var e_1, _a;
        if (pluginExports.ConfigCtrl) {
            this.angularConfigCtrl = pluginExports.ConfigCtrl;
        }
        if (this.meta && this.meta.includes) {
            try {
                for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](this.meta.includes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var include = _c.value;
                    if (include.type === _plugin__WEBPACK_IMPORTED_MODULE_1__["PluginIncludeType"].page && include.component) {
                        var exp = pluginExports[include.component];
                        if (!exp) {
                            console.warn('App Page uses unknown component: ', include.component, this.meta);
                            continue;
                        }
                        if (!this.angularPages) {
                            this.angularPages = {};
                        }
                        this.angularPages[include.component] = exp;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    };
    return AppPlugin;
}(_plugin__WEBPACK_IMPORTED_MODULE_1__["GrafanaPlugin"]));



/***/ }),

/***/ "./packages/grafana-ui/src/types/datasource.ts":
/*!*****************************************************!*\
  !*** ./packages/grafana-ui/src/types/datasource.ts ***!
  \*****************************************************/
/*! exports provided: DataSourcePlugin, DataSourceApi, DataSourceStatus */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataSourcePlugin", function() { return DataSourcePlugin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataSourceApi", function() { return DataSourceApi; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataSourceStatus", function() { return DataSourceStatus; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _plugin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugin */ "./packages/grafana-ui/src/types/plugin.ts");


var DataSourcePlugin = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](DataSourcePlugin, _super);
    function DataSourcePlugin(DataSourceClass) {
        var _this = _super.call(this) || this;
        _this.DataSourceClass = DataSourceClass;
        _this.components = {};
        return _this;
    }
    DataSourcePlugin.prototype.setConfigEditor = function (editor) {
        this.components.ConfigEditor = editor;
        return this;
    };
    DataSourcePlugin.prototype.setConfigCtrl = function (ConfigCtrl) {
        this.angularConfigCtrl = ConfigCtrl;
        return this;
    };
    DataSourcePlugin.prototype.setQueryCtrl = function (QueryCtrl) {
        this.components.QueryCtrl = QueryCtrl;
        return this;
    };
    DataSourcePlugin.prototype.setAnnotationQueryCtrl = function (AnnotationsQueryCtrl) {
        this.components.AnnotationsQueryCtrl = AnnotationsQueryCtrl;
        return this;
    };
    DataSourcePlugin.prototype.setQueryEditor = function (QueryEditor) {
        this.components.QueryEditor = QueryEditor;
        return this;
    };
    DataSourcePlugin.prototype.setExploreQueryField = function (ExploreQueryField) {
        this.components.ExploreQueryField = ExploreQueryField;
        return this;
    };
    DataSourcePlugin.prototype.setExploreMetricsQueryField = function (ExploreQueryField) {
        this.components.ExploreMetricsQueryField = ExploreQueryField;
        return this;
    };
    DataSourcePlugin.prototype.setExploreLogsQueryField = function (ExploreQueryField) {
        this.components.ExploreLogsQueryField = ExploreQueryField;
        return this;
    };
    DataSourcePlugin.prototype.setExploreStartPage = function (ExploreStartPage) {
        this.components.ExploreStartPage = ExploreStartPage;
        return this;
    };
    DataSourcePlugin.prototype.setVariableQueryEditor = function (VariableQueryEditor) {
        this.components.VariableQueryEditor = VariableQueryEditor;
        return this;
    };
    DataSourcePlugin.prototype.setComponentsFromLegacyExports = function (pluginExports) {
        this.angularConfigCtrl = pluginExports.ConfigCtrl;
        this.components.QueryCtrl = pluginExports.QueryCtrl;
        this.components.AnnotationsQueryCtrl = pluginExports.AnnotationsQueryCtrl;
        this.components.ExploreQueryField = pluginExports.ExploreQueryField;
        this.components.ExploreStartPage = pluginExports.ExploreStartPage;
        this.components.QueryEditor = pluginExports.QueryEditor;
        this.components.VariableQueryEditor = pluginExports.VariableQueryEditor;
    };
    return DataSourcePlugin;
}(_plugin__WEBPACK_IMPORTED_MODULE_1__["GrafanaPlugin"]));

/**
 * The main data source abstraction interface, represents an instance of a data source
 *
 * Although this is a class, datasource implementations do not *yet* need to extend it.
 * As such, we can not yet add functions with default implementations.
 */
var DataSourceApi = /** @class */ (function () {
    function DataSourceApi(instanceSettings) {
        this.name = instanceSettings.name;
        this.id = instanceSettings.id;
    }
    return DataSourceApi;
}());

var DataSourceStatus;
(function (DataSourceStatus) {
    DataSourceStatus[DataSourceStatus["Connected"] = 0] = "Connected";
    DataSourceStatus[DataSourceStatus["Disconnected"] = 1] = "Disconnected";
})(DataSourceStatus || (DataSourceStatus = {}));


/***/ }),

/***/ "./packages/grafana-ui/src/types/index.ts":
/*!************************************************!*\
  !*** ./packages/grafana-ui/src/types/index.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _panel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./panel */ "./packages/grafana-ui/src/types/panel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelPlugin", function() { return _panel__WEBPACK_IMPORTED_MODULE_0__["PanelPlugin"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VizOrientation", function() { return _panel__WEBPACK_IMPORTED_MODULE_0__["VizOrientation"]; });

/* harmony import */ var _plugin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugin */ "./packages/grafana-ui/src/types/plugin.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PluginState", function() { return _plugin__WEBPACK_IMPORTED_MODULE_1__["PluginState"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PluginType", function() { return _plugin__WEBPACK_IMPORTED_MODULE_1__["PluginType"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PluginIncludeType", function() { return _plugin__WEBPACK_IMPORTED_MODULE_1__["PluginIncludeType"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GrafanaPlugin", function() { return _plugin__WEBPACK_IMPORTED_MODULE_1__["GrafanaPlugin"]; });

/* harmony import */ var _app__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app */ "./packages/grafana-ui/src/types/app.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AppPlugin", function() { return _app__WEBPACK_IMPORTED_MODULE_2__["AppPlugin"]; });

/* harmony import */ var _datasource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./datasource */ "./packages/grafana-ui/src/types/datasource.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataSourcePlugin", function() { return _datasource__WEBPACK_IMPORTED_MODULE_3__["DataSourcePlugin"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataSourceApi", function() { return _datasource__WEBPACK_IMPORTED_MODULE_3__["DataSourceApi"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataSourceStatus", function() { return _datasource__WEBPACK_IMPORTED_MODULE_3__["DataSourceStatus"]; });

/* harmony import */ var _theme__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./theme */ "./packages/grafana-ui/src/types/theme.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GrafanaThemeType", function() { return _theme__WEBPACK_IMPORTED_MODULE_4__["GrafanaThemeType"]; });

/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./input */ "./packages/grafana-ui/src/types/input.ts");
/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_input__WEBPACK_IMPORTED_MODULE_5__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _input__WEBPACK_IMPORTED_MODULE_5__) if(["PanelPlugin","VizOrientation","PluginState","PluginType","PluginIncludeType","GrafanaPlugin","AppPlugin","DataSourcePlugin","DataSourceApi","DataSourceStatus","GrafanaThemeType","default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _input__WEBPACK_IMPORTED_MODULE_5__[key]; }) }(__WEBPACK_IMPORT_KEY__));








/***/ }),

/***/ "./packages/grafana-ui/src/types/input.ts":
/*!************************************************!*\
  !*** ./packages/grafana-ui/src/types/input.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./packages/grafana-ui/src/types/panel.ts":
/*!************************************************!*\
  !*** ./packages/grafana-ui/src/types/panel.ts ***!
  \************************************************/
/*! exports provided: PanelPlugin, VizOrientation */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PanelPlugin", function() { return PanelPlugin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VizOrientation", function() { return VizOrientation; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _plugin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugin */ "./packages/grafana-ui/src/types/plugin.ts");


var PanelPlugin = /** @class */ (function (_super) {
    tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"](PanelPlugin, _super);
    function PanelPlugin(panel) {
        var _this = _super.call(this) || this;
        _this.panel = panel;
        return _this;
    }
    PanelPlugin.prototype.setEditor = function (editor) {
        this.editor = editor;
        return this;
    };
    PanelPlugin.prototype.setDefaults = function (defaults) {
        this.defaults = defaults;
        return this;
    };
    /**
     * This function is called before the panel first loads if
     * the current version is different than the version that was saved.
     *
     * This is a good place to support any changes to the options model
     */
    PanelPlugin.prototype.setMigrationHandler = function (handler) {
        this.onPanelMigration = handler;
        return this;
    };
    /**
     * This function is called when the visualization was changed.  This
     * passes in the options that were used in the previous visualization
     */
    PanelPlugin.prototype.setPanelChangeHandler = function (handler) {
        this.onPanelTypeChanged = handler;
        return this;
    };
    return PanelPlugin;
}(_plugin__WEBPACK_IMPORTED_MODULE_1__["GrafanaPlugin"]));

var VizOrientation;
(function (VizOrientation) {
    VizOrientation["Auto"] = "auto";
    VizOrientation["Vertical"] = "vertical";
    VizOrientation["Horizontal"] = "horizontal";
})(VizOrientation || (VizOrientation = {}));


/***/ }),

/***/ "./packages/grafana-ui/src/types/plugin.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-ui/src/types/plugin.ts ***!
  \*************************************************/
/*! exports provided: PluginState, PluginType, PluginIncludeType, GrafanaPlugin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PluginState", function() { return PluginState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PluginType", function() { return PluginType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PluginIncludeType", function() { return PluginIncludeType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GrafanaPlugin", function() { return GrafanaPlugin; });
var PluginState;
(function (PluginState) {
    PluginState["alpha"] = "alpha";
    PluginState["beta"] = "beta";
})(PluginState || (PluginState = {}));
var PluginType;
(function (PluginType) {
    PluginType["panel"] = "panel";
    PluginType["datasource"] = "datasource";
    PluginType["app"] = "app";
    PluginType["renderer"] = "renderer";
})(PluginType || (PluginType = {}));
var PluginIncludeType;
(function (PluginIncludeType) {
    PluginIncludeType["dashboard"] = "dashboard";
    PluginIncludeType["page"] = "page";
    // Only valid for apps
    PluginIncludeType["panel"] = "panel";
    PluginIncludeType["datasource"] = "datasource";
})(PluginIncludeType || (PluginIncludeType = {}));
var GrafanaPlugin = /** @class */ (function () {
    function GrafanaPlugin() {
    }
    // Tabs on the plugin page
    GrafanaPlugin.prototype.addConfigPage = function (tab) {
        if (!this.configPages) {
            this.configPages = [];
        }
        this.configPages.push(tab);
        return this;
    };
    return GrafanaPlugin;
}());



/***/ }),

/***/ "./packages/grafana-ui/src/types/theme.ts":
/*!************************************************!*\
  !*** ./packages/grafana-ui/src/types/theme.ts ***!
  \************************************************/
/*! exports provided: GrafanaThemeType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GrafanaThemeType", function() { return GrafanaThemeType; });
var GrafanaThemeType;
(function (GrafanaThemeType) {
    GrafanaThemeType["Light"] = "light";
    GrafanaThemeType["Dark"] = "dark";
})(GrafanaThemeType || (GrafanaThemeType = {}));


/***/ }),

/***/ "./packages/grafana-ui/src/utils/ansicolor.ts":
/*!****************************************************!*\
  !*** ./packages/grafana-ui/src/utils/ansicolor.ts ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
// Vendored and converted to TS, source: https://github.com/xpl/ansicolor/blob/b82360563ed29de444dc7618b9236191e0a77096/ansicolor.js
// License: Unlicense, author: https://github.com/xpl

var O = Object;
/*  See https://misc.flogisoft.com/bash/tip_colors_and_formatting
    ------------------------------------------------------------------------ */
var colorCodes = ['black', 'red', 'green', 'yellow', 'blue', 'magenta', 'cyan', 'lightGray', '', 'default'], colorCodesLight = [
    'darkGray',
    'lightRed',
    'lightGreen',
    'lightYellow',
    'lightBlue',
    'lightMagenta',
    'lightCyan',
    'white',
    '',
], styleCodes = ['', 'bright', 'dim', 'italic', 'underline', '', '', 'inverse'], asBright = {
    red: 'lightRed',
    green: 'lightGreen',
    yellow: 'lightYellow',
    blue: 'lightBlue',
    magenta: 'lightMagenta',
    cyan: 'lightCyan',
    black: 'darkGray',
    lightGray: 'white',
}, types = {
    0: 'style',
    2: 'unstyle',
    3: 'color',
    9: 'colorLight',
    4: 'bgColor',
    10: 'bgColorLight',
}, subtypes = {
    color: colorCodes,
    colorLight: colorCodesLight,
    bgColor: colorCodes,
    bgColorLight: colorCodesLight,
    style: styleCodes,
    unstyle: styleCodes,
};
/*  ------------------------------------------------------------------------ */
var clean = function (obj) {
    for (var k in obj) {
        if (!obj[k]) {
            delete obj[k];
        }
    }
    return O.keys(obj).length === 0 ? undefined : obj;
};
/*  ------------------------------------------------------------------------ */
var Color = /** @class */ (function () {
    function Color(background, name, brightness) {
        this.background = background;
        this.name = name;
        this.brightness = brightness;
    }
    Object.defineProperty(Color.prototype, "inverse", {
        get: function () {
            return new Color(!this.background, this.name || (this.background ? 'black' : 'white'), this.brightness);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Color.prototype, "clean", {
        get: function () {
            return clean({
                name: this.name === 'default' ? '' : this.name,
                bright: this.brightness === Code.bright,
                dim: this.brightness === Code.dim,
            });
        },
        enumerable: true,
        configurable: true
    });
    Color.prototype.defaultBrightness = function (value) {
        return new Color(this.background, this.name, this.brightness || value);
    };
    Color.prototype.css = function (inverted) {
        var color = inverted ? this.inverse : this;
        // @ts-ignore
        var rgbName = (color.brightness === Code.bright && asBright[color.name]) || color.name;
        var prop = color.background ? 'background:' : 'color:';
        // @ts-ignore
        var rgb = Colors.rgb[rgbName];
        var alpha = this.brightness === Code.dim ? 0.5 : 1;
        return rgb
            ? prop + 'rgba(' + tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](rgb, [alpha]).join(',') + ');'
            : !color.background && alpha < 1
                ? 'color:rgba(0,0,0,0.5);'
                : ''; // Chrome does not support 'opacity' property...
    };
    return Color;
}());
/*  ------------------------------------------------------------------------ */
var Code = /** @class */ (function () {
    function Code(n) {
        if (n !== undefined) {
            this.value = Number(n);
        }
        else {
            this.value = undefined;
        }
    }
    Object.defineProperty(Code.prototype, "type", {
        get: function () {
            // @ts-ignore
            return types[Math.floor(this.value / 10)];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Code.prototype, "subtype", {
        get: function () {
            // @ts-ignore
            return subtypes[this.type][this.value % 10];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Code.prototype, "str", {
        get: function () {
            return this.value ? '\u001b[' + this.value + 'm' : '';
        },
        enumerable: true,
        configurable: true
    });
    Code.str = function (x) {
        return new Code(x).str;
    };
    Object.defineProperty(Code.prototype, "isBrightness", {
        get: function () {
            return this.value === Code.noBrightness || this.value === Code.bright || this.value === Code.dim;
        },
        enumerable: true,
        configurable: true
    });
    Code.reset = 0;
    Code.bright = 1;
    Code.dim = 2;
    Code.inverse = 7;
    Code.noBrightness = 22;
    Code.noItalic = 23;
    Code.noUnderline = 24;
    Code.noInverse = 27;
    Code.noColor = 39;
    Code.noBgColor = 49;
    return Code;
}());
/*  ------------------------------------------------------------------------ */
var replaceAll = function (str, a, b) { return str.split(a).join(b); };
/*  ANSI brightness codes do not overlap, e.g. "{bright}{dim}foo" will be rendered bright (not dim).
    So we fix it by adding brightness canceling before each brightness code, so the former example gets
    converted to "{noBrightness}{bright}{noBrightness}{dim}foo" – this way it gets rendered as expected.
 */
var denormalizeBrightness = function (s) { return s.replace(/(\u001b\[(1|2)m)/g, '\u001b[22m$1'); };
var normalizeBrightness = function (s) { return s.replace(/\u001b\[22m(\u001b\[(1|2)m)/g, '$1'); };
// @ts-ignore
var wrap = function (x, openCode, closeCode) {
    var open = Code.str(openCode), close = Code.str(closeCode);
    return String(x)
        .split('\n')
        .map(function (line) { return denormalizeBrightness(open + replaceAll(normalizeBrightness(line), close, open) + close); })
        .join('\n');
};
/*  ------------------------------------------------------------------------ */
var camel = function (a, b) { return a + b.charAt(0).toUpperCase() + b.slice(1); };
var stringWrappingMethods = (function () {
    return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](colorCodes.map(function (k, i) {
        return !k
            ? []
            : [
                // color methods
                [k, 30 + i, Code.noColor],
                [camel('bg', k), 40 + i, Code.noBgColor],
            ];
    }), colorCodesLight.map(function (k, i) {
        return !k
            ? []
            : [
                // light color methods
                [k, 90 + i, Code.noColor],
                [camel('bg', k), 100 + i, Code.noBgColor],
            ];
    }), ['', 'BrightRed', 'BrightGreen', 'BrightYellow', 'BrightBlue', 'BrightMagenta', 'BrightCyan'].map(function (k, i) {
        return !k ? [] : [['bg' + k, 100 + i, Code.noBgColor]];
    }), styleCodes.map(function (k, i) {
        return !k
            ? []
            : [
                // style methods
                [k, i, k === 'bright' || k === 'dim' ? Code.noBrightness : 20 + i],
            ];
    })).reduce(function (a, b) { return a.concat(b); });
})();
/*  ------------------------------------------------------------------------ */
// @ts-ignore
var assignStringWrappingAPI = function (target, wrapBefore) {
    if (wrapBefore === void 0) { wrapBefore = target; }
    return stringWrappingMethods.reduce(function (memo, _a) {
        var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](_a, 3), k = _b[0], open = _b[1], close = _b[2];
        return O.defineProperty(memo, k, {
            // @ts-ignore
            get: function () { return assignStringWrappingAPI(function (str) { return wrapBefore(wrap(str, open, close)); }); },
        });
    }, target);
};
/*  ------------------------------------------------------------------------ */
var TEXT = 0, BRACKET = 1, CODE = 2;
function rawParse(s) {
    var e_1, _a;
    var state = TEXT, buffer = '', text = '', code = '', codes = [];
    var spans = [];
    for (var i = 0, n = s.length; i < n; i++) {
        var c = s[i];
        buffer += c;
        switch (state) {
            case TEXT: {
                if (c === '\u001b') {
                    state = BRACKET;
                    buffer = c;
                }
                else {
                    text += c;
                }
                break;
            }
            case BRACKET:
                if (c === '[') {
                    state = CODE;
                    code = '';
                    codes = [];
                }
                else {
                    state = TEXT;
                    text += buffer;
                }
                break;
            case CODE:
                if (c >= '0' && c <= '9') {
                    code += c;
                }
                else if (c === ';') {
                    codes.push(new Code(code));
                    code = '';
                }
                else if (c === 'm' && code.length) {
                    codes.push(new Code(code));
                    try {
                        for (var codes_1 = (e_1 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](codes)), codes_1_1 = codes_1.next(); !codes_1_1.done; codes_1_1 = codes_1.next()) {
                            var code_1 = codes_1_1.value;
                            spans.push({ text: text, code: code_1 });
                            text = '';
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (codes_1_1 && !codes_1_1.done && (_a = codes_1.return)) _a.call(codes_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    state = TEXT;
                }
                else {
                    state = TEXT;
                    text += buffer;
                }
        }
    }
    if (state !== TEXT) {
        text += buffer;
    }
    if (text) {
        spans.push({ text: text, code: new Code() });
    }
    return spans;
}
/*  ------------------------------------------------------------------------ */
/**
 * Represents an ANSI-escaped string.
 */
var Colors = /** @class */ (function () {
    /**
     * @param {string} s a string containing ANSI escape codes.
     */
    function Colors(s) {
        this.spans = s ? rawParse(s) : [];
    }
    Object.defineProperty(Colors.prototype, "str", {
        get: function () {
            return this.spans.reduce(function (str, p) { return str + p.text + p.code.str; }, '');
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Colors.prototype, "parsed", {
        get: function () {
            var styles;
            var brightness;
            var color;
            var bgColor;
            function reset() {
                (color = new Color()),
                    (bgColor = new Color(true /* background */)),
                    (brightness = undefined),
                    (styles = new Set());
            }
            reset();
            return O.assign(new Colors(), {
                spans: this.spans
                    .map(function (span) {
                    var e_2, _a;
                    var c = span.code;
                    var inverted = styles.has('inverse'), underline = styles.has('underline') ? 'text-decoration: underline;' : '', italic = styles.has('italic') ? 'font-style: italic;' : '', bold = brightness === Code.bright ? 'font-weight: bold;' : '';
                    var foreColor = color.defaultBrightness(brightness);
                    var styledSpan = O.assign({ css: bold + italic + underline + foreColor.css(inverted) + bgColor.css(inverted) }, clean({ bold: !!bold, color: foreColor.clean, bgColor: bgColor.clean }), span);
                    try {
                        for (var styles_1 = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](styles), styles_1_1 = styles_1.next(); !styles_1_1.done; styles_1_1 = styles_1.next()) {
                            var k = styles_1_1.value;
                            styledSpan[k] = true;
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (styles_1_1 && !styles_1_1.done && (_a = styles_1.return)) _a.call(styles_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                    if (c.isBrightness) {
                        brightness = c.value;
                    }
                    else if (span.code.value !== undefined) {
                        if (span.code.value === Code.reset) {
                            reset();
                        }
                        else {
                            switch (span.code.type) {
                                case 'color':
                                case 'colorLight':
                                    color = new Color(false, c.subtype);
                                    break;
                                case 'bgColor':
                                case 'bgColorLight':
                                    bgColor = new Color(true, c.subtype);
                                    break;
                                case 'style':
                                    styles.add(c.subtype);
                                    break;
                                case 'unstyle':
                                    styles.delete(c.subtype);
                                    break;
                            }
                        }
                    }
                    return styledSpan;
                })
                    .filter(function (s) { return s.text.length > 0; }),
            });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Colors.prototype, "asChromeConsoleLogArguments", {
        /*  Outputs with Chrome DevTools-compatible format     */
        get: function () {
            var spans = this.parsed.spans;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"]([spans.map(function (s) { return '%c' + s.text; }).join('')], spans.map(function (s) { return s.css; }));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Colors.prototype, "browserConsoleArguments", {
        get: function () {
            return this.asChromeConsoleLogArguments;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Colors, "nice", {
        /**
         * @desc installs String prototype extensions
         * @example
         * require ('ansicolor').nice
         * console.log ('foo'.bright.red)
         */
        get: function () {
            Colors.names.forEach(function (k) {
                if (!(k in String.prototype)) {
                    O.defineProperty(String.prototype, k, {
                        get: function () {
                            // @ts-ignore
                            return Colors[k](this);
                        },
                    });
                }
            });
            return Colors;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @desc parses a string containing ANSI escape codes
     * @return {Colors} parsed representation.
     */
    Colors.parse = function (s) {
        return new Colors(s).parsed;
    };
    /**
     * @desc strips ANSI codes from a string
     * @param {string} s a string containing ANSI escape codes.
     * @return {string} clean string.
     */
    Colors.strip = function (s) {
        return s.replace(/[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-PRZcf-nqry=><]/g, ''); // hope V8 caches the regexp
    };
    /**
     * @example
     * const spans = [...ansi.parse ('\u001b[7m\u001b[7mfoo\u001b[7mbar\u001b[27m')]
     */
    Colors.prototype[Symbol.iterator] = function () {
        return this.spans[Symbol.iterator]();
    };
    Colors.names = stringWrappingMethods.map(function (_a) {
        var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__read"](_a, 1), k = _b[0];
        return k;
    });
    Colors.rgb = {
        black: [0, 0, 0],
        darkGray: [100, 100, 100],
        lightGray: [200, 200, 200],
        white: [255, 255, 255],
        red: [204, 0, 0],
        lightRed: [255, 51, 0],
        green: [0, 204, 0],
        lightGreen: [51, 204, 51],
        yellow: [204, 102, 0],
        lightYellow: [255, 153, 51],
        blue: [0, 0, 255],
        lightBlue: [26, 140, 255],
        magenta: [204, 0, 204],
        lightMagenta: [255, 0, 255],
        cyan: [0, 153, 255],
        lightCyan: [0, 204, 255],
    };
    return Colors;
}());
/* harmony default export */ __webpack_exports__["default"] = (Colors);
/*  ------------------------------------------------------------------------ */
assignStringWrappingAPI(Colors, function (str) { return str; });


/***/ }),

/***/ "./packages/grafana-ui/src/utils/colors.ts":
/*!*************************************************!*\
  !*** ./packages/grafana-ui/src/utils/colors.ts ***!
  \*************************************************/
/*! exports provided: PALETTE_ROWS, PALETTE_COLUMNS, DEFAULT_ANNOTATION_COLOR, OK_COLOR, ALERTING_COLOR, NO_DATA_COLOR, PENDING_COLOR, REGION_FILL_ALPHA, colors, sortedColors */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PALETTE_ROWS", function() { return PALETTE_ROWS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PALETTE_COLUMNS", function() { return PALETTE_COLUMNS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DEFAULT_ANNOTATION_COLOR", function() { return DEFAULT_ANNOTATION_COLOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OK_COLOR", function() { return OK_COLOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ALERTING_COLOR", function() { return ALERTING_COLOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NO_DATA_COLOR", function() { return NO_DATA_COLOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PENDING_COLOR", function() { return PENDING_COLOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "REGION_FILL_ALPHA", function() { return REGION_FILL_ALPHA; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "colors", function() { return colors; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sortedColors", function() { return sortedColors; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lodash_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/map */ "./node_modules/lodash/map.js");
/* harmony import */ var lodash_map__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_map__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_sortBy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/sortBy */ "./node_modules/lodash/sortBy.js");
/* harmony import */ var lodash_sortBy__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_sortBy__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/flattenDeep */ "./node_modules/lodash/flattenDeep.js");
/* harmony import */ var lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_chunk__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/chunk */ "./node_modules/lodash/chunk.js");
/* harmony import */ var lodash_chunk__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_chunk__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_zip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/zip */ "./node_modules/lodash/zip.js");
/* harmony import */ var lodash_zip__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_zip__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js");
/* harmony import */ var tinycolor2__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(tinycolor2__WEBPACK_IMPORTED_MODULE_6__);







var PALETTE_ROWS = 4;
var PALETTE_COLUMNS = 14;
var DEFAULT_ANNOTATION_COLOR = 'rgba(0, 211, 255, 1)';
var OK_COLOR = 'rgba(11, 237, 50, 1)';
var ALERTING_COLOR = 'rgba(237, 46, 24, 1)';
var NO_DATA_COLOR = 'rgba(150, 150, 150, 1)';
var PENDING_COLOR = 'rgba(247, 149, 32, 1)';
var REGION_FILL_ALPHA = 0.09;
var colors = [
    '#7EB26D',
    '#EAB839',
    '#6ED0E0',
    '#EF843C',
    '#E24D42',
    '#1F78C1',
    '#BA43A9',
    '#705DA0',
    '#508642',
    '#CCA300',
    '#447EBC',
    '#C15C17',
    '#890F02',
    '#0A437C',
    '#6D1F62',
    '#584477',
    '#B7DBAB',
    '#F4D598',
    '#70DBED',
    '#F9BA8F',
    '#F29191',
    '#82B5D8',
    '#E5A8E2',
    '#AEA2E0',
    '#629E51',
    '#E5AC0E',
    '#64B0C8',
    '#E0752D',
    '#BF1B00',
    '#0A50A1',
    '#962D82',
    '#614D93',
    '#9AC48A',
    '#F2C96D',
    '#65C5DB',
    '#F9934E',
    '#EA6460',
    '#5195CE',
    '#D683CE',
    '#806EB7',
    '#3F6833',
    '#967302',
    '#2F575E',
    '#99440A',
    '#58140C',
    '#052B51',
    '#511749',
    '#3F2B5B',
    '#E0F9D7',
    '#FCEACA',
    '#CFFAFF',
    '#F9E2D2',
    '#FCE2DE',
    '#BADFF4',
    '#F9D9F9',
    '#DEDAF7',
];
function sortColorsByHue(hexColors) {
    var hslColors = lodash_map__WEBPACK_IMPORTED_MODULE_1___default()(hexColors, hexToHsl);
    var sortedHSLColors = lodash_sortBy__WEBPACK_IMPORTED_MODULE_2___default()(hslColors, ['h']);
    var chunkedHSLColors = lodash_chunk__WEBPACK_IMPORTED_MODULE_4___default()(sortedHSLColors, PALETTE_ROWS);
    var sortedChunkedHSLColors = lodash_map__WEBPACK_IMPORTED_MODULE_1___default()(chunkedHSLColors, function (chunk) {
        return lodash_sortBy__WEBPACK_IMPORTED_MODULE_2___default()(chunk, 'l');
    });
    var flattenedZippedSortedChunkedHSLColors = lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_3___default()(lodash_zip__WEBPACK_IMPORTED_MODULE_5___default.a.apply(void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__spread"](sortedChunkedHSLColors)));
    return lodash_map__WEBPACK_IMPORTED_MODULE_1___default()(flattenedZippedSortedChunkedHSLColors, hslToHex);
}
function hexToHsl(color) {
    return tinycolor2__WEBPACK_IMPORTED_MODULE_6___default()(color).toHsl();
}
function hslToHex(color) {
    return tinycolor2__WEBPACK_IMPORTED_MODULE_6___default()(color).toHexString();
}
var sortedColors = sortColorsByHue(colors);


/***/ }),

/***/ "./packages/grafana-ui/src/utils/dataLinks.ts":
/*!****************************************************!*\
  !*** ./packages/grafana-ui/src/utils/dataLinks.ts ***!
  \****************************************************/
/*! exports provided: DataLinkBuiltInVars, linkModelToContextMenuItems */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataLinkBuiltInVars", function() { return DataLinkBuiltInVars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "linkModelToContextMenuItems", function() { return linkModelToContextMenuItems; });
var DataLinkBuiltInVars = {
    keepTime: '__url_time_range',
    timeRangeFrom: '__from',
    timeRangeTo: '__to',
    includeVars: '__all_variables',
    seriesName: '__series.name',
    fieldName: '__field.name',
    valueTime: '__value.time',
    valueNumeric: '__value.numeric',
    valueText: '__value.text',
    valueRaw: '__value.raw',
    // name of the calculation represented by the value
    valueCalc: '__value.calc',
};
/**
 * Delays creating links until we need to open the ContextMenu
 */
var linkModelToContextMenuItems = function (links) {
    return links.getLinks().map(function (link) {
        return {
            label: link.title,
            // TODO: rename to href
            url: link.href,
            target: link.target,
            icon: "fa " + (link.target === '_self' ? 'fa-link' : 'fa-external-link'),
        };
    });
};


/***/ }),

/***/ "./packages/grafana-ui/src/utils/displayProcessor.ts":
/*!***********************************************************!*\
  !*** ./packages/grafana-ui/src/utils/displayProcessor.ts ***!
  \***********************************************************/
/*! exports provided: getDisplayProcessor, getColorFromThreshold, getDecimalsForValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDisplayProcessor", function() { return getDisplayProcessor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getColorFromThreshold", function() { return getColorFromThreshold; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDecimalsForValue", function() { return getDecimalsForValue; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var _valueFormats_valueFormats__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./valueFormats/valueFormats */ "./packages/grafana-ui/src/utils/valueFormats/valueFormats.ts");
/* harmony import */ var _namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./namedColorsPalette */ "./packages/grafana-ui/src/utils/namedColorsPalette.ts");
/* harmony import */ var _types_index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../types/index */ "./packages/grafana-ui/src/types/index.ts");
// Libraries


// Utils


// Types

function getDisplayProcessor(options) {
    if (options && !lodash__WEBPACK_IMPORTED_MODULE_0___default.a.isEmpty(options)) {
        var field_1 = options.config ? options.config : {};
        var formatFunc_1 = Object(_valueFormats_valueFormats__WEBPACK_IMPORTED_MODULE_2__["getValueFormat"])(field_1.unit || 'none');
        return function (value) {
            var theme = options.theme;
            var mappings = field_1.mappings, thresholds = field_1.thresholds;
            var color;
            var text = lodash__WEBPACK_IMPORTED_MODULE_0___default.a.toString(value);
            var numeric = toNumber(value);
            var shouldFormat = true;
            if (mappings && mappings.length > 0) {
                var mappedValue = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_1__["getMappedValue"])(mappings, value);
                if (mappedValue) {
                    text = mappedValue.text;
                    var v = toNumber(text);
                    if (!isNaN(v)) {
                        numeric = v;
                    }
                    shouldFormat = false;
                }
            }
            if (!isNaN(numeric)) {
                if (shouldFormat && !lodash__WEBPACK_IMPORTED_MODULE_0___default.a.isBoolean(value)) {
                    var _a = getDecimalsForValue(value, field_1.decimals), decimals = _a.decimals, scaledDecimals = _a.scaledDecimals;
                    text = formatFunc_1(numeric, decimals, scaledDecimals, options.isUtc);
                    // Check if the formatted text mapped to a different value
                    if (mappings && mappings.length > 0) {
                        var mappedValue = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_1__["getMappedValue"])(mappings, text);
                        if (mappedValue) {
                            text = mappedValue.text;
                        }
                    }
                }
                if (thresholds && thresholds.length) {
                    color = getColorFromThreshold(numeric, thresholds, theme);
                }
            }
            if (!text) {
                if (field_1 && field_1.noValue) {
                    text = field_1.noValue;
                }
                else {
                    text = ''; // No data?
                }
            }
            return { text: text, numeric: numeric, color: color };
        };
    }
    return toStringProcessor;
}
/** Will return any value as a number or NaN */
function toNumber(value) {
    if (typeof value === 'number') {
        return value;
    }
    if (value === null || value === undefined || Array.isArray(value)) {
        return NaN; // lodash calls them 0
    }
    if (typeof value === 'boolean') {
        return value ? 1 : 0;
    }
    return lodash__WEBPACK_IMPORTED_MODULE_0___default.a.toNumber(value);
}
function toStringProcessor(value) {
    return { text: lodash__WEBPACK_IMPORTED_MODULE_0___default.a.toString(value), numeric: toNumber(value) };
}
function getColorFromThreshold(value, thresholds, theme) {
    var themeType = theme ? theme.type : _types_index__WEBPACK_IMPORTED_MODULE_4__["GrafanaThemeType"].Dark;
    if (thresholds.length === 1) {
        return Object(_namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(thresholds[0].color, themeType);
    }
    var atThreshold = thresholds.filter(function (threshold) { return value === threshold.value; })[0];
    if (atThreshold) {
        return Object(_namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(atThreshold.color, themeType);
    }
    var belowThreshold = thresholds.filter(function (threshold) { return value > threshold.value; });
    if (belowThreshold.length > 0) {
        var nearestThreshold = belowThreshold.sort(function (t1, t2) { return t2.value - t1.value; })[0];
        return Object(_namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(nearestThreshold.color, themeType);
    }
    // Use the first threshold as the default color
    return Object(_namedColorsPalette__WEBPACK_IMPORTED_MODULE_3__["getColorFromHexRgbOrName"])(thresholds[0].color, themeType);
}
// function getSignificantDigitCount(n: number): number {
//   // remove decimal and make positive
//   n = Math.abs(parseInt(String(n).replace('.', ''), 10));
//   if (n === 0) {
//     return 0;
//   }
//
//   // kill the 0s at the end of n
//   while (n !== 0 && n % 10 === 0) {
//     n /= 10;
//   }
//
//   // get number of digits
//   return Math.floor(Math.log(n) / Math.LN10) + 1;
// }
function getDecimalsForValue(value, decimalOverride) {
    if (lodash__WEBPACK_IMPORTED_MODULE_0___default.a.isNumber(decimalOverride)) {
        // It's important that scaledDecimals is null here
        return { decimals: decimalOverride, scaledDecimals: null };
    }
    var dec = -Math.floor(Math.log(value) / Math.LN10) + 1;
    var magn = Math.pow(10, -dec);
    var norm = value / magn; // norm is between 1.0 and 10.0
    var size;
    if (norm < 1.5) {
        size = 1;
    }
    else if (norm < 3) {
        size = 2;
        // special case for 2.5, requires an extra decimal
        if (norm > 2.25) {
            size = 2.5;
            ++dec;
        }
    }
    else if (norm < 7.5) {
        size = 5;
    }
    else {
        size = 10;
    }
    size *= magn;
    // reduce starting decimals if not needed
    if (value % 1 === 0) {
        dec = 0;
    }
    var decimals = Math.max(0, dec);
    var scaledDecimals = decimals - Math.floor(Math.log(size) / Math.LN10) + 2;
    return { decimals: decimals, scaledDecimals: scaledDecimals };
}


/***/ }),

/***/ "./packages/grafana-ui/src/utils/dom.ts":
/*!**********************************************!*\
  !*** ./packages/grafana-ui/src/utils/dom.ts ***!
  \**********************************************/
/*! exports provided: getPreviousCousin, getNextCharacter */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getPreviousCousin", function() { return getPreviousCousin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getNextCharacter", function() { return getNextCharacter; });
// Node.closest() polyfill
if ('Element' in window && !Element.prototype.closest) {
    Element.prototype.closest = function (s) {
        var matches = (this.document || this.ownerDocument).querySelectorAll(s);
        var el = this;
        var i;
        // eslint-disable-next-line
        do {
            i = matches.length;
            // eslint-disable-next-line
            while (--i >= 0 && matches.item(i) !== el) { }
            el = el.parentElement;
        } while (i < 0 && el);
        return el;
    };
}
function getPreviousCousin(node, selector) {
    var sibling = node.parentElement.previousSibling;
    var el;
    while (sibling) {
        el = sibling.querySelector(selector);
        if (el) {
            return el;
        }
        sibling = sibling.previousSibling;
    }
    return undefined;
}
function getNextCharacter(global) {
    if (global === void 0) { global = window; }
    var selection = global.getSelection();
    if (!selection || !selection.anchorNode) {
        return null;
    }
    var range = selection.getRangeAt(0);
    var text = selection.anchorNode.textContent;
    var offset = range.startOffset;
    return text.substr(offset, 1);
}


/***/ }),

/***/ "./packages/grafana-ui/src/utils/fieldDisplay.ts":
/*!*******************************************************!*\
  !*** ./packages/grafana-ui/src/utils/fieldDisplay.ts ***!
  \*******************************************************/
/*! exports provided: VAR_SERIES_NAME, VAR_FIELD_NAME, VAR_CALC, VAR_CELL_PREFIX, DEFAULT_FIELD_DISPLAY_VALUES_LIMIT, getFieldDisplayValues, applyFieldProperties, getFieldProperties */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VAR_SERIES_NAME", function() { return VAR_SERIES_NAME; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VAR_FIELD_NAME", function() { return VAR_FIELD_NAME; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VAR_CALC", function() { return VAR_CALC; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VAR_CELL_PREFIX", function() { return VAR_CELL_PREFIX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DEFAULT_FIELD_DISPLAY_VALUES_LIMIT", function() { return DEFAULT_FIELD_DISPLAY_VALUES_LIMIT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFieldDisplayValues", function() { return getFieldDisplayValues; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "applyFieldProperties", function() { return applyFieldProperties; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFieldProperties", function() { return getFieldProperties; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _grafana_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @grafana/data */ "./packages/grafana-data/src/index.ts");
/* harmony import */ var lodash_toNumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/toNumber */ "./node_modules/lodash/toNumber.js");
/* harmony import */ var lodash_toNumber__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_toNumber__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_toString__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/toString */ "./node_modules/lodash/toString.js");
/* harmony import */ var lodash_toString__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_toString__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _displayProcessor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./displayProcessor */ "./packages/grafana-ui/src/utils/displayProcessor.ts");
/* harmony import */ var _flotPairs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./flotPairs */ "./packages/grafana-ui/src/utils/flotPairs.ts");






// TODO: use built in variables, same as for data links?
var VAR_SERIES_NAME = '__series.name';
var VAR_FIELD_NAME = '__field.name';
var VAR_CALC = '__calc';
var VAR_CELL_PREFIX = '__cell_'; // consistent with existing table templates
function getTitleTemplate(title, stats, data) {
    var e_1, _a;
    // If the title exists, use it as a template variable
    if (title) {
        return title;
    }
    if (!data || !data.length) {
        return 'No Data';
    }
    var fieldCount = 0;
    try {
        for (var _b = tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](data[0].fields), _c = _b.next(); !_c.done; _c = _b.next()) {
            var field = _c.value;
            if (field.type === _grafana_data__WEBPACK_IMPORTED_MODULE_1__["FieldType"].number) {
                fieldCount++;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    var parts = [];
    if (stats.length > 1) {
        parts.push('${' + VAR_CALC + '}');
    }
    if (data.length > 1) {
        parts.push('${' + VAR_SERIES_NAME + '}');
    }
    if (fieldCount > 1 || !parts.length) {
        parts.push('${' + VAR_FIELD_NAME + '}');
    }
    return parts.join(' ');
}
var DEFAULT_FIELD_DISPLAY_VALUES_LIMIT = 25;
var getFieldDisplayValues = function (options) {
    var e_2, _a;
    var data = options.data, replaceVariables = options.replaceVariables, fieldOptions = options.fieldOptions;
    var defaults = fieldOptions.defaults, override = fieldOptions.override;
    var calcs = fieldOptions.calcs.length ? fieldOptions.calcs : [_grafana_data__WEBPACK_IMPORTED_MODULE_1__["ReducerID"].last];
    var values = [];
    if (data) {
        var hitLimit = false;
        var limit = fieldOptions.limit ? fieldOptions.limit : DEFAULT_FIELD_DISPLAY_VALUES_LIMIT;
        var defaultTitle = getTitleTemplate(fieldOptions.defaults.title, calcs, data);
        var scopedVars = {};
        for (var s = 0; s < data.length && !hitLimit; s++) {
            var series = data[s];
            if (!series.name) {
                series = tslib__WEBPACK_IMPORTED_MODULE_0__["__assign"]({}, series, { name: series.refId ? series.refId : "Series[" + s + "]" });
            }
            scopedVars['__series'] = { text: 'Series', value: { name: series.name } };
            var timeField = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_1__["getTimeField"])(series).timeField;
            var view = new _grafana_data__WEBPACK_IMPORTED_MODULE_1__["DataFrameView"](series);
            for (var i = 0; i < series.fields.length && !hitLimit; i++) {
                var field = series.fields[i];
                // Show all number fields
                if (field.type !== _grafana_data__WEBPACK_IMPORTED_MODULE_1__["FieldType"].number) {
                    continue;
                }
                var config = getFieldProperties(defaults, field.config || {}, override);
                var name = field.name;
                if (!name) {
                    name = "Field[" + s + "]";
                }
                scopedVars['__field'] = { text: 'Field', value: { name: name } };
                var display = Object(_displayProcessor__WEBPACK_IMPORTED_MODULE_4__["getDisplayProcessor"])({
                    config: config,
                    theme: options.theme,
                });
                var title = config.title ? config.title : defaultTitle;
                // Show all rows
                if (fieldOptions.values) {
                    var usesCellValues = title.indexOf(VAR_CELL_PREFIX) >= 0;
                    for (var j = 0; j < field.values.length; j++) {
                        // Add all the row variables
                        if (usesCellValues) {
                            for (var k = 0; k < series.fields.length; k++) {
                                var f = series.fields[k];
                                var v = f.values.get(j);
                                scopedVars[VAR_CELL_PREFIX + k] = {
                                    value: v,
                                    text: lodash_toString__WEBPACK_IMPORTED_MODULE_3___default()(v),
                                };
                            }
                        }
                        var displayValue = display(field.values.get(j));
                        displayValue.title = replaceVariables(title, scopedVars);
                        values.push({
                            name: name,
                            field: config,
                            display: displayValue,
                            view: view,
                            colIndex: i,
                            rowIndex: j,
                        });
                        if (values.length >= limit) {
                            hitLimit = true;
                            break;
                        }
                    }
                }
                else {
                    var results = Object(_grafana_data__WEBPACK_IMPORTED_MODULE_1__["reduceField"])({
                        field: field,
                        reducers: calcs,
                    });
                    var sparkline = undefined;
                    // Single sparkline for every reducer
                    if (options.sparkline && timeField) {
                        sparkline = Object(_flotPairs__WEBPACK_IMPORTED_MODULE_5__["getFlotPairs"])({
                            xField: timeField,
                            yField: series.fields[i],
                        });
                    }
                    try {
                        for (var calcs_1 = (e_2 = void 0, tslib__WEBPACK_IMPORTED_MODULE_0__["__values"](calcs)), calcs_1_1 = calcs_1.next(); !calcs_1_1.done; calcs_1_1 = calcs_1.next()) {
                            var calc = calcs_1_1.value;
                            scopedVars[VAR_CALC] = { value: calc, text: calc };
                            var displayValue = display(results[calc]);
                            displayValue.title = replaceVariables(title, scopedVars);
                            values.push({
                                name: calc,
                                field: config,
                                display: displayValue,
                                sparkline: sparkline,
                                view: view,
                                colIndex: i,
                            });
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (calcs_1_1 && !calcs_1_1.done && (_a = calcs_1.return)) _a.call(calcs_1);
                        }
                        finally { if (e_2) throw e_2.error; }
       