// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/Microsoft/hcsshim/cmd/containerd-shim-runhcs-v1/stats/stats.proto

/*
	Package stats is a generated protocol buffer package.

	It is generated from these files:
		github.com/Microsoft/hcsshim/cmd/containerd-shim-runhcs-v1/stats/stats.proto

	It has these top-level messages:
		Statistics
		WindowsContainerStatistics
		LinuxContainerStatistics
		VirtualMachineStatistics
		VirtualMachineProcessorStatistics
		VirtualMachineMemoryStatistics
*/
package stats

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// skipping weak import gogoproto "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Statistics struct {
	// Types that are valid to be assigned to Container:
	//	*Statistics_Windows
	//	*Statistics_Linux
	Container isStatistics_Container    `protobuf_oneof:"container"`
	VM        *VirtualMachineStatistics `protobuf:"bytes,3,opt,name=vm" json:"vm,omitempty"`
}

func (m *Statistics) Reset()                    { *m = Statistics{} }
func (*Statistics) ProtoMessage()               {}
func (*Statistics) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{0} }

type isStatistics_Container interface {
	isStatistics_Container()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Statistics_Windows struct {
	Windows *WindowsContainerStatistics `protobuf:"bytes,1,opt,name=windows,oneof"`
}
type Statistics_Linux struct {
	Linux *LinuxContainerStatistics `protobuf:"bytes,2,opt,name=linux,oneof"`
}

func (*Statistics_Windows) isStatistics_Container() {}
func (*Statistics_Linux) isStatistics_Container()   {}

func (m *Statistics) GetContainer() isStatistics_Container {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *Statistics) GetWindows() *WindowsContainerStatistics {
	if x, ok := m.GetContainer().(*Statistics_Windows); ok {
		return x.Windows
	}
	return nil
}

func (m *Statistics) GetLinux() *LinuxContainerStatistics {
	if x, ok := m.GetContainer().(*Statistics_Linux); ok {
		return x.Linux
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Statistics) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Statistics_OneofMarshaler, _Statistics_OneofUnmarshaler, _Statistics_OneofSizer, []interface{}{
		(*Statistics_Windows)(nil),
		(*Statistics_Linux)(nil),
	}
}

func _Statistics_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Statistics)
	// container
	switch x := m.Container.(type) {
	case *Statistics_Windows:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Windows); err != nil {
			return err
		}
	case *Statistics_Linux:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Linux); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Statistics.Container has unexpected type %T", x)
	}
	return nil
}

func _Statistics_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Statistics)
	switch tag {
	case 1: // container.windows
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WindowsContainerStatistics)
		err := b.DecodeMessage(msg)
		m.Container = &Statistics_Windows{msg}
		return true, err
	case 2: // container.linux
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LinuxContainerStatistics)
		err := b.DecodeMessage(msg)
		m.Container = &Statistics_Linux{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Statistics_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Statistics)
	// container
	switch x := m.Container.(type) {
	case *Statistics_Windows:
		s := proto.Size(x.Windows)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Statistics_Linux:
		s := proto.Size(x.Linux)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type WindowsContainerStatistics struct {
}

func (m *WindowsContainerStatistics) Reset()                    { *m = WindowsContainerStatistics{} }
func (*WindowsContainerStatistics) ProtoMessage()               {}
func (*WindowsContainerStatistics) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{1} }

type LinuxContainerStatistics struct {
}

func (m *LinuxContainerStatistics) Reset()                    { *m = LinuxContainerStatistics{} }
func (*LinuxContainerStatistics) ProtoMessage()               {}
func (*LinuxContainerStatistics) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{2} }

type VirtualMachineStatistics struct {
	Processor *VirtualMachineProcessorStatistics `protobuf:"bytes,1,opt,name=processor" json:"processor,omitempty"`
	Memory    *VirtualMachineMemoryStatistics    `protobuf:"bytes,2,opt,name=memory" json:"memory,omitempty"`
}

func (m *VirtualMachineStatistics) Reset()                    { *m = VirtualMachineStatistics{} }
func (*VirtualMachineStatistics) ProtoMessage()               {}
func (*VirtualMachineStatistics) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{3} }

type VirtualMachineProcessorStatistics struct {
	TotalRuntimeNS uint64 `protobuf:"varint,1,opt,name=total_runtime_ns,json=totalRuntimeNs,proto3" json:"total_runtime_ns,omitempty"`
}

func (m *VirtualMachineProcessorStatistics) Reset()      { *m = VirtualMachineProcessorStatistics{} }
func (*VirtualMachineProcessorStatistics) ProtoMessage() {}
func (*VirtualMachineProcessorStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptorStats, []int{4}
}

type VirtualMachineMemoryStatistics struct {
	WorkingSetBytes uint64 `protobuf:"varint,1,opt,name=working_set_bytes,json=workingSetBytes,proto3" json:"working_set_bytes,omitempty"`
}

func (m *VirtualMachineMemoryStatistics) Reset()      { *m = VirtualMachineMemoryStatistics{} }
func (*VirtualMachineMemoryStatistics) ProtoMessage() {}
func (*VirtualMachineMemoryStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptorStats, []int{5}
}

func init() {
	proto.RegisterType((*Statistics)(nil), "containerd.runhcs.stats.v1.Statistics")
	proto.RegisterType((*WindowsContainerStatistics)(nil), "containerd.runhcs.stats.v1.WindowsContainerStatistics")
	proto.RegisterType((*LinuxContainerStatistics)(nil), "containerd.runhcs.stats.v1.LinuxContainerStatistics")
	proto.RegisterType((*VirtualMachineStatistics)(nil), "containerd.runhcs.stats.v1.VirtualMachineStatistics")
	proto.RegisterType((*VirtualMachineProcessorStatistics)(nil), "containerd.runhcs.stats.v1.VirtualMachineProcessorStatistics")
	proto.RegisterType((*VirtualMachineMemoryStatistics)(nil), "containerd.runhcs.stats.v1.VirtualMachineMemoryStatistics")
}
func (m *Statistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Statistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Container != nil {
		nn1, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.VM != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.VM.Size()))
		n2, err := m.VM.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *Statistics_Windows) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Windows != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Windows.Size()))
		n3, err := m.Windows.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Statistics_Linux) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Linux != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Linux.Size()))
		n4, err := m.Linux.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *WindowsContainerStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *LinuxContainerStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxContainerStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *VirtualMachineStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualMachineStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Processor != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Processor.Size()))
		n5, err := m.Processor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Memory != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Memory.Size()))
		n6, err := m.Memory.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *VirtualMachineProcessorStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualMachineProcessorStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TotalRuntimeNS != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalRuntimeNS))
	}
	return i, nil
}

func (m *VirtualMachineMemoryStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualMachineMemoryStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.WorkingSetBytes != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.WorkingSetBytes))
	}
	return i, nil
}

func encodeVarintStats(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Statistics) Size() (n int) {
	var l int
	_ = l
	if m.Container != nil {
		n += m.Container.Size()
	}
	if m.VM != nil {
		l = m.VM.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func (m *Statistics_Windows) Size() (n int) {
	var l int
	_ = l
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *Statistics_Linux) Size() (n int) {
	var l int
	_ = l
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *WindowsContainerStatistics) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *LinuxContainerStatistics) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *VirtualMachineStatistics) Size() (n int) {
	var l int
	_ = l
	if m.Processor != nil {
		l = m.Processor.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func (m *VirtualMachineProcessorStatistics) Size() (n int) {
	var l int
	_ = l
	if m.TotalRuntimeNS != 0 {
		n += 1 + sovStats(uint64(m.TotalRuntimeNS))
	}
	return n
}

func (m *VirtualMachineMemoryStatistics) Size() (n int) {
	var l int
	_ = l
	if m.WorkingSetBytes != 0 {
		n += 1 + sovStats(uint64(m.WorkingSetBytes))
	}
	return n
}

func sovStats(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStats(x uint64) (n int) {
	return sovStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Statistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Statistics{`,
		`Container:` + fmt.Sprintf("%v", this.Container) + `,`,
		`VM:` + strings.Replace(fmt.Sprintf("%v", this.VM), "VirtualMachineStatistics", "VirtualMachineStatistics", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Statistics_Windows) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Statistics_Windows{`,
		`Windows:` + strings.Replace(fmt.Sprintf("%v", this.Windows), "WindowsContainerStatistics", "WindowsContainerStatistics", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Statistics_Linux) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Statistics_Linux{`,
		`Linux:` + strings.Replace(fmt.Sprintf("%v", this.Linux), "LinuxContainerStatistics", "LinuxContainerStatistics", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerStatistics{`,
		`}`,
	}, "")
	return s
}
func (this *LinuxContainerStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxContainerStatistics{`,
		`}`,
	}, "")
	return s
}
func (this *VirtualMachineStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VirtualMachineStatistics{`,
		`Processor:` + strings.Replace(fmt.Sprintf("%v", this.Processor), "VirtualMachineProcessorStatistics", "VirtualMachineProcessorStatistics", 1) + `,`,
		`Memory:` + strings.Replace(fmt.Sprintf("%v", this.Memory), "VirtualMachineMemoryStatistics", "VirtualMachineMemoryStatistics", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VirtualMachineProcessorStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VirtualMachineProcessorStatistics{`,
		`TotalRuntimeNS:` + fmt.Sprintf("%v", this.TotalRuntimeNS) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VirtualMachineMemoryStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VirtualMachineMemoryStatistics{`,
		`WorkingSetBytes:` + fmt.Sprintf("%v", this.WorkingSetBytes) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringStats(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Statistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Statistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Statistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WindowsContainerStatistics{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Container = &Statistics_Windows{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Linux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LinuxContainerStatistics{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Container = &Statistics_Linux{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VM", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VM == nil {
				m.VM = &VirtualMachineStatistics{}
			}
			if err := m.VM.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxContainerStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxContainerStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxContainerStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualMachineStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualMachineStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualMachineStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Processor == nil {
				m.Processor = &VirtualMachineProcessorStatistics{}
			}
			if err := m.Processor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memory == nil {
				m.Memory = &VirtualMachineMemoryStatistics{}
			}
			if err := m.Memory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualMachineProcessorStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualMachineProcessorStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualMachineProcessorStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRuntimeNS", wireType)
			}
			m.TotalRuntimeNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRuntimeNS |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualMachineMemoryStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualMachineMemoryStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualMachineMemoryStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkingSetBytes", wireType)
			}
			m.WorkingSetBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkingSetBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStats   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/Microsoft/hcsshim/cmd/containerd-shim-runhcs-v1/stats/stats.proto", fileDescriptorStats)
}

var fileDescriptorStats = []byte{
	// 430 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x93, 0xcf, 0x6b, 0xd4, 0x40,
	0x14, 0xc7, 0x37, 0x51, 0x57, 0xfa, 0x0a, 0x55, 0x07, 0x0f, 0x61, 0x91, 0x54, 0x73, 0x12, 0x61,
	0x13, 0xaa, 0xe2, 0xc1, 0x1f, 0x97, 0x08, 0xe2, 0x21, 0x2b, 0x32, 0x2b, 0x55, 0xf4, 0xb0, 0x66,
	0x67, 0xc7, 0xcd, 0xe0, 0xce, 0x4c, 0x99, 0x79, 0xd9, 0xb5, 0x37, 0xaf, 0xfe, 0x67, 0x05, 0x2f,
	0x1e, 0x3d, 0x15, 0x9b, 0xbf, 0x44, 0x92, 0xc9, 0x9a, 0x1e, 0xdc, 0xb6, 0xd0, 0xcb, 0x90, 0xcc,
	0xf7, 0xfb, 0x3e, 0xef, 0x9b, 0x47, 0x1e, 0x64, 0x73, 0x81, 0x45, 0x39, 0x8d, 0x99, 0x96, 0xc9,
	0x48, 0x30, 0xa3, 0xad, 0xfe, 0x82, 0x49, 0xc1, 0xac, 0x2d, 0x84, 0x4c, 0x98, 0x9c, 0x25, 0x4c,
	0x2b, 0xcc, 0x85, 0xe2, 0x66, 0x36, 0xac, 0xef, 0x86, 0xa6, 0x54, 0x05, 0xb3, 0xc3, 0xe5, 0x5e,
	0x62, 0x31, 0x47, 0xeb, 0xce, 0xf8, 0xc0, 0x68, 0xd4, 0x64, 0xd0, 0x99, 0x63, 0xe7, 0x8b, 0x9d,
	0xbc, 0xdc, 0x1b, 0xdc, 0x9e, 0xeb, 0xb9, 0x6e, 0x6c, 0x49, 0xfd, 0xe4, 0x2a, 0xa2, 0x1f, 0x3e,
	0xc0, 0x18, 0x73, 0x14, 0x16, 0x05, 0xb3, 0x84, 0xc2, 0xf5, 0x95, 0x50, 0x33, 0xbd, 0xb2, 0x81,
	0x77, 0xd7, 0xbb, 0xbf, 0xfd, 0xf0, 0x49, 0xbc, 0x19, 0x19, 0xbf, 0x77, 0xd6, 0x97, 0x6b, 0x47,
	0x07, 0x7a, 0xdd, 0xa3, 0x6b, 0x10, 0xc9, 0xe0, 0xda, 0x42, 0xa8, 0xf2, 0x5b, 0xe0, 0x37, 0xc4,
	0xc7, 0x67, 0x11, 0xb3, 0xda, 0xf8, 0x7f, 0x9e, 0x83, 0x90, 0x0c, 0xfc, 0xa5, 0x0c, 0xae, 0x9c,
	0x8f, 0xda, 0x17, 0x06, 0xcb, 0x7c, 0x31, 0xca, 0x59, 0x21, 0x14, 0xef, 0x50, 0x69, 0xbf, 0x3a,
	0xde, 0xf5, 0xf7, 0x47, 0xd4, 0x5f, 0xca, 0x74, 0x1b, 0xb6, 0xfe, 0x21, 0xa2, 0x3b, 0x30, 0xd8,
	0xfc, 0x45, 0xd1, 0x00, 0x82, 0x4d, 0xe9, 0xa2, 0x9f, 0x1e, 0x04, 0x9b, 0xfa, 0x91, 0x4f, 0xb0,
	0x75, 0x60, 0x34, 0xe3, 0xd6, 0x6a, 0xd3, 0x4e, 0xf5, 0xc5, 0xc5, 0x83, 0xbf, 0x5d, 0x97, 0x76,
	0x44, 0xda, 0xf1, 0x08, 0x85, 0xbe, 0xe4, 0x52, 0x9b, 0xc3, 0x76, 0xba, 0x4f, 0x2f, 0x4e, 0x1e,
	0x35, 0x75, 0xa7, 0xb0, 0x2d, 0x29, 0xca, 0xe1, 0xde, 0xb9, 0x19, 0xc8, 0x73, 0xb8, 0x89, 0x1a,
	0xf3, 0xc5, 0xc4, 0x94, 0x0a, 0x85, 0xe4, 0x13, 0xe5, 0x7e, 0x99, 0xab, 0x29, 0xa9, 0x8e, 0x77,
	0x77, 0xde, 0xd5, 0x1a, 0x75, 0xd2, 0x9b, 0x31, 0xdd, 0xc1, 0xd3, 0xef, 0x36, 0xca, 0x20, 0x3c,
	0x3b, 0x0c, 0x79, 0x00, 0xb7, 0x56, 0xda, 0x7c, 0x15, 0x6a, 0x3e, 0xb1, 0x1c, 0x27, 0xd3, 0x43,
	0xe4, 0x6d, 0x03, 0x7a, 0xa3, 0x15, 0xc6, 0x1c, 0xd3, 0xfa, 0x3a, 0xfd, 0x7c, 0x74, 0x12, 0xf6,
	0x7e, 0x9f, 0x84, 0xbd, 0xef, 0x55, 0xe8, 0x1d, 0x55, 0xa1, 0xf7, 0xab, 0x0a, 0xbd, 0x3f, 0x55,
	0xe8, 0x7d, 0x7c, 0x75, 0xd9, 0xf5, 0x7a, 0xd6, 0x9c, 0x1f, 0x7a, 0xd3, 0x7e, 0xb3, 0x2f, 0x8f,
	0xfe, 0x06, 0x00, 0x00, 0xff, 0xff, 0x05, 0xa5, 0x30, 0x6f, 0xb1, 0x03, 0x00, 0x00,
}
