'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertPhraseFilter = convertPhraseFilter;

var _node_types = require('../node_types');

function convertPhraseFilter(filter) {
  if (filter.meta.type !== 'phrase') {
    throw new Error('Expected filter of type "phrase", got "' + filter.meta.type + '"');
  }

  var _filter$meta = filter.meta,
      key = _filter$meta.key,
      params = _filter$meta.params;

  return _node_types.nodeTypes.function.buildNode('is', key, params.query);
} /*
   * Licensed to Elasticsearch B.V. under one or more contributor
   * license agreements. See the NOTICE file distributed with
   * this work for additional information regarding copyright
   * ownership. Elasticsearch B.V. licenses this file to you under
   * the Apache License, Version 2.0 (the "License"); you may
   * not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *    http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing,
   * software distributed under the License is distributed on an
   * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   * KIND, either express or implied.  See the License for the
   * specific language governing permissions and limitations
   * under the License.
   */