// Code generated by go-swagger; DO NOT EDIT.

package package_appr

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/operator-framework/go-appr/models"
)

// NewCreatePackageParams creates a new CreatePackageParams object
// with the default values initialized.
func NewCreatePackageParams() *CreatePackageParams {
	var (
		forceDefault = bool(false)
	)
	return &CreatePackageParams{
		Force: &forceDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewCreatePackageParamsWithTimeout creates a new CreatePackageParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewCreatePackageParamsWithTimeout(timeout time.Duration) *CreatePackageParams {
	var (
		forceDefault = bool(false)
	)
	return &CreatePackageParams{
		Force: &forceDefault,

		timeout: timeout,
	}
}

// NewCreatePackageParamsWithContext creates a new CreatePackageParams object
// with the default values initialized, and the ability to set a context for a request
func NewCreatePackageParamsWithContext(ctx context.Context) *CreatePackageParams {
	var (
		forceDefault = bool(false)
	)
	return &CreatePackageParams{
		Force: &forceDefault,

		Context: ctx,
	}
}

// NewCreatePackageParamsWithHTTPClient creates a new CreatePackageParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewCreatePackageParamsWithHTTPClient(client *http.Client) *CreatePackageParams {
	var (
		forceDefault = bool(false)
	)
	return &CreatePackageParams{
		Force:      &forceDefault,
		HTTPClient: client,
	}
}

/*CreatePackageParams contains all the parameters to send to the API endpoint
for the create package operation typically these are written to a http.Request
*/
type CreatePackageParams struct {

	/*Body
	  Package object to be added to the registry

	*/
	Body *models.PostPackage
	/*Force
	  Force push the release (if allowed)

	*/
	Force *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the create package params
func (o *CreatePackageParams) WithTimeout(timeout time.Duration) *CreatePackageParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create package params
func (o *CreatePackageParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create package params
func (o *CreatePackageParams) WithContext(ctx context.Context) *CreatePackageParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create package params
func (o *CreatePackageParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create package params
func (o *CreatePackageParams) WithHTTPClient(client *http.Client) *CreatePackageParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create package params
func (o *CreatePackageParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create package params
func (o *CreatePackageParams) WithBody(body *models.PostPackage) *CreatePackageParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create package params
func (o *CreatePackageParams) SetBody(body *models.PostPackage) {
	o.Body = body
}

// WithForce adds the force to the create package params
func (o *CreatePackageParams) WithForce(force *bool) *CreatePackageParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the create package params
func (o *CreatePackageParams) SetForce(force *bool) {
	o.Force = force
}

// WriteToRequest writes these params to a swagger request
func (o *CreatePackageParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool
		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {
			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
