// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	config_v1 "github.com/openshift/api/config/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeDNSes implements DNSInterface
type FakeDNSes struct {
	Fake *FakeConfigV1
}

var dnsesResource = schema.GroupVersionResource{Group: "config.openshift.io", Version: "v1", Resource: "dnses"}

var dnsesKind = schema.GroupVersionKind{Group: "config.openshift.io", Version: "v1", Kind: "DNS"}

// Get takes name of the dNS, and returns the corresponding dNS object, and an error if there is any.
func (c *FakeDNSes) Get(name string, options v1.GetOptions) (result *config_v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(dnsesResource, name), &config_v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.DNS), err
}

// List takes label and field selectors, and returns the list of DNSes that match those selectors.
func (c *FakeDNSes) List(opts v1.ListOptions) (result *config_v1.DNSList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(dnsesResource, dnsesKind, opts), &config_v1.DNSList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &config_v1.DNSList{ListMeta: obj.(*config_v1.DNSList).ListMeta}
	for _, item := range obj.(*config_v1.DNSList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested dNSes.
func (c *FakeDNSes) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(dnsesResource, opts))
}

// Create takes the representation of a dNS and creates it.  Returns the server's representation of the dNS, and an error, if there is any.
func (c *FakeDNSes) Create(dNS *config_v1.DNS) (result *config_v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(dnsesResource, dNS), &config_v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.DNS), err
}

// Update takes the representation of a dNS and updates it. Returns the server's representation of the dNS, and an error, if there is any.
func (c *FakeDNSes) Update(dNS *config_v1.DNS) (result *config_v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(dnsesResource, dNS), &config_v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.DNS), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDNSes) UpdateStatus(dNS *config_v1.DNS) (*config_v1.DNS, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(dnsesResource, "status", dNS), &config_v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.DNS), err
}

// Delete takes name of the dNS and deletes it. Returns an error if one occurs.
func (c *FakeDNSes) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(dnsesResource, name), &config_v1.DNS{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDNSes) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(dnsesResource, listOptions)

	_, err := c.Fake.Invokes(action, &config_v1.DNSList{})
	return err
}

// Patch applies the patch and returns the patched dNS.
func (c *FakeDNSes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *config_v1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(dnsesResource, name, data, subresources...), &config_v1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.DNS), err
}
