// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	config_v1 "github.com/openshift/api/config/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeInfrastructures implements InfrastructureInterface
type FakeInfrastructures struct {
	Fake *FakeConfigV1
}

var infrastructuresResource = schema.GroupVersionResource{Group: "config.openshift.io", Version: "v1", Resource: "infrastructures"}

var infrastructuresKind = schema.GroupVersionKind{Group: "config.openshift.io", Version: "v1", Kind: "Infrastructure"}

// Get takes name of the infrastructure, and returns the corresponding infrastructure object, and an error if there is any.
func (c *FakeInfrastructures) Get(name string, options v1.GetOptions) (result *config_v1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(infrastructuresResource, name), &config_v1.Infrastructure{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.Infrastructure), err
}

// List takes label and field selectors, and returns the list of Infrastructures that match those selectors.
func (c *FakeInfrastructures) List(opts v1.ListOptions) (result *config_v1.InfrastructureList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(infrastructuresResource, infrastructuresKind, opts), &config_v1.InfrastructureList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &config_v1.InfrastructureList{ListMeta: obj.(*config_v1.InfrastructureList).ListMeta}
	for _, item := range obj.(*config_v1.InfrastructureList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested infrastructures.
func (c *FakeInfrastructures) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(infrastructuresResource, opts))
}

// Create takes the representation of a infrastructure and creates it.  Returns the server's representation of the infrastructure, and an error, if there is any.
func (c *FakeInfrastructures) Create(infrastructure *config_v1.Infrastructure) (result *config_v1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(infrastructuresResource, infrastructure), &config_v1.Infrastructure{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.Infrastructure), err
}

// Update takes the representation of a infrastructure and updates it. Returns the server's representation of the infrastructure, and an error, if there is any.
func (c *FakeInfrastructures) Update(infrastructure *config_v1.Infrastructure) (result *config_v1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(infrastructuresResource, infrastructure), &config_v1.Infrastructure{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.Infrastructure), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeInfrastructures) UpdateStatus(infrastructure *config_v1.Infrastructure) (*config_v1.Infrastructure, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(infrastructuresResource, "status", infrastructure), &config_v1.Infrastructure{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.Infrastructure), err
}

// Delete takes name of the infrastructure and deletes it. Returns an error if one occurs.
func (c *FakeInfrastructures) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(infrastructuresResource, name), &config_v1.Infrastructure{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeInfrastructures) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(infrastructuresResource, listOptions)

	_, err := c.Fake.Invokes(action, &config_v1.InfrastructureList{})
	return err
}

// Patch applies the patch and returns the patched infrastructure.
func (c *FakeInfrastructures) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *config_v1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(infrastructuresResource, name, data, subresources...), &config_v1.Infrastructure{})
	if obj == nil {
		return nil, err
	}
	return obj.(*config_v1.Infrastructure), err
}
