// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/config/v1"
	scheme "github.com/openshift/client-go/config/clientset/versioned/scheme"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ProxiesGetter has a method to return a ProxyInterface.
// A group's client should implement this interface.
type ProxiesGetter interface {
	Proxies() ProxyInterface
}

// ProxyInterface has methods to work with Proxy resources.
type ProxyInterface interface {
	Create(*v1.Proxy) (*v1.Proxy, error)
	Update(*v1.Proxy) (*v1.Proxy, error)
	Delete(name string, options *meta_v1.DeleteOptions) error
	DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error
	Get(name string, options meta_v1.GetOptions) (*v1.Proxy, error)
	List(opts meta_v1.ListOptions) (*v1.ProxyList, error)
	Watch(opts meta_v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Proxy, err error)
	ProxyExpansion
}

// proxies implements ProxyInterface
type proxies struct {
	client rest.Interface
}

// newProxies returns a Proxies
func newProxies(c *ConfigV1Client) *proxies {
	return &proxies{
		client: c.RESTClient(),
	}
}

// Get takes name of the proxy, and returns the corresponding proxy object, and an error if there is any.
func (c *proxies) Get(name string, options meta_v1.GetOptions) (result *v1.Proxy, err error) {
	result = &v1.Proxy{}
	err = c.client.Get().
		Resource("proxies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Proxies that match those selectors.
func (c *proxies) List(opts meta_v1.ListOptions) (result *v1.ProxyList, err error) {
	result = &v1.ProxyList{}
	err = c.client.Get().
		Resource("proxies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested proxies.
func (c *proxies) Watch(opts meta_v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Resource("proxies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a proxy and creates it.  Returns the server's representation of the proxy, and an error, if there is any.
func (c *proxies) Create(proxy *v1.Proxy) (result *v1.Proxy, err error) {
	result = &v1.Proxy{}
	err = c.client.Post().
		Resource("proxies").
		Body(proxy).
		Do().
		Into(result)
	return
}

// Update takes the representation of a proxy and updates it. Returns the server's representation of the proxy, and an error, if there is any.
func (c *proxies) Update(proxy *v1.Proxy) (result *v1.Proxy, err error) {
	result = &v1.Proxy{}
	err = c.client.Put().
		Resource("proxies").
		Name(proxy.Name).
		Body(proxy).
		Do().
		Into(result)
	return
}

// Delete takes name of the proxy and deletes it. Returns an error if one occurs.
func (c *proxies) Delete(name string, options *meta_v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("proxies").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *proxies) DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error {
	return c.client.Delete().
		Resource("proxies").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched proxy.
func (c *proxies) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Proxy, err error) {
	result = &v1.Proxy{}
	err = c.client.Patch(pt).
		Resource("proxies").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
