// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	operator_v1 "github.com/openshift/api/operator/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAuthentications implements AuthenticationInterface
type FakeAuthentications struct {
	Fake *FakeOperatorV1
}

var authenticationsResource = schema.GroupVersionResource{Group: "operator.openshift.io", Version: "v1", Resource: "authentications"}

var authenticationsKind = schema.GroupVersionKind{Group: "operator.openshift.io", Version: "v1", Kind: "Authentication"}

// Get takes name of the authentication, and returns the corresponding authentication object, and an error if there is any.
func (c *FakeAuthentications) Get(name string, options v1.GetOptions) (result *operator_v1.Authentication, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(authenticationsResource, name), &operator_v1.Authentication{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operator_v1.Authentication), err
}

// List takes label and field selectors, and returns the list of Authentications that match those selectors.
func (c *FakeAuthentications) List(opts v1.ListOptions) (result *operator_v1.AuthenticationList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(authenticationsResource, authenticationsKind, opts), &operator_v1.AuthenticationList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &operator_v1.AuthenticationList{ListMeta: obj.(*operator_v1.AuthenticationList).ListMeta}
	for _, item := range obj.(*operator_v1.AuthenticationList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested authentications.
func (c *FakeAuthentications) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(authenticationsResource, opts))
}

// Create takes the representation of a authentication and creates it.  Returns the server's representation of the authentication, and an error, if there is any.
func (c *FakeAuthentications) Create(authentication *operator_v1.Authentication) (result *operator_v1.Authentication, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(authenticationsResource, authentication), &operator_v1.Authentication{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operator_v1.Authentication), err
}

// Update takes the representation of a authentication and updates it. Returns the server's representation of the authentication, and an error, if there is any.
func (c *FakeAuthentications) Update(authentication *operator_v1.Authentication) (result *operator_v1.Authentication, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(authenticationsResource, authentication), &operator_v1.Authentication{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operator_v1.Authentication), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeAuthentications) UpdateStatus(authentication *operator_v1.Authentication) (*operator_v1.Authentication, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(authenticationsResource, "status", authentication), &operator_v1.Authentication{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operator_v1.Authentication), err
}

// Delete takes name of the authentication and deletes it. Returns an error if one occurs.
func (c *FakeAuthentications) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(authenticationsResource, name), &operator_v1.Authentication{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAuthentications) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(authenticationsResource, listOptions)

	_, err := c.Fake.Invokes(action, &operator_v1.AuthenticationList{})
	return err
}

// Patch applies the patch and returns the patched authentication.
func (c *FakeAuthentications) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *operator_v1.Authentication, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(authenticationsResource, name, data, subresources...), &operator_v1.Authentication{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operator_v1.Authentication), err
}
