// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KubeAPIServersGetter has a method to return a KubeAPIServerInterface.
// A group's client should implement this interface.
type KubeAPIServersGetter interface {
	KubeAPIServers() KubeAPIServerInterface
}

// KubeAPIServerInterface has methods to work with KubeAPIServer resources.
type KubeAPIServerInterface interface {
	Create(*v1.KubeAPIServer) (*v1.KubeAPIServer, error)
	Update(*v1.KubeAPIServer) (*v1.KubeAPIServer, error)
	UpdateStatus(*v1.KubeAPIServer) (*v1.KubeAPIServer, error)
	Delete(name string, options *meta_v1.DeleteOptions) error
	DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error
	Get(name string, options meta_v1.GetOptions) (*v1.KubeAPIServer, error)
	List(opts meta_v1.ListOptions) (*v1.KubeAPIServerList, error)
	Watch(opts meta_v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeAPIServer, err error)
	KubeAPIServerExpansion
}

// kubeAPIServers implements KubeAPIServerInterface
type kubeAPIServers struct {
	client rest.Interface
}

// newKubeAPIServers returns a KubeAPIServers
func newKubeAPIServers(c *OperatorV1Client) *kubeAPIServers {
	return &kubeAPIServers{
		client: c.RESTClient(),
	}
}

// Get takes name of the kubeAPIServer, and returns the corresponding kubeAPIServer object, and an error if there is any.
func (c *kubeAPIServers) Get(name string, options meta_v1.GetOptions) (result *v1.KubeAPIServer, err error) {
	result = &v1.KubeAPIServer{}
	err = c.client.Get().
		Resource("kubeapiservers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KubeAPIServers that match those selectors.
func (c *kubeAPIServers) List(opts meta_v1.ListOptions) (result *v1.KubeAPIServerList, err error) {
	result = &v1.KubeAPIServerList{}
	err = c.client.Get().
		Resource("kubeapiservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kubeAPIServers.
func (c *kubeAPIServers) Watch(opts meta_v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Resource("kubeapiservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a kubeAPIServer and creates it.  Returns the server's representation of the kubeAPIServer, and an error, if there is any.
func (c *kubeAPIServers) Create(kubeAPIServer *v1.KubeAPIServer) (result *v1.KubeAPIServer, err error) {
	result = &v1.KubeAPIServer{}
	err = c.client.Post().
		Resource("kubeapiservers").
		Body(kubeAPIServer).
		Do().
		Into(result)
	return
}

// Update takes the representation of a kubeAPIServer and updates it. Returns the server's representation of the kubeAPIServer, and an error, if there is any.
func (c *kubeAPIServers) Update(kubeAPIServer *v1.KubeAPIServer) (result *v1.KubeAPIServer, err error) {
	result = &v1.KubeAPIServer{}
	err = c.client.Put().
		Resource("kubeapiservers").
		Name(kubeAPIServer.Name).
		Body(kubeAPIServer).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *kubeAPIServers) UpdateStatus(kubeAPIServer *v1.KubeAPIServer) (result *v1.KubeAPIServer, err error) {
	result = &v1.KubeAPIServer{}
	err = c.client.Put().
		Resource("kubeapiservers").
		Name(kubeAPIServer.Name).
		SubResource("status").
		Body(kubeAPIServer).
		Do().
		Into(result)
	return
}

// Delete takes name of the kubeAPIServer and deletes it. Returns an error if one occurs.
func (c *kubeAPIServers) Delete(name string, options *meta_v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("kubeapiservers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kubeAPIServers) DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error {
	return c.client.Delete().
		Resource("kubeapiservers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched kubeAPIServer.
func (c *kubeAPIServers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeAPIServer, err error) {
	result = &v1.KubeAPIServer{}
	err = c.client.Patch(pt).
		Resource("kubeapiservers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
