// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KubeSchedulersGetter has a method to return a KubeSchedulerInterface.
// A group's client should implement this interface.
type KubeSchedulersGetter interface {
	KubeSchedulers() KubeSchedulerInterface
}

// KubeSchedulerInterface has methods to work with KubeScheduler resources.
type KubeSchedulerInterface interface {
	Create(*v1.KubeScheduler) (*v1.KubeScheduler, error)
	Update(*v1.KubeScheduler) (*v1.KubeScheduler, error)
	UpdateStatus(*v1.KubeScheduler) (*v1.KubeScheduler, error)
	Delete(name string, options *meta_v1.DeleteOptions) error
	DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error
	Get(name string, options meta_v1.GetOptions) (*v1.KubeScheduler, error)
	List(opts meta_v1.ListOptions) (*v1.KubeSchedulerList, error)
	Watch(opts meta_v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeScheduler, err error)
	KubeSchedulerExpansion
}

// kubeSchedulers implements KubeSchedulerInterface
type kubeSchedulers struct {
	client rest.Interface
}

// newKubeSchedulers returns a KubeSchedulers
func newKubeSchedulers(c *OperatorV1Client) *kubeSchedulers {
	return &kubeSchedulers{
		client: c.RESTClient(),
	}
}

// Get takes name of the kubeScheduler, and returns the corresponding kubeScheduler object, and an error if there is any.
func (c *kubeSchedulers) Get(name string, options meta_v1.GetOptions) (result *v1.KubeScheduler, err error) {
	result = &v1.KubeScheduler{}
	err = c.client.Get().
		Resource("kubeschedulers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KubeSchedulers that match those selectors.
func (c *kubeSchedulers) List(opts meta_v1.ListOptions) (result *v1.KubeSchedulerList, err error) {
	result = &v1.KubeSchedulerList{}
	err = c.client.Get().
		Resource("kubeschedulers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kubeSchedulers.
func (c *kubeSchedulers) Watch(opts meta_v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Resource("kubeschedulers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a kubeScheduler and creates it.  Returns the server's representation of the kubeScheduler, and an error, if there is any.
func (c *kubeSchedulers) Create(kubeScheduler *v1.KubeScheduler) (result *v1.KubeScheduler, err error) {
	result = &v1.KubeScheduler{}
	err = c.client.Post().
		Resource("kubeschedulers").
		Body(kubeScheduler).
		Do().
		Into(result)
	return
}

// Update takes the representation of a kubeScheduler and updates it. Returns the server's representation of the kubeScheduler, and an error, if there is any.
func (c *kubeSchedulers) Update(kubeScheduler *v1.KubeScheduler) (result *v1.KubeScheduler, err error) {
	result = &v1.KubeScheduler{}
	err = c.client.Put().
		Resource("kubeschedulers").
		Name(kubeScheduler.Name).
		Body(kubeScheduler).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *kubeSchedulers) UpdateStatus(kubeScheduler *v1.KubeScheduler) (result *v1.KubeScheduler, err error) {
	result = &v1.KubeScheduler{}
	err = c.client.Put().
		Resource("kubeschedulers").
		Name(kubeScheduler.Name).
		SubResource("status").
		Body(kubeScheduler).
		Do().
		Into(result)
	return
}

// Delete takes name of the kubeScheduler and deletes it. Returns an error if one occurs.
func (c *kubeSchedulers) Delete(name string, options *meta_v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("kubeschedulers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kubeSchedulers) DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error {
	return c.client.Delete().
		Resource("kubeschedulers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched kubeScheduler.
func (c *kubeSchedulers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeScheduler, err error) {
	result = &v1.KubeScheduler{}
	err = c.client.Patch(pt).
		Resource("kubeschedulers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
