// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OpenShiftAPIServersGetter has a method to return a OpenShiftAPIServerInterface.
// A group's client should implement this interface.
type OpenShiftAPIServersGetter interface {
	OpenShiftAPIServers() OpenShiftAPIServerInterface
}

// OpenShiftAPIServerInterface has methods to work with OpenShiftAPIServer resources.
type OpenShiftAPIServerInterface interface {
	Create(*v1.OpenShiftAPIServer) (*v1.OpenShiftAPIServer, error)
	Update(*v1.OpenShiftAPIServer) (*v1.OpenShiftAPIServer, error)
	UpdateStatus(*v1.OpenShiftAPIServer) (*v1.OpenShiftAPIServer, error)
	Delete(name string, options *meta_v1.DeleteOptions) error
	DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error
	Get(name string, options meta_v1.GetOptions) (*v1.OpenShiftAPIServer, error)
	List(opts meta_v1.ListOptions) (*v1.OpenShiftAPIServerList, error)
	Watch(opts meta_v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.OpenShiftAPIServer, err error)
	OpenShiftAPIServerExpansion
}

// openShiftAPIServers implements OpenShiftAPIServerInterface
type openShiftAPIServers struct {
	client rest.Interface
}

// newOpenShiftAPIServers returns a OpenShiftAPIServers
func newOpenShiftAPIServers(c *OperatorV1Client) *openShiftAPIServers {
	return &openShiftAPIServers{
		client: c.RESTClient(),
	}
}

// Get takes name of the openShiftAPIServer, and returns the corresponding openShiftAPIServer object, and an error if there is any.
func (c *openShiftAPIServers) Get(name string, options meta_v1.GetOptions) (result *v1.OpenShiftAPIServer, err error) {
	result = &v1.OpenShiftAPIServer{}
	err = c.client.Get().
		Resource("openshiftapiservers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OpenShiftAPIServers that match those selectors.
func (c *openShiftAPIServers) List(opts meta_v1.ListOptions) (result *v1.OpenShiftAPIServerList, err error) {
	result = &v1.OpenShiftAPIServerList{}
	err = c.client.Get().
		Resource("openshiftapiservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested openShiftAPIServers.
func (c *openShiftAPIServers) Watch(opts meta_v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Resource("openshiftapiservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a openShiftAPIServer and creates it.  Returns the server's representation of the openShiftAPIServer, and an error, if there is any.
func (c *openShiftAPIServers) Create(openShiftAPIServer *v1.OpenShiftAPIServer) (result *v1.OpenShiftAPIServer, err error) {
	result = &v1.OpenShiftAPIServer{}
	err = c.client.Post().
		Resource("openshiftapiservers").
		Body(openShiftAPIServer).
		Do().
		Into(result)
	return
}

// Update takes the representation of a openShiftAPIServer and updates it. Returns the server's representation of the openShiftAPIServer, and an error, if there is any.
func (c *openShiftAPIServers) Update(openShiftAPIServer *v1.OpenShiftAPIServer) (result *v1.OpenShiftAPIServer, err error) {
	result = &v1.OpenShiftAPIServer{}
	err = c.client.Put().
		Resource("openshiftapiservers").
		Name(openShiftAPIServer.Name).
		Body(openShiftAPIServer).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *openShiftAPIServers) UpdateStatus(openShiftAPIServer *v1.OpenShiftAPIServer) (result *v1.OpenShiftAPIServer, err error) {
	result = &v1.OpenShiftAPIServer{}
	err = c.client.Put().
		Resource("openshiftapiservers").
		Name(openShiftAPIServer.Name).
		SubResource("status").
		Body(openShiftAPIServer).
		Do().
		Into(result)
	return
}

// Delete takes name of the openShiftAPIServer and deletes it. Returns an error if one occurs.
func (c *openShiftAPIServers) Delete(name string, options *meta_v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("openshiftapiservers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *openShiftAPIServers) DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error {
	return c.client.Delete().
		Resource("openshiftapiservers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched openShiftAPIServer.
func (c *openShiftAPIServers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.OpenShiftAPIServer, err error) {
	result = &v1.OpenShiftAPIServer{}
	err = c.client.Patch(pt).
		Resource("openshiftapiservers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
