// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OpenShiftControllerManagersGetter has a method to return a OpenShiftControllerManagerInterface.
// A group's client should implement this interface.
type OpenShiftControllerManagersGetter interface {
	OpenShiftControllerManagers() OpenShiftControllerManagerInterface
}

// OpenShiftControllerManagerInterface has methods to work with OpenShiftControllerManager resources.
type OpenShiftControllerManagerInterface interface {
	Create(*v1.OpenShiftControllerManager) (*v1.OpenShiftControllerManager, error)
	Update(*v1.OpenShiftControllerManager) (*v1.OpenShiftControllerManager, error)
	UpdateStatus(*v1.OpenShiftControllerManager) (*v1.OpenShiftControllerManager, error)
	Delete(name string, options *meta_v1.DeleteOptions) error
	DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error
	Get(name string, options meta_v1.GetOptions) (*v1.OpenShiftControllerManager, error)
	List(opts meta_v1.ListOptions) (*v1.OpenShiftControllerManagerList, error)
	Watch(opts meta_v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.OpenShiftControllerManager, err error)
	OpenShiftControllerManagerExpansion
}

// openShiftControllerManagers implements OpenShiftControllerManagerInterface
type openShiftControllerManagers struct {
	client rest.Interface
}

// newOpenShiftControllerManagers returns a OpenShiftControllerManagers
func newOpenShiftControllerManagers(c *OperatorV1Client) *openShiftControllerManagers {
	return &openShiftControllerManagers{
		client: c.RESTClient(),
	}
}

// Get takes name of the openShiftControllerManager, and returns the corresponding openShiftControllerManager object, and an error if there is any.
func (c *openShiftControllerManagers) Get(name string, options meta_v1.GetOptions) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Get().
		Resource("openshiftcontrollermanagers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OpenShiftControllerManagers that match those selectors.
func (c *openShiftControllerManagers) List(opts meta_v1.ListOptions) (result *v1.OpenShiftControllerManagerList, err error) {
	result = &v1.OpenShiftControllerManagerList{}
	err = c.client.Get().
		Resource("openshiftcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested openShiftControllerManagers.
func (c *openShiftControllerManagers) Watch(opts meta_v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Resource("openshiftcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a openShiftControllerManager and creates it.  Returns the server's representation of the openShiftControllerManager, and an error, if there is any.
func (c *openShiftControllerManagers) Create(openShiftControllerManager *v1.OpenShiftControllerManager) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Post().
		Resource("openshiftcontrollermanagers").
		Body(openShiftControllerManager).
		Do().
		Into(result)
	return
}

// Update takes the representation of a openShiftControllerManager and updates it. Returns the server's representation of the openShiftControllerManager, and an error, if there is any.
func (c *openShiftControllerManagers) Update(openShiftControllerManager *v1.OpenShiftControllerManager) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Put().
		Resource("openshiftcontrollermanagers").
		Name(openShiftControllerManager.Name).
		Body(openShiftControllerManager).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *openShiftControllerManagers) UpdateStatus(openShiftControllerManager *v1.OpenShiftControllerManager) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Put().
		Resource("openshiftcontrollermanagers").
		Name(openShiftControllerManager.Name).
		SubResource("status").
		Body(openShiftControllerManager).
		Do().
		Into(result)
	return
}

// Delete takes name of the openShiftControllerManager and deletes it. Returns an error if one occurs.
func (c *openShiftControllerManagers) Delete(name string, options *meta_v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("openshiftcontrollermanagers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *openShiftControllerManagers) DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error {
	return c.client.Delete().
		Resource("openshiftcontrollermanagers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched openShiftControllerManager.
func (c *openShiftControllerManagers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Patch(pt).
		Resource("openshiftcontrollermanagers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
