// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ServiceCatalogAPIServersGetter has a method to return a ServiceCatalogAPIServerInterface.
// A group's client should implement this interface.
type ServiceCatalogAPIServersGetter interface {
	ServiceCatalogAPIServers() ServiceCatalogAPIServerInterface
}

// ServiceCatalogAPIServerInterface has methods to work with ServiceCatalogAPIServer resources.
type ServiceCatalogAPIServerInterface interface {
	Create(*v1.ServiceCatalogAPIServer) (*v1.ServiceCatalogAPIServer, error)
	Update(*v1.ServiceCatalogAPIServer) (*v1.ServiceCatalogAPIServer, error)
	UpdateStatus(*v1.ServiceCatalogAPIServer) (*v1.ServiceCatalogAPIServer, error)
	Delete(name string, options *meta_v1.DeleteOptions) error
	DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error
	Get(name string, options meta_v1.GetOptions) (*v1.ServiceCatalogAPIServer, error)
	List(opts meta_v1.ListOptions) (*v1.ServiceCatalogAPIServerList, error)
	Watch(opts meta_v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ServiceCatalogAPIServer, err error)
	ServiceCatalogAPIServerExpansion
}

// serviceCatalogAPIServers implements ServiceCatalogAPIServerInterface
type serviceCatalogAPIServers struct {
	client rest.Interface
}

// newServiceCatalogAPIServers returns a ServiceCatalogAPIServers
func newServiceCatalogAPIServers(c *OperatorV1Client) *serviceCatalogAPIServers {
	return &serviceCatalogAPIServers{
		client: c.RESTClient(),
	}
}

// Get takes name of the serviceCatalogAPIServer, and returns the corresponding serviceCatalogAPIServer object, and an error if there is any.
func (c *serviceCatalogAPIServers) Get(name string, options meta_v1.GetOptions) (result *v1.ServiceCatalogAPIServer, err error) {
	result = &v1.ServiceCatalogAPIServer{}
	err = c.client.Get().
		Resource("servicecatalogapiservers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceCatalogAPIServers that match those selectors.
func (c *serviceCatalogAPIServers) List(opts meta_v1.ListOptions) (result *v1.ServiceCatalogAPIServerList, err error) {
	result = &v1.ServiceCatalogAPIServerList{}
	err = c.client.Get().
		Resource("servicecatalogapiservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceCatalogAPIServers.
func (c *serviceCatalogAPIServers) Watch(opts meta_v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Resource("servicecatalogapiservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a serviceCatalogAPIServer and creates it.  Returns the server's representation of the serviceCatalogAPIServer, and an error, if there is any.
func (c *serviceCatalogAPIServers) Create(serviceCatalogAPIServer *v1.ServiceCatalogAPIServer) (result *v1.ServiceCatalogAPIServer, err error) {
	result = &v1.ServiceCatalogAPIServer{}
	err = c.client.Post().
		Resource("servicecatalogapiservers").
		Body(serviceCatalogAPIServer).
		Do().
		Into(result)
	return
}

// Update takes the representation of a serviceCatalogAPIServer and updates it. Returns the server's representation of the serviceCatalogAPIServer, and an error, if there is any.
func (c *serviceCatalogAPIServers) Update(serviceCatalogAPIServer *v1.ServiceCatalogAPIServer) (result *v1.ServiceCatalogAPIServer, err error) {
	result = &v1.ServiceCatalogAPIServer{}
	err = c.client.Put().
		Resource("servicecatalogapiservers").
		Name(serviceCatalogAPIServer.Name).
		Body(serviceCatalogAPIServer).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *serviceCatalogAPIServers) UpdateStatus(serviceCatalogAPIServer *v1.ServiceCatalogAPIServer) (result *v1.ServiceCatalogAPIServer, err error) {
	result = &v1.ServiceCatalogAPIServer{}
	err = c.client.Put().
		Resource("servicecatalogapiservers").
		Name(serviceCatalogAPIServer.Name).
		SubResource("status").
		Body(serviceCatalogAPIServer).
		Do().
		Into(result)
	return
}

// Delete takes name of the serviceCatalogAPIServer and deletes it. Returns an error if one occurs.
func (c *serviceCatalogAPIServers) Delete(name string, options *meta_v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("servicecatalogapiservers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceCatalogAPIServers) DeleteCollection(options *meta_v1.DeleteOptions, listOptions meta_v1.ListOptions) error {
	return c.client.Delete().
		Resource("servicecatalogapiservers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched serviceCatalogAPIServer.
func (c *serviceCatalogAPIServers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ServiceCatalogAPIServer, err error) {
	result = &v1.ServiceCatalogAPIServer{}
	err = c.client.Patch(pt).
		Resource("servicecatalogapiservers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
