import * as React from 'react';
import { RouteComponentProps } from 'react-router';
import { getBadgeFromType } from '@console/shared';
import { PipelineModel } from '../../models';
import ProjectListPage from '../projects/ProjectListPage';
import PipelinesResourceList from './PipelinesResourceList';

type PipelinesPageProps = RouteComponentProps<{ ns: string }>;

export const PipelinesPage: React.FC<PipelinesPageProps> = (props) => {
  const {
    match: {
      params: { ns: namespace },
    },
  } = props;
  return namespace ? (
    <PipelinesResourceList
      {...props}
      badge={getBadgeFromType(PipelineModel.badge)}
      namespace={namespace}
      title={PipelineModel.labelPlural}
    />
  ) : (
    <ProjectListPage
      title={PipelineModel.labelPlural}
      badge={getBadgeFromType(PipelineModel.badge)}
    >
      Select a project to view the list of {PipelineModel.labelPlural}
    </ProjectListPage>
  );
};

export default PipelinesPage;
