// Code generated by lister-gen. DO NOT EDIT.

package internalversion

import (
	oauth "github.com/openshift/origin/pkg/oauth/apis/oauth"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// OAuthAuthorizeTokenLister helps list OAuthAuthorizeTokens.
type OAuthAuthorizeTokenLister interface {
	// List lists all OAuthAuthorizeTokens in the indexer.
	List(selector labels.Selector) (ret []*oauth.OAuthAuthorizeToken, err error)
	// Get retrieves the OAuthAuthorizeToken from the index for a given name.
	Get(name string) (*oauth.OAuthAuthorizeToken, error)
	OAuthAuthorizeTokenListerExpansion
}

// oAuthAuthorizeTokenLister implements the OAuthAuthorizeTokenLister interface.
type oAuthAuthorizeTokenLister struct {
	indexer cache.Indexer
}

// NewOAuthAuthorizeTokenLister returns a new OAuthAuthorizeTokenLister.
func NewOAuthAuthorizeTokenLister(indexer cache.Indexer) OAuthAuthorizeTokenLister {
	return &oAuthAuthorizeTokenLister{indexer: indexer}
}

// List lists all OAuthAuthorizeTokens in the indexer.
func (s *oAuthAuthorizeTokenLister) List(selector labels.Selector) (ret []*oauth.OAuthAuthorizeToken, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*oauth.OAuthAuthorizeToken))
	})
	return ret, err
}

// Get retrieves the OAuthAuthorizeToken from the index for a given name.
func (s *oAuthAuthorizeTokenLister) Get(name string) (*oauth.OAuthAuthorizeToken, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(oauth.Resource("oauthauthorizetoken"), name)
	}
	return obj.(*oauth.OAuthAuthorizeToken), nil
}
