// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package apimanagement

import original "github.com/Azure/azure-sdk-for-go/services/apimanagement/mgmt/2016-10-10/apimanagement"

type APIExportClient = original.APIExportClient

func NewAPIExportClient(subscriptionID string) APIExportClient {
	return original.NewAPIExportClient(subscriptionID)
}
func NewAPIExportClientWithBaseURI(baseURI string, subscriptionID string) APIExportClient {
	return original.NewAPIExportClientWithBaseURI(baseURI, subscriptionID)
}

type APIOperationsClient = original.APIOperationsClient

func NewAPIOperationsClient(subscriptionID string) APIOperationsClient {
	return original.NewAPIOperationsClient(subscriptionID)
}
func NewAPIOperationsClientWithBaseURI(baseURI string, subscriptionID string) APIOperationsClient {
	return original.NewAPIOperationsClientWithBaseURI(baseURI, subscriptionID)
}

type APIOperationsPolicyClient = original.APIOperationsPolicyClient

func NewAPIOperationsPolicyClient(subscriptionID string) APIOperationsPolicyClient {
	return original.NewAPIOperationsPolicyClient(subscriptionID)
}
func NewAPIOperationsPolicyClientWithBaseURI(baseURI string, subscriptionID string) APIOperationsPolicyClient {
	return original.NewAPIOperationsPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type APIPolicyClient = original.APIPolicyClient

func NewAPIPolicyClient(subscriptionID string) APIPolicyClient {
	return original.NewAPIPolicyClient(subscriptionID)
}
func NewAPIPolicyClientWithBaseURI(baseURI string, subscriptionID string) APIPolicyClient {
	return original.NewAPIPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type APIProductsClient = original.APIProductsClient

func NewAPIProductsClient(subscriptionID string) APIProductsClient {
	return original.NewAPIProductsClient(subscriptionID)
}
func NewAPIProductsClientWithBaseURI(baseURI string, subscriptionID string) APIProductsClient {
	return original.NewAPIProductsClientWithBaseURI(baseURI, subscriptionID)
}

type ApisClient = original.ApisClient

func NewApisClient(subscriptionID string) ApisClient {
	return original.NewApisClient(subscriptionID)
}
func NewApisClientWithBaseURI(baseURI string, subscriptionID string) ApisClient {
	return original.NewApisClientWithBaseURI(baseURI, subscriptionID)
}

type AuthorizationServersClient = original.AuthorizationServersClient

func NewAuthorizationServersClient(subscriptionID string) AuthorizationServersClient {
	return original.NewAuthorizationServersClient(subscriptionID)
}
func NewAuthorizationServersClientWithBaseURI(baseURI string, subscriptionID string) AuthorizationServersClient {
	return original.NewAuthorizationServersClientWithBaseURI(baseURI, subscriptionID)
}

type BackendsClient = original.BackendsClient

func NewBackendsClient(subscriptionID string) BackendsClient {
	return original.NewBackendsClient(subscriptionID)
}
func NewBackendsClientWithBaseURI(baseURI string, subscriptionID string) BackendsClient {
	return original.NewBackendsClientWithBaseURI(baseURI, subscriptionID)
}

type CertificatesClient = original.CertificatesClient

func NewCertificatesClient(subscriptionID string) CertificatesClient {
	return original.NewCertificatesClient(subscriptionID)
}
func NewCertificatesClientWithBaseURI(baseURI string, subscriptionID string) CertificatesClient {
	return original.NewCertificatesClientWithBaseURI(baseURI, subscriptionID)
}

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}

type GroupsClient = original.GroupsClient

func NewGroupsClient(subscriptionID string) GroupsClient {
	return original.NewGroupsClient(subscriptionID)
}
func NewGroupsClientWithBaseURI(baseURI string, subscriptionID string) GroupsClient {
	return original.NewGroupsClientWithBaseURI(baseURI, subscriptionID)
}

type GroupUsersClient = original.GroupUsersClient

func NewGroupUsersClient(subscriptionID string) GroupUsersClient {
	return original.NewGroupUsersClient(subscriptionID)
}
func NewGroupUsersClientWithBaseURI(baseURI string, subscriptionID string) GroupUsersClient {
	return original.NewGroupUsersClientWithBaseURI(baseURI, subscriptionID)
}

type IdentityProvidersClient = original.IdentityProvidersClient

func NewIdentityProvidersClient(subscriptionID string) IdentityProvidersClient {
	return original.NewIdentityProvidersClient(subscriptionID)
}
func NewIdentityProvidersClientWithBaseURI(baseURI string, subscriptionID string) IdentityProvidersClient {
	return original.NewIdentityProvidersClientWithBaseURI(baseURI, subscriptionID)
}

type LoggersClient = original.LoggersClient

func NewLoggersClient(subscriptionID string) LoggersClient {
	return original.NewLoggersClient(subscriptionID)
}
func NewLoggersClientWithBaseURI(baseURI string, subscriptionID string) LoggersClient {
	return original.NewLoggersClientWithBaseURI(baseURI, subscriptionID)
}

type APIProtocolContract = original.APIProtocolContract

const (
	HTTP  APIProtocolContract = original.HTTP
	HTTPS APIProtocolContract = original.HTTPS
)

type APITypeContract = original.APITypeContract

const (
	APITypeContractHTTP APITypeContract = original.APITypeContractHTTP
	APITypeContractSoap APITypeContract = original.APITypeContractSoap
)

type AsyncOperationState = original.AsyncOperationState

const (
	Failed     AsyncOperationState = original.Failed
	InProgress AsyncOperationState = original.InProgress
	Started    AsyncOperationState = original.Started
	Succeeded  AsyncOperationState = original.Succeeded
)

type BackendProtocol = original.BackendProtocol

const (
	BackendProtocolHTTP BackendProtocol = original.BackendProtocolHTTP
	BackendProtocolSoap BackendProtocol = original.BackendProtocolSoap
)

type BearerTokenSendingMethodsContract = original.BearerTokenSendingMethodsContract

const (
	AuthorizationHeader BearerTokenSendingMethodsContract = original.AuthorizationHeader
	Query               BearerTokenSendingMethodsContract = original.Query
)

type ClientAuthenticationMethodContract = original.ClientAuthenticationMethodContract

const (
	Basic ClientAuthenticationMethodContract = original.Basic
	Body  ClientAuthenticationMethodContract = original.Body
)

type ConnectivityStatusType = original.ConnectivityStatusType

const (
	Failure      ConnectivityStatusType = original.Failure
	Initializing ConnectivityStatusType = original.Initializing
	Success      ConnectivityStatusType = original.Success
)

type GrantTypesContract = original.GrantTypesContract

const (
	AuthorizationCode     GrantTypesContract = original.AuthorizationCode
	ClientCredentials     GrantTypesContract = original.ClientCredentials
	Implicit              GrantTypesContract = original.Implicit
	ResourceOwnerPassword GrantTypesContract = original.ResourceOwnerPassword
)

type GroupTypeContract = original.GroupTypeContract

const (
	Custom   GroupTypeContract = original.Custom
	External GroupTypeContract = original.External
	System   GroupTypeContract = original.System
)

type HostnameType = original.HostnameType

const (
	Management HostnameType = original.Management
	Portal     HostnameType = original.Portal
	Proxy      HostnameType = original.Proxy
	Scm        HostnameType = original.Scm
)

type HTTPStatusCode = original.HTTPStatusCode

const (
	Accepted HTTPStatusCode = original.Accepted
	Conflict HTTPStatusCode = original.Conflict
	Continue HTTPStatusCode = original.Continue
	Created  HTTPStatusCode = original.Created
	NotFound HTTPStatusCode = original.NotFound
	OK       HTTPStatusCode = original.OK
)

type IdentityProviderNameType = original.IdentityProviderNameType

const (
	Aad       IdentityProviderNameType = original.Aad
	AadB2C    IdentityProviderNameType = original.AadB2C
	Facebook  IdentityProviderNameType = original.Facebook
	Google    IdentityProviderNameType = original.Google
	Microsoft IdentityProviderNameType = original.Microsoft
	Twitter   IdentityProviderNameType = original.Twitter
)

type KeyTypeContract = original.KeyTypeContract

const (
	Primary   KeyTypeContract = original.Primary
	Secondary KeyTypeContract = original.Secondary
)

type MethodContract = original.MethodContract

const (
	DELETE  MethodContract = original.DELETE
	GET     MethodContract = original.GET
	HEAD    MethodContract = original.HEAD
	OPTIONS MethodContract = original.OPTIONS
	PATCH   MethodContract = original.PATCH
	POST    MethodContract = original.POST
	PUT     MethodContract = original.PUT
	TRACE   MethodContract = original.TRACE
)

type NameAvailabilityReason = original.NameAvailabilityReason

const (
	AlreadyExists NameAvailabilityReason = original.AlreadyExists
	Invalid       NameAvailabilityReason = original.Invalid
	Valid         NameAvailabilityReason = original.Valid
)

type PolicyScopeContract = original.PolicyScopeContract

const (
	PolicyScopeContractAll       PolicyScopeContract = original.PolicyScopeContractAll
	PolicyScopeContractAPI       PolicyScopeContract = original.PolicyScopeContractAPI
	PolicyScopeContractOperation PolicyScopeContract = original.PolicyScopeContractOperation
	PolicyScopeContractProduct   PolicyScopeContract = original.PolicyScopeContractProduct
	PolicyScopeContractTenant    PolicyScopeContract = original.PolicyScopeContractTenant
)

type ProductStateContract = original.ProductStateContract

const (
	NotPublished ProductStateContract = original.NotPublished
	Published    ProductStateContract = original.Published
)

type ReportsAggregation = original.ReportsAggregation

const (
	ByAPI          ReportsAggregation = original.ByAPI
	ByGeo          ReportsAggregation = original.ByGeo
	ByOperation    ReportsAggregation = original.ByOperation
	ByProduct      ReportsAggregation = original.ByProduct
	BySubscription ReportsAggregation = original.BySubscription
	ByTime         ReportsAggregation = original.ByTime
	ByUser         ReportsAggregation = original.ByUser
)

type SkuType = original.SkuType

const (
	Developer SkuType = original.Developer
	Premium   SkuType = original.Premium
	Standard  SkuType = original.Standard
)

type SubscriptionStateContract = original.SubscriptionStateContract

const (
	Active    SubscriptionStateContract = original.Active
	Cancelled SubscriptionStateContract = original.Cancelled
	Expired   SubscriptionStateContract = original.Expired
	Rejected  SubscriptionStateContract = original.Rejected
	Submitted SubscriptionStateContract = original.Submitted
	Suspended SubscriptionStateContract = original.Suspended
)

type UserStateContract = original.UserStateContract

const (
	UserStateContractActive  UserStateContract = original.UserStateContractActive
	UserStateContractBlocked UserStateContract = original.UserStateContractBlocked
)

type VirtualNetworkType = original.VirtualNetworkType

const (
	VirtualNetworkTypeExternal VirtualNetworkType = original.VirtualNetworkTypeExternal
	VirtualNetworkTypeInternal VirtualNetworkType = original.VirtualNetworkTypeInternal
	VirtualNetworkTypeNone     VirtualNetworkType = original.VirtualNetworkTypeNone
)

type AccessInformationContract = original.AccessInformationContract
type AccessInformationUpdateParameters = original.AccessInformationUpdateParameters
type AdditionalRegion = original.AdditionalRegion
type APICollection = original.APICollection
type APICollectionIterator = original.APICollectionIterator
type APICollectionPage = original.APICollectionPage
type APIContract = original.APIContract
type APIEntityBaseContract = original.APIEntityBaseContract
type APIExportResult = original.APIExportResult
type APIUpdateContract = original.APIUpdateContract
type AuthenticationSettingsContract = original.AuthenticationSettingsContract
type AuthorizationServerCollection = original.AuthorizationServerCollection
type AuthorizationServerCollectionIterator = original.AuthorizationServerCollectionIterator
type AuthorizationServerCollectionPage = original.AuthorizationServerCollectionPage
type BackendAuthorizationHeaderCredentials = original.BackendAuthorizationHeaderCredentials
type BackendBaseParameters = original.BackendBaseParameters
type BackendCollection = original.BackendCollection
type BackendCollectionIterator = original.BackendCollectionIterator
type BackendCollectionPage = original.BackendCollectionPage
type BackendContract = original.BackendContract
type BackendCredentialsContract = original.BackendCredentialsContract
type BackendProperties = original.BackendProperties
type BackendProxyContract = original.BackendProxyContract
type BackendResponse = original.BackendResponse
type BackendUpdateParameters = original.BackendUpdateParameters
type CertificateCollection = original.CertificateCollection
type CertificateCollectionIterator = original.CertificateCollectionIterator
type CertificateCollectionPage = original.CertificateCollectionPage
type CertificateContract = original.CertificateContract
type CertificateCreateOrUpdateParameters = original.CertificateCreateOrUpdateParameters
type CertificateInformation = original.CertificateInformation
type ConnectivityStatusContract = original.ConnectivityStatusContract
type DeployConfigurationParameters = original.DeployConfigurationParameters
type ErrorBodyContract = original.ErrorBodyContract
type ErrorFieldContract = original.ErrorFieldContract
type ErrorResponse = original.ErrorResponse
type GenerateSsoURLResult = original.GenerateSsoURLResult
type GroupCollection = original.GroupCollection
type GroupCollectionIterator = original.GroupCollectionIterator
type GroupCollectionPage = original.GroupCollectionPage
type GroupContract = original.GroupContract
type GroupCreateParameters = original.GroupCreateParameters
type GroupUpdateParameters = original.GroupUpdateParameters
type HostnameConfiguration = original.HostnameConfiguration
type IdentityProviderContract = original.IdentityProviderContract
type IdentityProviderList = original.IdentityProviderList
type IdentityProviderUpdateParameters = original.IdentityProviderUpdateParameters
type LoggerCollection = original.LoggerCollection
type LoggerCollectionIterator = original.LoggerCollectionIterator
type LoggerCollectionPage = original.LoggerCollectionPage
type LoggerCreateParameters = original.LoggerCreateParameters
type LoggerResponse = original.LoggerResponse
type LoggerUpdateParameters = original.LoggerUpdateParameters
type NetworkStatusContract = original.NetworkStatusContract
type OAuth2AuthenticationSettingsContract = original.OAuth2AuthenticationSettingsContract
type OAuth2AuthorizationServerContract = original.OAuth2AuthorizationServerContract
type OAuth2AuthorizationServerUpdateContract = original.OAuth2AuthorizationServerUpdateContract
type OpenIDConnectProviderCollection = original.OpenIDConnectProviderCollection
type OpenIDConnectProviderCollectionIterator = original.OpenIDConnectProviderCollectionIterator
type OpenIDConnectProviderCollectionPage = original.OpenIDConnectProviderCollectionPage
type OpenidConnectProviderContract = original.OpenidConnectProviderContract
type OpenidConnectProviderCreateContract = original.OpenidConnectProviderCreateContract
type OpenidConnectProviderUpdateContract = original.OpenidConnectProviderUpdateContract
type Operation = original.Operation
type OperationCollection = original.OperationCollection
type OperationCollectionIterator = original.OperationCollectionIterator
type OperationCollectionPage = original.OperationCollectionPage
type OperationContract = original.OperationContract
type OperationDisplay = original.OperationDisplay
type OperationEntityBaseContract = original.OperationEntityBaseContract
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationResultContract = original.OperationResultContract
type OperationUpdateContract = original.OperationUpdateContract
type ParameterContract = original.ParameterContract
type PolicySnippetContract = original.PolicySnippetContract
type PolicySnippetsCollection = original.PolicySnippetsCollection
type ProductCollection = original.ProductCollection
type ProductCollectionIterator = original.ProductCollectionIterator
type ProductCollectionPage = original.ProductCollectionPage
type ProductContract = original.ProductContract
type ProductUpdateParameters = original.ProductUpdateParameters
type PropertyCollection = original.PropertyCollection
type PropertyCollectionIterator = original.PropertyCollectionIterator
type PropertyCollectionPage = original.PropertyCollectionPage
type PropertyContract = original.PropertyContract
type PropertyCreateParameters = original.PropertyCreateParameters
type PropertyUpdateParameters = original.PropertyUpdateParameters
type QuotaCounterCollection = original.QuotaCounterCollection
type QuotaCounterContract = original.QuotaCounterContract
type QuotaCounterValueContract = original.QuotaCounterValueContract
type ReadCloser = original.ReadCloser
type RegionContract = original.RegionContract
type RegionListResult = original.RegionListResult
type ReportCollection = original.ReportCollection
type ReportCollectionIterator = original.ReportCollectionIterator
type ReportCollectionPage = original.ReportCollectionPage
type ReportRecordContract = original.ReportRecordContract
type RepresentationContract = original.RepresentationContract
type RequestContract = original.RequestContract
type Resource = original.Resource
type ResultContract = original.ResultContract
type SaveConfigurationParameter = original.SaveConfigurationParameter
type ServiceBackupRestoreParameters = original.ServiceBackupRestoreParameters
type ServiceCheckNameAvailabilityParameters = original.ServiceCheckNameAvailabilityParameters
type ServiceGetSsoTokenResult = original.ServiceGetSsoTokenResult
type ServiceListResult = original.ServiceListResult
type ServiceListResultIterator = original.ServiceListResultIterator
type ServiceListResultPage = original.ServiceListResultPage
type ServiceManageDeploymentsParameters = original.ServiceManageDeploymentsParameters
type ServiceNameAvailabilityResult = original.ServiceNameAvailabilityResult
type ServiceProperties = original.ServiceProperties
type ServiceResource = original.ServiceResource
type ServicesApplyNetworkConfigurationUpdatesFuture = original.ServicesApplyNetworkConfigurationUpdatesFuture
type ServicesBackupFuture = original.ServicesBackupFuture
type ServiceSkuProperties = original.ServiceSkuProperties
type ServicesManageDeploymentsFuture = original.ServicesManageDeploymentsFuture
type ServicesRestoreFuture = original.ServicesRestoreFuture
type ServicesUpdateFuture = original.ServicesUpdateFuture
type ServicesUpdateHostnameFuture = original.ServicesUpdateHostnameFuture
type ServiceUpdateHostnameParameters = original.ServiceUpdateHostnameParameters
type ServiceUpdateParameters = original.ServiceUpdateParameters
type ServiceUploadCertificateParameters = original.ServiceUploadCertificateParameters
type SubscriptionCollection = original.SubscriptionCollection
type SubscriptionCollectionIterator = original.SubscriptionCollectionIterator
type SubscriptionCollectionPage = original.SubscriptionCollectionPage
type SubscriptionContract = original.SubscriptionContract
type SubscriptionCreateParameters = original.SubscriptionCreateParameters
type SubscriptionKeyParameterNamesContract = original.SubscriptionKeyParameterNamesContract
type SubscriptionUpdateParameters = original.SubscriptionUpdateParameters
type TenantConfigurationDeployFuture = original.TenantConfigurationDeployFuture
type TenantConfigurationSaveFuture = original.TenantConfigurationSaveFuture
type TenantConfigurationSyncStateContract = original.TenantConfigurationSyncStateContract
type TenantConfigurationValidateFuture = original.TenantConfigurationValidateFuture
type TokenBodyParameterContract = original.TokenBodyParameterContract
type UserCollection = original.UserCollection
type UserCollectionIterator = original.UserCollectionIterator
type UserCollectionPage = original.UserCollectionPage
type UserContract = original.UserContract
type UserCreateParameters = original.UserCreateParameters
type UserIdentityCollection = original.UserIdentityCollection
type UserIdentityContract = original.UserIdentityContract
type UserTokenParameters = original.UserTokenParameters
type UserTokenResult = original.UserTokenResult
type UserUpdateParameters = original.UserUpdateParameters
type VirtualNetworkConfiguration = original.VirtualNetworkConfiguration
type NetworkStatusClient = original.NetworkStatusClient

func NewNetworkStatusClient(subscriptionID string) NetworkStatusClient {
	return original.NewNetworkStatusClient(subscriptionID)
}
func NewNetworkStatusClientWithBaseURI(baseURI string, subscriptionID string) NetworkStatusClient {
	return original.NewNetworkStatusClientWithBaseURI(baseURI, subscriptionID)
}

type OpenIDConnectProvidersClient = original.OpenIDConnectProvidersClient

func NewOpenIDConnectProvidersClient(subscriptionID string) OpenIDConnectProvidersClient {
	return original.NewOpenIDConnectProvidersClient(subscriptionID)
}
func NewOpenIDConnectProvidersClientWithBaseURI(baseURI string, subscriptionID string) OpenIDConnectProvidersClient {
	return original.NewOpenIDConnectProvidersClientWithBaseURI(baseURI, subscriptionID)
}

type OperationsClient = original.OperationsClient

func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}

type PolicySnippetsClient = original.PolicySnippetsClient

func NewPolicySnippetsClient(subscriptionID string) PolicySnippetsClient {
	return original.NewPolicySnippetsClient(subscriptionID)
}
func NewPolicySnippetsClientWithBaseURI(baseURI string, subscriptionID string) PolicySnippetsClient {
	return original.NewPolicySnippetsClientWithBaseURI(baseURI, subscriptionID)
}

type ProductApisClient = original.ProductApisClient

func NewProductApisClient(subscriptionID string) ProductApisClient {
	return original.NewProductApisClient(subscriptionID)
}
func NewProductApisClientWithBaseURI(baseURI string, subscriptionID string) ProductApisClient {
	return original.NewProductApisClientWithBaseURI(baseURI, subscriptionID)
}

type ProductGroupsClient = original.ProductGroupsClient

func NewProductGroupsClient(subscriptionID string) ProductGroupsClient {
	return original.NewProductGroupsClient(subscriptionID)
}
func NewProductGroupsClientWithBaseURI(baseURI string, subscriptionID string) ProductGroupsClient {
	return original.NewProductGroupsClientWithBaseURI(baseURI, subscriptionID)
}

type ProductPolicyClient = original.ProductPolicyClient

func NewProductPolicyClient(subscriptionID string) ProductPolicyClient {
	return original.NewProductPolicyClient(subscriptionID)
}
func NewProductPolicyClientWithBaseURI(baseURI string, subscriptionID string) ProductPolicyClient {
	return original.NewProductPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type ProductsClient = original.ProductsClient

func NewProductsClient(subscriptionID string) ProductsClient {
	return original.NewProductsClient(subscriptionID)
}
func NewProductsClientWithBaseURI(baseURI string, subscriptionID string) ProductsClient {
	return original.NewProductsClientWithBaseURI(baseURI, subscriptionID)
}

type ProductSubscriptionsClient = original.ProductSubscriptionsClient

func NewProductSubscriptionsClient(subscriptionID string) ProductSubscriptionsClient {
	return original.NewProductSubscriptionsClient(subscriptionID)
}
func NewProductSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) ProductSubscriptionsClient {
	return original.NewProductSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}

type PropertiesClient = original.PropertiesClient

func NewPropertiesClient(subscriptionID string) PropertiesClient {
	return original.NewPropertiesClient(subscriptionID)
}
func NewPropertiesClientWithBaseURI(baseURI string, subscriptionID string) PropertiesClient {
	return original.NewPropertiesClientWithBaseURI(baseURI, subscriptionID)
}

type PropertyClient = original.PropertyClient

func NewPropertyClient(subscriptionID string) PropertyClient {
	return original.NewPropertyClient(subscriptionID)
}
func NewPropertyClientWithBaseURI(baseURI string, subscriptionID string) PropertyClient {
	return original.NewPropertyClientWithBaseURI(baseURI, subscriptionID)
}

type QuotaByCounterKeysClient = original.QuotaByCounterKeysClient

func NewQuotaByCounterKeysClient(subscriptionID string) QuotaByCounterKeysClient {
	return original.NewQuotaByCounterKeysClient(subscriptionID)
}
func NewQuotaByCounterKeysClientWithBaseURI(baseURI string, subscriptionID string) QuotaByCounterKeysClient {
	return original.NewQuotaByCounterKeysClientWithBaseURI(baseURI, subscriptionID)
}

type QuotaByPeriodKeysClient = original.QuotaByPeriodKeysClient

func NewQuotaByPeriodKeysClient(subscriptionID string) QuotaByPeriodKeysClient {
	return original.NewQuotaByPeriodKeysClient(subscriptionID)
}
func NewQuotaByPeriodKeysClientWithBaseURI(baseURI string, subscriptionID string) QuotaByPeriodKeysClient {
	return original.NewQuotaByPeriodKeysClientWithBaseURI(baseURI, subscriptionID)
}

type RegionsClient = original.RegionsClient

func NewRegionsClient(subscriptionID string) RegionsClient {
	return original.NewRegionsClient(subscriptionID)
}
func NewRegionsClientWithBaseURI(baseURI string, subscriptionID string) RegionsClient {
	return original.NewRegionsClientWithBaseURI(baseURI, subscriptionID)
}

type ReportsClient = original.ReportsClient

func NewReportsClient(subscriptionID string) ReportsClient {
	return original.NewReportsClient(subscriptionID)
}
func NewReportsClientWithBaseURI(baseURI string, subscriptionID string) ReportsClient {
	return original.NewReportsClientWithBaseURI(baseURI, subscriptionID)
}

type ServicesClient = original.ServicesClient

func NewServicesClient(subscriptionID string) ServicesClient {
	return original.NewServicesClient(subscriptionID)
}
func NewServicesClientWithBaseURI(baseURI string, subscriptionID string) ServicesClient {
	return original.NewServicesClientWithBaseURI(baseURI, subscriptionID)
}

type SubscriptionsClient = original.SubscriptionsClient

func NewSubscriptionsClient(subscriptionID string) SubscriptionsClient {
	return original.NewSubscriptionsClient(subscriptionID)
}
func NewSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionsClient {
	return original.NewSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}

type TenantAccessClient = original.TenantAccessClient

func NewTenantAccessClient(subscriptionID string) TenantAccessClient {
	return original.NewTenantAccessClient(subscriptionID)
}
func NewTenantAccessClientWithBaseURI(baseURI string, subscriptionID string) TenantAccessClient {
	return original.NewTenantAccessClientWithBaseURI(baseURI, subscriptionID)
}

type TenantAccessGitClient = original.TenantAccessGitClient

func NewTenantAccessGitClient(subscriptionID string) TenantAccessGitClient {
	return original.NewTenantAccessGitClient(subscriptionID)
}
func NewTenantAccessGitClientWithBaseURI(baseURI string, subscriptionID string) TenantAccessGitClient {
	return original.NewTenantAccessGitClientWithBaseURI(baseURI, subscriptionID)
}

type TenantConfigurationClient = original.TenantConfigurationClient

func NewTenantConfigurationClient(subscriptionID string) TenantConfigurationClient {
	return original.NewTenantConfigurationClient(subscriptionID)
}
func NewTenantConfigurationClientWithBaseURI(baseURI string, subscriptionID string) TenantConfigurationClient {
	return original.NewTenantConfigurationClientWithBaseURI(baseURI, subscriptionID)
}

type TenantConfigurationSyncStateClient = original.TenantConfigurationSyncStateClient

func NewTenantConfigurationSyncStateClient(subscriptionID string) TenantConfigurationSyncStateClient {
	return original.NewTenantConfigurationSyncStateClient(subscriptionID)
}
func NewTenantConfigurationSyncStateClientWithBaseURI(baseURI string, subscriptionID string) TenantConfigurationSyncStateClient {
	return original.NewTenantConfigurationSyncStateClientWithBaseURI(baseURI, subscriptionID)
}

type TenantPolicyClient = original.TenantPolicyClient

func NewTenantPolicyClient(subscriptionID string) TenantPolicyClient {
	return original.NewTenantPolicyClient(subscriptionID)
}
func NewTenantPolicyClientWithBaseURI(baseURI string, subscriptionID string) TenantPolicyClient {
	return original.NewTenantPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type UserGroupsClient = original.UserGroupsClient

func NewUserGroupsClient(subscriptionID string) UserGroupsClient {
	return original.NewUserGroupsClient(subscriptionID)
}
func NewUserGroupsClientWithBaseURI(baseURI string, subscriptionID string) UserGroupsClient {
	return original.NewUserGroupsClientWithBaseURI(baseURI, subscriptionID)
}

type UserIdentitiesClient = original.UserIdentitiesClient

func NewUserIdentitiesClient(subscriptionID string) UserIdentitiesClient {
	return original.NewUserIdentitiesClient(subscriptionID)
}
func NewUserIdentitiesClientWithBaseURI(baseURI string, subscriptionID string) UserIdentitiesClient {
	return original.NewUserIdentitiesClientWithBaseURI(baseURI, subscriptionID)
}

type UsersClient = original.UsersClient

func NewUsersClient(subscriptionID string) UsersClient {
	return original.NewUsersClient(subscriptionID)
}
func NewUsersClientWithBaseURI(baseURI string, subscriptionID string) UsersClient {
	return original.NewUsersClientWithBaseURI(baseURI, subscriptionID)
}

type UserSubscriptionsClient = original.UserSubscriptionsClient

func NewUserSubscriptionsClient(subscriptionID string) UserSubscriptionsClient {
	return original.NewUserSubscriptionsClient(subscriptionID)
}
func NewUserSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) UserSubscriptionsClient {
	return original.NewUserSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
