// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package subscription

import original "github.com/Azure/azure-sdk-for-go/services/preview/subscription/mgmt/2018-03-01-preview/subscription"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient

func New() BaseClient {
	return original.New()
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}

type FactoryClient = original.FactoryClient

func NewFactoryClient() FactoryClient {
	return original.NewFactoryClient()
}
func NewFactoryClientWithBaseURI(baseURI string) FactoryClient {
	return original.NewFactoryClientWithBaseURI(baseURI)
}

type OfferType = original.OfferType

const (
	MSAZR0017P OfferType = original.MSAZR0017P
	MSAZR0148P OfferType = original.MSAZR0148P
)

func PossibleOfferTypeValues() []OfferType {
	return original.PossibleOfferTypeValues()
}

type AdPrincipal = original.AdPrincipal
type CreationParameters = original.CreationParameters
type CreationResult = original.CreationResult
type ErrorResponse = original.ErrorResponse
type FactoryCreateSubscriptionInEnrollmentAccountFuture = original.FactoryCreateSubscriptionInEnrollmentAccountFuture
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultType = original.OperationListResultType
type OperationType = original.OperationType
type OperationsClient = original.OperationsClient

func NewOperationsClient() OperationsClient {
	return original.NewOperationsClient()
}
func NewOperationsClientWithBaseURI(baseURI string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI)
}

type OperationsGroupClient = original.OperationsGroupClient

func NewOperationsGroupClient() OperationsGroupClient {
	return original.NewOperationsGroupClient()
}
func NewOperationsGroupClientWithBaseURI(baseURI string) OperationsGroupClient {
	return original.NewOperationsGroupClientWithBaseURI(baseURI)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
