// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package sql

import original "github.com/Azure/azure-sdk-for-go/services/sql/mgmt/2017-03-01-preview/sql"

type BackupLongTermRetentionPoliciesClient = original.BackupLongTermRetentionPoliciesClient

func NewBackupLongTermRetentionPoliciesClient(subscriptionID string) BackupLongTermRetentionPoliciesClient {
	return original.NewBackupLongTermRetentionPoliciesClient(subscriptionID)
}
func NewBackupLongTermRetentionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) BackupLongTermRetentionPoliciesClient {
	return original.NewBackupLongTermRetentionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}

type BackupLongTermRetentionVaultsClient = original.BackupLongTermRetentionVaultsClient

func NewBackupLongTermRetentionVaultsClient(subscriptionID string) BackupLongTermRetentionVaultsClient {
	return original.NewBackupLongTermRetentionVaultsClient(subscriptionID)
}
func NewBackupLongTermRetentionVaultsClientWithBaseURI(baseURI string, subscriptionID string) BackupLongTermRetentionVaultsClient {
	return original.NewBackupLongTermRetentionVaultsClientWithBaseURI(baseURI, subscriptionID)
}

type CapabilitiesClient = original.CapabilitiesClient

func NewCapabilitiesClient(subscriptionID string) CapabilitiesClient {
	return original.NewCapabilitiesClient(subscriptionID)
}
func NewCapabilitiesClientWithBaseURI(baseURI string, subscriptionID string) CapabilitiesClient {
	return original.NewCapabilitiesClientWithBaseURI(baseURI, subscriptionID)
}

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}

type DatabaseAutomaticTuningClient = original.DatabaseAutomaticTuningClient

func NewDatabaseAutomaticTuningClient(subscriptionID string) DatabaseAutomaticTuningClient {
	return original.NewDatabaseAutomaticTuningClient(subscriptionID)
}
func NewDatabaseAutomaticTuningClientWithBaseURI(baseURI string, subscriptionID string) DatabaseAutomaticTuningClient {
	return original.NewDatabaseAutomaticTuningClientWithBaseURI(baseURI, subscriptionID)
}

type DatabaseBlobAuditingPoliciesClient = original.DatabaseBlobAuditingPoliciesClient

func NewDatabaseBlobAuditingPoliciesClient(subscriptionID string) DatabaseBlobAuditingPoliciesClient {
	return original.NewDatabaseBlobAuditingPoliciesClient(subscriptionID)
}
func NewDatabaseBlobAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseBlobAuditingPoliciesClient {
	return original.NewDatabaseBlobAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}

type DatabaseOperationsClient = original.DatabaseOperationsClient

func NewDatabaseOperationsClient(subscriptionID string) DatabaseOperationsClient {
	return original.NewDatabaseOperationsClient(subscriptionID)
}
func NewDatabaseOperationsClientWithBaseURI(baseURI string, subscriptionID string) DatabaseOperationsClient {
	return original.NewDatabaseOperationsClientWithBaseURI(baseURI, subscriptionID)
}

type DatabasesClient = original.DatabasesClient

func NewDatabasesClient(subscriptionID string) DatabasesClient {
	return original.NewDatabasesClient(subscriptionID)
}
func NewDatabasesClientWithBaseURI(baseURI string, subscriptionID string) DatabasesClient {
	return original.NewDatabasesClientWithBaseURI(baseURI, subscriptionID)
}

type DatabaseThreatDetectionPoliciesClient = original.DatabaseThreatDetectionPoliciesClient

func NewDatabaseThreatDetectionPoliciesClient(subscriptionID string) DatabaseThreatDetectionPoliciesClient {
	return original.NewDatabaseThreatDetectionPoliciesClient(subscriptionID)
}
func NewDatabaseThreatDetectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseThreatDetectionPoliciesClient {
	return original.NewDatabaseThreatDetectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}

type DatabaseUsagesClient = original.DatabaseUsagesClient

func NewDatabaseUsagesClient(subscriptionID string) DatabaseUsagesClient {
	return original.NewDatabaseUsagesClient(subscriptionID)
}
func NewDatabaseUsagesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseUsagesClient {
	return original.NewDatabaseUsagesClientWithBaseURI(baseURI, subscriptionID)
}

type DataMaskingPoliciesClient = original.DataMaskingPoliciesClient

func NewDataMaskingPoliciesClient(subscriptionID string) DataMaskingPoliciesClient {
	return original.NewDataMaskingPoliciesClient(subscriptionID)
}
func NewDataMaskingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DataMaskingPoliciesClient {
	return original.NewDataMaskingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}

type DataMaskingRulesClient = original.DataMaskingRulesClient

func NewDataMaskingRulesClient(subscriptionID string) DataMaskingRulesClient {
	return original.NewDataMaskingRulesClient(subscriptionID)
}
func NewDataMaskingRulesClientWithBaseURI(baseURI string, subscriptionID string) DataMaskingRulesClient {
	return original.NewDataMaskingRulesClientWithBaseURI(baseURI, subscriptionID)
}

type ElasticPoolActivitiesClient = original.ElasticPoolActivitiesClient

func NewElasticPoolActivitiesClient(subscriptionID string) ElasticPoolActivitiesClient {
	return original.NewElasticPoolActivitiesClient(subscriptionID)
}
func NewElasticPoolActivitiesClientWithBaseURI(baseURI string, subscriptionID string) ElasticPoolActivitiesClient {
	return original.NewElasticPoolActivitiesClientWithBaseURI(baseURI, subscriptionID)
}

type ElasticPoolDatabaseActivitiesClient = original.ElasticPoolDatabaseActivitiesClient

func NewElasticPoolDatabaseActivitiesClient(subscriptionID string) ElasticPoolDatabaseActivitiesClient {
	return original.NewElasticPoolDatabaseActivitiesClient(subscriptionID)
}
func NewElasticPoolDatabaseActivitiesClientWithBaseURI(baseURI string, subscriptionID string) ElasticPoolDatabaseActivitiesClient {
	return original.NewElasticPoolDatabaseActivitiesClientWithBaseURI(baseURI, subscriptionID)
}

type ElasticPoolsClient = original.ElasticPoolsClient

func NewElasticPoolsClient(subscriptionID string) ElasticPoolsClient {
	return original.NewElasticPoolsClient(subscriptionID)
}
func NewElasticPoolsClientWithBaseURI(baseURI string, subscriptionID string) ElasticPoolsClient {
	return original.NewElasticPoolsClientWithBaseURI(baseURI, subscriptionID)
}

type EncryptionProtectorsClient = original.EncryptionProtectorsClient

func NewEncryptionProtectorsClient(subscriptionID string) EncryptionProtectorsClient {
	return original.NewEncryptionProtectorsClient(subscriptionID)
}
func NewEncryptionProtectorsClientWithBaseURI(baseURI string, subscriptionID string) EncryptionProtectorsClient {
	return original.NewEncryptionProtectorsClientWithBaseURI(baseURI, subscriptionID)
}

type FailoverGroupsClient = original.FailoverGroupsClient

func NewFailoverGroupsClient(subscriptionID string) FailoverGroupsClient {
	return original.NewFailoverGroupsClient(subscriptionID)
}
func NewFailoverGroupsClientWithBaseURI(baseURI string, subscriptionID string) FailoverGroupsClient {
	return original.NewFailoverGroupsClientWithBaseURI(baseURI, subscriptionID)
}

type FirewallRulesClient = original.FirewallRulesClient

func NewFirewallRulesClient(subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClient(subscriptionID)
}
func NewFirewallRulesClientWithBaseURI(baseURI string, subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClientWithBaseURI(baseURI, subscriptionID)
}

type GeoBackupPoliciesClient = original.GeoBackupPoliciesClient

func NewGeoBackupPoliciesClient(subscriptionID string) GeoBackupPoliciesClient {
	return original.NewGeoBackupPoliciesClient(subscriptionID)
}
func NewGeoBackupPoliciesClientWithBaseURI(baseURI string, subscriptionID string) GeoBackupPoliciesClient {
	return original.NewGeoBackupPoliciesClientWithBaseURI(baseURI, subscriptionID)
}

type AuthenticationType = original.AuthenticationType

const (
	ADPassword AuthenticationType = original.ADPassword
	SQL        AuthenticationType = original.SQL
)

type AutomaticTuningDisabledReason = original.AutomaticTuningDisabledReason

const (
	AutoConfigured      AutomaticTuningDisabledReason = original.AutoConfigured
	Default             AutomaticTuningDisabledReason = original.Default
	Disabled            AutomaticTuningDisabledReason = original.Disabled
	InheritedFromServer AutomaticTuningDisabledReason = original.InheritedFromServer
	NotSupported        AutomaticTuningDisabledReason = original.NotSupported
	QueryStoreOff       AutomaticTuningDisabledReason = original.QueryStoreOff
	QueryStoreReadOnly  AutomaticTuningDisabledReason = original.QueryStoreReadOnly
)

type AutomaticTuningMode = original.AutomaticTuningMode

const (
	Auto        AutomaticTuningMode = original.Auto
	Custom      AutomaticTuningMode = original.Custom
	Inherit     AutomaticTuningMode = original.Inherit
	Unspecified AutomaticTuningMode = original.Unspecified
)

type AutomaticTuningOptionModeActual = original.AutomaticTuningOptionModeActual

const (
	Off AutomaticTuningOptionModeActual = original.Off
	On  AutomaticTuningOptionModeActual = original.On
)

type AutomaticTuningOptionModeDesired = original.AutomaticTuningOptionModeDesired

const (
	AutomaticTuningOptionModeDesiredDefault AutomaticTuningOptionModeDesired = original.AutomaticTuningOptionModeDesiredDefault
	AutomaticTuningOptionModeDesiredOff     AutomaticTuningOptionModeDesired = original.AutomaticTuningOptionModeDesiredOff
	AutomaticTuningOptionModeDesiredOn      AutomaticTuningOptionModeDesired = original.AutomaticTuningOptionModeDesiredOn
)

type AutomaticTuningServerMode = original.AutomaticTuningServerMode

const (
	AutomaticTuningServerModeAuto        AutomaticTuningServerMode = original.AutomaticTuningServerModeAuto
	AutomaticTuningServerModeCustom      AutomaticTuningServerMode = original.AutomaticTuningServerModeCustom
	AutomaticTuningServerModeUnspecified AutomaticTuningServerMode = original.AutomaticTuningServerModeUnspecified
)

type AutomaticTuningServerReason = original.AutomaticTuningServerReason

const (
	AutomaticTuningServerReasonAutoConfigured AutomaticTuningServerReason = original.AutomaticTuningServerReasonAutoConfigured
	AutomaticTuningServerReasonDefault        AutomaticTuningServerReason = original.AutomaticTuningServerReasonDefault
	AutomaticTuningServerReasonDisabled       AutomaticTuningServerReason = original.AutomaticTuningServerReasonDisabled
)

type BackupLongTermRetentionPolicyState = original.BackupLongTermRetentionPolicyState

const (
	BackupLongTermRetentionPolicyStateDisabled BackupLongTermRetentionPolicyState = original.BackupLongTermRetentionPolicyStateDisabled
	BackupLongTermRetentionPolicyStateEnabled  BackupLongTermRetentionPolicyState = original.BackupLongTermRetentionPolicyStateEnabled
)

type BlobAuditingPolicyState = original.BlobAuditingPolicyState

const (
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = original.BlobAuditingPolicyStateDisabled
	BlobAuditingPolicyStateEnabled  BlobAuditingPolicyState = original.BlobAuditingPolicyStateEnabled
)

type CapabilityStatus = original.CapabilityStatus

const (
	CapabilityStatusAvailable CapabilityStatus = original.CapabilityStatusAvailable
	CapabilityStatusDefault   CapabilityStatus = original.CapabilityStatusDefault
	CapabilityStatusDisabled  CapabilityStatus = original.CapabilityStatusDisabled
	CapabilityStatusVisible   CapabilityStatus = original.CapabilityStatusVisible
)

type CheckNameAvailabilityReason = original.CheckNameAvailabilityReason

const (
	AlreadyExists CheckNameAvailabilityReason = original.AlreadyExists
	Invalid       CheckNameAvailabilityReason = original.Invalid
)

type CreateMode = original.CreateMode

const (
	CreateModeCopy                           CreateMode = original.CreateModeCopy
	CreateModeDefault                        CreateMode = original.CreateModeDefault
	CreateModeNonReadableSecondary           CreateMode = original.CreateModeNonReadableSecondary
	CreateModeOnlineSecondary                CreateMode = original.CreateModeOnlineSecondary
	CreateModePointInTimeRestore             CreateMode = original.CreateModePointInTimeRestore
	CreateModeRecovery                       CreateMode = original.CreateModeRecovery
	CreateModeRestore                        CreateMode = original.CreateModeRestore
	CreateModeRestoreLongTermRetentionBackup CreateMode = original.CreateModeRestoreLongTermRetentionBackup
)

type DatabaseEdition = original.DatabaseEdition

const (
	Basic         DatabaseEdition = original.Basic
	Business      DatabaseEdition = original.Business
	DataWarehouse DatabaseEdition = original.DataWarehouse
	Free          DatabaseEdition = original.Free
	Premium       DatabaseEdition = original.Premium
	PremiumRS     DatabaseEdition = original.PremiumRS
	Standard      DatabaseEdition = original.Standard
	Stretch       DatabaseEdition = original.Stretch
	System        DatabaseEdition = original.System
	System2       DatabaseEdition = original.System2
	Web           DatabaseEdition = original.Web
)

type DataMaskingFunction = original.DataMaskingFunction

const (
	DataMaskingFunctionCCN     DataMaskingFunction = original.DataMaskingFunctionCCN
	DataMaskingFunctionDefault DataMaskingFunction = original.DataMaskingFunctionDefault
	DataMaskingFunctionEmail   DataMaskingFunction = original.DataMaskingFunctionEmail
	DataMaskingFunctionNumber  DataMaskingFunction = original.DataMaskingFunctionNumber
	DataMaskingFunctionSSN     DataMaskingFunction = original.DataMaskingFunctionSSN
	DataMaskingFunctionText    DataMaskingFunction = original.DataMaskingFunctionText
)

type DataMaskingRuleState = original.DataMaskingRuleState

const (
	DataMaskingRuleStateDisabled DataMaskingRuleState = original.DataMaskingRuleStateDisabled
	DataMaskingRuleStateEnabled  DataMaskingRuleState = original.DataMaskingRuleStateEnabled
)

type DataMaskingState = original.DataMaskingState

const (
	DataMaskingStateDisabled DataMaskingState = original.DataMaskingStateDisabled
	DataMaskingStateEnabled  DataMaskingState = original.DataMaskingStateEnabled
)

type ElasticPoolEdition = original.ElasticPoolEdition

const (
	ElasticPoolEditionBasic    ElasticPoolEdition = original.ElasticPoolEditionBasic
	ElasticPoolEditionPremium  ElasticPoolEdition = original.ElasticPoolEditionPremium
	ElasticPoolEditionStandard ElasticPoolEdition = original.ElasticPoolEditionStandard
)

type ElasticPoolState = original.ElasticPoolState

const (
	ElasticPoolStateCreating ElasticPoolState = original.ElasticPoolStateCreating
	ElasticPoolStateDisabled ElasticPoolState = original.ElasticPoolStateDisabled
	ElasticPoolStateReady    ElasticPoolState = original.ElasticPoolStateReady
)

type FailoverGroupReplicationRole = original.FailoverGroupReplicationRole

const (
	Primary   FailoverGroupReplicationRole = original.Primary
	Secondary FailoverGroupReplicationRole = original.Secondary
)

type GeoBackupPolicyState = original.GeoBackupPolicyState

const (
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = original.GeoBackupPolicyStateDisabled
	GeoBackupPolicyStateEnabled  GeoBackupPolicyState = original.GeoBackupPolicyStateEnabled
)

type IdentityType = original.IdentityType

const (
	SystemAssigned IdentityType = original.SystemAssigned
)

type ManagementOperationState = original.ManagementOperationState

const (
	CancelInProgress ManagementOperationState = original.CancelInProgress
	Cancelled        ManagementOperationState = original.Cancelled
	Failed           ManagementOperationState = original.Failed
	InProgress       ManagementOperationState = original.InProgress
	Pending          ManagementOperationState = original.Pending
	Succeeded        ManagementOperationState = original.Succeeded
)

type MaxSizeUnits = original.MaxSizeUnits

const (
	Gigabytes MaxSizeUnits = original.Gigabytes
	Megabytes MaxSizeUnits = original.Megabytes
	Petabytes MaxSizeUnits = original.Petabytes
	Terabytes MaxSizeUnits = original.Terabytes
)

type OperationOrigin = original.OperationOrigin

const (
	OperationOriginSystem OperationOrigin = original.OperationOriginSystem
	OperationOriginUser   OperationOrigin = original.OperationOriginUser
)

type PerformanceLevelUnit = original.PerformanceLevelUnit

const (
	DTU PerformanceLevelUnit = original.DTU
)

type PrimaryAggregationType = original.PrimaryAggregationType

const (
	Average PrimaryAggregationType = original.Average
	Count   PrimaryAggregationType = original.Count
	Maximum PrimaryAggregationType = original.Maximum
	Minimum PrimaryAggregationType = original.Minimum
	None    PrimaryAggregationType = original.None
	Total   PrimaryAggregationType = original.Total
)

type ReadOnlyEndpointFailoverPolicy = original.ReadOnlyEndpointFailoverPolicy

const (
	ReadOnlyEndpointFailoverPolicyDisabled ReadOnlyEndpointFailoverPolicy = original.ReadOnlyEndpointFailoverPolicyDisabled
	ReadOnlyEndpointFailoverPolicyEnabled  ReadOnlyEndpointFailoverPolicy = original.ReadOnlyEndpointFailoverPolicyEnabled
)

type ReadScale = original.ReadScale

const (
	ReadScaleDisabled ReadScale = original.ReadScaleDisabled
	ReadScaleEnabled  ReadScale = original.ReadScaleEnabled
)

type ReadWriteEndpointFailoverPolicy = original.ReadWriteEndpointFailoverPolicy

const (
	Automatic ReadWriteEndpointFailoverPolicy = original.Automatic
	Manual    ReadWriteEndpointFailoverPolicy = original.Manual
)

type RecommendedIndexAction = original.RecommendedIndexAction

const (
	Create  RecommendedIndexAction = original.Create
	Drop    RecommendedIndexAction = original.Drop
	Rebuild RecommendedIndexAction = original.Rebuild
)

type RecommendedIndexState = original.RecommendedIndexState

const (
	RecommendedIndexStateActive        RecommendedIndexState = original.RecommendedIndexStateActive
	RecommendedIndexStateBlocked       RecommendedIndexState = original.RecommendedIndexStateBlocked
	RecommendedIndexStateExecuting     RecommendedIndexState = original.RecommendedIndexStateExecuting
	RecommendedIndexStateExpired       RecommendedIndexState = original.RecommendedIndexStateExpired
	RecommendedIndexStateIgnored       RecommendedIndexState = original.RecommendedIndexStateIgnored
	RecommendedIndexStatePending       RecommendedIndexState = original.RecommendedIndexStatePending
	RecommendedIndexStatePendingRevert RecommendedIndexState = original.RecommendedIndexStatePendingRevert
	RecommendedIndexStateReverted      RecommendedIndexState = original.RecommendedIndexStateReverted
	RecommendedIndexStateReverting     RecommendedIndexState = original.RecommendedIndexStateReverting
	RecommendedIndexStateSuccess       RecommendedIndexState = original.RecommendedIndexStateSuccess
	RecommendedIndexStateVerifying     RecommendedIndexState = original.RecommendedIndexStateVerifying
)

type RecommendedIndexType = original.RecommendedIndexType

const (
	CLUSTERED            RecommendedIndexType = original.CLUSTERED
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = original.CLUSTEREDCOLUMNSTORE
	COLUMNSTORE          RecommendedIndexType = original.COLUMNSTORE
	NONCLUSTERED         RecommendedIndexType = original.NONCLUSTERED
)

type ReplicationRole = original.ReplicationRole

const (
	ReplicationRoleCopy                 ReplicationRole = original.ReplicationRoleCopy
	ReplicationRoleNonReadableSecondary ReplicationRole = original.ReplicationRoleNonReadableSecondary
	ReplicationRolePrimary              ReplicationRole = original.ReplicationRolePrimary
	ReplicationRoleSecondary            ReplicationRole = original.ReplicationRoleSecondary
	ReplicationRoleSource               ReplicationRole = original.ReplicationRoleSource
)

type ReplicationState = original.ReplicationState

const (
	CATCHUP   ReplicationState = original.CATCHUP
	PENDING   ReplicationState = original.PENDING
	SEEDING   ReplicationState = original.SEEDING
	SUSPENDED ReplicationState = original.SUSPENDED
)

type RestorePointType = original.RestorePointType

const (
	CONTINUOUS RestorePointType = original.CONTINUOUS
	DISCRETE   RestorePointType = original.DISCRETE
)

type SampleName = original.SampleName

const (
	AdventureWorksLT SampleName = original.AdventureWorksLT
)

type SecurityAlertPolicyEmailAccountAdmins = original.SecurityAlertPolicyEmailAccountAdmins

const (
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = original.SecurityAlertPolicyEmailAccountAdminsDisabled
	SecurityAlertPolicyEmailAccountAdminsEnabled  SecurityAlertPolicyEmailAccountAdmins = original.SecurityAlertPolicyEmailAccountAdminsEnabled
)

type SecurityAlertPolicyState = original.SecurityAlertPolicyState

const (
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = original.SecurityAlertPolicyStateDisabled
	SecurityAlertPolicyStateEnabled  SecurityAlertPolicyState = original.SecurityAlertPolicyStateEnabled
	SecurityAlertPolicyStateNew      SecurityAlertPolicyState = original.SecurityAlertPolicyStateNew
)

type SecurityAlertPolicyUseServerDefault = original.SecurityAlertPolicyUseServerDefault

const (
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = original.SecurityAlertPolicyUseServerDefaultDisabled
	SecurityAlertPolicyUseServerDefaultEnabled  SecurityAlertPolicyUseServerDefault = original.SecurityAlertPolicyUseServerDefaultEnabled
)

type ServerConnectionType = original.ServerConnectionType

const (
	ServerConnectionTypeDefault  ServerConnectionType = original.ServerConnectionTypeDefault
	ServerConnectionTypeProxy    ServerConnectionType = original.ServerConnectionTypeProxy
	ServerConnectionTypeRedirect ServerConnectionType = original.ServerConnectionTypeRedirect
)

type ServerKeyType = original.ServerKeyType

const (
	AzureKeyVault  ServerKeyType = original.AzureKeyVault
	ServiceManaged ServerKeyType = original.ServiceManaged
)

type ServiceObjectiveName = original.ServiceObjectiveName

const (
	ServiceObjectiveNameBasic       ServiceObjectiveName = original.ServiceObjectiveNameBasic
	ServiceObjectiveNameDS100       ServiceObjectiveName = original.ServiceObjectiveNameDS100
	ServiceObjectiveNameDS1000      ServiceObjectiveName = original.ServiceObjectiveNameDS1000
	ServiceObjectiveNameDS1200      ServiceObjectiveName = original.ServiceObjectiveNameDS1200
	ServiceObjectiveNameDS1500      ServiceObjectiveName = original.ServiceObjectiveNameDS1500
	ServiceObjectiveNameDS200       ServiceObjectiveName = original.ServiceObjectiveNameDS200
	ServiceObjectiveNameDS2000      ServiceObjectiveName = original.ServiceObjectiveNameDS2000
	ServiceObjectiveNameDS300       ServiceObjectiveName = original.ServiceObjectiveNameDS300
	ServiceObjectiveNameDS400       ServiceObjectiveName = original.ServiceObjectiveNameDS400
	ServiceObjectiveNameDS500       ServiceObjectiveName = original.ServiceObjectiveNameDS500
	ServiceObjectiveNameDS600       ServiceObjectiveName = original.ServiceObjectiveNameDS600
	ServiceObjectiveNameDW100       ServiceObjectiveName = original.ServiceObjectiveNameDW100
	ServiceObjectiveNameDW1000      ServiceObjectiveName = original.ServiceObjectiveNameDW1000
	ServiceObjectiveNameDW10000c    ServiceObjectiveName = original.ServiceObjectiveNameDW10000c
	ServiceObjectiveNameDW1000c     ServiceObjectiveName = original.ServiceObjectiveNameDW1000c
	ServiceObjectiveNameDW1200      ServiceObjectiveName = original.ServiceObjectiveNameDW1200
	ServiceObjectiveNameDW1500      ServiceObjectiveName = original.ServiceObjectiveNameDW1500
	ServiceObjectiveNameDW15000c    ServiceObjectiveName = original.ServiceObjectiveNameDW15000c
	ServiceObjectiveNameDW1500c     ServiceObjectiveName = original.ServiceObjectiveNameDW1500c
	ServiceObjectiveNameDW200       ServiceObjectiveName = original.ServiceObjectiveNameDW200
	ServiceObjectiveNameDW2000      ServiceObjectiveName = original.ServiceObjectiveNameDW2000
	ServiceObjectiveNameDW2000c     ServiceObjectiveName = original.ServiceObjectiveNameDW2000c
	ServiceObjectiveNameDW2500c     ServiceObjectiveName = original.ServiceObjectiveNameDW2500c
	ServiceObjectiveNameDW300       ServiceObjectiveName = original.ServiceObjectiveNameDW300
	ServiceObjectiveNameDW3000      ServiceObjectiveName = original.ServiceObjectiveNameDW3000
	ServiceObjectiveNameDW30000c    ServiceObjectiveName = original.ServiceObjectiveNameDW30000c
	ServiceObjectiveNameDW3000c     ServiceObjectiveName = original.ServiceObjectiveNameDW3000c
	ServiceObjectiveNameDW400       ServiceObjectiveName = original.ServiceObjectiveNameDW400
	ServiceObjectiveNameDW500       ServiceObjectiveName = original.ServiceObjectiveNameDW500
	ServiceObjectiveNameDW5000c     ServiceObjectiveName = original.ServiceObjectiveNameDW5000c
	ServiceObjectiveNameDW600       ServiceObjectiveName = original.ServiceObjectiveNameDW600
	ServiceObjectiveNameDW6000      ServiceObjectiveName = original.ServiceObjectiveNameDW6000
	ServiceObjectiveNameDW6000c     ServiceObjectiveName = original.ServiceObjectiveNameDW6000c
	ServiceObjectiveNameDW7500c     ServiceObjectiveName = original.ServiceObjectiveNameDW7500c
	ServiceObjectiveNameElasticPool ServiceObjectiveName = original.ServiceObjectiveNameElasticPool
	ServiceObjectiveNameFree        ServiceObjectiveName = original.ServiceObjectiveNameFree
	ServiceObjectiveNameP1          ServiceObjectiveName = original.ServiceObjectiveNameP1
	ServiceObjectiveNameP11         ServiceObjectiveName = original.ServiceObjectiveNameP11
	ServiceObjectiveNameP15         ServiceObjectiveName = original.ServiceObjectiveNameP15
	ServiceObjectiveNameP2          ServiceObjectiveName = original.ServiceObjectiveNameP2
	ServiceObjectiveNameP3          ServiceObjectiveName = original.ServiceObjectiveNameP3
	ServiceObjectiveNameP4          ServiceObjectiveName = original.ServiceObjectiveNameP4
	ServiceObjectiveNameP6          ServiceObjectiveName = original.ServiceObjectiveNameP6
	ServiceObjectiveNamePRS1        ServiceObjectiveName = original.ServiceObjectiveNamePRS1
	ServiceObjectiveNamePRS2        ServiceObjectiveName = original.ServiceObjectiveNamePRS2
	ServiceObjectiveNamePRS4        ServiceObjectiveName = original.ServiceObjectiveNamePRS4
	ServiceObjectiveNamePRS6        ServiceObjectiveName = original.ServiceObjectiveNamePRS6
	ServiceObjectiveNameS0          ServiceObjectiveName = original.ServiceObjectiveNameS0
	ServiceObjectiveNameS1          ServiceObjectiveName = original.ServiceObjectiveNameS1
	ServiceObjectiveNameS12         ServiceObjectiveName = original.ServiceObjectiveNameS12
	ServiceObjectiveNameS2          ServiceObjectiveName = original.ServiceObjectiveNameS2
	ServiceObjectiveNameS3          ServiceObjectiveName = original.ServiceObjectiveNameS3
	ServiceObjectiveNameS4          ServiceObjectiveName = original.ServiceObjectiveNameS4
	ServiceObjectiveNameS6          ServiceObjectiveName = original.ServiceObjectiveNameS6
	ServiceObjectiveNameS7          ServiceObjectiveName = original.ServiceObjectiveNameS7
	ServiceObjectiveNameS9          ServiceObjectiveName = original.ServiceObjectiveNameS9
	ServiceObjectiveNameSystem      ServiceObjectiveName = original.ServiceObjectiveNameSystem
	ServiceObjectiveNameSystem0     ServiceObjectiveName = original.ServiceObjectiveNameSystem0
	ServiceObjectiveNameSystem1     ServiceObjectiveName = original.ServiceObjectiveNameSystem1
	ServiceObjectiveNameSystem2     ServiceObjectiveName = original.ServiceObjectiveNameSystem2
	ServiceObjectiveNameSystem2L    ServiceObjectiveName = original.ServiceObjectiveNameSystem2L
	ServiceObjectiveNameSystem3     ServiceObjectiveName = original.ServiceObjectiveNameSystem3
	ServiceObjectiveNameSystem3L    ServiceObjectiveName = original.ServiceObjectiveNameSystem3L
	ServiceObjectiveNameSystem4     ServiceObjectiveName = original.ServiceObjectiveNameSystem4
	ServiceObjectiveNameSystem4L    ServiceObjectiveName = original.ServiceObjectiveNameSystem4L
)

type StorageKeyType = original.StorageKeyType

const (
	SharedAccessKey  StorageKeyType = original.SharedAccessKey
	StorageAccessKey StorageKeyType = original.StorageAccessKey
)

type SyncAgentState = original.SyncAgentState

const (
	NeverConnected SyncAgentState = original.NeverConnected
	Offline        SyncAgentState = original.Offline
	Online         SyncAgentState = original.Online
)

type SyncConflictResolutionPolicy = original.SyncConflictResolutionPolicy

const (
	HubWin    SyncConflictResolutionPolicy = original.HubWin
	MemberWin SyncConflictResolutionPolicy = original.MemberWin
)

type SyncDirection = original.SyncDirection

const (
	Bidirectional     SyncDirection = original.Bidirectional
	OneWayHubToMember SyncDirection = original.OneWayHubToMember
	OneWayMemberToHub SyncDirection = original.OneWayMemberToHub
)

type SyncGroupLogType = original.SyncGroupLogType

const (
	All     SyncGroupLogType = original.All
	Error   SyncGroupLogType = original.Error
	Success SyncGroupLogType = original.Success
	Warning SyncGroupLogType = original.Warning
)

type SyncGroupState = original.SyncGroupState

const (
	SyncGroupStateError       SyncGroupState = original.SyncGroupStateError
	SyncGroupStateGood        SyncGroupState = original.SyncGroupStateGood
	SyncGroupStateNotReady    SyncGroupState = original.SyncGroupStateNotReady
	SyncGroupStateProgressing SyncGroupState = original.SyncGroupStateProgressing
	SyncGroupStateWarning     SyncGroupState = original.SyncGroupStateWarning
)

type SyncMemberDbType = original.SyncMemberDbType

const (
	AzureSQLDatabase  SyncMemberDbType = original.AzureSQLDatabase
	SQLServerDatabase SyncMemberDbType = original.SQLServerDatabase
)

type SyncMemberState = original.SyncMemberState

const (
	DeProvisioned             SyncMemberState = original.DeProvisioned
	DeProvisionFailed         SyncMemberState = original.DeProvisionFailed
	DeProvisioning            SyncMemberState = original.DeProvisioning
	DisabledBackupRestore     SyncMemberState = original.DisabledBackupRestore
	DisabledTombstoneCleanup  SyncMemberState = original.DisabledTombstoneCleanup
	Provisioned               SyncMemberState = original.Provisioned
	ProvisionFailed           SyncMemberState = original.ProvisionFailed
	Provisioning              SyncMemberState = original.Provisioning
	ReprovisionFailed         SyncMemberState = original.ReprovisionFailed
	Reprovisioning            SyncMemberState = original.Reprovisioning
	SyncCancelled             SyncMemberState = original.SyncCancelled
	SyncCancelling            SyncMemberState = original.SyncCancelling
	SyncFailed                SyncMemberState = original.SyncFailed
	SyncInProgress            SyncMemberState = original.SyncInProgress
	SyncSucceeded             SyncMemberState = original.SyncSucceeded
	SyncSucceededWithWarnings SyncMemberState = original.SyncSucceededWithWarnings
	UnProvisioned             SyncMemberState = original.UnProvisioned
	UnReprovisioned           SyncMemberState = original.UnReprovisioned
)

type TransparentDataEncryptionActivityStatus = original.TransparentDataEncryptionActivityStatus

const (
	Decrypting TransparentDataEncryptionActivityStatus = original.Decrypting
	Encrypting TransparentDataEncryptionActivityStatus = original.Encrypting
)

type TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatus

const (
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusDisabled
	TransparentDataEncryptionStatusEnabled  TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusEnabled
)

type UnitDefinitionType = original.UnitDefinitionType

const (
	UnitDefinitionTypeBytes          UnitDefinitionType = original.UnitDefinitionTypeBytes
	UnitDefinitionTypeBytesPerSecond UnitDefinitionType = original.UnitDefinitionTypeBytesPerSecond
	UnitDefinitionTypeCount          UnitDefinitionType = original.UnitDefinitionTypeCount
	UnitDefinitionTypeCountPerSecond UnitDefinitionType = original.UnitDefinitionTypeCountPerSecond
	UnitDefinitionTypePercent        UnitDefinitionType = original.UnitDefinitionTypePercent
	UnitDefinitionTypeSeconds        UnitDefinitionType = original.UnitDefinitionTypeSeconds
)

type UnitType = original.UnitType

const (
	UnitTypeBytes          UnitType = original.UnitTypeBytes
	UnitTypeBytesPerSecond UnitType = original.UnitTypeBytesPerSecond
	UnitTypeCount          UnitType = original.UnitTypeCount
	UnitTypeCountPerSecond UnitType = original.UnitTypeCountPerSecond
	UnitTypePercent        UnitType = original.UnitTypePercent
	UnitTypeSeconds        UnitType = original.UnitTypeSeconds
)

type VirtualNetworkRuleState = original.VirtualNetworkRuleState

const (
	VirtualNetworkRuleStateDeleting     VirtualNetworkRuleState = original.VirtualNetworkRuleStateDeleting
	VirtualNetworkRuleStateInitializing VirtualNetworkRuleState = original.VirtualNetworkRuleStateInitializing
	VirtualNetworkRuleStateInProgress   VirtualNetworkRuleState = original.VirtualNetworkRuleStateInProgress
	VirtualNetworkRuleStateReady        VirtualNetworkRuleState = original.VirtualNetworkRuleStateReady
	VirtualNetworkRuleStateUnknown      VirtualNetworkRuleState = original.VirtualNetworkRuleStateUnknown
)

type AutomaticTuningOptions = original.AutomaticTuningOptions
type AutomaticTuningServerOptions = original.AutomaticTuningServerOptions
type AutomaticTuningServerProperties = original.AutomaticTuningServerProperties
type BackupLongTermRetentionPoliciesCreateOrUpdateFuture = original.BackupLongTermRetentionPoliciesCreateOrUpdateFuture
type BackupLongTermRetentionPolicy = original.BackupLongTermRetentionPolicy
type BackupLongTermRetentionPolicyListResult = original.BackupLongTermRetentionPolicyListResult
type BackupLongTermRetentionPolicyProperties = original.BackupLongTermRetentionPolicyProperties
type BackupLongTermRetentionVault = original.BackupLongTermRetentionVault
type BackupLongTermRetentionVaultListResult = original.BackupLongTermRetentionVaultListResult
type BackupLongTermRetentionVaultProperties = original.BackupLongTermRetentionVaultProperties
type BackupLongTermRetentionVaultsCreateOrUpdateFuture = original.BackupLongTermRetentionVaultsCreateOrUpdateFuture
type CheckNameAvailabilityRequest = original.CheckNameAvailabilityRequest
type CheckNameAvailabilityResponse = original.CheckNameAvailabilityResponse
type CreateDatabaseRestorePointDefinition = original.CreateDatabaseRestorePointDefinition
type Database = original.Database
type DatabaseAutomaticTuning = original.DatabaseAutomaticTuning
type DatabaseAutomaticTuningProperties = original.DatabaseAutomaticTuningProperties
type DatabaseBlobAuditingPolicy = original.DatabaseBlobAuditingPolicy
type DatabaseBlobAuditingPolicyProperties = original.DatabaseBlobAuditingPolicyProperties
type DatabaseListResult = original.DatabaseListResult
type DatabaseOperation = original.DatabaseOperation
type DatabaseOperationListResult = original.DatabaseOperationListResult
type DatabaseOperationListResultIterator = original.DatabaseOperationListResultIterator
type DatabaseOperationListResultPage = original.DatabaseOperationListResultPage
type DatabaseOperationProperties = original.DatabaseOperationProperties
type DatabaseProperties = original.DatabaseProperties
type DatabasesCreateImportOperationFuture = original.DatabasesCreateImportOperationFuture
type DatabasesCreateOrUpdateFuture = original.DatabasesCreateOrUpdateFuture
type DatabaseSecurityAlertPolicy = original.DatabaseSecurityAlertPolicy
type DatabaseSecurityAlertPolicyProperties = original.DatabaseSecurityAlertPolicyProperties
type DatabasesExportFuture = original.DatabasesExportFuture
type DatabasesImportFuture = original.DatabasesImportFuture
type DatabasesPauseFuture = original.DatabasesPauseFuture
type DatabasesResumeFuture = original.DatabasesResumeFuture
type DatabasesUpdateFuture = original.DatabasesUpdateFuture
type DatabaseUpdate = original.DatabaseUpdate
type DatabaseUsage = original.DatabaseUsage
type DatabaseUsageListResult = original.DatabaseUsageListResult
type DataMaskingPolicy = original.DataMaskingPolicy
type DataMaskingPolicyProperties = original.DataMaskingPolicyProperties
type DataMaskingRule = original.DataMaskingRule
type DataMaskingRuleListResult = original.DataMaskingRuleListResult
type DataMaskingRuleProperties = original.DataMaskingRuleProperties
type EditionCapability = original.EditionCapability
type ElasticPool = original.ElasticPool
type ElasticPoolActivity = original.ElasticPoolActivity
type ElasticPoolActivityListResult = original.ElasticPoolActivityListResult
type ElasticPoolActivityProperties = original.ElasticPoolActivityProperties
type ElasticPoolDatabaseActivity = original.ElasticPoolDatabaseActivity
type ElasticPoolDatabaseActivityListResult = original.ElasticPoolDatabaseActivityListResult
type ElasticPoolDatabaseActivityProperties = original.ElasticPoolDatabaseActivityProperties
type ElasticPoolDtuCapability = original.ElasticPoolDtuCapability
type ElasticPoolEditionCapability = original.ElasticPoolEditionCapability
type ElasticPoolListResult = original.ElasticPoolListResult
type ElasticPoolPerDatabaseMaxDtuCapability = original.ElasticPoolPerDatabaseMaxDtuCapability
type ElasticPoolPerDatabaseMinDtuCapability = original.ElasticPoolPerDatabaseMinDtuCapability
type ElasticPoolProperties = original.ElasticPoolProperties
type ElasticPoolsCreateOrUpdateFuture = original.ElasticPoolsCreateOrUpdateFuture
type ElasticPoolsUpdateFuture = original.ElasticPoolsUpdateFuture
type ElasticPoolUpdate = original.ElasticPoolUpdate
type EncryptionProtector = original.EncryptionProtector
type EncryptionProtectorListResult = original.EncryptionProtectorListResult
type EncryptionProtectorListResultIterator = original.EncryptionProtectorListResultIterator
type EncryptionProtectorListResultPage = original.EncryptionProtectorListResultPage
type EncryptionProtectorProperties = original.EncryptionProtectorProperties
type EncryptionProtectorsCreateOrUpdateFuture = original.EncryptionProtectorsCreateOrUpdateFuture
type ExportRequest = original.ExportRequest
type FailoverGroup = original.FailoverGroup
type FailoverGroupListResult = original.FailoverGroupListResult
type FailoverGroupListResultIterator = original.FailoverGroupListResultIterator
type FailoverGroupListResultPage = original.FailoverGroupListResultPage
type FailoverGroupProperties = original.FailoverGroupProperties
type FailoverGroupReadOnlyEndpoint = original.FailoverGroupReadOnlyEndpoint
type FailoverGroupReadWriteEndpoint = original.FailoverGroupReadWriteEndpoint
type FailoverGroupsCreateOrUpdateFuture = original.FailoverGroupsCreateOrUpdateFuture
type FailoverGroupsDeleteFuture = original.FailoverGroupsDeleteFuture
type FailoverGroupsFailoverFuture = original.FailoverGroupsFailoverFuture
type FailoverGroupsForceFailoverAllowDataLossFuture = original.FailoverGroupsForceFailoverAllowDataLossFuture
type FailoverGroupsUpdateFuture = original.FailoverGroupsUpdateFuture
type FailoverGroupUpdate = original.FailoverGroupUpdate
type FailoverGroupUpdateProperties = original.FailoverGroupUpdateProperties
type FirewallRule = original.FirewallRule
type FirewallRuleListResult = original.FirewallRuleListResult
type FirewallRuleProperties = original.FirewallRuleProperties
type GeoBackupPolicy = original.GeoBackupPolicy
type GeoBackupPolicyListResult = original.GeoBackupPolicyListResult
type GeoBackupPolicyProperties = original.GeoBackupPolicyProperties
type ImportExportResponse = original.ImportExportResponse
type ImportExportResponseProperties = original.ImportExportResponseProperties
type ImportExtensionProperties = original.ImportExtensionProperties
type ImportExtensionRequest = original.ImportExtensionRequest
type ImportRequest = original.ImportRequest
type LocationCapabilities = original.LocationCapabilities
type MaxSizeCapability = original.MaxSizeCapability
type Metric = original.Metric
type MetricAvailability = original.MetricAvailability
type MetricDefinition = original.MetricDefinition
type MetricDefinitionListResult = original.MetricDefinitionListResult
type MetricListResult = original.MetricListResult
type MetricName = original.MetricName
type MetricValue = original.MetricValue
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationImpact = original.OperationImpact
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type PartnerInfo = original.PartnerInfo
type PerformanceLevel = original.PerformanceLevel
type ProxyResource = original.ProxyResource
type RecommendedElasticPool = original.RecommendedElasticPool
type RecommendedElasticPoolListMetricsResult = original.RecommendedElasticPoolListMetricsResult
type RecommendedElasticPoolListResult = original.RecommendedElasticPoolListResult
type RecommendedElasticPoolMetric = original.RecommendedElasticPoolMetric
type RecommendedElasticPoolProperties = original.RecommendedElasticPoolProperties
type RecommendedIndex = original.RecommendedIndex
type RecommendedIndexProperties = original.RecommendedIndexProperties
type RecoverableDatabase = original.RecoverableDatabase
type RecoverableDatabaseListResult = original.RecoverableDatabaseListResult
type RecoverableDatabaseProperties = original.RecoverableDatabaseProperties
type ReplicationLink = original.ReplicationLink
type ReplicationLinkListResult = original.ReplicationLinkListResult
type ReplicationLinkProperties = original.ReplicationLinkProperties
type ReplicationLinksFailoverAllowDataLossFuture = original.ReplicationLinksFailoverAllowDataLossFuture
type ReplicationLinksFailoverFuture = original.ReplicationLinksFailoverFuture
type Resource = original.Resource
type ResourceIdentity = original.ResourceIdentity
type ResourceMoveDefinition = original.ResourceMoveDefinition
type RestorableDroppedDatabase = original.RestorableDroppedDatabase
type RestorableDroppedDatabaseListResult = original.RestorableDroppedDatabaseListResult
type RestorableDroppedDatabaseProperties = original.RestorableDroppedDatabaseProperties
type RestorePoint = original.RestorePoint
type RestorePointListResult = original.RestorePointListResult
type RestorePointProperties = original.RestorePointProperties
type RestorePointsCreateFuture = original.RestorePointsCreateFuture
type Server = original.Server
type ServerAdministratorListResult = original.ServerAdministratorListResult
type ServerAdministratorProperties = original.ServerAdministratorProperties
type ServerAutomaticTuning = original.ServerAutomaticTuning
type ServerAzureADAdministrator = original.ServerAzureADAdministrator
type ServerAzureADAdministratorsCreateOrUpdateFuture = original.ServerAzureADAdministratorsCreateOrUpdateFuture
type ServerAzureADAdministratorsDeleteFuture = original.ServerAzureADAdministratorsDeleteFuture
type ServerCommunicationLink = original.ServerCommunicationLink
type ServerCommunicationLinkListResult = original.ServerCommunicationLinkListResult
type ServerCommunicationLinkProperties = original.ServerCommunicationLinkProperties
type ServerCommunicationLinksCreateOrUpdateFuture = original.ServerCommunicationLinksCreateOrUpdateFuture
type ServerConnectionPolicy = original.ServerConnectionPolicy
type ServerConnectionPolicyProperties = original.ServerConnectionPolicyProperties
type ServerDNSAlias = original.ServerDNSAlias
type ServerDNSAliasAcquisition = original.ServerDNSAliasAcquisition
type ServerDNSAliasesAcquireFuture = original.ServerDNSAliasesAcquireFuture
type ServerDNSAliasesCreateOrUpdateFuture = original.ServerDNSAliasesCreateOrUpdateFuture
type ServerDNSAliasesDeleteFuture = original.ServerDNSAliasesDeleteFuture
type ServerDNSAliasListResult = original.ServerDNSAliasListResult
type ServerDNSAliasListResultIterator = original.ServerDNSAliasListResultIterator
type ServerDNSAliasListResultPage = original.ServerDNSAliasListResultPage
type ServerDNSAliasProperties = original.ServerDNSAliasProperties
type ServerKey = original.ServerKey
type ServerKeyListResult = original.ServerKeyListResult
type ServerKeyListResultIterator = original.ServerKeyListResultIterator
type ServerKeyListResultPage = original.ServerKeyListResultPage
type ServerKeyProperties = original.ServerKeyProperties
type ServerKeysCreateOrUpdateFuture = original.ServerKeysCreateOrUpdateFuture
type ServerKeysDeleteFuture = original.ServerKeysDeleteFuture
type ServerListResult = original.ServerListResult
type ServerListResultIterator = original.ServerListResultIterator
type ServerListResultPage = original.ServerListResultPage
type ServerProperties = original.ServerProperties
type ServersCreateOrUpdateFuture = original.ServersCreateOrUpdateFuture
type ServersDeleteFuture = original.ServersDeleteFuture
type ServersUpdateFuture = original.ServersUpdateFuture
type ServerUpdate = original.ServerUpdate
type ServerUsage = original.ServerUsage
type ServerUsageListResult = original.ServerUsageListResult
type ServerVersionCapability = original.ServerVersionCapability
type ServiceObjective = original.ServiceObjective
type ServiceObjectiveCapability = original.ServiceObjectiveCapability
type ServiceObjectiveListResult = original.ServiceObjectiveListResult
type ServiceObjectiveProperties = original.ServiceObjectiveProperties
type ServiceTierAdvisor = original.ServiceTierAdvisor
type ServiceTierAdvisorListResult = original.ServiceTierAdvisorListResult
type ServiceTierAdvisorProperties = original.ServiceTierAdvisorProperties
type SloUsageMetric = original.SloUsageMetric
type SubscriptionUsage = original.SubscriptionUsage
type SubscriptionUsageListResult = original.SubscriptionUsageListResult
type SubscriptionUsageListResultIterator = original.SubscriptionUsageListResultIterator
type SubscriptionUsageListResultPage = original.SubscriptionUsageListResultPage
type SubscriptionUsageProperties = original.SubscriptionUsageProperties
type SyncAgent = original.SyncAgent
type SyncAgentKeyProperties = original.SyncAgentKeyProperties
type SyncAgentLinkedDatabase = original.SyncAgentLinkedDatabase
type SyncAgentLinkedDatabaseListResult = original.SyncAgentLinkedDatabaseListResult
type SyncAgentLinkedDatabaseListResultIterator = original.SyncAgentLinkedDatabaseListResultIterator
type SyncAgentLinkedDatabaseListResultPage = original.SyncAgentLinkedDatabaseListResultPage
type SyncAgentLinkedDatabaseProperties = original.SyncAgentLinkedDatabaseProperties
type SyncAgentListResult = original.SyncAgentListResult
type SyncAgentListResultIterator = original.SyncAgentListResultIterator
type SyncAgentListResultPage = original.SyncAgentListResultPage
type SyncAgentProperties = original.SyncAgentProperties
type SyncAgentsCreateOrUpdateFuture = original.SyncAgentsCreateOrUpdateFuture
type SyncAgentsDeleteFuture = original.SyncAgentsDeleteFuture
type SyncDatabaseIDListResult = original.SyncDatabaseIDListResult
type SyncDatabaseIDListResultIterator = original.SyncDatabaseIDListResultIterator
type SyncDatabaseIDListResultPage = original.SyncDatabaseIDListResultPage
type SyncDatabaseIDProperties = original.SyncDatabaseIDProperties
type SyncFullSchemaProperties = original.SyncFullSchemaProperties
type SyncFullSchemaPropertiesListResult = original.SyncFullSchemaPropertiesListResult
type SyncFullSchemaPropertiesListResultIterator = original.SyncFullSchemaPropertiesListResultIterator
type SyncFullSchemaPropertiesListResultPage = original.SyncFullSchemaPropertiesListResultPage
type SyncFullSchemaTable = original.SyncFullSchemaTable
type SyncFullSchemaTableColumn = original.SyncFullSchemaTableColumn
type SyncGroup = original.SyncGroup
type SyncGroupListResult = original.SyncGroupListResult
type SyncGroupListResultIterator = original.SyncGroupListResultIterator
type SyncGroupListResultPage = original.SyncGroupListResultPage
type SyncGroupLogListResult = original.SyncGroupLogListResult
type SyncGroupLogListResultIterator = original.SyncGroupLogListResultIterator
type SyncGroupLogListResultPage = original.SyncGroupLogListResultPage
type SyncGroupLogProperties = original.SyncGroupLogProperties
type SyncGroupProperties = original.SyncGroupProperties
type SyncGroupSchema = original.SyncGroupSchema
type SyncGroupSchemaTable = original.SyncGroupSchemaTable
type SyncGroupSchemaTableColumn = original.SyncGroupSchemaTableColumn
type SyncGroupsCreateOrUpdateFuture = original.SyncGroupsCreateOrUpdateFuture
type SyncGroupsDeleteFuture = original.SyncGroupsDeleteFuture
type SyncGroupsRefreshHubSchemaFuture = original.SyncGroupsRefreshHubSchemaFuture
type SyncGroupsUpdateFuture = original.SyncGroupsUpdateFuture
type SyncMember = original.SyncMember
type SyncMemberListResult = original.SyncMemberListResult
type SyncMemberListResultIterator = original.SyncMemberListResultIterator
type SyncMemberListResultPage = original.SyncMemberListResultPage
type SyncMemberProperties = original.SyncMemberProperties
type SyncMembersCreateOrUpdateFuture = original.SyncMembersCreateOrUpdateFuture
type SyncMembersDeleteFuture = original.SyncMembersDeleteFuture
type SyncMembersRefreshMemberSchemaFuture = original.SyncMembersRefreshMemberSchemaFuture
type SyncMembersUpdateFuture = original.SyncMembersUpdateFuture
type TrackedResource = original.TrackedResource
type TransparentDataEncryption = original.TransparentDataEncryption
type TransparentDataEncryptionActivity = original.TransparentDataEncryptionActivity
type TransparentDataEncryptionActivityListResult = original.TransparentDataEncryptionActivityListResult
type TransparentDataEncryptionActivityProperties = original.TransparentDataEncryptionActivityProperties
type TransparentDataEncryptionProperties = original.TransparentDataEncryptionProperties
type VirtualNetworkRule = original.VirtualNetworkRule
type VirtualNetworkRuleListResult = original.VirtualNetworkRuleListResult
type VirtualNetworkRuleListResultIterator = original.VirtualNetworkRuleListResultIterator
type VirtualNetworkRuleListResultPage = original.VirtualNetworkRuleListResultPage
type VirtualNetworkRuleProperties = original.VirtualNetworkRuleProperties
type VirtualNetworkRulesCreateOrUpdateFuture = original.VirtualNetworkRulesCreateOrUpdateFuture
type VirtualNetworkRulesDeleteFuture = original.VirtualNetworkRulesDeleteFuture
type OperationsClient = original.OperationsClient

func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}

type RecommendedElasticPoolsClient = original.RecommendedElasticPoolsClient

func NewRecommendedElasticPoolsClient(subscriptionID string) RecommendedElasticPoolsClient {
	return original.NewRecommendedElasticPoolsClient(subscriptionID)
}
func NewRecommendedElasticPoolsClientWithBaseURI(baseURI string, subscriptionID string) RecommendedElasticPoolsClient {
	return original.NewRecommendedElasticPoolsClientWithBaseURI(baseURI, subscriptionID)
}

type RecoverableDatabasesClient = original.RecoverableDatabasesClient

func NewRecoverableDatabasesClient(subscriptionID string) RecoverableDatabasesClient {
	return original.NewRecoverableDatabasesClient(subscriptionID)
}
func NewRecoverableDatabasesClientWithBaseURI(baseURI string, subscriptionID string) RecoverableDatabasesClient {
	return original.NewRecoverableDatabasesClientWithBaseURI(baseURI, subscriptionID)
}

type ReplicationLinksClient = original.ReplicationLinksClient

func NewReplicationLinksClient(subscriptionID string) ReplicationLinksClient {
	return original.NewReplicationLinksClient(subscriptionID)
}
func NewReplicationLinksClientWithBaseURI(baseURI string, subscriptionID string) ReplicationLinksClient {
	return original.NewReplicationLinksClientWithBaseURI(baseURI, subscriptionID)
}

type RestorableDroppedDatabasesClient = original.RestorableDroppedDatabasesClient

func NewRestorableDroppedDatabasesClient(subscriptionID string) RestorableDroppedDatabasesClient {
	return original.NewRestorableDroppedDatabasesClient(subscriptionID)
}
func NewRestorableDroppedDatabasesClientWithBaseURI(baseURI string, subscriptionID string) RestorableDroppedDatabasesClient {
	return original.NewRestorableDroppedDatabasesClientWithBaseURI(baseURI, subscriptionID)
}

type RestorePointsClient = original.RestorePointsClient

func NewRestorePointsClient(subscriptionID string) RestorePointsClient {
	return original.NewRestorePointsClient(subscriptionID)
}
func NewRestorePointsClientWithBaseURI(baseURI string, subscriptionID string) RestorePointsClient {
	return original.NewRestorePointsClientWithBaseURI(baseURI, subscriptionID)
}

type ServerAutomaticTuningClient = original.ServerAutomaticTuningClient

func NewServerAutomaticTuningClient(subscriptionID string) ServerAutomaticTuningClient {
	return original.NewServerAutomaticTuningClient(subscriptionID)
}
func NewServerAutomaticTuningClientWithBaseURI(baseURI string, subscriptionID string) ServerAutomaticTuningClient {
	return original.NewServerAutomaticTuningClientWithBaseURI(baseURI, subscriptionID)
}

type ServerAzureADAdministratorsClient = original.ServerAzureADAdministratorsClient

func NewServerAzureADAdministratorsClient(subscriptionID string) ServerAzureADAdministratorsClient {
	return original.NewServerAzureADAdministratorsClient(subscriptionID)
}
func NewServerAzureADAdministratorsClientWithBaseURI(baseURI string, subscriptionID string) ServerAzureADAdministratorsClient {
	return original.NewServerAzureADAdministratorsClientWithBaseURI(baseURI, subscriptionID)
}

type ServerCommunicationLinksClient = original.ServerCommunicationLinksClient

func NewServerCommunicationLinksClient(subscriptionID string) ServerCommunicationLinksClient {
	return original.NewServerCommunicationLinksClient(subscriptionID)
}
func NewServerCommunicationLinksClientWithBaseURI(baseURI string, subscriptionID string) ServerCommunicationLinksClient {
	return original.NewServerCommunicationLinksClientWithBaseURI(baseURI, subscriptionID)
}

type ServerConnectionPoliciesClient = original.ServerConnectionPoliciesClient

func NewServerConnectionPoliciesClient(subscriptionID string) ServerConnectionPoliciesClient {
	return original.NewServerConnectionPoliciesClient(subscriptionID)
}
func NewServerConnectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ServerConnectionPoliciesClient {
	return original.NewServerConnectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}

type ServerDNSAliasesClient = original.ServerDNSAliasesClient

func NewServerDNSAliasesClient(subscriptionID string) ServerDNSAliasesClient {
	return original.NewServerDNSAliasesClient(subscriptionID)
}
func NewServerDNSAliasesClientWithBaseURI(baseURI string, subscriptionID string) ServerDNSAliasesClient {
	return original.NewServerDNSAliasesClientWithBaseURI(baseURI, subscriptionID)
}

type ServerKeysClient = original.ServerKeysClient

func NewServerKeysClient(subscriptionID string) ServerKeysClient {
	return original.NewServerKeysClient(subscriptionID)
}
func NewServerKeysClientWithBaseURI(baseURI string, subscriptionID string) ServerKeysClient {
	return original.NewServerKeysClientWithBaseURI(baseURI, subscriptionID)
}

type ServersClient = original.ServersClient

func NewServersClient(subscriptionID string) ServersClient {
	return original.NewServersClient(subscriptionID)
}
func NewServersClientWithBaseURI(baseURI string, subscriptionID string) ServersClient {
	return original.NewServersClientWithBaseURI(baseURI, subscriptionID)
}

type ServerUsagesClient = original.ServerUsagesClient

func NewServerUsagesClient(subscriptionID string) ServerUsagesClient {
	return original.NewServerUsagesClient(subscriptionID)
}
func NewServerUsagesClientWithBaseURI(baseURI string, subscriptionID string) ServerUsagesClient {
	return original.NewServerUsagesClientWithBaseURI(baseURI, subscriptionID)
}

type ServiceObjectivesClient = original.ServiceObjectivesClient

func NewServiceObjectivesClient(subscriptionID string) ServiceObjectivesClient {
	return original.NewServiceObjectivesClient(subscriptionID)
}
func NewServiceObjectivesClientWithBaseURI(baseURI string, subscriptionID string) ServiceObjectivesClient {
	return original.NewServiceObjectivesClientWithBaseURI(baseURI, subscriptionID)
}

type ServiceTierAdvisorsClient = original.ServiceTierAdvisorsClient

func NewServiceTierAdvisorsClient(subscriptionID string) ServiceTierAdvisorsClient {
	return original.NewServiceTierAdvisorsClient(subscriptionID)
}
func NewServiceTierAdvisorsClientWithBaseURI(baseURI string, subscriptionID string) ServiceTierAdvisorsClient {
	return original.NewServiceTierAdvisorsClientWithBaseURI(baseURI, subscriptionID)
}

type SubscriptionUsagesClient = original.SubscriptionUsagesClient

func NewSubscriptionUsagesClient(subscriptionID string) SubscriptionUsagesClient {
	return original.NewSubscriptionUsagesClient(subscriptionID)
}
func NewSubscriptionUsagesClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionUsagesClient {
	return original.NewSubscriptionUsagesClientWithBaseURI(baseURI, subscriptionID)
}

type SyncAgentsClient = original.SyncAgentsClient

func NewSyncAgentsClient(subscriptionID string) SyncAgentsClient {
	return original.NewSyncAgentsClient(subscriptionID)
}
func NewSyncAgentsClientWithBaseURI(baseURI string, subscriptionID string) SyncAgentsClient {
	return original.NewSyncAgentsClientWithBaseURI(baseURI, subscriptionID)
}

type SyncGroupsClient = original.SyncGroupsClient

func NewSyncGroupsClient(subscriptionID string) SyncGroupsClient {
	return original.NewSyncGroupsClient(subscriptionID)
}
func NewSyncGroupsClientWithBaseURI(baseURI string, subscriptionID string) SyncGroupsClient {
	return original.NewSyncGroupsClientWithBaseURI(baseURI, subscriptionID)
}

type SyncMembersClient = original.SyncMembersClient

func NewSyncMembersClient(subscriptionID string) SyncMembersClient {
	return original.NewSyncMembersClient(subscriptionID)
}
func NewSyncMembersClientWithBaseURI(baseURI string, subscriptionID string) SyncMembersClient {
	return original.NewSyncMembersClientWithBaseURI(baseURI, subscriptionID)
}

type TransparentDataEncryptionActivitiesClient = original.TransparentDataEncryptionActivitiesClient

func NewTransparentDataEncryptionActivitiesClient(subscriptionID string) TransparentDataEncryptionActivitiesClient {
	return original.NewTransparentDataEncryptionActivitiesClient(subscriptionID)
}
func NewTransparentDataEncryptionActivitiesClientWithBaseURI(baseURI string, subscriptionID string) TransparentDataEncryptionActivitiesClient {
	return original.NewTransparentDataEncryptionActivitiesClientWithBaseURI(baseURI, subscriptionID)
}

type TransparentDataEncryptionsClient = original.TransparentDataEncryptionsClient

func NewTransparentDataEncryptionsClient(subscriptionID string) TransparentDataEncryptionsClient {
	return original.NewTransparentDataEncryptionsClient(subscriptionID)
}
func NewTransparentDataEncryptionsClientWithBaseURI(baseURI string, subscriptionID string) TransparentDataEncryptionsClient {
	return original.NewTransparentDataEncryptionsClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}

type VirtualNetworkRulesClient = original.VirtualNetworkRulesClient

func NewVirtualNetworkRulesClient(subscriptionID string) VirtualNetworkRulesClient {
	return original.NewVirtualNetworkRulesClient(subscriptionID)
}
func NewVirtualNetworkRulesClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkRulesClient {
	return original.NewVirtualNetworkRulesClientWithBaseURI(baseURI, subscriptionID)
}
