package websearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// AnswerType enumerates the values for answer type.
type AnswerType string

const (
	// AnswerTypeComputation ...
	AnswerTypeComputation AnswerType = "Computation"
	// AnswerTypeImages ...
	AnswerTypeImages AnswerType = "Images"
	// AnswerTypeNews ...
	AnswerTypeNews AnswerType = "News"
	// AnswerTypeRelatedSearches ...
	AnswerTypeRelatedSearches AnswerType = "RelatedSearches"
	// AnswerTypeSpellSuggestions ...
	AnswerTypeSpellSuggestions AnswerType = "SpellSuggestions"
	// AnswerTypeTimeZone ...
	AnswerTypeTimeZone AnswerType = "TimeZone"
	// AnswerTypeVideos ...
	AnswerTypeVideos AnswerType = "Videos"
	// AnswerTypeWebPages ...
	AnswerTypeWebPages AnswerType = "WebPages"
)

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// Freshness enumerates the values for freshness.
type Freshness string

const (
	// Day ...
	Day Freshness = "Day"
	// Month ...
	Month Freshness = "Month"
	// Week ...
	Week Freshness = "Week"
)

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// TextFormat enumerates the values for text format.
type TextFormat string

const (
	// HTML ...
	HTML TextFormat = "Html"
	// Raw ...
	Raw TextFormat = "Raw"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeWebWebGrouping ...
	TypeWebWebGrouping Type = "Web/WebGrouping"
)

// TypeBasicResponseBase enumerates the values for type basic response base.
type TypeBasicResponseBase string

const (
	// TypeAnswer ...
	TypeAnswer TypeBasicResponseBase = "Answer"
	// TypeArticle ...
	TypeArticle TypeBasicResponseBase = "Article"
	// TypeComputation ...
	TypeComputation TypeBasicResponseBase = "Computation"
	// TypeCreativeWork ...
	TypeCreativeWork TypeBasicResponseBase = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse TypeBasicResponseBase = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable TypeBasicResponseBase = "Identifiable"
	// TypeImageObject ...
	TypeImageObject TypeBasicResponseBase = "ImageObject"
	// TypeImages ...
	TypeImages TypeBasicResponseBase = "Images"
	// TypeIntangible ...
	TypeIntangible TypeBasicResponseBase = "Intangible"
	// TypeMediaObject ...
	TypeMediaObject TypeBasicResponseBase = "MediaObject"
	// TypeNews ...
	TypeNews TypeBasicResponseBase = "News"
	// TypeNewsArticle ...
	TypeNewsArticle TypeBasicResponseBase = "NewsArticle"
	// TypePlaces ...
	TypePlaces TypeBasicResponseBase = "Places"
	// TypeRelatedSearchesRelatedSearchAnswer ...
	TypeRelatedSearchesRelatedSearchAnswer TypeBasicResponseBase = "RelatedSearches/RelatedSearchAnswer"
	// TypeResponse ...
	TypeResponse TypeBasicResponseBase = "Response"
	// TypeResponseBase ...
	TypeResponseBase TypeBasicResponseBase = "ResponseBase"
	// TypeSearchResponse ...
	TypeSearchResponse TypeBasicResponseBase = "SearchResponse"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer TypeBasicResponseBase = "SearchResultsAnswer"
	// TypeSpellSuggestions ...
	TypeSpellSuggestions TypeBasicResponseBase = "SpellSuggestions"
	// TypeStructuredValue ...
	TypeStructuredValue TypeBasicResponseBase = "StructuredValue"
	// TypeThing ...
	TypeThing TypeBasicResponseBase = "Thing"
	// TypeTimeZone ...
	TypeTimeZone TypeBasicResponseBase = "TimeZone"
	// TypeVideoObject ...
	TypeVideoObject TypeBasicResponseBase = "VideoObject"
	// TypeVideos ...
	TypeVideos TypeBasicResponseBase = "Videos"
	// TypeWebPage ...
	TypeWebPage TypeBasicResponseBase = "WebPage"
	// TypeWebWebAnswer ...
	TypeWebWebAnswer TypeBasicResponseBase = "Web/WebAnswer"
)

// BasicAnswer
type BasicAnswer interface {
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsImages() (*Images, bool)
	AsNews() (*News, bool)
	AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool)
	AsSpellSuggestions() (*SpellSuggestions, bool)
	AsTimeZone() (*TimeZone, bool)
	AsVideos() (*Videos, bool)
	AsComputation() (*Computation, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer
type Answer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string  `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query `json:"followUpQueries,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeRelatedSearchesRelatedSearchAnswer):
		var rsrsa RelatedSearchesRelatedSearchAnswer
		err := json.Unmarshal(body, &rsrsa)
		return rsrsa, err
	case string(TypeSpellSuggestions):
		var ss SpellSuggestions
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeTimeZone):
		var tz TimeZone
		err := json.Unmarshal(body, &tz)
		return tz, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeComputation):
		var c Computation
		err := json.Unmarshal(body, &c)
		return c, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	type Alias Answer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsImageObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Answer.
func (a Answer) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Answer.
func (a Answer) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Answer.
func (a Answer) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Answer.
func (a Answer) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Answer.
func (a Answer) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Answer.
func (a Answer) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Answer.
func (a Answer) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsSearchResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Answer.
func (a Answer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Answer.
func (a Answer) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Answer.
func (a Answer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// BasicArticle
type BasicArticle interface {
	AsNewsArticle() (*NewsArticle, bool)
	AsArticle() (*Article, bool)
}

// Article
type Article struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// WordCount - The number of words in the text of the Article.
	WordCount *int32 `json:"wordCount,omitempty"`
}

func unmarshalBasicArticle(body []byte) (BasicArticle, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	default:
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicArticleArray(body []byte) ([]BasicArticle, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicArticle, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicArticle(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Article.
func (a Article) MarshalJSON() ([]byte, error) {
	a.Type = TypeArticle
	type Alias Article
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsImageObject is the BasicResponseBase implementation for Article.
func (a Article) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Article.
func (a Article) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Article.
func (a Article) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Article.
func (a Article) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Article.
func (a Article) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Article.
func (a Article) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Article.
func (a Article) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Article.
func (a Article) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Article.
func (a Article) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Article.
func (a Article) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Article.
func (a Article) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Article.
func (a Article) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsSearchResponse is the BasicResponseBase implementation for Article.
func (a Article) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Article.
func (a Article) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Article.
func (a Article) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Article.
func (a Article) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Article.
func (a Article) AsBasicThing() (BasicThing, bool) {
	return &a, true
}

// AsPlaces is the BasicResponseBase implementation for Article.
func (a Article) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Article.
func (a Article) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Article.
func (a Article) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Article.
func (a Article) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Article.
func (a Article) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &a, true
}

// AsIntangible is the BasicResponseBase implementation for Article.
func (a Article) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Article.
func (a Article) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Article.
func (a Article) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Article.
func (a Article) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Article.
func (a Article) AsArticle() (*Article, bool) {
	return &a, true
}

// AsBasicArticle is the BasicResponseBase implementation for Article.
func (a Article) AsBasicArticle() (BasicArticle, bool) {
	return &a, true
}

// AsStructuredValue is the BasicResponseBase implementation for Article.
func (a Article) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Article.
func (a Article) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Article.
func (a Article) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Article struct.
func (a *Article) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["wordCount"]
	if v != nil {
		var wordCount int32
		err = json.Unmarshal(*m["wordCount"], &wordCount)
		if err != nil {
			return err
		}
		a.WordCount = &wordCount
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		a.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		a.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		a.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		a.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		a.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		a.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		a.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		a.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		a.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		a.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		a.Type = _type
	}

	return nil
}

// Computation defines an expression and its answer
type Computation struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string  `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query `json:"followUpQueries,omitempty"`
	// Expression - The math or conversion expression. If the query contains a request to convert units of measure (for example, meters to feet), this field contains the from units and value contains the to units. If the query contains a mathematical expression such as 2+2, this field contains the expression and value contains the answer. Note that mathematical expressions may be normalized. For example, if the query was sqrt(4^2+8^2), the normalized expression may be sqrt((4^2)+(8^2)). If the user's query is a math question and the textDecorations query parameter is set to true, the expression string may include formatting markers. For example, if the user's query is log(2), the normalized expression includes the subscript markers. For more information, see Hit Highlighting.
	Expression *string `json:"expression,omitempty"`
	// Value - The expression's answer.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Computation.
func (c Computation) MarshalJSON() ([]byte, error) {
	c.Type = TypeComputation
	type Alias Computation
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(c),
	})
}

// AsImageObject is the BasicResponseBase implementation for Computation.
func (c Computation) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Computation.
func (c Computation) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Computation.
func (c Computation) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Computation.
func (c Computation) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Computation.
func (c Computation) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Computation.
func (c Computation) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Computation.
func (c Computation) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Computation.
func (c Computation) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Computation.
func (c Computation) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Computation.
func (c Computation) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Computation.
func (c Computation) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Computation.
func (c Computation) AsComputation() (*Computation, bool) {
	return &c, true
}

// AsIdentifiable is the BasicResponseBase implementation for Computation.
func (c Computation) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &c, true
}

// AsSearchResponse is the BasicResponseBase implementation for Computation.
func (c Computation) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Computation.
func (c Computation) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicResponse() (BasicResponse, bool) {
	return &c, true
}

// AsThing is the BasicResponseBase implementation for Computation.
func (c Computation) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Computation.
func (c Computation) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Computation.
func (c Computation) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Computation.
func (c Computation) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicAnswer() (BasicAnswer, bool) {
	return &c, true
}

// AsErrorResponse is the BasicResponseBase implementation for Computation.
func (c Computation) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Computation.
func (c Computation) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Computation.
func (c Computation) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Computation.
func (c Computation) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Computation.
func (c Computation) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Computation.
func (c Computation) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Computation.
func (c Computation) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Computation.
func (c Computation) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &c, true
}

// BasicCreativeWork
type BasicCreativeWork interface {
	AsImageObject() (*ImageObject, bool)
	AsWebPage() (*WebPage, bool)
	AsNewsArticle() (*NewsArticle, bool)
	AsVideoObject() (*VideoObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork
type CreativeWork struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	type Alias CreativeWork
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cw),
	})
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsSearchResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsPlaces is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		cw.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		cw.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		cw.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cw.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		cw.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		cw.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cw.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		cw.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		cw.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cw.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		cw.Type = _type
	}

	return nil
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	type Alias ErrorResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(er),
	})
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsSearchResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsImageObject() (*ImageObject, bool)
	AsWebPage() (*WebPage, bool)
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsImages() (*Images, bool)
	AsNewsArticle() (*NewsArticle, bool)
	AsNews() (*News, bool)
	AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool)
	AsSpellSuggestions() (*SpellSuggestions, bool)
	AsTimeZone() (*TimeZone, bool)
	AsVideoObject() (*VideoObject, bool)
	AsVideos() (*Videos, bool)
	AsComputation() (*Computation, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeRelatedSearchesRelatedSearchAnswer):
		var rsrsa RelatedSearchesRelatedSearchAnswer
		err := json.Unmarshal(body, &rsrsa)
		return rsrsa, err
	case string(TypeSpellSuggestions):
		var ss SpellSuggestions
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeTimeZone):
		var tz TimeZone
		err := json.Unmarshal(body, &tz)
		return tz, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeComputation):
		var c Computation
		err := json.Unmarshal(body, &c)
		return c, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	type Alias Identifiable
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsSearchResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImageObject defines an image
type ImageObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// Thumbnail - The URL to a thumbnail of the image
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	type Alias ImageObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ioVar),
	})
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsWebPage is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsSearchResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsPlaces is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsArticle is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnail"]
	if v != nil {
		var thumbnail ImageObject
		err = json.Unmarshal(*m["thumbnail"], &thumbnail)
		if err != nil {
			return err
		}
		ioVar.Thumbnail = &thumbnail
	}

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		ioVar.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		ioVar.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		ioVar.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		ioVar.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		ioVar.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		ioVar.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		ioVar.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ioVar.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		ioVar.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		ioVar.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ioVar.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		ioVar.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		ioVar.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ioVar.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		ioVar.Type = _type
	}

	return nil
}

// Images defines an image answer
type Images struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	NextOffset            *int32 `json:"nextOffset,omitempty"`
	// Value - A list of image objects that are relevant to the query. If there are no results, the List is empty.
	Value           *[]ImageObject `json:"value,omitempty"`
	QueryExpansions *[]Query       `json:"queryExpansions,omitempty"`
	SimilarTerms    *[]Query       `json:"similarTerms,omitempty"`
	RelatedSearches *[]Query       `json:"relatedSearches,omitempty"`
}

// MarshalJSON is the custom marshaler for Images.
func (i Images) MarshalJSON() ([]byte, error) {
	i.Type = TypeImages
	type Alias Images
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsImageObject is the BasicResponseBase implementation for Images.
func (i Images) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Images.
func (i Images) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Images.
func (i Images) AsImages() (*Images, bool) {
	return &i, true
}

// AsNewsArticle is the BasicResponseBase implementation for Images.
func (i Images) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Images.
func (i Images) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Images.
func (i Images) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Images.
func (i Images) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Images.
func (i Images) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Images.
func (i Images) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Images.
func (i Images) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsSearchResponse is the BasicResponseBase implementation for Images.
func (i Images) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Images.
func (i Images) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsThing is the BasicResponseBase implementation for Images.
func (i Images) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Images.
func (i Images) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Images.
func (i Images) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicAnswer() (BasicAnswer, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Images.
func (i Images) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Images.
func (i Images) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Images.
func (i Images) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Images.
func (i Images) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Images.
func (i Images) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Images.
func (i Images) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicIntangible
type BasicIntangible interface {
	AsStructuredValue() (*StructuredValue, bool)
	AsIntangible() (*Intangible, bool)
}

// Intangible
type Intangible struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicIntangible(body []byte) (BasicIntangible, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIntangibleArray(body []byte) ([]BasicIntangible, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIntangible, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIntangible(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Intangible.
func (i Intangible) MarshalJSON() ([]byte, error) {
	i.Type = TypeIntangible
	type Alias Intangible
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsImageObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsSearchResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicThing() (BasicThing, bool) {
	return &i, true
}

// AsPlaces is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIntangible() (*Intangible, bool) {
	return &i, true
}

// AsBasicIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIntangible() (BasicIntangible, bool) {
	return &i, true
}

// AsMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicMediaObject
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject
type MediaObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	type Alias MediaObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mo),
	})
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsSearchResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsPlaces is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsArticle is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		mo.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		mo.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		mo.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		mo.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		mo.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		mo.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		mo.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mo.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		mo.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		mo.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		mo.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		mo.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		mo.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mo.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		mo.Type = _type
	}

	return nil
}

// News defines a news answer.
type News struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - An array of NewsArticle objects that contain information about news articles that are relevant to the query. If there are no results to return for the request, the array is empty.
	Value    *[]NewsArticle `json:"value,omitempty"`
	Location *string        `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for News.
func (n News) MarshalJSON() ([]byte, error) {
	n.Type = TypeNews
	type Alias News
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(n),
	})
}

// AsImageObject is the BasicResponseBase implementation for News.
func (n News) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for News.
func (n News) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for News.
func (n News) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for News.
func (n News) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for News.
func (n News) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for News.
func (n News) AsNews() (*News, bool) {
	return &n, true
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for News.
func (n News) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for News.
func (n News) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for News.
func (n News) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for News.
func (n News) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for News.
func (n News) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for News.
func (n News) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for News.
func (n News) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for News.
func (n News) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &n, true
}

// AsSearchResponse is the BasicResponseBase implementation for News.
func (n News) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for News.
func (n News) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for News.
func (n News) AsBasicResponse() (BasicResponse, bool) {
	return &n, true
}

// AsThing is the BasicResponseBase implementation for News.
func (n News) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for News.
func (n News) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for News.
func (n News) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for News.
func (n News) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for News.
func (n News) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &n, true
}

// AsAnswer is the BasicResponseBase implementation for News.
func (n News) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for News.
func (n News) AsBasicAnswer() (BasicAnswer, bool) {
	return &n, true
}

// AsErrorResponse is the BasicResponseBase implementation for News.
func (n News) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for News.
func (n News) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for News.
func (n News) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for News.
func (n News) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for News.
func (n News) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for News.
func (n News) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for News.
func (n News) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for News.
func (n News) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for News.
func (n News) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for News.
func (n News) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for News.
func (n News) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for News.
func (n News) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &n, true
}

// NewsArticle defines a news article.
type NewsArticle struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// WordCount - The number of words in the text of the Article.
	WordCount *int32 `json:"wordCount,omitempty"`
}

// MarshalJSON is the custom marshaler for NewsArticle.
func (na NewsArticle) MarshalJSON() ([]byte, error) {
	na.Type = TypeNewsArticle
	type Alias NewsArticle
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(na),
	})
}

// AsImageObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsNewsArticle() (*NewsArticle, bool) {
	return &na, true
}

// AsNews is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &na, true
}

// AsSearchResponse is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicResponse() (BasicResponse, bool) {
	return &na, true
}

// AsThing is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicThing() (BasicThing, bool) {
	return &na, true
}

// AsPlaces is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &na, true
}

// AsIntangible is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicArticle() (BasicArticle, bool) {
	return &na, true
}

// AsStructuredValue is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for NewsArticle.
func (na NewsArticle) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &na, true
}

// UnmarshalJSON is the custom unmarshaler for NewsArticle struct.
func (na *NewsArticle) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["wordCount"]
	if v != nil {
		var wordCount int32
		err = json.Unmarshal(*m["wordCount"], &wordCount)
		if err != nil {
			return err
		}
		na.WordCount = &wordCount
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		na.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		na.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		na.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		na.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		na.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		na.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		na.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		na.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		na.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		na.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		na.Type = _type
	}

	return nil
}

// Places defines a local entity answer.
type Places struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - A list of local entities, such as restaurants or hotels.
	Value *[]BasicThing `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Places.
func (p Places) MarshalJSON() ([]byte, error) {
	p.Type = TypePlaces
	type Alias Places
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(p),
	})
}

// AsImageObject is the BasicResponseBase implementation for Places.
func (p Places) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Places.
func (p Places) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Places.
func (p Places) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Places.
func (p Places) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Places.
func (p Places) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Places.
func (p Places) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Places.
func (p Places) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Places.
func (p Places) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Places.
func (p Places) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Places.
func (p Places) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Places.
func (p Places) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Places.
func (p Places) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p, true
}

// AsSearchResponse is the BasicResponseBase implementation for Places.
func (p Places) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Places.
func (p Places) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Places.
func (p Places) AsBasicResponse() (BasicResponse, bool) {
	return &p, true
}

// AsThing is the BasicResponseBase implementation for Places.
func (p Places) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Places.
func (p Places) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Places.
func (p Places) AsPlaces() (*Places, bool) {
	return &p, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &p, true
}

// AsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsBasicAnswer() (BasicAnswer, bool) {
	return &p, true
}

// AsErrorResponse is the BasicResponseBase implementation for Places.
func (p Places) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Places.
func (p Places) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Places.
func (p Places) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Places.
func (p Places) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Places.
func (p Places) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Places.
func (p Places) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Places.
func (p Places) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Places.
func (p Places) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Places.
func (p Places) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Places.
func (p Places) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Places.
func (p Places) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Places.
func (p Places) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p, true
}

// UnmarshalJSON is the custom unmarshaler for Places struct.
func (p *Places) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["value"]
	if v != nil {
		value, err := unmarshalBasicThingArray(*m["value"])
		if err != nil {
			return err
		}
		p.Value = &value
	}

	v = m["queryContext"]
	if v != nil {
		var queryContext QueryContext
		err = json.Unmarshal(*m["queryContext"], &queryContext)
		if err != nil {
			return err
		}
		p.QueryContext = &queryContext
	}

	v = m["totalEstimatedMatches"]
	if v != nil {
		var totalEstimatedMatches int64
		err = json.Unmarshal(*m["totalEstimatedMatches"], &totalEstimatedMatches)
		if err != nil {
			return err
		}
		p.TotalEstimatedMatches = &totalEstimatedMatches
	}

	v = m["isFamilyFriendly"]
	if v != nil {
		var isFamilyFriendly bool
		err = json.Unmarshal(*m["isFamilyFriendly"], &isFamilyFriendly)
		if err != nil {
			return err
		}
		p.IsFamilyFriendly = &isFamilyFriendly
	}

	v = m["followUpQueries"]
	if v != nil {
		var followUpQueries []Query
		err = json.Unmarshal(*m["followUpQueries"], &followUpQueries)
		if err != nil {
			return err
		}
		p.FollowUpQueries = &followUpQueries
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		p.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		p.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		p.Type = _type
	}

	return nil
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - The display version of the query term. This version of the query term may contain special characters that highlight the search term found in the query string. The string contains the highlighting characters only if the query enabled hit highlighting
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - The URL that takes the user to the Bing search results page for the query.Only related search results include this field.
	WebSearchURL *string      `json:"webSearchUrl,omitempty"`
	SearchLink   *string      `json:"searchLink,omitempty"`
	Thumbnail    *ImageObject `json:"thumbnail,omitempty"`
}

// QueryContext defines the query context that Bing used for the request.
type QueryContext struct {
	// OriginalQuery - The query string as specified in the request.
	OriginalQuery *string `json:"originalQuery,omitempty"`
	// AlteredQuery - The query string used by Bing to perform the query. Bing uses the altered query string if the original query string contained spelling mistakes. For example, if the query string is "saling downwind", the altered query string will be "sailing downwind". This field is included only if the original query string contains a spelling mistake.
	AlteredQuery *string `json:"alteredQuery,omitempty"`
	// AlterationOverrideQuery - The query string to use to force Bing to use the original string. For example, if the query string is "saling downwind", the override query string will be "+saling downwind". Remember to encode the query string which results in "%2Bsaling+downwind". This field is included only if the original query string contains a spelling mistake.
	AlterationOverrideQuery *string `json:"alterationOverrideQuery,omitempty"`
	// AdultIntent - A Boolean value that indicates whether the specified query has adult intent. The value is true if the query has adult intent; otherwise, false.
	AdultIntent *bool `json:"adultIntent,omitempty"`
	// AskUserForLocation - A Boolean value that indicates whether Bing requires the user's location to provide accurate results. If you specified the user's location by using the X-MSEdge-ClientIP and X-Search-Location headers, you can ignore this field. For location aware queries, such as "today's weather" or "restaurants near me" that need the user's location to provide accurate results, this field is set to true. For location aware queries that include the location (for example, "Seattle weather"), this field is set to false. This field is also set to false for queries that are not location aware, such as "best sellers".
	AskUserForLocation *bool `json:"askUserForLocation,omitempty"`
	IsTransactional    *bool `json:"isTransactional,omitempty"`
}

// RankingRankingGroup defines a search results group, such as mainline.
type RankingRankingGroup struct {
	// Items - A list of search result items to display in the group.
	Items *[]RankingRankingItem `json:"items,omitempty"`
}

// RankingRankingItem defines a search result item to display
type RankingRankingItem struct {
	// AnswerType - The answer that contains the item to display. Use the type to find the answer in the SearchResponse object. The type is the name of a SearchResponse field. Possible values include: 'AnswerTypeWebPages', 'AnswerTypeImages', 'AnswerTypeSpellSuggestions', 'AnswerTypeNews', 'AnswerTypeRelatedSearches', 'AnswerTypeVideos', 'AnswerTypeComputation', 'AnswerTypeTimeZone'
	AnswerType AnswerType `json:"answerType,omitempty"`
	// ResultIndex - A zero-based index of the item in the answer.If the item does not include this field, display all items in the answer. For example, display all news articles in the News answer.
	ResultIndex *int32 `json:"resultIndex,omitempty"`
	// Value - The ID that identifies either an answer to display or an item of an answer to display. If the ID identifies an answer, display all items of the answer.
	Value           BasicIdentifiable `json:"value,omitempty"`
	HTMLIndex       *int32            `json:"htmlIndex,omitempty"`
	TextualIndex    *int32            `json:"textualIndex,omitempty"`
	ScreenshotIndex *int32            `json:"screenshotIndex,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RankingRankingItem struct.
func (rri *RankingRankingItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["answerType"]
	if v != nil {
		var answerType AnswerType
		err = json.Unmarshal(*m["answerType"], &answerType)
		if err != nil {
			return err
		}
		rri.AnswerType = answerType
	}

	v = m["resultIndex"]
	if v != nil {
		var resultIndex int32
		err = json.Unmarshal(*m["resultIndex"], &resultIndex)
		if err != nil {
			return err
		}
		rri.ResultIndex = &resultIndex
	}

	v = m["value"]
	if v != nil {
		value, err := unmarshalBasicIdentifiable(*m["value"])
		if err != nil {
			return err
		}
		rri.Value = value
	}

	v = m["htmlIndex"]
	if v != nil {
		var HTMLIndex int32
		err = json.Unmarshal(*m["htmlIndex"], &HTMLIndex)
		if err != nil {
			return err
		}
		rri.HTMLIndex = &HTMLIndex
	}

	v = m["textualIndex"]
	if v != nil {
		var textualIndex int32
		err = json.Unmarshal(*m["textualIndex"], &textualIndex)
		if err != nil {
			return err
		}
		rri.TextualIndex = &textualIndex
	}

	v = m["screenshotIndex"]
	if v != nil {
		var screenshotIndex int32
		err = json.Unmarshal(*m["screenshotIndex"], &screenshotIndex)
		if err != nil {
			return err
		}
		rri.ScreenshotIndex = &screenshotIndex
	}

	return nil
}

// RankingRankingResponse defines where on the search results page content should be placed and in what order.
type RankingRankingResponse struct {
	// Pole - The search results that should be afforded the most visible treatment (for example, displayed above the mainline and sidebar).
	Pole *RankingRankingGroup `json:"pole,omitempty"`
	// Mainline - The search results to display in the mainline.
	Mainline *RankingRankingGroup `json:"mainline,omitempty"`
	// Sidebar - The search results to display in the sidebar.
	Sidebar *RankingRankingGroup `json:"sidebar,omitempty"`
}

// RelatedSearchesRelatedSearchAnswer defines a list of related queries made by others.
type RelatedSearchesRelatedSearchAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - A list of related queries that were made by others.
	Value *[]Query `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) MarshalJSON() ([]byte, error) {
	rsrsa.Type = TypeRelatedSearchesRelatedSearchAnswer
	type Alias RelatedSearchesRelatedSearchAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rsrsa),
	})
}

// AsImageObject is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return &rsrsa, true
}

// AsSpellSuggestions is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &rsrsa, true
}

// AsSearchResponse is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &rsrsa, true
}

// AsThing is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &rsrsa, true
}

// AsAnswer is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &rsrsa, true
}

// AsErrorResponse is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for RelatedSearchesRelatedSearchAnswer.
func (rsrsa RelatedSearchesRelatedSearchAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rsrsa, true
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsImageObject() (*ImageObject, bool)
	AsWebPage() (*WebPage, bool)
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsImages() (*Images, bool)
	AsNewsArticle() (*NewsArticle, bool)
	AsNews() (*News, bool)
	AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool)
	AsSpellSuggestions() (*SpellSuggestions, bool)
	AsTimeZone() (*TimeZone, bool)
	AsVideoObject() (*VideoObject, bool)
	AsVideos() (*Videos, bool)
	AsComputation() (*Computation, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit from this
type Response struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeRelatedSearchesRelatedSearchAnswer):
		var rsrsa RelatedSearchesRelatedSearchAnswer
		err := json.Unmarshal(body, &rsrsa)
		return rsrsa, err
	case string(TypeSpellSuggestions):
		var ss SpellSuggestions
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeTimeZone):
		var tz TimeZone
		err := json.Unmarshal(body, &tz)
		return tz, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeComputation):
		var c Computation
		err := json.Unmarshal(body, &c)
		return c, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	type Alias Response
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Response.
func (r Response) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Response.
func (r Response) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Response.
func (r Response) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Response.
func (r Response) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Response.
func (r Response) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Response.
func (r Response) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Response.
func (r Response) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Response.
func (r Response) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Response.
func (r Response) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsSearchResponse is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Response.
func (r Response) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Response.
func (r Response) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Response.
func (r Response) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase
type BasicResponseBase interface {
	AsImageObject() (*ImageObject, bool)
	AsWebPage() (*WebPage, bool)
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsImages() (*Images, bool)
	AsNewsArticle() (*NewsArticle, bool)
	AsNews() (*News, bool)
	AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool)
	AsSpellSuggestions() (*SpellSuggestions, bool)
	AsTimeZone() (*TimeZone, bool)
	AsVideoObject() (*VideoObject, bool)
	AsVideos() (*Videos, bool)
	AsComputation() (*Computation, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeRelatedSearchesRelatedSearchAnswer):
		var rsrsa RelatedSearchesRelatedSearchAnswer
		err := json.Unmarshal(body, &rsrsa)
		return rsrsa, err
	case string(TypeSpellSuggestions):
		var ss SpellSuggestions
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeTimeZone):
		var tz TimeZone
		err := json.Unmarshal(body, &tz)
		return tz, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeComputation):
		var c Computation
		err := json.Unmarshal(body, &c)
		return c, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	type Alias ResponseBase
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rb),
	})
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// SearchResponse defines the top-level object that the response includes when the request succeeds.
type SearchResponse struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// QueryContext - An object that contains the query string that Bing used for the request. This object contains the query string as entered by the user. It may also contain an altered query string that Bing used for the query if the query string contained a spelling mistake.
	QueryContext *QueryContext `json:"queryContext,omitempty"`
	// WebPages - A list of webpages that are relevant to the search query.
	WebPages *WebWebAnswer `json:"webPages,omitempty"`
	// Images - A list of images that are relevant to the search query.
	Images *Images `json:"images,omitempty"`
	// News - A list of news articles that are relevant to the search query.
	News *News `json:"news,omitempty"`
	// RelatedSearches - A list of related queries made by others.
	RelatedSearches *RelatedSearchesRelatedSearchAnswer `json:"relatedSearches,omitempty"`
	// SpellSuggestions - The query string that likely represents the user's intent.
	SpellSuggestions *SpellSuggestions `json:"spellSuggestions,omitempty"`
	// TimeZone - The date and time of one or more geographic locations.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// Videos - A list of videos that are relevant to the search query.
	Videos *Videos `json:"videos,omitempty"`
	// Computation - The answer to a math expression or units conversion expression.
	Computation *Computation `json:"computation,omitempty"`
	// RankingResponse - The order that Bing suggests that you display the search results in.
	RankingResponse *RankingRankingResponse `json:"rankingResponse,omitempty"`
}

// MarshalJSON is the custom marshaler for SearchResponse.
func (sr SearchResponse) MarshalJSON() ([]byte, error) {
	sr.Type = TypeSearchResponse
	type Alias SearchResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sr),
	})
}

// AsImageObject is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sr, true
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResponse() (*SearchResponse, bool) {
	return &sr, true
}

// AsResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponse() (BasicResponse, bool) {
	return &sr, true
}

// AsThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sr, true
}

// BasicSearchResultsAnswer
type BasicSearchResultsAnswer interface {
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsImages() (*Images, bool)
	AsNews() (*News, bool)
	AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool)
	AsSpellSuggestions() (*SpellSuggestions, bool)
	AsTimeZone() (*TimeZone, bool)
	AsVideos() (*Videos, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer
type SearchResultsAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeNews):
		var n News
		err := json.Unmarshal(body, &n)
		return n, err
	case string(TypeRelatedSearchesRelatedSearchAnswer):
		var rsrsa RelatedSearchesRelatedSearchAnswer
		err := json.Unmarshal(body, &rsrsa)
		return rsrsa, err
	case string(TypeSpellSuggestions):
		var ss SpellSuggestions
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeTimeZone):
		var tz TimeZone
		err := json.Unmarshal(body, &tz)
		return tz, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	type Alias SearchResultsAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sra),
	})
}

// AsImageObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// SpellSuggestions defines a suggested query string that likely represents the user's intent. The search results
// include this response if Bing determines that the user may have intended to search for something different. For
// example, if the user searches for alon brown, Bing may determine that the user likely intended to search for Alton
// Brown instead (based on past searches by others of Alon Brown).
type SpellSuggestions struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - A list of suggested query strings that may represent the user's intention. The list contains only one Query object.
	Value *[]Query `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SpellSuggestions.
func (ss SpellSuggestions) MarshalJSON() ([]byte, error) {
	ss.Type = TypeSpellSuggestions
	type Alias SpellSuggestions
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ss),
	})
}

// AsImageObject is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return &ss, true
}

// AsTimeZone is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ss, true
}

// AsSearchResponse is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicResponse() (BasicResponse, bool) {
	return &ss, true
}

// AsThing is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &ss, true
}

// AsAnswer is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicAnswer() (BasicAnswer, bool) {
	return &ss, true
}

// AsErrorResponse is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SpellSuggestions.
func (ss SpellSuggestions) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ss, true
}

// StructuredValue ...
type StructuredValue struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

// MarshalJSON is the custom marshaler for StructuredValue.
func (sv StructuredValue) MarshalJSON() ([]byte, error) {
	sv.Type = TypeStructuredValue
	type Alias StructuredValue
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sv),
	})
}

// AsImageObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sv, true
}

// AsSearchResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponse() (BasicResponse, bool) {
	return &sv, true
}

// AsThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicThing() (BasicThing, bool) {
	return &sv, true
}

// AsPlaces is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIntangible() (BasicIntangible, bool) {
	return &sv, true
}

// AsMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsStructuredValue() (*StructuredValue, bool) {
	return &sv, true
}

// AsResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sv, true
}

// BasicThing
type BasicThing interface {
	AsImageObject() (*ImageObject, bool)
	AsWebPage() (*WebPage, bool)
	AsNewsArticle() (*NewsArticle, bool)
	AsVideoObject() (*VideoObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsArticle() (*Article, bool)
	AsBasicArticle() (BasicArticle, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsThing() (*Thing, bool)
}

// Thing
type Thing struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeNewsArticle):
		var na NewsArticle
		err := json.Unmarshal(body, &na)
		return na, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeArticle):
		var a Article
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	type Alias Thing
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(t),
	})
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Thing.
func (t Thing) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Thing.
func (t Thing) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Thing.
func (t Thing) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Thing.
func (t Thing) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Thing.
func (t Thing) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Thing.
func (t Thing) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for Thing.
func (t Thing) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsSearchResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsPlaces is the BasicResponseBase implementation for Thing.
func (t Thing) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Thing.
func (t Thing) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// TimeZone defines the data and time of one or more geographic locations.
type TimeZone struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// PrimaryCityTime - The data and time, in UTC, of the geographic location specified in the query. If the query specified a specific geographic location (for example, a city), this object contains the name of the geographic location and the current date and time of the location, in UTC. If the query specified a general geographic location, such as a state or country, this object contains the date and time of the primary city or state found in the specified state or country. If the location contains additional time zones, the otherCityTimes field contains the data and time of cities or states located in the other time zones.
	PrimaryCityTime *TimeZoneTimeZoneInformation `json:"primaryCityTime,omitempty"`
	// OtherCityTimes - A list of dates and times of nearby time zones.
	OtherCityTimes *[]TimeZoneTimeZoneInformation `json:"otherCityTimes,omitempty"`
}

// MarshalJSON is the custom marshaler for TimeZone.
func (tz TimeZone) MarshalJSON() ([]byte, error) {
	tz.Type = TypeTimeZone
	type Alias TimeZone
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(tz),
	})
}

// AsImageObject is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsTimeZone() (*TimeZone, bool) {
	return &tz, true
}

// AsVideoObject is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &tz, true
}

// AsSearchResponse is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicResponse() (BasicResponse, bool) {
	return &tz, true
}

// AsThing is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &tz, true
}

// AsAnswer is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicAnswer() (BasicAnswer, bool) {
	return &tz, true
}

// AsErrorResponse is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for TimeZone.
func (tz TimeZone) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &tz, true
}

// TimeZoneTimeZoneInformation defines a date and time for a geographical location.
type TimeZoneTimeZoneInformation struct {
	// Location - The name of the geographical location.For example, County; City; City, State; City, State, Country; or Time Zone.
	Location *string `json:"location,omitempty"`
	// Time - The data and time specified in the form, YYYY-MM-DDThh;mm:ss.ssssssZ.
	Time *string `json:"time,omitempty"`
	// UtcOffset - The offset from UTC. For example, UTC-7.
	UtcOffset *string `json:"utcOffset,omitempty"`
}

// VideoObject defines a video object that is relevant to the query.
type VideoObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height             *int32       `json:"height,omitempty"`
	MotionThumbnailURL *string      `json:"motionThumbnailUrl,omitempty"`
	MotionThumbnailID  *string      `json:"motionThumbnailId,omitempty"`
	EmbedHTML          *string      `json:"embedHtml,omitempty"`
	AllowHTTPSEmbed    *bool        `json:"allowHttpsEmbed,omitempty"`
	ViewCount          *int32       `json:"viewCount,omitempty"`
	Thumbnail          *ImageObject `json:"thumbnail,omitempty"`
	VideoID            *string      `json:"videoId,omitempty"`
	AllowMobileEmbed   *bool        `json:"allowMobileEmbed,omitempty"`
	IsSuperfresh       *bool        `json:"isSuperfresh,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoObject.
func (vo VideoObject) MarshalJSON() ([]byte, error) {
	vo.Type = TypeVideoObject
	type Alias VideoObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vo),
	})
}

// AsImageObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsVideoObject() (*VideoObject, bool) {
	return &vo, true
}

// AsVideos is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &vo, true
}

// AsSearchResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicResponse() (BasicResponse, bool) {
	return &vo, true
}

// AsThing is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicThing() (BasicThing, bool) {
	return &vo, true
}

// AsPlaces is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &vo, true
}

// AsIntangible is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &vo, true
}

// AsArticle is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &vo, true
}

// UnmarshalJSON is the custom unmarshaler for VideoObject struct.
func (vo *VideoObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["motionThumbnailUrl"]
	if v != nil {
		var motionThumbnailURL string
		err = json.Unmarshal(*m["motionThumbnailUrl"], &motionThumbnailURL)
		if err != nil {
			return err
		}
		vo.MotionThumbnailURL = &motionThumbnailURL
	}

	v = m["motionThumbnailId"]
	if v != nil {
		var motionThumbnailID string
		err = json.Unmarshal(*m["motionThumbnailId"], &motionThumbnailID)
		if err != nil {
			return err
		}
		vo.MotionThumbnailID = &motionThumbnailID
	}

	v = m["embedHtml"]
	if v != nil {
		var embedHTML string
		err = json.Unmarshal(*m["embedHtml"], &embedHTML)
		if err != nil {
			return err
		}
		vo.EmbedHTML = &embedHTML
	}

	v = m["allowHttpsEmbed"]
	if v != nil {
		var allowHTTPSEmbed bool
		err = json.Unmarshal(*m["allowHttpsEmbed"], &allowHTTPSEmbed)
		if err != nil {
			return err
		}
		vo.AllowHTTPSEmbed = &allowHTTPSEmbed
	}

	v = m["viewCount"]
	if v != nil {
		var viewCount int32
		err = json.Unmarshal(*m["viewCount"], &viewCount)
		if err != nil {
			return err
		}
		vo.ViewCount = &viewCount
	}

	v = m["thumbnail"]
	if v != nil {
		var thumbnail ImageObject
		err = json.Unmarshal(*m["thumbnail"], &thumbnail)
		if err != nil {
			return err
		}
		vo.Thumbnail = &thumbnail
	}

	v = m["videoId"]
	if v != nil {
		var videoID string
		err = json.Unmarshal(*m["videoId"], &videoID)
		if err != nil {
			return err
		}
		vo.VideoID = &videoID
	}

	v = m["allowMobileEmbed"]
	if v != nil {
		var allowMobileEmbed bool
		err = json.Unmarshal(*m["allowMobileEmbed"], &allowMobileEmbed)
		if err != nil {
			return err
		}
		vo.AllowMobileEmbed = &allowMobileEmbed
	}

	v = m["isSuperfresh"]
	if v != nil {
		var isSuperfresh bool
		err = json.Unmarshal(*m["isSuperfresh"], &isSuperfresh)
		if err != nil {
			return err
		}
		vo.IsSuperfresh = &isSuperfresh
	}

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		vo.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		vo.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		vo.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		vo.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		vo.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		vo.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		vo.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		vo.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		vo.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		vo.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		vo.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		vo.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		vo.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		vo.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		vo.Type = _type
	}

	return nil
}

// Videos defines a video answer.
type Videos struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - A list of video objects that are relevant to the query.
	Value           *[]VideoObject `json:"value,omitempty"`
	NextOffset      *int32         `json:"nextOffset,omitempty"`
	QueryExpansions *[]Query       `json:"queryExpansions,omitempty"`
	RelatedSearches *[]Query       `json:"relatedSearches,omitempty"`
}

// MarshalJSON is the custom marshaler for Videos.
func (vVar Videos) MarshalJSON() ([]byte, error) {
	vVar.Type = TypeVideos
	type Alias Videos
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vVar),
	})
}

// AsImageObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsVideos() (*Videos, bool) {
	return &vVar, true
}

// AsComputation is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &vVar, true
}

// AsSearchResponse is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicResponse() (BasicResponse, bool) {
	return &vVar, true
}

// AsThing is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &vVar, true
}

// AsAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicAnswer() (BasicAnswer, bool) {
	return &vVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &vVar, true
}

// WebMetaTag defines a webpage's metadata.
type WebMetaTag struct {
	// Name - The metadata.
	Name *string `json:"name,omitempty"`
	// Content - The name of the metadata.
	Content *string `json:"content,omitempty"`
}

// WebPage defines a webpage that is relevant to the query.
type WebPage struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// DisplayURL - The display URL of the webpage. The URL is meant for display purposes only and is not well formed.
	DisplayURL *string `json:"displayUrl,omitempty"`
	// Snippet - A snippet of text from the webpage that describes its contents.
	Snippet *string `json:"snippet,omitempty"`
	// DeepLinks - A list of links to related content that Bing found in the website that contains this webpage. The Webpage object in this context includes only the name, url, urlPingSuffix, and snippet fields.
	DeepLinks *[]WebPage `json:"deepLinks,omitempty"`
	// DateLastCrawled - The last time that Bing crawled the webpage. The date is in the form, YYYY-MM-DDTHH:MM:SS. For example, 2015-04-13T05:23:39.
	DateLastCrawled *string `json:"dateLastCrawled,omitempty"`
	// SearchTags - A list of search tags that the webpage owner specified on the webpage. The API returns only indexed search tags. The name field of the MetaTag object contains the indexed search tag. Search tags begin with search.* (for example, search.assetId). The content field contains the tag's value.
	SearchTags         *[]WebMetaTag `json:"searchTags,omitempty"`
	PrimaryImageOfPage *ImageObject  `json:"primaryImageOfPage,omitempty"`
}

// MarshalJSON is the custom marshaler for WebPage.
func (wp WebPage) MarshalJSON() ([]byte, error) {
	wp.Type = TypeWebPage
	type Alias WebPage
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(wp),
	})
}

// AsImageObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsWebPage() (*WebPage, bool) {
	return &wp, true
}

// AsWebWebAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &wp, true
}

// AsSearchResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponse() (BasicResponse, bool) {
	return &wp, true
}

// AsThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicThing() (BasicThing, bool) {
	return &wp, true
}

// AsPlaces is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &wp, true
}

// AsIntangible is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &wp, true
}

// UnmarshalJSON is the custom unmarshaler for WebPage struct.
func (wp *WebPage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["displayUrl"]
	if v != nil {
		var displayURL string
		err = json.Unmarshal(*m["displayUrl"], &displayURL)
		if err != nil {
			return err
		}
		wp.DisplayURL = &displayURL
	}

	v = m["snippet"]
	if v != nil {
		var snippet string
		err = json.Unmarshal(*m["snippet"], &snippet)
		if err != nil {
			return err
		}
		wp.Snippet = &snippet
	}

	v = m["deepLinks"]
	if v != nil {
		var deepLinks []WebPage
		err = json.Unmarshal(*m["deepLinks"], &deepLinks)
		if err != nil {
			return err
		}
		wp.DeepLinks = &deepLinks
	}

	v = m["dateLastCrawled"]
	if v != nil {
		var dateLastCrawled string
		err = json.Unmarshal(*m["dateLastCrawled"], &dateLastCrawled)
		if err != nil {
			return err
		}
		wp.DateLastCrawled = &dateLastCrawled
	}

	v = m["searchTags"]
	if v != nil {
		var searchTags []WebMetaTag
		err = json.Unmarshal(*m["searchTags"], &searchTags)
		if err != nil {
			return err
		}
		wp.SearchTags = &searchTags
	}

	v = m["primaryImageOfPage"]
	if v != nil {
		var primaryImageOfPage ImageObject
		err = json.Unmarshal(*m["primaryImageOfPage"], &primaryImageOfPage)
		if err != nil {
			return err
		}
		wp.PrimaryImageOfPage = &primaryImageOfPage
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		wp.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		wp.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		wp.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		wp.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		wp.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		wp.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		wp.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		wp.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		wp.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		wp.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		wp.Type = _type
	}

	return nil
}

// WebWebAnswer defines a list of relevant webpage links.
type WebWebAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeImages', 'TypeNewsArticle', 'TypeNews', 'TypeRelatedSearchesRelatedSearchAnswer', 'TypeSpellSuggestions', 'TypeTimeZone', 'TypeVideoObject', 'TypeVideos', 'TypeComputation', 'TypeIdentifiable', 'TypeSearchResponse', 'TypeResponse', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeMediaObject', 'TypeArticle', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - A list of webpages that are relevant to the query.
	Value *[]WebPage `json:"value,omitempty"`
	// SomeResultsRemoved - A Boolean value that indicates whether the response excluded some results from the answer. If Bing excluded some results, the value is true.
	SomeResultsRemoved *bool `json:"someResultsRemoved,omitempty"`
}

// MarshalJSON is the custom marshaler for WebWebAnswer.
func (wwa WebWebAnswer) MarshalJSON() ([]byte, error) {
	wwa.Type = TypeWebWebAnswer
	type Alias WebWebAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(wwa),
	})
}

// AsImageObject is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return &wwa, true
}

// AsImages is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsImages() (*Images, bool) {
	return nil, false
}

// AsNewsArticle is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsNewsArticle() (*NewsArticle, bool) {
	return nil, false
}

// AsNews is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsNews() (*News, bool) {
	return nil, false
}

// AsRelatedSearchesRelatedSearchAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsRelatedSearchesRelatedSearchAnswer() (*RelatedSearchesRelatedSearchAnswer, bool) {
	return nil, false
}

// AsSpellSuggestions is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsSpellSuggestions() (*SpellSuggestions, bool) {
	return nil, false
}

// AsTimeZone is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsTimeZone() (*TimeZone, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsComputation is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsComputation() (*Computation, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &wwa, true
}

// AsSearchResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &wwa, true
}

// AsThing is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &wwa, true
}

// AsAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &wwa, true
}

// AsErrorResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsArticle is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsArticle() (*Article, bool) {
	return nil, false
}

// AsBasicArticle is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicArticle() (BasicArticle, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &wwa, true
}

// BasicWebWebGrouping
type BasicWebWebGrouping interface {
	AsWebWebGrouping() (*WebWebGrouping, bool)
}

// WebWebGrouping
type WebWebGrouping struct {
	WebPages *[]WebPage `json:"webPages,omitempty"`
	// Type - Possible values include: 'TypeWebWebGrouping'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicWebWebGrouping(body []byte) (BasicWebWebGrouping, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var wwg WebWebGrouping
		err := json.Unmarshal(body, &wwg)
		return wwg, err
	}
}
func unmarshalBasicWebWebGroupingArray(body []byte) ([]BasicWebWebGrouping, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wwgArray := make([]BasicWebWebGrouping, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wwg, err := unmarshalBasicWebWebGrouping(*rawMessage)
		if err != nil {
			return nil, err
		}
		wwgArray[index] = wwg
	}
	return wwgArray, nil
}

// MarshalJSON is the custom marshaler for WebWebGrouping.
func (wwg WebWebGrouping) MarshalJSON() ([]byte, error) {
	wwg.Type = TypeWebWebGrouping
	type Alias WebWebGrouping
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(wwg),
	})
}

// AsWebWebGrouping is the BasicWebWebGrouping implementation for WebWebGrouping.
func (wwg WebWebGrouping) AsWebWebGrouping() (*WebWebGrouping, bool) {
	return &wwg, true
}

// AsBasicWebWebGrouping is the BasicWebWebGrouping implementation for WebWebGrouping.
func (wwg WebWebGrouping) AsBasicWebWebGrouping() (BasicWebWebGrouping, bool) {
	return &wwg, true
}
