package mobileengagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// ExportTasksClient is the microsoft Azure Mobile Engagement REST APIs.
type ExportTasksClient struct {
	BaseClient
}

// NewExportTasksClient creates an instance of the ExportTasksClient client.
func NewExportTasksClient(subscriptionID string) ExportTasksClient {
	return NewExportTasksClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewExportTasksClientWithBaseURI creates an instance of the ExportTasksClient client.
func NewExportTasksClientWithBaseURI(baseURI string, subscriptionID string) ExportTasksClient {
	return ExportTasksClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateActivitiesTask creates a task to export activities.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateActivitiesTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.StartDate", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.EndDate", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateActivitiesTask", err.Error())
	}

	req, err := client.CreateActivitiesTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateActivitiesTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateActivitiesTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateActivitiesTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateActivitiesTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateActivitiesTask", resp, "Failure responding to request")
	}

	return
}

// CreateActivitiesTaskPreparer prepares the CreateActivitiesTask request.
func (client ExportTasksClient) CreateActivitiesTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/activities", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateActivitiesTaskSender sends the CreateActivitiesTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateActivitiesTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateActivitiesTaskResponder handles the response to the CreateActivitiesTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateActivitiesTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateCrashesTask creates a task to export crashes.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateCrashesTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.StartDate", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.EndDate", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateCrashesTask", err.Error())
	}

	req, err := client.CreateCrashesTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateCrashesTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateCrashesTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateCrashesTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateCrashesTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateCrashesTask", resp, "Failure responding to request")
	}

	return
}

// CreateCrashesTaskPreparer prepares the CreateCrashesTask request.
func (client ExportTasksClient) CreateCrashesTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/crashes", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateCrashesTaskSender sends the CreateCrashesTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateCrashesTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateCrashesTaskResponder handles the response to the CreateCrashesTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateCrashesTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateErrorsTask creates a task to export errors.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateErrorsTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.StartDate", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.EndDate", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateErrorsTask", err.Error())
	}

	req, err := client.CreateErrorsTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateErrorsTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateErrorsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateErrorsTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateErrorsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateErrorsTask", resp, "Failure responding to request")
	}

	return
}

// CreateErrorsTaskPreparer prepares the CreateErrorsTask request.
func (client ExportTasksClient) CreateErrorsTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/errors", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateErrorsTaskSender sends the CreateErrorsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateErrorsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateErrorsTaskResponder handles the response to the CreateErrorsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateErrorsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateEventsTask creates a task to export events.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateEventsTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.StartDate", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.EndDate", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateEventsTask", err.Error())
	}

	req, err := client.CreateEventsTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateEventsTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateEventsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateEventsTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateEventsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateEventsTask", resp, "Failure responding to request")
	}

	return
}

// CreateEventsTaskPreparer prepares the CreateEventsTask request.
func (client ExportTasksClient) CreateEventsTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/events", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateEventsTaskSender sends the CreateEventsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateEventsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateEventsTaskResponder handles the response to the CreateEventsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateEventsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateFeedbackTaskByCampaign creates a task to export push campaign data for a set of campaigns.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateFeedbackTaskByCampaign(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters FeedbackByCampaignParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.CampaignIds", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "parameters.CampaignIds", Name: validation.MinItems, Rule: 1, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateFeedbackTaskByCampaign", err.Error())
	}

	req, err := client.CreateFeedbackTaskByCampaignPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByCampaign", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateFeedbackTaskByCampaignSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByCampaign", resp, "Failure sending request")
		return
	}

	result, err = client.CreateFeedbackTaskByCampaignResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByCampaign", resp, "Failure responding to request")
	}

	return
}

// CreateFeedbackTaskByCampaignPreparer prepares the CreateFeedbackTaskByCampaign request.
func (client ExportTasksClient) CreateFeedbackTaskByCampaignPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters FeedbackByCampaignParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/feedbackByCampaign", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateFeedbackTaskByCampaignSender sends the CreateFeedbackTaskByCampaign request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateFeedbackTaskByCampaignSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateFeedbackTaskByCampaignResponder handles the response to the CreateFeedbackTaskByCampaign request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateFeedbackTaskByCampaignResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateFeedbackTaskByDateRange creates a task to export push campaign data for a date range.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateFeedbackTaskByDateRange(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters FeedbackByDateRangeParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.CampaignWindowStart", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.CampaignWindowEnd", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateFeedbackTaskByDateRange", err.Error())
	}

	req, err := client.CreateFeedbackTaskByDateRangePreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByDateRange", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateFeedbackTaskByDateRangeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByDateRange", resp, "Failure sending request")
		return
	}

	result, err = client.CreateFeedbackTaskByDateRangeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByDateRange", resp, "Failure responding to request")
	}

	return
}

// CreateFeedbackTaskByDateRangePreparer prepares the CreateFeedbackTaskByDateRange request.
func (client ExportTasksClient) CreateFeedbackTaskByDateRangePreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters FeedbackByDateRangeParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/feedbackByDate", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateFeedbackTaskByDateRangeSender sends the CreateFeedbackTaskByDateRange request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateFeedbackTaskByDateRangeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateFeedbackTaskByDateRangeResponder handles the response to the CreateFeedbackTaskByDateRange request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateFeedbackTaskByDateRangeResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateJobsTask creates a task to export jobs.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateJobsTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.StartDate", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.EndDate", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateJobsTask", err.Error())
	}

	req, err := client.CreateJobsTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateJobsTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateJobsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateJobsTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateJobsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateJobsTask", resp, "Failure responding to request")
	}

	return
}

// CreateJobsTaskPreparer prepares the CreateJobsTask request.
func (client ExportTasksClient) CreateJobsTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/jobs", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateJobsTaskSender sends the CreateJobsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateJobsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateJobsTaskResponder handles the response to the CreateJobsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateJobsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateSessionsTask creates a task to export sessions.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateSessionsTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.StartDate", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.EndDate", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateSessionsTask", err.Error())
	}

	req, err := client.CreateSessionsTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateSessionsTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSessionsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateSessionsTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateSessionsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateSessionsTask", resp, "Failure responding to request")
	}

	return
}

// CreateSessionsTaskPreparer prepares the CreateSessionsTask request.
func (client ExportTasksClient) CreateSessionsTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/sessions", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSessionsTaskSender sends the CreateSessionsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateSessionsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateSessionsTaskResponder handles the response to the CreateSessionsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateSessionsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateTagsTask creates a task to export tags.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateTagsTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters ExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateTagsTask", err.Error())
	}

	req, err := client.CreateTagsTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTagsTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateTagsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTagsTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateTagsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTagsTask", resp, "Failure responding to request")
	}

	return
}

// CreateTagsTaskPreparer prepares the CreateTagsTask request.
func (client ExportTasksClient) CreateTagsTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters ExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/tags", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateTagsTaskSender sends the CreateTagsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateTagsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateTagsTaskResponder handles the response to the CreateTagsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateTagsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateTokensTask creates a task to export tags.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name.
func (client ExportTasksClient) CreateTokensTask(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters ExportTaskParameter) (result ExportTaskResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ContainerURL", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "CreateTokensTask", err.Error())
	}

	req, err := client.CreateTokensTaskPreparer(ctx, resourceGroupName, appCollection, appName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTokensTask", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateTokensTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTokensTask", resp, "Failure sending request")
		return
	}

	result, err = client.CreateTokensTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTokensTask", resp, "Failure responding to request")
	}

	return
}

// CreateTokensTaskPreparer prepares the CreateTokensTask request.
func (client ExportTasksClient) CreateTokensTaskPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, parameters ExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/tokens", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateTokensTaskSender sends the CreateTokensTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateTokensTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateTokensTaskResponder handles the response to the CreateTokensTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateTokensTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get retrieves information about a previously created export task.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. ID is export task identifier.
func (client ExportTasksClient) Get(ctx context.Context, resourceGroupName string, appCollection string, appName string, ID string) (result ExportTaskResult, err error) {
	req, err := client.GetPreparer(ctx, resourceGroupName, appCollection, appName, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ExportTasksClient) GetPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) GetResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get the list of export tasks.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. skip is control paging of export tasks, start results at the given offset, defaults
// to 0 (1st page of data). top is control paging of export tasks, number of export tasks to return with each call.
// By default, it returns all export tasks with a default paging of 20.
// The response contains a `nextLink` property describing the path to get the next page if there are more results.
// The maximum paging limit for $top is 40. orderby is sort results by an expression which looks like
// `$orderby=taskId asc` (default when not specified).
// The syntax is orderby={property} {direction} or just orderby={property}.
// Properties that can be specified for sorting: taskId, errorDetails, dateCreated, taskStatus, and dateCreated.
// The available directions are asc (for ascending order) and desc (for descending order).
// When not specified the asc direction is used.
// Only one orderby property can be specified.
func (client ExportTasksClient) List(ctx context.Context, resourceGroupName string, appCollection string, appName string, skip *int32, top *int32, orderby string) (result ExportTaskListResultPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMaximum, Rule: 40, Chain: nil},
					{Target: "top", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("mobileengagement.ExportTasksClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, appCollection, appName, skip, top, orderby)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.etlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", resp, "Failure sending request")
		return
	}

	result.etlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ExportTasksClient) ListPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, skip *int32, top *int32, orderby string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["$skip"] = autorest.Encode("query", 0)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	} else {
		queryParameters["$top"] = autorest.Encode("query", 20)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) ListResponder(resp *http.Response) (result ExportTaskListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ExportTasksClient) listNextResults(lastResults ExportTaskListResult) (result ExportTaskListResult, err error) {
	req, err := lastResults.exportTaskListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ExportTasksClient) ListComplete(ctx context.Context, resourceGroupName string, appCollection string, appName string, skip *int32, top *int32, orderby string) (result ExportTaskListResultIterator, err error) {
	result.page, err = client.List(ctx, resourceGroupName, appCollection, appName, skip, top, orderby)
	return
}
