// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package storagesync

import original "github.com/Azure/azure-sdk-for-go/services/storagesync/mgmt/2018-04-02/storagesync"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type CloudEndpointsGroupClient = original.CloudEndpointsGroupClient
type CloudTiering = original.CloudTiering

const (
	Off CloudTiering = original.Off
	On  CloudTiering = original.On
)

type CloudTiering1 = original.CloudTiering1

const (
	CloudTiering1Off CloudTiering1 = original.CloudTiering1Off
	CloudTiering1On  CloudTiering1 = original.CloudTiering1On
)

type CloudTiering2 = original.CloudTiering2

const (
	CloudTiering2Off CloudTiering2 = original.CloudTiering2Off
	CloudTiering2On  CloudTiering2 = original.CloudTiering2On
)

type NameAvailabilityReason = original.NameAvailabilityReason

const (
	AlreadyExists NameAvailabilityReason = original.AlreadyExists
	Invalid       NameAvailabilityReason = original.Invalid
)

type Operation = original.Operation

const (
	Cancel Operation = original.Cancel
	Do     Operation = original.Do
	Undo   Operation = original.Undo
)

type Reason = original.Reason

const (
	Deleted      Reason = original.Deleted
	Registered   Reason = original.Registered
	Suspended    Reason = original.Suspended
	Unregistered Reason = original.Unregistered
	Warned       Reason = original.Warned
)

type Status = original.Status

const (
	Aborted   Status = original.Aborted
	Active    Status = original.Active
	Expired   Status = original.Expired
	Failed    Status = original.Failed
	Succeeded Status = original.Succeeded
)

type APIError = original.APIError
type AzureEntityResource = original.AzureEntityResource
type BackupRequest = original.BackupRequest
type CheckNameAvailabilityParameters = original.CheckNameAvailabilityParameters
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type CloudEndpoint = original.CloudEndpoint
type CloudEndpointArray = original.CloudEndpointArray
type CloudEndpointCreateParameters = original.CloudEndpointCreateParameters
type CloudEndpointCreateParametersProperties = original.CloudEndpointCreateParametersProperties
type CloudEndpointProperties = original.CloudEndpointProperties
type CloudEndpointsGroupCreateFuture = original.CloudEndpointsGroupCreateFuture
type CloudEndpointsGroupDeleteFuture = original.CloudEndpointsGroupDeleteFuture
type CloudEndpointsGroupPostBackupFuture = original.CloudEndpointsGroupPostBackupFuture
type CloudEndpointsGroupPostRestoreFuture = original.CloudEndpointsGroupPostRestoreFuture
type CloudEndpointsGroupPreBackupFuture = original.CloudEndpointsGroupPreBackupFuture
type CloudEndpointsGroupPreRestoreFuture = original.CloudEndpointsGroupPreRestoreFuture
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type OperationDisplayInfo = original.OperationDisplayInfo
type OperationDisplayResource = original.OperationDisplayResource
type OperationEntity = original.OperationEntity
type OperationEntityListResult = original.OperationEntityListResult
type OperationEntityListResultIterator = original.OperationEntityListResultIterator
type OperationEntityListResultPage = original.OperationEntityListResultPage
type PostBackupResponse = original.PostBackupResponse
type PostBackupResponseProperties = original.PostBackupResponseProperties
type PostRestoreRequest = original.PostRestoreRequest
type PreRestoreRequest = original.PreRestoreRequest
type ProxyResource = original.ProxyResource
type RecallActionParameters = original.RecallActionParameters
type RegisteredServer = original.RegisteredServer
type RegisteredServerArray = original.RegisteredServerArray
type RegisteredServerCreateParameters = original.RegisteredServerCreateParameters
type RegisteredServerCreateParametersProperties = original.RegisteredServerCreateParametersProperties
type RegisteredServerProperties = original.RegisteredServerProperties
type RegisteredServersGroupCreateFuture = original.RegisteredServersGroupCreateFuture
type RegisteredServersGroupDeleteFuture = original.RegisteredServersGroupDeleteFuture
type Resource = original.Resource
type ResourcesMoveInfo = original.ResourcesMoveInfo
type RestoreFileSpec = original.RestoreFileSpec
type ServerEndpoint = original.ServerEndpoint
type ServerEndpointArray = original.ServerEndpointArray
type ServerEndpointCreateParameters = original.ServerEndpointCreateParameters
type ServerEndpointCreateParametersProperties = original.ServerEndpointCreateParametersProperties
type ServerEndpointProperties = original.ServerEndpointProperties
type ServerEndpointsGroupCreateFuture = original.ServerEndpointsGroupCreateFuture
type ServerEndpointsGroupDeleteFuture = original.ServerEndpointsGroupDeleteFuture
type ServerEndpointsGroupRecallActionFuture = original.ServerEndpointsGroupRecallActionFuture
type ServerEndpointsGroupUpdateFuture = original.ServerEndpointsGroupUpdateFuture
type ServerEndpointUpdateParameters = original.ServerEndpointUpdateParameters
type ServerEndpointUpdateProperties = original.ServerEndpointUpdateProperties
type Service = original.Service
type ServiceArray = original.ServiceArray
type ServiceCreateParameters = original.ServiceCreateParameters
type ServiceProperties = original.ServiceProperties
type ServiceUpdateParameters = original.ServiceUpdateParameters
type SubscriptionState = original.SubscriptionState
type SyncGroup = original.SyncGroup
type SyncGroupArray = original.SyncGroupArray
type SyncGroupCreateParameters = original.SyncGroupCreateParameters
type SyncGroupProperties = original.SyncGroupProperties
type TrackedResource = original.TrackedResource
type Workflow = original.Workflow
type WorkflowArray = original.WorkflowArray
type WorkflowProperties = original.WorkflowProperties
type OperationsGroupClient = original.OperationsGroupClient
type RegisteredServersGroupClient = original.RegisteredServersGroupClient
type ServerEndpointsGroupClient = original.ServerEndpointsGroupClient
type ServicesGroupClient = original.ServicesGroupClient
type SyncGroupsGroupClient = original.SyncGroupsGroupClient
type WorkflowsGroupClient = original.WorkflowsGroupClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewCloudEndpointsGroupClient(subscriptionID string) CloudEndpointsGroupClient {
	return original.NewCloudEndpointsGroupClient(subscriptionID)
}
func NewCloudEndpointsGroupClientWithBaseURI(baseURI string, subscriptionID string) CloudEndpointsGroupClient {
	return original.NewCloudEndpointsGroupClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleCloudTieringValues() []CloudTiering {
	return original.PossibleCloudTieringValues()
}
func PossibleCloudTiering1Values() []CloudTiering1 {
	return original.PossibleCloudTiering1Values()
}
func PossibleCloudTiering2Values() []CloudTiering2 {
	return original.PossibleCloudTiering2Values()
}
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return original.PossibleNameAvailabilityReasonValues()
}
func PossibleOperationValues() []Operation {
	return original.PossibleOperationValues()
}
func PossibleReasonValues() []Reason {
	return original.PossibleReasonValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func NewOperationsGroupClient(subscriptionID string) OperationsGroupClient {
	return original.NewOperationsGroupClient(subscriptionID)
}
func NewOperationsGroupClientWithBaseURI(baseURI string, subscriptionID string) OperationsGroupClient {
	return original.NewOperationsGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegisteredServersGroupClient(subscriptionID string) RegisteredServersGroupClient {
	return original.NewRegisteredServersGroupClient(subscriptionID)
}
func NewRegisteredServersGroupClientWithBaseURI(baseURI string, subscriptionID string) RegisteredServersGroupClient {
	return original.NewRegisteredServersGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerEndpointsGroupClient(subscriptionID string) ServerEndpointsGroupClient {
	return original.NewServerEndpointsGroupClient(subscriptionID)
}
func NewServerEndpointsGroupClientWithBaseURI(baseURI string, subscriptionID string) ServerEndpointsGroupClient {
	return original.NewServerEndpointsGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewServicesGroupClient(subscriptionID string) ServicesGroupClient {
	return original.NewServicesGroupClient(subscriptionID)
}
func NewServicesGroupClientWithBaseURI(baseURI string, subscriptionID string) ServicesGroupClient {
	return original.NewServicesGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewSyncGroupsGroupClient(subscriptionID string) SyncGroupsGroupClient {
	return original.NewSyncGroupsGroupClient(subscriptionID)
}
func NewSyncGroupsGroupClientWithBaseURI(baseURI string, subscriptionID string) SyncGroupsGroupClient {
	return original.NewSyncGroupsGroupClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewWorkflowsGroupClient(subscriptionID string) WorkflowsGroupClient {
	return original.NewWorkflowsGroupClient(subscriptionID)
}
func NewWorkflowsGroupClientWithBaseURI(baseURI string, subscriptionID string) WorkflowsGroupClient {
	return original.NewWorkflowsGroupClientWithBaseURI(baseURI, subscriptionID)
}
