package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayCookieBasedAffinity enumerates the values for application gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled ...
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled ...
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleApplicationGatewayCookieBasedAffinityValues returns an array of possible values for the ApplicationGatewayCookieBasedAffinity const type.
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return []ApplicationGatewayCookieBasedAffinity{Disabled, Enabled}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayOperationalState enumerates the values for application gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running ...
	Running ApplicationGatewayOperationalState = "Running"
	// Starting ...
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped ...
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping ...
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleApplicationGatewayOperationalStateValues returns an array of possible values for the ApplicationGatewayOperationalState const type.
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return []ApplicationGatewayOperationalState{Running, Starting, Stopped, Stopping}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayProtocol enumerates the values for application gateway protocol.
type ApplicationGatewayProtocol string

const (
	// HTTP ...
	HTTP ApplicationGatewayProtocol = "Http"
	// HTTPS ...
	HTTPS ApplicationGatewayProtocol = "Https"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleApplicationGatewayProtocolValues returns an array of possible values for the ApplicationGatewayProtocol const type.
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return []ApplicationGatewayProtocol{HTTP, HTTPS}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayRequestRoutingRuleType enumerates the values for application gateway request routing rule
// type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic ...
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleApplicationGatewayRequestRoutingRuleTypeValues returns an array of possible values for the ApplicationGatewayRequestRoutingRuleType const type.
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return []ApplicationGatewayRequestRoutingRuleType{Basic}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaySkuName enumerates the values for application gateway sku name.
type ApplicationGatewaySkuName string

const (
	// StandardLarge ...
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium ...
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall ...
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleApplicationGatewaySkuNameValues returns an array of possible values for the ApplicationGatewaySkuName const type.
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return []ApplicationGatewaySkuName{StandardLarge, StandardMedium, StandardSmall}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// Standard ...
	Standard ApplicationGatewayTier = "Standard"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleApplicationGatewayTierValues returns an array of possible values for the ApplicationGatewayTier const type.
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return []ApplicationGatewayTier{Standard}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// Available ...
	Available AuthorizationUseStatus = "Available"
	// InUse ...
	InUse AuthorizationUseStatus = "InUse"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleAuthorizationUseStatusValues returns an array of possible values for the AuthorizationUseStatus const type.
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return []AuthorizationUseStatus{Available, InUse}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values for express route circuit
// peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// Configured ...
	Configured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// Configuring ...
	Configuring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// NotConfigured ...
	NotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ValidationNeeded ...
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues returns an array of possible values for the ExpressRouteCircuitPeeringAdvertisedPublicPrefixState const type.
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState{Configured, Configuring, NotConfigured, ValidationNeeded}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringState enumerates the values for express route circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled ...
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled ...
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleExpressRouteCircuitPeeringStateValues returns an array of possible values for the ExpressRouteCircuitPeeringState const type.
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return []ExpressRouteCircuitPeeringState{ExpressRouteCircuitPeeringStateDisabled, ExpressRouteCircuitPeeringStateEnabled}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringType enumerates the values for express route circuit peering type.
type ExpressRouteCircuitPeeringType string

const (
	// AzurePrivatePeering ...
	AzurePrivatePeering ExpressRouteCircuitPeeringType = "AzurePrivatePeering"
	// AzurePublicPeering ...
	AzurePublicPeering ExpressRouteCircuitPeeringType = "AzurePublicPeering"
	// MicrosoftPeering ...
	MicrosoftPeering ExpressRouteCircuitPeeringType = "MicrosoftPeering"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleExpressRouteCircuitPeeringTypeValues returns an array of possible values for the ExpressRouteCircuitPeeringType const type.
func PossibleExpressRouteCircuitPeeringTypeValues() []ExpressRouteCircuitPeeringType {
	return []ExpressRouteCircuitPeeringType{AzurePrivatePeering, AzurePublicPeering, MicrosoftPeering}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitSkuFamily enumerates the values for express route circuit sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// MeteredData ...
	MeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// UnlimitedData ...
	UnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleExpressRouteCircuitSkuFamilyValues returns an array of possible values for the ExpressRouteCircuitSkuFamily const type.
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return []ExpressRouteCircuitSkuFamily{MeteredData, UnlimitedData}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitSkuTier enumerates the values for express route circuit sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierPremium ...
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard ...
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleExpressRouteCircuitSkuTierValues returns an array of possible values for the ExpressRouteCircuitSkuTier const type.
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return []ExpressRouteCircuitSkuTier{ExpressRouteCircuitSkuTierPremium, ExpressRouteCircuitSkuTierStandard}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic ...
	Dynamic IPAllocationMethod = "Dynamic"
	// Static ...
	Static IPAllocationMethod = "Static"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleIPAllocationMethodValues returns an array of possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{Dynamic, Static}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// Default ...
	Default LoadDistribution = "Default"
	// SourceIP ...
	SourceIP LoadDistribution = "SourceIP"
	// SourceIPProtocol ...
	SourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleLoadDistributionValues returns an array of possible values for the LoadDistribution const type.
func PossibleLoadDistributionValues() []LoadDistribution {
	return []LoadDistribution{Default, SourceIP, SourceIPProtocol}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed ...
	Failed OperationStatus = "Failed"
	// InProgress ...
	InProgress OperationStatus = "InProgress"
	// Succeeded ...
	Succeeded OperationStatus = "Succeeded"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{Failed, InProgress, Succeeded}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolTCP ...
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolTCP}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet ...
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone ...
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance ...
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway ...
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal ...
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleRouteNextHopTypeValues returns an array of possible values for the RouteNextHopType const type.
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return []RouteNextHopType{RouteNextHopTypeInternet, RouteNextHopTypeNone, RouteNextHopTypeVirtualAppliance, RouteNextHopTypeVirtualNetworkGateway, RouteNextHopTypeVnetLocal}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// Allow ...
	Allow SecurityRuleAccess = "Allow"
	// Deny ...
	Deny SecurityRuleAccess = "Deny"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleSecurityRuleAccessValues returns an array of possible values for the SecurityRuleAccess const type.
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return []SecurityRuleAccess{Allow, Deny}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// Inbound ...
	Inbound SecurityRuleDirection = "Inbound"
	// Outbound ...
	Outbound SecurityRuleDirection = "Outbound"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleSecurityRuleDirectionValues returns an array of possible values for the SecurityRuleDirection const type.
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return []SecurityRuleDirection{Inbound, Outbound}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// Asterisk ...
	Asterisk SecurityRuleProtocol = "*"
	// TCP ...
	TCP SecurityRuleProtocol = "Tcp"
	// UDP ...
	UDP SecurityRuleProtocol = "Udp"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleSecurityRuleProtocolValues returns an array of possible values for the SecurityRuleProtocol const type.
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return []SecurityRuleProtocol{Asterisk, TCP, UDP}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ServiceProviderProvisioningState enumerates the values for service provider provisioning state.
type ServiceProviderProvisioningState string

const (
	// Deprovisioning ...
	Deprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// NotProvisioned ...
	NotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// Provisioned ...
	Provisioned ServiceProviderProvisioningState = "Provisioned"
	// Provisioning ...
	Provisioning ServiceProviderProvisioningState = "Provisioning"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleServiceProviderProvisioningStateValues returns an array of possible values for the ServiceProviderProvisioningState const type.
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return []ServiceProviderProvisioningState{Deprovisioning, NotProvisioned, Provisioned, Provisioning}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "Udp"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolTCP, TransportProtocolUDP}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// Connected ...
	Connected VirtualNetworkGatewayConnectionStatus = "Connected"
	// Connecting ...
	Connecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// NotConnected ...
	NotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// Unknown ...
	Unknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleVirtualNetworkGatewayConnectionStatusValues returns an array of possible values for the VirtualNetworkGatewayConnectionStatus const type.
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return []VirtualNetworkGatewayConnectionStatus{Connected, Connecting, NotConnected, Unknown}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionType enumerates the values for virtual network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute ...
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec ...
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet ...
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient ...
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleVirtualNetworkGatewayConnectionTypeValues returns an array of possible values for the VirtualNetworkGatewayConnectionType const type.
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return []VirtualNetworkGatewayConnectionType{ExpressRoute, IPsec, Vnet2Vnet, VPNClient}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayType enumerates the values for virtual network gateway type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute ...
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeVpn ...
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleVirtualNetworkGatewayTypeValues returns an array of possible values for the VirtualNetworkGatewayType const type.
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return []VirtualNetworkGatewayType{VirtualNetworkGatewayTypeExpressRoute, VirtualNetworkGatewayTypeVpn}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased ...
	PolicyBased VpnType = "PolicyBased"
	// RouteBased ...
	RouteBased VpnType = "RouteBased"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PossibleVpnTypeValues returns an array of possible values for the VpnType const type.
func PossibleVpnTypeValues() []VpnType {
	return []VpnType{PolicyBased, RouteBased}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// AddressSpace addressSpace contains an array of IP address ranges that can be used by subnets
type AddressSpace struct {
	// AddressPrefixes - Gets or sets List of address blocks reserved for this virtual network in CIDR notation
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGateway applicationGateways resource
type ApplicationGateway struct {
	autorest.Response                   `json:"-"`
	*ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGateway.
func (ag ApplicationGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ApplicationGatewayPropertiesFormat != nil {
		objectMap["properties"] = ag.ApplicationGatewayPropertiesFormat
	}
	if ag.Etag != nil {
		objectMap["etag"] = ag.Etag
	}
	if ag.ID != nil {
		objectMap["id"] = ag.ID
	}
	if ag.Name != nil {
		objectMap["name"] = ag.Name
	}
	if ag.Type != nil {
		objectMap["type"] = ag.Type
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGateway struct.
func (ag *ApplicationGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPropertiesFormat ApplicationGatewayPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				ag.ApplicationGatewayPropertiesFormat = &applicationGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ag.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayBackendAddress backend Address of application gateway
type ApplicationGatewayBackendAddress struct {
	// Fqdn - Gets or sets the dns name
	Fqdn *string `json:"fqdn,omitempty"`
	// IPAddress - Gets or sets the ip address
	IPAddress *string `json:"ipAddress,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayBackendAddressPool backend Address Pool of application gateway
type ApplicationGatewayBackendAddressPool struct {
	*ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewayBackendAddressPool.
func (agbap ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat
	}
	if agbap.Name != nil {
		objectMap["name"] = agbap.Name
	}
	if agbap.Etag != nil {
		objectMap["etag"] = agbap.Etag
	}
	if agbap.ID != nil {
		objectMap["id"] = agbap.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendAddressPool struct.
func (agbap *ApplicationGatewayBackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendAddressPoolPropertiesFormat ApplicationGatewayBackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat = &applicationGatewayBackendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbap.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayBackendAddressPoolPropertiesFormat properties of Backend Address Pool of application gateway
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Gets or sets backendIPConfiguration of application gateway
	BackendIPConfigurations *[]SubResource `json:"backendIPConfigurations,omitempty"`
	// BackendAddresses - Gets or sets the backend addresses
	BackendAddresses *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the backend address pool resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayBackendHTTPSettings backend address pool settings of application gateway
type ApplicationGatewayBackendHTTPSettings struct {
	*ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewayBackendHTTPSettings.
func (agbhs ApplicationGatewayBackendHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat != nil {
		objectMap["properties"] = agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
	}
	if agbhs.Name != nil {
		objectMap["name"] = agbhs.Name
	}
	if agbhs.Etag != nil {
		objectMap["etag"] = agbhs.Etag
	}
	if agbhs.ID != nil {
		objectMap["id"] = agbhs.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendHTTPSettings struct.
func (agbhs *ApplicationGatewayBackendHTTPSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendHTTPSettingsPropertiesFormat ApplicationGatewayBackendHTTPSettingsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendHTTPSettingsPropertiesFormat)
				if err != nil {
					return err
				}
				agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat = &applicationGatewayBackendHTTPSettingsPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbhs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbhs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbhs.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayBackendHTTPSettingsPropertiesFormat properties of Backend address pool settings of application
// gateway
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Port - Gets or sets the port
	Port *int32 `json:"port,omitempty"`
	// Protocol - Gets or sets the protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// CookieBasedAffinity - Gets or sets the cookie affinity. Possible values include: 'Enabled', 'Disabled'
	CookieBasedAffinity ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the backend http settings resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayFrontendIPConfiguration frontend IP configuration of application gateway
type ApplicationGatewayFrontendIPConfiguration struct {
	*ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendIPConfiguration.
func (agfic ApplicationGatewayFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
	}
	if agfic.Name != nil {
		objectMap["name"] = agfic.Name
	}
	if agfic.Etag != nil {
		objectMap["etag"] = agfic.Etag
	}
	if agfic.ID != nil {
		objectMap["id"] = agfic.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendIPConfiguration struct.
func (agfic *ApplicationGatewayFrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendIPConfigurationPropertiesFormat ApplicationGatewayFrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat = &applicationGatewayFrontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfic.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayFrontendIPConfigurationPropertiesFormat properties of Frontend IP configuration of application
// gateway
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - Gets or sets the privateIPAddress of the Network Interface IP Configuration
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method (Static/Dynamic). Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Gets or sets the reference of the subnet resource
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Gets or sets the reference of the PublicIP resource
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayFrontendPort frontend Port of application gateway
type ApplicationGatewayFrontendPort struct {
	*ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendPort.
func (agfp ApplicationGatewayFrontendPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfp.ApplicationGatewayFrontendPortPropertiesFormat != nil {
		objectMap["properties"] = agfp.ApplicationGatewayFrontendPortPropertiesFormat
	}
	if agfp.Name != nil {
		objectMap["name"] = agfp.Name
	}
	if agfp.Etag != nil {
		objectMap["etag"] = agfp.Etag
	}
	if agfp.ID != nil {
		objectMap["id"] = agfp.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendPort struct.
func (agfp *ApplicationGatewayFrontendPort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendPortPropertiesFormat ApplicationGatewayFrontendPortPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendPortPropertiesFormat)
				if err != nil {
					return err
				}
				agfp.ApplicationGatewayFrontendPortPropertiesFormat = &applicationGatewayFrontendPortPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfp.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayFrontendPortPropertiesFormat properties of Frontend Port of application gateway
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Port - Gets or sets the frontend port
	Port *int32 `json:"port,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the frontend port resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayHTTPListener http listener of application gateway
type ApplicationGatewayHTTPListener struct {
	*ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewayHTTPListener.
func (aghl ApplicationGatewayHTTPListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghl.ApplicationGatewayHTTPListenerPropertiesFormat != nil {
		objectMap["properties"] = aghl.ApplicationGatewayHTTPListenerPropertiesFormat
	}
	if aghl.Name != nil {
		objectMap["name"] = aghl.Name
	}
	if aghl.Etag != nil {
		objectMap["etag"] = aghl.Etag
	}
	if aghl.ID != nil {
		objectMap["id"] = aghl.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayHTTPListener struct.
func (aghl *ApplicationGatewayHTTPListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayHTTPListenerPropertiesFormat ApplicationGatewayHTTPListenerPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayHTTPListenerPropertiesFormat)
				if err != nil {
					return err
				}
				aghl.ApplicationGatewayHTTPListenerPropertiesFormat = &applicationGatewayHTTPListenerPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aghl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				aghl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aghl.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayHTTPListenerPropertiesFormat properties of Http listener of application gateway
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// FrontendIPConfiguration - Gets or sets frontend IP configuration resource of application gateway
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// FrontendPort - Gets or sets frontend port resource of application gateway
	FrontendPort *SubResource `json:"frontendPort,omitempty"`
	// Protocol - Gets or sets the protocol. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// SslCertificate - Gets or sets ssl certificate resource of application gateway
	SslCertificate *SubResource `json:"sslCertificate,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the http listener resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayIPConfiguration IP configuration of application gateway
type ApplicationGatewayIPConfiguration struct {
	*ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewayIPConfiguration.
func (agic ApplicationGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agic.ApplicationGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agic.ApplicationGatewayIPConfigurationPropertiesFormat
	}
	if agic.Name != nil {
		objectMap["name"] = agic.Name
	}
	if agic.Etag != nil {
		objectMap["etag"] = agic.Etag
	}
	if agic.ID != nil {
		objectMap["id"] = agic.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayIPConfiguration struct.
func (agic *ApplicationGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayIPConfigurationPropertiesFormat ApplicationGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agic.ApplicationGatewayIPConfigurationPropertiesFormat = &applicationGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agic.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayIPConfigurationPropertiesFormat properties of IP configuration of application gateway
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Subnet - Gets or sets the reference of the subnet resource.A subnet from where appliation gateway gets its private address
	Subnet *SubResource `json:"subnet,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the application gateway subnet resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayListResult response for ListLoadBalancers Api service call
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of ApplicationGateways in a resource group
	Value *[]ApplicationGateway `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayListResultIterator provides access to a complete listing of ApplicationGateway values.
type ApplicationGatewayListResultIterator struct {
	i    int
	page ApplicationGatewayListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayListResultIterator) Response() ApplicationGatewayListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayListResultIterator) Value() ApplicationGateway {
	if !iter.page.NotDone() {
		return ApplicationGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (aglr ApplicationGatewayListResult) IsEmpty() bool {
	return aglr.Value == nil || len(*aglr.Value) == 0
}

// applicationGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aglr ApplicationGatewayListResult) applicationGatewayListResultPreparer() (*http.Request, error) {
	if aglr.NextLink == nil || len(to.String(aglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aglr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayListResultPage contains a page of ApplicationGateway values.
type ApplicationGatewayListResultPage struct {
	fn   func(ApplicationGatewayListResult) (ApplicationGatewayListResult, error)
	aglr ApplicationGatewayListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayListResultPage) Next() error {
	next, err := page.fn(page.aglr)
	if err != nil {
		return err
	}
	page.aglr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayListResultPage) NotDone() bool {
	return !page.aglr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page ApplicationGatewayListResultPage) Response() ApplicationGatewayListResult {
	return page.aglr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayListResultPage) Values() []ApplicationGateway {
	if page.aglr.IsEmpty() {
		return nil
	}
	return *page.aglr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayPropertiesFormat properties of Application Gateway
type ApplicationGatewayPropertiesFormat struct {
	// Sku - Gets or sets sku of application gateway resource
	Sku *ApplicationGatewaySku `json:"sku,omitempty"`
	// OperationalState - Gets operational state of application gateway resource. Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping'
	OperationalState ApplicationGatewayOperationalState `json:"operationalState,omitempty"`
	// GatewayIPConfigurations - Gets or sets subnets of application gateway resource
	GatewayIPConfigurations *[]ApplicationGatewayIPConfiguration `json:"gatewayIPConfigurations,omitempty"`
	// SslCertificates - Gets or sets ssl certificates of application gateway resource
	SslCertificates *[]ApplicationGatewaySslCertificate `json:"sslCertificates,omitempty"`
	// FrontendIPConfigurations - Gets or sets frontend IP addresses of application gateway resource
	FrontendIPConfigurations *[]ApplicationGatewayFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// FrontendPorts - Gets or sets frontend ports of application gateway resource
	FrontendPorts *[]ApplicationGatewayFrontendPort `json:"frontendPorts,omitempty"`
	// BackendAddressPools - Gets or sets backend address pool of application gateway resource
	BackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"backendAddressPools,omitempty"`
	// BackendHTTPSettingsCollection - Gets or sets backend http settings of application gateway resource
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
	// HTTPListeners - Gets or sets HTTP listeners of application gateway resource
	HTTPListeners *[]ApplicationGatewayHTTPListener `json:"httpListeners,omitempty"`
	// RequestRoutingRules - Gets or sets request routing rules of application gateway resource
	RequestRoutingRules *[]ApplicationGatewayRequestRoutingRule `json:"requestRoutingRules,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the ApplicationGateway resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the ApplicationGateway resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayRequestRoutingRule request routing rule of application gateway
type ApplicationGatewayRequestRoutingRule struct {
	*ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewayRequestRoutingRule.
func (agrrr ApplicationGatewayRequestRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat != nil {
		objectMap["properties"] = agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat
	}
	if agrrr.Name != nil {
		objectMap["name"] = agrrr.Name
	}
	if agrrr.Etag != nil {
		objectMap["etag"] = agrrr.Etag
	}
	if agrrr.ID != nil {
		objectMap["id"] = agrrr.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRequestRoutingRule struct.
func (agrrr *ApplicationGatewayRequestRoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRequestRoutingRulePropertiesFormat ApplicationGatewayRequestRoutingRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRequestRoutingRulePropertiesFormat)
				if err != nil {
					return err
				}
				agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat = &applicationGatewayRequestRoutingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrr.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewayRequestRoutingRulePropertiesFormat properties of Request routing rule of application gateway
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// RuleType - Gets or sets the rule type. Possible values include: 'Basic'
	RuleType ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	// BackendAddressPool - Gets or sets backend address pool resource of application gateway
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Gets or sets frontend port resource of application gateway
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// HTTPListener - Gets or sets http listener resource of application gateway
	HTTPListener *SubResource `json:"httpListener,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the request routing rule resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysCreateOrUpdateFuture) Result(client ApplicationGatewaysClient) (ag ApplicationGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ag, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ag, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	ag, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysDeleteFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaySku SKU of application gateway
type ApplicationGatewaySku struct {
	// Name - Gets or sets name of application gateway SKU. Possible values include: 'StandardSmall', 'StandardMedium', 'StandardLarge'
	Name ApplicationGatewaySkuName `json:"name,omitempty"`
	// Tier - Gets or sets tier of application gateway. Possible values include: 'Standard'
	Tier ApplicationGatewayTier `json:"tier,omitempty"`
	// Capacity - Gets or sets capacity (instance count) of application gateway
	Capacity *int32 `json:"capacity,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaySslCertificate SSL certificates of application gateway
type ApplicationGatewaySslCertificate struct {
	*ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ApplicationGatewaySslCertificate.
func (agsc ApplicationGatewaySslCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsc.ApplicationGatewaySslCertificatePropertiesFormat != nil {
		objectMap["properties"] = agsc.ApplicationGatewaySslCertificatePropertiesFormat
	}
	if agsc.Name != nil {
		objectMap["name"] = agsc.Name
	}
	if agsc.Etag != nil {
		objectMap["etag"] = agsc.Etag
	}
	if agsc.ID != nil {
		objectMap["id"] = agsc.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslCertificate struct.
func (agsc *ApplicationGatewaySslCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewaySslCertificatePropertiesFormat ApplicationGatewaySslCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agsc.ApplicationGatewaySslCertificatePropertiesFormat = &applicationGatewaySslCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agsc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agsc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agsc.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaySslCertificatePropertiesFormat properties of SSL certificates of application gateway
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	// Data - Gets or sets the certificate data
	Data *string `json:"data,omitempty"`
	// Password - Gets or sets the certificate password
	Password *string `json:"password,omitempty"`
	// PublicCertData - Gets or sets the certificate public data
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the ssl certificate resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaysStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStartFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysStartFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStartFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.StartResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.StartResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ApplicationGatewaysStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStopFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationGatewaysStopFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStopFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.StopResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.StopResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// AuthorizationListResult response for ListAuthorizations Api service callRetrieves all authorizations that
// belongs to an ExpressRouteCircuit
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the authorizations in an ExpressRoute Circuit
	Value *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// AuthorizationListResultIterator provides access to a complete listing of ExpressRouteCircuitAuthorization
// values.
type AuthorizationListResultIterator struct {
	i    int
	page AuthorizationListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter AuthorizationListResultIterator) Response() AuthorizationListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationListResultIterator) Value() ExpressRouteCircuitAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (alr AuthorizationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// authorizationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AuthorizationListResult) authorizationListResultPreparer() (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// AuthorizationListResultPage contains a page of ExpressRouteCircuitAuthorization values.
type AuthorizationListResultPage struct {
	fn  func(AuthorizationListResult) (AuthorizationListResult, error)
	alr AuthorizationListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationListResultPage) Next() error {
	next, err := page.fn(page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page AuthorizationListResultPage) Response() AuthorizationListResult {
	return page.alr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationListResultPage) Values() []ExpressRouteCircuitAuthorization {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// AuthorizationPropertiesFormat ...
type AuthorizationPropertiesFormat struct {
	// AuthorizationKey - Gets or sets the authorization key
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// AuthorizationUseStatus - Gets or sets AuthorizationUseStatus. Possible values include: 'Available', 'InUse'
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is inprogress, or has failed. Note that this status is distinct from the
// HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation
// succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous
// operation failed, the response body includes the HTTP status code for the failed request and error information
// regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the AzureAsuncOperation. Possible values include: 'InProgress', 'Succeeded', 'Failed'
	Status OperationStatus `json:"status,omitempty"`
	Error  *Error          `json:"error,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// BackendAddressPool pool of backend IP addresseses
type BackendAddressPool struct {
	*BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for BackendAddressPool.
func (bap BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bap.BackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = bap.BackendAddressPoolPropertiesFormat
	}
	if bap.Name != nil {
		objectMap["name"] = bap.Name
	}
	if bap.Etag != nil {
		objectMap["etag"] = bap.Etag
	}
	if bap.ID != nil {
		objectMap["id"] = bap.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for BackendAddressPool struct.
func (bap *BackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendAddressPoolPropertiesFormat BackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &backendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				bap.BackendAddressPoolPropertiesFormat = &backendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bap.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// BackendAddressPoolPropertiesFormat properties of BackendAddressPool
type BackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Gets collection of references to IPs defined in NICs
	BackendIPConfigurations *[]SubResource `json:"backendIPConfigurations,omitempty"`
	// LoadBalancingRules - Gets Load Balancing rules that use this Backend Address Pool
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// OutboundNatRule - Gets outbound rules that use this Backend Address Pool
	OutboundNatRule *SubResource `json:"outboundNatRule,omitempty"`
	// ProvisioningState - Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ConnectionResetSharedKey ...
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	// KeyLength - The virtual network connection reset shared key length
	KeyLength *int64 `json:"keyLength,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ConnectionSharedKey response for GetConnectionSharedKey Api servive call
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value
	Value *string `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// DhcpOptions dHCPOptions contains an array of DNS servers available to VMs deployed in the virtual
// networkStandard DHCP option for a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// DNSServers - Gets or sets list of DNS servers IP addresses
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// DNSNameAvailabilityResult response for CheckDnsNameAvailability Api servive call
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Domain availability (True/False)
	Available *bool `json:"available,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Error ...
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ErrorDetails ...
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuit expressRouteCircuit resource
type ExpressRouteCircuit struct {
	autorest.Response `json:"-"`
	// Sku - Gets or sets sku
	Sku                                  *ExpressRouteCircuitSku `json:"sku,omitempty"`
	*ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ExpressRouteCircuit.
func (erc ExpressRouteCircuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.Sku != nil {
		objectMap["sku"] = erc.Sku
	}
	if erc.ExpressRouteCircuitPropertiesFormat != nil {
		objectMap["properties"] = erc.ExpressRouteCircuitPropertiesFormat
	}
	if erc.Etag != nil {
		objectMap["etag"] = erc.Etag
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	if erc.Name != nil {
		objectMap["name"] = erc.Name
	}
	if erc.Type != nil {
		objectMap["type"] = erc.Type
	}
	if erc.Location != nil {
		objectMap["location"] = erc.Location
	}
	if erc.Tags != nil {
		objectMap["tags"] = erc.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuit struct.
func (erc *ExpressRouteCircuit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ExpressRouteCircuitSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				erc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var expressRouteCircuitPropertiesFormat ExpressRouteCircuitPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPropertiesFormat)
				if err != nil {
					return err
				}
				erc.ExpressRouteCircuitPropertiesFormat = &expressRouteCircuitPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erc.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitArpTable the arp table associated with the ExpressRouteCircuit
type ExpressRouteCircuitArpTable struct {
	// IPAddress - Gets ipAddress.
	IPAddress *string `json:"ipAddress,omitempty"`
	// MacAddress - Gets macAddress.
	MacAddress *string `json:"macAddress,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitAuthorization authorization in a ExpressRouteCircuit resource
type ExpressRouteCircuitAuthorization struct {
	autorest.Response              `json:"-"`
	*AuthorizationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ExpressRouteCircuitAuthorization.
func (erca ExpressRouteCircuitAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erca.AuthorizationPropertiesFormat != nil {
		objectMap["properties"] = erca.AuthorizationPropertiesFormat
	}
	if erca.Name != nil {
		objectMap["name"] = erca.Name
	}
	if erca.Etag != nil {
		objectMap["etag"] = erca.Etag
	}
	if erca.ID != nil {
		objectMap["id"] = erca.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitAuthorization struct.
func (erca *ExpressRouteCircuitAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationPropertiesFormat AuthorizationPropertiesFormat
				err = json.Unmarshal(*v, &authorizationPropertiesFormat)
				if err != nil {
					return err
				}
				erca.AuthorizationPropertiesFormat = &authorizationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erca.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erca.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erca.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture) Result(client ExpressRouteCircuitAuthorizationsClient) (erca ExpressRouteCircuitAuthorization, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return erca, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		erca, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	erca, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitAuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitAuthorizationsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitAuthorizationsDeleteFuture) Result(client ExpressRouteCircuitAuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitListResult response for ListExpressRouteCircuit Api service call
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of ExpressRouteCircuits in a resource group
	Value *[]ExpressRouteCircuit `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitListResultIterator provides access to a complete listing of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultIterator struct {
	i    int
	page ExpressRouteCircuitListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitListResultIterator) Response() ExpressRouteCircuitListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitListResultIterator) Value() ExpressRouteCircuit {
	if !iter.page.NotDone() {
		return ExpressRouteCircuit{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (erclr ExpressRouteCircuitListResult) IsEmpty() bool {
	return erclr.Value == nil || len(*erclr.Value) == 0
}

// expressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erclr ExpressRouteCircuitListResult) expressRouteCircuitListResultPreparer() (*http.Request, error) {
	if erclr.NextLink == nil || len(to.String(erclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erclr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitListResultPage contains a page of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultPage struct {
	fn    func(ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)
	erclr ExpressRouteCircuitListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitListResultPage) Next() error {
	next, err := page.fn(page.erclr)
	if err != nil {
		return err
	}
	page.erclr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitListResultPage) NotDone() bool {
	return !page.erclr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitListResultPage) Response() ExpressRouteCircuitListResult {
	return page.erclr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitListResultPage) Values() []ExpressRouteCircuit {
	if page.erclr.IsEmpty() {
		return nil
	}
	return *page.erclr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeering peering in a ExpressRouteCircuit resource
type ExpressRouteCircuitPeering struct {
	autorest.Response                           `json:"-"`
	*ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeering.
func (ercp ExpressRouteCircuitPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercp.ExpressRouteCircuitPeeringPropertiesFormat != nil {
		objectMap["properties"] = ercp.ExpressRouteCircuitPeeringPropertiesFormat
	}
	if ercp.Name != nil {
		objectMap["name"] = ercp.Name
	}
	if ercp.Etag != nil {
		objectMap["etag"] = ercp.Etag
	}
	if ercp.ID != nil {
		objectMap["id"] = ercp.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitPeering struct.
func (ercp *ExpressRouteCircuitPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitPeeringPropertiesFormat ExpressRouteCircuitPeeringPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				ercp.ExpressRouteCircuitPeeringPropertiesFormat = &expressRouteCircuitPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercp.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringConfig specfies the peering config
type ExpressRouteCircuitPeeringConfig struct {
	// AdvertisedPublicPrefixes - Gets or sets the reference of AdvertisedPublicPrefixes
	AdvertisedPublicPrefixes *[]string `json:"advertisedPublicPrefixes,omitempty"`
	// AdvertisedPublicPrefixesState - Gets or sets AdvertisedPublicPrefixState of the Peering resource. Possible values include: 'NotConfigured', 'Configuring', 'Configured', 'ValidationNeeded'
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	// CustomerASN - Gets or Sets CustomerAsn of the peering.
	CustomerASN *int32 `json:"customerASN,omitempty"`
	// RoutingRegistryName - Gets or Sets RoutingRegistryName of the config.
	RoutingRegistryName *string `json:"routingRegistryName,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringListResult response for ListPeering Api service callRetrieves all Peerings that
// belongs to an ExpressRouteCircuit
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the peerings in an express route circuit
	Value *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringListResultIterator provides access to a complete listing of ExpressRouteCircuitPeering
// values.
type ExpressRouteCircuitPeeringListResultIterator struct {
	i    int
	page ExpressRouteCircuitPeeringListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitPeeringListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitPeeringListResultIterator) Response() ExpressRouteCircuitPeeringListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitPeeringListResultIterator) Value() ExpressRouteCircuitPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (ercplr ExpressRouteCircuitPeeringListResult) IsEmpty() bool {
	return ercplr.Value == nil || len(*ercplr.Value) == 0
}

// expressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercplr ExpressRouteCircuitPeeringListResult) expressRouteCircuitPeeringListResultPreparer() (*http.Request, error) {
	if ercplr.NextLink == nil || len(to.String(ercplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercplr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringListResultPage contains a page of ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultPage struct {
	fn     func(ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)
	ercplr ExpressRouteCircuitPeeringListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitPeeringListResultPage) Next() error {
	next, err := page.fn(page.ercplr)
	if err != nil {
		return err
	}
	page.ercplr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitPeeringListResultPage) NotDone() bool {
	return !page.ercplr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitPeeringListResultPage) Response() ExpressRouteCircuitPeeringListResult {
	return page.ercplr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitPeeringListResultPage) Values() []ExpressRouteCircuitPeering {
	if page.ercplr.IsEmpty() {
		return nil
	}
	return *page.ercplr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringPropertiesFormat ...
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// PeeringType - Gets or sets PeeringType. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRouteCircuitPeeringType `json:"peeringType,omitempty"`
	// State - Gets or sets state of Peering. Possible values include: 'ExpressRouteCircuitPeeringStateDisabled', 'ExpressRouteCircuitPeeringStateEnabled'
	State ExpressRouteCircuitPeeringState `json:"state,omitempty"`
	// AzureASN - Gets or sets the azure ASN
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - Gets or sets the peer ASN
	PeerASN *int32 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - Gets or sets the primary address prefix
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - Gets or sets the secondary address prefix
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - Gets or sets the primary port
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - Gets or sets the secondary port
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - Gets or sets the shared key
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - Gets or sets the vlan id
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - Gets or sets the mircosoft peering config
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// Stats - Gets or peering stats
	Stats *ExpressRouteCircuitStats `json:"stats,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitPeeringsCreateOrUpdateFuture) Result(client ExpressRouteCircuitPeeringsClient) (ercp ExpressRouteCircuitPeering, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ercp, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ercp, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	ercp, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitPeeringsDeleteFuture) Result(client ExpressRouteCircuitPeeringsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitPropertiesFormat properties of ExpressRouteCircuit
type ExpressRouteCircuitPropertiesFormat struct {
	// CircuitProvisioningState - Gets or sets CircuitProvisioningState state of the resource
	CircuitProvisioningState *string `json:"circuitProvisioningState,omitempty"`
	// ServiceProviderProvisioningState - Gets or sets ServiceProviderProvisioningState state of the resource. Possible values include: 'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// Authorizations - Gets or sets list of authorizations
	Authorizations *[]ExpressRouteCircuitAuthorization `json:"authorizations,omitempty"`
	// Peerings - Gets or sets list of peerings
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// ServiceKey - Gets or sets ServiceKey
	ServiceKey *string `json:"serviceKey,omitempty"`
	// ServiceProviderNotes - Gets or sets ServiceProviderNotes
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ServiceProviderProperties - Gets or sets ServiceProviderProperties
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitRoutesTable the routes table associated with the ExpressRouteCircuit
type ExpressRouteCircuitRoutesTable struct {
	// AddressPrefix - Gets AddressPrefix.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NextHopType - Gets NextHopType. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
	// NextHopIP - Gets NextHopIP.
	NextHopIP *string `json:"nextHopIP,omitempty"`
	// AsPath - Gets AsPath.
	AsPath *string `json:"asPath,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsArpTableListResult response for ListArpTable associated with the Express Route Circuits Api
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of ArpTable
	Value *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsArpTableListResultIterator provides access to a complete listing of
// ExpressRouteCircuitArpTable values.
type ExpressRouteCircuitsArpTableListResultIterator struct {
	i    int
	page ExpressRouteCircuitsArpTableListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitsArpTableListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitsArpTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitsArpTableListResultIterator) Response() ExpressRouteCircuitsArpTableListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitsArpTableListResultIterator) Value() ExpressRouteCircuitArpTable {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitArpTable{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (ercatlr ExpressRouteCircuitsArpTableListResult) IsEmpty() bool {
	return ercatlr.Value == nil || len(*ercatlr.Value) == 0
}

// expressRouteCircuitsArpTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercatlr ExpressRouteCircuitsArpTableListResult) expressRouteCircuitsArpTableListResultPreparer() (*http.Request, error) {
	if ercatlr.NextLink == nil || len(to.String(ercatlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercatlr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsArpTableListResultPage contains a page of ExpressRouteCircuitArpTable values.
type ExpressRouteCircuitsArpTableListResultPage struct {
	fn      func(ExpressRouteCircuitsArpTableListResult) (ExpressRouteCircuitsArpTableListResult, error)
	ercatlr ExpressRouteCircuitsArpTableListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitsArpTableListResultPage) Next() error {
	next, err := page.fn(page.ercatlr)
	if err != nil {
		return err
	}
	page.ercatlr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitsArpTableListResultPage) NotDone() bool {
	return !page.ercatlr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitsArpTableListResultPage) Response() ExpressRouteCircuitsArpTableListResult {
	return page.ercatlr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitsArpTableListResultPage) Values() []ExpressRouteCircuitArpTable {
	if page.ercatlr.IsEmpty() {
		return nil
	}
	return *page.ercatlr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitsCreateOrUpdateFuture) Result(client ExpressRouteCircuitsClient) (erc ExpressRouteCircuit, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return erc, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		erc, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	erc, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExpressRouteCircuitsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExpressRouteCircuitsDeleteFuture) Result(client ExpressRouteCircuitsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitServiceProviderProperties contains ServiceProviderProperties in an ExpressRouteCircuit
type ExpressRouteCircuitServiceProviderProperties struct {
	// ServiceProviderName - Gets or sets serviceProviderName.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	// PeeringLocation - Gets or sets peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - Gets or sets BandwidthInMbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitSku contains sku in an ExpressRouteCircuit
type ExpressRouteCircuitSku struct {
	// Name - Gets or sets name of the sku.
	Name *string `json:"name,omitempty"`
	// Tier - Gets or sets tier of the sku. Possible values include: 'ExpressRouteCircuitSkuTierStandard', 'ExpressRouteCircuitSkuTierPremium'
	Tier ExpressRouteCircuitSkuTier `json:"tier,omitempty"`
	// Family - Gets or sets family of the sku. Possible values include: 'UnlimitedData', 'MeteredData'
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsRoutesTableListResult response for ListRoutesTable associated with the Express Route
// Circuits Api
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of RoutesTable
	Value *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsRoutesTableListResultIterator provides access to a complete listing of
// ExpressRouteCircuitRoutesTable values.
type ExpressRouteCircuitsRoutesTableListResultIterator struct {
	i    int
	page ExpressRouteCircuitsRoutesTableListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitsRoutesTableListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitsRoutesTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitsRoutesTableListResultIterator) Response() ExpressRouteCircuitsRoutesTableListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitsRoutesTableListResultIterator) Value() ExpressRouteCircuitRoutesTable {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitRoutesTable{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (ercrtlr ExpressRouteCircuitsRoutesTableListResult) IsEmpty() bool {
	return ercrtlr.Value == nil || len(*ercrtlr.Value) == 0
}

// expressRouteCircuitsRoutesTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercrtlr ExpressRouteCircuitsRoutesTableListResult) expressRouteCircuitsRoutesTableListResultPreparer() (*http.Request, error) {
	if ercrtlr.NextLink == nil || len(to.String(ercrtlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercrtlr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsRoutesTableListResultPage contains a page of ExpressRouteCircuitRoutesTable values.
type ExpressRouteCircuitsRoutesTableListResultPage struct {
	fn      func(ExpressRouteCircuitsRoutesTableListResult) (ExpressRouteCircuitsRoutesTableListResult, error)
	ercrtlr ExpressRouteCircuitsRoutesTableListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitsRoutesTableListResultPage) Next() error {
	next, err := page.fn(page.ercrtlr)
	if err != nil {
		return err
	}
	page.ercrtlr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitsRoutesTableListResultPage) NotDone() bool {
	return !page.ercrtlr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitsRoutesTableListResultPage) Response() ExpressRouteCircuitsRoutesTableListResult {
	return page.ercrtlr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitsRoutesTableListResultPage) Values() []ExpressRouteCircuitRoutesTable {
	if page.ercrtlr.IsEmpty() {
		return nil
	}
	return *page.ercrtlr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsStatsListResult response for ListStats from Express Route Circuits Api service call
type ExpressRouteCircuitsStatsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of Stats
	Value *[]ExpressRouteCircuitStats `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsStatsListResultIterator provides access to a complete listing of ExpressRouteCircuitStats
// values.
type ExpressRouteCircuitsStatsListResultIterator struct {
	i    int
	page ExpressRouteCircuitsStatsListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitsStatsListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitsStatsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitsStatsListResultIterator) Response() ExpressRouteCircuitsStatsListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitsStatsListResultIterator) Value() ExpressRouteCircuitStats {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitStats{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (ercslr ExpressRouteCircuitsStatsListResult) IsEmpty() bool {
	return ercslr.Value == nil || len(*ercslr.Value) == 0
}

// expressRouteCircuitsStatsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercslr ExpressRouteCircuitsStatsListResult) expressRouteCircuitsStatsListResultPreparer() (*http.Request, error) {
	if ercslr.NextLink == nil || len(to.String(ercslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercslr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitsStatsListResultPage contains a page of ExpressRouteCircuitStats values.
type ExpressRouteCircuitsStatsListResultPage struct {
	fn     func(ExpressRouteCircuitsStatsListResult) (ExpressRouteCircuitsStatsListResult, error)
	ercslr ExpressRouteCircuitsStatsListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitsStatsListResultPage) Next() error {
	next, err := page.fn(page.ercslr)
	if err != nil {
		return err
	}
	page.ercslr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitsStatsListResultPage) NotDone() bool {
	return !page.ercslr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitsStatsListResultPage) Response() ExpressRouteCircuitsStatsListResult {
	return page.ercslr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitsStatsListResultPage) Values() []ExpressRouteCircuitStats {
	if page.ercslr.IsEmpty() {
		return nil
	}
	return *page.ercslr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteCircuitStats contains Stats associated with the peering
type ExpressRouteCircuitStats struct {
	// BytesIn - Gets BytesIn of the peering.
	BytesIn *int32 `json:"bytesIn,omitempty"`
	// BytesOut - Gets BytesOut of the peering.
	BytesOut *int32 `json:"bytesOut,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteServiceProvider expressRouteResourceProvider object
type ExpressRouteServiceProvider struct {
	// ID - Gets or sets the ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the resource.
	Type       *string                                      `json:"type,omitempty"`
	Properties *ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteServiceProviderBandwidthsOffered contains Bandwidths offered in ExpressRouteServiceProviders
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// OfferName - Gets the OfferName
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - Gets the ValueInMbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteServiceProviderListResult response for ListExpressRouteServiceProvider Api service call
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of ExpressRouteResourceProvider
	Value *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteServiceProviderListResultIterator provides access to a complete listing of
// ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultIterator struct {
	i    int
	page ExpressRouteServiceProviderListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteServiceProviderListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter ExpressRouteServiceProviderListResultIterator) Response() ExpressRouteServiceProviderListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteServiceProviderListResultIterator) Value() ExpressRouteServiceProvider {
	if !iter.page.NotDone() {
		return ExpressRouteServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (ersplr ExpressRouteServiceProviderListResult) IsEmpty() bool {
	return ersplr.Value == nil || len(*ersplr.Value) == 0
}

// expressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ersplr ExpressRouteServiceProviderListResult) expressRouteServiceProviderListResultPreparer() (*http.Request, error) {
	if ersplr.NextLink == nil || len(to.String(ersplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ersplr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteServiceProviderListResultPage contains a page of ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultPage struct {
	fn     func(ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)
	ersplr ExpressRouteServiceProviderListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteServiceProviderListResultPage) Next() error {
	next, err := page.fn(page.ersplr)
	if err != nil {
		return err
	}
	page.ersplr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteServiceProviderListResultPage) NotDone() bool {
	return !page.ersplr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page ExpressRouteServiceProviderListResultPage) Response() ExpressRouteServiceProviderListResult {
	return page.ersplr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteServiceProviderListResultPage) Values() []ExpressRouteServiceProvider {
	if page.ersplr.IsEmpty() {
		return nil
	}
	return *page.ersplr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ExpressRouteServiceProviderPropertiesFormat properties of ExpressRouteServiceProvider
type ExpressRouteServiceProviderPropertiesFormat struct {
	// PeeringLocations - Gets or list of peering locations
	PeeringLocations *[]string `json:"peeringLocations,omitempty"`
	// BandwidthsOffered - Gets or bandwidths offered
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the resource
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// FrontendIPConfiguration frontend IP address of the load balancer
type FrontendIPConfiguration struct {
	*FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for FrontendIPConfiguration.
func (fic FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fic.FrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = fic.FrontendIPConfigurationPropertiesFormat
	}
	if fic.Name != nil {
		objectMap["name"] = fic.Name
	}
	if fic.Etag != nil {
		objectMap["etag"] = fic.Etag
	}
	if fic.ID != nil {
		objectMap["id"] = fic.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for FrontendIPConfiguration struct.
func (fic *FrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendIPConfigurationPropertiesFormat FrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &frontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				fic.FrontendIPConfigurationPropertiesFormat = &frontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fic.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// FrontendIPConfigurationPropertiesFormat properties of Frontend IP Configuration of the load balancer
type FrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - Gets or sets the IP address of the Load Balancer.This is only specified if a specific private IP address shall be allocated from the subnet specified in subnetRef
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method (Static/Dynamic). Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Gets or sets the reference of the subnet resource.A subnet from wher the load balancer gets its private frontend address
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Gets or sets the reference of the PublicIP resource
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// InboundNatRules - Read only.Inbound rules URIs that use this frontend IP
	InboundNatRules *[]SubResource `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Read only.Inbound pools URIs that use this frontend IP
	InboundNatPools *[]SubResource `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - Read only.Outbound rules URIs that use this frontend IP
	OutboundNatRules *[]SubResource `json:"outboundNatRules,omitempty"`
	// LoadBalancingRules - Gets Load Balancing rules URIs that use this frontend IP
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InboundNatPool inbound NAT pool of the loadbalancer
type InboundNatPool struct {
	*InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for InboundNatPool.
func (inp InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inp.InboundNatPoolPropertiesFormat != nil {
		objectMap["properties"] = inp.InboundNatPoolPropertiesFormat
	}
	if inp.Name != nil {
		objectMap["name"] = inp.Name
	}
	if inp.Etag != nil {
		objectMap["etag"] = inp.Etag
	}
	if inp.ID != nil {
		objectMap["id"] = inp.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for InboundNatPool struct.
func (inp *InboundNatPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatPoolPropertiesFormat InboundNatPoolPropertiesFormat
				err = json.Unmarshal(*v, &inboundNatPoolPropertiesFormat)
				if err != nil {
					return err
				}
				inp.InboundNatPoolPropertiesFormat = &inboundNatPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inp.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InboundNatPoolPropertiesFormat properties of Inbound NAT pool
type InboundNatPoolPropertiesFormat struct {
	// FrontendIPConfiguration - Gets or sets a reference to frontend IP Addresses
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// Protocol - Gets or sets the transport potocol for the external endpoint. Possible values are Udp or Tcp. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPortRangeStart - Gets or sets the starting port range for the NAT pool. You can spcify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - Gets or sets the ending port range for the NAT pool. You can spcify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// BackendPort - Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal compotnent on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
	BackendPort *int32 `json:"backendPort,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InboundNatRule inbound NAT rule of the loadbalancer
type InboundNatRule struct {
	*InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for InboundNatRule.
func (inr InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inr.InboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = inr.InboundNatRulePropertiesFormat
	}
	if inr.Name != nil {
		objectMap["name"] = inr.Name
	}
	if inr.Etag != nil {
		objectMap["etag"] = inr.Etag
	}
	if inr.ID != nil {
		objectMap["id"] = inr.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for InboundNatRule struct.
func (inr *InboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatRulePropertiesFormat InboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &inboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				inr.InboundNatRulePropertiesFormat = &inboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inr.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InboundNatRulePropertiesFormat properties of Inbound NAT rule
type InboundNatRulePropertiesFormat struct {
	// FrontendIPConfiguration - Gets or sets a reference to frontend IP Addresses
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendIPConfiguration - Gets or sets a reference to a private ip address defined on a NetworkInterface of a VM. Traffic sent to frontendPort of each of the frontendIPConfigurations is forwarded to the backed IP
	BackendIPConfiguration *SubResource `json:"backendIPConfiguration,omitempty"`
	// Protocol - Gets or sets the transport potocol for the external endpoint. Possible values are Udp or Tcp. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPort - Gets or sets the port for the external endpoint. You can spcify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal compotnent on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This emlement is only used when the protocol is set to Tcp
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Interface a NetworkInterface in a resource group
type Interface struct {
	autorest.Response          `json:"-"`
	*InterfacePropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InterfacePropertiesFormat != nil {
		objectMap["properties"] = i.InterfacePropertiesFormat
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Name != nil {
		objectMap["name"] = i.Name
	}
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for Interface struct.
func (i *Interface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfacePropertiesFormat InterfacePropertiesFormat
				err = json.Unmarshal(*v, &interfacePropertiesFormat)
				if err != nil {
					return err
				}
				i.InterfacePropertiesFormat = &interfacePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfaceDNSSettings dns Settings of a network interface
type InterfaceDNSSettings struct {
	// DNSServers - Gets or sets list of DNS servers IP addresses
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// AppliedDNSServers - Gets or sets list of Applied DNS servers IP addresses
	AppliedDNSServers *[]string `json:"appliedDnsServers,omitempty"`
	// InternalDNSNameLabel - Gets or sets the Internal DNS name
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`
	// InternalFqdn - Gets or sets full IDNS name in the form, DnsName.VnetId.ZoneId.TopleveSuffix. This is set when the NIC is associated to a VM
	InternalFqdn *string `json:"internalFqdn,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfaceIPConfiguration iPConfiguration in a NetworkInterface
type InterfaceIPConfiguration struct {
	*InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for InterfaceIPConfiguration.
func (iic InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iic.InterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = iic.InterfaceIPConfigurationPropertiesFormat
	}
	if iic.Name != nil {
		objectMap["name"] = iic.Name
	}
	if iic.Etag != nil {
		objectMap["etag"] = iic.Etag
	}
	if iic.ID != nil {
		objectMap["id"] = iic.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for InterfaceIPConfiguration struct.
func (iic *InterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceIPConfigurationPropertiesFormat InterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				iic.InterfaceIPConfigurationPropertiesFormat = &interfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				iic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iic.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfaceIPConfigurationPropertiesFormat properties of IPConfiguration
type InterfaceIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - Gets or sets the privateIPAddress of the Network Interface IP Configuration
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method (Static/Dynamic). Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Gets or sets the reference of the subnet resource
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Gets or sets the reference of the PublicIP resource
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// LoadBalancerBackendAddressPools - Gets or sets the reference of LoadBalancerBackendAddressPool resource
	LoadBalancerBackendAddressPools *[]SubResource `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatRules - Gets or sets list of references of LoadBalancerInboundNatRules
	LoadBalancerInboundNatRules *[]SubResource `json:"loadBalancerInboundNatRules,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfaceListResult response for ListNetworkInterface Api service call
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets list of NetworkInterfaces in a resource group
	Value *[]Interface `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfaceListResultIterator provides access to a complete listing of Interface values.
type InterfaceListResultIterator struct {
	i    int
	page InterfaceListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter InterfaceListResultIterator) Response() InterfaceListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceListResultIterator) Value() Interface {
	if !iter.page.NotDone() {
		return Interface{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (ilr InterfaceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// interfaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InterfaceListResult) interfaceListResultPreparer() (*http.Request, error) {
	if ilr.NextLink == nil || len(to.String(ilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfaceListResultPage contains a page of Interface values.
type InterfaceListResultPage struct {
	fn  func(InterfaceListResult) (InterfaceListResult, error)
	ilr InterfaceListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceListResultPage) Next() error {
	next, err := page.fn(page.ilr)
	if err != nil {
		return err
	}
	page.ilr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page InterfaceListResultPage) Response() InterfaceListResult {
	return page.ilr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceListResultPage) Values() []Interface {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfacePropertiesFormat networkInterface properties.
type InterfacePropertiesFormat struct {
	// VirtualMachine - Gets or sets the reference of a VirtualMachine
	VirtualMachine *SubResource `json:"virtualMachine,omitempty"`
	// NetworkSecurityGroup - Gets or sets the reference of the NetworkSecurityGroup resource
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`
	// IPConfigurations - Gets or sets list of IPConfigurations of the NetworkInterface
	IPConfigurations *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// DNSSettings - Gets or sets DNS Settings in  NetworkInterface
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`
	// MacAddress - Gets the MAC Address of the network interface
	MacAddress *string `json:"macAddress,omitempty"`
	// Primary - Gets whether this is a primary NIC on a virtual machine
	Primary *bool `json:"primary,omitempty"`
	// EnableIPForwarding - Gets or sets whether IPForwarding is enabled on the NIC
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the network interface resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InterfacesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InterfacesCreateOrUpdateFuture) Result(client InterfacesClient) (i Interface, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return i, azure.NewAsyncOpIncompleteError("network.InterfacesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		i, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	i, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// InterfacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type InterfacesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InterfacesDeleteFuture) Result(client InterfacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.InterfacesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancer loadBalancer resource
type LoadBalancer struct {
	autorest.Response             `json:"-"`
	*LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for LoadBalancer.
func (lb LoadBalancer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lb.LoadBalancerPropertiesFormat != nil {
		objectMap["properties"] = lb.LoadBalancerPropertiesFormat
	}
	if lb.Etag != nil {
		objectMap["etag"] = lb.Etag
	}
	if lb.ID != nil {
		objectMap["id"] = lb.ID
	}
	if lb.Name != nil {
		objectMap["name"] = lb.Name
	}
	if lb.Type != nil {
		objectMap["type"] = lb.Type
	}
	if lb.Location != nil {
		objectMap["location"] = lb.Location
	}
	if lb.Tags != nil {
		objectMap["tags"] = lb.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for LoadBalancer struct.
func (lb *LoadBalancer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancerPropertiesFormat LoadBalancerPropertiesFormat
				err = json.Unmarshal(*v, &loadBalancerPropertiesFormat)
				if err != nil {
					return err
				}
				lb.LoadBalancerPropertiesFormat = &loadBalancerPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lb.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lb.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lb.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lb.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancerListResult response for ListLoadBalancers Api service call
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of LoadBalancers in a resource group
	Value *[]LoadBalancer `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancerListResultIterator provides access to a complete listing of LoadBalancer values.
type LoadBalancerListResultIterator struct {
	i    int
	page LoadBalancerListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter LoadBalancerListResultIterator) Response() LoadBalancerListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerListResultIterator) Value() LoadBalancer {
	if !iter.page.NotDone() {
		return LoadBalancer{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (lblr LoadBalancerListResult) IsEmpty() bool {
	return lblr.Value == nil || len(*lblr.Value) == 0
}

// loadBalancerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lblr LoadBalancerListResult) loadBalancerListResultPreparer() (*http.Request, error) {
	if lblr.NextLink == nil || len(to.String(lblr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lblr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancerListResultPage contains a page of LoadBalancer values.
type LoadBalancerListResultPage struct {
	fn   func(LoadBalancerListResult) (LoadBalancerListResult, error)
	lblr LoadBalancerListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerListResultPage) Next() error {
	next, err := page.fn(page.lblr)
	if err != nil {
		return err
	}
	page.lblr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerListResultPage) NotDone() bool {
	return !page.lblr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page LoadBalancerListResultPage) Response() LoadBalancerListResult {
	return page.lblr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerListResultPage) Values() []LoadBalancer {
	if page.lblr.IsEmpty() {
		return nil
	}
	return *page.lblr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancerPropertiesFormat properties of Load Balancer
type LoadBalancerPropertiesFormat struct {
	// FrontendIPConfigurations - Gets or sets frontend IP addresses of the load balancer
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPools - Gets or sets Pools of backend IP addresseses
	BackendAddressPools *[]BackendAddressPool `json:"backendAddressPools,omitempty"`
	// LoadBalancingRules - Gets or sets loadbalancing rules
	LoadBalancingRules *[]LoadBalancingRule `json:"loadBalancingRules,omitempty"`
	// Probes - Gets or sets list of Load balancer probes
	Probes *[]Probe `json:"probes,omitempty"`
	// InboundNatRules - Gets or sets list of inbound rules
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Gets or sets inbound NAT pools
	InboundNatPools *[]InboundNatPool `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - Gets or sets outbound NAT rules
	OutboundNatRules *[]OutboundNatRule `json:"outboundNatRules,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the Load balancer resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LoadBalancersCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LoadBalancersCreateOrUpdateFuture) Result(client LoadBalancersClient) (lb LoadBalancer, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return lb, azure.NewAsyncOpIncompleteError("network.LoadBalancersCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		lb, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	lb, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LoadBalancersDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LoadBalancersDeleteFuture) Result(client LoadBalancersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.LoadBalancersDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancingRule rules of the load balancer
type LoadBalancingRule struct {
	*LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for LoadBalancingRule.
func (lbr LoadBalancingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbr.LoadBalancingRulePropertiesFormat != nil {
		objectMap["properties"] = lbr.LoadBalancingRulePropertiesFormat
	}
	if lbr.Name != nil {
		objectMap["name"] = lbr.Name
	}
	if lbr.Etag != nil {
		objectMap["etag"] = lbr.Etag
	}
	if lbr.ID != nil {
		objectMap["id"] = lbr.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for LoadBalancingRule struct.
func (lbr *LoadBalancingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancingRulePropertiesFormat LoadBalancingRulePropertiesFormat
				err = json.Unmarshal(*v, &loadBalancingRulePropertiesFormat)
				if err != nil {
					return err
				}
				lbr.LoadBalancingRulePropertiesFormat = &loadBalancingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lbr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lbr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lbr.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LoadBalancingRulePropertiesFormat properties of the load balancer
type LoadBalancingRulePropertiesFormat struct {
	// FrontendIPConfiguration - Gets or sets a reference to frontend IP Addresses
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendAddressPool - Gets or sets  a reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// Probe - Gets or sets the reference of the load balancer probe used by the Load Balancing rule.
	Probe *SubResource `json:"probe,omitempty"`
	// Protocol - Gets or sets the transport protocol for the external endpoint. Possible values are Udp or Tcp. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// LoadDistribution - Gets or sets the load distribution policy for this rule. Possible values include: 'Default', 'SourceIP', 'SourceIPProtocol'
	LoadDistribution LoadDistribution `json:"loadDistribution,omitempty"`
	// FrontendPort - Gets or sets the port for the external endpoint. You can specify any port number you choose, but the port numbers specified for each role in the service must be unique. Possible values range between 1 and 65535, inclusive
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - Gets or sets a port used for internal connections on the endpoint. The localPort attribute maps the eternal port of the endpoint to an internal port on a role. This is useful in scenarios where a role must communicate to an internal compotnent on a port that is different from the one that is exposed externally. If not specified, the value of localPort is the same as the port attribute. Set the value of localPort to '*' to automatically assign an unallocated port that is discoverable using the runtime API
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - Gets or sets the timeout for the Tcp idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This emlement is only used when the protocol is set to Tcp
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn availability Group. This setting is required when using the SQL Always ON availability Groups in SQL server. This setting can't be changed after you create the endpoint
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LocalNetworkGateway a common class for general resource information
type LocalNetworkGateway struct {
	autorest.Response                    `json:"-"`
	*LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for LocalNetworkGateway.
func (lng LocalNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lng.LocalNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = lng.LocalNetworkGatewayPropertiesFormat
	}
	if lng.Etag != nil {
		objectMap["etag"] = lng.Etag
	}
	if lng.ID != nil {
		objectMap["id"] = lng.ID
	}
	if lng.Name != nil {
		objectMap["name"] = lng.Name
	}
	if lng.Type != nil {
		objectMap["type"] = lng.Type
	}
	if lng.Location != nil {
		objectMap["location"] = lng.Location
	}
	if lng.Tags != nil {
		objectMap["tags"] = lng.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for LocalNetworkGateway struct.
func (lng *LocalNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var localNetworkGatewayPropertiesFormat LocalNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &localNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				lng.LocalNetworkGatewayPropertiesFormat = &localNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lng.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LocalNetworkGatewayListResult response for ListLocalNetworkGateways Api service call
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of LocalNetworkGateways that exists in a resource group
	Value *[]LocalNetworkGateway `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LocalNetworkGatewayListResultIterator provides access to a complete listing of LocalNetworkGateway values.
type LocalNetworkGatewayListResultIterator struct {
	i    int
	page LocalNetworkGatewayListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocalNetworkGatewayListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocalNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter LocalNetworkGatewayListResultIterator) Response() LocalNetworkGatewayListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocalNetworkGatewayListResultIterator) Value() LocalNetworkGateway {
	if !iter.page.NotDone() {
		return LocalNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (lnglr LocalNetworkGatewayListResult) IsEmpty() bool {
	return lnglr.Value == nil || len(*lnglr.Value) == 0
}

// localNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnglr LocalNetworkGatewayListResult) localNetworkGatewayListResultPreparer() (*http.Request, error) {
	if lnglr.NextLink == nil || len(to.String(lnglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnglr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LocalNetworkGatewayListResultPage contains a page of LocalNetworkGateway values.
type LocalNetworkGatewayListResultPage struct {
	fn    func(LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)
	lnglr LocalNetworkGatewayListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocalNetworkGatewayListResultPage) Next() error {
	next, err := page.fn(page.lnglr)
	if err != nil {
		return err
	}
	page.lnglr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocalNetworkGatewayListResultPage) NotDone() bool {
	return !page.lnglr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page LocalNetworkGatewayListResultPage) Response() LocalNetworkGatewayListResult {
	return page.lnglr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page LocalNetworkGatewayListResultPage) Values() []LocalNetworkGateway {
	if page.lnglr.IsEmpty() {
		return nil
	}
	return *page.lnglr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LocalNetworkGatewayPropertiesFormat localNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	// LocalNetworkAddressSpace - Local network site Address space
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	// GatewayIPAddress - IP address of local network gateway.
	GatewayIPAddress *string `json:"gatewayIpAddress,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the LocalNetworkGateway resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the LocalNetworkGateway resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LocalNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LocalNetworkGatewaysCreateOrUpdateFuture) Result(client LocalNetworkGatewaysClient) (lng LocalNetworkGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return lng, azure.NewAsyncOpIncompleteError("network.LocalNetworkGatewaysCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		lng, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	lng, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// LocalNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LocalNetworkGatewaysDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future LocalNetworkGatewaysDeleteFuture) Result(client LocalNetworkGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.LocalNetworkGatewaysDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// OutboundNatRule outbound NAT pool of the loadbalancer
type OutboundNatRule struct {
	*OutboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for OutboundNatRule.
func (onr OutboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if onr.OutboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = onr.OutboundNatRulePropertiesFormat
	}
	if onr.Name != nil {
		objectMap["name"] = onr.Name
	}
	if onr.Etag != nil {
		objectMap["etag"] = onr.Etag
	}
	if onr.ID != nil {
		objectMap["id"] = onr.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for OutboundNatRule struct.
func (onr *OutboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outboundNatRulePropertiesFormat OutboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &outboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				onr.OutboundNatRulePropertiesFormat = &outboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				onr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				onr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				onr.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// OutboundNatRulePropertiesFormat outbound NAT pool of the loadbalancer
type OutboundNatRulePropertiesFormat struct {
	// AllocatedOutboundPorts - Gets or sets the number of outbound ports to be used for SNAT
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`
	// FrontendIPConfigurations - Gets or sets Frontend IP addresses of the load balancer
	FrontendIPConfigurations *[]SubResource `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPool - Gets or sets a reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Probe load balancer Probe
type Probe struct {
	*ProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for Probe.
func (p Probe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProbePropertiesFormat != nil {
		objectMap["properties"] = p.ProbePropertiesFormat
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for Probe struct.
func (p *Probe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var probePropertiesFormat ProbePropertiesFormat
				err = json.Unmarshal(*v, &probePropertiesFormat)
				if err != nil {
					return err
				}
				p.ProbePropertiesFormat = &probePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// ProbePropertiesFormat ...
type ProbePropertiesFormat struct {
	// LoadBalancingRules - Gets Load balancer rules that use this probe
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// Protocol - Gets or sets the protocol of the end point. Possible values are http pr Tcp. If Tcp is specified, a received ACK is required for the probe to be successful. If http is specified,a 200 OK response from the specifies URI is required for the probe to be successful. Possible values include: 'ProbeProtocolHTTP', 'ProbeProtocolTCP'
	Protocol ProbeProtocol `json:"protocol,omitempty"`
	// Port - Gets or sets Port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32 `json:"port,omitempty"`
	// IntervalInSeconds - Gets or sets the interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
	// NumberOfProbes - Gets or sets the number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endponints to be taken out of rotation faster or slower than the typical times used in Azure.
	NumberOfProbes *int32 `json:"numberOfProbes,omitempty"`
	// RequestPath - Gets or sets the URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value
	RequestPath *string `json:"requestPath,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddress publicIPAddress resource
type PublicIPAddress struct {
	autorest.Response                `json:"-"`
	*PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for PublicIPAddress.
func (pia PublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pia.PublicIPAddressPropertiesFormat != nil {
		objectMap["properties"] = pia.PublicIPAddressPropertiesFormat
	}
	if pia.Etag != nil {
		objectMap["etag"] = pia.Etag
	}
	if pia.ID != nil {
		objectMap["id"] = pia.ID
	}
	if pia.Name != nil {
		objectMap["name"] = pia.Name
	}
	if pia.Type != nil {
		objectMap["type"] = pia.Type
	}
	if pia.Location != nil {
		objectMap["location"] = pia.Location
	}
	if pia.Tags != nil {
		objectMap["tags"] = pia.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for PublicIPAddress struct.
func (pia *PublicIPAddress) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publicIPAddressPropertiesFormat PublicIPAddressPropertiesFormat
				err = json.Unmarshal(*v, &publicIPAddressPropertiesFormat)
				if err != nil {
					return err
				}
				pia.PublicIPAddressPropertiesFormat = &publicIPAddressPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pia.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pia.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pia.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pia.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddressDNSSettings contains FQDN of the DNS record associated with the public IP address
type PublicIPAddressDNSSettings struct {
	// DomainNameLabel - Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	// Fqdn - Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
	Fqdn *string `json:"fqdn,omitempty"`
	// ReverseFqdn - Gets or Sests the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string `json:"reverseFqdn,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddressesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPAddressesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PublicIPAddressesCreateOrUpdateFuture) Result(client PublicIPAddressesClient) (pia PublicIPAddress, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return pia, azure.NewAsyncOpIncompleteError("network.PublicIPAddressesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		pia, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	pia, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddressesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPAddressesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future PublicIPAddressesDeleteFuture) Result(client PublicIPAddressesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.PublicIPAddressesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddressListResult response for ListPublicIpAddresses Api service call
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of publicIP addresses that exists in a resource group
	Value *[]PublicIPAddress `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddressListResultIterator provides access to a complete listing of PublicIPAddress values.
type PublicIPAddressListResultIterator struct {
	i    int
	page PublicIPAddressListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicIPAddressListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicIPAddressListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter PublicIPAddressListResultIterator) Response() PublicIPAddressListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicIPAddressListResultIterator) Value() PublicIPAddress {
	if !iter.page.NotDone() {
		return PublicIPAddress{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (pialr PublicIPAddressListResult) IsEmpty() bool {
	return pialr.Value == nil || len(*pialr.Value) == 0
}

// publicIPAddressListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pialr PublicIPAddressListResult) publicIPAddressListResultPreparer() (*http.Request, error) {
	if pialr.NextLink == nil || len(to.String(pialr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pialr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddressListResultPage contains a page of PublicIPAddress values.
type PublicIPAddressListResultPage struct {
	fn    func(PublicIPAddressListResult) (PublicIPAddressListResult, error)
	pialr PublicIPAddressListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicIPAddressListResultPage) Next() error {
	next, err := page.fn(page.pialr)
	if err != nil {
		return err
	}
	page.pialr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicIPAddressListResultPage) NotDone() bool {
	return !page.pialr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page PublicIPAddressListResultPage) Response() PublicIPAddressListResult {
	return page.pialr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicIPAddressListResultPage) Values() []PublicIPAddress {
	if page.pialr.IsEmpty() {
		return nil
	}
	return *page.pialr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// PublicIPAddressPropertiesFormat publicIpAddress properties
type PublicIPAddressPropertiesFormat struct {
	// PublicIPAllocationMethod - Gets or sets PublicIP allocation method (Static/Dynamic). Possible values include: 'Static', 'Dynamic'
	PublicIPAllocationMethod IPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`
	// IPConfiguration - Gets a reference to the network interface IP configurations using this public IP address
	IPConfiguration *SubResource `json:"ipConfiguration,omitempty"`
	// DNSSettings - Gets or sets FQDN of the DNS record associated with the public IP address
	DNSSettings *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	// IPAddress - Gets the assigned public IP address
	IPAddress *string `json:"ipAddress,omitempty"`
	// IdleTimeoutInMinutes - Gets or sets the Idletimeout of the public IP address
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the PublicIP resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Resource ...
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Route route resource
type Route struct {
	autorest.Response      `json:"-"`
	*RoutePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RoutePropertiesFormat != nil {
		objectMap["properties"] = r.RoutePropertiesFormat
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for Route struct.
func (r *Route) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routePropertiesFormat RoutePropertiesFormat
				err = json.Unmarshal(*v, &routePropertiesFormat)
				if err != nil {
					return err
				}
				r.RoutePropertiesFormat = &routePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteListResult response for ListRoute Api servive call
type RouteListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of Routes in a resource group
	Value *[]Route `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteListResultIterator provides access to a complete listing of Route values.
type RouteListResultIterator struct {
	i    int
	page RouteListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter RouteListResultIterator) Response() RouteListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteListResultIterator) Value() Route {
	if !iter.page.NotDone() {
		return Route{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (rlr RouteListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// routeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RouteListResult) routeListResultPreparer() (*http.Request, error) {
	if rlr.NextLink == nil || len(to.String(rlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteListResultPage contains a page of Route values.
type RouteListResultPage struct {
	fn  func(RouteListResult) (RouteListResult, error)
	rlr RouteListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteListResultPage) Next() error {
	next, err := page.fn(page.rlr)
	if err != nil {
		return err
	}
	page.rlr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page RouteListResultPage) Response() RouteListResult {
	return page.rlr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteListResultPage) Values() []Route {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RoutePropertiesFormat route resource
type RoutePropertiesFormat struct {
	// AddressPrefix - Gets or sets the destination CIDR to which the route applies.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NextHopType - Gets or sets the type of Azure hop the packet should be sent to. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
	// NextHopIPAddress - Gets or sets the IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RoutesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RoutesCreateOrUpdateFuture) Result(client RoutesClient) (r Route, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return r, azure.NewAsyncOpIncompleteError("network.RoutesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		r, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	r, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RoutesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RoutesDeleteFuture) Result(client RoutesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.RoutesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteTable routeTable resource
type RouteTable struct {
	autorest.Response           `json:"-"`
	*RouteTablePropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for RouteTable.
func (rt RouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.RouteTablePropertiesFormat != nil {
		objectMap["properties"] = rt.RouteTablePropertiesFormat
	}
	if rt.Etag != nil {
		objectMap["etag"] = rt.Etag
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Name != nil {
		objectMap["name"] = rt.Name
	}
	if rt.Type != nil {
		objectMap["type"] = rt.Type
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for RouteTable struct.
func (rt *RouteTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeTablePropertiesFormat RouteTablePropertiesFormat
				err = json.Unmarshal(*v, &routeTablePropertiesFormat)
				if err != nil {
					return err
				}
				rt.RouteTablePropertiesFormat = &routeTablePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rt.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteTableListResult response for ListRouteTable Api servive call
type RouteTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of RouteTables in a resource group
	Value *[]RouteTable `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteTableListResultIterator provides access to a complete listing of RouteTable values.
type RouteTableListResultIterator struct {
	i    int
	page RouteTableListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteTableListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter RouteTableListResultIterator) Response() RouteTableListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteTableListResultIterator) Value() RouteTable {
	if !iter.page.NotDone() {
		return RouteTable{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (rtlr RouteTableListResult) IsEmpty() bool {
	return rtlr.Value == nil || len(*rtlr.Value) == 0
}

// routeTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtlr RouteTableListResult) routeTableListResultPreparer() (*http.Request, error) {
	if rtlr.NextLink == nil || len(to.String(rtlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtlr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteTableListResultPage contains a page of RouteTable values.
type RouteTableListResultPage struct {
	fn   func(RouteTableListResult) (RouteTableListResult, error)
	rtlr RouteTableListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteTableListResultPage) Next() error {
	next, err := page.fn(page.rtlr)
	if err != nil {
		return err
	}
	page.rtlr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteTableListResultPage) NotDone() bool {
	return !page.rtlr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page RouteTableListResultPage) Response() RouteTableListResult {
	return page.rtlr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteTableListResultPage) Values() []RouteTable {
	if page.rtlr.IsEmpty() {
		return nil
	}
	return *page.rtlr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteTablePropertiesFormat route Table resource
type RouteTablePropertiesFormat struct {
	// Routes - Gets or sets Routes in a Route Table
	Routes *[]Route `json:"routes,omitempty"`
	// Subnets - Gets collection of references to subnets
	Subnets *[]SubResource `json:"subnets,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteTablesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteTablesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteTablesCreateOrUpdateFuture) Result(client RouteTablesClient) (rt RouteTable, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rt, azure.NewAsyncOpIncompleteError("network.RouteTablesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rt, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	rt, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// RouteTablesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RouteTablesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RouteTablesDeleteFuture) Result(client RouteTablesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.RouteTablesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityGroup networkSecurityGroup resource
type SecurityGroup struct {
	autorest.Response              `json:"-"`
	*SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for SecurityGroup.
func (sg SecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SecurityGroupPropertiesFormat != nil {
		objectMap["properties"] = sg.SecurityGroupPropertiesFormat
	}
	if sg.Etag != nil {
		objectMap["etag"] = sg.Etag
	}
	if sg.ID != nil {
		objectMap["id"] = sg.ID
	}
	if sg.Name != nil {
		objectMap["name"] = sg.Name
	}
	if sg.Type != nil {
		objectMap["type"] = sg.Type
	}
	if sg.Location != nil {
		objectMap["location"] = sg.Location
	}
	if sg.Tags != nil {
		objectMap["tags"] = sg.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for SecurityGroup struct.
func (sg *SecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityGroupPropertiesFormat SecurityGroupPropertiesFormat
				err = json.Unmarshal(*v, &securityGroupPropertiesFormat)
				if err != nil {
					return err
				}
				sg.SecurityGroupPropertiesFormat = &securityGroupPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sg.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityGroupListResult response for ListNetworkSecurityGroups Api servive call
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of NetworkSecurityGroups in a resource group
	Value *[]SecurityGroup `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityGroupListResultIterator provides access to a complete listing of SecurityGroup values.
type SecurityGroupListResultIterator struct {
	i    int
	page SecurityGroupListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityGroupListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter SecurityGroupListResultIterator) Response() SecurityGroupListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityGroupListResultIterator) Value() SecurityGroup {
	if !iter.page.NotDone() {
		return SecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (sglr SecurityGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// securityGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SecurityGroupListResult) securityGroupListResultPreparer() (*http.Request, error) {
	if sglr.NextLink == nil || len(to.String(sglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityGroupListResultPage contains a page of SecurityGroup values.
type SecurityGroupListResultPage struct {
	fn   func(SecurityGroupListResult) (SecurityGroupListResult, error)
	sglr SecurityGroupListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityGroupListResultPage) Next() error {
	next, err := page.fn(page.sglr)
	if err != nil {
		return err
	}
	page.sglr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page SecurityGroupListResultPage) Response() SecurityGroupListResult {
	return page.sglr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityGroupListResultPage) Values() []SecurityGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityGroupPropertiesFormat network Security Group resource
type SecurityGroupPropertiesFormat struct {
	// SecurityRules - Gets or sets Security rules of network security group
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
	// DefaultSecurityRules - Gets or sets Default security rules of network security group
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	// NetworkInterfaces - Gets collection of references to Network Interfaces
	NetworkInterfaces *[]SubResource `json:"networkInterfaces,omitempty"`
	// Subnets - Gets collection of references to subnets
	Subnets *[]SubResource `json:"subnets,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the network security group resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityGroupsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityGroupsCreateOrUpdateFuture) Result(client SecurityGroupsClient) (sg SecurityGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sg, azure.NewAsyncOpIncompleteError("network.SecurityGroupsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sg, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	sg, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SecurityGroupsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityGroupsDeleteFuture) Result(client SecurityGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.SecurityGroupsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRule network security rule
type SecurityRule struct {
	autorest.Response             `json:"-"`
	*SecurityRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for SecurityRule.
func (sr SecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SecurityRulePropertiesFormat != nil {
		objectMap["properties"] = sr.SecurityRulePropertiesFormat
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for SecurityRule struct.
func (sr *SecurityRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityRulePropertiesFormat SecurityRulePropertiesFormat
				err = json.Unmarshal(*v, &securityRulePropertiesFormat)
				if err != nil {
					return err
				}
				sr.SecurityRulePropertiesFormat = &securityRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRuleListResult response for ListSecurityRule Api service callRetrieves all security rules that belongs
// to a network security group
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets security rules in a network security group
	Value *[]SecurityRule `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRuleListResultIterator provides access to a complete listing of SecurityRule values.
type SecurityRuleListResultIterator struct {
	i    int
	page SecurityRuleListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter SecurityRuleListResultIterator) Response() SecurityRuleListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityRuleListResultIterator) Value() SecurityRule {
	if !iter.page.NotDone() {
		return SecurityRule{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (srlr SecurityRuleListResult) IsEmpty() bool {
	return srlr.Value == nil || len(*srlr.Value) == 0
}

// securityRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srlr SecurityRuleListResult) securityRuleListResultPreparer() (*http.Request, error) {
	if srlr.NextLink == nil || len(to.String(srlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srlr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRuleListResultPage contains a page of SecurityRule values.
type SecurityRuleListResultPage struct {
	fn   func(SecurityRuleListResult) (SecurityRuleListResult, error)
	srlr SecurityRuleListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityRuleListResultPage) Next() error {
	next, err := page.fn(page.srlr)
	if err != nil {
		return err
	}
	page.srlr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityRuleListResultPage) NotDone() bool {
	return !page.srlr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page SecurityRuleListResultPage) Response() SecurityRuleListResult {
	return page.srlr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityRuleListResultPage) Values() []SecurityRule {
	if page.srlr.IsEmpty() {
		return nil
	}
	return *page.srlr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRulePropertiesFormat ...
type SecurityRulePropertiesFormat struct {
	// Description - Gets or sets a description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Protocol - Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*). Possible values include: 'TCP', 'UDP', 'Asterisk'
	Protocol SecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - Gets or sets Source Port or Range. Integer or range between 0 and 65535. Asterix '*' can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - Gets or sets Destination Port or Range. Integer or range between 0 and 65535. Asterix '*' can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourceAddressPrefix - Gets or sets source address prefix. CIDR or source IP range. Asterix '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - Gets or sets destination address prefix. CIDR or source IP range. Asterix '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// Access - Gets or sets network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'. Possible values include: 'Allow', 'Deny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - Gets or sets the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - Gets or sets the direction of the rule.InBound or Outbound. The direction specifies if rule will be evaluated on incoming or outcoming traffic. Possible values include: 'Inbound', 'Outbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityRulesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityRulesCreateOrUpdateFuture) Result(client SecurityRulesClient) (sr SecurityRule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("network.SecurityRulesCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SecurityRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SecurityRulesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SecurityRulesDeleteFuture) Result(client SecurityRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.SecurityRulesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Subnet subnet in a VirtualNework resource
type Subnet struct {
	autorest.Response       `json:"-"`
	*SubnetPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SubnetPropertiesFormat != nil {
		objectMap["properties"] = s.SubnetPropertiesFormat
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for Subnet struct.
func (s *Subnet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subnetPropertiesFormat SubnetPropertiesFormat
				err = json.Unmarshal(*v, &subnetPropertiesFormat)
				if err != nil {
					return err
				}
				s.SubnetPropertiesFormat = &subnetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SubnetListResult response for ListSubnets Api service callRetrieves all subnet that belongs to a virtual network
type SubnetListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the subnets in a virtual network
	Value *[]Subnet `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SubnetListResultIterator provides access to a complete listing of Subnet values.
type SubnetListResultIterator struct {
	i    int
	page SubnetListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubnetListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubnetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter SubnetListResultIterator) Response() SubnetListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubnetListResultIterator) Value() Subnet {
	if !iter.page.NotDone() {
		return Subnet{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (slr SubnetListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// subnetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubnetListResult) subnetListResultPreparer() (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SubnetListResultPage contains a page of Subnet values.
type SubnetListResultPage struct {
	fn  func(SubnetListResult) (SubnetListResult, error)
	slr SubnetListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubnetListResultPage) Next() error {
	next, err := page.fn(page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubnetListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page SubnetListResultPage) Response() SubnetListResult {
	return page.slr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page SubnetListResultPage) Values() []Subnet {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SubnetPropertiesFormat ...
type SubnetPropertiesFormat struct {
	// AddressPrefix - Gets or sets Address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NetworkSecurityGroup - Gets or sets the reference of the NetworkSecurityGroup resource
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`
	// RouteTable - Gets or sets the reference of the RouteTable resource
	RouteTable *SubResource `json:"routeTable,omitempty"`
	// IPConfigurations - Gets array of references to the network interface IP configurations using subnet
	IPConfigurations *[]SubResource `json:"ipConfigurations,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SubnetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SubnetsCreateOrUpdateFuture) Result(client SubnetsClient) (s Subnet, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return s, azure.NewAsyncOpIncompleteError("network.SubnetsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		s, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	s, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SubnetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SubnetsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future SubnetsDeleteFuture) Result(client SubnetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.SubnetsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Usage describes Network Resource Usage.
type Usage struct {
	// Unit - Gets or sets an enum describing the unit of measurement.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Gets or sets the current value of the usage.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - Gets or sets the limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - Gets or sets the name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UsageName the Usage Names.
type UsageName struct {
	// Value - Gets or sets a string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Gets or sets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UsagesListResult the List Usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list Network Resource Usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UsagesListResultIterator provides access to a complete listing of Usage values.
type UsagesListResultIterator struct {
	i    int
	page UsagesListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsagesListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsagesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter UsagesListResultIterator) Response() UsagesListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsagesListResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (ulr UsagesListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// usagesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsagesListResult) usagesListResultPreparer() (*http.Request, error) {
	if ulr.NextLink == nil || len(to.String(ulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UsagesListResultPage contains a page of Usage values.
type UsagesListResultPage struct {
	fn  func(UsagesListResult) (UsagesListResult, error)
	ulr UsagesListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsagesListResultPage) Next() error {
	next, err := page.fn(page.ulr)
	if err != nil {
		return err
	}
	page.ulr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsagesListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page UsagesListResultPage) Response() UsagesListResult {
	return page.ulr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page UsagesListResultPage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetwork virtual Network resource
type VirtualNetwork struct {
	autorest.Response               `json:"-"`
	*VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkPropertiesFormat != nil {
		objectMap["properties"] = vn.VirtualNetworkPropertiesFormat
	}
	if vn.Etag != nil {
		objectMap["etag"] = vn.Etag
	}
	if vn.ID != nil {
		objectMap["id"] = vn.ID
	}
	if vn.Name != nil {
		objectMap["name"] = vn.Name
	}
	if vn.Type != nil {
		objectMap["type"] = vn.Type
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPropertiesFormat VirtualNetworkPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkPropertiesFormat)
				if err != nil {
					return err
				}
				vn.VirtualNetworkPropertiesFormat = &virtualNetworkPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vn.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGateway a common class for general resource information
type VirtualNetworkGateway struct {
	autorest.Response                      `json:"-"`
	*VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for VirtualNetworkGateway.
func (vng VirtualNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vng.VirtualNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = vng.VirtualNetworkGatewayPropertiesFormat
	}
	if vng.Etag != nil {
		objectMap["etag"] = vng.Etag
	}
	if vng.ID != nil {
		objectMap["id"] = vng.ID
	}
	if vng.Name != nil {
		objectMap["name"] = vng.Name
	}
	if vng.Type != nil {
		objectMap["type"] = vng.Type
	}
	if vng.Location != nil {
		objectMap["location"] = vng.Location
	}
	if vng.Tags != nil {
		objectMap["tags"] = vng.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGateway struct.
func (vng *VirtualNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayPropertiesFormat VirtualNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				vng.VirtualNetworkGatewayPropertiesFormat = &virtualNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vng.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnection a common class for general resource information
type VirtualNetworkGatewayConnection struct {
	autorest.Response                                `json:"-"`
	*VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnection.
func (vngc VirtualNetworkGatewayConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngc.VirtualNetworkGatewayConnectionPropertiesFormat != nil {
		objectMap["properties"] = vngc.VirtualNetworkGatewayConnectionPropertiesFormat
	}
	if vngc.Etag != nil {
		objectMap["etag"] = vngc.Etag
	}
	if vngc.ID != nil {
		objectMap["id"] = vngc.ID
	}
	if vngc.Name != nil {
		objectMap["name"] = vngc.Name
	}
	if vngc.Type != nil {
		objectMap["type"] = vngc.Type
	}
	if vngc.Location != nil {
		objectMap["location"] = vngc.Location
	}
	if vngc.Tags != nil {
		objectMap["tags"] = vngc.Tags
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayConnection struct.
func (vngc *VirtualNetworkGatewayConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayConnectionPropertiesFormat VirtualNetworkGatewayConnectionPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				vngc.VirtualNetworkGatewayConnectionPropertiesFormat = &virtualNetworkGatewayConnectionPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vngc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vngc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vngc.Tags = tags
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionListResult response for ListVirtualNetworkGatewayConnections Api service call
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of VirtualNetworkGatewayConnections that exists in a resource group
	Value *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionListResultIterator provides access to a complete listing of
// VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultIterator struct {
	i    int
	page VirtualNetworkGatewayConnectionListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Response() VirtualNetworkGatewayConnectionListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Value() VirtualNetworkGatewayConnection {
	if !iter.page.NotDone() {
		return VirtualNetworkGatewayConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (vngclr VirtualNetworkGatewayConnectionListResult) IsEmpty() bool {
	return vngclr.Value == nil || len(*vngclr.Value) == 0
}

// virtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vngclr VirtualNetworkGatewayConnectionListResult) virtualNetworkGatewayConnectionListResultPreparer() (*http.Request, error) {
	if vngclr.NextLink == nil || len(to.String(vngclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vngclr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionListResultPage contains a page of VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultPage struct {
	fn     func(VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)
	vngclr VirtualNetworkGatewayConnectionListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayConnectionListResultPage) Next() error {
	next, err := page.fn(page.vngclr)
	if err != nil {
		return err
	}
	page.vngclr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayConnectionListResultPage) NotDone() bool {
	return !page.vngclr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayConnectionListResultPage) Response() VirtualNetworkGatewayConnectionListResult {
	return page.vngclr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayConnectionListResultPage) Values() []VirtualNetworkGatewayConnection {
	if page.vngclr.IsEmpty() {
		return nil
	}
	return *page.vngclr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionPropertiesFormat virtualNeworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	VirtualNetworkGateway1 *VirtualNetworkGateway `json:"virtualNetworkGateway1,omitempty"`
	VirtualNetworkGateway2 *VirtualNetworkGateway `json:"virtualNetworkGateway2,omitempty"`
	LocalNetworkGateway2   *LocalNetworkGateway   `json:"localNetworkGateway2,omitempty"`
	// ConnectionType - Gateway connection type -Ipsec/Dedicated/VpnClient/Vnet2Vnet. Possible values include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
	ConnectionType VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`
	// RoutingWeight - The Routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`
	// SharedKey - The Ipsec share key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// ConnectionStatus - Virtual network Gateway connection status. Possible values include: 'Unknown', 'Connecting', 'Connected', 'NotConnected'
	ConnectionStatus VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	// EgressBytesTransferred - The Egress Bytes Transferred in this connection
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty"`
	// IngressBytesTransferred - The Ingress Bytes Transferred in this connection
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty"`
	// Peer - The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the VirtualNetworkGatewayConnection resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the VirtualNetworkGatewayConnection resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsCreateOrUpdateFuture) Result(client VirtualNetworkGatewayConnectionsClient) (vngc VirtualNetworkGatewayConnection, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vngc, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vngc, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	vngc, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewayConnectionsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsDeleteFuture) Result(client VirtualNetworkGatewayConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionsResetSharedKeyFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsResetSharedKeyFuture) Result(client VirtualNetworkGatewayConnectionsClient) (crsk ConnectionResetSharedKey, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return crsk, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		crsk, err = client.ResetSharedKeyResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", resp, "Failure sending request")
		return
	}
	crsk, err = client.ResetSharedKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayConnectionsSetSharedKeyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewayConnectionsSetSharedKeyFuture) Result(client VirtualNetworkGatewayConnectionsClient) (csk ConnectionSharedKey, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return csk, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		csk, err = client.SetSharedKeyResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", resp, "Failure sending request")
		return
	}
	csk, err = client.SetSharedKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayIPConfiguration ipConfiguration for Virtual network gateway
type VirtualNetworkGatewayIPConfiguration struct {
	*VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// MarshalJSON is the custom marshaler for VirtualNetworkGatewayIPConfiguration.
func (vngic VirtualNetworkGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat
	}
	if vngic.Name != nil {
		objectMap["name"] = vngic.Name
	}
	if vngic.Etag != nil {
		objectMap["etag"] = vngic.Etag
	}
	if vngic.ID != nil {
		objectMap["id"] = vngic.ID
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayIPConfiguration struct.
func (vngic *VirtualNetworkGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayIPConfigurationPropertiesFormat VirtualNetworkGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat = &virtualNetworkGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngic.ID = &ID
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayIPConfigurationPropertiesFormat properties of VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - Gets or sets the privateIPAddress of the Network Interface IP Configuration
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method (Static/Dynamic). Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Gets or sets the reference of the subnet resource
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Gets or sets the reference of the PublicIP resource
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayListResult response for ListVirtualNetworkGateways Api service call
type VirtualNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of VirtualNetworkGateways that exists in a resource group
	Value *[]VirtualNetworkGateway `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayListResultIterator provides access to a complete listing of VirtualNetworkGateway values.
type VirtualNetworkGatewayListResultIterator struct {
	i    int
	page VirtualNetworkGatewayListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayListResultIterator) Response() VirtualNetworkGatewayListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayListResultIterator) Value() VirtualNetworkGateway {
	if !iter.page.NotDone() {
		return VirtualNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (vnglr VirtualNetworkGatewayListResult) IsEmpty() bool {
	return vnglr.Value == nil || len(*vnglr.Value) == 0
}

// virtualNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnglr VirtualNetworkGatewayListResult) virtualNetworkGatewayListResultPreparer() (*http.Request, error) {
	if vnglr.NextLink == nil || len(to.String(vnglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnglr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayListResultPage contains a page of VirtualNetworkGateway values.
type VirtualNetworkGatewayListResultPage struct {
	fn    func(VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)
	vnglr VirtualNetworkGatewayListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayListResultPage) Next() error {
	next, err := page.fn(page.vnglr)
	if err != nil {
		return err
	}
	page.vnglr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayListResultPage) NotDone() bool {
	return !page.vnglr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayListResultPage) Response() VirtualNetworkGatewayListResult {
	return page.vnglr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayListResultPage) Values() []VirtualNetworkGateway {
	if page.vnglr.IsEmpty() {
		return nil
	}
	return *page.vnglr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewayPropertiesFormat virtualNeworkGateay properties
type VirtualNetworkGatewayPropertiesFormat struct {
	// IPConfigurations - IpConfigurations for Virtual network gateway.
	IPConfigurations *[]VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`
	// GatewayType - The type of this virtual network gateway. Possible values include: 'VirtualNetworkGatewayTypeVpn', 'VirtualNetworkGatewayTypeExpressRoute'
	GatewayType VirtualNetworkGatewayType `json:"gatewayType,omitempty"`
	// VpnType - The type of this virtual network gateway. Possible values include: 'PolicyBased', 'RouteBased'
	VpnType VpnType `json:"vpnType,omitempty"`
	// EnableBgp - EnableBgp Flag
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// GatewayDefaultSite - Gets or sets the reference of the LocalNetworkGateway resource which represents Local network site having default routes. Assign Null value in case of removing existing default site setting.
	GatewayDefaultSite *SubResource `json:"gatewayDefaultSite,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the VirtualNetworkGateway resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the VirtualNetworkGateway resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysCreateOrUpdateFuture) Result(client VirtualNetworkGatewaysClient) (vng VirtualNetworkGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vng, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vng, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	vng, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworkGatewaysDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysDeleteFuture) Result(client VirtualNetworkGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkGatewaysResetFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworkGatewaysResetFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworkGatewaysResetFuture) Result(client VirtualNetworkGatewaysClient) (vng VirtualNetworkGateway, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vng, azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysResetFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vng, err = client.ResetResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", resp, "Failure sending request")
		return
	}
	vng, err = client.ResetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkListResult response for ListVirtualNetworks Api servive call
type VirtualNetworkListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets list of VirtualNetworks in a resource group
	Value *[]VirtualNetwork `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkListResultIterator provides access to a complete listing of VirtualNetwork values.
type VirtualNetworkListResultIterator struct {
	i    int
	page VirtualNetworkListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (iter VirtualNetworkListResultIterator) Response() VirtualNetworkListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkListResultIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// IsEmpty returns true if the ListResult contains no values.
func (vnlr VirtualNetworkListResult) IsEmpty() bool {
	return vnlr.Value == nil || len(*vnlr.Value) == 0
}

// virtualNetworkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnlr VirtualNetworkListResult) virtualNetworkListResultPreparer() (*http.Request, error) {
	if vnlr.NextLink == nil || len(to.String(vnlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnlr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkListResultPage contains a page of VirtualNetwork values.
type VirtualNetworkListResultPage struct {
	fn   func(VirtualNetworkListResult) (VirtualNetworkListResult, error)
	vnlr VirtualNetworkListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkListResultPage) Next() error {
	next, err := page.fn(page.vnlr)
	if err != nil {
		return err
	}
	page.vnlr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkListResultPage) NotDone() bool {
	return !page.vnlr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Response returns the raw server response from the last page request.
func (page VirtualNetworkListResultPage) Response() VirtualNetworkListResult {
	return page.vnlr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkListResultPage) Values() []VirtualNetwork {
	if page.vnlr.IsEmpty() {
		return nil
	}
	return *page.vnlr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworkPropertiesFormat ...
type VirtualNetworkPropertiesFormat struct {
	// AddressSpace - Gets or sets AddressSpace that contains an array of IP address ranges that can be used by subnets
	AddressSpace *AddressSpace `json:"addressSpace,omitempty"`
	// DhcpOptions - Gets or sets DHCPOptions that contains an array of DNS servers available to VMs deployed in the virtual network
	DhcpOptions *DhcpOptions `json:"dhcpOptions,omitempty"`
	// Subnets - Gets or sets List of subnets in a VirtualNetwork
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ResourceGUID - Gets or sets resource guid property of the VirtualNetwork resource
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the PublicIP resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworksCreateOrUpdateFuture) Result(client VirtualNetworksClient) (vn VirtualNetwork, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return vn, azure.NewAsyncOpIncompleteError("network.VirtualNetworksCreateOrUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		vn, err = client.CreateOrUpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	vn, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// VirtualNetworksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/network/mgmt/2015-05-01-preview/network instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future VirtualNetworksDeleteFuture) Result(client VirtualNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("network.VirtualNetworksDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}
