package adhybridhealthservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"net/http"
)

// AddsServiceClient is the REST APIs for Azure Active Drectory Connect Health
type AddsServiceClient struct {
	BaseClient
}

// NewAddsServiceClient creates an instance of the AddsServiceClient client.
func NewAddsServiceClient() AddsServiceClient {
	return NewAddsServiceClientWithBaseURI(DefaultBaseURI)
}

// NewAddsServiceClientWithBaseURI creates an instance of the AddsServiceClient client.
func NewAddsServiceClientWithBaseURI(baseURI string) AddsServiceClient {
	return AddsServiceClient{NewWithBaseURI(baseURI)}
}

// GetMetrics gets the server related metrics for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
// groupKey - the group key
// fromDate - the start date.
// toDate - the end date.
func (client AddsServiceClient) GetMetrics(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (result MetricSets, err error) {
	req, err := client.GetMetricsPreparer(ctx, serviceName, metricName, groupName, groupKey, fromDate, toDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServiceClient", "GetMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServiceClient", "GetMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServiceClient", "GetMetrics", resp, "Failure responding to request")
	}

	return
}

// GetMetricsPreparer prepares the GetMetrics request.
func (client AddsServiceClient) GetMetricsPreparer(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(groupKey) > 0 {
		queryParameters["groupKey"] = autorest.Encode("query", groupKey)
	}
	if fromDate != nil {
		queryParameters["fromDate"] = autorest.Encode("query", *fromDate)
	}
	if toDate != nil {
		queryParameters["toDate"] = autorest.Encode("query", *toDate)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metrics/{metricName}/groups/{groupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMetricsSender sends the GetMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServiceClient) GetMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetMetricsResponder handles the response to the GetMetrics request. The method always
// closes the http.Response Body.
func (client AddsServiceClient) GetMetricsResponder(resp *http.Response) (result MetricSets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
