package websearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// WebClient is the the Web Search API lets you send a search query to Bing and get back search results that include
// links to webpages, images, and more.
type WebClient struct {
	BaseClient
}

// NewWebClient creates an instance of the WebClient client.
func NewWebClient() WebClient {
	return WebClient{New()}
}

// Search sends the search request.
// Parameters:
// query - the user's search query term. The term may not be empty. The term may contain Bing Advanced
// Operators. For example, to limit results to a specific domain, use the site: operator.
// acceptLanguage - a comma-delimited list of one or more languages to use for user interface strings. The list
// is in decreasing order of preference. For additional information, including expected format, see
// [RFC2616](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html). This header and the setLang query
// parameter are mutually exclusive; do not specify both. If you set this header, you must also specify the cc
// query parameter. Bing will use the first supported language it finds from the list, and combine that
// language with the cc parameter value to determine the market to return results for. If the list does not
// include a supported language, Bing will find the closest language and market that supports the request, and
// may use an aggregated or default market for the results instead of a specified one. You should use this
// header and the cc query parameter only if you specify multiple languages; otherwise, you should use the mkt
// and setLang query parameters. A user interface string is a string that's used as a label in a user
// interface. There are very few user interface strings in the JSON response objects. Any links in the response
// objects to Bing.com properties will apply the specified language.
// pragma - by default, Bing returns cached content, if available. To prevent Bing from returning cached
// content, set the Pragma header to no-cache (for example, Pragma: no-cache).
// userAgent - the user agent originating the request. Bing uses the user agent to provide mobile users with an
// optimized experience. Although optional, you are strongly encouraged to always specify this header. The
// user-agent should be the same string that any commonly used browser would send. For information about user
// agents, see [RFC 2616](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
// clientID - bing uses this header to provide users with consistent behavior across Bing API calls. Bing often
// flights new features and improvements, and it uses the client ID as a key for assigning traffic on different
// flights. If you do not use the same client ID for a user across multiple requests, then Bing may assign the
// user to multiple conflicting flights. Being assigned to multiple conflicting flights can lead to an
// inconsistent user experience. For example, if the second request has a different flight assignment than the
// first, the experience may be unexpected. Also, Bing can use the client ID to tailor web results to that
// client ID’s search history, providing a richer experience for the user. Bing also uses this header to help
// improve result rankings by analyzing the activity generated by a client ID. The relevance improvements help
// with better quality of results delivered by Bing APIs and in turn enables higher click-through rates for the
// API consumer. IMPORTANT: Although optional, you should consider this header required. Persisting the client
// ID across multiple requests for the same end user and device combination enables 1) the API consumer to
// receive a consistent user experience, and 2) higher click-through rates via better quality of results from
// the Bing APIs. Each user that uses your application on the device must have a unique, Bing generated client
// ID. If you do not include this header in the request, Bing generates an ID and returns it in the
// X-MSEdge-ClientID response header. The only time that you should NOT include this header in a request is the
// first time the user uses your app on that device. Use the client ID for each Bing API request that your app
// makes for this user on the device. Persist the client ID. To persist the ID in a browser app, use a
// persistent HTTP cookie to ensure the ID is used across all sessions. Do not use a session cookie. For other
// apps such as mobile apps, use the device's persistent storage to persist the ID. The next time the user uses
// your app on that device, get the client ID that you persisted. Bing responses may or may not include this
// header. If the response includes this header, capture the client ID and use it for all subsequent Bing
// requests for the user on that device. If you include the X-MSEdge-ClientID, you must not include cookies in
// the request.
// clientIP - the IPv4 or IPv6 address of the client device. The IP address is used to discover the user's
// location. Bing uses the location information to determine safe search behavior. Although optional, you are
// encouraged to always specify this header and the X-Search-Location header. Do not obfuscate the address (for
// example, by changing the last octet to 0). Obfuscating the address results in the location not being
// anywhere near the device's actual location, which may result in Bing serving erroneous results.
// location - a semicolon-delimited list of key/value pairs that describe the client's geographical location.
// Bing uses the location information to determine safe search behavior and to return relevant local content.
// Specify the key/value pair as <key>:<value>. The following are the keys that you use to specify the user's
// location. lat (required): The latitude of the client's location, in degrees. The latitude must be greater
// than or equal to -90.0 and less than or equal to +90.0. Negative values indicate southern latitudes and
// positive values indicate northern latitudes. long (required): The longitude of the client's location, in
// degrees. The longitude must be greater than or equal to -180.0 and less than or equal to +180.0. Negative
// values indicate western longitudes and positive values indicate eastern longitudes. re (required): The
// radius, in meters, which specifies the horizontal accuracy of the coordinates. Pass the value returned by
// the device's location service. Typical values might be 22m for GPS/Wi-Fi, 380m for cell tower triangulation,
// and 18,000m for reverse IP lookup. ts (optional): The UTC UNIX timestamp of when the client was at the
// location. (The UNIX timestamp is the number of seconds since January 1, 1970.) head (optional): The client's
// relative heading or direction of travel. Specify the direction of travel as degrees from 0 through 360,
// counting clockwise relative to true north. Specify this key only if the sp key is nonzero. sp (optional):
// The horizontal velocity (speed), in meters per second, that the client device is traveling. alt (optional):
// The altitude of the client device, in meters. are (optional): The radius, in meters, that specifies the
// vertical accuracy of the coordinates. Specify this key only if you specify the alt key. Although many of the
// keys are optional, the more information that you provide, the more accurate the location results are.
// Although optional, you are encouraged to always specify the user's geographical location. Providing the
// location is especially important if the client's IP address does not accurately reflect the user's physical
// location (for example, if the client uses VPN). For optimal results, you should include this header and the
// X-MSEdge-ClientIP header, but at a minimum, you should include this header.
// answerCount - the number of answers that you want the response to include. The answers that Bing returns are
// based on ranking. For example, if Bing returns webpages, images, videos, and relatedSearches for a request
// and you set this parameter to two (2), the response includes webpages and images.If you included the
// responseFilter query parameter in the same request and set it to webpages and news, the response would
// include only webpages.
// countryCode - a 2-character country code of the country where the results come from. This API supports only
// the United States market. If you specify this query parameter, it must be set to us. If you set this
// parameter, you must also specify the Accept-Language header. Bing uses the first supported language it finds
// from the languages list, and combine that language with the country code that you specify to determine the
// market to return results for. If the languages list does not include a supported language, Bing finds the
// closest language and market that supports the request, or it may use an aggregated or default market for the
// results instead of a specified one. You should use this query parameter and the Accept-Language query
// parameter only if you specify multiple languages; otherwise, you should use the mkt and setLang query
// parameters. This parameter and the mkt query parameter are mutually exclusive—do not specify both.
// count - the number of search results to return in the response. The default is 10 and the maximum value is
// 50. The actual number delivered may be less than requested.Use this parameter along with the offset
// parameter to page results.For example, if your user interface displays 10 search results per page, set count
// to 10 and offset to 0 to get the first page of results. For each subsequent page, increment offset by 10
// (for example, 0, 10, 20). It is possible for multiple pages to include some overlap in results.
// freshness - filter search results by the following age values: Day—Return webpages that Bing discovered
// within the last 24 hours. Week—Return webpages that Bing discovered within the last 7 days. Month—Return
// webpages that discovered within the last 30 days. This filter applies only to webpage results and not to the
// other results such as news and images.
// market - the market where the results come from. Typically, mkt is the country where the user is making the
// request from. However, it could be a different country if the user is not located in a country where Bing
// delivers results. The market must be in the form <language code>-<country code>. For example, en-US. The
// string is case insensitive. If known, you are encouraged to always specify the market. Specifying the market
// helps Bing route the request and return an appropriate and optimal response. If you specify a market that is
// not listed in Market Codes, Bing uses a best fit market code based on an internal mapping that is subject to
// change. This parameter and the cc query parameter are mutually exclusive—do not specify both.
// offset - the zero-based offset that indicates the number of search results to skip before returning results.
// The default is 0. The offset should be less than (totalEstimatedMatches - count). Use this parameter along
// with the count parameter to page results. For example, if your user interface displays 10 search results per
// page, set count to 10 and offset to 0 to get the first page of results. For each subsequent page, increment
// offset by 10 (for example, 0, 10, 20). it is possible for multiple pages to include some overlap in results.
// promote - a comma-delimited list of answers that you want the response to include regardless of their
// ranking. For example, if you set answerCount) to two (2) so Bing returns the top two ranked answers, but you
// also want the response to include news, you'd set promote to news. If the top ranked answers are webpages,
// images, videos, and relatedSearches, the response includes webpages and images because news is not a ranked
// answer. But if you set promote to video, Bing would promote the video answer into the response and return
// webpages, images, and videos. The answers that you want to promote do not count against the answerCount
// limit. For example, if the ranked answers are news, images, and videos, and you set answerCount to 1 and
// promote to news, the response contains news and images. Or, if the ranked answers are videos, images, and
// news, the response contains videos and news. Possible values are Computation, Images, News, RelatedSearches,
// SpellSuggestions, TimeZone, Videos, Webpages. Use only if you specify answerCount.
// responseFilter - a comma-delimited list of answers to include in the response. If you do not specify this
// parameter, the response includes all search answers for which there's relevant data. Possible filter values
// are Computation, Images, News, RelatedSearches, SpellSuggestions, TimeZone, Videos, Webpages. Although you
// may use this filter to get a single answer, you should instead use the answer-specific endpoint in order to
// get richer results. For example, to receive only images, send the request to one of the Image Search API
// endpoints. The RelatedSearches and SpellSuggestions answers do not support a separate endpoint like the
// Image Search API does (only the Web Search API returns them). To include answers that would otherwise be
// excluded because of ranking, see the promote query parameter.
// safeSearch - a filter used to filter adult content. Off: Return webpages with adult text, images, or videos.
// Moderate: Return webpages with adult text, but not adult images or videos. Strict: Do not return webpages
// with adult text, images, or videos. The default is Moderate. If the request comes from a market that Bing's
// adult policy requires that safeSearch is set to Strict, Bing ignores the safeSearch value and uses Strict.
// If you use the site: query operator, there is the chance that the response may contain adult content
// regardless of what the safeSearch query parameter is set to. Use site: only if you are aware of the content
// on the site and your scenario supports the possibility of adult content.
// setLang - the language to use for user interface strings. Specify the language using the ISO 639-1 2-letter
// language code. For example, the language code for English is EN. The default is EN (English). Although
// optional, you should always specify the language. Typically, you set setLang to the same language specified
// by mkt unless the user wants the user interface strings displayed in a different language. This parameter
// and the Accept-Language header are mutually exclusive; do not specify both. A user interface string is a
// string that's used as a label in a user interface. There are few user interface strings in the JSON response
// objects. Also, any links to Bing.com properties in the response objects apply the specified language.
// textDecorations - a Boolean value that determines whether display strings should contain decoration markers
// such as hit highlighting characters. If true, the strings may include markers. The default is false. To
// specify whether to use Unicode characters or HTML tags as the markers, see the textFormat query parameter.
// textFormat - the type of markers to use for text decorations (see the textDecorations query parameter).
// Possible values are Raw—Use Unicode characters to mark content that needs special formatting. The Unicode
// characters are in the range E000 through E019. For example, Bing uses E000 and E001 to mark the beginning
// and end of query terms for hit highlighting. HTML—Use HTML tags to mark content that needs special
// formatting. For example, use <b> tags to highlight query terms in display strings. The default is Raw. For
// display strings that contain escapable HTML characters such as <, >, and &, if textFormat is set to HTML,
// Bing escapes the characters as appropriate (for example, < is escaped to &lt;).
func (client WebClient) Search(ctx context.Context, query string, acceptLanguage string, pragma string, userAgent string, clientID string, clientIP string, location string, answerCount *int32, countryCode string, count *int32, freshness Freshness, market string, offset *int32, promote []AnswerType, responseFilter []AnswerType, safeSearch SafeSearch, setLang string, textDecorations *bool, textFormat TextFormat) (result SearchResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebClient.Search")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SearchPreparer(ctx, query, acceptLanguage, pragma, userAgent, clientID, clientIP, location, answerCount, countryCode, count, freshness, market, offset, promote, responseFilter, safeSearch, setLang, textDecorations, textFormat)
	if err != nil {
		err = autorest.NewErrorWithError(err, "websearch.WebClient", "Search", nil, "Failure preparing request")
		return
	}

	resp, err := client.SearchSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "websearch.WebClient", "Search", resp, "Failure sending request")
		return
	}

	result, err = client.SearchResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "websearch.WebClient", "Search", resp, "Failure responding to request")
	}

	return
}

// SearchPreparer prepares the Search request.
func (client WebClient) SearchPreparer(ctx context.Context, query string, acceptLanguage string, pragma string, userAgent string, clientID string, clientIP string, location string, answerCount *int32, countryCode string, count *int32, freshness Freshness, market string, offset *int32, promote []AnswerType, responseFilter []AnswerType, safeSearch SafeSearch, setLang string, textDecorations *bool, textFormat TextFormat) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"q": autorest.Encode("query", query),
	}
	if answerCount != nil {
		queryParameters["answerCount"] = autorest.Encode("query", *answerCount)
	}
	if len(countryCode) > 0 {
		queryParameters["cc"] = autorest.Encode("query", countryCode)
	}
	if count != nil {
		queryParameters["count"] = autorest.Encode("query", *count)
	}
	if len(string(freshness)) > 0 {
		queryParameters["freshness"] = autorest.Encode("query", freshness)
	}
	if len(market) > 0 {
		queryParameters["mkt"] = autorest.Encode("query", market)
	} else {
		queryParameters["mkt"] = autorest.Encode("query", "en-us")
	}
	if offset != nil {
		queryParameters["offset"] = autorest.Encode("query", *offset)
	}
	if promote != nil && len(promote) > 0 {
		queryParameters["promote"] = autorest.Encode("query", promote, ",")
	}
	if responseFilter != nil && len(responseFilter) > 0 {
		queryParameters["responseFilter"] = autorest.Encode("query", responseFilter, ",")
	}
	if len(string(safeSearch)) > 0 {
		queryParameters["safeSearch"] = autorest.Encode("query", safeSearch)
	}
	if len(setLang) > 0 {
		queryParameters["setLang"] = autorest.Encode("query", setLang)
	}
	if textDecorations != nil {
		queryParameters["textDecorations"] = autorest.Encode("query", *textDecorations)
	}
	if len(string(textFormat)) > 0 {
		queryParameters["textFormat"] = autorest.Encode("query", textFormat)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/bing/v7.0", urlParameters),
		autorest.WithPath("/search"),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("X-BingApis-SDK", "true"))
	if len(acceptLanguage) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Accept-Language", autorest.String(acceptLanguage)))
	}
	if len(pragma) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Pragma", autorest.String(pragma)))
	}
	if len(userAgent) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("User-Agent", autorest.String(userAgent)))
	}
	if len(clientID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-MSEdge-ClientID", autorest.String(clientID)))
	}
	if len(clientIP) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-MSEdge-ClientIP", autorest.String(clientIP)))
	}
	if len(location) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Search-Location", autorest.String(location)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SearchSender sends the Search request. The method will close the
// http.Response Body if it receives an error.
func (client WebClient) SearchSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// SearchResponder handles the response to the Search request. The method always
// closes the http.Response Body.
func (client WebClient) SearchResponder(resp *http.Response) (result SearchResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
