// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package sql

import original "github.com/Azure/azure-sdk-for-go/services/sql/mgmt/2014-04-01/sql"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AdvisorStatus = original.AdvisorStatus

const (
	GA                   AdvisorStatus = original.GA
	LimitedPublicPreview AdvisorStatus = original.LimitedPublicPreview
	PrivatePreview       AdvisorStatus = original.PrivatePreview
	PublicPreview        AdvisorStatus = original.PublicPreview
)

type AuthenticationType = original.AuthenticationType

const (
	ADPassword AuthenticationType = original.ADPassword
	SQL        AuthenticationType = original.SQL
)

type AutoExecuteStatus = original.AutoExecuteStatus

const (
	Default  AutoExecuteStatus = original.Default
	Disabled AutoExecuteStatus = original.Disabled
	Enabled  AutoExecuteStatus = original.Enabled
)

type BackupLongTermRetentionPolicyState = original.BackupLongTermRetentionPolicyState

const (
	BackupLongTermRetentionPolicyStateDisabled BackupLongTermRetentionPolicyState = original.BackupLongTermRetentionPolicyStateDisabled
	BackupLongTermRetentionPolicyStateEnabled  BackupLongTermRetentionPolicyState = original.BackupLongTermRetentionPolicyStateEnabled
)

type CapabilityStatus = original.CapabilityStatus

const (
	CapabilityStatusAvailable CapabilityStatus = original.CapabilityStatusAvailable
	CapabilityStatusDefault   CapabilityStatus = original.CapabilityStatusDefault
	CapabilityStatusDisabled  CapabilityStatus = original.CapabilityStatusDisabled
	CapabilityStatusVisible   CapabilityStatus = original.CapabilityStatusVisible
)

type CheckNameAvailabilityReason = original.CheckNameAvailabilityReason

const (
	AlreadyExists CheckNameAvailabilityReason = original.AlreadyExists
	Invalid       CheckNameAvailabilityReason = original.Invalid
)

type CreateMode = original.CreateMode

const (
	CreateModeCopy                           CreateMode = original.CreateModeCopy
	CreateModeDefault                        CreateMode = original.CreateModeDefault
	CreateModeNonReadableSecondary           CreateMode = original.CreateModeNonReadableSecondary
	CreateModeOnlineSecondary                CreateMode = original.CreateModeOnlineSecondary
	CreateModePointInTimeRestore             CreateMode = original.CreateModePointInTimeRestore
	CreateModeRecovery                       CreateMode = original.CreateModeRecovery
	CreateModeRestore                        CreateMode = original.CreateModeRestore
	CreateModeRestoreLongTermRetentionBackup CreateMode = original.CreateModeRestoreLongTermRetentionBackup
)

type DataMaskingFunction = original.DataMaskingFunction

const (
	DataMaskingFunctionCCN     DataMaskingFunction = original.DataMaskingFunctionCCN
	DataMaskingFunctionDefault DataMaskingFunction = original.DataMaskingFunctionDefault
	DataMaskingFunctionEmail   DataMaskingFunction = original.DataMaskingFunctionEmail
	DataMaskingFunctionNumber  DataMaskingFunction = original.DataMaskingFunctionNumber
	DataMaskingFunctionSSN     DataMaskingFunction = original.DataMaskingFunctionSSN
	DataMaskingFunctionText    DataMaskingFunction = original.DataMaskingFunctionText
)

type DataMaskingRuleState = original.DataMaskingRuleState

const (
	DataMaskingRuleStateDisabled DataMaskingRuleState = original.DataMaskingRuleStateDisabled
	DataMaskingRuleStateEnabled  DataMaskingRuleState = original.DataMaskingRuleStateEnabled
)

type DataMaskingState = original.DataMaskingState

const (
	DataMaskingStateDisabled DataMaskingState = original.DataMaskingStateDisabled
	DataMaskingStateEnabled  DataMaskingState = original.DataMaskingStateEnabled
)

type DatabaseEdition = original.DatabaseEdition

const (
	Basic            DatabaseEdition = original.Basic
	Business         DatabaseEdition = original.Business
	BusinessCritical DatabaseEdition = original.BusinessCritical
	DataWarehouse    DatabaseEdition = original.DataWarehouse
	Free             DatabaseEdition = original.Free
	GeneralPurpose   DatabaseEdition = original.GeneralPurpose
	Hyperscale       DatabaseEdition = original.Hyperscale
	Premium          DatabaseEdition = original.Premium
	PremiumRS        DatabaseEdition = original.PremiumRS
	Standard         DatabaseEdition = original.Standard
	Stretch          DatabaseEdition = original.Stretch
	System           DatabaseEdition = original.System
	System2          DatabaseEdition = original.System2
	Web              DatabaseEdition = original.Web
)

type DisasterRecoveryConfigurationAutoFailover = original.DisasterRecoveryConfigurationAutoFailover

const (
	Off DisasterRecoveryConfigurationAutoFailover = original.Off
	On  DisasterRecoveryConfigurationAutoFailover = original.On
)

type DisasterRecoveryConfigurationFailoverPolicy = original.DisasterRecoveryConfigurationFailoverPolicy

const (
	Automatic DisasterRecoveryConfigurationFailoverPolicy = original.Automatic
	Manual    DisasterRecoveryConfigurationFailoverPolicy = original.Manual
)

type DisasterRecoveryConfigurationRole = original.DisasterRecoveryConfigurationRole

const (
	None      DisasterRecoveryConfigurationRole = original.None
	Primary   DisasterRecoveryConfigurationRole = original.Primary
	Secondary DisasterRecoveryConfigurationRole = original.Secondary
)

type DisasterRecoveryConfigurationStatus = original.DisasterRecoveryConfigurationStatus

const (
	Creating    DisasterRecoveryConfigurationStatus = original.Creating
	Dropping    DisasterRecoveryConfigurationStatus = original.Dropping
	FailingOver DisasterRecoveryConfigurationStatus = original.FailingOver
	Ready       DisasterRecoveryConfigurationStatus = original.Ready
)

type ElasticPoolEdition = original.ElasticPoolEdition

const (
	ElasticPoolEditionBasic            ElasticPoolEdition = original.ElasticPoolEditionBasic
	ElasticPoolEditionBusinessCritical ElasticPoolEdition = original.ElasticPoolEditionBusinessCritical
	ElasticPoolEditionGeneralPurpose   ElasticPoolEdition = original.ElasticPoolEditionGeneralPurpose
	ElasticPoolEditionPremium          ElasticPoolEdition = original.ElasticPoolEditionPremium
	ElasticPoolEditionStandard         ElasticPoolEdition = original.ElasticPoolEditionStandard
)

type ElasticPoolState = original.ElasticPoolState

const (
	ElasticPoolStateCreating ElasticPoolState = original.ElasticPoolStateCreating
	ElasticPoolStateDisabled ElasticPoolState = original.ElasticPoolStateDisabled
	ElasticPoolStateReady    ElasticPoolState = original.ElasticPoolStateReady
)

type GeoBackupPolicyState = original.GeoBackupPolicyState

const (
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = original.GeoBackupPolicyStateDisabled
	GeoBackupPolicyStateEnabled  GeoBackupPolicyState = original.GeoBackupPolicyStateEnabled
)

type MaxSizeUnits = original.MaxSizeUnits

const (
	Gigabytes MaxSizeUnits = original.Gigabytes
	Megabytes MaxSizeUnits = original.Megabytes
	Petabytes MaxSizeUnits = original.Petabytes
	Terabytes MaxSizeUnits = original.Terabytes
)

type PerformanceLevelUnit = original.PerformanceLevelUnit

const (
	DTU PerformanceLevelUnit = original.DTU
)

type PrimaryAggregationType = original.PrimaryAggregationType

const (
	PrimaryAggregationTypeAverage PrimaryAggregationType = original.PrimaryAggregationTypeAverage
	PrimaryAggregationTypeCount   PrimaryAggregationType = original.PrimaryAggregationTypeCount
	PrimaryAggregationTypeMaximum PrimaryAggregationType = original.PrimaryAggregationTypeMaximum
	PrimaryAggregationTypeMinimum PrimaryAggregationType = original.PrimaryAggregationTypeMinimum
	PrimaryAggregationTypeNone    PrimaryAggregationType = original.PrimaryAggregationTypeNone
	PrimaryAggregationTypeTotal   PrimaryAggregationType = original.PrimaryAggregationTypeTotal
)

type QueryAggregationFunction = original.QueryAggregationFunction

const (
	Avg QueryAggregationFunction = original.Avg
	Max QueryAggregationFunction = original.Max
	Min QueryAggregationFunction = original.Min
	Sum QueryAggregationFunction = original.Sum
)

type QueryExecutionType = original.QueryExecutionType

const (
	Aborted   QueryExecutionType = original.Aborted
	Any       QueryExecutionType = original.Any
	Exception QueryExecutionType = original.Exception
	Irregular QueryExecutionType = original.Irregular
	Regular   QueryExecutionType = original.Regular
)

type QueryMetricUnit = original.QueryMetricUnit

const (
	KB           QueryMetricUnit = original.KB
	Microseconds QueryMetricUnit = original.Microseconds
	Percentage   QueryMetricUnit = original.Percentage
)

type QueryObservedMetricType = original.QueryObservedMetricType

const (
	CPU            QueryObservedMetricType = original.CPU
	Duration       QueryObservedMetricType = original.Duration
	ExecutionCount QueryObservedMetricType = original.ExecutionCount
	Io             QueryObservedMetricType = original.Io
	Logio          QueryObservedMetricType = original.Logio
)

type ReadScale = original.ReadScale

const (
	ReadScaleDisabled ReadScale = original.ReadScaleDisabled
	ReadScaleEnabled  ReadScale = original.ReadScaleEnabled
)

type RecommendedIndexAction = original.RecommendedIndexAction

const (
	Create  RecommendedIndexAction = original.Create
	Drop    RecommendedIndexAction = original.Drop
	Rebuild RecommendedIndexAction = original.Rebuild
)

type RecommendedIndexState = original.RecommendedIndexState

const (
	Active        RecommendedIndexState = original.Active
	Blocked       RecommendedIndexState = original.Blocked
	Executing     RecommendedIndexState = original.Executing
	Expired       RecommendedIndexState = original.Expired
	Ignored       RecommendedIndexState = original.Ignored
	Pending       RecommendedIndexState = original.Pending
	PendingRevert RecommendedIndexState = original.PendingRevert
	Reverted      RecommendedIndexState = original.Reverted
	Reverting     RecommendedIndexState = original.Reverting
	Success       RecommendedIndexState = original.Success
	Verifying     RecommendedIndexState = original.Verifying
)

type RecommendedIndexType = original.RecommendedIndexType

const (
	CLUSTERED            RecommendedIndexType = original.CLUSTERED
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = original.CLUSTEREDCOLUMNSTORE
	COLUMNSTORE          RecommendedIndexType = original.COLUMNSTORE
	NONCLUSTERED         RecommendedIndexType = original.NONCLUSTERED
)

type ReplicationRole = original.ReplicationRole

const (
	ReplicationRoleCopy                 ReplicationRole = original.ReplicationRoleCopy
	ReplicationRoleNonReadableSecondary ReplicationRole = original.ReplicationRoleNonReadableSecondary
	ReplicationRolePrimary              ReplicationRole = original.ReplicationRolePrimary
	ReplicationRoleSecondary            ReplicationRole = original.ReplicationRoleSecondary
	ReplicationRoleSource               ReplicationRole = original.ReplicationRoleSource
)

type ReplicationState = original.ReplicationState

const (
	CATCHUP   ReplicationState = original.CATCHUP
	PENDING   ReplicationState = original.PENDING
	SEEDING   ReplicationState = original.SEEDING
	SUSPENDED ReplicationState = original.SUSPENDED
)

type RestorePointType = original.RestorePointType

const (
	CONTINUOUS RestorePointType = original.CONTINUOUS
	DISCRETE   RestorePointType = original.DISCRETE
)

type SampleName = original.SampleName

const (
	AdventureWorksLT SampleName = original.AdventureWorksLT
)

type SecurityAlertPolicyEmailAccountAdmins = original.SecurityAlertPolicyEmailAccountAdmins

const (
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = original.SecurityAlertPolicyEmailAccountAdminsDisabled
	SecurityAlertPolicyEmailAccountAdminsEnabled  SecurityAlertPolicyEmailAccountAdmins = original.SecurityAlertPolicyEmailAccountAdminsEnabled
)

type SecurityAlertPolicyState = original.SecurityAlertPolicyState

const (
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = original.SecurityAlertPolicyStateDisabled
	SecurityAlertPolicyStateEnabled  SecurityAlertPolicyState = original.SecurityAlertPolicyStateEnabled
	SecurityAlertPolicyStateNew      SecurityAlertPolicyState = original.SecurityAlertPolicyStateNew
)

type SecurityAlertPolicyUseServerDefault = original.SecurityAlertPolicyUseServerDefault

const (
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = original.SecurityAlertPolicyUseServerDefaultDisabled
	SecurityAlertPolicyUseServerDefaultEnabled  SecurityAlertPolicyUseServerDefault = original.SecurityAlertPolicyUseServerDefaultEnabled
)

type ServerConnectionType = original.ServerConnectionType

const (
	ServerConnectionTypeDefault  ServerConnectionType = original.ServerConnectionTypeDefault
	ServerConnectionTypeProxy    ServerConnectionType = original.ServerConnectionTypeProxy
	ServerConnectionTypeRedirect ServerConnectionType = original.ServerConnectionTypeRedirect
)

type ServerState = original.ServerState

const (
	ServerStateDisabled ServerState = original.ServerStateDisabled
	ServerStateReady    ServerState = original.ServerStateReady
)

type ServerVersion = original.ServerVersion

const (
	OneTwoFullStopZero ServerVersion = original.OneTwoFullStopZero
	TwoFullStopZero    ServerVersion = original.TwoFullStopZero
)

type ServiceObjectiveName = original.ServiceObjectiveName

const (
	ServiceObjectiveNameBasic       ServiceObjectiveName = original.ServiceObjectiveNameBasic
	ServiceObjectiveNameDS100       ServiceObjectiveName = original.ServiceObjectiveNameDS100
	ServiceObjectiveNameDS1000      ServiceObjectiveName = original.ServiceObjectiveNameDS1000
	ServiceObjectiveNameDS1200      ServiceObjectiveName = original.ServiceObjectiveNameDS1200
	ServiceObjectiveNameDS1500      ServiceObjectiveName = original.ServiceObjectiveNameDS1500
	ServiceObjectiveNameDS200       ServiceObjectiveName = original.ServiceObjectiveNameDS200
	ServiceObjectiveNameDS2000      ServiceObjectiveName = original.ServiceObjectiveNameDS2000
	ServiceObjectiveNameDS300       ServiceObjectiveName = original.ServiceObjectiveNameDS300
	ServiceObjectiveNameDS400       ServiceObjectiveName = original.ServiceObjectiveNameDS400
	ServiceObjectiveNameDS500       ServiceObjectiveName = original.ServiceObjectiveNameDS500
	ServiceObjectiveNameDS600       ServiceObjectiveName = original.ServiceObjectiveNameDS600
	ServiceObjectiveNameDW100       ServiceObjectiveName = original.ServiceObjectiveNameDW100
	ServiceObjectiveNameDW1000      ServiceObjectiveName = original.ServiceObjectiveNameDW1000
	ServiceObjectiveNameDW10000c    ServiceObjectiveName = original.ServiceObjectiveNameDW10000c
	ServiceObjectiveNameDW1000c     ServiceObjectiveName = original.ServiceObjectiveNameDW1000c
	ServiceObjectiveNameDW1200      ServiceObjectiveName = original.ServiceObjectiveNameDW1200
	ServiceObjectiveNameDW1500      ServiceObjectiveName = original.ServiceObjectiveNameDW1500
	ServiceObjectiveNameDW15000c    ServiceObjectiveName = original.ServiceObjectiveNameDW15000c
	ServiceObjectiveNameDW1500c     ServiceObjectiveName = original.ServiceObjectiveNameDW1500c
	ServiceObjectiveNameDW200       ServiceObjectiveName = original.ServiceObjectiveNameDW200
	ServiceObjectiveNameDW2000      ServiceObjectiveName = original.ServiceObjectiveNameDW2000
	ServiceObjectiveNameDW2000c     ServiceObjectiveName = original.ServiceObjectiveNameDW2000c
	ServiceObjectiveNameDW2500c     ServiceObjectiveName = original.ServiceObjectiveNameDW2500c
	ServiceObjectiveNameDW300       ServiceObjectiveName = original.ServiceObjectiveNameDW300
	ServiceObjectiveNameDW3000      ServiceObjectiveName = original.ServiceObjectiveNameDW3000
	ServiceObjectiveNameDW30000c    ServiceObjectiveName = original.ServiceObjectiveNameDW30000c
	ServiceObjectiveNameDW3000c     ServiceObjectiveName = original.ServiceObjectiveNameDW3000c
	ServiceObjectiveNameDW400       ServiceObjectiveName = original.ServiceObjectiveNameDW400
	ServiceObjectiveNameDW500       ServiceObjectiveName = original.ServiceObjectiveNameDW500
	ServiceObjectiveNameDW5000c     ServiceObjectiveName = original.ServiceObjectiveNameDW5000c
	ServiceObjectiveNameDW600       ServiceObjectiveName = original.ServiceObjectiveNameDW600
	ServiceObjectiveNameDW6000      ServiceObjectiveName = original.ServiceObjectiveNameDW6000
	ServiceObjectiveNameDW6000c     ServiceObjectiveName = original.ServiceObjectiveNameDW6000c
	ServiceObjectiveNameDW7500c     ServiceObjectiveName = original.ServiceObjectiveNameDW7500c
	ServiceObjectiveNameElasticPool ServiceObjectiveName = original.ServiceObjectiveNameElasticPool
	ServiceObjectiveNameFree        ServiceObjectiveName = original.ServiceObjectiveNameFree
	ServiceObjectiveNameP1          ServiceObjectiveName = original.ServiceObjectiveNameP1
	ServiceObjectiveNameP11         ServiceObjectiveName = original.ServiceObjectiveNameP11
	ServiceObjectiveNameP15         ServiceObjectiveName = original.ServiceObjectiveNameP15
	ServiceObjectiveNameP2          ServiceObjectiveName = original.ServiceObjectiveNameP2
	ServiceObjectiveNameP3          ServiceObjectiveName = original.ServiceObjectiveNameP3
	ServiceObjectiveNameP4          ServiceObjectiveName = original.ServiceObjectiveNameP4
	ServiceObjectiveNameP6          ServiceObjectiveName = original.ServiceObjectiveNameP6
	ServiceObjectiveNamePRS1        ServiceObjectiveName = original.ServiceObjectiveNamePRS1
	ServiceObjectiveNamePRS2        ServiceObjectiveName = original.ServiceObjectiveNamePRS2
	ServiceObjectiveNamePRS4        ServiceObjectiveName = original.ServiceObjectiveNamePRS4
	ServiceObjectiveNamePRS6        ServiceObjectiveName = original.ServiceObjectiveNamePRS6
	ServiceObjectiveNameS0          ServiceObjectiveName = original.ServiceObjectiveNameS0
	ServiceObjectiveNameS1          ServiceObjectiveName = original.ServiceObjectiveNameS1
	ServiceObjectiveNameS12         ServiceObjectiveName = original.ServiceObjectiveNameS12
	ServiceObjectiveNameS2          ServiceObjectiveName = original.ServiceObjectiveNameS2
	ServiceObjectiveNameS3          ServiceObjectiveName = original.ServiceObjectiveNameS3
	ServiceObjectiveNameS4          ServiceObjectiveName = original.ServiceObjectiveNameS4
	ServiceObjectiveNameS6          ServiceObjectiveName = original.ServiceObjectiveNameS6
	ServiceObjectiveNameS7          ServiceObjectiveName = original.ServiceObjectiveNameS7
	ServiceObjectiveNameS9          ServiceObjectiveName = original.ServiceObjectiveNameS9
	ServiceObjectiveNameSystem      ServiceObjectiveName = original.ServiceObjectiveNameSystem
	ServiceObjectiveNameSystem0     ServiceObjectiveName = original.ServiceObjectiveNameSystem0
	ServiceObjectiveNameSystem1     ServiceObjectiveName = original.ServiceObjectiveNameSystem1
	ServiceObjectiveNameSystem2     ServiceObjectiveName = original.ServiceObjectiveNameSystem2
	ServiceObjectiveNameSystem2L    ServiceObjectiveName = original.ServiceObjectiveNameSystem2L
	ServiceObjectiveNameSystem3     ServiceObjectiveName = original.ServiceObjectiveNameSystem3
	ServiceObjectiveNameSystem3L    ServiceObjectiveName = original.ServiceObjectiveNameSystem3L
	ServiceObjectiveNameSystem4     ServiceObjectiveName = original.ServiceObjectiveNameSystem4
	ServiceObjectiveNameSystem4L    ServiceObjectiveName = original.ServiceObjectiveNameSystem4L
)

type StorageKeyType = original.StorageKeyType

const (
	SharedAccessKey  StorageKeyType = original.SharedAccessKey
	StorageAccessKey StorageKeyType = original.StorageAccessKey
)

type TransparentDataEncryptionActivityStatus = original.TransparentDataEncryptionActivityStatus

const (
	Decrypting TransparentDataEncryptionActivityStatus = original.Decrypting
	Encrypting TransparentDataEncryptionActivityStatus = original.Encrypting
)

type TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatus

const (
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusDisabled
	TransparentDataEncryptionStatusEnabled  TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusEnabled
)

type UnitDefinitionType = original.UnitDefinitionType

const (
	Bytes          UnitDefinitionType = original.Bytes
	BytesPerSecond UnitDefinitionType = original.BytesPerSecond
	Count          UnitDefinitionType = original.Count
	CountPerSecond UnitDefinitionType = original.CountPerSecond
	Percent        UnitDefinitionType = original.Percent
	Seconds        UnitDefinitionType = original.Seconds
)

type UnitType = original.UnitType

const (
	UnitTypeBytes          UnitType = original.UnitTypeBytes
	UnitTypeBytesPerSecond UnitType = original.UnitTypeBytesPerSecond
	UnitTypeCount          UnitType = original.UnitTypeCount
	UnitTypeCountPerSecond UnitType = original.UnitTypeCountPerSecond
	UnitTypePercent        UnitType = original.UnitTypePercent
	UnitTypeSeconds        UnitType = original.UnitTypeSeconds
)

type Advisor = original.Advisor
type AdvisorListResult = original.AdvisorListResult
type AdvisorProperties = original.AdvisorProperties
type BackupLongTermRetentionPoliciesClient = original.BackupLongTermRetentionPoliciesClient
type BackupLongTermRetentionPoliciesCreateOrUpdateFuture = original.BackupLongTermRetentionPoliciesCreateOrUpdateFuture
type BackupLongTermRetentionPolicy = original.BackupLongTermRetentionPolicy
type BackupLongTermRetentionPolicyListResult = original.BackupLongTermRetentionPolicyListResult
type BackupLongTermRetentionPolicyProperties = original.BackupLongTermRetentionPolicyProperties
type BackupLongTermRetentionVault = original.BackupLongTermRetentionVault
type BackupLongTermRetentionVaultListResult = original.BackupLongTermRetentionVaultListResult
type BackupLongTermRetentionVaultProperties = original.BackupLongTermRetentionVaultProperties
type BackupLongTermRetentionVaultsClient = original.BackupLongTermRetentionVaultsClient
type BackupLongTermRetentionVaultsCreateOrUpdateFuture = original.BackupLongTermRetentionVaultsCreateOrUpdateFuture
type BaseClient = original.BaseClient
type CapabilitiesClient = original.CapabilitiesClient
type CheckNameAvailabilityRequest = original.CheckNameAvailabilityRequest
type CheckNameAvailabilityResponse = original.CheckNameAvailabilityResponse
type DataMaskingPoliciesClient = original.DataMaskingPoliciesClient
type DataMaskingPolicy = original.DataMaskingPolicy
type DataMaskingPolicyProperties = original.DataMaskingPolicyProperties
type DataMaskingRule = original.DataMaskingRule
type DataMaskingRuleListResult = original.DataMaskingRuleListResult
type DataMaskingRuleProperties = original.DataMaskingRuleProperties
type DataMaskingRulesClient = original.DataMaskingRulesClient
type Database = original.Database
type DatabaseAdvisorsClient = original.DatabaseAdvisorsClient
type DatabaseConnectionPoliciesClient = original.DatabaseConnectionPoliciesClient
type DatabaseConnectionPolicy = original.DatabaseConnectionPolicy
type DatabaseConnectionPolicyProperties = original.DatabaseConnectionPolicyProperties
type DatabaseListResult = original.DatabaseListResult
type DatabaseProperties = original.DatabaseProperties
type DatabaseSecurityAlertPolicy = original.DatabaseSecurityAlertPolicy
type DatabaseSecurityAlertPolicyProperties = original.DatabaseSecurityAlertPolicyProperties
type DatabaseTableAuditingPoliciesClient = original.DatabaseTableAuditingPoliciesClient
type DatabaseTableAuditingPolicy = original.DatabaseTableAuditingPolicy
type DatabaseTableAuditingPolicyListResult = original.DatabaseTableAuditingPolicyListResult
type DatabaseTableAuditingPolicyProperties = original.DatabaseTableAuditingPolicyProperties
type DatabaseThreatDetectionPoliciesClient = original.DatabaseThreatDetectionPoliciesClient
type DatabaseUpdate = original.DatabaseUpdate
type DatabaseUsage = original.DatabaseUsage
type DatabaseUsageListResult = original.DatabaseUsageListResult
type DatabaseUsagesClient = original.DatabaseUsagesClient
type DatabasesClient = original.DatabasesClient
type DatabasesCreateImportOperationFuture = original.DatabasesCreateImportOperationFuture
type DatabasesCreateOrUpdateFuture = original.DatabasesCreateOrUpdateFuture
type DatabasesExportFuture = original.DatabasesExportFuture
type DatabasesImportFuture = original.DatabasesImportFuture
type DatabasesPauseFuture = original.DatabasesPauseFuture
type DatabasesResumeFuture = original.DatabasesResumeFuture
type DatabasesUpdateFuture = original.DatabasesUpdateFuture
type DisasterRecoveryConfiguration = original.DisasterRecoveryConfiguration
type DisasterRecoveryConfigurationListResult = original.DisasterRecoveryConfigurationListResult
type DisasterRecoveryConfigurationProperties = original.DisasterRecoveryConfigurationProperties
type DisasterRecoveryConfigurationsClient = original.DisasterRecoveryConfigurationsClient
type DisasterRecoveryConfigurationsCreateOrUpdateFuture = original.DisasterRecoveryConfigurationsCreateOrUpdateFuture
type DisasterRecoveryConfigurationsDeleteFuture = original.DisasterRecoveryConfigurationsDeleteFuture
type DisasterRecoveryConfigurationsFailoverAllowDataLossFuture = original.DisasterRecoveryConfigurationsFailoverAllowDataLossFuture
type DisasterRecoveryConfigurationsFailoverFuture = original.DisasterRecoveryConfigurationsFailoverFuture
type EditionCapability = original.EditionCapability
type ElasticPool = original.ElasticPool
type ElasticPoolActivitiesClient = original.ElasticPoolActivitiesClient
type ElasticPoolActivity = original.ElasticPoolActivity
type ElasticPoolActivityListResult = original.ElasticPoolActivityListResult
type ElasticPoolActivityProperties = original.ElasticPoolActivityProperties
type ElasticPoolDatabaseActivitiesClient = original.ElasticPoolDatabaseActivitiesClient
type ElasticPoolDatabaseActivity = original.ElasticPoolDatabaseActivity
type ElasticPoolDatabaseActivityListResult = original.ElasticPoolDatabaseActivityListResult
type ElasticPoolDatabaseActivityProperties = original.ElasticPoolDatabaseActivityProperties
type ElasticPoolDtuCapability = original.ElasticPoolDtuCapability
type ElasticPoolEditionCapability = original.ElasticPoolEditionCapability
type ElasticPoolListResult = original.ElasticPoolListResult
type ElasticPoolPerDatabaseMaxDtuCapability = original.ElasticPoolPerDatabaseMaxDtuCapability
type ElasticPoolPerDatabaseMinDtuCapability = original.ElasticPoolPerDatabaseMinDtuCapability
type ElasticPoolProperties = original.ElasticPoolProperties
type ElasticPoolUpdate = original.ElasticPoolUpdate
type ElasticPoolsClient = original.ElasticPoolsClient
type ElasticPoolsCreateOrUpdateFuture = original.ElasticPoolsCreateOrUpdateFuture
type ElasticPoolsUpdateFuture = original.ElasticPoolsUpdateFuture
type ExportRequest = original.ExportRequest
type ExtensionListResult = original.ExtensionListResult
type ExtensionsClient = original.ExtensionsClient
type FirewallRule = original.FirewallRule
type FirewallRuleListResult = original.FirewallRuleListResult
type FirewallRuleProperties = original.FirewallRuleProperties
type FirewallRulesClient = original.FirewallRulesClient
type GeoBackupPoliciesClient = original.GeoBackupPoliciesClient
type GeoBackupPolicy = original.GeoBackupPolicy
type GeoBackupPolicyListResult = original.GeoBackupPolicyListResult
type GeoBackupPolicyProperties = original.GeoBackupPolicyProperties
type ImportExportResponse = original.ImportExportResponse
type ImportExportResponseProperties = original.ImportExportResponseProperties
type ImportExtensionProperties = original.ImportExtensionProperties
type ImportExtensionRequest = original.ImportExtensionRequest
type ImportRequest = original.ImportRequest
type LocationCapabilities = original.LocationCapabilities
type MaxSizeCapability = original.MaxSizeCapability
type Metric = original.Metric
type MetricAvailability = original.MetricAvailability
type MetricDefinition = original.MetricDefinition
type MetricDefinitionListResult = original.MetricDefinitionListResult
type MetricListResult = original.MetricListResult
type MetricName = original.MetricName
type MetricValue = original.MetricValue
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationImpact = original.OperationImpact
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type PerformanceLevel = original.PerformanceLevel
type ProxyResource = original.ProxyResource
type QueriesClient = original.QueriesClient
type QueryInterval = original.QueryInterval
type QueryMetric = original.QueryMetric
type QueryStatistic = original.QueryStatistic
type QueryStatisticListResult = original.QueryStatisticListResult
type QueryStatisticsClient = original.QueryStatisticsClient
type QueryText = original.QueryText
type QueryTextListResult = original.QueryTextListResult
type QueryTextsClient = original.QueryTextsClient
type RecommendedElasticPool = original.RecommendedElasticPool
type RecommendedElasticPoolListMetricsResult = original.RecommendedElasticPoolListMetricsResult
type RecommendedElasticPoolListResult = original.RecommendedElasticPoolListResult
type RecommendedElasticPoolMetric = original.RecommendedElasticPoolMetric
type RecommendedElasticPoolProperties = original.RecommendedElasticPoolProperties
type RecommendedElasticPoolsClient = original.RecommendedElasticPoolsClient
type RecommendedIndex = original.RecommendedIndex
type RecommendedIndexProperties = original.RecommendedIndexProperties
type RecoverableDatabase = original.RecoverableDatabase
type RecoverableDatabaseListResult = original.RecoverableDatabaseListResult
type RecoverableDatabaseProperties = original.RecoverableDatabaseProperties
type RecoverableDatabasesClient = original.RecoverableDatabasesClient
type ReplicationLink = original.ReplicationLink
type ReplicationLinkListResult = original.ReplicationLinkListResult
type ReplicationLinkProperties = original.ReplicationLinkProperties
type ReplicationLinksClient = original.ReplicationLinksClient
type ReplicationLinksFailoverAllowDataLossFuture = original.ReplicationLinksFailoverAllowDataLossFuture
type ReplicationLinksFailoverFuture = original.ReplicationLinksFailoverFuture
type Resource = original.Resource
type RestorableDroppedDatabase = original.RestorableDroppedDatabase
type RestorableDroppedDatabaseListResult = original.RestorableDroppedDatabaseListResult
type RestorableDroppedDatabaseProperties = original.RestorableDroppedDatabaseProperties
type RestorableDroppedDatabasesClient = original.RestorableDroppedDatabasesClient
type RestorePoint = original.RestorePoint
type RestorePointListResult = original.RestorePointListResult
type RestorePointProperties = original.RestorePointProperties
type RestorePointsClient = original.RestorePointsClient
type Server = original.Server
type ServerAdministratorListResult = original.ServerAdministratorListResult
type ServerAdministratorProperties = original.ServerAdministratorProperties
type ServerAdvisorsClient = original.ServerAdvisorsClient
type ServerAzureADAdministrator = original.ServerAzureADAdministrator
type ServerAzureADAdministratorsClient = original.ServerAzureADAdministratorsClient
type ServerAzureADAdministratorsCreateOrUpdateFuture = original.ServerAzureADAdministratorsCreateOrUpdateFuture
type ServerAzureADAdministratorsDeleteFuture = original.ServerAzureADAdministratorsDeleteFuture
type ServerCommunicationLink = original.ServerCommunicationLink
type ServerCommunicationLinkListResult = original.ServerCommunicationLinkListResult
type ServerCommunicationLinkProperties = original.ServerCommunicationLinkProperties
type ServerCommunicationLinksClient = original.ServerCommunicationLinksClient
type ServerCommunicationLinksCreateOrUpdateFuture = original.ServerCommunicationLinksCreateOrUpdateFuture
type ServerConnectionPoliciesClient = original.ServerConnectionPoliciesClient
type ServerConnectionPolicy = original.ServerConnectionPolicy
type ServerConnectionPolicyProperties = original.ServerConnectionPolicyProperties
type ServerListResult = original.ServerListResult
type ServerProperties = original.ServerProperties
type ServerTableAuditingPoliciesClient = original.ServerTableAuditingPoliciesClient
type ServerTableAuditingPolicy = original.ServerTableAuditingPolicy
type ServerTableAuditingPolicyListResult = original.ServerTableAuditingPolicyListResult
type ServerTableAuditingPolicyProperties = original.ServerTableAuditingPolicyProperties
type ServerUpdate = original.ServerUpdate
type ServerUsage = original.ServerUsage
type ServerUsageListResult = original.ServerUsageListResult
type ServerUsagesClient = original.ServerUsagesClient
type ServerVersionCapability = original.ServerVersionCapability
type ServersClient = original.ServersClient
type ServiceObjective = original.ServiceObjective
type ServiceObjectiveCapability = original.ServiceObjectiveCapability
type ServiceObjectiveListResult = original.ServiceObjectiveListResult
type ServiceObjectiveProperties = original.ServiceObjectiveProperties
type ServiceObjectivesClient = original.ServiceObjectivesClient
type ServiceTierAdvisor = original.ServiceTierAdvisor
type ServiceTierAdvisorListResult = original.ServiceTierAdvisorListResult
type ServiceTierAdvisorProperties = original.ServiceTierAdvisorProperties
type ServiceTierAdvisorsClient = original.ServiceTierAdvisorsClient
type SloUsageMetric = original.SloUsageMetric
type TableAuditingPolicyProperties = original.TableAuditingPolicyProperties
type TopQueries = original.TopQueries
type TopQueriesListResult = original.TopQueriesListResult
type TrackedResource = original.TrackedResource
type TransparentDataEncryption = original.TransparentDataEncryption
type TransparentDataEncryptionActivitiesClient = original.TransparentDataEncryptionActivitiesClient
type TransparentDataEncryptionActivity = original.TransparentDataEncryptionActivity
type TransparentDataEncryptionActivityListResult = original.TransparentDataEncryptionActivityListResult
type TransparentDataEncryptionActivityProperties = original.TransparentDataEncryptionActivityProperties
type TransparentDataEncryptionConfigurationsClient = original.TransparentDataEncryptionConfigurationsClient
type TransparentDataEncryptionListResult = original.TransparentDataEncryptionListResult
type TransparentDataEncryptionProperties = original.TransparentDataEncryptionProperties
type TransparentDataEncryptionsClient = original.TransparentDataEncryptionsClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewBackupLongTermRetentionPoliciesClient(subscriptionID string) BackupLongTermRetentionPoliciesClient {
	return original.NewBackupLongTermRetentionPoliciesClient(subscriptionID)
}
func NewBackupLongTermRetentionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) BackupLongTermRetentionPoliciesClient {
	return original.NewBackupLongTermRetentionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBackupLongTermRetentionVaultsClient(subscriptionID string) BackupLongTermRetentionVaultsClient {
	return original.NewBackupLongTermRetentionVaultsClient(subscriptionID)
}
func NewBackupLongTermRetentionVaultsClientWithBaseURI(baseURI string, subscriptionID string) BackupLongTermRetentionVaultsClient {
	return original.NewBackupLongTermRetentionVaultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCapabilitiesClient(subscriptionID string) CapabilitiesClient {
	return original.NewCapabilitiesClient(subscriptionID)
}
func NewCapabilitiesClientWithBaseURI(baseURI string, subscriptionID string) CapabilitiesClient {
	return original.NewCapabilitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataMaskingPoliciesClient(subscriptionID string) DataMaskingPoliciesClient {
	return original.NewDataMaskingPoliciesClient(subscriptionID)
}
func NewDataMaskingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DataMaskingPoliciesClient {
	return original.NewDataMaskingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataMaskingRulesClient(subscriptionID string) DataMaskingRulesClient {
	return original.NewDataMaskingRulesClient(subscriptionID)
}
func NewDataMaskingRulesClientWithBaseURI(baseURI string, subscriptionID string) DataMaskingRulesClient {
	return original.NewDataMaskingRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseAdvisorsClient(subscriptionID string) DatabaseAdvisorsClient {
	return original.NewDatabaseAdvisorsClient(subscriptionID)
}
func NewDatabaseAdvisorsClientWithBaseURI(baseURI string, subscriptionID string) DatabaseAdvisorsClient {
	return original.NewDatabaseAdvisorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseConnectionPoliciesClient(subscriptionID string) DatabaseConnectionPoliciesClient {
	return original.NewDatabaseConnectionPoliciesClient(subscriptionID)
}
func NewDatabaseConnectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseConnectionPoliciesClient {
	return original.NewDatabaseConnectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseTableAuditingPoliciesClient(subscriptionID string) DatabaseTableAuditingPoliciesClient {
	return original.NewDatabaseTableAuditingPoliciesClient(subscriptionID)
}
func NewDatabaseTableAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseTableAuditingPoliciesClient {
	return original.NewDatabaseTableAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseThreatDetectionPoliciesClient(subscriptionID string) DatabaseThreatDetectionPoliciesClient {
	return original.NewDatabaseThreatDetectionPoliciesClient(subscriptionID)
}
func NewDatabaseThreatDetectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseThreatDetectionPoliciesClient {
	return original.NewDatabaseThreatDetectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseUsagesClient(subscriptionID string) DatabaseUsagesClient {
	return original.NewDatabaseUsagesClient(subscriptionID)
}
func NewDatabaseUsagesClientWithBaseURI(baseURI string, subscriptionID string) DatabaseUsagesClient {
	return original.NewDatabaseUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabasesClient(subscriptionID string) DatabasesClient {
	return original.NewDatabasesClient(subscriptionID)
}
func NewDatabasesClientWithBaseURI(baseURI string, subscriptionID string) DatabasesClient {
	return original.NewDatabasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDisasterRecoveryConfigurationsClient(subscriptionID string) DisasterRecoveryConfigurationsClient {
	return original.NewDisasterRecoveryConfigurationsClient(subscriptionID)
}
func NewDisasterRecoveryConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) DisasterRecoveryConfigurationsClient {
	return original.NewDisasterRecoveryConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewElasticPoolActivitiesClient(subscriptionID string) ElasticPoolActivitiesClient {
	return original.NewElasticPoolActivitiesClient(subscriptionID)
}
func NewElasticPoolActivitiesClientWithBaseURI(baseURI string, subscriptionID string) ElasticPoolActivitiesClient {
	return original.NewElasticPoolActivitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewElasticPoolDatabaseActivitiesClient(subscriptionID string) ElasticPoolDatabaseActivitiesClient {
	return original.NewElasticPoolDatabaseActivitiesClient(subscriptionID)
}
func NewElasticPoolDatabaseActivitiesClientWithBaseURI(baseURI string, subscriptionID string) ElasticPoolDatabaseActivitiesClient {
	return original.NewElasticPoolDatabaseActivitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewElasticPoolsClient(subscriptionID string) ElasticPoolsClient {
	return original.NewElasticPoolsClient(subscriptionID)
}
func NewElasticPoolsClientWithBaseURI(baseURI string, subscriptionID string) ElasticPoolsClient {
	return original.NewElasticPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExtensionsClient(subscriptionID string) ExtensionsClient {
	return original.NewExtensionsClient(subscriptionID)
}
func NewExtensionsClientWithBaseURI(baseURI string, subscriptionID string) ExtensionsClient {
	return original.NewExtensionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallRulesClient(subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClient(subscriptionID)
}
func NewFirewallRulesClientWithBaseURI(baseURI string, subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewGeoBackupPoliciesClient(subscriptionID string) GeoBackupPoliciesClient {
	return original.NewGeoBackupPoliciesClient(subscriptionID)
}
func NewGeoBackupPoliciesClientWithBaseURI(baseURI string, subscriptionID string) GeoBackupPoliciesClient {
	return original.NewGeoBackupPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewQueriesClient(subscriptionID string) QueriesClient {
	return original.NewQueriesClient(subscriptionID)
}
func NewQueriesClientWithBaseURI(baseURI string, subscriptionID string) QueriesClient {
	return original.NewQueriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewQueryStatisticsClient(subscriptionID string) QueryStatisticsClient {
	return original.NewQueryStatisticsClient(subscriptionID)
}
func NewQueryStatisticsClientWithBaseURI(baseURI string, subscriptionID string) QueryStatisticsClient {
	return original.NewQueryStatisticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewQueryTextsClient(subscriptionID string) QueryTextsClient {
	return original.NewQueryTextsClient(subscriptionID)
}
func NewQueryTextsClientWithBaseURI(baseURI string, subscriptionID string) QueryTextsClient {
	return original.NewQueryTextsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRecommendedElasticPoolsClient(subscriptionID string) RecommendedElasticPoolsClient {
	return original.NewRecommendedElasticPoolsClient(subscriptionID)
}
func NewRecommendedElasticPoolsClientWithBaseURI(baseURI string, subscriptionID string) RecommendedElasticPoolsClient {
	return original.NewRecommendedElasticPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRecoverableDatabasesClient(subscriptionID string) RecoverableDatabasesClient {
	return original.NewRecoverableDatabasesClient(subscriptionID)
}
func NewRecoverableDatabasesClientWithBaseURI(baseURI string, subscriptionID string) RecoverableDatabasesClient {
	return original.NewRecoverableDatabasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewReplicationLinksClient(subscriptionID string) ReplicationLinksClient {
	return original.NewReplicationLinksClient(subscriptionID)
}
func NewReplicationLinksClientWithBaseURI(baseURI string, subscriptionID string) ReplicationLinksClient {
	return original.NewReplicationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorableDroppedDatabasesClient(subscriptionID string) RestorableDroppedDatabasesClient {
	return original.NewRestorableDroppedDatabasesClient(subscriptionID)
}
func NewRestorableDroppedDatabasesClientWithBaseURI(baseURI string, subscriptionID string) RestorableDroppedDatabasesClient {
	return original.NewRestorableDroppedDatabasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorePointsClient(subscriptionID string) RestorePointsClient {
	return original.NewRestorePointsClient(subscriptionID)
}
func NewRestorePointsClientWithBaseURI(baseURI string, subscriptionID string) RestorePointsClient {
	return original.NewRestorePointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerAdvisorsClient(subscriptionID string) ServerAdvisorsClient {
	return original.NewServerAdvisorsClient(subscriptionID)
}
func NewServerAdvisorsClientWithBaseURI(baseURI string, subscriptionID string) ServerAdvisorsClient {
	return original.NewServerAdvisorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerAzureADAdministratorsClient(subscriptionID string) ServerAzureADAdministratorsClient {
	return original.NewServerAzureADAdministratorsClient(subscriptionID)
}
func NewServerAzureADAdministratorsClientWithBaseURI(baseURI string, subscriptionID string) ServerAzureADAdministratorsClient {
	return original.NewServerAzureADAdministratorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerCommunicationLinksClient(subscriptionID string) ServerCommunicationLinksClient {
	return original.NewServerCommunicationLinksClient(subscriptionID)
}
func NewServerCommunicationLinksClientWithBaseURI(baseURI string, subscriptionID string) ServerCommunicationLinksClient {
	return original.NewServerCommunicationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerConnectionPoliciesClient(subscriptionID string) ServerConnectionPoliciesClient {
	return original.NewServerConnectionPoliciesClient(subscriptionID)
}
func NewServerConnectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ServerConnectionPoliciesClient {
	return original.NewServerConnectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerTableAuditingPoliciesClient(subscriptionID string) ServerTableAuditingPoliciesClient {
	return original.NewServerTableAuditingPoliciesClient(subscriptionID)
}
func NewServerTableAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ServerTableAuditingPoliciesClient {
	return original.NewServerTableAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerUsagesClient(subscriptionID string) ServerUsagesClient {
	return original.NewServerUsagesClient(subscriptionID)
}
func NewServerUsagesClientWithBaseURI(baseURI string, subscriptionID string) ServerUsagesClient {
	return original.NewServerUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServersClient(subscriptionID string) ServersClient {
	return original.NewServersClient(subscriptionID)
}
func NewServersClientWithBaseURI(baseURI string, subscriptionID string) ServersClient {
	return original.NewServersClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceObjectivesClient(subscriptionID string) ServiceObjectivesClient {
	return original.NewServiceObjectivesClient(subscriptionID)
}
func NewServiceObjectivesClientWithBaseURI(baseURI string, subscriptionID string) ServiceObjectivesClient {
	return original.NewServiceObjectivesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceTierAdvisorsClient(subscriptionID string) ServiceTierAdvisorsClient {
	return original.NewServiceTierAdvisorsClient(subscriptionID)
}
func NewServiceTierAdvisorsClientWithBaseURI(baseURI string, subscriptionID string) ServiceTierAdvisorsClient {
	return original.NewServiceTierAdvisorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTransparentDataEncryptionActivitiesClient(subscriptionID string) TransparentDataEncryptionActivitiesClient {
	return original.NewTransparentDataEncryptionActivitiesClient(subscriptionID)
}
func NewTransparentDataEncryptionActivitiesClientWithBaseURI(baseURI string, subscriptionID string) TransparentDataEncryptionActivitiesClient {
	return original.NewTransparentDataEncryptionActivitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTransparentDataEncryptionConfigurationsClient(subscriptionID string) TransparentDataEncryptionConfigurationsClient {
	return original.NewTransparentDataEncryptionConfigurationsClient(subscriptionID)
}
func NewTransparentDataEncryptionConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) TransparentDataEncryptionConfigurationsClient {
	return original.NewTransparentDataEncryptionConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTransparentDataEncryptionsClient(subscriptionID string) TransparentDataEncryptionsClient {
	return original.NewTransparentDataEncryptionsClient(subscriptionID)
}
func NewTransparentDataEncryptionsClientWithBaseURI(baseURI string, subscriptionID string) TransparentDataEncryptionsClient {
	return original.NewTransparentDataEncryptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAdvisorStatusValues() []AdvisorStatus {
	return original.PossibleAdvisorStatusValues()
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleAutoExecuteStatusValues() []AutoExecuteStatus {
	return original.PossibleAutoExecuteStatusValues()
}
func PossibleBackupLongTermRetentionPolicyStateValues() []BackupLongTermRetentionPolicyState {
	return original.PossibleBackupLongTermRetentionPolicyStateValues()
}
func PossibleCapabilityStatusValues() []CapabilityStatus {
	return original.PossibleCapabilityStatusValues()
}
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return original.PossibleCheckNameAvailabilityReasonValues()
}
func PossibleCreateModeValues() []CreateMode {
	return original.PossibleCreateModeValues()
}
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return original.PossibleDataMaskingFunctionValues()
}
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return original.PossibleDataMaskingRuleStateValues()
}
func PossibleDataMaskingStateValues() []DataMaskingState {
	return original.PossibleDataMaskingStateValues()
}
func PossibleDatabaseEditionValues() []DatabaseEdition {
	return original.PossibleDatabaseEditionValues()
}
func PossibleDisasterRecoveryConfigurationAutoFailoverValues() []DisasterRecoveryConfigurationAutoFailover {
	return original.PossibleDisasterRecoveryConfigurationAutoFailoverValues()
}
func PossibleDisasterRecoveryConfigurationFailoverPolicyValues() []DisasterRecoveryConfigurationFailoverPolicy {
	return original.PossibleDisasterRecoveryConfigurationFailoverPolicyValues()
}
func PossibleDisasterRecoveryConfigurationRoleValues() []DisasterRecoveryConfigurationRole {
	return original.PossibleDisasterRecoveryConfigurationRoleValues()
}
func PossibleDisasterRecoveryConfigurationStatusValues() []DisasterRecoveryConfigurationStatus {
	return original.PossibleDisasterRecoveryConfigurationStatusValues()
}
func PossibleElasticPoolEditionValues() []ElasticPoolEdition {
	return original.PossibleElasticPoolEditionValues()
}
func PossibleElasticPoolStateValues() []ElasticPoolState {
	return original.PossibleElasticPoolStateValues()
}
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return original.PossibleGeoBackupPolicyStateValues()
}
func PossibleMaxSizeUnitsValues() []MaxSizeUnits {
	return original.PossibleMaxSizeUnitsValues()
}
func PossiblePerformanceLevelUnitValues() []PerformanceLevelUnit {
	return original.PossiblePerformanceLevelUnitValues()
}
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return original.PossiblePrimaryAggregationTypeValues()
}
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return original.PossibleQueryAggregationFunctionValues()
}
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return original.PossibleQueryExecutionTypeValues()
}
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return original.PossibleQueryMetricUnitValues()
}
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return original.PossibleQueryObservedMetricTypeValues()
}
func PossibleReadScaleValues() []ReadScale {
	return original.PossibleReadScaleValues()
}
func PossibleRecommendedIndexActionValues() []RecommendedIndexAction {
	return original.PossibleRecommendedIndexActionValues()
}
func PossibleRecommendedIndexStateValues() []RecommendedIndexState {
	return original.PossibleRecommendedIndexStateValues()
}
func PossibleRecommendedIndexTypeValues() []RecommendedIndexType {
	return original.PossibleRecommendedIndexTypeValues()
}
func PossibleReplicationRoleValues() []ReplicationRole {
	return original.PossibleReplicationRoleValues()
}
func PossibleReplicationStateValues() []ReplicationState {
	return original.PossibleReplicationStateValues()
}
func PossibleRestorePointTypeValues() []RestorePointType {
	return original.PossibleRestorePointTypeValues()
}
func PossibleSampleNameValues() []SampleName {
	return original.PossibleSampleNameValues()
}
func PossibleSecurityAlertPolicyEmailAccountAdminsValues() []SecurityAlertPolicyEmailAccountAdmins {
	return original.PossibleSecurityAlertPolicyEmailAccountAdminsValues()
}
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return original.PossibleSecurityAlertPolicyStateValues()
}
func PossibleSecurityAlertPolicyUseServerDefaultValues() []SecurityAlertPolicyUseServerDefault {
	return original.PossibleSecurityAlertPolicyUseServerDefaultValues()
}
func PossibleServerConnectionTypeValues() []ServerConnectionType {
	return original.PossibleServerConnectionTypeValues()
}
func PossibleServerStateValues() []ServerState {
	return original.PossibleServerStateValues()
}
func PossibleServerVersionValues() []ServerVersion {
	return original.PossibleServerVersionValues()
}
func PossibleServiceObjectiveNameValues() []ServiceObjectiveName {
	return original.PossibleServiceObjectiveNameValues()
}
func PossibleStorageKeyTypeValues() []StorageKeyType {
	return original.PossibleStorageKeyTypeValues()
}
func PossibleTransparentDataEncryptionActivityStatusValues() []TransparentDataEncryptionActivityStatus {
	return original.PossibleTransparentDataEncryptionActivityStatusValues()
}
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return original.PossibleTransparentDataEncryptionStatusValues()
}
func PossibleUnitDefinitionTypeValues() []UnitDefinitionType {
	return original.PossibleUnitDefinitionTypeValues()
}
func PossibleUnitTypeValues() []UnitType {
	return original.PossibleUnitTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
