// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateTeamMember = "AssociateTeamMember"

// AssociateTeamMemberRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTeamMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTeamMember for more information on using the AssociateTeamMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTeamMemberRequest method.
//    req, resp := client.AssociateTeamMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/AssociateTeamMember
func (c *CodeStar) AssociateTeamMemberRequest(input *AssociateTeamMemberInput) (req *request.Request, output *AssociateTeamMemberOutput) {
	op := &request.Operation{
		Name:       opAssociateTeamMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTeamMemberInput{}
	}

	output = &AssociateTeamMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTeamMember API operation for AWS CodeStar.
//
// Adds an IAM user to the team for an AWS CodeStar project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation AssociateTeamMember for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   A resource limit has been exceeded.
//
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * TeamMemberAlreadyAssociatedException
//   The team member is already associated with a role in this project.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * InvalidServiceRoleException
//   The service role is not valid.
//
//   * ProjectConfigurationException
//   Project configuration information is required but not specified.
//
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/AssociateTeamMember
func (c *CodeStar) AssociateTeamMember(input *AssociateTeamMemberInput) (*AssociateTeamMemberOutput, error) {
	req, out := c.AssociateTeamMemberRequest(input)
	return out, req.Send()
}

// AssociateTeamMemberWithContext is the same as AssociateTeamMember with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTeamMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) AssociateTeamMemberWithContext(ctx aws.Context, input *AssociateTeamMemberInput, opts ...request.Option) (*AssociateTeamMemberOutput, error) {
	req, out := c.AssociateTeamMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateProject
func (c *CodeStar) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS CodeStar.
//
// Creates a project, including project resources. This action creates a project
// based on a submitted project request. A set of source code files and a toolchain
// template file can be included with the project request. If these are not
// provided, an empty project is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * ProjectAlreadyExistsException
//   An AWS CodeStar project with the same ID already exists in this region for
//   the AWS account. AWS CodeStar project IDs must be unique within a region
//   for the AWS account.
//
//   * LimitExceededException
//   A resource limit has been exceeded.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * ProjectCreationFailedException
//   The project creation request was valid, but a nonspecific exception or error
//   occurred during project creation. The project could not be created in AWS
//   CodeStar.
//
//   * InvalidServiceRoleException
//   The service role is not valid.
//
//   * ProjectConfigurationException
//   Project configuration information is required but not specified.
//
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateProject
func (c *CodeStar) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserProfile for more information on using the CreateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserProfileRequest method.
//    req, resp := client.CreateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateUserProfile
func (c *CodeStar) CreateUserProfileRequest(input *CreateUserProfileInput) (req *request.Request, output *CreateUserProfileOutput) {
	op := &request.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	output = &CreateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserProfile API operation for AWS CodeStar.
//
// Creates a profile for a user that includes user preferences, such as the
// display name and email address assocciated with the user, in AWS CodeStar.
// The user profile is not project-specific. Information in the user profile
// is displayed wherever the user's information appears to other users in AWS
// CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation CreateUserProfile for usage and error information.
//
// Returned Error Types:
//   * UserProfileAlreadyExistsException
//   A user profile with that name already exists in this region for the AWS account.
//   AWS CodeStar user profile names must be unique within a region for the AWS
//   account.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateUserProfile
func (c *CodeStar) CreateUserProfile(input *CreateUserProfileInput) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	return out, req.Send()
}

// CreateUserProfileWithContext is the same as CreateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) CreateUserProfileWithContext(ctx aws.Context, input *CreateUserProfileInput, opts ...request.Option) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteProject
func (c *CodeStar) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for AWS CodeStar.
//
// Deletes a project, including project resources. Does not delete users associated
// with the project, but does delete the IAM roles that allowed access to the
// project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * InvalidServiceRoleException
//   The service role is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteProject
func (c *CodeStar) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserProfile for more information on using the DeleteUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserProfileRequest method.
//    req, resp := client.DeleteUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteUserProfile
func (c *CodeStar) DeleteUserProfileRequest(input *DeleteUserProfileInput) (req *request.Request, output *DeleteUserProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	output = &DeleteUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserProfile API operation for AWS CodeStar.
//
// Deletes a user profile in AWS CodeStar, including all personal preference
// data associated with that profile, such as display name and email address.
// It does not delete the history of that user, for example the history of commits
// made by that user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DeleteUserProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteUserProfile
func (c *CodeStar) DeleteUserProfile(input *DeleteUserProfileInput) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	return out, req.Send()
}

// DeleteUserProfileWithContext is the same as DeleteUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DeleteUserProfileWithContext(ctx aws.Context, input *DeleteUserProfileInput, opts ...request.Option) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeProject
func (c *CodeStar) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for AWS CodeStar.
//
// Describes a project and its resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DescribeProject for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * InvalidServiceRoleException
//   The service role is not valid.
//
//   * ProjectConfigurationException
//   Project configuration information is required but not specified.
//
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeProject
func (c *CodeStar) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserProfile = "DescribeUserProfile"

// DescribeUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserProfile for more information on using the DescribeUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserProfileRequest method.
//    req, resp := client.DescribeUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeUserProfile
func (c *CodeStar) DescribeUserProfileRequest(input *DescribeUserProfileInput) (req *request.Request, output *DescribeUserProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserProfileInput{}
	}

	output = &DescribeUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserProfile API operation for AWS CodeStar.
//
// Describes a user in AWS CodeStar and the user attributes across all projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DescribeUserProfile for usage and error information.
//
// Returned Error Types:
//   * UserProfileNotFoundException
//   The user profile was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeUserProfile
func (c *CodeStar) DescribeUserProfile(input *DescribeUserProfileInput) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	return out, req.Send()
}

// DescribeUserProfileWithContext is the same as DescribeUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DescribeUserProfileWithContext(ctx aws.Context, input *DescribeUserProfileInput, opts ...request.Option) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTeamMember = "DisassociateTeamMember"

// DisassociateTeamMemberRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTeamMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateTeamMember for more information on using the DisassociateTeamMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateTeamMemberRequest method.
//    req, resp := client.DisassociateTeamMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DisassociateTeamMember
func (c *CodeStar) DisassociateTeamMemberRequest(input *DisassociateTeamMemberInput) (req *request.Request, output *DisassociateTeamMemberOutput) {
	op := &request.Operation{
		Name:       opDisassociateTeamMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateTeamMemberInput{}
	}

	output = &DisassociateTeamMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateTeamMember API operation for AWS CodeStar.
//
// Removes a user from a project. Removing a user from a project also removes
// the IAM policies from that user that allowed access to the project and its
// resources. Disassociating a team member does not remove that user's profile
// from AWS CodeStar. It does not remove the user from IAM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DisassociateTeamMember for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * InvalidServiceRoleException
//   The service role is not valid.
//
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DisassociateTeamMember
func (c *CodeStar) DisassociateTeamMember(input *DisassociateTeamMemberInput) (*DisassociateTeamMemberOutput, error) {
	req, out := c.DisassociateTeamMemberRequest(input)
	return out, req.Send()
}

// DisassociateTeamMemberWithContext is the same as DisassociateTeamMember with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTeamMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DisassociateTeamMemberWithContext(ctx aws.Context, input *DisassociateTeamMemberInput, opts ...request.Option) (*DisassociateTeamMemberOutput, error) {
	req, out := c.DisassociateTeamMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListProjects
func (c *CodeStar) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS CodeStar.
//
// Lists all projects in AWS CodeStar associated with your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The next token is not valid.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListProjects
func (c *CodeStar) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesRequest method.
//    req, resp := client.ListResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListResources
func (c *CodeStar) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for AWS CodeStar.
//
// Lists resources associated with a project in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListResources for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * InvalidNextTokenException
//   The next token is not valid.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListResources
func (c *CodeStar) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForProject = "ListTagsForProject"

// ListTagsForProjectRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForProject for more information on using the ListTagsForProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForProjectRequest method.
//    req, resp := client.ListTagsForProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTagsForProject
func (c *CodeStar) ListTagsForProjectRequest(input *ListTagsForProjectInput) (req *request.Request, output *ListTagsForProjectOutput) {
	op := &request.Operation{
		Name:       opListTagsForProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForProjectInput{}
	}

	output = &ListTagsForProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForProject API operation for AWS CodeStar.
//
// Gets the tags for a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListTagsForProject for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * InvalidNextTokenException
//   The next token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTagsForProject
func (c *CodeStar) ListTagsForProject(input *ListTagsForProjectInput) (*ListTagsForProjectOutput, error) {
	req, out := c.ListTagsForProjectRequest(input)
	return out, req.Send()
}

// ListTagsForProjectWithContext is the same as ListTagsForProject with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListTagsForProjectWithContext(ctx aws.Context, input *ListTagsForProjectInput, opts ...request.Option) (*ListTagsForProjectOutput, error) {
	req, out := c.ListTagsForProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTeamMembers = "ListTeamMembers"

// ListTeamMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListTeamMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTeamMembers for more information on using the ListTeamMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTeamMembersRequest method.
//    req, resp := client.ListTeamMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembers
func (c *CodeStar) ListTeamMembersRequest(input *ListTeamMembersInput) (req *request.Request, output *ListTeamMembersOutput) {
	op := &request.Operation{
		Name:       opListTeamMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTeamMembersInput{}
	}

	output = &ListTeamMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTeamMembers API operation for AWS CodeStar.
//
// Lists all team members associated with a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListTeamMembers for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * InvalidNextTokenException
//   The next token is not valid.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembers
func (c *CodeStar) ListTeamMembers(input *ListTeamMembersInput) (*ListTeamMembersOutput, error) {
	req, out := c.ListTeamMembersRequest(input)
	return out, req.Send()
}

// ListTeamMembersWithContext is the same as ListTeamMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTeamMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListTeamMembersWithContext(ctx aws.Context, input *ListTeamMembersInput, opts ...request.Option) (*ListTeamMembersOutput, error) {
	req, out := c.ListTeamMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserProfiles = "ListUserProfiles"

// ListUserProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListUserProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserProfiles for more information on using the ListUserProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserProfilesRequest method.
//    req, resp := client.ListUserProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListUserProfiles
func (c *CodeStar) ListUserProfilesRequest(input *ListUserProfilesInput) (req *request.Request, output *ListUserProfilesOutput) {
	op := &request.Operation{
		Name:       opListUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserProfilesInput{}
	}

	output = &ListUserProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserProfiles API operation for AWS CodeStar.
//
// Lists all the user profiles configured for your AWS account in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListUserProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The next token is not valid.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListUserProfiles
func (c *CodeStar) ListUserProfiles(input *ListUserProfilesInput) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	return out, req.Send()
}

// ListUserProfilesWithContext is the same as ListUserProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListUserProfilesWithContext(ctx aws.Context, input *ListUserProfilesInput, opts ...request.Option) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagProject = "TagProject"

// TagProjectRequest generates a "aws/request.Request" representing the
// client's request for the TagProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagProject for more information on using the TagProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagProjectRequest method.
//    req, resp := client.TagProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/TagProject
func (c *CodeStar) TagProjectRequest(input *TagProjectInput) (req *request.Request, output *TagProjectOutput) {
	op := &request.Operation{
		Name:       opTagProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagProjectInput{}
	}

	output = &TagProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagProject API operation for AWS CodeStar.
//
// Adds tags to a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation TagProject for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * LimitExceededException
//   A resource limit has been exceeded.
//
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/TagProject
func (c *CodeStar) TagProject(input *TagProjectInput) (*TagProjectOutput, error) {
	req, out := c.TagProjectRequest(input)
	return out, req.Send()
}

// TagProjectWithContext is the same as TagProject with the addition of
// the ability to pass a context and additional request options.
//
// See TagProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) TagProjectWithContext(ctx aws.Context, input *TagProjectInput, opts ...request.Option) (*TagProjectOutput, error) {
	req, out := c.TagProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagProject = "UntagProject"

// UntagProjectRequest generates a "aws/request.Request" representing the
// client's request for the UntagProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagProject for more information on using the UntagProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagProjectRequest method.
//    req, resp := client.UntagProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UntagProject
func (c *CodeStar) UntagProjectRequest(input *UntagProjectInput) (req *request.Request, output *UntagProjectOutput) {
	op := &request.Operation{
		Name:       opUntagProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagProjectInput{}
	}

	output = &UntagProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagProject API operation for AWS CodeStar.
//
// Removes tags from a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation UntagProject for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * LimitExceededException
//   A resource limit has been exceeded.
//
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UntagProject
func (c *CodeStar) UntagProject(input *UntagProjectInput) (*UntagProjectOutput, error) {
	req, out := c.UntagProjectRequest(input)
	return out, req.Send()
}

// UntagProjectWithContext is the same as UntagProject with the addition of
// the ability to pass a context and additional request options.
//
// See UntagProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) UntagProjectWithContext(ctx aws.Context, input *UntagProjectInput, opts ...request.Option) (*UntagProjectOutput, error) {
	req, out := c.UntagProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateProject
func (c *CodeStar) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateProject API operation for AWS CodeStar.
//
// Updates a project in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateProject
func (c *CodeStar) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTeamMember = "UpdateTeamMember"

// UpdateTeamMemberRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTeamMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTeamMember for more information on using the UpdateTeamMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTeamMemberRequest method.
//    req, resp := client.UpdateTeamMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateTeamMember
func (c *CodeStar) UpdateTeamMemberRequest(input *UpdateTeamMemberInput) (req *request.Request, output *UpdateTeamMemberOutput) {
	op := &request.Operation{
		Name:       opUpdateTeamMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTeamMemberInput{}
	}

	output = &UpdateTeamMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTeamMember API operation for AWS CodeStar.
//
// Updates a team member's attributes in an AWS CodeStar project. For example,
// you can change a team member's role in the project, or change whether they
// have remote access to project resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation UpdateTeamMember for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   A resource limit has been exceeded.
//
//   * ProjectNotFoundException
//   The specified AWS CodeStar project was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
//   * InvalidServiceRoleException
//   The service role is not valid.
//
//   * ProjectConfigurationException
//   Project configuration information is required but not specified.
//
//   * ConcurrentModificationException
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
//   * TeamMemberNotFoundException
//   The specified team member was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateTeamMember
func (c *CodeStar) UpdateTeamMember(input *UpdateTeamMemberInput) (*UpdateTeamMemberOutput, error) {
	req, out := c.UpdateTeamMemberRequest(input)
	return out, req.Send()
}

// UpdateTeamMemberWithContext is the same as UpdateTeamMember with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTeamMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) UpdateTeamMemberWithContext(ctx aws.Context, input *UpdateTeamMemberInput, opts ...request.Option) (*UpdateTeamMemberOutput, error) {
	req, out := c.UpdateTeamMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserProfile for more information on using the UpdateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserProfileRequest method.
//    req, resp := client.UpdateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateUserProfile
func (c *CodeStar) UpdateUserProfileRequest(input *UpdateUserProfileInput) (req *request.Request, output *UpdateUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	output = &UpdateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserProfile API operation for AWS CodeStar.
//
// Updates a user's profile in AWS CodeStar. The user profile is not project-specific.
// Information in the user profile is displayed wherever the user's information
// appears to other users in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation UpdateUserProfile for usage and error information.
//
// Returned Error Types:
//   * UserProfileNotFoundException
//   The user profile was not found.
//
//   * ValidationException
//   The specified input is either not valid, or it could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateUserProfile
func (c *CodeStar) UpdateUserProfile(input *UpdateUserProfileInput) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	return out, req.Send()
}

// UpdateUserProfileWithContext is the same as UpdateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) UpdateUserProfileWithContext(ctx aws.Context, input *UpdateUserProfileInput, opts ...request.Option) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateTeamMemberInput struct {
	_ struct{} `type:"structure"`

	// A user- or system-generated token that identifies the entity that requested
	// the team member association to the project. This token can be used to repeat
	// the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The ID of the project to which you will add the IAM user.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`

	// The AWS CodeStar project role that will apply to this user. This role determines
	// what actions a user can take in an AWS CodeStar project.
	//
	// ProjectRole is a required field
	ProjectRole *string `locationName:"projectRole" type:"string" required:"true"`

	// Whether the team member is allowed to use an SSH public/private key pair
	// to remotely access project resources, for example Amazon EC2 instances.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS
	// CodeStar project.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateTeamMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTeamMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTeamMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTeamMemberInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}
	if s.ProjectRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectRole"))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateTeamMemberInput) SetClientRequestToken(v string) *AssociateTeamMemberInput {
	s.ClientRequestToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *AssociateTeamMemberInput) SetProjectId(v string) *AssociateTeamMemberInput {
	s.ProjectId = &v
	return s
}

// SetProjectRole sets the ProjectRole field's value.
func (s *AssociateTeamMemberInput) SetProjectRole(v string) *AssociateTeamMemberInput {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *AssociateTeamMemberInput) SetRemoteAccessAllowed(v bool) *AssociateTeamMemberInput {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *AssociateTeamMemberInput) SetUserArn(v string) *AssociateTeamMemberInput {
	s.UserArn = &v
	return s
}

type AssociateTeamMemberOutput struct {
	_ struct{} `type:"structure"`

	// The user- or system-generated token from the initial request that can be
	// used to repeat the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateTeamMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTeamMemberOutput) GoString() string {
	return s.String()
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateTeamMemberOutput) SetClientRequestToken(v string) *AssociateTeamMemberOutput {
	s.ClientRequestToken = &v
	return s
}

// Location and destination information about the source code files provided
// with the project request. The source code is uploaded to the new project
// source repository after project creation.
type Code struct {
	_ struct{} `type:"structure"`

	// The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit
	// or GitHub. After AWS CodeStar provisions the new repository, the source code
	// files provided with the project request are placed in the repository.
	//
	// Destination is a required field
	Destination *CodeDestination `locationName:"destination" type:"structure" required:"true"`

	// The location where the source code files provided with the project request
	// are stored. AWS CodeStar retrieves the files during project creation.
	//
	// Source is a required field
	Source *CodeSource `locationName:"source" type:"structure" required:"true"`
}

// String returns the string representation
func (s Code) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Code) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Code) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Code"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *Code) SetDestination(v *CodeDestination) *Code {
	s.Destination = v
	return s
}

// SetSource sets the Source field's value.
func (s *Code) SetSource(v *CodeSource) *Code {
	s.Source = v
	return s
}

// Information about the AWS CodeCommit repository to be created in AWS CodeStar.
// This is where the source code files provided with the project request will
// be uploaded after project creation.
type CodeCommitCodeDestination struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeCommit repository to be created in AWS CodeStar.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeCommitCodeDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeCommitCodeDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeCommitCodeDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeCommitCodeDestination"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CodeCommitCodeDestination) SetName(v string) *CodeCommitCodeDestination {
	s.Name = &v
	return s
}

// The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit
// or GitHub. After AWS CodeStar provisions the new repository, the source code
// files provided with the project request are placed in the repository.
type CodeDestination struct {
	_ struct{} `type:"structure"`

	// Information about the AWS CodeCommit repository to be created in AWS CodeStar.
	// This is where the source code files provided with the project request will
	// be uploaded after project creation.
	CodeCommit *CodeCommitCodeDestination `locationName:"codeCommit" type:"structure"`

	// Information about the GitHub repository to be created in AWS CodeStar. This
	// is where the source code files provided with the project request will be
	// uploaded after project creation.
	GitHub *GitHubCodeDestination `locationName:"gitHub" type:"structure"`
}

// String returns the string representation
func (s CodeDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeDestination"}
	if s.CodeCommit != nil {
		if err := s.CodeCommit.Validate(); err != nil {
			invalidParams.AddNested("CodeCommit", err.(request.ErrInvalidParams))
		}
	}
	if s.GitHub != nil {
		if err := s.GitHub.Validate(); err != nil {
			invalidParams.AddNested("GitHub", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeCommit sets the CodeCommit field's value.
func (s *CodeDestination) SetCodeCommit(v *CodeCommitCodeDestination) *CodeDestination {
	s.CodeCommit = v
	return s
}

// SetGitHub sets the GitHub field's value.
func (s *CodeDestination) SetGitHub(v *GitHubCodeDestination) *CodeDestination {
	s.GitHub = v
	return s
}

// The location where the source code files provided with the project request
// are stored. AWS CodeStar retrieves the files during project creation.
type CodeSource struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon S3 location where the source code files provided
	// with the project request are stored.
	//
	// S3 is a required field
	S3 *S3Location `locationName:"s3" type:"structure" required:"true"`
}

// String returns the string representation
func (s CodeSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeSource"}
	if s.S3 == nil {
		invalidParams.Add(request.NewErrParamRequired("S3"))
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *CodeSource) SetS3(v *S3Location) *CodeSource {
	s.S3 = v
	return s
}

// Another modification is being made. That modification must complete before
// you can make your change.
type ConcurrentModificationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s ConcurrentModificationException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConcurrentModificationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConcurrentModificationException) RequestID() string {
	return s.respMetadata.RequestID
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// A user- or system-generated token that identifies the entity that requested
	// project creation. This token can be used to repeat the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The description of the project, if any.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the project to be created in AWS CodeStar.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// The display name for the project to be created in AWS CodeStar.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// A list of the Code objects submitted with the project request. If this parameter
	// is specified, the request must also include the toolchain parameter.
	SourceCode []*Code `locationName:"sourceCode" type:"list"`

	// The tags created for the project.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name of the toolchain template file submitted with the project request.
	// If this parameter is specified, the request must also include the sourceCode
	// parameter.
	Toolchain *Toolchain `locationName:"toolchain" type:"structure"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceCode != nil {
		for i, v := range s.SourceCode {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceCode", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Toolchain != nil {
		if err := s.Toolchain.Validate(); err != nil {
			invalidParams.AddNested("Toolchain", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProjectInput) SetClientRequestToken(v string) *CreateProjectInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateProjectInput) SetId(v string) *CreateProjectInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// SetSourceCode sets the SourceCode field's value.
func (s *CreateProjectInput) SetSourceCode(v []*Code) *CreateProjectInput {
	s.SourceCode = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v map[string]*string) *CreateProjectInput {
	s.Tags = v
	return s
}

// SetToolchain sets the Toolchain field's value.
func (s *CreateProjectInput) SetToolchain(v *Toolchain) *CreateProjectInput {
	s.Toolchain = v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created project.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A user- or system-generated token that identifies the entity that requested
	// project creation.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// Reserved for future use.
	ProjectTemplateId *string `locationName:"projectTemplateId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateProjectOutput) SetArn(v string) *CreateProjectOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProjectOutput) SetClientRequestToken(v string) *CreateProjectOutput {
	s.ClientRequestToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateProjectOutput) SetId(v string) *CreateProjectOutput {
	s.Id = &v
	return s
}

// SetProjectTemplateId sets the ProjectTemplateId field's value.
func (s *CreateProjectOutput) SetProjectTemplateId(v string) *CreateProjectOutput {
	s.ProjectTemplateId = &v
	return s
}

type CreateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The name that will be displayed as the friendly name for the user in AWS
	// CodeStar.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true" sensitive:"true"`

	// The email address that will be displayed as part of the user's profile in
	// AWS CodeStar.
	//
	// EmailAddress is a required field
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" required:"true" sensitive:"true"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserProfileInput"}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 3))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserProfileInput) SetDisplayName(v string) *CreateUserProfileInput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateUserProfileInput) SetEmailAddress(v string) *CreateUserProfileInput {
	s.EmailAddress = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *CreateUserProfileInput) SetSshPublicKey(v string) *CreateUserProfileInput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserProfileInput) SetUserArn(v string) *CreateUserProfileInput {
	s.UserArn = &v
	return s
}

type CreateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date the user profile was created, in timestamp format.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The date the user profile was last modified, in timestamp format.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The SSH public key associated with the user in AWS CodeStar. This is the
	// public portion of the public/private keypair the user can use to access project
	// resources if a project owner allows the user remote access to those resources.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateUserProfileOutput) SetCreatedTimestamp(v time.Time) *CreateUserProfileOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserProfileOutput) SetDisplayName(v string) *CreateUserProfileOutput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateUserProfileOutput) SetEmailAddress(v string) *CreateUserProfileOutput {
	s.EmailAddress = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *CreateUserProfileOutput) SetLastModifiedTimestamp(v time.Time) *CreateUserProfileOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *CreateUserProfileOutput) SetSshPublicKey(v string) *CreateUserProfileOutput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserProfileOutput) SetUserArn(v string) *CreateUserProfileOutput {
	s.UserArn = &v
	return s
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// A user- or system-generated token that identifies the entity that requested
	// project deletion. This token can be used to repeat the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Whether to send a delete request for the primary stack in AWS CloudFormation
	// originally used to generate the project and its resources. This option will
	// delete all AWS resources for the project (except for any buckets in Amazon
	// S3) as well as deleting the project itself. Recommended for most use cases.
	DeleteStack *bool `locationName:"deleteStack" type:"boolean"`

	// The ID of the project to be deleted in AWS CodeStar.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteProjectInput) SetClientRequestToken(v string) *DeleteProjectInput {
	s.ClientRequestToken = &v
	return s
}

// SetDeleteStack sets the DeleteStack field's value.
func (s *DeleteProjectInput) SetDeleteStack(v bool) *DeleteProjectInput {
	s.DeleteStack = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteProjectInput) SetId(v string) *DeleteProjectInput {
	s.Id = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted project.
	ProjectArn *string `locationName:"projectArn" type:"string"`

	// The ID of the primary stack in AWS CloudFormation that will be deleted as
	// part of deleting the project and its resources.
	StackId *string `locationName:"stackId" type:"string"`
}

// String returns the string representation
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DeleteProjectOutput) SetProjectArn(v string) *DeleteProjectOutput {
	s.ProjectArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DeleteProjectOutput) SetStackId(v string) *DeleteProjectOutput {
	s.StackId = &v
	return s
}

type DeleteUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserProfileInput"}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserArn sets the UserArn field's value.
func (s *DeleteUserProfileInput) SetUserArn(v string) *DeleteUserProfileInput {
	s.UserArn = &v
	return s
}

type DeleteUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user deleted from AWS CodeStar.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileOutput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *DeleteUserProfileOutput) SetUserArn(v string) *DeleteUserProfileOutput {
	s.UserArn = &v
	return s
}

type DescribeProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeProjectInput) SetId(v string) *DescribeProjectInput {
	s.Id = &v
	return s
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the project.
	Arn *string `locationName:"arn" type:"string"`

	// A user- or system-generated token that identifies the entity that requested
	// project creation.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The date and time the project was created, in timestamp format.
	CreatedTimeStamp *time.Time `locationName:"createdTimeStamp" type:"timestamp"`

	// The description of the project, if any.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the project.
	Id *string `locationName:"id" min:"2" type:"string"`

	// The display name for the project.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`

	// The ID for the AWS CodeStar project template used to create the project.
	ProjectTemplateId *string `locationName:"projectTemplateId" min:"1" type:"string"`

	// The ID of the primary stack in AWS CloudFormation used to generate resources
	// for the project.
	StackId *string `locationName:"stackId" type:"string"`

	// The project creation or deletion status.
	Status *ProjectStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeProjectOutput) SetArn(v string) *DescribeProjectOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DescribeProjectOutput) SetClientRequestToken(v string) *DescribeProjectOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedTimeStamp sets the CreatedTimeStamp field's value.
func (s *DescribeProjectOutput) SetCreatedTimeStamp(v time.Time) *DescribeProjectOutput {
	s.CreatedTimeStamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeProjectOutput) SetDescription(v string) *DescribeProjectOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeProjectOutput) SetId(v string) *DescribeProjectOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeProjectOutput) SetName(v string) *DescribeProjectOutput {
	s.Name = &v
	return s
}

// SetProjectTemplateId sets the ProjectTemplateId field's value.
func (s *DescribeProjectOutput) SetProjectTemplateId(v string) *DescribeProjectOutput {
	s.ProjectTemplateId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeProjectOutput) SetStackId(v string) *DescribeProjectOutput {
	s.StackId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeProjectOutput) SetStatus(v *ProjectStatus) *DescribeProjectOutput {
	s.Status = v
	return s
}

type DescribeUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserProfileInput"}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserArn sets the UserArn field's value.
func (s *DescribeUserProfileInput) SetUserArn(v string) *DescribeUserProfileInput {
	s.UserArn = &v
	return s
}

type DescribeUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the user profile was created in AWS CodeStar, in timestamp
	// format.
	//
	// CreatedTimestamp is a required field
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp" required:"true"`

	// The display name shown for the user in AWS CodeStar projects. For example,
	// this could be set to both first and last name ("Mary Major") or a single
	// name ("Mary"). The display name is also used to generate the initial icon
	// associated with the user in AWS CodeStar projects. If spaces are included
	// in the display name, the first character that appears after the space will
	// be used as the second character in the user initial icon. The initial icon
	// displays a maximum of two characters, so a display name with more than one
	// space (for example "Mary Jane Major") would generate an initial icon using
	// the first character and the first character after the space ("MJ", not "MM").
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address for the user. Optional.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The date and time when the user profile was last modified, in timestamp format.
	//
	// LastModifiedTimestamp is a required field
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp" required:"true"`

	// The SSH public key associated with the user. This SSH public key is associated
	// with the user profile, and can be used in conjunction with the associated
	// private key for access to project resources, such as Amazon EC2 instances,
	// if a project owner grants remote access to those resources.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfileOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DescribeUserProfileOutput) SetCreatedTimestamp(v time.Time) *DescribeUserProfileOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeUserProfileOutput) SetDisplayName(v string) *DescribeUserProfileOutput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *DescribeUserProfileOutput) SetEmailAddress(v string) *DescribeUserProfileOutput {
	s.EmailAddress = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *DescribeUserProfileOutput) SetLastModifiedTimestamp(v time.Time) *DescribeUserProfileOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *DescribeUserProfileOutput) SetSshPublicKey(v string) *DescribeUserProfileOutput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DescribeUserProfileOutput) SetUserArn(v string) *DescribeUserProfileOutput {
	s.UserArn = &v
	return s
}

type DisassociateTeamMemberInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS CodeStar project from which you want to remove a team member.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM user or group whom you want to
	// remove from the project.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateTeamMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTeamMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTeamMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateTeamMemberInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *DisassociateTeamMemberInput) SetProjectId(v string) *DisassociateTeamMemberInput {
	s.ProjectId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DisassociateTeamMemberInput) SetUserArn(v string) *DisassociateTeamMemberInput {
	s.UserArn = &v
	return s
}

type DisassociateTeamMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateTeamMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTeamMemberOutput) GoString() string {
	return s.String()
}

// Information about the GitHub repository to be created in AWS CodeStar. This
// is where the source code files provided with the project request will be
// uploaded after project creation.
type GitHubCodeDestination struct {
	_ struct{} `type:"structure"`

	// Description for the GitHub repository to be created in AWS CodeStar. This
	// description displays in GitHub after the repository is created.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether to enable issues for the GitHub repository.
	//
	// IssuesEnabled is a required field
	IssuesEnabled *bool `locationName:"issuesEnabled" type:"boolean" required:"true"`

	// Name of the GitHub repository to be created in AWS CodeStar.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The GitHub username for the owner of the GitHub repository to be created
	// in AWS CodeStar. If this repository should be owned by a GitHub organization,
	// provide its name.
	//
	// Owner is a required field
	Owner *string `locationName:"owner" min:"1" type:"string" required:"true"`

	// Whether the GitHub repository is to be a private repository.
	//
	// PrivateRepository is a required field
	PrivateRepository *bool `locationName:"privateRepository" type:"boolean" required:"true"`

	// The GitHub user's personal access token for the GitHub repository.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"1" type:"string" required:"true" sensitive:"true"`

	// The type of GitHub repository to be created in AWS CodeStar. Valid values
	// are User or Organization.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s GitHubCodeDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GitHubCodeDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitHubCodeDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GitHubCodeDestination"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.IssuesEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("IssuesEnabled"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Owner != nil && len(*s.Owner) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Owner", 1))
	}
	if s.PrivateRepository == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateRepository"))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}
	if s.Token != nil && len(*s.Token) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Token", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *GitHubCodeDestination) SetDescription(v string) *GitHubCodeDestination {
	s.Description = &v
	return s
}

// SetIssuesEnabled sets the IssuesEnabled field's value.
func (s *GitHubCodeDestination) SetIssuesEnabled(v bool) *GitHubCodeDestination {
	s.IssuesEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *GitHubCodeDestination) SetName(v string) *GitHubCodeDestination {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GitHubCodeDestination) SetOwner(v string) *GitHubCodeDestination {
	s.Owner = &v
	return s
}

// SetPrivateRepository sets the PrivateRepository field's value.
func (s *GitHubCodeDestination) SetPrivateRepository(v bool) *GitHubCodeDestination {
	s.PrivateRepository = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GitHubCodeDestination) SetToken(v string) *GitHubCodeDestination {
	s.Token = &v
	return s
}

// SetType sets the Type field's value.
func (s *GitHubCodeDestination) SetType(v string) *GitHubCodeDestination {
	s.Type = &v
	return s
}

// The next token is not valid.
type InvalidNextTokenException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s InvalidNextTokenException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidNextTokenException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidNextTokenException) RequestID() string {
	return s.respMetadata.RequestID
}

// The service role is not valid.
type InvalidServiceRoleException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s InvalidServiceRoleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidServiceRoleException) GoString() string {
	return s.String()
}

func newErrorInvalidServiceRoleException(v protocol.ResponseMetadata) error {
	return &InvalidServiceRoleException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidServiceRoleException) Code() string {
	return "InvalidServiceRoleException"
}

// Message returns the exception's message.
func (s InvalidServiceRoleException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidServiceRoleException) OrigErr() error {
	return nil
}

func (s InvalidServiceRoleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidServiceRoleException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidServiceRoleException) RequestID() string {
	return s.respMetadata.RequestID
}

// A resource limit has been exceeded.
type LimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s LimitExceededException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s LimitExceededException) OrigErr() error {
	return nil
}

func (s LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s LimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s LimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of data that can be contained in a single set of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token to be used to return the next set of results, if the
	// results cannot be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of projects.
	//
	// Projects is a required field
	Projects []*ProjectSummary `locationName:"projects" type:"list" required:"true"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*ProjectSummary) *ListProjectsOutput {
	s.Projects = v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of data that can be contained in a single set of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListResourcesInput) SetProjectId(v string) *ListResourcesInput {
	s.ProjectId = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of resources associated with the project.
	Resources []*Resource `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourcesOutput) SetResources(v []*Resource) *ListResourcesOutput {
	s.Resources = v
	return s
}

type ListTagsForProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project to get tags for.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// Reserved for future use.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Reserved for future use.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListTagsForProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForProjectInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ListTagsForProjectInput) SetId(v string) *ListTagsForProjectInput {
	s.Id = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForProjectInput) SetMaxResults(v int64) *ListTagsForProjectInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForProjectInput) SetNextToken(v string) *ListTagsForProjectInput {
	s.NextToken = &v
	return s
}

type ListTagsForProjectOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The tags for the project.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForProjectOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForProjectOutput) SetNextToken(v string) *ListTagsForProjectOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForProjectOutput) SetTags(v map[string]*string) *ListTagsForProjectOutput {
	s.Tags = v
	return s
}

type ListTeamMembersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of team members you want returned in a response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project for which you want to list team members.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTeamMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTeamMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTeamMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTeamMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTeamMembersInput) SetMaxResults(v int64) *ListTeamMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTeamMembersInput) SetNextToken(v string) *ListTeamMembersInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListTeamMembersInput) SetProjectId(v string) *ListTeamMembersInput {
	s.ProjectId = &v
	return s
}

type ListTeamMembersOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of team member objects for the project.
	//
	// TeamMembers is a required field
	TeamMembers []*TeamMember `locationName:"teamMembers" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTeamMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTeamMembersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTeamMembersOutput) SetNextToken(v string) *ListTeamMembersOutput {
	s.NextToken = &v
	return s
}

// SetTeamMembers sets the TeamMembers field's value.
func (s *ListTeamMembersOutput) SetTeamMembers(v []*TeamMember) *ListTeamMembersOutput {
	s.TeamMembers = v
	return s
}

type ListUserProfilesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListUserProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserProfilesInput) SetMaxResults(v int64) *ListUserProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserProfilesInput) SetNextToken(v string) *ListUserProfilesInput {
	s.NextToken = &v
	return s
}

type ListUserProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// All the user profiles configured in AWS CodeStar for an AWS account.
	//
	// UserProfiles is a required field
	UserProfiles []*UserProfileSummary `locationName:"userProfiles" type:"list" required:"true"`
}

// String returns the string representation
func (s ListUserProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserProfilesOutput) SetNextToken(v string) *ListUserProfilesOutput {
	s.NextToken = &v
	return s
}

// SetUserProfiles sets the UserProfiles field's value.
func (s *ListUserProfilesOutput) SetUserProfiles(v []*UserProfileSummary) *ListUserProfilesOutput {
	s.UserProfiles = v
	return s
}

// An AWS CodeStar project with the same ID already exists in this region for
// the AWS account. AWS CodeStar project IDs must be unique within a region
// for the AWS account.
type ProjectAlreadyExistsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s ProjectAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorProjectAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ProjectAlreadyExistsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ProjectAlreadyExistsException) Code() string {
	return "ProjectAlreadyExistsException"
}

// Message returns the exception's message.
func (s ProjectAlreadyExistsException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ProjectAlreadyExistsException) OrigErr() error {
	return nil
}

func (s ProjectAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ProjectAlreadyExistsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ProjectAlreadyExistsException) RequestID() string {
	return s.respMetadata.RequestID
}

// Project configuration information is required but not specified.
type ProjectConfigurationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s ProjectConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectConfigurationException) GoString() string {
	return s.String()
}

func newErrorProjectConfigurationException(v protocol.ResponseMetadata) error {
	return &ProjectConfigurationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ProjectConfigurationException) Code() string {
	return "ProjectConfigurationException"
}

// Message returns the exception's message.
func (s ProjectConfigurationException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ProjectConfigurationException) OrigErr() error {
	return nil
}

func (s ProjectConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ProjectConfigurationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ProjectConfigurationException) RequestID() string {
	return s.respMetadata.RequestID
}

// The project creation request was valid, but a nonspecific exception or error
// occurred during project creation. The project could not be created in AWS
// CodeStar.
type ProjectCreationFailedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s ProjectCreationFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectCreationFailedException) GoString() string {
	return s.String()
}

func newErrorProjectCreationFailedException(v protocol.ResponseMetadata) error {
	return &ProjectCreationFailedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ProjectCreationFailedException) Code() string {
	return "ProjectCreationFailedException"
}

// Message returns the exception's message.
func (s ProjectCreationFailedException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ProjectCreationFailedException) OrigErr() error {
	return nil
}

func (s ProjectCreationFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ProjectCreationFailedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ProjectCreationFailedException) RequestID() string {
	return s.respMetadata.RequestID
}

// The specified AWS CodeStar project was not found.
type ProjectNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s ProjectNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectNotFoundException) GoString() string {
	return s.String()
}

func newErrorProjectNotFoundException(v protocol.ResponseMetadata) error {
	return &ProjectNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ProjectNotFoundException) Code() string {
	return "ProjectNotFoundException"
}

// Message returns the exception's message.
func (s ProjectNotFoundException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ProjectNotFoundException) OrigErr() error {
	return nil
}

func (s ProjectNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ProjectNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ProjectNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// An indication of whether a project creation or deletion is failed or successful.
type ProjectStatus struct {
	_ struct{} `type:"structure"`

	// In the case of a project creation or deletion failure, a reason for the failure.
	Reason *string `locationName:"reason" type:"string"`

	// The phase of completion for a project creation or deletion.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectStatus) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ProjectStatus) SetReason(v string) *ProjectStatus {
	s.Reason = &v
	return s
}

// SetState sets the State field's value.
func (s *ProjectStatus) SetState(v string) *ProjectStatus {
	s.State = &v
	return s
}

// Information about the metadata for a project.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string `locationName:"projectArn" type:"string"`

	// The ID of the project.
	ProjectId *string `locationName:"projectId" min:"2" type:"string"`
}

// String returns the string representation
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ProjectSummary) SetProjectArn(v string) *ProjectSummary {
	s.ProjectArn = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ProjectSummary) SetProjectId(v string) *ProjectSummary {
	s.ProjectId = &v
	return s
}

// Information about a resource for a project.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"11" type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// The Amazon S3 location where the source code files provided with the project
// request are stored.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 object key where the source code files provided with the project
	// request are stored.
	BucketKey *string `locationName:"bucketKey" type:"string"`

	// The Amazon S3 bucket name where the source code files provided with the project
	// request are stored.
	BucketName *string `locationName:"bucketName" min:"3" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketKey sets the BucketKey field's value.
func (s *S3Location) SetBucketKey(v string) *S3Location {
	s.BucketKey = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *S3Location) SetBucketName(v string) *S3Location {
	s.BucketName = &v
	return s
}

type TagProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project you want to add a tag to.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// The tags you want to add to the project.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagProjectInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *TagProjectInput) SetId(v string) *TagProjectInput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagProjectInput) SetTags(v map[string]*string) *TagProjectInput {
	s.Tags = v
	return s
}

type TagProjectOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the project.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s TagProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagProjectOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *TagProjectOutput) SetTags(v map[string]*string) *TagProjectOutput {
	s.Tags = v
	return s
}

// Information about a team member in a project.
type TeamMember struct {
	_ struct{} `type:"structure"`

	// The role assigned to the user in the project. Project roles have different
	// levels of access. For more information, see Working with Teams (http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html)
	// in the AWS CodeStar User Guide.
	//
	// ProjectRole is a required field
	ProjectRole *string `locationName:"projectRole" type:"string" required:"true"`

	// Whether the user is allowed to remotely access project resources using an
	// SSH public/private key pair.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s TeamMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeamMember) GoString() string {
	return s.String()
}

// SetProjectRole sets the ProjectRole field's value.
func (s *TeamMember) SetProjectRole(v string) *TeamMember {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *TeamMember) SetRemoteAccessAllowed(v bool) *TeamMember {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *TeamMember) SetUserArn(v string) *TeamMember {
	s.UserArn = &v
	return s
}

// The team member is already associated with a role in this project.
type TeamMemberAlreadyAssociatedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s TeamMemberAlreadyAssociatedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeamMemberAlreadyAssociatedException) GoString() string {
	return s.String()
}

func newErrorTeamMemberAlreadyAssociatedException(v protocol.ResponseMetadata) error {
	return &TeamMemberAlreadyAssociatedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TeamMemberAlreadyAssociatedException) Code() string {
	return "TeamMemberAlreadyAssociatedException"
}

// Message returns the exception's message.
func (s TeamMemberAlreadyAssociatedException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TeamMemberAlreadyAssociatedException) OrigErr() error {
	return nil
}

func (s TeamMemberAlreadyAssociatedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s TeamMemberAlreadyAssociatedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TeamMemberAlreadyAssociatedException) RequestID() string {
	return s.respMetadata.RequestID
}

// The specified team member was not found.
type TeamMemberNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s TeamMemberNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeamMemberNotFoundException) GoString() string {
	return s.String()
}

func newErrorTeamMemberNotFoundException(v protocol.ResponseMetadata) error {
	return &TeamMemberNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TeamMemberNotFoundException) Code() string {
	return "TeamMemberNotFoundException"
}

// Message returns the exception's message.
func (s TeamMemberNotFoundException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TeamMemberNotFoundException) OrigErr() error {
	return nil
}

func (s TeamMemberNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s TeamMemberNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TeamMemberNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// The toolchain template file provided with the project request. AWS CodeStar
// uses the template to provision the toolchain stack in AWS CloudFormation.
type Toolchain struct {
	_ struct{} `type:"structure"`

	// The service role ARN for AWS CodeStar to use for the toolchain template during
	// stack provisioning.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The Amazon S3 location where the toolchain template file provided with the
	// project request is stored. AWS CodeStar retrieves the file during project
	// creation.
	//
	// Source is a required field
	Source *ToolchainSource `locationName:"source" type:"structure" required:"true"`

	// The list of parameter overrides to be passed into the toolchain template
	// during stack provisioning, if any.
	StackParameters map[string]*string `locationName:"stackParameters" type:"map"`
}

// String returns the string representation
func (s Toolchain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Toolchain) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Toolchain) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Toolchain"}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *Toolchain) SetRoleArn(v string) *Toolchain {
	s.RoleArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Toolchain) SetSource(v *ToolchainSource) *Toolchain {
	s.Source = v
	return s
}

// SetStackParameters sets the StackParameters field's value.
func (s *Toolchain) SetStackParameters(v map[string]*string) *Toolchain {
	s.StackParameters = v
	return s
}

// The Amazon S3 location where the toolchain template file provided with the
// project request is stored. AWS CodeStar retrieves the file during project
// creation.
type ToolchainSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the toolchain template file provided with the
	// project request is stored.
	//
	// S3 is a required field
	S3 *S3Location `locationName:"s3" type:"structure" required:"true"`
}

// String returns the string representation
func (s ToolchainSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ToolchainSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ToolchainSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ToolchainSource"}
	if s.S3 == nil {
		invalidParams.Add(request.NewErrParamRequired("S3"))
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *ToolchainSource) SetS3(v *S3Location) *ToolchainSource {
	s.S3 = v
	return s
}

type UntagProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project to remove tags from.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// The tags to remove from the project.
	//
	// Tags is a required field
	Tags []*string `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagProjectInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UntagProjectInput) SetId(v string) *UntagProjectInput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UntagProjectInput) SetTags(v []*string) *UntagProjectInput {
	s.Tags = v
	return s
}

type UntagProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagProjectOutput) GoString() string {
	return s.String()
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// The description of the project, if any.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the project you want to update.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// The name of the project you want to update.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateProjectInput) SetDescription(v string) *UpdateProjectInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateProjectInput) SetId(v string) *UpdateProjectInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProjectInput) SetName(v string) *UpdateProjectInput {
	s.Name = &v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

type UpdateTeamMemberInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`

	// The role assigned to the user in the project. Project roles have different
	// levels of access. For more information, see Working with Teams (http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html)
	// in the AWS CodeStar User Guide.
	ProjectRole *string `locationName:"projectRole" type:"string"`

	// Whether a team member is allowed to remotely access project resources using
	// the SSH public key associated with the user's profile. Even if this is set
	// to True, the user must associate a public key with their profile before the
	// user can access resources.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user for whom you want to change team
	// membership attributes.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTeamMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTeamMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTeamMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTeamMemberInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *UpdateTeamMemberInput) SetProjectId(v string) *UpdateTeamMemberInput {
	s.ProjectId = &v
	return s
}

// SetProjectRole sets the ProjectRole field's value.
func (s *UpdateTeamMemberInput) SetProjectRole(v string) *UpdateTeamMemberInput {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *UpdateTeamMemberInput) SetRemoteAccessAllowed(v bool) *UpdateTeamMemberInput {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateTeamMemberInput) SetUserArn(v string) *UpdateTeamMemberInput {
	s.UserArn = &v
	return s
}

type UpdateTeamMemberOutput struct {
	_ struct{} `type:"structure"`

	// The project role granted to the user.
	ProjectRole *string `locationName:"projectRole" type:"string"`

	// Whether a team member is allowed to remotely access project resources using
	// the SSH public key associated with the user's profile.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user whose team membership attributes
	// were updated.
	UserArn *string `locationName:"userArn" min:"32" type:"string"`
}

// String returns the string representation
func (s UpdateTeamMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTeamMemberOutput) GoString() string {
	return s.String()
}

// SetProjectRole sets the ProjectRole field's value.
func (s *UpdateTeamMemberOutput) SetProjectRole(v string) *UpdateTeamMemberOutput {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *UpdateTeamMemberOutput) SetRemoteAccessAllowed(v bool) *UpdateTeamMemberOutput {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateTeamMemberOutput) SetUserArn(v string) *UpdateTeamMemberOutput {
	s.UserArn = &v
	return s
}

type UpdateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The name that will be displayed as the friendly name for the user in AWS
	// CodeStar.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserProfileInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 3))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateUserProfileInput) SetDisplayName(v string) *UpdateUserProfileInput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UpdateUserProfileInput) SetEmailAddress(v string) *UpdateUserProfileInput {
	s.EmailAddress = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UpdateUserProfileInput) SetSshPublicKey(v string) *UpdateUserProfileInput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateUserProfileInput) SetUserArn(v string) *UpdateUserProfileInput {
	s.UserArn = &v
	return s
}

type UpdateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date the user profile was created, in timestamp format.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The date the user profile was last modified, in timestamp format.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The SSH public key associated with the user in AWS CodeStar. This is the
	// public portion of the public/private keypair the user can use to access project
	// resources if a project owner allows the user remote access to those resources.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *UpdateUserProfileOutput) SetCreatedTimestamp(v time.Time) *UpdateUserProfileOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateUserProfileOutput) SetDisplayName(v string) *UpdateUserProfileOutput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UpdateUserProfileOutput) SetEmailAddress(v string) *UpdateUserProfileOutput {
	s.EmailAddress = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *UpdateUserProfileOutput) SetLastModifiedTimestamp(v time.Time) *UpdateUserProfileOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UpdateUserProfileOutput) SetSshPublicKey(v string) *UpdateUserProfileOutput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateUserProfileOutput) SetUserArn(v string) *UpdateUserProfileOutput {
	s.UserArn = &v
	return s
}

// A user profile with that name already exists in this region for the AWS account.
// AWS CodeStar user profile names must be unique within a region for the AWS
// account.
type UserProfileAlreadyExistsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s UserProfileAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserProfileAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorUserProfileAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &UserProfileAlreadyExistsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s UserProfileAlreadyExistsException) Code() string {
	return "UserProfileAlreadyExistsException"
}

// Message returns the exception's message.
func (s UserProfileAlreadyExistsException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s UserProfileAlreadyExistsException) OrigErr() error {
	return nil
}

func (s UserProfileAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s UserProfileAlreadyExistsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s UserProfileAlreadyExistsException) RequestID() string {
	return s.respMetadata.RequestID
}

// The user profile was not found.
type UserProfileNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s UserProfileNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserProfileNotFoundException) GoString() string {
	return s.String()
}

func newErrorUserProfileNotFoundException(v protocol.ResponseMetadata) error {
	return &UserProfileNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s UserProfileNotFoundException) Code() string {
	return "UserProfileNotFoundException"
}

// Message returns the exception's message.
func (s UserProfileNotFoundException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s UserProfileNotFoundException) OrigErr() error {
	return nil
}

func (s UserProfileNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s UserProfileNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s UserProfileNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// Information about a user's profile in AWS CodeStar.
type UserProfileSummary struct {
	_ struct{} `type:"structure"`

	// The display name of a user in AWS CodeStar. For example, this could be set
	// to both first and last name ("Mary Major") or a single name ("Mary"). The
	// display name is also used to generate the initial icon associated with the
	// user in AWS CodeStar projects. If spaces are included in the display name,
	// the first character that appears after the space will be used as the second
	// character in the user initial icon. The initial icon displays a maximum of
	// two characters, so a display name with more than one space (for example "Mary
	// Jane Major") would generate an initial icon using the first character and
	// the first character after the space ("MJ", not "MM").
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address associated with the user.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	UserArn *string `locationName:"userArn" min:"32" type:"string"`
}

// String returns the string representation
func (s UserProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserProfileSummary) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *UserProfileSummary) SetDisplayName(v string) *UserProfileSummary {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UserProfileSummary) SetEmailAddress(v string) *UserProfileSummary {
	s.EmailAddress = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UserProfileSummary) SetSshPublicKey(v string) *UserProfileSummary {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UserProfileSummary) SetUserArn(v string) *UserProfileSummary {
	s.UserArn = &v
	return s
}

// The specified input is either not valid, or it could not be validated.
type ValidationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s ValidationException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ValidationException) OrigErr() error {
	return nil
}

func (s ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ValidationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ValidationException) RequestID() string {
	return s.respMetadata.RequestID
}
