// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opAssociateRepository = "AssociateRepository"

// AssociateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateRepository for more information on using the AssociateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateRepositoryRequest method.
//    req, resp := client.AssociateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/AssociateRepository
func (c *CodeGuruReviewer) AssociateRepositoryRequest(input *AssociateRepositoryInput) (req *request.Request, output *AssociateRepositoryOutput) {
	op := &request.Operation{
		Name:       opAssociateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/associations",
	}

	if input == nil {
		input = &AssociateRepositoryInput{}
	}

	output = &AssociateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateRepository API operation for Amazon CodeGuru Reviewer.
//
// Associates an AWS CodeCommit repository with Amazon CodeGuru Reviewer. When
// you associate an AWS CodeCommit repository with Amazon CodeGuru Reviewer,
// Amazon CodeGuru Reviewer will provide recommendations for each pull request.
// You can view recommendations in the AWS CodeCommit repository.
//
// You can associate a GitHub repository using the Amazon CodeGuru Reviewer
// console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation AssociateRepository for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/AssociateRepository
func (c *CodeGuruReviewer) AssociateRepository(input *AssociateRepositoryInput) (*AssociateRepositoryOutput, error) {
	req, out := c.AssociateRepositoryRequest(input)
	return out, req.Send()
}

// AssociateRepositoryWithContext is the same as AssociateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) AssociateRepositoryWithContext(ctx aws.Context, input *AssociateRepositoryInput, opts ...request.Option) (*AssociateRepositoryOutput, error) {
	req, out := c.AssociateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRepositoryAssociation = "DescribeRepositoryAssociation"

// DescribeRepositoryAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRepositoryAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRepositoryAssociation for more information on using the DescribeRepositoryAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRepositoryAssociationRequest method.
//    req, resp := client.DescribeRepositoryAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRepositoryAssociation
func (c *CodeGuruReviewer) DescribeRepositoryAssociationRequest(input *DescribeRepositoryAssociationInput) (req *request.Request, output *DescribeRepositoryAssociationOutput) {
	op := &request.Operation{
		Name:       opDescribeRepositoryAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/associations/{AssociationArn}",
	}

	if input == nil {
		input = &DescribeRepositoryAssociationInput{}
	}

	output = &DescribeRepositoryAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRepositoryAssociation API operation for Amazon CodeGuru Reviewer.
//
// Describes a repository association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation DescribeRepositoryAssociation for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRepositoryAssociation
func (c *CodeGuruReviewer) DescribeRepositoryAssociation(input *DescribeRepositoryAssociationInput) (*DescribeRepositoryAssociationOutput, error) {
	req, out := c.DescribeRepositoryAssociationRequest(input)
	return out, req.Send()
}

// DescribeRepositoryAssociationWithContext is the same as DescribeRepositoryAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRepositoryAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) DescribeRepositoryAssociationWithContext(ctx aws.Context, input *DescribeRepositoryAssociationInput, opts ...request.Option) (*DescribeRepositoryAssociationOutput, error) {
	req, out := c.DescribeRepositoryAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateRepository = "DisassociateRepository"

// DisassociateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateRepository for more information on using the DisassociateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateRepositoryRequest method.
//    req, resp := client.DisassociateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DisassociateRepository
func (c *CodeGuruReviewer) DisassociateRepositoryRequest(input *DisassociateRepositoryInput) (req *request.Request, output *DisassociateRepositoryOutput) {
	op := &request.Operation{
		Name:       opDisassociateRepository,
		HTTPMethod: "DELETE",
		HTTPPath:   "/associations/{AssociationArn}",
	}

	if input == nil {
		input = &DisassociateRepositoryInput{}
	}

	output = &DisassociateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateRepository API operation for Amazon CodeGuru Reviewer.
//
// Removes the association between Amazon CodeGuru Reviewer and a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation DisassociateRepository for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DisassociateRepository
func (c *CodeGuruReviewer) DisassociateRepository(input *DisassociateRepositoryInput) (*DisassociateRepositoryOutput, error) {
	req, out := c.DisassociateRepositoryRequest(input)
	return out, req.Send()
}

// DisassociateRepositoryWithContext is the same as DisassociateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) DisassociateRepositoryWithContext(ctx aws.Context, input *DisassociateRepositoryInput, opts ...request.Option) (*DisassociateRepositoryOutput, error) {
	req, out := c.DisassociateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRepositoryAssociations = "ListRepositoryAssociations"

// ListRepositoryAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositoryAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositoryAssociations for more information on using the ListRepositoryAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRepositoryAssociationsRequest method.
//    req, resp := client.ListRepositoryAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRepositoryAssociations
func (c *CodeGuruReviewer) ListRepositoryAssociationsRequest(input *ListRepositoryAssociationsInput) (req *request.Request, output *ListRepositoryAssociationsOutput) {
	op := &request.Operation{
		Name:       opListRepositoryAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoryAssociationsInput{}
	}

	output = &ListRepositoryAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositoryAssociations API operation for Amazon CodeGuru Reviewer.
//
// Lists repository associations. You can optionally filter on one or more of
// the following recommendation properties: provider types, states, names, and
// owners.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Reviewer's
// API operation ListRepositoryAssociations for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The input fails to satisfy the specified constraints.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRepositoryAssociations
func (c *CodeGuruReviewer) ListRepositoryAssociations(input *ListRepositoryAssociationsInput) (*ListRepositoryAssociationsOutput, error) {
	req, out := c.ListRepositoryAssociationsRequest(input)
	return out, req.Send()
}

// ListRepositoryAssociationsWithContext is the same as ListRepositoryAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositoryAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRepositoryAssociationsWithContext(ctx aws.Context, input *ListRepositoryAssociationsInput, opts ...request.Option) (*ListRepositoryAssociationsOutput, error) {
	req, out := c.ListRepositoryAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoryAssociationsPages iterates over the pages of a ListRepositoryAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositoryAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRepositoryAssociations operation.
//    pageNum := 0
//    err := client.ListRepositoryAssociationsPages(params,
//        func(page *codegurureviewer.ListRepositoryAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeGuruReviewer) ListRepositoryAssociationsPages(input *ListRepositoryAssociationsInput, fn func(*ListRepositoryAssociationsOutput, bool) bool) error {
	return c.ListRepositoryAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoryAssociationsPagesWithContext same as ListRepositoryAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruReviewer) ListRepositoryAssociationsPagesWithContext(ctx aws.Context, input *ListRepositoryAssociationsInput, fn func(*ListRepositoryAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoryAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoryAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRepositoryAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AccessDeniedException) OrigErr() error {
	return nil
}

func (s AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s AccessDeniedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AccessDeniedException) RequestID() string {
	return s.respMetadata.RequestID
}

type AssociateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	//
	// If you want to add a new repository association, this parameter specifies
	// a unique identifier for the new repository association that helps ensure
	// idempotency.
	//
	// If you use the AWS CLI or one of the AWS SDK to call this operation, then
	// you can leave this parameter empty. The CLI or SDK generates a random UUID
	// for you and includes that in the request. If you don't use the SDK and instead
	// generate a raw HTTP request to the Secrets Manager service endpoint, then
	// you must generate a ClientRequestToken yourself for new versions and include
	// that value in the request.
	//
	// You typically only need to interact with this value if you implement your
	// own retry logic and want to ensure that a given repository association is
	// not created twice. We recommend that you generate a UUID-type value to ensure
	// uniqueness within the specified repository association.
	//
	// Amazon CodeGuru Reviewer uses this value to prevent the accidental creation
	// of duplicate repository associations if there are failures and retries.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The repository to associate.
	//
	// Repository is a required field
	Repository *Repository `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateRepositoryInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil {
		if err := s.Repository.Validate(); err != nil {
			invalidParams.AddNested("Repository", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateRepositoryInput) SetClientRequestToken(v string) *AssociateRepositoryInput {
	s.ClientRequestToken = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *AssociateRepositoryInput) SetRepository(v *Repository) *AssociateRepositoryInput {
	s.Repository = v
	return s
}

type AssociateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository association.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`
}

// String returns the string representation
func (s AssociateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryAssociation sets the RepositoryAssociation field's value.
func (s *AssociateRepositoryOutput) SetRepositoryAssociation(v *RepositoryAssociation) *AssociateRepositoryOutput {
	s.RepositoryAssociation = v
	return s
}

// Information about an AWS CodeCommit repository.
type CodeCommitRepository struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeCommit repository.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeCommitRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeCommitRepository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeCommitRepository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeCommitRepository"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CodeCommitRepository) SetName(v string) *CodeCommitRepository {
	s.Name = &v
	return s
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request.
type ConflictException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConflictException) OrigErr() error {
	return nil
}

func (s ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConflictException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConflictException) RequestID() string {
	return s.respMetadata.RequestID
}

type DescribeRepositoryAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the association.
	//
	// AssociationArn is a required field
	AssociationArn *string `location:"uri" locationName:"AssociationArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRepositoryAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoryAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRepositoryAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRepositoryAssociationInput"}
	if s.AssociationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationArn"))
	}
	if s.AssociationArn != nil && len(*s.AssociationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *DescribeRepositoryAssociationInput) SetAssociationArn(v string) *DescribeRepositoryAssociationInput {
	s.AssociationArn = &v
	return s
}

type DescribeRepositoryAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository association.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`
}

// String returns the string representation
func (s DescribeRepositoryAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoryAssociationOutput) GoString() string {
	return s.String()
}

// SetRepositoryAssociation sets the RepositoryAssociation field's value.
func (s *DescribeRepositoryAssociationOutput) SetRepositoryAssociation(v *RepositoryAssociation) *DescribeRepositoryAssociationOutput {
	s.RepositoryAssociation = v
	return s
}

type DisassociateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the association.
	//
	// AssociationArn is a required field
	AssociationArn *string `location:"uri" locationName:"AssociationArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateRepositoryInput"}
	if s.AssociationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationArn"))
	}
	if s.AssociationArn != nil && len(*s.AssociationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *DisassociateRepositoryInput) SetAssociationArn(v string) *DisassociateRepositoryInput {
	s.AssociationArn = &v
	return s
}

type DisassociateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the disassociated repository.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`
}

// String returns the string representation
func (s DisassociateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryAssociation sets the RepositoryAssociation field's value.
func (s *DisassociateRepositoryOutput) SetRepositoryAssociation(v *RepositoryAssociation) *DisassociateRepositoryOutput {
	s.RepositoryAssociation = v
	return s
}

// The server encountered an internal error and is unable to complete the request.
type InternalServerException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalServerException) OrigErr() error {
	return nil
}

func (s InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalServerException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalServerException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListRepositoryAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository association results returned by ListRepositoryAssociations
	// in paginated output. When this parameter is used, ListRepositoryAssociations
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListRepositoryAssociations request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter is not used, then
	// ListRepositoryAssociations returns up to 100 results and a nextToken value
	// if applicable.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// List of names to use as a filter.
	Names []*string `location:"querystring" locationName:"Name" min:"1" type:"list"`

	// The nextToken value returned from a previous paginated ListRepositoryAssociations
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// List of owners to use as a filter. For AWS CodeCommit, the owner is the AWS
	// account id. For GitHub, it is the GitHub account name.
	Owners []*string `location:"querystring" locationName:"Owner" min:"1" type:"list"`

	// List of provider types to use as a filter.
	ProviderTypes []*string `location:"querystring" locationName:"ProviderType" min:"1" type:"list"`

	// List of states to use as a filter.
	States []*string `location:"querystring" locationName:"State" min:"1" type:"list"`
}

// String returns the string representation
func (s ListRepositoryAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoryAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoryAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositoryAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Owners != nil && len(s.Owners) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Owners", 1))
	}
	if s.ProviderTypes != nil && len(s.ProviderTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderTypes", 1))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("States", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRepositoryAssociationsInput) SetMaxResults(v int64) *ListRepositoryAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ListRepositoryAssociationsInput) SetNames(v []*string) *ListRepositoryAssociationsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoryAssociationsInput) SetNextToken(v string) *ListRepositoryAssociationsInput {
	s.NextToken = &v
	return s
}

// SetOwners sets the Owners field's value.
func (s *ListRepositoryAssociationsInput) SetOwners(v []*string) *ListRepositoryAssociationsInput {
	s.Owners = v
	return s
}

// SetProviderTypes sets the ProviderTypes field's value.
func (s *ListRepositoryAssociationsInput) SetProviderTypes(v []*string) *ListRepositoryAssociationsInput {
	s.ProviderTypes = v
	return s
}

// SetStates sets the States field's value.
func (s *ListRepositoryAssociationsInput) SetStates(v []*string) *ListRepositoryAssociationsInput {
	s.States = v
	return s
}

type ListRepositoryAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListRecommendations request. When
	// the results of a ListRecommendations request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// A list of repository associations that meet the criteria of the request.
	RepositoryAssociationSummaries []*RepositoryAssociationSummary `type:"list"`
}

// String returns the string representation
func (s ListRepositoryAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoryAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoryAssociationsOutput) SetNextToken(v string) *ListRepositoryAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetRepositoryAssociationSummaries sets the RepositoryAssociationSummaries field's value.
func (s *ListRepositoryAssociationsOutput) SetRepositoryAssociationSummaries(v []*RepositoryAssociationSummary) *ListRepositoryAssociationsOutput {
	s.RepositoryAssociationSummaries = v
	return s
}

// The resource specified in the request was not found.
type NotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s NotFoundException) OrigErr() error {
	return nil
}

func (s NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s NotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s NotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// Information about a repository.
type Repository struct {
	_ struct{} `type:"structure"`

	// Information about an AWS CodeCommit repository.
	CodeCommit *CodeCommitRepository `type:"structure"`
}

// String returns the string representation
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Repository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Repository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Repository"}
	if s.CodeCommit != nil {
		if err := s.CodeCommit.Validate(); err != nil {
			invalidParams.AddNested("CodeCommit", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeCommit sets the CodeCommit field's value.
func (s *Repository) SetCodeCommit(v *CodeCommitRepository) *Repository {
	s.CodeCommit = v
	return s
}

// Information about a repository association.
type RepositoryAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the repository association.
	AssociationArn *string `min:"1" type:"string"`

	// The id of the repository association.
	AssociationId *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the repository association
	// was created.
	CreatedTimeStamp *time.Time `type:"timestamp"`

	// The time, in milliseconds since the epoch, when the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository.
	Name *string `min:"1" type:"string"`

	// The owner of the repository.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The state of the repository association.
	State *string `type:"string" enum:"RepositoryAssociationState"`

	// A description of why the repository association is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation
func (s RepositoryAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryAssociation) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *RepositoryAssociation) SetAssociationArn(v string) *RepositoryAssociation {
	s.AssociationArn = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *RepositoryAssociation) SetAssociationId(v string) *RepositoryAssociation {
	s.AssociationId = &v
	return s
}

// SetCreatedTimeStamp sets the CreatedTimeStamp field's value.
func (s *RepositoryAssociation) SetCreatedTimeStamp(v time.Time) *RepositoryAssociation {
	s.CreatedTimeStamp = &v
	return s
}

// SetLastUpdatedTimeStamp sets the LastUpdatedTimeStamp field's value.
func (s *RepositoryAssociation) SetLastUpdatedTimeStamp(v time.Time) *RepositoryAssociation {
	s.LastUpdatedTimeStamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryAssociation) SetName(v string) *RepositoryAssociation {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *RepositoryAssociation) SetOwner(v string) *RepositoryAssociation {
	s.Owner = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *RepositoryAssociation) SetProviderType(v string) *RepositoryAssociation {
	s.ProviderType = &v
	return s
}

// SetState sets the State field's value.
func (s *RepositoryAssociation) SetState(v string) *RepositoryAssociation {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *RepositoryAssociation) SetStateReason(v string) *RepositoryAssociation {
	s.StateReason = &v
	return s
}

// Information about a repository association.
type RepositoryAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the repository association.
	AssociationArn *string `min:"1" type:"string"`

	// The repository association ID.
	AssociationId *string `min:"1" type:"string"`

	// The time, in milliseconds since the epoch, since the repository association
	// was last updated.
	LastUpdatedTimeStamp *time.Time `type:"timestamp"`

	// The name of the repository association.
	Name *string `min:"1" type:"string"`

	// The owner of the repository association.
	Owner *string `min:"1" type:"string"`

	// The provider type of the repository association.
	ProviderType *string `type:"string" enum:"ProviderType"`

	// The state of the repository association.
	//
	// Associated
	//
	// Amazon CodeGuru Reviewer is associated with the repository.
	//
	// Associating
	//
	// The association is in progress.
	//
	// Failed
	//
	// The association failed. For more information about troubleshooting (or why
	// it failed), see [troubleshooting topic].
	//
	// Disassociating
	//
	// Amazon CodeGuru Reviewer is in the process of disassociating with the repository.
	State *string `type:"string" enum:"RepositoryAssociationState"`
}

// String returns the string representation
func (s RepositoryAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryAssociationSummary) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *RepositoryAssociationSummary) SetAssociationArn(v string) *RepositoryAssociationSummary {
	s.AssociationArn = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *RepositoryAssociationSummary) SetAssociationId(v string) *RepositoryAssociationSummary {
	s.AssociationId = &v
	return s
}

// SetLastUpdatedTimeStamp sets the LastUpdatedTimeStamp field's value.
func (s *RepositoryAssociationSummary) SetLastUpdatedTimeStamp(v time.Time) *RepositoryAssociationSummary {
	s.LastUpdatedTimeStamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryAssociationSummary) SetName(v string) *RepositoryAssociationSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *RepositoryAssociationSummary) SetOwner(v string) *RepositoryAssociationSummary {
	s.Owner = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *RepositoryAssociationSummary) SetProviderType(v string) *RepositoryAssociationSummary {
	s.ProviderType = &v
	return s
}

// SetState sets the State field's value.
func (s *RepositoryAssociationSummary) SetState(v string) *RepositoryAssociationSummary {
	s.State = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ThrottlingException) OrigErr() error {
	return nil
}

func (s ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ThrottlingException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ThrottlingException) RequestID() string {
	return s.respMetadata.RequestID
}

// The input fails to satisfy the specified constraints.
type ValidationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ValidationException) OrigErr() error {
	return nil
}

func (s ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ValidationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ValidationException) RequestID() string {
	return s.respMetadata.RequestID
}

const (
	// ProviderTypeCodeCommit is a ProviderType enum value
	ProviderTypeCodeCommit = "CodeCommit"

	// ProviderTypeGitHub is a ProviderType enum value
	ProviderTypeGitHub = "GitHub"
)

const (
	// RepositoryAssociationStateAssociated is a RepositoryAssociationState enum value
	RepositoryAssociationStateAssociated = "Associated"

	// RepositoryAssociationStateAssociating is a RepositoryAssociationState enum value
	RepositoryAssociationStateAssociating = "Associating"

	// RepositoryAssociationStateFailed is a RepositoryAssociationState enum value
	RepositoryAssociationStateFailed = "Failed"

	// RepositoryAssociationStateDisassociating is a RepositoryAssociationState enum value
	RepositoryAssociationStateDisassociating = "Disassociating"
)
