#!/bin/bash
source "$(dirname "${BASH_SOURCE}")/lib/init.sh"

SCRIPT_ROOT=$(dirname ${BASH_SOURCE})/..
CODEGEN_PKG=${CODEGEN_PKG:-$(cd ${SCRIPT_ROOT}; ls -d -1 ./vendor/k8s.io/code-generator 2>/dev/null || echo ../../../k8s.io/code-generator)}

go install ./${CODEGEN_PKG}/cmd/openapi-gen

function codegen::join() { local IFS="$1"; shift; echo "$*"; }

ORIGIN_PREFIX="${OS_GO_PACKAGE}/"

INPUT_DIRS=(
  # kube apis
  $(
    grep --color=never -rl '+k8s:openapi-gen=' vendor/k8s.io/kubernetes | \
    xargs -n1 dirname | \
    sed "s,^vendor/,," | \
    sort -u | \
    sed '/^k8s\.io\/kubernetes\/build\/root$/d' | \
    sed '/^k8s\.io\/kubernetes$/d' | \
    sed '/^k8s\.io\/kubernetes\/staging$/d' | \
    sed 's,k8s\.io/kubernetes/staging/src/,,'
  )

  # origin apis
  $(
    grep --color=never -rl '+k8s:openapi-gen=' vendor/github.com/openshift/api | \
    xargs -n1 dirname | \
    sed "s,^vendor/,," | \
    sort -u
  )
)

INPUT_DIRS=$(IFS=,; echo "${INPUT_DIRS[*]}")


echo "Generating openapi"
${GOPATH}/bin/openapi-gen \
  --logtostderr \
  --build-tag=ignore_autogenerated_openshift \
  -O zz_generated.openapi \
  --go-header-file ${SCRIPT_ROOT}/hack/boilerplate.txt \
  --output-base="${GOPATH}/src" \
  --input-dirs "${INPUT_DIRS}" \
  --output-package "${ORIGIN_PREFIX}pkg/openapi" \
  "$@"
