package streamanalytics

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// BindingType enumerates the values for binding type.
type BindingType string

const (
	// BindingTypeFunctionRetrieveDefaultDefinitionParameters ...
	BindingTypeFunctionRetrieveDefaultDefinitionParameters BindingType = "FunctionRetrieveDefaultDefinitionParameters"
	// BindingTypeMicrosoftMachineLearningWebService ...
	BindingTypeMicrosoftMachineLearningWebService BindingType = "Microsoft.MachineLearning/WebService"
	// BindingTypeMicrosoftStreamAnalyticsJavascriptUdf ...
	BindingTypeMicrosoftStreamAnalyticsJavascriptUdf BindingType = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// CompatibilityLevel enumerates the values for compatibility level.
type CompatibilityLevel string

const (
	// OneFullStopZero ...
	OneFullStopZero CompatibilityLevel = "1.0"
)

// Encoding enumerates the values for encoding.
type Encoding string

const (
	// UTF8 ...
	UTF8 Encoding = "UTF8"
)

// EventsOutOfOrderPolicy enumerates the values for events out of order policy.
type EventsOutOfOrderPolicy string

const (
	// Adjust ...
	Adjust EventsOutOfOrderPolicy = "Adjust"
	// Drop ...
	Drop EventsOutOfOrderPolicy = "Drop"
)

// JSONOutputSerializationFormat enumerates the values for json output serialization format.
type JSONOutputSerializationFormat string

const (
	// Array ...
	Array JSONOutputSerializationFormat = "Array"
	// LineSeparated ...
	LineSeparated JSONOutputSerializationFormat = "LineSeparated"
)

// OutputErrorPolicy enumerates the values for output error policy.
type OutputErrorPolicy string

const (
	// OutputErrorPolicyDrop ...
	OutputErrorPolicyDrop OutputErrorPolicy = "Drop"
	// OutputErrorPolicyStop ...
	OutputErrorPolicyStop OutputErrorPolicy = "Stop"
)

// OutputStartMode enumerates the values for output start mode.
type OutputStartMode string

const (
	// CustomTime ...
	CustomTime OutputStartMode = "CustomTime"
	// JobStartTime ...
	JobStartTime OutputStartMode = "JobStartTime"
	// LastOutputEventTime ...
	LastOutputEventTime OutputStartMode = "LastOutputEventTime"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Standard ...
	Standard SkuName = "Standard"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeAvro ...
	TypeAvro Type = "Avro"
	// TypeCsv ...
	TypeCsv Type = "Csv"
	// TypeJSON ...
	TypeJSON Type = "Json"
	// TypeSerialization ...
	TypeSerialization Type = "Serialization"
)

// TypeBasicFunctionBinding enumerates the values for type basic function binding.
type TypeBasicFunctionBinding string

const (
	// TypeFunctionBinding ...
	TypeFunctionBinding TypeBasicFunctionBinding = "FunctionBinding"
	// TypeMicrosoftMachineLearningWebService ...
	TypeMicrosoftMachineLearningWebService TypeBasicFunctionBinding = "Microsoft.MachineLearning/WebService"
	// TypeMicrosoftStreamAnalyticsJavascriptUdf ...
	TypeMicrosoftStreamAnalyticsJavascriptUdf TypeBasicFunctionBinding = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// TypeBasicFunctionProperties enumerates the values for type basic function properties.
type TypeBasicFunctionProperties string

const (
	// TypeFunctionProperties ...
	TypeFunctionProperties TypeBasicFunctionProperties = "FunctionProperties"
	// TypeScalar ...
	TypeScalar TypeBasicFunctionProperties = "Scalar"
)

// TypeBasicInputProperties enumerates the values for type basic input properties.
type TypeBasicInputProperties string

const (
	// TypeInputProperties ...
	TypeInputProperties TypeBasicInputProperties = "InputProperties"
	// TypeReference ...
	TypeReference TypeBasicInputProperties = "Reference"
	// TypeStream ...
	TypeStream TypeBasicInputProperties = "Stream"
)

// TypeBasicOutputDataSource enumerates the values for type basic output data source.
type TypeBasicOutputDataSource string

const (
	// TypeMicrosoftDataLakeAccounts ...
	TypeMicrosoftDataLakeAccounts TypeBasicOutputDataSource = "Microsoft.DataLake/Accounts"
	// TypeMicrosoftServiceBusEventHub ...
	TypeMicrosoftServiceBusEventHub TypeBasicOutputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeMicrosoftServiceBusQueue ...
	TypeMicrosoftServiceBusQueue TypeBasicOutputDataSource = "Microsoft.ServiceBus/Queue"
	// TypeMicrosoftServiceBusTopic ...
	TypeMicrosoftServiceBusTopic TypeBasicOutputDataSource = "Microsoft.ServiceBus/Topic"
	// TypeMicrosoftSQLServerDatabase ...
	TypeMicrosoftSQLServerDatabase TypeBasicOutputDataSource = "Microsoft.Sql/Server/Database"
	// TypeMicrosoftStorageBlob ...
	TypeMicrosoftStorageBlob TypeBasicOutputDataSource = "Microsoft.Storage/Blob"
	// TypeMicrosoftStorageDocumentDB ...
	TypeMicrosoftStorageDocumentDB TypeBasicOutputDataSource = "Microsoft.Storage/DocumentDB"
	// TypeMicrosoftStorageTable ...
	TypeMicrosoftStorageTable TypeBasicOutputDataSource = "Microsoft.Storage/Table"
	// TypeOutputDataSource ...
	TypeOutputDataSource TypeBasicOutputDataSource = "OutputDataSource"
	// TypePowerBI ...
	TypePowerBI TypeBasicOutputDataSource = "PowerBI"
)

// TypeBasicReferenceInputDataSource enumerates the values for type basic reference input data source.
type TypeBasicReferenceInputDataSource string

const (
	// TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob ...
	TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob TypeBasicReferenceInputDataSource = "Microsoft.Storage/Blob"
	// TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource ...
	TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource TypeBasicReferenceInputDataSource = "ReferenceInputDataSource"
)

// TypeBasicStreamInputDataSource enumerates the values for type basic stream input data source.
type TypeBasicStreamInputDataSource string

const (
	// TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs ...
	TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs TypeBasicStreamInputDataSource = "Microsoft.Devices/IotHubs"
	// TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub ...
	TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub TypeBasicStreamInputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob ...
	TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob TypeBasicStreamInputDataSource = "Microsoft.Storage/Blob"
	// TypeBasicStreamInputDataSourceTypeStreamInputDataSource ...
	TypeBasicStreamInputDataSourceTypeStreamInputDataSource TypeBasicStreamInputDataSource = "StreamInputDataSource"
)

// UdfType enumerates the values for udf type.
type UdfType string

const (
	// Scalar ...
	Scalar UdfType = "Scalar"
)

// AvroSerialization describes how data from an input is serialized or how data is serialized when written to an
// output in Avro format.
type AvroSerialization struct {
	// Properties - The properties that are associated with the Avro serialization type. Required on PUT (CreateOrReplace) requests.
	Properties interface{} `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroSerialization.
func (as AvroSerialization) MarshalJSON() ([]byte, error) {
	as.Type = TypeAvro
	objectMap := make(map[string]interface{})
	objectMap["properties"] = as.Properties
	objectMap["type"] = as.Type
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return &as, true
}

// AsJSONSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AsSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsSerialization() (*Serialization, bool) {
	return nil, false
}

// AsBasicSerialization is the BasicSerialization implementation for AvroSerialization.
func (as AvroSerialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &as, true
}

// AzureDataLakeStoreOutputDataSource describes an Azure Data Lake Store output data source.
type AzureDataLakeStoreOutputDataSource struct {
	// AzureDataLakeStoreOutputDataSourceProperties - The properties that are associated with an Azure Data Lake Store output. Required on PUT (CreateOrReplace) requests.
	*AzureDataLakeStoreOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) MarshalJSON() ([]byte, error) {
	adlsods.Type = TypeMicrosoftDataLakeAccounts
	objectMap := make(map[string]interface{})
	if adlsods.AzureDataLakeStoreOutputDataSourceProperties != nil {
		objectMap["properties"] = adlsods.AzureDataLakeStoreOutputDataSourceProperties
	}
	objectMap["type"] = adlsods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return &adlsods, true
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &adlsods, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreOutputDataSource struct.
func (adlsods *AzureDataLakeStoreOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureDataLakeStoreOutputDataSourceProperties AzureDataLakeStoreOutputDataSourceProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreOutputDataSourceProperties)
				if err != nil {
					return err
				}
				adlsods.AzureDataLakeStoreOutputDataSourceProperties = &azureDataLakeStoreOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsods.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreOutputDataSourceProperties the properties that are associated with an Azure Data Lake Store.
type AzureDataLakeStoreOutputDataSourceProperties struct {
	// AccountName - The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
	// TenantID - The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
	TenantID *string `json:"tenantId,omitempty"`
	// FilePathPrefix - The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
	FilePathPrefix *string `json:"filePathPrefix,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
	// RefreshToken - A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// TokenUserPrincipalName - The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	// TokenUserDisplayName - The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBinding the binding to an Azure Machine Learning web service.
type AzureMachineLearningWebServiceFunctionBinding struct {
	// AzureMachineLearningWebServiceFunctionBindingProperties - The binding properties associated with an Azure Machine learning web service.
	*AzureMachineLearningWebServiceFunctionBindingProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeFunctionBinding', 'TypeMicrosoftStreamAnalyticsJavascriptUdf', 'TypeMicrosoftMachineLearningWebService'
	Type TypeBasicFunctionBinding `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) MarshalJSON() ([]byte, error) {
	amlwsfb.Type = TypeMicrosoftMachineLearningWebService
	objectMap := make(map[string]interface{})
	if amlwsfb.AzureMachineLearningWebServiceFunctionBindingProperties != nil {
		objectMap["properties"] = amlwsfb.AzureMachineLearningWebServiceFunctionBindingProperties
	}
	objectMap["type"] = amlwsfb.Type
	return json.Marshal(objectMap)
}

// AsJavaScriptFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return nil, false
}

// AsAzureMachineLearningWebServiceFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return &amlwsfb, true
}

// AsFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsFunctionBinding() (*FunctionBinding, bool) {
	return nil, false
}

// AsBasicFunctionBinding is the BasicFunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsBasicFunctionBinding() (BasicFunctionBinding, bool) {
	return &amlwsfb, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMachineLearningWebServiceFunctionBinding struct.
func (amlwsfb *AzureMachineLearningWebServiceFunctionBinding) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureMachineLearningWebServiceFunctionBindingProperties AzureMachineLearningWebServiceFunctionBindingProperties
				err = json.Unmarshal(*v, &azureMachineLearningWebServiceFunctionBindingProperties)
				if err != nil {
					return err
				}
				amlwsfb.AzureMachineLearningWebServiceFunctionBindingProperties = &azureMachineLearningWebServiceFunctionBindingProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFunctionBinding
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amlwsfb.Type = typeVar
			}
		}
	}

	return nil
}

// AzureMachineLearningWebServiceFunctionBindingProperties the binding properties associated with an Azure Machine
// learning web service.
type AzureMachineLearningWebServiceFunctionBindingProperties struct {
	// Endpoint - The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	Endpoint *string `json:"endpoint,omitempty"`
	// APIKey - The API key used to authenticate with Request-Response endpoint.
	APIKey *string `json:"apiKey,omitempty"`
	// Inputs - The inputs for the Azure Machine Learning web service endpoint.
	Inputs *AzureMachineLearningWebServiceInputs `json:"inputs,omitempty"`
	// Outputs - A list of outputs from the Azure Machine Learning web service endpoint execution.
	Outputs *[]AzureMachineLearningWebServiceOutputColumn `json:"outputs,omitempty"`
	// BatchSize - Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
	BatchSize *int32 `json:"batchSize,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBindingRetrievalProperties the binding retrieval properties associated
// with an Azure Machine learning web service.
type AzureMachineLearningWebServiceFunctionBindingRetrievalProperties struct {
	// ExecuteEndpoint - The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	ExecuteEndpoint *string `json:"executeEndpoint,omitempty"`
	// UdfType - The function type. Possible values include: 'Scalar'
	UdfType UdfType `json:"udfType,omitempty"`
}

// AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters the parameters needed to retrieve the
// default function definition for an Azure Machine Learning web service function.
type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters struct {
	// AzureMachineLearningWebServiceFunctionBindingRetrievalProperties - The binding retrieval properties associated with an Azure Machine learning web service.
	*AzureMachineLearningWebServiceFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
	// BindingType - Possible values include: 'BindingTypeFunctionRetrieveDefaultDefinitionParameters', 'BindingTypeMicrosoftMachineLearningWebService', 'BindingTypeMicrosoftStreamAnalyticsJavascriptUdf'
	BindingType BindingType `json:"bindingType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	amlwsfrddp.BindingType = BindingTypeMicrosoftMachineLearningWebService
	objectMap := make(map[string]interface{})
	if amlwsfrddp.AzureMachineLearningWebServiceFunctionBindingRetrievalProperties != nil {
		objectMap["bindingRetrievalProperties"] = amlwsfrddp.AzureMachineLearningWebServiceFunctionBindingRetrievalProperties
	}
	objectMap["bindingType"] = amlwsfrddp.BindingType
	return json.Marshal(objectMap)
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &amlwsfrddp, true
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsBasicFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsBasicFunctionRetrieveDefaultDefinitionParameters() (BasicFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &amlwsfrddp, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters struct.
func (amlwsfrddp *AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bindingRetrievalProperties":
			if v != nil {
				var azureMachineLearningWebServiceFunctionBindingRetrievalProperties AzureMachineLearningWebServiceFunctionBindingRetrievalProperties
				err = json.Unmarshal(*v, &azureMachineLearningWebServiceFunctionBindingRetrievalProperties)
				if err != nil {
					return err
				}
				amlwsfrddp.AzureMachineLearningWebServiceFunctionBindingRetrievalProperties = &azureMachineLearningWebServiceFunctionBindingRetrievalProperties
			}
		case "bindingType":
			if v != nil {
				var bindingType BindingType
				err = json.Unmarshal(*v, &bindingType)
				if err != nil {
					return err
				}
				amlwsfrddp.BindingType = bindingType
			}
		}
	}

	return nil
}

// AzureMachineLearningWebServiceInputColumn describes an input column for the Azure Machine Learning web service
// endpoint.
type AzureMachineLearningWebServiceInputColumn struct {
	// Name - The name of the input column.
	Name *string `json:"name,omitempty"`
	// DataType - The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string `json:"dataType,omitempty"`
	// MapTo - The zero based index of the function parameter this input maps to.
	MapTo *int32 `json:"mapTo,omitempty"`
}

// AzureMachineLearningWebServiceInputs the inputs for the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceInputs struct {
	// Name - The name of the input. This is the name provided while authoring the endpoint.
	Name *string `json:"name,omitempty"`
	// ColumnNames - A list of input columns for the Azure Machine Learning web service endpoint.
	ColumnNames *[]AzureMachineLearningWebServiceInputColumn `json:"columnNames,omitempty"`
}

// AzureMachineLearningWebServiceOutputColumn describes an output column for the Azure Machine Learning web service
// endpoint.
type AzureMachineLearningWebServiceOutputColumn struct {
	// Name - The name of the output column.
	Name *string `json:"name,omitempty"`
	// DataType - The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string `json:"dataType,omitempty"`
}

// AzureSQLDatabaseDataSourceProperties the properties that are associated with an Azure SQL database data source.
type AzureSQLDatabaseDataSourceProperties struct {
	// Server - The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`
	// Database - The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// User - The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
	// Password - The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`
	// Table - The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
}

// AzureSQLDatabaseOutputDataSource describes an Azure SQL database output data source.
type AzureSQLDatabaseOutputDataSource struct {
	// AzureSQLDatabaseOutputDataSourceProperties - The properties that are associated with an Azure SQL database output. Required on PUT (CreateOrReplace) requests.
	*AzureSQLDatabaseOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) MarshalJSON() ([]byte, error) {
	asdods.Type = TypeMicrosoftSQLServerDatabase
	objectMap := make(map[string]interface{})
	if asdods.AzureSQLDatabaseOutputDataSourceProperties != nil {
		objectMap["properties"] = asdods.AzureSQLDatabaseOutputDataSourceProperties
	}
	objectMap["type"] = asdods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return &asdods, true
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &asdods, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDatabaseOutputDataSource struct.
func (asdods *AzureSQLDatabaseOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureSQLDatabaseOutputDataSourceProperties AzureSQLDatabaseOutputDataSourceProperties
				err = json.Unmarshal(*v, &azureSQLDatabaseOutputDataSourceProperties)
				if err != nil {
					return err
				}
				asdods.AzureSQLDatabaseOutputDataSourceProperties = &azureSQLDatabaseOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asdods.Type = typeVar
			}
		}
	}

	return nil
}

// AzureSQLDatabaseOutputDataSourceProperties the properties that are associated with an Azure SQL database output.
type AzureSQLDatabaseOutputDataSourceProperties struct {
	// Server - The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`
	// Database - The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// User - The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
	// Password - The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`
	// Table - The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
}

// AzureTableOutputDataSource describes an Azure Table output data source.
type AzureTableOutputDataSource struct {
	// AzureTableOutputDataSourceProperties - The properties that are associated with an Azure Table output. Required on PUT (CreateOrReplace) requests.
	*AzureTableOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) MarshalJSON() ([]byte, error) {
	atods.Type = TypeMicrosoftStorageTable
	objectMap := make(map[string]interface{})
	if atods.AzureTableOutputDataSourceProperties != nil {
		objectMap["properties"] = atods.AzureTableOutputDataSourceProperties
	}
	objectMap["type"] = atods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return &atods, true
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &atods, true
}

// UnmarshalJSON is the custom unmarshaler for AzureTableOutputDataSource struct.
func (atods *AzureTableOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureTableOutputDataSourceProperties AzureTableOutputDataSourceProperties
				err = json.Unmarshal(*v, &azureTableOutputDataSourceProperties)
				if err != nil {
					return err
				}
				atods.AzureTableOutputDataSourceProperties = &azureTableOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atods.Type = typeVar
			}
		}
	}

	return nil
}

// AzureTableOutputDataSourceProperties the properties that are associated with an Azure Table output.
type AzureTableOutputDataSourceProperties struct {
	// AccountName - The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`
	// Table - The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// PartitionKey - This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
	PartitionKey *string `json:"partitionKey,omitempty"`
	// RowKey - This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
	RowKey *string `json:"rowKey,omitempty"`
	// ColumnsToRemove - If specified, each item in the array is the name of a column to remove (if present) from output event entities.
	ColumnsToRemove *[]string `json:"columnsToRemove,omitempty"`
	// BatchSize - The number of rows to write to the Azure Table at a time.
	BatchSize *int32 `json:"batchSize,omitempty"`
}

// BlobDataSourceProperties the properties that are associated with a blob data source.
type BlobDataSourceProperties struct {
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobOutputDataSource describes a blob output data source.
type BlobOutputDataSource struct {
	// BlobOutputDataSourceProperties - The properties that are associated with a blob output. Required on PUT (CreateOrReplace) requests.
	*BlobOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobOutputDataSource.
func (bods BlobOutputDataSource) MarshalJSON() ([]byte, error) {
	bods.Type = TypeMicrosoftStorageBlob
	objectMap := make(map[string]interface{})
	if bods.BlobOutputDataSourceProperties != nil {
		objectMap["properties"] = bods.BlobOutputDataSourceProperties
	}
	objectMap["type"] = bods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return &bods, true
}

// AsOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &bods, true
}

// UnmarshalJSON is the custom unmarshaler for BlobOutputDataSource struct.
func (bods *BlobOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobOutputDataSourceProperties BlobOutputDataSourceProperties
				err = json.Unmarshal(*v, &blobOutputDataSourceProperties)
				if err != nil {
					return err
				}
				bods.BlobOutputDataSourceProperties = &blobOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bods.Type = typeVar
			}
		}
	}

	return nil
}

// BlobOutputDataSourceProperties the properties that are associated with a blob output.
type BlobOutputDataSourceProperties struct {
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobReferenceInputDataSource describes a blob input data source that contains reference data.
type BlobReferenceInputDataSource struct {
	// BlobReferenceInputDataSourceProperties - The properties that are associated with a blob input containing reference data. Required on PUT (CreateOrReplace) requests.
	*BlobReferenceInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource', 'TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicReferenceInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	brids.Type = TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob
	objectMap := make(map[string]interface{})
	if brids.BlobReferenceInputDataSourceProperties != nil {
		objectMap["properties"] = brids.BlobReferenceInputDataSourceProperties
	}
	objectMap["type"] = brids.Type
	return json.Marshal(objectMap)
}

// AsBlobReferenceInputDataSource is the BasicReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool) {
	return &brids, true
}

// AsReferenceInputDataSource is the BasicReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsReferenceInputDataSource() (*ReferenceInputDataSource, bool) {
	return nil, false
}

// AsBasicReferenceInputDataSource is the BasicReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsBasicReferenceInputDataSource() (BasicReferenceInputDataSource, bool) {
	return &brids, true
}

// UnmarshalJSON is the custom unmarshaler for BlobReferenceInputDataSource struct.
func (brids *BlobReferenceInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobReferenceInputDataSourceProperties BlobReferenceInputDataSourceProperties
				err = json.Unmarshal(*v, &blobReferenceInputDataSourceProperties)
				if err != nil {
					return err
				}
				brids.BlobReferenceInputDataSourceProperties = &blobReferenceInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicReferenceInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				brids.Type = typeVar
			}
		}
	}

	return nil
}

// BlobReferenceInputDataSourceProperties the properties that are associated with a blob input containing reference
// data.
type BlobReferenceInputDataSourceProperties struct {
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobStreamInputDataSource describes a blob input data source that contains stream data.
type BlobStreamInputDataSource struct {
	// BlobStreamInputDataSourceProperties - The properties that are associated with a blob input containing stream data. Required on PUT (CreateOrReplace) requests.
	*BlobStreamInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) MarshalJSON() ([]byte, error) {
	bsids.Type = TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob
	objectMap := make(map[string]interface{})
	if bsids.BlobStreamInputDataSourceProperties != nil {
		objectMap["properties"] = bsids.BlobStreamInputDataSourceProperties
	}
	objectMap["type"] = bsids.Type
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return &bsids, true
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return nil, false
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &bsids, true
}

// UnmarshalJSON is the custom unmarshaler for BlobStreamInputDataSource struct.
func (bsids *BlobStreamInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobStreamInputDataSourceProperties BlobStreamInputDataSourceProperties
				err = json.Unmarshal(*v, &blobStreamInputDataSourceProperties)
				if err != nil {
					return err
				}
				bsids.BlobStreamInputDataSourceProperties = &blobStreamInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStreamInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsids.Type = typeVar
			}
		}
	}

	return nil
}

// BlobStreamInputDataSourceProperties the properties that are associated with a blob input containing stream data.
type BlobStreamInputDataSourceProperties struct {
	// SourcePartitionCount - The partition count of the blob input data source. Range 1 - 256.
	SourcePartitionCount *int32 `json:"sourcePartitionCount,omitempty"`
	// StorageAccounts - A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// Container - The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`
	// PathPattern - The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
	PathPattern *string `json:"pathPattern,omitempty"`
	// DateFormat - The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// CsvSerialization describes how data from an input is serialized or how data is serialized when written to an
// output in CSV format.
type CsvSerialization struct {
	// CsvSerializationProperties - The properties that are associated with the CSV serialization type. Required on PUT (CreateOrReplace) requests.
	*CsvSerializationProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CsvSerialization.
func (cs CsvSerialization) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCsv
	objectMap := make(map[string]interface{})
	if cs.CsvSerializationProperties != nil {
		objectMap["properties"] = cs.CsvSerializationProperties
	}
	objectMap["type"] = cs.Type
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return &cs, true
}

// AsSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsSerialization() (*Serialization, bool) {
	return nil, false
}

// AsBasicSerialization is the BasicSerialization implementation for CsvSerialization.
func (cs CsvSerialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CsvSerialization struct.
func (cs *CsvSerialization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var csvSerializationProperties CsvSerializationProperties
				err = json.Unmarshal(*v, &csvSerializationProperties)
				if err != nil {
					return err
				}
				cs.CsvSerializationProperties = &csvSerializationProperties
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = typeVar
			}
		}
	}

	return nil
}

// CsvSerializationProperties the properties that are associated with the CSV serialization type.
type CsvSerializationProperties struct {
	// FieldDelimiter - Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
	FieldDelimiter *string `json:"fieldDelimiter,omitempty"`
	// Encoding - Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests. Possible values include: 'UTF8'
	Encoding Encoding `json:"encoding,omitempty"`
}

// DiagnosticCondition condition applicable to the resource, or to the job overall, that warrant customer
// attention.
type DiagnosticCondition struct {
	// Since - The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the ops log around this time.
	Since *string `json:"since,omitempty"`
	// Code - The opaque diagnostic code.
	Code *string `json:"code,omitempty"`
	// Message - The human-readable message describing the condition in detail. Localized in the Accept-Language of the client request.
	Message *string `json:"message,omitempty"`
}

// Diagnostics describes conditions applicable to the Input, Output, or the job overall, that warrant customer
// attention.
type Diagnostics struct {
	// Conditions - A collection of zero or more conditions applicable to the resource, or to the job overall, that warrant customer attention.
	Conditions *[]DiagnosticCondition `json:"conditions,omitempty"`
}

// DocumentDbOutputDataSource describes a DocumentDB output data source.
type DocumentDbOutputDataSource struct {
	// DocumentDbOutputDataSourceProperties - The properties that are associated with a DocumentDB output. Required on PUT (CreateOrReplace) requests.
	*DocumentDbOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) MarshalJSON() ([]byte, error) {
	ddods.Type = TypeMicrosoftStorageDocumentDB
	objectMap := make(map[string]interface{})
	if ddods.DocumentDbOutputDataSourceProperties != nil {
		objectMap["properties"] = ddods.DocumentDbOutputDataSourceProperties
	}
	objectMap["type"] = ddods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return &ddods, true
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &ddods, true
}

// UnmarshalJSON is the custom unmarshaler for DocumentDbOutputDataSource struct.
func (ddods *DocumentDbOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var documentDbOutputDataSourceProperties DocumentDbOutputDataSourceProperties
				err = json.Unmarshal(*v, &documentDbOutputDataSourceProperties)
				if err != nil {
					return err
				}
				ddods.DocumentDbOutputDataSourceProperties = &documentDbOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ddods.Type = typeVar
			}
		}
	}

	return nil
}

// DocumentDbOutputDataSourceProperties the properties that are associated with a DocumentDB output.
type DocumentDbOutputDataSourceProperties struct {
	// AccountID - The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
	AccountID *string `json:"accountId,omitempty"`
	// AccountKey - The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`
	// Database - The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`
	// CollectionNamePattern - The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
	CollectionNamePattern *string `json:"collectionNamePattern,omitempty"`
	// PartitionKey - The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
	PartitionKey *string `json:"partitionKey,omitempty"`
	// DocumentID - The name of the field in output events used to specify the primary key which insert or update operations are based on.
	DocumentID *string `json:"documentId,omitempty"`
}

// ErrorResponse describes the error that occurred.
type ErrorResponse struct {
	// Code - Error code associated with the error that occurred.
	Code *string `json:"code,omitempty"`
	// Message - Describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// EventHubDataSourceProperties the common properties that are associated with Event Hub data sources.
type EventHubDataSourceProperties struct {
	// EventHubName - The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
}

// EventHubOutputDataSource describes an Event Hub output data source.
type EventHubOutputDataSource struct {
	// EventHubOutputDataSourceProperties - The properties that are associated with an Event Hub output. Required on PUT (CreateOrReplace) requests.
	*EventHubOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) MarshalJSON() ([]byte, error) {
	ehods.Type = TypeMicrosoftServiceBusEventHub
	objectMap := make(map[string]interface{})
	if ehods.EventHubOutputDataSourceProperties != nil {
		objectMap["properties"] = ehods.EventHubOutputDataSourceProperties
	}
	objectMap["type"] = ehods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return &ehods, true
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &ehods, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubOutputDataSource struct.
func (ehods *EventHubOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubOutputDataSourceProperties EventHubOutputDataSourceProperties
				err = json.Unmarshal(*v, &eventHubOutputDataSourceProperties)
				if err != nil {
					return err
				}
				ehods.EventHubOutputDataSourceProperties = &eventHubOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehods.Type = typeVar
			}
		}
	}

	return nil
}

// EventHubOutputDataSourceProperties the properties that are associated with an Event Hub output.
type EventHubOutputDataSourceProperties struct {
	// PartitionKey - The key/column that is used to determine to which partition to send event data.
	PartitionKey *string `json:"partitionKey,omitempty"`
	// EventHubName - The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
}

// EventHubStreamInputDataSource describes an Event Hub input data source that contains stream data.
type EventHubStreamInputDataSource struct {
	// EventHubStreamInputDataSourceProperties - The properties that are associated with an Event Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	*EventHubStreamInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	ehsids.Type = TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub
	objectMap := make(map[string]interface{})
	if ehsids.EventHubStreamInputDataSourceProperties != nil {
		objectMap["properties"] = ehsids.EventHubStreamInputDataSourceProperties
	}
	objectMap["type"] = ehsids.Type
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return &ehsids, true
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return nil, false
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &ehsids, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubStreamInputDataSource struct.
func (ehsids *EventHubStreamInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubStreamInputDataSourceProperties EventHubStreamInputDataSourceProperties
				err = json.Unmarshal(*v, &eventHubStreamInputDataSourceProperties)
				if err != nil {
					return err
				}
				ehsids.EventHubStreamInputDataSourceProperties = &eventHubStreamInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStreamInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehsids.Type = typeVar
			}
		}
	}

	return nil
}

// EventHubStreamInputDataSourceProperties the properties that are associated with a Event Hub input containing
// stream data.
type EventHubStreamInputDataSourceProperties struct {
	// ConsumerGroupName - The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// EventHubName - The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
}

// Function a function object, containing all information associated with the named function. All functions are
// contained under a streaming job.
type Function struct {
	autorest.Response `json:"-"`
	// Properties - The properties that are associated with a function.
	Properties BasicFunctionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Function struct.
func (f *Function) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicFunctionProperties(*v)
				if err != nil {
					return err
				}
				f.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicFunctionBinding the physical binding of the function. For example, in the Azure Machine Learning web service’s
// case, this describes the endpoint.
type BasicFunctionBinding interface {
	AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool)
	AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool)
	AsFunctionBinding() (*FunctionBinding, bool)
}

// FunctionBinding the physical binding of the function. For example, in the Azure Machine Learning web service’s
// case, this describes the endpoint.
type FunctionBinding struct {
	// Type - Possible values include: 'TypeFunctionBinding', 'TypeMicrosoftStreamAnalyticsJavascriptUdf', 'TypeMicrosoftMachineLearningWebService'
	Type TypeBasicFunctionBinding `json:"type,omitempty"`
}

func unmarshalBasicFunctionBinding(body []byte) (BasicFunctionBinding, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeMicrosoftStreamAnalyticsJavascriptUdf):
		var jsfb JavaScriptFunctionBinding
		err := json.Unmarshal(body, &jsfb)
		return jsfb, err
	case string(TypeMicrosoftMachineLearningWebService):
		var amlwsfb AzureMachineLearningWebServiceFunctionBinding
		err := json.Unmarshal(body, &amlwsfb)
		return amlwsfb, err
	default:
		var fb FunctionBinding
		err := json.Unmarshal(body, &fb)
		return fb, err
	}
}
func unmarshalBasicFunctionBindingArray(body []byte) ([]BasicFunctionBinding, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fbArray := make([]BasicFunctionBinding, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fb, err := unmarshalBasicFunctionBinding(*rawMessage)
		if err != nil {
			return nil, err
		}
		fbArray[index] = fb
	}
	return fbArray, nil
}

// MarshalJSON is the custom marshaler for FunctionBinding.
func (fb FunctionBinding) MarshalJSON() ([]byte, error) {
	fb.Type = TypeFunctionBinding
	objectMap := make(map[string]interface{})
	objectMap["type"] = fb.Type
	return json.Marshal(objectMap)
}

// AsJavaScriptFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return nil, false
}

// AsAzureMachineLearningWebServiceFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return nil, false
}

// AsFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsFunctionBinding() (*FunctionBinding, bool) {
	return &fb, true
}

// AsBasicFunctionBinding is the BasicFunctionBinding implementation for FunctionBinding.
func (fb FunctionBinding) AsBasicFunctionBinding() (BasicFunctionBinding, bool) {
	return &fb, true
}

// FunctionInput describes one input parameter of a function.
type FunctionInput struct {
	// DataType - The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string `json:"dataType,omitempty"`
	// IsConfigurationParameter - A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
	IsConfigurationParameter *bool `json:"isConfigurationParameter,omitempty"`
}

// FunctionListResult object containing a list of functions under a streaming job.
type FunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of functions under a streaming job. Populated by a 'List' operation.
	Value *[]Function `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FunctionListResultIterator provides access to a complete listing of Function values.
type FunctionListResultIterator struct {
	i    int
	page FunctionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FunctionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FunctionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FunctionListResultIterator) Response() FunctionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FunctionListResultIterator) Value() Function {
	if !iter.page.NotDone() {
		return Function{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (flr FunctionListResult) IsEmpty() bool {
	return flr.Value == nil || len(*flr.Value) == 0
}

// functionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (flr FunctionListResult) functionListResultPreparer() (*http.Request, error) {
	if flr.NextLink == nil || len(to.String(flr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(flr.NextLink)))
}

// FunctionListResultPage contains a page of Function values.
type FunctionListResultPage struct {
	fn  func(FunctionListResult) (FunctionListResult, error)
	flr FunctionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FunctionListResultPage) Next() error {
	next, err := page.fn(page.flr)
	if err != nil {
		return err
	}
	page.flr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FunctionListResultPage) NotDone() bool {
	return !page.flr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FunctionListResultPage) Response() FunctionListResult {
	return page.flr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FunctionListResultPage) Values() []Function {
	if page.flr.IsEmpty() {
		return nil
	}
	return *page.flr.Value
}

// FunctionOutput describes the output of a function.
type FunctionOutput struct {
	// DataType - The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string `json:"dataType,omitempty"`
}

// BasicFunctionProperties the properties that are associated with a function.
type BasicFunctionProperties interface {
	AsScalarFunctionProperties() (*ScalarFunctionProperties, bool)
	AsFunctionProperties() (*FunctionProperties, bool)
}

// FunctionProperties the properties that are associated with a function.
type FunctionProperties struct {
	// Etag - The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Type - Possible values include: 'TypeFunctionProperties', 'TypeScalar'
	Type TypeBasicFunctionProperties `json:"type,omitempty"`
}

func unmarshalBasicFunctionProperties(body []byte) (BasicFunctionProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeScalar):
		var sfp ScalarFunctionProperties
		err := json.Unmarshal(body, &sfp)
		return sfp, err
	default:
		var fp FunctionProperties
		err := json.Unmarshal(body, &fp)
		return fp, err
	}
}
func unmarshalBasicFunctionPropertiesArray(body []byte) ([]BasicFunctionProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fpArray := make([]BasicFunctionProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fp, err := unmarshalBasicFunctionProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		fpArray[index] = fp
	}
	return fpArray, nil
}

// MarshalJSON is the custom marshaler for FunctionProperties.
func (fp FunctionProperties) MarshalJSON() ([]byte, error) {
	fp.Type = TypeFunctionProperties
	objectMap := make(map[string]interface{})
	if fp.Etag != nil {
		objectMap["etag"] = fp.Etag
	}
	objectMap["type"] = fp.Type
	return json.Marshal(objectMap)
}

// AsScalarFunctionProperties is the BasicFunctionProperties implementation for FunctionProperties.
func (fp FunctionProperties) AsScalarFunctionProperties() (*ScalarFunctionProperties, bool) {
	return nil, false
}

// AsFunctionProperties is the BasicFunctionProperties implementation for FunctionProperties.
func (fp FunctionProperties) AsFunctionProperties() (*FunctionProperties, bool) {
	return &fp, true
}

// AsBasicFunctionProperties is the BasicFunctionProperties implementation for FunctionProperties.
func (fp FunctionProperties) AsBasicFunctionProperties() (BasicFunctionProperties, bool) {
	return &fp, true
}

// BasicFunctionRetrieveDefaultDefinitionParameters parameters used to specify the type of function to retrieve the
// default definition for.
type BasicFunctionRetrieveDefaultDefinitionParameters interface {
	AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool)
	AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool)
	AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool)
}

// FunctionRetrieveDefaultDefinitionParameters parameters used to specify the type of function to retrieve the
// default definition for.
type FunctionRetrieveDefaultDefinitionParameters struct {
	// BindingType - Possible values include: 'BindingTypeFunctionRetrieveDefaultDefinitionParameters', 'BindingTypeMicrosoftMachineLearningWebService', 'BindingTypeMicrosoftStreamAnalyticsJavascriptUdf'
	BindingType BindingType `json:"bindingType,omitempty"`
}

func unmarshalBasicFunctionRetrieveDefaultDefinitionParameters(body []byte) (BasicFunctionRetrieveDefaultDefinitionParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["bindingType"] {
	case string(BindingTypeMicrosoftMachineLearningWebService):
		var amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &amlwsfrddp)
		return amlwsfrddp, err
	case string(BindingTypeMicrosoftStreamAnalyticsJavascriptUdf):
		var jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &jsfrddp)
		return jsfrddp, err
	default:
		var frddp FunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &frddp)
		return frddp, err
	}
}
func unmarshalBasicFunctionRetrieveDefaultDefinitionParametersArray(body []byte) ([]BasicFunctionRetrieveDefaultDefinitionParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	frddpArray := make([]BasicFunctionRetrieveDefaultDefinitionParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		frddp, err := unmarshalBasicFunctionRetrieveDefaultDefinitionParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		frddpArray[index] = frddp
	}
	return frddpArray, nil
}

// MarshalJSON is the custom marshaler for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	frddp.BindingType = BindingTypeFunctionRetrieveDefaultDefinitionParameters
	objectMap := make(map[string]interface{})
	objectMap["bindingType"] = frddp.BindingType
	return json.Marshal(objectMap)
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool) {
	return &frddp, true
}

// AsBasicFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for FunctionRetrieveDefaultDefinitionParameters.
func (frddp FunctionRetrieveDefaultDefinitionParameters) AsBasicFunctionRetrieveDefaultDefinitionParameters() (BasicFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &frddp, true
}

// FunctionsTestFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type FunctionsTestFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future FunctionsTestFuture) Result(client FunctionsClient) (rts ResourceTestStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.FunctionsTestFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rts, azure.NewAsyncOpIncompleteError("streamanalytics.FunctionsTestFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rts, err = client.TestResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.FunctionsTestFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.FunctionsTestFuture", "Result", resp, "Failure sending request")
		return
	}
	rts, err = client.TestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.FunctionsTestFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Input an input object, containing all information associated with the named input. All inputs are contained
// under a streaming job.
type Input struct {
	autorest.Response `json:"-"`
	// Properties - The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
	Properties BasicInputProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Input struct.
func (i *Input) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicInputProperties(*v)
				if err != nil {
					return err
				}
				i.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		}
	}

	return nil
}

// InputListResult object containing a list of inputs under a streaming job.
type InputListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of inputs under a streaming job. Populated by a 'List' operation.
	Value *[]Input `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InputListResultIterator provides access to a complete listing of Input values.
type InputListResultIterator struct {
	i    int
	page InputListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InputListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InputListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InputListResultIterator) Response() InputListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InputListResultIterator) Value() Input {
	if !iter.page.NotDone() {
		return Input{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InputListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// inputListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InputListResult) inputListResultPreparer() (*http.Request, error) {
	if ilr.NextLink == nil || len(to.String(ilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InputListResultPage contains a page of Input values.
type InputListResultPage struct {
	fn  func(InputListResult) (InputListResult, error)
	ilr InputListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InputListResultPage) Next() error {
	next, err := page.fn(page.ilr)
	if err != nil {
		return err
	}
	page.ilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InputListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InputListResultPage) Response() InputListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InputListResultPage) Values() []Input {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// BasicInputProperties the properties that are associated with an input.
type BasicInputProperties interface {
	AsReferenceInputProperties() (*ReferenceInputProperties, bool)
	AsStreamInputProperties() (*StreamInputProperties, bool)
	AsInputProperties() (*InputProperties, bool)
}

// InputProperties the properties that are associated with an input.
type InputProperties struct {
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Type - Possible values include: 'TypeInputProperties', 'TypeReference', 'TypeStream'
	Type TypeBasicInputProperties `json:"type,omitempty"`
}

func unmarshalBasicInputProperties(body []byte) (BasicInputProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeReference):
		var rip ReferenceInputProperties
		err := json.Unmarshal(body, &rip)
		return rip, err
	case string(TypeStream):
		var sip StreamInputProperties
		err := json.Unmarshal(body, &sip)
		return sip, err
	default:
		var IP InputProperties
		err := json.Unmarshal(body, &IP)
		return IP, err
	}
}
func unmarshalBasicInputPropertiesArray(body []byte) ([]BasicInputProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	IPArray := make([]BasicInputProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		IP, err := unmarshalBasicInputProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		IPArray[index] = IP
	}
	return IPArray, nil
}

// MarshalJSON is the custom marshaler for InputProperties.
func (IP InputProperties) MarshalJSON() ([]byte, error) {
	IP.Type = TypeInputProperties
	objectMap := make(map[string]interface{})
	objectMap["serialization"] = IP.Serialization
	if IP.Diagnostics != nil {
		objectMap["diagnostics"] = IP.Diagnostics
	}
	if IP.Etag != nil {
		objectMap["etag"] = IP.Etag
	}
	objectMap["type"] = IP.Type
	return json.Marshal(objectMap)
}

// AsReferenceInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return nil, false
}

// AsStreamInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return nil, false
}

// AsInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsInputProperties() (*InputProperties, bool) {
	return &IP, true
}

// AsBasicInputProperties is the BasicInputProperties implementation for InputProperties.
func (IP InputProperties) AsBasicInputProperties() (BasicInputProperties, bool) {
	return &IP, true
}

// UnmarshalJSON is the custom unmarshaler for InputProperties struct.
func (IP *InputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				IP.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				IP.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				IP.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicInputProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = typeVar
			}
		}
	}

	return nil
}

// InputsTestFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type InputsTestFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InputsTestFuture) Result(client InputsClient) (rts ResourceTestStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.InputsTestFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rts, azure.NewAsyncOpIncompleteError("streamanalytics.InputsTestFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rts, err = client.TestResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.InputsTestFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.InputsTestFuture", "Result", resp, "Failure sending request")
		return
	}
	rts, err = client.TestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.InputsTestFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// IoTHubStreamInputDataSource describes an IoT Hub input data source that contains stream data.
type IoTHubStreamInputDataSource struct {
	// IoTHubStreamInputDataSourceProperties - The properties that are associated with an IoT Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	*IoTHubStreamInputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	ithsids.Type = TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs
	objectMap := make(map[string]interface{})
	if ithsids.IoTHubStreamInputDataSourceProperties != nil {
		objectMap["properties"] = ithsids.IoTHubStreamInputDataSourceProperties
	}
	objectMap["type"] = ithsids.Type
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return &ithsids, true
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return nil, false
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &ithsids, true
}

// UnmarshalJSON is the custom unmarshaler for IoTHubStreamInputDataSource struct.
func (ithsids *IoTHubStreamInputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTHubStreamInputDataSourceProperties IoTHubStreamInputDataSourceProperties
				err = json.Unmarshal(*v, &ioTHubStreamInputDataSourceProperties)
				if err != nil {
					return err
				}
				ithsids.IoTHubStreamInputDataSourceProperties = &ioTHubStreamInputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStreamInputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ithsids.Type = typeVar
			}
		}
	}

	return nil
}

// IoTHubStreamInputDataSourceProperties the properties that are associated with a IoT Hub input containing stream
// data.
type IoTHubStreamInputDataSourceProperties struct {
	// IotHubNamespace - The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
	IotHubNamespace *string `json:"iotHubNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
	// ConsumerGroupName - The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`
	// Endpoint - The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
	Endpoint *string `json:"endpoint,omitempty"`
}

// JavaScriptFunctionBinding the binding to a JavaScript function.
type JavaScriptFunctionBinding struct {
	// JavaScriptFunctionBindingProperties - The binding properties associated with a JavaScript function.
	*JavaScriptFunctionBindingProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeFunctionBinding', 'TypeMicrosoftStreamAnalyticsJavascriptUdf', 'TypeMicrosoftMachineLearningWebService'
	Type TypeBasicFunctionBinding `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) MarshalJSON() ([]byte, error) {
	jsfb.Type = TypeMicrosoftStreamAnalyticsJavascriptUdf
	objectMap := make(map[string]interface{})
	if jsfb.JavaScriptFunctionBindingProperties != nil {
		objectMap["properties"] = jsfb.JavaScriptFunctionBindingProperties
	}
	objectMap["type"] = jsfb.Type
	return json.Marshal(objectMap)
}

// AsJavaScriptFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return &jsfb, true
}

// AsAzureMachineLearningWebServiceFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return nil, false
}

// AsFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsFunctionBinding() (*FunctionBinding, bool) {
	return nil, false
}

// AsBasicFunctionBinding is the BasicFunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsBasicFunctionBinding() (BasicFunctionBinding, bool) {
	return &jsfb, true
}

// UnmarshalJSON is the custom unmarshaler for JavaScriptFunctionBinding struct.
func (jsfb *JavaScriptFunctionBinding) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var javaScriptFunctionBindingProperties JavaScriptFunctionBindingProperties
				err = json.Unmarshal(*v, &javaScriptFunctionBindingProperties)
				if err != nil {
					return err
				}
				jsfb.JavaScriptFunctionBindingProperties = &javaScriptFunctionBindingProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFunctionBinding
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jsfb.Type = typeVar
			}
		}
	}

	return nil
}

// JavaScriptFunctionBindingProperties the binding properties associated with a JavaScript function.
type JavaScriptFunctionBindingProperties struct {
	// Script - The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
	Script *string `json:"script,omitempty"`
}

// JavaScriptFunctionBindingRetrievalProperties the binding retrieval properties associated with a JavaScript
// function.
type JavaScriptFunctionBindingRetrievalProperties struct {
	// Script - The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'.
	Script *string `json:"script,omitempty"`
	// UdfType - The function type. Possible values include: 'Scalar'
	UdfType UdfType `json:"udfType,omitempty"`
}

// JavaScriptFunctionRetrieveDefaultDefinitionParameters the parameters needed to retrieve the default function
// definition for a JavaScript function.
type JavaScriptFunctionRetrieveDefaultDefinitionParameters struct {
	// JavaScriptFunctionBindingRetrievalProperties - The binding retrieval properties associated with a JavaScript function.
	*JavaScriptFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
	// BindingType - Possible values include: 'BindingTypeFunctionRetrieveDefaultDefinitionParameters', 'BindingTypeMicrosoftMachineLearningWebService', 'BindingTypeMicrosoftStreamAnalyticsJavascriptUdf'
	BindingType BindingType `json:"bindingType,omitempty"`
}

// MarshalJSON is the custom marshaler for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	jsfrddp.BindingType = BindingTypeMicrosoftStreamAnalyticsJavascriptUdf
	objectMap := make(map[string]interface{})
	if jsfrddp.JavaScriptFunctionBindingRetrievalProperties != nil {
		objectMap["bindingRetrievalProperties"] = jsfrddp.JavaScriptFunctionBindingRetrievalProperties
	}
	objectMap["bindingType"] = jsfrddp.BindingType
	return json.Marshal(objectMap)
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &jsfrddp, true
}

// AsFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsFunctionRetrieveDefaultDefinitionParameters() (*FunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsBasicFunctionRetrieveDefaultDefinitionParameters is the BasicFunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsBasicFunctionRetrieveDefaultDefinitionParameters() (BasicFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &jsfrddp, true
}

// UnmarshalJSON is the custom unmarshaler for JavaScriptFunctionRetrieveDefaultDefinitionParameters struct.
func (jsfrddp *JavaScriptFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bindingRetrievalProperties":
			if v != nil {
				var javaScriptFunctionBindingRetrievalProperties JavaScriptFunctionBindingRetrievalProperties
				err = json.Unmarshal(*v, &javaScriptFunctionBindingRetrievalProperties)
				if err != nil {
					return err
				}
				jsfrddp.JavaScriptFunctionBindingRetrievalProperties = &javaScriptFunctionBindingRetrievalProperties
			}
		case "bindingType":
			if v != nil {
				var bindingType BindingType
				err = json.Unmarshal(*v, &bindingType)
				if err != nil {
					return err
				}
				jsfrddp.BindingType = bindingType
			}
		}
	}

	return nil
}

// JSONSerialization describes how data from an input is serialized or how data is serialized when written to an
// output in JSON format.
type JSONSerialization struct {
	// JSONSerializationProperties - The properties that are associated with the JSON serialization type. Required on PUT (CreateOrReplace) requests.
	*JSONSerializationProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JSONSerialization.
func (js JSONSerialization) MarshalJSON() ([]byte, error) {
	js.Type = TypeJSON
	objectMap := make(map[string]interface{})
	if js.JSONSerializationProperties != nil {
		objectMap["properties"] = js.JSONSerializationProperties
	}
	objectMap["type"] = js.Type
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return &js, true
}

// AsCsvSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AsSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsSerialization() (*Serialization, bool) {
	return nil, false
}

// AsBasicSerialization is the BasicSerialization implementation for JSONSerialization.
func (js JSONSerialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &js, true
}

// UnmarshalJSON is the custom unmarshaler for JSONSerialization struct.
func (js *JSONSerialization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var JSONSerializationProperties JSONSerializationProperties
				err = json.Unmarshal(*v, &JSONSerializationProperties)
				if err != nil {
					return err
				}
				js.JSONSerializationProperties = &JSONSerializationProperties
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = typeVar
			}
		}
	}

	return nil
}

// JSONSerializationProperties the properties that are associated with the JSON serialization type.
type JSONSerializationProperties struct {
	// Encoding - Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests. Possible values include: 'UTF8'
	Encoding Encoding `json:"encoding,omitempty"`
	// Format - This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null. Possible values include: 'LineSeparated', 'Array'
	Format JSONOutputSerializationFormat `json:"format,omitempty"`
}

// OAuthBasedDataSourceProperties the properties that are associated with data sources that use OAuth as their
// authentication model.
type OAuthBasedDataSourceProperties struct {
	// RefreshToken - A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// TokenUserPrincipalName - The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	// TokenUserDisplayName - The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`
}

// Operation a Stream Analytics REST API operation
type Operation struct {
	// Name - The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - Contains the localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	// Provider - The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Stream Analytics operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Stream Analytics operations supported by the Microsoft.StreamAnalytics resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Output an output object, containing all information associated with the named output. All outputs are contained
// under a streaming job.
type Output struct {
	autorest.Response `json:"-"`
	// OutputProperties - The properties that are associated with an output. Required on PUT (CreateOrReplace) requests.
	*OutputProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Output struct.
func (o *Output) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outputProperties OutputProperties
				err = json.Unmarshal(*v, &outputProperties)
				if err != nil {
					return err
				}
				o.OutputProperties = &outputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicOutputDataSource describes the data source that output will be written to.
type BasicOutputDataSource interface {
	AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool)
	AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool)
	AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool)
	AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool)
	AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool)
	AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool)
	AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool)
	AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool)
	AsBlobOutputDataSource() (*BlobOutputDataSource, bool)
	AsOutputDataSource() (*OutputDataSource, bool)
}

// OutputDataSource describes the data source that output will be written to.
type OutputDataSource struct {
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

func unmarshalBasicOutputDataSource(body []byte) (BasicOutputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeMicrosoftDataLakeAccounts):
		var adlsods AzureDataLakeStoreOutputDataSource
		err := json.Unmarshal(body, &adlsods)
		return adlsods, err
	case string(TypePowerBI):
		var pbods PowerBIOutputDataSource
		err := json.Unmarshal(body, &pbods)
		return pbods, err
	case string(TypeMicrosoftServiceBusTopic):
		var sbtods ServiceBusTopicOutputDataSource
		err := json.Unmarshal(body, &sbtods)
		return sbtods, err
	case string(TypeMicrosoftServiceBusQueue):
		var sbqods ServiceBusQueueOutputDataSource
		err := json.Unmarshal(body, &sbqods)
		return sbqods, err
	case string(TypeMicrosoftStorageDocumentDB):
		var ddods DocumentDbOutputDataSource
		err := json.Unmarshal(body, &ddods)
		return ddods, err
	case string(TypeMicrosoftSQLServerDatabase):
		var asdods AzureSQLDatabaseOutputDataSource
		err := json.Unmarshal(body, &asdods)
		return asdods, err
	case string(TypeMicrosoftServiceBusEventHub):
		var ehods EventHubOutputDataSource
		err := json.Unmarshal(body, &ehods)
		return ehods, err
	case string(TypeMicrosoftStorageTable):
		var atods AzureTableOutputDataSource
		err := json.Unmarshal(body, &atods)
		return atods, err
	case string(TypeMicrosoftStorageBlob):
		var bods BlobOutputDataSource
		err := json.Unmarshal(body, &bods)
		return bods, err
	default:
		var ods OutputDataSource
		err := json.Unmarshal(body, &ods)
		return ods, err
	}
}
func unmarshalBasicOutputDataSourceArray(body []byte) ([]BasicOutputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	odsArray := make([]BasicOutputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ods, err := unmarshalBasicOutputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		odsArray[index] = ods
	}
	return odsArray, nil
}

// MarshalJSON is the custom marshaler for OutputDataSource.
func (ods OutputDataSource) MarshalJSON() ([]byte, error) {
	ods.Type = TypeOutputDataSource
	objectMap := make(map[string]interface{})
	objectMap["type"] = ods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return &ods, true
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for OutputDataSource.
func (ods OutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &ods, true
}

// OutputListResult object containing a list of outputs under a streaming job.
type OutputListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of outputs under a streaming job. Populated by a 'List' operation.
	Value *[]Output `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OutputListResultIterator provides access to a complete listing of Output values.
type OutputListResultIterator struct {
	i    int
	page OutputListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutputListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutputListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutputListResultIterator) Response() OutputListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutputListResultIterator) Value() Output {
	if !iter.page.NotDone() {
		return Output{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OutputListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// outputListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OutputListResult) outputListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OutputListResultPage contains a page of Output values.
type OutputListResultPage struct {
	fn  func(OutputListResult) (OutputListResult, error)
	olr OutputListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutputListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutputListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutputListResultPage) Response() OutputListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutputListResultPage) Values() []Output {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// OutputProperties the properties that are associated with an output.
type OutputProperties struct {
	// Datasource - Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
	Datasource BasicOutputDataSource `json:"datasource,omitempty"`
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OutputProperties struct.
func (op *OutputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "datasource":
			if v != nil {
				datasource, err := unmarshalBasicOutputDataSource(*v)
				if err != nil {
					return err
				}
				op.Datasource = datasource
			}
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				op.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				op.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				op.Etag = &etag
			}
		}
	}

	return nil
}

// OutputsTestFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OutputsTestFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future OutputsTestFuture) Result(client OutputsClient) (rts ResourceTestStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.OutputsTestFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return rts, azure.NewAsyncOpIncompleteError("streamanalytics.OutputsTestFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rts, err = client.TestResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.OutputsTestFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.OutputsTestFuture", "Result", resp, "Failure sending request")
		return
	}
	rts, err = client.TestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.OutputsTestFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PowerBIOutputDataSource describes a Power BI output data source.
type PowerBIOutputDataSource struct {
	// PowerBIOutputDataSourceProperties - The properties that are associated with a Power BI output. Required on PUT (CreateOrReplace) requests.
	*PowerBIOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) MarshalJSON() ([]byte, error) {
	pbods.Type = TypePowerBI
	objectMap := make(map[string]interface{})
	if pbods.PowerBIOutputDataSourceProperties != nil {
		objectMap["properties"] = pbods.PowerBIOutputDataSourceProperties
	}
	objectMap["type"] = pbods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return &pbods, true
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &pbods, true
}

// UnmarshalJSON is the custom unmarshaler for PowerBIOutputDataSource struct.
func (pbods *PowerBIOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var powerBIOutputDataSourceProperties PowerBIOutputDataSourceProperties
				err = json.Unmarshal(*v, &powerBIOutputDataSourceProperties)
				if err != nil {
					return err
				}
				pbods.PowerBIOutputDataSourceProperties = &powerBIOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pbods.Type = typeVar
			}
		}
	}

	return nil
}

// PowerBIOutputDataSourceProperties the properties that are associated with a Power BI output.
type PowerBIOutputDataSourceProperties struct {
	// Dataset - The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
	Dataset *string `json:"dataset,omitempty"`
	// Table - The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
	// GroupID - The ID of the Power BI group.
	GroupID *string `json:"groupId,omitempty"`
	// GroupName - The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
	GroupName *string `json:"groupName,omitempty"`
	// RefreshToken - A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// TokenUserPrincipalName - The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	// TokenUserDisplayName - The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`
}

// BasicReferenceInputDataSource describes an input data source that contains reference data.
type BasicReferenceInputDataSource interface {
	AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool)
	AsReferenceInputDataSource() (*ReferenceInputDataSource, bool)
}

// ReferenceInputDataSource describes an input data source that contains reference data.
type ReferenceInputDataSource struct {
	// Type - Possible values include: 'TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource', 'TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicReferenceInputDataSource `json:"type,omitempty"`
}

func unmarshalBasicReferenceInputDataSource(body []byte) (BasicReferenceInputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob):
		var brids BlobReferenceInputDataSource
		err := json.Unmarshal(body, &brids)
		return brids, err
	default:
		var rids ReferenceInputDataSource
		err := json.Unmarshal(body, &rids)
		return rids, err
	}
}
func unmarshalBasicReferenceInputDataSourceArray(body []byte) ([]BasicReferenceInputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ridsArray := make([]BasicReferenceInputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rids, err := unmarshalBasicReferenceInputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		ridsArray[index] = rids
	}
	return ridsArray, nil
}

// MarshalJSON is the custom marshaler for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	rids.Type = TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource
	objectMap := make(map[string]interface{})
	objectMap["type"] = rids.Type
	return json.Marshal(objectMap)
}

// AsBlobReferenceInputDataSource is the BasicReferenceInputDataSource implementation for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool) {
	return nil, false
}

// AsReferenceInputDataSource is the BasicReferenceInputDataSource implementation for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) AsReferenceInputDataSource() (*ReferenceInputDataSource, bool) {
	return &rids, true
}

// AsBasicReferenceInputDataSource is the BasicReferenceInputDataSource implementation for ReferenceInputDataSource.
func (rids ReferenceInputDataSource) AsBasicReferenceInputDataSource() (BasicReferenceInputDataSource, bool) {
	return &rids, true
}

// ReferenceInputProperties the properties that are associated with an input containing reference data.
type ReferenceInputProperties struct {
	// Datasource - Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
	Datasource BasicReferenceInputDataSource `json:"datasource,omitempty"`
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Type - Possible values include: 'TypeInputProperties', 'TypeReference', 'TypeStream'
	Type TypeBasicInputProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReferenceInputProperties.
func (rip ReferenceInputProperties) MarshalJSON() ([]byte, error) {
	rip.Type = TypeReference
	objectMap := make(map[string]interface{})
	objectMap["datasource"] = rip.Datasource
	objectMap["serialization"] = rip.Serialization
	if rip.Diagnostics != nil {
		objectMap["diagnostics"] = rip.Diagnostics
	}
	if rip.Etag != nil {
		objectMap["etag"] = rip.Etag
	}
	objectMap["type"] = rip.Type
	return json.Marshal(objectMap)
}

// AsReferenceInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return &rip, true
}

// AsStreamInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return nil, false
}

// AsInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsInputProperties() (*InputProperties, bool) {
	return nil, false
}

// AsBasicInputProperties is the BasicInputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsBasicInputProperties() (BasicInputProperties, bool) {
	return &rip, true
}

// UnmarshalJSON is the custom unmarshaler for ReferenceInputProperties struct.
func (rip *ReferenceInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "datasource":
			if v != nil {
				datasource, err := unmarshalBasicReferenceInputDataSource(*v)
				if err != nil {
					return err
				}
				rip.Datasource = datasource
			}
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				rip.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				rip.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rip.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicInputProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rip.Type = typeVar
			}
		}
	}

	return nil
}

// Resource the base resource model definition.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location. Required on PUT (CreateOrReplace) requests.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceTestStatus describes the status of the test operation along with error information, if applicable.
type ResourceTestStatus struct {
	autorest.Response `json:"-"`
	// Status - The status of the test operation.
	Status *string `json:"status,omitempty"`
	// Error - Describes the error that occurred.
	Error *ErrorResponse `json:"error,omitempty"`
}

// ScalarFunctionConfiguration describes the configuration of the scalar function.
type ScalarFunctionConfiguration struct {
	// Inputs - A list of inputs describing the parameters of the function.
	Inputs *[]FunctionInput `json:"inputs,omitempty"`
	// Output - The output of the function.
	Output *FunctionOutput `json:"output,omitempty"`
	// Binding - The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
	Binding BasicFunctionBinding `json:"binding,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ScalarFunctionConfiguration struct.
func (sfc *ScalarFunctionConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "inputs":
			if v != nil {
				var inputs []FunctionInput
				err = json.Unmarshal(*v, &inputs)
				if err != nil {
					return err
				}
				sfc.Inputs = &inputs
			}
		case "output":
			if v != nil {
				var output FunctionOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				sfc.Output = &output
			}
		case "binding":
			if v != nil {
				binding, err := unmarshalBasicFunctionBinding(*v)
				if err != nil {
					return err
				}
				sfc.Binding = binding
			}
		}
	}

	return nil
}

// ScalarFunctionProperties the properties that are associated with a scalar function.
type ScalarFunctionProperties struct {
	// ScalarFunctionConfiguration - Describes the configuration of the scalar function.
	*ScalarFunctionConfiguration `json:"properties,omitempty"`
	// Etag - The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Type - Possible values include: 'TypeFunctionProperties', 'TypeScalar'
	Type TypeBasicFunctionProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) MarshalJSON() ([]byte, error) {
	sfp.Type = TypeScalar
	objectMap := make(map[string]interface{})
	if sfp.ScalarFunctionConfiguration != nil {
		objectMap["properties"] = sfp.ScalarFunctionConfiguration
	}
	if sfp.Etag != nil {
		objectMap["etag"] = sfp.Etag
	}
	objectMap["type"] = sfp.Type
	return json.Marshal(objectMap)
}

// AsScalarFunctionProperties is the BasicFunctionProperties implementation for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) AsScalarFunctionProperties() (*ScalarFunctionProperties, bool) {
	return &sfp, true
}

// AsFunctionProperties is the BasicFunctionProperties implementation for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) AsFunctionProperties() (*FunctionProperties, bool) {
	return nil, false
}

// AsBasicFunctionProperties is the BasicFunctionProperties implementation for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) AsBasicFunctionProperties() (BasicFunctionProperties, bool) {
	return &sfp, true
}

// UnmarshalJSON is the custom unmarshaler for ScalarFunctionProperties struct.
func (sfp *ScalarFunctionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scalarFunctionConfiguration ScalarFunctionConfiguration
				err = json.Unmarshal(*v, &scalarFunctionConfiguration)
				if err != nil {
					return err
				}
				sfp.ScalarFunctionConfiguration = &scalarFunctionConfiguration
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sfp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFunctionProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sfp.Type = typeVar
			}
		}
	}

	return nil
}

// BasicSerialization describes how data from an input is serialized or how data is serialized when written to an
// output.
type BasicSerialization interface {
	AsAvroSerialization() (*AvroSerialization, bool)
	AsJSONSerialization() (*JSONSerialization, bool)
	AsCsvSerialization() (*CsvSerialization, bool)
	AsSerialization() (*Serialization, bool)
}

// Serialization describes how data from an input is serialized or how data is serialized when written to an
// output.
type Serialization struct {
	// Type - Possible values include: 'TypeSerialization', 'TypeAvro', 'TypeJSON', 'TypeCsv'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicSerialization(body []byte) (BasicSerialization, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAvro):
		var as AvroSerialization
		err := json.Unmarshal(body, &as)
		return as, err
	case string(TypeJSON):
		var js JSONSerialization
		err := json.Unmarshal(body, &js)
		return js, err
	case string(TypeCsv):
		var cs CsvSerialization
		err := json.Unmarshal(body, &cs)
		return cs, err
	default:
		var s Serialization
		err := json.Unmarshal(body, &s)
		return s, err
	}
}
func unmarshalBasicSerializationArray(body []byte) ([]BasicSerialization, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]BasicSerialization, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalBasicSerialization(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// MarshalJSON is the custom marshaler for Serialization.
func (s Serialization) MarshalJSON() ([]byte, error) {
	s.Type = TypeSerialization
	objectMap := make(map[string]interface{})
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// AsAvroSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AsSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsSerialization() (*Serialization, bool) {
	return &s, true
}

// AsBasicSerialization is the BasicSerialization implementation for Serialization.
func (s Serialization) AsBasicSerialization() (BasicSerialization, bool) {
	return &s, true
}

// ServiceBusDataSourceProperties the common properties that are associated with Service Bus data sources (Queues,
// Topics, Event Hubs, etc.).
type ServiceBusDataSourceProperties struct {
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
}

// ServiceBusQueueOutputDataSource describes a Service Bus Queue output data source.
type ServiceBusQueueOutputDataSource struct {
	// ServiceBusQueueOutputDataSourceProperties - The properties that are associated with a Service Bus Queue output. Required on PUT (CreateOrReplace) requests.
	*ServiceBusQueueOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) MarshalJSON() ([]byte, error) {
	sbqods.Type = TypeMicrosoftServiceBusQueue
	objectMap := make(map[string]interface{})
	if sbqods.ServiceBusQueueOutputDataSourceProperties != nil {
		objectMap["properties"] = sbqods.ServiceBusQueueOutputDataSourceProperties
	}
	objectMap["type"] = sbqods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return &sbqods, true
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &sbqods, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceBusQueueOutputDataSource struct.
func (sbqods *ServiceBusQueueOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceBusQueueOutputDataSourceProperties ServiceBusQueueOutputDataSourceProperties
				err = json.Unmarshal(*v, &serviceBusQueueOutputDataSourceProperties)
				if err != nil {
					return err
				}
				sbqods.ServiceBusQueueOutputDataSourceProperties = &serviceBusQueueOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbqods.Type = typeVar
			}
		}
	}

	return nil
}

// ServiceBusQueueOutputDataSourceProperties the properties that are associated with a Service Bus Queue output.
type ServiceBusQueueOutputDataSourceProperties struct {
	// QueueName - The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
	QueueName *string `json:"queueName,omitempty"`
	// PropertyColumns - A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns *[]string `json:"propertyColumns,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
}

// ServiceBusTopicOutputDataSource describes a Service Bus Topic output data source.
type ServiceBusTopicOutputDataSource struct {
	// ServiceBusTopicOutputDataSourceProperties - The properties that are associated with a Service Bus Topic output. Required on PUT (CreateOrReplace) requests.
	*ServiceBusTopicOutputDataSourceProperties `json:"properties,omitempty"`
	// Type - Possible values include: 'TypeOutputDataSource', 'TypeMicrosoftDataLakeAccounts', 'TypePowerBI', 'TypeMicrosoftServiceBusTopic', 'TypeMicrosoftServiceBusQueue', 'TypeMicrosoftStorageDocumentDB', 'TypeMicrosoftSQLServerDatabase', 'TypeMicrosoftServiceBusEventHub', 'TypeMicrosoftStorageTable', 'TypeMicrosoftStorageBlob'
	Type TypeBasicOutputDataSource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) MarshalJSON() ([]byte, error) {
	sbtods.Type = TypeMicrosoftServiceBusTopic
	objectMap := make(map[string]interface{})
	if sbtods.ServiceBusTopicOutputDataSourceProperties != nil {
		objectMap["properties"] = sbtods.ServiceBusTopicOutputDataSourceProperties
	}
	objectMap["type"] = sbtods.Type
	return json.Marshal(objectMap)
}

// AsAzureDataLakeStoreOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return &sbtods, true
}

// AsServiceBusQueueOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AsOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsOutputDataSource() (*OutputDataSource, bool) {
	return nil, false
}

// AsBasicOutputDataSource is the BasicOutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsBasicOutputDataSource() (BasicOutputDataSource, bool) {
	return &sbtods, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceBusTopicOutputDataSource struct.
func (sbtods *ServiceBusTopicOutputDataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceBusTopicOutputDataSourceProperties ServiceBusTopicOutputDataSourceProperties
				err = json.Unmarshal(*v, &serviceBusTopicOutputDataSourceProperties)
				if err != nil {
					return err
				}
				sbtods.ServiceBusTopicOutputDataSourceProperties = &serviceBusTopicOutputDataSourceProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicOutputDataSource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbtods.Type = typeVar
			}
		}
	}

	return nil
}

// ServiceBusTopicOutputDataSourceProperties the properties that are associated with a Service Bus Topic output.
type ServiceBusTopicOutputDataSourceProperties struct {
	// TopicName - The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
	TopicName *string `json:"topicName,omitempty"`
	// PropertyColumns - A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns *[]string `json:"propertyColumns,omitempty"`
	// ServiceBusNamespace - The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// SharedAccessPolicyName - The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// SharedAccessPolicyKey - The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`
}

// Sku the properties that are associated with a SKU.
type Sku struct {
	// Name - The name of the SKU. Required on PUT (CreateOrReplace) requests. Possible values include: 'Standard'
	Name SkuName `json:"name,omitempty"`
}

// StartStreamingJobParameters parameters supplied to the Start Streaming Job operation.
type StartStreamingJobParameters struct {
	// OutputStartMode - Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time. Possible values include: 'JobStartTime', 'CustomTime', 'LastOutputEventTime'
	OutputStartMode OutputStartMode `json:"outputStartMode,omitempty"`
	// OutputStartTime - Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *date.Time `json:"outputStartTime,omitempty"`
}

// StorageAccount the properties that are associated with an Azure Storage account
type StorageAccount struct {
	// AccountName - The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`
}

// StreamingJob a streamng job object, containing all information associated with the named streaming job.
type StreamingJob struct {
	autorest.Response `json:"-"`
	// StreamingJobProperties - The properties that are associated with a streaming job.  Required on PUT (CreateOrReplace) requests.
	*StreamingJobProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location. Required on PUT (CreateOrReplace) requests.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StreamingJob.
func (sj StreamingJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sj.StreamingJobProperties != nil {
		objectMap["properties"] = sj.StreamingJobProperties
	}
	if sj.ID != nil {
		objectMap["id"] = sj.ID
	}
	if sj.Name != nil {
		objectMap["name"] = sj.Name
	}
	if sj.Type != nil {
		objectMap["type"] = sj.Type
	}
	if sj.Location != nil {
		objectMap["location"] = sj.Location
	}
	if sj.Tags != nil {
		objectMap["tags"] = sj.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StreamingJob struct.
func (sj *StreamingJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var streamingJobProperties StreamingJobProperties
				err = json.Unmarshal(*v, &streamingJobProperties)
				if err != nil {
					return err
				}
				sj.StreamingJobProperties = &streamingJobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sj.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sj.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sj.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sj.Tags = tags
			}
		}
	}

	return nil
}

// StreamingJobListResult object containing a list of streaming jobs.
type StreamingJobListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of streaming jobs. Populated by a 'List' operation.
	Value *[]StreamingJob `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StreamingJobListResultIterator provides access to a complete listing of StreamingJob values.
type StreamingJobListResultIterator struct {
	i    int
	page StreamingJobListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StreamingJobListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StreamingJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StreamingJobListResultIterator) Response() StreamingJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StreamingJobListResultIterator) Value() StreamingJob {
	if !iter.page.NotDone() {
		return StreamingJob{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sjlr StreamingJobListResult) IsEmpty() bool {
	return sjlr.Value == nil || len(*sjlr.Value) == 0
}

// streamingJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sjlr StreamingJobListResult) streamingJobListResultPreparer() (*http.Request, error) {
	if sjlr.NextLink == nil || len(to.String(sjlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sjlr.NextLink)))
}

// StreamingJobListResultPage contains a page of StreamingJob values.
type StreamingJobListResultPage struct {
	fn   func(StreamingJobListResult) (StreamingJobListResult, error)
	sjlr StreamingJobListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StreamingJobListResultPage) Next() error {
	next, err := page.fn(page.sjlr)
	if err != nil {
		return err
	}
	page.sjlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StreamingJobListResultPage) NotDone() bool {
	return !page.sjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StreamingJobListResultPage) Response() StreamingJobListResult {
	return page.sjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StreamingJobListResultPage) Values() []StreamingJob {
	if page.sjlr.IsEmpty() {
		return nil
	}
	return *page.sjlr.Value
}

// StreamingJobProperties the properties that are associated with a streaming job.
type StreamingJobProperties struct {
	// Sku - Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
	Sku *Sku `json:"sku,omitempty"`
	// JobID - A GUID uniquely identifying the streaming job. This GUID is generated upon creation of the streaming job.
	JobID *string `json:"jobId,omitempty"`
	// ProvisioningState - Describes the provisioning status of the streaming job.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// JobState - Describes the state of the streaming job.
	JobState *string `json:"jobState,omitempty"`
	// OutputStartMode - This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time. Possible values include: 'JobStartTime', 'CustomTime', 'LastOutputEventTime'
	OutputStartMode OutputStartMode `json:"outputStartMode,omitempty"`
	// OutputStartTime - Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *date.Time `json:"outputStartTime,omitempty"`
	// LastOutputEventTime - Value is either an ISO-8601 formatted timestamp indicating the last output event time of the streaming job or null indicating that output has not yet been produced. In case of multiple outputs or multiple streams, this shows the latest value in that set.
	LastOutputEventTime *date.Time `json:"lastOutputEventTime,omitempty"`
	// EventsOutOfOrderPolicy - Indicates the policy to apply to events that arrive out of order in the input event stream. Possible values include: 'Adjust', 'Drop'
	EventsOutOfOrderPolicy EventsOutOfOrderPolicy `json:"eventsOutOfOrderPolicy,omitempty"`
	// OutputErrorPolicy - Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size). Possible values include: 'OutputErrorPolicyStop', 'OutputErrorPolicyDrop'
	OutputErrorPolicy OutputErrorPolicy `json:"outputErrorPolicy,omitempty"`
	// EventsOutOfOrderMaxDelayInSeconds - The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
	EventsOutOfOrderMaxDelayInSeconds *int32 `json:"eventsOutOfOrderMaxDelayInSeconds,omitempty"`
	// EventsLateArrivalMaxDelayInSeconds - The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1.
	EventsLateArrivalMaxDelayInSeconds *int32 `json:"eventsLateArrivalMaxDelayInSeconds,omitempty"`
	// DataLocale - The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified.
	DataLocale *string `json:"dataLocale,omitempty"`
	// CompatibilityLevel - Controls certain runtime behaviors of the streaming job. Possible values include: 'OneFullStopZero'
	CompatibilityLevel CompatibilityLevel `json:"compatibilityLevel,omitempty"`
	// CreatedDate - Value is an ISO-8601 formatted UTC timestamp indicating when the streaming job was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Inputs - A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
	Inputs *[]Input `json:"inputs,omitempty"`
	// Transformation - Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual tranformation.
	Transformation *Transformation `json:"transformation,omitempty"`
	// Outputs - A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
	Outputs *[]Output `json:"outputs,omitempty"`
	// Functions - A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
	Functions *[]Function `json:"functions,omitempty"`
	// Etag - The current entity tag for the streaming job. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
}

// StreamingJobsCreateOrReplaceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingJobsCreateOrReplaceFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future StreamingJobsCreateOrReplaceFuture) Result(client StreamingJobsClient) (sj StreamingJob, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsCreateOrReplaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sj, azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsCreateOrReplaceFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sj, err = client.CreateOrReplaceResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsCreateOrReplaceFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsCreateOrReplaceFuture", "Result", resp, "Failure sending request")
		return
	}
	sj, err = client.CreateOrReplaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsCreateOrReplaceFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// StreamingJobsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type StreamingJobsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future StreamingJobsDeleteFuture) Result(client StreamingJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// StreamingJobsStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type StreamingJobsStartFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future StreamingJobsStartFuture) Result(client StreamingJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsStartFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.StartResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStartFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStartFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.StartResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStartFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// StreamingJobsStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type StreamingJobsStopFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future StreamingJobsStopFuture) Result(client StreamingJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("streamanalytics.StreamingJobsStopFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.StopResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStopFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStopFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.StopResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "streamanalytics.StreamingJobsStopFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// BasicStreamInputDataSource describes an input data source that contains stream data.
type BasicStreamInputDataSource interface {
	AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool)
	AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool)
	AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool)
	AsStreamInputDataSource() (*StreamInputDataSource, bool)
}

// StreamInputDataSource describes an input data source that contains stream data.
type StreamInputDataSource struct {
	// Type - Possible values include: 'TypeBasicStreamInputDataSourceTypeStreamInputDataSource', 'TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs', 'TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub', 'TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob'
	Type TypeBasicStreamInputDataSource `json:"type,omitempty"`
}

func unmarshalBasicStreamInputDataSource(body []byte) (BasicStreamInputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs):
		var ithsids IoTHubStreamInputDataSource
		err := json.Unmarshal(body, &ithsids)
		return ithsids, err
	case string(TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub):
		var ehsids EventHubStreamInputDataSource
		err := json.Unmarshal(body, &ehsids)
		return ehsids, err
	case string(TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob):
		var bsids BlobStreamInputDataSource
		err := json.Unmarshal(body, &bsids)
		return bsids, err
	default:
		var sids StreamInputDataSource
		err := json.Unmarshal(body, &sids)
		return sids, err
	}
}
func unmarshalBasicStreamInputDataSourceArray(body []byte) ([]BasicStreamInputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sidsArray := make([]BasicStreamInputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sids, err := unmarshalBasicStreamInputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		sidsArray[index] = sids
	}
	return sidsArray, nil
}

// MarshalJSON is the custom marshaler for StreamInputDataSource.
func (sids StreamInputDataSource) MarshalJSON() ([]byte, error) {
	sids.Type = TypeBasicStreamInputDataSourceTypeStreamInputDataSource
	objectMap := make(map[string]interface{})
	objectMap["type"] = sids.Type
	return json.Marshal(objectMap)
}

// AsIoTHubStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// AsStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsStreamInputDataSource() (*StreamInputDataSource, bool) {
	return &sids, true
}

// AsBasicStreamInputDataSource is the BasicStreamInputDataSource implementation for StreamInputDataSource.
func (sids StreamInputDataSource) AsBasicStreamInputDataSource() (BasicStreamInputDataSource, bool) {
	return &sids, true
}

// StreamInputProperties the properties that are associated with an input containing stream data.
type StreamInputProperties struct {
	// Datasource - Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
	Datasource BasicStreamInputDataSource `json:"datasource,omitempty"`
	// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
	Serialization BasicSerialization `json:"serialization,omitempty"`
	// Diagnostics - Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty"`
	// Etag - The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
	// Type - Possible values include: 'TypeInputProperties', 'TypeReference', 'TypeStream'
	Type TypeBasicInputProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamInputProperties.
func (sip StreamInputProperties) MarshalJSON() ([]byte, error) {
	sip.Type = TypeStream
	objectMap := make(map[string]interface{})
	objectMap["datasource"] = sip.Datasource
	objectMap["serialization"] = sip.Serialization
	if sip.Diagnostics != nil {
		objectMap["diagnostics"] = sip.Diagnostics
	}
	if sip.Etag != nil {
		objectMap["etag"] = sip.Etag
	}
	objectMap["type"] = sip.Type
	return json.Marshal(objectMap)
}

// AsReferenceInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return nil, false
}

// AsStreamInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return &sip, true
}

// AsInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsInputProperties() (*InputProperties, bool) {
	return nil, false
}

// AsBasicInputProperties is the BasicInputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsBasicInputProperties() (BasicInputProperties, bool) {
	return &sip, true
}

// UnmarshalJSON is the custom unmarshaler for StreamInputProperties struct.
func (sip *StreamInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "datasource":
			if v != nil {
				datasource, err := unmarshalBasicStreamInputDataSource(*v)
				if err != nil {
					return err
				}
				sip.Datasource = datasource
			}
		case "serialization":
			if v != nil {
				serialization, err := unmarshalBasicSerialization(*v)
				if err != nil {
					return err
				}
				sip.Serialization = serialization
			}
		case "diagnostics":
			if v != nil {
				var diagnostics Diagnostics
				err = json.Unmarshal(*v, &diagnostics)
				if err != nil {
					return err
				}
				sip.Diagnostics = &diagnostics
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sip.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicInputProperties
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sip.Type = typeVar
			}
		}
	}

	return nil
}

// SubResource the base sub-resource model definition.
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// SubscriptionQuota describes the current quota for the subscription.
type SubscriptionQuota struct {
	// SubscriptionQuotaProperties - Describes the properties of the quota.
	*SubscriptionQuotaProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionQuota struct.
func (sq *SubscriptionQuota) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionQuotaProperties SubscriptionQuotaProperties
				err = json.Unmarshal(*v, &subscriptionQuotaProperties)
				if err != nil {
					return err
				}
				sq.SubscriptionQuotaProperties = &subscriptionQuotaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sq.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionQuotaProperties describes the properties of the quota.
type SubscriptionQuotaProperties struct {
	// MaxCount - The max permitted usage of this resource.
	MaxCount *int32 `json:"maxCount,omitempty"`
	// CurrentCount - The current usage of this resource.
	CurrentCount *int32 `json:"currentCount,omitempty"`
}

// SubscriptionQuotasListResult result of the GetQuotas operation. It contains a list of quotas for the
// subscription in a particular region.
type SubscriptionQuotasListResult struct {
	autorest.Response `json:"-"`
	// Value - List of quotas for the subscription in a particular region.
	Value *[]SubscriptionQuota `json:"value,omitempty"`
}

// Transformation a transformation object, containing all information associated with the named transformation. All
// transformations are contained under a streaming job.
type Transformation struct {
	autorest.Response `json:"-"`
	// TransformationProperties - The properties that are associated with a transformation. Required on PUT (CreateOrReplace) requests.
	*TransformationProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Transformation struct.
func (t *Transformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transformationProperties TransformationProperties
				err = json.Unmarshal(*v, &transformationProperties)
				if err != nil {
					return err
				}
				t.TransformationProperties = &transformationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TransformationProperties the properties that are associated with a transformation.
type TransformationProperties struct {
	// StreamingUnits - Specifies the number of streaming units that the streaming job uses.
	StreamingUnits *int32 `json:"streamingUnits,omitempty"`
	// Query - Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
	Query *string `json:"query,omitempty"`
	// Etag - The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty"`
}
