// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package comprehendiface provides an interface to enable mocking the Amazon Comprehend service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package comprehendiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/comprehend"
)

// ComprehendAPI provides an interface to enable mocking the
// comprehend.Comprehend service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Comprehend.
//    func myFunc(svc comprehendiface.ComprehendAPI) bool {
//        // Make svc.BatchDetectDominantLanguage request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := comprehend.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockComprehendClient struct {
//        comprehendiface.ComprehendAPI
//    }
//    func (m *mockComprehendClient) BatchDetectDominantLanguage(input *comprehend.BatchDetectDominantLanguageInput) (*comprehend.BatchDetectDominantLanguageOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockComprehendClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ComprehendAPI interface {
	BatchDetectDominantLanguage(*comprehend.BatchDetectDominantLanguageInput) (*comprehend.BatchDetectDominantLanguageOutput, error)
	BatchDetectDominantLanguageWithContext(aws.Context, *comprehend.BatchDetectDominantLanguageInput, ...request.Option) (*comprehend.BatchDetectDominantLanguageOutput, error)
	BatchDetectDominantLanguageRequest(*comprehend.BatchDetectDominantLanguageInput) (*request.Request, *comprehend.BatchDetectDominantLanguageOutput)

	BatchDetectEntities(*comprehend.BatchDetectEntitiesInput) (*comprehend.BatchDetectEntitiesOutput, error)
	BatchDetectEntitiesWithContext(aws.Context, *comprehend.BatchDetectEntitiesInput, ...request.Option) (*comprehend.BatchDetectEntitiesOutput, error)
	BatchDetectEntitiesRequest(*comprehend.BatchDetectEntitiesInput) (*request.Request, *comprehend.BatchDetectEntitiesOutput)

	BatchDetectKeyPhrases(*comprehend.BatchDetectKeyPhrasesInput) (*comprehend.BatchDetectKeyPhrasesOutput, error)
	BatchDetectKeyPhrasesWithContext(aws.Context, *comprehend.BatchDetectKeyPhrasesInput, ...request.Option) (*comprehend.BatchDetectKeyPhrasesOutput, error)
	BatchDetectKeyPhrasesRequest(*comprehend.BatchDetectKeyPhrasesInput) (*request.Request, *comprehend.BatchDetectKeyPhrasesOutput)

	BatchDetectSentiment(*comprehend.BatchDetectSentimentInput) (*comprehend.BatchDetectSentimentOutput, error)
	BatchDetectSentimentWithContext(aws.Context, *comprehend.BatchDetectSentimentInput, ...request.Option) (*comprehend.BatchDetectSentimentOutput, error)
	BatchDetectSentimentRequest(*comprehend.BatchDetectSentimentInput) (*request.Request, *comprehend.BatchDetectSentimentOutput)

	DescribeTopicsDetectionJob(*comprehend.DescribeTopicsDetectionJobInput) (*comprehend.DescribeTopicsDetectionJobOutput, error)
	DescribeTopicsDetectionJobWithContext(aws.Context, *comprehend.DescribeTopicsDetectionJobInput, ...request.Option) (*comprehend.DescribeTopicsDetectionJobOutput, error)
	DescribeTopicsDetectionJobRequest(*comprehend.DescribeTopicsDetectionJobInput) (*request.Request, *comprehend.DescribeTopicsDetectionJobOutput)

	DetectDominantLanguage(*comprehend.DetectDominantLanguageInput) (*comprehend.DetectDominantLanguageOutput, error)
	DetectDominantLanguageWithContext(aws.Context, *comprehend.DetectDominantLanguageInput, ...request.Option) (*comprehend.DetectDominantLanguageOutput, error)
	DetectDominantLanguageRequest(*comprehend.DetectDominantLanguageInput) (*request.Request, *comprehend.DetectDominantLanguageOutput)

	DetectEntities(*comprehend.DetectEntitiesInput) (*comprehend.DetectEntitiesOutput, error)
	DetectEntitiesWithContext(aws.Context, *comprehend.DetectEntitiesInput, ...request.Option) (*comprehend.DetectEntitiesOutput, error)
	DetectEntitiesRequest(*comprehend.DetectEntitiesInput) (*request.Request, *comprehend.DetectEntitiesOutput)

	DetectKeyPhrases(*comprehend.DetectKeyPhrasesInput) (*comprehend.DetectKeyPhrasesOutput, error)
	DetectKeyPhrasesWithContext(aws.Context, *comprehend.DetectKeyPhrasesInput, ...request.Option) (*comprehend.DetectKeyPhrasesOutput, error)
	DetectKeyPhrasesRequest(*comprehend.DetectKeyPhrasesInput) (*request.Request, *comprehend.DetectKeyPhrasesOutput)

	DetectSentiment(*comprehend.DetectSentimentInput) (*comprehend.DetectSentimentOutput, error)
	DetectSentimentWithContext(aws.Context, *comprehend.DetectSentimentInput, ...request.Option) (*comprehend.DetectSentimentOutput, error)
	DetectSentimentRequest(*comprehend.DetectSentimentInput) (*request.Request, *comprehend.DetectSentimentOutput)

	ListTopicsDetectionJobs(*comprehend.ListTopicsDetectionJobsInput) (*comprehend.ListTopicsDetectionJobsOutput, error)
	ListTopicsDetectionJobsWithContext(aws.Context, *comprehend.ListTopicsDetectionJobsInput, ...request.Option) (*comprehend.ListTopicsDetectionJobsOutput, error)
	ListTopicsDetectionJobsRequest(*comprehend.ListTopicsDetectionJobsInput) (*request.Request, *comprehend.ListTopicsDetectionJobsOutput)

	ListTopicsDetectionJobsPages(*comprehend.ListTopicsDetectionJobsInput, func(*comprehend.ListTopicsDetectionJobsOutput, bool) bool) error
	ListTopicsDetectionJobsPagesWithContext(aws.Context, *comprehend.ListTopicsDetectionJobsInput, func(*comprehend.ListTopicsDetectionJobsOutput, bool) bool, ...request.Option) error

	StartTopicsDetectionJob(*comprehend.StartTopicsDetectionJobInput) (*comprehend.StartTopicsDetectionJobOutput, error)
	StartTopicsDetectionJobWithContext(aws.Context, *comprehend.StartTopicsDetectionJobInput, ...request.Option) (*comprehend.StartTopicsDetectionJobOutput, error)
	StartTopicsDetectionJobRequest(*comprehend.StartTopicsDetectionJobInput) (*request.Request, *comprehend.StartTopicsDetectionJobOutput)
}

var _ ComprehendAPI = (*comprehend.Comprehend)(nil)
