/*
Copyright 2019 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	operators "github.com/operator-framework/operator-lifecycle-manager/pkg/api/apis/operators"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeInstallPlans implements InstallPlanInterface
type FakeInstallPlans struct {
	Fake *FakeOperators
	ns   string
}

var installplansResource = schema.GroupVersionResource{Group: "operators.coreos.com", Version: "", Resource: "installplans"}

var installplansKind = schema.GroupVersionKind{Group: "operators.coreos.com", Version: "", Kind: "InstallPlan"}

// Get takes name of the installPlan, and returns the corresponding installPlan object, and an error if there is any.
func (c *FakeInstallPlans) Get(name string, options v1.GetOptions) (result *operators.InstallPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(installplansResource, c.ns, name), &operators.InstallPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.InstallPlan), err
}

// List takes label and field selectors, and returns the list of InstallPlans that match those selectors.
func (c *FakeInstallPlans) List(opts v1.ListOptions) (result *operators.InstallPlanList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(installplansResource, installplansKind, c.ns, opts), &operators.InstallPlanList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &operators.InstallPlanList{ListMeta: obj.(*operators.InstallPlanList).ListMeta}
	for _, item := range obj.(*operators.InstallPlanList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested installPlans.
func (c *FakeInstallPlans) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(installplansResource, c.ns, opts))

}

// Create takes the representation of a installPlan and creates it.  Returns the server's representation of the installPlan, and an error, if there is any.
func (c *FakeInstallPlans) Create(installPlan *operators.InstallPlan) (result *operators.InstallPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(installplansResource, c.ns, installPlan), &operators.InstallPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.InstallPlan), err
}

// Update takes the representation of a installPlan and updates it. Returns the server's representation of the installPlan, and an error, if there is any.
func (c *FakeInstallPlans) Update(installPlan *operators.InstallPlan) (result *operators.InstallPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(installplansResource, c.ns, installPlan), &operators.InstallPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.InstallPlan), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeInstallPlans) UpdateStatus(installPlan *operators.InstallPlan) (*operators.InstallPlan, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(installplansResource, "status", c.ns, installPlan), &operators.InstallPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.InstallPlan), err
}

// Delete takes name of the installPlan and deletes it. Returns an error if one occurs.
func (c *FakeInstallPlans) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(installplansResource, c.ns, name), &operators.InstallPlan{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeInstallPlans) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(installplansResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &operators.InstallPlanList{})
	return err
}

// Patch applies the patch and returns the patched installPlan.
func (c *FakeInstallPlans) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *operators.InstallPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(installplansResource, c.ns, name, pt, data, subresources...), &operators.InstallPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.InstallPlan), err
}
