/*
Copyright 2019 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package internalversion

import (
	time "time"

	operators "github.com/operator-framework/operator-lifecycle-manager/pkg/api/apis/operators"
	clientsetinternalversion "github.com/operator-framework/operator-lifecycle-manager/pkg/api/client/clientset/internalversion"
	internalinterfaces "github.com/operator-framework/operator-lifecycle-manager/pkg/api/client/informers/internalversion/internalinterfaces"
	internalversion "github.com/operator-framework/operator-lifecycle-manager/pkg/api/client/listers/operators/internalversion"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// InstallPlanInformer provides access to a shared informer and lister for
// InstallPlans.
type InstallPlanInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() internalversion.InstallPlanLister
}

type installPlanInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewInstallPlanInformer constructs a new informer for InstallPlan type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewInstallPlanInformer(client clientsetinternalversion.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredInstallPlanInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredInstallPlanInformer constructs a new informer for InstallPlan type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredInstallPlanInformer(client clientsetinternalversion.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.Operators().InstallPlans(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.Operators().InstallPlans(namespace).Watch(options)
			},
		},
		&operators.InstallPlan{},
		resyncPeriod,
		indexers,
	)
}

func (f *installPlanInformer) defaultInformer(client clientsetinternalversion.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredInstallPlanInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *installPlanInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&operators.InstallPlan{}, f.defaultInformer)
}

func (f *installPlanInformer) Lister() internalversion.InstallPlanLister {
	return internalversion.NewInstallPlanLister(f.Informer().GetIndexer())
}
