// Code generated by protoc-gen-go.
// source: registry.proto
// DO NOT EDIT!

/*
Package api is a generated protocol buffer package.

It is generated from these files:
	registry.proto

It has these top-level messages:
	Channel
	PackageName
	Package
	GroupVersionKind
	Bundle
	ChannelEntry
	ListPackageRequest
	GetPackageRequest
	GetBundleRequest
	GetBundleInChannelRequest
	GetAllReplacementsRequest
	GetReplacementRequest
	GetAllProvidersRequest
	GetLatestProvidersRequest
	GetDefaultProviderRequest
*/
package api

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Channel struct {
	Name    string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	CsvName string `protobuf:"bytes,2,opt,name=csvName" json:"csvName,omitempty"`
}

func (m *Channel) Reset()                    { *m = Channel{} }
func (m *Channel) String() string            { return proto.CompactTextString(m) }
func (*Channel) ProtoMessage()               {}
func (*Channel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Channel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Channel) GetCsvName() string {
	if m != nil {
		return m.CsvName
	}
	return ""
}

type PackageName struct {
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *PackageName) Reset()                    { *m = PackageName{} }
func (m *PackageName) String() string            { return proto.CompactTextString(m) }
func (*PackageName) ProtoMessage()               {}
func (*PackageName) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *PackageName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type Package struct {
	Name               string     `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Channels           []*Channel `protobuf:"bytes,2,rep,name=channels" json:"channels,omitempty"`
	DefaultChannelName string     `protobuf:"bytes,3,opt,name=defaultChannelName" json:"defaultChannelName,omitempty"`
}

func (m *Package) Reset()                    { *m = Package{} }
func (m *Package) String() string            { return proto.CompactTextString(m) }
func (*Package) ProtoMessage()               {}
func (*Package) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Package) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Package) GetChannels() []*Channel {
	if m != nil {
		return m.Channels
	}
	return nil
}

func (m *Package) GetDefaultChannelName() string {
	if m != nil {
		return m.DefaultChannelName
	}
	return ""
}

type GroupVersionKind struct {
	Group   string `protobuf:"bytes,1,opt,name=group" json:"group,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	Kind    string `protobuf:"bytes,3,opt,name=kind" json:"kind,omitempty"`
	Plural  string `protobuf:"bytes,4,opt,name=plural" json:"plural,omitempty"`
}

func (m *GroupVersionKind) Reset()                    { *m = GroupVersionKind{} }
func (m *GroupVersionKind) String() string            { return proto.CompactTextString(m) }
func (*GroupVersionKind) ProtoMessage()               {}
func (*GroupVersionKind) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *GroupVersionKind) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *GroupVersionKind) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *GroupVersionKind) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *GroupVersionKind) GetPlural() string {
	if m != nil {
		return m.Plural
	}
	return ""
}

type Bundle struct {
	CsvName      string              `protobuf:"bytes,1,opt,name=csvName" json:"csvName,omitempty"`
	PackageName  string              `protobuf:"bytes,2,opt,name=packageName" json:"packageName,omitempty"`
	ChannelName  string              `protobuf:"bytes,3,opt,name=channelName" json:"channelName,omitempty"`
	CsvJson      string              `protobuf:"bytes,4,opt,name=csvJson" json:"csvJson,omitempty"`
	Object       []string            `protobuf:"bytes,5,rep,name=object" json:"object,omitempty"`
	BundlePath   string              `protobuf:"bytes,6,opt,name=bundlePath" json:"bundlePath,omitempty"`
	ProvidedApis []*GroupVersionKind `protobuf:"bytes,7,rep,name=providedApis" json:"providedApis,omitempty"`
	RequiredApis []*GroupVersionKind `protobuf:"bytes,8,rep,name=requiredApis" json:"requiredApis,omitempty"`
}

func (m *Bundle) Reset()                    { *m = Bundle{} }
func (m *Bundle) String() string            { return proto.CompactTextString(m) }
func (*Bundle) ProtoMessage()               {}
func (*Bundle) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Bundle) GetCsvName() string {
	if m != nil {
		return m.CsvName
	}
	return ""
}

func (m *Bundle) GetPackageName() string {
	if m != nil {
		return m.PackageName
	}
	return ""
}

func (m *Bundle) GetChannelName() string {
	if m != nil {
		return m.ChannelName
	}
	return ""
}

func (m *Bundle) GetCsvJson() string {
	if m != nil {
		return m.CsvJson
	}
	return ""
}

func (m *Bundle) GetObject() []string {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *Bundle) GetBundlePath() string {
	if m != nil {
		return m.BundlePath
	}
	return ""
}

func (m *Bundle) GetProvidedApis() []*GroupVersionKind {
	if m != nil {
		return m.ProvidedApis
	}
	return nil
}

func (m *Bundle) GetRequiredApis() []*GroupVersionKind {
	if m != nil {
		return m.RequiredApis
	}
	return nil
}

type ChannelEntry struct {
	PackageName string `protobuf:"bytes,1,opt,name=packageName" json:"packageName,omitempty"`
	ChannelName string `protobuf:"bytes,2,opt,name=channelName" json:"channelName,omitempty"`
	BundleName  string `protobuf:"bytes,3,opt,name=bundleName" json:"bundleName,omitempty"`
	Replaces    string `protobuf:"bytes,4,opt,name=replaces" json:"replaces,omitempty"`
}

func (m *ChannelEntry) Reset()                    { *m = ChannelEntry{} }
func (m *ChannelEntry) String() string            { return proto.CompactTextString(m) }
func (*ChannelEntry) ProtoMessage()               {}
func (*ChannelEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ChannelEntry) GetPackageName() string {
	if m != nil {
		return m.PackageName
	}
	return ""
}

func (m *ChannelEntry) GetChannelName() string {
	if m != nil {
		return m.ChannelName
	}
	return ""
}

func (m *ChannelEntry) GetBundleName() string {
	if m != nil {
		return m.BundleName
	}
	return ""
}

func (m *ChannelEntry) GetReplaces() string {
	if m != nil {
		return m.Replaces
	}
	return ""
}

type ListPackageRequest struct {
}

func (m *ListPackageRequest) Reset()                    { *m = ListPackageRequest{} }
func (m *ListPackageRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPackageRequest) ProtoMessage()               {}
func (*ListPackageRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type GetPackageRequest struct {
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetPackageRequest) Reset()                    { *m = GetPackageRequest{} }
func (m *GetPackageRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPackageRequest) ProtoMessage()               {}
func (*GetPackageRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetPackageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type GetBundleRequest struct {
	PkgName     string `protobuf:"bytes,1,opt,name=pkgName" json:"pkgName,omitempty"`
	ChannelName string `protobuf:"bytes,2,opt,name=channelName" json:"channelName,omitempty"`
	CsvName     string `protobuf:"bytes,3,opt,name=csvName" json:"csvName,omitempty"`
}

func (m *GetBundleRequest) Reset()                    { *m = GetBundleRequest{} }
func (m *GetBundleRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBundleRequest) ProtoMessage()               {}
func (*GetBundleRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GetBundleRequest) GetPkgName() string {
	if m != nil {
		return m.PkgName
	}
	return ""
}

func (m *GetBundleRequest) GetChannelName() string {
	if m != nil {
		return m.ChannelName
	}
	return ""
}

func (m *GetBundleRequest) GetCsvName() string {
	if m != nil {
		return m.CsvName
	}
	return ""
}

type GetBundleInChannelRequest struct {
	PkgName     string `protobuf:"bytes,1,opt,name=pkgName" json:"pkgName,omitempty"`
	ChannelName string `protobuf:"bytes,2,opt,name=channelName" json:"channelName,omitempty"`
}

func (m *GetBundleInChannelRequest) Reset()                    { *m = GetBundleInChannelRequest{} }
func (m *GetBundleInChannelRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBundleInChannelRequest) ProtoMessage()               {}
func (*GetBundleInChannelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *GetBundleInChannelRequest) GetPkgName() string {
	if m != nil {
		return m.PkgName
	}
	return ""
}

func (m *GetBundleInChannelRequest) GetChannelName() string {
	if m != nil {
		return m.ChannelName
	}
	return ""
}

type GetAllReplacementsRequest struct {
	CsvName string `protobuf:"bytes,1,opt,name=csvName" json:"csvName,omitempty"`
}

func (m *GetAllReplacementsRequest) Reset()                    { *m = GetAllReplacementsRequest{} }
func (m *GetAllReplacementsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAllReplacementsRequest) ProtoMessage()               {}
func (*GetAllReplacementsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GetAllReplacementsRequest) GetCsvName() string {
	if m != nil {
		return m.CsvName
	}
	return ""
}

type GetReplacementRequest struct {
	CsvName     string `protobuf:"bytes,1,opt,name=csvName" json:"csvName,omitempty"`
	PkgName     string `protobuf:"bytes,2,opt,name=pkgName" json:"pkgName,omitempty"`
	ChannelName string `protobuf:"bytes,3,opt,name=channelName" json:"channelName,omitempty"`
}

func (m *GetReplacementRequest) Reset()                    { *m = GetReplacementRequest{} }
func (m *GetReplacementRequest) String() string            { return proto.CompactTextString(m) }
func (*GetReplacementRequest) ProtoMessage()               {}
func (*GetReplacementRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GetReplacementRequest) GetCsvName() string {
	if m != nil {
		return m.CsvName
	}
	return ""
}

func (m *GetReplacementRequest) GetPkgName() string {
	if m != nil {
		return m.PkgName
	}
	return ""
}

func (m *GetReplacementRequest) GetChannelName() string {
	if m != nil {
		return m.ChannelName
	}
	return ""
}

type GetAllProvidersRequest struct {
	Group   string `protobuf:"bytes,1,opt,name=group" json:"group,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	Kind    string `protobuf:"bytes,3,opt,name=kind" json:"kind,omitempty"`
	Plural  string `protobuf:"bytes,4,opt,name=plural" json:"plural,omitempty"`
}

func (m *GetAllProvidersRequest) Reset()                    { *m = GetAllProvidersRequest{} }
func (m *GetAllProvidersRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAllProvidersRequest) ProtoMessage()               {}
func (*GetAllProvidersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetAllProvidersRequest) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *GetAllProvidersRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *GetAllProvidersRequest) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *GetAllProvidersRequest) GetPlural() string {
	if m != nil {
		return m.Plural
	}
	return ""
}

type GetLatestProvidersRequest struct {
	Group   string `protobuf:"bytes,1,opt,name=group" json:"group,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	Kind    string `protobuf:"bytes,3,opt,name=kind" json:"kind,omitempty"`
	Plural  string `protobuf:"bytes,4,opt,name=plural" json:"plural,omitempty"`
}

func (m *GetLatestProvidersRequest) Reset()                    { *m = GetLatestProvidersRequest{} }
func (m *GetLatestProvidersRequest) String() string            { return proto.CompactTextString(m) }
func (*GetLatestProvidersRequest) ProtoMessage()               {}
func (*GetLatestProvidersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetLatestProvidersRequest) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *GetLatestProvidersRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *GetLatestProvidersRequest) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *GetLatestProvidersRequest) GetPlural() string {
	if m != nil {
		return m.Plural
	}
	return ""
}

type GetDefaultProviderRequest struct {
	Group   string `protobuf:"bytes,1,opt,name=group" json:"group,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	Kind    string `protobuf:"bytes,3,opt,name=kind" json:"kind,omitempty"`
	Plural  string `protobuf:"bytes,4,opt,name=plural" json:"plural,omitempty"`
}

func (m *GetDefaultProviderRequest) Reset()                    { *m = GetDefaultProviderRequest{} }
func (m *GetDefaultProviderRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDefaultProviderRequest) ProtoMessage()               {}
func (*GetDefaultProviderRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GetDefaultProviderRequest) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *GetDefaultProviderRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *GetDefaultProviderRequest) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *GetDefaultProviderRequest) GetPlural() string {
	if m != nil {
		return m.Plural
	}
	return ""
}

func init() {
	proto.RegisterType((*Channel)(nil), "api.Channel")
	proto.RegisterType((*PackageName)(nil), "api.PackageName")
	proto.RegisterType((*Package)(nil), "api.Package")
	proto.RegisterType((*GroupVersionKind)(nil), "api.GroupVersionKind")
	proto.RegisterType((*Bundle)(nil), "api.Bundle")
	proto.RegisterType((*ChannelEntry)(nil), "api.ChannelEntry")
	proto.RegisterType((*ListPackageRequest)(nil), "api.ListPackageRequest")
	proto.RegisterType((*GetPackageRequest)(nil), "api.GetPackageRequest")
	proto.RegisterType((*GetBundleRequest)(nil), "api.GetBundleRequest")
	proto.RegisterType((*GetBundleInChannelRequest)(nil), "api.GetBundleInChannelRequest")
	proto.RegisterType((*GetAllReplacementsRequest)(nil), "api.GetAllReplacementsRequest")
	proto.RegisterType((*GetReplacementRequest)(nil), "api.GetReplacementRequest")
	proto.RegisterType((*GetAllProvidersRequest)(nil), "api.GetAllProvidersRequest")
	proto.RegisterType((*GetLatestProvidersRequest)(nil), "api.GetLatestProvidersRequest")
	proto.RegisterType((*GetDefaultProviderRequest)(nil), "api.GetDefaultProviderRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Registry service

type RegistryClient interface {
	ListPackages(ctx context.Context, in *ListPackageRequest, opts ...grpc.CallOption) (Registry_ListPackagesClient, error)
	GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error)
	GetBundle(ctx context.Context, in *GetBundleRequest, opts ...grpc.CallOption) (*Bundle, error)
	GetBundleForChannel(ctx context.Context, in *GetBundleInChannelRequest, opts ...grpc.CallOption) (*Bundle, error)
	GetChannelEntriesThatReplace(ctx context.Context, in *GetAllReplacementsRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatReplaceClient, error)
	GetBundleThatReplaces(ctx context.Context, in *GetReplacementRequest, opts ...grpc.CallOption) (*Bundle, error)
	GetChannelEntriesThatProvide(ctx context.Context, in *GetAllProvidersRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatProvideClient, error)
	GetLatestChannelEntriesThatProvide(ctx context.Context, in *GetLatestProvidersRequest, opts ...grpc.CallOption) (Registry_GetLatestChannelEntriesThatProvideClient, error)
	GetDefaultBundleThatProvides(ctx context.Context, in *GetDefaultProviderRequest, opts ...grpc.CallOption) (*Bundle, error)
}

type registryClient struct {
	cc *grpc.ClientConn
}

func NewRegistryClient(cc *grpc.ClientConn) RegistryClient {
	return &registryClient{cc}
}

func (c *registryClient) ListPackages(ctx context.Context, in *ListPackageRequest, opts ...grpc.CallOption) (Registry_ListPackagesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Registry_serviceDesc.Streams[0], c.cc, "/api.Registry/ListPackages", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryListPackagesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_ListPackagesClient interface {
	Recv() (*PackageName, error)
	grpc.ClientStream
}

type registryListPackagesClient struct {
	grpc.ClientStream
}

func (x *registryListPackagesClient) Recv() (*PackageName, error) {
	m := new(PackageName)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error) {
	out := new(Package)
	err := grpc.Invoke(ctx, "/api.Registry/GetPackage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetBundle(ctx context.Context, in *GetBundleRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := grpc.Invoke(ctx, "/api.Registry/GetBundle", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetBundleForChannel(ctx context.Context, in *GetBundleInChannelRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := grpc.Invoke(ctx, "/api.Registry/GetBundleForChannel", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetChannelEntriesThatReplace(ctx context.Context, in *GetAllReplacementsRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatReplaceClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Registry_serviceDesc.Streams[1], c.cc, "/api.Registry/GetChannelEntriesThatReplace", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryGetChannelEntriesThatReplaceClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_GetChannelEntriesThatReplaceClient interface {
	Recv() (*ChannelEntry, error)
	grpc.ClientStream
}

type registryGetChannelEntriesThatReplaceClient struct {
	grpc.ClientStream
}

func (x *registryGetChannelEntriesThatReplaceClient) Recv() (*ChannelEntry, error) {
	m := new(ChannelEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetBundleThatReplaces(ctx context.Context, in *GetReplacementRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := grpc.Invoke(ctx, "/api.Registry/GetBundleThatReplaces", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetChannelEntriesThatProvide(ctx context.Context, in *GetAllProvidersRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatProvideClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Registry_serviceDesc.Streams[2], c.cc, "/api.Registry/GetChannelEntriesThatProvide", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryGetChannelEntriesThatProvideClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_GetChannelEntriesThatProvideClient interface {
	Recv() (*ChannelEntry, error)
	grpc.ClientStream
}

type registryGetChannelEntriesThatProvideClient struct {
	grpc.ClientStream
}

func (x *registryGetChannelEntriesThatProvideClient) Recv() (*ChannelEntry, error) {
	m := new(ChannelEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetLatestChannelEntriesThatProvide(ctx context.Context, in *GetLatestProvidersRequest, opts ...grpc.CallOption) (Registry_GetLatestChannelEntriesThatProvideClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Registry_serviceDesc.Streams[3], c.cc, "/api.Registry/GetLatestChannelEntriesThatProvide", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryGetLatestChannelEntriesThatProvideClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_GetLatestChannelEntriesThatProvideClient interface {
	Recv() (*ChannelEntry, error)
	grpc.ClientStream
}

type registryGetLatestChannelEntriesThatProvideClient struct {
	grpc.ClientStream
}

func (x *registryGetLatestChannelEntriesThatProvideClient) Recv() (*ChannelEntry, error) {
	m := new(ChannelEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetDefaultBundleThatProvides(ctx context.Context, in *GetDefaultProviderRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := grpc.Invoke(ctx, "/api.Registry/GetDefaultBundleThatProvides", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Registry service

type RegistryServer interface {
	ListPackages(*ListPackageRequest, Registry_ListPackagesServer) error
	GetPackage(context.Context, *GetPackageRequest) (*Package, error)
	GetBundle(context.Context, *GetBundleRequest) (*Bundle, error)
	GetBundleForChannel(context.Context, *GetBundleInChannelRequest) (*Bundle, error)
	GetChannelEntriesThatReplace(*GetAllReplacementsRequest, Registry_GetChannelEntriesThatReplaceServer) error
	GetBundleThatReplaces(context.Context, *GetReplacementRequest) (*Bundle, error)
	GetChannelEntriesThatProvide(*GetAllProvidersRequest, Registry_GetChannelEntriesThatProvideServer) error
	GetLatestChannelEntriesThatProvide(*GetLatestProvidersRequest, Registry_GetLatestChannelEntriesThatProvideServer) error
	GetDefaultBundleThatProvides(context.Context, *GetDefaultProviderRequest) (*Bundle, error)
}

func RegisterRegistryServer(s *grpc.Server, srv RegistryServer) {
	s.RegisterService(&_Registry_serviceDesc, srv)
}

func _Registry_ListPackages_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListPackageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).ListPackages(m, &registryListPackagesServer{stream})
}

type Registry_ListPackagesServer interface {
	Send(*PackageName) error
	grpc.ServerStream
}

type registryListPackagesServer struct {
	grpc.ServerStream
}

func (x *registryListPackagesServer) Send(m *PackageName) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetPackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetPackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetPackage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetPackage(ctx, req.(*GetPackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetBundle(ctx, req.(*GetBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetBundleForChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBundleInChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetBundleForChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetBundleForChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetBundleForChannel(ctx, req.(*GetBundleInChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetChannelEntriesThatReplace_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetAllReplacementsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).GetChannelEntriesThatReplace(m, &registryGetChannelEntriesThatReplaceServer{stream})
}

type Registry_GetChannelEntriesThatReplaceServer interface {
	Send(*ChannelEntry) error
	grpc.ServerStream
}

type registryGetChannelEntriesThatReplaceServer struct {
	grpc.ServerStream
}

func (x *registryGetChannelEntriesThatReplaceServer) Send(m *ChannelEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetBundleThatReplaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplacementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetBundleThatReplaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetBundleThatReplaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetBundleThatReplaces(ctx, req.(*GetReplacementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetChannelEntriesThatProvide_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetAllProvidersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).GetChannelEntriesThatProvide(m, &registryGetChannelEntriesThatProvideServer{stream})
}

type Registry_GetChannelEntriesThatProvideServer interface {
	Send(*ChannelEntry) error
	grpc.ServerStream
}

type registryGetChannelEntriesThatProvideServer struct {
	grpc.ServerStream
}

func (x *registryGetChannelEntriesThatProvideServer) Send(m *ChannelEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetLatestChannelEntriesThatProvide_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetLatestProvidersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).GetLatestChannelEntriesThatProvide(m, &registryGetLatestChannelEntriesThatProvideServer{stream})
}

type Registry_GetLatestChannelEntriesThatProvideServer interface {
	Send(*ChannelEntry) error
	grpc.ServerStream
}

type registryGetLatestChannelEntriesThatProvideServer struct {
	grpc.ServerStream
}

func (x *registryGetLatestChannelEntriesThatProvideServer) Send(m *ChannelEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetDefaultBundleThatProvides_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetDefaultBundleThatProvides(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetDefaultBundleThatProvides",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetDefaultBundleThatProvides(ctx, req.(*GetDefaultProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Registry_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.Registry",
	HandlerType: (*RegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPackage",
			Handler:    _Registry_GetPackage_Handler,
		},
		{
			MethodName: "GetBundle",
			Handler:    _Registry_GetBundle_Handler,
		},
		{
			MethodName: "GetBundleForChannel",
			Handler:    _Registry_GetBundleForChannel_Handler,
		},
		{
			MethodName: "GetBundleThatReplaces",
			Handler:    _Registry_GetBundleThatReplaces_Handler,
		},
		{
			MethodName: "GetDefaultBundleThatProvides",
			Handler:    _Registry_GetDefaultBundleThatProvides_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListPackages",
			Handler:       _Registry_ListPackages_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetChannelEntriesThatReplace",
			Handler:       _Registry_GetChannelEntriesThatReplace_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetChannelEntriesThatProvide",
			Handler:       _Registry_GetChannelEntriesThatProvide_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetLatestChannelEntriesThatProvide",
			Handler:       _Registry_GetLatestChannelEntriesThatProvide_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "registry.proto",
}

func init() { proto.RegisterFile("registry.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 680 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xc4, 0x56, 0x4f, 0x6f, 0xd3, 0x30,
	0x14, 0x5f, 0xda, 0xad, 0xed, 0x5e, 0x2b, 0xb4, 0x99, 0x6d, 0x84, 0x80, 0xa6, 0xe2, 0x0b, 0x3b,
	0x55, 0x30, 0x40, 0x88, 0x03, 0x87, 0x8d, 0x41, 0x05, 0x0c, 0x34, 0x45, 0xfc, 0x39, 0x70, 0xf2,
	0x12, 0xd3, 0x86, 0x65, 0x4e, 0x66, 0x3b, 0x9b, 0xf6, 0x25, 0xb8, 0xf0, 0x3d, 0xf8, 0x8c, 0x28,
	0xb6, 0x93, 0x3a, 0x69, 0xba, 0x21, 0x21, 0xe0, 0xd6, 0xf7, 0xfc, 0xfe, 0xfc, 0xde, 0xcb, 0xef,
	0x67, 0x17, 0x6e, 0x70, 0x3a, 0x89, 0x84, 0xe4, 0x97, 0xa3, 0x94, 0x27, 0x32, 0x41, 0x6d, 0x92,
	0x46, 0xf8, 0x29, 0x74, 0x5f, 0x4c, 0x09, 0x63, 0x34, 0x46, 0x08, 0x96, 0x19, 0x39, 0xa5, 0xae,
	0x33, 0x74, 0x76, 0x56, 0x7d, 0xf5, 0x1b, 0xb9, 0xd0, 0x0d, 0xc4, 0xf9, 0xfb, 0xdc, 0xdd, 0x52,
	0xee, 0xc2, 0xc4, 0xf7, 0xa0, 0x7f, 0x44, 0x82, 0x13, 0x32, 0xa1, 0xb9, 0xd9, 0x94, 0x8c, 0x2f,
	0xa0, 0x6b, 0x42, 0x1a, 0x6b, 0xef, 0x40, 0x2f, 0xd0, 0xad, 0x85, 0xdb, 0x1a, 0xb6, 0x77, 0xfa,
	0xbb, 0x83, 0x11, 0x49, 0xa3, 0x91, 0xc1, 0xe3, 0x97, 0xa7, 0x68, 0x04, 0x28, 0xa4, 0x5f, 0x49,
	0x16, 0x4b, 0x73, 0xa6, 0x00, 0xb5, 0x55, 0xad, 0x86, 0x13, 0xcc, 0x60, 0x6d, 0xcc, 0x93, 0x2c,
	0xfd, 0x44, 0xb9, 0x88, 0x12, 0xf6, 0x36, 0x62, 0x21, 0xda, 0x80, 0x95, 0x49, 0xee, 0x33, 0x10,
	0xb4, 0x91, 0xcf, 0x77, 0xae, 0x83, 0x8a, 0xf9, 0x8c, 0x99, 0x23, 0x3e, 0x89, 0x58, 0x68, 0xba,
	0xa8, 0xdf, 0x68, 0x0b, 0x3a, 0x69, 0x9c, 0x71, 0x12, 0xbb, 0xcb, 0xca, 0x6b, 0x2c, 0xfc, 0xb3,
	0x05, 0x9d, 0xfd, 0x8c, 0x85, 0x71, 0x65, 0x61, 0x4e, 0x65, 0x61, 0x68, 0x08, 0xfd, 0x74, 0xb6,
	0x30, 0xd3, 0xce, 0x76, 0xe5, 0x11, 0xc1, 0xdc, 0x7c, 0xb6, 0xcb, 0x54, 0x7f, 0x23, 0x12, 0x66,
	0x10, 0x14, 0x66, 0x0e, 0x2d, 0x39, 0xfe, 0x46, 0x03, 0xe9, 0xae, 0x0c, 0xdb, 0x39, 0x34, 0x6d,
	0xa1, 0x6d, 0x80, 0x63, 0x85, 0xec, 0x88, 0xc8, 0xa9, 0xdb, 0x51, 0x49, 0x96, 0x07, 0x3d, 0x83,
	0x41, 0xca, 0x93, 0xf3, 0x28, 0xa4, 0xe1, 0x5e, 0x1a, 0x09, 0xb7, 0xab, 0x3e, 0xc4, 0xa6, 0xfa,
	0x10, 0xf5, 0x1d, 0xfa, 0x95, 0xd0, 0x3c, 0x95, 0xd3, 0xb3, 0x2c, 0xe2, 0x26, 0xb5, 0x77, 0x65,
	0xaa, 0x1d, 0x8a, 0xbf, 0x3b, 0x30, 0x30, 0x1f, 0xec, 0x25, 0x93, 0xfc, 0xb2, 0xbe, 0x1c, 0xe7,
	0xda, 0xe5, 0xb4, 0xe6, 0x97, 0x53, 0x8e, 0x6a, 0x6d, 0xcf, 0xf2, 0x20, 0x0f, 0x7a, 0x9c, 0xa6,
	0x31, 0x09, 0xa8, 0x30, 0xdb, 0x2b, 0x6d, 0xbc, 0x01, 0xe8, 0x30, 0x12, 0xd2, 0xd0, 0xd5, 0xa7,
	0x67, 0x19, 0x15, 0x12, 0xdf, 0x87, 0xf5, 0x31, 0xad, 0x39, 0x1b, 0x99, 0x3e, 0x85, 0xb5, 0x31,
	0x95, 0x9a, 0x02, 0x45, 0x9c, 0x0b, 0xdd, 0xf4, 0x64, 0x62, 0x33, 0xc1, 0x98, 0xbf, 0x31, 0x8a,
	0xc5, 0xa2, 0x76, 0x55, 0x76, 0x9f, 0xe1, 0x76, 0xd9, 0xe9, 0x35, 0x2b, 0xa4, 0xf2, 0xe7, 0x2d,
	0xf1, 0x13, 0x55, 0x78, 0x2f, 0x8e, 0x7d, 0xbd, 0x93, 0x53, 0xca, 0xa4, 0xb0, 0x0a, 0x37, 0xb3,
	0x1a, 0x9f, 0xc2, 0xe6, 0x98, 0x4a, 0x2b, 0xe7, 0xda, 0x14, 0x1b, 0x65, 0xeb, 0x4a, 0x94, 0xf3,
	0x02, 0xc0, 0x12, 0xb6, 0x34, 0xca, 0x23, 0xcd, 0x44, 0x5e, 0x42, 0xfc, 0x9b, 0xfa, 0xbe, 0x50,
	0xbb, 0x39, 0x24, 0x92, 0x0a, 0xf9, 0x1f, 0x1a, 0x1f, 0xe8, 0x1b, 0xae, 0xe8, 0xfc, 0x0f, 0x1a,
	0xef, 0xfe, 0x58, 0x81, 0x9e, 0x6f, 0x9e, 0x0b, 0xf4, 0x1c, 0x06, 0x96, 0x38, 0x04, 0xba, 0xa5,
	0x24, 0x3e, 0xaf, 0x17, 0x6f, 0x4d, 0x1d, 0x58, 0xcf, 0x02, 0x5e, 0x7a, 0xe0, 0xa0, 0xc7, 0x00,
	0x33, 0x15, 0xa1, 0x2d, 0x7d, 0x3f, 0xd4, 0x65, 0xe5, 0x0d, 0xec, 0x5c, 0xbc, 0x84, 0x1e, 0xc2,
	0x6a, 0x49, 0x74, 0xb4, 0x59, 0x24, 0x55, 0x24, 0xe6, 0xf5, 0x95, 0x5b, 0xfb, 0xf0, 0x12, 0x3a,
	0x80, 0x9b, 0x65, 0xc8, 0xab, 0x84, 0x17, 0xef, 0xda, 0x76, 0x35, 0xb9, 0xae, 0x9a, 0x7a, 0x95,
	0x8f, 0x70, 0x77, 0x4c, 0xa5, 0x75, 0x3b, 0x45, 0x54, 0x7c, 0x98, 0x92, 0x82, 0xe3, 0xb3, 0x72,
	0xcd, 0x5a, 0xf1, 0xd6, 0xed, 0x47, 0x4c, 0xdd, 0x6e, 0x6a, 0x0b, 0xfb, 0x4a, 0x28, 0xba, 0x8b,
	0x55, 0x4e, 0x20, 0xaf, 0xa8, 0x37, 0x2f, 0xa2, 0x3a, 0x34, 0x7f, 0x01, 0x34, 0xc3, 0x0c, 0x74,
	0xc7, 0x82, 0x56, 0xe7, 0xe9, 0x22, 0x5c, 0x5f, 0x00, 0x97, 0xdc, 0x5e, 0x5c, 0xb9, 0x1c, 0xba,
	0x59, 0x04, 0x8b, 0x8a, 0xbf, 0x53, 0x80, 0x0d, 0x7f, 0x67, 0xb3, 0x9b, 0x74, 0x31, 0x2b, 0xdb,
	0x4c, 0xf1, 0xda, 0xfc, 0xc7, 0x1d, 0xf5, 0xc7, 0xe5, 0xd1, 0xaf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xf7, 0x7c, 0x82, 0x4a, 0xca, 0x08, 0x00, 0x00,
}
