// +build !ignore_autogenerated

/*
Copyright Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	json "encoding/json"
	unsafe "unsafe"

	operators "github.com/operator-framework/operator-lifecycle-manager/pkg/api/apis/operators"
	corev1 "k8s.io/api/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*APIResourceReference)(nil), (*operators.APIResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIResourceReference_To_operators_APIResourceReference(a.(*APIResourceReference), b.(*operators.APIResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.APIResourceReference)(nil), (*APIResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_APIResourceReference_To_v1alpha1_APIResourceReference(a.(*operators.APIResourceReference), b.(*APIResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIServiceDefinitions)(nil), (*operators.APIServiceDefinitions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIServiceDefinitions_To_operators_APIServiceDefinitions(a.(*APIServiceDefinitions), b.(*operators.APIServiceDefinitions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.APIServiceDefinitions)(nil), (*APIServiceDefinitions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_APIServiceDefinitions_To_v1alpha1_APIServiceDefinitions(a.(*operators.APIServiceDefinitions), b.(*APIServiceDefinitions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIServiceDescription)(nil), (*operators.APIServiceDescription)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIServiceDescription_To_operators_APIServiceDescription(a.(*APIServiceDescription), b.(*operators.APIServiceDescription), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.APIServiceDescription)(nil), (*APIServiceDescription)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_APIServiceDescription_To_v1alpha1_APIServiceDescription(a.(*operators.APIServiceDescription), b.(*APIServiceDescription), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ActionDescriptor)(nil), (*operators.ActionDescriptor)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ActionDescriptor_To_operators_ActionDescriptor(a.(*ActionDescriptor), b.(*operators.ActionDescriptor), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.ActionDescriptor)(nil), (*ActionDescriptor)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_ActionDescriptor_To_v1alpha1_ActionDescriptor(a.(*operators.ActionDescriptor), b.(*ActionDescriptor), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AppLink)(nil), (*operators.AppLink)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_AppLink_To_operators_AppLink(a.(*AppLink), b.(*operators.AppLink), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.AppLink)(nil), (*AppLink)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_AppLink_To_v1alpha1_AppLink(a.(*operators.AppLink), b.(*AppLink), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CRDDescription)(nil), (*operators.CRDDescription)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CRDDescription_To_operators_CRDDescription(a.(*CRDDescription), b.(*operators.CRDDescription), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.CRDDescription)(nil), (*CRDDescription)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_CRDDescription_To_v1alpha1_CRDDescription(a.(*operators.CRDDescription), b.(*CRDDescription), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CatalogSource)(nil), (*operators.CatalogSource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CatalogSource_To_operators_CatalogSource(a.(*CatalogSource), b.(*operators.CatalogSource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.CatalogSource)(nil), (*CatalogSource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_CatalogSource_To_v1alpha1_CatalogSource(a.(*operators.CatalogSource), b.(*CatalogSource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CatalogSourceList)(nil), (*operators.CatalogSourceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CatalogSourceList_To_operators_CatalogSourceList(a.(*CatalogSourceList), b.(*operators.CatalogSourceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.CatalogSourceList)(nil), (*CatalogSourceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_CatalogSourceList_To_v1alpha1_CatalogSourceList(a.(*operators.CatalogSourceList), b.(*CatalogSourceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CatalogSourceSpec)(nil), (*operators.CatalogSourceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CatalogSourceSpec_To_operators_CatalogSourceSpec(a.(*CatalogSourceSpec), b.(*operators.CatalogSourceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.CatalogSourceSpec)(nil), (*CatalogSourceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_CatalogSourceSpec_To_v1alpha1_CatalogSourceSpec(a.(*operators.CatalogSourceSpec), b.(*CatalogSourceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CatalogSourceStatus)(nil), (*operators.CatalogSourceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CatalogSourceStatus_To_operators_CatalogSourceStatus(a.(*CatalogSourceStatus), b.(*operators.CatalogSourceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.CatalogSourceStatus)(nil), (*CatalogSourceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_CatalogSourceStatus_To_v1alpha1_CatalogSourceStatus(a.(*operators.CatalogSourceStatus), b.(*CatalogSourceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterServiceVersion)(nil), (*operators.ClusterServiceVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterServiceVersion_To_operators_ClusterServiceVersion(a.(*ClusterServiceVersion), b.(*operators.ClusterServiceVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.ClusterServiceVersion)(nil), (*ClusterServiceVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_ClusterServiceVersion_To_v1alpha1_ClusterServiceVersion(a.(*operators.ClusterServiceVersion), b.(*ClusterServiceVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterServiceVersionCondition)(nil), (*operators.ClusterServiceVersionCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterServiceVersionCondition_To_operators_ClusterServiceVersionCondition(a.(*ClusterServiceVersionCondition), b.(*operators.ClusterServiceVersionCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.ClusterServiceVersionCondition)(nil), (*ClusterServiceVersionCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_ClusterServiceVersionCondition_To_v1alpha1_ClusterServiceVersionCondition(a.(*operators.ClusterServiceVersionCondition), b.(*ClusterServiceVersionCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterServiceVersionList)(nil), (*operators.ClusterServiceVersionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterServiceVersionList_To_operators_ClusterServiceVersionList(a.(*ClusterServiceVersionList), b.(*operators.ClusterServiceVersionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.ClusterServiceVersionList)(nil), (*ClusterServiceVersionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_ClusterServiceVersionList_To_v1alpha1_ClusterServiceVersionList(a.(*operators.ClusterServiceVersionList), b.(*ClusterServiceVersionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterServiceVersionSpec)(nil), (*operators.ClusterServiceVersionSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterServiceVersionSpec_To_operators_ClusterServiceVersionSpec(a.(*ClusterServiceVersionSpec), b.(*operators.ClusterServiceVersionSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.ClusterServiceVersionSpec)(nil), (*ClusterServiceVersionSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_ClusterServiceVersionSpec_To_v1alpha1_ClusterServiceVersionSpec(a.(*operators.ClusterServiceVersionSpec), b.(*ClusterServiceVersionSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterServiceVersionStatus)(nil), (*operators.ClusterServiceVersionStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterServiceVersionStatus_To_operators_ClusterServiceVersionStatus(a.(*ClusterServiceVersionStatus), b.(*operators.ClusterServiceVersionStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.ClusterServiceVersionStatus)(nil), (*ClusterServiceVersionStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_ClusterServiceVersionStatus_To_v1alpha1_ClusterServiceVersionStatus(a.(*operators.ClusterServiceVersionStatus), b.(*ClusterServiceVersionStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ConfigMapResourceReference)(nil), (*operators.ConfigMapResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ConfigMapResourceReference_To_operators_ConfigMapResourceReference(a.(*ConfigMapResourceReference), b.(*operators.ConfigMapResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.ConfigMapResourceReference)(nil), (*ConfigMapResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_ConfigMapResourceReference_To_v1alpha1_ConfigMapResourceReference(a.(*operators.ConfigMapResourceReference), b.(*ConfigMapResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CustomResourceDefinitions)(nil), (*operators.CustomResourceDefinitions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CustomResourceDefinitions_To_operators_CustomResourceDefinitions(a.(*CustomResourceDefinitions), b.(*operators.CustomResourceDefinitions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.CustomResourceDefinitions)(nil), (*CustomResourceDefinitions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_CustomResourceDefinitions_To_v1alpha1_CustomResourceDefinitions(a.(*operators.CustomResourceDefinitions), b.(*CustomResourceDefinitions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DependentStatus)(nil), (*operators.DependentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DependentStatus_To_operators_DependentStatus(a.(*DependentStatus), b.(*operators.DependentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.DependentStatus)(nil), (*DependentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_DependentStatus_To_v1alpha1_DependentStatus(a.(*operators.DependentStatus), b.(*DependentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*GRPCConnectionState)(nil), (*operators.GRPCConnectionState)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GRPCConnectionState_To_operators_GRPCConnectionState(a.(*GRPCConnectionState), b.(*operators.GRPCConnectionState), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.GRPCConnectionState)(nil), (*GRPCConnectionState)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_GRPCConnectionState_To_v1alpha1_GRPCConnectionState(a.(*operators.GRPCConnectionState), b.(*GRPCConnectionState), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Icon)(nil), (*operators.Icon)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Icon_To_operators_Icon(a.(*Icon), b.(*operators.Icon), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.Icon)(nil), (*Icon)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_Icon_To_v1alpha1_Icon(a.(*operators.Icon), b.(*Icon), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InstallMode)(nil), (*operators.InstallMode)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InstallMode_To_operators_InstallMode(a.(*InstallMode), b.(*operators.InstallMode), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.InstallMode)(nil), (*InstallMode)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_InstallMode_To_v1alpha1_InstallMode(a.(*operators.InstallMode), b.(*InstallMode), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InstallPlan)(nil), (*operators.InstallPlan)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InstallPlan_To_operators_InstallPlan(a.(*InstallPlan), b.(*operators.InstallPlan), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.InstallPlan)(nil), (*InstallPlan)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_InstallPlan_To_v1alpha1_InstallPlan(a.(*operators.InstallPlan), b.(*InstallPlan), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InstallPlanCondition)(nil), (*operators.InstallPlanCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InstallPlanCondition_To_operators_InstallPlanCondition(a.(*InstallPlanCondition), b.(*operators.InstallPlanCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.InstallPlanCondition)(nil), (*InstallPlanCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_InstallPlanCondition_To_v1alpha1_InstallPlanCondition(a.(*operators.InstallPlanCondition), b.(*InstallPlanCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InstallPlanList)(nil), (*operators.InstallPlanList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InstallPlanList_To_operators_InstallPlanList(a.(*InstallPlanList), b.(*operators.InstallPlanList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.InstallPlanList)(nil), (*InstallPlanList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_InstallPlanList_To_v1alpha1_InstallPlanList(a.(*operators.InstallPlanList), b.(*InstallPlanList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InstallPlanReference)(nil), (*operators.InstallPlanReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InstallPlanReference_To_operators_InstallPlanReference(a.(*InstallPlanReference), b.(*operators.InstallPlanReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.InstallPlanReference)(nil), (*InstallPlanReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_InstallPlanReference_To_v1alpha1_InstallPlanReference(a.(*operators.InstallPlanReference), b.(*InstallPlanReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InstallPlanSpec)(nil), (*operators.InstallPlanSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InstallPlanSpec_To_operators_InstallPlanSpec(a.(*InstallPlanSpec), b.(*operators.InstallPlanSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.InstallPlanSpec)(nil), (*InstallPlanSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_InstallPlanSpec_To_v1alpha1_InstallPlanSpec(a.(*operators.InstallPlanSpec), b.(*InstallPlanSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InstallPlanStatus)(nil), (*operators.InstallPlanStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InstallPlanStatus_To_operators_InstallPlanStatus(a.(*InstallPlanStatus), b.(*operators.InstallPlanStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.InstallPlanStatus)(nil), (*InstallPlanStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_InstallPlanStatus_To_v1alpha1_InstallPlanStatus(a.(*operators.InstallPlanStatus), b.(*InstallPlanStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Maintainer)(nil), (*operators.Maintainer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Maintainer_To_operators_Maintainer(a.(*Maintainer), b.(*operators.Maintainer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.Maintainer)(nil), (*Maintainer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_Maintainer_To_v1alpha1_Maintainer(a.(*operators.Maintainer), b.(*Maintainer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NamedInstallStrategy)(nil), (*operators.NamedInstallStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_NamedInstallStrategy_To_operators_NamedInstallStrategy(a.(*NamedInstallStrategy), b.(*operators.NamedInstallStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.NamedInstallStrategy)(nil), (*NamedInstallStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_NamedInstallStrategy_To_v1alpha1_NamedInstallStrategy(a.(*operators.NamedInstallStrategy), b.(*NamedInstallStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RegistryServiceStatus)(nil), (*operators.RegistryServiceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_RegistryServiceStatus_To_operators_RegistryServiceStatus(a.(*RegistryServiceStatus), b.(*operators.RegistryServiceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.RegistryServiceStatus)(nil), (*RegistryServiceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_RegistryServiceStatus_To_v1alpha1_RegistryServiceStatus(a.(*operators.RegistryServiceStatus), b.(*RegistryServiceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RequirementStatus)(nil), (*operators.RequirementStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_RequirementStatus_To_operators_RequirementStatus(a.(*RequirementStatus), b.(*operators.RequirementStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.RequirementStatus)(nil), (*RequirementStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_RequirementStatus_To_v1alpha1_RequirementStatus(a.(*operators.RequirementStatus), b.(*RequirementStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SpecDescriptor)(nil), (*operators.SpecDescriptor)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SpecDescriptor_To_operators_SpecDescriptor(a.(*SpecDescriptor), b.(*operators.SpecDescriptor), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.SpecDescriptor)(nil), (*SpecDescriptor)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_SpecDescriptor_To_v1alpha1_SpecDescriptor(a.(*operators.SpecDescriptor), b.(*SpecDescriptor), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*StatusDescriptor)(nil), (*operators.StatusDescriptor)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_StatusDescriptor_To_operators_StatusDescriptor(a.(*StatusDescriptor), b.(*operators.StatusDescriptor), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.StatusDescriptor)(nil), (*StatusDescriptor)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_StatusDescriptor_To_v1alpha1_StatusDescriptor(a.(*operators.StatusDescriptor), b.(*StatusDescriptor), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Step)(nil), (*operators.Step)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Step_To_operators_Step(a.(*Step), b.(*operators.Step), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.Step)(nil), (*Step)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_Step_To_v1alpha1_Step(a.(*operators.Step), b.(*Step), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*StepResource)(nil), (*operators.StepResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_StepResource_To_operators_StepResource(a.(*StepResource), b.(*operators.StepResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.StepResource)(nil), (*StepResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_StepResource_To_v1alpha1_StepResource(a.(*operators.StepResource), b.(*StepResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Subscription)(nil), (*operators.Subscription)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Subscription_To_operators_Subscription(a.(*Subscription), b.(*operators.Subscription), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.Subscription)(nil), (*Subscription)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_Subscription_To_v1alpha1_Subscription(a.(*operators.Subscription), b.(*Subscription), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubscriptionCatalogHealth)(nil), (*operators.SubscriptionCatalogHealth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SubscriptionCatalogHealth_To_operators_SubscriptionCatalogHealth(a.(*SubscriptionCatalogHealth), b.(*operators.SubscriptionCatalogHealth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.SubscriptionCatalogHealth)(nil), (*SubscriptionCatalogHealth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_SubscriptionCatalogHealth_To_v1alpha1_SubscriptionCatalogHealth(a.(*operators.SubscriptionCatalogHealth), b.(*SubscriptionCatalogHealth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubscriptionCondition)(nil), (*operators.SubscriptionCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SubscriptionCondition_To_operators_SubscriptionCondition(a.(*SubscriptionCondition), b.(*operators.SubscriptionCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.SubscriptionCondition)(nil), (*SubscriptionCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_SubscriptionCondition_To_v1alpha1_SubscriptionCondition(a.(*operators.SubscriptionCondition), b.(*SubscriptionCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubscriptionConfig)(nil), (*operators.SubscriptionConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SubscriptionConfig_To_operators_SubscriptionConfig(a.(*SubscriptionConfig), b.(*operators.SubscriptionConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.SubscriptionConfig)(nil), (*SubscriptionConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_SubscriptionConfig_To_v1alpha1_SubscriptionConfig(a.(*operators.SubscriptionConfig), b.(*SubscriptionConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubscriptionList)(nil), (*operators.SubscriptionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SubscriptionList_To_operators_SubscriptionList(a.(*SubscriptionList), b.(*operators.SubscriptionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.SubscriptionList)(nil), (*SubscriptionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_SubscriptionList_To_v1alpha1_SubscriptionList(a.(*operators.SubscriptionList), b.(*SubscriptionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubscriptionSpec)(nil), (*operators.SubscriptionSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SubscriptionSpec_To_operators_SubscriptionSpec(a.(*SubscriptionSpec), b.(*operators.SubscriptionSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.SubscriptionSpec)(nil), (*SubscriptionSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_SubscriptionSpec_To_v1alpha1_SubscriptionSpec(a.(*operators.SubscriptionSpec), b.(*SubscriptionSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubscriptionStatus)(nil), (*operators.SubscriptionStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SubscriptionStatus_To_operators_SubscriptionStatus(a.(*SubscriptionStatus), b.(*operators.SubscriptionStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*operators.SubscriptionStatus)(nil), (*SubscriptionStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_operators_SubscriptionStatus_To_v1alpha1_SubscriptionStatus(a.(*operators.SubscriptionStatus), b.(*SubscriptionStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_APIResourceReference_To_operators_APIResourceReference(in *APIResourceReference, out *operators.APIResourceReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Kind = in.Kind
	out.Version = in.Version
	return nil
}

// Convert_v1alpha1_APIResourceReference_To_operators_APIResourceReference is an autogenerated conversion function.
func Convert_v1alpha1_APIResourceReference_To_operators_APIResourceReference(in *APIResourceReference, out *operators.APIResourceReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIResourceReference_To_operators_APIResourceReference(in, out, s)
}

func autoConvert_operators_APIResourceReference_To_v1alpha1_APIResourceReference(in *operators.APIResourceReference, out *APIResourceReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Kind = in.Kind
	out.Version = in.Version
	return nil
}

// Convert_operators_APIResourceReference_To_v1alpha1_APIResourceReference is an autogenerated conversion function.
func Convert_operators_APIResourceReference_To_v1alpha1_APIResourceReference(in *operators.APIResourceReference, out *APIResourceReference, s conversion.Scope) error {
	return autoConvert_operators_APIResourceReference_To_v1alpha1_APIResourceReference(in, out, s)
}

func autoConvert_v1alpha1_APIServiceDefinitions_To_operators_APIServiceDefinitions(in *APIServiceDefinitions, out *operators.APIServiceDefinitions, s conversion.Scope) error {
	out.Owned = *(*[]operators.APIServiceDescription)(unsafe.Pointer(&in.Owned))
	out.Required = *(*[]operators.APIServiceDescription)(unsafe.Pointer(&in.Required))
	return nil
}

// Convert_v1alpha1_APIServiceDefinitions_To_operators_APIServiceDefinitions is an autogenerated conversion function.
func Convert_v1alpha1_APIServiceDefinitions_To_operators_APIServiceDefinitions(in *APIServiceDefinitions, out *operators.APIServiceDefinitions, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIServiceDefinitions_To_operators_APIServiceDefinitions(in, out, s)
}

func autoConvert_operators_APIServiceDefinitions_To_v1alpha1_APIServiceDefinitions(in *operators.APIServiceDefinitions, out *APIServiceDefinitions, s conversion.Scope) error {
	out.Owned = *(*[]APIServiceDescription)(unsafe.Pointer(&in.Owned))
	out.Required = *(*[]APIServiceDescription)(unsafe.Pointer(&in.Required))
	return nil
}

// Convert_operators_APIServiceDefinitions_To_v1alpha1_APIServiceDefinitions is an autogenerated conversion function.
func Convert_operators_APIServiceDefinitions_To_v1alpha1_APIServiceDefinitions(in *operators.APIServiceDefinitions, out *APIServiceDefinitions, s conversion.Scope) error {
	return autoConvert_operators_APIServiceDefinitions_To_v1alpha1_APIServiceDefinitions(in, out, s)
}

func autoConvert_v1alpha1_APIServiceDescription_To_operators_APIServiceDescription(in *APIServiceDescription, out *operators.APIServiceDescription, s conversion.Scope) error {
	out.Name = in.Name
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.DeploymentName = in.DeploymentName
	out.ContainerPort = in.ContainerPort
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Resources = *(*[]operators.APIResourceReference)(unsafe.Pointer(&in.Resources))
	out.StatusDescriptors = *(*[]operators.StatusDescriptor)(unsafe.Pointer(&in.StatusDescriptors))
	out.SpecDescriptors = *(*[]operators.SpecDescriptor)(unsafe.Pointer(&in.SpecDescriptors))
	out.ActionDescriptor = *(*[]operators.ActionDescriptor)(unsafe.Pointer(&in.ActionDescriptor))
	return nil
}

// Convert_v1alpha1_APIServiceDescription_To_operators_APIServiceDescription is an autogenerated conversion function.
func Convert_v1alpha1_APIServiceDescription_To_operators_APIServiceDescription(in *APIServiceDescription, out *operators.APIServiceDescription, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIServiceDescription_To_operators_APIServiceDescription(in, out, s)
}

func autoConvert_operators_APIServiceDescription_To_v1alpha1_APIServiceDescription(in *operators.APIServiceDescription, out *APIServiceDescription, s conversion.Scope) error {
	out.Name = in.Name
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.DeploymentName = in.DeploymentName
	out.ContainerPort = in.ContainerPort
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Resources = *(*[]APIResourceReference)(unsafe.Pointer(&in.Resources))
	out.StatusDescriptors = *(*[]StatusDescriptor)(unsafe.Pointer(&in.StatusDescriptors))
	out.SpecDescriptors = *(*[]SpecDescriptor)(unsafe.Pointer(&in.SpecDescriptors))
	out.ActionDescriptor = *(*[]ActionDescriptor)(unsafe.Pointer(&in.ActionDescriptor))
	return nil
}

// Convert_operators_APIServiceDescription_To_v1alpha1_APIServiceDescription is an autogenerated conversion function.
func Convert_operators_APIServiceDescription_To_v1alpha1_APIServiceDescription(in *operators.APIServiceDescription, out *APIServiceDescription, s conversion.Scope) error {
	return autoConvert_operators_APIServiceDescription_To_v1alpha1_APIServiceDescription(in, out, s)
}

func autoConvert_v1alpha1_ActionDescriptor_To_operators_ActionDescriptor(in *ActionDescriptor, out *operators.ActionDescriptor, s conversion.Scope) error {
	out.Path = in.Path
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.XDescriptors = *(*[]string)(unsafe.Pointer(&in.XDescriptors))
	out.Value = (*json.RawMessage)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_v1alpha1_ActionDescriptor_To_operators_ActionDescriptor is an autogenerated conversion function.
func Convert_v1alpha1_ActionDescriptor_To_operators_ActionDescriptor(in *ActionDescriptor, out *operators.ActionDescriptor, s conversion.Scope) error {
	return autoConvert_v1alpha1_ActionDescriptor_To_operators_ActionDescriptor(in, out, s)
}

func autoConvert_operators_ActionDescriptor_To_v1alpha1_ActionDescriptor(in *operators.ActionDescriptor, out *ActionDescriptor, s conversion.Scope) error {
	out.Path = in.Path
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.XDescriptors = *(*[]string)(unsafe.Pointer(&in.XDescriptors))
	out.Value = (*json.RawMessage)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_operators_ActionDescriptor_To_v1alpha1_ActionDescriptor is an autogenerated conversion function.
func Convert_operators_ActionDescriptor_To_v1alpha1_ActionDescriptor(in *operators.ActionDescriptor, out *ActionDescriptor, s conversion.Scope) error {
	return autoConvert_operators_ActionDescriptor_To_v1alpha1_ActionDescriptor(in, out, s)
}

func autoConvert_v1alpha1_AppLink_To_operators_AppLink(in *AppLink, out *operators.AppLink, s conversion.Scope) error {
	out.Name = in.Name
	out.URL = in.URL
	return nil
}

// Convert_v1alpha1_AppLink_To_operators_AppLink is an autogenerated conversion function.
func Convert_v1alpha1_AppLink_To_operators_AppLink(in *AppLink, out *operators.AppLink, s conversion.Scope) error {
	return autoConvert_v1alpha1_AppLink_To_operators_AppLink(in, out, s)
}

func autoConvert_operators_AppLink_To_v1alpha1_AppLink(in *operators.AppLink, out *AppLink, s conversion.Scope) error {
	out.Name = in.Name
	out.URL = in.URL
	return nil
}

// Convert_operators_AppLink_To_v1alpha1_AppLink is an autogenerated conversion function.
func Convert_operators_AppLink_To_v1alpha1_AppLink(in *operators.AppLink, out *AppLink, s conversion.Scope) error {
	return autoConvert_operators_AppLink_To_v1alpha1_AppLink(in, out, s)
}

func autoConvert_v1alpha1_CRDDescription_To_operators_CRDDescription(in *CRDDescription, out *operators.CRDDescription, s conversion.Scope) error {
	out.Name = in.Name
	out.Version = in.Version
	out.Kind = in.Kind
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Resources = *(*[]operators.APIResourceReference)(unsafe.Pointer(&in.Resources))
	out.StatusDescriptors = *(*[]operators.StatusDescriptor)(unsafe.Pointer(&in.StatusDescriptors))
	out.SpecDescriptors = *(*[]operators.SpecDescriptor)(unsafe.Pointer(&in.SpecDescriptors))
	out.ActionDescriptor = *(*[]operators.ActionDescriptor)(unsafe.Pointer(&in.ActionDescriptor))
	return nil
}

// Convert_v1alpha1_CRDDescription_To_operators_CRDDescription is an autogenerated conversion function.
func Convert_v1alpha1_CRDDescription_To_operators_CRDDescription(in *CRDDescription, out *operators.CRDDescription, s conversion.Scope) error {
	return autoConvert_v1alpha1_CRDDescription_To_operators_CRDDescription(in, out, s)
}

func autoConvert_operators_CRDDescription_To_v1alpha1_CRDDescription(in *operators.CRDDescription, out *CRDDescription, s conversion.Scope) error {
	out.Name = in.Name
	out.Version = in.Version
	out.Kind = in.Kind
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Resources = *(*[]APIResourceReference)(unsafe.Pointer(&in.Resources))
	out.StatusDescriptors = *(*[]StatusDescriptor)(unsafe.Pointer(&in.StatusDescriptors))
	out.SpecDescriptors = *(*[]SpecDescriptor)(unsafe.Pointer(&in.SpecDescriptors))
	out.ActionDescriptor = *(*[]ActionDescriptor)(unsafe.Pointer(&in.ActionDescriptor))
	return nil
}

// Convert_operators_CRDDescription_To_v1alpha1_CRDDescription is an autogenerated conversion function.
func Convert_operators_CRDDescription_To_v1alpha1_CRDDescription(in *operators.CRDDescription, out *CRDDescription, s conversion.Scope) error {
	return autoConvert_operators_CRDDescription_To_v1alpha1_CRDDescription(in, out, s)
}

func autoConvert_v1alpha1_CatalogSource_To_operators_CatalogSource(in *CatalogSource, out *operators.CatalogSource, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_CatalogSourceSpec_To_operators_CatalogSourceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_CatalogSourceStatus_To_operators_CatalogSourceStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_CatalogSource_To_operators_CatalogSource is an autogenerated conversion function.
func Convert_v1alpha1_CatalogSource_To_operators_CatalogSource(in *CatalogSource, out *operators.CatalogSource, s conversion.Scope) error {
	return autoConvert_v1alpha1_CatalogSource_To_operators_CatalogSource(in, out, s)
}

func autoConvert_operators_CatalogSource_To_v1alpha1_CatalogSource(in *operators.CatalogSource, out *CatalogSource, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_operators_CatalogSourceSpec_To_v1alpha1_CatalogSourceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_operators_CatalogSourceStatus_To_v1alpha1_CatalogSourceStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_operators_CatalogSource_To_v1alpha1_CatalogSource is an autogenerated conversion function.
func Convert_operators_CatalogSource_To_v1alpha1_CatalogSource(in *operators.CatalogSource, out *CatalogSource, s conversion.Scope) error {
	return autoConvert_operators_CatalogSource_To_v1alpha1_CatalogSource(in, out, s)
}

func autoConvert_v1alpha1_CatalogSourceList_To_operators_CatalogSourceList(in *CatalogSourceList, out *operators.CatalogSourceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]operators.CatalogSource)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_CatalogSourceList_To_operators_CatalogSourceList is an autogenerated conversion function.
func Convert_v1alpha1_CatalogSourceList_To_operators_CatalogSourceList(in *CatalogSourceList, out *operators.CatalogSourceList, s conversion.Scope) error {
	return autoConvert_v1alpha1_CatalogSourceList_To_operators_CatalogSourceList(in, out, s)
}

func autoConvert_operators_CatalogSourceList_To_v1alpha1_CatalogSourceList(in *operators.CatalogSourceList, out *CatalogSourceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]CatalogSource)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_operators_CatalogSourceList_To_v1alpha1_CatalogSourceList is an autogenerated conversion function.
func Convert_operators_CatalogSourceList_To_v1alpha1_CatalogSourceList(in *operators.CatalogSourceList, out *CatalogSourceList, s conversion.Scope) error {
	return autoConvert_operators_CatalogSourceList_To_v1alpha1_CatalogSourceList(in, out, s)
}

func autoConvert_v1alpha1_CatalogSourceSpec_To_operators_CatalogSourceSpec(in *CatalogSourceSpec, out *operators.CatalogSourceSpec, s conversion.Scope) error {
	out.SourceType = operators.SourceType(in.SourceType)
	out.ConfigMap = in.ConfigMap
	out.Address = in.Address
	out.Image = in.Image
	out.Secrets = *(*[]string)(unsafe.Pointer(&in.Secrets))
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Publisher = in.Publisher
	if err := Convert_v1alpha1_Icon_To_operators_Icon(&in.Icon, &out.Icon, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_CatalogSourceSpec_To_operators_CatalogSourceSpec is an autogenerated conversion function.
func Convert_v1alpha1_CatalogSourceSpec_To_operators_CatalogSourceSpec(in *CatalogSourceSpec, out *operators.CatalogSourceSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_CatalogSourceSpec_To_operators_CatalogSourceSpec(in, out, s)
}

func autoConvert_operators_CatalogSourceSpec_To_v1alpha1_CatalogSourceSpec(in *operators.CatalogSourceSpec, out *CatalogSourceSpec, s conversion.Scope) error {
	out.SourceType = SourceType(in.SourceType)
	out.ConfigMap = in.ConfigMap
	out.Address = in.Address
	out.Image = in.Image
	out.Secrets = *(*[]string)(unsafe.Pointer(&in.Secrets))
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Publisher = in.Publisher
	if err := Convert_operators_Icon_To_v1alpha1_Icon(&in.Icon, &out.Icon, s); err != nil {
		return err
	}
	return nil
}

// Convert_operators_CatalogSourceSpec_To_v1alpha1_CatalogSourceSpec is an autogenerated conversion function.
func Convert_operators_CatalogSourceSpec_To_v1alpha1_CatalogSourceSpec(in *operators.CatalogSourceSpec, out *CatalogSourceSpec, s conversion.Scope) error {
	return autoConvert_operators_CatalogSourceSpec_To_v1alpha1_CatalogSourceSpec(in, out, s)
}

func autoConvert_v1alpha1_CatalogSourceStatus_To_operators_CatalogSourceStatus(in *CatalogSourceStatus, out *operators.CatalogSourceStatus, s conversion.Scope) error {
	out.Message = in.Message
	out.Reason = operators.ConditionReason(in.Reason)
	out.ConfigMapResource = (*operators.ConfigMapResourceReference)(unsafe.Pointer(in.ConfigMapResource))
	out.RegistryServiceStatus = (*operators.RegistryServiceStatus)(unsafe.Pointer(in.RegistryServiceStatus))
	out.GRPCConnectionState = (*operators.GRPCConnectionState)(unsafe.Pointer(in.GRPCConnectionState))
	return nil
}

// Convert_v1alpha1_CatalogSourceStatus_To_operators_CatalogSourceStatus is an autogenerated conversion function.
func Convert_v1alpha1_CatalogSourceStatus_To_operators_CatalogSourceStatus(in *CatalogSourceStatus, out *operators.CatalogSourceStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_CatalogSourceStatus_To_operators_CatalogSourceStatus(in, out, s)
}

func autoConvert_operators_CatalogSourceStatus_To_v1alpha1_CatalogSourceStatus(in *operators.CatalogSourceStatus, out *CatalogSourceStatus, s conversion.Scope) error {
	out.Message = in.Message
	out.Reason = ConditionReason(in.Reason)
	out.ConfigMapResource = (*ConfigMapResourceReference)(unsafe.Pointer(in.ConfigMapResource))
	out.RegistryServiceStatus = (*RegistryServiceStatus)(unsafe.Pointer(in.RegistryServiceStatus))
	out.GRPCConnectionState = (*GRPCConnectionState)(unsafe.Pointer(in.GRPCConnectionState))
	return nil
}

// Convert_operators_CatalogSourceStatus_To_v1alpha1_CatalogSourceStatus is an autogenerated conversion function.
func Convert_operators_CatalogSourceStatus_To_v1alpha1_CatalogSourceStatus(in *operators.CatalogSourceStatus, out *CatalogSourceStatus, s conversion.Scope) error {
	return autoConvert_operators_CatalogSourceStatus_To_v1alpha1_CatalogSourceStatus(in, out, s)
}

func autoConvert_v1alpha1_ClusterServiceVersion_To_operators_ClusterServiceVersion(in *ClusterServiceVersion, out *operators.ClusterServiceVersion, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ClusterServiceVersionSpec_To_operators_ClusterServiceVersionSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ClusterServiceVersionStatus_To_operators_ClusterServiceVersionStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ClusterServiceVersion_To_operators_ClusterServiceVersion is an autogenerated conversion function.
func Convert_v1alpha1_ClusterServiceVersion_To_operators_ClusterServiceVersion(in *ClusterServiceVersion, out *operators.ClusterServiceVersion, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterServiceVersion_To_operators_ClusterServiceVersion(in, out, s)
}

func autoConvert_operators_ClusterServiceVersion_To_v1alpha1_ClusterServiceVersion(in *operators.ClusterServiceVersion, out *ClusterServiceVersion, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_operators_ClusterServiceVersionSpec_To_v1alpha1_ClusterServiceVersionSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_operators_ClusterServiceVersionStatus_To_v1alpha1_ClusterServiceVersionStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_operators_ClusterServiceVersion_To_v1alpha1_ClusterServiceVersion is an autogenerated conversion function.
func Convert_operators_ClusterServiceVersion_To_v1alpha1_ClusterServiceVersion(in *operators.ClusterServiceVersion, out *ClusterServiceVersion, s conversion.Scope) error {
	return autoConvert_operators_ClusterServiceVersion_To_v1alpha1_ClusterServiceVersion(in, out, s)
}

func autoConvert_v1alpha1_ClusterServiceVersionCondition_To_operators_ClusterServiceVersionCondition(in *ClusterServiceVersionCondition, out *operators.ClusterServiceVersionCondition, s conversion.Scope) error {
	out.Phase = operators.ClusterServiceVersionPhase(in.Phase)
	out.Message = in.Message
	out.Reason = operators.ConditionReason(in.Reason)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	return nil
}

// Convert_v1alpha1_ClusterServiceVersionCondition_To_operators_ClusterServiceVersionCondition is an autogenerated conversion function.
func Convert_v1alpha1_ClusterServiceVersionCondition_To_operators_ClusterServiceVersionCondition(in *ClusterServiceVersionCondition, out *operators.ClusterServiceVersionCondition, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterServiceVersionCondition_To_operators_ClusterServiceVersionCondition(in, out, s)
}

func autoConvert_operators_ClusterServiceVersionCondition_To_v1alpha1_ClusterServiceVersionCondition(in *operators.ClusterServiceVersionCondition, out *ClusterServiceVersionCondition, s conversion.Scope) error {
	out.Phase = ClusterServiceVersionPhase(in.Phase)
	out.Message = in.Message
	out.Reason = ConditionReason(in.Reason)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	return nil
}

// Convert_operators_ClusterServiceVersionCondition_To_v1alpha1_ClusterServiceVersionCondition is an autogenerated conversion function.
func Convert_operators_ClusterServiceVersionCondition_To_v1alpha1_ClusterServiceVersionCondition(in *operators.ClusterServiceVersionCondition, out *ClusterServiceVersionCondition, s conversion.Scope) error {
	return autoConvert_operators_ClusterServiceVersionCondition_To_v1alpha1_ClusterServiceVersionCondition(in, out, s)
}

func autoConvert_v1alpha1_ClusterServiceVersionList_To_operators_ClusterServiceVersionList(in *ClusterServiceVersionList, out *operators.ClusterServiceVersionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]operators.ClusterServiceVersion)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ClusterServiceVersionList_To_operators_ClusterServiceVersionList is an autogenerated conversion function.
func Convert_v1alpha1_ClusterServiceVersionList_To_operators_ClusterServiceVersionList(in *ClusterServiceVersionList, out *operators.ClusterServiceVersionList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterServiceVersionList_To_operators_ClusterServiceVersionList(in, out, s)
}

func autoConvert_operators_ClusterServiceVersionList_To_v1alpha1_ClusterServiceVersionList(in *operators.ClusterServiceVersionList, out *ClusterServiceVersionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ClusterServiceVersion)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_operators_ClusterServiceVersionList_To_v1alpha1_ClusterServiceVersionList is an autogenerated conversion function.
func Convert_operators_ClusterServiceVersionList_To_v1alpha1_ClusterServiceVersionList(in *operators.ClusterServiceVersionList, out *ClusterServiceVersionList, s conversion.Scope) error {
	return autoConvert_operators_ClusterServiceVersionList_To_v1alpha1_ClusterServiceVersionList(in, out, s)
}

func autoConvert_v1alpha1_ClusterServiceVersionSpec_To_operators_ClusterServiceVersionSpec(in *ClusterServiceVersionSpec, out *operators.ClusterServiceVersionSpec, s conversion.Scope) error {
	if err := Convert_v1alpha1_NamedInstallStrategy_To_operators_NamedInstallStrategy(&in.InstallStrategy, &out.InstallStrategy, s); err != nil {
		return err
	}
	out.Version = in.Version
	out.Maturity = in.Maturity
	if err := Convert_v1alpha1_CustomResourceDefinitions_To_operators_CustomResourceDefinitions(&in.CustomResourceDefinitions, &out.CustomResourceDefinitions, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_APIServiceDefinitions_To_operators_APIServiceDefinitions(&in.APIServiceDefinitions, &out.APIServiceDefinitions, s); err != nil {
		return err
	}
	out.NativeAPIs = *(*[]v1.GroupVersionKind)(unsafe.Pointer(&in.NativeAPIs))
	out.MinKubeVersion = in.MinKubeVersion
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Keywords = *(*[]string)(unsafe.Pointer(&in.Keywords))
	out.Maintainers = *(*[]operators.Maintainer)(unsafe.Pointer(&in.Maintainers))
	if err := Convert_v1alpha1_AppLink_To_operators_AppLink(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.Links = *(*[]operators.AppLink)(unsafe.Pointer(&in.Links))
	out.Icon = *(*[]operators.Icon)(unsafe.Pointer(&in.Icon))
	out.InstallModes = *(*[]operators.InstallMode)(unsafe.Pointer(&in.InstallModes))
	out.Replaces = in.Replaces
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Selector = (*v1.LabelSelector)(unsafe.Pointer(in.Selector))
	return nil
}

// Convert_v1alpha1_ClusterServiceVersionSpec_To_operators_ClusterServiceVersionSpec is an autogenerated conversion function.
func Convert_v1alpha1_ClusterServiceVersionSpec_To_operators_ClusterServiceVersionSpec(in *ClusterServiceVersionSpec, out *operators.ClusterServiceVersionSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterServiceVersionSpec_To_operators_ClusterServiceVersionSpec(in, out, s)
}

func autoConvert_operators_ClusterServiceVersionSpec_To_v1alpha1_ClusterServiceVersionSpec(in *operators.ClusterServiceVersionSpec, out *ClusterServiceVersionSpec, s conversion.Scope) error {
	if err := Convert_operators_NamedInstallStrategy_To_v1alpha1_NamedInstallStrategy(&in.InstallStrategy, &out.InstallStrategy, s); err != nil {
		return err
	}
	out.Version = in.Version
	out.Maturity = in.Maturity
	if err := Convert_operators_CustomResourceDefinitions_To_v1alpha1_CustomResourceDefinitions(&in.CustomResourceDefinitions, &out.CustomResourceDefinitions, s); err != nil {
		return err
	}
	if err := Convert_operators_APIServiceDefinitions_To_v1alpha1_APIServiceDefinitions(&in.APIServiceDefinitions, &out.APIServiceDefinitions, s); err != nil {
		return err
	}
	out.NativeAPIs = *(*[]v1.GroupVersionKind)(unsafe.Pointer(&in.NativeAPIs))
	out.MinKubeVersion = in.MinKubeVersion
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.Keywords = *(*[]string)(unsafe.Pointer(&in.Keywords))
	out.Maintainers = *(*[]Maintainer)(unsafe.Pointer(&in.Maintainers))
	if err := Convert_operators_AppLink_To_v1alpha1_AppLink(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.Links = *(*[]AppLink)(unsafe.Pointer(&in.Links))
	out.Icon = *(*[]Icon)(unsafe.Pointer(&in.Icon))
	out.InstallModes = *(*[]InstallMode)(unsafe.Pointer(&in.InstallModes))
	out.Replaces = in.Replaces
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Selector = (*v1.LabelSelector)(unsafe.Pointer(in.Selector))
	return nil
}

// Convert_operators_ClusterServiceVersionSpec_To_v1alpha1_ClusterServiceVersionSpec is an autogenerated conversion function.
func Convert_operators_ClusterServiceVersionSpec_To_v1alpha1_ClusterServiceVersionSpec(in *operators.ClusterServiceVersionSpec, out *ClusterServiceVersionSpec, s conversion.Scope) error {
	return autoConvert_operators_ClusterServiceVersionSpec_To_v1alpha1_ClusterServiceVersionSpec(in, out, s)
}

func autoConvert_v1alpha1_ClusterServiceVersionStatus_To_operators_ClusterServiceVersionStatus(in *ClusterServiceVersionStatus, out *operators.ClusterServiceVersionStatus, s conversion.Scope) error {
	out.Phase = operators.ClusterServiceVersionPhase(in.Phase)
	out.Message = in.Message
	out.Reason = operators.ConditionReason(in.Reason)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Conditions = *(*[]operators.ClusterServiceVersionCondition)(unsafe.Pointer(&in.Conditions))
	out.RequirementStatus = *(*[]operators.RequirementStatus)(unsafe.Pointer(&in.RequirementStatus))
	out.CertsLastUpdated = in.CertsLastUpdated
	out.CertsRotateAt = in.CertsRotateAt
	return nil
}

// Convert_v1alpha1_ClusterServiceVersionStatus_To_operators_ClusterServiceVersionStatus is an autogenerated conversion function.
func Convert_v1alpha1_ClusterServiceVersionStatus_To_operators_ClusterServiceVersionStatus(in *ClusterServiceVersionStatus, out *operators.ClusterServiceVersionStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterServiceVersionStatus_To_operators_ClusterServiceVersionStatus(in, out, s)
}

func autoConvert_operators_ClusterServiceVersionStatus_To_v1alpha1_ClusterServiceVersionStatus(in *operators.ClusterServiceVersionStatus, out *ClusterServiceVersionStatus, s conversion.Scope) error {
	out.Phase = ClusterServiceVersionPhase(in.Phase)
	out.Message = in.Message
	out.Reason = ConditionReason(in.Reason)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Conditions = *(*[]ClusterServiceVersionCondition)(unsafe.Pointer(&in.Conditions))
	out.RequirementStatus = *(*[]RequirementStatus)(unsafe.Pointer(&in.RequirementStatus))
	out.CertsLastUpdated = in.CertsLastUpdated
	out.CertsRotateAt = in.CertsRotateAt
	return nil
}

// Convert_operators_ClusterServiceVersionStatus_To_v1alpha1_ClusterServiceVersionStatus is an autogenerated conversion function.
func Convert_operators_ClusterServiceVersionStatus_To_v1alpha1_ClusterServiceVersionStatus(in *operators.ClusterServiceVersionStatus, out *ClusterServiceVersionStatus, s conversion.Scope) error {
	return autoConvert_operators_ClusterServiceVersionStatus_To_v1alpha1_ClusterServiceVersionStatus(in, out, s)
}

func autoConvert_v1alpha1_ConfigMapResourceReference_To_operators_ConfigMapResourceReference(in *ConfigMapResourceReference, out *operators.ConfigMapResourceReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	out.UID = types.UID(in.UID)
	out.ResourceVersion = in.ResourceVersion
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_v1alpha1_ConfigMapResourceReference_To_operators_ConfigMapResourceReference is an autogenerated conversion function.
func Convert_v1alpha1_ConfigMapResourceReference_To_operators_ConfigMapResourceReference(in *ConfigMapResourceReference, out *operators.ConfigMapResourceReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_ConfigMapResourceReference_To_operators_ConfigMapResourceReference(in, out, s)
}

func autoConvert_operators_ConfigMapResourceReference_To_v1alpha1_ConfigMapResourceReference(in *operators.ConfigMapResourceReference, out *ConfigMapResourceReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	out.UID = types.UID(in.UID)
	out.ResourceVersion = in.ResourceVersion
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_operators_ConfigMapResourceReference_To_v1alpha1_ConfigMapResourceReference is an autogenerated conversion function.
func Convert_operators_ConfigMapResourceReference_To_v1alpha1_ConfigMapResourceReference(in *operators.ConfigMapResourceReference, out *ConfigMapResourceReference, s conversion.Scope) error {
	return autoConvert_operators_ConfigMapResourceReference_To_v1alpha1_ConfigMapResourceReference(in, out, s)
}

func autoConvert_v1alpha1_CustomResourceDefinitions_To_operators_CustomResourceDefinitions(in *CustomResourceDefinitions, out *operators.CustomResourceDefinitions, s conversion.Scope) error {
	out.Owned = *(*[]operators.CRDDescription)(unsafe.Pointer(&in.Owned))
	out.Required = *(*[]operators.CRDDescription)(unsafe.Pointer(&in.Required))
	return nil
}

// Convert_v1alpha1_CustomResourceDefinitions_To_operators_CustomResourceDefinitions is an autogenerated conversion function.
func Convert_v1alpha1_CustomResourceDefinitions_To_operators_CustomResourceDefinitions(in *CustomResourceDefinitions, out *operators.CustomResourceDefinitions, s conversion.Scope) error {
	return autoConvert_v1alpha1_CustomResourceDefinitions_To_operators_CustomResourceDefinitions(in, out, s)
}

func autoConvert_operators_CustomResourceDefinitions_To_v1alpha1_CustomResourceDefinitions(in *operators.CustomResourceDefinitions, out *CustomResourceDefinitions, s conversion.Scope) error {
	out.Owned = *(*[]CRDDescription)(unsafe.Pointer(&in.Owned))
	out.Required = *(*[]CRDDescription)(unsafe.Pointer(&in.Required))
	return nil
}

// Convert_operators_CustomResourceDefinitions_To_v1alpha1_CustomResourceDefinitions is an autogenerated conversion function.
func Convert_operators_CustomResourceDefinitions_To_v1alpha1_CustomResourceDefinitions(in *operators.CustomResourceDefinitions, out *CustomResourceDefinitions, s conversion.Scope) error {
	return autoConvert_operators_CustomResourceDefinitions_To_v1alpha1_CustomResourceDefinitions(in, out, s)
}

func autoConvert_v1alpha1_DependentStatus_To_operators_DependentStatus(in *DependentStatus, out *operators.DependentStatus, s conversion.Scope) error {
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.Status = operators.StatusReason(in.Status)
	out.UUID = in.UUID
	out.Message = in.Message
	return nil
}

// Convert_v1alpha1_DependentStatus_To_operators_DependentStatus is an autogenerated conversion function.
func Convert_v1alpha1_DependentStatus_To_operators_DependentStatus(in *DependentStatus, out *operators.DependentStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_DependentStatus_To_operators_DependentStatus(in, out, s)
}

func autoConvert_operators_DependentStatus_To_v1alpha1_DependentStatus(in *operators.DependentStatus, out *DependentStatus, s conversion.Scope) error {
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.Status = StatusReason(in.Status)
	out.UUID = in.UUID
	out.Message = in.Message
	return nil
}

// Convert_operators_DependentStatus_To_v1alpha1_DependentStatus is an autogenerated conversion function.
func Convert_operators_DependentStatus_To_v1alpha1_DependentStatus(in *operators.DependentStatus, out *DependentStatus, s conversion.Scope) error {
	return autoConvert_operators_DependentStatus_To_v1alpha1_DependentStatus(in, out, s)
}

func autoConvert_v1alpha1_GRPCConnectionState_To_operators_GRPCConnectionState(in *GRPCConnectionState, out *operators.GRPCConnectionState, s conversion.Scope) error {
	out.Address = in.Address
	out.LastObservedState = in.LastObservedState
	out.LastConnectTime = in.LastConnectTime
	return nil
}

// Convert_v1alpha1_GRPCConnectionState_To_operators_GRPCConnectionState is an autogenerated conversion function.
func Convert_v1alpha1_GRPCConnectionState_To_operators_GRPCConnectionState(in *GRPCConnectionState, out *operators.GRPCConnectionState, s conversion.Scope) error {
	return autoConvert_v1alpha1_GRPCConnectionState_To_operators_GRPCConnectionState(in, out, s)
}

func autoConvert_operators_GRPCConnectionState_To_v1alpha1_GRPCConnectionState(in *operators.GRPCConnectionState, out *GRPCConnectionState, s conversion.Scope) error {
	out.Address = in.Address
	out.LastObservedState = in.LastObservedState
	out.LastConnectTime = in.LastConnectTime
	return nil
}

// Convert_operators_GRPCConnectionState_To_v1alpha1_GRPCConnectionState is an autogenerated conversion function.
func Convert_operators_GRPCConnectionState_To_v1alpha1_GRPCConnectionState(in *operators.GRPCConnectionState, out *GRPCConnectionState, s conversion.Scope) error {
	return autoConvert_operators_GRPCConnectionState_To_v1alpha1_GRPCConnectionState(in, out, s)
}

func autoConvert_v1alpha1_Icon_To_operators_Icon(in *Icon, out *operators.Icon, s conversion.Scope) error {
	out.Data = in.Data
	out.MediaType = in.MediaType
	return nil
}

// Convert_v1alpha1_Icon_To_operators_Icon is an autogenerated conversion function.
func Convert_v1alpha1_Icon_To_operators_Icon(in *Icon, out *operators.Icon, s conversion.Scope) error {
	return autoConvert_v1alpha1_Icon_To_operators_Icon(in, out, s)
}

func autoConvert_operators_Icon_To_v1alpha1_Icon(in *operators.Icon, out *Icon, s conversion.Scope) error {
	out.Data = in.Data
	out.MediaType = in.MediaType
	return nil
}

// Convert_operators_Icon_To_v1alpha1_Icon is an autogenerated conversion function.
func Convert_operators_Icon_To_v1alpha1_Icon(in *operators.Icon, out *Icon, s conversion.Scope) error {
	return autoConvert_operators_Icon_To_v1alpha1_Icon(in, out, s)
}

func autoConvert_v1alpha1_InstallMode_To_operators_InstallMode(in *InstallMode, out *operators.InstallMode, s conversion.Scope) error {
	out.Type = operators.InstallModeType(in.Type)
	out.Supported = in.Supported
	return nil
}

// Convert_v1alpha1_InstallMode_To_operators_InstallMode is an autogenerated conversion function.
func Convert_v1alpha1_InstallMode_To_operators_InstallMode(in *InstallMode, out *operators.InstallMode, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstallMode_To_operators_InstallMode(in, out, s)
}

func autoConvert_operators_InstallMode_To_v1alpha1_InstallMode(in *operators.InstallMode, out *InstallMode, s conversion.Scope) error {
	out.Type = InstallModeType(in.Type)
	out.Supported = in.Supported
	return nil
}

// Convert_operators_InstallMode_To_v1alpha1_InstallMode is an autogenerated conversion function.
func Convert_operators_InstallMode_To_v1alpha1_InstallMode(in *operators.InstallMode, out *InstallMode, s conversion.Scope) error {
	return autoConvert_operators_InstallMode_To_v1alpha1_InstallMode(in, out, s)
}

func autoConvert_v1alpha1_InstallPlan_To_operators_InstallPlan(in *InstallPlan, out *operators.InstallPlan, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_InstallPlanSpec_To_operators_InstallPlanSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_InstallPlanStatus_To_operators_InstallPlanStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_InstallPlan_To_operators_InstallPlan is an autogenerated conversion function.
func Convert_v1alpha1_InstallPlan_To_operators_InstallPlan(in *InstallPlan, out *operators.InstallPlan, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstallPlan_To_operators_InstallPlan(in, out, s)
}

func autoConvert_operators_InstallPlan_To_v1alpha1_InstallPlan(in *operators.InstallPlan, out *InstallPlan, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_operators_InstallPlanSpec_To_v1alpha1_InstallPlanSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_operators_InstallPlanStatus_To_v1alpha1_InstallPlanStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_operators_InstallPlan_To_v1alpha1_InstallPlan is an autogenerated conversion function.
func Convert_operators_InstallPlan_To_v1alpha1_InstallPlan(in *operators.InstallPlan, out *InstallPlan, s conversion.Scope) error {
	return autoConvert_operators_InstallPlan_To_v1alpha1_InstallPlan(in, out, s)
}

func autoConvert_v1alpha1_InstallPlanCondition_To_operators_InstallPlanCondition(in *InstallPlanCondition, out *operators.InstallPlanCondition, s conversion.Scope) error {
	out.Type = operators.InstallPlanConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = operators.InstallPlanConditionReason(in.Reason)
	out.Message = in.Message
	return nil
}

// Convert_v1alpha1_InstallPlanCondition_To_operators_InstallPlanCondition is an autogenerated conversion function.
func Convert_v1alpha1_InstallPlanCondition_To_operators_InstallPlanCondition(in *InstallPlanCondition, out *operators.InstallPlanCondition, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstallPlanCondition_To_operators_InstallPlanCondition(in, out, s)
}

func autoConvert_operators_InstallPlanCondition_To_v1alpha1_InstallPlanCondition(in *operators.InstallPlanCondition, out *InstallPlanCondition, s conversion.Scope) error {
	out.Type = InstallPlanConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = InstallPlanConditionReason(in.Reason)
	out.Message = in.Message
	return nil
}

// Convert_operators_InstallPlanCondition_To_v1alpha1_InstallPlanCondition is an autogenerated conversion function.
func Convert_operators_InstallPlanCondition_To_v1alpha1_InstallPlanCondition(in *operators.InstallPlanCondition, out *InstallPlanCondition, s conversion.Scope) error {
	return autoConvert_operators_InstallPlanCondition_To_v1alpha1_InstallPlanCondition(in, out, s)
}

func autoConvert_v1alpha1_InstallPlanList_To_operators_InstallPlanList(in *InstallPlanList, out *operators.InstallPlanList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]operators.InstallPlan)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_InstallPlanList_To_operators_InstallPlanList is an autogenerated conversion function.
func Convert_v1alpha1_InstallPlanList_To_operators_InstallPlanList(in *InstallPlanList, out *operators.InstallPlanList, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstallPlanList_To_operators_InstallPlanList(in, out, s)
}

func autoConvert_operators_InstallPlanList_To_v1alpha1_InstallPlanList(in *operators.InstallPlanList, out *InstallPlanList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]InstallPlan)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_operators_InstallPlanList_To_v1alpha1_InstallPlanList is an autogenerated conversion function.
func Convert_operators_InstallPlanList_To_v1alpha1_InstallPlanList(in *operators.InstallPlanList, out *InstallPlanList, s conversion.Scope) error {
	return autoConvert_operators_InstallPlanList_To_v1alpha1_InstallPlanList(in, out, s)
}

func autoConvert_v1alpha1_InstallPlanReference_To_operators_InstallPlanReference(in *InstallPlanReference, out *operators.InstallPlanReference, s conversion.Scope) error {
	out.APIVersion = in.APIVersion
	out.Kind = in.Kind
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_v1alpha1_InstallPlanReference_To_operators_InstallPlanReference is an autogenerated conversion function.
func Convert_v1alpha1_InstallPlanReference_To_operators_InstallPlanReference(in *InstallPlanReference, out *operators.InstallPlanReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstallPlanReference_To_operators_InstallPlanReference(in, out, s)
}

func autoConvert_operators_InstallPlanReference_To_v1alpha1_InstallPlanReference(in *operators.InstallPlanReference, out *InstallPlanReference, s conversion.Scope) error {
	out.APIVersion = in.APIVersion
	out.Kind = in.Kind
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_operators_InstallPlanReference_To_v1alpha1_InstallPlanReference is an autogenerated conversion function.
func Convert_operators_InstallPlanReference_To_v1alpha1_InstallPlanReference(in *operators.InstallPlanReference, out *InstallPlanReference, s conversion.Scope) error {
	return autoConvert_operators_InstallPlanReference_To_v1alpha1_InstallPlanReference(in, out, s)
}

func autoConvert_v1alpha1_InstallPlanSpec_To_operators_InstallPlanSpec(in *InstallPlanSpec, out *operators.InstallPlanSpec, s conversion.Scope) error {
	out.CatalogSource = in.CatalogSource
	out.CatalogSourceNamespace = in.CatalogSourceNamespace
	out.ClusterServiceVersionNames = *(*[]string)(unsafe.Pointer(&in.ClusterServiceVersionNames))
	out.Approval = operators.Approval(in.Approval)
	out.Approved = in.Approved
	return nil
}

// Convert_v1alpha1_InstallPlanSpec_To_operators_InstallPlanSpec is an autogenerated conversion function.
func Convert_v1alpha1_InstallPlanSpec_To_operators_InstallPlanSpec(in *InstallPlanSpec, out *operators.InstallPlanSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstallPlanSpec_To_operators_InstallPlanSpec(in, out, s)
}

func autoConvert_operators_InstallPlanSpec_To_v1alpha1_InstallPlanSpec(in *operators.InstallPlanSpec, out *InstallPlanSpec, s conversion.Scope) error {
	out.CatalogSource = in.CatalogSource
	out.CatalogSourceNamespace = in.CatalogSourceNamespace
	out.ClusterServiceVersionNames = *(*[]string)(unsafe.Pointer(&in.ClusterServiceVersionNames))
	out.Approval = Approval(in.Approval)
	out.Approved = in.Approved
	return nil
}

// Convert_operators_InstallPlanSpec_To_v1alpha1_InstallPlanSpec is an autogenerated conversion function.
func Convert_operators_InstallPlanSpec_To_v1alpha1_InstallPlanSpec(in *operators.InstallPlanSpec, out *InstallPlanSpec, s conversion.Scope) error {
	return autoConvert_operators_InstallPlanSpec_To_v1alpha1_InstallPlanSpec(in, out, s)
}

func autoConvert_v1alpha1_InstallPlanStatus_To_operators_InstallPlanStatus(in *InstallPlanStatus, out *operators.InstallPlanStatus, s conversion.Scope) error {
	out.Phase = operators.InstallPlanPhase(in.Phase)
	out.Conditions = *(*[]operators.InstallPlanCondition)(unsafe.Pointer(&in.Conditions))
	out.CatalogSources = *(*[]string)(unsafe.Pointer(&in.CatalogSources))
	out.Plan = *(*[]*operators.Step)(unsafe.Pointer(&in.Plan))
	out.AttenuatedServiceAccountRef = (*corev1.ObjectReference)(unsafe.Pointer(in.AttenuatedServiceAccountRef))
	return nil
}

// Convert_v1alpha1_InstallPlanStatus_To_operators_InstallPlanStatus is an autogenerated conversion function.
func Convert_v1alpha1_InstallPlanStatus_To_operators_InstallPlanStatus(in *InstallPlanStatus, out *operators.InstallPlanStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_InstallPlanStatus_To_operators_InstallPlanStatus(in, out, s)
}

func autoConvert_operators_InstallPlanStatus_To_v1alpha1_InstallPlanStatus(in *operators.InstallPlanStatus, out *InstallPlanStatus, s conversion.Scope) error {
	out.Phase = InstallPlanPhase(in.Phase)
	out.Conditions = *(*[]InstallPlanCondition)(unsafe.Pointer(&in.Conditions))
	out.CatalogSources = *(*[]string)(unsafe.Pointer(&in.CatalogSources))
	out.Plan = *(*[]*Step)(unsafe.Pointer(&in.Plan))
	out.AttenuatedServiceAccountRef = (*corev1.ObjectReference)(unsafe.Pointer(in.AttenuatedServiceAccountRef))
	return nil
}

// Convert_operators_InstallPlanStatus_To_v1alpha1_InstallPlanStatus is an autogenerated conversion function.
func Convert_operators_InstallPlanStatus_To_v1alpha1_InstallPlanStatus(in *operators.InstallPlanStatus, out *InstallPlanStatus, s conversion.Scope) error {
	return autoConvert_operators_InstallPlanStatus_To_v1alpha1_InstallPlanStatus(in, out, s)
}

func autoConvert_v1alpha1_Maintainer_To_operators_Maintainer(in *Maintainer, out *operators.Maintainer, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

// Convert_v1alpha1_Maintainer_To_operators_Maintainer is an autogenerated conversion function.
func Convert_v1alpha1_Maintainer_To_operators_Maintainer(in *Maintainer, out *operators.Maintainer, s conversion.Scope) error {
	return autoConvert_v1alpha1_Maintainer_To_operators_Maintainer(in, out, s)
}

func autoConvert_operators_Maintainer_To_v1alpha1_Maintainer(in *operators.Maintainer, out *Maintainer, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

// Convert_operators_Maintainer_To_v1alpha1_Maintainer is an autogenerated conversion function.
func Convert_operators_Maintainer_To_v1alpha1_Maintainer(in *operators.Maintainer, out *Maintainer, s conversion.Scope) error {
	return autoConvert_operators_Maintainer_To_v1alpha1_Maintainer(in, out, s)
}

func autoConvert_v1alpha1_NamedInstallStrategy_To_operators_NamedInstallStrategy(in *NamedInstallStrategy, out *operators.NamedInstallStrategy, s conversion.Scope) error {
	out.StrategyName = in.StrategyName
	out.StrategySpecRaw = *(*json.RawMessage)(unsafe.Pointer(&in.StrategySpecRaw))
	return nil
}

// Convert_v1alpha1_NamedInstallStrategy_To_operators_NamedInstallStrategy is an autogenerated conversion function.
func Convert_v1alpha1_NamedInstallStrategy_To_operators_NamedInstallStrategy(in *NamedInstallStrategy, out *operators.NamedInstallStrategy, s conversion.Scope) error {
	return autoConvert_v1alpha1_NamedInstallStrategy_To_operators_NamedInstallStrategy(in, out, s)
}

func autoConvert_operators_NamedInstallStrategy_To_v1alpha1_NamedInstallStrategy(in *operators.NamedInstallStrategy, out *NamedInstallStrategy, s conversion.Scope) error {
	out.StrategyName = in.StrategyName
	out.StrategySpecRaw = *(*json.RawMessage)(unsafe.Pointer(&in.StrategySpecRaw))
	return nil
}

// Convert_operators_NamedInstallStrategy_To_v1alpha1_NamedInstallStrategy is an autogenerated conversion function.
func Convert_operators_NamedInstallStrategy_To_v1alpha1_NamedInstallStrategy(in *operators.NamedInstallStrategy, out *NamedInstallStrategy, s conversion.Scope) error {
	return autoConvert_operators_NamedInstallStrategy_To_v1alpha1_NamedInstallStrategy(in, out, s)
}

func autoConvert_v1alpha1_RegistryServiceStatus_To_operators_RegistryServiceStatus(in *RegistryServiceStatus, out *operators.RegistryServiceStatus, s conversion.Scope) error {
	out.Protocol = in.Protocol
	out.ServiceName = in.ServiceName
	out.ServiceNamespace = in.ServiceNamespace
	out.Port = in.Port
	out.CreatedAt = in.CreatedAt
	return nil
}

// Convert_v1alpha1_RegistryServiceStatus_To_operators_RegistryServiceStatus is an autogenerated conversion function.
func Convert_v1alpha1_RegistryServiceStatus_To_operators_RegistryServiceStatus(in *RegistryServiceStatus, out *operators.RegistryServiceStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_RegistryServiceStatus_To_operators_RegistryServiceStatus(in, out, s)
}

func autoConvert_operators_RegistryServiceStatus_To_v1alpha1_RegistryServiceStatus(in *operators.RegistryServiceStatus, out *RegistryServiceStatus, s conversion.Scope) error {
	out.Protocol = in.Protocol
	out.ServiceName = in.ServiceName
	out.ServiceNamespace = in.ServiceNamespace
	out.Port = in.Port
	out.CreatedAt = in.CreatedAt
	return nil
}

// Convert_operators_RegistryServiceStatus_To_v1alpha1_RegistryServiceStatus is an autogenerated conversion function.
func Convert_operators_RegistryServiceStatus_To_v1alpha1_RegistryServiceStatus(in *operators.RegistryServiceStatus, out *RegistryServiceStatus, s conversion.Scope) error {
	return autoConvert_operators_RegistryServiceStatus_To_v1alpha1_RegistryServiceStatus(in, out, s)
}

func autoConvert_v1alpha1_RequirementStatus_To_operators_RequirementStatus(in *RequirementStatus, out *operators.RequirementStatus, s conversion.Scope) error {
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.Name = in.Name
	out.Status = operators.StatusReason(in.Status)
	out.Message = in.Message
	out.UUID = in.UUID
	out.Dependents = *(*[]operators.DependentStatus)(unsafe.Pointer(&in.Dependents))
	return nil
}

// Convert_v1alpha1_RequirementStatus_To_operators_RequirementStatus is an autogenerated conversion function.
func Convert_v1alpha1_RequirementStatus_To_operators_RequirementStatus(in *RequirementStatus, out *operators.RequirementStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_RequirementStatus_To_operators_RequirementStatus(in, out, s)
}

func autoConvert_operators_RequirementStatus_To_v1alpha1_RequirementStatus(in *operators.RequirementStatus, out *RequirementStatus, s conversion.Scope) error {
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.Name = in.Name
	out.Status = StatusReason(in.Status)
	out.Message = in.Message
	out.UUID = in.UUID
	out.Dependents = *(*[]DependentStatus)(unsafe.Pointer(&in.Dependents))
	return nil
}

// Convert_operators_RequirementStatus_To_v1alpha1_RequirementStatus is an autogenerated conversion function.
func Convert_operators_RequirementStatus_To_v1alpha1_RequirementStatus(in *operators.RequirementStatus, out *RequirementStatus, s conversion.Scope) error {
	return autoConvert_operators_RequirementStatus_To_v1alpha1_RequirementStatus(in, out, s)
}

func autoConvert_v1alpha1_SpecDescriptor_To_operators_SpecDescriptor(in *SpecDescriptor, out *operators.SpecDescriptor, s conversion.Scope) error {
	out.Path = in.Path
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.XDescriptors = *(*[]string)(unsafe.Pointer(&in.XDescriptors))
	out.Value = (*json.RawMessage)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_v1alpha1_SpecDescriptor_To_operators_SpecDescriptor is an autogenerated conversion function.
func Convert_v1alpha1_SpecDescriptor_To_operators_SpecDescriptor(in *SpecDescriptor, out *operators.SpecDescriptor, s conversion.Scope) error {
	return autoConvert_v1alpha1_SpecDescriptor_To_operators_SpecDescriptor(in, out, s)
}

func autoConvert_operators_SpecDescriptor_To_v1alpha1_SpecDescriptor(in *operators.SpecDescriptor, out *SpecDescriptor, s conversion.Scope) error {
	out.Path = in.Path
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.XDescriptors = *(*[]string)(unsafe.Pointer(&in.XDescriptors))
	out.Value = (*json.RawMessage)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_operators_SpecDescriptor_To_v1alpha1_SpecDescriptor is an autogenerated conversion function.
func Convert_operators_SpecDescriptor_To_v1alpha1_SpecDescriptor(in *operators.SpecDescriptor, out *SpecDescriptor, s conversion.Scope) error {
	return autoConvert_operators_SpecDescriptor_To_v1alpha1_SpecDescriptor(in, out, s)
}

func autoConvert_v1alpha1_StatusDescriptor_To_operators_StatusDescriptor(in *StatusDescriptor, out *operators.StatusDescriptor, s conversion.Scope) error {
	out.Path = in.Path
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.XDescriptors = *(*[]string)(unsafe.Pointer(&in.XDescriptors))
	out.Value = (*json.RawMessage)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_v1alpha1_StatusDescriptor_To_operators_StatusDescriptor is an autogenerated conversion function.
func Convert_v1alpha1_StatusDescriptor_To_operators_StatusDescriptor(in *StatusDescriptor, out *operators.StatusDescriptor, s conversion.Scope) error {
	return autoConvert_v1alpha1_StatusDescriptor_To_operators_StatusDescriptor(in, out, s)
}

func autoConvert_operators_StatusDescriptor_To_v1alpha1_StatusDescriptor(in *operators.StatusDescriptor, out *StatusDescriptor, s conversion.Scope) error {
	out.Path = in.Path
	out.DisplayName = in.DisplayName
	out.Description = in.Description
	out.XDescriptors = *(*[]string)(unsafe.Pointer(&in.XDescriptors))
	out.Value = (*json.RawMessage)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_operators_StatusDescriptor_To_v1alpha1_StatusDescriptor is an autogenerated conversion function.
func Convert_operators_StatusDescriptor_To_v1alpha1_StatusDescriptor(in *operators.StatusDescriptor, out *StatusDescriptor, s conversion.Scope) error {
	return autoConvert_operators_StatusDescriptor_To_v1alpha1_StatusDescriptor(in, out, s)
}

func autoConvert_v1alpha1_Step_To_operators_Step(in *Step, out *operators.Step, s conversion.Scope) error {
	out.Resolving = in.Resolving
	if err := Convert_v1alpha1_StepResource_To_operators_StepResource(&in.Resource, &out.Resource, s); err != nil {
		return err
	}
	out.Status = operators.StepStatus(in.Status)
	return nil
}

// Convert_v1alpha1_Step_To_operators_Step is an autogenerated conversion function.
func Convert_v1alpha1_Step_To_operators_Step(in *Step, out *operators.Step, s conversion.Scope) error {
	return autoConvert_v1alpha1_Step_To_operators_Step(in, out, s)
}

func autoConvert_operators_Step_To_v1alpha1_Step(in *operators.Step, out *Step, s conversion.Scope) error {
	out.Resolving = in.Resolving
	if err := Convert_operators_StepResource_To_v1alpha1_StepResource(&in.Resource, &out.Resource, s); err != nil {
		return err
	}
	out.Status = StepStatus(in.Status)
	return nil
}

// Convert_operators_Step_To_v1alpha1_Step is an autogenerated conversion function.
func Convert_operators_Step_To_v1alpha1_Step(in *operators.Step, out *Step, s conversion.Scope) error {
	return autoConvert_operators_Step_To_v1alpha1_Step(in, out, s)
}

func autoConvert_v1alpha1_StepResource_To_operators_StepResource(in *StepResource, out *operators.StepResource, s conversion.Scope) error {
	out.CatalogSource = in.CatalogSource
	out.CatalogSourceNamespace = in.CatalogSourceNamespace
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.Name = in.Name
	out.Manifest = in.Manifest
	return nil
}

// Convert_v1alpha1_StepResource_To_operators_StepResource is an autogenerated conversion function.
func Convert_v1alpha1_StepResource_To_operators_StepResource(in *StepResource, out *operators.StepResource, s conversion.Scope) error {
	return autoConvert_v1alpha1_StepResource_To_operators_StepResource(in, out, s)
}

func autoConvert_operators_StepResource_To_v1alpha1_StepResource(in *operators.StepResource, out *StepResource, s conversion.Scope) error {
	out.CatalogSource = in.CatalogSource
	out.CatalogSourceNamespace = in.CatalogSourceNamespace
	out.Group = in.Group
	out.Version = in.Version
	out.Kind = in.Kind
	out.Name = in.Name
	out.Manifest = in.Manifest
	return nil
}

// Convert_operators_StepResource_To_v1alpha1_StepResource is an autogenerated conversion function.
func Convert_operators_StepResource_To_v1alpha1_StepResource(in *operators.StepResource, out *StepResource, s conversion.Scope) error {
	return autoConvert_operators_StepResource_To_v1alpha1_StepResource(in, out, s)
}

func autoConvert_v1alpha1_Subscription_To_operators_Subscription(in *Subscription, out *operators.Subscription, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Spec = (*operators.SubscriptionSpec)(unsafe.Pointer(in.Spec))
	if err := Convert_v1alpha1_SubscriptionStatus_To_operators_SubscriptionStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Subscription_To_operators_Subscription is an autogenerated conversion function.
func Convert_v1alpha1_Subscription_To_operators_Subscription(in *Subscription, out *operators.Subscription, s conversion.Scope) error {
	return autoConvert_v1alpha1_Subscription_To_operators_Subscription(in, out, s)
}

func autoConvert_operators_Subscription_To_v1alpha1_Subscription(in *operators.Subscription, out *Subscription, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Spec = (*SubscriptionSpec)(unsafe.Pointer(in.Spec))
	if err := Convert_operators_SubscriptionStatus_To_v1alpha1_SubscriptionStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_operators_Subscription_To_v1alpha1_Subscription is an autogenerated conversion function.
func Convert_operators_Subscription_To_v1alpha1_Subscription(in *operators.Subscription, out *Subscription, s conversion.Scope) error {
	return autoConvert_operators_Subscription_To_v1alpha1_Subscription(in, out, s)
}

func autoConvert_v1alpha1_SubscriptionCatalogHealth_To_operators_SubscriptionCatalogHealth(in *SubscriptionCatalogHealth, out *operators.SubscriptionCatalogHealth, s conversion.Scope) error {
	out.CatalogSourceRef = (*corev1.ObjectReference)(unsafe.Pointer(in.CatalogSourceRef))
	out.LastUpdated = (*v1.Time)(unsafe.Pointer(in.LastUpdated))
	out.Healthy = in.Healthy
	return nil
}

// Convert_v1alpha1_SubscriptionCatalogHealth_To_operators_SubscriptionCatalogHealth is an autogenerated conversion function.
func Convert_v1alpha1_SubscriptionCatalogHealth_To_operators_SubscriptionCatalogHealth(in *SubscriptionCatalogHealth, out *operators.SubscriptionCatalogHealth, s conversion.Scope) error {
	return autoConvert_v1alpha1_SubscriptionCatalogHealth_To_operators_SubscriptionCatalogHealth(in, out, s)
}

func autoConvert_operators_SubscriptionCatalogHealth_To_v1alpha1_SubscriptionCatalogHealth(in *operators.SubscriptionCatalogHealth, out *SubscriptionCatalogHealth, s conversion.Scope) error {
	out.CatalogSourceRef = (*corev1.ObjectReference)(unsafe.Pointer(in.CatalogSourceRef))
	out.LastUpdated = (*v1.Time)(unsafe.Pointer(in.LastUpdated))
	out.Healthy = in.Healthy
	return nil
}

// Convert_operators_SubscriptionCatalogHealth_To_v1alpha1_SubscriptionCatalogHealth is an autogenerated conversion function.
func Convert_operators_SubscriptionCatalogHealth_To_v1alpha1_SubscriptionCatalogHealth(in *operators.SubscriptionCatalogHealth, out *SubscriptionCatalogHealth, s conversion.Scope) error {
	return autoConvert_operators_SubscriptionCatalogHealth_To_v1alpha1_SubscriptionCatalogHealth(in, out, s)
}

func autoConvert_v1alpha1_SubscriptionCondition_To_operators_SubscriptionCondition(in *SubscriptionCondition, out *operators.SubscriptionCondition, s conversion.Scope) error {
	out.Type = operators.SubscriptionConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.Reason = in.Reason
	out.Message = in.Message
	out.LastHeartbeatTime = (*v1.Time)(unsafe.Pointer(in.LastHeartbeatTime))
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	return nil
}

// Convert_v1alpha1_SubscriptionCondition_To_operators_SubscriptionCondition is an autogenerated conversion function.
func Convert_v1alpha1_SubscriptionCondition_To_operators_SubscriptionCondition(in *SubscriptionCondition, out *operators.SubscriptionCondition, s conversion.Scope) error {
	return autoConvert_v1alpha1_SubscriptionCondition_To_operators_SubscriptionCondition(in, out, s)
}

func autoConvert_operators_SubscriptionCondition_To_v1alpha1_SubscriptionCondition(in *operators.SubscriptionCondition, out *SubscriptionCondition, s conversion.Scope) error {
	out.Type = SubscriptionConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.Reason = in.Reason
	out.Message = in.Message
	out.LastHeartbeatTime = (*v1.Time)(unsafe.Pointer(in.LastHeartbeatTime))
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	return nil
}

// Convert_operators_SubscriptionCondition_To_v1alpha1_SubscriptionCondition is an autogenerated conversion function.
func Convert_operators_SubscriptionCondition_To_v1alpha1_SubscriptionCondition(in *operators.SubscriptionCondition, out *SubscriptionCondition, s conversion.Scope) error {
	return autoConvert_operators_SubscriptionCondition_To_v1alpha1_SubscriptionCondition(in, out, s)
}

func autoConvert_v1alpha1_SubscriptionConfig_To_operators_SubscriptionConfig(in *SubscriptionConfig, out *operators.SubscriptionConfig, s conversion.Scope) error {
	out.Selector = (*v1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.Tolerations = *(*[]corev1.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.Resources = in.Resources
	out.EnvFrom = *(*[]corev1.EnvFromSource)(unsafe.Pointer(&in.EnvFrom))
	out.Env = *(*[]corev1.EnvVar)(unsafe.Pointer(&in.Env))
	out.Volumes = *(*[]corev1.Volume)(unsafe.Pointer(&in.Volumes))
	out.VolumeMounts = *(*[]corev1.VolumeMount)(unsafe.Pointer(&in.VolumeMounts))
	return nil
}

// Convert_v1alpha1_SubscriptionConfig_To_operators_SubscriptionConfig is an autogenerated conversion function.
func Convert_v1alpha1_SubscriptionConfig_To_operators_SubscriptionConfig(in *SubscriptionConfig, out *operators.SubscriptionConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_SubscriptionConfig_To_operators_SubscriptionConfig(in, out, s)
}

func autoConvert_operators_SubscriptionConfig_To_v1alpha1_SubscriptionConfig(in *operators.SubscriptionConfig, out *SubscriptionConfig, s conversion.Scope) error {
	out.Selector = (*v1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.Tolerations = *(*[]corev1.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.Resources = in.Resources
	out.EnvFrom = *(*[]corev1.EnvFromSource)(unsafe.Pointer(&in.EnvFrom))
	out.Env = *(*[]corev1.EnvVar)(unsafe.Pointer(&in.Env))
	out.Volumes = *(*[]corev1.Volume)(unsafe.Pointer(&in.Volumes))
	out.VolumeMounts = *(*[]corev1.VolumeMount)(unsafe.Pointer(&in.VolumeMounts))
	return nil
}

// Convert_operators_SubscriptionConfig_To_v1alpha1_SubscriptionConfig is an autogenerated conversion function.
func Convert_operators_SubscriptionConfig_To_v1alpha1_SubscriptionConfig(in *operators.SubscriptionConfig, out *SubscriptionConfig, s conversion.Scope) error {
	return autoConvert_operators_SubscriptionConfig_To_v1alpha1_SubscriptionConfig(in, out, s)
}

func autoConvert_v1alpha1_SubscriptionList_To_operators_SubscriptionList(in *SubscriptionList, out *operators.SubscriptionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]operators.Subscription)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_SubscriptionList_To_operators_SubscriptionList is an autogenerated conversion function.
func Convert_v1alpha1_SubscriptionList_To_operators_SubscriptionList(in *SubscriptionList, out *operators.SubscriptionList, s conversion.Scope) error {
	return autoConvert_v1alpha1_SubscriptionList_To_operators_SubscriptionList(in, out, s)
}

func autoConvert_operators_SubscriptionList_To_v1alpha1_SubscriptionList(in *operators.SubscriptionList, out *SubscriptionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]Subscription)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_operators_SubscriptionList_To_v1alpha1_SubscriptionList is an autogenerated conversion function.
func Convert_operators_SubscriptionList_To_v1alpha1_SubscriptionList(in *operators.SubscriptionList, out *SubscriptionList, s conversion.Scope) error {
	return autoConvert_operators_SubscriptionList_To_v1alpha1_SubscriptionList(in, out, s)
}

func autoConvert_v1alpha1_SubscriptionSpec_To_operators_SubscriptionSpec(in *SubscriptionSpec, out *operators.SubscriptionSpec, s conversion.Scope) error {
	out.CatalogSource = in.CatalogSource
	out.CatalogSourceNamespace = in.CatalogSourceNamespace
	out.Package = in.Package
	out.Channel = in.Channel
	out.StartingCSV = in.StartingCSV
	out.InstallPlanApproval = operators.Approval(in.InstallPlanApproval)
	if err := Convert_v1alpha1_SubscriptionConfig_To_operators_SubscriptionConfig(&in.Config, &out.Config, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_SubscriptionSpec_To_operators_SubscriptionSpec is an autogenerated conversion function.
func Convert_v1alpha1_SubscriptionSpec_To_operators_SubscriptionSpec(in *SubscriptionSpec, out *operators.SubscriptionSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_SubscriptionSpec_To_operators_SubscriptionSpec(in, out, s)
}

func autoConvert_operators_SubscriptionSpec_To_v1alpha1_SubscriptionSpec(in *operators.SubscriptionSpec, out *SubscriptionSpec, s conversion.Scope) error {
	out.CatalogSource = in.CatalogSource
	out.CatalogSourceNamespace = in.CatalogSourceNamespace
	out.Package = in.Package
	out.Channel = in.Channel
	out.StartingCSV = in.StartingCSV
	out.InstallPlanApproval = Approval(in.InstallPlanApproval)
	if err := Convert_operators_SubscriptionConfig_To_v1alpha1_SubscriptionConfig(&in.Config, &out.Config, s); err != nil {
		return err
	}
	return nil
}

// Convert_operators_SubscriptionSpec_To_v1alpha1_SubscriptionSpec is an autogenerated conversion function.
func Convert_operators_SubscriptionSpec_To_v1alpha1_SubscriptionSpec(in *operators.SubscriptionSpec, out *SubscriptionSpec, s conversion.Scope) error {
	return autoConvert_operators_SubscriptionSpec_To_v1alpha1_SubscriptionSpec(in, out, s)
}

func autoConvert_v1alpha1_SubscriptionStatus_To_operators_SubscriptionStatus(in *SubscriptionStatus, out *operators.SubscriptionStatus, s conversion.Scope) error {
	out.CurrentCSV = in.CurrentCSV
	out.InstalledCSV = in.InstalledCSV
	out.Install = (*operators.InstallPlanReference)(unsafe.Pointer(in.Install))
	out.State = operators.SubscriptionState(in.State)
	out.Reason = operators.ConditionReason(in.Reason)
	out.InstallPlanRef = (*corev1.ObjectReference)(unsafe.Pointer(in.InstallPlanRef))
	out.CatalogHealth = *(*[]operators.SubscriptionCatalogHealth)(unsafe.Pointer(&in.CatalogHealth))
	out.Conditions = *(*[]operators.SubscriptionCondition)(unsafe.Pointer(&in.Conditions))
	out.LastUpdated = in.LastUpdated
	return nil
}

// Convert_v1alpha1_SubscriptionStatus_To_operators_SubscriptionStatus is an autogenerated conversion function.
func Convert_v1alpha1_SubscriptionStatus_To_operators_SubscriptionStatus(in *SubscriptionStatus, out *operators.SubscriptionStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_SubscriptionStatus_To_operators_SubscriptionStatus(in, out, s)
}

func autoConvert_operators_SubscriptionStatus_To_v1alpha1_SubscriptionStatus(in *operators.SubscriptionStatus, out *SubscriptionStatus, s conversion.Scope) error {
	out.CurrentCSV = in.CurrentCSV
	out.InstalledCSV = in.InstalledCSV
	out.Install = (*InstallPlanReference)(unsafe.Pointer(in.Install))
	out.State = SubscriptionState(in.State)
	out.Reason = ConditionReason(in.Reason)
	out.InstallPlanRef = (*corev1.ObjectReference)(unsafe.Pointer(in.InstallPlanRef))
	out.CatalogHealth = *(*[]SubscriptionCatalogHealth)(unsafe.Pointer(&in.CatalogHealth))
	out.Conditions = *(*[]SubscriptionCondition)(unsafe.Pointer(&in.Conditions))
	out.LastUpdated = in.LastUpdated
	return nil
}

// Convert_operators_SubscriptionStatus_To_v1alpha1_SubscriptionStatus is an autogenerated conversion function.
func Convert_operators_SubscriptionStatus_To_v1alpha1_SubscriptionStatus(in *operators.SubscriptionStatus, out *SubscriptionStatus, s conversion.Scope) error {
	return autoConvert_operators_SubscriptionStatus_To_v1alpha1_SubscriptionStatus(in, out, s)
}
