package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	etcdClientSecretFileName = "etcd-client-secret.yaml.template"
)

var _ asset.WritableAsset = (*EtcdClientSecret)(nil)

// EtcdClientSecret is an asset for the etcd client signer
type EtcdClientSecret struct {
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *EtcdClientSecret) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *EtcdClientSecret) Name() string {
	return "EtcdClientSecret"
}

// Generate generates the actual files by this asset
func (t *EtcdClientSecret) Generate(parents asset.Parents) error {
	fileName := etcdClientSecretFileName
	data, err := content.GetBootkubeTemplate(fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *EtcdClientSecret) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *EtcdClientSecret) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, etcdClientSecretFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
