// This file was generated by go generate; DO NOT EDIT

package language

import "golang.org/x/text/internal/tag"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "29"

const numLanguages = 8654

const numScripts = 230

const numRegions = 354

type fromTo struct {
	from uint16
	to   uint16
}

const nonCanonicalUnd = 649
const (
	_af  = 10
	_am  = 17
	_ar  = 21
	_az  = 36
	_bg  = 56
	_bn  = 75
	_ca  = 97
	_cs  = 121
	_da  = 128
	_de  = 133
	_el  = 154
	_en  = 155
	_es  = 157
	_et  = 159
	_fa  = 164
	_fi  = 168
	_fil = 170
	_fr  = 175
	_gu  = 211
	_he  = 224
	_hi  = 225
	_hr  = 238
	_hu  = 242
	_hy  = 243
	_id  = 248
	_is  = 258
	_it  = 259
	_ja  = 263
	_ka  = 273
	_kk  = 303
	_km  = 307
	_kn  = 309
	_ko  = 310
	_ky  = 333
	_lo  = 357
	_lt  = 361
	_lv  = 368
	_mk  = 396
	_ml  = 397
	_mn  = 399
	_mo  = 402
	_mr  = 406
	_ms  = 410
	_mul = 414
	_my  = 421
	_nb  = 431
	_ne  = 436
	_nl  = 445
	_no  = 449
	_pa  = 471
	_pl  = 487
	_pt  = 495
	_ro  = 515
	_ru  = 519
	_sh  = 549
	_si  = 552
	_sk  = 554
	_sl  = 556
	_sq  = 570
	_sr  = 571
	_sv  = 583
	_sw  = 584
	_ta  = 593
	_te  = 600
	_th  = 605
	_tl  = 616
	_tn  = 619
	_tr  = 623
	_uk  = 646
	_ur  = 652
	_uz  = 653
	_vi  = 658
	_zh  = 708
	_zu  = 710
	_jbo = 265
	_ami = 1033
	_bnn = 1740
	_hak = 221
	_tlh = 13850
	_lb  = 340
	_nv  = 458
	_pwn = 11438
	_tao = 13571
	_tay = 13581
	_tsu = 14045
	_nn  = 447
	_sfb = 13012
	_vgt = 15084
	_sgg = 13043
	_cmn = 2390
	_nan = 428
	_hsn = 240
)

const langPrivateStart = 0x2d09

const langPrivateEnd = 0x2f10

// lang holds an alphabetically sorted list of ISO-639 language identifiers.
// All entries are 4 bytes. The index of the identifier (divided by 4) is the language tag.
// For 2-byte language identifiers, the two successive bytes have the following meaning:
//     - if the first letter of the 2- and 3-letter ISO codes are the same:
//       the second and third letter of the 3-letter ISO code.
//     - otherwise: a 0 and a by 2 bits right-shifted index into altLangISO3.
// For 3-byte language identifiers the 4th byte is 0.
var lang tag.Index = "" + // Size: 2856 bytes
	"---\x00aaarabbkabr\x00ace\x00ach\x00ada\x00ady\x00aeveaeb\x00affragq\x00" +
	"aho\x00akkaakk\x00aln\x00alt\x00ammhamo\x00anrgaoz\x00arraarc\x00arn\x00" +
	"aro\x00arq\x00ary\x00arz\x00assmasa\x00ase\x00ast\x00atj\x00avvaawa\x00a" +
	"yymazzebaakbal\x00ban\x00bap\x00bar\x00bas\x00bax\x00bbc\x00bbj\x00bci" +
	"\x00beelbej\x00bem\x00bew\x00bez\x00bfd\x00bfq\x00bft\x00bfy\x00bgulbgc" +
	"\x00bgn\x00bgx\x00bhihbhb\x00bhi\x00bhk\x00bho\x00biisbik\x00bin\x00bjj" +
	"\x00bjn\x00bkm\x00bku\x00blt\x00bmambmq\x00bnenboodbpy\x00bqi\x00bqv\x00" +
	"brrebra\x00brh\x00brx\x00bsosbsq\x00bss\x00bto\x00btv\x00bua\x00buc\x00b" +
	"ug\x00bum\x00bvb\x00byn\x00byv\x00bze\x00caatcch\x00ccp\x00ceheceb\x00cg" +
	"g\x00chhachk\x00chm\x00cho\x00chp\x00chr\x00cja\x00cjm\x00ckb\x00cooscop" +
	"\x00cps\x00crrecrj\x00crk\x00crl\x00crm\x00crs\x00csescsb\x00csw\x00ctd" +
	"\x00cuhucvhvcyymdaandak\x00dar\x00dav\x00dcc\x00deeuden\x00dgr\x00dje" +
	"\x00dnj\x00doi\x00dsb\x00dtm\x00dtp\x00dty\x00dua\x00dvivdyo\x00dyu\x00d" +
	"zzoebu\x00eeweefi\x00egl\x00egy\x00eky\x00elllenngeopoes\x00\x05esu\x00e" +
	"tstett\x00euusewo\x00ext\x00faasfan\x00ffulffm\x00fiinfia\x00fil\x00fit" +
	"\x00fjijfoaofon\x00frrafrc\x00frp\x00frr\x00frs\x00fud\x00fuq\x00fur\x00" +
	"fuv\x00fvr\x00fyrygalegaa\x00gag\x00gan\x00gay\x00gbm\x00gbz\x00gcr\x00g" +
	"dlagez\x00ggn\x00gil\x00gjk\x00gju\x00gllgglk\x00gnrngom\x00gon\x00gor" +
	"\x00gos\x00got\x00grc\x00grt\x00gsw\x00guujgub\x00guc\x00gur\x00guw\x00g" +
	"uz\x00gvlvgvr\x00gwi\x00haauhak\x00haw\x00haz\x00heebhiinhif\x00hil\x00h" +
	"lu\x00hmd\x00hnd\x00hne\x00hnj\x00hnn\x00hno\x00homohoc\x00hoj\x00hrrvhs" +
	"b\x00hsn\x00htathuunhyyehzerianaiba\x00ibb\x00idndieleigboiiiiikpkikt" +
	"\x00ilo\x00inndinh\x00iodoisslittaiukuiw\x00\x03izh\x00japnjam\x00jbo" +
	"\x00jgo\x00ji\x00\x06jmc\x00jml\x00jut\x00jvavjwavkaatkaa\x00kab\x00kac" +
	"\x00kaj\x00kam\x00kao\x00kbd\x00kcg\x00kck\x00kde\x00kdt\x00kea\x00ken" +
	"\x00kfo\x00kfr\x00kfy\x00kgonkge\x00kgp\x00kha\x00khb\x00khn\x00khq\x00k" +
	"ht\x00khw\x00kiikkiu\x00kjuakjg\x00kkazkkj\x00klalkln\x00kmhmkmb\x00knan" +
	"koorkoi\x00kok\x00kos\x00kpe\x00kraukrc\x00kri\x00krj\x00krl\x00kru\x00k" +
	"sasksb\x00ksf\x00ksh\x00kuurkum\x00kvomkvr\x00kvx\x00kw\x00\x01kxm\x00kx" +
	"p\x00kyirlaatlab\x00lad\x00lag\x00lah\x00laj\x00lbtzlbe\x00lbw\x00lcp" +
	"\x00lep\x00lez\x00lgugliimlif\x00lij\x00lis\x00ljp\x00lki\x00lkt\x00lmn" +
	"\x00lmo\x00lninloaolol\x00loz\x00lrc\x00ltitltg\x00luublua\x00luo\x00luy" +
	"\x00luz\x00lvavlwl\x00lzh\x00lzz\x00mad\x00maf\x00mag\x00mai\x00mak\x00m" +
	"an\x00mas\x00maz\x00mdf\x00mdh\x00mdr\x00men\x00mer\x00mfa\x00mfe\x00mgl" +
	"gmgh\x00mgo\x00mgp\x00mgy\x00mhahmirimin\x00mis\x00mkkdmlalmls\x00mnonmn" +
	"i\x00mnw\x00moolmoe\x00moh\x00mos\x00mrarmrd\x00mrj\x00mro\x00mssamtltmt" +
	"r\x00mua\x00mul\x00mus\x00mvy\x00mwk\x00mwr\x00mwv\x00mxc\x00myyamyv\x00" +
	"myx\x00myz\x00mzn\x00naaunah\x00nan\x00nap\x00naq\x00nbobnch\x00nddendc" +
	"\x00nds\x00neepnew\x00ngdongl\x00nhe\x00nhw\x00nij\x00niu\x00njo\x00nlld" +
	"nmg\x00nnnonnh\x00noornod\x00noe\x00non\x00nqo\x00nrblnsk\x00nso\x00nus" +
	"\x00nvavnxq\x00nyyanym\x00nyn\x00nzi\x00occiojjiomrmorriosssosa\x00otk" +
	"\x00paanpag\x00pal\x00pam\x00pap\x00pau\x00pcd\x00pcm\x00pdc\x00pdt\x00p" +
	"eo\x00pfl\x00phn\x00pilipka\x00pko\x00plolpms\x00pnt\x00pon\x00pra\x00pr" +
	"d\x00prg\x00psusptorpuu\x00quuequc\x00qug\x00raj\x00rcf\x00rej\x00rgn" +
	"\x00ria\x00rif\x00rjs\x00rkt\x00rmohrmf\x00rmo\x00rmt\x00rmu\x00rnunrng" +
	"\x00roonrob\x00rof\x00rtm\x00ruusrue\x00rug\x00rw\x00\x04rwk\x00ryu\x00s" +
	"aansaf\x00sah\x00saq\x00sas\x00sat\x00saz\x00sbp\x00scrdsck\x00scn\x00sc" +
	"o\x00scs\x00sdndsdc\x00sdh\x00semesef\x00seh\x00sei\x00ses\x00sgagsga" +
	"\x00sgs\x00sh\x00\x02shi\x00shn\x00siinsid\x00sklkskr\x00sllvsli\x00sly" +
	"\x00smmosma\x00smi\x00smj\x00smn\x00smp\x00sms\x00snnasnk\x00soomsou\x00" +
	"sqqisrrpsrb\x00srn\x00srr\x00srx\x00ssswssy\x00stotstq\x00suunsuk\x00sus" +
	"\x00svweswwaswb\x00swc\x00swg\x00swv\x00sxn\x00syl\x00syr\x00szl\x00taam" +
	"taj\x00tbw\x00tcy\x00tdd\x00tdg\x00tdh\x00teeltem\x00teo\x00tet\x00tggkt" +
	"hhathl\x00thq\x00thr\x00tiirtig\x00tiv\x00tkuktkl\x00tkr\x00tkt\x00tlglt" +
	"ly\x00tmh\x00tnsntoontog\x00tpi\x00trurtru\x00trv\x00tssotsd\x00tsf\x00t" +
	"sg\x00tsj\x00ttatttj\x00tts\x00ttt\x00tum\x00tvl\x00twwitwq\x00txg\x00ty" +
	"ahtyv\x00tzm\x00udm\x00ugiguga\x00ukkruli\x00umb\x00und\x00unr\x00unx" +
	"\x00urrduzzbvai\x00veenvec\x00vep\x00viievic\x00vls\x00vmf\x00vmw\x00voo" +
	"lvot\x00vro\x00vun\x00walnwae\x00wal\x00war\x00wbp\x00wbq\x00wbr\x00wls" +
	"\x00wni\x00woolwtm\x00wuu\x00xav\x00xcr\x00xhhoxlc\x00xld\x00xmf\x00xmn" +
	"\x00xmr\x00xna\x00xnr\x00xog\x00xpr\x00xsa\x00xsr\x00yao\x00yap\x00yav" +
	"\x00ybb\x00yiidyooryrl\x00yua\x00yue\x00zahazag\x00zbl\x00zdj\x00zea\x00" +
	"zgh\x00zhhozmi\x00zuulzxx\x00zza\x00\xff\xff\xff\xff"

const langNoIndexOffset = 713

// langNoIndex is a bit vector of all 3-letter language codes that are not used as an index
// in lookup tables. The language ids for these language codes are derived directly
// from the letters and are not consecutive.
// Size: 2197 bytes, 2197 elements
var langNoIndex = [2197]uint8{
	// Entry 0 - 3F
	0xff, 0xfd, 0xfd, 0xfe, 0xef, 0xf7, 0xbf, 0xd2,
	0xfb, 0xbf, 0xfe, 0xfa, 0xb7, 0x1d, 0x3c, 0x57,
	0x6f, 0x97, 0x73, 0xf8, 0xff, 0xef, 0xff, 0x70,
	0xaf, 0x03, 0xff, 0xff, 0xcf, 0x05, 0x85, 0x62,
	0xe9, 0xbf, 0xfd, 0xff, 0xff, 0xf7, 0xfd, 0x77,
	0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3,
	0xc9, 0xff, 0xff, 0xff, 0x4d, 0xb8, 0x0a, 0x6a,
	0x7e, 0xfa, 0xe3, 0xfe, 0x7e, 0xff, 0x77, 0xff,
	// Entry 40 - 7F
	0xff, 0xff, 0xff, 0xdf, 0x2b, 0xf4, 0xf1, 0xe0,
	0x5d, 0xe7, 0x9f, 0x14, 0x07, 0x20, 0xdf, 0xed,
	0x9f, 0x3f, 0xc9, 0x21, 0xf8, 0x3f, 0x94, 0xf7,
	0x7e, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff,
	0xff, 0xff, 0x5f, 0xfc, 0xdb, 0xfd, 0xbf, 0xb5,
	0x7b, 0xdf, 0x7f, 0xf7, 0xeb, 0xfe, 0xff, 0xa7,
	0xbd, 0xff, 0x7f, 0xf7, 0xff, 0xef, 0xef, 0xef,
	0xff, 0xff, 0x9f, 0xff, 0xff, 0xef, 0xff, 0xdf,
	// Entry 80 - BF
	0xff, 0xff, 0xf3, 0xff, 0xfb, 0x2f, 0xff, 0xff,
	0xfb, 0xee, 0xff, 0xbd, 0xdb, 0xff, 0xdf, 0xf7,
	0xff, 0xfa, 0xfd, 0xff, 0x7e, 0xaf, 0x7b, 0xfe,
	0x7f, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff,
	0xff, 0xdf, 0xfb, 0xff, 0xfd, 0xfc, 0xfb, 0xff,
	0xff, 0xff, 0xff, 0xf7, 0x7f, 0xbf, 0xfd, 0xd5,
	0xa5, 0x77, 0x40, 0xff, 0x9c, 0xc1, 0x41, 0x2c,
	0x08, 0x24, 0x41, 0x00, 0x50, 0x40, 0x00, 0x80,
	// Entry C0 - FF
	0xfb, 0x4a, 0xf2, 0x9f, 0xb4, 0x42, 0x41, 0x96,
	0x9b, 0x14, 0x88, 0xf6, 0x7b, 0xe7, 0x17, 0x56,
	0x55, 0x7d, 0x0e, 0x1c, 0x37, 0x71, 0xf3, 0xef,
	0x97, 0xff, 0x5d, 0x38, 0x64, 0x08, 0x00, 0x10,
	0xbc, 0x87, 0xaf, 0xdf, 0xff, 0xf7, 0x73, 0x35,
	0x3e, 0x87, 0xc7, 0xdf, 0xff, 0x00, 0x81, 0x00,
	0xb0, 0x05, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x40, 0x00, 0x40, 0x92, 0x21, 0xd0, 0xbf, 0x5d,
	// Entry 100 - 13F
	0xfd, 0xde, 0xfe, 0x5e, 0x00, 0x00, 0x02, 0x64,
	0x8d, 0x19, 0xc1, 0xdf, 0x79, 0x22, 0x00, 0x00,
	0x00, 0xdf, 0x6d, 0xdc, 0x26, 0xe5, 0xd9, 0xf3,
	0xfe, 0xff, 0xfd, 0xcb, 0x9f, 0x14, 0x01, 0x0c,
	0x86, 0x00, 0xd1, 0x00, 0xf0, 0xc5, 0x67, 0x5f,
	0x56, 0x89, 0x5e, 0xb7, 0xec, 0xef, 0x03, 0x00,
	0x02, 0x00, 0x00, 0x00, 0xc0, 0x77, 0xda, 0x57,
	0x90, 0x69, 0x01, 0x2c, 0x96, 0x79, 0xe0, 0xff,
	// Entry 140 - 17F
	0xff, 0x7f, 0x00, 0x00, 0x00, 0x01, 0x08, 0x56,
	0x01, 0x00, 0x00, 0xb0, 0x14, 0x03, 0x50, 0x16,
	0x0a, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x09,
	0x00, 0x00, 0x60, 0x10, 0x00, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x44, 0x00, 0x00, 0x10, 0x00, 0x04,
	0x08, 0x00, 0x00, 0x04, 0x00, 0x80, 0x28, 0x04,
	0x00, 0x00, 0x50, 0xd5, 0x2d, 0x00, 0x64, 0x35,
	0x24, 0x53, 0xf5, 0xd4, 0xbd, 0xe2, 0xcd, 0x03,
	// Entry 180 - 1BF
	0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x17, 0x39, 0x01, 0xdd, 0x57, 0x98,
	0x21, 0x98, 0xa5, 0x00, 0x00, 0x01, 0x40, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x40, 0x00, 0x44, 0x00, 0x00, 0xb0, 0xfe,
	0xa9, 0x39, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x01, 0x28, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x20, 0x04, 0xa6, 0x08, 0x04, 0x00, 0x08,
	0x81, 0x50, 0x00, 0x00, 0x08, 0x11, 0x86, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x06, 0x55,
	0x02, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x60,
	0x3b, 0x83, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xbe, 0xdf, 0xff, 0xfe, 0xbf,
	// Entry 200 - 23F
	0xdf, 0xc7, 0x83, 0x82, 0xc0, 0xff, 0xdf, 0x27,
	0xcf, 0x5f, 0xe7, 0x01, 0x10, 0x20, 0xb2, 0xc5,
	0xa4, 0x45, 0x25, 0x9b, 0x03, 0xcf, 0xf0, 0xdf,
	0x03, 0xc4, 0x08, 0x10, 0x01, 0x0e, 0x01, 0xe3,
	0x92, 0x54, 0xdb, 0x38, 0xf1, 0x7f, 0xf7, 0x6d,
	0xf9, 0xff, 0x1c, 0x7d, 0x04, 0x08, 0x00, 0x01,
	0x21, 0x12, 0x6c, 0x5f, 0xdd, 0x0f, 0x85, 0x4f,
	0x40, 0x40, 0x00, 0x04, 0xf9, 0xfd, 0xbd, 0xd4,
	// Entry 240 - 27F
	0xe8, 0x13, 0xf4, 0x27, 0xa3, 0x0d, 0x00, 0x00,
	0x20, 0x7b, 0x39, 0x02, 0x05, 0x84, 0x00, 0xf0,
	0xbf, 0x7f, 0xda, 0x00, 0x18, 0x04, 0x81, 0x00,
	0x00, 0x00, 0x80, 0x10, 0x94, 0x1c, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x04,
	0x08, 0xb4, 0x7c, 0xa5, 0x0c, 0x40, 0x00, 0x00,
	0x11, 0x04, 0x04, 0x6c, 0x00, 0x20, 0x70, 0xff,
	0xfb, 0x7f, 0x60, 0x00, 0x05, 0x9b, 0xdd, 0x6e,
	// Entry 280 - 2BF
	0x03, 0x00, 0x11, 0x00, 0x00, 0x00, 0x40, 0x05,
	0xb5, 0xb6, 0x80, 0x08, 0x04, 0x00, 0x04, 0x51,
	0xe2, 0xff, 0xfd, 0x3f, 0x05, 0x09, 0x08, 0x05,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x02, 0x60,
	0xe5, 0x48, 0x14, 0x89, 0x20, 0xc0, 0x47, 0x80,
	0x07, 0x00, 0x00, 0x00, 0xcc, 0x50, 0x40, 0x24,
	0x85, 0x47, 0x84, 0x40, 0x20, 0x10, 0x00, 0x20,
	// Entry 2C0 - 2FF
	0x02, 0x50, 0x88, 0x11, 0x00, 0xd1, 0x6c, 0xee,
	0x50, 0x27, 0x1d, 0x11, 0x69, 0x06, 0x59, 0xe9,
	0x33, 0x08, 0x00, 0x20, 0x05, 0x40, 0x10, 0x00,
	0x00, 0x00, 0x50, 0x44, 0x96, 0x49, 0xd6, 0x5d,
	0xa7, 0x81, 0x47, 0x97, 0xfb, 0x00, 0x10, 0x00,
	0x08, 0x00, 0x80, 0x00, 0x40, 0x45, 0x00, 0x01,
	0x02, 0x00, 0x01, 0x40, 0x80, 0x00, 0x04, 0x08,
	0xf8, 0xeb, 0xf6, 0x39, 0xc4, 0x89, 0x16, 0x00,
	// Entry 300 - 33F
	0x00, 0x0c, 0x04, 0x01, 0x20, 0x20, 0xdd, 0xa2,
	0x01, 0x00, 0x00, 0x00, 0x12, 0x04, 0x00, 0x00,
	0x04, 0x10, 0xf0, 0x9d, 0x95, 0x13, 0x04, 0x80,
	0x00, 0x01, 0xd0, 0x12, 0x40, 0x00, 0x10, 0xb0,
	0x10, 0x62, 0x4c, 0xd2, 0x02, 0x01, 0x4a, 0x00,
	0x46, 0x04, 0x00, 0x08, 0x02, 0x00, 0x20, 0xc0,
	0x00, 0x80, 0x06, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0xd8, 0x6f, 0x15, 0x02, 0x08, 0x00,
	// Entry 340 - 37F
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01,
	0x00, 0x10, 0x00, 0x00, 0x00, 0xf8, 0x85, 0xe3,
	0xdd, 0xff, 0xff, 0xff, 0xbb, 0xff, 0x7f, 0xfb,
	0xff, 0xfc, 0xfe, 0xdf, 0xff, 0xff, 0xff, 0xf6,
	0xfb, 0xfe, 0xf7, 0x1f, 0xff, 0xb3, 0xed, 0xff,
	0xdb, 0xed, 0xff, 0xfe, 0xff, 0xfe, 0xdf, 0xff,
	0xff, 0xff, 0xf7, 0xff, 0xfd, 0xff, 0xff, 0xff,
	0xfd, 0xff, 0xdf, 0xaf, 0x9c, 0xff, 0xfb, 0xff,
	// Entry 380 - 3BF
	0xff, 0xff, 0xff, 0xff, 0xef, 0xd2, 0xbb, 0xdf,
	0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef,
	0xfd, 0xff, 0xff, 0xf7, 0xfd, 0xff, 0xff, 0xff,
	0xef, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x5f, 0xd3, 0x7b, 0xfd, 0xd9, 0xdf, 0xef,
	0xbc, 0x18, 0x05, 0x2c, 0xff, 0x07, 0xf0, 0xff,
	0xf7, 0x5f, 0x00, 0x08, 0x00, 0xc3, 0x3d, 0x1b,
	0x06, 0xe6, 0x72, 0xf0, 0xdd, 0x3c, 0x7f, 0x44,
	// Entry 3C0 - 3FF
	0x02, 0x30, 0x9f, 0x7a, 0x16, 0xfd, 0xff, 0x57,
	0xf2, 0xff, 0x39, 0xff, 0xf2, 0x1e, 0x95, 0xf7,
	0xf7, 0xff, 0x45, 0x80, 0x01, 0x02, 0x00, 0x00,
	0x40, 0x54, 0x9f, 0x8a, 0xd9, 0xd9, 0x0e, 0x11,
	0x84, 0x51, 0xc0, 0xf3, 0xfb, 0x47, 0x00, 0x01,
	0x05, 0xd1, 0x50, 0x58, 0x00, 0x00, 0x00, 0x10,
	0x04, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x17, 0xd2,
	0xf9, 0xfd, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 400 - 43F
	0xd7, 0x6f, 0xff, 0xff, 0xdf, 0x7d, 0xbb, 0xff,
	0xff, 0xff, 0xf7, 0xf3, 0xef, 0xff, 0xff, 0xf7,
	0xff, 0xdf, 0xdb, 0x7f, 0xff, 0xff, 0x7f, 0xff,
	0xff, 0xff, 0xef, 0xff, 0xbc, 0xff, 0xff, 0xfb,
	0xff, 0xfb, 0xff, 0xde, 0x76, 0xbd, 0xff, 0xf7,
	0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xf3, 0xfe,
	0xef, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xde,
	0xf7, 0xbb, 0xef, 0xf7, 0xff, 0xfb, 0xbf, 0xdf,
	// Entry 440 - 47F
	0xfd, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0x5f, 0x7d,
	0x7f, 0xff, 0xff, 0xf7, 0xe5, 0xfc, 0xff, 0xfd,
	0x7f, 0x7f, 0xff, 0x9e, 0xae, 0xff, 0xee, 0xff,
	0x7f, 0xf7, 0x7b, 0x02, 0x82, 0x04, 0xff, 0xf7,
	0xff, 0xbf, 0xd7, 0xef, 0xfe, 0xdf, 0xf7, 0xfe,
	0xe2, 0x8e, 0xe7, 0xff, 0xf7, 0xff, 0x56, 0xbd,
	0xcd, 0xff, 0xfb, 0xff, 0xff, 0xdf, 0xef, 0xff,
	0xe5, 0xdf, 0x7d, 0x0f, 0xa7, 0x51, 0x04, 0x44,
	// Entry 480 - 4BF
	0x13, 0xd0, 0x5d, 0xaf, 0xa6, 0xfd, 0xb9, 0xff,
	0x63, 0x5d, 0x5b, 0xff, 0xff, 0xbf, 0x3f, 0x20,
	0x14, 0x00, 0x57, 0x51, 0x82, 0x65, 0xf5, 0x49,
	0xe2, 0xff, 0xfc, 0xdf, 0x00, 0x05, 0xc5, 0x05,
	0x00, 0x22, 0x00, 0x74, 0x69, 0x10, 0x08, 0x04,
	0x41, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x51, 0x60, 0x05, 0x04, 0x01, 0x00, 0x00,
	0x06, 0x01, 0x20, 0x00, 0x18, 0x01, 0x92, 0xb1,
	// Entry 4C0 - 4FF
	0xfd, 0x67, 0x4b, 0x06, 0x95, 0x06, 0x57, 0xed,
	0xfb, 0x4c, 0x9d, 0x7b, 0x83, 0x04, 0x62, 0x40,
	0x00, 0x15, 0x42, 0x00, 0x00, 0x00, 0x54, 0x83,
	0xf9, 0x4f, 0x10, 0x8c, 0xc9, 0x46, 0xde, 0xf7,
	0x13, 0x31, 0x00, 0x20, 0x00, 0x00, 0x00, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x10, 0x00,
	0x01, 0x40, 0x00, 0xf0, 0x5b, 0xf4, 0xbe, 0x7d,
	0xba, 0xcf, 0xf7, 0xaf, 0x42, 0x04, 0x84, 0x41,
	// Entry 500 - 53F
	0xb0, 0xff, 0x79, 0x7a, 0x04, 0x00, 0x00, 0x49,
	0x2d, 0x14, 0x27, 0x77, 0xed, 0xf1, 0xbf, 0xef,
	0x3f, 0x00, 0x00, 0x02, 0xc6, 0xa0, 0x1e, 0xfc,
	0xbb, 0xff, 0xfd, 0xfb, 0xb7, 0xfd, 0xf5, 0xff,
	0xfd, 0xfc, 0xd5, 0xed, 0x47, 0xf4, 0x7f, 0x10,
	0x01, 0x01, 0x84, 0x6d, 0xff, 0xf7, 0xdd, 0xf9,
	0x5f, 0x05, 0x86, 0xef, 0xf5, 0x77, 0xbd, 0x3c,
	0x00, 0x00, 0x00, 0x43, 0x71, 0x42, 0x00, 0x40,
	// Entry 540 - 57F
	0x00, 0x00, 0x01, 0x43, 0x19, 0x00, 0x08, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 580 - 5BF
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xab, 0xbd, 0xe7, 0x57, 0xee, 0x13, 0x5d,
	0x09, 0xc1, 0x40, 0x21, 0xfa, 0x17, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xde, 0xff, 0xbf,
	0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
	0x00, 0x30, 0x95, 0xe3, 0x10, 0x00, 0x00, 0x00,
	0x11, 0x04, 0x16, 0x00, 0x01, 0x02, 0x00, 0x81,
	0xa3, 0x01, 0x50, 0x00, 0x00, 0x83, 0x11, 0x40,
	// Entry 5C0 - 5FF
	0x00, 0x00, 0x00, 0xf0, 0xdd, 0x7b, 0x7e, 0x02,
	0xaa, 0x10, 0x5d, 0xd8, 0x52, 0x00, 0x80, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x02, 0x02,
	0x19, 0x00, 0x10, 0x02, 0x10, 0x61, 0x5a, 0x9d,
	0x31, 0x00, 0x00, 0x00, 0x01, 0x50, 0x02, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x42, 0x00, 0x20, 0x00,
	0x00, 0x1f, 0xdf, 0xf2, 0xfd, 0xff, 0xfd, 0x3f,
	0x9f, 0x18, 0xcf, 0x9c, 0xbf, 0xaf, 0x5f, 0xfe,
	// Entry 600 - 63F
	0x7b, 0x4b, 0x40, 0x10, 0xe1, 0xfd, 0xaf, 0xfd,
	0xb7, 0xf7, 0xff, 0xf3, 0xdf, 0xff, 0x6f, 0xf1,
	0x7b, 0xf1, 0x7f, 0xdf, 0x7f, 0xbf, 0xfe, 0xb7,
	0xee, 0x1c, 0xfb, 0xdb, 0xef, 0xdf, 0xff, 0xfd,
	0x7e, 0xbe, 0x57, 0xff, 0x6f, 0x81, 0x76, 0x1f,
	0xd4, 0x77, 0xf5, 0xfd, 0xff, 0xff, 0xeb, 0xfe,
	0xbf, 0x5f, 0x57, 0x1b, 0xeb, 0x5f, 0x50, 0x18,
	0x02, 0xfa, 0xff, 0x9d, 0x15, 0x97, 0x15, 0x0f,
	// Entry 640 - 67F
	0x75, 0xc4, 0x7d, 0x81, 0x82, 0xf1, 0xd7, 0x7e,
	0xff, 0xff, 0xff, 0xef, 0xff, 0xfd, 0xdd, 0xde,
	0xfc, 0xfd, 0xf6, 0x5f, 0x7a, 0x1f, 0x40, 0x98,
	0x02, 0xff, 0xe3, 0xff, 0xf3, 0xd6, 0xf2, 0xff,
	0xfb, 0xdf, 0x7d, 0x50, 0x1e, 0x15, 0x7b, 0xb4,
	0xf5, 0xbe, 0xff, 0xff, 0xf3, 0xf7, 0xff, 0xf7,
	0x7f, 0xff, 0xff, 0xbe, 0xdb, 0xf7, 0xd7, 0xf9,
	0xef, 0x2f, 0x80, 0xbf, 0xc5, 0xff, 0xff, 0xf3,
	// Entry 680 - 6BF
	0x97, 0x9d, 0xff, 0xff, 0xf7, 0xcf, 0xfd, 0xbf,
	0xde, 0x7f, 0x06, 0x1d, 0x57, 0xff, 0xf8, 0xda,
	0x5d, 0xce, 0x7d, 0x16, 0xb9, 0xea, 0x69, 0xa0,
	0x1a, 0x20, 0x00, 0x30, 0x02, 0x04, 0x24, 0x48,
	0x04, 0x00, 0x00, 0x40, 0xd4, 0x02, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x04, 0x00, 0x20, 0x01, 0x06,
	0x50, 0x00, 0x08, 0x00, 0x00, 0x00, 0x24, 0x00,
	0x04, 0x00, 0x10, 0x8c, 0x58, 0xd5, 0x0d, 0x0f,
	// Entry 6C0 - 6FF
	0x14, 0x4d, 0xf1, 0x16, 0x44, 0xd1, 0x42, 0x08,
	0x40, 0x00, 0x00, 0x40, 0x00, 0x08, 0x00, 0x00,
	0x00, 0xdc, 0xff, 0xeb, 0x1f, 0x58, 0x08, 0x41,
	0x04, 0xa0, 0x04, 0x00, 0x30, 0x12, 0x40, 0x22,
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x80, 0x10, 0x10, 0xaf,
	0x6f, 0x93, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x80, 0x80, 0x25, 0x00, 0x00,
	// Entry 700 - 73F
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
	0x80, 0x86, 0xc2, 0x02, 0x00, 0x00, 0x00, 0x01,
	0xdf, 0x18, 0x00, 0x00, 0x02, 0xf0, 0xfd, 0x79,
	0x3b, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
	0x03, 0x00, 0x09, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 740 - 77F
	0x00, 0x00, 0x00, 0xef, 0xf7, 0xfd, 0xcf, 0x7e,
	0xa0, 0x11, 0x10, 0x00, 0x00, 0x92, 0x01, 0x44,
	0xcd, 0xf9, 0x5e, 0x00, 0x01, 0x00, 0x30, 0x14,
	0x04, 0x55, 0x10, 0x01, 0x04, 0xf6, 0x3f, 0x7a,
	0x05, 0x04, 0x00, 0xb0, 0x80, 0x00, 0x55, 0x55,
	0x97, 0x7c, 0x9f, 0x71, 0xcc, 0x78, 0xd1, 0x43,
	0xf5, 0x57, 0x67, 0x14, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xf7, 0xdb, 0x1f, 0x54, 0x60,
	// Entry 780 - 7BF
	0x03, 0x68, 0x01, 0x10, 0x8b, 0x38, 0xaa, 0x01,
	0x00, 0x00, 0x30, 0x00, 0x24, 0x44, 0x00, 0x00,
	0x10, 0x03, 0x11, 0x02, 0x01, 0x00, 0x00, 0xf0,
	0xf5, 0xff, 0xd5, 0xd7, 0xbc, 0x70, 0xd6, 0x78,
	0x78, 0x15, 0x50, 0x00, 0xa4, 0x84, 0xe9, 0x41,
	0x00, 0x00, 0x00, 0x6b, 0x39, 0x52, 0x74, 0x00,
	0xe8, 0x30, 0x90, 0x6a, 0x92, 0x00, 0x00, 0x02,
	0xff, 0xef, 0xff, 0x4f, 0x85, 0x53, 0xf4, 0xed,
	// Entry 7C0 - 7FF
	0xdd, 0xbf, 0x72, 0x19, 0xc7, 0x0c, 0xf5, 0x42,
	0x54, 0xdd, 0x77, 0x14, 0x00, 0x80, 0xc0, 0x56,
	0xcc, 0x16, 0x9e, 0xfb, 0x35, 0x7d, 0xef, 0xff,
	0xbd, 0xa4, 0xaf, 0x01, 0x44, 0x18, 0x01, 0x5d,
	0x4e, 0x4a, 0x08, 0x50, 0x28, 0x30, 0xe0, 0x80,
	0x10, 0x20, 0x24, 0x00, 0xff, 0x3f, 0xdf, 0x67,
	0xfe, 0x01, 0x06, 0x88, 0x0a, 0x40, 0x16, 0x01,
	0x01, 0x15, 0x2b, 0x3e, 0x01, 0x00, 0x00, 0x10,
	// Entry 800 - 83F
	0x90, 0x69, 0x45, 0x02, 0x02, 0x01, 0xe1, 0xbf,
	0xbf, 0x03, 0x00, 0x00, 0x10, 0xd4, 0xa7, 0xd1,
	0x54, 0x9e, 0x44, 0xdf, 0xfd, 0x8f, 0x66, 0xb3,
	0x55, 0x20, 0xd4, 0xc3, 0xd8, 0x30, 0x3d, 0x80,
	0x00, 0x00, 0x00, 0x4c, 0xd4, 0x11, 0xc5, 0x84,
	0x6e, 0x50, 0x00, 0x22, 0x50, 0x6e, 0xbf, 0xdb,
	0x07, 0x00, 0x20, 0x10, 0x84, 0xb2, 0x45, 0x10,
	0x06, 0x44, 0x00, 0x00, 0x12, 0x02, 0x11, 0x00,
	// Entry 840 - 87F
	0xf0, 0xfb, 0xfd, 0x3f, 0x05, 0x00, 0x12, 0x81,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x02, 0x28,
	0x84, 0x00, 0x33, 0xc0, 0x23, 0x24, 0x00, 0x00,
	0x00, 0xcb, 0xe4, 0x3a, 0x42, 0xc8, 0x14, 0xf1,
	0xef, 0xff, 0x7f, 0x16, 0x01, 0x01, 0x84, 0x50,
	0x07, 0xfc, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x40,
	0x10, 0x38, 0x01, 0x01, 0x1c, 0x12, 0x40, 0xe1,
	// Entry 880 - 8BF
	0x76, 0x16, 0x08, 0x03, 0x10, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x24,
	0x0a, 0x00, 0x80, 0x00, 0x00,
}

// altLangISO3 holds an alphabetically sorted list of 3-letter language code alternatives
// to 2-letter language codes that cannot be derived using the method described above.
// Each 3-letter code is followed by its 1-byte langID.
var altLangISO3 tag.Index = "---\x00cor\x00hbs\x01heb\x02kin\x03spa\x04yid\x05\xff\xff\xff\xff"

// altLangIndex is used to convert indexes in altLangISO3 to langIDs.
// Size: 12 bytes, 6 elements
var altLangIndex = [6]uint16{
	0x014a, 0x0225, 0x0105, 0x020a, 0x009d, 0x010b,
}

// langAliasMap maps langIDs to their suggested replacements.
// Size: 640 bytes, 160 elements
var langAliasMap = [160]fromTo{
	0:   {from: 0xc4, to: 0xda},
	1:   {from: 0xff, to: 0xf8},
	2:   {from: 0x105, to: 0xe0},
	3:   {from: 0x10b, to: 0x2b9},
	4:   {from: 0x110, to: 0x10f},
	5:   {from: 0x192, to: 0x203},
	6:   {from: 0x1af, to: 0x1c1},
	7:   {from: 0x225, to: 0x23b},
	8:   {from: 0x268, to: 0xaa},
	9:   {from: 0x274, to: 0x252},
	10:  {from: 0x27d, to: 0xd},
	11:  {from: 0x2d5, to: 0x2db},
	12:  {from: 0x326, to: 0x93},
	13:  {from: 0x3c7, to: 0x1c48},
	14:  {from: 0x3e8, to: 0x23a},
	15:  {from: 0x3f9, to: 0x23a},
	16:  {from: 0x484, to: 0x15},
	17:  {from: 0x48f, to: 0xf3},
	18:  {from: 0x4d5, to: 0x1f38},
	19:  {from: 0x54a, to: 0x23},
	20:  {from: 0x550, to: 0x2732},
	21:  {from: 0x55c, to: 0x24},
	22:  {from: 0x57d, to: 0xa1},
	23:  {from: 0x5a3, to: 0x26},
	24:  {from: 0x5ac, to: 0x42},
	25:  {from: 0x615, to: 0x5a7},
	26:  {from: 0x65a, to: 0xc7a},
	27:  {from: 0x786, to: 0x1a5},
	28:  {from: 0x7cd, to: 0x16e},
	29:  {from: 0x7d4, to: 0x59},
	30:  {from: 0x855, to: 0x30b9},
	31:  {from: 0x8cf, to: 0x2c4},
	32:  {from: 0x90c, to: 0x23f1},
	33:  {from: 0x915, to: 0x95a},
	34:  {from: 0x932, to: 0x24f},
	35:  {from: 0x953, to: 0x3fc0},
	36:  {from: 0x956, to: 0x2c4},
	37:  {from: 0x995, to: 0x2b3e},
	38:  {from: 0x9c5, to: 0x2f18},
	39:  {from: 0xa50, to: 0x73},
	40:  {from: 0xa9f, to: 0x79},
	41:  {from: 0xb5f, to: 0x8a},
	42:  {from: 0xb6e, to: 0x1a2},
	43:  {from: 0xb8f, to: 0xb92},
	44:  {from: 0xb95, to: 0x2c8},
	45:  {from: 0xc76, to: 0x1df1},
	46:  {from: 0xc85, to: 0x2c31},
	47:  {from: 0xcd0, to: 0x1bd},
	48:  {from: 0xe67, to: 0x9f},
	49:  {from: 0xe9b, to: 0x179},
	50:  {from: 0xf37, to: 0xfc},
	51:  {from: 0x1010, to: 0xd},
	52:  {from: 0x11bb, to: 0xaf},
	53:  {from: 0x1207, to: 0xa6},
	54:  {from: 0x12b6, to: 0xb32},
	55:  {from: 0x12ba, to: 0x1d2},
	56:  {from: 0x12c9, to: 0x145c},
	57:  {from: 0x1317, to: 0x111},
	58:  {from: 0x131a, to: 0x85},
	59:  {from: 0x133a, to: 0x3a46},
	60:  {from: 0x1401, to: 0xcc},
	61:  {from: 0x145f, to: 0x9a},
	62:  {from: 0x1497, to: 0x278f},
	63:  {from: 0x14af, to: 0xca},
	64:  {from: 0x14be, to: 0xcd6},
	65:  {from: 0x1511, to: 0x12bb},
	66:  {from: 0x15a0, to: 0x154d},
	67:  {from: 0x15ad, to: 0x168a},
	68:  {from: 0x1621, to: 0x23f},
	69:  {from: 0x1710, to: 0x1a98},
	70:  {from: 0x180b, to: 0x2947},
	71:  {from: 0x1821, to: 0x102},
	72:  {from: 0x18f1, to: 0x104},
	73:  {from: 0x191d, to: 0x12ac},
	74:  {from: 0x1dcf, to: 0x3548},
	75:  {from: 0x1dd4, to: 0x1e74},
	76:  {from: 0x1df1, to: 0x18f},
	77:  {from: 0x1e7a, to: 0x145},
	78:  {from: 0x1e85, to: 0x13b},
	79:  {from: 0x1e89, to: 0x122},
	80:  {from: 0x1e90, to: 0x138},
	81:  {from: 0x1ea6, to: 0x1f82},
	82:  {from: 0x1ecc, to: 0x147},
	83:  {from: 0x1f30, to: 0x8d},
	84:  {from: 0x1f65, to: 0x12f8},
	85:  {from: 0x1f7d, to: 0x4235},
	86:  {from: 0x1f8b, to: 0x371a},
	87:  {from: 0x1fc4, to: 0x8d},
	88:  {from: 0x1fce, to: 0x8d},
	89:  {from: 0x1ff9, to: 0x6c1},
	90:  {from: 0x20ad, to: 0x2fbd},
	91:  {from: 0x2119, to: 0x30fc},
	92:  {from: 0x2209, to: 0x170},
	93:  {from: 0x227b, to: 0x18c},
	94:  {from: 0x2287, to: 0x189},
	95:  {from: 0x2291, to: 0x19a},
	96:  {from: 0x22e7, to: 0x8f2},
	97:  {from: 0x2340, to: 0x69},
	98:  {from: 0x23d5, to: 0x179},
	99:  {from: 0x2460, to: 0x244b},
	100: {from: 0x2490, to: 0x1f4},
	101: {from: 0x24be, to: 0x3a46},
	102: {from: 0x24fc, to: 0x244b},
	103: {from: 0x2520, to: 0x40ef},
	104: {from: 0x2686, to: 0x25ce},
	105: {from: 0x26ab, to: 0x1b4},
	106: {from: 0x271d, to: 0x2b3e},
	107: {from: 0x28b1, to: 0x1d1},
	108: {from: 0x2993, to: 0x1d3},
	109: {from: 0x29d6, to: 0x3a46},
	110: {from: 0x2a93, to: 0x1ee},
	111: {from: 0x2aaa, to: 0x32e},
	112: {from: 0x2ade, to: 0xa4},
	113: {from: 0x2adf, to: 0xa4},
	114: {from: 0x2b96, to: 0x183},
	115: {from: 0x2b9f, to: 0x1763},
	116: {from: 0x2bb1, to: 0x2b2c},
	117: {from: 0x2bb8, to: 0x152},
	118: {from: 0x2beb, to: 0x37},
	119: {from: 0x2bfc, to: 0x2019},
	120: {from: 0x2c37, to: 0x2c32},
	121: {from: 0x2c86, to: 0x2c6e},
	122: {from: 0x2f2a, to: 0x1f1},
	123: {from: 0x30fd, to: 0x3125},
	124: {from: 0x31c1, to: 0x203},
	125: {from: 0x3285, to: 0x1667},
	126: {from: 0x337d, to: 0x22a},
	127: {from: 0x33ef, to: 0x132},
	128: {from: 0x340d, to: 0x215},
	129: {from: 0x3494, to: 0x248},
	130: {from: 0x3557, to: 0x8d},
	131: {from: 0x35ad, to: 0x3689},
	132: {from: 0x35c2, to: 0x2a32},
	133: {from: 0x35c6, to: 0x4c},
	134: {from: 0x35c9, to: 0x2fbf},
	135: {from: 0x3603, to: 0x373d},
	136: {from: 0x3629, to: 0x3d57},
	137: {from: 0x363c, to: 0x376e},
	138: {from: 0x364b, to: 0x1d3b},
	139: {from: 0x364c, to: 0x2c31},
	140: {from: 0x36f3, to: 0x26a},
	141: {from: 0x38e5, to: 0xb28},
	142: {from: 0x390f, to: 0xe91},
	143: {from: 0x3a30, to: 0x28d},
	144: {from: 0x3d54, to: 0x7f},
	145: {from: 0x3f9f, to: 0x828},
	146: {from: 0x4055, to: 0x30a},
	147: {from: 0x4090, to: 0x3cf7},
	148: {from: 0x410f, to: 0x13a},
	149: {from: 0x4162, to: 0x3462},
	150: {from: 0x4164, to: 0x86},
	151: {from: 0x4246, to: 0x30b9},
	152: {from: 0x427a, to: 0x2b9},
	153: {from: 0x4361, to: 0x21a0},
	154: {from: 0x4374, to: 0x2473},
	155: {from: 0x43a7, to: 0x4645},
	156: {from: 0x4445, to: 0x4437},
	157: {from: 0x44d5, to: 0x44dc},
	158: {from: 0x46ad, to: 0x19a},
	159: {from: 0x473e, to: 0x2be},
}

// Size: 160 bytes, 160 elements
var langAliasTypes = [160]langAliasType{
	// Entry 0 - 3F
	0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 1, 0, 0, 1, 2, 1,
	1, 2, 0, 1, 0, 1, 2, 1, 1, 0, 0, 2, 1, 1, 0, 2,
	0, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 1, 1, 0, 0, 2,
	1, 1, 1, 1, 2, 1, 0, 1, 1, 2, 2, 0, 1, 2, 0, 1,
	// Entry 40 - 7F
	0, 1, 1, 1, 1, 0, 0, 2, 1, 0, 0, 0, 1, 1, 1, 1,
	1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 2, 2, 2,
	0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0,
	2, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 2, 0, 2, 1,
	// Entry 80 - BF
	1, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1,
	2, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1,
}

const (
	_Latn = 82
	_Hani = 50
	_Hans = 52
	_Hant = 53
	_Qaaa = 131
	_Qaai = 139
	_Qabx = 180
	_Zinh = 224
	_Zyyy = 229
	_Zzzz = 230
)

// script is an alphabetically sorted list of ISO 15924 codes. The index
// of the script in the string, divided by 4, is the internal scriptID.
var script tag.Index = "" + // Size: 928 bytes
	"----AdlmAfakAghbAhomArabAranArmiArmnAvstBaliBamuBassBatkBengBhksBlisBopo" +
	"BrahBraiBugiBuhdCakmCansCariChamCherCirtCoptCprtCyrlCyrsDevaDsrtDuplEgyd" +
	"EgyhEgypElbaEthiGeokGeorGlagGothGranGrekGujrGuruHanbHangHaniHanoHansHant" +
	"HatrHebrHiraHluwHmngHrktHungIndsItalJamoJavaJpanJurcKaliKanaKharKhmrKhoj" +
	"KitlKitsKndaKoreKpelKthiLanaLaooLatfLatgLatnLekeLepcLimbLinaLinbLisuLoma" +
	"LyciLydiMahjMandManiMarcMayaMendMercMeroMlymModiMongMoonMrooMteiMultMymr" +
	"NarbNbatNewaNkgbNkooNshuOgamOlckOrkhOryaOsgeOsmaPalmPaucPermPhagPhliPhlp" +
	"PhlvPhnxPiqdPlrdPrtiQaaaQaabQaacQaadQaaeQaafQaagQaahQaaiQaajQaakQaalQaam" +
	"QaanQaaoQaapQaaqQaarQaasQaatQaauQaavQaawQaaxQaayQaazQabaQabbQabcQabdQabe" +
	"QabfQabgQabhQabiQabjQabkQablQabmQabnQaboQabpQabqQabrQabsQabtQabuQabvQabw" +
	"QabxRjngRoroRunrSamrSaraSarbSaurSgnwShawShrdSiddSindSinhSoraSundSyloSyrc" +
	"SyreSyrjSyrnTagbTakrTaleTaluTamlTangTavtTeluTengTfngTglgThaaThaiTibtTirh" +
	"UgarVaiiVispWaraWoleXpeoXsuxYiiiZinhZmthZsyeZsymZxxxZyyyZzzz\xff\xff\xff" +
	"\xff"

// suppressScript is an index from langID to the dominant script for that language,
// if it exists.  If a script is given, it should be suppressed from the language tag.
// Size: 713 bytes, 713 elements
var suppressScript = [713]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x27, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	// Entry 80 - BF
	0x52, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0xd4, 0x00, 0x00, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2d, 0x52, 0x52, 0x52, 0x00, 0x52,
	0x00, 0x52, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x52,
	0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry C0 - FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x2e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x37, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52,
	0x00, 0x52, 0x52, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	// Entry 100 - 13F
	0x00, 0x00, 0x52, 0x52, 0x00, 0x37, 0x00, 0x41,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e,
	0x00, 0x52, 0x00, 0x46, 0x00, 0x4a, 0x4b, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 140 - 17F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x4f, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	// Entry 180 - 1BF
	0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x1e, 0x64, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x52, 0x00, 0x52, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52,
	// Entry 1C0 - 1FF
	0x00, 0x52, 0x00, 0x00, 0x00, 0x70, 0x52, 0x00,
	0x52, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x75, 0x00, 0x00, 0x00, 0x2f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x52,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	// Entry 200 - 23F
	0x00, 0x52, 0x00, 0x52, 0x00, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc1, 0x00, 0x52, 0x00, 0x52, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 240 - 27F
	0x52, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x52,
	0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xd0, 0x52, 0x00, 0x00, 0x00, 0xd5, 0x00, 0x00,
	0x00, 0x27, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
	0x52, 0x00, 0x52, 0x52, 0x52, 0x00, 0x52, 0x52,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00,
	// Entry 280 - 2BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x52,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 2C0 - 2FF
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00,
	0x00,
}

const (
	_001 = 1
	_419 = 30
	_BR  = 64
	_CA  = 72
	_ES  = 109
	_GB  = 121
	_MD  = 186
	_PT  = 236
	_UK  = 304
	_US  = 306
	_ZZ  = 354
	_XA  = 320
	_XC  = 322
	_XK  = 330
)

// isoRegionOffset needs to be added to the index of regionISO to obtain the regionID
// for 2-letter ISO codes. (The first isoRegionOffset regionIDs are reserved for
// the UN.M49 codes used for groups.)
const isoRegionOffset = 31

// regionTypes defines the status of a region for various standards.
// Size: 355 bytes, 355 elements
var regionTypes = [355]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 40 - 7F
	0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06,
	0x04, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 80 - BF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	// Entry C0 - FF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x06,
	0x06, 0x06, 0x00, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x06,
	0x00, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	// Entry 100 - 13F
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06,
	// Entry 140 - 17F
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06,
	0x04, 0x06, 0x05,
}

// regionISO holds a list of alphabetically sorted 2-letter ISO region codes.
// Each 2-letter codes is followed by two bytes with the following meaning:
//     - [A-Z}{2}: the first letter of the 2-letter code plus these two
//                 letters form the 3-letter ISO code.
//     - 0, n:     index into altRegionISO3.
var regionISO tag.Index = "" + // Size: 1300 bytes
	"AAAAACSCADNDAEREAFFGAGTGAIIAALLBAMRMANNTAOGOAQTAARRGASSMATUTAUUSAWBWAXLA" +
	"AZZEBAIHBBRBBDGDBEELBFFABGGRBHHRBIDIBJENBLLMBMMUBNRNBOOLBQESBRRABSHSBTTN" +
	"BUURBVVTBWWABYLRBZLZCAANCCCKCDODCFAFCGOGCHHECIIVCKOKCLHLCMMRCNHNCOOLCPPT" +
	"CRRICS\x00\x00CTTECUUBCVPVCWUWCXXRCYYPCZZEDDDRDEEUDGGADJJIDKNKDMMADOOMDY" +
	"HYDZZAEA  ECCUEESTEGGYEHSHERRIESSPETTHEU\x00\x03FIINFJJIFKLKFMSMFOROFQ" +
	"\x00\x18FRRAFXXXGAABGBBRGDRDGEEOGFUFGGGYGHHAGIIBGLRLGMMBGNINGPLPGQNQGRRC" +
	"GS\x00\x06GTTMGUUMGWNBGYUYHKKGHMMDHNNDHRRVHTTIHUUNHVVOIC  IDDNIERLILSRIM" +
	"MNINNDIOOTIQRQIRRNISSLITTAJEEYJMAMJOORJPPNJTTNKEENKGGZKHHMKIIRKM\x00\x09" +
	"KNNAKP\x00\x0cKRORKWWTKY\x00\x0fKZAZLAAOLBBNLCCALIIELKKALRBRLSSOLTTULUUX" +
	"LVVALYBYMAARMCCOMDDAMENEMFAFMGDGMHHLMIIDMKKDMLLIMMMRMNNGMOACMPNPMQTQMRRT" +
	"MSSRMTLTMUUSMVDVMWWIMXEXMYYSMZOZNAAMNCCLNEERNFFKNGGANHHBNIICNLLDNOORNPPL" +
	"NQ\x00\x1eNRRUNTTZNUIUNZZLOMMNPAANPCCIPEERPFYFPGNGPHHLPKAKPLOLPM\x00\x12" +
	"PNCNPRRIPSSEPTRTPUUSPWLWPYRYPZCZQAATQMMMQNNNQOOOQPPPQQQQQRRRQSSSQTTTQU" +
	"\x00\x03QVVVQWWWQXXXQYYYQZZZREEURHHOROOURS\x00\x15RUUSRWWASAAUSBLBSCYCSD" +
	"DNSEWESGGPSHHNSIVNSJJMSKVKSLLESMMRSNENSOOMSRURSSSDSTTPSUUNSVLVSXXMSYYRSZ" +
	"WZTAAATCCATDCDTF\x00\x18TGGOTHHATJJKTKKLTLLSTMKMTNUNTOONTPMPTRURTTTOTVUV" +
	"TWWNTZZAUAKRUGGAUK  UMMIUSSAUYRYUZZBVAATVCCTVDDRVEENVGGBVIIRVNNMVUUTWFLF" +
	"WKAKWSSMXAAAXBBBXCCCXDDDXEEEXFFFXGGGXHHHXIIIXJJJXKKKXLLLXMMMXNNNXOOOXPPP" +
	"XQQQXRRRXSSSXTTTXUUUXVVVXWWWXXXXXYYYXZZZYDMDYEEMYT\x00\x1bYUUGZAAFZMMBZR" +
	"ARZWWEZZZZ\xff\xff\xff\xff"

// altRegionISO3 holds a list of 3-letter region codes that cannot be
// mapped to 2-letter codes using the default algorithm. This is a short list.
var altRegionISO3 string = "SCGQUUSGSCOMPRKCYMSPMSRBATFMYTATN"

// altRegionIDs holds a list of regionIDs the positions of which match those
// of the 3-letter ISO codes in altRegionISO3.
// Size: 22 bytes, 11 elements
var altRegionIDs = [11]uint16{
	0x0056, 0x006f, 0x0086, 0x00a6, 0x00a8, 0x00ab, 0x00e8, 0x0103,
	0x011f, 0x015c, 0x00da,
}

// Size: 80 bytes, 20 elements
var regionOldMap = [20]fromTo{
	0:  {from: 0x43, to: 0xc2},
	1:  {from: 0x57, to: 0xa5},
	2:  {from: 0x5e, to: 0x5f},
	3:  {from: 0x65, to: 0x3a},
	4:  {from: 0x77, to: 0x76},
	5:  {from: 0x91, to: 0x36},
	6:  {from: 0xa1, to: 0x131},
	7:  {from: 0xbf, to: 0x131},
	8:  {from: 0xd5, to: 0x13c},
	9:  {from: 0xda, to: 0x2a},
	10: {from: 0xed, to: 0x131},
	11: {from: 0xf0, to: 0xe0},
	12: {from: 0xfa, to: 0x6f},
	13: {from: 0x101, to: 0x161},
	14: {from: 0x128, to: 0x124},
	15: {from: 0x130, to: 0x79},
	16: {from: 0x137, to: 0x13b},
	17: {from: 0x13e, to: 0x131},
	18: {from: 0x15a, to: 0x15b},
	19: {from: 0x160, to: 0x4a},
}

// m49 maps regionIDs to UN.M49 codes. The first isoRegionOffset entries are
// codes indicating collections of regions.
// Size: 710 bytes, 355 elements
var m49 = [355]int16{
	// Entry 0 - 3F
	0, 1, 2, 3, 5, 9, 11, 13,
	14, 15, 17, 18, 19, 21, 29, 30,
	34, 35, 39, 53, 54, 57, 61, 142,
	143, 145, 150, 151, 154, 155, 419, 958,
	0, 20, 784, 4, 28, 660, 8, 51,
	530, 24, 10, 32, 16, 40, 36, 533,
	248, 31, 70, 52, 50, 56, 854, 100,
	48, 108, 204, 652, 60, 96, 68, 535,
	// Entry 40 - 7F
	76, 44, 64, 104, 74, 72, 112, 84,
	124, 166, 180, 140, 178, 756, 384, 184,
	152, 120, 156, 170, 0, 188, 891, 296,
	192, 132, 531, 162, 196, 203, 278, 276,
	0, 262, 208, 212, 214, 204, 12, 0,
	218, 233, 818, 732, 232, 724, 231, 967,
	246, 242, 238, 583, 234, 0, 250, 249,
	266, 826, 308, 268, 254, 831, 288, 292,
	// Entry 80 - BF
	304, 270, 324, 312, 226, 300, 239, 320,
	316, 624, 328, 344, 334, 340, 191, 332,
	348, 854, 0, 360, 372, 376, 833, 356,
	86, 368, 364, 352, 380, 832, 388, 400,
	392, 581, 404, 417, 116, 296, 174, 659,
	408, 410, 414, 136, 398, 418, 422, 662,
	438, 144, 430, 426, 440, 442, 428, 434,
	504, 492, 498, 499, 663, 450, 584, 581,
	// Entry C0 - FF
	807, 466, 104, 496, 446, 580, 474, 478,
	500, 470, 480, 462, 454, 484, 458, 508,
	516, 540, 562, 574, 566, 548, 558, 528,
	578, 524, 10, 520, 536, 570, 554, 512,
	591, 0, 604, 258, 598, 608, 586, 616,
	666, 612, 630, 275, 620, 581, 585, 600,
	591, 634, 959, 960, 961, 962, 963, 964,
	965, 966, 967, 968, 969, 970, 971, 972,
	// Entry 100 - 13F
	638, 716, 642, 688, 643, 646, 682, 90,
	690, 729, 752, 702, 654, 705, 744, 703,
	694, 674, 686, 706, 740, 728, 678, 810,
	222, 534, 760, 748, 0, 796, 148, 260,
	768, 764, 762, 772, 626, 795, 788, 776,
	626, 792, 780, 798, 158, 834, 804, 800,
	826, 581, 840, 858, 860, 336, 670, 704,
	862, 92, 850, 704, 548, 876, 581, 882,
	// Entry 140 - 17F
	973, 974, 975, 976, 977, 978, 979, 980,
	981, 982, 983, 984, 985, 986, 987, 988,
	989, 990, 991, 992, 993, 994, 995, 996,
	997, 998, 720, 887, 175, 891, 710, 894,
	180, 716, 999,
}

// m49Index gives indexes into fromM49 based on the three most significant bits
// of a 10-bit UN.M49 code. To search an UN.M49 code in fromM49, search in
//    fromM49[m49Index[msb39(code)]:m49Index[msb3(code)+1]]
// for an entry where the first 7 bits match the 7 lsb of the UN.M49 code.
// The region code is stored in the 9 lsb of the indexed value.
// Size: 18 bytes, 9 elements
var m49Index = [9]int16{
	0, 59, 107, 142, 180, 219, 258, 290,
	332,
}

// fromM49 contains entries to map UN.M49 codes to regions. See m49Index for details.
// Size: 664 bytes, 332 elements
var fromM49 = [332]uint16{
	// Entry 0 - 3F
	0x0201, 0x0402, 0x0603, 0x0823, 0x0a04, 0x1026, 0x1205, 0x142a,
	0x1606, 0x1866, 0x1a07, 0x1c08, 0x1e09, 0x202c, 0x220a, 0x240b,
	0x260c, 0x2821, 0x2a0d, 0x3029, 0x3824, 0x3a0e, 0x3c0f, 0x3e31,
	0x402b, 0x4410, 0x4611, 0x482e, 0x4e12, 0x502d, 0x5841, 0x6038,
	0x6434, 0x6627, 0x6833, 0x6a13, 0x6c14, 0x7035, 0x7215, 0x783c,
	0x7a16, 0x8042, 0x883e, 0x8c32, 0x9045, 0x9444, 0x9840, 0xa847,
	0xac98, 0xb507, 0xb939, 0xc03d, 0xc837, 0xd0c2, 0xd839, 0xe046,
	0xe8a4, 0xf051, 0xf848, 0x0859, 0x10ab, 0x184b, 0x1c17, 0x1e18,
	// Entry 40 - 7F
	0x20b1, 0x2219, 0x291e, 0x2c1a, 0x2e1b, 0x3050, 0x341c, 0x361d,
	0x3852, 0x3d2c, 0x445b, 0x4c49, 0x5453, 0x5ca6, 0x5f5c, 0x644c,
	0x684a, 0x704f, 0x7855, 0x7e8e, 0x8058, 0x885c, 0x965d, 0x983a,
	0xa062, 0xa863, 0xac64, 0xb468, 0xbd18, 0xc484, 0xcc6e, 0xce6e,
	0xd06c, 0xd269, 0xd474, 0xdc72, 0xde86, 0xe471, 0xec70, 0xf030,
	0xf277, 0xf476, 0xfc7c, 0x04e3, 0x091f, 0x0c61, 0x1478, 0x187b,
	0x1c81, 0x26eb, 0x285f, 0x2c5e, 0x305f, 0x407e, 0x487f, 0x50a5,
	0x5885, 0x6080, 0x687a, 0x7083, 0x7888, 0x8087, 0x8882, 0x908a,
	// Entry 80 - BF
	0x988f, 0x9c8c, 0xa135, 0xa88d, 0xb08b, 0xb890, 0xc09b, 0xc897,
	0xd093, 0xd89a, 0xe099, 0xe894, 0xf095, 0xf89c, 0x004e, 0x089e,
	0x10a0, 0x1cac, 0x209f, 0x28a2, 0x30a8, 0x34a9, 0x3caa, 0x42a3,
	0x44ad, 0x461e, 0x4cae, 0x54b3, 0x58b6, 0x5cb2, 0x64b7, 0x6cb0,
	0x70b4, 0x74b5, 0x7cc4, 0x84bd, 0x8ccc, 0x94ce, 0x9ccb, 0xa4c1,
	0xacc9, 0xb4c6, 0xbcc7, 0xc0ca, 0xc8cd, 0xd8b9, 0xe0c3, 0xe4ba,
	0xe6bb, 0xe8c8, 0xf0b8, 0xf8cf, 0x00df, 0x08d0, 0x10db, 0x18d9,
	0x20d7, 0x2428, 0x265a, 0x2a2f, 0x2d19, 0x2e3f, 0x30dc, 0x38d1,
	// Entry C0 - FF
	0x493c, 0x54de, 0x5cd6, 0x64d2, 0x6cd4, 0x74dd, 0x7cd3, 0x84d8,
	0x88c5, 0x8b31, 0x8e73, 0x90be, 0x92ee, 0x94e6, 0x9ee0, 0xace4,
	0xb0ef, 0xb8e2, 0xc0e5, 0xc8e9, 0xd0e7, 0xd8ec, 0xe089, 0xe524,
	0xecea, 0xf4f1, 0xfd00, 0x0502, 0x0704, 0x0d05, 0x183b, 0x1d0c,
	0x26a7, 0x2825, 0x2caf, 0x2ebc, 0x34e8, 0x3d36, 0x4511, 0x4d16,
	0x5506, 0x5d12, 0x6103, 0x6508, 0x6d10, 0x7d0b, 0x7f0f, 0x813b,
	0x830d, 0x8513, 0x8d5e, 0x9961, 0xa15a, 0xa86d, 0xb115, 0xb309,
	0xb86b, 0xc109, 0xc914, 0xd10e, 0xd91b, 0xe10a, 0xe84d, 0xf11a,
	// Entry 100 - 13F
	0xf522, 0xf921, 0x0120, 0x0923, 0x1127, 0x192a, 0x2022, 0x2926,
	0x3129, 0x3725, 0x391d, 0x3d2b, 0x412f, 0x492e, 0x4ec0, 0x5517,
	0x646a, 0x7479, 0x7e7d, 0x809d, 0x8296, 0x852d, 0x9132, 0xa53a,
	0xac36, 0xb533, 0xb934, 0xbd38, 0xd93d, 0xe53f, 0xed5b, 0xef5b,
	0xf656, 0xfd5f, 0x7c1f, 0x7ef2, 0x80f3, 0x82f4, 0x84f5, 0x86f6,
	0x88f7, 0x8af8, 0x8cf9, 0x8e6f, 0x90fb, 0x92fc, 0x94fd, 0x96fe,
	0x98ff, 0x9b40, 0x9d41, 0x9f42, 0xa143, 0xa344, 0xa545, 0xa746,
	0xa947, 0xab48, 0xad49, 0xaf4a, 0xb14b, 0xb34c, 0xb54d, 0xb74e,
	// Entry 140 - 17F
	0xb94f, 0xbb50, 0xbd51, 0xbf52, 0xc153, 0xc354, 0xc555, 0xc756,
	0xc957, 0xcb58, 0xcd59, 0xcf62,
}

// Size: 1444 bytes
var variantIndex = map[string]uint8{
	"1606nict": 0x0,
	"1694acad": 0x1,
	"1901":     0x2,
	"1959acad": 0x3,
	"1994":     0x45,
	"1996":     0x4,
	"abl1943":  0x5,
	"alalc97":  0x47,
	"aluku":    0x6,
	"ao1990":   0x7,
	"arevela":  0x8,
	"arevmda":  0x9,
	"baku1926": 0xa,
	"balanka":  0xb,
	"barla":    0xc,
	"basiceng": 0xd,
	"bauddha":  0xe,
	"biscayan": 0xf,
	"biske":    0x40,
	"bohoric":  0x10,
	"boont":    0x11,
	"colb1945": 0x12,
	"cornu":    0x13,
	"dajnko":   0x14,
	"ekavsk":   0x15,
	"emodeng":  0x16,
	"fonipa":   0x48,
	"fonupa":   0x49,
	"fonxsamp": 0x4a,
	"hepburn":  0x17,
	"heploc":   0x46,
	"hognorsk": 0x18,
	"ijekavsk": 0x19,
	"itihasa":  0x1a,
	"jauer":    0x1b,
	"jyutping": 0x1c,
	"kkcor":    0x1d,
	"kociewie": 0x1e,
	"kscor":    0x1f,
	"laukika":  0x20,
	"lipaw":    0x41,
	"luna1918": 0x21,
	"metelko":  0x22,
	"monoton":  0x23,
	"ndyuka":   0x24,
	"nedis":    0x25,
	"newfound": 0x26,
	"njiva":    0x42,
	"nulik":    0x27,
	"osojs":    0x43,
	"oxendict": 0x28,
	"pamaka":   0x29,
	"petr1708": 0x2a,
	"pinyin":   0x2b,
	"polyton":  0x2c,
	"puter":    0x2d,
	"rigik":    0x2e,
	"rozaj":    0x2f,
	"rumgr":    0x30,
	"scotland": 0x31,
	"scouse":   0x32,
	"simple":   0x4b,
	"solba":    0x44,
	"sotav":    0x33,
	"surmiran": 0x34,
	"sursilv":  0x35,
	"sutsilv":  0x36,
	"tarask":   0x37,
	"uccor":    0x38,
	"ucrcor":   0x39,
	"ulster":   0x3a,
	"unifon":   0x3b,
	"vaidika":  0x3c,
	"valencia": 0x3d,
	"vallader": 0x3e,
	"wadegile": 0x3f,
}

// variantNumSpecialized is the number of specialized variants in variants.
const variantNumSpecialized = 71

// nRegionGroups is the number of region groups.
const nRegionGroups = 32

type likelyLangRegion struct {
	lang   uint16
	region uint16
}

// likelyScript is a lookup table, indexed by scriptID, for the most likely
// languages and regions given a script.
// Size: 928 bytes, 232 elements
var likelyScript = [232]likelyLangRegion{
	1:   {lang: 0xa6, region: 0x82},
	3:   {lang: 0x159, region: 0x104},
	4:   {lang: 0xc, region: 0x97},
	5:   {lang: 0x15, region: 0x6a},
	7:   {lang: 0x16, region: 0x9a},
	8:   {lang: 0xf3, region: 0x27},
	9:   {lang: 0x8, region: 0x9a},
	10:  {lang: 0x27, region: 0x93},
	11:  {lang: 0x2b, region: 0x51},
	12:  {lang: 0x55, region: 0xb2},
	13:  {lang: 0x2c, region: 0x93},
	14:  {lang: 0x4b, region: 0x34},
	15:  {lang: 0x20d, region: 0x97},
	17:  {lang: 0x2c4, region: 0x12c},
	18:  {lang: 0x1e5, region: 0x97},
	19:  {lang: 0xaf, region: 0x76},
	20:  {lang: 0x5b, region: 0x93},
	21:  {lang: 0x47, region: 0xe5},
	22:  {lang: 0x63, region: 0x34},
	23:  {lang: 0x73, region: 0x48},
	24:  {lang: 0x2a8, region: 0x129},
	25:  {lang: 0x6e, region: 0x13b},
	26:  {lang: 0x6c, region: 0x132},
	28:  {lang: 0x71, region: 0x6a},
	29:  {lang: 0xd0, region: 0x5c},
	30:  {lang: 0x207, region: 0x104},
	32:  {lang: 0xe1, region: 0x97},
	34:  {lang: 0xaf, region: 0x76},
	37:  {lang: 0x98, region: 0x6a},
	38:  {lang: 0x23a, region: 0x26},
	39:  {lang: 0x11, region: 0x6e},
	41:  {lang: 0x111, region: 0x7b},
	42:  {lang: 0x7d, region: 0x37},
	43:  {lang: 0xcf, region: 0x12e},
	44:  {lang: 0x20d, region: 0x97},
	45:  {lang: 0x9a, region: 0x85},
	46:  {lang: 0xd3, region: 0x97},
	47:  {lang: 0x1d7, region: 0x97},
	48:  {lang: 0x2c4, region: 0x12c},
	49:  {lang: 0x136, region: 0xa9},
	50:  {lang: 0x2c4, region: 0x52},
	51:  {lang: 0xe9, region: 0xe5},
	52:  {lang: 0x2c4, region: 0x52},
	53:  {lang: 0x2c4, region: 0x12c},
	54:  {lang: 0x18b, region: 0x99},
	55:  {lang: 0xe0, region: 0x95},
	56:  {lang: 0x107, region: 0xa0},
	57:  {lang: 0xe4, region: 0x129},
	58:  {lang: 0xe8, region: 0xad},
	60:  {lang: 0xf2, region: 0x90},
	62:  {lang: 0xa0, region: 0x9c},
	63:  {lang: 0x136, region: 0xa9},
	64:  {lang: 0x10f, region: 0x93},
	65:  {lang: 0x107, region: 0xa0},
	67:  {lang: 0x99, region: 0xc2},
	68:  {lang: 0x107, region: 0xa0},
	69:  {lang: 0x1eb, region: 0xe6},
	70:  {lang: 0x133, region: 0xa4},
	71:  {lang: 0x21a, region: 0x97},
	74:  {lang: 0x135, region: 0x97},
	75:  {lang: 0x136, region: 0xa9},
	77:  {lang: 0x40, region: 0x97},
	78:  {lang: 0x1c2, region: 0x121},
	79:  {lang: 0x165, region: 0xad},
	84:  {lang: 0x158, region: 0x97},
	85:  {lang: 0x15c, region: 0x97},
	86:  {lang: 0x14f, region: 0x85},
	87:  {lang: 0xd0, region: 0x85},
	88:  {lang: 0x15e, region: 0x52},
	90:  {lang: 0x2aa, region: 0x129},
	91:  {lang: 0x2ab, region: 0x129},
	92:  {lang: 0xe1, region: 0x97},
	93:  {lang: 0x1a8, region: 0x9a},
	94:  {lang: 0x2ad, region: 0x52},
	95:  {lang: 0x4c, region: 0x52},
	97:  {lang: 0x17f, region: 0x110},
	98:  {lang: 0x2ae, region: 0x109},
	99:  {lang: 0x2ae, region: 0x109},
	100: {lang: 0x18d, region: 0x97},
	101: {lang: 0x196, region: 0x97},
	102: {lang: 0x18f, region: 0x52},
	104: {lang: 0x199, region: 0x34},
	105: {lang: 0x190, region: 0x97},
	106: {lang: 0x22b, region: 0xe6},
	107: {lang: 0x1a5, region: 0xc2},
	108: {lang: 0x2af, region: 0x106},
	109: {lang: 0x16, region: 0x9f},
	110: {lang: 0x1b5, region: 0xd9},
	112: {lang: 0x179, region: 0x82},
	114: {lang: 0x223, region: 0x94},
	115: {lang: 0x212, region: 0x97},
	116: {lang: 0x1d6, region: 0xc3},
	117: {lang: 0x1d3, region: 0x97},
	118: {lang: 0x1d5, region: 0x132},
	119: {lang: 0x238, region: 0x113},
	120: {lang: 0x16, region: 0x11a},
	121: {lang: 0x7c, region: 0xc2},
	122: {lang: 0x147, region: 0x104},
	123: {lang: 0x172, region: 0x52},
	124: {lang: 0x1d9, region: 0x9a},
	125: {lang: 0x1d9, region: 0x52},
	127: {lang: 0x1e3, region: 0xae},
	129: {lang: 0xe5, region: 0x52},
	130: {lang: 0x2b2, region: 0x9a},
	181: {lang: 0x1f6, region: 0x93},
	183: {lang: 0x1c4, region: 0x10a},
	184: {lang: 0x234, region: 0x95},
	186: {lang: 0x2b3, region: 0x15b},
	187: {lang: 0x213, region: 0x97},
	188: {lang: 0x1e, region: 0x132},
	189: {lang: 0x9b, region: 0x79},
	190: {lang: 0x20d, region: 0x97},
	191: {lang: 0x20d, region: 0x97},
	192: {lang: 0x21a, region: 0x97},
	193: {lang: 0x228, region: 0xb1},
	194: {lang: 0x23c, region: 0x97},
	195: {lang: 0x244, region: 0x93},
	196: {lang: 0x24e, region: 0x34},
	197: {lang: 0x24f, region: 0x99},
	201: {lang: 0x253, region: 0xe5},
	202: {lang: 0x8a, region: 0x97},
	203: {lang: 0x255, region: 0x52},
	204: {lang: 0x126, region: 0x52},
	205: {lang: 0x251, region: 0x97},
	206: {lang: 0x27f, region: 0x52},
	207: {lang: 0x48, region: 0x13b},
	208: {lang: 0x258, region: 0x97},
	210: {lang: 0x2c3, region: 0xb8},
	211: {lang: 0xaa, region: 0xe5},
	212: {lang: 0x90, region: 0xcb},
	213: {lang: 0x25d, region: 0x121},
	214: {lang: 0x4c, region: 0x52},
	215: {lang: 0x177, region: 0x97},
	216: {lang: 0x285, region: 0x11a},
	217: {lang: 0x28e, region: 0xb2},
	219: {lang: 0xec, region: 0x97},
	221: {lang: 0x1e1, region: 0x9a},
	222: {lang: 0xe, region: 0x99},
	223: {lang: 0xfb, region: 0x52},
}

type likelyScriptRegion struct {
	region uint16
	script uint8
	flags  uint8
}

// likelyLang is a lookup table, indexed by langID, for the most likely
// scripts and regions given incomplete information. If more entries exist for a
// given language, region and script are the index and size respectively
// of the list in likelyLangList.
// Size: 2852 bytes, 713 elements
var likelyLang = [713]likelyScriptRegion{
	0:   {region: 0x132, script: 0x52, flags: 0x0},
	1:   {region: 0x6e, script: 0x52, flags: 0x0},
	2:   {region: 0x7b, script: 0x1e, flags: 0x0},
	3:   {region: 0x7e, script: 0x52, flags: 0x0},
	4:   {region: 0x93, script: 0x52, flags: 0x0},
	5:   {region: 0x12f, script: 0x52, flags: 0x0},
	6:   {region: 0x7e, script: 0x52, flags: 0x0},
	7:   {region: 0x104, script: 0x1e, flags: 0x0},
	8:   {region: 0x9a, script: 0x9, flags: 0x0},
	9:   {region: 0x126, script: 0x5, flags: 0x0},
	10:  {region: 0x15e, script: 0x52, flags: 0x0},
	11:  {region: 0x51, script: 0x52, flags: 0x0},
	12:  {region: 0x97, script: 0x4, flags: 0x0},
	13:  {region: 0x7e, script: 0x52, flags: 0x0},
	14:  {region: 0x99, script: 0xde, flags: 0x0},
	15:  {region: 0x14a, script: 0x52, flags: 0x0},
	16:  {region: 0x104, script: 0x1e, flags: 0x0},
	17:  {region: 0x6e, script: 0x27, flags: 0x0},
	18:  {region: 0xd4, script: 0x52, flags: 0x0},
	20:  {region: 0x93, script: 0x52, flags: 0x0},
	21:  {region: 0x6a, script: 0x5, flags: 0x0},
	22:  {region: 0x0, script: 0x3, flags: 0x1},
	23:  {region: 0x50, script: 0x52, flags: 0x0},
	24:  {region: 0x3e, script: 0x52, flags: 0x0},
	25:  {region: 0x66, script: 0x5, flags: 0x0},
	26:  {region: 0xb8, script: 0x5, flags: 0x0},
	27:  {region: 0x6a, script: 0x5, flags: 0x0},
	28:  {region: 0x97, script: 0xe, flags: 0x0},
	29:  {region: 0x12d, script: 0x52, flags: 0x0},
	30:  {region: 0x132, script: 0xbc, flags: 0x0},
	31:  {region: 0x6d, script: 0x52, flags: 0x0},
	32:  {region: 0x48, script: 0x52, flags: 0x0},
	33:  {region: 0x104, script: 0x1e, flags: 0x0},
	34:  {region: 0x97, script: 0x20, flags: 0x0},
	35:  {region: 0x3e, script: 0x52, flags: 0x0},
	36:  {region: 0x3, script: 0x5, flags: 0x1},
	37:  {region: 0x104, script: 0x1e, flags: 0x0},
	38:  {region: 0xe6, script: 0x5, flags: 0x0},
	39:  {region: 0x93, script: 0x52, flags: 0x0},
	40:  {region: 0xd9, script: 0x20, flags: 0x0},
	41:  {region: 0x2d, script: 0x52, flags: 0x0},
	42:  {region: 0x51, script: 0x52, flags: 0x0},
	43:  {region: 0x51, script: 0xb, flags: 0x0},
	44:  {region: 0x93, script: 0x52, flags: 0x0},
	45:  {region: 0x51, script: 0x52, flags: 0x0},
	46:  {region: 0x4e, script: 0x52, flags: 0x0},
	47:  {region: 0x46, script: 0x1e, flags: 0x0},
	48:  {region: 0x109, script: 0x5, flags: 0x0},
	49:  {region: 0x15f, script: 0x52, flags: 0x0},
	50:  {region: 0x93, script: 0x52, flags: 0x0},
	51:  {region: 0x12d, script: 0x52, flags: 0x0},
	52:  {region: 0x51, script: 0x52, flags: 0x0},
	53:  {region: 0x97, script: 0xcd, flags: 0x0},
	54:  {region: 0xe6, script: 0x5, flags: 0x0},
	55:  {region: 0x97, script: 0x20, flags: 0x0},
	56:  {region: 0x37, script: 0x1e, flags: 0x0},
	57:  {region: 0x97, script: 0x20, flags: 0x0},
	58:  {region: 0xe6, script: 0x5, flags: 0x0},
	59:  {region: 0x129, script: 0x2d, flags: 0x0},
	61:  {region: 0x97, script: 0x20, flags: 0x0},
	62:  {region: 0x97, script: 0x20, flags: 0x0},
	63:  {region: 0xe5, script: 0x52, flags: 0x0},
	64:  {region: 0x97, script: 0x20, flags: 0x0},
	65:  {region: 0x13c, script: 0x52, flags: 0x0},
	66:  {region: 0xe5, script: 0x52, flags: 0x0},
	67:  {region: 0xd4, script: 0x52, flags: 0x0},
	68:  {region: 0x97, script: 0x20, flags: 0x0},
	69:  {region: 0x93, script: 0x52, flags: 0x0},
	70:  {region: 0x51, script: 0x52, flags: 0x0},
	71:  {region: 0xe5, script: 0x52, flags: 0x0},
	72:  {region: 0x13b, script: 0xcf, flags: 0x0},
	73:  {region: 0xc1, script: 0x52, flags: 0x0},
	74:  {region: 0xc1, script: 0x52, flags: 0x0},
	75:  {region: 0x34, script: 0xe, flags: 0x0},
	76:  {region: 0x52, script: 0xd6, flags: 0x0},
	77:  {region: 0x97, script: 0xe, flags: 0x0},
	78:  {region: 0x9a, script: 0x5, flags: 0x0},
	79:  {region: 0x4e, script: 0x52, flags: 0x0},
	80:  {region: 0x76, script: 0x52, flags: 0x0},
	81:  {region: 0x97, script: 0x20, flags: 0x0},
	82:  {region: 0xe6, script: 0x5, flags: 0x0},
	83:  {region: 0x97, script: 0x20, flags: 0x0},
	84:  {region: 0x32, script: 0x52, flags: 0x0},
	85:  {region: 0xb2, script: 0xc, flags: 0x0},
	86:  {region: 0x51, script: 0x52, flags: 0x0},
	87:  {region: 0xe5, script: 0x52, flags: 0x0},
	88:  {region: 0xe6, script: 0x20, flags: 0x0},
	89:  {region: 0x104, script: 0x1e, flags: 0x0},
	90:  {region: 0x15c, script: 0x52, flags: 0x0},
	91:  {region: 0x93, script: 0x52, flags: 0x0},
	92:  {region: 0x51, script: 0x52, flags: 0x0},
	93:  {region: 0x84, script: 0x52, flags: 0x0},
	94:  {region: 0x6c, script: 0x27, flags: 0x0},
	95:  {region: 0x51, script: 0x52, flags: 0x0},
	96:  {region: 0xc1, script: 0x52, flags: 0x0},
	97:  {region: 0x6d, script: 0x52, flags: 0x0},
	98:  {region: 0xd4, script: 0x52, flags: 0x0},
	99:  {region: 0x8, script: 0x2, flags: 0x1},
	100: {region: 0x104, script: 0x1e, flags: 0x0},
	101: {region: 0xe5, script: 0x52, flags: 0x0},
	102: {region: 0x12f, script: 0x52, flags: 0x0},
	103: {region: 0x88, script: 0x52, flags: 0x0},
	104: {region: 0x73, script: 0x52, flags: 0x0},
	105: {region: 0x104, script: 0x1e, flags: 0x0},
	106: {region: 0x132, script: 0x52, flags: 0x0},
	107: {region: 0x48, script: 0x52, flags: 0x0},
	108: {region: 0x132, script: 0x1a, flags: 0x0},
	109: {region: 0xa4, script: 0x5, flags: 0x0},
	110: {region: 0x13b, script: 0x19, flags: 0x0},
	111: {region: 0x99, script: 0x5, flags: 0x0},
	112: {region: 0x76, script: 0x52, flags: 0x0},
	113: {region: 0x6a, script: 0x1c, flags: 0x0},
	114: {region: 0xe5, script: 0x52, flags: 0x0},
	115: {region: 0x48, script: 0x17, flags: 0x0},
	116: {region: 0x48, script: 0x17, flags: 0x0},
	117: {region: 0x48, script: 0x17, flags: 0x0},
	118: {region: 0x48, script: 0x17, flags: 0x0},
	119: {region: 0x48, script: 0x17, flags: 0x0},
	120: {region: 0x108, script: 0x52, flags: 0x0},
	121: {region: 0x5d, script: 0x52, flags: 0x0},
	122: {region: 0xe7, script: 0x52, flags: 0x0},
	123: {region: 0x48, script: 0x17, flags: 0x0},
	124: {region: 0xc2, script: 0x79, flags: 0x0},
	125: {region: 0xa, script: 0x2, flags: 0x1},
	126: {region: 0x104, script: 0x1e, flags: 0x0},
	127: {region: 0x79, script: 0x52, flags: 0x0},
	128: {region: 0x62, script: 0x52, flags: 0x0},
	129: {region: 0x132, script: 0x52, flags: 0x0},
	130: {region: 0x104, script: 0x1e, flags: 0x0},
	131: {region: 0xa2, script: 0x52, flags: 0x0},
	132: {region: 0x97, script: 0x5, flags: 0x0},
	133: {region: 0x5f, script: 0x52, flags: 0x0},
	134: {region: 0x48, script: 0x52, flags: 0x0},
	135: {region: 0x48, script: 0x52, flags: 0x0},
	136: {region: 0xd2, script: 0x52, flags: 0x0},
	137: {region: 0x4e, script: 0x52, flags: 0x0},
	138: {region: 0x97, script: 0x5, flags: 0x0},
	139: {region: 0x5f, script: 0x52, flags: 0x0},
	140: {region: 0xc1, script: 0x52, flags: 0x0},
	141: {region: 0xce, script: 0x52, flags: 0x0},
	142: {region: 0xd9, script: 0x20, flags: 0x0},
	143: {region: 0x51, script: 0x52, flags: 0x0},
	144: {region: 0xcb, script: 0xd4, flags: 0x0},
	145: {region: 0x112, script: 0x52, flags: 0x0},
	146: {region: 0x36, script: 0x52, flags: 0x0},
	147: {region: 0x42, script: 0xd6, flags: 0x0},
	148: {region: 0xa2, script: 0x52, flags: 0x0},
	149: {region: 0x7e, script: 0x52, flags: 0x0},
	150: {region: 0xd4, script: 0x52, flags: 0x0},
	151: {region: 0x9c, script: 0x52, flags: 0x0},
	152: {region: 0x6a, script: 0x25, flags: 0x0},
	153: {region: 0xc2, script: 0x43, flags: 0x0},
	154: {region: 0x85, script: 0x2d, flags: 0x0},
	155: {region: 0xc, script: 0x2, flags: 0x1},
	156: {region: 0x1, script: 0x52, flags: 0x0},
	157: {region: 0x6d, script: 0x52, flags: 0x0},
	158: {region: 0x132, script: 0x52, flags: 0x0},
	159: {region: 0x69, script: 0x52, flags: 0x0},
	160: {region: 0x9c, script: 0x3e, flags: 0x0},
	161: {region: 0x6d, script: 0x52, flags: 0x0},
	162: {region: 0x51, script: 0x52, flags: 0x0},
	163: {region: 0x6d, script: 0x52, flags: 0x0},
	164: {region: 0x9a, script: 0x5, flags: 0x0},
	165: {region: 0x84, script: 0x52, flags: 0x0},
	166: {region: 0xe, script: 0x2, flags: 0x1},
	167: {region: 0xc1, script: 0x52, flags: 0x0},
	168: {region: 0x70, script: 0x52, flags: 0x0},
	169: {region: 0x109, script: 0x5, flags: 0x0},
	170: {region: 0xe5, script: 0x52, flags: 0x0},
	171: {region: 0x10a, script: 0x52, flags: 0x0},
	172: {region: 0x71, script: 0x52, flags: 0x0},
	173: {region: 0x74, script: 0x52, flags: 0x0},
	174: {region: 0x3a, script: 0x52, flags: 0x0},
	175: {region: 0x76, script: 0x52, flags: 0x0},
	176: {region: 0x132, script: 0x52, flags: 0x0},
	177: {region: 0x76, script: 0x52, flags: 0x0},
	178: {region: 0x5f, script: 0x52, flags: 0x0},
	179: {region: 0x5f, script: 0x52, flags: 0x0},
	180: {region: 0x13d, script: 0x52, flags: 0x0},
	181: {region: 0xd2, script: 0x52, flags: 0x0},
	182: {region: 0x9c, script: 0x52, flags: 0x0},
	183: {region: 0xd4, script: 0x52, flags: 0x0},
	184: {region: 0x109, script: 0x52, flags: 0x0},
	185: {region: 0xd7, script: 0x52, flags: 0x0},
	186: {region: 0x94, script: 0x52, flags: 0x0},
	187: {region: 0x7e, script: 0x52, flags: 0x0},
	188: {region: 0xba, script: 0x52, flags: 0x0},
	189: {region: 0x52, script: 0x34, flags: 0x0},
	190: {region: 0x93, script: 0x52, flags: 0x0},
	191: {region: 0x97, script: 0x20, flags: 0x0},
	192: {region: 0x9a, script: 0x5, flags: 0x0},
	193: {region: 0x7c, script: 0x52, flags: 0x0},
	194: {region: 0x79, script: 0x52, flags: 0x0},
	195: {region: 0x6e, script: 0x27, flags: 0x0},
	196: {region: 0xd9, script: 0x20, flags: 0x0},
	197: {region: 0xa5, script: 0x52, flags: 0x0},
	198: {region: 0xe6, script: 0x5, flags: 0x0},
	199: {region: 0xe6, script: 0x5, flags: 0x0},
	200: {region: 0x6d, script: 0x52, flags: 0x0},
	201: {region: 0x9a, script: 0x5, flags: 0x0},
	202: {region: 0xef, script: 0x52, flags: 0x0},
	203: {region: 0x97, script: 0x20, flags: 0x0},
	204: {region: 0x97, script: 0xd0, flags: 0x0},
	205: {region: 0x93, script: 0x52, flags: 0x0},
	206: {region: 0xd7, script: 0x52, flags: 0x0},
	207: {region: 0x12e, script: 0x2b, flags: 0x0},
	208: {region: 0x10, script: 0x2, flags: 0x1},
	209: {region: 0x97, script: 0xe, flags: 0x0},
	210: {region: 0x4d, script: 0x52, flags: 0x0},
	211: {region: 0x97, script: 0x2e, flags: 0x0},
	212: {region: 0x40, script: 0x52, flags: 0x0},
	213: {region: 0x53, script: 0x52, flags: 0x0},
	214: {region: 0x7e, script: 0x52, flags: 0x0},
	216: {region: 0xa2, script: 0x52, flags: 0x0},
	217: {region: 0x96, script: 0x52, flags: 0x0},
	218: {region: 0xd9, script: 0x20, flags: 0x0},
	219: {region: 0x48, script: 0x52, flags: 0x0},
	220: {region: 0x12, script: 0x3, flags: 0x1},
	221: {region: 0x52, script: 0x34, flags: 0x0},
	222: {region: 0x132, script: 0x52, flags: 0x0},
	223: {region: 0x23, script: 0x5, flags: 0x0},
	224: {region: 0x95, script: 0x37, flags: 0x0},
	225: {region: 0x97, script: 0x20, flags: 0x0},
	226: {region: 0x71, script: 0x52, flags: 0x0},
	227: {region: 0xe5, script: 0x52, flags: 0x0},
	228: {region: 0x129, script: 0x39, flags: 0x0},
	229: {region: 0x52, script: 0x81, flags: 0x0},
	230: {region: 0xe6, script: 0x5, flags: 0x0},
	231: {region: 0x97, script: 0x20, flags: 0x0},
	232: {region: 0xad, script: 0x3a, flags: 0x0},
	233: {region: 0xe5, script: 0x52, flags: 0x0},
	234: {region: 0xe6, script: 0x5, flags: 0x0},
	235: {region: 0xe4, script: 0x52, flags: 0x0},
	236: {region: 0x97, script: 0x20, flags: 0x0},
	237: {region: 0x97, script: 0x20, flags: 0x0},
	238: {region: 0x8e, script: 0x52, flags: 0x0},
	239: {region: 0x5f, script: 0x52, flags: 0x0},
	240: {region: 0x52, script: 0x34, flags: 0x0},
	241: {region: 0x8f, script: 0x52, flags: 0x0},
	242: {region: 0x90, script: 0x52, flags: 0x0},
	243: {region: 0x27, script: 0x8, flags: 0x0},
	244: {region: 0xd0, script: 0x52, flags: 0x0},
	245: {region: 0x76, script: 0x52, flags: 0x0},
	246: {region: 0xce, script: 0x52, flags: 0x0},
	247: {region: 0xd4, script: 0x52, flags: 0x0},
	248: {region: 0x93, script: 0x52, flags: 0x0},
	250: {region: 0xd4, script: 0x52, flags: 0x0},
	251: {region: 0x52, script: 0xdf, flags: 0x0},
	252: {region: 0x132, script: 0x52, flags: 0x0},
	253: {region: 0x48, script: 0x52, flags: 0x0},
	254: {region: 0xe5, script: 0x52, flags: 0x0},
	255: {region: 0x93, script: 0x52, flags: 0x0},
	256: {region: 0x104, script: 0x1e, flags: 0x0},
	258: {region: 0x9b, script: 0x52, flags: 0x0},
	259: {region: 0x9c, script: 0x52, flags: 0x0},
	260: {region: 0x48, script: 0x17, flags: 0x0},
	261: {region: 0x95, script: 0x37, flags: 0x0},
	262: {region: 0x104, script: 0x52, flags: 0x0},
	263: {region: 0xa0, script: 0x41, flags: 0x0},
	264: {region: 0x9e, script: 0x52, flags: 0x0},
	266: {region: 0x51, script: 0x52, flags: 0x0},
	267: {region: 0x12e, script: 0x37, flags: 0x0},
	268: {region: 0x12d, script: 0x52, flags: 0x0},
	269: {region: 0xd9, script: 0x20, flags: 0x0},
	270: {region: 0x62, script: 0x52, flags: 0x0},
	271: {region: 0x93, script: 0x52, flags: 0x0},
	272: {region: 0x93, script: 0x52, flags: 0x0},
	273: {region: 0x7b, script: 0x29, flags: 0x0},
	274: {region: 0x134, script: 0x1e, flags: 0x0},
	275: {region: 0x66, script: 0x52, flags: 0x0},
	276: {region: 0xc2, script: 0x52, flags: 0x0},
	277: {region: 0xd4, script: 0x52, flags: 0x0},
	278: {region: 0xa2, script: 0x52, flags: 0x0},
	279: {region: 0xc1, script: 0x52, flags: 0x0},
	280: {region: 0x104, script: 0x1e, flags: 0x0},
	281: {region: 0xd4, script: 0x52, flags: 0x0},
	282: {region: 0x161, script: 0x52, flags: 0x0},
	283: {region: 0x12d, script: 0x52, flags: 0x0},
	284: {region: 0x121, script: 0xd5, flags: 0x0},
	285: {region: 0x59, script: 0x52, flags: 0x0},
	286: {region: 0x51, script: 0x52, flags: 0x0},
	287: {region: 0x4e, script: 0x52, flags: 0x0},
	288: {region: 0x97, script: 0x20, flags: 0x0},
	289: {region: 0x97, script: 0x20, flags: 0x0},
	290: {region: 0x4a, script: 0x52, flags: 0x0},
	291: {region: 0x93, script: 0x52, flags: 0x0},
	292: {region: 0x40, script: 0x52, flags: 0x0},
	293: {region: 0x97, script: 0x52, flags: 0x0},
	294: {region: 0x52, script: 0xcc, flags: 0x0},
	295: {region: 0x97, script: 0x20, flags: 0x0},
	296: {region: 0xc1, script: 0x52, flags: 0x0},
	297: {region: 0x97, script: 0x6b, flags: 0x0},
	298: {region: 0xe6, script: 0x5, flags: 0x0},
	299: {region: 0xa2, script: 0x52, flags: 0x0},
	300: {region: 0x129, script: 0x52, flags: 0x0},
	301: {region: 0xd0, script: 0x52, flags: 0x0},
	302: {region: 0xad, script: 0x4f, flags: 0x0},
	303: {region: 0x15, script: 0x6, flags: 0x1},
	304: {region: 0x51, script: 0x52, flags: 0x0},
	305: {region: 0x80, script: 0x52, flags: 0x0},
	306: {region: 0xa2, script: 0x52, flags: 0x0},
	307: {region: 0xa4, script: 0x46, flags: 0x0},
	308: {region: 0x29, script: 0x52, flags: 0x0},
	309: {region: 0x97, script: 0x4a, flags: 0x0},
	310: {region: 0xa9, script: 0x4b, flags: 0x0},
	311: {region: 0x104, script: 0x1e, flags: 0x0},
	312: {region: 0x97, script: 0x20, flags: 0x0},
	313: {region: 0x73, script: 0x52, flags: 0x0},
	314: {region: 0xb2, script: 0x52, flags: 0x0},
	316: {region: 0x104, script: 0x1e, flags: 0x0},
	317: {region: 0x110, script: 0x52, flags: 0x0},
	318: {region: 0xe5, script: 0x52, flags: 0x0},
	319: {region: 0x104, script: 0x52, flags: 0x0},
	320: {region: 0x97, script: 0x20, flags: 0x0},
	321: {region: 0x97, script: 0x5, flags: 0x0},
	322: {region: 0x12d, script: 0x52, flags: 0x0},
	323: {region: 0x51, script: 0x52, flags: 0x0},
	324: {region: 0x5f, script: 0x52, flags: 0x0},
	325: {region: 0x1b, script: 0x3, flags: 0x1},
	326: {region: 0x104, script: 0x1e, flags: 0x0},
	327: {region: 0x104, script: 0x1e, flags: 0x0},
	328: {region: 0x93, script: 0x52, flags: 0x0},
	329: {region: 0xe6, script: 0x5, flags: 0x0},
	330: {region: 0x79, script: 0x52, flags: 0x0},
	331: {region: 0x121, script: 0xd5, flags: 0x0},
	332: {region: 0xe6, script: 0x5, flags: 0x0},
	333: {region: 0x1e, script: 0x5, flags: 0x1},
	334: {region: 0x135, script: 0x52, flags: 0x0},
	335: {region: 0x85, script: 0x56, flags: 0x0},
	336: {region: 0x95, script: 0x37, flags: 0x0},
	337: {region: 0x12d, script: 0x52, flags: 0x0},
	338: {region: 0xe6, script: 0x5, flags: 0x0},
	339: {region: 0x12f, script: 0x52, flags: 0x0},
	340: {region: 0xb5, script: 0x52, flags: 0x0},
	341: {region: 0x104, script: 0x1e, flags: 0x0},
	342: {region: 0x93, script: 0x52, flags: 0x0},
	343: {region: 0x52, script: 0xd5, flags: 0x0},
	344: {region: 0x97, script: 0x54, flags: 0x0},
	345: {region: 0x104, script: 0x1e, flags: 0x0},
	346: {region: 0x12f, script: 0x52, flags: 0x0},
	347: {region: 0xd7, script: 0x52, flags: 0x0},
	348: {region: 0x23, script: 0x2, flags: 0x1},
	349: {region: 0x9c, script: 0x52, flags: 0x0},
	350: {region: 0x52, script: 0x58, flags: 0x0},
	351: {region: 0x93, script: 0x52, flags: 0x0},
	352: {region: 0x9a, script: 0x5, flags: 0x0},
	353: {region: 0x132, script: 0x52, flags: 0x0},
	354: {region: 0x97, script: 0xd0, flags: 0x0},
	355: {region: 0x9c, script: 0x52, flags: 0x0},
	356: {region: 0x4a, script: 0x52, flags: 0x0},
	357: {region: 0xad, script: 0x4f, flags: 0x0},
	358: {region: 0x4a, script: 0x52, flags: 0x0},
	359: {region: 0x15f, script: 0x52, flags: 0x0},
	360: {region: 0x9a, script: 0x5, flags: 0x0},
	361: {region: 0xb4, script: 0x52, flags: 0x0},
	362: {region: 0xb6, script: 0x52, flags: 0x0},
	363: {region: 0x4a, script: 0x52, flags: 0x0},
	364: {region: 0x4a, script: 0x52, flags: 0x0},
	365: {region: 0xa2, script: 0x52, flags: 0x0},
	366: {region: 0xa2, script: 0x52, flags: 0x0},
	367: {region: 0x9a, script: 0x5, flags: 0x0},
	368: {region: 0xb6, script: 0x52, flags: 0x0},
	369: {region: 0x121, script: 0xd5, flags: 0x0},
	370: {region: 0x52, script: 0x34, flags: 0x0},
	371: {region: 0x129, script: 0x52, flags: 0x0},
	372: {region: 0x93, script: 0x52, flags: 0x0},
	373: {region: 0x51, script: 0x52, flags: 0x0},
	374: {region: 0x97, script: 0x20, flags: 0x0},
	375: {region: 0x97, script: 0x20, flags: 0x0},
	376: {region: 0x93, script: 0x52, flags: 0x0},
	377: {region: 0x25, script: 0x3, flags: 0x1},
	378: {region: 0xa2, script: 0x52, flags: 0x0},
	379: {region: 0xcd, script: 0x52, flags: 0x0},
	380: {region: 0x104, script: 0x1e, flags: 0x0},
	381: {region: 0xe5, script: 0x52, flags: 0x0},
	382: {region: 0x93, script: 0x52, flags: 0x0},
	383: {region: 0x110, script: 0x52, flags: 0x0},
	384: {region: 0xa2, script: 0x52, flags: 0x0},
	385: {region: 0x121, script: 0x5, flags: 0x0},
	386: {region: 0xca, script: 0x52, flags: 0x0},
	387: {region: 0xbd, script: 0x52, flags: 0x0},
	388: {region: 0xcf, script: 0x52, flags: 0x0},
	389: {region: 0x51, script: 0x52, flags: 0x0},
	390: {region: 0xd9, script: 0x20, flags: 0x0},
	391: {region: 0x12d, script: 0x52, flags: 0x0},
	392: {region: 0xbe, script: 0x52, flags: 0x0},
	393: {region: 0xde, script: 0x52, flags: 0x0},
	394: {region: 0x93, script: 0x52, flags: 0x0},
	395: {region: 0x99, script: 0x36, flags: 0x0},
	396: {region: 0xc0, script: 0x1e, flags: 0x0},
	397: {region: 0x97, script: 0x64, flags: 0x0},
	398: {region: 0x109, script: 0x52, flags: 0x0},
	399: {region: 0x28, script: 0x3, flags: 0x1},
	400: {region: 0x97, script: 0xe, flags: 0x0},
	401: {region: 0xc2, script: 0x6b, flags: 0x0},
	403: {region: 0x48, script: 0x52, flags: 0x0},
	404: {region: 0x48, script: 0x52, flags: 0x0},
	405: {region: 0x36, script: 0x52, flags: 0x0},
	406: {region: 0x97, script: 0x20, flags: 0x0},
	407: {region: 0xd9, script: 0x20, flags: 0x0},
	408: {region: 0x104, script: 0x1e, flags: 0x0},
	409: {region: 0x34, script: 0x68, flags: 0x0},
	410: {region: 0x2b, script: 0x3, flags: 0x1},
	411: {region: 0xc9, script: 0x52, flags: 0x0},
	412: {region: 0x97, script: 0x20, flags: 0x0},
	413: {region: 0x51, script: 0x52, flags: 0x0},
	415: {region: 0x132, script: 0x52, flags: 0x0},
	416: {region: 0xe6, script: 0x5, flags: 0x0},
	417: {region: 0xc1, script: 0x52, flags: 0x0},
	418: {region: 0x97, script: 0x20, flags: 0x0},
	419: {region: 0x93, script: 0x52, flags: 0x0},
	420: {region: 0x161, script: 0x52, flags: 0x0},
	421: {region: 0xc2, script: 0x6b, flags: 0x0},
	422: {region: 0x104, script: 0x1e, flags: 0x0},
	423: {region: 0x12f, script: 0x52, flags: 0x0},
	424: {region: 0x9a, script: 0x5d, flags: 0x0},
	425: {region: 0x9a, script: 0x5, flags: 0x0},
	426: {region: 0xdb, script: 0x52, flags: 0x0},
	428: {region: 0x52, script: 0x34, flags: 0x0},
	429: {region: 0x9c, script: 0x52, flags: 0x0},
	430: {region: 0xd0, script: 0x52, flags: 0x0},
	431: {region: 0xd8, script: 0x52, flags: 0x0},
	432: {region: 0xcd, script: 0x52, flags: 0x0},
	433: {region: 0x161, script: 0x52, flags: 0x0},
	434: {region: 0xcf, script: 0x52, flags: 0x0},
	435: {region: 0x5f, script: 0x52, flags: 0x0},
	436: {region: 0xd9, script: 0x20, flags: 0x0},
	437: {region: 0xd9, script: 0x20, flags: 0x0},
	438: {region: 0xd0, script: 0x52, flags: 0x0},
	439: {region: 0xcf, script: 0x52, flags: 0x0},
	440: {region: 0xcd, script: 0x52, flags: 0x0},
	441: {region: 0xcd, script: 0x52, flags: 0x0},
	442: {region: 0x93, script: 0x52, flags: 0x0},
	443: {region: 0xdd, script: 0x52, flags: 0x0},
	444: {region: 0x97, script: 0x52, flags: 0x0},
	445: {region: 0xd7, script: 0x52, flags: 0x0},
	446: {region: 0x51, script: 0x52, flags: 0x0},
	447: {region: 0xd8, script: 0x52, flags: 0x0},
	448: {region: 0x51, script: 0x52, flags: 0x0},
	449: {region: 0xd8, script: 0x52, flags: 0x0},
	450: {region: 0x121, script: 0x4e, flags: 0x0},
	451: {region: 0x97, script: 0x20, flags: 0x0},
	452: {region: 0x10a, script: 0xb7, flags: 0x0},
	453: {region: 0x82, script: 0x70, flags: 0x0},
	454: {region: 0x15e, script: 0x52, flags: 0x0},
	455: {region: 0x48, script: 0x17, flags: 0x0},
	456: {region: 0x15e, script: 0x52, flags: 0x0},
	457: {region: 0x115, script: 0x52, flags: 0x0},
	458: {region: 0x132, script: 0x52, flags: 0x0},
	459: {region: 0x52, script: 0x52, flags: 0x0},
	460: {region: 0xcc, script: 0x52, flags: 0x0},
	461: {region: 0x12d, script: 0x52, flags: 0x0},
	462: {region: 0x12f, script: 0x52, flags: 0x0},
	463: {region: 0x7e, script: 0x52, flags: 0x0},
	464: {region: 0x76, script: 0x52, flags: 0x0},
	466: {region: 0x6e, script: 0x52, flags: 0x0},
	467: {region: 0x97, script: 0x75, flags: 0x0},
	468: {region: 0x7b, script: 0x1e, flags: 0x0},
	469: {region: 0x132, script: 0x76, flags: 0x0},
	470: {region: 0xc3, script: 0x74, flags: 0x0},
	471: {region: 0x2e, script: 0x3, flags: 0x1},
	472: {region: 0xe5, script: 0x52, flags: 0x0},
	473: {region: 0x31, script: 0x2, flags: 0x1},
	474: {region: 0xe5, script: 0x52, flags: 0x0},
	475: {region: 0x2f, script: 0x52, flags: 0x0},
	476: {region: 0xee, script: 0x52, flags: 0x0},
	477: {region: 0x76, script: 0x52, flags: 0x0},
	478: {region: 0xd4, script: 0x52, flags: 0x0},
	479: {region: 0x132, script: 0x52, flags: 0x0},
	480: {region: 0x48, script: 0x52, flags: 0x0},
	481: {region: 0x9a, script: 0xdd, flags: 0x0},
	482: {region: 0x5f, script: 0x52, flags: 0x0},
	483: {region: 0xae, script: 0x7f, flags: 0x0},
	485: {region: 0x97, script: 0x12, flags: 0x0},
	486: {region: 0xa2, script: 0x52, flags: 0x0},
	487: {region: 0xe7, script: 0x52, flags: 0x0},
	488: {region: 0x9c, script: 0x52, flags: 0x0},
	489: {region: 0x85, script: 0x2d, flags: 0x0},
	490: {region: 0x73, script: 0x52, flags: 0x0},
	491: {region: 0xe6, script: 0x45, flags: 0x0},
	492: {region: 0x9a, script: 0x5, flags: 0x0},
	493: {region: 0x1, script: 0x52, flags: 0x0},
	494: {region: 0x23, script: 0x5, flags: 0x0},
	495: {region: 0x40, script: 0x52, flags: 0x0},
	496: {region: 0x78, script: 0x52, flags: 0x0},
	497: {region: 0xe2, script: 0x52, flags: 0x0},
	498: {region: 0x87, script: 0x52, flags: 0x0},
	499: {region: 0x68, script: 0x52, flags: 0x0},
	500: {region: 0x97, script: 0x20, flags: 0x0},
	501: {region: 0x100, script: 0x52, flags: 0x0},
	502: {region: 0x93, script: 0x52, flags: 0x0},
	503: {region: 0x9c, script: 0x52, flags: 0x0},
	504: {region: 0x97, script: 0x52, flags: 0x0},
	505: {region: 0x33, script: 0x2, flags: 0x1},
	506: {region: 0xd9, script: 0x20, flags: 0x0},
	507: {region: 0x34, script: 0xe, flags: 0x0},
	508: {region: 0x4d, script: 0x52, flags: 0x0},
	509: {region: 0x70, script: 0x52, flags: 0x0},
	510: {region: 0x4d, script: 0x52, flags: 0x0},
	511: {region: 0x9a, script: 0x5, flags: 0x0},
	512: {region: 0x10a, script: 0x52, flags: 0x0},
	513: {region: 0x39, script: 0x52, flags: 0x0},
	514: {region: 0xcf, script: 0x52, flags: 0x0},
	515: {region: 0x102, script: 0x52, flags: 0x0},
	516: {region: 0x93, script: 0x52, flags: 0x0},
	517: {region: 0x12d, script: 0x52, flags: 0x0},
	518: {region: 0x71, script: 0x52, flags: 0x0},
	519: {region: 0x104, script: 0x1e, flags: 0x0},
	520: {region: 0x12e, script: 0x1e, flags: 0x0},
	521: {region: 0x107, script: 0x52, flags: 0x0},
	522: {region: 0x105, script: 0x52, flags: 0x0},
	523: {region: 0x12d, script: 0x52, flags: 0x0},
	524: {region: 0xa0, script: 0x44, flags: 0x0},
	525: {region: 0x97, script: 0x20, flags: 0x0},
	526: {region: 0x7e, script: 0x52, flags: 0x0},
	527: {region: 0x104, script: 0x1e, flags: 0x0},
	528: {region: 0xa2, script: 0x52, flags: 0x0},
	529: {region: 0x93, script: 0x52, flags: 0x0},
	530: {region: 0x97, script: 0x52, flags: 0x0},
	531: {region: 0x97, script: 0xbb, flags: 0x0},
	532: {region: 0x12d, script: 0x52, flags: 0x0},
	533: {region: 0x9c, script: 0x52, flags: 0x0},
	534: {region: 0x97, script: 0x20, flags: 0x0},
	535: {region: 0x9c, script: 0x52, flags: 0x0},
	536: {region: 0x79, script: 0x52, flags: 0x0},
	537: {region: 0x48, script: 0x52, flags: 0x0},
	538: {region: 0x35, script: 0x4, flags: 0x1},
	539: {region: 0x9c, script: 0x52, flags: 0x0},
	540: {region: 0x9a, script: 0x5, flags: 0x0},
	541: {region: 0xd8, script: 0x52, flags: 0x0},
	542: {region: 0x4e, script: 0x52, flags: 0x0},
	543: {region: 0xcf, script: 0x52, flags: 0x0},
	544: {region: 0xcd, script: 0x52, flags: 0x0},
	545: {region: 0xc1, script: 0x52, flags: 0x0},
	546: {region: 0x4b, script: 0x52, flags: 0x0},
	547: {region: 0x94, script: 0x72, flags: 0x0},
	548: {region: 0xb4, script: 0x52, flags: 0x0},
	550: {region: 0xb8, script: 0xd2, flags: 0x0},
	551: {region: 0xc2, script: 0x6b, flags: 0x0},
	552: {region: 0xb1, script: 0xc1, flags: 0x0},
	553: {region: 0x6e, script: 0x52, flags: 0x0},
	554: {region: 0x10f, script: 0x52, flags: 0x0},
	555: {region: 0xe6, script: 0x5, flags: 0x0},
	556: {region: 0x10d, script: 0x52, flags: 0x0},
	557: {region: 0xe7, script: 0x52, flags: 0x0},
	558: {region: 0x93, script: 0x52, flags: 0x0},
	559: {region: 0x13f, script: 0x52, flags: 0x0},
	560: {region: 0x10a, script: 0x52, flags: 0x0},
	562: {region: 0x10a, script: 0x52, flags: 0x0},
	563: {region: 0x70, script: 0x52, flags: 0x0},
	564: {region: 0x95, script: 0xb8, flags: 0x0},
	565: {region: 0x70, script: 0x52, flags: 0x0},
	566: {region: 0x161, script: 0x52, flags: 0x0},
	567: {region: 0xc1, script: 0x52, flags: 0x0},
	568: {region: 0x113, script: 0x52, flags: 0x0},
	569: {region: 0x121, script: 0xd5, flags: 0x0},
	570: {region: 0x26, script: 0x52, flags: 0x0},
	571: {region: 0x39, script: 0x5, flags: 0x1},
	572: {region: 0x97, script: 0xc2, flags: 0x0},
	573: {region: 0x114, script: 0x52, flags: 0x0},
	574: {region: 0x112, script: 0x52, flags: 0x0},
	575: {region: 0x97, script: 0x20, flags: 0x0},
	576: {region: 0x15e, script: 0x52, flags: 0x0},
	577: {region: 0x6c, script: 0x52, flags: 0x0},
	578: {region: 0x15e, script: 0x52, flags: 0x0},
	579: {region: 0x5f, script: 0x52, flags: 0x0},
	580: {region: 0x93, script: 0x52, flags: 0x0},
	581: {region: 0x12d, script: 0x52, flags: 0x0},
	582: {region: 0x82, script: 0x52, flags: 0x0},
	583: {region: 0x10a, script: 0x52, flags: 0x0},
	584: {region: 0x12d, script: 0x52, flags: 0x0},
	585: {region: 0x15c, script: 0x5, flags: 0x0},
	586: {region: 0x4a, script: 0x52, flags: 0x0},
	587: {region: 0x5f, script: 0x52, flags: 0x0},
	588: {region: 0x97, script: 0x20, flags: 0x0},
	589: {region: 0x93, script: 0x52, flags: 0x0},
	590: {region: 0x34, script: 0xe, flags: 0x0},
	591: {region: 0x99, script: 0xc5, flags: 0x0},
	592: {region: 0xe7, script: 0x52, flags: 0x0},
	593: {region: 0x97, script: 0xcd, flags: 0x0},
	594: {region: 0xd9, script: 0x20, flags: 0x0},
	595: {region: 0xe5, script: 0x52, flags: 0x0},
	596: {region: 0x97, script: 0x4a, flags: 0x0},
	597: {region: 0x52, script: 0xcb, flags: 0x0},
	598: {region: 0xd9, script: 0x20, flags: 0x0},
	599: {region: 0xd9, script: 0x20, flags: 0x0},
	600: {region: 0x97, script: 0xd0, flags: 0x0},
	601: {region: 0x110, script: 0x52, flags: 0x0},
	602: {region: 0x12f, script: 0x52, flags: 0x0},
	603: {region: 0x124, script: 0x52, flags: 0x0},
	604: {region: 0x3e, script: 0x3, flags: 0x1},
	605: {region: 0x121, script: 0xd5, flags: 0x0},
	606: {region: 0xd9, script: 0x20, flags: 0x0},
	607: {region: 0xd9, script: 0x20, flags: 0x0},
	608: {region: 0xd9, script: 0x20, flags: 0x0},
	609: {region: 0x6e, script: 0x27, flags: 0x0},
	610: {region: 0x6c, script: 0x27, flags: 0x0},
	611: {region: 0xd4, script: 0x52, flags: 0x0},
	612: {region: 0x125, script: 0x52, flags: 0x0},
	613: {region: 0x123, script: 0x52, flags: 0x0},
	614: {region: 0x31, script: 0x52, flags: 0x0},
	615: {region: 0xd9, script: 0x20, flags: 0x0},
	616: {region: 0xe5, script: 0x52, flags: 0x0},
	617: {region: 0x31, script: 0x52, flags: 0x0},
	618: {region: 0xd2, script: 0x52, flags: 0x0},
	619: {region: 0x15e, script: 0x52, flags: 0x0},
	620: {region: 0x127, script: 0x52, flags: 0x0},
	621: {region: 0xcc, script: 0x52, flags: 0x0},
	622: {region: 0xe4, script: 0x52, flags: 0x0},
	623: {region: 0x129, script: 0x52, flags: 0x0},
	624: {region: 0x129, script: 0x52, flags: 0x0},
	625: {region: 0x12c, script: 0x52, flags: 0x0},
	626: {region: 0x15e, script: 0x52, flags: 0x0},
	627: {region: 0x85, script: 0x2d, flags: 0x0},
	628: {region: 0xd9, script: 0x20, flags: 0x0},
	629: {region: 0xe5, script: 0x52, flags: 0x0},
	630: {region: 0x42, script: 0xd6, flags: 0x0},
	631: {region: 0x104, script: 0x1e, flags: 0x0},
	632: {region: 0x12f, script: 0x52, flags: 0x0},
	633: {region: 0x121, script: 0xd5, flags: 0x0},
	634: {region: 0x31, script: 0x52, flags: 0x0},
	635: {region: 0xcc, script: 0x52, flags: 0x0},
	636: {region: 0x12b, script: 0x52, flags: 0x0},
	638: {region: 0xd2, script: 0x52, flags: 0x0},
	639: {region: 0x52, script: 0xce, flags: 0x0},
	640: {region: 0xe3, script: 0x52, flags: 0x0},
	641: {region: 0x104, script: 0x1e, flags: 0x0},
	642: {region: 0xb8, script: 0x52, flags: 0x0},
	643: {region: 0x104, script: 0x1e, flags: 0x0},
	644: {region: 0x41, script: 0x4, flags: 0x1},
	645: {region: 0x11a, script: 0xd8, flags: 0x0},
	646: {region: 0x12e, script: 0x1e, flags: 0x0},
	647: {region: 0x73, script: 0x52, flags: 0x0},
	648: {region: 0x29, script: 0x52, flags: 0x0},
	650: {region: 0x45, script: 0x3, flags: 0x1},
	651: {region: 0x97, script: 0xe, flags: 0x0},
	652: {region: 0xe6, script: 0x5, flags: 0x0},
	653: {region: 0x48, script: 0x4, flags: 0x1},
	654: {region: 0xb2, script: 0xd9, flags: 0x0},
	655: {region: 0x15e, script: 0x52, flags: 0x0},
	656: {region: 0x9c, script: 0x52, flags: 0x0},
	657: {region: 0x104, script: 0x52, flags: 0x0},
	658: {region: 0x13b, script: 0x52, flags: 0x0},
	659: {region: 0x119, script: 0x52, flags: 0x0},
	660: {region: 0x35, script: 0x52, flags: 0x0},
	661: {region: 0x5f, script: 0x52, flags: 0x0},
	662: {region: 0xcf, script: 0x52, flags: 0x0},
	663: {region: 0x1, script: 0x52, flags: 0x0},
	664: {region: 0x104, script: 0x52, flags: 0x0},
	665: {region: 0x69, script: 0x52, flags: 0x0},
	666: {region: 0x12d, script: 0x52, flags: 0x0},
	667: {region: 0x35, script: 0x52, flags: 0x0},
	668: {region: 0x4d, script: 0x52, flags: 0x0},
	669: {region: 0x6e, script: 0x27, flags: 0x0},
	670: {region: 0xe5, script: 0x52, flags: 0x0},
	671: {region: 0x2e, script: 0x52, flags: 0x0},
	672: {region: 0x97, script: 0xd0, flags: 0x0},
	673: {region: 0x97, script: 0x20, flags: 0x0},
	674: {region: 0x13d, script: 0x52, flags: 0x0},
	675: {region: 0xa6, script: 0x5, flags: 0x0},
	676: {region: 0x112, script: 0x52, flags: 0x0},
	677: {region: 0x97, script: 0x20, flags: 0x0},
	678: {region: 0x52, script: 0x34, flags: 0x0},
	679: {region: 0x40, script: 0x52, flags: 0x0},
	680: {region: 0x129, script: 0x18, flags: 0x0},
	681: {region: 0x15e, script: 0x52, flags: 0x0},
	682: {region: 0x129, script: 0x5a, flags: 0x0},
	683: {region: 0x129, script: 0x5b, flags: 0x0},
	684: {region: 0x7b, script: 0x29, flags: 0x0},
	685: {region: 0x52, script: 0x5e, flags: 0x0},
	686: {region: 0x109, script: 0x62, flags: 0x0},
	687: {region: 0x106, script: 0x6c, flags: 0x0},
	688: {region: 0x97, script: 0x20, flags: 0x0},
	689: {region: 0x12f, script: 0x52, flags: 0x0},
	690: {region: 0x9a, script: 0x82, flags: 0x0},
	691: {region: 0x15b, script: 0xba, flags: 0x0},
	692: {region: 0xd9, script: 0x20, flags: 0x0},
	693: {region: 0xcf, script: 0x52, flags: 0x0},
	694: {region: 0x73, script: 0x52, flags: 0x0},
	695: {region: 0x51, script: 0x52, flags: 0x0},
	696: {region: 0x51, script: 0x52, flags: 0x0},
	697: {region: 0x1, script: 0x37, flags: 0x0},
	698: {region: 0xd4, script: 0x52, flags: 0x0},
	699: {region: 0x40, script: 0x52, flags: 0x0},
	700: {region: 0xcd, script: 0x52, flags: 0x0},
	701: {region: 0x4c, script: 0x3, flags: 0x1},
	702: {region: 0x52, script: 0x52, flags: 0x0},
	703: {region: 0x109, script: 0x52, flags: 0x0},
	705: {region: 0xa6, script: 0x5, flags: 0x0},
	706: {region: 0xd7, script: 0x52, flags: 0x0},
	707: {region: 0xb8, script: 0xd2, flags: 0x0},
	708: {region: 0x4f, script: 0x14, flags: 0x1},
	709: {region: 0xce, script: 0x52, flags: 0x0},
	710: {region: 0x15e, script: 0x52, flags: 0x0},
	712: {region: 0x129, script: 0x52, flags: 0x0},
}

// likelyLangList holds lists info associated with likelyLang.
// Size: 396 bytes, 99 elements
var likelyLangList = [99]likelyScriptRegion{
	0:  {region: 0x9a, script: 0x7, flags: 0x0},
	1:  {region: 0x9f, script: 0x6d, flags: 0x2},
	2:  {region: 0x11a, script: 0x78, flags: 0x2},
	3:  {region: 0x31, script: 0x52, flags: 0x0},
	4:  {region: 0x99, script: 0x5, flags: 0x4},
	5:  {region: 0x9a, script: 0x5, flags: 0x4},
	6:  {region: 0x104, script: 0x1e, flags: 0x4},
	7:  {region: 0x9a, script: 0x5, flags: 0x2},
	8:  {region: 0x97, script: 0xe, flags: 0x0},
	9:  {region: 0x34, script: 0x16, flags: 0x2},
	10: {region: 0x104, script: 0x1e, flags: 0x0},
	11: {region: 0x37, script: 0x2a, flags: 0x2},
	12: {region: 0x132, script: 0x52, flags: 0x0},
	13: {region: 0x79, script: 0xbd, flags: 0x2},
	14: {region: 0x112, script: 0x52, flags: 0x0},
	15: {region: 0x82, script: 0x1, flags: 0x2},
	16: {region: 0x5c, script: 0x1d, flags: 0x0},
	17: {region: 0x85, script: 0x57, flags: 0x2},
	18: {region: 0xd4, script: 0x52, flags: 0x0},
	19: {region: 0x51, script: 0x5, flags: 0x4},
	20: {region: 0x109, script: 0x5, flags: 0x4},
	21: {region: 0xac, script: 0x1e, flags: 0x0},
	22: {region: 0x23, script: 0x5, flags: 0x4},
	23: {region: 0x52, script: 0x5, flags: 0x4},
	24: {region: 0x9a, script: 0x5, flags: 0x4},
	25: {region: 0xc3, script: 0x5, flags: 0x4},
	26: {region: 0x52, script: 0x5, flags: 0x2},
	27: {region: 0x129, script: 0x52, flags: 0x0},
	28: {region: 0xae, script: 0x5, flags: 0x4},
	29: {region: 0x99, script: 0x5, flags: 0x2},
	30: {region: 0xa3, script: 0x1e, flags: 0x0},
	31: {region: 0x52, script: 0x5, flags: 0x4},
	32: {region: 0x129, script: 0x52, flags: 0x4},
	33: {region: 0x52, script: 0x5, flags: 0x2},
	34: {region: 0x129, script: 0x52, flags: 0x2},
	35: {region: 0xd9, script: 0x20, flags: 0x0},
	36: {region: 0x97, script: 0x55, flags: 0x2},
	37: {region: 0x81, script: 0x52, flags: 0x0},
	38: {region: 0x82, script: 0x70, flags: 0x4},
	39: {region: 0x82, script: 0x70, flags: 0x2},
	40: {region: 0xc3, script: 0x1e, flags: 0x0},
	41: {region: 0x52, script: 0x66, flags: 0x4},
	42: {region: 0x52, script: 0x66, flags: 0x2},
	43: {region: 0xce, script: 0x52, flags: 0x0},
	44: {region: 0x49, script: 0x5, flags: 0x4},
	45: {region: 0x93, script: 0x5, flags: 0x4},
	46: {region: 0x97, script: 0x2f, flags: 0x0},
	47: {region: 0xe6, script: 0x5, flags: 0x4},
	48: {region: 0xe6, script: 0x5, flags: 0x2},
	49: {region: 0x9a, script: 0x7c, flags: 0x0},
	50: {region: 0x52, script: 0x7d, flags: 0x2},
	51: {region: 0xb8, script: 0xd2, flags: 0x0},
	52: {region: 0xd7, script: 0x52, flags: 0x4},
	53: {region: 0xe6, script: 0x5, flags: 0x0},
	54: {region: 0x97, script: 0x20, flags: 0x2},
	55: {region: 0x97, script: 0x47, flags: 0x2},
	56: {region: 0x97, script: 0xc0, flags: 0x2},
	57: {region: 0x103, script: 0x1e, flags: 0x0},
	58: {region: 0xbb, script: 0x52, flags: 0x4},
	59: {region: 0x102, script: 0x52, flags: 0x4},
	60: {region: 0x104, script: 0x52, flags: 0x4},
	61: {region: 0x129, script: 0x52, flags: 0x4},
	62: {region: 0x122, script: 0x1e, flags: 0x0},
	63: {region: 0xe6, script: 0x5, flags: 0x4},
	64: {region: 0xe6, script: 0x5, flags: 0x2},
	65: {region: 0x52, script: 0x5, flags: 0x0},
	66: {region: 0xac, script: 0x1e, flags: 0x4},
	67: {region: 0xc3, script: 0x1e, flags: 0x4},
	68: {region: 0xac, script: 0x1e, flags: 0x2},
	69: {region: 0x97, script: 0xe, flags: 0x0},
	70: {region: 0xd9, script: 0x20, flags: 0x4},
	71: {region: 0xd9, script: 0x20, flags: 0x2},
	72: {region: 0x134, script: 0x52, flags: 0x0},
	73: {region: 0x23, script: 0x5, flags: 0x4},
	74: {region: 0x52, script: 0x1e, flags: 0x4},
	75: {region: 0x23, script: 0x5, flags: 0x2},
	76: {region: 0x8b, script: 0x35, flags: 0x0},
	77: {region: 0x52, script: 0x34, flags: 0x4},
	78: {region: 0x52, script: 0x34, flags: 0x2},
	79: {region: 0x52, script: 0x34, flags: 0x0},
	80: {region: 0x2e, script: 0x35, flags: 0x4},
	81: {region: 0x3d, script: 0x35, flags: 0x4},
	82: {region: 0x79, script: 0x35, flags: 0x4},
	83: {region: 0x7c, script: 0x35, flags: 0x4},
	84: {region: 0x8b, script: 0x35, flags: 0x4},
	85: {region: 0x93, script: 0x35, flags: 0x4},
	86: {region: 0xc4, script: 0x35, flags: 0x4},
	87: {region: 0xce, script: 0x35, flags: 0x4},
	88: {region: 0xe0, script: 0x35, flags: 0x4},
	89: {region: 0xe3, script: 0x35, flags: 0x4},
	90: {region: 0xe5, script: 0x35, flags: 0x4},
	91: {region: 0x114, script: 0x35, flags: 0x4},
	92: {region: 0x121, script: 0x35, flags: 0x4},
	93: {region: 0x12c, script: 0x35, flags: 0x4},
	94: {region: 0x132, script: 0x35, flags: 0x4},
	95: {region: 0x13b, script: 0x35, flags: 0x4},
	96: {region: 0x12c, script: 0x11, flags: 0x2},
	97: {region: 0x12c, script: 0x30, flags: 0x2},
	98: {region: 0x12c, script: 0x35, flags: 0x2},
}

type likelyLangScript struct {
	lang   uint16
	script uint8
	flags  uint8
}

// likelyRegion is a lookup table, indexed by regionID, for the most likely
// languages and scripts given incomplete information. If more entries exist
// for a given regionID, lang and script are the index and size respectively
// of the list in likelyRegionList.
// TODO: exclude containers and user-definable regions from the list.
// Size: 1420 bytes, 355 elements
var likelyRegion = [355]likelyLangScript{
	33:  {lang: 0x61, script: 0x52, flags: 0x0},
	34:  {lang: 0x15, script: 0x5, flags: 0x0},
	35:  {lang: 0x0, script: 0x2, flags: 0x1},
	38:  {lang: 0x2, script: 0x2, flags: 0x1},
	39:  {lang: 0x4, script: 0x2, flags: 0x1},
	41:  {lang: 0x1ef, script: 0x52, flags: 0x0},
	42:  {lang: 0x0, script: 0x52, flags: 0x0},
	43:  {lang: 0x9d, script: 0x52, flags: 0x0},
	44:  {lang: 0x22f, script: 0x52, flags: 0x0},
	45:  {lang: 0x85, script: 0x52, flags: 0x0},
	47:  {lang: 0x1bd, script: 0x52, flags: 0x0},
	48:  {lang: 0x247, script: 0x52, flags: 0x0},
	49:  {lang: 0x24, script: 0x52, flags: 0x0},
	50:  {lang: 0x6, script: 0x2, flags: 0x1},
	52:  {lang: 0x4b, script: 0xe, flags: 0x0},
	53:  {lang: 0x1bd, script: 0x52, flags: 0x0},
	54:  {lang: 0xaf, script: 0x52, flags: 0x0},
	55:  {lang: 0x38, script: 0x1e, flags: 0x0},
	56:  {lang: 0x15, script: 0x5, flags: 0x0},
	57:  {lang: 0x201, script: 0x52, flags: 0x0},
	58:  {lang: 0xaf, script: 0x52, flags: 0x0},
	59:  {lang: 0xaf, script: 0x52, flags: 0x0},
	61:  {lang: 0x19a, script: 0x52, flags: 0x0},
	62:  {lang: 0x9d, script: 0x52, flags: 0x0},
	63:  {lang: 0x1db, script: 0x52, flags: 0x0},
	64:  {lang: 0x1ef, script: 0x52, flags: 0x0},
	66:  {lang: 0x8, script: 0x2, flags: 0x1},
	68:  {lang: 0x0, script: 0x52, flags: 0x0},
	70:  {lang: 0x2f, script: 0x1e, flags: 0x0},
	72:  {lang: 0x2b9, script: 0x37, flags: 0x2},
	73:  {lang: 0x19a, script: 0x5, flags: 0x2},
	74:  {lang: 0x248, script: 0x52, flags: 0x0},
	75:  {lang: 0xaf, script: 0x52, flags: 0x0},
	76:  {lang: 0xaf, script: 0x52, flags: 0x0},
	77:  {lang: 0x85, script: 0x52, flags: 0x0},
	78:  {lang: 0xaf, script: 0x52, flags: 0x0},
	80:  {lang: 0x9d, script: 0x52, flags: 0x0},
	81:  {lang: 0xaf, script: 0x52, flags: 0x0},
	82:  {lang: 0xa, script: 0x5, flags: 0x1},
	83:  {lang: 0x9d, script: 0x52, flags: 0x0},
	84:  {lang: 0x0, script: 0x52, flags: 0x0},
	85:  {lang: 0x9d, script: 0x52, flags: 0x0},
	88:  {lang: 0x9d, script: 0x52, flags: 0x0},
	89:  {lang: 0x1ef, script: 0x52, flags: 0x0},
	90:  {lang: 0x1db, script: 0x52, flags: 0x0},
	92:  {lang: 0xf, script: 0x2, flags: 0x1},
	93:  {lang: 0x79, script: 0x52, flags: 0x0},
	95:  {lang: 0x85, script: 0x52, flags: 0x0},
	97:  {lang: 0x1, script: 0x52, flags: 0x0},
	98:  {lang: 0x80, script: 0x52, flags: 0x0},
	100: {lang: 0x9d, script: 0x52, flags: 0x0},
	102: {lang: 0x11, script: 0x2, flags: 0x1},
	103: {lang: 0x9d, script: 0x52, flags: 0x0},
	104: {lang: 0x9d, script: 0x52, flags: 0x0},
	105: {lang: 0x9f, script: 0x52, flags: 0x0},
	106: {lang: 0x15, script: 0x5, flags: 0x0},
	107: {lang: 0x15, script: 0x5, flags: 0x0},
	108: {lang: 0x261, script: 0x27, flags: 0x0},
	109: {lang: 0x9d, script: 0x52, flags: 0x0},
	110: {lang: 0x13, script: 0x2, flags: 0x1},
	112: {lang: 0xa8, script: 0x52, flags: 0x0},
	113: {lang: 0xe2, script: 0x20, flags: 0x2},
	116: {lang: 0xad, script: 0x52, flags: 0x0},
	118: {lang: 0xaf, script: 0x52, flags: 0x0},
	120: {lang: 0xaf, script: 0x52, flags: 0x0},
	121: {lang: 0x15, script: 0x2, flags: 0x1},
	123: {lang: 0x17, script: 0x3, flags: 0x1},
	124: {lang: 0xaf, script: 0x52, flags: 0x0},
	126: {lang: 0xd, script: 0x52, flags: 0x0},
	128: {lang: 0x131, script: 0x52, flags: 0x0},
	130: {lang: 0xaf, script: 0x52, flags: 0x0},
	131: {lang: 0xaf, script: 0x52, flags: 0x0},
	132: {lang: 0x9d, script: 0x52, flags: 0x0},
	133: {lang: 0x1a, script: 0x2, flags: 0x1},
	134: {lang: 0x0, script: 0x52, flags: 0x0},
	135: {lang: 0x9d, script: 0x52, flags: 0x0},
	137: {lang: 0x1ef, script: 0x52, flags: 0x0},
	139: {lang: 0x2c4, script: 0x35, flags: 0x0},
	140: {lang: 0x0, script: 0x52, flags: 0x0},
	141: {lang: 0x9d, script: 0x52, flags: 0x0},
	142: {lang: 0xee, script: 0x52, flags: 0x0},
	143: {lang: 0xf1, script: 0x52, flags: 0x0},
	144: {lang: 0xf2, script: 0x52, flags: 0x0},
	146: {lang: 0x9d, script: 0x52, flags: 0x0},
	147: {lang: 0x1c, script: 0x2, flags: 0x1},
	149: {lang: 0xe0, script: 0x37, flags: 0x0},
	151: {lang: 0x1e, script: 0x3, flags: 0x1},
	153: {lang: 0x15, script: 0x5, flags: 0x0},
	154: {lang: 0x21, script: 0x2, flags: 0x1},
	155: {lang: 0x102, script: 0x52, flags: 0x0},
	156: {lang: 0x103, script: 0x52, flags: 0x0},
	159: {lang: 0x15, script: 0x5, flags: 0x0},
	160: {lang: 0x107, script: 0x41, flags: 0x0},
	162: {lang: 0x248, script: 0x52, flags: 0x0},
	163: {lang: 0x14d, script: 0x1e, flags: 0x0},
	164: {lang: 0x23, script: 0x3, flags: 0x1},
	166: {lang: 0x26, script: 0x2, flags: 0x1},
	168: {lang: 0x136, script: 0x4b, flags: 0x0},
	169: {lang: 0x136, script: 0x4b, flags: 0x0},
	170: {lang: 0x15, script: 0x5, flags: 0x0},
	172: {lang: 0x207, script: 0x1e, flags: 0x0},
	173: {lang: 0x28, script: 0x2, flags: 0x1},
	174: {lang: 0x15, script: 0x5, flags: 0x0},
	176: {lang: 0x85, script: 0x52, flags: 0x0},
	177: {lang: 0x228, script: 0xc1, flags: 0x0},
	179: {lang: 0x242, script: 0x52, flags: 0x0},
	180: {lang: 0x169, script: 0x52, flags: 0x0},
	181: {lang: 0xaf, script: 0x52, flags: 0x0},
	182: {lang: 0x170, script: 0x52, flags: 0x0},
	183: {lang: 0x15, script: 0x5, flags: 0x0},
	184: {lang: 0x2a, script: 0x2, flags: 0x1},
	185: {lang: 0xaf, script: 0x52, flags: 0x0},
	186: {lang: 0x2c, script: 0x2, flags: 0x1},
	187: {lang: 0x23b, script: 0x52, flags: 0x0},
	188: {lang: 0xaf, script: 0x52, flags: 0x0},
	189: {lang: 0x183, script: 0x52, flags: 0x0},
	192: {lang: 0x2e, script: 0x2, flags: 0x1},
	193: {lang: 0x49, script: 0x52, flags: 0x0},
	194: {lang: 0x30, script: 0x2, flags: 0x1},
	195: {lang: 0x32, script: 0x2, flags: 0x1},
	196: {lang: 0x34, script: 0x2, flags: 0x1},
	198: {lang: 0xaf, script: 0x52, flags: 0x0},
	199: {lang: 0x36, script: 0x2, flags: 0x1},
	201: {lang: 0x19b, script: 0x52, flags: 0x0},
	202: {lang: 0x38, script: 0x3, flags: 0x1},
	203: {lang: 0x90, script: 0xd4, flags: 0x0},
	205: {lang: 0x9d, script: 0x52, flags: 0x0},
	206: {lang: 0x19a, script: 0x52, flags: 0x0},
	207: {lang: 0x1ef, script: 0x52, flags: 0x0},
	208: {lang: 0xa, script: 0x52, flags: 0x0},
	209: {lang: 0xaf, script: 0x52, flags: 0x0},
	210: {lang: 0xdc, script: 0x52, flags: 0x0},
	212: {lang: 0xdc, script: 0x5, flags: 0x2},
	214: {lang: 0x9d, script: 0x52, flags: 0x0},
	215: {lang: 0x1bd, script: 0x52, flags: 0x0},
	216: {lang: 0x1af, script: 0x52, flags: 0x0},
	217: {lang: 0x1b4, script: 0x20, flags: 0x0},
	223: {lang: 0x15, script: 0x5, flags: 0x0},
	224: {lang: 0x9d, script: 0x52, flags: 0x0},
	226: {lang: 0x9d, script: 0x52, flags: 0x0},
	227: {lang: 0xaf, script: 0x52, flags: 0x0},
	228: {lang: 0x26e, script: 0x52, flags: 0x0},
	229: {lang: 0xaa, script: 0x52, flags: 0x0},
	230: {lang: 0x3b, script: 0x3, flags: 0x1},
	231: {lang: 0x3e, script: 0x2, flags: 0x1},
	232: {lang: 0xaf, script: 0x52, flags: 0x0},
	234: {lang: 0x9d, script: 0x52, flags: 0x0},
	235: {lang: 0x15, script: 0x5, flags: 0x0},
	236: {lang: 0x1ef, script: 0x52, flags: 0x0},
	238: {lang: 0x1dc, script: 0x52, flags: 0x0},
	239: {lang: 0xca, script: 0x52, flags: 0x0},
	241: {lang: 0x15, script: 0x5, flags: 0x0},
	256: {lang: 0xaf, script: 0x52, flags: 0x0},
	258: {lang: 0x40, script: 0x2, flags: 0x1},
	259: {lang: 0x23b, script: 0x1e, flags: 0x0},
	260: {lang: 0x42, script: 0x2, flags: 0x1},
	261: {lang: 0x20a, script: 0x52, flags: 0x0},
	262: {lang: 0x15, script: 0x5, flags: 0x0},
	264: {lang: 0xaf, script: 0x52, flags: 0x0},
	265: {lang: 0x15, script: 0x5, flags: 0x0},
	266: {lang: 0x44, script: 0x2, flags: 0x1},
	269: {lang: 0x22c, script: 0x52, flags: 0x0},
	270: {lang: 0x1af, script: 0x52, flags: 0x0},
	271: {lang: 0x46, script: 0x2, flags: 0x1},
	273: {lang: 0x103, script: 0x52, flags: 0x0},
	274: {lang: 0xaf, script: 0x52, flags: 0x0},
	275: {lang: 0x238, script: 0x52, flags: 0x0},
	276: {lang: 0x1bd, script: 0x52, flags: 0x0},
	278: {lang: 0x1ef, script: 0x52, flags: 0x0},
	280: {lang: 0x9d, script: 0x52, flags: 0x0},
	282: {lang: 0x48, script: 0x2, flags: 0x1},
	286: {lang: 0xaf, script: 0x52, flags: 0x0},
	287: {lang: 0xaf, script: 0x52, flags: 0x0},
	288: {lang: 0xaf, script: 0x52, flags: 0x0},
	289: {lang: 0x4a, script: 0x3, flags: 0x1},
	290: {lang: 0x4d, script: 0x2, flags: 0x1},
	291: {lang: 0x265, script: 0x52, flags: 0x0},
	292: {lang: 0x1ef, script: 0x52, flags: 0x0},
	293: {lang: 0x264, script: 0x52, flags: 0x0},
	294: {lang: 0x4f, script: 0x2, flags: 0x1},
	295: {lang: 0x26c, script: 0x52, flags: 0x0},
	297: {lang: 0x51, script: 0x4, flags: 0x1},
	299: {lang: 0x27c, script: 0x52, flags: 0x0},
	300: {lang: 0x55, script: 0x2, flags: 0x1},
	301: {lang: 0x248, script: 0x52, flags: 0x0},
	302: {lang: 0x57, script: 0x3, flags: 0x1},
	303: {lang: 0x248, script: 0x52, flags: 0x0},
	306: {lang: 0x2b9, script: 0x37, flags: 0x2},
	307: {lang: 0x9d, script: 0x52, flags: 0x0},
	308: {lang: 0x28d, script: 0x52, flags: 0x0},
	309: {lang: 0x103, script: 0x52, flags: 0x0},
	312: {lang: 0x9d, script: 0x52, flags: 0x0},
	315: {lang: 0x292, script: 0x52, flags: 0x0},
	316: {lang: 0x41, script: 0x52, flags: 0x0},
	317: {lang: 0xaf, script: 0x52, flags: 0x0},
	319: {lang: 0x22f, script: 0x52, flags: 0x0},
	330: {lang: 0x5a, script: 0x2, flags: 0x1},
	347: {lang: 0x15, script: 0x5, flags: 0x0},
	348: {lang: 0x5c, script: 0x2, flags: 0x1},
	353: {lang: 0x236, script: 0x52, flags: 0x0},
}

// likelyRegionList holds lists info associated with likelyRegion.
// Size: 376 bytes, 94 elements
var likelyRegionList = [94]likelyLangScript{
	0:  {lang: 0xa4, script: 0x5, flags: 0x0},
	1:  {lang: 0x264, script: 0x52, flags: 0x0},
	2:  {lang: 0x23a, script: 0x52, flags: 0x0},
	3:  {lang: 0x18c, script: 0x1e, flags: 0x0},
	4:  {lang: 0xf3, script: 0x8, flags: 0x0},
	5:  {lang: 0x145, script: 0x52, flags: 0x0},
	6:  {lang: 0x54, script: 0x52, flags: 0x0},
	7:  {lang: 0x23b, script: 0x1e, flags: 0x0},
	8:  {lang: 0x93, script: 0xd6, flags: 0x0},
	9:  {lang: 0x1b4, script: 0x20, flags: 0x0},
	10: {lang: 0x2c4, script: 0x34, flags: 0x0},
	11: {lang: 0x284, script: 0x5, flags: 0x0},
	12: {lang: 0x2bd, script: 0x35, flags: 0x0},
	13: {lang: 0x2be, script: 0x52, flags: 0x0},
	14: {lang: 0x157, script: 0xd5, flags: 0x0},
	15: {lang: 0x9a, script: 0x2d, flags: 0x0},
	16: {lang: 0x26f, script: 0x52, flags: 0x0},
	17: {lang: 0x15, script: 0x5, flags: 0x0},
	18: {lang: 0xaf, script: 0x52, flags: 0x0},
	19: {lang: 0x11, script: 0x27, flags: 0x0},
	20: {lang: 0x9b, script: 0x52, flags: 0x0},
	21: {lang: 0x141, script: 0x5, flags: 0x2},
	22: {lang: 0x2b9, script: 0x37, flags: 0x2},
	23: {lang: 0x111, script: 0x29, flags: 0x0},
	24: {lang: 0x2, script: 0x1e, flags: 0x0},
	25: {lang: 0x145, script: 0x52, flags: 0x0},
	26: {lang: 0x9a, script: 0x2d, flags: 0x0},
	27: {lang: 0x18c, script: 0x1e, flags: 0x0},
	28: {lang: 0xf8, script: 0x52, flags: 0x0},
	29: {lang: 0x19a, script: 0x5, flags: 0x0},
	30: {lang: 0xe1, script: 0x20, flags: 0x0},
	31: {lang: 0x28c, script: 0x5, flags: 0x0},
	32: {lang: 0x129, script: 0x6b, flags: 0x0},
	33: {lang: 0xa4, script: 0x5, flags: 0x0},
	34: {lang: 0x264, script: 0x52, flags: 0x0},
	35: {lang: 0x133, script: 0x46, flags: 0x0},
	36: {lang: 0x6d, script: 0x5, flags: 0x0},
	37: {lang: 0x11c, script: 0xd5, flags: 0x0},
	38: {lang: 0x15, script: 0x5, flags: 0x0},
	39: {lang: 0xaf, script: 0x52, flags: 0x0},
	40: {lang: 0x165, script: 0x4f, flags: 0x0},
	41: {lang: 0x11c, script: 0xd5, flags: 0x0},
	42: {lang: 0x15, script: 0x5, flags: 0x0},
	43: {lang: 0xaf, script: 0x52, flags: 0x0},
	44: {lang: 0x203, script: 0x52, flags: 0x0},
	45: {lang: 0x286, script: 0x1e, flags: 0x0},
	46: {lang: 0x18c, script: 0x1e, flags: 0x0},
	47: {lang: 0x23a, script: 0x52, flags: 0x0},
	48: {lang: 0x1a5, script: 0x6b, flags: 0x0},
	49: {lang: 0x114, script: 0x52, flags: 0x0},
	50: {lang: 0x18f, script: 0x1e, flags: 0x0},
	51: {lang: 0x12f, script: 0x5, flags: 0x0},
	52: {lang: 0x2c4, script: 0x35, flags: 0x0},
	53: {lang: 0x1ef, script: 0x52, flags: 0x0},
	54: {lang: 0x15, script: 0x5, flags: 0x0},
	55: {lang: 0xaf, script: 0x52, flags: 0x0},
	56: {lang: 0x182, script: 0x52, flags: 0x0},
	57: {lang: 0x28c, script: 0x5, flags: 0x0},
	58: {lang: 0x40, script: 0x20, flags: 0x0},
	59: {lang: 0x28c, script: 0x5, flags: 0x0},
	60: {lang: 0x28c, script: 0x5, flags: 0x0},
	61: {lang: 0x58, script: 0x20, flags: 0x0},
	62: {lang: 0x1e7, script: 0x52, flags: 0x0},
	63: {lang: 0x2f, script: 0x1e, flags: 0x0},
	64: {lang: 0x203, script: 0x52, flags: 0x0},
	65: {lang: 0x38, script: 0x1e, flags: 0x0},
	66: {lang: 0x207, script: 0x1e, flags: 0x0},
	67: {lang: 0x13f, script: 0x52, flags: 0x0},
	68: {lang: 0x247, script: 0x52, flags: 0x0},
	69: {lang: 0x2b9, script: 0x37, flags: 0x0},
	70: {lang: 0x22a, script: 0x52, flags: 0x0},
	71: {lang: 0x286, script: 0x1e, flags: 0x0},
	72: {lang: 0x15, script: 0x5, flags: 0x0},
	73: {lang: 0xaf, script: 0x52, flags: 0x0},
	74: {lang: 0x25d, script: 0xd5, flags: 0x0},
	75: {lang: 0x181, script: 0x5, flags: 0x0},
	76: {lang: 0x191, script: 0x6b, flags: 0x0},
	77: {lang: 0x25c, script: 0x1e, flags: 0x0},
	78: {lang: 0xa4, script: 0x5, flags: 0x0},
	79: {lang: 0x15, script: 0x5, flags: 0x0},
	80: {lang: 0xaf, script: 0x52, flags: 0x0},
	81: {lang: 0x26f, script: 0x52, flags: 0x0},
	82: {lang: 0x24, script: 0x5, flags: 0x0},
	83: {lang: 0x118, script: 0x1e, flags: 0x0},
	84: {lang: 0x3b, script: 0x2d, flags: 0x0},
	85: {lang: 0x2c4, script: 0x35, flags: 0x0},
	86: {lang: 0x271, script: 0x52, flags: 0x0},
	87: {lang: 0x286, script: 0x1e, flags: 0x0},
	88: {lang: 0x2b9, script: 0x37, flags: 0x0},
	89: {lang: 0x1e7, script: 0x52, flags: 0x0},
	90: {lang: 0x23a, script: 0x52, flags: 0x0},
	91: {lang: 0x23b, script: 0x1e, flags: 0x0},
	92: {lang: 0xaf, script: 0x52, flags: 0x0},
	93: {lang: 0x249, script: 0x5, flags: 0x0},
}

type likelyTag struct {
	lang   uint16
	region uint16
	script uint8
}

// Size: 192 bytes, 32 elements
var likelyRegionGroup = [32]likelyTag{
	1:  {lang: 0x9b, region: 0xd4, script: 0x52},
	2:  {lang: 0x9b, region: 0x132, script: 0x52},
	3:  {lang: 0x1ef, region: 0x40, script: 0x52},
	4:  {lang: 0x9b, region: 0x2e, script: 0x52},
	5:  {lang: 0x9b, region: 0xd4, script: 0x52},
	6:  {lang: 0x9d, region: 0xcd, script: 0x52},
	7:  {lang: 0x248, region: 0x12d, script: 0x52},
	8:  {lang: 0x15, region: 0x6a, script: 0x5},
	9:  {lang: 0x248, region: 0x4a, script: 0x52},
	10: {lang: 0x9b, region: 0x15e, script: 0x52},
	11: {lang: 0x9b, region: 0x132, script: 0x52},
	12: {lang: 0x9b, region: 0x132, script: 0x52},
	13: {lang: 0x9d, region: 0x58, script: 0x52},
	14: {lang: 0x2c4, region: 0x52, script: 0x34},
	15: {lang: 0xe1, region: 0x97, script: 0x20},
	16: {lang: 0xf8, region: 0x93, script: 0x52},
	17: {lang: 0x103, region: 0x9c, script: 0x52},
	18: {lang: 0x9b, region: 0x2e, script: 0x52},
	19: {lang: 0x9b, region: 0xe4, script: 0x52},
	20: {lang: 0x9b, region: 0x88, script: 0x52},
	21: {lang: 0x22f, region: 0x13f, script: 0x52},
	22: {lang: 0x2c4, region: 0x52, script: 0x34},
	23: {lang: 0x28d, region: 0x134, script: 0x52},
	24: {lang: 0x15, region: 0x106, script: 0x5},
	25: {lang: 0x207, region: 0x104, script: 0x1e},
	26: {lang: 0x207, region: 0x104, script: 0x1e},
	27: {lang: 0x9b, region: 0x79, script: 0x52},
	28: {lang: 0x85, region: 0x5f, script: 0x52},
	29: {lang: 0x9d, region: 0x1e, script: 0x52},
	30: {lang: 0x9b, region: 0x98, script: 0x52},
	31: {lang: 0x9b, region: 0x79, script: 0x52},
}

type mutualIntelligibility struct {
	want   uint16
	have   uint16
	conf   uint8
	oneway bool
}

type scriptIntelligibility struct {
	lang uint16
	want uint8
	have uint8
	conf uint8
}

// matchLang holds pairs of langIDs of base languages that are typically
// mutually intelligible. Each pair is associated with a confidence and
// whether the intelligibility goes one or both ways.
// Size: 708 bytes, 118 elements
var matchLang = [118]mutualIntelligibility{
	0:   {want: 0x1c1, have: 0x1af, conf: 0x2, oneway: false},
	1:   {want: 0x145, have: 0x6f, conf: 0x2, oneway: false},
	2:   {want: 0xee, have: 0x54, conf: 0x2, oneway: false},
	3:   {want: 0x225, have: 0x54, conf: 0x2, oneway: false},
	4:   {want: 0x23b, have: 0x54, conf: 0x2, oneway: false},
	5:   {want: 0x225, have: 0xee, conf: 0x2, oneway: false},
	6:   {want: 0x23b, have: 0xee, conf: 0x2, oneway: false},
	7:   {want: 0x225, have: 0x23b, conf: 0x2, oneway: false},
	8:   {want: 0x241, have: 0x1, conf: 0x2, oneway: false},
	9:   {want: 0xd2, have: 0x85, conf: 0x2, oneway: true},
	10:  {want: 0x154, have: 0x85, conf: 0x2, oneway: true},
	11:  {want: 0x80, have: 0x1c1, conf: 0x2, oneway: false},
	12:  {want: 0x80, have: 0x1af, conf: 0x2, oneway: false},
	13:  {want: 0x6f, have: 0x145, conf: 0x2, oneway: false},
	14:  {want: 0x2, have: 0x207, conf: 0x2, oneway: true},
	15:  {want: 0x5, have: 0x9b, conf: 0x2, oneway: true},
	16:  {want: 0xa, have: 0x1bd, conf: 0x2, oneway: true},
	17:  {want: 0xd, have: 0x9b, conf: 0x2, oneway: true},
	18:  {want: 0x23, have: 0x9d, conf: 0x2, oneway: true},
	19:  {want: 0x24, have: 0x207, conf: 0x2, oneway: true},
	20:  {want: 0x2f, have: 0x207, conf: 0x2, oneway: true},
	21:  {want: 0x31, have: 0x9b, conf: 0x2, oneway: true},
	22:  {want: 0x3c, have: 0xe1, conf: 0x2, oneway: true},
	23:  {want: 0x4b, have: 0x9b, conf: 0x2, oneway: true},
	24:  {want: 0x50, have: 0xaf, conf: 0x2, oneway: true},
	25:  {want: 0x65, have: 0xaa, conf: 0x2, oneway: true},
	26:  {want: 0x6c, have: 0x9b, conf: 0x2, oneway: true},
	27:  {want: 0x6f, have: 0x15, conf: 0x2, oneway: true},
	28:  {want: 0x70, have: 0xaf, conf: 0x2, oneway: true},
	29:  {want: 0x78, have: 0xaf, conf: 0x2, oneway: true},
	30:  {want: 0x7f, have: 0x9b, conf: 0x2, oneway: true},
	31:  {want: 0x95, have: 0x9b, conf: 0x2, oneway: true},
	32:  {want: 0x9c, have: 0x9b, conf: 0x2, oneway: true},
	33:  {want: 0x9f, have: 0xa8, conf: 0x2, oneway: true},
	34:  {want: 0xa1, have: 0x9d, conf: 0x2, oneway: true},
	35:  {want: 0xad, have: 0x80, conf: 0x2, oneway: true},
	36:  {want: 0xb9, have: 0x1bd, conf: 0x2, oneway: true},
	37:  {want: 0xba, have: 0x9b, conf: 0x2, oneway: true},
	38:  {want: 0xbb, have: 0x9b, conf: 0x2, oneway: true},
	39:  {want: 0xc2, have: 0x9b, conf: 0x2, oneway: true},
	40:  {want: 0xc8, have: 0x9d, conf: 0x2, oneway: true},
	41:  {want: 0xca, have: 0x9d, conf: 0x2, oneway: true},
	42:  {want: 0xd3, have: 0xe1, conf: 0x2, oneway: true},
	43:  {want: 0xdc, have: 0x9b, conf: 0x2, oneway: true},
	44:  {want: 0xde, have: 0x9b, conf: 0x2, oneway: true},
	45:  {want: 0xf1, have: 0xaf, conf: 0x2, oneway: true},
	46:  {want: 0xf3, have: 0x207, conf: 0x2, oneway: true},
	47:  {want: 0xf5, have: 0x9b, conf: 0x2, oneway: true},
	48:  {want: 0xfa, have: 0x9b, conf: 0x2, oneway: true},
	49:  {want: 0x102, have: 0x9b, conf: 0x2, oneway: true},
	50:  {want: 0x10f, have: 0xf8, conf: 0x2, oneway: true},
	51:  {want: 0x111, have: 0x9b, conf: 0x2, oneway: true},
	52:  {want: 0x122, have: 0xaf, conf: 0x2, oneway: true},
	53:  {want: 0x12f, have: 0x207, conf: 0x2, oneway: true},
	54:  {want: 0x133, have: 0x9b, conf: 0x2, oneway: true},
	55:  {want: 0x135, have: 0x9b, conf: 0x2, oneway: true},
	56:  {want: 0x13d, have: 0x9b, conf: 0x2, oneway: true},
	57:  {want: 0x145, have: 0x26f, conf: 0x2, oneway: true},
	58:  {want: 0x14d, have: 0x207, conf: 0x2, oneway: true},
	59:  {want: 0x14e, have: 0x103, conf: 0x2, oneway: true},
	60:  {want: 0x15a, have: 0x9b, conf: 0x2, oneway: true},
	61:  {want: 0x164, have: 0xaf, conf: 0x2, oneway: true},
	62:  {want: 0x165, have: 0x9b, conf: 0x2, oneway: true},
	63:  {want: 0x167, have: 0x9b, conf: 0x2, oneway: true},
	64:  {want: 0x16c, have: 0xaf, conf: 0x2, oneway: true},
	65:  {want: 0x182, have: 0x9b, conf: 0x2, oneway: true},
	66:  {want: 0x183, have: 0xaf, conf: 0x2, oneway: true},
	67:  {want: 0x189, have: 0x9b, conf: 0x2, oneway: true},
	68:  {want: 0x18c, have: 0x38, conf: 0x2, oneway: true},
	69:  {want: 0x18d, have: 0x9b, conf: 0x2, oneway: true},
	70:  {want: 0x18f, have: 0x207, conf: 0x2, oneway: true},
	71:  {want: 0x196, have: 0xe1, conf: 0x2, oneway: true},
	72:  {want: 0x19a, have: 0xf8, conf: 0x2, oneway: true},
	73:  {want: 0x19b, have: 0x9b, conf: 0x2, oneway: true},
	74:  {want: 0x1a5, have: 0x9b, conf: 0x2, oneway: true},
	75:  {want: 0x1b4, have: 0x9b, conf: 0x2, oneway: true},
	76:  {want: 0x1bf, have: 0x1af, conf: 0x2, oneway: false},
	77:  {want: 0x1bf, have: 0x1c1, conf: 0x2, oneway: true},
	78:  {want: 0x1c8, have: 0x9b, conf: 0x2, oneway: true},
	79:  {want: 0x1cc, have: 0x9b, conf: 0x2, oneway: true},
	80:  {want: 0x1ce, have: 0x9b, conf: 0x2, oneway: true},
	81:  {want: 0x1d0, have: 0xaf, conf: 0x2, oneway: true},
	82:  {want: 0x1d2, have: 0x9b, conf: 0x2, oneway: true},
	83:  {want: 0x1d3, have: 0x9b, conf: 0x2, oneway: true},
	84:  {want: 0x1d7, have: 0x9b, conf: 0x2, oneway: true},
	85:  {want: 0x1de, have: 0x9b, conf: 0x2, oneway: true},
	86:  {want: 0x1ee, have: 0x9b, conf: 0x2, oneway: true},
	87:  {want: 0x1f1, have: 0x9d, conf: 0x2, oneway: true},
	88:  {want: 0x1fc, have: 0x85, conf: 0x2, oneway: true},
	89:  {want: 0x201, have: 0x9b, conf: 0x2, oneway: true},
	90:  {want: 0x20a, have: 0xaf, conf: 0x2, oneway: true},
	91:  {want: 0x20d, have: 0xe1, conf: 0x2, oneway: true},
	92:  {want: 0x21a, have: 0x9b, conf: 0x2, oneway: true},
	93:  {want: 0x228, have: 0x9b, conf: 0x2, oneway: true},
	94:  {want: 0x236, have: 0x9b, conf: 0x2, oneway: true},
	95:  {want: 0x238, have: 0x9b, conf: 0x2, oneway: true},
	96:  {want: 0x23a, have: 0x9b, conf: 0x2, oneway: true},
	97:  {want: 0x242, have: 0x9b, conf: 0x2, oneway: true},
	98:  {want: 0x244, have: 0xf8, conf: 0x2, oneway: true},
	99:  {want: 0x248, have: 0x9b, conf: 0x2, oneway: true},
	100: {want: 0x251, have: 0x9b, conf: 0x2, oneway: true},
	101: {want: 0x258, have: 0x9b, conf: 0x2, oneway: true},
	102: {want: 0x25c, have: 0x207, conf: 0x2, oneway: true},
	103: {want: 0x261, have: 0x9b, conf: 0x2, oneway: true},
	104: {want: 0x264, have: 0x207, conf: 0x2, oneway: true},
	105: {want: 0x361a, have: 0x9b, conf: 0x2, oneway: true},
	106: {want: 0x26b, have: 0x9b, conf: 0x2, oneway: true},
	107: {want: 0x26c, have: 0x9b, conf: 0x2, oneway: true},
	108: {want: 0x277, have: 0x207, conf: 0x2, oneway: true},
	109: {want: 0x27b, have: 0x9b, conf: 0x2, oneway: true},
	110: {want: 0x284, have: 0x2c4, conf: 0x2, oneway: true},
	111: {want: 0x28c, have: 0x9b, conf: 0x2, oneway: true},
	112: {want: 0x28d, have: 0x207, conf: 0x2, oneway: true},
	113: {want: 0x2a4, have: 0xaf, conf: 0x2, oneway: true},
	114: {want: 0x2a9, have: 0x9b, conf: 0x2, oneway: true},
	115: {want: 0x2b9, have: 0x9b, conf: 0x2, oneway: true},
	116: {want: 0x2ba, have: 0x9b, conf: 0x2, oneway: true},
	117: {want: 0x2c6, have: 0x9b, conf: 0x2, oneway: true},
}

// matchScript holds pairs of scriptIDs where readers of one script
// can typically also read the other. Each is associated with a confidence.
// Size: 24 bytes, 4 elements
var matchScript = [4]scriptIntelligibility{
	0: {lang: 0x23b, want: 0x52, have: 0x1e, conf: 0x2},
	1: {lang: 0x23b, want: 0x1e, have: 0x52, conf: 0x2},
	2: {lang: 0x0, want: 0x34, have: 0x35, conf: 0x1},
	3: {lang: 0x0, want: 0x35, have: 0x34, conf: 0x1},
}

// Size: 128 bytes, 32 elements
var regionContainment = [32]uint32{
	0xffffffff, 0x000007a2, 0x00003044, 0x00000008,
	0x403c0010, 0x00000020, 0x00000040, 0x00000080,
	0x00000100, 0x00000200, 0x00000400, 0x2000384c,
	0x00001000, 0x00002000, 0x00004000, 0x00008000,
	0x00010000, 0x00020000, 0x00040000, 0x00080000,
	0x00100000, 0x00200000, 0x01c1c000, 0x00800000,
	0x01000000, 0x1e020000, 0x04000000, 0x08000000,
	0x10000000, 0x20002048, 0x40000000, 0x80000000,
}

// regionInclusion maps region identifiers to sets of regions in regionInclusionBits,
// where each set holds all groupings that are directly connected in a region
// containment graph.
// Size: 355 bytes, 355 elements
var regionInclusion = [355]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
	0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
	0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x25, 0x25, 0x22, 0x23,
	0x25, 0x26, 0x21, 0x27, 0x28, 0x29, 0x2a, 0x25,
	0x2b, 0x23, 0x22, 0x25, 0x24, 0x29, 0x2c, 0x2d,
	0x23, 0x2e, 0x2c, 0x25, 0x2f, 0x30, 0x27, 0x25,
	// Entry 40 - 7F
	0x27, 0x25, 0x24, 0x30, 0x21, 0x31, 0x32, 0x33,
	0x2f, 0x21, 0x26, 0x26, 0x26, 0x34, 0x2c, 0x28,
	0x27, 0x26, 0x35, 0x27, 0x21, 0x33, 0x22, 0x20,
	0x25, 0x2c, 0x25, 0x21, 0x36, 0x2d, 0x34, 0x29,
	0x21, 0x2e, 0x37, 0x25, 0x25, 0x20, 0x38, 0x38,
	0x27, 0x37, 0x38, 0x38, 0x2e, 0x39, 0x2e, 0x1f,
	0x37, 0x3a, 0x27, 0x3b, 0x2b, 0x20, 0x29, 0x34,
	0x26, 0x37, 0x25, 0x23, 0x27, 0x2b, 0x2c, 0x22,
	// Entry 80 - BF
	0x2f, 0x2c, 0x2c, 0x25, 0x26, 0x39, 0x21, 0x33,
	0x3b, 0x2c, 0x27, 0x35, 0x21, 0x33, 0x39, 0x25,
	0x2d, 0x20, 0x38, 0x30, 0x37, 0x23, 0x2b, 0x24,
	0x21, 0x23, 0x24, 0x2b, 0x39, 0x2b, 0x25, 0x23,
	0x35, 0x20, 0x2e, 0x3c, 0x30, 0x3b, 0x2e, 0x25,
	0x35, 0x35, 0x23, 0x25, 0x3c, 0x30, 0x23, 0x25,
	0x34, 0x24, 0x2c, 0x31, 0x37, 0x29, 0x37, 0x38,
	0x38, 0x34, 0x32, 0x22, 0x25, 0x2e, 0x3b, 0x20,
	// Entry C0 - FF
	0x22, 0x2c, 0x30, 0x35, 0x35, 0x3b, 0x25, 0x2c,
	0x25, 0x39, 0x2e, 0x24, 0x2e, 0x33, 0x30, 0x2e,
	0x31, 0x3a, 0x2c, 0x2a, 0x2c, 0x20, 0x33, 0x29,
	0x2b, 0x24, 0x20, 0x3b, 0x23, 0x28, 0x2a, 0x23,
	0x33, 0x20, 0x27, 0x28, 0x3a, 0x30, 0x24, 0x2d,
	0x2f, 0x28, 0x25, 0x23, 0x39, 0x20, 0x3b, 0x27,
	0x20, 0x23, 0x20, 0x20, 0x1e, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	// Entry 100 - 13F
	0x2e, 0x20, 0x2d, 0x22, 0x32, 0x2e, 0x23, 0x3a,
	0x2e, 0x38, 0x37, 0x30, 0x2c, 0x39, 0x2b, 0x2d,
	0x2c, 0x22, 0x2c, 0x2e, 0x27, 0x2e, 0x26, 0x32,
	0x33, 0x25, 0x23, 0x31, 0x21, 0x25, 0x26, 0x21,
	0x2c, 0x30, 0x3c, 0x28, 0x30, 0x3c, 0x38, 0x28,
	0x30, 0x23, 0x25, 0x28, 0x35, 0x2e, 0x32, 0x2e,
	0x20, 0x21, 0x2f, 0x27, 0x3c, 0x22, 0x25, 0x20,
	0x27, 0x25, 0x25, 0x30, 0x3a, 0x28, 0x20, 0x28,
	// Entry 140 - 17F
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x23, 0x23, 0x2e, 0x22, 0x31, 0x2e,
	0x26, 0x2e, 0x20,
}

// regionInclusionBits is an array of bit vectors where every vector represents
// a set of region groupings.  These sets are used to compute the distance
// between two regions for the purpose of language matching.
// Size: 288 bytes, 72 elements
var regionInclusionBits = [72]uint32{
	// Entry 0 - 1F
	0x82400813, 0x000007a3, 0x00003844, 0x20000808,
	0x403c0011, 0x00000022, 0x20000844, 0x00000082,
	0x00000102, 0x00000202, 0x00000402, 0x2000384d,
	0x00001804, 0x20002804, 0x00404000, 0x00408000,
	0x00410000, 0x02020000, 0x00040010, 0x00080010,
	0x00100010, 0x00200010, 0x01c1c001, 0x00c00000,
	0x01400000, 0x1e020001, 0x06000000, 0x0a000000,
	0x12000000, 0x20002848, 0x40000010, 0x80000001,
	// Entry 20 - 3F
	0x00000001, 0x40000000, 0x00020000, 0x01000000,
	0x00008000, 0x00002000, 0x00000200, 0x00000008,
	0x00200000, 0x90000000, 0x00040000, 0x08000000,
	0x00000020, 0x84000000, 0x00000080, 0x00001000,
	0x00010000, 0x00000400, 0x04000000, 0x00000040,
	0x10000000, 0x00004000, 0x81000000, 0x88000000,
	0x00000100, 0x80020000, 0x00080000, 0x00100000,
	0x00800000, 0xffffffff, 0x82400fb3, 0xc27c0813,
	// Entry 40 - 5F
	0xa240385f, 0x83c1c813, 0x9e420813, 0x92000001,
	0x86000001, 0x81400001, 0x8a000001, 0x82020001,
}

// regionInclusionNext marks, for each entry in regionInclusionBits, the set of
// all groups that are reachable from the groups set in the respective entry.
// Size: 72 bytes, 72 elements
var regionInclusionNext = [72]uint8{
	// Entry 0 - 3F
	0x3d, 0x3e, 0x0b, 0x0b, 0x3f, 0x01, 0x0b, 0x01,
	0x01, 0x01, 0x01, 0x40, 0x0b, 0x0b, 0x16, 0x16,
	0x16, 0x19, 0x04, 0x04, 0x04, 0x04, 0x41, 0x16,
	0x16, 0x42, 0x19, 0x19, 0x19, 0x0b, 0x04, 0x00,
	0x00, 0x1e, 0x11, 0x18, 0x0f, 0x0d, 0x09, 0x03,
	0x15, 0x43, 0x12, 0x1b, 0x05, 0x44, 0x07, 0x0c,
	0x10, 0x0a, 0x1a, 0x06, 0x1c, 0x0e, 0x45, 0x46,
	0x08, 0x47, 0x13, 0x14, 0x17, 0x3d, 0x3d, 0x3d,
	// Entry 40 - 7F
	0x3d, 0x3d, 0x3d, 0x42, 0x42, 0x41, 0x42, 0x42,
}

type parentRel struct {
	lang       uint16
	script     uint8
	maxScript  uint8
	toRegion   uint16
	fromRegion []uint16
}

// Size: 412 bytes, 5 elements
var parents = [5]parentRel{
	0: {lang: 0x9b, script: 0x0, maxScript: 0x52, toRegion: 0x1, fromRegion: []uint16{0x1a, 0x24, 0x25, 0x2e, 0x33, 0x35, 0x3c, 0x41, 0x45, 0x47, 0x48, 0x49, 0x4f, 0x51, 0x5b, 0x5c, 0x60, 0x63, 0x6c, 0x71, 0x72, 0x73, 0x79, 0x7a, 0x7d, 0x7e, 0x7f, 0x81, 0x8a, 0x8b, 0x94, 0x95, 0x96, 0x97, 0x98, 0x9d, 0x9e, 0xa2, 0xa5, 0xa7, 0xab, 0xaf, 0xb2, 0xb3, 0xbd, 0xc4, 0xc8, 0xc9, 0xca, 0xcc, 0xce, 0xd0, 0xd3, 0xd4, 0xdb, 0xdd, 0xde, 0xe4, 0xe5, 0xe6, 0xe9, 0xee, 0x105, 0x107, 0x108, 0x109, 0x10b, 0x10c, 0x110, 0x115, 0x119, 0x11b, 0x11d, 0x123, 0x127, 0x12a, 0x12b, 0x12d, 0x12f, 0x136, 0x139, 0x13c, 0x13f, 0x15e, 0x15f, 0x161}},
	1: {lang: 0x9b, script: 0x0, maxScript: 0x52, toRegion: 0x1a, fromRegion: []uint16{0x2d, 0x4d, 0x5f, 0x62, 0x70, 0xd7, 0x10a, 0x10d}},
	2: {lang: 0x9d, script: 0x0, maxScript: 0x52, toRegion: 0x1e, fromRegion: []uint16{0x2b, 0x3e, 0x40, 0x50, 0x53, 0x55, 0x58, 0x64, 0x68, 0x87, 0x8d, 0xcd, 0xd6, 0xe0, 0xe2, 0xea, 0xef, 0x118, 0x132, 0x133, 0x138}},
	3: {lang: 0x1ef, script: 0x0, maxScript: 0x52, toRegion: 0xec, fromRegion: []uint16{0x29, 0x4d, 0x59, 0x84, 0x89, 0xb5, 0xc4, 0xcf, 0x116, 0x124}},
	4: {lang: 0x2c4, script: 0x35, maxScript: 0x35, toRegion: 0x8b, fromRegion: []uint16{0xc4}},
}

// Total table size 20315 bytes (19KiB); checksum: C16EF251
