// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/image/v1"
	scheme "github.com/openshift/client-go/image/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	rest "k8s.io/client-go/rest"
)

// ImageTagsGetter has a method to return a ImageTagInterface.
// A group's client should implement this interface.
type ImageTagsGetter interface {
	ImageTags(namespace string) ImageTagInterface
}

// ImageTagInterface has methods to work with ImageTag resources.
type ImageTagInterface interface {
	Create(*v1.ImageTag) (*v1.ImageTag, error)
	Update(*v1.ImageTag) (*v1.ImageTag, error)
	Delete(name string, options *metav1.DeleteOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ImageTag, error)
	List(opts metav1.ListOptions) (*v1.ImageTagList, error)
	ImageTagExpansion
}

// imageTags implements ImageTagInterface
type imageTags struct {
	client rest.Interface
	ns     string
}

// newImageTags returns a ImageTags
func newImageTags(c *ImageV1Client, namespace string) *imageTags {
	return &imageTags{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the imageTag, and returns the corresponding imageTag object, and an error if there is any.
func (c *imageTags) Get(name string, options metav1.GetOptions) (result *v1.ImageTag, err error) {
	result = &v1.ImageTag{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("imagetags").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ImageTags that match those selectors.
func (c *imageTags) List(opts metav1.ListOptions) (result *v1.ImageTagList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ImageTagList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("imagetags").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Create takes the representation of a imageTag and creates it.  Returns the server's representation of the imageTag, and an error, if there is any.
func (c *imageTags) Create(imageTag *v1.ImageTag) (result *v1.ImageTag, err error) {
	result = &v1.ImageTag{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("imagetags").
		Body(imageTag).
		Do().
		Into(result)
	return
}

// Update takes the representation of a imageTag and updates it. Returns the server's representation of the imageTag, and an error, if there is any.
func (c *imageTags) Update(imageTag *v1.ImageTag) (result *v1.ImageTag, err error) {
	result = &v1.ImageTag{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("imagetags").
		Name(imageTag.Name).
		Body(imageTag).
		Do().
		Into(result)
	return
}

// Delete takes name of the imageTag and deletes it. Returns an error if one occurs.
func (c *imageTags) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("imagetags").
		Name(name).
		Body(options).
		Do().
		Error()
}
