// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (210B)
// assets/dns/configmap.yaml (390B)
// assets/dns/daemonset.yaml (4.302kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (381B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\x8d\xbd\x6e\xc5\x30\x08\x46\x77\x3f\x05\xba\x7b\x52\x75\xab\xbc\x76\xe8\xde\xa1\x3b\xd7\xa6\x0a\x8a\x03\x16\xe0\x54\xea\xd3\x5f\xe5\x67\x3b\xe7\x08\xf4\xad\x2c\x35\xc3\x67\x1b\x1e\x64\xdf\xda\x28\x61\xe7\x1f\x32\x67\x95\x0c\xf6\xc4\x32\xe3\x88\x45\x8d\xff\x31\x58\x65\x5e\x3f\x7c\x66\x7d\xdb\xdf\xd3\x46\x81\x15\x03\x73\x02\x10\xdc\x28\x83\x76\x12\x5f\xf8\x37\xa6\x2a\x9e\x6c\x34\xf2\x9c\x26\xc0\xce\x5f\xa6\xa3\xfb\x71\x39\xc1\xe3\x91\x00\x8c\x5c\x87\x15\xba\x1b\x49\xed\xca\x12\x7e\x9a\x93\xed\x5c\xe8\x92\xae\xf5\x82\x63\xc3\x3b\x5e\x7d\x27\x7b\xde\xbf\x8d\x3d\x4e\xf8\xc3\x28\x4b\x7a\x05\x00\x00\xff\xff\xcb\xdd\xd7\x2a\xd2\x00\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 210, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x37, 0xb2, 0x0, 0x7d, 0x4a, 0xd9, 0xf, 0x8, 0x44, 0xe7, 0xab, 0x82, 0xe4, 0x50, 0x94, 0xaa, 0x4e, 0xfd, 0xa0, 0x63, 0xba, 0x18, 0xcf, 0xeb, 0xa6, 0xe4, 0x2d, 0x4, 0x35, 0xd5, 0xc7, 0xd}}
	return a, nil
}

var _assetsDnsConfigmapYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x8c\x4f\x4b\x33\x31\x18\xc4\xef\xfb\x29\x06\xde\xf3\xbb\xb5\x2c\x2b\xb8\xd7\x9e\xbd\x7a\x7f\x4c\x66\x9b\xd0\x6c\x12\x9e\x24\x45\x51\xbf\xbb\xb4\x85\x68\xc1\x39\xcd\x3f\x7e\x27\x1f\xed\x82\x43\x8a\xab\x3f\x3e\x4b\x1e\x24\xfb\x17\x6a\xf1\x29\x2e\x38\xef\x87\x7f\x88\xb2\x11\x12\xed\xd5\x94\x2c\x86\x10\x25\x0a\x2b\xa4\x42\x5b\xac\x7e\xe3\x60\xa5\xca\x32\x00\x87\xa4\x5c\x7d\xe0\x82\xcf\x01\x00\xc6\x65\x9e\xe6\x09\x1f\xd7\x70\x11\x55\x93\x96\x1e\x1d\x25\x54\xd7\xe3\xa9\xbd\x52\x23\x2b\x0b\x4c\x68\xa5\x52\xc7\x90\x8c\x04\xf8\xf8\x5f\xac\xd5\x51\x34\x0b\x7c\x7e\xbc\x99\x1f\xec\x45\x39\xd9\x02\x1f\x0b\x4d\x53\xde\x2d\x2d\x97\xaa\x94\xed\xae\x5c\x25\x84\xea\x34\xb5\xa3\xfb\x1b\xdf\xdf\x5f\xdd\x65\x4d\x1b\xab\x63\x2b\x58\x9e\xf6\xf3\xf4\x7b\x78\x7b\xc7\x88\x1d\xab\xd9\x29\x4b\x0a\xe7\xd1\xa4\xb8\xf6\x83\x11\xe3\x88\xe9\xa1\x17\xca\x90\xc4\x0e\x37\xfe\x77\x00\x00\x00\xff\xff\xef\xe8\x25\x0a\x86\x01\x00\x00")

func assetsDnsConfigmapYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsConfigmapYaml,
		"assets/dns/configmap.yaml",
	)
}

func assetsDnsConfigmapYaml() (*asset, error) {
	bytes, err := assetsDnsConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/configmap.yaml", size: 390, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x60, 0x35, 0x3d, 0x20, 0x71, 0xe4, 0x2d, 0x28, 0xd6, 0xac, 0xd6, 0xef, 0x59, 0x0, 0x1, 0x68, 0xee, 0x6, 0x5b, 0xde, 0x33, 0x4d, 0xdf, 0xf1, 0x31, 0xbd, 0x16, 0xd1, 0xfc, 0xec, 0x7e, 0x62}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x57\x5f\x6f\xe3\xb8\x11\x7f\xf7\xa7\x98\x93\x83\xcd\x2e\x1a\x25\x4e\x0f\x7b\xbd\x6a\x37\xd7\x4b\x13\xa7\x1b\xf4\x9c\x18\xb1\xf7\xfa\x10\x04\x0b\x9a\x1a\x59\x6c\x28\x92\x47\x8e\xe4\x35\xb2\xf9\xee\x05\xa5\xc8\xa6\x64\x37\x8b\x02\xcd\x43\x6c\x73\x86\x3f\xce\xbf\xdf\x70\xf8\x28\x54\x9a\xc0\x25\xc3\x42\xab\x19\xd2\x80\x19\xf1\x3b\x5a\x27\xb4\x4a\x80\x19\xe3\x4e\xaa\xd3\xc1\x10\x14\x2b\xf0\xa8\xfe\xef\x0c\xe3\x08\x4c\xa5\x20\xd9\x02\xa5\x03\x66\x11\x1c\x12\x30\x02\x5b\x2a\x12\x05\x0e\x9c\x41\x9e\x0c\x00\x08\x0b\x23\x19\xa1\xff\x0e\xd0\xae\xd6\xdf\xd1\x56\x82\xe3\x39\xe7\xba\x54\x74\xc3\x0a\x4c\x20\x55\xee\x45\x6a\xac\xd0\x56\xd0\xfa\x42\x32\xe7\x1a\xa1\x5b\x3b\xc2\x22\x56\x3a\xc5\x98\x5b\x41\x82\x33\xf9\xa2\xcd\xb5\x22\x26\x14\x5a\xd7\xa2\xc7\xb5\xa5\x21\x22\xc0\x10\x44\xc1\x96\x08\xc2\xf5\xad\x6d\x35\x6a\xf9\xb4\x94\x72\xaa\xa5\xe0\xeb\x04\xae\xb3\x1b\x4d\x53\x8b\x0e\x15\x6d\xb4\xb8\x2e\x0a\xe6\x43\x76\x0f\x11\xd7\x16\x53\xe5\x22\x78\xd8\x88\x99\x5d\xba\x5a\x16\x73\xad\xb2\xe8\x08\xa2\x13\x24\x7e\xf2\xa2\x79\x72\xa1\x2d\x66\x42\x62\xb8\xa5\xd2\xb2\x2c\x70\xe2\x03\xb1\xf1\x60\xeb\x83\x87\x11\xcb\xb8\x51\xda\x48\x01\x0a\xaf\x3f\x65\x94\x27\x10\x9e\x10\x68\x58\x64\xe9\xad\x92\xeb\x04\xc8\x96\xdb\xad\x46\xdb\xee\x39\x9b\xf8\x4d\xb5\xa5\x04\xde\xff\xf8\xfe\xc7\x00\x65\x37\x92\x3e\x3f\x9a\x34\xd7\x32\x81\xcf\x97\xd3\xff\x1d\x29\x26\x6e\xf6\xa2\xcd\x2f\x5e\x41\xfb\xeb\xe9\x1e\xb4\x02\xc9\x0a\xbe\xdf\xb6\x10\x4d\x8a\x0a\x15\x3a\x37\xb5\x7a\x81\x49\xa0\x9e\x13\x99\x7f\x20\x85\x4b\x00\xa6\x09\x6b\x8e\x4c\x52\xde\x95\xd4\xa6\xfc\x3c\xfa\x79\xd4\x59\x76\x3c\x47\x6f\xce\xa7\xf9\x7c\x1a\x08\x84\x12\x24\x98\xbc\x44\xc9\xd6\x33\xe4\x5a\xa5\x2e\x81\x9f\xc2\xad\xbe\x00\x75\x49\x1b\xe1\xfb\x40\xe6\x4a\xce\xd1\xb9\x79\x6e\xd1\xe5\x5a\xa6\x09\x9c\x06\xd2\x8c\x09\x59\x5a\x0c\xa4\xdb\xbd\x16\x9d\x2e\x2d\x47\x17\xba\x25\x45\x21\xc8\x75\x1d\x2d\xb0\xd0\x76\x9d\xc0\xfb\xd3\x3f\x4f\x44\xa7\x74\xfe\x28\xd1\xf5\xb5\xb9\x29\x13\x38\x1d\x8d\x8a\xbd\x18\x7f\x19\x6d\x20\x02\xfe\x35\x8c\xf5\x06\xc9\x0a\xed\xff\x9d\x8d\x0e\x79\x59\x77\x0a\xad\x08\xbf\x76\xd2\x68\xac\xa8\x84\xc4\x25\xa6\x3d\x02\xbc\xce\xb7\x5c\x3b\x72\xb1\xe7\xe8\x2b\x64\xab\x95\x02\x67\x50\x55\x70\x73\x3e\x19\xcf\xc6\x77\xbf\x8f\xef\xea\xee\x78\xf1\xdb\xe7\xd9\x7c\x7c\xf7\xe5\xf2\x76\x72\x7e\x7d\xb3\xaf\x4b\xb6\xdb\x51\x55\xbb\x66\x78\xa4\xeb\x8b\xf1\x2c\x30\x62\x08\x17\xbe\xf7\x80\xb6\xd0\x34\x61\x87\x86\x59\x46\x98\x82\x14\x8e\x40\x67\x6d\x5b\x75\x9d\x5d\x37\xb7\xf3\x71\x02\x57\xda\x82\xd2\xab\x23\x40\xe5\x4a\x8b\x40\x39\x3a\xac\xcd\xb2\x28\x19\x89\x0a\x9b\xf6\xfe\x01\x32\x6d\x01\x19\xcf\xbb\x82\xa3\x0e\x26\x53\xc0\xa4\x60\x0e\x56\x82\x72\x8f\xd5\xf7\xd7\x95\x59\x26\xbe\xc2\x4a\x48\x09\x4c\x3a\x0d\x0b\x04\x96\xa6\x98\x1e\x07\x38\x15\x93\x25\x26\x10\xd5\xb9\x8e\x2d\x2e\x85\x23\xbb\x3e\xd6\x06\x95\xcb\x45\x46\x71\x4f\xe0\x2a\x1e\xed\x34\xe2\x20\x74\x27\x0b\xa1\x4e\x16\xcc\xe5\xc1\x5a\xcc\x83\x1f\xdf\x42\x27\x7e\xd8\x55\x87\x3a\x47\x71\xa9\xc1\x08\x83\x9e\x62\x83\x90\xac\x96\x19\x38\x7c\xf4\x2e\x1d\xbc\xfd\xb7\x5e\x38\x88\xcd\xbb\x0f\x80\x5f\x05\xc1\xe8\x10\xe6\xe3\xbb\x49\xa8\x7e\x3b\x1d\xdf\xcc\x3e\x5d\x5f\xcd\xbf\x4c\xce\xef\xfe\x39\xbe\x3b\x8b\xb6\x8e\x2d\x51\x61\x9d\xba\x2e\x3f\xa2\x60\xfb\xa7\xdb\xd9\x7c\xf6\xe5\xea\xfa\xb7\xf1\x59\xb4\x2d\xba\x50\x63\x3e\x9e\x4c\x77\x14\x8e\xa9\x30\x51\x68\xc6\xf5\xd5\xec\xec\xf0\x08\x0e\xeb\xfb\x00\x62\x0b\x31\xdb\xd4\x09\x7c\xfc\xf8\x11\xa2\x83\xa7\xb6\xda\x9e\x3b\x3b\x87\x30\x61\x8f\x08\xac\xbe\xc7\xb5\x65\x76\x0d\x9e\x17\xdb\x9c\x6b\x99\x36\x7c\xa9\xd7\x0f\x1d\x30\x22\x2b\x16\x25\xa1\x0b\xd3\xcc\x0d\xc4\x19\xc4\xf1\x56\x1a\x6b\x25\xd7\xfe\xe0\xad\x93\xcf\x91\xff\xbd\x71\xa9\x6b\xc9\x2a\xf7\xe7\x7a\x16\x7f\x80\x54\x77\xda\x4f\x8a\x5c\xfa\x2a\x8e\xcf\xc1\x55\xfc\x8b\x30\xae\x23\xf6\xc5\xec\x2a\x0e\x42\x79\xf8\xd6\xef\xfb\x5f\x1f\x9e\xa3\x1d\x28\xef\xf1\x15\x12\xcf\xdb\xf8\xc0\xf5\x14\x32\xab\x0b\xe0\xb2\x74\x84\xd6\x37\x34\x10\x19\x98\x5e\x17\x6a\xfe\x84\x71\x67\x6f\x0f\xde\xa6\x62\x09\xbf\x46\x07\x4f\xdb\x7e\xf0\x1c\xc1\x9f\x5c\xae\x2d\xd5\x26\x54\xfc\xf9\xf8\xe0\xa9\x4b\x97\xe7\xe8\xdd\xbb\x41\x1f\x2e\x83\xfb\x7b\x88\x0e\xfe\x16\x41\x8c\x7f\xc0\x08\xde\xbc\xf1\xfb\x87\xc2\x34\xe6\x43\xac\x10\x46\xf0\xf0\xf0\xc1\xe7\x42\xf5\x76\x43\x1b\x8d\xfb\x97\x33\xa3\x87\xb3\xe8\xe0\xa9\xdd\xdc\xd3\xce\x44\x37\xa6\x5a\x61\xd7\x9c\x21\x7c\x36\x29\x23\x0c\xda\x1f\xd4\x39\x14\x19\xac\x10\x96\x48\x9e\xcc\x22\x0d\x22\xe7\x7a\x00\xff\xc2\xa6\x1b\x28\x4d\x50\xee\x80\xad\x72\x54\xde\x0f\x5b\xdf\x09\x2f\xc3\xcc\x06\x4d\x97\xe4\x6f\x0b\x6d\x81\x19\x01\xa5\x62\x15\x13\x92\x2d\x84\x14\xb4\xee\x1d\x33\x23\x26\x11\x50\x91\x15\xe8\x81\x4a\x99\x7a\x86\x3a\xf2\x25\x10\x1c\x28\xb2\xba\x84\xdb\x13\x84\x83\x14\x25\x12\xa6\x83\x7d\x49\x78\x1a\xb6\xe1\xfc\x7e\xe8\x87\xf0\xf7\x52\xc8\x14\x18\x28\x5c\x05\xfc\x68\x4a\x29\xf4\xd9\xf3\x48\x97\x16\x78\xe9\x48\x17\x1b\xa3\x33\x21\x09\x2d\xa6\xde\xed\x1e\xf6\xd2\xa2\x81\xb8\x82\x68\x08\x07\x4f\xfd\x06\xd3\x50\xa8\x43\xa9\x5f\x5e\x21\x55\x63\xeb\xb9\x31\xa8\x52\x68\x3b\xd0\xd6\x08\x4f\x9c\xdd\xeb\x04\x76\x38\xf5\x43\x18\x99\x3d\x9c\x6a\xf4\x85\xf1\xea\x75\x29\xd6\xca\x4d\x51\x3e\x3c\xef\xdd\x00\x80\x3c\xd7\x50\xd7\xeb\x73\xb3\xa9\xfd\xd8\xa5\x0e\xfc\x97\x50\xfc\xb2\xe3\x7b\xff\x90\xba\xcc\xf7\x2c\xed\xc4\x68\x7e\x7b\x79\x9b\xec\x61\x00\x23\x5d\xf8\x87\x88\x5c\x03\x69\x60\x95\x16\x29\x30\xb5\x06\xa1\xb8\x56\x4e\x38\x42\x45\xb0\xc0\x9c\x55\x42\xdb\x1d\xd4\x3b\x34\xd2\x5f\xe3\xfb\x2a\xa2\xd0\xa9\xc8\x04\xa6\x50\x35\x6f\x31\x5f\x88\x0a\x31\xed\x95\x27\x00\x2f\x4c\xcf\xcd\x9d\x1a\xf8\xf6\xed\xa5\x03\xbf\xae\xb7\xeb\x75\xab\xeb\xc9\xe1\x59\x6b\xb1\xd0\x15\xa6\x5b\x5f\xeb\xaa\xe6\x16\x19\xe1\x49\xc3\x9e\x7a\xf4\xd9\xf6\x79\xe0\xda\xac\x81\xe7\xa5\xed\x92\xa4\xd7\x6f\x9c\x44\x34\xf0\xd3\x08\xde\xc0\x8a\x89\x6e\xcd\x97\xca\x5f\xc9\xbb\xad\xbd\x93\xbc\xbd\x03\xef\xab\x43\x6c\x3b\xc3\xa6\xca\xb5\x03\xe6\x25\x66\xac\x94\xed\xe9\xfe\x5e\x9e\xa1\x44\x4e\xda\x6e\x11\x16\x48\xec\xf8\xb1\x5c\xa0\x55\xe8\x6f\x39\xa1\x4f\xb4\x4b\x40\x0a\x55\x7e\x6d\x34\x5e\x54\x9b\x21\x73\x7b\xf6\x77\x9e\x73\xcd\xf2\x84\x99\xc0\xd8\x21\xf8\xa7\xef\x2b\x23\xb2\xef\x4f\x84\x45\xd7\xc1\x18\x1e\x71\x9d\x40\xfb\xd0\xec\x66\xb5\x79\xd8\xf4\x65\xaf\x8d\xbe\x7e\xad\x1e\x7c\x07\x3b\x30\x7b\x26\x61\x3f\x24\xad\x0d\x26\x70\xb5\x05\x21\x2d\xfd\xa8\x23\xb4\xda\x18\x3a\x6c\x17\x11\x98\x94\xe0\x5f\x79\xe4\xc0\x69\xa0\x9c\x11\x5c\xde\xcc\xbc\xd3\x4c\xae\xd8\xda\xb5\x77\x2d\x68\x55\xeb\xfa\xb4\xb8\xcd\x33\x43\x1b\x8f\xa2\x6d\x02\x63\xdf\xe2\xdd\xe0\x3f\x01\x00\x00\xff\xff\x02\xd7\x8f\xdd\xce\x10\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 4302, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x66, 0x9, 0x9a, 0x9e, 0x45, 0x7e, 0x37, 0xa8, 0x5d, 0xa2, 0x8e, 0xca, 0xf1, 0xcd, 0xb5, 0xd1, 0xd6, 0x2b, 0xe0, 0xa, 0x7d, 0x73, 0x6, 0xbc, 0xc8, 0x46, 0xe1, 0x50, 0x5, 0x93, 0xad, 0xd1}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\xce\x3d\x4b\x04\x31\x10\xc6\xf1\x3e\x9f\xe2\x81\x6b\x3d\xe1\x10\x0b\xd3\x6a\x63\xb7\xe0\x4b\x3f\x97\x1d\x8e\xe0\xe4\x85\x99\xd9\x13\xbf\xbd\x18\xe1\xdc\x15\xc1\x26\x90\xe4\xcf\x8f\xe7\x2d\xd7\x39\xe2\x89\xf5\x9c\x13\x07\xea\xf9\x95\xd5\x72\xab\x11\xe7\x43\xd8\xa1\x52\xe1\xab\x71\x5a\xa7\xc4\xa0\x3a\x43\xe8\xc8\x62\x20\x65\x18\x3b\xc8\xa1\x4b\xf5\x5c\x38\x58\xe7\x14\x03\xb0\x43\x92\xc5\x9c\xf5\x71\xc2\x7b\x16\xc1\x91\x41\x8b\xb7\x42\x9e\x13\x89\x7c\xa0\x50\xa5\x13\xcf\xd7\x23\x36\x16\x4e\xde\x14\xd9\x7e\x8b\x40\x6f\xea\xf6\x85\xee\xc7\x8c\x88\xb9\x5a\x00\xbe\x3f\x22\x6e\x6f\xc6\xc5\x49\x4f\xec\xd3\x78\xba\x04\xda\xbc\xa5\x26\x11\x2f\x0f\xd3\x16\xd8\x7b\xea\xff\x22\x3f\xd1\x05\x7a\xbe\x5f\x43\x85\x5d\x73\x5a\xaf\xb9\x3b\xfc\x41\x6d\xb2\x0d\xf5\x19\x00\x00\xff\xff\xc5\xcb\x88\xa8\x7d\x01\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 381, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xa9, 0x6d, 0x77, 0x15, 0x61, 0x5f, 0x22, 0x3d, 0xd7, 0x33, 0xf2, 0xcf, 0xe0, 0xbd, 0x5d, 0xc6, 0xf1, 0x17, 0x84, 0xff, 0x81, 0xdb, 0x33, 0xd0, 0x30, 0x3b, 0xe3, 0x8e, 0x8e, 0x39, 0x8d, 0x48}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/configmap.yaml": assetsDnsConfigmapYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"configmap.yaml":            {assetsDnsConfigmapYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
