// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateActivity = "CreateActivity"

// CreateActivityRequest generates a "aws/request.Request" representing the
// client's request for the CreateActivity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActivity for more information on using the CreateActivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateActivityRequest method.
//    req, resp := client.CreateActivityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity
func (c *SFN) CreateActivityRequest(input *CreateActivityInput) (req *request.Request, output *CreateActivityOutput) {
	op := &request.Operation{
		Name:       opCreateActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActivityInput{}
	}

	output = &CreateActivityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActivity API operation for AWS Step Functions.
//
// Creates an activity. An activity is a task that you write in any programming
// language and host on any machine that has access to AWS Step Functions. Activities
// must poll Step Functions using the GetActivityTask API action and respond
// using SendTask* API actions. This function lets Step Functions know the existence
// of your activity and returns an identifier for use in a state machine and
// when polling from the activity.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation CreateActivity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeActivityLimitExceeded "ActivityLimitExceeded"
//   The maximum number of activities has been reached. Existing activities must
//   be deleted before a new activity can be created.
//
//   * ErrCodeInvalidName "InvalidName"
//   The provided name is invalid.
//
//   * ErrCodeTooManyTags "TooManyTags"
//   You've exceeded the number of tags allowed for a resource. See the Limits
//   Topic (https://docs.aws.amazon.com/step-functions/latest/dg/limits.html)
//   in the AWS Step Functions Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity
func (c *SFN) CreateActivity(input *CreateActivityInput) (*CreateActivityOutput, error) {
	req, out := c.CreateActivityRequest(input)
	return out, req.Send()
}

// CreateActivityWithContext is the same as CreateActivity with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) CreateActivityWithContext(ctx aws.Context, input *CreateActivityInput, opts ...request.Option) (*CreateActivityOutput, error) {
	req, out := c.CreateActivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStateMachine = "CreateStateMachine"

// CreateStateMachineRequest generates a "aws/request.Request" representing the
// client's request for the CreateStateMachine operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStateMachine for more information on using the CreateStateMachine
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStateMachineRequest method.
//    req, resp := client.CreateStateMachineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine
func (c *SFN) CreateStateMachineRequest(input *CreateStateMachineInput) (req *request.Request, output *CreateStateMachineOutput) {
	op := &request.Operation{
		Name:       opCreateStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStateMachineInput{}
	}

	output = &CreateStateMachineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStateMachine API operation for AWS Step Functions.
//
// Creates a state machine. A state machine consists of a collection of states
// that can do work (Task states), determine to which states to transition next
// (Choice states), stop an execution with an error (Fail states), and so on.
// State machines are specified using a JSON-based, structured language.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation CreateStateMachine for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidDefinition "InvalidDefinition"
//   The provided Amazon States Language definition is invalid.
//
//   * ErrCodeInvalidName "InvalidName"
//   The provided name is invalid.
//
//   * ErrCodeStateMachineAlreadyExists "StateMachineAlreadyExists"
//   A state machine with the same name but a different definition or role ARN
//   already exists.
//
//   * ErrCodeStateMachineDeleting "StateMachineDeleting"
//   The specified state machine is being deleted.
//
//   * ErrCodeStateMachineLimitExceeded "StateMachineLimitExceeded"
//   The maximum number of state machines has been reached. Existing state machines
//   must be deleted before a new state machine can be created.
//
//   * ErrCodeTooManyTags "TooManyTags"
//   You've exceeded the number of tags allowed for a resource. See the Limits
//   Topic (https://docs.aws.amazon.com/step-functions/latest/dg/limits.html)
//   in the AWS Step Functions Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateStateMachine
func (c *SFN) CreateStateMachine(input *CreateStateMachineInput) (*CreateStateMachineOutput, error) {
	req, out := c.CreateStateMachineRequest(input)
	return out, req.Send()
}

// CreateStateMachineWithContext is the same as CreateStateMachine with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStateMachine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) CreateStateMachineWithContext(ctx aws.Context, input *CreateStateMachineInput, opts ...request.Option) (*CreateStateMachineOutput, error) {
	req, out := c.CreateStateMachineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActivity = "DeleteActivity"

// DeleteActivityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActivity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActivity for more information on using the DeleteActivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteActivityRequest method.
//    req, resp := client.DeleteActivityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity
func (c *SFN) DeleteActivityRequest(input *DeleteActivityInput) (req *request.Request, output *DeleteActivityOutput) {
	op := &request.Operation{
		Name:       opDeleteActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteActivityInput{}
	}

	output = &DeleteActivityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteActivity API operation for AWS Step Functions.
//
// Deletes an activity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DeleteActivity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteActivity
func (c *SFN) DeleteActivity(input *DeleteActivityInput) (*DeleteActivityOutput, error) {
	req, out := c.DeleteActivityRequest(input)
	return out, req.Send()
}

// DeleteActivityWithContext is the same as DeleteActivity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DeleteActivityWithContext(ctx aws.Context, input *DeleteActivityInput, opts ...request.Option) (*DeleteActivityOutput, error) {
	req, out := c.DeleteActivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStateMachine = "DeleteStateMachine"

// DeleteStateMachineRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStateMachine operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStateMachine for more information on using the DeleteStateMachine
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStateMachineRequest method.
//    req, resp := client.DeleteStateMachineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine
func (c *SFN) DeleteStateMachineRequest(input *DeleteStateMachineInput) (req *request.Request, output *DeleteStateMachineOutput) {
	op := &request.Operation{
		Name:       opDeleteStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStateMachineInput{}
	}

	output = &DeleteStateMachineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStateMachine API operation for AWS Step Functions.
//
// Deletes a state machine. This is an asynchronous operation: It sets the state
// machine's status to DELETING and begins the deletion process. Each state
// machine execution is deleted the next time it makes a state transition.
//
// The state machine itself is deleted after all executions are completed or
// deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DeleteStateMachine for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine
func (c *SFN) DeleteStateMachine(input *DeleteStateMachineInput) (*DeleteStateMachineOutput, error) {
	req, out := c.DeleteStateMachineRequest(input)
	return out, req.Send()
}

// DeleteStateMachineWithContext is the same as DeleteStateMachine with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStateMachine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DeleteStateMachineWithContext(ctx aws.Context, input *DeleteStateMachineInput, opts ...request.Option) (*DeleteStateMachineOutput, error) {
	req, out := c.DeleteStateMachineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActivity = "DescribeActivity"

// DescribeActivityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActivity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActivity for more information on using the DescribeActivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActivityRequest method.
//    req, resp := client.DescribeActivityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity
func (c *SFN) DescribeActivityRequest(input *DescribeActivityInput) (req *request.Request, output *DescribeActivityOutput) {
	op := &request.Operation{
		Name:       opDescribeActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActivityInput{}
	}

	output = &DescribeActivityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActivity API operation for AWS Step Functions.
//
// Describes an activity.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DescribeActivity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeActivityDoesNotExist "ActivityDoesNotExist"
//   The specified activity does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeActivity
func (c *SFN) DescribeActivity(input *DescribeActivityInput) (*DescribeActivityOutput, error) {
	req, out := c.DescribeActivityRequest(input)
	return out, req.Send()
}

// DescribeActivityWithContext is the same as DescribeActivity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DescribeActivityWithContext(ctx aws.Context, input *DescribeActivityInput, opts ...request.Option) (*DescribeActivityOutput, error) {
	req, out := c.DescribeActivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExecution = "DescribeExecution"

// DescribeExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExecution for more information on using the DescribeExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExecutionRequest method.
//    req, resp := client.DescribeExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution
func (c *SFN) DescribeExecutionRequest(input *DescribeExecutionInput) (req *request.Request, output *DescribeExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExecutionInput{}
	}

	output = &DescribeExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExecution API operation for AWS Step Functions.
//
// Describes an execution.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DescribeExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionDoesNotExist "ExecutionDoesNotExist"
//   The specified execution does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeExecution
func (c *SFN) DescribeExecution(input *DescribeExecutionInput) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	return out, req.Send()
}

// DescribeExecutionWithContext is the same as DescribeExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DescribeExecutionWithContext(ctx aws.Context, input *DescribeExecutionInput, opts ...request.Option) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStateMachine = "DescribeStateMachine"

// DescribeStateMachineRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStateMachine operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStateMachine for more information on using the DescribeStateMachine
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStateMachineRequest method.
//    req, resp := client.DescribeStateMachineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine
func (c *SFN) DescribeStateMachineRequest(input *DescribeStateMachineInput) (req *request.Request, output *DescribeStateMachineOutput) {
	op := &request.Operation{
		Name:       opDescribeStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStateMachineInput{}
	}

	output = &DescribeStateMachineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStateMachine API operation for AWS Step Functions.
//
// Describes a state machine.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DescribeStateMachine for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeStateMachineDoesNotExist "StateMachineDoesNotExist"
//   The specified state machine does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine
func (c *SFN) DescribeStateMachine(input *DescribeStateMachineInput) (*DescribeStateMachineOutput, error) {
	req, out := c.DescribeStateMachineRequest(input)
	return out, req.Send()
}

// DescribeStateMachineWithContext is the same as DescribeStateMachine with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStateMachine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DescribeStateMachineWithContext(ctx aws.Context, input *DescribeStateMachineInput, opts ...request.Option) (*DescribeStateMachineOutput, error) {
	req, out := c.DescribeStateMachineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStateMachineForExecution = "DescribeStateMachineForExecution"

// DescribeStateMachineForExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStateMachineForExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStateMachineForExecution for more information on using the DescribeStateMachineForExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStateMachineForExecutionRequest method.
//    req, resp := client.DescribeStateMachineForExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineForExecution
func (c *SFN) DescribeStateMachineForExecutionRequest(input *DescribeStateMachineForExecutionInput) (req *request.Request, output *DescribeStateMachineForExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeStateMachineForExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStateMachineForExecutionInput{}
	}

	output = &DescribeStateMachineForExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStateMachineForExecution API operation for AWS Step Functions.
//
// Describes the state machine associated with a specific execution.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation DescribeStateMachineForExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionDoesNotExist "ExecutionDoesNotExist"
//   The specified execution does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineForExecution
func (c *SFN) DescribeStateMachineForExecution(input *DescribeStateMachineForExecutionInput) (*DescribeStateMachineForExecutionOutput, error) {
	req, out := c.DescribeStateMachineForExecutionRequest(input)
	return out, req.Send()
}

// DescribeStateMachineForExecutionWithContext is the same as DescribeStateMachineForExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStateMachineForExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) DescribeStateMachineForExecutionWithContext(ctx aws.Context, input *DescribeStateMachineForExecutionInput, opts ...request.Option) (*DescribeStateMachineForExecutionOutput, error) {
	req, out := c.DescribeStateMachineForExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetActivityTask = "GetActivityTask"

// GetActivityTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetActivityTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetActivityTask for more information on using the GetActivityTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetActivityTaskRequest method.
//    req, resp := client.GetActivityTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask
func (c *SFN) GetActivityTaskRequest(input *GetActivityTaskInput) (req *request.Request, output *GetActivityTaskOutput) {
	op := &request.Operation{
		Name:       opGetActivityTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetActivityTaskInput{}
	}

	output = &GetActivityTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetActivityTask API operation for AWS Step Functions.
//
// Used by workers to retrieve a task (with the specified activity ARN) which
// has been scheduled for execution by a running state machine. This initiates
// a long poll, where the service holds the HTTP connection open and responds
// as soon as a task becomes available (i.e. an execution of a task of this
// type is needed.) The maximum time the service holds on to the request before
// responding is 60 seconds. If no task is available within 60 seconds, the
// poll returns a taskToken with a null string.
//
// Workers should set their client side socket timeout to at least 65 seconds
// (5 seconds higher than the maximum time the service may hold the poll request).
//
// Polling with GetActivityTask can cause latency in some implementations. See
// Avoid Latency When Polling for Activity Tasks (https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html)
// in the Step Functions Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation GetActivityTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeActivityDoesNotExist "ActivityDoesNotExist"
//   The specified activity does not exist.
//
//   * ErrCodeActivityWorkerLimitExceeded "ActivityWorkerLimitExceeded"
//   The maximum number of workers concurrently polling for activity tasks has
//   been reached.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetActivityTask
func (c *SFN) GetActivityTask(input *GetActivityTaskInput) (*GetActivityTaskOutput, error) {
	req, out := c.GetActivityTaskRequest(input)
	return out, req.Send()
}

// GetActivityTaskWithContext is the same as GetActivityTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetActivityTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) GetActivityTaskWithContext(ctx aws.Context, input *GetActivityTaskInput, opts ...request.Option) (*GetActivityTaskOutput, error) {
	req, out := c.GetActivityTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExecutionHistory = "GetExecutionHistory"

// GetExecutionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetExecutionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExecutionHistory for more information on using the GetExecutionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExecutionHistoryRequest method.
//    req, resp := client.GetExecutionHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory
func (c *SFN) GetExecutionHistoryRequest(input *GetExecutionHistoryInput) (req *request.Request, output *GetExecutionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetExecutionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExecutionHistoryInput{}
	}

	output = &GetExecutionHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExecutionHistory API operation for AWS Step Functions.
//
// Returns the history of the specified execution as a list of events. By default,
// the results are returned in ascending order of the timeStamp of the events.
// Use the reverseOrder parameter to get the latest events first.
//
// If nextToken is returned, there are more results available. The value of
// nextToken is a unique pagination token for each page. Make the call again
// using the returned token to retrieve the next page. Keep all other arguments
// unchanged. Each pagination token expires after 24 hours. Using an expired
// pagination token will return an HTTP 400 InvalidToken error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation GetExecutionHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionDoesNotExist "ExecutionDoesNotExist"
//   The specified execution does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory
func (c *SFN) GetExecutionHistory(input *GetExecutionHistoryInput) (*GetExecutionHistoryOutput, error) {
	req, out := c.GetExecutionHistoryRequest(input)
	return out, req.Send()
}

// GetExecutionHistoryWithContext is the same as GetExecutionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetExecutionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) GetExecutionHistoryWithContext(ctx aws.Context, input *GetExecutionHistoryInput, opts ...request.Option) (*GetExecutionHistoryOutput, error) {
	req, out := c.GetExecutionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetExecutionHistoryPages iterates over the pages of a GetExecutionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetExecutionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetExecutionHistory operation.
//    pageNum := 0
//    err := client.GetExecutionHistoryPages(params,
//        func(page *sfn.GetExecutionHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) GetExecutionHistoryPages(input *GetExecutionHistoryInput, fn func(*GetExecutionHistoryOutput, bool) bool) error {
	return c.GetExecutionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetExecutionHistoryPagesWithContext same as GetExecutionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) GetExecutionHistoryPagesWithContext(ctx aws.Context, input *GetExecutionHistoryInput, fn func(*GetExecutionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetExecutionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetExecutionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetExecutionHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListActivities = "ListActivities"

// ListActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActivities for more information on using the ListActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActivitiesRequest method.
//    req, resp := client.ListActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities
func (c *SFN) ListActivitiesRequest(input *ListActivitiesInput) (req *request.Request, output *ListActivitiesOutput) {
	op := &request.Operation{
		Name:       opListActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActivitiesInput{}
	}

	output = &ListActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActivities API operation for AWS Step Functions.
//
// Lists the existing activities.
//
// If nextToken is returned, there are more results available. The value of
// nextToken is a unique pagination token for each page. Make the call again
// using the returned token to retrieve the next page. Keep all other arguments
// unchanged. Each pagination token expires after 24 hours. Using an expired
// pagination token will return an HTTP 400 InvalidToken error.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation ListActivities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListActivities
func (c *SFN) ListActivities(input *ListActivitiesInput) (*ListActivitiesOutput, error) {
	req, out := c.ListActivitiesRequest(input)
	return out, req.Send()
}

// ListActivitiesWithContext is the same as ListActivities with the addition of
// the ability to pass a context and additional request options.
//
// See ListActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListActivitiesWithContext(ctx aws.Context, input *ListActivitiesInput, opts ...request.Option) (*ListActivitiesOutput, error) {
	req, out := c.ListActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActivitiesPages iterates over the pages of a ListActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListActivities operation.
//    pageNum := 0
//    err := client.ListActivitiesPages(params,
//        func(page *sfn.ListActivitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) ListActivitiesPages(input *ListActivitiesInput, fn func(*ListActivitiesOutput, bool) bool) error {
	return c.ListActivitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActivitiesPagesWithContext same as ListActivitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListActivitiesPagesWithContext(ctx aws.Context, input *ListActivitiesInput, fn func(*ListActivitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActivitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActivitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListActivitiesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListExecutions = "ListExecutions"

// ListExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExecutions for more information on using the ListExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExecutionsRequest method.
//    req, resp := client.ListExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions
func (c *SFN) ListExecutionsRequest(input *ListExecutionsInput) (req *request.Request, output *ListExecutionsOutput) {
	op := &request.Operation{
		Name:       opListExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExecutionsInput{}
	}

	output = &ListExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExecutions API operation for AWS Step Functions.
//
// Lists the executions of a state machine that meet the filtering criteria.
// Results are sorted by time, with the most recent execution first.
//
// If nextToken is returned, there are more results available. The value of
// nextToken is a unique pagination token for each page. Make the call again
// using the returned token to retrieve the next page. Keep all other arguments
// unchanged. Each pagination token expires after 24 hours. Using an expired
// pagination token will return an HTTP 400 InvalidToken error.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation ListExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeStateMachineDoesNotExist "StateMachineDoesNotExist"
//   The specified state machine does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions
func (c *SFN) ListExecutions(input *ListExecutionsInput) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	return out, req.Send()
}

// ListExecutionsWithContext is the same as ListExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListExecutionsWithContext(ctx aws.Context, input *ListExecutionsInput, opts ...request.Option) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExecutionsPages iterates over the pages of a ListExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExecutions operation.
//    pageNum := 0
//    err := client.ListExecutionsPages(params,
//        func(page *sfn.ListExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) ListExecutionsPages(input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool) error {
	return c.ListExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExecutionsPagesWithContext same as ListExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListExecutionsPagesWithContext(ctx aws.Context, input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListExecutionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListStateMachines = "ListStateMachines"

// ListStateMachinesRequest generates a "aws/request.Request" representing the
// client's request for the ListStateMachines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStateMachines for more information on using the ListStateMachines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStateMachinesRequest method.
//    req, resp := client.ListStateMachinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines
func (c *SFN) ListStateMachinesRequest(input *ListStateMachinesInput) (req *request.Request, output *ListStateMachinesOutput) {
	op := &request.Operation{
		Name:       opListStateMachines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStateMachinesInput{}
	}

	output = &ListStateMachinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStateMachines API operation for AWS Step Functions.
//
// Lists the existing state machines.
//
// If nextToken is returned, there are more results available. The value of
// nextToken is a unique pagination token for each page. Make the call again
// using the returned token to retrieve the next page. Keep all other arguments
// unchanged. Each pagination token expires after 24 hours. Using an expired
// pagination token will return an HTTP 400 InvalidToken error.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation ListStateMachines for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListStateMachines
func (c *SFN) ListStateMachines(input *ListStateMachinesInput) (*ListStateMachinesOutput, error) {
	req, out := c.ListStateMachinesRequest(input)
	return out, req.Send()
}

// ListStateMachinesWithContext is the same as ListStateMachines with the addition of
// the ability to pass a context and additional request options.
//
// See ListStateMachines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListStateMachinesWithContext(ctx aws.Context, input *ListStateMachinesInput, opts ...request.Option) (*ListStateMachinesOutput, error) {
	req, out := c.ListStateMachinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStateMachinesPages iterates over the pages of a ListStateMachines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStateMachines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStateMachines operation.
//    pageNum := 0
//    err := client.ListStateMachinesPages(params,
//        func(page *sfn.ListStateMachinesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SFN) ListStateMachinesPages(input *ListStateMachinesInput, fn func(*ListStateMachinesOutput, bool) bool) error {
	return c.ListStateMachinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStateMachinesPagesWithContext same as ListStateMachinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListStateMachinesPagesWithContext(ctx aws.Context, input *ListStateMachinesInput, fn func(*ListStateMachinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStateMachinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStateMachinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListStateMachinesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListTagsForResource
func (c *SFN) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Step Functions.
//
// List tags for a given resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   Could not fine the referenced resource. Only state machine and activity ARNs
//   are supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListTagsForResource
func (c *SFN) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTaskFailure = "SendTaskFailure"

// SendTaskFailureRequest generates a "aws/request.Request" representing the
// client's request for the SendTaskFailure operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTaskFailure for more information on using the SendTaskFailure
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTaskFailureRequest method.
//    req, resp := client.SendTaskFailureRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure
func (c *SFN) SendTaskFailureRequest(input *SendTaskFailureInput) (req *request.Request, output *SendTaskFailureOutput) {
	op := &request.Operation{
		Name:       opSendTaskFailure,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTaskFailureInput{}
	}

	output = &SendTaskFailureOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendTaskFailure API operation for AWS Step Functions.
//
// Used by workers to report that the task identified by the taskToken failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation SendTaskFailure for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTaskDoesNotExist "TaskDoesNotExist"
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeTaskTimedOut "TaskTimedOut"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskFailure
func (c *SFN) SendTaskFailure(input *SendTaskFailureInput) (*SendTaskFailureOutput, error) {
	req, out := c.SendTaskFailureRequest(input)
	return out, req.Send()
}

// SendTaskFailureWithContext is the same as SendTaskFailure with the addition of
// the ability to pass a context and additional request options.
//
// See SendTaskFailure for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) SendTaskFailureWithContext(ctx aws.Context, input *SendTaskFailureInput, opts ...request.Option) (*SendTaskFailureOutput, error) {
	req, out := c.SendTaskFailureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTaskHeartbeat = "SendTaskHeartbeat"

// SendTaskHeartbeatRequest generates a "aws/request.Request" representing the
// client's request for the SendTaskHeartbeat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTaskHeartbeat for more information on using the SendTaskHeartbeat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTaskHeartbeatRequest method.
//    req, resp := client.SendTaskHeartbeatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat
func (c *SFN) SendTaskHeartbeatRequest(input *SendTaskHeartbeatInput) (req *request.Request, output *SendTaskHeartbeatOutput) {
	op := &request.Operation{
		Name:       opSendTaskHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTaskHeartbeatInput{}
	}

	output = &SendTaskHeartbeatOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendTaskHeartbeat API operation for AWS Step Functions.
//
// Used by workers to report to the service that the task represented by the
// specified taskToken is still making progress. This action resets the Heartbeat
// clock. The Heartbeat threshold is specified in the state machine's Amazon
// States Language definition. This action does not in itself create an event
// in the execution history. However, if the task times out, the execution history
// contains an ActivityTimedOut event.
//
// The Timeout of a task, defined in the state machine's Amazon States Language
// definition, is its maximum allowed duration, regardless of the number of
// SendTaskHeartbeat requests received.
//
// This operation is only useful for long-lived tasks to report the liveliness
// of the task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation SendTaskHeartbeat for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTaskDoesNotExist "TaskDoesNotExist"
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeTaskTimedOut "TaskTimedOut"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat
func (c *SFN) SendTaskHeartbeat(input *SendTaskHeartbeatInput) (*SendTaskHeartbeatOutput, error) {
	req, out := c.SendTaskHeartbeatRequest(input)
	return out, req.Send()
}

// SendTaskHeartbeatWithContext is the same as SendTaskHeartbeat with the addition of
// the ability to pass a context and additional request options.
//
// See SendTaskHeartbeat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) SendTaskHeartbeatWithContext(ctx aws.Context, input *SendTaskHeartbeatInput, opts ...request.Option) (*SendTaskHeartbeatOutput, error) {
	req, out := c.SendTaskHeartbeatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTaskSuccess = "SendTaskSuccess"

// SendTaskSuccessRequest generates a "aws/request.Request" representing the
// client's request for the SendTaskSuccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTaskSuccess for more information on using the SendTaskSuccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTaskSuccessRequest method.
//    req, resp := client.SendTaskSuccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess
func (c *SFN) SendTaskSuccessRequest(input *SendTaskSuccessInput) (req *request.Request, output *SendTaskSuccessOutput) {
	op := &request.Operation{
		Name:       opSendTaskSuccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTaskSuccessInput{}
	}

	output = &SendTaskSuccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendTaskSuccess API operation for AWS Step Functions.
//
// Used by workers to report that the task identified by the taskToken completed
// successfully.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation SendTaskSuccess for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTaskDoesNotExist "TaskDoesNotExist"
//
//   * ErrCodeInvalidOutput "InvalidOutput"
//   The provided JSON output data is invalid.
//
//   * ErrCodeInvalidToken "InvalidToken"
//   The provided token is invalid.
//
//   * ErrCodeTaskTimedOut "TaskTimedOut"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskSuccess
func (c *SFN) SendTaskSuccess(input *SendTaskSuccessInput) (*SendTaskSuccessOutput, error) {
	req, out := c.SendTaskSuccessRequest(input)
	return out, req.Send()
}

// SendTaskSuccessWithContext is the same as SendTaskSuccess with the addition of
// the ability to pass a context and additional request options.
//
// See SendTaskSuccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) SendTaskSuccessWithContext(ctx aws.Context, input *SendTaskSuccessInput, opts ...request.Option) (*SendTaskSuccessOutput, error) {
	req, out := c.SendTaskSuccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExecution = "StartExecution"

// StartExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExecution for more information on using the StartExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartExecutionRequest method.
//    req, resp := client.StartExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution
func (c *SFN) StartExecutionRequest(input *StartExecutionInput) (req *request.Request, output *StartExecutionOutput) {
	op := &request.Operation{
		Name:       opStartExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExecutionInput{}
	}

	output = &StartExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExecution API operation for AWS Step Functions.
//
// Starts a state machine execution.
//
// StartExecution is idempotent. If StartExecution is called with the same name
// and input as a running execution, the call will succeed and return the same
// response as the original request. If the execution is closed or if the input
// is different, it will return a 400 ExecutionAlreadyExists error. Names can
// be reused after 90 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation StartExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionLimitExceeded "ExecutionLimitExceeded"
//   The maximum number of running executions has been reached. Running executions
//   must end or be stopped before a new execution can be started.
//
//   * ErrCodeExecutionAlreadyExists "ExecutionAlreadyExists"
//   The execution has the same name as another execution (but a different input).
//
//   Executions with the same name and input are considered idempotent.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidExecutionInput "InvalidExecutionInput"
//   The provided JSON input data is invalid.
//
//   * ErrCodeInvalidName "InvalidName"
//   The provided name is invalid.
//
//   * ErrCodeStateMachineDoesNotExist "StateMachineDoesNotExist"
//   The specified state machine does not exist.
//
//   * ErrCodeStateMachineDeleting "StateMachineDeleting"
//   The specified state machine is being deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StartExecution
func (c *SFN) StartExecution(input *StartExecutionInput) (*StartExecutionOutput, error) {
	req, out := c.StartExecutionRequest(input)
	return out, req.Send()
}

// StartExecutionWithContext is the same as StartExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) StartExecutionWithContext(ctx aws.Context, input *StartExecutionInput, opts ...request.Option) (*StartExecutionOutput, error) {
	req, out := c.StartExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopExecution = "StopExecution"

// StopExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopExecution for more information on using the StopExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopExecutionRequest method.
//    req, resp := client.StopExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution
func (c *SFN) StopExecutionRequest(input *StopExecutionInput) (req *request.Request, output *StopExecutionOutput) {
	op := &request.Operation{
		Name:       opStopExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopExecutionInput{}
	}

	output = &StopExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopExecution API operation for AWS Step Functions.
//
// Stops an execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation StopExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeExecutionDoesNotExist "ExecutionDoesNotExist"
//   The specified execution does not exist.
//
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution
func (c *SFN) StopExecution(input *StopExecutionInput) (*StopExecutionOutput, error) {
	req, out := c.StopExecutionRequest(input)
	return out, req.Send()
}

// StopExecutionWithContext is the same as StopExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) StopExecutionWithContext(ctx aws.Context, input *StopExecutionInput, opts ...request.Option) (*StopExecutionOutput, error) {
	req, out := c.StopExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TagResource
func (c *SFN) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Step Functions.
//
// Add a tag to a Step Functions resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   Could not fine the referenced resource. Only state machine and activity ARNs
//   are supported.
//
//   * ErrCodeTooManyTags "TooManyTags"
//   You've exceeded the number of tags allowed for a resource. See the Limits
//   Topic (https://docs.aws.amazon.com/step-functions/latest/dg/limits.html)
//   in the AWS Step Functions Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/TagResource
func (c *SFN) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UntagResource
func (c *SFN) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Step Functions.
//
// Remove a tag from a Step Functions resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   Could not fine the referenced resource. Only state machine and activity ARNs
//   are supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UntagResource
func (c *SFN) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStateMachine = "UpdateStateMachine"

// UpdateStateMachineRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStateMachine operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStateMachine for more information on using the UpdateStateMachine
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStateMachineRequest method.
//    req, resp := client.UpdateStateMachineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachine
func (c *SFN) UpdateStateMachineRequest(input *UpdateStateMachineInput) (req *request.Request, output *UpdateStateMachineOutput) {
	op := &request.Operation{
		Name:       opUpdateStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStateMachineInput{}
	}

	output = &UpdateStateMachineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStateMachine API operation for AWS Step Functions.
//
// Updates an existing state machine by modifying its definition and/or roleArn.
// Running executions will continue to use the previous definition and roleArn.
// You must include at least one of definition or roleArn or you will receive
// a MissingRequiredParameter error.
//
// All StartExecution calls within a few seconds will use the updated definition
// and roleArn. Executions started immediately after calling UpdateStateMachine
// may use the previous state machine definition and roleArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Step Functions's
// API operation UpdateStateMachine for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArn "InvalidArn"
//   The provided Amazon Resource Name (ARN) is invalid.
//
//   * ErrCodeInvalidDefinition "InvalidDefinition"
//   The provided Amazon States Language definition is invalid.
//
//   * ErrCodeMissingRequiredParameter "MissingRequiredParameter"
//   Request is missing a required parameter. This error occurs if both definition
//   and roleArn are not specified.
//
//   * ErrCodeStateMachineDeleting "StateMachineDeleting"
//   The specified state machine is being deleted.
//
//   * ErrCodeStateMachineDoesNotExist "StateMachineDoesNotExist"
//   The specified state machine does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachine
func (c *SFN) UpdateStateMachine(input *UpdateStateMachineInput) (*UpdateStateMachineOutput, error) {
	req, out := c.UpdateStateMachineRequest(input)
	return out, req.Send()
}

// UpdateStateMachineWithContext is the same as UpdateStateMachine with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStateMachine for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SFN) UpdateStateMachineWithContext(ctx aws.Context, input *UpdateStateMachineInput, opts ...request.Option) (*UpdateStateMachineOutput, error) {
	req, out := c.UpdateStateMachineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains details about an activity that failed during an execution.
type ActivityFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ActivityFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ActivityFailedEventDetails) SetCause(v string) *ActivityFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ActivityFailedEventDetails) SetError(v string) *ActivityFailedEventDetails {
	s.Error = &v
	return s
}

// Contains details about an activity.
type ActivityListItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the activity.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// The date the activity is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The name of the activity.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivityListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityListItem) GoString() string {
	return s.String()
}

// SetActivityArn sets the ActivityArn field's value.
func (s *ActivityListItem) SetActivityArn(v string) *ActivityListItem {
	s.ActivityArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ActivityListItem) SetCreationDate(v time.Time) *ActivityListItem {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActivityListItem) SetName(v string) *ActivityListItem {
	s.Name = &v
	return s
}

// Contains details about an activity schedule failure that occurred during
// an execution.
type ActivityScheduleFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ActivityScheduleFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityScheduleFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ActivityScheduleFailedEventDetails) SetCause(v string) *ActivityScheduleFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ActivityScheduleFailedEventDetails) SetError(v string) *ActivityScheduleFailedEventDetails {
	s.Error = &v
	return s
}

// Contains details about an activity scheduled during an execution.
type ActivityScheduledEventDetails struct {
	_ struct{} `type:"structure"`

	// The maximum allowed duration between two heartbeats for the activity task.
	HeartbeatInSeconds *int64 `locationName:"heartbeatInSeconds" type:"long"`

	// The JSON data input to the activity task.
	Input *string `locationName:"input" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the scheduled activity.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The maximum allowed duration of the activity task.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s ActivityScheduledEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityScheduledEventDetails) GoString() string {
	return s.String()
}

// SetHeartbeatInSeconds sets the HeartbeatInSeconds field's value.
func (s *ActivityScheduledEventDetails) SetHeartbeatInSeconds(v int64) *ActivityScheduledEventDetails {
	s.HeartbeatInSeconds = &v
	return s
}

// SetInput sets the Input field's value.
func (s *ActivityScheduledEventDetails) SetInput(v string) *ActivityScheduledEventDetails {
	s.Input = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *ActivityScheduledEventDetails) SetResource(v string) *ActivityScheduledEventDetails {
	s.Resource = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *ActivityScheduledEventDetails) SetTimeoutInSeconds(v int64) *ActivityScheduledEventDetails {
	s.TimeoutInSeconds = &v
	return s
}

// Contains details about the start of an activity during an execution.
type ActivityStartedEventDetails struct {
	_ struct{} `type:"structure"`

	// The name of the worker that the task is assigned to. These names are provided
	// by the workers when calling GetActivityTask.
	WorkerName *string `locationName:"workerName" type:"string"`
}

// String returns the string representation
func (s ActivityStartedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityStartedEventDetails) GoString() string {
	return s.String()
}

// SetWorkerName sets the WorkerName field's value.
func (s *ActivityStartedEventDetails) SetWorkerName(v string) *ActivityStartedEventDetails {
	s.WorkerName = &v
	return s
}

// Contains details about an activity that successfully terminated during an
// execution.
type ActivitySucceededEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data output by the activity task.
	Output *string `locationName:"output" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ActivitySucceededEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivitySucceededEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *ActivitySucceededEventDetails) SetOutput(v string) *ActivitySucceededEventDetails {
	s.Output = &v
	return s
}

// Contains details about an activity timeout that occurred during an execution.
type ActivityTimedOutEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the timeout.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ActivityTimedOutEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTimedOutEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ActivityTimedOutEventDetails) SetCause(v string) *ActivityTimedOutEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ActivityTimedOutEventDetails) SetError(v string) *ActivityTimedOutEventDetails {
	s.Error = &v
	return s
}

type CreateActivityInput struct {
	_ struct{} `type:"structure"`

	// The name of the activity to create. This name must be unique for your AWS
	// account and region for 90 days. For more information, see Limits Related
	// to State Machine Executions (https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions)
	// in the AWS Step Functions Developer Guide.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The list of tags to add to a resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateActivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateActivityInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateActivityInput) SetName(v string) *CreateActivityInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateActivityInput) SetTags(v []*Tag) *CreateActivityInput {
	s.Tags = v
	return s
}

type CreateActivityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the created activity.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// The date the activity is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s CreateActivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivityOutput) GoString() string {
	return s.String()
}

// SetActivityArn sets the ActivityArn field's value.
func (s *CreateActivityOutput) SetActivityArn(v string) *CreateActivityOutput {
	s.ActivityArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateActivityOutput) SetCreationDate(v time.Time) *CreateActivityOutput {
	s.CreationDate = &v
	return s
}

type CreateStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon States Language definition of the state machine. See Amazon States
	// Language (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the state machine.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// Tags to be added when creating a state machine.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStateMachineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStateMachineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStateMachineInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Definition != nil && len(*s.Definition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Definition", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *CreateStateMachineInput) SetDefinition(v string) *CreateStateMachineInput {
	s.Definition = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStateMachineInput) SetName(v string) *CreateStateMachineInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateStateMachineInput) SetRoleArn(v string) *CreateStateMachineInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStateMachineInput) SetTags(v []*Tag) *CreateStateMachineInput {
	s.Tags = v
	return s
}

type CreateStateMachineOutput struct {
	_ struct{} `type:"structure"`

	// The date the state machine is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the created state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStateMachineOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateStateMachineOutput) SetCreationDate(v time.Time) *CreateStateMachineOutput {
	s.CreationDate = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *CreateStateMachineOutput) SetStateMachineArn(v string) *CreateStateMachineOutput {
	s.StateMachineArn = &v
	return s
}

type DeleteActivityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activity to delete.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteActivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteActivityInput"}
	if s.ActivityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityArn"))
	}
	if s.ActivityArn != nil && len(*s.ActivityArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityArn sets the ActivityArn field's value.
func (s *DeleteActivityInput) SetActivityArn(v string) *DeleteActivityInput {
	s.ActivityArn = &v
	return s
}

type DeleteActivityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteActivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivityOutput) GoString() string {
	return s.String()
}

type DeleteStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the state machine to delete.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStateMachineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStateMachineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStateMachineInput"}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DeleteStateMachineInput) SetStateMachineArn(v string) *DeleteStateMachineInput {
	s.StateMachineArn = &v
	return s
}

type DeleteStateMachineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStateMachineOutput) GoString() string {
	return s.String()
}

type DescribeActivityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activity to describe.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeActivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActivityInput"}
	if s.ActivityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityArn"))
	}
	if s.ActivityArn != nil && len(*s.ActivityArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityArn sets the ActivityArn field's value.
func (s *DescribeActivityInput) SetActivityArn(v string) *DescribeActivityInput {
	s.ActivityArn = &v
	return s
}

type DescribeActivityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the activity.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// The date the activity is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The name of the activity.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeActivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityOutput) GoString() string {
	return s.String()
}

// SetActivityArn sets the ActivityArn field's value.
func (s *DescribeActivityOutput) SetActivityArn(v string) *DescribeActivityOutput {
	s.ActivityArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeActivityOutput) SetCreationDate(v time.Time) *DescribeActivityOutput {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeActivityOutput) SetName(v string) *DescribeActivityOutput {
	s.Name = &v
	return s
}

type DescribeExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the execution to describe.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExecutionInput"}
	if s.ExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *DescribeExecutionInput) SetExecutionArn(v string) *DescribeExecutionInput {
	s.ExecutionArn = &v
	return s
}

type DescribeExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The string that contains the JSON input data of the execution.
	//
	// Input is a required field
	Input *string `locationName:"input" type:"string" required:"true" sensitive:"true"`

	// The name of the execution.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	Name *string `locationName:"name" min:"1" type:"string"`

	// The JSON output data of the execution.
	//
	// This field is set only if the execution succeeds. If the execution fails,
	// this field is null.
	Output *string `locationName:"output" type:"string" sensitive:"true"`

	// The date the execution is started.
	//
	// StartDate is a required field
	StartDate *time.Time `locationName:"startDate" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the executed stated machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The current status of the execution.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ExecutionStatus"`

	// If the execution has already ended, the date the execution stopped.
	StopDate *time.Time `locationName:"stopDate" type:"timestamp"`
}

// String returns the string representation
func (s DescribeExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *DescribeExecutionOutput) SetExecutionArn(v string) *DescribeExecutionOutput {
	s.ExecutionArn = &v
	return s
}

// SetInput sets the Input field's value.
func (s *DescribeExecutionOutput) SetInput(v string) *DescribeExecutionOutput {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeExecutionOutput) SetName(v string) *DescribeExecutionOutput {
	s.Name = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *DescribeExecutionOutput) SetOutput(v string) *DescribeExecutionOutput {
	s.Output = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *DescribeExecutionOutput) SetStartDate(v time.Time) *DescribeExecutionOutput {
	s.StartDate = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DescribeExecutionOutput) SetStateMachineArn(v string) *DescribeExecutionOutput {
	s.StateMachineArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeExecutionOutput) SetStatus(v string) *DescribeExecutionOutput {
	s.Status = &v
	return s
}

// SetStopDate sets the StopDate field's value.
func (s *DescribeExecutionOutput) SetStopDate(v time.Time) *DescribeExecutionOutput {
	s.StopDate = &v
	return s
}

type DescribeStateMachineForExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the execution you want state machine information
	// for.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStateMachineForExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStateMachineForExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStateMachineForExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStateMachineForExecutionInput"}
	if s.ExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *DescribeStateMachineForExecutionInput) SetExecutionArn(v string) *DescribeStateMachineForExecutionInput {
	s.ExecutionArn = &v
	return s
}

type DescribeStateMachineForExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon States Language definition of the state machine. See Amazon States
	// Language (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the state machine associated with the execution.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role of the State Machine for the
	// execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the state machine associated with the execution.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The date and time the state machine associated with an execution was updated.
	// For a newly created state machine, this is the creation date.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `locationName:"updateDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s DescribeStateMachineForExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStateMachineForExecutionOutput) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *DescribeStateMachineForExecutionOutput) SetDefinition(v string) *DescribeStateMachineForExecutionOutput {
	s.Definition = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeStateMachineForExecutionOutput) SetName(v string) *DescribeStateMachineForExecutionOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeStateMachineForExecutionOutput) SetRoleArn(v string) *DescribeStateMachineForExecutionOutput {
	s.RoleArn = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DescribeStateMachineForExecutionOutput) SetStateMachineArn(v string) *DescribeStateMachineForExecutionOutput {
	s.StateMachineArn = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *DescribeStateMachineForExecutionOutput) SetUpdateDate(v time.Time) *DescribeStateMachineForExecutionOutput {
	s.UpdateDate = &v
	return s
}

type DescribeStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the state machine to describe.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStateMachineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStateMachineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStateMachineInput"}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DescribeStateMachineInput) SetStateMachineArn(v string) *DescribeStateMachineInput {
	s.StateMachineArn = &v
	return s
}

type DescribeStateMachineOutput struct {
	_ struct{} `type:"structure"`

	// The date the state machine is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The Amazon States Language definition of the state machine. See Amazon States
	// Language (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the state machine.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role used when creating this state
	// machine. (The IAM role maintains security by granting Step Functions access
	// to AWS resources.)
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The current status of the state machine.
	Status *string `locationName:"status" type:"string" enum:"StateMachineStatus"`
}

// String returns the string representation
func (s DescribeStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStateMachineOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeStateMachineOutput) SetCreationDate(v time.Time) *DescribeStateMachineOutput {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *DescribeStateMachineOutput) SetDefinition(v string) *DescribeStateMachineOutput {
	s.Definition = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeStateMachineOutput) SetName(v string) *DescribeStateMachineOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeStateMachineOutput) SetRoleArn(v string) *DescribeStateMachineOutput {
	s.RoleArn = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *DescribeStateMachineOutput) SetStateMachineArn(v string) *DescribeStateMachineOutput {
	s.StateMachineArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeStateMachineOutput) SetStatus(v string) *DescribeStateMachineOutput {
	s.Status = &v
	return s
}

// Contains details about an abort of an execution.
type ExecutionAbortedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ExecutionAbortedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionAbortedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ExecutionAbortedEventDetails) SetCause(v string) *ExecutionAbortedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ExecutionAbortedEventDetails) SetError(v string) *ExecutionAbortedEventDetails {
	s.Error = &v
	return s
}

// Contains details about an execution failure event.
type ExecutionFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ExecutionFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ExecutionFailedEventDetails) SetCause(v string) *ExecutionFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ExecutionFailedEventDetails) SetError(v string) *ExecutionFailedEventDetails {
	s.Error = &v
	return s
}

// Contains details about an execution.
type ExecutionListItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The name of the execution.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The date the execution started.
	//
	// StartDate is a required field
	StartDate *time.Time `locationName:"startDate" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the executed state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The current status of the execution.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ExecutionStatus"`

	// If the execution already ended, the date the execution stopped.
	StopDate *time.Time `locationName:"stopDate" type:"timestamp"`
}

// String returns the string representation
func (s ExecutionListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionListItem) GoString() string {
	return s.String()
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *ExecutionListItem) SetExecutionArn(v string) *ExecutionListItem {
	s.ExecutionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ExecutionListItem) SetName(v string) *ExecutionListItem {
	s.Name = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ExecutionListItem) SetStartDate(v time.Time) *ExecutionListItem {
	s.StartDate = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *ExecutionListItem) SetStateMachineArn(v string) *ExecutionListItem {
	s.StateMachineArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExecutionListItem) SetStatus(v string) *ExecutionListItem {
	s.Status = &v
	return s
}

// SetStopDate sets the StopDate field's value.
func (s *ExecutionListItem) SetStopDate(v time.Time) *ExecutionListItem {
	s.StopDate = &v
	return s
}

// Contains details about the start of the execution.
type ExecutionStartedEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data input to the execution.
	Input *string `locationName:"input" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda
	// tasks.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation
func (s ExecutionStartedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionStartedEventDetails) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *ExecutionStartedEventDetails) SetInput(v string) *ExecutionStartedEventDetails {
	s.Input = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExecutionStartedEventDetails) SetRoleArn(v string) *ExecutionStartedEventDetails {
	s.RoleArn = &v
	return s
}

// Contains details about the successful termination of the execution.
type ExecutionSucceededEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data output by the execution.
	Output *string `locationName:"output" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ExecutionSucceededEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionSucceededEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *ExecutionSucceededEventDetails) SetOutput(v string) *ExecutionSucceededEventDetails {
	s.Output = &v
	return s
}

// Contains details about the execution timeout that occurred during the execution.
type ExecutionTimedOutEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the timeout.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ExecutionTimedOutEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionTimedOutEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ExecutionTimedOutEventDetails) SetCause(v string) *ExecutionTimedOutEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *ExecutionTimedOutEventDetails) SetError(v string) *ExecutionTimedOutEventDetails {
	s.Error = &v
	return s
}

type GetActivityTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned
	// when you create the task using CreateActivity.)
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// You can provide an arbitrary name in order to identify the worker that the
	// task is assigned to. This name is used when it is logged in the execution
	// history.
	WorkerName *string `locationName:"workerName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetActivityTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActivityTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetActivityTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetActivityTaskInput"}
	if s.ActivityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityArn"))
	}
	if s.ActivityArn != nil && len(*s.ActivityArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityArn", 1))
	}
	if s.WorkerName != nil && len(*s.WorkerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityArn sets the ActivityArn field's value.
func (s *GetActivityTaskInput) SetActivityArn(v string) *GetActivityTaskInput {
	s.ActivityArn = &v
	return s
}

// SetWorkerName sets the WorkerName field's value.
func (s *GetActivityTaskInput) SetWorkerName(v string) *GetActivityTaskInput {
	s.WorkerName = &v
	return s
}

type GetActivityTaskOutput struct {
	_ struct{} `type:"structure"`

	// The string that contains the JSON input data for the task.
	Input *string `locationName:"input" type:"string" sensitive:"true"`

	// A token that identifies the scheduled task. This token must be copied and
	// included in subsequent calls to SendTaskHeartbeat, SendTaskSuccess or SendTaskFailure
	// in order to report the progress or completion of the task.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetActivityTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActivityTaskOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *GetActivityTaskOutput) SetInput(v string) *GetActivityTaskOutput {
	s.Input = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *GetActivityTaskOutput) SetTaskToken(v string) *GetActivityTaskOutput {
	s.TaskToken = &v
	return s
}

type GetExecutionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results. The default is 100 and the maximum allowed
	// page size is 1000. A value of 0 uses the default.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Lists events in descending order of their timeStamp.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s GetExecutionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExecutionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExecutionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExecutionHistoryInput"}
	if s.ExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *GetExecutionHistoryInput) SetExecutionArn(v string) *GetExecutionHistoryInput {
	s.ExecutionArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetExecutionHistoryInput) SetMaxResults(v int64) *GetExecutionHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExecutionHistoryInput) SetNextToken(v string) *GetExecutionHistoryInput {
	s.NextToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *GetExecutionHistoryInput) SetReverseOrder(v bool) *GetExecutionHistoryInput {
	s.ReverseOrder = &v
	return s
}

type GetExecutionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of events that occurred in the execution.
	//
	// Events is a required field
	Events []*HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetExecutionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExecutionHistoryOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *GetExecutionHistoryOutput) SetEvents(v []*HistoryEvent) *GetExecutionHistoryOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExecutionHistoryOutput) SetNextToken(v string) *GetExecutionHistoryOutput {
	s.NextToken = &v
	return s
}

// Contains details about the events of an execution.
type HistoryEvent struct {
	_ struct{} `type:"structure"`

	// Contains details about an activity that failed during an execution.
	ActivityFailedEventDetails *ActivityFailedEventDetails `locationName:"activityFailedEventDetails" type:"structure"`

	// Contains details about an activity schedule event that failed during an execution.
	ActivityScheduleFailedEventDetails *ActivityScheduleFailedEventDetails `locationName:"activityScheduleFailedEventDetails" type:"structure"`

	// Contains details about an activity scheduled during an execution.
	ActivityScheduledEventDetails *ActivityScheduledEventDetails `locationName:"activityScheduledEventDetails" type:"structure"`

	// Contains details about the start of an activity during an execution.
	ActivityStartedEventDetails *ActivityStartedEventDetails `locationName:"activityStartedEventDetails" type:"structure"`

	// Contains details about an activity that successfully terminated during an
	// execution.
	ActivitySucceededEventDetails *ActivitySucceededEventDetails `locationName:"activitySucceededEventDetails" type:"structure"`

	// Contains details about an activity timeout that occurred during an execution.
	ActivityTimedOutEventDetails *ActivityTimedOutEventDetails `locationName:"activityTimedOutEventDetails" type:"structure"`

	// Contains details about an abort of an execution.
	ExecutionAbortedEventDetails *ExecutionAbortedEventDetails `locationName:"executionAbortedEventDetails" type:"structure"`

	// Contains details about an execution failure event.
	ExecutionFailedEventDetails *ExecutionFailedEventDetails `locationName:"executionFailedEventDetails" type:"structure"`

	// Contains details about the start of the execution.
	ExecutionStartedEventDetails *ExecutionStartedEventDetails `locationName:"executionStartedEventDetails" type:"structure"`

	// Contains details about the successful termination of the execution.
	ExecutionSucceededEventDetails *ExecutionSucceededEventDetails `locationName:"executionSucceededEventDetails" type:"structure"`

	// Contains details about the execution timeout that occurred during the execution.
	ExecutionTimedOutEventDetails *ExecutionTimedOutEventDetails `locationName:"executionTimedOutEventDetails" type:"structure"`

	// The id of the event. Events are numbered sequentially, starting at one.
	//
	// Id is a required field
	Id *int64 `locationName:"id" type:"long" required:"true"`

	// Contains details about a lambda function that failed during an execution.
	LambdaFunctionFailedEventDetails *LambdaFunctionFailedEventDetails `locationName:"lambdaFunctionFailedEventDetails" type:"structure"`

	// Contains details about a failed lambda function schedule event that occurred
	// during an execution.
	LambdaFunctionScheduleFailedEventDetails *LambdaFunctionScheduleFailedEventDetails `locationName:"lambdaFunctionScheduleFailedEventDetails" type:"structure"`

	// Contains details about a lambda function scheduled during an execution.
	LambdaFunctionScheduledEventDetails *LambdaFunctionScheduledEventDetails `locationName:"lambdaFunctionScheduledEventDetails" type:"structure"`

	// Contains details about a lambda function that failed to start during an execution.
	LambdaFunctionStartFailedEventDetails *LambdaFunctionStartFailedEventDetails `locationName:"lambdaFunctionStartFailedEventDetails" type:"structure"`

	// Contains details about a lambda function that terminated successfully during
	// an execution.
	LambdaFunctionSucceededEventDetails *LambdaFunctionSucceededEventDetails `locationName:"lambdaFunctionSucceededEventDetails" type:"structure"`

	// Contains details about a lambda function timeout that occurred during an
	// execution.
	LambdaFunctionTimedOutEventDetails *LambdaFunctionTimedOutEventDetails `locationName:"lambdaFunctionTimedOutEventDetails" type:"structure"`

	// The id of the previous event.
	PreviousEventId *int64 `locationName:"previousEventId" type:"long"`

	// Contains details about a state entered during an execution.
	StateEnteredEventDetails *StateEnteredEventDetails `locationName:"stateEnteredEventDetails" type:"structure"`

	// Contains details about an exit from a state during an execution.
	StateExitedEventDetails *StateExitedEventDetails `locationName:"stateExitedEventDetails" type:"structure"`

	// Contains details about the failure of a task.
	TaskFailedEventDetails *TaskFailedEventDetails `locationName:"taskFailedEventDetails" type:"structure"`

	// Contains details about a task that was scheduled.
	TaskScheduledEventDetails *TaskScheduledEventDetails `locationName:"taskScheduledEventDetails" type:"structure"`

	// Contains details about a task that failed to start.
	TaskStartFailedEventDetails *TaskStartFailedEventDetails `locationName:"taskStartFailedEventDetails" type:"structure"`

	// Contains details about a task that was started.
	TaskStartedEventDetails *TaskStartedEventDetails `locationName:"taskStartedEventDetails" type:"structure"`

	// Contains details about a task that where the submit failed.
	TaskSubmitFailedEventDetails *TaskSubmitFailedEventDetails `locationName:"taskSubmitFailedEventDetails" type:"structure"`

	// Contains details about a submitted task.
	TaskSubmittedEventDetails *TaskSubmittedEventDetails `locationName:"taskSubmittedEventDetails" type:"structure"`

	// Contains details about a task that succeeded.
	TaskSucceededEventDetails *TaskSucceededEventDetails `locationName:"taskSucceededEventDetails" type:"structure"`

	// Contains details about a task that timed out.
	TaskTimedOutEventDetails *TaskTimedOutEventDetails `locationName:"taskTimedOutEventDetails" type:"structure"`

	// The date and time the event occurred.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`

	// The type of the event.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"HistoryEventType"`
}

// String returns the string representation
func (s HistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoryEvent) GoString() string {
	return s.String()
}

// SetActivityFailedEventDetails sets the ActivityFailedEventDetails field's value.
func (s *HistoryEvent) SetActivityFailedEventDetails(v *ActivityFailedEventDetails) *HistoryEvent {
	s.ActivityFailedEventDetails = v
	return s
}

// SetActivityScheduleFailedEventDetails sets the ActivityScheduleFailedEventDetails field's value.
func (s *HistoryEvent) SetActivityScheduleFailedEventDetails(v *ActivityScheduleFailedEventDetails) *HistoryEvent {
	s.ActivityScheduleFailedEventDetails = v
	return s
}

// SetActivityScheduledEventDetails sets the ActivityScheduledEventDetails field's value.
func (s *HistoryEvent) SetActivityScheduledEventDetails(v *ActivityScheduledEventDetails) *HistoryEvent {
	s.ActivityScheduledEventDetails = v
	return s
}

// SetActivityStartedEventDetails sets the ActivityStartedEventDetails field's value.
func (s *HistoryEvent) SetActivityStartedEventDetails(v *ActivityStartedEventDetails) *HistoryEvent {
	s.ActivityStartedEventDetails = v
	return s
}

// SetActivitySucceededEventDetails sets the ActivitySucceededEventDetails field's value.
func (s *HistoryEvent) SetActivitySucceededEventDetails(v *ActivitySucceededEventDetails) *HistoryEvent {
	s.ActivitySucceededEventDetails = v
	return s
}

// SetActivityTimedOutEventDetails sets the ActivityTimedOutEventDetails field's value.
func (s *HistoryEvent) SetActivityTimedOutEventDetails(v *ActivityTimedOutEventDetails) *HistoryEvent {
	s.ActivityTimedOutEventDetails = v
	return s
}

// SetExecutionAbortedEventDetails sets the ExecutionAbortedEventDetails field's value.
func (s *HistoryEvent) SetExecutionAbortedEventDetails(v *ExecutionAbortedEventDetails) *HistoryEvent {
	s.ExecutionAbortedEventDetails = v
	return s
}

// SetExecutionFailedEventDetails sets the ExecutionFailedEventDetails field's value.
func (s *HistoryEvent) SetExecutionFailedEventDetails(v *ExecutionFailedEventDetails) *HistoryEvent {
	s.ExecutionFailedEventDetails = v
	return s
}

// SetExecutionStartedEventDetails sets the ExecutionStartedEventDetails field's value.
func (s *HistoryEvent) SetExecutionStartedEventDetails(v *ExecutionStartedEventDetails) *HistoryEvent {
	s.ExecutionStartedEventDetails = v
	return s
}

// SetExecutionSucceededEventDetails sets the ExecutionSucceededEventDetails field's value.
func (s *HistoryEvent) SetExecutionSucceededEventDetails(v *ExecutionSucceededEventDetails) *HistoryEvent {
	s.ExecutionSucceededEventDetails = v
	return s
}

// SetExecutionTimedOutEventDetails sets the ExecutionTimedOutEventDetails field's value.
func (s *HistoryEvent) SetExecutionTimedOutEventDetails(v *ExecutionTimedOutEventDetails) *HistoryEvent {
	s.ExecutionTimedOutEventDetails = v
	return s
}

// SetId sets the Id field's value.
func (s *HistoryEvent) SetId(v int64) *HistoryEvent {
	s.Id = &v
	return s
}

// SetLambdaFunctionFailedEventDetails sets the LambdaFunctionFailedEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionFailedEventDetails(v *LambdaFunctionFailedEventDetails) *HistoryEvent {
	s.LambdaFunctionFailedEventDetails = v
	return s
}

// SetLambdaFunctionScheduleFailedEventDetails sets the LambdaFunctionScheduleFailedEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionScheduleFailedEventDetails(v *LambdaFunctionScheduleFailedEventDetails) *HistoryEvent {
	s.LambdaFunctionScheduleFailedEventDetails = v
	return s
}

// SetLambdaFunctionScheduledEventDetails sets the LambdaFunctionScheduledEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionScheduledEventDetails(v *LambdaFunctionScheduledEventDetails) *HistoryEvent {
	s.LambdaFunctionScheduledEventDetails = v
	return s
}

// SetLambdaFunctionStartFailedEventDetails sets the LambdaFunctionStartFailedEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionStartFailedEventDetails(v *LambdaFunctionStartFailedEventDetails) *HistoryEvent {
	s.LambdaFunctionStartFailedEventDetails = v
	return s
}

// SetLambdaFunctionSucceededEventDetails sets the LambdaFunctionSucceededEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionSucceededEventDetails(v *LambdaFunctionSucceededEventDetails) *HistoryEvent {
	s.LambdaFunctionSucceededEventDetails = v
	return s
}

// SetLambdaFunctionTimedOutEventDetails sets the LambdaFunctionTimedOutEventDetails field's value.
func (s *HistoryEvent) SetLambdaFunctionTimedOutEventDetails(v *LambdaFunctionTimedOutEventDetails) *HistoryEvent {
	s.LambdaFunctionTimedOutEventDetails = v
	return s
}

// SetPreviousEventId sets the PreviousEventId field's value.
func (s *HistoryEvent) SetPreviousEventId(v int64) *HistoryEvent {
	s.PreviousEventId = &v
	return s
}

// SetStateEnteredEventDetails sets the StateEnteredEventDetails field's value.
func (s *HistoryEvent) SetStateEnteredEventDetails(v *StateEnteredEventDetails) *HistoryEvent {
	s.StateEnteredEventDetails = v
	return s
}

// SetStateExitedEventDetails sets the StateExitedEventDetails field's value.
func (s *HistoryEvent) SetStateExitedEventDetails(v *StateExitedEventDetails) *HistoryEvent {
	s.StateExitedEventDetails = v
	return s
}

// SetTaskFailedEventDetails sets the TaskFailedEventDetails field's value.
func (s *HistoryEvent) SetTaskFailedEventDetails(v *TaskFailedEventDetails) *HistoryEvent {
	s.TaskFailedEventDetails = v
	return s
}

// SetTaskScheduledEventDetails sets the TaskScheduledEventDetails field's value.
func (s *HistoryEvent) SetTaskScheduledEventDetails(v *TaskScheduledEventDetails) *HistoryEvent {
	s.TaskScheduledEventDetails = v
	return s
}

// SetTaskStartFailedEventDetails sets the TaskStartFailedEventDetails field's value.
func (s *HistoryEvent) SetTaskStartFailedEventDetails(v *TaskStartFailedEventDetails) *HistoryEvent {
	s.TaskStartFailedEventDetails = v
	return s
}

// SetTaskStartedEventDetails sets the TaskStartedEventDetails field's value.
func (s *HistoryEvent) SetTaskStartedEventDetails(v *TaskStartedEventDetails) *HistoryEvent {
	s.TaskStartedEventDetails = v
	return s
}

// SetTaskSubmitFailedEventDetails sets the TaskSubmitFailedEventDetails field's value.
func (s *HistoryEvent) SetTaskSubmitFailedEventDetails(v *TaskSubmitFailedEventDetails) *HistoryEvent {
	s.TaskSubmitFailedEventDetails = v
	return s
}

// SetTaskSubmittedEventDetails sets the TaskSubmittedEventDetails field's value.
func (s *HistoryEvent) SetTaskSubmittedEventDetails(v *TaskSubmittedEventDetails) *HistoryEvent {
	s.TaskSubmittedEventDetails = v
	return s
}

// SetTaskSucceededEventDetails sets the TaskSucceededEventDetails field's value.
func (s *HistoryEvent) SetTaskSucceededEventDetails(v *TaskSucceededEventDetails) *HistoryEvent {
	s.TaskSucceededEventDetails = v
	return s
}

// SetTaskTimedOutEventDetails sets the TaskTimedOutEventDetails field's value.
func (s *HistoryEvent) SetTaskTimedOutEventDetails(v *TaskTimedOutEventDetails) *HistoryEvent {
	s.TaskTimedOutEventDetails = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *HistoryEvent) SetTimestamp(v time.Time) *HistoryEvent {
	s.Timestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *HistoryEvent) SetType(v string) *HistoryEvent {
	s.Type = &v
	return s
}

// Contains details about a lambda function that failed during an execution.
type LambdaFunctionFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s LambdaFunctionFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionFailedEventDetails) SetCause(v string) *LambdaFunctionFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionFailedEventDetails) SetError(v string) *LambdaFunctionFailedEventDetails {
	s.Error = &v
	return s
}

// Contains details about a failed lambda function schedule event that occurred
// during an execution.
type LambdaFunctionScheduleFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s LambdaFunctionScheduleFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionScheduleFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionScheduleFailedEventDetails) SetCause(v string) *LambdaFunctionScheduleFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionScheduleFailedEventDetails) SetError(v string) *LambdaFunctionScheduleFailedEventDetails {
	s.Error = &v
	return s
}

// Contains details about a lambda function scheduled during an execution.
type LambdaFunctionScheduledEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data input to the lambda function.
	Input *string `locationName:"input" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the scheduled lambda function.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The maximum allowed duration of the lambda function.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s LambdaFunctionScheduledEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionScheduledEventDetails) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *LambdaFunctionScheduledEventDetails) SetInput(v string) *LambdaFunctionScheduledEventDetails {
	s.Input = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *LambdaFunctionScheduledEventDetails) SetResource(v string) *LambdaFunctionScheduledEventDetails {
	s.Resource = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *LambdaFunctionScheduledEventDetails) SetTimeoutInSeconds(v int64) *LambdaFunctionScheduledEventDetails {
	s.TimeoutInSeconds = &v
	return s
}

// Contains details about a lambda function that failed to start during an execution.
type LambdaFunctionStartFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s LambdaFunctionStartFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionStartFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionStartFailedEventDetails) SetCause(v string) *LambdaFunctionStartFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionStartFailedEventDetails) SetError(v string) *LambdaFunctionStartFailedEventDetails {
	s.Error = &v
	return s
}

// Contains details about a lambda function that successfully terminated during
// an execution.
type LambdaFunctionSucceededEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data output by the lambda function.
	Output *string `locationName:"output" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s LambdaFunctionSucceededEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionSucceededEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *LambdaFunctionSucceededEventDetails) SetOutput(v string) *LambdaFunctionSucceededEventDetails {
	s.Output = &v
	return s
}

// Contains details about a lambda function timeout that occurred during an
// execution.
type LambdaFunctionTimedOutEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the timeout.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s LambdaFunctionTimedOutEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionTimedOutEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *LambdaFunctionTimedOutEventDetails) SetCause(v string) *LambdaFunctionTimedOutEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *LambdaFunctionTimedOutEventDetails) SetError(v string) *LambdaFunctionTimedOutEventDetails {
	s.Error = &v
	return s
}

type ListActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results. The default is 100 and the maximum allowed
	// page size is 1000. A value of 0 uses the default.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActivitiesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListActivitiesInput) SetMaxResults(v int64) *ListActivitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActivitiesInput) SetNextToken(v string) *ListActivitiesInput {
	s.NextToken = &v
	return s
}

type ListActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The list of activities.
	//
	// Activities is a required field
	Activities []*ActivityListItem `locationName:"activities" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivitiesOutput) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *ListActivitiesOutput) SetActivities(v []*ActivityListItem) *ListActivitiesOutput {
	s.Activities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActivitiesOutput) SetNextToken(v string) *ListActivitiesOutput {
	s.NextToken = &v
	return s
}

type ListExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results. The default is 100 and the maximum allowed
	// page size is 1000. A value of 0 uses the default.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the state machine whose executions is listed.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// If specified, only list the executions whose current execution status matches
	// the given filter.
	StatusFilter *string `locationName:"statusFilter" type:"string" enum:"ExecutionStatus"`
}

// String returns the string representation
func (s ListExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExecutionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExecutionsInput) SetMaxResults(v int64) *ListExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsInput) SetNextToken(v string) *ListExecutionsInput {
	s.NextToken = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *ListExecutionsInput) SetStateMachineArn(v string) *ListExecutionsInput {
	s.StateMachineArn = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListExecutionsInput) SetStatusFilter(v string) *ListExecutionsInput {
	s.StatusFilter = &v
	return s
}

type ListExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of matching executions.
	//
	// Executions is a required field
	Executions []*ExecutionListItem `locationName:"executions" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExecutionsOutput) GoString() string {
	return s.String()
}

// SetExecutions sets the Executions field's value.
func (s *ListExecutionsOutput) SetExecutions(v []*ExecutionListItem) *ListExecutionsOutput {
	s.Executions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsOutput) SetNextToken(v string) *ListExecutionsOutput {
	s.NextToken = &v
	return s
}

type ListStateMachinesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results. The default is 100 and the maximum allowed
	// page size is 1000. A value of 0 uses the default.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListStateMachinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStateMachinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStateMachinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStateMachinesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStateMachinesInput) SetMaxResults(v int64) *ListStateMachinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStateMachinesInput) SetNextToken(v string) *ListStateMachinesInput {
	s.NextToken = &v
	return s
}

type ListStateMachinesOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// StateMachines is a required field
	StateMachines []*StateMachineListItem `locationName:"stateMachines" type:"list" required:"true"`
}

// String returns the string representation
func (s ListStateMachinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStateMachinesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStateMachinesOutput) SetNextToken(v string) *ListStateMachinesOutput {
	s.NextToken = &v
	return s
}

// SetStateMachines sets the StateMachines field's value.
func (s *ListStateMachinesOutput) SetStateMachines(v []*StateMachineListItem) *ListStateMachinesOutput {
	s.StateMachines = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Step Functions state machine or activity.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of tags associated with the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type SendTaskFailureInput struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`

	// The token that represents this task. Task tokens are generated by the service
	// when the tasks are assigned to a worker (see GetActivityTask::taskToken).
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendTaskFailureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskFailureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTaskFailureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTaskFailureInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCause sets the Cause field's value.
func (s *SendTaskFailureInput) SetCause(v string) *SendTaskFailureInput {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *SendTaskFailureInput) SetError(v string) *SendTaskFailureInput {
	s.Error = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *SendTaskFailureInput) SetTaskToken(v string) *SendTaskFailureInput {
	s.TaskToken = &v
	return s
}

type SendTaskFailureOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTaskFailureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskFailureOutput) GoString() string {
	return s.String()
}

type SendTaskHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The token that represents this task. Task tokens are generated by the service
	// when the tasks are assigned to a worker (see GetActivityTaskOutput$taskToken).
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendTaskHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskHeartbeatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTaskHeartbeatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTaskHeartbeatInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskToken sets the TaskToken field's value.
func (s *SendTaskHeartbeatInput) SetTaskToken(v string) *SendTaskHeartbeatInput {
	s.TaskToken = &v
	return s
}

type SendTaskHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTaskHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskHeartbeatOutput) GoString() string {
	return s.String()
}

type SendTaskSuccessInput struct {
	_ struct{} `type:"structure"`

	// The JSON output of the task.
	//
	// Output is a required field
	Output *string `locationName:"output" type:"string" required:"true" sensitive:"true"`

	// The token that represents this task. Task tokens are generated by the service
	// when the tasks are assigned to a worker (see GetActivityTaskOutput$taskToken).
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendTaskSuccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskSuccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTaskSuccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTaskSuccessInput"}
	if s.Output == nil {
		invalidParams.Add(request.NewErrParamRequired("Output"))
	}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutput sets the Output field's value.
func (s *SendTaskSuccessInput) SetOutput(v string) *SendTaskSuccessInput {
	s.Output = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *SendTaskSuccessInput) SetTaskToken(v string) *SendTaskSuccessInput {
	s.TaskToken = &v
	return s
}

type SendTaskSuccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTaskSuccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTaskSuccessOutput) GoString() string {
	return s.String()
}

type StartExecutionInput struct {
	_ struct{} `type:"structure"`

	// The string that contains the JSON input data for the execution, for example:
	//
	// "input": "{\"first_name\" : \"test\"}"
	//
	// If you don't include any JSON input data, you still must include the two
	// braces, for example: "input": "{}"
	Input *string `locationName:"input" type:"string" sensitive:"true"`

	// The name of the execution. This name must be unique for your AWS account,
	// region, and state machine for 90 days. For more information, see Limits Related
	// to State Machine Executions (https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions)
	// in the AWS Step Functions Developer Guide.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the state machine to execute.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExecutionInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInput sets the Input field's value.
func (s *StartExecutionInput) SetInput(v string) *StartExecutionInput {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartExecutionInput) SetName(v string) *StartExecutionInput {
	s.Name = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *StartExecutionInput) SetStateMachineArn(v string) *StartExecutionInput {
	s.StateMachineArn = &v
	return s
}

type StartExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The date the execution is started.
	//
	// StartDate is a required field
	StartDate *time.Time `locationName:"startDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s StartExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *StartExecutionOutput) SetExecutionArn(v string) *StartExecutionOutput {
	s.ExecutionArn = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *StartExecutionOutput) SetStartDate(v time.Time) *StartExecutionOutput {
	s.StartDate = &v
	return s
}

// Contains details about a state entered during an execution.
type StateEnteredEventDetails struct {
	_ struct{} `type:"structure"`

	// The string that contains the JSON input data for the state.
	Input *string `locationName:"input" type:"string" sensitive:"true"`

	// The name of the state.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StateEnteredEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateEnteredEventDetails) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *StateEnteredEventDetails) SetInput(v string) *StateEnteredEventDetails {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *StateEnteredEventDetails) SetName(v string) *StateEnteredEventDetails {
	s.Name = &v
	return s
}

// Contains details about an exit from a state during an execution.
type StateExitedEventDetails struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The JSON output data of the state.
	Output *string `locationName:"output" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s StateExitedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateExitedEventDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StateExitedEventDetails) SetName(v string) *StateExitedEventDetails {
	s.Name = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *StateExitedEventDetails) SetOutput(v string) *StateExitedEventDetails {
	s.Output = &v
	return s
}

// Contains details about the state machine.
type StateMachineListItem struct {
	_ struct{} `type:"structure"`

	// The date the state machine is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The name of the state machine.
	//
	// A name must not contain:
	//
	//    * whitespace
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StateMachineListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateMachineListItem) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *StateMachineListItem) SetCreationDate(v time.Time) *StateMachineListItem {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *StateMachineListItem) SetName(v string) *StateMachineListItem {
	s.Name = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *StateMachineListItem) SetStateMachineArn(v string) *StateMachineListItem {
	s.StateMachineArn = &v
	return s
}

type StopExecutionInput struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the execution to stop.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopExecutionInput"}
	if s.ExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCause sets the Cause field's value.
func (s *StopExecutionInput) SetCause(v string) *StopExecutionInput {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *StopExecutionInput) SetError(v string) *StopExecutionInput {
	s.Error = &v
	return s
}

// SetExecutionArn sets the ExecutionArn field's value.
func (s *StopExecutionInput) SetExecutionArn(v string) *StopExecutionInput {
	s.ExecutionArn = &v
	return s
}

type StopExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The date the execution is stopped.
	//
	// StopDate is a required field
	StopDate *time.Time `locationName:"stopDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s StopExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopExecutionOutput) GoString() string {
	return s.String()
}

// SetStopDate sets the StopDate field's value.
func (s *StopExecutionOutput) SetStopDate(v time.Time) *StopExecutionOutput {
	s.StopDate = &v
	return s
}

// Tags are key-value pairs that can be associated with Step Functions state
// machines and activities.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of a tag.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The value of a tag.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Step Functions state machine or activity.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The list of tags to add to a resource.
	//
	// Tags may only contain unicode letters, digits, whitespace, or these symbols:
	// _ . : / = + - @.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Contains details about a task failure event.
type TaskFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *TaskFailedEventDetails) SetCause(v string) *TaskFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *TaskFailedEventDetails) SetError(v string) *TaskFailedEventDetails {
	s.Error = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *TaskFailedEventDetails) SetResource(v string) *TaskFailedEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskFailedEventDetails) SetResourceType(v string) *TaskFailedEventDetails {
	s.ResourceType = &v
	return s
}

// Contains details about a task scheduled during an execution.
type TaskScheduledEventDetails struct {
	_ struct{} `type:"structure"`

	// The JSON data passed to the resource referenced in a task state.
	//
	// Parameters is a required field
	Parameters *string `locationName:"parameters" type:"string" required:"true" sensitive:"true"`

	// The region of the scheduled task
	//
	// Region is a required field
	Region *string `locationName:"region" min:"1" type:"string" required:"true"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`

	// The maximum allowed duration of the task.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s TaskScheduledEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskScheduledEventDetails) GoString() string {
	return s.String()
}

// SetParameters sets the Parameters field's value.
func (s *TaskScheduledEventDetails) SetParameters(v string) *TaskScheduledEventDetails {
	s.Parameters = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *TaskScheduledEventDetails) SetRegion(v string) *TaskScheduledEventDetails {
	s.Region = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *TaskScheduledEventDetails) SetResource(v string) *TaskScheduledEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskScheduledEventDetails) SetResourceType(v string) *TaskScheduledEventDetails {
	s.ResourceType = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *TaskScheduledEventDetails) SetTimeoutInSeconds(v int64) *TaskScheduledEventDetails {
	s.TimeoutInSeconds = &v
	return s
}

// Contains details about a task that failed to start during an execution.
type TaskStartFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskStartFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskStartFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *TaskStartFailedEventDetails) SetCause(v string) *TaskStartFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *TaskStartFailedEventDetails) SetError(v string) *TaskStartFailedEventDetails {
	s.Error = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *TaskStartFailedEventDetails) SetResource(v string) *TaskStartFailedEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskStartFailedEventDetails) SetResourceType(v string) *TaskStartFailedEventDetails {
	s.ResourceType = &v
	return s
}

// Contains details about the start of a task during an execution.
type TaskStartedEventDetails struct {
	_ struct{} `type:"structure"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskStartedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskStartedEventDetails) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *TaskStartedEventDetails) SetResource(v string) *TaskStartedEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskStartedEventDetails) SetResourceType(v string) *TaskStartedEventDetails {
	s.ResourceType = &v
	return s
}

// Contains details about a task that failed to submit during an execution.
type TaskSubmitFailedEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskSubmitFailedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskSubmitFailedEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *TaskSubmitFailedEventDetails) SetCause(v string) *TaskSubmitFailedEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *TaskSubmitFailedEventDetails) SetError(v string) *TaskSubmitFailedEventDetails {
	s.Error = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *TaskSubmitFailedEventDetails) SetResource(v string) *TaskSubmitFailedEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskSubmitFailedEventDetails) SetResourceType(v string) *TaskSubmitFailedEventDetails {
	s.ResourceType = &v
	return s
}

// Contains details about a task submitted to a resource .
type TaskSubmittedEventDetails struct {
	_ struct{} `type:"structure"`

	// The response from a resource when a task has started.
	Output *string `locationName:"output" type:"string" sensitive:"true"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskSubmittedEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskSubmittedEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *TaskSubmittedEventDetails) SetOutput(v string) *TaskSubmittedEventDetails {
	s.Output = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *TaskSubmittedEventDetails) SetResource(v string) *TaskSubmittedEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskSubmittedEventDetails) SetResourceType(v string) *TaskSubmittedEventDetails {
	s.ResourceType = &v
	return s
}

// Contains details about the successful completion of a task state.
type TaskSucceededEventDetails struct {
	_ struct{} `type:"structure"`

	// The full JSON response from a resource when a task has succeeded. This response
	// becomes the output of the related task.
	Output *string `locationName:"output" type:"string" sensitive:"true"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskSucceededEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskSucceededEventDetails) GoString() string {
	return s.String()
}

// SetOutput sets the Output field's value.
func (s *TaskSucceededEventDetails) SetOutput(v string) *TaskSucceededEventDetails {
	s.Output = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *TaskSucceededEventDetails) SetResource(v string) *TaskSucceededEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskSucceededEventDetails) SetResourceType(v string) *TaskSucceededEventDetails {
	s.ResourceType = &v
	return s
}

// Contains details about a resource timeout that occurred during an execution.
type TaskTimedOutEventDetails struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string" sensitive:"true"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string" sensitive:"true"`

	// The service name of the resource in a task state.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" min:"1" type:"string" required:"true"`

	// The action of the resource called by a task state.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskTimedOutEventDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskTimedOutEventDetails) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *TaskTimedOutEventDetails) SetCause(v string) *TaskTimedOutEventDetails {
	s.Cause = &v
	return s
}

// SetError sets the Error field's value.
func (s *TaskTimedOutEventDetails) SetError(v string) *TaskTimedOutEventDetails {
	s.Error = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *TaskTimedOutEventDetails) SetResource(v string) *TaskTimedOutEventDetails {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaskTimedOutEventDetails) SetResourceType(v string) *TaskTimedOutEventDetails {
	s.ResourceType = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Step Functions state machine or activity.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The list of tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon States Language definition of the state machine. See Amazon States
	// Language (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
	Definition *string `locationName:"definition" min:"1" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the IAM role of the state machine.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStateMachineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStateMachineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStateMachineInput"}
	if s.Definition != nil && len(*s.Definition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Definition", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.StateMachineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *UpdateStateMachineInput) SetDefinition(v string) *UpdateStateMachineInput {
	s.Definition = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateStateMachineInput) SetRoleArn(v string) *UpdateStateMachineInput {
	s.RoleArn = &v
	return s
}

// SetStateMachineArn sets the StateMachineArn field's value.
func (s *UpdateStateMachineInput) SetStateMachineArn(v string) *UpdateStateMachineInput {
	s.StateMachineArn = &v
	return s
}

type UpdateStateMachineOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the state machine was updated.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `locationName:"updateDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s UpdateStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStateMachineOutput) GoString() string {
	return s.String()
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *UpdateStateMachineOutput) SetUpdateDate(v time.Time) *UpdateStateMachineOutput {
	s.UpdateDate = &v
	return s
}

const (
	// ExecutionStatusRunning is a ExecutionStatus enum value
	ExecutionStatusRunning = "RUNNING"

	// ExecutionStatusSucceeded is a ExecutionStatus enum value
	ExecutionStatusSucceeded = "SUCCEEDED"

	// ExecutionStatusFailed is a ExecutionStatus enum value
	ExecutionStatusFailed = "FAILED"

	// ExecutionStatusTimedOut is a ExecutionStatus enum value
	ExecutionStatusTimedOut = "TIMED_OUT"

	// ExecutionStatusAborted is a ExecutionStatus enum value
	ExecutionStatusAborted = "ABORTED"
)

const (
	// HistoryEventTypeActivityFailed is a HistoryEventType enum value
	HistoryEventTypeActivityFailed = "ActivityFailed"

	// HistoryEventTypeActivityScheduleFailed is a HistoryEventType enum value
	HistoryEventTypeActivityScheduleFailed = "ActivityScheduleFailed"

	// HistoryEventTypeActivityScheduled is a HistoryEventType enum value
	HistoryEventTypeActivityScheduled = "ActivityScheduled"

	// HistoryEventTypeActivityStarted is a HistoryEventType enum value
	HistoryEventTypeActivityStarted = "ActivityStarted"

	// HistoryEventTypeActivitySucceeded is a HistoryEventType enum value
	HistoryEventTypeActivitySucceeded = "ActivitySucceeded"

	// HistoryEventTypeActivityTimedOut is a HistoryEventType enum value
	HistoryEventTypeActivityTimedOut = "ActivityTimedOut"

	// HistoryEventTypeChoiceStateEntered is a HistoryEventType enum value
	HistoryEventTypeChoiceStateEntered = "ChoiceStateEntered"

	// HistoryEventTypeChoiceStateExited is a HistoryEventType enum value
	HistoryEventTypeChoiceStateExited = "ChoiceStateExited"

	// HistoryEventTypeTaskFailed is a HistoryEventType enum value
	HistoryEventTypeTaskFailed = "TaskFailed"

	// HistoryEventTypeTaskScheduled is a HistoryEventType enum value
	HistoryEventTypeTaskScheduled = "TaskScheduled"

	// HistoryEventTypeTaskStartFailed is a HistoryEventType enum value
	HistoryEventTypeTaskStartFailed = "TaskStartFailed"

	// HistoryEventTypeTaskStarted is a HistoryEventType enum value
	HistoryEventTypeTaskStarted = "TaskStarted"

	// HistoryEventTypeTaskSubmitFailed is a HistoryEventType enum value
	HistoryEventTypeTaskSubmitFailed = "TaskSubmitFailed"

	// HistoryEventTypeTaskSubmitted is a HistoryEventType enum value
	HistoryEventTypeTaskSubmitted = "TaskSubmitted"

	// HistoryEventTypeTaskSucceeded is a HistoryEventType enum value
	HistoryEventTypeTaskSucceeded = "TaskSucceeded"

	// HistoryEventTypeTaskTimedOut is a HistoryEventType enum value
	HistoryEventTypeTaskTimedOut = "TaskTimedOut"

	// HistoryEventTypeExecutionFailed is a HistoryEventType enum value
	HistoryEventTypeExecutionFailed = "ExecutionFailed"

	// HistoryEventTypeExecutionStarted is a HistoryEventType enum value
	HistoryEventTypeExecutionStarted = "ExecutionStarted"

	// HistoryEventTypeExecutionSucceeded is a HistoryEventType enum value
	HistoryEventTypeExecutionSucceeded = "ExecutionSucceeded"

	// HistoryEventTypeExecutionAborted is a HistoryEventType enum value
	HistoryEventTypeExecutionAborted = "ExecutionAborted"

	// HistoryEventTypeExecutionTimedOut is a HistoryEventType enum value
	HistoryEventTypeExecutionTimedOut = "ExecutionTimedOut"

	// HistoryEventTypeFailStateEntered is a HistoryEventType enum value
	HistoryEventTypeFailStateEntered = "FailStateEntered"

	// HistoryEventTypeLambdaFunctionFailed is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionFailed = "LambdaFunctionFailed"

	// HistoryEventTypeLambdaFunctionScheduleFailed is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionScheduleFailed = "LambdaFunctionScheduleFailed"

	// HistoryEventTypeLambdaFunctionScheduled is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionScheduled = "LambdaFunctionScheduled"

	// HistoryEventTypeLambdaFunctionStartFailed is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionStartFailed = "LambdaFunctionStartFailed"

	// HistoryEventTypeLambdaFunctionStarted is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionStarted = "LambdaFunctionStarted"

	// HistoryEventTypeLambdaFunctionSucceeded is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionSucceeded = "LambdaFunctionSucceeded"

	// HistoryEventTypeLambdaFunctionTimedOut is a HistoryEventType enum value
	HistoryEventTypeLambdaFunctionTimedOut = "LambdaFunctionTimedOut"

	// HistoryEventTypeSucceedStateEntered is a HistoryEventType enum value
	HistoryEventTypeSucceedStateEntered = "SucceedStateEntered"

	// HistoryEventTypeSucceedStateExited is a HistoryEventType enum value
	HistoryEventTypeSucceedStateExited = "SucceedStateExited"

	// HistoryEventTypeTaskStateAborted is a HistoryEventType enum value
	HistoryEventTypeTaskStateAborted = "TaskStateAborted"

	// HistoryEventTypeTaskStateEntered is a HistoryEventType enum value
	HistoryEventTypeTaskStateEntered = "TaskStateEntered"

	// HistoryEventTypeTaskStateExited is a HistoryEventType enum value
	HistoryEventTypeTaskStateExited = "TaskStateExited"

	// HistoryEventTypePassStateEntered is a HistoryEventType enum value
	HistoryEventTypePassStateEntered = "PassStateEntered"

	// HistoryEventTypePassStateExited is a HistoryEventType enum value
	HistoryEventTypePassStateExited = "PassStateExited"

	// HistoryEventTypeParallelStateAborted is a HistoryEventType enum value
	HistoryEventTypeParallelStateAborted = "ParallelStateAborted"

	// HistoryEventTypeParallelStateEntered is a HistoryEventType enum value
	HistoryEventTypeParallelStateEntered = "ParallelStateEntered"

	// HistoryEventTypeParallelStateExited is a HistoryEventType enum value
	HistoryEventTypeParallelStateExited = "ParallelStateExited"

	// HistoryEventTypeParallelStateFailed is a HistoryEventType enum value
	HistoryEventTypeParallelStateFailed = "ParallelStateFailed"

	// HistoryEventTypeParallelStateStarted is a HistoryEventType enum value
	HistoryEventTypeParallelStateStarted = "ParallelStateStarted"

	// HistoryEventTypeParallelStateSucceeded is a HistoryEventType enum value
	HistoryEventTypeParallelStateSucceeded = "ParallelStateSucceeded"

	// HistoryEventTypeWaitStateAborted is a HistoryEventType enum value
	HistoryEventTypeWaitStateAborted = "WaitStateAborted"

	// HistoryEventTypeWaitStateEntered is a HistoryEventType enum value
	HistoryEventTypeWaitStateEntered = "WaitStateEntered"

	// HistoryEventTypeWaitStateExited is a HistoryEventType enum value
	HistoryEventTypeWaitStateExited = "WaitStateExited"
)

const (
	// StateMachineStatusActive is a StateMachineStatus enum value
	StateMachineStatusActive = "ACTIVE"

	// StateMachineStatusDeleting is a StateMachineStatus enum value
	StateMachineStatusDeleting = "DELETING"
)
