// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateServiceQuotaTemplate = "AssociateServiceQuotaTemplate"

// AssociateServiceQuotaTemplateRequest generates a "aws/request.Request" representing the
// client's request for the AssociateServiceQuotaTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateServiceQuotaTemplate for more information on using the AssociateServiceQuotaTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateServiceQuotaTemplateRequest method.
//    req, resp := client.AssociateServiceQuotaTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate
func (c *ServiceQuotas) AssociateServiceQuotaTemplateRequest(input *AssociateServiceQuotaTemplateInput) (req *request.Request, output *AssociateServiceQuotaTemplateOutput) {
	op := &request.Operation{
		Name:       opAssociateServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateServiceQuotaTemplateInput{}
	}

	output = &AssociateServiceQuotaTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateServiceQuotaTemplate API operation for Service Quotas.
//
// Associates the Service Quotas template with your organization so that when
// new accounts are created in your organization, the template submits increase
// requests for the specified service quotas. Use the Service Quotas template
// to request an increase for any adjustable quota value. After you define the
// Service Quotas template, use this operation to associate, or enable, the
// template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation AssociateServiceQuotaTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * ErrCodeAWSServiceAccessNotEnabledException "AWSServiceAccessNotEnabledException"
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization. To enable, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeOrganizationNotInAllFeaturesModeException "OrganizationNotInAllFeaturesModeException"
//   The organization that your account belongs to, is not in All Features mode.
//   To enable all features mode, see EnableAllFeatures (https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAllFeatures.html).
//
//   * ErrCodeTemplatesNotAvailableInRegionException "TemplatesNotAvailableInRegionException"
//   The Service Quotas template is not available in the Region where you are
//   making the request. Please make the request in us-east-1.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate
func (c *ServiceQuotas) AssociateServiceQuotaTemplate(input *AssociateServiceQuotaTemplateInput) (*AssociateServiceQuotaTemplateOutput, error) {
	req, out := c.AssociateServiceQuotaTemplateRequest(input)
	return out, req.Send()
}

// AssociateServiceQuotaTemplateWithContext is the same as AssociateServiceQuotaTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateServiceQuotaTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) AssociateServiceQuotaTemplateWithContext(ctx aws.Context, input *AssociateServiceQuotaTemplateInput, opts ...request.Option) (*AssociateServiceQuotaTemplateOutput, error) {
	req, out := c.AssociateServiceQuotaTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceQuotaIncreaseRequestFromTemplate = "DeleteServiceQuotaIncreaseRequestFromTemplate"

// DeleteServiceQuotaIncreaseRequestFromTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceQuotaIncreaseRequestFromTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceQuotaIncreaseRequestFromTemplate for more information on using the DeleteServiceQuotaIncreaseRequestFromTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServiceQuotaIncreaseRequestFromTemplateRequest method.
//    req, resp := client.DeleteServiceQuotaIncreaseRequestFromTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) DeleteServiceQuotaIncreaseRequestFromTemplateRequest(input *DeleteServiceQuotaIncreaseRequestFromTemplateInput) (req *request.Request, output *DeleteServiceQuotaIncreaseRequestFromTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceQuotaIncreaseRequestFromTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceQuotaIncreaseRequestFromTemplateInput{}
	}

	output = &DeleteServiceQuotaIncreaseRequestFromTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServiceQuotaIncreaseRequestFromTemplate API operation for Service Quotas.
//
// Removes a service quota increase request from the Service Quotas template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation DeleteServiceQuotaIncreaseRequestFromTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeAWSServiceAccessNotEnabledException "AWSServiceAccessNotEnabledException"
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization. To enable, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeTemplatesNotAvailableInRegionException "TemplatesNotAvailableInRegionException"
//   The Service Quotas template is not available in the Region where you are
//   making the request. Please make the request in us-east-1.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) DeleteServiceQuotaIncreaseRequestFromTemplate(input *DeleteServiceQuotaIncreaseRequestFromTemplateInput) (*DeleteServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.DeleteServiceQuotaIncreaseRequestFromTemplateRequest(input)
	return out, req.Send()
}

// DeleteServiceQuotaIncreaseRequestFromTemplateWithContext is the same as DeleteServiceQuotaIncreaseRequestFromTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceQuotaIncreaseRequestFromTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) DeleteServiceQuotaIncreaseRequestFromTemplateWithContext(ctx aws.Context, input *DeleteServiceQuotaIncreaseRequestFromTemplateInput, opts ...request.Option) (*DeleteServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.DeleteServiceQuotaIncreaseRequestFromTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateServiceQuotaTemplate = "DisassociateServiceQuotaTemplate"

// DisassociateServiceQuotaTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateServiceQuotaTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateServiceQuotaTemplate for more information on using the DisassociateServiceQuotaTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateServiceQuotaTemplateRequest method.
//    req, resp := client.DisassociateServiceQuotaTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate
func (c *ServiceQuotas) DisassociateServiceQuotaTemplateRequest(input *DisassociateServiceQuotaTemplateInput) (req *request.Request, output *DisassociateServiceQuotaTemplateOutput) {
	op := &request.Operation{
		Name:       opDisassociateServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateServiceQuotaTemplateInput{}
	}

	output = &DisassociateServiceQuotaTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateServiceQuotaTemplate API operation for Service Quotas.
//
// Disables the Service Quotas template. Once the template is disabled, it does
// not request quota increases for new accounts in your organization. Disabling
// the quota template does not apply the quota increase requests from the template.
//
// Related operations
//
//    * To enable the quota template, call AssociateServiceQuotaTemplate.
//
//    * To delete a specific service quota from the template, use DeleteServiceQuotaIncreaseRequestFromTemplate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation DisassociateServiceQuotaTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeServiceQuotaTemplateNotInUseException "ServiceQuotaTemplateNotInUseException"
//   The quota request template is not associated with your organization.
//
//   To use the template, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * ErrCodeAWSServiceAccessNotEnabledException "AWSServiceAccessNotEnabledException"
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization. To enable, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeTemplatesNotAvailableInRegionException "TemplatesNotAvailableInRegionException"
//   The Service Quotas template is not available in the Region where you are
//   making the request. Please make the request in us-east-1.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate
func (c *ServiceQuotas) DisassociateServiceQuotaTemplate(input *DisassociateServiceQuotaTemplateInput) (*DisassociateServiceQuotaTemplateOutput, error) {
	req, out := c.DisassociateServiceQuotaTemplateRequest(input)
	return out, req.Send()
}

// DisassociateServiceQuotaTemplateWithContext is the same as DisassociateServiceQuotaTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateServiceQuotaTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) DisassociateServiceQuotaTemplateWithContext(ctx aws.Context, input *DisassociateServiceQuotaTemplateInput, opts ...request.Option) (*DisassociateServiceQuotaTemplateOutput, error) {
	req, out := c.DisassociateServiceQuotaTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAWSDefaultServiceQuota = "GetAWSDefaultServiceQuota"

// GetAWSDefaultServiceQuotaRequest generates a "aws/request.Request" representing the
// client's request for the GetAWSDefaultServiceQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAWSDefaultServiceQuota for more information on using the GetAWSDefaultServiceQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAWSDefaultServiceQuotaRequest method.
//    req, resp := client.GetAWSDefaultServiceQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota
func (c *ServiceQuotas) GetAWSDefaultServiceQuotaRequest(input *GetAWSDefaultServiceQuotaInput) (req *request.Request, output *GetAWSDefaultServiceQuotaOutput) {
	op := &request.Operation{
		Name:       opGetAWSDefaultServiceQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAWSDefaultServiceQuotaInput{}
	}

	output = &GetAWSDefaultServiceQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAWSDefaultServiceQuota API operation for Service Quotas.
//
// Retrieves the default service quotas values. The Value returned for each
// quota is the AWS default value, even if the quotas have been increased..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetAWSDefaultServiceQuota for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota
func (c *ServiceQuotas) GetAWSDefaultServiceQuota(input *GetAWSDefaultServiceQuotaInput) (*GetAWSDefaultServiceQuotaOutput, error) {
	req, out := c.GetAWSDefaultServiceQuotaRequest(input)
	return out, req.Send()
}

// GetAWSDefaultServiceQuotaWithContext is the same as GetAWSDefaultServiceQuota with the addition of
// the ability to pass a context and additional request options.
//
// See GetAWSDefaultServiceQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetAWSDefaultServiceQuotaWithContext(ctx aws.Context, input *GetAWSDefaultServiceQuotaInput, opts ...request.Option) (*GetAWSDefaultServiceQuotaOutput, error) {
	req, out := c.GetAWSDefaultServiceQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssociationForServiceQuotaTemplate = "GetAssociationForServiceQuotaTemplate"

// GetAssociationForServiceQuotaTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetAssociationForServiceQuotaTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssociationForServiceQuotaTemplate for more information on using the GetAssociationForServiceQuotaTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssociationForServiceQuotaTemplateRequest method.
//    req, resp := client.GetAssociationForServiceQuotaTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate
func (c *ServiceQuotas) GetAssociationForServiceQuotaTemplateRequest(input *GetAssociationForServiceQuotaTemplateInput) (req *request.Request, output *GetAssociationForServiceQuotaTemplateOutput) {
	op := &request.Operation{
		Name:       opGetAssociationForServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAssociationForServiceQuotaTemplateInput{}
	}

	output = &GetAssociationForServiceQuotaTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssociationForServiceQuotaTemplate API operation for Service Quotas.
//
// Retrieves the ServiceQuotaTemplateAssociationStatus value from the service.
// Use this action to determine if the Service Quota template is associated,
// or enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetAssociationForServiceQuotaTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeServiceQuotaTemplateNotInUseException "ServiceQuotaTemplateNotInUseException"
//   The quota request template is not associated with your organization.
//
//   To use the template, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * ErrCodeAWSServiceAccessNotEnabledException "AWSServiceAccessNotEnabledException"
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization. To enable, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeTemplatesNotAvailableInRegionException "TemplatesNotAvailableInRegionException"
//   The Service Quotas template is not available in the Region where you are
//   making the request. Please make the request in us-east-1.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate
func (c *ServiceQuotas) GetAssociationForServiceQuotaTemplate(input *GetAssociationForServiceQuotaTemplateInput) (*GetAssociationForServiceQuotaTemplateOutput, error) {
	req, out := c.GetAssociationForServiceQuotaTemplateRequest(input)
	return out, req.Send()
}

// GetAssociationForServiceQuotaTemplateWithContext is the same as GetAssociationForServiceQuotaTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssociationForServiceQuotaTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetAssociationForServiceQuotaTemplateWithContext(ctx aws.Context, input *GetAssociationForServiceQuotaTemplateInput, opts ...request.Option) (*GetAssociationForServiceQuotaTemplateOutput, error) {
	req, out := c.GetAssociationForServiceQuotaTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRequestedServiceQuotaChange = "GetRequestedServiceQuotaChange"

// GetRequestedServiceQuotaChangeRequest generates a "aws/request.Request" representing the
// client's request for the GetRequestedServiceQuotaChange operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRequestedServiceQuotaChange for more information on using the GetRequestedServiceQuotaChange
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRequestedServiceQuotaChangeRequest method.
//    req, resp := client.GetRequestedServiceQuotaChangeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange
func (c *ServiceQuotas) GetRequestedServiceQuotaChangeRequest(input *GetRequestedServiceQuotaChangeInput) (req *request.Request, output *GetRequestedServiceQuotaChangeOutput) {
	op := &request.Operation{
		Name:       opGetRequestedServiceQuotaChange,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRequestedServiceQuotaChangeInput{}
	}

	output = &GetRequestedServiceQuotaChangeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRequestedServiceQuotaChange API operation for Service Quotas.
//
// Retrieves the details for a particular increase request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetRequestedServiceQuotaChange for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange
func (c *ServiceQuotas) GetRequestedServiceQuotaChange(input *GetRequestedServiceQuotaChangeInput) (*GetRequestedServiceQuotaChangeOutput, error) {
	req, out := c.GetRequestedServiceQuotaChangeRequest(input)
	return out, req.Send()
}

// GetRequestedServiceQuotaChangeWithContext is the same as GetRequestedServiceQuotaChange with the addition of
// the ability to pass a context and additional request options.
//
// See GetRequestedServiceQuotaChange for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetRequestedServiceQuotaChangeWithContext(ctx aws.Context, input *GetRequestedServiceQuotaChangeInput, opts ...request.Option) (*GetRequestedServiceQuotaChangeOutput, error) {
	req, out := c.GetRequestedServiceQuotaChangeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceQuota = "GetServiceQuota"

// GetServiceQuotaRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceQuota for more information on using the GetServiceQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceQuotaRequest method.
//    req, resp := client.GetServiceQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota
func (c *ServiceQuotas) GetServiceQuotaRequest(input *GetServiceQuotaInput) (req *request.Request, output *GetServiceQuotaOutput) {
	op := &request.Operation{
		Name:       opGetServiceQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceQuotaInput{}
	}

	output = &GetServiceQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceQuota API operation for Service Quotas.
//
// Returns the details for the specified service quota. This operation provides
// a different Value than the GetAWSDefaultServiceQuota operation. This operation
// returns the applied value for each quota. GetAWSDefaultServiceQuota returns
// the default AWS value for each quota.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetServiceQuota for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota
func (c *ServiceQuotas) GetServiceQuota(input *GetServiceQuotaInput) (*GetServiceQuotaOutput, error) {
	req, out := c.GetServiceQuotaRequest(input)
	return out, req.Send()
}

// GetServiceQuotaWithContext is the same as GetServiceQuota with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetServiceQuotaWithContext(ctx aws.Context, input *GetServiceQuotaInput, opts ...request.Option) (*GetServiceQuotaOutput, error) {
	req, out := c.GetServiceQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceQuotaIncreaseRequestFromTemplate = "GetServiceQuotaIncreaseRequestFromTemplate"

// GetServiceQuotaIncreaseRequestFromTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceQuotaIncreaseRequestFromTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceQuotaIncreaseRequestFromTemplate for more information on using the GetServiceQuotaIncreaseRequestFromTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceQuotaIncreaseRequestFromTemplateRequest method.
//    req, resp := client.GetServiceQuotaIncreaseRequestFromTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) GetServiceQuotaIncreaseRequestFromTemplateRequest(input *GetServiceQuotaIncreaseRequestFromTemplateInput) (req *request.Request, output *GetServiceQuotaIncreaseRequestFromTemplateOutput) {
	op := &request.Operation{
		Name:       opGetServiceQuotaIncreaseRequestFromTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceQuotaIncreaseRequestFromTemplateInput{}
	}

	output = &GetServiceQuotaIncreaseRequestFromTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceQuotaIncreaseRequestFromTemplate API operation for Service Quotas.
//
// Returns the details of the service quota increase request in your template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation GetServiceQuotaIncreaseRequestFromTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeAWSServiceAccessNotEnabledException "AWSServiceAccessNotEnabledException"
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization. To enable, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeTemplatesNotAvailableInRegionException "TemplatesNotAvailableInRegionException"
//   The Service Quotas template is not available in the Region where you are
//   making the request. Please make the request in us-east-1.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate
func (c *ServiceQuotas) GetServiceQuotaIncreaseRequestFromTemplate(input *GetServiceQuotaIncreaseRequestFromTemplateInput) (*GetServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.GetServiceQuotaIncreaseRequestFromTemplateRequest(input)
	return out, req.Send()
}

// GetServiceQuotaIncreaseRequestFromTemplateWithContext is the same as GetServiceQuotaIncreaseRequestFromTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceQuotaIncreaseRequestFromTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) GetServiceQuotaIncreaseRequestFromTemplateWithContext(ctx aws.Context, input *GetServiceQuotaIncreaseRequestFromTemplateInput, opts ...request.Option) (*GetServiceQuotaIncreaseRequestFromTemplateOutput, error) {
	req, out := c.GetServiceQuotaIncreaseRequestFromTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAWSDefaultServiceQuotas = "ListAWSDefaultServiceQuotas"

// ListAWSDefaultServiceQuotasRequest generates a "aws/request.Request" representing the
// client's request for the ListAWSDefaultServiceQuotas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAWSDefaultServiceQuotas for more information on using the ListAWSDefaultServiceQuotas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAWSDefaultServiceQuotasRequest method.
//    req, resp := client.ListAWSDefaultServiceQuotasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasRequest(input *ListAWSDefaultServiceQuotasInput) (req *request.Request, output *ListAWSDefaultServiceQuotasOutput) {
	op := &request.Operation{
		Name:       opListAWSDefaultServiceQuotas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAWSDefaultServiceQuotasInput{}
	}

	output = &ListAWSDefaultServiceQuotasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAWSDefaultServiceQuotas API operation for Service Quotas.
//
// Lists all default service quotas for the specified AWS service or all AWS
// services. ListAWSDefaultServiceQuotas is similar to ListServiceQuotas except
// for the Value object. The Value object returned by ListAWSDefaultServiceQuotas
// is the default value assigned by AWS. This request returns a list of all
// service quotas for the specified service. The listing of each you'll see
// the default values are the values that AWS provides for the quotas.
//
// Always check the NextToken response parameter when calling any of the List*
// operations. These operations can return an unexpected list of results, even
// when there are more results available. When this happens, the NextToken response
// parameter contains a value to pass the next call to the same API to request
// the next part of the list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListAWSDefaultServiceQuotas for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeInvalidPaginationTokenException "InvalidPaginationTokenException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas
func (c *ServiceQuotas) ListAWSDefaultServiceQuotas(input *ListAWSDefaultServiceQuotasInput) (*ListAWSDefaultServiceQuotasOutput, error) {
	req, out := c.ListAWSDefaultServiceQuotasRequest(input)
	return out, req.Send()
}

// ListAWSDefaultServiceQuotasWithContext is the same as ListAWSDefaultServiceQuotas with the addition of
// the ability to pass a context and additional request options.
//
// See ListAWSDefaultServiceQuotas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasWithContext(ctx aws.Context, input *ListAWSDefaultServiceQuotasInput, opts ...request.Option) (*ListAWSDefaultServiceQuotasOutput, error) {
	req, out := c.ListAWSDefaultServiceQuotasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAWSDefaultServiceQuotasPages iterates over the pages of a ListAWSDefaultServiceQuotas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAWSDefaultServiceQuotas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAWSDefaultServiceQuotas operation.
//    pageNum := 0
//    err := client.ListAWSDefaultServiceQuotasPages(params,
//        func(page *servicequotas.ListAWSDefaultServiceQuotasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasPages(input *ListAWSDefaultServiceQuotasInput, fn func(*ListAWSDefaultServiceQuotasOutput, bool) bool) error {
	return c.ListAWSDefaultServiceQuotasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAWSDefaultServiceQuotasPagesWithContext same as ListAWSDefaultServiceQuotasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListAWSDefaultServiceQuotasPagesWithContext(ctx aws.Context, input *ListAWSDefaultServiceQuotasInput, fn func(*ListAWSDefaultServiceQuotasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAWSDefaultServiceQuotasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAWSDefaultServiceQuotasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAWSDefaultServiceQuotasOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRequestedServiceQuotaChangeHistory = "ListRequestedServiceQuotaChangeHistory"

// ListRequestedServiceQuotaChangeHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListRequestedServiceQuotaChangeHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRequestedServiceQuotaChangeHistory for more information on using the ListRequestedServiceQuotaChangeHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRequestedServiceQuotaChangeHistoryRequest method.
//    req, resp := client.ListRequestedServiceQuotaChangeHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryRequest(input *ListRequestedServiceQuotaChangeHistoryInput) (req *request.Request, output *ListRequestedServiceQuotaChangeHistoryOutput) {
	op := &request.Operation{
		Name:       opListRequestedServiceQuotaChangeHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRequestedServiceQuotaChangeHistoryInput{}
	}

	output = &ListRequestedServiceQuotaChangeHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRequestedServiceQuotaChangeHistory API operation for Service Quotas.
//
// Requests a list of the changes to quotas for a service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListRequestedServiceQuotaChangeHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeInvalidPaginationTokenException "InvalidPaginationTokenException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistory(input *ListRequestedServiceQuotaChangeHistoryInput) (*ListRequestedServiceQuotaChangeHistoryOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryRequest(input)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryWithContext is the same as ListRequestedServiceQuotaChangeHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListRequestedServiceQuotaChangeHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryInput, opts ...request.Option) (*ListRequestedServiceQuotaChangeHistoryOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryPages iterates over the pages of a ListRequestedServiceQuotaChangeHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRequestedServiceQuotaChangeHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRequestedServiceQuotaChangeHistory operation.
//    pageNum := 0
//    err := client.ListRequestedServiceQuotaChangeHistoryPages(params,
//        func(page *servicequotas.ListRequestedServiceQuotaChangeHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryPages(input *ListRequestedServiceQuotaChangeHistoryInput, fn func(*ListRequestedServiceQuotaChangeHistoryOutput, bool) bool) error {
	return c.ListRequestedServiceQuotaChangeHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRequestedServiceQuotaChangeHistoryPagesWithContext same as ListRequestedServiceQuotaChangeHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryPagesWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryInput, fn func(*ListRequestedServiceQuotaChangeHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRequestedServiceQuotaChangeHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRequestedServiceQuotaChangeHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRequestedServiceQuotaChangeHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRequestedServiceQuotaChangeHistoryByQuota = "ListRequestedServiceQuotaChangeHistoryByQuota"

// ListRequestedServiceQuotaChangeHistoryByQuotaRequest generates a "aws/request.Request" representing the
// client's request for the ListRequestedServiceQuotaChangeHistoryByQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRequestedServiceQuotaChangeHistoryByQuota for more information on using the ListRequestedServiceQuotaChangeHistoryByQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRequestedServiceQuotaChangeHistoryByQuotaRequest method.
//    req, resp := client.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input *ListRequestedServiceQuotaChangeHistoryByQuotaInput) (req *request.Request, output *ListRequestedServiceQuotaChangeHistoryByQuotaOutput) {
	op := &request.Operation{
		Name:       opListRequestedServiceQuotaChangeHistoryByQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRequestedServiceQuotaChangeHistoryByQuotaInput{}
	}

	output = &ListRequestedServiceQuotaChangeHistoryByQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRequestedServiceQuotaChangeHistoryByQuota API operation for Service Quotas.
//
// Requests a list of the changes to specific service quotas. This command provides
// additional granularity over the ListRequestedServiceQuotaChangeHistory command.
// Once a quota change request has reached CASE_CLOSED, APPROVED, or DENIED,
// the history has been kept for 90 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListRequestedServiceQuotaChangeHistoryByQuota for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeInvalidPaginationTokenException "InvalidPaginationTokenException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuota(input *ListRequestedServiceQuotaChangeHistoryByQuotaInput) (*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryByQuotaWithContext is the same as ListRequestedServiceQuotaChangeHistoryByQuota with the addition of
// the ability to pass a context and additional request options.
//
// See ListRequestedServiceQuotaChangeHistoryByQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryByQuotaInput, opts ...request.Option) (*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, error) {
	req, out := c.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRequestedServiceQuotaChangeHistoryByQuotaPages iterates over the pages of a ListRequestedServiceQuotaChangeHistoryByQuota operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRequestedServiceQuotaChangeHistoryByQuota method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRequestedServiceQuotaChangeHistoryByQuota operation.
//    pageNum := 0
//    err := client.ListRequestedServiceQuotaChangeHistoryByQuotaPages(params,
//        func(page *servicequotas.ListRequestedServiceQuotaChangeHistoryByQuotaOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaPages(input *ListRequestedServiceQuotaChangeHistoryByQuotaInput, fn func(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, bool) bool) error {
	return c.ListRequestedServiceQuotaChangeHistoryByQuotaPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRequestedServiceQuotaChangeHistoryByQuotaPagesWithContext same as ListRequestedServiceQuotaChangeHistoryByQuotaPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListRequestedServiceQuotaChangeHistoryByQuotaPagesWithContext(ctx aws.Context, input *ListRequestedServiceQuotaChangeHistoryByQuotaInput, fn func(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRequestedServiceQuotaChangeHistoryByQuotaInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListServiceQuotaIncreaseRequestsInTemplate = "ListServiceQuotaIncreaseRequestsInTemplate"

// ListServiceQuotaIncreaseRequestsInTemplateRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceQuotaIncreaseRequestsInTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceQuotaIncreaseRequestsInTemplate for more information on using the ListServiceQuotaIncreaseRequestsInTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServiceQuotaIncreaseRequestsInTemplateRequest method.
//    req, resp := client.ListServiceQuotaIncreaseRequestsInTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplateRequest(input *ListServiceQuotaIncreaseRequestsInTemplateInput) (req *request.Request, output *ListServiceQuotaIncreaseRequestsInTemplateOutput) {
	op := &request.Operation{
		Name:       opListServiceQuotaIncreaseRequestsInTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceQuotaIncreaseRequestsInTemplateInput{}
	}

	output = &ListServiceQuotaIncreaseRequestsInTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceQuotaIncreaseRequestsInTemplate API operation for Service Quotas.
//
// Returns a list of the quota increase requests in the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListServiceQuotaIncreaseRequestsInTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeAWSServiceAccessNotEnabledException "AWSServiceAccessNotEnabledException"
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization. To enable, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeTemplatesNotAvailableInRegionException "TemplatesNotAvailableInRegionException"
//   The Service Quotas template is not available in the Region where you are
//   making the request. Please make the request in us-east-1.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplate(input *ListServiceQuotaIncreaseRequestsInTemplateInput) (*ListServiceQuotaIncreaseRequestsInTemplateOutput, error) {
	req, out := c.ListServiceQuotaIncreaseRequestsInTemplateRequest(input)
	return out, req.Send()
}

// ListServiceQuotaIncreaseRequestsInTemplateWithContext is the same as ListServiceQuotaIncreaseRequestsInTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceQuotaIncreaseRequestsInTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplateWithContext(ctx aws.Context, input *ListServiceQuotaIncreaseRequestsInTemplateInput, opts ...request.Option) (*ListServiceQuotaIncreaseRequestsInTemplateOutput, error) {
	req, out := c.ListServiceQuotaIncreaseRequestsInTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceQuotaIncreaseRequestsInTemplatePages iterates over the pages of a ListServiceQuotaIncreaseRequestsInTemplate operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceQuotaIncreaseRequestsInTemplate method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServiceQuotaIncreaseRequestsInTemplate operation.
//    pageNum := 0
//    err := client.ListServiceQuotaIncreaseRequestsInTemplatePages(params,
//        func(page *servicequotas.ListServiceQuotaIncreaseRequestsInTemplateOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplatePages(input *ListServiceQuotaIncreaseRequestsInTemplateInput, fn func(*ListServiceQuotaIncreaseRequestsInTemplateOutput, bool) bool) error {
	return c.ListServiceQuotaIncreaseRequestsInTemplatePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceQuotaIncreaseRequestsInTemplatePagesWithContext same as ListServiceQuotaIncreaseRequestsInTemplatePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotaIncreaseRequestsInTemplatePagesWithContext(ctx aws.Context, input *ListServiceQuotaIncreaseRequestsInTemplateInput, fn func(*ListServiceQuotaIncreaseRequestsInTemplateOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceQuotaIncreaseRequestsInTemplateInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceQuotaIncreaseRequestsInTemplateRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListServiceQuotaIncreaseRequestsInTemplateOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListServiceQuotas = "ListServiceQuotas"

// ListServiceQuotasRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceQuotas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceQuotas for more information on using the ListServiceQuotas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServiceQuotasRequest method.
//    req, resp := client.ListServiceQuotasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas
func (c *ServiceQuotas) ListServiceQuotasRequest(input *ListServiceQuotasInput) (req *request.Request, output *ListServiceQuotasOutput) {
	op := &request.Operation{
		Name:       opListServiceQuotas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceQuotasInput{}
	}

	output = &ListServiceQuotasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceQuotas API operation for Service Quotas.
//
// Lists all service quotas for the specified AWS service. This request returns
// a list of the service quotas for the specified service. you'll see the default
// values are the values that AWS provides for the quotas.
//
// Always check the NextToken response parameter when calling any of the List*
// operations. These operations can return an unexpected list of results, even
// when there are more results available. When this happens, the NextToken response
// parameter contains a value to pass the next call to the same API to request
// the next part of the list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListServiceQuotas for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeInvalidPaginationTokenException "InvalidPaginationTokenException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas
func (c *ServiceQuotas) ListServiceQuotas(input *ListServiceQuotasInput) (*ListServiceQuotasOutput, error) {
	req, out := c.ListServiceQuotasRequest(input)
	return out, req.Send()
}

// ListServiceQuotasWithContext is the same as ListServiceQuotas with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceQuotas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotasWithContext(ctx aws.Context, input *ListServiceQuotasInput, opts ...request.Option) (*ListServiceQuotasOutput, error) {
	req, out := c.ListServiceQuotasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceQuotasPages iterates over the pages of a ListServiceQuotas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceQuotas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServiceQuotas operation.
//    pageNum := 0
//    err := client.ListServiceQuotasPages(params,
//        func(page *servicequotas.ListServiceQuotasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListServiceQuotasPages(input *ListServiceQuotasInput, fn func(*ListServiceQuotasOutput, bool) bool) error {
	return c.ListServiceQuotasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceQuotasPagesWithContext same as ListServiceQuotasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServiceQuotasPagesWithContext(ctx aws.Context, input *ListServiceQuotasInput, fn func(*ListServiceQuotasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceQuotasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceQuotasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListServiceQuotasOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServicesRequest method.
//    req, resp := client.ListServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices
func (c *ServiceQuotas) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for Service Quotas.
//
// Lists the AWS services available in Service Quotas. Not all AWS services
// are available in Service Quotas. To list the see the list of the service
// quotas for a specific service, use ListServiceQuotas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation ListServices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeInvalidPaginationTokenException "InvalidPaginationTokenException"
//   Invalid input was provided.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices
func (c *ServiceQuotas) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServices operation.
//    pageNum := 0
//    err := client.ListServicesPages(params,
//        func(page *servicequotas.ListServicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceQuotas) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListServicesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutServiceQuotaIncreaseRequestIntoTemplate = "PutServiceQuotaIncreaseRequestIntoTemplate"

// PutServiceQuotaIncreaseRequestIntoTemplateRequest generates a "aws/request.Request" representing the
// client's request for the PutServiceQuotaIncreaseRequestIntoTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutServiceQuotaIncreaseRequestIntoTemplate for more information on using the PutServiceQuotaIncreaseRequestIntoTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutServiceQuotaIncreaseRequestIntoTemplateRequest method.
//    req, resp := client.PutServiceQuotaIncreaseRequestIntoTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate
func (c *ServiceQuotas) PutServiceQuotaIncreaseRequestIntoTemplateRequest(input *PutServiceQuotaIncreaseRequestIntoTemplateInput) (req *request.Request, output *PutServiceQuotaIncreaseRequestIntoTemplateOutput) {
	op := &request.Operation{
		Name:       opPutServiceQuotaIncreaseRequestIntoTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutServiceQuotaIncreaseRequestIntoTemplateInput{}
	}

	output = &PutServiceQuotaIncreaseRequestIntoTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutServiceQuotaIncreaseRequestIntoTemplate API operation for Service Quotas.
//
// Defines and adds a quota to the service quota template. To add a quota to
// the template, you must provide the ServiceCode, QuotaCode, AwsRegion, and
// DesiredValue. Once you add a quota to the template, use ListServiceQuotaIncreaseRequestsInTemplate
// to see the list of quotas in the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation PutServiceQuotaIncreaseRequestIntoTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeQuotaExceededException "QuotaExceededException"
//   You have exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use Service Quotas to request a service
//   quota increase.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeAWSServiceAccessNotEnabledException "AWSServiceAccessNotEnabledException"
//   The action you attempted is not allowed unless Service Access with Service
//   Quotas is enabled in your organization. To enable, call AssociateServiceQuotaTemplate.
//
//   * ErrCodeTemplatesNotAvailableInRegionException "TemplatesNotAvailableInRegionException"
//   The Service Quotas template is not available in the Region where you are
//   making the request. Please make the request in us-east-1.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   The account making this call is not a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate
func (c *ServiceQuotas) PutServiceQuotaIncreaseRequestIntoTemplate(input *PutServiceQuotaIncreaseRequestIntoTemplateInput) (*PutServiceQuotaIncreaseRequestIntoTemplateOutput, error) {
	req, out := c.PutServiceQuotaIncreaseRequestIntoTemplateRequest(input)
	return out, req.Send()
}

// PutServiceQuotaIncreaseRequestIntoTemplateWithContext is the same as PutServiceQuotaIncreaseRequestIntoTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See PutServiceQuotaIncreaseRequestIntoTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) PutServiceQuotaIncreaseRequestIntoTemplateWithContext(ctx aws.Context, input *PutServiceQuotaIncreaseRequestIntoTemplateInput, opts ...request.Option) (*PutServiceQuotaIncreaseRequestIntoTemplateOutput, error) {
	req, out := c.PutServiceQuotaIncreaseRequestIntoTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestServiceQuotaIncrease = "RequestServiceQuotaIncrease"

// RequestServiceQuotaIncreaseRequest generates a "aws/request.Request" representing the
// client's request for the RequestServiceQuotaIncrease operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestServiceQuotaIncrease for more information on using the RequestServiceQuotaIncrease
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestServiceQuotaIncreaseRequest method.
//    req, resp := client.RequestServiceQuotaIncreaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease
func (c *ServiceQuotas) RequestServiceQuotaIncreaseRequest(input *RequestServiceQuotaIncreaseInput) (req *request.Request, output *RequestServiceQuotaIncreaseOutput) {
	op := &request.Operation{
		Name:       opRequestServiceQuotaIncrease,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestServiceQuotaIncreaseInput{}
	}

	output = &RequestServiceQuotaIncreaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestServiceQuotaIncrease API operation for Service Quotas.
//
// Retrieves the details of a service quota increase request. The response to
// this command provides the details in the RequestedServiceQuotaChange object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Service Quotas's
// API operation RequestServiceQuotaIncrease for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDependencyAccessDeniedException "DependencyAccessDeniedException"
//   You can't perform this action because a dependency does not have access.
//
//   * ErrCodeQuotaExceededException "QuotaExceededException"
//   You have exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use Service Quotas to request a service
//   quota increase.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeNoSuchResourceException "NoSuchResourceException"
//   The specified resource does not exist.
//
//   * ErrCodeIllegalArgumentException "IllegalArgumentException"
//   Invalid input was provided.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   Invalid input was provided for the .
//
//   * ErrCodeServiceException "ServiceException"
//   Something went wrong.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Due to throttling, the request was denied. Slow down the rate of request
//   calls, or request an increase for this quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease
func (c *ServiceQuotas) RequestServiceQuotaIncrease(input *RequestServiceQuotaIncreaseInput) (*RequestServiceQuotaIncreaseOutput, error) {
	req, out := c.RequestServiceQuotaIncreaseRequest(input)
	return out, req.Send()
}

// RequestServiceQuotaIncreaseWithContext is the same as RequestServiceQuotaIncrease with the addition of
// the ability to pass a context and additional request options.
//
// See RequestServiceQuotaIncrease for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceQuotas) RequestServiceQuotaIncreaseWithContext(ctx aws.Context, input *RequestServiceQuotaIncreaseInput, opts ...request.Option) (*RequestServiceQuotaIncreaseOutput, error) {
	req, out := c.RequestServiceQuotaIncreaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceQuotaTemplateInput) GoString() string {
	return s.String()
}

type AssociateServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceQuotaTemplateOutput) GoString() string {
	return s.String()
}

type DeleteServiceQuotaIncreaseRequestFromTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS Region for the quota that you want to delete.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// Specifies the code for the quota that you want to delete.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the code for the service that you want to delete.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceQuotaIncreaseRequestFromTemplateInput"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) SetAwsRegion(v string) *DeleteServiceQuotaIncreaseRequestFromTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) SetQuotaCode(v string) *DeleteServiceQuotaIncreaseRequestFromTemplateInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *DeleteServiceQuotaIncreaseRequestFromTemplateInput) SetServiceCode(v string) *DeleteServiceQuotaIncreaseRequestFromTemplateInput {
	s.ServiceCode = &v
	return s
}

type DeleteServiceQuotaIncreaseRequestFromTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceQuotaIncreaseRequestFromTemplateOutput) GoString() string {
	return s.String()
}

type DisassociateServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceQuotaTemplateInput) GoString() string {
	return s.String()
}

type DisassociateServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceQuotaTemplateOutput) GoString() string {
	return s.String()
}

// Returns an error that explains why the action did not succeed.
type ErrorReason struct {
	_ struct{} `type:"structure"`

	// Service Quotas returns the following error values.
	//
	// DEPENDENCY_ACCESS_DENIED_ERROR is returned when the caller does not have
	// permission to call the service or service quota. To resolve the error, you
	// need permission to access the service or service quota.
	//
	// DEPENDENCY_THROTTLING_ERROR is returned when the service being called is
	// throttling Service Quotas.
	//
	// DEPENDENCY_SERVICE_ERROR is returned when the service being called has availability
	// issues.
	//
	// SERVICE_QUOTA_NOT_AVAILABLE_ERROR is returned when there was an error in
	// Service Quotas.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message that provides more detail.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorReason) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorReason) SetErrorCode(v string) *ErrorReason {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorReason) SetErrorMessage(v string) *ErrorReason {
	s.ErrorMessage = &v
	return s
}

type GetAWSDefaultServiceQuotaInput struct {
	_ struct{} `type:"structure"`

	// Identifies the service quota you want to select.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAWSDefaultServiceQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAWSDefaultServiceQuotaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAWSDefaultServiceQuotaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAWSDefaultServiceQuotaInput"}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *GetAWSDefaultServiceQuotaInput) SetQuotaCode(v string) *GetAWSDefaultServiceQuotaInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *GetAWSDefaultServiceQuotaInput) SetServiceCode(v string) *GetAWSDefaultServiceQuotaInput {
	s.ServiceCode = &v
	return s
}

type GetAWSDefaultServiceQuotaOutput struct {
	_ struct{} `type:"structure"`

	// Returns the ServiceQuota object which contains all values for a quota.
	Quota *ServiceQuota `type:"structure"`
}

// String returns the string representation
func (s GetAWSDefaultServiceQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAWSDefaultServiceQuotaOutput) GoString() string {
	return s.String()
}

// SetQuota sets the Quota field's value.
func (s *GetAWSDefaultServiceQuotaOutput) SetQuota(v *ServiceQuota) *GetAWSDefaultServiceQuotaOutput {
	s.Quota = v
	return s
}

type GetAssociationForServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAssociationForServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociationForServiceQuotaTemplateInput) GoString() string {
	return s.String()
}

type GetAssociationForServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the template is ASSOCIATED or DISASSOCIATED. If the template
	// is ASSOCIATED, then it requests service quota increases for all new accounts
	// created in your organization.
	ServiceQuotaTemplateAssociationStatus *string `type:"string" enum:"ServiceQuotaTemplateAssociationStatus"`
}

// String returns the string representation
func (s GetAssociationForServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociationForServiceQuotaTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceQuotaTemplateAssociationStatus sets the ServiceQuotaTemplateAssociationStatus field's value.
func (s *GetAssociationForServiceQuotaTemplateOutput) SetServiceQuotaTemplateAssociationStatus(v string) *GetAssociationForServiceQuotaTemplateOutput {
	s.ServiceQuotaTemplateAssociationStatus = &v
	return s
}

type GetRequestedServiceQuotaChangeInput struct {
	_ struct{} `type:"structure"`

	// Identifies the quota increase request.
	//
	// RequestId is a required field
	RequestId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRequestedServiceQuotaChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRequestedServiceQuotaChangeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRequestedServiceQuotaChangeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRequestedServiceQuotaChangeInput"}
	if s.RequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestId"))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestId sets the RequestId field's value.
func (s *GetRequestedServiceQuotaChangeInput) SetRequestId(v string) *GetRequestedServiceQuotaChangeInput {
	s.RequestId = &v
	return s
}

type GetRequestedServiceQuotaChangeOutput struct {
	_ struct{} `type:"structure"`

	// Returns the RequestedServiceQuotaChange object for the specific increase
	// request.
	RequestedQuota *RequestedServiceQuotaChange `type:"structure"`
}

// String returns the string representation
func (s GetRequestedServiceQuotaChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRequestedServiceQuotaChangeOutput) GoString() string {
	return s.String()
}

// SetRequestedQuota sets the RequestedQuota field's value.
func (s *GetRequestedServiceQuotaChangeOutput) SetRequestedQuota(v *RequestedServiceQuotaChange) *GetRequestedServiceQuotaChangeOutput {
	s.RequestedQuota = v
	return s
}

type GetServiceQuotaIncreaseRequestFromTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS Region for the quota that you want to use.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// Specifies the quota you want.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceQuotaIncreaseRequestFromTemplateInput"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) SetAwsRegion(v string) *GetServiceQuotaIncreaseRequestFromTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) SetQuotaCode(v string) *GetServiceQuotaIncreaseRequestFromTemplateInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateInput) SetServiceCode(v string) *GetServiceQuotaIncreaseRequestFromTemplateInput {
	s.ServiceCode = &v
	return s
}

type GetServiceQuotaIncreaseRequestFromTemplateOutput struct {
	_ struct{} `type:"structure"`

	// This object contains the details about the quota increase request.
	ServiceQuotaIncreaseRequestInTemplate *ServiceQuotaIncreaseRequestInTemplate `type:"structure"`
}

// String returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaIncreaseRequestFromTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceQuotaIncreaseRequestInTemplate sets the ServiceQuotaIncreaseRequestInTemplate field's value.
func (s *GetServiceQuotaIncreaseRequestFromTemplateOutput) SetServiceQuotaIncreaseRequestInTemplate(v *ServiceQuotaIncreaseRequestInTemplate) *GetServiceQuotaIncreaseRequestFromTemplateOutput {
	s.ServiceQuotaIncreaseRequestInTemplate = v
	return s
}

type GetServiceQuotaInput struct {
	_ struct{} `type:"structure"`

	// Identifies the service quota you want to select.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceQuotaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceQuotaInput"}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *GetServiceQuotaInput) SetQuotaCode(v string) *GetServiceQuotaInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *GetServiceQuotaInput) SetServiceCode(v string) *GetServiceQuotaInput {
	s.ServiceCode = &v
	return s
}

type GetServiceQuotaOutput struct {
	_ struct{} `type:"structure"`

	// Returns the ServiceQuota object which contains all values for a quota.
	Quota *ServiceQuota `type:"structure"`
}

// String returns the string representation
func (s GetServiceQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceQuotaOutput) GoString() string {
	return s.String()
}

// SetQuota sets the Quota field's value.
func (s *GetServiceQuotaOutput) SetQuota(v *ServiceQuota) *GetServiceQuotaOutput {
	s.Quota = v
	return s
}

type ListAWSDefaultServiceQuotasInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from. If additional
	// items exist beyond the specified maximum, the NextToken element is present
	// and has a value (isn't null). Include that value as the NextToken request
	// parameter in the call to the operation to get the next part of the results.
	// You should check NextToken after every operation to ensure that you receive
	// all of the results.
	NextToken *string `type:"string"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAWSDefaultServiceQuotasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAWSDefaultServiceQuotasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAWSDefaultServiceQuotasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAWSDefaultServiceQuotasInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAWSDefaultServiceQuotasInput) SetMaxResults(v int64) *ListAWSDefaultServiceQuotasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAWSDefaultServiceQuotasInput) SetNextToken(v string) *ListAWSDefaultServiceQuotasInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListAWSDefaultServiceQuotasInput) SetServiceCode(v string) *ListAWSDefaultServiceQuotasInput {
	s.ServiceCode = &v
	return s
}

type ListAWSDefaultServiceQuotasOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// A list of the quotas in the account with the AWS default values.
	Quotas []*ServiceQuota `type:"list"`
}

// String returns the string representation
func (s ListAWSDefaultServiceQuotasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAWSDefaultServiceQuotasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAWSDefaultServiceQuotasOutput) SetNextToken(v string) *ListAWSDefaultServiceQuotasOutput {
	s.NextToken = &v
	return s
}

// SetQuotas sets the Quotas field's value.
func (s *ListAWSDefaultServiceQuotasOutput) SetQuotas(v []*ServiceQuota) *ListAWSDefaultServiceQuotasOutput {
	s.Quotas = v
	return s
}

type ListRequestedServiceQuotaChangeHistoryByQuotaInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// Specifies the service quota that you want to use
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`

	// Specifies the status value of the quota increase request.
	Status *string `type:"string" enum:"RequestStatus"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRequestedServiceQuotaChangeHistoryByQuotaInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetMaxResults(v int64) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.NextToken = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetQuotaCode(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetServiceCode(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.ServiceCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) SetStatus(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaInput {
	s.Status = &v
	return s
}

type ListRequestedServiceQuotaChangeHistoryByQuotaOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates there's more output available
	// that what's included in the current response. This can occur even when the
	// response includes no values at all, such as when you ask for a filtered view
	// of a very long list. Use this value in the NextToken request parameter in
	// a subsequent call to the operation to continue processing and get the next
	// part of the output. You should repeat this until the NextToken response element
	// comes back empty (as null).
	NextToken *string `type:"string"`

	// Returns a list of service quota requests.
	RequestedQuotas []*RequestedServiceQuotaChange `type:"list"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaOutput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryByQuotaOutput {
	s.NextToken = &v
	return s
}

// SetRequestedQuotas sets the RequestedQuotas field's value.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaOutput) SetRequestedQuotas(v []*RequestedServiceQuotaChange) *ListRequestedServiceQuotaChangeHistoryByQuotaOutput {
	s.RequestedQuotas = v
	return s
}

type ListRequestedServiceQuotaChangeHistoryInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// Specifies the service that you want to use.
	ServiceCode *string `min:"1" type:"string"`

	// Specifies the status value of the quota increase request.
	Status *string `type:"string" enum:"RequestStatus"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRequestedServiceQuotaChangeHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRequestedServiceQuotaChangeHistoryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetMaxResults(v int64) *ListRequestedServiceQuotaChangeHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetServiceCode(v string) *ListRequestedServiceQuotaChangeHistoryInput {
	s.ServiceCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRequestedServiceQuotaChangeHistoryInput) SetStatus(v string) *ListRequestedServiceQuotaChangeHistoryInput {
	s.Status = &v
	return s
}

type ListRequestedServiceQuotaChangeHistoryOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates there's more output available
	// that what's included in the current response. This can occur even when the
	// response includes no values at all, such as when you ask for a filtered view
	// of a very long list. Use this value in the NextToken request parameter in
	// a subsequent call to the operation to continue processing and get the next
	// part of the output. You should repeat this until the NextToken response element
	// comes back empty (as null).
	NextToken *string `type:"string"`

	// Returns a list of service quota requests.
	RequestedQuotas []*RequestedServiceQuotaChange `type:"list"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRequestedServiceQuotaChangeHistoryOutput) SetNextToken(v string) *ListRequestedServiceQuotaChangeHistoryOutput {
	s.NextToken = &v
	return s
}

// SetRequestedQuotas sets the RequestedQuotas field's value.
func (s *ListRequestedServiceQuotaChangeHistoryOutput) SetRequestedQuotas(v []*RequestedServiceQuotaChange) *ListRequestedServiceQuotaChangeHistoryOutput {
	s.RequestedQuotas = v
	return s
}

type ListServiceQuotaIncreaseRequestsInTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS Region for the quota that you want to use.
	AwsRegion *string `min:"1" type:"string"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The identifier for a service. When performing an operation, use the ServiceCode
	// to specify a particular service.
	ServiceCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceQuotaIncreaseRequestsInTemplateInput"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetAwsRegion(v string) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetMaxResults(v int64) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetNextToken(v string) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) SetServiceCode(v string) *ListServiceQuotaIncreaseRequestsInTemplateInput {
	s.ServiceCode = &v
	return s
}

type ListServiceQuotaIncreaseRequestsInTemplateOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates there's more output available
	// that what's included in the current response. This can occur even when the
	// response includes no values at all, such as when you ask for a filtered view
	// of a very long list. Use this value in the NextToken request parameter in
	// a subsequent call to the operation to continue processing and get the next
	// part of the output. You should repeat this until the NextToken response element
	// comes back empty (as null).
	NextToken *string `type:"string"`

	// Returns the list of values of the quota increase request in the template.
	ServiceQuotaIncreaseRequestInTemplateList []*ServiceQuotaIncreaseRequestInTemplate `type:"list"`
}

// String returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateOutput) SetNextToken(v string) *ListServiceQuotaIncreaseRequestsInTemplateOutput {
	s.NextToken = &v
	return s
}

// SetServiceQuotaIncreaseRequestInTemplateList sets the ServiceQuotaIncreaseRequestInTemplateList field's value.
func (s *ListServiceQuotaIncreaseRequestsInTemplateOutput) SetServiceQuotaIncreaseRequestInTemplateList(v []*ServiceQuotaIncreaseRequestInTemplate) *ListServiceQuotaIncreaseRequestsInTemplateOutput {
	s.ServiceQuotaIncreaseRequestInTemplateList = v
	return s
}

type ListServiceQuotasInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The identifier for a service. When performing an operation, use the ServiceCode
	// to specify a particular service.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListServiceQuotasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceQuotasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceQuotasInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceQuotasInput) SetMaxResults(v int64) *ListServiceQuotasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotasInput) SetNextToken(v string) *ListServiceQuotasInput {
	s.NextToken = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ListServiceQuotasInput) SetServiceCode(v string) *ListServiceQuotasInput {
	s.ServiceCode = &v
	return s
}

type ListServiceQuotasOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates there's more output available
	// that what's included in the current response. This can occur even when the
	// response includes no values at all, such as when you ask for a filtered view
	// of a very long list. Use this value in the NextToken request parameter in
	// a subsequent call to the operation to continue processing and get the next
	// part of the output. You should repeat this until the NextToken response element
	// comes back empty (as null).
	NextToken *string `type:"string"`

	// The response information for a quota lists all attribute information for
	// the quota.
	Quotas []*ServiceQuota `type:"list"`
}

// String returns the string representation
func (s ListServiceQuotasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceQuotasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceQuotasOutput) SetNextToken(v string) *ListServiceQuotasOutput {
	s.NextToken = &v
	return s
}

// SetQuotas sets the Quotas field's value.
func (s *ListServiceQuotasOutput) SetQuotas(v []*ServiceQuota) *ListServiceQuotasOutput {
	s.Quotas = v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates there's more output available
	// that what's included in the current response. This can occur even when the
	// response includes no values at all, such as when you ask for a filtered view
	// of a very long list. Use this value in the NextToken request parameter in
	// a subsequent call to the operation to continue processing and get the next
	// part of the output. You should repeat this until the NextToken response element
	// comes back empty (as null).
	NextToken *string `type:"string"`

	// Returns a list of services.
	Services []*ServiceInfo `type:"list"`
}

// String returns the string representation
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *ListServicesOutput) SetServices(v []*ServiceInfo) *ListServicesOutput {
	s.Services = v
	return s
}

// A structure that uses CloudWatch metrics to gather data about the service
// quota.
type MetricInfo struct {
	_ struct{} `type:"structure"`

	// A dimension is a name/value pair that is part of the identity of a metric.
	// Every metric has specific characteristics that describe it, and you can think
	// of dimensions as categories for those characteristics. These dimensions are
	// part of the CloudWatch Metric Identity that measures usage against a particular
	// service quota.
	MetricDimensions map[string]*string `type:"map"`

	// The name of the CloudWatch metric that measures usage of a service quota.
	// This is a required field.
	MetricName *string `type:"string"`

	// The namespace of the metric. The namespace is a container for CloudWatch
	// metrics. You can specify a name for the namespace when you create a metric.
	MetricNamespace *string `type:"string"`

	// Statistics are metric data aggregations over specified periods of time. This
	// is the recommended statistic to use when comparing usage in the CloudWatch
	// Metric against your Service Quota.
	MetricStatisticRecommendation *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricInfo) GoString() string {
	return s.String()
}

// SetMetricDimensions sets the MetricDimensions field's value.
func (s *MetricInfo) SetMetricDimensions(v map[string]*string) *MetricInfo {
	s.MetricDimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricInfo) SetMetricName(v string) *MetricInfo {
	s.MetricName = &v
	return s
}

// SetMetricNamespace sets the MetricNamespace field's value.
func (s *MetricInfo) SetMetricNamespace(v string) *MetricInfo {
	s.MetricNamespace = &v
	return s
}

// SetMetricStatisticRecommendation sets the MetricStatisticRecommendation field's value.
func (s *MetricInfo) SetMetricStatisticRecommendation(v string) *MetricInfo {
	s.MetricStatisticRecommendation = &v
	return s
}

type PutServiceQuotaIncreaseRequestIntoTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS Region for the quota.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// Specifies the new, increased value for the quota.
	//
	// DesiredValue is a required field
	DesiredValue *float64 `type:"double" required:"true"`

	// Specifies the service quota that you want to use.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutServiceQuotaIncreaseRequestIntoTemplateInput"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.DesiredValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredValue"))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetAwsRegion(v string) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.AwsRegion = &v
	return s
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetDesiredValue(v float64) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.DesiredValue = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetQuotaCode(v string) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateInput) SetServiceCode(v string) *PutServiceQuotaIncreaseRequestIntoTemplateInput {
	s.ServiceCode = &v
	return s
}

type PutServiceQuotaIncreaseRequestIntoTemplateOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about one service quota increase request.
	ServiceQuotaIncreaseRequestInTemplate *ServiceQuotaIncreaseRequestInTemplate `type:"structure"`
}

// String returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutServiceQuotaIncreaseRequestIntoTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceQuotaIncreaseRequestInTemplate sets the ServiceQuotaIncreaseRequestInTemplate field's value.
func (s *PutServiceQuotaIncreaseRequestIntoTemplateOutput) SetServiceQuotaIncreaseRequestInTemplate(v *ServiceQuotaIncreaseRequestInTemplate) *PutServiceQuotaIncreaseRequestIntoTemplateOutput {
	s.ServiceQuotaIncreaseRequestInTemplate = v
	return s
}

// A structure that contains information about the quota period.
type QuotaPeriod struct {
	_ struct{} `type:"structure"`

	// The time unit of a period.
	PeriodUnit *string `type:"string" enum:"PeriodUnit"`

	// The value of a period.
	PeriodValue *int64 `type:"integer"`
}

// String returns the string representation
func (s QuotaPeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuotaPeriod) GoString() string {
	return s.String()
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *QuotaPeriod) SetPeriodUnit(v string) *QuotaPeriod {
	s.PeriodUnit = &v
	return s
}

// SetPeriodValue sets the PeriodValue field's value.
func (s *QuotaPeriod) SetPeriodValue(v int64) *QuotaPeriod {
	s.PeriodValue = &v
	return s
}

type RequestServiceQuotaIncreaseInput struct {
	_ struct{} `type:"structure"`

	// Specifies the value submitted in the service quota increase request.
	//
	// DesiredValue is a required field
	DesiredValue *float64 `type:"double" required:"true"`

	// Specifies the service quota that you want to use.
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestServiceQuotaIncreaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestServiceQuotaIncreaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestServiceQuotaIncreaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestServiceQuotaIncreaseInput"}
	if s.DesiredValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredValue"))
	}
	if s.QuotaCode == nil {
		invalidParams.Add(request.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuotaCode", 1))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *RequestServiceQuotaIncreaseInput) SetDesiredValue(v float64) *RequestServiceQuotaIncreaseInput {
	s.DesiredValue = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *RequestServiceQuotaIncreaseInput) SetQuotaCode(v string) *RequestServiceQuotaIncreaseInput {
	s.QuotaCode = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *RequestServiceQuotaIncreaseInput) SetServiceCode(v string) *RequestServiceQuotaIncreaseInput {
	s.ServiceCode = &v
	return s
}

type RequestServiceQuotaIncreaseOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of service quota requests.
	RequestedQuota *RequestedServiceQuotaChange `type:"structure"`
}

// String returns the string representation
func (s RequestServiceQuotaIncreaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestServiceQuotaIncreaseOutput) GoString() string {
	return s.String()
}

// SetRequestedQuota sets the RequestedQuota field's value.
func (s *RequestServiceQuotaIncreaseOutput) SetRequestedQuota(v *RequestedServiceQuotaChange) *RequestServiceQuotaIncreaseOutput {
	s.RequestedQuota = v
	return s
}

// A structure that contains information about a requested change for a quota.
type RequestedServiceQuotaChange struct {
	_ struct{} `type:"structure"`

	// The case Id for the service quota increase request.
	CaseId *string `type:"string"`

	// The date and time when the service quota increase request was received and
	// the case Id was created.
	Created *time.Time `type:"timestamp"`

	// New increased value for the service quota.
	DesiredValue *float64 `type:"double"`

	// Identifies if the quota is global.
	GlobalQuota *bool `type:"boolean"`

	// The unique identifier of a requested service quota change.
	Id *string `min:"1" type:"string"`

	// The date and time of the most recent change in the service quota increase
	// request.
	LastUpdated *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the service quota.
	QuotaArn *string `type:"string"`

	// Specifies the service quota that you want to use.
	QuotaCode *string `min:"1" type:"string"`

	// Name of the service quota.
	QuotaName *string `type:"string"`

	// The IAM identity who submitted the service quota increase request.
	Requester *string `type:"string"`

	// Specifies the service that you want to use.
	ServiceCode *string `min:"1" type:"string"`

	// The name of the AWS service specified in the increase request.
	ServiceName *string `type:"string"`

	// State of the service quota increase request.
	Status *string `type:"string" enum:"RequestStatus"`

	// Specifies the unit used for the quota.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s RequestedServiceQuotaChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestedServiceQuotaChange) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *RequestedServiceQuotaChange) SetCaseId(v string) *RequestedServiceQuotaChange {
	s.CaseId = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *RequestedServiceQuotaChange) SetCreated(v time.Time) *RequestedServiceQuotaChange {
	s.Created = &v
	return s
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *RequestedServiceQuotaChange) SetDesiredValue(v float64) *RequestedServiceQuotaChange {
	s.DesiredValue = &v
	return s
}

// SetGlobalQuota sets the GlobalQuota field's value.
func (s *RequestedServiceQuotaChange) SetGlobalQuota(v bool) *RequestedServiceQuotaChange {
	s.GlobalQuota = &v
	return s
}

// SetId sets the Id field's value.
func (s *RequestedServiceQuotaChange) SetId(v string) *RequestedServiceQuotaChange {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *RequestedServiceQuotaChange) SetLastUpdated(v time.Time) *RequestedServiceQuotaChange {
	s.LastUpdated = &v
	return s
}

// SetQuotaArn sets the QuotaArn field's value.
func (s *RequestedServiceQuotaChange) SetQuotaArn(v string) *RequestedServiceQuotaChange {
	s.QuotaArn = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *RequestedServiceQuotaChange) SetQuotaCode(v string) *RequestedServiceQuotaChange {
	s.QuotaCode = &v
	return s
}

// SetQuotaName sets the QuotaName field's value.
func (s *RequestedServiceQuotaChange) SetQuotaName(v string) *RequestedServiceQuotaChange {
	s.QuotaName = &v
	return s
}

// SetRequester sets the Requester field's value.
func (s *RequestedServiceQuotaChange) SetRequester(v string) *RequestedServiceQuotaChange {
	s.Requester = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *RequestedServiceQuotaChange) SetServiceCode(v string) *RequestedServiceQuotaChange {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *RequestedServiceQuotaChange) SetServiceName(v string) *RequestedServiceQuotaChange {
	s.ServiceName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RequestedServiceQuotaChange) SetStatus(v string) *RequestedServiceQuotaChange {
	s.Status = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *RequestedServiceQuotaChange) SetUnit(v string) *RequestedServiceQuotaChange {
	s.Unit = &v
	return s
}

// A structure that contains the ServiceName and ServiceCode. It does not include
// all details of the service quota. To get those values, use the ListServiceQuotas
// operation.
type ServiceInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the service that you want to use.
	ServiceCode *string `min:"1" type:"string"`

	// The name of the AWS service specified in the increase request.
	ServiceName *string `type:"string"`
}

// String returns the string representation
func (s ServiceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceInfo) GoString() string {
	return s.String()
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ServiceInfo) SetServiceCode(v string) *ServiceInfo {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceInfo) SetServiceName(v string) *ServiceInfo {
	s.ServiceName = &v
	return s
}

// A structure that contains the full set of details that define the service
// quota.
type ServiceQuota struct {
	_ struct{} `type:"structure"`

	// Specifies if the quota value can be increased.
	Adjustable *bool `type:"boolean"`

	// Specifies the ErrorCode and ErrorMessage when success isn't achieved.
	ErrorReason *ErrorReason `type:"structure"`

	// Specifies if the quota is global.
	GlobalQuota *bool `type:"boolean"`

	// Identifies the unit and value of how time is measured.
	Period *QuotaPeriod `type:"structure"`

	// The Amazon Resource Name (ARN) of the service quota.
	QuotaArn *string `type:"string"`

	// The code identifier for the service quota specified.
	QuotaCode *string `min:"1" type:"string"`

	// The name identifier of the service quota.
	QuotaName *string `type:"string"`

	// Specifies the service that you want to use.
	ServiceCode *string `min:"1" type:"string"`

	// The name of the AWS service specified in the increase request.
	ServiceName *string `type:"string"`

	// The unit of measurement for the value of the service quota.
	Unit *string `type:"string"`

	// Specifies the details about the measurement.
	UsageMetric *MetricInfo `type:"structure"`

	// The value of service quota.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s ServiceQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuota) GoString() string {
	return s.String()
}

// SetAdjustable sets the Adjustable field's value.
func (s *ServiceQuota) SetAdjustable(v bool) *ServiceQuota {
	s.Adjustable = &v
	return s
}

// SetErrorReason sets the ErrorReason field's value.
func (s *ServiceQuota) SetErrorReason(v *ErrorReason) *ServiceQuota {
	s.ErrorReason = v
	return s
}

// SetGlobalQuota sets the GlobalQuota field's value.
func (s *ServiceQuota) SetGlobalQuota(v bool) *ServiceQuota {
	s.GlobalQuota = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *ServiceQuota) SetPeriod(v *QuotaPeriod) *ServiceQuota {
	s.Period = v
	return s
}

// SetQuotaArn sets the QuotaArn field's value.
func (s *ServiceQuota) SetQuotaArn(v string) *ServiceQuota {
	s.QuotaArn = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *ServiceQuota) SetQuotaCode(v string) *ServiceQuota {
	s.QuotaCode = &v
	return s
}

// SetQuotaName sets the QuotaName field's value.
func (s *ServiceQuota) SetQuotaName(v string) *ServiceQuota {
	s.QuotaName = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ServiceQuota) SetServiceCode(v string) *ServiceQuota {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceQuota) SetServiceName(v string) *ServiceQuota {
	s.ServiceName = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *ServiceQuota) SetUnit(v string) *ServiceQuota {
	s.Unit = &v
	return s
}

// SetUsageMetric sets the UsageMetric field's value.
func (s *ServiceQuota) SetUsageMetric(v *MetricInfo) *ServiceQuota {
	s.UsageMetric = v
	return s
}

// SetValue sets the Value field's value.
func (s *ServiceQuota) SetValue(v float64) *ServiceQuota {
	s.Value = &v
	return s
}

// A structure that contains information about one service quota increase request.
type ServiceQuotaIncreaseRequestInTemplate struct {
	_ struct{} `type:"structure"`

	// The AWS Region where the increase request occurs.
	AwsRegion *string `min:"1" type:"string"`

	// Identifies the new, increased value of the service quota in the increase
	// request.
	DesiredValue *float64 `type:"double"`

	// Specifies if the quota is a global quota.
	GlobalQuota *bool `type:"boolean"`

	// The code identifier for the service quota specified in the increase request.
	QuotaCode *string `min:"1" type:"string"`

	// The name of the service quota in the increase request.
	QuotaName *string `type:"string"`

	// The code identifier for the AWS service specified in the increase request.
	ServiceCode *string `min:"1" type:"string"`

	// The name of the AWS service specified in the increase request.
	ServiceName *string `type:"string"`

	// The unit of measure for the increase request.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s ServiceQuotaIncreaseRequestInTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaIncreaseRequestInTemplate) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetAwsRegion(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.AwsRegion = &v
	return s
}

// SetDesiredValue sets the DesiredValue field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetDesiredValue(v float64) *ServiceQuotaIncreaseRequestInTemplate {
	s.DesiredValue = &v
	return s
}

// SetGlobalQuota sets the GlobalQuota field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetGlobalQuota(v bool) *ServiceQuotaIncreaseRequestInTemplate {
	s.GlobalQuota = &v
	return s
}

// SetQuotaCode sets the QuotaCode field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetQuotaCode(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.QuotaCode = &v
	return s
}

// SetQuotaName sets the QuotaName field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetQuotaName(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.QuotaName = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetServiceCode(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.ServiceCode = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetServiceName(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.ServiceName = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *ServiceQuotaIncreaseRequestInTemplate) SetUnit(v string) *ServiceQuotaIncreaseRequestInTemplate {
	s.Unit = &v
	return s
}

const (
	// ErrorCodeDependencyAccessDeniedError is a ErrorCode enum value
	ErrorCodeDependencyAccessDeniedError = "DEPENDENCY_ACCESS_DENIED_ERROR"

	// ErrorCodeDependencyThrottlingError is a ErrorCode enum value
	ErrorCodeDependencyThrottlingError = "DEPENDENCY_THROTTLING_ERROR"

	// ErrorCodeDependencyServiceError is a ErrorCode enum value
	ErrorCodeDependencyServiceError = "DEPENDENCY_SERVICE_ERROR"

	// ErrorCodeServiceQuotaNotAvailableError is a ErrorCode enum value
	ErrorCodeServiceQuotaNotAvailableError = "SERVICE_QUOTA_NOT_AVAILABLE_ERROR"
)

const (
	// PeriodUnitMicrosecond is a PeriodUnit enum value
	PeriodUnitMicrosecond = "MICROSECOND"

	// PeriodUnitMillisecond is a PeriodUnit enum value
	PeriodUnitMillisecond = "MILLISECOND"

	// PeriodUnitSecond is a PeriodUnit enum value
	PeriodUnitSecond = "SECOND"

	// PeriodUnitMinute is a PeriodUnit enum value
	PeriodUnitMinute = "MINUTE"

	// PeriodUnitHour is a PeriodUnit enum value
	PeriodUnitHour = "HOUR"

	// PeriodUnitDay is a PeriodUnit enum value
	PeriodUnitDay = "DAY"

	// PeriodUnitWeek is a PeriodUnit enum value
	PeriodUnitWeek = "WEEK"
)

const (
	// RequestStatusPending is a RequestStatus enum value
	RequestStatusPending = "PENDING"

	// RequestStatusCaseOpened is a RequestStatus enum value
	RequestStatusCaseOpened = "CASE_OPENED"

	// RequestStatusApproved is a RequestStatus enum value
	RequestStatusApproved = "APPROVED"

	// RequestStatusDenied is a RequestStatus enum value
	RequestStatusDenied = "DENIED"

	// RequestStatusCaseClosed is a RequestStatus enum value
	RequestStatusCaseClosed = "CASE_CLOSED"
)

const (
	// ServiceQuotaTemplateAssociationStatusAssociated is a ServiceQuotaTemplateAssociationStatus enum value
	ServiceQuotaTemplateAssociationStatusAssociated = "ASSOCIATED"

	// ServiceQuotaTemplateAssociationStatusDisassociated is a ServiceQuotaTemplateAssociationStatus enum value
	ServiceQuotaTemplateAssociationStatusDisassociated = "DISASSOCIATED"
)
