package storsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/storsimple1200series/mgmt/2016-10-01/storsimple"

// AlertEmailNotificationStatus enumerates the values for alert email notification status.
type AlertEmailNotificationStatus string

const (
	// Disabled ...
	Disabled AlertEmailNotificationStatus = "Disabled"
	// Enabled ...
	Enabled AlertEmailNotificationStatus = "Enabled"
)

// PossibleAlertEmailNotificationStatusValues returns an array of possible values for the AlertEmailNotificationStatus const type.
func PossibleAlertEmailNotificationStatusValues() []AlertEmailNotificationStatus {
	return []AlertEmailNotificationStatus{Disabled, Enabled}
}

// AlertScope enumerates the values for alert scope.
type AlertScope string

const (
	// AlertScopeDevice ...
	AlertScopeDevice AlertScope = "Device"
	// AlertScopeResource ...
	AlertScopeResource AlertScope = "Resource"
)

// PossibleAlertScopeValues returns an array of possible values for the AlertScope const type.
func PossibleAlertScopeValues() []AlertScope {
	return []AlertScope{AlertScopeDevice, AlertScopeResource}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// Critical ...
	Critical AlertSeverity = "Critical"
	// Informational ...
	Informational AlertSeverity = "Informational"
	// Warning ...
	Warning AlertSeverity = "Warning"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{Critical, Informational, Warning}
}

// AlertSourceType enumerates the values for alert source type.
type AlertSourceType string

const (
	// AlertSourceTypeDevice ...
	AlertSourceTypeDevice AlertSourceType = "Device"
	// AlertSourceTypeResource ...
	AlertSourceTypeResource AlertSourceType = "Resource"
)

// PossibleAlertSourceTypeValues returns an array of possible values for the AlertSourceType const type.
func PossibleAlertSourceTypeValues() []AlertSourceType {
	return []AlertSourceType{AlertSourceTypeDevice, AlertSourceTypeResource}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// Active ...
	Active AlertStatus = "Active"
	// Cleared ...
	Cleared AlertStatus = "Cleared"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{Active, Cleared}
}

// AuthType enumerates the values for auth type.
type AuthType string

const (
	// AccessControlService ...
	AccessControlService AuthType = "AccessControlService"
	// AzureActiveDirectory ...
	AzureActiveDirectory AuthType = "AzureActiveDirectory"
	// Invalid ...
	Invalid AuthType = "Invalid"
)

// PossibleAuthTypeValues returns an array of possible values for the AuthType const type.
func PossibleAuthTypeValues() []AuthType {
	return []AuthType{AccessControlService, AzureActiveDirectory, Invalid}
}

// CloudType enumerates the values for cloud type.
type CloudType string

const (
	// Azure ...
	Azure CloudType = "Azure"
	// HP ...
	HP CloudType = "HP"
	// OpenStack ...
	OpenStack CloudType = "OpenStack"
	// S3 ...
	S3 CloudType = "S3"
	// S3RRS ...
	S3RRS CloudType = "S3_RRS"
)

// PossibleCloudTypeValues returns an array of possible values for the CloudType const type.
func PossibleCloudTypeValues() []CloudType {
	return []CloudType{Azure, HP, OpenStack, S3, S3RRS}
}

// ContractVersions enumerates the values for contract versions.
type ContractVersions string

const (
	// InvalidVersion ...
	InvalidVersion ContractVersions = "InvalidVersion"
	// V201109 ...
	V201109 ContractVersions = "V2011_09"
	// V201202 ...
	V201202 ContractVersions = "V2012_02"
	// V201205 ...
	V201205 ContractVersions = "V2012_05"
	// V201212 ...
	V201212 ContractVersions = "V2012_12"
	// V201304 ...
	V201304 ContractVersions = "V2013_04"
	// V201310 ...
	V201310 ContractVersions = "V2013_10"
	// V201311 ...
	V201311 ContractVersions = "V2013_11"
	// V201404 ...
	V201404 ContractVersions = "V2014_04"
	// V201406 ...
	V201406 ContractVersions = "V2014_06"
	// V201407 ...
	V201407 ContractVersions = "V2014_07"
	// V201409 ...
	V201409 ContractVersions = "V2014_09"
	// V201410 ...
	V201410 ContractVersions = "V2014_10"
	// V201412 ...
	V201412 ContractVersions = "V2014_12"
	// V201501 ...
	V201501 ContractVersions = "V2015_01"
	// V201502 ...
	V201502 ContractVersions = "V2015_02"
	// V201504 ...
	V201504 ContractVersions = "V2015_04"
	// V201505 ...
	V201505 ContractVersions = "V2015_05"
	// V201506 ...
	V201506 ContractVersions = "V2015_06"
	// V201507 ...
	V201507 ContractVersions = "V2015_07"
	// V201508 ...
	V201508 ContractVersions = "V2015_08"
	// V201510 ...
	V201510 ContractVersions = "V2015_10"
	// V201512 ...
	V201512 ContractVersions = "V2015_12"
	// V201601 ...
	V201601 ContractVersions = "V2016_01"
	// V201602 ...
	V201602 ContractVersions = "V2016_02"
	// V201604 ...
	V201604 ContractVersions = "V2016_04"
	// V201605 ...
	V201605 ContractVersions = "V2016_05"
	// V201607 ...
	V201607 ContractVersions = "V2016_07"
	// V201608 ...
	V201608 ContractVersions = "V2016_08"
)

// PossibleContractVersionsValues returns an array of possible values for the ContractVersions const type.
func PossibleContractVersionsValues() []ContractVersions {
	return []ContractVersions{InvalidVersion, V201109, V201202, V201205, V201212, V201304, V201310, V201311, V201404, V201406, V201407, V201409, V201410, V201412, V201501, V201502, V201504, V201505, V201506, V201507, V201508, V201510, V201512, V201601, V201602, V201604, V201605, V201607, V201608}
}

// DataPolicy enumerates the values for data policy.
type DataPolicy string

const (
	// DataPolicyCloud ...
	DataPolicyCloud DataPolicy = "Cloud"
	// DataPolicyInvalid ...
	DataPolicyInvalid DataPolicy = "Invalid"
	// DataPolicyLocal ...
	DataPolicyLocal DataPolicy = "Local"
	// DataPolicyTiered ...
	DataPolicyTiered DataPolicy = "Tiered"
)

// PossibleDataPolicyValues returns an array of possible values for the DataPolicy const type.
func PossibleDataPolicyValues() []DataPolicy {
	return []DataPolicy{DataPolicyCloud, DataPolicyInvalid, DataPolicyLocal, DataPolicyTiered}
}

// DeviceConfigurationStatus enumerates the values for device configuration status.
type DeviceConfigurationStatus string

const (
	// Complete ...
	Complete DeviceConfigurationStatus = "Complete"
	// Pending ...
	Pending DeviceConfigurationStatus = "Pending"
)

// PossibleDeviceConfigurationStatusValues returns an array of possible values for the DeviceConfigurationStatus const type.
func PossibleDeviceConfigurationStatusValues() []DeviceConfigurationStatus {
	return []DeviceConfigurationStatus{Complete, Pending}
}

// DeviceOperation enumerates the values for device operation.
type DeviceOperation string

const (
	// Browsable ...
	Browsable DeviceOperation = "Browsable"
	// Deactivate ...
	Deactivate DeviceOperation = "Deactivate"
	// Delete ...
	Delete DeviceOperation = "Delete"
	// DeleteWithWarning ...
	DeleteWithWarning DeviceOperation = "DeleteWithWarning"
	// DRSource ...
	DRSource DeviceOperation = "DRSource"
	// DRTarget ...
	DRTarget DeviceOperation = "DRTarget"
	// None ...
	None DeviceOperation = "None"
	// ReadOnlyForDR ...
	ReadOnlyForDR DeviceOperation = "ReadOnlyForDR"
)

// PossibleDeviceOperationValues returns an array of possible values for the DeviceOperation const type.
func PossibleDeviceOperationValues() []DeviceOperation {
	return []DeviceOperation{Browsable, Deactivate, Delete, DeleteWithWarning, DRSource, DRTarget, None, ReadOnlyForDR}
}

// DeviceStatus enumerates the values for device status.
type DeviceStatus string

const (
	// Creating ...
	Creating DeviceStatus = "Creating"
	// Deactivated ...
	Deactivated DeviceStatus = "Deactivated"
	// Deactivating ...
	Deactivating DeviceStatus = "Deactivating"
	// Deleted ...
	Deleted DeviceStatus = "Deleted"
	// MaintenanceMode ...
	MaintenanceMode DeviceStatus = "MaintenanceMode"
	// Offline ...
	Offline DeviceStatus = "Offline"
	// Online ...
	Online DeviceStatus = "Online"
	// Provisioning ...
	Provisioning DeviceStatus = "Provisioning"
	// ReadyToSetup ...
	ReadyToSetup DeviceStatus = "ReadyToSetup"
	// RequiresAttention ...
	RequiresAttention DeviceStatus = "RequiresAttention"
	// Unknown ...
	Unknown DeviceStatus = "Unknown"
)

// PossibleDeviceStatusValues returns an array of possible values for the DeviceStatus const type.
func PossibleDeviceStatusValues() []DeviceStatus {
	return []DeviceStatus{Creating, Deactivated, Deactivating, Deleted, MaintenanceMode, Offline, Online, Provisioning, ReadyToSetup, RequiresAttention, Unknown}
}

// DeviceType enumerates the values for device type.
type DeviceType string

const (
	// DeviceTypeAppliance ...
	DeviceTypeAppliance DeviceType = "Appliance"
	// DeviceTypeInvalid ...
	DeviceTypeInvalid DeviceType = "Invalid"
	// DeviceTypeSeries9000OnPremVirtualAppliance ...
	DeviceTypeSeries9000OnPremVirtualAppliance DeviceType = "Series9000OnPremVirtualAppliance"
	// DeviceTypeSeries9000PhysicalAppliance ...
	DeviceTypeSeries9000PhysicalAppliance DeviceType = "Series9000PhysicalAppliance"
	// DeviceTypeSeries9000VirtualAppliance ...
	DeviceTypeSeries9000VirtualAppliance DeviceType = "Series9000VirtualAppliance"
	// DeviceTypeVirtualAppliance ...
	DeviceTypeVirtualAppliance DeviceType = "VirtualAppliance"
)

// PossibleDeviceTypeValues returns an array of possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{DeviceTypeAppliance, DeviceTypeInvalid, DeviceTypeSeries9000OnPremVirtualAppliance, DeviceTypeSeries9000PhysicalAppliance, DeviceTypeSeries9000VirtualAppliance, DeviceTypeVirtualAppliance}
}

// DhcpStatus enumerates the values for dhcp status.
type DhcpStatus string

const (
	// DhcpStatusDisabled ...
	DhcpStatusDisabled DhcpStatus = "Disabled"
	// DhcpStatusEnabled ...
	DhcpStatusEnabled DhcpStatus = "Enabled"
)

// PossibleDhcpStatusValues returns an array of possible values for the DhcpStatus const type.
func PossibleDhcpStatusValues() []DhcpStatus {
	return []DhcpStatus{DhcpStatusDisabled, DhcpStatusEnabled}
}

// DiskStatus enumerates the values for disk status.
type DiskStatus string

const (
	// DiskStatusOffline ...
	DiskStatusOffline DiskStatus = "Offline"
	// DiskStatusOnline ...
	DiskStatusOnline DiskStatus = "Online"
)

// PossibleDiskStatusValues returns an array of possible values for the DiskStatus const type.
func PossibleDiskStatusValues() []DiskStatus {
	return []DiskStatus{DiskStatusOffline, DiskStatusOnline}
}

// DownloadPhase enumerates the values for download phase.
type DownloadPhase string

const (
	// DownloadPhaseDownloading ...
	DownloadPhaseDownloading DownloadPhase = "Downloading"
	// DownloadPhaseInitializing ...
	DownloadPhaseInitializing DownloadPhase = "Initializing"
	// DownloadPhaseUnknown ...
	DownloadPhaseUnknown DownloadPhase = "Unknown"
	// DownloadPhaseVerifying ...
	DownloadPhaseVerifying DownloadPhase = "Verifying"
)

// PossibleDownloadPhaseValues returns an array of possible values for the DownloadPhase const type.
func PossibleDownloadPhaseValues() []DownloadPhase {
	return []DownloadPhase{DownloadPhaseDownloading, DownloadPhaseInitializing, DownloadPhaseUnknown, DownloadPhaseVerifying}
}

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES256 ...
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmNone ...
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmRSAESPKCS1V15 ...
	EncryptionAlgorithmRSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// PossibleEncryptionAlgorithmValues returns an array of possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{EncryptionAlgorithmAES256, EncryptionAlgorithmNone, EncryptionAlgorithmRSAESPKCS1V15}
}

// EncryptionStatus enumerates the values for encryption status.
type EncryptionStatus string

const (
	// EncryptionStatusDisabled ...
	EncryptionStatusDisabled EncryptionStatus = "Disabled"
	// EncryptionStatusEnabled ...
	EncryptionStatusEnabled EncryptionStatus = "Enabled"
)

// PossibleEncryptionStatusValues returns an array of possible values for the EncryptionStatus const type.
func PossibleEncryptionStatusValues() []EncryptionStatus {
	return []EncryptionStatus{EncryptionStatusDisabled, EncryptionStatusEnabled}
}

// InitiatedBy enumerates the values for initiated by.
type InitiatedBy string

const (
	// Manual ...
	Manual InitiatedBy = "Manual"
	// Scheduled ...
	Scheduled InitiatedBy = "Scheduled"
)

// PossibleInitiatedByValues returns an array of possible values for the InitiatedBy const type.
func PossibleInitiatedByValues() []InitiatedBy {
	return []InitiatedBy{Manual, Scheduled}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCanceled ...
	JobStatusCanceled JobStatus = "Canceled"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "Failed"
	// JobStatusInvalid ...
	JobStatusInvalid JobStatus = "Invalid"
	// JobStatusPaused ...
	JobStatusPaused JobStatus = "Paused"
	// JobStatusRunning ...
	JobStatusRunning JobStatus = "Running"
	// JobStatusScheduled ...
	JobStatusScheduled JobStatus = "Scheduled"
	// JobStatusSucceeded ...
	JobStatusSucceeded JobStatus = "Succeeded"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusCanceled, JobStatusFailed, JobStatusInvalid, JobStatusPaused, JobStatusRunning, JobStatusScheduled, JobStatusSucceeded}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeBackup ...
	JobTypeBackup JobType = "Backup"
	// JobTypeClone ...
	JobTypeClone JobType = "Clone"
	// JobTypeDownloadUpdates ...
	JobTypeDownloadUpdates JobType = "DownloadUpdates"
	// JobTypeFailover ...
	JobTypeFailover JobType = "Failover"
	// JobTypeInstallUpdates ...
	JobTypeInstallUpdates JobType = "InstallUpdates"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeBackup, JobTypeClone, JobTypeDownloadUpdates, JobTypeFailover, JobTypeInstallUpdates}
}

// KeyRolloverStatus enumerates the values for key rollover status.
type KeyRolloverStatus string

const (
	// NotRequired ...
	NotRequired KeyRolloverStatus = "NotRequired"
	// Required ...
	Required KeyRolloverStatus = "Required"
)

// PossibleKeyRolloverStatusValues returns an array of possible values for the KeyRolloverStatus const type.
func PossibleKeyRolloverStatusValues() []KeyRolloverStatus {
	return []KeyRolloverStatus{NotRequired, Required}
}

// ManagerType enumerates the values for manager type.
type ManagerType string

const (
	// GardaV1 ...
	GardaV1 ManagerType = "GardaV1"
	// HelsinkiV1 ...
	HelsinkiV1 ManagerType = "HelsinkiV1"
)

// PossibleManagerTypeValues returns an array of possible values for the ManagerType const type.
func PossibleManagerTypeValues() []ManagerType {
	return []ManagerType{GardaV1, HelsinkiV1}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage ...
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeLast ...
	MetricAggregationTypeLast MetricAggregationType = "Last"
	// MetricAggregationTypeMaximum ...
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	// MetricAggregationTypeMinimum ...
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	// MetricAggregationTypeNone ...
	MetricAggregationTypeNone MetricAggregationType = "None"
	// MetricAggregationTypeTotal ...
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeLast, MetricAggregationTypeMaximum, MetricAggregationTypeMinimum, MetricAggregationTypeNone, MetricAggregationTypeTotal}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// Bytes ...
	Bytes MetricUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond MetricUnit = "BytesPerSecond"
	// Count ...
	Count MetricUnit = "Count"
	// CountPerSecond ...
	CountPerSecond MetricUnit = "CountPerSecond"
	// Percent ...
	Percent MetricUnit = "Percent"
	// Seconds ...
	Seconds MetricUnit = "Seconds"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{Bytes, BytesPerSecond, Count, CountPerSecond, Percent, Seconds}
}

// MonitoringStatus enumerates the values for monitoring status.
type MonitoringStatus string

const (
	// MonitoringStatusDisabled ...
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	// MonitoringStatusEnabled ...
	MonitoringStatusEnabled MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns an array of possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{MonitoringStatusDisabled, MonitoringStatusEnabled}
}

// ServiceOwnersAlertNotificationStatus enumerates the values for service owners alert notification status.
type ServiceOwnersAlertNotificationStatus string

const (
	// ServiceOwnersAlertNotificationStatusDisabled ...
	ServiceOwnersAlertNotificationStatusDisabled ServiceOwnersAlertNotificationStatus = "Disabled"
	// ServiceOwnersAlertNotificationStatusEnabled ...
	ServiceOwnersAlertNotificationStatusEnabled ServiceOwnersAlertNotificationStatus = "Enabled"
)

// PossibleServiceOwnersAlertNotificationStatusValues returns an array of possible values for the ServiceOwnersAlertNotificationStatus const type.
func PossibleServiceOwnersAlertNotificationStatusValues() []ServiceOwnersAlertNotificationStatus {
	return []ServiceOwnersAlertNotificationStatus{ServiceOwnersAlertNotificationStatusDisabled, ServiceOwnersAlertNotificationStatusEnabled}
}

// ShareStatus enumerates the values for share status.
type ShareStatus string

const (
	// ShareStatusOffline ...
	ShareStatusOffline ShareStatus = "Offline"
	// ShareStatusOnline ...
	ShareStatusOnline ShareStatus = "Online"
)

// PossibleShareStatusValues returns an array of possible values for the ShareStatus const type.
func PossibleShareStatusValues() []ShareStatus {
	return []ShareStatus{ShareStatusOffline, ShareStatusOnline}
}

// SslStatus enumerates the values for ssl status.
type SslStatus string

const (
	// SslStatusDisabled ...
	SslStatusDisabled SslStatus = "Disabled"
	// SslStatusEnabled ...
	SslStatusEnabled SslStatus = "Enabled"
)

// PossibleSslStatusValues returns an array of possible values for the SslStatus const type.
func PossibleSslStatusValues() []SslStatus {
	return []SslStatus{SslStatusDisabled, SslStatusEnabled}
}

// SupportedDeviceCapabilities enumerates the values for supported device capabilities.
type SupportedDeviceCapabilities string

const (
	// SupportedDeviceCapabilitiesFileServer ...
	SupportedDeviceCapabilitiesFileServer SupportedDeviceCapabilities = "FileServer"
	// SupportedDeviceCapabilitiesInvalid ...
	SupportedDeviceCapabilitiesInvalid SupportedDeviceCapabilities = "Invalid"
	// SupportedDeviceCapabilitiesIscsiServer ...
	SupportedDeviceCapabilitiesIscsiServer SupportedDeviceCapabilities = "IscsiServer"
)

// PossibleSupportedDeviceCapabilitiesValues returns an array of possible values for the SupportedDeviceCapabilities const type.
func PossibleSupportedDeviceCapabilitiesValues() []SupportedDeviceCapabilities {
	return []SupportedDeviceCapabilities{SupportedDeviceCapabilitiesFileServer, SupportedDeviceCapabilitiesInvalid, SupportedDeviceCapabilitiesIscsiServer}
}

// TargetType enumerates the values for target type.
type TargetType string

const (
	// TargetTypeDiskServer ...
	TargetTypeDiskServer TargetType = "DiskServer"
	// TargetTypeFileServer ...
	TargetTypeFileServer TargetType = "FileServer"
)

// PossibleTargetTypeValues returns an array of possible values for the TargetType const type.
func PossibleTargetTypeValues() []TargetType {
	return []TargetType{TargetTypeDiskServer, TargetTypeFileServer}
}

// UpdateOperation enumerates the values for update operation.
type UpdateOperation string

const (
	// Downloading ...
	Downloading UpdateOperation = "Downloading"
	// Idle ...
	Idle UpdateOperation = "Idle"
	// Installing ...
	Installing UpdateOperation = "Installing"
	// Scanning ...
	Scanning UpdateOperation = "Scanning"
)

// PossibleUpdateOperationValues returns an array of possible values for the UpdateOperation const type.
func PossibleUpdateOperationValues() []UpdateOperation {
	return []UpdateOperation{Downloading, Idle, Installing, Scanning}
}

// AccessControlRecord the access control record
type AccessControlRecord struct {
	autorest.Response `json:"-"`
	// AccessControlRecordProperties - Properties of AccessControlRecord
	*AccessControlRecordProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AccessControlRecord.
func (acr AccessControlRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acr.AccessControlRecordProperties != nil {
		objectMap["properties"] = acr.AccessControlRecordProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccessControlRecord struct.
func (acr *AccessControlRecord) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessControlRecordProperties AccessControlRecordProperties
				err = json.Unmarshal(*v, &accessControlRecordProperties)
				if err != nil {
					return err
				}
				acr.AccessControlRecordProperties = &accessControlRecordProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				acr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				acr.Type = &typeVar
			}
		}
	}

	return nil
}

// AccessControlRecordList collection of AccessControlRecords
type AccessControlRecordList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]AccessControlRecord `json:"value,omitempty"`
}

// AccessControlRecordProperties properties of access control record
type AccessControlRecordProperties struct {
	// InitiatorName - The Iscsi initiator name (IQN)
	InitiatorName *string `json:"initiatorName,omitempty"`
}

// AccessControlRecordsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AccessControlRecordsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccessControlRecordsCreateOrUpdateFuture) Result(client AccessControlRecordsClient) (acr AccessControlRecord, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.AccessControlRecordsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.AccessControlRecordsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if acr.Response.Response, err = future.GetResult(sender); err == nil && acr.Response.Response.StatusCode != http.StatusNoContent {
		acr, err = client.CreateOrUpdateResponder(acr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.AccessControlRecordsCreateOrUpdateFuture", "Result", acr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccessControlRecordsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AccessControlRecordsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccessControlRecordsDeleteFuture) Result(client AccessControlRecordsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.AccessControlRecordsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.AccessControlRecordsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Alert alert class
type Alert struct {
	// AlertProperties - Properties of alert
	*AlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertErrorDetails error details for the alert
type AlertErrorDetails struct {
	// ErrorCode - Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Error Message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Occurences - Number of occurrences.
	Occurences *int32 `json:"occurences,omitempty"`
}

// AlertFilter filters that can be specified on the alert
type AlertFilter struct {
	// Status - Status of the alert. Possible values include: 'Active', 'Cleared'
	Status AlertStatus `json:"status,omitempty"`
	// Severity - Severity of the alert. Possible values include: 'Informational', 'Warning', 'Critical'
	Severity AlertSeverity `json:"severity,omitempty"`
	// SourceType - Source of the alert. Possible values include: 'AlertSourceTypeResource', 'AlertSourceTypeDevice'
	SourceType AlertSourceType `json:"sourceType,omitempty"`
	// SourceName - Source name of the alert
	SourceName *string `json:"sourceName,omitempty"`
	// AppearedOnTime - UTC time on which the alert appeared
	AppearedOnTime *date.Time `json:"appearedOnTime,omitempty"`
}

// AlertList collection of Alerts
type AlertList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - Id of the next page of alerts
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{fn: getNextPage}
}

// AlertProperties properties of alert
type AlertProperties struct {
	// Title - Title of the alert
	Title *string `json:"title,omitempty"`
	// Scope - Device or Resource alert. Possible values include: 'AlertScopeResource', 'AlertScopeDevice'
	Scope AlertScope `json:"scope,omitempty"`
	// AlertType - Type of the alert
	AlertType *string `json:"alertType,omitempty"`
	// AppearedAtTime - UTC time at which the alert appeared
	AppearedAtTime *date.Time `json:"appearedAtTime,omitempty"`
	// AppearedAtSourceTime - UTC time at which the alert appeared on the source
	AppearedAtSourceTime *date.Time `json:"appearedAtSourceTime,omitempty"`
	// ClearedAtTime - UTC time at which the alert got cleared
	ClearedAtTime *date.Time `json:"clearedAtTime,omitempty"`
	// ClearedAtSourceTime - UTC time at which the alert was cleared on the source
	ClearedAtSourceTime *date.Time `json:"clearedAtSourceTime,omitempty"`
	// Source - Source at which the alert was cleared
	Source *AlertSource `json:"source,omitempty"`
	// Recommendation - Recommendation for acting on the alert
	Recommendation *string `json:"recommendation,omitempty"`
	// ResolutionReason - Reason for resolving the alert
	ResolutionReason *string `json:"resolutionReason,omitempty"`
	// Severity - Severity of the alert. Possible values include: 'Informational', 'Warning', 'Critical'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Status - Current status of the alert. Possible values include: 'Active', 'Cleared'
	Status AlertStatus `json:"status,omitempty"`
	// ErrorDetails - ErrorDetails of the alert
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty"`
	// DetailedInformation - Other information about the alert
	DetailedInformation map[string]*string `json:"detailedInformation"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Title != nil {
		objectMap["title"] = ap.Title
	}
	if ap.Scope != "" {
		objectMap["scope"] = ap.Scope
	}
	if ap.AlertType != nil {
		objectMap["alertType"] = ap.AlertType
	}
	if ap.AppearedAtTime != nil {
		objectMap["appearedAtTime"] = ap.AppearedAtTime
	}
	if ap.AppearedAtSourceTime != nil {
		objectMap["appearedAtSourceTime"] = ap.AppearedAtSourceTime
	}
	if ap.ClearedAtTime != nil {
		objectMap["clearedAtTime"] = ap.ClearedAtTime
	}
	if ap.ClearedAtSourceTime != nil {
		objectMap["clearedAtSourceTime"] = ap.ClearedAtSourceTime
	}
	if ap.Source != nil {
		objectMap["source"] = ap.Source
	}
	if ap.Recommendation != nil {
		objectMap["recommendation"] = ap.Recommendation
	}
	if ap.ResolutionReason != nil {
		objectMap["resolutionReason"] = ap.ResolutionReason
	}
	if ap.Severity != "" {
		objectMap["severity"] = ap.Severity
	}
	if ap.Status != "" {
		objectMap["status"] = ap.Status
	}
	if ap.ErrorDetails != nil {
		objectMap["errorDetails"] = ap.ErrorDetails
	}
	if ap.DetailedInformation != nil {
		objectMap["detailedInformation"] = ap.DetailedInformation
	}
	return json.Marshal(objectMap)
}

// AlertSettings alertSettings on the device which represents how alerts will be processed
type AlertSettings struct {
	autorest.Response `json:"-"`
	// AlertSettingsProperties - Properties of AlertSettings
	*AlertSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertSettings.
func (as AlertSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.AlertSettingsProperties != nil {
		objectMap["properties"] = as.AlertSettingsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertSettings struct.
func (as *AlertSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertSettingsProperties AlertSettingsProperties
				err = json.Unmarshal(*v, &alertSettingsProperties)
				if err != nil {
					return err
				}
				as.AlertSettingsProperties = &alertSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertSettingsProperties class containing the properties of AlertSettings
type AlertSettingsProperties struct {
	// EmailNotification - Value indicating whether user/admins will receive emails when an alert condition occurs on the system. Possible values include: 'Enabled', 'Disabled'
	EmailNotification AlertEmailNotificationStatus `json:"emailNotification,omitempty"`
	// NotificationToServiceOwners - Value indicating whether service owners will receive emails when an alert condition occurs on the system. Applicable only if emailNotification flag is Enabled. Possible values include: 'ServiceOwnersAlertNotificationStatusEnabled', 'ServiceOwnersAlertNotificationStatusDisabled'
	NotificationToServiceOwners ServiceOwnersAlertNotificationStatus `json:"notificationToServiceOwners,omitempty"`
	// AlertNotificationCulture - Culture setting to be used while building alert emails. For eg: "en-US"
	AlertNotificationCulture *string `json:"alertNotificationCulture,omitempty"`
	// AdditionalRecipientEmailList - List of email addresses (apart from admin/co-admin of subscription) to whom the alert emails need to be sent
	AdditionalRecipientEmailList *[]string `json:"additionalRecipientEmailList,omitempty"`
}

// AlertSource source at which the alert can be raised
type AlertSource struct {
	// Name - Name of the source.
	Name *string `json:"name,omitempty"`
	// TimeZone - The time zone.
	TimeZone *string `json:"timeZone,omitempty"`
	// AlertSourceType - Source type of the alert. Possible values include: 'AlertSourceTypeResource', 'AlertSourceTypeDevice'
	AlertSourceType AlertSourceType `json:"alertSourceType,omitempty"`
}

// AsymmetricEncryptedSecret this class can be used as the Type for any secret entity represented as
// Password, CertThumbprint, Algorithm. This class is intended to be used when the secret is encrypted with
// an asymmetric key pair. The encryptionAlgorithm field is mainly for future usage to potentially allow
// different entities encrypted using different algorithms.
type AsymmetricEncryptedSecret struct {
	// Value - The value of the secret itself. If the secret is in plaintext then EncryptionAlgorithm will be none and EncryptionCertThumbprint will be null.
	Value *string `json:"value,omitempty"`
	// EncryptionCertificateThumbprint - Thumbprint certificate that was used to encrypt "Value"
	EncryptionCertificateThumbprint *string `json:"encryptionCertificateThumbprint,omitempty"`
	// EncryptionAlgorithm - Algorithm used to encrypt "Value". Possible values include: 'EncryptionAlgorithmNone', 'EncryptionAlgorithmAES256', 'EncryptionAlgorithmRSAESPKCS1V15'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// AvailableProviderOperation class represents provider operation
type AvailableProviderOperation struct {
	// Name - Gets or sets the name of the operation being performed on this particular object
	// Return value format: "{resourceProviderNamespace}/{resourceType}/{read|write|deletion|action}"
	// Eg: Microsoft.StorSimple/managers/devices/fileServers/read
	//     Microsoft.StorSimple/managers/devices/alerts/clearAlerts/action
	Name *string `json:"name,omitempty"`
	// Display - Gets or sets Display information
	// Contains the localized display information for this particular operation/action
	Display *AvailableProviderOperationDisplay `json:"display,omitempty"`
	// Origin - Gets or sets Origin
	// The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX.
	// Default value is “user,system”
	Origin *string `json:"origin,omitempty"`
	// Properties - Gets or sets Properties
	// Reserved for future use
	Properties interface{} `json:"properties,omitempty"`
}

// AvailableProviderOperationDisplay contains the localized display information for this particular
// operation / action.
// These value will be used by several clients for
// (1) custom role definitions for RBAC;
// (2) complex query filters for the event service; and (3) audit history / records for management
// operations.
type AvailableProviderOperationDisplay struct {
	// Provider - Gets or sets Provider
	// The localized friendly form of the resource provider name – it is expected to also include the publisher/company responsible.
	// It should use Title Casing and begin with “Microsoft” for 1st party services.
	Provider *string `json:"provider,omitempty"`
	// Resource - Gets or sets Resource
	// The localized friendly form of the resource type related to this action/operation – it should match the public documentation for the resource provider.
	// It should use Title Casing – for examples, please refer to the “name” section.
	Resource *string `json:"resource,omitempty"`
	// Operation - Gets or sets Operation
	// The localized friendly name for the operation, as it should be shown to the user.
	// It should be concise (to fit in drop downs) but clear (i.e. self-documenting). It should use Title Casing and include the entity/resource to which it applies.
	Operation *string `json:"operation,omitempty"`
	// Description - Gets or sets Description
	// The localized friendly description for the operation, as it should be shown to the user.
	// It should be thorough, yet concise – it will be used in tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// AvailableProviderOperations class for set of operations used for discovery of available provider
// operations.
type AvailableProviderOperations struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]AvailableProviderOperation `json:"value,omitempty"`
	// NextLink - The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableProviderOperationsIterator provides access to a complete listing of AvailableProviderOperation
// values.
type AvailableProviderOperationsIterator struct {
	i    int
	page AvailableProviderOperationsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableProviderOperationsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableProviderOperationsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableProviderOperationsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableProviderOperationsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableProviderOperationsIterator) Response() AvailableProviderOperations {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableProviderOperationsIterator) Value() AvailableProviderOperation {
	if !iter.page.NotDone() {
		return AvailableProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableProviderOperationsIterator type.
func NewAvailableProviderOperationsIterator(page AvailableProviderOperationsPage) AvailableProviderOperationsIterator {
	return AvailableProviderOperationsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apo AvailableProviderOperations) IsEmpty() bool {
	return apo.Value == nil || len(*apo.Value) == 0
}

// availableProviderOperationsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apo AvailableProviderOperations) availableProviderOperationsPreparer(ctx context.Context) (*http.Request, error) {
	if apo.NextLink == nil || len(to.String(apo.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apo.NextLink)))
}

// AvailableProviderOperationsPage contains a page of AvailableProviderOperation values.
type AvailableProviderOperationsPage struct {
	fn  func(context.Context, AvailableProviderOperations) (AvailableProviderOperations, error)
	apo AvailableProviderOperations
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableProviderOperationsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableProviderOperationsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.apo)
	if err != nil {
		return err
	}
	page.apo = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableProviderOperationsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableProviderOperationsPage) NotDone() bool {
	return !page.apo.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableProviderOperationsPage) Response() AvailableProviderOperations {
	return page.apo
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableProviderOperationsPage) Values() []AvailableProviderOperation {
	if page.apo.IsEmpty() {
		return nil
	}
	return *page.apo.Value
}

// Creates a new instance of the AvailableProviderOperationsPage type.
func NewAvailableProviderOperationsPage(getNextPage func(context.Context, AvailableProviderOperations) (AvailableProviderOperations, error)) AvailableProviderOperationsPage {
	return AvailableProviderOperationsPage{fn: getNextPage}
}

// Backup the backup.
type Backup struct {
	// BackupProperties - Properties of backup
	*BackupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Backup.
func (b Backup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BackupProperties != nil {
		objectMap["properties"] = b.BackupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Backup struct.
func (b *Backup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupProperties BackupProperties
				err = json.Unmarshal(*v, &backupProperties)
				if err != nil {
					return err
				}
				b.BackupProperties = &backupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupElement class represents BackupElement
type BackupElement struct {
	// BackupElementProperties - The Properties of backup element
	*BackupElementProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupElement.
func (be BackupElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if be.BackupElementProperties != nil {
		objectMap["properties"] = be.BackupElementProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupElement struct.
func (be *BackupElement) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupElementProperties BackupElementProperties
				err = json.Unmarshal(*v, &backupElementProperties)
				if err != nil {
					return err
				}
				be.BackupElementProperties = &backupElementProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				be.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				be.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				be.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupElementProperties the backup element properties
type BackupElementProperties struct {
	// SizeInBytes - The size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// EndpointName - The name of the endpoint.
	EndpointName *string `json:"endpointName,omitempty"`
	// DataPolicy - The data policy of backed up endpoint. Possible values include: 'DataPolicyInvalid', 'DataPolicyLocal', 'DataPolicyTiered', 'DataPolicyCloud'
	DataPolicy DataPolicy `json:"dataPolicy,omitempty"`
}

// BackupFilter backup OData filter class
type BackupFilter struct {
	// InitiatedBy - Gets or sets InitiatedBy. Possible values include: 'Manual', 'Scheduled'
	InitiatedBy InitiatedBy `json:"initiatedBy,omitempty"`
	// CreatedTime - Gets or sets CreatedTime
	CreatedTime *date.Time `json:"createdTime,omitempty"`
}

// BackupList collection of backups
type BackupList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Backup `json:"value,omitempty"`
	// NextLink - The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupListIterator provides access to a complete listing of Backup values.
type BackupListIterator struct {
	i    int
	page BackupListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupListIterator) Response() BackupList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupListIterator) Value() Backup {
	if !iter.page.NotDone() {
		return Backup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupListIterator type.
func NewBackupListIterator(page BackupListPage) BackupListIterator {
	return BackupListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bl BackupList) IsEmpty() bool {
	return bl.Value == nil || len(*bl.Value) == 0
}

// backupListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bl BackupList) backupListPreparer(ctx context.Context) (*http.Request, error) {
	if bl.NextLink == nil || len(to.String(bl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bl.NextLink)))
}

// BackupListPage contains a page of Backup values.
type BackupListPage struct {
	fn func(context.Context, BackupList) (BackupList, error)
	bl BackupList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bl)
	if err != nil {
		return err
	}
	page.bl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupListPage) NotDone() bool {
	return !page.bl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupListPage) Response() BackupList {
	return page.bl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupListPage) Values() []Backup {
	if page.bl.IsEmpty() {
		return nil
	}
	return *page.bl.Value
}

// Creates a new instance of the BackupListPage type.
func NewBackupListPage(getNextPage func(context.Context, BackupList) (BackupList, error)) BackupListPage {
	return BackupListPage{fn: getNextPage}
}

// BackupProperties class represents Backup properties
type BackupProperties struct {
	// TargetID - The path id of the target FileServer or IscsiServer for which the backup was taken.
	TargetID *string `json:"targetId,omitempty"`
	// TargetType - Type of target, FileServer or IscsiServer
	TargetType *string `json:"targetType,omitempty"`
	// SizeInBytes - The backup size in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// CreatedTime - The time when the backup was created.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - The time when the backup will expire.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// InitiatedBy - Indicates how the backup was initiated "Manual | Scheduled". Possible values include: 'Manual', 'Scheduled'
	InitiatedBy InitiatedBy `json:"initiatedBy,omitempty"`
	// DeviceID - The Device Identifier.
	DeviceID *string `json:"deviceId,omitempty"`
	// Elements - The backup elements.
	Elements *[]BackupElement `json:"elements,omitempty"`
}

// BackupScheduleGroup the Backup Schedule Group
type BackupScheduleGroup struct {
	autorest.Response `json:"-"`
	// BackupScheduleGroupProperties - Properties of BackupScheduleGroup
	*BackupScheduleGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupScheduleGroup.
func (bsg BackupScheduleGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsg.BackupScheduleGroupProperties != nil {
		objectMap["properties"] = bsg.BackupScheduleGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupScheduleGroup struct.
func (bsg *BackupScheduleGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupScheduleGroupProperties BackupScheduleGroupProperties
				err = json.Unmarshal(*v, &backupScheduleGroupProperties)
				if err != nil {
					return err
				}
				bsg.BackupScheduleGroupProperties = &backupScheduleGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsg.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupScheduleGroupList the list response of backup schedule groups
type BackupScheduleGroupList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]BackupScheduleGroup `json:"value,omitempty"`
}

// BackupScheduleGroupProperties the Backup Schedule Group Properties
type BackupScheduleGroupProperties struct {
	// StartTime - The start time. When this field is specified we will generate Default GrandFather Father Son Backup Schedules.
	StartTime *Time `json:"startTime,omitempty"`
}

// BackupScheduleGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupScheduleGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupScheduleGroupsCreateOrUpdateFuture) Result(client BackupScheduleGroupsClient) (bsg BackupScheduleGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupScheduleGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupScheduleGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bsg.Response.Response, err = future.GetResult(sender); err == nil && bsg.Response.Response.StatusCode != http.StatusNoContent {
		bsg, err = client.CreateOrUpdateResponder(bsg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.BackupScheduleGroupsCreateOrUpdateFuture", "Result", bsg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupScheduleGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupScheduleGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupScheduleGroupsDeleteFuture) Result(client BackupScheduleGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupScheduleGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupScheduleGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupsCloneFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BackupsCloneFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupsCloneFuture) Result(client BackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupsCloneFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupsCloneFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupsDeleteFuture) Result(client BackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.BackupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.BackupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BaseModel base class for models
type BaseModel struct {
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// ChapProperties chap properties
type ChapProperties struct {
	// Password - The chap password.
	Password *AsymmetricEncryptedSecret `json:"password,omitempty"`
}

// ChapSettings challenge-Handshake Authentication Protocol (CHAP) setting
type ChapSettings struct {
	autorest.Response `json:"-"`
	// ChapProperties - Chap properties
	*ChapProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ChapSettings.
func (cs ChapSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.ChapProperties != nil {
		objectMap["properties"] = cs.ChapProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ChapSettings struct.
func (cs *ChapSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var chapProperties ChapProperties
				err = json.Unmarshal(*v, &chapProperties)
				if err != nil {
					return err
				}
				cs.ChapProperties = &chapProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = &typeVar
			}
		}
	}

	return nil
}

// ChapSettingsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ChapSettingsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ChapSettingsCreateOrUpdateFuture) Result(client ChapSettingsClient) (cs ChapSettings, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.ChapSettingsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.ChapSettingsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cs.Response.Response, err = future.GetResult(sender); err == nil && cs.Response.Response.StatusCode != http.StatusNoContent {
		cs, err = client.CreateOrUpdateResponder(cs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.ChapSettingsCreateOrUpdateFuture", "Result", cs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ChapSettingsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ChapSettingsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ChapSettingsDeleteFuture) Result(client ChapSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.ChapSettingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.ChapSettingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ChapSettingsList collection of Chap setting entities
type ChapSettingsList struct {
	autorest.Response `json:"-"`
	// Value - The chap settings entity collection
	Value *[]ChapSettings `json:"value,omitempty"`
}

// ClearAlertRequest request for clearing the alert
type ClearAlertRequest struct {
	// ResolutionMessage - Resolution message while clearing the request
	ResolutionMessage *string `json:"resolutionMessage,omitempty"`
	// Alerts - List of alert Ids to be cleared
	Alerts *[]string `json:"alerts,omitempty"`
}

// CloneRequest clone Job Request Model.
type CloneRequest struct {
	// CloneRequestProperties - CloneJob Properties are encapsulated in this object.
	*CloneRequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CloneRequest.
func (cr CloneRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.CloneRequestProperties != nil {
		objectMap["properties"] = cr.CloneRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloneRequest struct.
func (cr *CloneRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloneRequestProperties CloneRequestProperties
				err = json.Unmarshal(*v, &cloneRequestProperties)
				if err != nil {
					return err
				}
				cr.CloneRequestProperties = &cloneRequestProperties
			}
		}
	}

	return nil
}

// CloneRequestProperties properties of CloneRequest
type CloneRequestProperties struct {
	// TargetDeviceID - DeviceId of the device which will act as the Clone target
	TargetDeviceID *string `json:"targetDeviceId,omitempty"`
	// TargetAccessPointID - Access point Id on which clone job will performed.
	TargetAccessPointID *string `json:"targetAccessPointId,omitempty"`
	// NewEndpointName - Name of new endpoint which will created as part of clone job.
	NewEndpointName *string `json:"newEndpointName,omitempty"`
	// Share - Share Object.
	Share *FileShare `json:"share,omitempty"`
	// Disk - Disk Object
	Disk *ISCSIDisk `json:"disk,omitempty"`
}

// Device represents a StorSimple device object along with its properties
type Device struct {
	autorest.Response `json:"-"`
	// DeviceProperties - Collection of properties for the device
	*DeviceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DeviceProperties != nil {
		objectMap["properties"] = d.DeviceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Device struct.
func (d *Device) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deviceProperties DeviceProperties
				err = json.Unmarshal(*v, &deviceProperties)
				if err != nil {
					return err
				}
				d.DeviceProperties = &deviceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceDetails class containing more granular details about the device
type DeviceDetails struct {
	// EndpointCount - Total number of endpoints that are currently on the device ( i.e. number of shares on FileServer or number of volumes on IscsiServer)
	EndpointCount *int32 `json:"endpointCount,omitempty"`
	// TotalStorageInBytes - Total storage available on the device in bytes.
	TotalStorageInBytes *int64 `json:"totalStorageInBytes,omitempty"`
	// TotalLocalStorageInBytes - Total local storage capacity in device in bytes.
	TotalLocalStorageInBytes *int64 `json:"totalLocalStorageInBytes,omitempty"`
	// ProvisionedStorageInBytes - Storage in bytes that has been provisioned on the device including both local and cloud
	ProvisionedStorageInBytes *int64 `json:"provisionedStorageInBytes,omitempty"`
	// ProvisionedLocalStorageInBytes - Storage in bytes that has been provisioned locally on the device
	ProvisionedLocalStorageInBytes *int64 `json:"provisionedLocalStorageInBytes,omitempty"`
	// UsingStorageInBytes - Storage that is being currently used in bytes including both local and cloud
	UsingStorageInBytes *int64 `json:"usingStorageInBytes,omitempty"`
	// UsingLocalStorageInBytes - Local Storage that is being currently used in bytes
	UsingLocalStorageInBytes *int64 `json:"usingLocalStorageInBytes,omitempty"`
	// TotalBackupSizeInBytes - Total size taken up by backups in bytes
	TotalBackupSizeInBytes *int64 `json:"totalBackupSizeInBytes,omitempty"`
	// AvailableStorageInBytes - Total pending available storage on the device in bytes
	AvailableStorageInBytes *int64 `json:"availableStorageInBytes,omitempty"`
	// AvailableLocalStorageInBytes - Local pending storage available on the device in bytes
	AvailableLocalStorageInBytes *int64 `json:"availableLocalStorageInBytes,omitempty"`
}

// DeviceList collection of Devices
type DeviceList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Device `json:"value,omitempty"`
}

// DevicePatch class that represents the Input for the PATCH call on Device. Currently the only patchable
// property on device is "DeviceDescription"
type DevicePatch struct {
	// DeviceDescription - Short description given for the device
	DeviceDescription *string `json:"deviceDescription,omitempty"`
}

// DeviceProperties encases all the properties of the Device
type DeviceProperties struct {
	// ActivationTime - The UTC time at which the device was activated
	ActivationTime *date.Time `json:"activationTime,omitempty"`
	// AllowedDeviceOperations - Operations that are allowed on the device based on its current state
	AllowedDeviceOperations *[]DeviceOperation `json:"allowedDeviceOperations,omitempty"`
	// Culture - Language culture setting on the device. For eg: "en-US"
	Culture *string `json:"culture,omitempty"`
	// DeviceCapabilities - Device can be configured either as FileServer or IscsiServer
	DeviceCapabilities *[]SupportedDeviceCapabilities `json:"deviceCapabilities,omitempty"`
	// DeviceDescription - Short description given for the device
	DeviceDescription *string `json:"deviceDescription,omitempty"`
	// DomainName - Fully qualified name of the domain to which the device is attached
	DomainName *string `json:"domainName,omitempty"`
	// DeviceSoftwareVersion - Version number of the software running on the device
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`
	// FriendlySoftwareName - Friendly name for the software version
	FriendlySoftwareName *string `json:"friendlySoftwareName,omitempty"`
	// DeviceConfigurationStatus - "Complete" if the device has been successfully registered as File/IscsiServer and the creation of share/volume is complete, "Pending" if the device is only registered but the creation of share/volume is complete is still pending. Possible values include: 'Complete', 'Pending'
	DeviceConfigurationStatus DeviceConfigurationStatus `json:"deviceConfigurationStatus,omitempty"`
	// ModelDescription - Name of the device model
	ModelDescription *string `json:"modelDescription,omitempty"`
	// Status - Current status of the device. Possible values include: 'Unknown', 'Online', 'Offline', 'RequiresAttention', 'MaintenanceMode', 'Creating', 'Provisioning', 'Deleted', 'ReadyToSetup', 'Deactivated', 'Deactivating'
	Status DeviceStatus `json:"status,omitempty"`
	// Type - Type of the device. Possible values include: 'DeviceTypeInvalid', 'DeviceTypeAppliance', 'DeviceTypeVirtualAppliance', 'DeviceTypeSeries9000OnPremVirtualAppliance', 'DeviceTypeSeries9000VirtualAppliance', 'DeviceTypeSeries9000PhysicalAppliance'
	Type DeviceType `json:"type,omitempty"`
	// Details - subclass containing more storage-related information about the device. This field will be populated only if the get call is made with $expand = details.
	Details *DeviceDetails `json:"details,omitempty"`
}

// DevicesCreateOrUpdateAlertSettingsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DevicesCreateOrUpdateAlertSettingsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesCreateOrUpdateAlertSettingsFuture) Result(client DevicesClient) (as AlertSettings, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesCreateOrUpdateAlertSettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesCreateOrUpdateAlertSettingsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if as.Response.Response, err = future.GetResult(sender); err == nil && as.Response.Response.StatusCode != http.StatusNoContent {
		as, err = client.CreateOrUpdateAlertSettingsResponder(as.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.DevicesCreateOrUpdateAlertSettingsFuture", "Result", as.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesCreateOrUpdateSecuritySettingsFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DevicesCreateOrUpdateSecuritySettingsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesCreateOrUpdateSecuritySettingsFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesCreateOrUpdateSecuritySettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesCreateOrUpdateSecuritySettingsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDeactivateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeactivateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesDeactivateFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesDeactivateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesDeactivateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesDeleteFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDownloadUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDownloadUpdatesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesDownloadUpdatesFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesDownloadUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesDownloadUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesFailoverFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesInstallUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesInstallUpdatesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesInstallUpdatesFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesInstallUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesInstallUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesPatchFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DevicesPatchFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesPatchFuture) Result(client DevicesClient) (d Device, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesPatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesPatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.PatchResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.DevicesPatchFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesScanForUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesScanForUpdatesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DevicesScanForUpdatesFuture) Result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.DevicesScanForUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.DevicesScanForUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EncryptionSettings the EncryptionSettings
type EncryptionSettings struct {
	autorest.Response `json:"-"`
	// EncryptionSettingsProperties - Properties of the EncryptionSettings.
	*EncryptionSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionSettings.
func (es EncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EncryptionSettingsProperties != nil {
		objectMap["properties"] = es.EncryptionSettingsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionSettings struct.
func (es *EncryptionSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var encryptionSettingsProperties EncryptionSettingsProperties
				err = json.Unmarshal(*v, &encryptionSettingsProperties)
				if err != nil {
					return err
				}
				es.EncryptionSettingsProperties = &encryptionSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionSettingsProperties the properties of EncryptionSettings
type EncryptionSettingsProperties struct {
	// EncryptionStatus - The encryption status which indicates if encryption is enabled or not. Possible values include: 'EncryptionStatusEnabled', 'EncryptionStatusDisabled'
	EncryptionStatus EncryptionStatus `json:"encryptionStatus,omitempty"`
	// KeyRolloverStatus - The key rollover status which indicates if key rollover is required or not. If secrets encryption has been upgraded, then it requires key rollover. Possible values include: 'Required', 'NotRequired'
	KeyRolloverStatus KeyRolloverStatus `json:"keyRolloverStatus,omitempty"`
}

// Error ...
type Error struct {
	ErrorCode *string  `json:"errorCode,omitempty"`
	Message   *Message `json:"message,omitempty"`
	Values    *[]Item  `json:"values,omitempty"`
}

// FailoverRequest the Failover request object.
type FailoverRequest struct {
	AccesspointIds   *[]string `json:"accesspointIds,omitempty"`
	TargetDeviceID   *string   `json:"targetDeviceId,omitempty"`
	SkipValidation   *bool     `json:"skipValidation,omitempty"`
	KeepSourceDevice *bool     `json:"keepSourceDevice,omitempty"`
}

// FileServer the file server.
type FileServer struct {
	autorest.Response `json:"-"`
	// FileServerProperties - The properties.
	*FileServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServer.
func (fs FileServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FileServerProperties != nil {
		objectMap["properties"] = fs.FileServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileServer struct.
func (fs *FileServer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileServerProperties FileServerProperties
				err = json.Unmarshal(*v, &fileServerProperties)
				if err != nil {
					return err
				}
				fs.FileServerProperties = &fileServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		}
	}

	return nil
}

// FileServerList collection of file servers
type FileServerList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]FileServer `json:"value,omitempty"`
}

// FileServerProperties the file server properties.
type FileServerProperties struct {
	// DomainName - Domain of the file server
	DomainName *string `json:"domainName,omitempty"`
	// StorageDomainID - The storage domain id.
	StorageDomainID *string `json:"storageDomainId,omitempty"`
	// BackupScheduleGroupID - The backup policy id.
	BackupScheduleGroupID *string `json:"backupScheduleGroupId,omitempty"`
	// Description - The description of the file server
	Description *string `json:"description,omitempty"`
}

// FileServersBackupNowFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FileServersBackupNowFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FileServersBackupNowFuture) Result(client FileServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.FileServersBackupNowFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.FileServersBackupNowFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FileServersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FileServersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FileServersCreateOrUpdateFuture) Result(client FileServersClient) (fs FileServer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.FileServersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.FileServersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fs.Response.Response, err = future.GetResult(sender); err == nil && fs.Response.Response.StatusCode != http.StatusNoContent {
		fs, err = client.CreateOrUpdateResponder(fs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.FileServersCreateOrUpdateFuture", "Result", fs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FileServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FileServersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FileServersDeleteFuture) Result(client FileServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.FileServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.FileServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FileShare the File Share.
type FileShare struct {
	autorest.Response `json:"-"`
	// FileShareProperties - The properties.
	*FileShareProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShare.
func (fs FileShare) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FileShareProperties != nil {
		objectMap["properties"] = fs.FileShareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileShare struct.
func (fs *FileShare) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileShareProperties FileShareProperties
				err = json.Unmarshal(*v, &fileShareProperties)
				if err != nil {
					return err
				}
				fs.FileShareProperties = &fileShareProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		}
	}

	return nil
}

// FileShareList collection of file shares
type FileShareList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]FileShare `json:"value,omitempty"`
}

// FileShareProperties the File Share.
type FileShareProperties struct {
	// Description - Description for file share
	Description *string `json:"description,omitempty"`
	// ShareStatus - The Share Status. Possible values include: 'ShareStatusOnline', 'ShareStatusOffline'
	ShareStatus ShareStatus `json:"shareStatus,omitempty"`
	// DataPolicy - The data policy. Possible values include: 'DataPolicyInvalid', 'DataPolicyLocal', 'DataPolicyTiered', 'DataPolicyCloud'
	DataPolicy DataPolicy `json:"dataPolicy,omitempty"`
	// AdminUser - The user/group who will have full permission in this share. Active directory email address. Example: xyz@contoso.com or Contoso\xyz.
	AdminUser *string `json:"adminUser,omitempty"`
	// ProvisionedCapacityInBytes - The total provisioned capacity in Bytes
	ProvisionedCapacityInBytes *int64 `json:"provisionedCapacityInBytes,omitempty"`
	// UsedCapacityInBytes - READ-ONLY; The used capacity in Bytes.
	UsedCapacityInBytes *int64 `json:"usedCapacityInBytes,omitempty"`
	// LocalUsedCapacityInBytes - READ-ONLY; The local used capacity in Bytes.
	LocalUsedCapacityInBytes *int64 `json:"localUsedCapacityInBytes,omitempty"`
	// MonitoringStatus - The monitoring status. Possible values include: 'MonitoringStatusEnabled', 'MonitoringStatusDisabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
}

// FileSharesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FileSharesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FileSharesCreateOrUpdateFuture) Result(client FileSharesClient) (fs FileShare, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.FileSharesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.FileSharesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fs.Response.Response, err = future.GetResult(sender); err == nil && fs.Response.Response.StatusCode != http.StatusNoContent {
		fs, err = client.CreateOrUpdateResponder(fs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.FileSharesCreateOrUpdateFuture", "Result", fs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FileSharesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FileSharesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FileSharesDeleteFuture) Result(client FileSharesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.FileSharesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.FileSharesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IPConfig details related to the IP address configuration
type IPConfig struct {
	// IPAddress - The IP address of the network adapter, either ipv4 or ipv6.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PrefixLength - The prefix length of the network adapter.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
	// Gateway - The gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`
}

// ISCSIDisk the iSCSI disk.
type ISCSIDisk struct {
	autorest.Response `json:"-"`
	// ISCSIDiskProperties - The properties.
	*ISCSIDiskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ISCSIDisk.
func (ID ISCSIDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ID.ISCSIDiskProperties != nil {
		objectMap["properties"] = ID.ISCSIDiskProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ISCSIDisk struct.
func (ID *ISCSIDisk) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iSCSIDiskProperties ISCSIDiskProperties
				err = json.Unmarshal(*v, &iSCSIDiskProperties)
				if err != nil {
					return err
				}
				ID.ISCSIDiskProperties = &iSCSIDiskProperties
			}
		case "id":
			if v != nil {
				var ID1 string
				err = json.Unmarshal(*v, &ID1)
				if err != nil {
					return err
				}
				ID.ID = &ID1
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ID.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ID.Type = &typeVar
			}
		}
	}

	return nil
}

// ISCSIDiskList collection of Iscsi disk
type ISCSIDiskList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]ISCSIDisk `json:"value,omitempty"`
}

// ISCSIDiskProperties the iSCSI disk properties.
type ISCSIDiskProperties struct {
	// Description - The description.
	Description *string `json:"description,omitempty"`
	// DiskStatus - The disk status. Possible values include: 'DiskStatusOnline', 'DiskStatusOffline'
	DiskStatus DiskStatus `json:"diskStatus,omitempty"`
	// AccessControlRecords - The access control records.
	AccessControlRecords *[]string `json:"accessControlRecords,omitempty"`
	// DataPolicy - The data policy. Possible values include: 'DataPolicyInvalid', 'DataPolicyLocal', 'DataPolicyTiered', 'DataPolicyCloud'
	DataPolicy DataPolicy `json:"dataPolicy,omitempty"`
	// ProvisionedCapacityInBytes - The provisioned capacity in bytes.
	ProvisionedCapacityInBytes *int64 `json:"provisionedCapacityInBytes,omitempty"`
	// UsedCapacityInBytes - READ-ONLY; The used capacity in bytes.
	UsedCapacityInBytes *int64 `json:"usedCapacityInBytes,omitempty"`
	// LocalUsedCapacityInBytes - READ-ONLY; The local used capacity in bytes.
	LocalUsedCapacityInBytes *int64 `json:"localUsedCapacityInBytes,omitempty"`
	// MonitoringStatus - The monitoring. Possible values include: 'MonitoringStatusEnabled', 'MonitoringStatusDisabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
}

// IscsiDisksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IscsiDisksCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IscsiDisksCreateOrUpdateFuture) Result(client IscsiDisksClient) (ID ISCSIDisk, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.IscsiDisksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.IscsiDisksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ID.Response.Response, err = future.GetResult(sender); err == nil && ID.Response.Response.StatusCode != http.StatusNoContent {
		ID, err = client.CreateOrUpdateResponder(ID.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.IscsiDisksCreateOrUpdateFuture", "Result", ID.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IscsiDisksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IscsiDisksDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IscsiDisksDeleteFuture) Result(client IscsiDisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.IscsiDisksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.IscsiDisksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ISCSIServer the iSCSI server.
type ISCSIServer struct {
	autorest.Response `json:"-"`
	// ISCSIServerProperties - The properties.
	*ISCSIServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ISCSIServer.
func (is ISCSIServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if is.ISCSIServerProperties != nil {
		objectMap["properties"] = is.ISCSIServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ISCSIServer struct.
func (is *ISCSIServer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iSCSIServerProperties ISCSIServerProperties
				err = json.Unmarshal(*v, &iSCSIServerProperties)
				if err != nil {
					return err
				}
				is.ISCSIServerProperties = &iSCSIServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				is.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				is.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				is.Type = &typeVar
			}
		}
	}

	return nil
}

// ISCSIServerList collection of Iscsi servers
type ISCSIServerList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]ISCSIServer `json:"value,omitempty"`
}

// ISCSIServerProperties the iSCSI server properties.
type ISCSIServerProperties struct {
	// StorageDomainID - The storage domain id.
	StorageDomainID *string `json:"storageDomainId,omitempty"`
	// BackupScheduleGroupID - The backup policy id.
	BackupScheduleGroupID *string `json:"backupScheduleGroupId,omitempty"`
	// Description - The description.
	Description *string `json:"description,omitempty"`
	// ChapID - The chap id.
	ChapID *string `json:"chapId,omitempty"`
	// ReverseChapID - The reverse chap id.
	ReverseChapID *string `json:"reverseChapId,omitempty"`
}

// IscsiServersBackupNowFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IscsiServersBackupNowFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IscsiServersBackupNowFuture) Result(client IscsiServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.IscsiServersBackupNowFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.IscsiServersBackupNowFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IscsiServersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IscsiServersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IscsiServersCreateOrUpdateFuture) Result(client IscsiServersClient) (is ISCSIServer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.IscsiServersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.IscsiServersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if is.Response.Response, err = future.GetResult(sender); err == nil && is.Response.Response.StatusCode != http.StatusNoContent {
		is, err = client.CreateOrUpdateResponder(is.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.IscsiServersCreateOrUpdateFuture", "Result", is.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IscsiServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IscsiServersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IscsiServersDeleteFuture) Result(client IscsiServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.IscsiServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.IscsiServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Item ...
type Item struct {
	Key   *string `json:"key,omitempty"`
	Value *string `json:"value,omitempty"`
}

// Job the Job.
type Job struct {
	autorest.Response `json:"-"`
	// Status - Current status of the job. Possible values include: 'JobStatusInvalid', 'JobStatusRunning', 'JobStatusSucceeded', 'JobStatusFailed', 'JobStatusCanceled', 'JobStatusPaused', 'JobStatusScheduled'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - The UTC time at which the job was started
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The UTC time at which the job completed
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - The percentage of the job that is already complete
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Error - The Error details.
	Error *JobErrorDetails `json:"error,omitempty"`
	// JobProperties - Other properties of the job
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.Status != "" {
		objectMap["status"] = j.Status
	}
	if j.StartTime != nil {
		objectMap["startTime"] = j.StartTime
	}
	if j.EndTime != nil {
		objectMap["endTime"] = j.EndTime
	}
	if j.PercentComplete != nil {
		objectMap["percentComplete"] = j.PercentComplete
	}
	if j.Error != nil {
		objectMap["error"] = j.Error
	}
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status JobStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				j.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				j.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				j.EndTime = &endTime
			}
		case "percentComplete":
			if v != nil {
				var percentComplete int32
				err = json.Unmarshal(*v, &percentComplete)
				if err != nil {
					return err
				}
				j.PercentComplete = &percentComplete
			}
		case "error":
			if v != nil {
				var errorVar JobErrorDetails
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				j.Error = &errorVar
			}
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobErrorDetails the job error information containing List of JobErrorItem.
type JobErrorDetails struct {
	// ErrorDetails - The error details.
	ErrorDetails *[]JobErrorItem `json:"errorDetails,omitempty"`
	// Code - The code intended for programmatic access
	Code *string `json:"code,omitempty"`
	// Message - The message intended to describe the error in detail
	Message *string `json:"message,omitempty"`
}

// JobErrorItem the job error items.
type JobErrorItem struct {
	// Recommendations - The recommended actions.
	Recommendations *[]string `json:"recommendations,omitempty"`
	// Code - The code intended for programmatic access
	Code *string `json:"code,omitempty"`
	// Message - The message intended to describe the error in detail
	Message *string `json:"message,omitempty"`
}

// JobFilter filters that can be specified for the job
type JobFilter struct {
	// JobType - The job type. Possible values include: 'JobTypeBackup', 'JobTypeClone', 'JobTypeFailover', 'JobTypeDownloadUpdates', 'JobTypeInstallUpdates'
	JobType JobType `json:"jobType,omitempty"`
	// Status - The job status. Possible values include: 'JobStatusInvalid', 'JobStatusRunning', 'JobStatusSucceeded', 'JobStatusFailed', 'JobStatusCanceled', 'JobStatusPaused', 'JobStatusScheduled'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - The start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// JobList collection of jobs
type JobList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - The NextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListIterator provides access to a complete listing of Job values.
type JobListIterator struct {
	i    int
	page JobListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListIterator) Response() JobList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListIterator type.
func NewJobListIterator(page JobListPage) JobListIterator {
	return JobListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jl JobList) IsEmpty() bool {
	return jl.Value == nil || len(*jl.Value) == 0
}

// jobListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jl JobList) jobListPreparer(ctx context.Context) (*http.Request, error) {
	if jl.NextLink == nil || len(to.String(jl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jl.NextLink)))
}

// JobListPage contains a page of Job values.
type JobListPage struct {
	fn func(context.Context, JobList) (JobList, error)
	jl JobList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jl)
	if err != nil {
		return err
	}
	page.jl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListPage) NotDone() bool {
	return !page.jl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListPage) Response() JobList {
	return page.jl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListPage) Values() []Job {
	if page.jl.IsEmpty() {
		return nil
	}
	return *page.jl.Value
}

// Creates a new instance of the JobListPage type.
func NewJobListPage(getNextPage func(context.Context, JobList) (JobList, error)) JobListPage {
	return JobListPage{fn: getNextPage}
}

// JobProperties properties for the job
type JobProperties struct {
	// JobType - Type of the job. Possible values include: 'JobTypeBackup', 'JobTypeClone', 'JobTypeFailover', 'JobTypeDownloadUpdates', 'JobTypeInstallUpdates'
	JobType JobType `json:"jobType,omitempty"`
	// TargetID - Id of the object that is created by the job
	TargetID *string `json:"targetId,omitempty"`
	// EntityID - The entity identifier for which the job ran.
	EntityID *string `json:"entityId,omitempty"`
	// EntityType - The entity type for which the job ran.
	EntityType *string `json:"entityType,omitempty"`
	// JobStages - The job stages.
	JobStages *[]JobStage `json:"jobStages,omitempty"`
	// DeviceID - The device id in which the job is currently running
	DeviceID *string `json:"deviceId,omitempty"`
	// IsCancellable - Represents whether the job is cancellable or not
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// Stats - stats properties for the job
	Stats *JobStats `json:"stats,omitempty"`
	// TargetType - The target type of the backup. Possible values include: 'TargetTypeFileServer', 'TargetTypeDiskServer'
	TargetType TargetType `json:"targetType,omitempty"`
	// SourceDeviceID - The source device identifier of the failover job.
	SourceDeviceID *string `json:"sourceDeviceId,omitempty"`
	// BackupPointInTime - The time of the backup used for the failover.
	BackupPointInTime *date.Time `json:"backupPointInTime,omitempty"`
	// DownloadProgress - The download progress.
	DownloadProgress *UpdateDownloadProgress `json:"downloadProgress,omitempty"`
	// InstallProgress - The install progress.
	InstallProgress *UpdateInstallProgress `json:"installProgress,omitempty"`
}

// JobStage contains details about the multiple job stages of a job
type JobStage struct {
	// Message - The message of the job stage.
	Message *string `json:"message,omitempty"`
	// StageStatus - The stage status. Possible values include: 'JobStatusInvalid', 'JobStatusRunning', 'JobStatusSucceeded', 'JobStatusFailed', 'JobStatusCanceled', 'JobStatusPaused', 'JobStatusScheduled'
	StageStatus JobStatus `json:"stageStatus,omitempty"`
	// Detail - The details of the stage.
	Detail *string `json:"detail,omitempty"`
	// ErrorCode - The error code of the stage if any.
	ErrorCode *string `json:"errorCode,omitempty"`
}

// JobStats stats that are available for all jobs in common
type JobStats struct {
	// CompletedWorkItemCount - Completed work item count.
	CompletedWorkItemCount *int32 `json:"completedWorkItemCount,omitempty"`
	// TotalWorkItemCount - Total work item count.
	TotalWorkItemCount *int32 `json:"totalWorkItemCount,omitempty"`
	// EstimatedTimeRemaining - The estimated time remaining.
	EstimatedTimeRemaining *int32 `json:"estimatedTimeRemaining,omitempty"`
}

// Manager the StorSimple Manager
type Manager struct {
	autorest.Response `json:"-"`
	// ManagerProperties - List of properties of the Manager
	*ManagerProperties `json:"properties,omitempty"`
	// Etag - ETag of the Manager
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; The Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The Resource type
	Type *string `json:"type,omitempty"`
	// Location - The Geo location of the Manager
	Location *string `json:"location,omitempty"`
	// Tags - Tags attached to the Manager
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Manager.
func (mVar Manager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.ManagerProperties != nil {
		objectMap["properties"] = mVar.ManagerProperties
	}
	if mVar.Etag != nil {
		objectMap["etag"] = mVar.Etag
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Manager struct.
func (mVar *Manager) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managerProperties ManagerProperties
				err = json.Unmarshal(*v, &managerProperties)
				if err != nil {
					return err
				}
				mVar.ManagerProperties = &managerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mVar.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		}
	}

	return nil
}

// ManagerExtendedInfo the extended info of the manager.
type ManagerExtendedInfo struct {
	autorest.Response `json:"-"`
	// ManagerExtendedInfoProperties - The extended info properties.
	*ManagerExtendedInfoProperties `json:"properties,omitempty"`
	// Etag - ETag of the Resource
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagerExtendedInfo.
func (mei ManagerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mei.ManagerExtendedInfoProperties != nil {
		objectMap["properties"] = mei.ManagerExtendedInfoProperties
	}
	if mei.Etag != nil {
		objectMap["etag"] = mei.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagerExtendedInfo struct.
func (mei *ManagerExtendedInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managerExtendedInfoProperties ManagerExtendedInfoProperties
				err = json.Unmarshal(*v, &managerExtendedInfoProperties)
				if err != nil {
					return err
				}
				mei.ManagerExtendedInfoProperties = &managerExtendedInfoProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mei.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mei.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mei.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagerExtendedInfoProperties properties of the ManagerExtendedInfo
type ManagerExtendedInfoProperties struct {
	// Version - Represents the version of the ExtendedInfo object being persisted
	Version *string `json:"version,omitempty"`
	// IntegrityKey - Represents the CIK of the resource
	IntegrityKey *string `json:"integrityKey,omitempty"`
	// EncryptionKey - Represents the CEK of the resource
	EncryptionKey *string `json:"encryptionKey,omitempty"`
	// EncryptionKeyThumbprint - Represents the Cert thumbprint that was used to encrypt the CEK
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	// PortalCertificateThumbprint - Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
	PortalCertificateThumbprint *string `json:"portalCertificateThumbprint,omitempty"`
	// Algorithm - Represents the encryption algorithm used to encrypt the other keys. None - if EncryptionKey is saved in plain text format. AlgorithmName - if encryption is used
	Algorithm *string `json:"algorithm,omitempty"`
}

// ManagerIntrinsicSettings intrinsic settings which refers to the type of the StorSimple manager
type ManagerIntrinsicSettings struct {
	// Type - Refers to the type of the StorSimple Manager. Possible values include: 'GardaV1', 'HelsinkiV1'
	Type ManagerType `json:"type,omitempty"`
}

// ManagerList list of StorSimple Managers under a particular resourceGroup
type ManagerList struct {
	autorest.Response `json:"-"`
	// Value - List of Managers
	Value *[]Manager `json:"value,omitempty"`
}

// ManagerPatch the StorSimple Manager patch.
type ManagerPatch struct {
	// Tags - The tags attached to the StorSimple Manager.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagerPatch.
func (mp ManagerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.Tags != nil {
		objectMap["tags"] = mp.Tags
	}
	return json.Marshal(objectMap)
}

// ManagerProperties the properties of the Manager
type ManagerProperties struct {
	// CisIntrinsicSettings - Specifies if the Manager is Garda or Helsinki
	CisIntrinsicSettings *ManagerIntrinsicSettings `json:"cisIntrinsicSettings,omitempty"`
	// Sku - Specifies the Sku
	Sku *ManagerSku `json:"sku,omitempty"`
	// ProvisioningState - READ-ONLY; Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully created
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ManagerSku the Sku.
type ManagerSku struct {
	// Name - Refers to the sku name which should be "Standard"
	Name *string `json:"name,omitempty"`
}

// Message ...
type Message struct {
	Language *string `json:"language,omitempty"`
	Value    *string `json:"value,omitempty"`
}

// MetricAvailablity metric availability specifies the time grain (aggregation interval or frequency) and
// the retention period for that time grain
type MetricAvailablity struct {
	// TimeGrain - The time grain, specifies the aggregation interval for the metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - The retention period for the metric at the specified timegrain
	Retention *string `json:"retention,omitempty"`
}

// MetricData the metric data.
type MetricData struct {
	// TimeStamp - The time when the metric data is fetched
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// Sum - The sum of all the samples available in the given instance of time for the specific metric data
	Sum *float64 `json:"sum,omitempty"`
	// Count - The count of samples of the metric data available for the given instance
	Count *int32 `json:"count,omitempty"`
	// Average - The average of all sample for the given instance
	Average *float64 `json:"average,omitempty"`
	// Minimum - The minimum of all samples available
	Minimum *float64 `json:"minimum,omitempty"`
	// Maximum - The maximum of all samples available
	Maximum *float64 `json:"maximum,omitempty"`
}

// MetricDefinition monitoring metric definition represents the metadata of the metrics.
type MetricDefinition struct {
	// Name - The metric name
	Name *MetricName `json:"name,omitempty"`
	// Unit - The metric unit. Possible values include: 'Bytes', 'BytesPerSecond', 'Count', 'CountPerSecond', 'Percent', 'Seconds'
	Unit MetricUnit `json:"unit,omitempty"`
	// PrimaryAggregationType - The metric aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeLast', 'MetricAggregationTypeMaximum', 'MetricAggregationTypeMinimum', 'MetricAggregationTypeNone', 'MetricAggregationTypeTotal'
	PrimaryAggregationType MetricAggregationType `json:"primaryAggregationType,omitempty"`
	// ResourceID - The metric source id
	ResourceID *string `json:"resourceId,omitempty"`
	// MetricAvailabilities - The available metric granularities
	MetricAvailabilities *[]MetricAvailablity `json:"metricAvailabilities,omitempty"`
	// Dimensions - The supported dimensions
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// Type - The metric definition type
	Type *string `json:"type,omitempty"`
}

// MetricDefinitionList list of metric definition
type MetricDefinitionList struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definition
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricDimension metric dimension
type MetricDimension struct {
	// Name - Metric dimension name
	Name *string `json:"name,omitempty"`
	// Value - Metric dimension values
	Value *string `json:"value,omitempty"`
}

// MetricFilter class representing the filters to be passed while fetching metrics
type MetricFilter struct {
	// Name - filter for name property
	Name *MetricNameFilter `json:"name,omitempty"`
	// StartTime - starttime for fetching metrics
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - endtime for fetching metrics
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - timegrain of the metrics
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricList collection of metrics
type MetricList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Metrics `json:"value,omitempty"`
}

// MetricName the name of the metric
type MetricName struct {
	// Value - Name of the metric
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized name of the metric
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricNameFilter class representing the name filter to be passed while fetching metrics
type MetricNameFilter struct {
	// Value - The value.
	Value *string `json:"value,omitempty"`
}

// Metrics monitoring metric
type Metrics struct {
	// ResourceID - The id of metric source
	ResourceID *string `json:"resourceId,omitempty"`
	// StartTime - The metric start time
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The metric end time
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - The time grain, time grain indicates frequency of the metric data
	TimeGrain *string `json:"timeGrain,omitempty"`
	// PrimaryAggregation - The metric aggregation type. Possible values include: 'MetricAggregationTypeAverage', 'MetricAggregationTypeLast', 'MetricAggregationTypeMaximum', 'MetricAggregationTypeMinimum', 'MetricAggregationTypeNone', 'MetricAggregationTypeTotal'
	PrimaryAggregation MetricAggregationType `json:"primaryAggregation,omitempty"`
	// Name - The name of the metrics
	Name *MetricName `json:"name,omitempty"`
	// Dimensions - The Metric dimension which indicates the source of the metric
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// Unit - The unit of the metric data. Possible values include: 'Bytes', 'BytesPerSecond', 'Count', 'CountPerSecond', 'Percent', 'Seconds'
	Unit MetricUnit `json:"unit,omitempty"`
	// Type - The Type of the metric data
	Type *string `json:"type,omitempty"`
	// Values - The metric data
	Values *[]MetricData `json:"values,omitempty"`
}

// NetworkAdapter represents a networkAdapter in a particular node.
type NetworkAdapter struct {
	// NetworkAdapterName - The name of the network adapter.
	NetworkAdapterName *string `json:"networkAdapterName,omitempty"`
	// IPv4Info - The ipv4 configuration of the network adapter.
	IPv4Info *IPConfig `json:"iPv4Info,omitempty"`
	// IPv6Info - The ipv6 configuration of the network adapter.
	IPv6Info *IPConfig `json:"iPv6Info,omitempty"`
	// DhcpStatus - Represents state of DHCP. Possible values include: 'DhcpStatusEnabled', 'DhcpStatusDisabled'
	DhcpStatus DhcpStatus `json:"dhcpStatus,omitempty"`
	// LinkSpeed - The speed of the network adapter.
	LinkSpeed *int64 `json:"linkSpeed,omitempty"`
}

// NetworkSettings the NetworkSettings of a device
type NetworkSettings struct {
	autorest.Response `json:"-"`
	// NetworkSettingsProperties - Properties of the given NetworkSettings.
	*NetworkSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkSettings.
func (ns NetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ns.NetworkSettingsProperties != nil {
		objectMap["properties"] = ns.NetworkSettingsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkSettings struct.
func (ns *NetworkSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkSettingsProperties NetworkSettingsProperties
				err = json.Unmarshal(*v, &networkSettingsProperties)
				if err != nil {
					return err
				}
				ns.NetworkSettingsProperties = &networkSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ns.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkSettingsProperties the properties of NetworkSettings
type NetworkSettingsProperties struct {
	// PrimaryDNSServer - The Primary DNS server for the device
	PrimaryDNSServer *string `json:"primaryDnsServer,omitempty"`
	// SecondaryDNSServer - The secondary DNS server for the device
	SecondaryDNSServer *string `json:"secondaryDnsServer,omitempty"`
	// NodeNetworks - The NetworkAdapters under each node of the device.
	NodeNetworks *[]NodeNetwork `json:"nodeNetworks,omitempty"`
}

// NodeNetwork represents a single node in a device.
type NodeNetwork struct {
	// NetworkAdapters - The array of network adapters in the node.
	NetworkAdapters *[]NetworkAdapter `json:"networkAdapters,omitempty"`
}

// RawCertificateData raw Certificate Data From IDM
type RawCertificateData struct {
	// AuthType - Specify the Authentication type. Possible values include: 'Invalid', 'AccessControlService', 'AzureActiveDirectory'
	AuthType AuthType `json:"authType,omitempty"`
	// Certificate - Gets or sets the base64 encoded certificate raw data string
	Certificate *string `json:"certificate,omitempty"`
}

// Resource the Azure Resource.
type Resource struct {
	// ID - READ-ONLY; The Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The Resource Name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The Resource type
	Type *string `json:"type,omitempty"`
	// Location - The Geo location of the Manager
	Location *string `json:"location,omitempty"`
	// Tags - Tags attached to the Manager
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceCertificateAndAADDetails resource Certificate And AAD Details from IDM
type ResourceCertificateAndAADDetails struct {
	// AuthType - Specify the Authentication type. Possible values include: 'Invalid', 'AccessControlService', 'AzureActiveDirectory'
	AuthType AuthType `json:"authType,omitempty"`
	// Certificate - Gets or sets the base64 encoded certificate raw data string
	Certificate *string `json:"certificate,omitempty"`
	// ResourceID - Gets or Sets the ResourceId
	ResourceID *int64 `json:"resourceId,omitempty"`
	// AadAuthority - AAD tenant authority
	AadAuthority *string `json:"aadAuthority,omitempty"`
	// AadTenantID - AAD tenant Id
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// ServicePrincipalClientID - AAD service principal clientId
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`
	// ServicePrincipalObjectID - AAD service principal ObjectId
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty"`
	// AzureManagementEndpointAudience - Azure Management Endpoint Audience
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty"`
	// Subject - Certificate Subject Name
	Subject *string `json:"subject,omitempty"`
	// ValidFrom - Certificate Validity start Date time
	ValidFrom *date.Time `json:"validFrom,omitempty"`
	// ValidTo - Certificate Validity End Date time
	ValidTo *date.Time `json:"validTo,omitempty"`
	// Thumbprint - Certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// FriendlyName - Certificate friendly name
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Issuer - Certificate issuer
	Issuer *string `json:"issuer,omitempty"`
}

// SecuritySettings the SecuritySettings of a device
type SecuritySettings struct {
	// SecuritySettingsProperties - Properties of the SecuritySettings.
	*SecuritySettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecuritySettings.
func (ss SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SecuritySettingsProperties != nil {
		objectMap["properties"] = ss.SecuritySettingsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecuritySettings struct.
func (ss *SecuritySettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securitySettingsProperties SecuritySettingsProperties
				err = json.Unmarshal(*v, &securitySettingsProperties)
				if err != nil {
					return err
				}
				ss.SecuritySettingsProperties = &securitySettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// SecuritySettingsProperties the properties of SecuritySettings
type SecuritySettingsProperties struct {
	// DeviceAdminPassword - Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to log into the  local web UI of the device. Actual password could have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and special characters
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
}

// SendTestAlertEmailRequest request for sending test alert email
type SendTestAlertEmailRequest struct {
	// EmailList - List of emails to send the test alerts
	EmailList *[]string `json:"emailList,omitempty"`
}

// StorageAccountCredential the storage account credential
type StorageAccountCredential struct {
	autorest.Response `json:"-"`
	// StorageAccountCredentialProperties - Credential properties
	*StorageAccountCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountCredential.
func (sac StorageAccountCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sac.StorageAccountCredentialProperties != nil {
		objectMap["properties"] = sac.StorageAccountCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageAccountCredential struct.
func (sac *StorageAccountCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageAccountCredentialProperties StorageAccountCredentialProperties
				err = json.Unmarshal(*v, &storageAccountCredentialProperties)
				if err != nil {
					return err
				}
				sac.StorageAccountCredentialProperties = &storageAccountCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sac.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageAccountCredentialList collection of Storage account credential entities
type StorageAccountCredentialList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]StorageAccountCredential `json:"value,omitempty"`
}

// StorageAccountCredentialProperties storage account properties
type StorageAccountCredentialProperties struct {
	// CloudType - The cloud service provider. Possible values include: 'Azure', 'S3', 'S3RRS', 'OpenStack', 'HP'
	CloudType CloudType `json:"cloudType,omitempty"`
	// EndPoint - The storage endpoint
	EndPoint *string `json:"endPoint,omitempty"`
	// Login - The storage account login
	Login *string `json:"login,omitempty"`
	// Location - The storage account's geo location
	Location *string `json:"location,omitempty"`
	// EnableSSL - SSL needs to be enabled or not. Possible values include: 'SslStatusEnabled', 'SslStatusDisabled'
	EnableSSL SslStatus `json:"enableSSL,omitempty"`
	// AccessKey - The details of the storage account password
	AccessKey *AsymmetricEncryptedSecret `json:"accessKey,omitempty"`
}

// StorageAccountCredentialsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type StorageAccountCredentialsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) Result(client StorageAccountCredentialsClient) (sac StorageAccountCredential, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.StorageAccountCredentialsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.StorageAccountCredentialsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sac.Response.Response, err = future.GetResult(sender); err == nil && sac.Response.Response.StatusCode != http.StatusNoContent {
		sac, err = client.CreateOrUpdateResponder(sac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.StorageAccountCredentialsCreateOrUpdateFuture", "Result", sac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StorageAccountCredentialsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StorageAccountCredentialsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *StorageAccountCredentialsDeleteFuture) Result(client StorageAccountCredentialsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.StorageAccountCredentialsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.StorageAccountCredentialsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StorageDomain the storage domain.
type StorageDomain struct {
	autorest.Response `json:"-"`
	// StorageDomainProperties - The properties.
	*StorageDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageDomain.
func (sd StorageDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.StorageDomainProperties != nil {
		objectMap["properties"] = sd.StorageDomainProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageDomain struct.
func (sd *StorageDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageDomainProperties StorageDomainProperties
				err = json.Unmarshal(*v, &storageDomainProperties)
				if err != nil {
					return err
				}
				sd.StorageDomainProperties = &storageDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sd.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageDomainList collection of storage domains
type StorageDomainList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]StorageDomain `json:"value,omitempty"`
}

// StorageDomainProperties the storage domain properties.
type StorageDomainProperties struct {
	// StorageAccountCredentialIds - The storage account credentials.
	StorageAccountCredentialIds *[]string `json:"storageAccountCredentialIds,omitempty"`
	// EncryptionKey - The encryption key used to encrypt the data. This is a user secret.
	EncryptionKey *AsymmetricEncryptedSecret `json:"encryptionKey,omitempty"`
	// EncryptionStatus - The encryption status "Enabled | Disabled". Possible values include: 'EncryptionStatusEnabled', 'EncryptionStatusDisabled'
	EncryptionStatus EncryptionStatus `json:"encryptionStatus,omitempty"`
}

// StorageDomainsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StorageDomainsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *StorageDomainsCreateOrUpdateFuture) Result(client StorageDomainsClient) (sd StorageDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.StorageDomainsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.StorageDomainsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sd.Response.Response, err = future.GetResult(sender); err == nil && sd.Response.Response.StatusCode != http.StatusNoContent {
		sd, err = client.CreateOrUpdateResponder(sd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple.StorageDomainsCreateOrUpdateFuture", "Result", sd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StorageDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StorageDomainsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *StorageDomainsDeleteFuture) Result(client StorageDomainsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.StorageDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("storsimple.StorageDomainsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SymmetricEncryptedSecret this class can be used as the Type for any secret entity represented as Value,
// ValueCertificateThumbprint, EncryptionAlgorithm. In this case, "Value" is a secret and the
// "valueThumbprint" represents the certificate thumbprint of the value. The algorithm field is mainly for
// future usage to potentially allow different entities encrypted using different algorithms.
type SymmetricEncryptedSecret struct {
	autorest.Response `json:"-"`
	// Value - The value of the secret itself. If the secret is in plaintext or null then EncryptionAlgorithm will be none
	Value *string `json:"value,omitempty"`
	// ValueCertificateThumbprint - Thumbprint cert that was used to encrypt "Value"
	ValueCertificateThumbprint *string `json:"valueCertificateThumbprint,omitempty"`
	// EncryptionAlgorithm - Algorithm used to encrypt "Value". Possible values include: 'EncryptionAlgorithmNone', 'EncryptionAlgorithmAES256', 'EncryptionAlgorithmRSAESPKCS1V15'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// Time the Time.
type Time struct {
	// Hour - The hour.
	Hour *int32 `json:"hour,omitempty"`
	// Minute - The minute.
	Minute *int32 `json:"minute,omitempty"`
}

// TimeSettings the TimeSettings of a device
type TimeSettings struct {
	autorest.Response `json:"-"`
	// TimeSettingsProperties - Properties of the TimeSettings.
	*TimeSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TimeSettings.
func (ts TimeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ts.TimeSettingsProperties != nil {
		objectMap["properties"] = ts.TimeSettingsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TimeSettings struct.
func (ts *TimeSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var timeSettingsProperties TimeSettingsProperties
				err = json.Unmarshal(*v, &timeSettingsProperties)
				if err != nil {
					return err
				}
				ts.TimeSettingsProperties = &timeSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ts.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ts.Type = &typeVar
			}
		}
	}

	return nil
}

// TimeSettingsProperties the properties of TimeSettings
type TimeSettingsProperties struct {
	// TimeZone - The timezone of device, like '(UTC -06:00) Central America'
	TimeZone *string `json:"timeZone,omitempty"`
	// PrimaryTimeServer - The primary Network Time Protocol (NTP) server name, like 'time.windows.com'.
	PrimaryTimeServer *string `json:"primaryTimeServer,omitempty"`
	// SecondaryTimeServer - The secondary Network Time Protocol (NTP) server name, like 'time.contoso.com'. It's optional.
	SecondaryTimeServer *string `json:"secondaryTimeServer,omitempty"`
}

// UpdateDownloadProgress details available during the download
type UpdateDownloadProgress struct {
	// DownloadPhase - The download phase. Possible values include: 'DownloadPhaseUnknown', 'DownloadPhaseInitializing', 'DownloadPhaseDownloading', 'DownloadPhaseVerifying'
	DownloadPhase DownloadPhase `json:"downloadPhase,omitempty"`
	// PercentComplete - Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// TotalBytesToDownload - Total bytes to download.
	TotalBytesToDownload *float64 `json:"totalBytesToDownload,omitempty"`
	// TotalBytesDownloaded - Total bytes downloaded.
	TotalBytesDownloaded *float64 `json:"totalBytesDownloaded,omitempty"`
	// NumberOfUpdatesToDownload - Number of updates to download.
	NumberOfUpdatesToDownload *int32 `json:"numberOfUpdatesToDownload,omitempty"`
	// NumberOfUpdatesDownloaded - Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32 `json:"numberOfUpdatesDownloaded,omitempty"`
}

// UpdateInstallProgress class representing the progress during installation of updates
type UpdateInstallProgress struct {
	// PercentComplete - Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// NumberOfUpdatesToInstall - Number of updates to install.
	NumberOfUpdatesToInstall *int32 `json:"numberOfUpdatesToInstall,omitempty"`
	// NumberOfUpdatesInstalled - Number of updates installed.
	NumberOfUpdatesInstalled *int32 `json:"numberOfUpdatesInstalled,omitempty"`
}

// Updates the updates profile
type Updates struct {
	autorest.Response `json:"-"`
	// UpdatesProperties - Update properties.
	*UpdatesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Updates.
func (u Updates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UpdatesProperties != nil {
		objectMap["properties"] = u.UpdatesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Updates struct.
func (u *Updates) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updatesProperties UpdatesProperties
				err = json.Unmarshal(*v, &updatesProperties)
				if err != nil {
					return err
				}
				u.UpdatesProperties = &updatesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		}
	}

	return nil
}

// UpdatesProperties properties of the update profile
type UpdatesProperties struct {
	// DeviceVersion - The current Device version.
	DeviceVersion *string `json:"deviceVersion,omitempty"`
	// DeviceLastScannedTime - The last time when the device did an update scan.
	DeviceLastScannedTime *date.Time `json:"deviceLastScannedTime,omitempty"`
	// RegularUpdatesAvailable - Set to true if regular updates were detected for the current version of the device.
	RegularUpdatesAvailable *bool `json:"regularUpdatesAvailable,omitempty"`
	// RebootRequiredForInstall - Set to true if RegularUpdatesAvailable is true and if at least one of the updateItems detected has needs a reboot to install.
	RebootRequiredForInstall *bool `json:"rebootRequiredForInstall,omitempty"`
	// TotalItemsPendingForDownload - The total number of items pending for download.
	TotalItemsPendingForDownload *int32 `json:"totalItemsPendingForDownload,omitempty"`
	// TotalItemsPendingForInstall - The total number of items pending for install.
	TotalItemsPendingForInstall *int32 `json:"totalItemsPendingForInstall,omitempty"`
	// Status - The current update operation. Possible values include: 'Idle', 'Scanning', 'Downloading', 'Installing'
	Status UpdateOperation `json:"status,omitempty"`
	// LastCompletedScanTime - The time when the last scan job was completed (success|cancelled|failed) on the device.
	LastCompletedScanTime *date.Time `json:"lastCompletedScanTime,omitempty"`
	// LastCompletedDownloadJobTime - The time when the last Download job was completed (success|cancelled|failed) on the device.
	LastCompletedDownloadJobTime *date.Time `json:"lastCompletedDownloadJobTime,omitempty"`
	// LastCompletedInstallJobTime - The time when the last Install job was completed (success|cancelled|failed) on the device.
	LastCompletedInstallJobTime *date.Time `json:"lastCompletedInstallJobTime,omitempty"`
	// InProgressDownloadJobID - If a download is in progress, this field contains the JobId of that particular download job
	InProgressDownloadJobID *string `json:"inProgressDownloadJobId,omitempty"`
	// InProgressInstallJobID - If an install is in progress, this field contains the JobId of that particular install job
	InProgressInstallJobID *string `json:"inProgressInstallJobId,omitempty"`
	// InProgressScanStartedTime - The time when the currently running scan (if any) started
	InProgressScanStartedTime *date.Time `json:"inProgressScanStartedTime,omitempty"`
	// InProgressDownloadJobStartedTime - The time when the currently running download (if any) started
	InProgressDownloadJobStartedTime *date.Time `json:"inProgressDownloadJobStartedTime,omitempty"`
	// InProgressInstallJobStartedTime - The time when the currently running install (if any) started
	InProgressInstallJobStartedTime *date.Time `json:"inProgressInstallJobStartedTime,omitempty"`
}

// UploadCertificateRequest upload Certificate Request to IDM
type UploadCertificateRequest struct {
	*RawCertificateData `json:"properties,omitempty"`
	// ContractVersion - READ-ONLY; Gets ContractVersion. Possible values include: 'InvalidVersion', 'V201109', 'V201202', 'V201205', 'V201212', 'V201304', 'V201310', 'V201311', 'V201404', 'V201406', 'V201407', 'V201409', 'V201410', 'V201412', 'V201501', 'V201502', 'V201504', 'V201505', 'V201506', 'V201507', 'V201508', 'V201510', 'V201512', 'V201601', 'V201602', 'V201604', 'V201605', 'V201607', 'V201608'
	ContractVersion ContractVersions `json:"contractVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for UploadCertificateRequest.
func (ucr UploadCertificateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucr.RawCertificateData != nil {
		objectMap["properties"] = ucr.RawCertificateData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UploadCertificateRequest struct.
func (ucr *UploadCertificateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var rawCertificateData RawCertificateData
				err = json.Unmarshal(*v, &rawCertificateData)
				if err != nil {
					return err
				}
				ucr.RawCertificateData = &rawCertificateData
			}
		case "contractVersion":
			if v != nil {
				var contractVersion ContractVersions
				err = json.Unmarshal(*v, &contractVersion)
				if err != nil {
					return err
				}
				ucr.ContractVersion = contractVersion
			}
		}
	}

	return nil
}

// UploadCertificateResponse upload Certificate Response from IDM
type UploadCertificateResponse struct {
	autorest.Response                 `json:"-"`
	*ResourceCertificateAndAADDetails `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UploadCertificateResponse.
func (ucr UploadCertificateResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucr.ResourceCertificateAndAADDetails != nil {
		objectMap["properties"] = ucr.ResourceCertificateAndAADDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UploadCertificateResponse struct.
func (ucr *UploadCertificateResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceCertificateAndAADDetails ResourceCertificateAndAADDetails
				err = json.Unmarshal(*v, &resourceCertificateAndAADDetails)
				if err != nil {
					return err
				}
				ucr.ResourceCertificateAndAADDetails = &resourceCertificateAndAADDetails
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ucr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ucr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ucr.Type = &typeVar
			}
		}
	}

	return nil
}
