// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/criteria.proto

package common

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A keyword criterion.
type KeywordInfo struct {
	// The text of the keyword (at most 80 characters and 10 words).
	Text *wrappers.StringValue `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The match type of the keyword.
	MatchType            enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=match_type,json=matchType,proto3,enum=google.ads.googleads.v1.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"match_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *KeywordInfo) Reset()         { *m = KeywordInfo{} }
func (m *KeywordInfo) String() string { return proto.CompactTextString(m) }
func (*KeywordInfo) ProtoMessage()    {}
func (*KeywordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{0}
}

func (m *KeywordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordInfo.Unmarshal(m, b)
}
func (m *KeywordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordInfo.Marshal(b, m, deterministic)
}
func (m *KeywordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordInfo.Merge(m, src)
}
func (m *KeywordInfo) XXX_Size() int {
	return xxx_messageInfo_KeywordInfo.Size(m)
}
func (m *KeywordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordInfo proto.InternalMessageInfo

func (m *KeywordInfo) GetText() *wrappers.StringValue {
	if m != nil {
		return m.Text
	}
	return nil
}

func (m *KeywordInfo) GetMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if m != nil {
		return m.MatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

// A placement criterion. This can be used to modify bids for sites when
// targeting the content network.
type PlacementInfo struct {
	// URL of the placement.
	//
	// For example, "http://www.domain.com".
	Url                  *wrappers.StringValue `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PlacementInfo) Reset()         { *m = PlacementInfo{} }
func (m *PlacementInfo) String() string { return proto.CompactTextString(m) }
func (*PlacementInfo) ProtoMessage()    {}
func (*PlacementInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{1}
}

func (m *PlacementInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlacementInfo.Unmarshal(m, b)
}
func (m *PlacementInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlacementInfo.Marshal(b, m, deterministic)
}
func (m *PlacementInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlacementInfo.Merge(m, src)
}
func (m *PlacementInfo) XXX_Size() int {
	return xxx_messageInfo_PlacementInfo.Size(m)
}
func (m *PlacementInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PlacementInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PlacementInfo proto.InternalMessageInfo

func (m *PlacementInfo) GetUrl() *wrappers.StringValue {
	if m != nil {
		return m.Url
	}
	return nil
}

// A mobile app category criterion.
type MobileAppCategoryInfo struct {
	// The mobile app category constant resource name.
	MobileAppCategoryConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=mobile_app_category_constant,json=mobileAppCategoryConstant,proto3" json:"mobile_app_category_constant,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}              `json:"-"`
	XXX_unrecognized          []byte                `json:"-"`
	XXX_sizecache             int32                 `json:"-"`
}

func (m *MobileAppCategoryInfo) Reset()         { *m = MobileAppCategoryInfo{} }
func (m *MobileAppCategoryInfo) String() string { return proto.CompactTextString(m) }
func (*MobileAppCategoryInfo) ProtoMessage()    {}
func (*MobileAppCategoryInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{2}
}

func (m *MobileAppCategoryInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MobileAppCategoryInfo.Unmarshal(m, b)
}
func (m *MobileAppCategoryInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MobileAppCategoryInfo.Marshal(b, m, deterministic)
}
func (m *MobileAppCategoryInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MobileAppCategoryInfo.Merge(m, src)
}
func (m *MobileAppCategoryInfo) XXX_Size() int {
	return xxx_messageInfo_MobileAppCategoryInfo.Size(m)
}
func (m *MobileAppCategoryInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MobileAppCategoryInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MobileAppCategoryInfo proto.InternalMessageInfo

func (m *MobileAppCategoryInfo) GetMobileAppCategoryConstant() *wrappers.StringValue {
	if m != nil {
		return m.MobileAppCategoryConstant
	}
	return nil
}

// A mobile application criterion.
type MobileApplicationInfo struct {
	// A string that uniquely identifies a mobile application to Google Ads API.
	// The format of this string is "{platform}-{platform_native_id}", where
	// platform is "1" for iOS apps and "2" for Android apps, and where
	// platform_native_id is the mobile application identifier native to the
	// corresponding platform.
	// For iOS, this native identifier is the 9 digit string that appears at the
	// end of an App Store URL (e.g., "476943146" for "Flood-It! 2" whose App
	// Store link is http://itunes.apple.com/us/app/flood-it!-2/id476943146).
	// For Android, this native identifier is the application's package name
	// (e.g., "com.labpixies.colordrips" for "Color Drips" given Google Play link
	// https://play.google.com/store/apps/details?id=com.labpixies.colordrips).
	// A well formed app id for Google Ads API would thus be "1-476943146" for iOS
	// and "2-com.labpixies.colordrips" for Android.
	// This field is required and must be set in CREATE operations.
	AppId *wrappers.StringValue `protobuf:"bytes,2,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// Name of this mobile application.
	Name                 *wrappers.StringValue `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MobileApplicationInfo) Reset()         { *m = MobileApplicationInfo{} }
func (m *MobileApplicationInfo) String() string { return proto.CompactTextString(m) }
func (*MobileApplicationInfo) ProtoMessage()    {}
func (*MobileApplicationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{3}
}

func (m *MobileApplicationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MobileApplicationInfo.Unmarshal(m, b)
}
func (m *MobileApplicationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MobileApplicationInfo.Marshal(b, m, deterministic)
}
func (m *MobileApplicationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MobileApplicationInfo.Merge(m, src)
}
func (m *MobileApplicationInfo) XXX_Size() int {
	return xxx_messageInfo_MobileApplicationInfo.Size(m)
}
func (m *MobileApplicationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MobileApplicationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MobileApplicationInfo proto.InternalMessageInfo

func (m *MobileApplicationInfo) GetAppId() *wrappers.StringValue {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *MobileApplicationInfo) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

// A location criterion.
type LocationInfo struct {
	// The geo target constant resource name.
	GeoTargetConstant    *wrappers.StringValue `protobuf:"bytes,1,opt,name=geo_target_constant,json=geoTargetConstant,proto3" json:"geo_target_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LocationInfo) Reset()         { *m = LocationInfo{} }
func (m *LocationInfo) String() string { return proto.CompactTextString(m) }
func (*LocationInfo) ProtoMessage()    {}
func (*LocationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{4}
}

func (m *LocationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationInfo.Unmarshal(m, b)
}
func (m *LocationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationInfo.Marshal(b, m, deterministic)
}
func (m *LocationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationInfo.Merge(m, src)
}
func (m *LocationInfo) XXX_Size() int {
	return xxx_messageInfo_LocationInfo.Size(m)
}
func (m *LocationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LocationInfo proto.InternalMessageInfo

func (m *LocationInfo) GetGeoTargetConstant() *wrappers.StringValue {
	if m != nil {
		return m.GeoTargetConstant
	}
	return nil
}

// A device criterion.
type DeviceInfo struct {
	// Type of the device.
	Type                 enums.DeviceEnum_Device `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.DeviceEnum_Device" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *DeviceInfo) Reset()         { *m = DeviceInfo{} }
func (m *DeviceInfo) String() string { return proto.CompactTextString(m) }
func (*DeviceInfo) ProtoMessage()    {}
func (*DeviceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{5}
}

func (m *DeviceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceInfo.Unmarshal(m, b)
}
func (m *DeviceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceInfo.Marshal(b, m, deterministic)
}
func (m *DeviceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceInfo.Merge(m, src)
}
func (m *DeviceInfo) XXX_Size() int {
	return xxx_messageInfo_DeviceInfo.Size(m)
}
func (m *DeviceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceInfo proto.InternalMessageInfo

func (m *DeviceInfo) GetType() enums.DeviceEnum_Device {
	if m != nil {
		return m.Type
	}
	return enums.DeviceEnum_UNSPECIFIED
}

// A preferred content criterion.
type PreferredContentInfo struct {
	// Type of the preferred content.
	Type                 enums.PreferredContentTypeEnum_PreferredContentType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.PreferredContentTypeEnum_PreferredContentType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *PreferredContentInfo) Reset()         { *m = PreferredContentInfo{} }
func (m *PreferredContentInfo) String() string { return proto.CompactTextString(m) }
func (*PreferredContentInfo) ProtoMessage()    {}
func (*PreferredContentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{6}
}

func (m *PreferredContentInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreferredContentInfo.Unmarshal(m, b)
}
func (m *PreferredContentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreferredContentInfo.Marshal(b, m, deterministic)
}
func (m *PreferredContentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreferredContentInfo.Merge(m, src)
}
func (m *PreferredContentInfo) XXX_Size() int {
	return xxx_messageInfo_PreferredContentInfo.Size(m)
}
func (m *PreferredContentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PreferredContentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PreferredContentInfo proto.InternalMessageInfo

func (m *PreferredContentInfo) GetType() enums.PreferredContentTypeEnum_PreferredContentType {
	if m != nil {
		return m.Type
	}
	return enums.PreferredContentTypeEnum_UNSPECIFIED
}

// A listing group criterion.
type ListingGroupInfo struct {
	// Type of the listing group.
	Type enums.ListingGroupTypeEnum_ListingGroupType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.ListingGroupTypeEnum_ListingGroupType" json:"type,omitempty"`
	// Dimension value with which this listing group is refining its parent.
	// Undefined for the root group.
	CaseValue *ListingDimensionInfo `protobuf:"bytes,2,opt,name=case_value,json=caseValue,proto3" json:"case_value,omitempty"`
	// Resource name of ad group criterion which is the parent listing group
	// subdivision. Null for the root group.
	ParentAdGroupCriterion *wrappers.StringValue `protobuf:"bytes,3,opt,name=parent_ad_group_criterion,json=parentAdGroupCriterion,proto3" json:"parent_ad_group_criterion,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}              `json:"-"`
	XXX_unrecognized       []byte                `json:"-"`
	XXX_sizecache          int32                 `json:"-"`
}

func (m *ListingGroupInfo) Reset()         { *m = ListingGroupInfo{} }
func (m *ListingGroupInfo) String() string { return proto.CompactTextString(m) }
func (*ListingGroupInfo) ProtoMessage()    {}
func (*ListingGroupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{7}
}

func (m *ListingGroupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingGroupInfo.Unmarshal(m, b)
}
func (m *ListingGroupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingGroupInfo.Marshal(b, m, deterministic)
}
func (m *ListingGroupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingGroupInfo.Merge(m, src)
}
func (m *ListingGroupInfo) XXX_Size() int {
	return xxx_messageInfo_ListingGroupInfo.Size(m)
}
func (m *ListingGroupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingGroupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingGroupInfo proto.InternalMessageInfo

func (m *ListingGroupInfo) GetType() enums.ListingGroupTypeEnum_ListingGroupType {
	if m != nil {
		return m.Type
	}
	return enums.ListingGroupTypeEnum_UNSPECIFIED
}

func (m *ListingGroupInfo) GetCaseValue() *ListingDimensionInfo {
	if m != nil {
		return m.CaseValue
	}
	return nil
}

func (m *ListingGroupInfo) GetParentAdGroupCriterion() *wrappers.StringValue {
	if m != nil {
		return m.ParentAdGroupCriterion
	}
	return nil
}

// A listing scope criterion.
type ListingScopeInfo struct {
	// Scope of the campaign criterion.
	Dimensions           []*ListingDimensionInfo `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ListingScopeInfo) Reset()         { *m = ListingScopeInfo{} }
func (m *ListingScopeInfo) String() string { return proto.CompactTextString(m) }
func (*ListingScopeInfo) ProtoMessage()    {}
func (*ListingScopeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{8}
}

func (m *ListingScopeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingScopeInfo.Unmarshal(m, b)
}
func (m *ListingScopeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingScopeInfo.Marshal(b, m, deterministic)
}
func (m *ListingScopeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingScopeInfo.Merge(m, src)
}
func (m *ListingScopeInfo) XXX_Size() int {
	return xxx_messageInfo_ListingScopeInfo.Size(m)
}
func (m *ListingScopeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingScopeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingScopeInfo proto.InternalMessageInfo

func (m *ListingScopeInfo) GetDimensions() []*ListingDimensionInfo {
	if m != nil {
		return m.Dimensions
	}
	return nil
}

// Listing dimensions for listing group criterion.
type ListingDimensionInfo struct {
	// Dimension of one of the types below is always present.
	//
	// Types that are valid to be assigned to Dimension:
	//	*ListingDimensionInfo_ListingBrand
	//	*ListingDimensionInfo_HotelId
	//	*ListingDimensionInfo_HotelClass
	//	*ListingDimensionInfo_HotelCountryRegion
	//	*ListingDimensionInfo_HotelState
	//	*ListingDimensionInfo_HotelCity
	//	*ListingDimensionInfo_ListingCustomAttribute
	//	*ListingDimensionInfo_ProductBiddingCategory
	//	*ListingDimensionInfo_ProductChannel
	//	*ListingDimensionInfo_ProductChannelExclusivity
	//	*ListingDimensionInfo_ProductCondition
	//	*ListingDimensionInfo_ProductItemId
	//	*ListingDimensionInfo_ProductType
	//	*ListingDimensionInfo_UnknownListingDimension
	Dimension            isListingDimensionInfo_Dimension `protobuf_oneof:"dimension"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *ListingDimensionInfo) Reset()         { *m = ListingDimensionInfo{} }
func (m *ListingDimensionInfo) String() string { return proto.CompactTextString(m) }
func (*ListingDimensionInfo) ProtoMessage()    {}
func (*ListingDimensionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{9}
}

func (m *ListingDimensionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingDimensionInfo.Unmarshal(m, b)
}
func (m *ListingDimensionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingDimensionInfo.Marshal(b, m, deterministic)
}
func (m *ListingDimensionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingDimensionInfo.Merge(m, src)
}
func (m *ListingDimensionInfo) XXX_Size() int {
	return xxx_messageInfo_ListingDimensionInfo.Size(m)
}
func (m *ListingDimensionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingDimensionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingDimensionInfo proto.InternalMessageInfo

type isListingDimensionInfo_Dimension interface {
	isListingDimensionInfo_Dimension()
}

type ListingDimensionInfo_ListingBrand struct {
	ListingBrand *ListingBrandInfo `protobuf:"bytes,1,opt,name=listing_brand,json=listingBrand,proto3,oneof"`
}

type ListingDimensionInfo_HotelId struct {
	HotelId *HotelIdInfo `protobuf:"bytes,2,opt,name=hotel_id,json=hotelId,proto3,oneof"`
}

type ListingDimensionInfo_HotelClass struct {
	HotelClass *HotelClassInfo `protobuf:"bytes,3,opt,name=hotel_class,json=hotelClass,proto3,oneof"`
}

type ListingDimensionInfo_HotelCountryRegion struct {
	HotelCountryRegion *HotelCountryRegionInfo `protobuf:"bytes,4,opt,name=hotel_country_region,json=hotelCountryRegion,proto3,oneof"`
}

type ListingDimensionInfo_HotelState struct {
	HotelState *HotelStateInfo `protobuf:"bytes,5,opt,name=hotel_state,json=hotelState,proto3,oneof"`
}

type ListingDimensionInfo_HotelCity struct {
	HotelCity *HotelCityInfo `protobuf:"bytes,6,opt,name=hotel_city,json=hotelCity,proto3,oneof"`
}

type ListingDimensionInfo_ListingCustomAttribute struct {
	ListingCustomAttribute *ListingCustomAttributeInfo `protobuf:"bytes,7,opt,name=listing_custom_attribute,json=listingCustomAttribute,proto3,oneof"`
}

type ListingDimensionInfo_ProductBiddingCategory struct {
	ProductBiddingCategory *ProductBiddingCategoryInfo `protobuf:"bytes,13,opt,name=product_bidding_category,json=productBiddingCategory,proto3,oneof"`
}

type ListingDimensionInfo_ProductChannel struct {
	ProductChannel *ProductChannelInfo `protobuf:"bytes,8,opt,name=product_channel,json=productChannel,proto3,oneof"`
}

type ListingDimensionInfo_ProductChannelExclusivity struct {
	ProductChannelExclusivity *ProductChannelExclusivityInfo `protobuf:"bytes,9,opt,name=product_channel_exclusivity,json=productChannelExclusivity,proto3,oneof"`
}

type ListingDimensionInfo_ProductCondition struct {
	ProductCondition *ProductConditionInfo `protobuf:"bytes,10,opt,name=product_condition,json=productCondition,proto3,oneof"`
}

type ListingDimensionInfo_ProductItemId struct {
	ProductItemId *ProductItemIdInfo `protobuf:"bytes,11,opt,name=product_item_id,json=productItemId,proto3,oneof"`
}

type ListingDimensionInfo_ProductType struct {
	ProductType *ProductTypeInfo `protobuf:"bytes,12,opt,name=product_type,json=productType,proto3,oneof"`
}

type ListingDimensionInfo_UnknownListingDimension struct {
	UnknownListingDimension *UnknownListingDimensionInfo `protobuf:"bytes,14,opt,name=unknown_listing_dimension,json=unknownListingDimension,proto3,oneof"`
}

func (*ListingDimensionInfo_ListingBrand) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelId) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelClass) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelCountryRegion) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelState) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelCity) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ListingCustomAttribute) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductBiddingCategory) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductChannel) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductChannelExclusivity) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductCondition) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductItemId) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductType) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_UnknownListingDimension) isListingDimensionInfo_Dimension() {}

func (m *ListingDimensionInfo) GetDimension() isListingDimensionInfo_Dimension {
	if m != nil {
		return m.Dimension
	}
	return nil
}

func (m *ListingDimensionInfo) GetListingBrand() *ListingBrandInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ListingBrand); ok {
		return x.ListingBrand
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelId() *HotelIdInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelId); ok {
		return x.HotelId
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelClass() *HotelClassInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelClass); ok {
		return x.HotelClass
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelCountryRegion() *HotelCountryRegionInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelCountryRegion); ok {
		return x.HotelCountryRegion
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelState() *HotelStateInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelState); ok {
		return x.HotelState
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelCity() *HotelCityInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelCity); ok {
		return x.HotelCity
	}
	return nil
}

func (m *ListingDimensionInfo) GetListingCustomAttribute() *ListingCustomAttributeInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ListingCustomAttribute); ok {
		return x.ListingCustomAttribute
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductBiddingCategory() *ProductBiddingCategoryInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductBiddingCategory); ok {
		return x.ProductBiddingCategory
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductChannel() *ProductChannelInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductChannel); ok {
		return x.ProductChannel
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductChannelExclusivity() *ProductChannelExclusivityInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductChannelExclusivity); ok {
		return x.ProductChannelExclusivity
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductCondition() *ProductConditionInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductCondition); ok {
		return x.ProductCondition
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductItemId() *ProductItemIdInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductItemId); ok {
		return x.ProductItemId
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductType() *ProductTypeInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductType); ok {
		return x.ProductType
	}
	return nil
}

func (m *ListingDimensionInfo) GetUnknownListingDimension() *UnknownListingDimensionInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_UnknownListingDimension); ok {
		return x.UnknownListingDimension
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListingDimensionInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListingDimensionInfo_ListingBrand)(nil),
		(*ListingDimensionInfo_HotelId)(nil),
		(*ListingDimensionInfo_HotelClass)(nil),
		(*ListingDimensionInfo_HotelCountryRegion)(nil),
		(*ListingDimensionInfo_HotelState)(nil),
		(*ListingDimensionInfo_HotelCity)(nil),
		(*ListingDimensionInfo_ListingCustomAttribute)(nil),
		(*ListingDimensionInfo_ProductBiddingCategory)(nil),
		(*ListingDimensionInfo_ProductChannel)(nil),
		(*ListingDimensionInfo_ProductChannelExclusivity)(nil),
		(*ListingDimensionInfo_ProductCondition)(nil),
		(*ListingDimensionInfo_ProductItemId)(nil),
		(*ListingDimensionInfo_ProductType)(nil),
		(*ListingDimensionInfo_UnknownListingDimension)(nil),
	}
}

// Brand of the listing.
type ListingBrandInfo struct {
	// String value of the listing brand.
	Value                *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListingBrandInfo) Reset()         { *m = ListingBrandInfo{} }
func (m *ListingBrandInfo) String() string { return proto.CompactTextString(m) }
func (*ListingBrandInfo) ProtoMessage()    {}
func (*ListingBrandInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{10}
}

func (m *ListingBrandInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingBrandInfo.Unmarshal(m, b)
}
func (m *ListingBrandInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingBrandInfo.Marshal(b, m, deterministic)
}
func (m *ListingBrandInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingBrandInfo.Merge(m, src)
}
func (m *ListingBrandInfo) XXX_Size() int {
	return xxx_messageInfo_ListingBrandInfo.Size(m)
}
func (m *ListingBrandInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingBrandInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingBrandInfo proto.InternalMessageInfo

func (m *ListingBrandInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// Advertiser-specific hotel ID.
type HotelIdInfo struct {
	// String value of the hotel ID.
	Value                *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HotelIdInfo) Reset()         { *m = HotelIdInfo{} }
func (m *HotelIdInfo) String() string { return proto.CompactTextString(m) }
func (*HotelIdInfo) ProtoMessage()    {}
func (*HotelIdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{11}
}

func (m *HotelIdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelIdInfo.Unmarshal(m, b)
}
func (m *HotelIdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelIdInfo.Marshal(b, m, deterministic)
}
func (m *HotelIdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelIdInfo.Merge(m, src)
}
func (m *HotelIdInfo) XXX_Size() int {
	return xxx_messageInfo_HotelIdInfo.Size(m)
}
func (m *HotelIdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelIdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelIdInfo proto.InternalMessageInfo

func (m *HotelIdInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// Class of the hotel as a number of stars 1 to 5.
type HotelClassInfo struct {
	// Long value of the hotel class.
	Value                *wrappers.Int64Value `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HotelClassInfo) Reset()         { *m = HotelClassInfo{} }
func (m *HotelClassInfo) String() string { return proto.CompactTextString(m) }
func (*HotelClassInfo) ProtoMessage()    {}
func (*HotelClassInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{12}
}

func (m *HotelClassInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelClassInfo.Unmarshal(m, b)
}
func (m *HotelClassInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelClassInfo.Marshal(b, m, deterministic)
}
func (m *HotelClassInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelClassInfo.Merge(m, src)
}
func (m *HotelClassInfo) XXX_Size() int {
	return xxx_messageInfo_HotelClassInfo.Size(m)
}
func (m *HotelClassInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelClassInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelClassInfo proto.InternalMessageInfo

func (m *HotelClassInfo) GetValue() *wrappers.Int64Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// Country or Region the hotel is located in.
type HotelCountryRegionInfo struct {
	// The Geo Target Constant resource name.
	CountryRegionCriterion *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_region_criterion,json=countryRegionCriterion,proto3" json:"country_region_criterion,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}              `json:"-"`
	XXX_unrecognized       []byte                `json:"-"`
	XXX_sizecache          int32                 `json:"-"`
}

func (m *HotelCountryRegionInfo) Reset()         { *m = HotelCountryRegionInfo{} }
func (m *HotelCountryRegionInfo) String() string { return proto.CompactTextString(m) }
func (*HotelCountryRegionInfo) ProtoMessage()    {}
func (*HotelCountryRegionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{13}
}

func (m *HotelCountryRegionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelCountryRegionInfo.Unmarshal(m, b)
}
func (m *HotelCountryRegionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelCountryRegionInfo.Marshal(b, m, deterministic)
}
func (m *HotelCountryRegionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelCountryRegionInfo.Merge(m, src)
}
func (m *HotelCountryRegionInfo) XXX_Size() int {
	return xxx_messageInfo_HotelCountryRegionInfo.Size(m)
}
func (m *HotelCountryRegionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelCountryRegionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelCountryRegionInfo proto.InternalMessageInfo

func (m *HotelCountryRegionInfo) GetCountryRegionCriterion() *wrappers.StringValue {
	if m != nil {
		return m.CountryRegionCriterion
	}
	return nil
}

// State the hotel is located in.
type HotelStateInfo struct {
	// The Geo Target Constant resource name.
	StateCriterion       *wrappers.StringValue `protobuf:"bytes,1,opt,name=state_criterion,json=stateCriterion,proto3" json:"state_criterion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HotelStateInfo) Reset()         { *m = HotelStateInfo{} }
func (m *HotelStateInfo) String() string { return proto.CompactTextString(m) }
func (*HotelStateInfo) ProtoMessage()    {}
func (*HotelStateInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{14}
}

func (m *HotelStateInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelStateInfo.Unmarshal(m, b)
}
func (m *HotelStateInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelStateInfo.Marshal(b, m, deterministic)
}
func (m *HotelStateInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelStateInfo.Merge(m, src)
}
func (m *HotelStateInfo) XXX_Size() int {
	return xxx_messageInfo_HotelStateInfo.Size(m)
}
func (m *HotelStateInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelStateInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelStateInfo proto.InternalMessageInfo

func (m *HotelStateInfo) GetStateCriterion() *wrappers.StringValue {
	if m != nil {
		return m.StateCriterion
	}
	return nil
}

// City the hotel is located in.
type HotelCityInfo struct {
	// The Geo Target Constant resource name.
	CityCriterion        *wrappers.StringValue `protobuf:"bytes,1,opt,name=city_criterion,json=cityCriterion,proto3" json:"city_criterion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HotelCityInfo) Reset()         { *m = HotelCityInfo{} }
func (m *HotelCityInfo) String() string { return proto.CompactTextString(m) }
func (*HotelCityInfo) ProtoMessage()    {}
func (*HotelCityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{15}
}

func (m *HotelCityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelCityInfo.Unmarshal(m, b)
}
func (m *HotelCityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelCityInfo.Marshal(b, m, deterministic)
}
func (m *HotelCityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelCityInfo.Merge(m, src)
}
func (m *HotelCityInfo) XXX_Size() int {
	return xxx_messageInfo_HotelCityInfo.Size(m)
}
func (m *HotelCityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelCityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelCityInfo proto.InternalMessageInfo

func (m *HotelCityInfo) GetCityCriterion() *wrappers.StringValue {
	if m != nil {
		return m.CityCriterion
	}
	return nil
}

// Listing custom attribute.
type ListingCustomAttributeInfo struct {
	// String value of the listing custom attribute.
	Value *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Indicates the index of the custom attribute.
	Index                enums.ListingCustomAttributeIndexEnum_ListingCustomAttributeIndex `protobuf:"varint,2,opt,name=index,proto3,enum=google.ads.googleads.v1.enums.ListingCustomAttributeIndexEnum_ListingCustomAttributeIndex" json:"index,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                          `json:"-"`
	XXX_unrecognized     []byte                                                            `json:"-"`
	XXX_sizecache        int32                                                             `json:"-"`
}

func (m *ListingCustomAttributeInfo) Reset()         { *m = ListingCustomAttributeInfo{} }
func (m *ListingCustomAttributeInfo) String() string { return proto.CompactTextString(m) }
func (*ListingCustomAttributeInfo) ProtoMessage()    {}
func (*ListingCustomAttributeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{16}
}

func (m *ListingCustomAttributeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingCustomAttributeInfo.Unmarshal(m, b)
}
func (m *ListingCustomAttributeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingCustomAttributeInfo.Marshal(b, m, deterministic)
}
func (m *ListingCustomAttributeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingCustomAttributeInfo.Merge(m, src)
}
func (m *ListingCustomAttributeInfo) XXX_Size() int {
	return xxx_messageInfo_ListingCustomAttributeInfo.Size(m)
}
func (m *ListingCustomAttributeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingCustomAttributeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingCustomAttributeInfo proto.InternalMessageInfo

func (m *ListingCustomAttributeInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ListingCustomAttributeInfo) GetIndex() enums.ListingCustomAttributeIndexEnum_ListingCustomAttributeIndex {
	if m != nil {
		return m.Index
	}
	return enums.ListingCustomAttributeIndexEnum_UNSPECIFIED
}

// Bidding category of a product offer.
type ProductBiddingCategoryInfo struct {
	// ID of the product bidding category.
	//
	// This ID is equivalent to the google_product_category ID as described in
	// this article: https://support.google.com/merchants/answer/6324436.
	Id *wrappers.Int64Value `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Two-letter upper-case country code of the product bidding category. It must
	// match the campaign.shopping_setting.sales_country field.
	CountryCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Level of the product bidding category.
	Level                enums.ProductBiddingCategoryLevelEnum_ProductBiddingCategoryLevel `protobuf:"varint,3,opt,name=level,proto3,enum=google.ads.googleads.v1.enums.ProductBiddingCategoryLevelEnum_ProductBiddingCategoryLevel" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                          `json:"-"`
	XXX_unrecognized     []byte                                                            `json:"-"`
	XXX_sizecache        int32                                                             `json:"-"`
}

func (m *ProductBiddingCategoryInfo) Reset()         { *m = ProductBiddingCategoryInfo{} }
func (m *ProductBiddingCategoryInfo) String() string { return proto.CompactTextString(m) }
func (*ProductBiddingCategoryInfo) ProtoMessage()    {}
func (*ProductBiddingCategoryInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{17}
}

func (m *ProductBiddingCategoryInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductBiddingCategoryInfo.Unmarshal(m, b)
}
func (m *ProductBiddingCategoryInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductBiddingCategoryInfo.Marshal(b, m, deterministic)
}
func (m *ProductBiddingCategoryInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductBiddingCategoryInfo.Merge(m, src)
}
func (m *ProductBiddingCategoryInfo) XXX_Size() int {
	return xxx_messageInfo_ProductBiddingCategoryInfo.Size(m)
}
func (m *ProductBiddingCategoryInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductBiddingCategoryInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductBiddingCategoryInfo proto.InternalMessageInfo

func (m *ProductBiddingCategoryInfo) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *ProductBiddingCategoryInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *ProductBiddingCategoryInfo) GetLevel() enums.ProductBiddingCategoryLevelEnum_ProductBiddingCategoryLevel {
	if m != nil {
		return m.Level
	}
	return enums.ProductBiddingCategoryLevelEnum_UNSPECIFIED
}

// Locality of a product offer.
type ProductChannelInfo struct {
	// Value of the locality.
	Channel              enums.ProductChannelEnum_ProductChannel `protobuf:"varint,1,opt,name=channel,proto3,enum=google.ads.googleads.v1.enums.ProductChannelEnum_ProductChannel" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *ProductChannelInfo) Reset()         { *m = ProductChannelInfo{} }
func (m *ProductChannelInfo) String() string { return proto.CompactTextString(m) }
func (*ProductChannelInfo) ProtoMessage()    {}
func (*ProductChannelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{18}
}

func (m *ProductChannelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductChannelInfo.Unmarshal(m, b)
}
func (m *ProductChannelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductChannelInfo.Marshal(b, m, deterministic)
}
func (m *ProductChannelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductChannelInfo.Merge(m, src)
}
func (m *ProductChannelInfo) XXX_Size() int {
	return xxx_messageInfo_ProductChannelInfo.Size(m)
}
func (m *ProductChannelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductChannelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductChannelInfo proto.InternalMessageInfo

func (m *ProductChannelInfo) GetChannel() enums.ProductChannelEnum_ProductChannel {
	if m != nil {
		return m.Channel
	}
	return enums.ProductChannelEnum_UNSPECIFIED
}

// Availability of a product offer.
type ProductChannelExclusivityInfo struct {
	// Value of the availability.
	ChannelExclusivity   enums.ProductChannelExclusivityEnum_ProductChannelExclusivity `protobuf:"varint,1,opt,name=channel_exclusivity,json=channelExclusivity,proto3,enum=google.ads.googleads.v1.enums.ProductChannelExclusivityEnum_ProductChannelExclusivity" json:"channel_exclusivity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                      `json:"-"`
	XXX_unrecognized     []byte                                                        `json:"-"`
	XXX_sizecache        int32                                                         `json:"-"`
}

func (m *ProductChannelExclusivityInfo) Reset()         { *m = ProductChannelExclusivityInfo{} }
func (m *ProductChannelExclusivityInfo) String() string { return proto.CompactTextString(m) }
func (*ProductChannelExclusivityInfo) ProtoMessage()    {}
func (*ProductChannelExclusivityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{19}
}

func (m *ProductChannelExclusivityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductChannelExclusivityInfo.Unmarshal(m, b)
}
func (m *ProductChannelExclusivityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductChannelExclusivityInfo.Marshal(b, m, deterministic)
}
func (m *ProductChannelExclusivityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductChannelExclusivityInfo.Merge(m, src)
}
func (m *ProductChannelExclusivityInfo) XXX_Size() int {
	return xxx_messageInfo_ProductChannelExclusivityInfo.Size(m)
}
func (m *ProductChannelExclusivityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductChannelExclusivityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductChannelExclusivityInfo proto.InternalMessageInfo

func (m *ProductChannelExclusivityInfo) GetChannelExclusivity() enums.ProductChannelExclusivityEnum_ProductChannelExclusivity {
	if m != nil {
		return m.ChannelExclusivity
	}
	return enums.ProductChannelExclusivityEnum_UNSPECIFIED
}

// Condition of a product offer.
type ProductConditionInfo struct {
	// Value of the condition.
	Condition            enums.ProductConditionEnum_ProductCondition `protobuf:"varint,1,opt,name=condition,proto3,enum=google.ads.googleads.v1.enums.ProductConditionEnum_ProductCondition" json:"condition,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ProductConditionInfo) Reset()         { *m = ProductConditionInfo{} }
func (m *ProductConditionInfo) String() string { return proto.CompactTextString(m) }
func (*ProductConditionInfo) ProtoMessage()    {}
func (*ProductConditionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{20}
}

func (m *ProductConditionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductConditionInfo.Unmarshal(m, b)
}
func (m *ProductConditionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductConditionInfo.Marshal(b, m, deterministic)
}
func (m *ProductConditionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductConditionInfo.Merge(m, src)
}
func (m *ProductConditionInfo) XXX_Size() int {
	return xxx_messageInfo_ProductConditionInfo.Size(m)
}
func (m *ProductConditionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductConditionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductConditionInfo proto.InternalMessageInfo

func (m *ProductConditionInfo) GetCondition() enums.ProductConditionEnum_ProductCondition {
	if m != nil {
		return m.Condition
	}
	return enums.ProductConditionEnum_UNSPECIFIED
}

// Item id of a product offer.
type ProductItemIdInfo struct {
	// Value of the id.
	Value                *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ProductItemIdInfo) Reset()         { *m = ProductItemIdInfo{} }
func (m *ProductItemIdInfo) String() string { return proto.CompactTextString(m) }
func (*ProductItemIdInfo) ProtoMessage()    {}
func (*ProductItemIdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{21}
}

func (m *ProductItemIdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductItemIdInfo.Unmarshal(m, b)
}
func (m *ProductItemIdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductItemIdInfo.Marshal(b, m, deterministic)
}
func (m *ProductItemIdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductItemIdInfo.Merge(m, src)
}
func (m *ProductItemIdInfo) XXX_Size() int {
	return xxx_messageInfo_ProductItemIdInfo.Size(m)
}
func (m *ProductItemIdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductItemIdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductItemIdInfo proto.InternalMessageInfo

func (m *ProductItemIdInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// Type of a product offer.
type ProductTypeInfo struct {
	// Value of the type.
	Value *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Level of the type.
	Level                enums.ProductTypeLevelEnum_ProductTypeLevel `protobuf:"varint,2,opt,name=level,proto3,enum=google.ads.googleads.v1.enums.ProductTypeLevelEnum_ProductTypeLevel" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ProductTypeInfo) Reset()         { *m = ProductTypeInfo{} }
func (m *ProductTypeInfo) String() string { return proto.CompactTextString(m) }
func (*ProductTypeInfo) ProtoMessage()    {}
func (*ProductTypeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{22}
}

func (m *ProductTypeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductTypeInfo.Unmarshal(m, b)
}
func (m *ProductTypeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductTypeInfo.Marshal(b, m, deterministic)
}
func (m *ProductTypeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductTypeInfo.Merge(m, src)
}
func (m *ProductTypeInfo) XXX_Size() int {
	return xxx_messageInfo_ProductTypeInfo.Size(m)
}
func (m *ProductTypeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductTypeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductTypeInfo proto.InternalMessageInfo

func (m *ProductTypeInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ProductTypeInfo) GetLevel() enums.ProductTypeLevelEnum_ProductTypeLevel {
	if m != nil {
		return m.Level
	}
	return enums.ProductTypeLevelEnum_UNSPECIFIED
}

// Unknown listing dimension.
type UnknownListingDimensionInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnknownListingDimensionInfo) Reset()         { *m = UnknownListingDimensionInfo{} }
func (m *UnknownListingDimensionInfo) String() string { return proto.CompactTextString(m) }
func (*UnknownListingDimensionInfo) ProtoMessage()    {}
func (*UnknownListingDimensionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{23}
}

func (m *UnknownListingDimensionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UnknownListingDimensionInfo.Unmarshal(m, b)
}
func (m *UnknownListingDimensionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UnknownListingDimensionInfo.Marshal(b, m, deterministic)
}
func (m *UnknownListingDimensionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnknownListingDimensionInfo.Merge(m, src)
}
func (m *UnknownListingDimensionInfo) XXX_Size() int {
	return xxx_messageInfo_UnknownListingDimensionInfo.Size(m)
}
func (m *UnknownListingDimensionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UnknownListingDimensionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UnknownListingDimensionInfo proto.InternalMessageInfo

// Criterion for hotel date selection (default dates vs. user selected).
type HotelDateSelectionTypeInfo struct {
	// Type of the hotel date selection
	Type                 enums.HotelDateSelectionTypeEnum_HotelDateSelectionType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.HotelDateSelectionTypeEnum_HotelDateSelectionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                `json:"-"`
	XXX_unrecognized     []byte                                                  `json:"-"`
	XXX_sizecache        int32                                                   `json:"-"`
}

func (m *HotelDateSelectionTypeInfo) Reset()         { *m = HotelDateSelectionTypeInfo{} }
func (m *HotelDateSelectionTypeInfo) String() string { return proto.CompactTextString(m) }
func (*HotelDateSelectionTypeInfo) ProtoMessage()    {}
func (*HotelDateSelectionTypeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{24}
}

func (m *HotelDateSelectionTypeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelDateSelectionTypeInfo.Unmarshal(m, b)
}
func (m *HotelDateSelectionTypeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelDateSelectionTypeInfo.Marshal(b, m, deterministic)
}
func (m *HotelDateSelectionTypeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelDateSelectionTypeInfo.Merge(m, src)
}
func (m *HotelDateSelectionTypeInfo) XXX_Size() int {
	return xxx_messageInfo_HotelDateSelectionTypeInfo.Size(m)
}
func (m *HotelDateSelectionTypeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelDateSelectionTypeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelDateSelectionTypeInfo proto.InternalMessageInfo

func (m *HotelDateSelectionTypeInfo) GetType() enums.HotelDateSelectionTypeEnum_HotelDateSelectionType {
	if m != nil {
		return m.Type
	}
	return enums.HotelDateSelectionTypeEnum_UNSPECIFIED
}

// Criterion for number of days prior to the stay the booking is being made.
type HotelAdvanceBookingWindowInfo struct {
	// Low end of the number of days prior to the stay.
	MinDays *wrappers.Int64Value `protobuf:"bytes,1,opt,name=min_days,json=minDays,proto3" json:"min_days,omitempty"`
	// High end of the number of days prior to the stay.
	MaxDays              *wrappers.Int64Value `protobuf:"bytes,2,opt,name=max_days,json=maxDays,proto3" json:"max_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HotelAdvanceBookingWindowInfo) Reset()         { *m = HotelAdvanceBookingWindowInfo{} }
func (m *HotelAdvanceBookingWindowInfo) String() string { return proto.CompactTextString(m) }
func (*HotelAdvanceBookingWindowInfo) ProtoMessage()    {}
func (*HotelAdvanceBookingWindowInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{25}
}

func (m *HotelAdvanceBookingWindowInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelAdvanceBookingWindowInfo.Unmarshal(m, b)
}
func (m *HotelAdvanceBookingWindowInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelAdvanceBookingWindowInfo.Marshal(b, m, deterministic)
}
func (m *HotelAdvanceBookingWindowInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelAdvanceBookingWindowInfo.Merge(m, src)
}
func (m *HotelAdvanceBookingWindowInfo) XXX_Size() int {
	return xxx_messageInfo_HotelAdvanceBookingWindowInfo.Size(m)
}
func (m *HotelAdvanceBookingWindowInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelAdvanceBookingWindowInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelAdvanceBookingWindowInfo proto.InternalMessageInfo

func (m *HotelAdvanceBookingWindowInfo) GetMinDays() *wrappers.Int64Value {
	if m != nil {
		return m.MinDays
	}
	return nil
}

func (m *HotelAdvanceBookingWindowInfo) GetMaxDays() *wrappers.Int64Value {
	if m != nil {
		return m.MaxDays
	}
	return nil
}

// Criterion for length of hotel stay in nights.
type HotelLengthOfStayInfo struct {
	// Low end of the number of nights in the stay.
	MinNights *wrappers.Int64Value `protobuf:"bytes,1,opt,name=min_nights,json=minNights,proto3" json:"min_nights,omitempty"`
	// High end of the number of nights in the stay.
	MaxNights            *wrappers.Int64Value `protobuf:"bytes,2,opt,name=max_nights,json=maxNights,proto3" json:"max_nights,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HotelLengthOfStayInfo) Reset()         { *m = HotelLengthOfStayInfo{} }
func (m *HotelLengthOfStayInfo) String() string { return proto.CompactTextString(m) }
func (*HotelLengthOfStayInfo) ProtoMessage()    {}
func (*HotelLengthOfStayInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{26}
}

func (m *HotelLengthOfStayInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelLengthOfStayInfo.Unmarshal(m, b)
}
func (m *HotelLengthOfStayInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelLengthOfStayInfo.Marshal(b, m, deterministic)
}
func (m *HotelLengthOfStayInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelLengthOfStayInfo.Merge(m, src)
}
func (m *HotelLengthOfStayInfo) XXX_Size() int {
	return xxx_messageInfo_HotelLengthOfStayInfo.Size(m)
}
func (m *HotelLengthOfStayInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelLengthOfStayInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelLengthOfStayInfo proto.InternalMessageInfo

func (m *HotelLengthOfStayInfo) GetMinNights() *wrappers.Int64Value {
	if m != nil {
		return m.MinNights
	}
	return nil
}

func (m *HotelLengthOfStayInfo) GetMaxNights() *wrappers.Int64Value {
	if m != nil {
		return m.MaxNights
	}
	return nil
}

// Criterion for day of the week the booking is for.
type HotelCheckInDayInfo struct {
	// The day of the week.
	DayOfWeek            enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,1,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.ads.googleads.v1.enums.DayOfWeekEnum_DayOfWeek" json:"day_of_week,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *HotelCheckInDayInfo) Reset()         { *m = HotelCheckInDayInfo{} }
func (m *HotelCheckInDayInfo) String() string { return proto.CompactTextString(m) }
func (*HotelCheckInDayInfo) ProtoMessage()    {}
func (*HotelCheckInDayInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{27}
}

func (m *HotelCheckInDayInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelCheckInDayInfo.Unmarshal(m, b)
}
func (m *HotelCheckInDayInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelCheckInDayInfo.Marshal(b, m, deterministic)
}
func (m *HotelCheckInDayInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelCheckInDayInfo.Merge(m, src)
}
func (m *HotelCheckInDayInfo) XXX_Size() int {
	return xxx_messageInfo_HotelCheckInDayInfo.Size(m)
}
func (m *HotelCheckInDayInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelCheckInDayInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelCheckInDayInfo proto.InternalMessageInfo

func (m *HotelCheckInDayInfo) GetDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if m != nil {
		return m.DayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

// Criterion for Interaction Type.
type InteractionTypeInfo struct {
	// The interaction type.
	Type                 enums.InteractionTypeEnum_InteractionType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.InteractionTypeEnum_InteractionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *InteractionTypeInfo) Reset()         { *m = InteractionTypeInfo{} }
func (m *InteractionTypeInfo) String() string { return proto.CompactTextString(m) }
func (*InteractionTypeInfo) ProtoMessage()    {}
func (*InteractionTypeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{28}
}

func (m *InteractionTypeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InteractionTypeInfo.Unmarshal(m, b)
}
func (m *InteractionTypeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InteractionTypeInfo.Marshal(b, m, deterministic)
}
func (m *InteractionTypeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InteractionTypeInfo.Merge(m, src)
}
func (m *InteractionTypeInfo) XXX_Size() int {
	return xxx_messageInfo_InteractionTypeInfo.Size(m)
}
func (m *InteractionTypeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_InteractionTypeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_InteractionTypeInfo proto.InternalMessageInfo

func (m *InteractionTypeInfo) GetType() enums.InteractionTypeEnum_InteractionType {
	if m != nil {
		return m.Type
	}
	return enums.InteractionTypeEnum_UNSPECIFIED
}

// Represents an AdSchedule criterion.
//
// AdSchedule is specified as the day of the week and a time interval
// within which ads will be shown.
//
// No more than six AdSchedules can be added for the same day.
type AdScheduleInfo struct {
	// Minutes after the start hour at which this schedule starts.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	StartMinute enums.MinuteOfHourEnum_MinuteOfHour `protobuf:"varint,1,opt,name=start_minute,json=startMinute,proto3,enum=google.ads.googleads.v1.enums.MinuteOfHourEnum_MinuteOfHour" json:"start_minute,omitempty"`
	// Minutes after the end hour at which this schedule ends. The schedule is
	// exclusive of the end minute.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	EndMinute enums.MinuteOfHourEnum_MinuteOfHour `protobuf:"varint,2,opt,name=end_minute,json=endMinute,proto3,enum=google.ads.googleads.v1.enums.MinuteOfHourEnum_MinuteOfHour" json:"end_minute,omitempty"`
	// Starting hour in 24 hour time.
	// This field must be between 0 and 23, inclusive.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	StartHour *wrappers.Int32Value `protobuf:"bytes,3,opt,name=start_hour,json=startHour,proto3" json:"start_hour,omitempty"`
	// Ending hour in 24 hour time; 24 signifies end of the day.
	// This field must be between 0 and 24, inclusive.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	EndHour *wrappers.Int32Value `protobuf:"bytes,4,opt,name=end_hour,json=endHour,proto3" json:"end_hour,omitempty"`
	// Day of the week the schedule applies to.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	DayOfWeek            enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,5,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.ads.googleads.v1.enums.DayOfWeekEnum_DayOfWeek" json:"day_of_week,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AdScheduleInfo) Reset()         { *m = AdScheduleInfo{} }
func (m *AdScheduleInfo) String() string { return proto.CompactTextString(m) }
func (*AdScheduleInfo) ProtoMessage()    {}
func (*AdScheduleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{29}
}

func (m *AdScheduleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdScheduleInfo.Unmarshal(m, b)
}
func (m *AdScheduleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdScheduleInfo.Marshal(b, m, deterministic)
}
func (m *AdScheduleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdScheduleInfo.Merge(m, src)
}
func (m *AdScheduleInfo) XXX_Size() int {
	return xxx_messageInfo_AdScheduleInfo.Size(m)
}
func (m *AdScheduleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdScheduleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdScheduleInfo proto.InternalMessageInfo

func (m *AdScheduleInfo) GetStartMinute() enums.MinuteOfHourEnum_MinuteOfHour {
	if m != nil {
		return m.StartMinute
	}
	return enums.MinuteOfHourEnum_UNSPECIFIED
}

func (m *AdScheduleInfo) GetEndMinute() enums.MinuteOfHourEnum_MinuteOfHour {
	if m != nil {
		return m.EndMinute
	}
	return enums.MinuteOfHourEnum_UNSPECIFIED
}

func (m *AdScheduleInfo) GetStartHour() *wrappers.Int32Value {
	if m != nil {
		return m.StartHour
	}
	return nil
}

func (m *AdScheduleInfo) GetEndHour() *wrappers.Int32Value {
	if m != nil {
		return m.EndHour
	}
	return nil
}

func (m *AdScheduleInfo) GetDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if m != nil {
		return m.DayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

// An age range criterion.
type AgeRangeInfo struct {
	// Type of the age range.
	Type                 enums.AgeRangeTypeEnum_AgeRangeType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.AgeRangeTypeEnum_AgeRangeType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *AgeRangeInfo) Reset()         { *m = AgeRangeInfo{} }
func (m *AgeRangeInfo) String() string { return proto.CompactTextString(m) }
func (*AgeRangeInfo) ProtoMessage()    {}
func (*AgeRangeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{30}
}

func (m *AgeRangeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AgeRangeInfo.Unmarshal(m, b)
}
func (m *AgeRangeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AgeRangeInfo.Marshal(b, m, deterministic)
}
func (m *AgeRangeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgeRangeInfo.Merge(m, src)
}
func (m *AgeRangeInfo) XXX_Size() int {
	return xxx_messageInfo_AgeRangeInfo.Size(m)
}
func (m *AgeRangeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AgeRangeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AgeRangeInfo proto.InternalMessageInfo

func (m *AgeRangeInfo) GetType() enums.AgeRangeTypeEnum_AgeRangeType {
	if m != nil {
		return m.Type
	}
	return enums.AgeRangeTypeEnum_UNSPECIFIED
}

// A gender criterion.
type GenderInfo struct {
	// Type of the gender.
	Type                 enums.GenderTypeEnum_GenderType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.GenderTypeEnum_GenderType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *GenderInfo) Reset()         { *m = GenderInfo{} }
func (m *GenderInfo) String() string { return proto.CompactTextString(m) }
func (*GenderInfo) ProtoMessage()    {}
func (*GenderInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{31}
}

func (m *GenderInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenderInfo.Unmarshal(m, b)
}
func (m *GenderInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenderInfo.Marshal(b, m, deterministic)
}
func (m *GenderInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenderInfo.Merge(m, src)
}
func (m *GenderInfo) XXX_Size() int {
	return xxx_messageInfo_GenderInfo.Size(m)
}
func (m *GenderInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GenderInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GenderInfo proto.InternalMessageInfo

func (m *GenderInfo) GetType() enums.GenderTypeEnum_GenderType {
	if m != nil {
		return m.Type
	}
	return enums.GenderTypeEnum_UNSPECIFIED
}

// An income range criterion.
type IncomeRangeInfo struct {
	// Type of the income range.
	Type                 enums.IncomeRangeTypeEnum_IncomeRangeType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.IncomeRangeTypeEnum_IncomeRangeType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *IncomeRangeInfo) Reset()         { *m = IncomeRangeInfo{} }
func (m *IncomeRangeInfo) String() string { return proto.CompactTextString(m) }
func (*IncomeRangeInfo) ProtoMessage()    {}
func (*IncomeRangeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{32}
}

func (m *IncomeRangeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncomeRangeInfo.Unmarshal(m, b)
}
func (m *IncomeRangeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncomeRangeInfo.Marshal(b, m, deterministic)
}
func (m *IncomeRangeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncomeRangeInfo.Merge(m, src)
}
func (m *IncomeRangeInfo) XXX_Size() int {
	return xxx_messageInfo_IncomeRangeInfo.Size(m)
}
func (m *IncomeRangeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_IncomeRangeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_IncomeRangeInfo proto.InternalMessageInfo

func (m *IncomeRangeInfo) GetType() enums.IncomeRangeTypeEnum_IncomeRangeType {
	if m != nil {
		return m.Type
	}
	return enums.IncomeRangeTypeEnum_UNSPECIFIED
}

// A parental status criterion.
type ParentalStatusInfo struct {
	// Type of the parental status.
	Type                 enums.ParentalStatusTypeEnum_ParentalStatusType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.ParentalStatusTypeEnum_ParentalStatusType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *ParentalStatusInfo) Reset()         { *m = ParentalStatusInfo{} }
func (m *ParentalStatusInfo) String() string { return proto.CompactTextString(m) }
func (*ParentalStatusInfo) ProtoMessage()    {}
func (*ParentalStatusInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{33}
}

func (m *ParentalStatusInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParentalStatusInfo.Unmarshal(m, b)
}
func (m *ParentalStatusInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParentalStatusInfo.Marshal(b, m, deterministic)
}
func (m *ParentalStatusInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParentalStatusInfo.Merge(m, src)
}
func (m *ParentalStatusInfo) XXX_Size() int {
	return xxx_messageInfo_ParentalStatusInfo.Size(m)
}
func (m *ParentalStatusInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ParentalStatusInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ParentalStatusInfo proto.InternalMessageInfo

func (m *ParentalStatusInfo) GetType() enums.ParentalStatusTypeEnum_ParentalStatusType {
	if m != nil {
		return m.Type
	}
	return enums.ParentalStatusTypeEnum_UNSPECIFIED
}

// A YouTube Video criterion.
type YouTubeVideoInfo struct {
	// YouTube video id as it appears on the YouTube watch page.
	VideoId              *wrappers.StringValue `protobuf:"bytes,1,opt,name=video_id,json=videoId,proto3" json:"video_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *YouTubeVideoInfo) Reset()         { *m = YouTubeVideoInfo{} }
func (m *YouTubeVideoInfo) String() string { return proto.CompactTextString(m) }
func (*YouTubeVideoInfo) ProtoMessage()    {}
func (*YouTubeVideoInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{34}
}

func (m *YouTubeVideoInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YouTubeVideoInfo.Unmarshal(m, b)
}
func (m *YouTubeVideoInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YouTubeVideoInfo.Marshal(b, m, deterministic)
}
func (m *YouTubeVideoInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YouTubeVideoInfo.Merge(m, src)
}
func (m *YouTubeVideoInfo) XXX_Size() int {
	return xxx_messageInfo_YouTubeVideoInfo.Size(m)
}
func (m *YouTubeVideoInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_YouTubeVideoInfo.DiscardUnknown(m)
}

var xxx_messageInfo_YouTubeVideoInfo proto.InternalMessageInfo

func (m *YouTubeVideoInfo) GetVideoId() *wrappers.StringValue {
	if m != nil {
		return m.VideoId
	}
	return nil
}

// A YouTube Channel criterion.
type YouTubeChannelInfo struct {
	// The YouTube uploader channel id or the channel code of a YouTube channel.
	ChannelId            *wrappers.StringValue `protobuf:"bytes,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *YouTubeChannelInfo) Reset()         { *m = YouTubeChannelInfo{} }
func (m *YouTubeChannelInfo) String() string { return proto.CompactTextString(m) }
func (*YouTubeChannelInfo) ProtoMessage()    {}
func (*YouTubeChannelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{35}
}

func (m *YouTubeChannelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YouTubeChannelInfo.Unmarshal(m, b)
}
func (m *YouTubeChannelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YouTubeChannelInfo.Marshal(b, m, deterministic)
}
func (m *YouTubeChannelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YouTubeChannelInfo.Merge(m, src)
}
func (m *YouTubeChannelInfo) XXX_Size() int {
	return xxx_messageInfo_YouTubeChannelInfo.Size(m)
}
func (m *YouTubeChannelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_YouTubeChannelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_YouTubeChannelInfo proto.InternalMessageInfo

func (m *YouTubeChannelInfo) GetChannelId() *wrappers.StringValue {
	if m != nil {
		return m.ChannelId
	}
	return nil
}

// A User List criterion. Represents a user list that is defined by the
// advertiser to be targeted.
type UserListInfo struct {
	// The User List resource name.
	UserList             *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserListInfo) Reset()         { *m = UserListInfo{} }
func (m *UserListInfo) String() string { return proto.CompactTextString(m) }
func (*UserListInfo) ProtoMessage()    {}
func (*UserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{36}
}

func (m *UserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListInfo.Unmarshal(m, b)
}
func (m *UserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListInfo.Marshal(b, m, deterministic)
}
func (m *UserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListInfo.Merge(m, src)
}
func (m *UserListInfo) XXX_Size() int {
	return xxx_messageInfo_UserListInfo.Size(m)
}
func (m *UserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListInfo proto.InternalMessageInfo

func (m *UserListInfo) GetUserList() *wrappers.StringValue {
	if m != nil {
		return m.UserList
	}
	return nil
}

// A Proximity criterion. The geo point and radius determine what geographical
// area is included. The address is a description of the geo point that does
// not affect ad serving.
//
// There are two ways to create a proximity. First, by setting an address
// and radius. The geo point will be automatically computed. Second, by
// setting a geo point and radius. The address is an optional label that won't
// be validated.
type ProximityInfo struct {
	// Latitude and longitude.
	GeoPoint *GeoPointInfo `protobuf:"bytes,1,opt,name=geo_point,json=geoPoint,proto3" json:"geo_point,omitempty"`
	// The radius of the proximity.
	Radius *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=radius,proto3" json:"radius,omitempty"`
	// The unit of measurement of the radius. Default is KILOMETERS.
	RadiusUnits enums.ProximityRadiusUnitsEnum_ProximityRadiusUnits `protobuf:"varint,3,opt,name=radius_units,json=radiusUnits,proto3,enum=google.ads.googleads.v1.enums.ProximityRadiusUnitsEnum_ProximityRadiusUnits" json:"radius_units,omitempty"`
	// Full address.
	Address              *AddressInfo `protobuf:"bytes,4,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ProximityInfo) Reset()         { *m = ProximityInfo{} }
func (m *ProximityInfo) String() string { return proto.CompactTextString(m) }
func (*ProximityInfo) ProtoMessage()    {}
func (*ProximityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{37}
}

func (m *ProximityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProximityInfo.Unmarshal(m, b)
}
func (m *ProximityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProximityInfo.Marshal(b, m, deterministic)
}
func (m *ProximityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProximityInfo.Merge(m, src)
}
func (m *ProximityInfo) XXX_Size() int {
	return xxx_messageInfo_ProximityInfo.Size(m)
}
func (m *ProximityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProximityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProximityInfo proto.InternalMessageInfo

func (m *ProximityInfo) GetGeoPoint() *GeoPointInfo {
	if m != nil {
		return m.GeoPoint
	}
	return nil
}

func (m *ProximityInfo) GetRadius() *wrappers.DoubleValue {
	if m != nil {
		return m.Radius
	}
	return nil
}

func (m *ProximityInfo) GetRadiusUnits() enums.ProximityRadiusUnitsEnum_ProximityRadiusUnits {
	if m != nil {
		return m.RadiusUnits
	}
	return enums.ProximityRadiusUnitsEnum_UNSPECIFIED
}

func (m *ProximityInfo) GetAddress() *AddressInfo {
	if m != nil {
		return m.Address
	}
	return nil
}

// Geo point for proximity criterion.
type GeoPointInfo struct {
	// Micro degrees for the longitude.
	LongitudeInMicroDegrees *wrappers.Int32Value `protobuf:"bytes,1,opt,name=longitude_in_micro_degrees,json=longitudeInMicroDegrees,proto3" json:"longitude_in_micro_degrees,omitempty"`
	// Micro degrees for the latitude.
	LatitudeInMicroDegrees *wrappers.Int32Value `protobuf:"bytes,2,opt,name=latitude_in_micro_degrees,json=latitudeInMicroDegrees,proto3" json:"latitude_in_micro_degrees,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *GeoPointInfo) Reset()         { *m = GeoPointInfo{} }
func (m *GeoPointInfo) String() string { return proto.CompactTextString(m) }
func (*GeoPointInfo) ProtoMessage()    {}
func (*GeoPointInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{38}
}

func (m *GeoPointInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GeoPointInfo.Unmarshal(m, b)
}
func (m *GeoPointInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GeoPointInfo.Marshal(b, m, deterministic)
}
func (m *GeoPointInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GeoPointInfo.Merge(m, src)
}
func (m *GeoPointInfo) XXX_Size() int {
	return xxx_messageInfo_GeoPointInfo.Size(m)
}
func (m *GeoPointInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GeoPointInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GeoPointInfo proto.InternalMessageInfo

func (m *GeoPointInfo) GetLongitudeInMicroDegrees() *wrappers.Int32Value {
	if m != nil {
		return m.LongitudeInMicroDegrees
	}
	return nil
}

func (m *GeoPointInfo) GetLatitudeInMicroDegrees() *wrappers.Int32Value {
	if m != nil {
		return m.LatitudeInMicroDegrees
	}
	return nil
}

// Address for proximity criterion.
type AddressInfo struct {
	// Postal code.
	PostalCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	// Province or state code.
	ProvinceCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=province_code,json=provinceCode,proto3" json:"province_code,omitempty"`
	// Country code.
	CountryCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Province or state name.
	ProvinceName *wrappers.StringValue `protobuf:"bytes,4,opt,name=province_name,json=provinceName,proto3" json:"province_name,omitempty"`
	// Street address line 1.
	StreetAddress *wrappers.StringValue `protobuf:"bytes,5,opt,name=street_address,json=streetAddress,proto3" json:"street_address,omitempty"`
	// Street address line 2. This field is write-only. It is only used for
	// calculating the longitude and latitude of an address when geo_point is
	// empty.
	StreetAddress2 *wrappers.StringValue `protobuf:"bytes,6,opt,name=street_address2,json=streetAddress2,proto3" json:"street_address2,omitempty"`
	// Name of the city.
	CityName             *wrappers.StringValue `protobuf:"bytes,7,opt,name=city_name,json=cityName,proto3" json:"city_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *AddressInfo) Reset()         { *m = AddressInfo{} }
func (m *AddressInfo) String() string { return proto.CompactTextString(m) }
func (*AddressInfo) ProtoMessage()    {}
func (*AddressInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{39}
}

func (m *AddressInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddressInfo.Unmarshal(m, b)
}
func (m *AddressInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddressInfo.Marshal(b, m, deterministic)
}
func (m *AddressInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddressInfo.Merge(m, src)
}
func (m *AddressInfo) XXX_Size() int {
	return xxx_messageInfo_AddressInfo.Size(m)
}
func (m *AddressInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AddressInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AddressInfo proto.InternalMessageInfo

func (m *AddressInfo) GetPostalCode() *wrappers.StringValue {
	if m != nil {
		return m.PostalCode
	}
	return nil
}

func (m *AddressInfo) GetProvinceCode() *wrappers.StringValue {
	if m != nil {
		return m.ProvinceCode
	}
	return nil
}

func (m *AddressInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *AddressInfo) GetProvinceName() *wrappers.StringValue {
	if m != nil {
		return m.ProvinceName
	}
	return nil
}

func (m *AddressInfo) GetStreetAddress() *wrappers.StringValue {
	if m != nil {
		return m.StreetAddress
	}
	return nil
}

func (m *AddressInfo) GetStreetAddress2() *wrappers.StringValue {
	if m != nil {
		return m.StreetAddress2
	}
	return nil
}

func (m *AddressInfo) GetCityName() *wrappers.StringValue {
	if m != nil {
		return m.CityName
	}
	return nil
}

// A topic criterion. Use topics to target or exclude placements in the
// Google Display Network based on the category into which the placement falls
// (for example, "Pets & Animals/Pets/Dogs").
type TopicInfo struct {
	// The Topic Constant resource name.
	TopicConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=topic_constant,json=topicConstant,proto3" json:"topic_constant,omitempty"`
	// The category to target or exclude. Each subsequent element in the array
	// describes a more specific sub-category. For example,
	// "Pets & Animals", "Pets", "Dogs" represents the "Pets & Animals/Pets/Dogs"
	// category.
	Path                 []*wrappers.StringValue `protobuf:"bytes,2,rep,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *TopicInfo) Reset()         { *m = TopicInfo{} }
func (m *TopicInfo) String() string { return proto.CompactTextString(m) }
func (*TopicInfo) ProtoMessage()    {}
func (*TopicInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{40}
}

func (m *TopicInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TopicInfo.Unmarshal(m, b)
}
func (m *TopicInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TopicInfo.Marshal(b, m, deterministic)
}
func (m *TopicInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TopicInfo.Merge(m, src)
}
func (m *TopicInfo) XXX_Size() int {
	return xxx_messageInfo_TopicInfo.Size(m)
}
func (m *TopicInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TopicInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TopicInfo proto.InternalMessageInfo

func (m *TopicInfo) GetTopicConstant() *wrappers.StringValue {
	if m != nil {
		return m.TopicConstant
	}
	return nil
}

func (m *TopicInfo) GetPath() []*wrappers.StringValue {
	if m != nil {
		return m.Path
	}
	return nil
}

// A language criterion.
type LanguageInfo struct {
	// The language constant resource name.
	LanguageConstant     *wrappers.StringValue `protobuf:"bytes,1,opt,name=language_constant,json=languageConstant,proto3" json:"language_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LanguageInfo) Reset()         { *m = LanguageInfo{} }
func (m *LanguageInfo) String() string { return proto.CompactTextString(m) }
func (*LanguageInfo) ProtoMessage()    {}
func (*LanguageInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{41}
}

func (m *LanguageInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LanguageInfo.Unmarshal(m, b)
}
func (m *LanguageInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LanguageInfo.Marshal(b, m, deterministic)
}
func (m *LanguageInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LanguageInfo.Merge(m, src)
}
func (m *LanguageInfo) XXX_Size() int {
	return xxx_messageInfo_LanguageInfo.Size(m)
}
func (m *LanguageInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LanguageInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LanguageInfo proto.InternalMessageInfo

func (m *LanguageInfo) GetLanguageConstant() *wrappers.StringValue {
	if m != nil {
		return m.LanguageConstant
	}
	return nil
}

// An IpBlock criterion used for IP exclusions. We allow:
//  - IPv4 and IPv6 addresses
//  - individual addresses (192.168.0.1)
//  - masks for individual addresses (192.168.0.1/32)
//  - masks for Class C networks (192.168.0.1/24)
type IpBlockInfo struct {
	// The IP address of this IP block.
	IpAddress            *wrappers.StringValue `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *IpBlockInfo) Reset()         { *m = IpBlockInfo{} }
func (m *IpBlockInfo) String() string { return proto.CompactTextString(m) }
func (*IpBlockInfo) ProtoMessage()    {}
func (*IpBlockInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{42}
}

func (m *IpBlockInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IpBlockInfo.Unmarshal(m, b)
}
func (m *IpBlockInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IpBlockInfo.Marshal(b, m, deterministic)
}
func (m *IpBlockInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IpBlockInfo.Merge(m, src)
}
func (m *IpBlockInfo) XXX_Size() int {
	return xxx_messageInfo_IpBlockInfo.Size(m)
}
func (m *IpBlockInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_IpBlockInfo.DiscardUnknown(m)
}

var xxx_messageInfo_IpBlockInfo proto.InternalMessageInfo

func (m *IpBlockInfo) GetIpAddress() *wrappers.StringValue {
	if m != nil {
		return m.IpAddress
	}
	return nil
}

// Content Label for category exclusion.
type ContentLabelInfo struct {
	// Content label type, required for CREATE operations.
	Type                 enums.ContentLabelTypeEnum_ContentLabelType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.ContentLabelTypeEnum_ContentLabelType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ContentLabelInfo) Reset()         { *m = ContentLabelInfo{} }
func (m *ContentLabelInfo) String() string { return proto.CompactTextString(m) }
func (*ContentLabelInfo) ProtoMessage()    {}
func (*ContentLabelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{43}
}

func (m *ContentLabelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContentLabelInfo.Unmarshal(m, b)
}
func (m *ContentLabelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContentLabelInfo.Marshal(b, m, deterministic)
}
func (m *ContentLabelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContentLabelInfo.Merge(m, src)
}
func (m *ContentLabelInfo) XXX_Size() int {
	return xxx_messageInfo_ContentLabelInfo.Size(m)
}
func (m *ContentLabelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ContentLabelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ContentLabelInfo proto.InternalMessageInfo

func (m *ContentLabelInfo) GetType() enums.ContentLabelTypeEnum_ContentLabelType {
	if m != nil {
		return m.Type
	}
	return enums.ContentLabelTypeEnum_UNSPECIFIED
}

// Represents a Carrier Criterion.
type CarrierInfo struct {
	// The Carrier constant resource name.
	CarrierConstant      *wrappers.StringValue `protobuf:"bytes,1,opt,name=carrier_constant,json=carrierConstant,proto3" json:"carrier_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CarrierInfo) Reset()         { *m = CarrierInfo{} }
func (m *CarrierInfo) String() string { return proto.CompactTextString(m) }
func (*CarrierInfo) ProtoMessage()    {}
func (*CarrierInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{44}
}

func (m *CarrierInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CarrierInfo.Unmarshal(m, b)
}
func (m *CarrierInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CarrierInfo.Marshal(b, m, deterministic)
}
func (m *CarrierInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CarrierInfo.Merge(m, src)
}
func (m *CarrierInfo) XXX_Size() int {
	return xxx_messageInfo_CarrierInfo.Size(m)
}
func (m *CarrierInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CarrierInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CarrierInfo proto.InternalMessageInfo

func (m *CarrierInfo) GetCarrierConstant() *wrappers.StringValue {
	if m != nil {
		return m.CarrierConstant
	}
	return nil
}

// Represents a particular interest-based topic to be targeted.
type UserInterestInfo struct {
	// The UserInterest resource name.
	UserInterestCategory *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_interest_category,json=userInterestCategory,proto3" json:"user_interest_category,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserInterestInfo) Reset()         { *m = UserInterestInfo{} }
func (m *UserInterestInfo) String() string { return proto.CompactTextString(m) }
func (*UserInterestInfo) ProtoMessage()    {}
func (*UserInterestInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{45}
}

func (m *UserInterestInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserInterestInfo.Unmarshal(m, b)
}
func (m *UserInterestInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserInterestInfo.Marshal(b, m, deterministic)
}
func (m *UserInterestInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserInterestInfo.Merge(m, src)
}
func (m *UserInterestInfo) XXX_Size() int {
	return xxx_messageInfo_UserInterestInfo.Size(m)
}
func (m *UserInterestInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserInterestInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserInterestInfo proto.InternalMessageInfo

func (m *UserInterestInfo) GetUserInterestCategory() *wrappers.StringValue {
	if m != nil {
		return m.UserInterestCategory
	}
	return nil
}

// Represents a criterion for targeting webpages of an advertiser's website.
type WebpageInfo struct {
	// The name of the criterion that is defined by this parameter. The name value
	// will be used for identifying, sorting and filtering criteria with this type
	// of parameters.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	CriterionName *wrappers.StringValue `protobuf:"bytes,1,opt,name=criterion_name,json=criterionName,proto3" json:"criterion_name,omitempty"`
	// Conditions, or logical expressions, for webpage targeting. The list of
	// webpage targeting conditions are and-ed together when evaluated
	// for targeting.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	Conditions           []*WebpageConditionInfo `protobuf:"bytes,2,rep,name=conditions,proto3" json:"conditions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *WebpageInfo) Reset()         { *m = WebpageInfo{} }
func (m *WebpageInfo) String() string { return proto.CompactTextString(m) }
func (*WebpageInfo) ProtoMessage()    {}
func (*WebpageInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{46}
}

func (m *WebpageInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebpageInfo.Unmarshal(m, b)
}
func (m *WebpageInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebpageInfo.Marshal(b, m, deterministic)
}
func (m *WebpageInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebpageInfo.Merge(m, src)
}
func (m *WebpageInfo) XXX_Size() int {
	return xxx_messageInfo_WebpageInfo.Size(m)
}
func (m *WebpageInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WebpageInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WebpageInfo proto.InternalMessageInfo

func (m *WebpageInfo) GetCriterionName() *wrappers.StringValue {
	if m != nil {
		return m.CriterionName
	}
	return nil
}

func (m *WebpageInfo) GetConditions() []*WebpageConditionInfo {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// Logical expression for targeting webpages of an advertiser's website.
type WebpageConditionInfo struct {
	// Operand of webpage targeting condition.
	Operand enums.WebpageConditionOperandEnum_WebpageConditionOperand `protobuf:"varint,1,opt,name=operand,proto3,enum=google.ads.googleads.v1.enums.WebpageConditionOperandEnum_WebpageConditionOperand" json:"operand,omitempty"`
	// Operator of webpage targeting condition.
	Operator enums.WebpageConditionOperatorEnum_WebpageConditionOperator `protobuf:"varint,2,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.WebpageConditionOperatorEnum_WebpageConditionOperator" json:"operator,omitempty"`
	// Argument of webpage targeting condition.
	Argument             *wrappers.StringValue `protobuf:"bytes,3,opt,name=argument,proto3" json:"argument,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *WebpageConditionInfo) Reset()         { *m = WebpageConditionInfo{} }
func (m *WebpageConditionInfo) String() string { return proto.CompactTextString(m) }
func (*WebpageConditionInfo) ProtoMessage()    {}
func (*WebpageConditionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{47}
}

func (m *WebpageConditionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebpageConditionInfo.Unmarshal(m, b)
}
func (m *WebpageConditionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebpageConditionInfo.Marshal(b, m, deterministic)
}
func (m *WebpageConditionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebpageConditionInfo.Merge(m, src)
}
func (m *WebpageConditionInfo) XXX_Size() int {
	return xxx_messageInfo_WebpageConditionInfo.Size(m)
}
func (m *WebpageConditionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WebpageConditionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WebpageConditionInfo proto.InternalMessageInfo

func (m *WebpageConditionInfo) GetOperand() enums.WebpageConditionOperandEnum_WebpageConditionOperand {
	if m != nil {
		return m.Operand
	}
	return enums.WebpageConditionOperandEnum_UNSPECIFIED
}

func (m *WebpageConditionInfo) GetOperator() enums.WebpageConditionOperatorEnum_WebpageConditionOperator {
	if m != nil {
		return m.Operator
	}
	return enums.WebpageConditionOperatorEnum_UNSPECIFIED
}

func (m *WebpageConditionInfo) GetArgument() *wrappers.StringValue {
	if m != nil {
		return m.Argument
	}
	return nil
}

// Represents an operating system version to be targeted.
type OperatingSystemVersionInfo struct {
	// The operating system version constant resource name.
	OperatingSystemVersionConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=operating_system_version_constant,json=operatingSystemVersionConstant,proto3" json:"operating_system_version_constant,omitempty"`
	XXX_NoUnkeyedLiteral           struct{}              `json:"-"`
	XXX_unrecognized               []byte                `json:"-"`
	XXX_sizecache                  int32                 `json:"-"`
}

func (m *OperatingSystemVersionInfo) Reset()         { *m = OperatingSystemVersionInfo{} }
func (m *OperatingSystemVersionInfo) String() string { return proto.CompactTextString(m) }
func (*OperatingSystemVersionInfo) ProtoMessage()    {}
func (*OperatingSystemVersionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{48}
}

func (m *OperatingSystemVersionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperatingSystemVersionInfo.Unmarshal(m, b)
}
func (m *OperatingSystemVersionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperatingSystemVersionInfo.Marshal(b, m, deterministic)
}
func (m *OperatingSystemVersionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperatingSystemVersionInfo.Merge(m, src)
}
func (m *OperatingSystemVersionInfo) XXX_Size() int {
	return xxx_messageInfo_OperatingSystemVersionInfo.Size(m)
}
func (m *OperatingSystemVersionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_OperatingSystemVersionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_OperatingSystemVersionInfo proto.InternalMessageInfo

func (m *OperatingSystemVersionInfo) GetOperatingSystemVersionConstant() *wrappers.StringValue {
	if m != nil {
		return m.OperatingSystemVersionConstant
	}
	return nil
}

// An app payment model criterion.
type AppPaymentModelInfo struct {
	// Type of the app payment model.
	Type                 enums.AppPaymentModelTypeEnum_AppPaymentModelType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.AppPaymentModelTypeEnum_AppPaymentModelType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *AppPaymentModelInfo) Reset()         { *m = AppPaymentModelInfo{} }
func (m *AppPaymentModelInfo) String() string { return proto.CompactTextString(m) }
func (*AppPaymentModelInfo) ProtoMessage()    {}
func (*AppPaymentModelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{49}
}

func (m *AppPaymentModelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppPaymentModelInfo.Unmarshal(m, b)
}
func (m *AppPaymentModelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppPaymentModelInfo.Marshal(b, m, deterministic)
}
func (m *AppPaymentModelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppPaymentModelInfo.Merge(m, src)
}
func (m *AppPaymentModelInfo) XXX_Size() int {
	return xxx_messageInfo_AppPaymentModelInfo.Size(m)
}
func (m *AppPaymentModelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AppPaymentModelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AppPaymentModelInfo proto.InternalMessageInfo

func (m *AppPaymentModelInfo) GetType() enums.AppPaymentModelTypeEnum_AppPaymentModelType {
	if m != nil {
		return m.Type
	}
	return enums.AppPaymentModelTypeEnum_UNSPECIFIED
}

// A mobile device criterion.
type MobileDeviceInfo struct {
	// The mobile device constant resource name.
	MobileDeviceConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=mobile_device_constant,json=mobileDeviceConstant,proto3" json:"mobile_device_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MobileDeviceInfo) Reset()         { *m = MobileDeviceInfo{} }
func (m *MobileDeviceInfo) String() string { return proto.CompactTextString(m) }
func (*MobileDeviceInfo) ProtoMessage()    {}
func (*MobileDeviceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{50}
}

func (m *MobileDeviceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MobileDeviceInfo.Unmarshal(m, b)
}
func (m *MobileDeviceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MobileDeviceInfo.Marshal(b, m, deterministic)
}
func (m *MobileDeviceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MobileDeviceInfo.Merge(m, src)
}
func (m *MobileDeviceInfo) XXX_Size() int {
	return xxx_messageInfo_MobileDeviceInfo.Size(m)
}
func (m *MobileDeviceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MobileDeviceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MobileDeviceInfo proto.InternalMessageInfo

func (m *MobileDeviceInfo) GetMobileDeviceConstant() *wrappers.StringValue {
	if m != nil {
		return m.MobileDeviceConstant
	}
	return nil
}

// A custom affinity criterion.
// A criterion of this type is only targetable.
type CustomAffinityInfo struct {
	// The CustomInterest resource name.
	CustomAffinity       *wrappers.StringValue `protobuf:"bytes,1,opt,name=custom_affinity,json=customAffinity,proto3" json:"custom_affinity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CustomAffinityInfo) Reset()         { *m = CustomAffinityInfo{} }
func (m *CustomAffinityInfo) String() string { return proto.CompactTextString(m) }
func (*CustomAffinityInfo) ProtoMessage()    {}
func (*CustomAffinityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{51}
}

func (m *CustomAffinityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomAffinityInfo.Unmarshal(m, b)
}
func (m *CustomAffinityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomAffinityInfo.Marshal(b, m, deterministic)
}
func (m *CustomAffinityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomAffinityInfo.Merge(m, src)
}
func (m *CustomAffinityInfo) XXX_Size() int {
	return xxx_messageInfo_CustomAffinityInfo.Size(m)
}
func (m *CustomAffinityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomAffinityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CustomAffinityInfo proto.InternalMessageInfo

func (m *CustomAffinityInfo) GetCustomAffinity() *wrappers.StringValue {
	if m != nil {
		return m.CustomAffinity
	}
	return nil
}

// A custom intent criterion.
// A criterion of this type is only targetable.
type CustomIntentInfo struct {
	// The CustomInterest resource name.
	CustomIntent         *wrappers.StringValue `protobuf:"bytes,1,opt,name=custom_intent,json=customIntent,proto3" json:"custom_intent,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CustomIntentInfo) Reset()         { *m = CustomIntentInfo{} }
func (m *CustomIntentInfo) String() string { return proto.CompactTextString(m) }
func (*CustomIntentInfo) ProtoMessage()    {}
func (*CustomIntentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{52}
}

func (m *CustomIntentInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomIntentInfo.Unmarshal(m, b)
}
func (m *CustomIntentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomIntentInfo.Marshal(b, m, deterministic)
}
func (m *CustomIntentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomIntentInfo.Merge(m, src)
}
func (m *CustomIntentInfo) XXX_Size() int {
	return xxx_messageInfo_CustomIntentInfo.Size(m)
}
func (m *CustomIntentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomIntentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CustomIntentInfo proto.InternalMessageInfo

func (m *CustomIntentInfo) GetCustomIntent() *wrappers.StringValue {
	if m != nil {
		return m.CustomIntent
	}
	return nil
}

// A radius around a list of locations specified via a feed.
type LocationGroupInfo struct {
	// Feed specifying locations for targeting.
	// This is required and must be set in CREATE operations.
	Feed *wrappers.StringValue `protobuf:"bytes,1,opt,name=feed,proto3" json:"feed,omitempty"`
	// Geo target constant(s) restricting the scope of the geographic area within
	// the feed. Currently only one geo target constant is allowed.
	GeoTargetConstants []*wrappers.StringValue `protobuf:"bytes,2,rep,name=geo_target_constants,json=geoTargetConstants,proto3" json:"geo_target_constants,omitempty"`
	// Distance in units specifying the radius around targeted locations.
	// This is required and must be set in CREATE operations.
	Radius *wrappers.Int64Value `protobuf:"bytes,3,opt,name=radius,proto3" json:"radius,omitempty"`
	// Unit of the radius, miles and meters supported currently.
	// This is required and must be set in CREATE operations.
	RadiusUnits          enums.LocationGroupRadiusUnitsEnum_LocationGroupRadiusUnits `protobuf:"varint,4,opt,name=radius_units,json=radiusUnits,proto3,enum=google.ads.googleads.v1.enums.LocationGroupRadiusUnitsEnum_LocationGroupRadiusUnits" json:"radius_units,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                    `json:"-"`
	XXX_unrecognized     []byte                                                      `json:"-"`
	XXX_sizecache        int32                                                       `json:"-"`
}

func (m *LocationGroupInfo) Reset()         { *m = LocationGroupInfo{} }
func (m *LocationGroupInfo) String() string { return proto.CompactTextString(m) }
func (*LocationGroupInfo) ProtoMessage()    {}
func (*LocationGroupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_90481ed808a2095c, []int{53}
}

func (m *LocationGroupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationGroupInfo.Unmarshal(m, b)
}
func (m *LocationGroupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationGroupInfo.Marshal(b, m, deterministic)
}
func (m *LocationGroupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationGroupInfo.Merge(m, src)
}
func (m *LocationGroupInfo) XXX_Size() int {
	return xxx_messageInfo_LocationGroupInfo.Size(m)
}
func (m *LocationGroupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationGroupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LocationGroupInfo proto.InternalMessageInfo

func (m *LocationGroupInfo) GetFeed() *wrappers.StringValue {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *LocationGroupInfo) GetGeoTargetConstants() []*wrappers.StringValue {
	if m != nil {
		return m.GeoTargetConstants
	}
	return nil
}

func (m *LocationGroupInfo) GetRadius() *wrappers.Int64Value {
	if m != nil {
		return m.Radius
	}
	return nil
}

func (m *LocationGroupInfo) GetRadiusUnits() enums.LocationGroupRadiusUnitsEnum_LocationGroupRadiusUnits {
	if m != nil {
		return m.RadiusUnits
	}
	return enums.LocationGroupRadiusUnitsEnum_UNSPECIFIED
}

func init() {
	proto.RegisterType((*KeywordInfo)(nil), "google.ads.googleads.v1.common.KeywordInfo")
	proto.RegisterType((*PlacementInfo)(nil), "google.ads.googleads.v1.common.PlacementInfo")
	proto.RegisterType((*MobileAppCategoryInfo)(nil), "google.ads.googleads.v1.common.MobileAppCategoryInfo")
	proto.RegisterType((*MobileApplicationInfo)(nil), "google.ads.googleads.v1.common.MobileApplicationInfo")
	proto.RegisterType((*LocationInfo)(nil), "google.ads.googleads.v1.common.LocationInfo")
	proto.RegisterType((*DeviceInfo)(nil), "google.ads.googleads.v1.common.DeviceInfo")
	proto.RegisterType((*PreferredContentInfo)(nil), "google.ads.googleads.v1.common.PreferredContentInfo")
	proto.RegisterType((*ListingGroupInfo)(nil), "google.ads.googleads.v1.common.ListingGroupInfo")
	proto.RegisterType((*ListingScopeInfo)(nil), "google.ads.googleads.v1.common.ListingScopeInfo")
	proto.RegisterType((*ListingDimensionInfo)(nil), "google.ads.googleads.v1.common.ListingDimensionInfo")
	proto.RegisterType((*ListingBrandInfo)(nil), "google.ads.googleads.v1.common.ListingBrandInfo")
	proto.RegisterType((*HotelIdInfo)(nil), "google.ads.googleads.v1.common.HotelIdInfo")
	proto.RegisterType((*HotelClassInfo)(nil), "google.ads.googleads.v1.common.HotelClassInfo")
	proto.RegisterType((*HotelCountryRegionInfo)(nil), "google.ads.googleads.v1.common.HotelCountryRegionInfo")
	proto.RegisterType((*HotelStateInfo)(nil), "google.ads.googleads.v1.common.HotelStateInfo")
	proto.RegisterType((*HotelCityInfo)(nil), "google.ads.googleads.v1.common.HotelCityInfo")
	proto.RegisterType((*ListingCustomAttributeInfo)(nil), "google.ads.googleads.v1.common.ListingCustomAttributeInfo")
	proto.RegisterType((*ProductBiddingCategoryInfo)(nil), "google.ads.googleads.v1.common.ProductBiddingCategoryInfo")
	proto.RegisterType((*ProductChannelInfo)(nil), "google.ads.googleads.v1.common.ProductChannelInfo")
	proto.RegisterType((*ProductChannelExclusivityInfo)(nil), "google.ads.googleads.v1.common.ProductChannelExclusivityInfo")
	proto.RegisterType((*ProductConditionInfo)(nil), "google.ads.googleads.v1.common.ProductConditionInfo")
	proto.RegisterType((*ProductItemIdInfo)(nil), "google.ads.googleads.v1.common.ProductItemIdInfo")
	proto.RegisterType((*ProductTypeInfo)(nil), "google.ads.googleads.v1.common.ProductTypeInfo")
	proto.RegisterType((*UnknownListingDimensionInfo)(nil), "google.ads.googleads.v1.common.UnknownListingDimensionInfo")
	proto.RegisterType((*HotelDateSelectionTypeInfo)(nil), "google.ads.googleads.v1.common.HotelDateSelectionTypeInfo")
	proto.RegisterType((*HotelAdvanceBookingWindowInfo)(nil), "google.ads.googleads.v1.common.HotelAdvanceBookingWindowInfo")
	proto.RegisterType((*HotelLengthOfStayInfo)(nil), "google.ads.googleads.v1.common.HotelLengthOfStayInfo")
	proto.RegisterType((*HotelCheckInDayInfo)(nil), "google.ads.googleads.v1.common.HotelCheckInDayInfo")
	proto.RegisterType((*InteractionTypeInfo)(nil), "google.ads.googleads.v1.common.InteractionTypeInfo")
	proto.RegisterType((*AdScheduleInfo)(nil), "google.ads.googleads.v1.common.AdScheduleInfo")
	proto.RegisterType((*AgeRangeInfo)(nil), "google.ads.googleads.v1.common.AgeRangeInfo")
	proto.RegisterType((*GenderInfo)(nil), "google.ads.googleads.v1.common.GenderInfo")
	proto.RegisterType((*IncomeRangeInfo)(nil), "google.ads.googleads.v1.common.IncomeRangeInfo")
	proto.RegisterType((*ParentalStatusInfo)(nil), "google.ads.googleads.v1.common.ParentalStatusInfo")
	proto.RegisterType((*YouTubeVideoInfo)(nil), "google.ads.googleads.v1.common.YouTubeVideoInfo")
	proto.RegisterType((*YouTubeChannelInfo)(nil), "google.ads.googleads.v1.common.YouTubeChannelInfo")
	proto.RegisterType((*UserListInfo)(nil), "google.ads.googleads.v1.common.UserListInfo")
	proto.RegisterType((*ProximityInfo)(nil), "google.ads.googleads.v1.common.ProximityInfo")
	proto.RegisterType((*GeoPointInfo)(nil), "google.ads.googleads.v1.common.GeoPointInfo")
	proto.RegisterType((*AddressInfo)(nil), "google.ads.googleads.v1.common.AddressInfo")
	proto.RegisterType((*TopicInfo)(nil), "google.ads.googleads.v1.common.TopicInfo")
	proto.RegisterType((*LanguageInfo)(nil), "google.ads.googleads.v1.common.LanguageInfo")
	proto.RegisterType((*IpBlockInfo)(nil), "google.ads.googleads.v1.common.IpBlockInfo")
	proto.RegisterType((*ContentLabelInfo)(nil), "google.ads.googleads.v1.common.ContentLabelInfo")
	proto.RegisterType((*CarrierInfo)(nil), "google.ads.googleads.v1.common.CarrierInfo")
	proto.RegisterType((*UserInterestInfo)(nil), "google.ads.googleads.v1.common.UserInterestInfo")
	proto.RegisterType((*WebpageInfo)(nil), "google.ads.googleads.v1.common.WebpageInfo")
	proto.RegisterType((*WebpageConditionInfo)(nil), "google.ads.googleads.v1.common.WebpageConditionInfo")
	proto.RegisterType((*OperatingSystemVersionInfo)(nil), "google.ads.googleads.v1.common.OperatingSystemVersionInfo")
	proto.RegisterType((*AppPaymentModelInfo)(nil), "google.ads.googleads.v1.common.AppPaymentModelInfo")
	proto.RegisterType((*MobileDeviceInfo)(nil), "google.ads.googleads.v1.common.MobileDeviceInfo")
	proto.RegisterType((*CustomAffinityInfo)(nil), "google.ads.googleads.v1.common.CustomAffinityInfo")
	proto.RegisterType((*CustomIntentInfo)(nil), "google.ads.googleads.v1.common.CustomIntentInfo")
	proto.RegisterType((*LocationGroupInfo)(nil), "google.ads.googleads.v1.common.LocationGroupInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/criteria.proto", fileDescriptor_90481ed808a2095c)
}

var fileDescriptor_90481ed808a2095c = []byte{
	// 2774 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x5a, 0x4f, 0x73, 0x1c, 0x47,
	0x15, 0xcf, 0xae, 0x64, 0x4b, 0x7a, 0x2b, 0xc9, 0xf2, 0x58, 0x51, 0xd6, 0xca, 0x9f, 0x0a, 0x73,
	0x4a, 0x11, 0xb2, 0xb2, 0x64, 0x63, 0x82, 0x42, 0x30, 0x2b, 0xc9, 0xc8, 0x9b, 0xc8, 0xb6, 0xb2,
	0x92, 0xe5, 0xc4, 0x71, 0x98, 0xb4, 0x66, 0x7a, 0x67, 0x1b, 0xcf, 0x74, 0x4f, 0xcd, 0xf4, 0x48,
	0x5a, 0x0e, 0x50, 0x45, 0x15, 0xc5, 0x81, 0x03, 0x77, 0x6e, 0x50, 0x1c, 0x80, 0x13, 0x1f, 0x81,
	0x82, 0x0b, 0xc5, 0x47, 0xe0, 0x13, 0x50, 0x7c, 0x06, 0x0e, 0x54, 0xff, 0x9b, 0x9d, 0xfd, 0xa7,
	0x99, 0x55, 0xe5, 0xa4, 0x9d, 0xee, 0xf7, 0xfb, 0xbd, 0xd7, 0xdd, 0xaf, 0xdf, 0x7b, 0xdd, 0x2d,
	0xf8, 0xc0, 0x67, 0xcc, 0x0f, 0xf0, 0x06, 0xf2, 0x92, 0x0d, 0xf5, 0x53, 0xfc, 0x3a, 0xdb, 0xdc,
	0x70, 0x59, 0x18, 0x32, 0xba, 0xe1, 0xc6, 0x84, 0xe3, 0x98, 0xa0, 0x46, 0x14, 0x33, 0xce, 0xac,
	0x77, 0x94, 0x4c, 0x03, 0x79, 0x49, 0x23, 0x13, 0x6f, 0x9c, 0x6d, 0x36, 0x94, 0xf8, 0xfa, 0xd6,
	0x24, 0x3a, 0x4c, 0xd3, 0x30, 0xd9, 0x40, 0x3e, 0x76, 0x62, 0x44, 0x7d, 0xec, 0xf0, 0x5e, 0x84,
	0x15, 0xe7, 0xfa, 0x76, 0x01, 0x26, 0x8a, 0x9c, 0x08, 0xf5, 0x42, 0x4c, 0xb9, 0x13, 0x32, 0x0f,
	0x07, 0x79, 0xec, 0xfd, 0xcb, 0xb1, 0x2e, 0xa3, 0x5c, 0xe0, 0x02, 0x74, 0x3a, 0x88, 0xdb, 0xb8,
	0x1c, 0xe7, 0xa1, 0x9e, 0xc3, 0x3a, 0xce, 0x39, 0xc6, 0xaf, 0x34, 0xe0, 0xdb, 0x05, 0x00, 0x7c,
	0x46, 0xdc, 0x92, 0xe4, 0x3e, 0xa6, 0x1e, 0x8e, 0xf3, 0xd6, 0x7c, 0x7c, 0x39, 0xa0, 0xcb, 0x38,
	0x0e, 0x1c, 0x0f, 0x71, 0xec, 0x24, 0x38, 0xc0, 0x2e, 0x27, 0x8c, 0xe6, 0xe1, 0xdf, 0xbd, 0x1c,
	0x4e, 0xa8, 0xcb, 0xc2, 0x31, 0xf3, 0x7e, 0xaf, 0x08, 0xc6, 0x71, 0x8c, 0x46, 0x94, 0x15, 0xcc,
	0xf8, 0x2b, 0xdc, 0x3b, 0x67, 0xb1, 0xe7, 0x84, 0x88, 0xbb, 0xdd, 0x3c, 0x6e, 0xe7, 0x72, 0x5c,
	0x40, 0x12, 0x4e, 0xa8, 0xef, 0xb8, 0x69, 0xc2, 0x59, 0xe8, 0x20, 0xce, 0x63, 0x72, 0x9a, 0x72,
	0xec, 0x10, 0xea, 0xe1, 0x8b, 0x72, 0xba, 0x0d, 0x87, 0x1f, 0xb3, 0x34, 0xca, 0xeb, 0x7e, 0x50,
	0x80, 0x63, 0x2e, 0x92, 0xc3, 0x54, 0xc0, 0x18, 0x79, 0x24, 0x4d, 0x9c, 0x94, 0x12, 0x9e, 0x68,
	0x82, 0x02, 0xb7, 0x0e, 0x09, 0x15, 0xa6, 0xb2, 0x8e, 0xd3, 0x65, 0x69, 0xac, 0x31, 0x1f, 0x5e,
	0x8e, 0x89, 0x50, 0x8c, 0x29, 0x47, 0x81, 0x93, 0x70, 0xc4, 0xd3, 0x64, 0x8a, 0x0d, 0x11, 0xc5,
	0xb8, 0x83, 0xe3, 0x18, 0x7b, 0x8e, 0x71, 0xef, 0xf2, 0xd3, 0x1c, 0xc5, 0xcc, 0x4b, 0x5d, 0xee,
	0x9c, 0x12, 0xcf, 0x93, 0xd3, 0x8d, 0x38, 0xf6, 0x59, 0xdc, 0x73, 0x02, 0x7c, 0x86, 0x03, 0xcd,
	0x71, 0xb7, 0x1c, 0x87, 0xdb, 0x45, 0x94, 0x66, 0xa0, 0x07, 0x53, 0x81, 0x1c, 0x7c, 0xe1, 0x06,
	0x69, 0x42, 0xce, 0x08, 0xef, 0x95, 0xf3, 0xe2, 0x8c, 0x80, 0x51, 0x8f, 0x88, 0xd5, 0x2a, 0xe7,
	0x13, 0x06, 0x26, 0xa6, 0x68, 0x60, 0x90, 0x85, 0x93, 0xcc, 0x2e, 0x48, 0x48, 0x78, 0x6f, 0x9c,
	0x3b, 0x14, 0xec, 0xd7, 0x73, 0x7c, 0x1a, 0x89, 0x48, 0x97, 0x99, 0xea, 0xb0, 0x08, 0xc7, 0x88,
	0x7a, 0x1a, 0xfe, 0xc3, 0x2b, 0xc1, 0x39, 0x33, 0x9e, 0xf5, 0x96, 0xc1, 0x47, 0x64, 0x03, 0x51,
	0xca, 0xb8, 0xf4, 0x5e, 0x63, 0x9c, 0x0e, 0xd1, 0x1b, 0xf2, 0xeb, 0x34, 0xed, 0x6c, 0x9c, 0xc7,
	0x28, 0x8a, 0x70, 0xac, 0xfb, 0xed, 0x3f, 0x56, 0xa0, 0xf6, 0xa9, 0xda, 0xa5, 0x2d, 0xda, 0x61,
	0xd6, 0x1d, 0x98, 0xe5, 0xf8, 0x82, 0xd7, 0x2b, 0xef, 0x56, 0xde, 0xab, 0x6d, 0xbd, 0xa5, 0xc3,
	0x7a, 0xc3, 0xc0, 0x1b, 0x47, 0x3c, 0x26, 0xd4, 0x3f, 0x41, 0x41, 0x8a, 0xdb, 0x52, 0xd2, 0x72,
	0x01, 0xfa, 0xdb, 0xbb, 0x5e, 0x7d, 0xb7, 0xf2, 0xde, 0xf2, 0xd6, 0x5e, 0x63, 0x52, 0x66, 0x90,
	0x83, 0x6a, 0x68, 0x8d, 0x8f, 0x05, 0xee, 0xb8, 0x17, 0xe1, 0x87, 0x34, 0x0d, 0x47, 0x1a, 0xdb,
	0x0b, 0xa1, 0xf9, 0x69, 0x3f, 0x80, 0xa5, 0xc3, 0x00, 0xb9, 0x58, 0xc4, 0x7d, 0x69, 0x67, 0x03,
	0x66, 0xd2, 0x38, 0x28, 0x65, 0xa6, 0x10, 0xb4, 0xcf, 0xe0, 0xf5, 0xc7, 0xec, 0x94, 0x04, 0xb8,
	0x19, 0x45, 0xbb, 0xda, 0xcd, 0x25, 0xd1, 0x57, 0xf0, 0x56, 0x28, 0x3b, 0x1c, 0x91, 0x5a, 0xb2,
	0x1d, 0xe0, 0x32, 0x9a, 0x70, 0x44, 0xcb, 0x4d, 0xc4, 0xed, 0x70, 0x98, 0x7a, 0x57, 0xc3, 0xed,
	0x9f, 0xe7, 0xf4, 0x06, 0x44, 0x45, 0x16, 0xa9, 0xf7, 0x2e, 0x5c, 0x17, 0x0a, 0x89, 0x27, 0xa7,
	0xac, 0x48, 0xc3, 0x35, 0x14, 0x45, 0x2d, 0x4f, 0xac, 0x0e, 0x45, 0x21, 0xae, 0xcf, 0x94, 0x59,
	0x1d, 0x21, 0x69, 0xbf, 0x84, 0xc5, 0x03, 0x96, 0x53, 0x7b, 0x00, 0xb7, 0x7c, 0xcc, 0x1c, 0x8e,
	0x62, 0x1f, 0xf3, 0xe9, 0x46, 0x79, 0xd3, 0xc7, 0xec, 0x58, 0xe2, 0xb2, 0xd1, 0xb5, 0x01, 0xf6,
	0x64, 0xae, 0x93, 0xdc, 0x7b, 0x30, 0x2b, 0x7d, 0xa0, 0x22, 0x7d, 0xe0, 0x4e, 0x81, 0x0f, 0x28,
	0xa0, 0x5c, 0x79, 0xf5, 0xb3, 0x2d, 0xd1, 0xf6, 0x05, 0xac, 0x1e, 0x9a, 0x98, 0xb6, 0xab, 0x42,
	0x9a, 0x64, 0xff, 0x5a, 0xb3, 0x2b, 0x0f, 0x3b, 0x28, 0x60, 0x1f, 0xa6, 0xc8, 0xbc, 0x6c, 0x5c,
	0x87, 0xd6, 0xfc, 0xbb, 0x2a, 0xac, 0x1c, 0xa8, 0xac, 0xb1, 0x2f, 0x62, 0xbf, 0x54, 0xfb, 0xf9,
	0xc0, 0xa0, 0x8a, 0x1c, 0x3b, 0x0f, 0xcf, 0x54, 0x0e, 0x37, 0x2a, 0x75, 0xd6, 0x11, 0x80, 0x8b,
	0x12, 0xec, 0x9c, 0x89, 0xd9, 0xd5, 0x5e, 0x70, 0xaf, 0x71, 0x79, 0x49, 0x65, 0xb8, 0xf6, 0x48,
	0x88, 0x69, 0xa2, 0x17, 0xb5, 0xbd, 0x20, 0x78, 0xe4, 0x22, 0x59, 0xcf, 0xe1, 0xb6, 0xca, 0x25,
	0x0e, 0xf2, 0x74, 0x06, 0xd3, 0x45, 0x1b, 0xa3, 0xa5, 0xdc, 0x66, 0x4d, 0xc1, 0x9b, 0x9e, 0x34,
	0x77, 0xd7, 0x60, 0xed, 0x6e, 0x36, 0x37, 0x47, 0x2e, 0x8b, 0xd4, 0x82, 0x1f, 0x03, 0x78, 0xc6,
	0x90, 0xa4, 0x5e, 0x7d, 0x77, 0xe6, 0xca, 0x23, 0xc8, 0xf1, 0xd8, 0xbf, 0xa9, 0xc1, 0xea, 0x38,
	0x21, 0xeb, 0x39, 0x2c, 0x99, 0xa4, 0x7e, 0x2a, 0x02, 0xa8, 0xf6, 0xda, 0x3b, 0x25, 0x35, 0xee,
	0x08, 0x8c, 0x20, 0x7a, 0xf4, 0x5a, 0x7b, 0x31, 0xc8, 0xb5, 0x59, 0x8f, 0x60, 0x5e, 0x55, 0x55,
	0xd9, 0x6e, 0x7c, 0xbf, 0x88, 0xf3, 0x91, 0x90, 0x6f, 0x19, 0xba, 0xb9, 0xae, 0xfa, 0xb4, 0x3e,
	0x83, 0x9a, 0x62, 0x72, 0x03, 0x94, 0x24, 0x7a, 0xc2, 0x1b, 0xa5, 0xc8, 0x76, 0x05, 0x42, 0xf3,
	0x41, 0x37, 0x6b, 0xb1, 0x7e, 0x0a, 0xab, 0x9a, 0x92, 0xa5, 0x94, 0xc7, 0x3d, 0x27, 0xc6, 0xbe,
	0x58, 0xcc, 0x59, 0xc9, 0x7d, 0xbf, 0x1c, 0xb7, 0x82, 0xb6, 0x25, 0x52, 0xeb, 0xb0, 0xba, 0x23,
	0x3d, 0x7d, 0xf3, 0x45, 0x19, 0x82, 0xeb, 0xd7, 0xa6, 0x30, 0xff, 0x48, 0x20, 0x06, 0xcc, 0x97,
	0x2d, 0xd6, 0x13, 0x00, 0x6d, 0x3e, 0xe1, 0xbd, 0xfa, 0x75, 0xc9, 0xf8, 0x41, 0x39, 0xa3, 0x09,
	0xef, 0x69, 0xc2, 0x85, 0xae, 0x69, 0xb0, 0xce, 0xa0, 0x3e, 0xa9, 0x3a, 0xac, 0xcf, 0x49, 0xf6,
	0xed, 0x92, 0xfe, 0xb0, 0x2b, 0xe1, 0x4d, 0x83, 0xd6, 0xaa, 0xd6, 0x82, 0xb1, 0xbd, 0x42, 0xef,
	0xa4, 0x72, 0xa9, 0xbe, 0x54, 0x4e, 0xef, 0xa1, 0xc2, 0xef, 0x28, 0x78, 0x3e, 0x0b, 0x09, 0xbd,
	0xd1, 0xd8, 0x5e, 0xeb, 0x2b, 0xb8, 0x31, 0x54, 0x2d, 0xd5, 0xe7, 0xa5, 0xba, 0xad, 0x92, 0xea,
	0x76, 0x15, 0x4a, 0xab, 0x59, 0x8e, 0x06, 0x5a, 0xad, 0x5f, 0xc0, 0x9b, 0x97, 0x14, 0x63, 0xf5,
	0x05, 0xa9, 0xea, 0xe3, 0xe9, 0x54, 0x3d, 0xec, 0x13, 0x68, 0xad, 0xb7, 0xa3, 0x49, 0x02, 0x96,
	0x0b, 0x37, 0x47, 0x8a, 0xb9, 0x3a, 0x94, 0x0b, 0x86, 0x46, 0xad, 0xc1, 0x69, 0x6d, 0x2b, 0xd1,
	0x50, 0xbb, 0xf5, 0x65, 0x7f, 0x12, 0x09, 0xc7, 0xa1, 0xd8, 0xe7, 0x35, 0xa9, 0x62, 0xb3, 0xa4,
	0x8a, 0x16, 0xc7, 0x61, 0xb6, 0xdb, 0x97, 0xa2, 0x7c, 0xa3, 0x75, 0x0c, 0x8b, 0xf9, 0xba, 0xb2,
	0xbe, 0x28, 0x99, 0x37, 0x4a, 0x32, 0x8b, 0x84, 0xa0, 0x79, 0x6b, 0x51, 0xbf, 0xc9, 0xea, 0xc1,
	0xed, 0x94, 0xbe, 0xa2, 0xec, 0x9c, 0x3a, 0xc6, 0xdf, 0xb3, 0x18, 0x59, 0x5f, 0x96, 0x2a, 0x3e,
	0x2a, 0x52, 0xf1, 0x4c, 0x11, 0x8c, 0x0b, 0xa6, 0x8f, 0x5e, 0x6b, 0xbf, 0x91, 0x8e, 0xef, 0xde,
	0xa9, 0xc1, 0x42, 0xa6, 0xca, 0xfe, 0x71, 0x16, 0xf7, 0xb3, 0xf8, 0x69, 0x6d, 0xc1, 0x35, 0x95,
	0xb4, 0xca, 0x94, 0x0d, 0x4a, 0xd4, 0x6e, 0x42, 0x2d, 0x17, 0x33, 0xaf, 0x44, 0xb1, 0x0b, 0xcb,
	0x83, 0x91, 0xd2, 0xda, 0x1c, 0x64, 0x79, 0x73, 0x84, 0xa5, 0x45, 0xf9, 0xfd, 0x7b, 0x03, 0x24,
	0x11, 0xac, 0x8d, 0x0f, 0x89, 0xd6, 0x09, 0xd4, 0x07, 0x43, 0x6c, 0x2e, 0x73, 0x96, 0xb1, 0x72,
	0xcd, 0xcd, 0x53, 0xf6, 0x33, 0xe7, 0x73, 0x6d, 0x76, 0x16, 0x21, 0xad, 0x87, 0x70, 0x43, 0x06,
	0xd8, 0x29, 0x15, 0x2c, 0x4b, 0x50, 0x9f, 0xf8, 0x18, 0x96, 0x06, 0x02, 0xa5, 0xb5, 0x0b, 0xcb,
	0x22, 0xca, 0x4e, 0x49, 0xbb, 0x24, 0x30, 0x7d, 0xd6, 0xbf, 0x57, 0x60, 0x7d, 0x72, 0x84, 0xbc,
	0xca, 0xc2, 0x59, 0x11, 0x5c, 0x93, 0x07, 0x77, 0x5d, 0xbb, 0xbd, 0x28, 0x57, 0x44, 0x8d, 0x68,
	0xf7, 0xf0, 0x45, 0xbe, 0x9e, 0x1a, 0xd7, 0xdf, 0x56, 0x8a, 0xec, 0xff, 0x55, 0x60, 0x7d, 0x72,
	0xb8, 0xb5, 0xde, 0x87, 0x2a, 0xf1, 0xca, 0x38, 0x4d, 0x95, 0x78, 0xd6, 0x03, 0x58, 0x34, 0x7e,
	0xe1, 0x32, 0x0f, 0x97, 0xaa, 0xd7, 0x6b, 0x1a, 0xb1, 0xcb, 0x3c, 0x39, 0x7c, 0x79, 0xd6, 0x94,
	0xe5, 0x40, 0xf1, 0xf0, 0xc7, 0xdb, 0x7d, 0x20, 0x18, 0x74, 0x05, 0x3b, 0xb1, 0xbf, 0xad, 0x14,
	0xd9, 0x11, 0x58, 0xa3, 0xd1, 0xdf, 0x7a, 0x01, 0x73, 0x26, 0x85, 0xa8, 0x6a, 0xf6, 0x47, 0xe5,
	0x2c, 0x31, 0x51, 0x3b, 0xa7, 0x5c, 0x37, 0xb5, 0x0d, 0xa1, 0xfd, 0xe7, 0x0a, 0xbc, 0x7d, 0x69,
	0x16, 0xb0, 0x7e, 0x5d, 0x81, 0x5b, 0xe3, 0x52, 0x8c, 0x32, 0xe5, 0x64, 0x3a, 0x53, 0xfa, 0xf8,
	0x31, 0x56, 0xe5, 0x7a, 0xdb, 0x96, 0x3b, 0xd2, 0x66, 0xff, 0x4c, 0x9c, 0x30, 0x46, 0x33, 0x87,
	0x75, 0x0a, 0x0b, 0xfd, 0x14, 0x54, 0xae, 0xde, 0x1f, 0xe6, 0x19, 0xb0, 0xc6, 0x34, 0xb6, 0xfb,
	0xb4, 0xf6, 0x3e, 0xdc, 0x1c, 0x49, 0x29, 0x57, 0x0a, 0x86, 0xbf, 0xaf, 0xc0, 0x8d, 0xa1, 0x14,
	0x72, 0xa5, 0xbd, 0xf9, 0xc2, 0x38, 0x67, 0x75, 0x9a, 0x01, 0x0b, 0x95, 0x23, 0x1e, 0x99, 0x35,
	0x1a, 0x37, 0x7c, 0x1b, 0xde, 0xbc, 0x24, 0x05, 0xd9, 0xbf, 0xac, 0xc0, 0xba, 0x0c, 0x60, 0x7b,
	0x88, 0xe3, 0x23, 0x73, 0x97, 0x99, 0x8d, 0xc6, 0x1b, 0x38, 0x79, 0x1d, 0x16, 0x18, 0x36, 0x9e,
	0x48, 0x9a, 0x37, 0xbe, 0x4b, 0x1f, 0xfa, 0x7e, 0x5b, 0x81, 0xb7, 0xa5, 0x40, 0xd3, 0x3b, 0x43,
	0xd4, 0xc5, 0x3b, 0x8c, 0xbd, 0x22, 0xd4, 0x7f, 0x4e, 0xa8, 0xc7, 0xce, 0xa5, 0x1d, 0xf7, 0x61,
	0x3e, 0x24, 0xd4, 0xf1, 0x50, 0x2f, 0x29, 0x13, 0x32, 0xe6, 0x42, 0x42, 0xf7, 0x50, 0x2f, 0x91,
	0x38, 0x74, 0xa1, 0x70, 0xd5, 0x32, 0x38, 0x74, 0x21, 0x70, 0xc2, 0xa2, 0xd7, 0xa5, 0x45, 0x07,
	0x98, 0xfa, 0xbc, 0xfb, 0xb4, 0x73, 0xc4, 0x91, 0xda, 0x42, 0xdb, 0x00, 0xc2, 0x12, 0x4a, 0xfc,
	0x2e, 0x2f, 0x65, 0xcb, 0x42, 0x48, 0xe8, 0x13, 0x29, 0x2d, 0xb1, 0xe8, 0xc2, 0x60, 0xab, 0x65,
	0xb0, 0xe8, 0x42, 0x61, 0xed, 0x10, 0x6e, 0xa9, 0x44, 0xd3, 0xc5, 0xee, 0xab, 0x96, 0x18, 0x9d,
	0x4e, 0x98, 0xb5, 0xdc, 0xd5, 0xb8, 0x5e, 0xa7, 0xfb, 0x45, 0xc7, 0x7e, 0xd4, 0x7b, 0xda, 0x79,
	0x8e, 0xf1, 0x2b, 0x75, 0xf2, 0x37, 0x5f, 0xed, 0x05, 0xcf, 0xfc, 0x14, 0xea, 0x5a, 0xfd, 0xeb,
	0xe6, 0xcc, 0x1f, 0x4e, 0x06, 0xfc, 0x61, 0xa7, 0x40, 0xcf, 0x10, 0x83, 0xd4, 0x36, 0xd4, 0x66,
	0x8e, 0xfd, 0x33, 0xb0, 0xdc, 0xf4, 0x8e, 0xdc, 0x2e, 0xf6, 0xd2, 0x40, 0xa9, 0x72, 0x60, 0x31,
	0xe1, 0x28, 0xe6, 0x8e, 0xba, 0xcb, 0xd5, 0x2a, 0x7f, 0x50, 0xa0, 0xf2, 0xb1, 0x14, 0x7e, 0xda,
	0x79, 0xc4, 0xd2, 0x58, 0xea, 0xcb, 0x37, 0xb4, 0x6b, 0x92, 0x51, 0x35, 0x59, 0x5f, 0x02, 0x60,
	0xea, 0x19, 0xfa, 0xea, 0x37, 0x40, 0xbf, 0x80, 0xa9, 0xa7, 0xc9, 0xb7, 0x01, 0x94, 0xf5, 0x5d,
	0x96, 0xc6, 0xfa, 0x0c, 0x3a, 0x76, 0xa9, 0xef, 0x6e, 0xe9, 0xa5, 0x96, 0xe2, 0x82, 0x46, 0x38,
	0xad, 0x30, 0x4c, 0x22, 0x67, 0x8b, 0x91, 0x73, 0x98, 0x7a, 0x12, 0x37, 0xe4, 0x0b, 0xd7, 0xbe,
	0x29, 0x5f, 0xf8, 0x1a, 0x16, 0x9b, 0x3e, 0x6e, 0x23, 0xea, 0xab, 0x95, 0x39, 0x1c, 0x70, 0x82,
	0xa2, 0x29, 0x33, 0xd0, 0xcc, 0x03, 0xf2, 0x0d, 0x7a, 0xf9, 0x5f, 0x00, 0xec, 0xcb, 0x37, 0x18,
	0x7d, 0x3f, 0x96, 0xe7, 0xff, 0xb0, 0x80, 0x5f, 0x01, 0x33, 0xf6, 0xfe, 0xa7, 0xe6, 0x26, 0x70,
	0xa3, 0x25, 0xdf, 0x5b, 0xfa, 0x03, 0x98, 0xd6, 0x8b, 0x33, 0x74, 0xce, 0x8b, 0x07, 0xda, 0xb4,
	0xaa, 0x18, 0xac, 0x43, 0xfd, 0x88, 0x70, 0x24, 0xdf, 0x10, 0xa4, 0xb6, 0x97, 0x03, 0xda, 0x1e,
	0x15, 0x05, 0xf7, 0x01, 0x82, 0xfe, 0x95, 0xd9, 0x48, 0xb3, 0xd6, 0xf9, 0x29, 0xac, 0x7c, 0xc1,
	0xd2, 0xe3, 0xf4, 0x14, 0x9f, 0x10, 0x0f, 0x33, 0xa9, 0xf1, 0x7b, 0x30, 0x7f, 0x26, 0x3e, 0x9c,
	0xac, 0xc0, 0xba, 0x3c, 0x0d, 0xcd, 0x49, 0xe9, 0x96, 0x67, 0x7f, 0x06, 0x96, 0x26, 0xcb, 0xd7,
	0x2c, 0x1f, 0x01, 0x98, 0xa2, 0xa1, 0x24, 0xe1, 0x82, 0x96, 0x6f, 0x79, 0x76, 0x0b, 0x16, 0x9f,
	0x25, 0x38, 0x16, 0xc9, 0x47, 0x92, 0x7d, 0x1f, 0x16, 0xd2, 0x04, 0xc7, 0xf2, 0x40, 0x55, 0x8a,
	0x6b, 0x3e, 0xd5, 0x70, 0xfb, 0x9f, 0x55, 0x58, 0x3a, 0x34, 0xaf, 0x00, 0x92, 0xac, 0x05, 0x0b,
	0x3e, 0x66, 0x4e, 0xc4, 0x48, 0x76, 0x7f, 0xfa, 0x9d, 0xa2, 0x03, 0xd9, 0x3e, 0x66, 0x87, 0x42,
	0x5e, 0xde, 0x79, 0xcd, 0xfb, 0xfa, 0xcb, 0xba, 0x07, 0xd7, 0xd5, 0xbb, 0xc2, 0xc4, 0xda, 0x72,
	0x8f, 0xa5, 0xa7, 0x81, 0xba, 0xe2, 0x6b, 0x6b, 0x59, 0x8b, 0xc1, 0x62, 0xfe, 0x35, 0x42, 0x57,
	0x97, 0xc5, 0x17, 0xa3, 0x7a, 0x10, 0x6d, 0x89, 0x7d, 0x26, 0xa0, 0x26, 0x89, 0x8f, 0x74, 0xb4,
	0x6b, 0x71, 0xff, 0xc3, 0x7a, 0x08, 0x73, 0xc8, 0xf3, 0x62, 0x9c, 0x24, 0x3a, 0x34, 0x14, 0xde,
	0x92, 0x35, 0x95, 0xb8, 0x1c, 0xae, 0xc1, 0xda, 0x7f, 0xab, 0xc0, 0x62, 0x7e, 0x22, 0xac, 0xcf,
	0x61, 0x3d, 0x60, 0xd4, 0x27, 0x3c, 0xf5, 0xb0, 0x43, 0xa8, 0x13, 0x12, 0x37, 0x66, 0x8e, 0x87,
	0xfd, 0x18, 0xe3, 0x4b, 0xd3, 0x9c, 0x89, 0x42, 0x6f, 0x64, 0xf0, 0x16, 0x7d, 0x2c, 0xc0, 0x7b,
	0x0a, 0x6b, 0x9d, 0xc0, 0xed, 0x00, 0xf1, 0x09, 0xc4, 0xd5, 0x62, 0xe2, 0x35, 0x83, 0x1e, 0xe4,
	0xb5, 0xff, 0x3d, 0x03, 0xb5, 0xdc, 0xd8, 0xac, 0x8f, 0xa1, 0x16, 0xb1, 0x84, 0xa3, 0x40, 0x9d,
	0x10, 0xca, 0xb8, 0x16, 0x28, 0x80, 0x3c, 0x20, 0x34, 0x61, 0x29, 0x8a, 0xd9, 0x19, 0xa1, 0x2e,
	0x2e, 0x7f, 0xc4, 0x58, 0x34, 0x10, 0x49, 0x31, 0x7c, 0x48, 0x99, 0x99, 0xf6, 0x90, 0x92, 0xb7,
	0x41, 0xbe, 0x31, 0xcc, 0x4e, 0x63, 0xc3, 0x13, 0x14, 0x62, 0x71, 0xfc, 0x4c, 0x78, 0x8c, 0x31,
	0x77, 0x8c, 0x9b, 0x5c, 0x2b, 0x73, 0xfc, 0x54, 0x18, 0x3d, 0x9d, 0xea, 0x6c, 0x9c, 0x27, 0xd9,
	0xd2, 0x97, 0x86, 0x85, 0x67, 0xe3, 0x1c, 0xcb, 0x96, 0xd8, 0xea, 0xf2, 0x28, 0x2c, 0x87, 0x32,
	0x57, 0x66, 0xab, 0x0b, 0x71, 0x31, 0x0c, 0x51, 0x96, 0x2e, 0x1c, 0xb3, 0x88, 0xb8, 0xe6, 0x4c,
	0xcd, 0xc5, 0xc7, 0x74, 0x6f, 0x25, 0x4b, 0x12, 0x63, 0xde, 0x49, 0xac, 0x3b, 0x30, 0x1b, 0x21,
	0xde, 0xd5, 0x57, 0xe4, 0x05, 0xef, 0x36, 0x42, 0xd2, 0xfe, 0x02, 0x16, 0x0f, 0x10, 0xf5, 0x53,
	0xa4, 0xd3, 0x46, 0x0b, 0x6e, 0x06, 0xfa, 0x7b, 0x3a, 0x4b, 0x56, 0x0c, 0x2c, 0x7b, 0xb4, 0xf9,
	0x04, 0x6a, 0xad, 0x68, 0x27, 0x60, 0xa2, 0x94, 0x53, 0x11, 0x96, 0x44, 0xd9, 0x8a, 0x95, 0x8a,
	0xb0, 0x24, 0xd2, 0xf3, 0x6c, 0x07, 0xb0, 0xa2, 0xdf, 0x51, 0x0e, 0xd0, 0xa9, 0x0e, 0xd9, 0xd3,
	0xbd, 0x98, 0xe4, 0xe1, 0x59, 0xc6, 0x19, 0x6e, 0xd4, 0xf9, 0xe6, 0x04, 0x6a, 0xbb, 0x28, 0x8e,
	0x89, 0xce, 0xd5, 0xfb, 0xb0, 0xe2, 0xaa, 0xcf, 0xe9, 0xa6, 0xe4, 0x86, 0x46, 0x65, 0x33, 0xd2,
	0x81, 0x15, 0x91, 0x27, 0x64, 0x79, 0x88, 0x75, 0xae, 0x68, 0xc3, 0x9a, 0xcc, 0x15, 0x44, 0x37,
	0xf6, 0x6f, 0x7b, 0xcb, 0xa8, 0x58, 0x4d, 0x73, 0x7c, 0xe6, 0x88, 0x6e, 0xff, 0xa9, 0x02, 0xb5,
	0xe7, 0xea, 0x3d, 0x37, 0xbb, 0xaf, 0x31, 0xf7, 0x2e, 0xca, 0x53, 0xcb, 0xdd, 0xd7, 0x18, 0x8c,
	0xdc, 0x75, 0xc7, 0x00, 0xd9, 0xf1, 0xb2, 0xf4, 0x23, 0x8c, 0xb6, 0x62, 0xe0, 0xfc, 0xdb, 0xce,
	0xf1, 0xd8, 0x7f, 0xad, 0xc2, 0xea, 0x38, 0x21, 0x2b, 0x80, 0x39, 0xfd, 0x7e, 0xad, 0x17, 0xb8,
	0x5d, 0xb0, 0xc0, 0xc3, 0x2c, 0x4f, 0x15, 0x5a, 0xae, 0xf3, 0x84, 0xbe, 0xb6, 0x51, 0x61, 0x45,
	0x30, 0x6f, 0x9e, 0xbb, 0x75, 0x95, 0x7c, 0x7c, 0x15, 0x75, 0x9c, 0xc5, 0x93, 0xf5, 0x71, 0x16,
	0xb7, 0x33, 0x2d, 0xd6, 0x87, 0x30, 0x8f, 0x62, 0x3f, 0x0d, 0x31, 0xe5, 0xa5, 0x82, 0x68, 0x26,
	0x6d, 0xff, 0xaa, 0x02, 0xeb, 0x8a, 0x90, 0x50, 0xff, 0xa8, 0x97, 0x70, 0x1c, 0x9e, 0xe0, 0x38,
	0x7b, 0xbd, 0xf2, 0xe1, 0x5b, 0xcc, 0xf4, 0x3a, 0x89, 0xec, 0x76, 0xce, 0x54, 0xff, 0x74, 0xee,
	0xfb, 0x0e, 0x1b, 0xab, 0x24, 0xf3, 0xe6, 0x14, 0x6e, 0x35, 0xa3, 0xe8, 0x50, 0xfd, 0x93, 0xd4,
	0x63, 0xe6, 0xe9, 0x6d, 0xf9, 0x93, 0x81, 0x6d, 0xf9, 0x49, 0x51, 0xe5, 0x3c, 0xc8, 0xd0, 0x2f,
	0xa0, 0x47, 0xdb, 0xf5, 0xe6, 0xec, 0xc0, 0x8a, 0x7a, 0xe9, 0xce, 0xbd, 0x08, 0xb7, 0x61, 0x4d,
	0x3f, 0xae, 0xab, 0x7f, 0x89, 0x9a, 0x6e, 0xa0, 0xab, 0x61, 0x8e, 0x2f, 0x1b, 0xde, 0x97, 0x60,
	0xe9, 0x9b, 0xbf, 0x4e, 0x87, 0x50, 0x53, 0x8d, 0x3d, 0x84, 0x1b, 0xe6, 0x39, 0x48, 0x37, 0x97,
	0xbb, 0x52, 0x75, 0x07, 0xa8, 0xec, 0x67, 0xb0, 0xa2, 0xc8, 0x5b, 0xfd, 0x87, 0xe7, 0x26, 0x2c,
	0x69, 0x6a, 0x22, 0x1b, 0x4b, 0x11, 0x2f, 0xba, 0x39, 0x1a, 0xfb, 0x1f, 0x55, 0xb8, 0x69, 0x9e,
	0xe1, 0xfb, 0x4f, 0xcb, 0x77, 0x60, 0xb6, 0x83, 0x71, 0xb9, 0xaa, 0x56, 0x4a, 0x5a, 0x4f, 0x60,
	0x75, 0xcc, 0xeb, 0x7d, 0x52, 0x2a, 0xaf, 0x58, 0x23, 0xcf, 0xf7, 0x89, 0x75, 0x37, 0x2b, 0x3c,
	0x67, 0x8a, 0x2f, 0x04, 0x4c, 0xdd, 0x79, 0x3e, 0x54, 0x77, 0xce, 0x96, 0xda, 0x97, 0x03, 0xc3,
	0x1f, 0xae, 0x3d, 0x27, 0x75, 0x0e, 0xd4, 0x9f, 0x3b, 0xff, 0xa9, 0x80, 0xed, 0xb2, 0xb0, 0x20,
	0xb6, 0xed, 0x2c, 0xe9, 0xbb, 0x6c, 0x74, 0x28, 0x06, 0x71, 0x58, 0x79, 0xb1, 0xa7, 0x01, 0x3e,
	0x13, 0xb9, 0xb0, 0xc1, 0x62, 0x7f, 0xc3, 0xc7, 0x54, 0x0e, 0xd1, 0xfc, 0xc7, 0x4d, 0x44, 0x92,
	0x49, 0xff, 0xf4, 0xf8, 0x91, 0xfa, 0xf3, 0x87, 0xea, 0xcc, 0x7e, 0xb3, 0xf9, 0x97, 0xea, 0x3b,
	0xfb, 0x8a, 0xac, 0xe9, 0x25, 0x0d, 0xf5, 0x53, 0xfc, 0x3a, 0xd9, 0x6c, 0xec, 0x4a, 0xb1, 0x7f,
	0x19, 0x81, 0x97, 0x4d, 0x2f, 0x79, 0x99, 0x09, 0xbc, 0x3c, 0xd9, 0x7c, 0xa9, 0x04, 0xfe, 0x5b,
	0xb5, 0x55, 0xeb, 0xf6, 0x76, 0xd3, 0x4b, 0xb6, 0xb7, 0x33, 0x91, 0xed, 0xed, 0x93, 0xcd, 0xed,
	0x6d, 0x25, 0x74, 0x7a, 0x5d, 0x5a, 0x77, 0xf7, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0x31, 0x13,
	0x6d, 0xc9, 0x91, 0x29, 0x00, 0x00,
}
