// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto

package runtimeconfig

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf4 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request for the `ListConfigs()` method.
type ListConfigsRequest struct {
	// The [project ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListConfigsRequest) Reset()                    { *m = ListConfigsRequest{} }
func (m *ListConfigsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListConfigsRequest) ProtoMessage()               {}
func (*ListConfigsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *ListConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// `ListConfigs()` returns the following response. The order of returned
// objects is arbitrary; that is, it is not ordered in any particular way.
type ListConfigsResponse struct {
	// A list of the configurations in the project. The order of returned
	// objects is arbitrary; that is, it is not ordered in any particular way.
	Configs []*RuntimeConfig `protobuf:"bytes,1,rep,name=configs" json:"configs,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListConfigsResponse) Reset()                    { *m = ListConfigsResponse{} }
func (m *ListConfigsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListConfigsResponse) ProtoMessage()               {}
func (*ListConfigsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ListConfigsResponse) GetConfigs() []*RuntimeConfig {
	if m != nil {
		return m.Configs
	}
	return nil
}

func (m *ListConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Gets a RuntimeConfig resource.
type GetConfigRequest struct {
	// The name of the RuntimeConfig resource to retrieve, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *GetConfigRequest) Reset()                    { *m = GetConfigRequest{} }
func (m *GetConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetConfigRequest) ProtoMessage()               {}
func (*GetConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *GetConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Creates a RuntimeConfig resource.
type CreateConfigRequest struct {
	// The [project ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The RuntimeConfig to create.
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *CreateConfigRequest) Reset()                    { *m = CreateConfigRequest{} }
func (m *CreateConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateConfigRequest) ProtoMessage()               {}
func (*CreateConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *CreateConfigRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConfigRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *CreateConfigRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Request message for `UpdateConfig()` method.
type UpdateConfigRequest struct {
	// The name of the RuntimeConfig resource to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The config resource to update.
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
}

func (m *UpdateConfigRequest) Reset()                    { *m = UpdateConfigRequest{} }
func (m *UpdateConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateConfigRequest) ProtoMessage()               {}
func (*UpdateConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *UpdateConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateConfigRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

// Request for the `DeleteConfig()` method.
type DeleteConfigRequest struct {
	// The RuntimeConfig resource to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteConfigRequest) Reset()                    { *m = DeleteConfigRequest{} }
func (m *DeleteConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteConfigRequest) ProtoMessage()               {}
func (*DeleteConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *DeleteConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `ListVariables()` method.
type ListVariablesRequest struct {
	// The path to the RuntimeConfig resource for which you want to list variables.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Filters variables by matching the specified filter. For example:
	//
	// `projects/example-project/config/[CONFIG_NAME]/variables/example-variable`.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The flag indicates whether the user wants to return values of variables.
	// If true, then only those variables that user has IAM GetVariable permission
	// will be returned along with their values.
	ReturnValues bool `protobuf:"varint,5,opt,name=return_values,json=returnValues" json:"return_values,omitempty"`
}

func (m *ListVariablesRequest) Reset()                    { *m = ListVariablesRequest{} }
func (m *ListVariablesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVariablesRequest) ProtoMessage()               {}
func (*ListVariablesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *ListVariablesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListVariablesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListVariablesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListVariablesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListVariablesRequest) GetReturnValues() bool {
	if m != nil {
		return m.ReturnValues
	}
	return false
}

// Response for the `ListVariables()` method.
type ListVariablesResponse struct {
	// A list of variables and their values. The order of returned variable
	// objects is arbitrary.
	Variables []*Variable `protobuf:"bytes,1,rep,name=variables" json:"variables,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListVariablesResponse) Reset()                    { *m = ListVariablesResponse{} }
func (m *ListVariablesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListVariablesResponse) ProtoMessage()               {}
func (*ListVariablesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *ListVariablesResponse) GetVariables() []*Variable {
	if m != nil {
		return m.Variables
	}
	return nil
}

func (m *ListVariablesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `WatchVariable()` method.
type WatchVariableRequest struct {
	// The name of the variable to watch, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// If specified, checks the current timestamp of the variable and if the
	// current timestamp is newer than `newerThan` timestamp, the method returns
	// immediately.
	//
	// If not specified or the variable has an older timestamp, the watcher waits
	// for a the value to change before returning.
	NewerThan *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=newer_than,json=newerThan" json:"newer_than,omitempty"`
}

func (m *WatchVariableRequest) Reset()                    { *m = WatchVariableRequest{} }
func (m *WatchVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*WatchVariableRequest) ProtoMessage()               {}
func (*WatchVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *WatchVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WatchVariableRequest) GetNewerThan() *google_protobuf2.Timestamp {
	if m != nil {
		return m.NewerThan
	}
	return nil
}

// Request for the `GetVariable()` method.
type GetVariableRequest struct {
	// The name of the variable to return, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIBLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetVariableRequest) Reset()                    { *m = GetVariableRequest{} }
func (m *GetVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVariableRequest) ProtoMessage()               {}
func (*GetVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *GetVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `CreateVariable()` method.
type CreateVariableRequest struct {
	// The path to the RutimeConfig resource that this variable should belong to.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The variable to create.
	Variable *Variable `protobuf:"bytes,2,opt,name=variable" json:"variable,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *CreateVariableRequest) Reset()                    { *m = CreateVariableRequest{} }
func (m *CreateVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVariableRequest) ProtoMessage()               {}
func (*CreateVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *CreateVariableRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateVariableRequest) GetVariable() *Variable {
	if m != nil {
		return m.Variable
	}
	return nil
}

func (m *CreateVariableRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Request for the `UpdateVariable()` method.
type UpdateVariableRequest struct {
	// The name of the variable to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The variable to update.
	Variable *Variable `protobuf:"bytes,2,opt,name=variable" json:"variable,omitempty"`
}

func (m *UpdateVariableRequest) Reset()                    { *m = UpdateVariableRequest{} }
func (m *UpdateVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateVariableRequest) ProtoMessage()               {}
func (*UpdateVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *UpdateVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateVariableRequest) GetVariable() *Variable {
	if m != nil {
		return m.Variable
	}
	return nil
}

// Request for the `DeleteVariable()` method.
type DeleteVariableRequest struct {
	// The name of the variable to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Set to `true` to recursively delete multiple variables with the same
	// prefix.
	Recursive bool `protobuf:"varint,2,opt,name=recursive" json:"recursive,omitempty"`
}

func (m *DeleteVariableRequest) Reset()                    { *m = DeleteVariableRequest{} }
func (m *DeleteVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVariableRequest) ProtoMessage()               {}
func (*DeleteVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *DeleteVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteVariableRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

// Request for the `ListWaiters()` method.
type ListWaitersRequest struct {
	// The path to the configuration for which you want to get a list of waiters.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListWaitersRequest) Reset()                    { *m = ListWaitersRequest{} }
func (m *ListWaitersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListWaitersRequest) ProtoMessage()               {}
func (*ListWaitersRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *ListWaitersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListWaitersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListWaitersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListWaiters()` method.
// Order of returned waiter objects is arbitrary.
type ListWaitersResponse struct {
	// Found waiters in the project.
	Waiters []*Waiter `protobuf:"bytes,1,rep,name=waiters" json:"waiters,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListWaitersResponse) Reset()                    { *m = ListWaitersResponse{} }
func (m *ListWaitersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListWaitersResponse) ProtoMessage()               {}
func (*ListWaitersResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *ListWaitersResponse) GetWaiters() []*Waiter {
	if m != nil {
		return m.Waiters
	}
	return nil
}

func (m *ListWaitersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `GetWaiter()` method.
type GetWaiterRequest struct {
	// The fully-qualified name of the Waiter resource object to retrieve, in the
	// format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetWaiterRequest) Reset()                    { *m = GetWaiterRequest{} }
func (m *GetWaiterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetWaiterRequest) ProtoMessage()               {}
func (*GetWaiterRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *GetWaiterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for `CreateWaiter()` method.
type CreateWaiterRequest struct {
	// The path to the configuration that will own the waiter.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The Waiter resource to create.
	Waiter *Waiter `protobuf:"bytes,2,opt,name=waiter" json:"waiter,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *CreateWaiterRequest) Reset()                    { *m = CreateWaiterRequest{} }
func (m *CreateWaiterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateWaiterRequest) ProtoMessage()               {}
func (*CreateWaiterRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *CreateWaiterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateWaiterRequest) GetWaiter() *Waiter {
	if m != nil {
		return m.Waiter
	}
	return nil
}

func (m *CreateWaiterRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Request for the `DeleteWaiter()` method.
type DeleteWaiterRequest struct {
	// The Waiter resource to delete, in the format:
	//
	//  `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteWaiterRequest) Reset()                    { *m = DeleteWaiterRequest{} }
func (m *DeleteWaiterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteWaiterRequest) ProtoMessage()               {}
func (*DeleteWaiterRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *DeleteWaiterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*ListConfigsRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListConfigsRequest")
	proto.RegisterType((*ListConfigsResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListConfigsResponse")
	proto.RegisterType((*GetConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetConfigRequest")
	proto.RegisterType((*CreateConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateConfigRequest")
	proto.RegisterType((*UpdateConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.UpdateConfigRequest")
	proto.RegisterType((*DeleteConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteConfigRequest")
	proto.RegisterType((*ListVariablesRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListVariablesRequest")
	proto.RegisterType((*ListVariablesResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListVariablesResponse")
	proto.RegisterType((*WatchVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.WatchVariableRequest")
	proto.RegisterType((*GetVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetVariableRequest")
	proto.RegisterType((*CreateVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateVariableRequest")
	proto.RegisterType((*UpdateVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.UpdateVariableRequest")
	proto.RegisterType((*DeleteVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteVariableRequest")
	proto.RegisterType((*ListWaitersRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListWaitersRequest")
	proto.RegisterType((*ListWaitersResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListWaitersResponse")
	proto.RegisterType((*GetWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetWaiterRequest")
	proto.RegisterType((*CreateWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateWaiterRequest")
	proto.RegisterType((*DeleteWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteWaiterRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for RuntimeConfigManager service

type RuntimeConfigManagerClient interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
	// Lists variables within given a configuration, matching any provided filters.
	// This only lists variable names, not the values, unless `return_values` is
	// true, in which case only variables that user has IAM permission to
	// GetVariable will be returned.
	ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal timeout
	// (60 seconds), the current variable value is returned and the `variableState`
	// will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
}

type runtimeConfigManagerClient struct {
	cc *grpc.ClientConn
}

func NewRuntimeConfigManagerClient(cc *grpc.ClientConn) RuntimeConfigManagerClient {
	return &runtimeConfigManagerClient{cc}
}

func (c *runtimeConfigManagerClient) ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error) {
	out := new(ListConfigsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error) {
	out := new(ListVariablesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error) {
	out := new(ListWaitersResponse)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error) {
	out := new(Waiter)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for RuntimeConfigManager service

type RuntimeConfigManagerServer interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(context.Context, *ListConfigsRequest) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(context.Context, *GetConfigRequest) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(context.Context, *CreateConfigRequest) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(context.Context, *UpdateConfigRequest) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(context.Context, *DeleteConfigRequest) (*google_protobuf4.Empty, error)
	// Lists variables within given a configuration, matching any provided filters.
	// This only lists variable names, not the values, unless `return_values` is
	// true, in which case only variables that user has IAM permission to
	// GetVariable will be returned.
	ListVariables(context.Context, *ListVariablesRequest) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(context.Context, *GetVariableRequest) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal timeout
	// (60 seconds), the current variable value is returned and the `variableState`
	// will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(context.Context, *WatchVariableRequest) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(context.Context, *CreateVariableRequest) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(context.Context, *UpdateVariableRequest) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(context.Context, *DeleteVariableRequest) (*google_protobuf4.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(context.Context, *ListWaitersRequest) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(context.Context, *GetWaiterRequest) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(context.Context, *CreateWaiterRequest) (*google_longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(context.Context, *DeleteWaiterRequest) (*google_protobuf4.Empty, error)
}

func RegisterRuntimeConfigManagerServer(s *grpc.Server, srv RuntimeConfigManagerServer) {
	s.RegisterService(&_RuntimeConfigManager_serviceDesc, srv)
}

func _RuntimeConfigManager_ListConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, req.(*ListConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, req.(*CreateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, req.(*UpdateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, req.(*DeleteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListVariables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVariablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, req.(*ListVariablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, req.(*GetVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_WatchVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WatchVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, req.(*WatchVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, req.(*CreateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, req.(*UpdateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, req.(*DeleteVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListWaiters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWaitersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, req.(*ListWaitersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, req.(*GetWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, req.(*CreateWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, req.(*DeleteWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RuntimeConfigManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager",
	HandlerType: (*RuntimeConfigManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConfigs",
			Handler:    _RuntimeConfigManager_ListConfigs_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _RuntimeConfigManager_GetConfig_Handler,
		},
		{
			MethodName: "CreateConfig",
			Handler:    _RuntimeConfigManager_CreateConfig_Handler,
		},
		{
			MethodName: "UpdateConfig",
			Handler:    _RuntimeConfigManager_UpdateConfig_Handler,
		},
		{
			MethodName: "DeleteConfig",
			Handler:    _RuntimeConfigManager_DeleteConfig_Handler,
		},
		{
			MethodName: "ListVariables",
			Handler:    _RuntimeConfigManager_ListVariables_Handler,
		},
		{
			MethodName: "GetVariable",
			Handler:    _RuntimeConfigManager_GetVariable_Handler,
		},
		{
			MethodName: "WatchVariable",
			Handler:    _RuntimeConfigManager_WatchVariable_Handler,
		},
		{
			MethodName: "CreateVariable",
			Handler:    _RuntimeConfigManager_CreateVariable_Handler,
		},
		{
			MethodName: "UpdateVariable",
			Handler:    _RuntimeConfigManager_UpdateVariable_Handler,
		},
		{
			MethodName: "DeleteVariable",
			Handler:    _RuntimeConfigManager_DeleteVariable_Handler,
		},
		{
			MethodName: "ListWaiters",
			Handler:    _RuntimeConfigManager_ListWaiters_Handler,
		},
		{
			MethodName: "GetWaiter",
			Handler:    _RuntimeConfigManager_GetWaiter_Handler,
		},
		{
			MethodName: "CreateWaiter",
			Handler:    _RuntimeConfigManager_CreateWaiter_Handler,
		},
		{
			MethodName: "DeleteWaiter",
			Handler:    _RuntimeConfigManager_DeleteWaiter_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto",
}

func init() {
	proto.RegisterFile("google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 1144 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x98, 0x5b, 0x6f, 0xdc, 0x44,
	0x14, 0xc7, 0x35, 0x69, 0x9b, 0x66, 0x4f, 0x2e, 0xa0, 0xc9, 0x45, 0x91, 0xdb, 0x8a, 0xc8, 0x45,
	0x51, 0x58, 0x55, 0x76, 0x93, 0x56, 0x69, 0x12, 0x28, 0x0f, 0x49, 0x51, 0x08, 0x17, 0xb5, 0x32,
	0x21, 0x95, 0x78, 0x59, 0x4d, 0x36, 0x13, 0xc7, 0xb0, 0x3b, 0x36, 0xf6, 0x38, 0x81, 0xa2, 0xbc,
	0xc0, 0x1b, 0x08, 0x09, 0x89, 0x87, 0xf2, 0x84, 0x10, 0x12, 0x20, 0x21, 0x84, 0x78, 0xe2, 0x05,
	0xd1, 0x2f, 0x81, 0xc4, 0x27, 0xe0, 0x83, 0x20, 0xcf, 0xc5, 0x6b, 0x6f, 0xf6, 0x32, 0x0e, 0xe1,
	0x2d, 0x39, 0x9e, 0x73, 0xce, 0x6f, 0xce, 0x9c, 0x99, 0xff, 0xd1, 0xc2, 0xaa, 0x1f, 0x86, 0x7e,
	0x8b, 0xba, 0xcd, 0x56, 0x98, 0x1e, 0xb8, 0x71, 0xca, 0x78, 0xd0, 0xa6, 0xcd, 0x90, 0x1d, 0x06,
	0xbe, 0x7b, 0xbc, 0xbc, 0x4f, 0x39, 0x59, 0x2e, 0x5b, 0x9d, 0x28, 0x0e, 0x79, 0x88, 0x6d, 0xe9,
	0xe7, 0x08, 0x3f, 0xa7, 0xbc, 0x42, 0xf9, 0x59, 0xd7, 0x55, 0x6c, 0x12, 0x05, 0x2e, 0x61, 0x2c,
	0xe4, 0x84, 0x07, 0x21, 0x4b, 0x64, 0x04, 0x6b, 0xc5, 0x24, 0x33, 0x4d, 0xc2, 0x34, 0x6e, 0x52,
	0xed, 0x73, 0x53, 0xf9, 0xb4, 0x42, 0xe6, 0xc7, 0x29, 0x63, 0x01, 0xf3, 0xdd, 0x30, 0xa2, 0x71,
	0x29, 0xf0, 0x35, 0xb5, 0x48, 0xfc, 0xb7, 0x9f, 0x1e, 0xba, 0xb4, 0x1d, 0xf1, 0x8f, 0xd5, 0xc7,
	0x17, 0xba, 0x3f, 0x66, 0x59, 0x13, 0x4e, 0xda, 0x91, 0x5c, 0x60, 0x1f, 0x01, 0x7e, 0x2b, 0x48,
	0xf8, 0x96, 0x00, 0x49, 0x3c, 0xfa, 0x61, 0x4a, 0x13, 0x8e, 0xe7, 0x60, 0x34, 0x22, 0x31, 0x65,
	0x7c, 0x1e, 0x2d, 0xa0, 0xa5, 0x9a, 0xa7, 0xfe, 0xc3, 0xd7, 0xa0, 0x16, 0x11, 0x9f, 0x36, 0x92,
	0xe0, 0x09, 0x9d, 0x1f, 0x59, 0x40, 0x4b, 0x57, 0xbc, 0xb1, 0xcc, 0xf0, 0x4e, 0xf0, 0x84, 0xe2,
	0x1b, 0x00, 0xe2, 0x23, 0x0f, 0x3f, 0xa0, 0x6c, 0xfe, 0x92, 0x70, 0x14, 0xcb, 0x77, 0x33, 0x83,
	0xfd, 0x39, 0x82, 0xe9, 0x52, 0xaa, 0x24, 0x0a, 0x59, 0x42, 0xf1, 0x9b, 0x70, 0x55, 0x96, 0x21,
	0x99, 0x47, 0x0b, 0x97, 0x96, 0xc6, 0x57, 0x96, 0x9d, 0xe1, 0xc5, 0x76, 0x3c, 0x69, 0x95, 0xc1,
	0x3c, 0x1d, 0x01, 0x2f, 0xc2, 0x73, 0x8c, 0x7e, 0xc4, 0x1b, 0x05, 0x90, 0x11, 0x01, 0x32, 0x99,
	0x99, 0x1f, 0xe5, 0x30, 0x8b, 0xf0, 0xfc, 0x36, 0x55, 0x28, 0x7a, 0xd3, 0x18, 0x2e, 0x33, 0xd2,
	0xa6, 0xca, 0x41, 0xfc, 0x6d, 0x3f, 0x45, 0x30, 0xbd, 0x15, 0x53, 0xc2, 0x69, 0x79, 0x6d, 0xbf,
	0x02, 0xed, 0xc0, 0xa8, 0x44, 0x11, 0x51, 0xce, 0xb5, 0x17, 0x15, 0x20, 0x2b, 0x67, 0x2c, 0xb3,
	0x35, 0x82, 0x03, 0x5d, 0x4e, 0x65, 0xd9, 0x39, 0xb0, 0x39, 0x4c, 0xbf, 0x1b, 0x1d, 0x9c, 0x01,
	0xd3, 0x9b, 0x40, 0x9d, 0x4d, 0x5c, 0x20, 0x94, 0xfd, 0x12, 0x4c, 0x3f, 0xa0, 0x2d, 0x6a, 0x90,
	0xd5, 0xfe, 0x09, 0xc1, 0x4c, 0x76, 0xde, 0x7b, 0x24, 0x0e, 0xc8, 0x7e, 0x8b, 0x0e, 0x6d, 0xae,
	0x39, 0x18, 0x3d, 0x0c, 0x5a, 0x9c, 0xc6, 0xea, 0x04, 0xd4, 0x7f, 0xe5, 0xa6, 0xbb, 0x34, 0xb0,
	0xe9, 0x2e, 0x77, 0x35, 0x1d, 0xbe, 0x09, 0x93, 0x31, 0xe5, 0x69, 0xcc, 0x1a, 0xc7, 0xa4, 0x95,
	0xd2, 0x64, 0xfe, 0xca, 0x02, 0x5a, 0x1a, 0xf3, 0x26, 0xa4, 0x71, 0x4f, 0xd8, 0xec, 0x2f, 0x10,
	0xcc, 0x76, 0x91, 0xaa, 0xde, 0x7c, 0x03, 0x6a, 0xc7, 0xda, 0xa8, 0xba, 0xf3, 0x96, 0x49, 0xf1,
	0x74, 0x24, 0xaf, 0xe3, 0x6e, 0xdc, 0x9a, 0x14, 0x66, 0x1e, 0x13, 0xde, 0x3c, 0xca, 0x63, 0x0c,
	0x38, 0xd9, 0x75, 0x00, 0x46, 0x4f, 0x68, 0xdc, 0xe0, 0x47, 0x44, 0xee, 0x7e, 0x7c, 0xc5, 0xd2,
	0x80, 0xfa, 0xce, 0x3b, 0xbb, 0xfa, 0xce, 0x7b, 0x35, 0xb1, 0x7a, 0xf7, 0x88, 0x30, 0x7b, 0x09,
	0xf0, 0x36, 0xe5, 0x06, 0x49, 0xec, 0x6f, 0x10, 0xcc, 0xca, 0x3b, 0xd0, 0xbd, 0xba, 0xdf, 0x49,
	0xbe, 0x0e, 0x63, 0x7a, 0xdf, 0xaa, 0xe5, 0xaa, 0x55, 0x2d, 0xf7, 0x1e, 0x76, 0x09, 0x52, 0x98,
	0x95, 0x97, 0xc0, 0xa4, 0x58, 0x17, 0x46, 0x65, 0xef, 0xc0, 0xac, 0xbc, 0x05, 0x26, 0x69, 0xaf,
	0x43, 0x2d, 0xa6, 0xcd, 0x34, 0x4e, 0x82, 0x63, 0x99, 0x77, 0xcc, 0xeb, 0x18, 0xf4, 0xfb, 0xfb,
	0x98, 0x04, 0x9c, 0xc6, 0xff, 0xeb, 0xfb, 0xfb, 0x99, 0x7a, 0x7f, 0xf3, 0x54, 0xaa, 0xc7, 0x1f,
	0xc0, 0xd5, 0x13, 0x69, 0x52, 0x1d, 0x5e, 0x37, 0xa9, 0x8a, 0x8c, 0xe2, 0x69, 0xd7, 0x8a, 0x0f,
	0xaf, 0xf2, 0x1e, 0xd0, 0x74, 0x5f, 0xe5, 0x0f, 0x6f, 0x79, 0x6d, 0xbf, 0xca, 0x6c, 0xc2, 0xa8,
	0x44, 0x51, 0x47, 0x5b, 0x65, 0x13, 0xca, 0x73, 0x58, 0xb3, 0xe5, 0x6f, 0xdf, 0x50, 0xfa, 0x95,
	0xbf, 0x67, 0x60, 0xa6, 0xf4, 0x80, 0xbe, 0x4d, 0x18, 0xf1, 0x69, 0x8c, 0x7f, 0x41, 0x30, 0x5e,
	0x10, 0x41, 0xbc, 0x6a, 0x82, 0x79, 0x56, 0xa0, 0xad, 0x7b, 0x95, 0xfd, 0xe4, 0x69, 0xdb, 0xb7,
	0x3e, 0xfd, 0xeb, 0x9f, 0xaf, 0x47, 0x16, 0xf1, 0x8b, 0xf9, 0xd0, 0xf1, 0x89, 0xac, 0xe0, 0xfd,
	0x28, 0x0e, 0xdf, 0xa7, 0x4d, 0x9e, 0xb8, 0xf5, 0x53, 0x57, 0xcb, 0xe9, 0xf7, 0x08, 0x6a, 0xb9,
	0x4e, 0xe2, 0xbb, 0x26, 0x49, 0xbb, 0x65, 0xd5, 0xaa, 0xae, 0x36, 0xbd, 0x20, 0xb3, 0xb2, 0x16,
	0x10, 0x35, 0xa1, 0x5b, 0x3f, 0xc5, 0xbf, 0x21, 0x98, 0x28, 0x6a, 0x34, 0x36, 0x2a, 0x4e, 0x0f,
	0x55, 0x3f, 0x0f, 0xea, 0x5d, 0x81, 0xea, 0xd8, 0x46, 0xf5, 0xdc, 0xd0, 0xda, 0x9e, 0x21, 0x17,
	0xd5, 0xdb, 0x0c, 0xb9, 0x87, 0xde, 0xff, 0x07, 0x64, 0xcb, 0xa8, 0xba, 0x39, 0xf2, 0x97, 0x08,
	0x26, 0x8a, 0xd2, 0x6f, 0x86, 0xdc, 0x63, 0x58, 0xb0, 0xe6, 0xce, 0x08, 0xd4, 0x6b, 0xd9, 0xc4,
	0xaa, 0x4f, 0xbd, 0x6e, 0x76, 0xea, 0xcf, 0x10, 0x4c, 0x96, 0x44, 0x1b, 0xaf, 0x99, 0xde, 0x89,
	0xee, 0x89, 0xc4, 0x5a, 0x3f, 0x87, 0xa7, 0xba, 0x4f, 0x6b, 0x02, 0x7a, 0x05, 0xdf, 0x1e, 0x70,
	0xfe, 0x05, 0x6c, 0xb7, 0x33, 0x0f, 0xfc, 0x8a, 0x60, 0xbc, 0xa0, 0xc0, 0x66, 0x4f, 0xc1, 0x59,
	0xc9, 0xb6, 0x2a, 0x89, 0x98, 0xbd, 0x2e, 0x78, 0xef, 0xe0, 0x65, 0x83, 0x22, 0x77, 0x60, 0xdd,
	0x7a, 0xfd, 0x14, 0xff, 0x81, 0x60, 0xb2, 0x34, 0x99, 0x98, 0x55, 0xbc, 0xd7, 0x30, 0x53, 0x11,
	0x7a, 0x53, 0x40, 0xbf, 0x62, 0xdf, 0xab, 0x0c, 0xbd, 0x71, 0x92, 0x65, 0xdf, 0x40, 0x75, 0xfc,
	0x27, 0x82, 0xa9, 0xf2, 0x14, 0x83, 0xd7, 0xcd, 0xdf, 0x89, 0x8b, 0xe1, 0xaf, 0xdc, 0x24, 0x1b,
	0x9d, 0x49, 0xe8, 0x19, 0x82, 0xa9, 0xf2, 0xac, 0x63, 0xc6, 0xdf, 0x73, 0x3e, 0xaa, 0xc8, 0xbf,
	0x25, 0xf8, 0xef, 0x5b, 0xd5, 0x9b, 0xa6, 0xb0, 0x81, 0x6f, 0x11, 0x4c, 0x95, 0xa7, 0x26, 0xb3,
	0x0d, 0xf4, 0x9c, 0xb4, 0xfa, 0x3e, 0x22, 0xaa, 0xbf, 0xeb, 0xe7, 0xe8, 0xef, 0xdf, 0x95, 0x36,
	0xab, 0x01, 0xc9, 0x5c, 0x9b, 0xcb, 0xc3, 0x9b, 0xb9, 0x36, 0x77, 0x4d, 0x62, 0xf6, 0xaa, 0x60,
	0xbf, 0x8d, 0x1d, 0xc3, 0x36, 0xd1, 0xb3, 0xd7, 0x0f, 0x52, 0xa5, 0x65, 0x38, 0x63, 0x95, 0x2e,
	0x4d, 0x31, 0x56, 0x85, 0x79, 0xa9, 0x17, 0x67, 0xff, 0x1a, 0x2b, 0xc8, 0xec, 0xc9, 0xfe, 0x31,
	0x17, 0x6a, 0x85, 0x5a, 0x41, 0xa8, 0xcb, 0xb4, 0x37, 0xb4, 0x63, 0xe1, 0x97, 0x11, 0xe7, 0xa1,
	0xfe, 0x65, 0xc4, 0x7e, 0x55, 0x00, 0xae, 0xd9, 0x15, 0x0b, 0xb9, 0xa1, 0x07, 0xc1, 0xa7, 0xb9,
	0xd6, 0x55, 0x01, 0xed, 0x31, 0x1c, 0xf6, 0x6d, 0x53, 0x55, 0xc2, 0x7a, 0xc5, 0x12, 0x6e, 0x7e,
	0x87, 0x60, 0xb1, 0x19, 0xb6, 0x0d, 0x70, 0x1e, 0xa1, 0xf7, 0x1e, 0xaa, 0x55, 0x7e, 0xd8, 0x22,
	0xcc, 0x77, 0xc2, 0xd8, 0x77, 0x7d, 0xca, 0x04, 0x89, 0x2b, 0x3f, 0x91, 0x28, 0x48, 0x06, 0xfd,
	0x22, 0xf5, 0x72, 0xc9, 0xfa, 0xf3, 0x88, 0xbd, 0x2d, 0x23, 0x6e, 0x89, 0xbc, 0xa5, 0xb1, 0xc2,
	0xd9, 0x5b, 0xde, 0xcc, 0x5c, 0xf6, 0x47, 0x45, 0x82, 0x3b, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff,
	0xdb, 0xa7, 0xdc, 0xe8, 0x6b, 0x13, 0x00, 0x00,
}
