// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/service/waf"
)

const opAssociateWebACL = "AssociateWebACL"

// AssociateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWebACL for more information on using the AssociateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateWebACLRequest method.
//    req, resp := client.AssociateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACL
func (c *WAFRegional) AssociateWebACLRequest(input *AssociateWebACLInput) (req *request.Request, output *AssociateWebACLOutput) {
	op := &request.Operation{
		Name:       opAssociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateWebACLInput{}
	}

	output = &AssociateWebACLOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateWebACL API operation for AWS WAF Regional.
//
// Associates a web ACL with a resource, either an application load balancer
// or Amazon API Gateway stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation AssociateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFUnavailableEntityException "WAFUnavailableEntityException"
//   The operation failed because the entity referenced is temporarily unavailable.
//   Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACL
func (c *WAFRegional) AssociateWebACL(input *AssociateWebACLInput) (*AssociateWebACLOutput, error) {
	req, out := c.AssociateWebACLRequest(input)
	return out, req.Send()
}

// AssociateWebACLWithContext is the same as AssociateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) AssociateWebACLWithContext(ctx aws.Context, input *AssociateWebACLInput, opts ...request.Option) (*AssociateWebACLOutput, error) {
	req, out := c.AssociateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateByteMatchSet = "CreateByteMatchSet"

// CreateByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateByteMatchSet for more information on using the CreateByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateByteMatchSetRequest method.
//    req, resp := client.CreateByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateByteMatchSet
func (c *WAFRegional) CreateByteMatchSetRequest(input *waf.CreateByteMatchSetInput) (req *request.Request, output *waf.CreateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateByteMatchSetInput{}
	}

	output = &waf.CreateByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateByteMatchSet API operation for AWS WAF Regional.
//
// Creates a ByteMatchSet. You then use UpdateByteMatchSet to identify the part
// of a web request that you want AWS WAF to inspect, such as the values of
// the User-Agent header or the query string. For example, you can create a
// ByteMatchSet that matches any requests with User-Agent headers that contain
// the string BadBot. You can then configure AWS WAF to reject those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateByteMatchSet request.
//
// Submit a CreateByteMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request.
//
// Submit an UpdateByteMatchSet request to specify the part of the request that
// you want AWS WAF to inspect (for example, the header or the URI) and the
// value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateByteMatchSet
func (c *WAFRegional) CreateByteMatchSet(input *waf.CreateByteMatchSetInput) (*waf.CreateByteMatchSetOutput, error) {
	req, out := c.CreateByteMatchSetRequest(input)
	return out, req.Send()
}

// CreateByteMatchSetWithContext is the same as CreateByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateByteMatchSetWithContext(ctx aws.Context, input *waf.CreateByteMatchSetInput, opts ...request.Option) (*waf.CreateByteMatchSetOutput, error) {
	req, out := c.CreateByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGeoMatchSet = "CreateGeoMatchSet"

// CreateGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGeoMatchSet for more information on using the CreateGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGeoMatchSetRequest method.
//    req, resp := client.CreateGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateGeoMatchSet
func (c *WAFRegional) CreateGeoMatchSetRequest(input *waf.CreateGeoMatchSetInput) (req *request.Request, output *waf.CreateGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateGeoMatchSetInput{}
	}

	output = &waf.CreateGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGeoMatchSet API operation for AWS WAF Regional.
//
// Creates an GeoMatchSet, which you use to specify which web requests you want
// to allow or block based on the country that the requests originate from.
// For example, if you're receiving a lot of requests from one or more countries
// and you want to block the requests, you can create an GeoMatchSet that contains
// those countries and then configure AWS WAF to block the requests.
//
// To create and configure a GeoMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateGeoMatchSet request.
//
// Submit a CreateGeoMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateGeoMatchSet request.
//
// Submit an UpdateGeoMatchSetSet request to specify the countries that you
// want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateGeoMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateGeoMatchSet
func (c *WAFRegional) CreateGeoMatchSet(input *waf.CreateGeoMatchSetInput) (*waf.CreateGeoMatchSetOutput, error) {
	req, out := c.CreateGeoMatchSetRequest(input)
	return out, req.Send()
}

// CreateGeoMatchSetWithContext is the same as CreateGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateGeoMatchSetWithContext(ctx aws.Context, input *waf.CreateGeoMatchSetInput, opts ...request.Option) (*waf.CreateGeoMatchSetOutput, error) {
	req, out := c.CreateGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIPSet = "CreateIPSet"

// CreateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIPSet for more information on using the CreateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIPSetRequest method.
//    req, resp := client.CreateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateIPSet
func (c *WAFRegional) CreateIPSetRequest(input *waf.CreateIPSetInput) (req *request.Request, output *waf.CreateIPSetOutput) {
	op := &request.Operation{
		Name:       opCreateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateIPSetInput{}
	}

	output = &waf.CreateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIPSet API operation for AWS WAF Regional.
//
// Creates an IPSet, which you use to specify which web requests that you want
// to allow or block based on the IP addresses that the requests originate from.
// For example, if you're receiving a lot of requests from one or more individual
// IP addresses or one or more ranges of IP addresses and you want to block
// the requests, you can create an IPSet that contains those IP addresses and
// then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateIPSet request.
//
// Submit a CreateIPSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateIPSet request to specify the IP addresses that you want AWS
// WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateIPSet
func (c *WAFRegional) CreateIPSet(input *waf.CreateIPSetInput) (*waf.CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	return out, req.Send()
}

// CreateIPSetWithContext is the same as CreateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateIPSetWithContext(ctx aws.Context, input *waf.CreateIPSetInput, opts ...request.Option) (*waf.CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRateBasedRule = "CreateRateBasedRule"

// CreateRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRateBasedRule for more information on using the CreateRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRateBasedRuleRequest method.
//    req, resp := client.CreateRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRateBasedRule
func (c *WAFRegional) CreateRateBasedRuleRequest(input *waf.CreateRateBasedRuleInput) (req *request.Request, output *waf.CreateRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateRateBasedRuleInput{}
	}

	output = &waf.CreateRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRateBasedRule API operation for AWS WAF Regional.
//
// Creates a RateBasedRule. The RateBasedRule contains a RateLimit, which specifies
// the maximum number of requests that AWS WAF allows from a specified IP address
// in a five-minute period. The RateBasedRule also contains the IPSet objects,
// ByteMatchSet objects, and other predicates that identify the requests that
// you want to count or block if these requests exceed the RateLimit.
//
// If you add more than one predicate to a RateBasedRule, a request not only
// must exceed the RateLimit, but it also must match all the specifications
// to be counted or blocked. For example, suppose you add the following to a
// RateBasedRule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// Further, you specify a RateLimit of 15,000.
//
// You then add the RateBasedRule to a WebACL and specify that you want to block
// requests that meet the conditions in the rule. For a request to be blocked,
// it must come from the IP address 192.0.2.44 and the User-Agent header in
// the request must contain the value BadBot. Further, requests that match these
// two conditions must be received at a rate of more than 15,000 requests every
// five minutes. If both conditions are met and the rate is exceeded, AWS WAF
// blocks the requests. If the rate drops below 15,000 for a five-minute period,
// AWS WAF no longer blocks the requests.
//
// As a second example, suppose you want to limit requests to a particular page
// on your site. To do this, you could add the following to a RateBasedRule:
//
//    * A ByteMatchSet with FieldToMatch of URI
//
//    * A PositionalConstraint of STARTS_WITH
//
//    * A TargetString of login
//
// Further, you specify a RateLimit of 15,000.
//
// By adding this RateBasedRule to a WebACL, you could limit requests to your
// login page without affecting the rest of your site.
//
// To create and configure a RateBasedRule, perform the following steps:
//
// Create and update the predicates that you want to include in the rule. For
// more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRule request.
//
// Submit a CreateRateBasedRule request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRateBasedRule request to specify the predicates that you
// want to include in the rule.
//
// Create and update a WebACL that contains the RateBasedRule. For more information,
// see CreateWebACL.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateRateBasedRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRateBasedRule
func (c *WAFRegional) CreateRateBasedRule(input *waf.CreateRateBasedRuleInput) (*waf.CreateRateBasedRuleOutput, error) {
	req, out := c.CreateRateBasedRuleRequest(input)
	return out, req.Send()
}

// CreateRateBasedRuleWithContext is the same as CreateRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateRateBasedRuleWithContext(ctx aws.Context, input *waf.CreateRateBasedRuleInput, opts ...request.Option) (*waf.CreateRateBasedRuleOutput, error) {
	req, out := c.CreateRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRegexMatchSet = "CreateRegexMatchSet"

// CreateRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRegexMatchSet for more information on using the CreateRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRegexMatchSetRequest method.
//    req, resp := client.CreateRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRegexMatchSet
func (c *WAFRegional) CreateRegexMatchSetRequest(input *waf.CreateRegexMatchSetInput) (req *request.Request, output *waf.CreateRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateRegexMatchSetInput{}
	}

	output = &waf.CreateRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRegexMatchSet API operation for AWS WAF Regional.
//
// Creates a RegexMatchSet. You then use UpdateRegexMatchSet to identify the
// part of a web request that you want AWS WAF to inspect, such as the values
// of the User-Agent header or the query string. For example, you can create
// a RegexMatchSet that contains a RegexMatchTuple that looks for any requests
// with User-Agent headers that match a RegexPatternSet with pattern B[a@]dB[o0]t.
// You can then configure AWS WAF to reject those requests.
//
// To create and configure a RegexMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRegexMatchSet request.
//
// Submit a CreateRegexMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexMatchSet request.
//
// Submit an UpdateRegexMatchSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value, using a RegexPatternSet, that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateRegexMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRegexMatchSet
func (c *WAFRegional) CreateRegexMatchSet(input *waf.CreateRegexMatchSetInput) (*waf.CreateRegexMatchSetOutput, error) {
	req, out := c.CreateRegexMatchSetRequest(input)
	return out, req.Send()
}

// CreateRegexMatchSetWithContext is the same as CreateRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateRegexMatchSetWithContext(ctx aws.Context, input *waf.CreateRegexMatchSetInput, opts ...request.Option) (*waf.CreateRegexMatchSetOutput, error) {
	req, out := c.CreateRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRegexPatternSet = "CreateRegexPatternSet"

// CreateRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRegexPatternSet for more information on using the CreateRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRegexPatternSetRequest method.
//    req, resp := client.CreateRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRegexPatternSet
func (c *WAFRegional) CreateRegexPatternSetRequest(input *waf.CreateRegexPatternSetInput) (req *request.Request, output *waf.CreateRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opCreateRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateRegexPatternSetInput{}
	}

	output = &waf.CreateRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRegexPatternSet API operation for AWS WAF Regional.
//
// Creates a RegexPatternSet. You then use UpdateRegexPatternSet to specify
// the regular expression (regex) pattern that you want AWS WAF to search for,
// such as B[a@]dB[o0]t. You can then configure AWS WAF to reject those requests.
//
// To create and configure a RegexPatternSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRegexPatternSet request.
//
// Submit a CreateRegexPatternSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexPatternSet request.
//
// Submit an UpdateRegexPatternSet request to specify the string that you want
// AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateRegexPatternSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRegexPatternSet
func (c *WAFRegional) CreateRegexPatternSet(input *waf.CreateRegexPatternSetInput) (*waf.CreateRegexPatternSetOutput, error) {
	req, out := c.CreateRegexPatternSetRequest(input)
	return out, req.Send()
}

// CreateRegexPatternSetWithContext is the same as CreateRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateRegexPatternSetWithContext(ctx aws.Context, input *waf.CreateRegexPatternSetInput, opts ...request.Option) (*waf.CreateRegexPatternSetOutput, error) {
	req, out := c.CreateRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleRequest method.
//    req, resp := client.CreateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRule
func (c *WAFRegional) CreateRuleRequest(input *waf.CreateRuleInput) (req *request.Request, output *waf.CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateRuleInput{}
	}

	output = &waf.CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for AWS WAF Regional.
//
// Creates a Rule, which contains the IPSet objects, ByteMatchSet objects, and
// other predicates that identify the requests that you want to block. If you
// add more than one predicate to a Rule, a request must match all of the specifications
// to be allowed or blocked. For example, suppose that you add the following
// to a Rule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// You then add the Rule to a WebACL and specify that you want to blocks requests
// that satisfy the Rule. For a request to be blocked, it must come from the
// IP address 192.0.2.44 and the User-Agent header in the request must contain
// the value BadBot.
//
// To create and configure a Rule, perform the following steps:
//
// Create and update the predicates that you want to include in the Rule. For
// more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRule request.
//
// Submit a CreateRule request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRule request to specify the predicates that you want to include
// in the Rule.
//
// Create and update a WebACL that contains the Rule. For more information,
// see CreateWebACL.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRule
func (c *WAFRegional) CreateRule(input *waf.CreateRuleInput) (*waf.CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateRuleWithContext(ctx aws.Context, input *waf.CreateRuleInput, opts ...request.Option) (*waf.CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRuleGroup = "CreateRuleGroup"

// CreateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRuleGroup for more information on using the CreateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleGroupRequest method.
//    req, resp := client.CreateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRuleGroup
func (c *WAFRegional) CreateRuleGroupRequest(input *waf.CreateRuleGroupInput) (req *request.Request, output *waf.CreateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opCreateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateRuleGroupInput{}
	}

	output = &waf.CreateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRuleGroup API operation for AWS WAF Regional.
//
// Creates a RuleGroup. A rule group is a collection of predefined rules that
// you add to a web ACL. You use UpdateRuleGroup to add rules to the rule group.
//
// Rule groups are subject to the following limits:
//
//    * Three rule groups per account. You can request an increase to this limit
//    by contacting customer support.
//
//    * One rule group per web ACL.
//
//    * Ten rules per rule group.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateRuleGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRuleGroup
func (c *WAFRegional) CreateRuleGroup(input *waf.CreateRuleGroupInput) (*waf.CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	return out, req.Send()
}

// CreateRuleGroupWithContext is the same as CreateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateRuleGroupWithContext(ctx aws.Context, input *waf.CreateRuleGroupInput, opts ...request.Option) (*waf.CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSizeConstraintSet = "CreateSizeConstraintSet"

// CreateSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSizeConstraintSet for more information on using the CreateSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSizeConstraintSetRequest method.
//    req, resp := client.CreateSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSizeConstraintSet
func (c *WAFRegional) CreateSizeConstraintSetRequest(input *waf.CreateSizeConstraintSetInput) (req *request.Request, output *waf.CreateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opCreateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateSizeConstraintSetInput{}
	}

	output = &waf.CreateSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSizeConstraintSet API operation for AWS WAF Regional.
//
// Creates a SizeConstraintSet. You then use UpdateSizeConstraintSet to identify
// the part of a web request that you want AWS WAF to check for length, such
// as the length of the User-Agent header or the length of the query string.
// For example, you can create a SizeConstraintSet that matches any requests
// that have a query string that is longer than 100 bytes. You can then configure
// AWS WAF to reject those requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSizeConstraintSet request.
//
// Submit a CreateSizeConstraintSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSizeConstraintSet request.
//
// Submit an UpdateSizeConstraintSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSizeConstraintSet
func (c *WAFRegional) CreateSizeConstraintSet(input *waf.CreateSizeConstraintSetInput) (*waf.CreateSizeConstraintSetOutput, error) {
	req, out := c.CreateSizeConstraintSetRequest(input)
	return out, req.Send()
}

// CreateSizeConstraintSetWithContext is the same as CreateSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateSizeConstraintSetWithContext(ctx aws.Context, input *waf.CreateSizeConstraintSetInput, opts ...request.Option) (*waf.CreateSizeConstraintSetOutput, error) {
	req, out := c.CreateSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSqlInjectionMatchSet = "CreateSqlInjectionMatchSet"

// CreateSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSqlInjectionMatchSet for more information on using the CreateSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSqlInjectionMatchSetRequest method.
//    req, resp := client.CreateSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSqlInjectionMatchSet
func (c *WAFRegional) CreateSqlInjectionMatchSetRequest(input *waf.CreateSqlInjectionMatchSetInput) (req *request.Request, output *waf.CreateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateSqlInjectionMatchSetInput{}
	}

	output = &waf.CreateSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Creates a SqlInjectionMatchSet, which you use to allow, block, or count requests
// that contain snippets of SQL code in a specified part of web requests. AWS
// WAF searches for character sequences that are likely to be malicious strings.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSqlInjectionMatchSet request.
//
// Submit a CreateSqlInjectionMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSqlInjectionMatchSet request.
//
// Submit an UpdateSqlInjectionMatchSet request to specify the parts of web
// requests in which you want to allow, block, or count malicious SQL code.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSqlInjectionMatchSet
func (c *WAFRegional) CreateSqlInjectionMatchSet(input *waf.CreateSqlInjectionMatchSetInput) (*waf.CreateSqlInjectionMatchSetOutput, error) {
	req, out := c.CreateSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// CreateSqlInjectionMatchSetWithContext is the same as CreateSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.CreateSqlInjectionMatchSetInput, opts ...request.Option) (*waf.CreateSqlInjectionMatchSetOutput, error) {
	req, out := c.CreateSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebACL = "CreateWebACL"

// CreateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the CreateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWebACL for more information on using the CreateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWebACLRequest method.
//    req, resp := client.CreateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateWebACL
func (c *WAFRegional) CreateWebACLRequest(input *waf.CreateWebACLInput) (req *request.Request, output *waf.CreateWebACLOutput) {
	op := &request.Operation{
		Name:       opCreateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateWebACLInput{}
	}

	output = &waf.CreateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWebACL API operation for AWS WAF Regional.
//
// Creates a WebACL, which contains the Rules that identify the CloudFront web
// requests that you want to allow, block, or count. AWS WAF evaluates Rules
// in order based on the value of Priority for each Rule.
//
// You also specify a default action, either ALLOW or BLOCK. If a web request
// doesn't match any of the Rules in a WebACL, AWS WAF responds to the request
// with the default action.
//
// To create and configure a WebACL, perform the following steps:
//
// Create and update the ByteMatchSet objects and other predicates that you
// want to include in Rules. For more information, see CreateByteMatchSet, UpdateByteMatchSet,
// CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
//
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateWebACL request.
//
// Submit a CreateWebACL request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateWebACL request.
//
// Submit an UpdateWebACL request to specify the Rules that you want to include
// in the WebACL, to specify the default action, and to associate the WebACL
// with a CloudFront distribution.
//
// For more information about how to use the AWS WAF API, see the AWS WAF Developer
// Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateWebACL
func (c *WAFRegional) CreateWebACL(input *waf.CreateWebACLInput) (*waf.CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	return out, req.Send()
}

// CreateWebACLWithContext is the same as CreateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateWebACLWithContext(ctx aws.Context, input *waf.CreateWebACLInput, opts ...request.Option) (*waf.CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateXssMatchSet = "CreateXssMatchSet"

// CreateXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateXssMatchSet for more information on using the CreateXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateXssMatchSetRequest method.
//    req, resp := client.CreateXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateXssMatchSet
func (c *WAFRegional) CreateXssMatchSetRequest(input *waf.CreateXssMatchSetInput) (req *request.Request, output *waf.CreateXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateXssMatchSetInput{}
	}

	output = &waf.CreateXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateXssMatchSet API operation for AWS WAF Regional.
//
// Creates an XssMatchSet, which you use to allow, block, or count requests
// that contain cross-site scripting attacks in the specified part of web requests.
// AWS WAF searches for character sequences that are likely to be malicious
// strings.
//
// To create and configure an XssMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateXssMatchSet request.
//
// Submit a CreateXssMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateXssMatchSet request.
//
// Submit an UpdateXssMatchSet request to specify the parts of web requests
// in which you want to allow, block, or count cross-site scripting attacks.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateXssMatchSet
func (c *WAFRegional) CreateXssMatchSet(input *waf.CreateXssMatchSetInput) (*waf.CreateXssMatchSetOutput, error) {
	req, out := c.CreateXssMatchSetRequest(input)
	return out, req.Send()
}

// CreateXssMatchSetWithContext is the same as CreateXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateXssMatchSetWithContext(ctx aws.Context, input *waf.CreateXssMatchSetInput, opts ...request.Option) (*waf.CreateXssMatchSetOutput, error) {
	req, out := c.CreateXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteByteMatchSet = "DeleteByteMatchSet"

// DeleteByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteByteMatchSet for more information on using the DeleteByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteByteMatchSetRequest method.
//    req, resp := client.DeleteByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteByteMatchSet
func (c *WAFRegional) DeleteByteMatchSetRequest(input *waf.DeleteByteMatchSetInput) (req *request.Request, output *waf.DeleteByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteByteMatchSetInput{}
	}

	output = &waf.DeleteByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteByteMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes a ByteMatchSet. You can't delete a ByteMatchSet if it's
// still used in any Rules or if it still includes any ByteMatchTuple objects
// (any filters).
//
// If you just want to remove a ByteMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a ByteMatchSet, perform the following steps:
//
// Update the ByteMatchSet to remove filters, if any. For more information,
// see UpdateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteByteMatchSet request.
//
// Submit a DeleteByteMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteByteMatchSet
func (c *WAFRegional) DeleteByteMatchSet(input *waf.DeleteByteMatchSetInput) (*waf.DeleteByteMatchSetOutput, error) {
	req, out := c.DeleteByteMatchSetRequest(input)
	return out, req.Send()
}

// DeleteByteMatchSetWithContext is the same as DeleteByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteByteMatchSetWithContext(ctx aws.Context, input *waf.DeleteByteMatchSetInput, opts ...request.Option) (*waf.DeleteByteMatchSetOutput, error) {
	req, out := c.DeleteByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGeoMatchSet = "DeleteGeoMatchSet"

// DeleteGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGeoMatchSet for more information on using the DeleteGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGeoMatchSetRequest method.
//    req, resp := client.DeleteGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteGeoMatchSet
func (c *WAFRegional) DeleteGeoMatchSetRequest(input *waf.DeleteGeoMatchSetInput) (req *request.Request, output *waf.DeleteGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteGeoMatchSetInput{}
	}

	output = &waf.DeleteGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGeoMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes a GeoMatchSet. You can't delete a GeoMatchSet if it's
// still used in any Rules or if it still includes any countries.
//
// If you just want to remove a GeoMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a GeoMatchSet from AWS WAF, perform the following steps:
//
// Update the GeoMatchSet to remove any countries. For more information, see
// UpdateGeoMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteGeoMatchSet request.
//
// Submit a DeleteGeoMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteGeoMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteGeoMatchSet
func (c *WAFRegional) DeleteGeoMatchSet(input *waf.DeleteGeoMatchSetInput) (*waf.DeleteGeoMatchSetOutput, error) {
	req, out := c.DeleteGeoMatchSetRequest(input)
	return out, req.Send()
}

// DeleteGeoMatchSetWithContext is the same as DeleteGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteGeoMatchSetWithContext(ctx aws.Context, input *waf.DeleteGeoMatchSetInput, opts ...request.Option) (*waf.DeleteGeoMatchSetOutput, error) {
	req, out := c.DeleteGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIPSet = "DeleteIPSet"

// DeleteIPSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIPSet for more information on using the DeleteIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIPSetRequest method.
//    req, resp := client.DeleteIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteIPSet
func (c *WAFRegional) DeleteIPSetRequest(input *waf.DeleteIPSetInput) (req *request.Request, output *waf.DeleteIPSetOutput) {
	op := &request.Operation{
		Name:       opDeleteIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteIPSetInput{}
	}

	output = &waf.DeleteIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIPSet API operation for AWS WAF Regional.
//
// Permanently deletes an IPSet. You can't delete an IPSet if it's still used
// in any Rules or if it still includes any IP addresses.
//
// If you just want to remove an IPSet from a Rule, use UpdateRule.
//
// To permanently delete an IPSet from AWS WAF, perform the following steps:
//
// Update the IPSet to remove IP address ranges, if any. For more information,
// see UpdateIPSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteIPSet request.
//
// Submit a DeleteIPSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteIPSet
func (c *WAFRegional) DeleteIPSet(input *waf.DeleteIPSetInput) (*waf.DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	return out, req.Send()
}

// DeleteIPSetWithContext is the same as DeleteIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteIPSetWithContext(ctx aws.Context, input *waf.DeleteIPSetInput, opts ...request.Option) (*waf.DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoggingConfiguration = "DeleteLoggingConfiguration"

// DeleteLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoggingConfiguration for more information on using the DeleteLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoggingConfigurationRequest method.
//    req, resp := client.DeleteLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteLoggingConfiguration
func (c *WAFRegional) DeleteLoggingConfigurationRequest(input *waf.DeleteLoggingConfigurationInput) (req *request.Request, output *waf.DeleteLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteLoggingConfigurationInput{}
	}

	output = &waf.DeleteLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLoggingConfiguration API operation for AWS WAF Regional.
//
// Permanently deletes the LoggingConfiguration from the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteLoggingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteLoggingConfiguration
func (c *WAFRegional) DeleteLoggingConfiguration(input *waf.DeleteLoggingConfigurationInput) (*waf.DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLoggingConfigurationWithContext is the same as DeleteLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteLoggingConfigurationWithContext(ctx aws.Context, input *waf.DeleteLoggingConfigurationInput, opts ...request.Option) (*waf.DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermissionPolicy = "DeletePermissionPolicy"

// DeletePermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermissionPolicy for more information on using the DeletePermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePermissionPolicyRequest method.
//    req, resp := client.DeletePermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeletePermissionPolicy
func (c *WAFRegional) DeletePermissionPolicyRequest(input *waf.DeletePermissionPolicyInput) (req *request.Request, output *waf.DeletePermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeletePermissionPolicyInput{}
	}

	output = &waf.DeletePermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermissionPolicy API operation for AWS WAF Regional.
//
// Permanently deletes an IAM policy from the specified RuleGroup.
//
// The user making the request must be the owner of the RuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeletePermissionPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeletePermissionPolicy
func (c *WAFRegional) DeletePermissionPolicy(input *waf.DeletePermissionPolicyInput) (*waf.DeletePermissionPolicyOutput, error) {
	req, out := c.DeletePermissionPolicyRequest(input)
	return out, req.Send()
}

// DeletePermissionPolicyWithContext is the same as DeletePermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeletePermissionPolicyWithContext(ctx aws.Context, input *waf.DeletePermissionPolicyInput, opts ...request.Option) (*waf.DeletePermissionPolicyOutput, error) {
	req, out := c.DeletePermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRateBasedRule = "DeleteRateBasedRule"

// DeleteRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRateBasedRule for more information on using the DeleteRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRateBasedRuleRequest method.
//    req, resp := client.DeleteRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRateBasedRule
func (c *WAFRegional) DeleteRateBasedRuleRequest(input *waf.DeleteRateBasedRuleInput) (req *request.Request, output *waf.DeleteRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteRateBasedRuleInput{}
	}

	output = &waf.DeleteRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRateBasedRule API operation for AWS WAF Regional.
//
// Permanently deletes a RateBasedRule. You can't delete a rule if it's still
// used in any WebACL objects or if it still includes any predicates, such as
// ByteMatchSet objects.
//
// If you just want to remove a rule from a WebACL, use UpdateWebACL.
//
// To permanently delete a RateBasedRule from AWS WAF, perform the following
// steps:
//
// Update the RateBasedRule to remove predicates, if any. For more information,
// see UpdateRateBasedRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRateBasedRule request.
//
// Submit a DeleteRateBasedRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteRateBasedRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRateBasedRule
func (c *WAFRegional) DeleteRateBasedRule(input *waf.DeleteRateBasedRuleInput) (*waf.DeleteRateBasedRuleOutput, error) {
	req, out := c.DeleteRateBasedRuleRequest(input)
	return out, req.Send()
}

// DeleteRateBasedRuleWithContext is the same as DeleteRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteRateBasedRuleWithContext(ctx aws.Context, input *waf.DeleteRateBasedRuleInput, opts ...request.Option) (*waf.DeleteRateBasedRuleOutput, error) {
	req, out := c.DeleteRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegexMatchSet = "DeleteRegexMatchSet"

// DeleteRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegexMatchSet for more information on using the DeleteRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegexMatchSetRequest method.
//    req, resp := client.DeleteRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRegexMatchSet
func (c *WAFRegional) DeleteRegexMatchSetRequest(input *waf.DeleteRegexMatchSetInput) (req *request.Request, output *waf.DeleteRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteRegexMatchSetInput{}
	}

	output = &waf.DeleteRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRegexMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes a RegexMatchSet. You can't delete a RegexMatchSet if
// it's still used in any Rules or if it still includes any RegexMatchTuples
// objects (any filters).
//
// If you just want to remove a RegexMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a RegexMatchSet, perform the following steps:
//
// Update the RegexMatchSet to remove filters, if any. For more information,
// see UpdateRegexMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRegexMatchSet request.
//
// Submit a DeleteRegexMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteRegexMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRegexMatchSet
func (c *WAFRegional) DeleteRegexMatchSet(input *waf.DeleteRegexMatchSetInput) (*waf.DeleteRegexMatchSetOutput, error) {
	req, out := c.DeleteRegexMatchSetRequest(input)
	return out, req.Send()
}

// DeleteRegexMatchSetWithContext is the same as DeleteRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteRegexMatchSetWithContext(ctx aws.Context, input *waf.DeleteRegexMatchSetInput, opts ...request.Option) (*waf.DeleteRegexMatchSetOutput, error) {
	req, out := c.DeleteRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegexPatternSet = "DeleteRegexPatternSet"

// DeleteRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegexPatternSet for more information on using the DeleteRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegexPatternSetRequest method.
//    req, resp := client.DeleteRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRegexPatternSet
func (c *WAFRegional) DeleteRegexPatternSetRequest(input *waf.DeleteRegexPatternSetInput) (req *request.Request, output *waf.DeleteRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opDeleteRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteRegexPatternSetInput{}
	}

	output = &waf.DeleteRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRegexPatternSet API operation for AWS WAF Regional.
//
// Permanently deletes a RegexPatternSet. You can't delete a RegexPatternSet
// if it's still used in any RegexMatchSet or if the RegexPatternSet is not
// empty.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteRegexPatternSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRegexPatternSet
func (c *WAFRegional) DeleteRegexPatternSet(input *waf.DeleteRegexPatternSetInput) (*waf.DeleteRegexPatternSetOutput, error) {
	req, out := c.DeleteRegexPatternSetRequest(input)
	return out, req.Send()
}

// DeleteRegexPatternSetWithContext is the same as DeleteRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteRegexPatternSetWithContext(ctx aws.Context, input *waf.DeleteRegexPatternSetInput, opts ...request.Option) (*waf.DeleteRegexPatternSetOutput, error) {
	req, out := c.DeleteRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRule
func (c *WAFRegional) DeleteRuleRequest(input *waf.DeleteRuleInput) (req *request.Request, output *waf.DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteRuleInput{}
	}

	output = &waf.DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRule API operation for AWS WAF Regional.
//
// Permanently deletes a Rule. You can't delete a Rule if it's still used in
// any WebACL objects or if it still includes any predicates, such as ByteMatchSet
// objects.
//
// If you just want to remove a Rule from a WebACL, use UpdateWebACL.
//
// To permanently delete a Rule from AWS WAF, perform the following steps:
//
// Update the Rule to remove predicates, if any. For more information, see UpdateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRule request.
//
// Submit a DeleteRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRule
func (c *WAFRegional) DeleteRule(input *waf.DeleteRuleInput) (*waf.DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteRuleWithContext(ctx aws.Context, input *waf.DeleteRuleInput, opts ...request.Option) (*waf.DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRuleGroup = "DeleteRuleGroup"

// DeleteRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRuleGroup for more information on using the DeleteRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleGroupRequest method.
//    req, resp := client.DeleteRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRuleGroup
func (c *WAFRegional) DeleteRuleGroupRequest(input *waf.DeleteRuleGroupInput) (req *request.Request, output *waf.DeleteRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteRuleGroupInput{}
	}

	output = &waf.DeleteRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRuleGroup API operation for AWS WAF Regional.
//
// Permanently deletes a RuleGroup. You can't delete a RuleGroup if it's still
// used in any WebACL objects or if it still includes any rules.
//
// If you just want to remove a RuleGroup from a WebACL, use UpdateWebACL.
//
// To permanently delete a RuleGroup from AWS WAF, perform the following steps:
//
// Update the RuleGroup to remove rules, if any. For more information, see UpdateRuleGroup.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRuleGroup request.
//
// Submit a DeleteRuleGroup request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteRuleGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRuleGroup
func (c *WAFRegional) DeleteRuleGroup(input *waf.DeleteRuleGroupInput) (*waf.DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	return out, req.Send()
}

// DeleteRuleGroupWithContext is the same as DeleteRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteRuleGroupWithContext(ctx aws.Context, input *waf.DeleteRuleGroupInput, opts ...request.Option) (*waf.DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSizeConstraintSet = "DeleteSizeConstraintSet"

// DeleteSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSizeConstraintSet for more information on using the DeleteSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSizeConstraintSetRequest method.
//    req, resp := client.DeleteSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSizeConstraintSet
func (c *WAFRegional) DeleteSizeConstraintSetRequest(input *waf.DeleteSizeConstraintSetInput) (req *request.Request, output *waf.DeleteSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteSizeConstraintSetInput{}
	}

	output = &waf.DeleteSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSizeConstraintSet API operation for AWS WAF Regional.
//
// Permanently deletes a SizeConstraintSet. You can't delete a SizeConstraintSet
// if it's still used in any Rules or if it still includes any SizeConstraint
// objects (any filters).
//
// If you just want to remove a SizeConstraintSet from a Rule, use UpdateRule.
//
// To permanently delete a SizeConstraintSet, perform the following steps:
//
// Update the SizeConstraintSet to remove filters, if any. For more information,
// see UpdateSizeConstraintSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteSizeConstraintSet request.
//
// Submit a DeleteSizeConstraintSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSizeConstraintSet
func (c *WAFRegional) DeleteSizeConstraintSet(input *waf.DeleteSizeConstraintSetInput) (*waf.DeleteSizeConstraintSetOutput, error) {
	req, out := c.DeleteSizeConstraintSetRequest(input)
	return out, req.Send()
}

// DeleteSizeConstraintSetWithContext is the same as DeleteSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteSizeConstraintSetWithContext(ctx aws.Context, input *waf.DeleteSizeConstraintSetInput, opts ...request.Option) (*waf.DeleteSizeConstraintSetOutput, error) {
	req, out := c.DeleteSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSqlInjectionMatchSet = "DeleteSqlInjectionMatchSet"

// DeleteSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSqlInjectionMatchSet for more information on using the DeleteSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSqlInjectionMatchSetRequest method.
//    req, resp := client.DeleteSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSqlInjectionMatchSet
func (c *WAFRegional) DeleteSqlInjectionMatchSetRequest(input *waf.DeleteSqlInjectionMatchSetInput) (req *request.Request, output *waf.DeleteSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteSqlInjectionMatchSetInput{}
	}

	output = &waf.DeleteSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes a SqlInjectionMatchSet. You can't delete a SqlInjectionMatchSet
// if it's still used in any Rules or if it still contains any SqlInjectionMatchTuple
// objects.
//
// If you just want to remove a SqlInjectionMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a SqlInjectionMatchSet from AWS WAF, perform the following
// steps:
//
// Update the SqlInjectionMatchSet to remove filters, if any. For more information,
// see UpdateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteSqlInjectionMatchSet request.
//
// Submit a DeleteSqlInjectionMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSqlInjectionMatchSet
func (c *WAFRegional) DeleteSqlInjectionMatchSet(input *waf.DeleteSqlInjectionMatchSetInput) (*waf.DeleteSqlInjectionMatchSetOutput, error) {
	req, out := c.DeleteSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// DeleteSqlInjectionMatchSetWithContext is the same as DeleteSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.DeleteSqlInjectionMatchSetInput, opts ...request.Option) (*waf.DeleteSqlInjectionMatchSetOutput, error) {
	req, out := c.DeleteSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWebACL = "DeleteWebACL"

// DeleteWebACLRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWebACL for more information on using the DeleteWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWebACLRequest method.
//    req, resp := client.DeleteWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteWebACL
func (c *WAFRegional) DeleteWebACLRequest(input *waf.DeleteWebACLInput) (req *request.Request, output *waf.DeleteWebACLOutput) {
	op := &request.Operation{
		Name:       opDeleteWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteWebACLInput{}
	}

	output = &waf.DeleteWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWebACL API operation for AWS WAF Regional.
//
// Permanently deletes a WebACL. You can't delete a WebACL if it still contains
// any Rules.
//
// To delete a WebACL, perform the following steps:
//
// Update the WebACL to remove Rules, if any. For more information, see UpdateWebACL.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteWebACL request.
//
// Submit a DeleteWebACL request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteWebACL
func (c *WAFRegional) DeleteWebACL(input *waf.DeleteWebACLInput) (*waf.DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	return out, req.Send()
}

// DeleteWebACLWithContext is the same as DeleteWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteWebACLWithContext(ctx aws.Context, input *waf.DeleteWebACLInput, opts ...request.Option) (*waf.DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteXssMatchSet = "DeleteXssMatchSet"

// DeleteXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteXssMatchSet for more information on using the DeleteXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteXssMatchSetRequest method.
//    req, resp := client.DeleteXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteXssMatchSet
func (c *WAFRegional) DeleteXssMatchSetRequest(input *waf.DeleteXssMatchSetInput) (req *request.Request, output *waf.DeleteXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteXssMatchSetInput{}
	}

	output = &waf.DeleteXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteXssMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes an XssMatchSet. You can't delete an XssMatchSet if it's
// still used in any Rules or if it still contains any XssMatchTuple objects.
//
// If you just want to remove an XssMatchSet from a Rule, use UpdateRule.
//
// To permanently delete an XssMatchSet from AWS WAF, perform the following
// steps:
//
// Update the XssMatchSet to remove filters, if any. For more information, see
// UpdateXssMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteXssMatchSet request.
//
// Submit a DeleteXssMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteXssMatchSet
func (c *WAFRegional) DeleteXssMatchSet(input *waf.DeleteXssMatchSetInput) (*waf.DeleteXssMatchSetOutput, error) {
	req, out := c.DeleteXssMatchSetRequest(input)
	return out, req.Send()
}

// DeleteXssMatchSetWithContext is the same as DeleteXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteXssMatchSetWithContext(ctx aws.Context, input *waf.DeleteXssMatchSetInput, opts ...request.Option) (*waf.DeleteXssMatchSetOutput, error) {
	req, out := c.DeleteXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWebACL = "DisassociateWebACL"

// DisassociateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWebACL for more information on using the DisassociateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateWebACLRequest method.
//    req, resp := client.DisassociateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACL
func (c *WAFRegional) DisassociateWebACLRequest(input *DisassociateWebACLInput) (req *request.Request, output *DisassociateWebACLOutput) {
	op := &request.Operation{
		Name:       opDisassociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateWebACLInput{}
	}

	output = &DisassociateWebACLOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateWebACL API operation for AWS WAF Regional.
//
// Removes a web ACL from the specified resource, either an application load
// balancer or Amazon API Gateway stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DisassociateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACL
func (c *WAFRegional) DisassociateWebACL(input *DisassociateWebACLInput) (*DisassociateWebACLOutput, error) {
	req, out := c.DisassociateWebACLRequest(input)
	return out, req.Send()
}

// DisassociateWebACLWithContext is the same as DisassociateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DisassociateWebACLWithContext(ctx aws.Context, input *DisassociateWebACLInput, opts ...request.Option) (*DisassociateWebACLOutput, error) {
	req, out := c.DisassociateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetByteMatchSet = "GetByteMatchSet"

// GetByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetByteMatchSet for more information on using the GetByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetByteMatchSetRequest method.
//    req, resp := client.GetByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetByteMatchSet
func (c *WAFRegional) GetByteMatchSetRequest(input *waf.GetByteMatchSetInput) (req *request.Request, output *waf.GetByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetByteMatchSetInput{}
	}

	output = &waf.GetByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetByteMatchSet API operation for AWS WAF Regional.
//
// Returns the ByteMatchSet specified by ByteMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetByteMatchSet
func (c *WAFRegional) GetByteMatchSet(input *waf.GetByteMatchSetInput) (*waf.GetByteMatchSetOutput, error) {
	req, out := c.GetByteMatchSetRequest(input)
	return out, req.Send()
}

// GetByteMatchSetWithContext is the same as GetByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetByteMatchSetWithContext(ctx aws.Context, input *waf.GetByteMatchSetInput, opts ...request.Option) (*waf.GetByteMatchSetOutput, error) {
	req, out := c.GetByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChangeToken = "GetChangeToken"

// GetChangeTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChangeToken for more information on using the GetChangeToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChangeTokenRequest method.
//    req, resp := client.GetChangeTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeToken
func (c *WAFRegional) GetChangeTokenRequest(input *waf.GetChangeTokenInput) (req *request.Request, output *waf.GetChangeTokenOutput) {
	op := &request.Operation{
		Name:       opGetChangeToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetChangeTokenInput{}
	}

	output = &waf.GetChangeTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChangeToken API operation for AWS WAF Regional.
//
// When you want to create, update, or delete AWS WAF objects, get a change
// token and include the change token in the create, update, or delete request.
// Change tokens ensure that your application doesn't submit conflicting requests
// to AWS WAF.
//
// Each create, update, or delete request must use a unique change token. If
// your application submits a GetChangeToken request and then submits a second
// GetChangeToken request before submitting a create, update, or delete request,
// the second GetChangeToken request returns the same value as the first GetChangeToken
// request.
//
// When you use a change token in a create, update, or delete request, the status
// of the change token changes to PENDING, which indicates that AWS WAF is propagating
// the change to all AWS WAF servers. Use GetChangeTokenStatus to determine
// the status of your change token.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetChangeToken for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeToken
func (c *WAFRegional) GetChangeToken(input *waf.GetChangeTokenInput) (*waf.GetChangeTokenOutput, error) {
	req, out := c.GetChangeTokenRequest(input)
	return out, req.Send()
}

// GetChangeTokenWithContext is the same as GetChangeToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetChangeToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetChangeTokenWithContext(ctx aws.Context, input *waf.GetChangeTokenInput, opts ...request.Option) (*waf.GetChangeTokenOutput, error) {
	req, out := c.GetChangeTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChangeTokenStatus = "GetChangeTokenStatus"

// GetChangeTokenStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeTokenStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChangeTokenStatus for more information on using the GetChangeTokenStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChangeTokenStatusRequest method.
//    req, resp := client.GetChangeTokenStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeTokenStatus
func (c *WAFRegional) GetChangeTokenStatusRequest(input *waf.GetChangeTokenStatusInput) (req *request.Request, output *waf.GetChangeTokenStatusOutput) {
	op := &request.Operation{
		Name:       opGetChangeTokenStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetChangeTokenStatusInput{}
	}

	output = &waf.GetChangeTokenStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChangeTokenStatus API operation for AWS WAF Regional.
//
// Returns the status of a ChangeToken that you got by calling GetChangeToken.
// ChangeTokenStatus is one of the following values:
//
//    * PROVISIONED: You requested the change token by calling GetChangeToken,
//    but you haven't used it yet in a call to create, update, or delete an
//    AWS WAF object.
//
//    * PENDING: AWS WAF is propagating the create, update, or delete request
//    to all AWS WAF servers.
//
//    * INSYNC: Propagation is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetChangeTokenStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeTokenStatus
func (c *WAFRegional) GetChangeTokenStatus(input *waf.GetChangeTokenStatusInput) (*waf.GetChangeTokenStatusOutput, error) {
	req, out := c.GetChangeTokenStatusRequest(input)
	return out, req.Send()
}

// GetChangeTokenStatusWithContext is the same as GetChangeTokenStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetChangeTokenStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetChangeTokenStatusWithContext(ctx aws.Context, input *waf.GetChangeTokenStatusInput, opts ...request.Option) (*waf.GetChangeTokenStatusOutput, error) {
	req, out := c.GetChangeTokenStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGeoMatchSet = "GetGeoMatchSet"

// GetGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeoMatchSet for more information on using the GetGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGeoMatchSetRequest method.
//    req, resp := client.GetGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetGeoMatchSet
func (c *WAFRegional) GetGeoMatchSetRequest(input *waf.GetGeoMatchSetInput) (req *request.Request, output *waf.GetGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetGeoMatchSetInput{}
	}

	output = &waf.GetGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGeoMatchSet API operation for AWS WAF Regional.
//
// Returns the GeoMatchSet that is specified by GeoMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetGeoMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetGeoMatchSet
func (c *WAFRegional) GetGeoMatchSet(input *waf.GetGeoMatchSetInput) (*waf.GetGeoMatchSetOutput, error) {
	req, out := c.GetGeoMatchSetRequest(input)
	return out, req.Send()
}

// GetGeoMatchSetWithContext is the same as GetGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetGeoMatchSetWithContext(ctx aws.Context, input *waf.GetGeoMatchSetInput, opts ...request.Option) (*waf.GetGeoMatchSetOutput, error) {
	req, out := c.GetGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIPSet = "GetIPSet"

// GetIPSetRequest generates a "aws/request.Request" representing the
// client's request for the GetIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIPSet for more information on using the GetIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIPSetRequest method.
//    req, resp := client.GetIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetIPSet
func (c *WAFRegional) GetIPSetRequest(input *waf.GetIPSetInput) (req *request.Request, output *waf.GetIPSetOutput) {
	op := &request.Operation{
		Name:       opGetIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetIPSetInput{}
	}

	output = &waf.GetIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIPSet API operation for AWS WAF Regional.
//
// Returns the IPSet that is specified by IPSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetIPSet
func (c *WAFRegional) GetIPSet(input *waf.GetIPSetInput) (*waf.GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	return out, req.Send()
}

// GetIPSetWithContext is the same as GetIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetIPSetWithContext(ctx aws.Context, input *waf.GetIPSetInput, opts ...request.Option) (*waf.GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingConfiguration = "GetLoggingConfiguration"

// GetLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggingConfiguration for more information on using the GetLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggingConfigurationRequest method.
//    req, resp := client.GetLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetLoggingConfiguration
func (c *WAFRegional) GetLoggingConfigurationRequest(input *waf.GetLoggingConfigurationInput) (req *request.Request, output *waf.GetLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetLoggingConfigurationInput{}
	}

	output = &waf.GetLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingConfiguration API operation for AWS WAF Regional.
//
// Returns the LoggingConfiguration for the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetLoggingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetLoggingConfiguration
func (c *WAFRegional) GetLoggingConfiguration(input *waf.GetLoggingConfigurationInput) (*waf.GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetLoggingConfigurationWithContext is the same as GetLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetLoggingConfigurationWithContext(ctx aws.Context, input *waf.GetLoggingConfigurationInput, opts ...request.Option) (*waf.GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPermissionPolicy = "GetPermissionPolicy"

// GetPermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPermissionPolicy for more information on using the GetPermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPermissionPolicyRequest method.
//    req, resp := client.GetPermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetPermissionPolicy
func (c *WAFRegional) GetPermissionPolicyRequest(input *waf.GetPermissionPolicyInput) (req *request.Request, output *waf.GetPermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetPermissionPolicyInput{}
	}

	output = &waf.GetPermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPermissionPolicy API operation for AWS WAF Regional.
//
// Returns the IAM policy attached to the RuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetPermissionPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetPermissionPolicy
func (c *WAFRegional) GetPermissionPolicy(input *waf.GetPermissionPolicyInput) (*waf.GetPermissionPolicyOutput, error) {
	req, out := c.GetPermissionPolicyRequest(input)
	return out, req.Send()
}

// GetPermissionPolicyWithContext is the same as GetPermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetPermissionPolicyWithContext(ctx aws.Context, input *waf.GetPermissionPolicyInput, opts ...request.Option) (*waf.GetPermissionPolicyOutput, error) {
	req, out := c.GetPermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRateBasedRule = "GetRateBasedRule"

// GetRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRateBasedRule for more information on using the GetRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRateBasedRuleRequest method.
//    req, resp := client.GetRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRateBasedRule
func (c *WAFRegional) GetRateBasedRuleRequest(input *waf.GetRateBasedRuleInput) (req *request.Request, output *waf.GetRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opGetRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetRateBasedRuleInput{}
	}

	output = &waf.GetRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRateBasedRule API operation for AWS WAF Regional.
//
// Returns the RateBasedRule that is specified by the RuleId that you included
// in the GetRateBasedRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetRateBasedRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRateBasedRule
func (c *WAFRegional) GetRateBasedRule(input *waf.GetRateBasedRuleInput) (*waf.GetRateBasedRuleOutput, error) {
	req, out := c.GetRateBasedRuleRequest(input)
	return out, req.Send()
}

// GetRateBasedRuleWithContext is the same as GetRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetRateBasedRuleWithContext(ctx aws.Context, input *waf.GetRateBasedRuleInput, opts ...request.Option) (*waf.GetRateBasedRuleOutput, error) {
	req, out := c.GetRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRateBasedRuleManagedKeys = "GetRateBasedRuleManagedKeys"

// GetRateBasedRuleManagedKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetRateBasedRuleManagedKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRateBasedRuleManagedKeys for more information on using the GetRateBasedRuleManagedKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRateBasedRuleManagedKeysRequest method.
//    req, resp := client.GetRateBasedRuleManagedKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRateBasedRuleManagedKeys
func (c *WAFRegional) GetRateBasedRuleManagedKeysRequest(input *waf.GetRateBasedRuleManagedKeysInput) (req *request.Request, output *waf.GetRateBasedRuleManagedKeysOutput) {
	op := &request.Operation{
		Name:       opGetRateBasedRuleManagedKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetRateBasedRuleManagedKeysInput{}
	}

	output = &waf.GetRateBasedRuleManagedKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRateBasedRuleManagedKeys API operation for AWS WAF Regional.
//
// Returns an array of IP addresses currently being blocked by the RateBasedRule
// that is specified by the RuleId. The maximum number of managed keys that
// will be blocked is 10,000. If more than 10,000 addresses exceed the rate
// limit, the 10,000 addresses with the highest rates will be blocked.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetRateBasedRuleManagedKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRateBasedRuleManagedKeys
func (c *WAFRegional) GetRateBasedRuleManagedKeys(input *waf.GetRateBasedRuleManagedKeysInput) (*waf.GetRateBasedRuleManagedKeysOutput, error) {
	req, out := c.GetRateBasedRuleManagedKeysRequest(input)
	return out, req.Send()
}

// GetRateBasedRuleManagedKeysWithContext is the same as GetRateBasedRuleManagedKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetRateBasedRuleManagedKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetRateBasedRuleManagedKeysWithContext(ctx aws.Context, input *waf.GetRateBasedRuleManagedKeysInput, opts ...request.Option) (*waf.GetRateBasedRuleManagedKeysOutput, error) {
	req, out := c.GetRateBasedRuleManagedKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegexMatchSet = "GetRegexMatchSet"

// GetRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegexMatchSet for more information on using the GetRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegexMatchSetRequest method.
//    req, resp := client.GetRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRegexMatchSet
func (c *WAFRegional) GetRegexMatchSetRequest(input *waf.GetRegexMatchSetInput) (req *request.Request, output *waf.GetRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetRegexMatchSetInput{}
	}

	output = &waf.GetRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegexMatchSet API operation for AWS WAF Regional.
//
// Returns the RegexMatchSet specified by RegexMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetRegexMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRegexMatchSet
func (c *WAFRegional) GetRegexMatchSet(input *waf.GetRegexMatchSetInput) (*waf.GetRegexMatchSetOutput, error) {
	req, out := c.GetRegexMatchSetRequest(input)
	return out, req.Send()
}

// GetRegexMatchSetWithContext is the same as GetRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetRegexMatchSetWithContext(ctx aws.Context, input *waf.GetRegexMatchSetInput, opts ...request.Option) (*waf.GetRegexMatchSetOutput, error) {
	req, out := c.GetRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegexPatternSet = "GetRegexPatternSet"

// GetRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the GetRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegexPatternSet for more information on using the GetRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegexPatternSetRequest method.
//    req, resp := client.GetRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRegexPatternSet
func (c *WAFRegional) GetRegexPatternSetRequest(input *waf.GetRegexPatternSetInput) (req *request.Request, output *waf.GetRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opGetRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetRegexPatternSetInput{}
	}

	output = &waf.GetRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegexPatternSet API operation for AWS WAF Regional.
//
// Returns the RegexPatternSet specified by RegexPatternSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetRegexPatternSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRegexPatternSet
func (c *WAFRegional) GetRegexPatternSet(input *waf.GetRegexPatternSetInput) (*waf.GetRegexPatternSetOutput, error) {
	req, out := c.GetRegexPatternSetRequest(input)
	return out, req.Send()
}

// GetRegexPatternSetWithContext is the same as GetRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetRegexPatternSetWithContext(ctx aws.Context, input *waf.GetRegexPatternSetInput, opts ...request.Option) (*waf.GetRegexPatternSetOutput, error) {
	req, out := c.GetRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRule = "GetRule"

// GetRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRule for more information on using the GetRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRuleRequest method.
//    req, resp := client.GetRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRule
func (c *WAFRegional) GetRuleRequest(input *waf.GetRuleInput) (req *request.Request, output *waf.GetRuleOutput) {
	op := &request.Operation{
		Name:       opGetRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetRuleInput{}
	}

	output = &waf.GetRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRule API operation for AWS WAF Regional.
//
// Returns the Rule that is specified by the RuleId that you included in the
// GetRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRule
func (c *WAFRegional) GetRule(input *waf.GetRuleInput) (*waf.GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	return out, req.Send()
}

// GetRuleWithContext is the same as GetRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetRuleWithContext(ctx aws.Context, input *waf.GetRuleInput, opts ...request.Option) (*waf.GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRuleGroup = "GetRuleGroup"

// GetRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRuleGroup for more information on using the GetRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRuleGroupRequest method.
//    req, resp := client.GetRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRuleGroup
func (c *WAFRegional) GetRuleGroupRequest(input *waf.GetRuleGroupInput) (req *request.Request, output *waf.GetRuleGroupOutput) {
	op := &request.Operation{
		Name:       opGetRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetRuleGroupInput{}
	}

	output = &waf.GetRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRuleGroup API operation for AWS WAF Regional.
//
// Returns the RuleGroup that is specified by the RuleGroupId that you included
// in the GetRuleGroup request.
//
// To view the rules in a rule group, use ListActivatedRulesInRuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetRuleGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRuleGroup
func (c *WAFRegional) GetRuleGroup(input *waf.GetRuleGroupInput) (*waf.GetRuleGroupOutput, error) {
	req, out := c.GetRuleGroupRequest(input)
	return out, req.Send()
}

// GetRuleGroupWithContext is the same as GetRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetRuleGroupWithContext(ctx aws.Context, input *waf.GetRuleGroupInput, opts ...request.Option) (*waf.GetRuleGroupOutput, error) {
	req, out := c.GetRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSampledRequests = "GetSampledRequests"

// GetSampledRequestsRequest generates a "aws/request.Request" representing the
// client's request for the GetSampledRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSampledRequests for more information on using the GetSampledRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSampledRequestsRequest method.
//    req, resp := client.GetSampledRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSampledRequests
func (c *WAFRegional) GetSampledRequestsRequest(input *waf.GetSampledRequestsInput) (req *request.Request, output *waf.GetSampledRequestsOutput) {
	op := &request.Operation{
		Name:       opGetSampledRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetSampledRequestsInput{}
	}

	output = &waf.GetSampledRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSampledRequests API operation for AWS WAF Regional.
//
// Gets detailed information about a specified number of requests--a sample--that
// AWS WAF randomly selects from among the first 5,000 requests that your AWS
// resource received during a time range that you choose. You can specify a
// sample size of up to 500 requests, and you can specify any time range in
// the previous three hours.
//
// GetSampledRequests returns a time range, which is usually the time range
// that you specified. However, if your resource (such as a CloudFront distribution)
// received 5,000 requests before the specified time range elapsed, GetSampledRequests
// returns an updated time range. This new time range indicates the actual period
// during which AWS WAF selected the requests in the sample.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetSampledRequests for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSampledRequests
func (c *WAFRegional) GetSampledRequests(input *waf.GetSampledRequestsInput) (*waf.GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	return out, req.Send()
}

// GetSampledRequestsWithContext is the same as GetSampledRequests with the addition of
// the ability to pass a context and additional request options.
//
// See GetSampledRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetSampledRequestsWithContext(ctx aws.Context, input *waf.GetSampledRequestsInput, opts ...request.Option) (*waf.GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSizeConstraintSet = "GetSizeConstraintSet"

// GetSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the GetSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSizeConstraintSet for more information on using the GetSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSizeConstraintSetRequest method.
//    req, resp := client.GetSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSizeConstraintSet
func (c *WAFRegional) GetSizeConstraintSetRequest(input *waf.GetSizeConstraintSetInput) (req *request.Request, output *waf.GetSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opGetSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetSizeConstraintSetInput{}
	}

	output = &waf.GetSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSizeConstraintSet API operation for AWS WAF Regional.
//
// Returns the SizeConstraintSet specified by SizeConstraintSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSizeConstraintSet
func (c *WAFRegional) GetSizeConstraintSet(input *waf.GetSizeConstraintSetInput) (*waf.GetSizeConstraintSetOutput, error) {
	req, out := c.GetSizeConstraintSetRequest(input)
	return out, req.Send()
}

// GetSizeConstraintSetWithContext is the same as GetSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetSizeConstraintSetWithContext(ctx aws.Context, input *waf.GetSizeConstraintSetInput, opts ...request.Option) (*waf.GetSizeConstraintSetOutput, error) {
	req, out := c.GetSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSqlInjectionMatchSet = "GetSqlInjectionMatchSet"

// GetSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSqlInjectionMatchSet for more information on using the GetSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSqlInjectionMatchSetRequest method.
//    req, resp := client.GetSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSqlInjectionMatchSet
func (c *WAFRegional) GetSqlInjectionMatchSetRequest(input *waf.GetSqlInjectionMatchSetInput) (req *request.Request, output *waf.GetSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetSqlInjectionMatchSetInput{}
	}

	output = &waf.GetSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Returns the SqlInjectionMatchSet that is specified by SqlInjectionMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSqlInjectionMatchSet
func (c *WAFRegional) GetSqlInjectionMatchSet(input *waf.GetSqlInjectionMatchSetInput) (*waf.GetSqlInjectionMatchSetOutput, error) {
	req, out := c.GetSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// GetSqlInjectionMatchSetWithContext is the same as GetSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.GetSqlInjectionMatchSetInput, opts ...request.Option) (*waf.GetSqlInjectionMatchSetOutput, error) {
	req, out := c.GetSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebACL = "GetWebACL"

// GetWebACLRequest generates a "aws/request.Request" representing the
// client's request for the GetWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWebACL for more information on using the GetWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWebACLRequest method.
//    req, resp := client.GetWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACL
func (c *WAFRegional) GetWebACLRequest(input *waf.GetWebACLInput) (req *request.Request, output *waf.GetWebACLOutput) {
	op := &request.Operation{
		Name:       opGetWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetWebACLInput{}
	}

	output = &waf.GetWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebACL API operation for AWS WAF Regional.
//
// Returns the WebACL that is specified by WebACLId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACL
func (c *WAFRegional) GetWebACL(input *waf.GetWebACLInput) (*waf.GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	return out, req.Send()
}

// GetWebACLWithContext is the same as GetWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetWebACLWithContext(ctx aws.Context, input *waf.GetWebACLInput, opts ...request.Option) (*waf.GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebACLForResource = "GetWebACLForResource"

// GetWebACLForResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetWebACLForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWebACLForResource for more information on using the GetWebACLForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWebACLForResourceRequest method.
//    req, resp := client.GetWebACLForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACLForResource
func (c *WAFRegional) GetWebACLForResourceRequest(input *GetWebACLForResourceInput) (req *request.Request, output *GetWebACLForResourceOutput) {
	op := &request.Operation{
		Name:       opGetWebACLForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWebACLForResourceInput{}
	}

	output = &GetWebACLForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebACLForResource API operation for AWS WAF Regional.
//
// Returns the web ACL for the specified resource, either an application load
// balancer or Amazon API Gateway stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetWebACLForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFUnavailableEntityException "WAFUnavailableEntityException"
//   The operation failed because the entity referenced is temporarily unavailable.
//   Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACLForResource
func (c *WAFRegional) GetWebACLForResource(input *GetWebACLForResourceInput) (*GetWebACLForResourceOutput, error) {
	req, out := c.GetWebACLForResourceRequest(input)
	return out, req.Send()
}

// GetWebACLForResourceWithContext is the same as GetWebACLForResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebACLForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetWebACLForResourceWithContext(ctx aws.Context, input *GetWebACLForResourceInput, opts ...request.Option) (*GetWebACLForResourceOutput, error) {
	req, out := c.GetWebACLForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetXssMatchSet = "GetXssMatchSet"

// GetXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetXssMatchSet for more information on using the GetXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetXssMatchSetRequest method.
//    req, resp := client.GetXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetXssMatchSet
func (c *WAFRegional) GetXssMatchSetRequest(input *waf.GetXssMatchSetInput) (req *request.Request, output *waf.GetXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetXssMatchSetInput{}
	}

	output = &waf.GetXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetXssMatchSet API operation for AWS WAF Regional.
//
// Returns the XssMatchSet that is specified by XssMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetXssMatchSet
func (c *WAFRegional) GetXssMatchSet(input *waf.GetXssMatchSetInput) (*waf.GetXssMatchSetOutput, error) {
	req, out := c.GetXssMatchSetRequest(input)
	return out, req.Send()
}

// GetXssMatchSetWithContext is the same as GetXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetXssMatchSetWithContext(ctx aws.Context, input *waf.GetXssMatchSetInput, opts ...request.Option) (*waf.GetXssMatchSetOutput, error) {
	req, out := c.GetXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActivatedRulesInRuleGroup = "ListActivatedRulesInRuleGroup"

// ListActivatedRulesInRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListActivatedRulesInRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActivatedRulesInRuleGroup for more information on using the ListActivatedRulesInRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActivatedRulesInRuleGroupRequest method.
//    req, resp := client.ListActivatedRulesInRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListActivatedRulesInRuleGroup
func (c *WAFRegional) ListActivatedRulesInRuleGroupRequest(input *waf.ListActivatedRulesInRuleGroupInput) (req *request.Request, output *waf.ListActivatedRulesInRuleGroupOutput) {
	op := &request.Operation{
		Name:       opListActivatedRulesInRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListActivatedRulesInRuleGroupInput{}
	}

	output = &waf.ListActivatedRulesInRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActivatedRulesInRuleGroup API operation for AWS WAF Regional.
//
// Returns an array of ActivatedRule objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListActivatedRulesInRuleGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListActivatedRulesInRuleGroup
func (c *WAFRegional) ListActivatedRulesInRuleGroup(input *waf.ListActivatedRulesInRuleGroupInput) (*waf.ListActivatedRulesInRuleGroupOutput, error) {
	req, out := c.ListActivatedRulesInRuleGroupRequest(input)
	return out, req.Send()
}

// ListActivatedRulesInRuleGroupWithContext is the same as ListActivatedRulesInRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListActivatedRulesInRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListActivatedRulesInRuleGroupWithContext(ctx aws.Context, input *waf.ListActivatedRulesInRuleGroupInput, opts ...request.Option) (*waf.ListActivatedRulesInRuleGroupOutput, error) {
	req, out := c.ListActivatedRulesInRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListByteMatchSets = "ListByteMatchSets"

// ListByteMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListByteMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListByteMatchSets for more information on using the ListByteMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListByteMatchSetsRequest method.
//    req, resp := client.ListByteMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListByteMatchSets
func (c *WAFRegional) ListByteMatchSetsRequest(input *waf.ListByteMatchSetsInput) (req *request.Request, output *waf.ListByteMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListByteMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListByteMatchSetsInput{}
	}

	output = &waf.ListByteMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListByteMatchSets API operation for AWS WAF Regional.
//
// Returns an array of ByteMatchSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListByteMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListByteMatchSets
func (c *WAFRegional) ListByteMatchSets(input *waf.ListByteMatchSetsInput) (*waf.ListByteMatchSetsOutput, error) {
	req, out := c.ListByteMatchSetsRequest(input)
	return out, req.Send()
}

// ListByteMatchSetsWithContext is the same as ListByteMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListByteMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListByteMatchSetsWithContext(ctx aws.Context, input *waf.ListByteMatchSetsInput, opts ...request.Option) (*waf.ListByteMatchSetsOutput, error) {
	req, out := c.ListByteMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGeoMatchSets = "ListGeoMatchSets"

// ListGeoMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListGeoMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeoMatchSets for more information on using the ListGeoMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGeoMatchSetsRequest method.
//    req, resp := client.ListGeoMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListGeoMatchSets
func (c *WAFRegional) ListGeoMatchSetsRequest(input *waf.ListGeoMatchSetsInput) (req *request.Request, output *waf.ListGeoMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListGeoMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListGeoMatchSetsInput{}
	}

	output = &waf.ListGeoMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGeoMatchSets API operation for AWS WAF Regional.
//
// Returns an array of GeoMatchSetSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListGeoMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListGeoMatchSets
func (c *WAFRegional) ListGeoMatchSets(input *waf.ListGeoMatchSetsInput) (*waf.ListGeoMatchSetsOutput, error) {
	req, out := c.ListGeoMatchSetsRequest(input)
	return out, req.Send()
}

// ListGeoMatchSetsWithContext is the same as ListGeoMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeoMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListGeoMatchSetsWithContext(ctx aws.Context, input *waf.ListGeoMatchSetsInput, opts ...request.Option) (*waf.ListGeoMatchSetsOutput, error) {
	req, out := c.ListGeoMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListIPSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIPSets for more information on using the ListIPSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIPSetsRequest method.
//    req, resp := client.ListIPSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListIPSets
func (c *WAFRegional) ListIPSetsRequest(input *waf.ListIPSetsInput) (req *request.Request, output *waf.ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListIPSetsInput{}
	}

	output = &waf.ListIPSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIPSets API operation for AWS WAF Regional.
//
// Returns an array of IPSetSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListIPSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListIPSets
func (c *WAFRegional) ListIPSets(input *waf.ListIPSetsInput) (*waf.ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	return out, req.Send()
}

// ListIPSetsWithContext is the same as ListIPSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListIPSetsWithContext(ctx aws.Context, input *waf.ListIPSetsInput, opts ...request.Option) (*waf.ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggingConfigurations = "ListLoggingConfigurations"

// ListLoggingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggingConfigurations for more information on using the ListLoggingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLoggingConfigurationsRequest method.
//    req, resp := client.ListLoggingConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListLoggingConfigurations
func (c *WAFRegional) ListLoggingConfigurationsRequest(input *waf.ListLoggingConfigurationsInput) (req *request.Request, output *waf.ListLoggingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListLoggingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListLoggingConfigurationsInput{}
	}

	output = &waf.ListLoggingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggingConfigurations API operation for AWS WAF Regional.
//
// Returns an array of LoggingConfiguration objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListLoggingConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListLoggingConfigurations
func (c *WAFRegional) ListLoggingConfigurations(input *waf.ListLoggingConfigurationsInput) (*waf.ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	return out, req.Send()
}

// ListLoggingConfigurationsWithContext is the same as ListLoggingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListLoggingConfigurationsWithContext(ctx aws.Context, input *waf.ListLoggingConfigurationsInput, opts ...request.Option) (*waf.ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRateBasedRules = "ListRateBasedRules"

// ListRateBasedRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRateBasedRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRateBasedRules for more information on using the ListRateBasedRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRateBasedRulesRequest method.
//    req, resp := client.ListRateBasedRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRateBasedRules
func (c *WAFRegional) ListRateBasedRulesRequest(input *waf.ListRateBasedRulesInput) (req *request.Request, output *waf.ListRateBasedRulesOutput) {
	op := &request.Operation{
		Name:       opListRateBasedRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListRateBasedRulesInput{}
	}

	output = &waf.ListRateBasedRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRateBasedRules API operation for AWS WAF Regional.
//
// Returns an array of RuleSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListRateBasedRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRateBasedRules
func (c *WAFRegional) ListRateBasedRules(input *waf.ListRateBasedRulesInput) (*waf.ListRateBasedRulesOutput, error) {
	req, out := c.ListRateBasedRulesRequest(input)
	return out, req.Send()
}

// ListRateBasedRulesWithContext is the same as ListRateBasedRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRateBasedRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListRateBasedRulesWithContext(ctx aws.Context, input *waf.ListRateBasedRulesInput, opts ...request.Option) (*waf.ListRateBasedRulesOutput, error) {
	req, out := c.ListRateBasedRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRegexMatchSets = "ListRegexMatchSets"

// ListRegexMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRegexMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegexMatchSets for more information on using the ListRegexMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegexMatchSetsRequest method.
//    req, resp := client.ListRegexMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRegexMatchSets
func (c *WAFRegional) ListRegexMatchSetsRequest(input *waf.ListRegexMatchSetsInput) (req *request.Request, output *waf.ListRegexMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListRegexMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListRegexMatchSetsInput{}
	}

	output = &waf.ListRegexMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRegexMatchSets API operation for AWS WAF Regional.
//
// Returns an array of RegexMatchSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListRegexMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRegexMatchSets
func (c *WAFRegional) ListRegexMatchSets(input *waf.ListRegexMatchSetsInput) (*waf.ListRegexMatchSetsOutput, error) {
	req, out := c.ListRegexMatchSetsRequest(input)
	return out, req.Send()
}

// ListRegexMatchSetsWithContext is the same as ListRegexMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegexMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListRegexMatchSetsWithContext(ctx aws.Context, input *waf.ListRegexMatchSetsInput, opts ...request.Option) (*waf.ListRegexMatchSetsOutput, error) {
	req, out := c.ListRegexMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRegexPatternSets = "ListRegexPatternSets"

// ListRegexPatternSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRegexPatternSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegexPatternSets for more information on using the ListRegexPatternSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegexPatternSetsRequest method.
//    req, resp := client.ListRegexPatternSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRegexPatternSets
func (c *WAFRegional) ListRegexPatternSetsRequest(input *waf.ListRegexPatternSetsInput) (req *request.Request, output *waf.ListRegexPatternSetsOutput) {
	op := &request.Operation{
		Name:       opListRegexPatternSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListRegexPatternSetsInput{}
	}

	output = &waf.ListRegexPatternSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRegexPatternSets API operation for AWS WAF Regional.
//
// Returns an array of RegexPatternSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListRegexPatternSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRegexPatternSets
func (c *WAFRegional) ListRegexPatternSets(input *waf.ListRegexPatternSetsInput) (*waf.ListRegexPatternSetsOutput, error) {
	req, out := c.ListRegexPatternSetsRequest(input)
	return out, req.Send()
}

// ListRegexPatternSetsWithContext is the same as ListRegexPatternSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegexPatternSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListRegexPatternSetsWithContext(ctx aws.Context, input *waf.ListRegexPatternSetsInput, opts ...request.Option) (*waf.ListRegexPatternSetsOutput, error) {
	req, out := c.ListRegexPatternSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourcesForWebACL = "ListResourcesForWebACL"

// ListResourcesForWebACLRequest generates a "aws/request.Request" representing the
// client's request for the ListResourcesForWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourcesForWebACL for more information on using the ListResourcesForWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesForWebACLRequest method.
//    req, resp := client.ListResourcesForWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACL
func (c *WAFRegional) ListResourcesForWebACLRequest(input *ListResourcesForWebACLInput) (req *request.Request, output *ListResourcesForWebACLOutput) {
	op := &request.Operation{
		Name:       opListResourcesForWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesForWebACLInput{}
	}

	output = &ListResourcesForWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourcesForWebACL API operation for AWS WAF Regional.
//
// Returns an array of resources associated with the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListResourcesForWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACL
func (c *WAFRegional) ListResourcesForWebACL(input *ListResourcesForWebACLInput) (*ListResourcesForWebACLOutput, error) {
	req, out := c.ListResourcesForWebACLRequest(input)
	return out, req.Send()
}

// ListResourcesForWebACLWithContext is the same as ListResourcesForWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourcesForWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListResourcesForWebACLWithContext(ctx aws.Context, input *ListResourcesForWebACLInput, opts ...request.Option) (*ListResourcesForWebACLOutput, error) {
	req, out := c.ListResourcesForWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuleGroups = "ListRuleGroups"

// ListRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleGroups for more information on using the ListRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRuleGroupsRequest method.
//    req, resp := client.ListRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRuleGroups
func (c *WAFRegional) ListRuleGroupsRequest(input *waf.ListRuleGroupsInput) (req *request.Request, output *waf.ListRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListRuleGroupsInput{}
	}

	output = &waf.ListRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleGroups API operation for AWS WAF Regional.
//
// Returns an array of RuleGroup objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListRuleGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRuleGroups
func (c *WAFRegional) ListRuleGroups(input *waf.ListRuleGroupsInput) (*waf.ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	return out, req.Send()
}

// ListRuleGroupsWithContext is the same as ListRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListRuleGroupsWithContext(ctx aws.Context, input *waf.ListRuleGroupsInput, opts ...request.Option) (*waf.ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRulesRequest method.
//    req, resp := client.ListRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRules
func (c *WAFRegional) ListRulesRequest(input *waf.ListRulesInput) (req *request.Request, output *waf.ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListRulesInput{}
	}

	output = &waf.ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for AWS WAF Regional.
//
// Returns an array of RuleSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRules
func (c *WAFRegional) ListRules(input *waf.ListRulesInput) (*waf.ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListRulesWithContext(ctx aws.Context, input *waf.ListRulesInput, opts ...request.Option) (*waf.ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSizeConstraintSets = "ListSizeConstraintSets"

// ListSizeConstraintSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSizeConstraintSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSizeConstraintSets for more information on using the ListSizeConstraintSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSizeConstraintSetsRequest method.
//    req, resp := client.ListSizeConstraintSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSizeConstraintSets
func (c *WAFRegional) ListSizeConstraintSetsRequest(input *waf.ListSizeConstraintSetsInput) (req *request.Request, output *waf.ListSizeConstraintSetsOutput) {
	op := &request.Operation{
		Name:       opListSizeConstraintSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListSizeConstraintSetsInput{}
	}

	output = &waf.ListSizeConstraintSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSizeConstraintSets API operation for AWS WAF Regional.
//
// Returns an array of SizeConstraintSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListSizeConstraintSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSizeConstraintSets
func (c *WAFRegional) ListSizeConstraintSets(input *waf.ListSizeConstraintSetsInput) (*waf.ListSizeConstraintSetsOutput, error) {
	req, out := c.ListSizeConstraintSetsRequest(input)
	return out, req.Send()
}

// ListSizeConstraintSetsWithContext is the same as ListSizeConstraintSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSizeConstraintSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListSizeConstraintSetsWithContext(ctx aws.Context, input *waf.ListSizeConstraintSetsInput, opts ...request.Option) (*waf.ListSizeConstraintSetsOutput, error) {
	req, out := c.ListSizeConstraintSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSqlInjectionMatchSets = "ListSqlInjectionMatchSets"

// ListSqlInjectionMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSqlInjectionMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSqlInjectionMatchSets for more information on using the ListSqlInjectionMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSqlInjectionMatchSetsRequest method.
//    req, resp := client.ListSqlInjectionMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSqlInjectionMatchSets
func (c *WAFRegional) ListSqlInjectionMatchSetsRequest(input *waf.ListSqlInjectionMatchSetsInput) (req *request.Request, output *waf.ListSqlInjectionMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListSqlInjectionMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListSqlInjectionMatchSetsInput{}
	}

	output = &waf.ListSqlInjectionMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSqlInjectionMatchSets API operation for AWS WAF Regional.
//
// Returns an array of SqlInjectionMatchSet objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListSqlInjectionMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSqlInjectionMatchSets
func (c *WAFRegional) ListSqlInjectionMatchSets(input *waf.ListSqlInjectionMatchSetsInput) (*waf.ListSqlInjectionMatchSetsOutput, error) {
	req, out := c.ListSqlInjectionMatchSetsRequest(input)
	return out, req.Send()
}

// ListSqlInjectionMatchSetsWithContext is the same as ListSqlInjectionMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSqlInjectionMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListSqlInjectionMatchSetsWithContext(ctx aws.Context, input *waf.ListSqlInjectionMatchSetsInput, opts ...request.Option) (*waf.ListSqlInjectionMatchSetsOutput, error) {
	req, out := c.ListSqlInjectionMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSubscribedRuleGroups = "ListSubscribedRuleGroups"

// ListSubscribedRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscribedRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscribedRuleGroups for more information on using the ListSubscribedRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscribedRuleGroupsRequest method.
//    req, resp := client.ListSubscribedRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSubscribedRuleGroups
func (c *WAFRegional) ListSubscribedRuleGroupsRequest(input *waf.ListSubscribedRuleGroupsInput) (req *request.Request, output *waf.ListSubscribedRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListSubscribedRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListSubscribedRuleGroupsInput{}
	}

	output = &waf.ListSubscribedRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscribedRuleGroups API operation for AWS WAF Regional.
//
// Returns an array of RuleGroup objects that you are subscribed to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListSubscribedRuleGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSubscribedRuleGroups
func (c *WAFRegional) ListSubscribedRuleGroups(input *waf.ListSubscribedRuleGroupsInput) (*waf.ListSubscribedRuleGroupsOutput, error) {
	req, out := c.ListSubscribedRuleGroupsRequest(input)
	return out, req.Send()
}

// ListSubscribedRuleGroupsWithContext is the same as ListSubscribedRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscribedRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListSubscribedRuleGroupsWithContext(ctx aws.Context, input *waf.ListSubscribedRuleGroupsInput, opts ...request.Option) (*waf.ListSubscribedRuleGroupsOutput, error) {
	req, out := c.ListSubscribedRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWebACLs = "ListWebACLs"

// ListWebACLsRequest generates a "aws/request.Request" representing the
// client's request for the ListWebACLs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWebACLs for more information on using the ListWebACLs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWebACLsRequest method.
//    req, resp := client.ListWebACLsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListWebACLs
func (c *WAFRegional) ListWebACLsRequest(input *waf.ListWebACLsInput) (req *request.Request, output *waf.ListWebACLsOutput) {
	op := &request.Operation{
		Name:       opListWebACLs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListWebACLsInput{}
	}

	output = &waf.ListWebACLsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebACLs API operation for AWS WAF Regional.
//
// Returns an array of WebACLSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListWebACLs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListWebACLs
func (c *WAFRegional) ListWebACLs(input *waf.ListWebACLsInput) (*waf.ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	return out, req.Send()
}

// ListWebACLsWithContext is the same as ListWebACLs with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebACLs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListWebACLsWithContext(ctx aws.Context, input *waf.ListWebACLsInput, opts ...request.Option) (*waf.ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListXssMatchSets = "ListXssMatchSets"

// ListXssMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListXssMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListXssMatchSets for more information on using the ListXssMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListXssMatchSetsRequest method.
//    req, resp := client.ListXssMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListXssMatchSets
func (c *WAFRegional) ListXssMatchSetsRequest(input *waf.ListXssMatchSetsInput) (req *request.Request, output *waf.ListXssMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListXssMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListXssMatchSetsInput{}
	}

	output = &waf.ListXssMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListXssMatchSets API operation for AWS WAF Regional.
//
// Returns an array of XssMatchSet objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListXssMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListXssMatchSets
func (c *WAFRegional) ListXssMatchSets(input *waf.ListXssMatchSetsInput) (*waf.ListXssMatchSetsOutput, error) {
	req, out := c.ListXssMatchSetsRequest(input)
	return out, req.Send()
}

// ListXssMatchSetsWithContext is the same as ListXssMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListXssMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListXssMatchSetsWithContext(ctx aws.Context, input *waf.ListXssMatchSetsInput, opts ...request.Option) (*waf.ListXssMatchSetsOutput, error) {
	req, out := c.ListXssMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingConfiguration = "PutLoggingConfiguration"

// PutLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingConfiguration for more information on using the PutLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLoggingConfigurationRequest method.
//    req, resp := client.PutLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/PutLoggingConfiguration
func (c *WAFRegional) PutLoggingConfigurationRequest(input *waf.PutLoggingConfigurationInput) (req *request.Request, output *waf.PutLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.PutLoggingConfigurationInput{}
	}

	output = &waf.PutLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutLoggingConfiguration API operation for AWS WAF Regional.
//
// Associates a LoggingConfiguration with a specified web ACL.
//
// You can access information about all traffic that AWS WAF inspects using
// the following steps:
//
// Create an Amazon Kinesis Data Firehose .
//
// Create the data firehose with a PUT source and in the region that you are
// operating. However, if you are capturing logs for Amazon CloudFront, always
// create the firehose in US East (N. Virginia).
//
// Associate that firehose to your web ACL using a PutLoggingConfiguration request.
//
// When you successfully enable logging using a PutLoggingConfiguration request,
// AWS WAF will create a service linked role with the necessary permissions
// to write logs to the Amazon Kinesis Data Firehose. For more information,
// see Logging Web ACL Traffic Information (https://docs.aws.amazon.com/waf/latest/developerguide/logging.html)
// in the AWS WAF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation PutLoggingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFServiceLinkedRoleErrorException "WAFServiceLinkedRoleErrorException"
//   AWS WAF is not able to access the service linked role. This can be caused
//   by a previous PutLoggingConfiguration request, which can lock the service
//   linked role for about 20 seconds. Please try your request again. The service
//   linked role can also be locked by a previous DeleteServiceLinkedRole request,
//   which can lock the role for 15 minutes or more. If you recently made a DeleteServiceLinkedRole,
//   wait at least 15 minutes and try the request again. If you receive this same
//   exception again, you will have to wait additional time until the role is
//   unlocked.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/PutLoggingConfiguration
func (c *WAFRegional) PutLoggingConfiguration(input *waf.PutLoggingConfigurationInput) (*waf.PutLoggingConfigurationOutput, error) {
	req, out := c.PutLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutLoggingConfigurationWithContext is the same as PutLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) PutLoggingConfigurationWithContext(ctx aws.Context, input *waf.PutLoggingConfigurationInput, opts ...request.Option) (*waf.PutLoggingConfigurationOutput, error) {
	req, out := c.PutLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPermissionPolicy = "PutPermissionPolicy"

// PutPermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutPermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPermissionPolicy for more information on using the PutPermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPermissionPolicyRequest method.
//    req, resp := client.PutPermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/PutPermissionPolicy
func (c *WAFRegional) PutPermissionPolicyRequest(input *waf.PutPermissionPolicyInput) (req *request.Request, output *waf.PutPermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opPutPermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.PutPermissionPolicyInput{}
	}

	output = &waf.PutPermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPermissionPolicy API operation for AWS WAF Regional.
//
// Attaches a IAM policy to the specified resource. The only supported use for
// this action is to share a RuleGroup across accounts.
//
// The PutPermissionPolicy is subject to the following restrictions:
//
//    * You can attach only one policy with each PutPermissionPolicy request.
//
//    * The policy must include an Effect, Action and Principal.
//
//    * Effect must specify Allow.
//
//    * The Action in the policy must be waf:UpdateWebACL, waf-regional:UpdateWebACL,
//    waf:GetRuleGroup and waf-regional:GetRuleGroup . Any extra or wildcard
//    actions in the policy will be rejected.
//
//    * The policy cannot include a Resource parameter.
//
//    * The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup
//    must exist in the same region.
//
//    * The user making the request must be the owner of the RuleGroup.
//
//    * Your policy must be composed using IAM Policy version 2012-10-17.
//
// For more information, see IAM Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
//
// An example of a valid policy parameter is shown in the Examples section below.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation PutPermissionPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidPermissionPolicyException "WAFInvalidPermissionPolicyException"
//   The operation failed because the specified policy is not in the proper format.
//
//   The policy is subject to the following restrictions:
//
//      * You can attach only one policy with each PutPermissionPolicy request.
//
//      * The policy must include an Effect, Action and Principal.
//
//      * Effect must specify Allow.
//
//      * The Action in the policy must be waf:UpdateWebACL, waf-regional:UpdateWebACL,
//      waf:GetRuleGroup and waf-regional:GetRuleGroup . Any extra or wildcard
//      actions in the policy will be rejected.
//
//      * The policy cannot include a Resource parameter.
//
//      * The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup
//      must exist in the same region.
//
//      * The user making the request must be the owner of the RuleGroup.
//
//      * Your policy must be composed using IAM Policy version 2012-10-17.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/PutPermissionPolicy
func (c *WAFRegional) PutPermissionPolicy(input *waf.PutPermissionPolicyInput) (*waf.PutPermissionPolicyOutput, error) {
	req, out := c.PutPermissionPolicyRequest(input)
	return out, req.Send()
}

// PutPermissionPolicyWithContext is the same as PutPermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutPermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) PutPermissionPolicyWithContext(ctx aws.Context, input *waf.PutPermissionPolicyInput, opts ...request.Option) (*waf.PutPermissionPolicyOutput, error) {
	req, out := c.PutPermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateByteMatchSet = "UpdateByteMatchSet"

// UpdateByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateByteMatchSet for more information on using the UpdateByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateByteMatchSetRequest method.
//    req, resp := client.UpdateByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateByteMatchSet
func (c *WAFRegional) UpdateByteMatchSetRequest(input *waf.UpdateByteMatchSetInput) (req *request.Request, output *waf.UpdateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateByteMatchSetInput{}
	}

	output = &waf.UpdateByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateByteMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet. For
// each ByteMatchTuple object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a ByteMatchSetUpdate object, you delete the existing object and
//    add a new one.
//
//    * The part of a web request that you want AWS WAF to inspect, such as
//    a query string or the value of the User-Agent header.
//
//    * The bytes (typically a string that corresponds with ASCII characters)
//    that you want AWS WAF to look for. For more information, including how
//    you specify the values for the AWS WAF API and the AWS CLI or SDKs, see
//    TargetString in the ByteMatchTuple data type.
//
//    * Where to look, such as at the beginning or the end of a query string.
//
//    * Whether to perform any conversions on the request, such as converting
//    it to lowercase, before inspecting it for the specified string.
//
// For example, you can add a ByteMatchSetUpdate object that matches web requests
// in which User-Agent headers contain the string BadBot. You can then configure
// AWS WAF to block those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
// Create a ByteMatchSet. For more information, see CreateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request.
//
// Submit an UpdateByteMatchSet request to specify the part of the request that
// you want AWS WAF to inspect (for example, the header or the URI) and the
// value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateByteMatchSet
func (c *WAFRegional) UpdateByteMatchSet(input *waf.UpdateByteMatchSetInput) (*waf.UpdateByteMatchSetOutput, error) {
	req, out := c.UpdateByteMatchSetRequest(input)
	return out, req.Send()
}

// UpdateByteMatchSetWithContext is the same as UpdateByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateByteMatchSetWithContext(ctx aws.Context, input *waf.UpdateByteMatchSetInput, opts ...request.Option) (*waf.UpdateByteMatchSetOutput, error) {
	req, out := c.UpdateByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGeoMatchSet = "UpdateGeoMatchSet"

// UpdateGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGeoMatchSet for more information on using the UpdateGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGeoMatchSetRequest method.
//    req, resp := client.UpdateGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateGeoMatchSet
func (c *WAFRegional) UpdateGeoMatchSetRequest(input *waf.UpdateGeoMatchSetInput) (req *request.Request, output *waf.UpdateGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateGeoMatchSetInput{}
	}

	output = &waf.UpdateGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGeoMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes GeoMatchConstraint objects in an GeoMatchSet. For each
// GeoMatchConstraint object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change an GeoMatchConstraint object, you delete the existing object and
//    add a new one.
//
//    * The Type. The only valid value for Type is Country.
//
//    * The Value, which is a two character code for the country to add to the
//    GeoMatchConstraint object. Valid codes are listed in GeoMatchConstraint$Value.
//
// To create and configure an GeoMatchSet, perform the following steps:
//
// Submit a CreateGeoMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateGeoMatchSet request.
//
// Submit an UpdateGeoMatchSet request to specify the country that you want
// AWS WAF to watch for.
//
// When you update an GeoMatchSet, you specify the country that you want to
// add and/or the country that you want to delete. If you want to change a country,
// you delete the existing country and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateGeoMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateGeoMatchSet
func (c *WAFRegional) UpdateGeoMatchSet(input *waf.UpdateGeoMatchSetInput) (*waf.UpdateGeoMatchSetOutput, error) {
	req, out := c.UpdateGeoMatchSetRequest(input)
	return out, req.Send()
}

// UpdateGeoMatchSetWithContext is the same as UpdateGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateGeoMatchSetWithContext(ctx aws.Context, input *waf.UpdateGeoMatchSetInput, opts ...request.Option) (*waf.UpdateGeoMatchSetOutput, error) {
	req, out := c.UpdateGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIPSet = "UpdateIPSet"

// UpdateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIPSet for more information on using the UpdateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIPSetRequest method.
//    req, resp := client.UpdateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateIPSet
func (c *WAFRegional) UpdateIPSetRequest(input *waf.UpdateIPSetInput) (req *request.Request, output *waf.UpdateIPSetOutput) {
	op := &request.Operation{
		Name:       opUpdateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateIPSetInput{}
	}

	output = &waf.UpdateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIPSet API operation for AWS WAF Regional.
//
// Inserts or deletes IPSetDescriptor objects in an IPSet. For each IPSetDescriptor
// object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change an IPSetDescriptor object, you delete the existing object and add
//    a new one.
//
//    * The IP address version, IPv4 or IPv6.
//
//    * The IP address in CIDR notation, for example, 192.0.2.0/24 (for the
//    range of IP addresses from 192.0.2.0 to 192.0.2.255) or 192.0.2.44/32
//    (for the individual IP address 192.0.2.44).
//
// AWS WAF supports IPv4 address ranges: /8 and any range between /16 through
// /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128.
// For more information about CIDR notation, see the Wikipedia entry Classless
// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// IPv6 addresses can be represented using any of the following formats:
//
//    * 1111:0000:0000:0000:0000:0000:0000:0111/128
//
//    * 1111:0:0:0:0:0:0:0111/128
//
//    * 1111::0111/128
//
//    * 1111::111/128
//
// You use an IPSet to specify which web requests you want to allow or block
// based on the IP addresses that the requests originated from. For example,
// if you're receiving a lot of requests from one or a small number of IP addresses
// and you want to block the requests, you can create an IPSet that specifies
// those IP addresses, and then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
// Submit a CreateIPSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateIPSet request to specify the IP addresses that you want AWS
// WAF to watch for.
//
// When you update an IPSet, you specify the IP addresses that you want to add
// and/or the IP addresses that you want to delete. If you want to change an
// IP address, you delete the existing IP address and add the new one.
//
// You can insert a maximum of 1000 addresses in a single request.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateIPSet
func (c *WAFRegional) UpdateIPSet(input *waf.UpdateIPSetInput) (*waf.UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	return out, req.Send()
}

// UpdateIPSetWithContext is the same as UpdateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateIPSetWithContext(ctx aws.Context, input *waf.UpdateIPSetInput, opts ...request.Option) (*waf.UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRateBasedRule = "UpdateRateBasedRule"

// UpdateRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRateBasedRule for more information on using the UpdateRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRateBasedRuleRequest method.
//    req, resp := client.UpdateRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRateBasedRule
func (c *WAFRegional) UpdateRateBasedRuleRequest(input *waf.UpdateRateBasedRuleInput) (req *request.Request, output *waf.UpdateRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateRateBasedRuleInput{}
	}

	output = &waf.UpdateRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRateBasedRule API operation for AWS WAF Regional.
//
// Inserts or deletes Predicate objects in a rule and updates the RateLimit
// in the rule.
//
// Each Predicate object identifies a predicate, such as a ByteMatchSet or an
// IPSet, that specifies the web requests that you want to block or count. The
// RateLimit specifies the number of requests every five minutes that triggers
// the rule.
//
// If you add more than one predicate to a RateBasedRule, a request must match
// all the predicates and exceed the RateLimit to be counted or blocked. For
// example, suppose you add the following to a RateBasedRule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// Further, you specify a RateLimit of 15,000.
//
// You then add the RateBasedRule to a WebACL and specify that you want to block
// requests that satisfy the rule. For a request to be blocked, it must come
// from the IP address 192.0.2.44 and the User-Agent header in the request must
// contain the value BadBot. Further, requests that match these two conditions
// much be received at a rate of more than 15,000 every five minutes. If the
// rate drops below this limit, AWS WAF no longer blocks the requests.
//
// As a second example, suppose you want to limit requests to a particular page
// on your site. To do this, you could add the following to a RateBasedRule:
//
//    * A ByteMatchSet with FieldToMatch of URI
//
//    * A PositionalConstraint of STARTS_WITH
//
//    * A TargetString of login
//
// Further, you specify a RateLimit of 15,000.
//
// By adding this RateBasedRule to a WebACL, you could limit requests to your
// login page without affecting the rest of your site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateRateBasedRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRateBasedRule
func (c *WAFRegional) UpdateRateBasedRule(input *waf.UpdateRateBasedRuleInput) (*waf.UpdateRateBasedRuleOutput, error) {
	req, out := c.UpdateRateBasedRuleRequest(input)
	return out, req.Send()
}

// UpdateRateBasedRuleWithContext is the same as UpdateRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateRateBasedRuleWithContext(ctx aws.Context, input *waf.UpdateRateBasedRuleInput, opts ...request.Option) (*waf.UpdateRateBasedRuleOutput, error) {
	req, out := c.UpdateRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegexMatchSet = "UpdateRegexMatchSet"

// UpdateRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegexMatchSet for more information on using the UpdateRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRegexMatchSetRequest method.
//    req, resp := client.UpdateRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRegexMatchSet
func (c *WAFRegional) UpdateRegexMatchSetRequest(input *waf.UpdateRegexMatchSetInput) (req *request.Request, output *waf.UpdateRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateRegexMatchSetInput{}
	}

	output = &waf.UpdateRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRegexMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes RegexMatchTuple objects (filters) in a RegexMatchSet.
// For each RegexMatchSetUpdate object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a RegexMatchSetUpdate object, you delete the existing object and
//    add a new one.
//
//    * The part of a web request that you want AWS WAF to inspectupdate, such
//    as a query string or the value of the User-Agent header.
//
//    * The identifier of the pattern (a regular expression) that you want AWS
//    WAF to look for. For more information, see RegexPatternSet.
//
//    * Whether to perform any conversions on the request, such as converting
//    it to lowercase, before inspecting it for the specified string.
//
// For example, you can create a RegexPatternSet that matches any requests with
// User-Agent headers that contain the string B[a@]dB[o0]t. You can then configure
// AWS WAF to reject those requests.
//
// To create and configure a RegexMatchSet, perform the following steps:
//
// Create a RegexMatchSet. For more information, see CreateRegexMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexMatchSet request.
//
// Submit an UpdateRegexMatchSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the identifier of the RegexPatternSet that contain the regular expression
// patters you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateRegexMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRegexMatchSet
func (c *WAFRegional) UpdateRegexMatchSet(input *waf.UpdateRegexMatchSetInput) (*waf.UpdateRegexMatchSetOutput, error) {
	req, out := c.UpdateRegexMatchSetRequest(input)
	return out, req.Send()
}

// UpdateRegexMatchSetWithContext is the same as UpdateRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateRegexMatchSetWithContext(ctx aws.Context, input *waf.UpdateRegexMatchSetInput, opts ...request.Option) (*waf.UpdateRegexMatchSetOutput, error) {
	req, out := c.UpdateRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegexPatternSet = "UpdateRegexPatternSet"

// UpdateRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegexPatternSet for more information on using the UpdateRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRegexPatternSetRequest method.
//    req, resp := client.UpdateRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRegexPatternSet
func (c *WAFRegional) UpdateRegexPatternSetRequest(input *waf.UpdateRegexPatternSetInput) (req *request.Request, output *waf.UpdateRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opUpdateRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateRegexPatternSetInput{}
	}

	output = &waf.UpdateRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRegexPatternSet API operation for AWS WAF Regional.
//
// Inserts or deletes RegexPatternString objects in a RegexPatternSet. For each
// RegexPatternString object, you specify the following values:
//
//    * Whether to insert or delete the RegexPatternString.
//
//    * The regular expression pattern that you want to insert or delete. For
//    more information, see RegexPatternSet.
//
// For example, you can create a RegexPatternString such as B[a@]dB[o0]t. AWS
// WAF will match this RegexPatternString to:
//
//    * BadBot
//
//    * BadB0t
//
//    * B@dBot
//
//    * B@dB0t
//
// To create and configure a RegexPatternSet, perform the following steps:
//
// Create a RegexPatternSet. For more information, see CreateRegexPatternSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexPatternSet request.
//
// Submit an UpdateRegexPatternSet request to specify the regular expression
// pattern that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateRegexPatternSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidRegexPatternException "WAFInvalidRegexPatternException"
//   The regular expression (regex) you specified in RegexPatternString is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRegexPatternSet
func (c *WAFRegional) UpdateRegexPatternSet(input *waf.UpdateRegexPatternSetInput) (*waf.UpdateRegexPatternSetOutput, error) {
	req, out := c.UpdateRegexPatternSetRequest(input)
	return out, req.Send()
}

// UpdateRegexPatternSetWithContext is the same as UpdateRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateRegexPatternSetWithContext(ctx aws.Context, input *waf.UpdateRegexPatternSetInput, opts ...request.Option) (*waf.UpdateRegexPatternSetOutput, error) {
	req, out := c.UpdateRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRule for more information on using the UpdateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleRequest method.
//    req, resp := client.UpdateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRule
func (c *WAFRegional) UpdateRuleRequest(input *waf.UpdateRuleInput) (req *request.Request, output *waf.UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateRuleInput{}
	}

	output = &waf.UpdateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRule API operation for AWS WAF Regional.
//
// Inserts or deletes Predicate objects in a Rule. Each Predicate object identifies
// a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests
// that you want to allow, block, or count. If you add more than one predicate
// to a Rule, a request must match all of the specifications to be allowed,
// blocked, or counted. For example, suppose that you add the following to a
// Rule:
//
//    * A ByteMatchSet that matches the value BadBot in the User-Agent header
//
//    * An IPSet that matches the IP address 192.0.2.44
//
// You then add the Rule to a WebACL and specify that you want to block requests
// that satisfy the Rule. For a request to be blocked, the User-Agent header
// in the request must contain the value BadBotand the request must originate
// from the IP address 192.0.2.44.
//
// To create and configure a Rule, perform the following steps:
//
// Create and update the predicates that you want to include in the Rule.
//
// Create the Rule. See CreateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRule request to add predicates to the Rule.
//
// Create and update a WebACL that contains the Rule. See CreateWebACL.
//
// If you want to replace one ByteMatchSet or IPSet with another, you delete
// the existing one and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRule
func (c *WAFRegional) UpdateRule(input *waf.UpdateRuleInput) (*waf.UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	return out, req.Send()
}

// UpdateRuleWithContext is the same as UpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateRuleWithContext(ctx aws.Context, input *waf.UpdateRuleInput, opts ...request.Option) (*waf.UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleGroup = "UpdateRuleGroup"

// UpdateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleGroup for more information on using the UpdateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleGroupRequest method.
//    req, resp := client.UpdateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRuleGroup
func (c *WAFRegional) UpdateRuleGroupRequest(input *waf.UpdateRuleGroupInput) (req *request.Request, output *waf.UpdateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateRuleGroupInput{}
	}

	output = &waf.UpdateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleGroup API operation for AWS WAF Regional.
//
// Inserts or deletes ActivatedRule objects in a RuleGroup.
//
// You can only insert REGULAR rules into a rule group.
//
// You can have a maximum of ten rules per rule group.
//
// To create and configure a RuleGroup, perform the following steps:
//
// Create and update the Rules that you want to include in the RuleGroup. See
// CreateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRuleGroup request.
//
// Submit an UpdateRuleGroup request to add Rules to the RuleGroup.
//
// Create and update a WebACL that contains the RuleGroup. See CreateWebACL.
//
// If you want to replace one Rule with another, you delete the existing one
// and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateRuleGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRuleGroup
func (c *WAFRegional) UpdateRuleGroup(input *waf.UpdateRuleGroupInput) (*waf.UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	return out, req.Send()
}

// UpdateRuleGroupWithContext is the same as UpdateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateRuleGroupWithContext(ctx aws.Context, input *waf.UpdateRuleGroupInput, opts ...request.Option) (*waf.UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSizeConstraintSet = "UpdateSizeConstraintSet"

// UpdateSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSizeConstraintSet for more information on using the UpdateSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSizeConstraintSetRequest method.
//    req, resp := client.UpdateSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSizeConstraintSet
func (c *WAFRegional) UpdateSizeConstraintSetRequest(input *waf.UpdateSizeConstraintSetInput) (req *request.Request, output *waf.UpdateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateSizeConstraintSetInput{}
	}

	output = &waf.UpdateSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSizeConstraintSet API operation for AWS WAF Regional.
//
// Inserts or deletes SizeConstraint objects (filters) in a SizeConstraintSet.
// For each SizeConstraint object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a SizeConstraintSetUpdate object, you delete the existing object
//    and add a new one.
//
//    * The part of a web request that you want AWS WAF to evaluate, such as
//    the length of a query string or the length of the User-Agent header.
//
//    * Whether to perform any transformations on the request, such as converting
//    it to lowercase, before checking its length. Note that transformations
//    of the request body are not supported because the AWS resource forwards
//    only the first 8192 bytes of your request to AWS WAF.
//
// You can only specify a single type of TextTransformation.
//
//    * A ComparisonOperator used for evaluating the selected part of the request
//    against the specified Size, such as equals, greater than, less than, and
//    so on.
//
//    * The length, in bytes, that you want AWS WAF to watch for in selected
//    part of the request. The length is computed after applying the transformation.
//
// For example, you can add a SizeConstraintSetUpdate object that matches web
// requests in which the length of the User-Agent header is greater than 100
// bytes. You can then configure AWS WAF to block those requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
// Create a SizeConstraintSet. For more information, see CreateSizeConstraintSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSizeConstraintSet request.
//
// Submit an UpdateSizeConstraintSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSizeConstraintSet
func (c *WAFRegional) UpdateSizeConstraintSet(input *waf.UpdateSizeConstraintSetInput) (*waf.UpdateSizeConstraintSetOutput, error) {
	req, out := c.UpdateSizeConstraintSetRequest(input)
	return out, req.Send()
}

// UpdateSizeConstraintSetWithContext is the same as UpdateSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateSizeConstraintSetWithContext(ctx aws.Context, input *waf.UpdateSizeConstraintSetInput, opts ...request.Option) (*waf.UpdateSizeConstraintSetOutput, error) {
	req, out := c.UpdateSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSqlInjectionMatchSet = "UpdateSqlInjectionMatchSet"

// UpdateSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSqlInjectionMatchSet for more information on using the UpdateSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSqlInjectionMatchSetRequest method.
//    req, resp := client.UpdateSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSqlInjectionMatchSet
func (c *WAFRegional) UpdateSqlInjectionMatchSetRequest(input *waf.UpdateSqlInjectionMatchSetInput) (req *request.Request, output *waf.UpdateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateSqlInjectionMatchSetInput{}
	}

	output = &waf.UpdateSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes SqlInjectionMatchTuple objects (filters) in a SqlInjectionMatchSet.
// For each SqlInjectionMatchTuple object, you specify the following values:
//
//    * Action: Whether to insert the object into or delete the object from
//    the array. To change a SqlInjectionMatchTuple, you delete the existing
//    object and add a new one.
//
//    * FieldToMatch: The part of web requests that you want AWS WAF to inspect
//    and, if you want AWS WAF to inspect a header or custom query parameter,
//    the name of the header or parameter.
//
//    * TextTransformation: Which text transformation, if any, to perform on
//    the web request before inspecting the request for snippets of malicious
//    SQL code.
//
// You can only specify a single type of TextTransformation.
//
// You use SqlInjectionMatchSet objects to specify which CloudFront requests
// that you want to allow, block, or count. For example, if you're receiving
// requests that contain snippets of SQL code in the query string and you want
// to block the requests, you can create a SqlInjectionMatchSet with the applicable
// settings, and then configure AWS WAF to block the requests.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
// Submit a CreateSqlInjectionMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateSqlInjectionMatchSet request to specify the parts of web
// requests that you want AWS WAF to inspect for snippets of SQL code.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSqlInjectionMatchSet
func (c *WAFRegional) UpdateSqlInjectionMatchSet(input *waf.UpdateSqlInjectionMatchSetInput) (*waf.UpdateSqlInjectionMatchSetOutput, error) {
	req, out := c.UpdateSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// UpdateSqlInjectionMatchSetWithContext is the same as UpdateSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.UpdateSqlInjectionMatchSetInput, opts ...request.Option) (*waf.UpdateSqlInjectionMatchSetOutput, error) {
	req, out := c.UpdateSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWebACL = "UpdateWebACL"

// UpdateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWebACL for more information on using the UpdateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWebACLRequest method.
//    req, resp := client.UpdateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateWebACL
func (c *WAFRegional) UpdateWebACLRequest(input *waf.UpdateWebACLInput) (req *request.Request, output *waf.UpdateWebACLOutput) {
	op := &request.Operation{
		Name:       opUpdateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateWebACLInput{}
	}

	output = &waf.UpdateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWebACL API operation for AWS WAF Regional.
//
// Inserts or deletes ActivatedRule objects in a WebACL. Each Rule identifies
// web requests that you want to allow, block, or count. When you update a WebACL,
// you specify the following values:
//
//    * A default action for the WebACL, either ALLOW or BLOCK. AWS WAF performs
//    the default action if a request doesn't match the criteria in any of the
//    Rules in a WebACL.
//
//    * The Rules that you want to add or delete. If you want to replace one
//    Rule with another, you delete the existing Rule and add the new one.
//
//    * For each Rule, whether you want AWS WAF to allow requests, block requests,
//    or count requests that match the conditions in the Rule.
//
//    * The order in which you want AWS WAF to evaluate the Rules in a WebACL.
//    If you add more than one Rule to a WebACL, AWS WAF evaluates each request
//    against the Rules in order based on the value of Priority. (The Rule that
//    has the lowest value for Priority is evaluated first.) When a web request
//    matches all the predicates (such as ByteMatchSets and IPSets) in a Rule,
//    AWS WAF immediately takes the corresponding action, allow or block, and
//    doesn't evaluate the request against the remaining Rules in the WebACL,
//    if any.
//
// To create and configure a WebACL, perform the following steps:
//
// Create and update the predicates that you want to include in Rules. For more
// information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet,
// CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
//
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule.
//
// Create a WebACL. See CreateWebACL.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateWebACL request.
//
// Submit an UpdateWebACL request to specify the Rules that you want to include
// in the WebACL, to specify the default action, and to associate the WebACL
// with a CloudFront distribution.
//
// The ActivatedRule can be a rule group. If you specify a rule group as your
// ActivatedRule, you can exclude specific rules from that rule group.
//
// If you already have a rule group associated with a web ACL and want to submit
// an UpdateWebACL request to exclude certain rules from that rule group, you
// must first remove the rule group from the web ACL, the re-insert it again,
// specifying the excluded rules. For details, see ActivatedRule$ExcludedRules.
//
// Be aware that if you try to add a RATE_BASED rule to a web ACL without setting
// the rule type when first creating the rule, the UpdateWebACL request will
// fail because the request tries to add a REGULAR rule (the default rule type)
// with the specified ID, which does not exist.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * ErrCodeWAFSubscriptionNotFoundException "WAFSubscriptionNotFoundException"
//   The specified subscription does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateWebACL
func (c *WAFRegional) UpdateWebACL(input *waf.UpdateWebACLInput) (*waf.UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	return out, req.Send()
}

// UpdateWebACLWithContext is the same as UpdateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateWebACLWithContext(ctx aws.Context, input *waf.UpdateWebACLInput, opts ...request.Option) (*waf.UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateXssMatchSet = "UpdateXssMatchSet"

// UpdateXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateXssMatchSet for more information on using the UpdateXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateXssMatchSetRequest method.
//    req, resp := client.UpdateXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateXssMatchSet
func (c *WAFRegional) UpdateXssMatchSetRequest(input *waf.UpdateXssMatchSetInput) (req *request.Request, output *waf.UpdateXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateXssMatchSetInput{}
	}

	output = &waf.UpdateXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateXssMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet. For
// each XssMatchTuple object, you specify the following values:
//
//    * Action: Whether to insert the object into or delete the object from
//    the array. To change an XssMatchTuple, you delete the existing object
//    and add a new one.
//
//    * FieldToMatch: The part of web requests that you want AWS WAF to inspect
//    and, if you want AWS WAF to inspect a header or custom query parameter,
//    the name of the header or parameter.
//
//    * TextTransformation: Which text transformation, if any, to perform on
//    the web request before inspecting the request for cross-site scripting
//    attacks.
//
// You can only specify a single type of TextTransformation.
//
// You use XssMatchSet objects to specify which CloudFront requests that you
// want to allow, block, or count. For example, if you're receiving requests
// that contain cross-site scripting attacks in the request body and you want
// to block the requests, you can create an XssMatchSet with the applicable
// settings, and then configure AWS WAF to block the requests.
//
// To create and configure an XssMatchSet, perform the following steps:
//
// Submit a CreateXssMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateXssMatchSet request to specify the parts of web requests
// that you want AWS WAF to inspect for cross-site scripting attacks.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateXssMatchSet
func (c *WAFRegional) UpdateXssMatchSet(input *waf.UpdateXssMatchSetInput) (*waf.UpdateXssMatchSetOutput, error) {
	req, out := c.UpdateXssMatchSetRequest(input)
	return out, req.Send()
}

// UpdateXssMatchSetWithContext is the same as UpdateXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateXssMatchSetWithContext(ctx aws.Context, input *waf.UpdateXssMatchSetInput, opts ...request.Option) (*waf.UpdateXssMatchSetOutput, error) {
	req, out := c.UpdateXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource to be protected, either an
	// application load balancer or Amazon API Gateway stage.
	//
	// The ARN should be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway stage: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A unique identifier (ID) for the web ACL.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWebACLInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AssociateWebACLInput) SetResourceArn(v string) *AssociateWebACLInput {
	s.ResourceArn = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *AssociateWebACLInput) SetWebACLId(v string) *AssociateWebACLInput {
	s.WebACLId = &v
	return s
}

type AssociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebACLOutput) GoString() string {
	return s.String()
}

type DisassociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource from which the web ACL is
	// being removed, either an application load balancer or Amazon API Gateway
	// stage.
	//
	// The ARN should be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway stage: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWebACLInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DisassociateWebACLInput) SetResourceArn(v string) *DisassociateWebACLInput {
	s.ResourceArn = &v
	return s
}

type DisassociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebACLOutput) GoString() string {
	return s.String()
}

type GetWebACLForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource for which to get the web ACL,
	// either an application load balancer or Amazon API Gateway stage.
	//
	// The ARN should be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway stage: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWebACLForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWebACLForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWebACLForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetWebACLForResourceInput) SetResourceArn(v string) *GetWebACLForResourceInput {
	s.ResourceArn = &v
	return s
}

type GetWebACLForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the web ACL that you specified in the GetWebACLForResource
	// request. If there is no associated resource, a null WebACLSummary is returned.
	WebACLSummary *waf.WebACLSummary `type:"structure"`
}

// String returns the string representation
func (s GetWebACLForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLForResourceOutput) GoString() string {
	return s.String()
}

// SetWebACLSummary sets the WebACLSummary field's value.
func (s *GetWebACLForResourceOutput) SetWebACLSummary(v *waf.WebACLSummary) *GetWebACLForResourceOutput {
	s.WebACLSummary = v
	return s
}

type ListResourcesForWebACLInput struct {
	_ struct{} `type:"structure"`

	// The type of resource to list, either an application load balancer or Amazon
	// API Gateway.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// The unique identifier (ID) of the web ACL for which to list the associated
	// resources.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesForWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesForWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesForWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesForWebACLInput"}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceType sets the ResourceType field's value.
func (s *ListResourcesForWebACLInput) SetResourceType(v string) *ListResourcesForWebACLInput {
	s.ResourceType = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *ListResourcesForWebACLInput) SetWebACLId(v string) *ListResourcesForWebACLInput {
	s.WebACLId = &v
	return s
}

type ListResourcesForWebACLOutput struct {
	_ struct{} `type:"structure"`

	// An array of ARNs (Amazon Resource Names) of the resources associated with
	// the specified web ACL. An array with zero elements is returned if there are
	// no resources associated with the web ACL.
	ResourceArns []*string `type:"list"`
}

// String returns the string representation
func (s ListResourcesForWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesForWebACLOutput) GoString() string {
	return s.String()
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ListResourcesForWebACLOutput) SetResourceArns(v []*string) *ListResourcesForWebACLOutput {
	s.ResourceArns = v
	return s
}

const (
	// ChangeActionInsert is a ChangeAction enum value
	ChangeActionInsert = "INSERT"

	// ChangeActionDelete is a ChangeAction enum value
	ChangeActionDelete = "DELETE"
)

const (
	// ChangeTokenStatusProvisioned is a ChangeTokenStatus enum value
	ChangeTokenStatusProvisioned = "PROVISIONED"

	// ChangeTokenStatusPending is a ChangeTokenStatus enum value
	ChangeTokenStatusPending = "PENDING"

	// ChangeTokenStatusInsync is a ChangeTokenStatus enum value
	ChangeTokenStatusInsync = "INSYNC"
)

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"
)

const (
	// GeoMatchConstraintTypeCountry is a GeoMatchConstraintType enum value
	GeoMatchConstraintTypeCountry = "Country"
)

const (
	// GeoMatchConstraintValueAf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAf = "AF"

	// GeoMatchConstraintValueAx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAx = "AX"

	// GeoMatchConstraintValueAl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAl = "AL"

	// GeoMatchConstraintValueDz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDz = "DZ"

	// GeoMatchConstraintValueAs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAs = "AS"

	// GeoMatchConstraintValueAd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAd = "AD"

	// GeoMatchConstraintValueAo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAo = "AO"

	// GeoMatchConstraintValueAi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAi = "AI"

	// GeoMatchConstraintValueAq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAq = "AQ"

	// GeoMatchConstraintValueAg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAg = "AG"

	// GeoMatchConstraintValueAr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAr = "AR"

	// GeoMatchConstraintValueAm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAm = "AM"

	// GeoMatchConstraintValueAw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAw = "AW"

	// GeoMatchConstraintValueAu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAu = "AU"

	// GeoMatchConstraintValueAt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAt = "AT"

	// GeoMatchConstraintValueAz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAz = "AZ"

	// GeoMatchConstraintValueBs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBs = "BS"

	// GeoMatchConstraintValueBh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBh = "BH"

	// GeoMatchConstraintValueBd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBd = "BD"

	// GeoMatchConstraintValueBb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBb = "BB"

	// GeoMatchConstraintValueBy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBy = "BY"

	// GeoMatchConstraintValueBe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBe = "BE"

	// GeoMatchConstraintValueBz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBz = "BZ"

	// GeoMatchConstraintValueBj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBj = "BJ"

	// GeoMatchConstraintValueBm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBm = "BM"

	// GeoMatchConstraintValueBt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBt = "BT"

	// GeoMatchConstraintValueBo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBo = "BO"

	// GeoMatchConstraintValueBq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBq = "BQ"

	// GeoMatchConstraintValueBa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBa = "BA"

	// GeoMatchConstraintValueBw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBw = "BW"

	// GeoMatchConstraintValueBv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBv = "BV"

	// GeoMatchConstraintValueBr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBr = "BR"

	// GeoMatchConstraintValueIo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIo = "IO"

	// GeoMatchConstraintValueBn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBn = "BN"

	// GeoMatchConstraintValueBg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBg = "BG"

	// GeoMatchConstraintValueBf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBf = "BF"

	// GeoMatchConstraintValueBi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBi = "BI"

	// GeoMatchConstraintValueKh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKh = "KH"

	// GeoMatchConstraintValueCm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCm = "CM"

	// GeoMatchConstraintValueCa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCa = "CA"

	// GeoMatchConstraintValueCv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCv = "CV"

	// GeoMatchConstraintValueKy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKy = "KY"

	// GeoMatchConstraintValueCf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCf = "CF"

	// GeoMatchConstraintValueTd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTd = "TD"

	// GeoMatchConstraintValueCl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCl = "CL"

	// GeoMatchConstraintValueCn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCn = "CN"

	// GeoMatchConstraintValueCx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCx = "CX"

	// GeoMatchConstraintValueCc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCc = "CC"

	// GeoMatchConstraintValueCo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCo = "CO"

	// GeoMatchConstraintValueKm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKm = "KM"

	// GeoMatchConstraintValueCg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCg = "CG"

	// GeoMatchConstraintValueCd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCd = "CD"

	// GeoMatchConstraintValueCk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCk = "CK"

	// GeoMatchConstraintValueCr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCr = "CR"

	// GeoMatchConstraintValueCi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCi = "CI"

	// GeoMatchConstraintValueHr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHr = "HR"

	// GeoMatchConstraintValueCu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCu = "CU"

	// GeoMatchConstraintValueCw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCw = "CW"

	// GeoMatchConstraintValueCy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCy = "CY"

	// GeoMatchConstraintValueCz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCz = "CZ"

	// GeoMatchConstraintValueDk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDk = "DK"

	// GeoMatchConstraintValueDj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDj = "DJ"

	// GeoMatchConstraintValueDm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDm = "DM"

	// GeoMatchConstraintValueDo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDo = "DO"

	// GeoMatchConstraintValueEc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEc = "EC"

	// GeoMatchConstraintValueEg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEg = "EG"

	// GeoMatchConstraintValueSv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSv = "SV"

	// GeoMatchConstraintValueGq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGq = "GQ"

	// GeoMatchConstraintValueEr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEr = "ER"

	// GeoMatchConstraintValueEe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEe = "EE"

	// GeoMatchConstraintValueEt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEt = "ET"

	// GeoMatchConstraintValueFk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFk = "FK"

	// GeoMatchConstraintValueFo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFo = "FO"

	// GeoMatchConstraintValueFj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFj = "FJ"

	// GeoMatchConstraintValueFi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFi = "FI"

	// GeoMatchConstraintValueFr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFr = "FR"

	// GeoMatchConstraintValueGf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGf = "GF"

	// GeoMatchConstraintValuePf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePf = "PF"

	// GeoMatchConstraintValueTf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTf = "TF"

	// GeoMatchConstraintValueGa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGa = "GA"

	// GeoMatchConstraintValueGm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGm = "GM"

	// GeoMatchConstraintValueGe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGe = "GE"

	// GeoMatchConstraintValueDe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDe = "DE"

	// GeoMatchConstraintValueGh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGh = "GH"

	// GeoMatchConstraintValueGi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGi = "GI"

	// GeoMatchConstraintValueGr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGr = "GR"

	// GeoMatchConstraintValueGl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGl = "GL"

	// GeoMatchConstraintValueGd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGd = "GD"

	// GeoMatchConstraintValueGp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGp = "GP"

	// GeoMatchConstraintValueGu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGu = "GU"

	// GeoMatchConstraintValueGt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGt = "GT"

	// GeoMatchConstraintValueGg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGg = "GG"

	// GeoMatchConstraintValueGn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGn = "GN"

	// GeoMatchConstraintValueGw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGw = "GW"

	// GeoMatchConstraintValueGy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGy = "GY"

	// GeoMatchConstraintValueHt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHt = "HT"

	// GeoMatchConstraintValueHm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHm = "HM"

	// GeoMatchConstraintValueVa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVa = "VA"

	// GeoMatchConstraintValueHn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHn = "HN"

	// GeoMatchConstraintValueHk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHk = "HK"

	// GeoMatchConstraintValueHu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHu = "HU"

	// GeoMatchConstraintValueIs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIs = "IS"

	// GeoMatchConstraintValueIn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIn = "IN"

	// GeoMatchConstraintValueId is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueId = "ID"

	// GeoMatchConstraintValueIr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIr = "IR"

	// GeoMatchConstraintValueIq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIq = "IQ"

	// GeoMatchConstraintValueIe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIe = "IE"

	// GeoMatchConstraintValueIm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIm = "IM"

	// GeoMatchConstraintValueIl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIl = "IL"

	// GeoMatchConstraintValueIt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIt = "IT"

	// GeoMatchConstraintValueJm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJm = "JM"

	// GeoMatchConstraintValueJp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJp = "JP"

	// GeoMatchConstraintValueJe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJe = "JE"

	// GeoMatchConstraintValueJo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJo = "JO"

	// GeoMatchConstraintValueKz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKz = "KZ"

	// GeoMatchConstraintValueKe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKe = "KE"

	// GeoMatchConstraintValueKi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKi = "KI"

	// GeoMatchConstraintValueKp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKp = "KP"

	// GeoMatchConstraintValueKr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKr = "KR"

	// GeoMatchConstraintValueKw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKw = "KW"

	// GeoMatchConstraintValueKg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKg = "KG"

	// GeoMatchConstraintValueLa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLa = "LA"

	// GeoMatchConstraintValueLv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLv = "LV"

	// GeoMatchConstraintValueLb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLb = "LB"

	// GeoMatchConstraintValueLs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLs = "LS"

	// GeoMatchConstraintValueLr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLr = "LR"

	// GeoMatchConstraintValueLy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLy = "LY"

	// GeoMatchConstraintValueLi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLi = "LI"

	// GeoMatchConstraintValueLt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLt = "LT"

	// GeoMatchConstraintValueLu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLu = "LU"

	// GeoMatchConstraintValueMo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMo = "MO"

	// GeoMatchConstraintValueMk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMk = "MK"

	// GeoMatchConstraintValueMg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMg = "MG"

	// GeoMatchConstraintValueMw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMw = "MW"

	// GeoMatchConstraintValueMy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMy = "MY"

	// GeoMatchConstraintValueMv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMv = "MV"

	// GeoMatchConstraintValueMl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMl = "ML"

	// GeoMatchConstraintValueMt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMt = "MT"

	// GeoMatchConstraintValueMh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMh = "MH"

	// GeoMatchConstraintValueMq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMq = "MQ"

	// GeoMatchConstraintValueMr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMr = "MR"

	// GeoMatchConstraintValueMu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMu = "MU"

	// GeoMatchConstraintValueYt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueYt = "YT"

	// GeoMatchConstraintValueMx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMx = "MX"

	// GeoMatchConstraintValueFm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFm = "FM"

	// GeoMatchConstraintValueMd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMd = "MD"

	// GeoMatchConstraintValueMc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMc = "MC"

	// GeoMatchConstraintValueMn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMn = "MN"

	// GeoMatchConstraintValueMe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMe = "ME"

	// GeoMatchConstraintValueMs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMs = "MS"

	// GeoMatchConstraintValueMa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMa = "MA"

	// GeoMatchConstraintValueMz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMz = "MZ"

	// GeoMatchConstraintValueMm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMm = "MM"

	// GeoMatchConstraintValueNa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNa = "NA"

	// GeoMatchConstraintValueNr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNr = "NR"

	// GeoMatchConstraintValueNp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNp = "NP"

	// GeoMatchConstraintValueNl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNl = "NL"

	// GeoMatchConstraintValueNc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNc = "NC"

	// GeoMatchConstraintValueNz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNz = "NZ"

	// GeoMatchConstraintValueNi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNi = "NI"

	// GeoMatchConstraintValueNe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNe = "NE"

	// GeoMatchConstraintValueNg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNg = "NG"

	// GeoMatchConstraintValueNu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNu = "NU"

	// GeoMatchConstraintValueNf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNf = "NF"

	// GeoMatchConstraintValueMp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMp = "MP"

	// GeoMatchConstraintValueNo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNo = "NO"

	// GeoMatchConstraintValueOm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueOm = "OM"

	// GeoMatchConstraintValuePk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePk = "PK"

	// GeoMatchConstraintValuePw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePw = "PW"

	// GeoMatchConstraintValuePs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePs = "PS"

	// GeoMatchConstraintValuePa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePa = "PA"

	// GeoMatchConstraintValuePg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePg = "PG"

	// GeoMatchConstraintValuePy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePy = "PY"

	// GeoMatchConstraintValuePe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePe = "PE"

	// GeoMatchConstraintValuePh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePh = "PH"

	// GeoMatchConstraintValuePn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePn = "PN"

	// GeoMatchConstraintValuePl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePl = "PL"

	// GeoMatchConstraintValuePt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePt = "PT"

	// GeoMatchConstraintValuePr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePr = "PR"

	// GeoMatchConstraintValueQa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueQa = "QA"

	// GeoMatchConstraintValueRe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRe = "RE"

	// GeoMatchConstraintValueRo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRo = "RO"

	// GeoMatchConstraintValueRu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRu = "RU"

	// GeoMatchConstraintValueRw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRw = "RW"

	// GeoMatchConstraintValueBl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBl = "BL"

	// GeoMatchConstraintValueSh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSh = "SH"

	// GeoMatchConstraintValueKn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKn = "KN"

	// GeoMatchConstraintValueLc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLc = "LC"

	// GeoMatchConstraintValueMf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMf = "MF"

	// GeoMatchConstraintValuePm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePm = "PM"

	// GeoMatchConstraintValueVc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVc = "VC"

	// GeoMatchConstraintValueWs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueWs = "WS"

	// GeoMatchConstraintValueSm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSm = "SM"

	// GeoMatchConstraintValueSt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSt = "ST"

	// GeoMatchConstraintValueSa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSa = "SA"

	// GeoMatchConstraintValueSn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSn = "SN"

	// GeoMatchConstraintValueRs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRs = "RS"

	// GeoMatchConstraintValueSc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSc = "SC"

	// GeoMatchConstraintValueSl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSl = "SL"

	// GeoMatchConstraintValueSg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSg = "SG"

	// GeoMatchConstraintValueSx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSx = "SX"

	// GeoMatchConstraintValueSk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSk = "SK"

	// GeoMatchConstraintValueSi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSi = "SI"

	// GeoMatchConstraintValueSb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSb = "SB"

	// GeoMatchConstraintValueSo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSo = "SO"

	// GeoMatchConstraintValueZa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueZa = "ZA"

	// GeoMatchConstraintValueGs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGs = "GS"

	// GeoMatchConstraintValueSs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSs = "SS"

	// GeoMatchConstraintValueEs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEs = "ES"

	// GeoMatchConstraintValueLk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLk = "LK"

	// GeoMatchConstraintValueSd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSd = "SD"

	// GeoMatchConstraintValueSr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSr = "SR"

	// GeoMatchConstraintValueSj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSj = "SJ"

	// GeoMatchConstraintValueSz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSz = "SZ"

	// GeoMatchConstraintValueSe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSe = "SE"

	// GeoMatchConstraintValueCh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCh = "CH"

	// GeoMatchConstraintValueSy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSy = "SY"

	// GeoMatchConstraintValueTw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTw = "TW"

	// GeoMatchConstraintValueTj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTj = "TJ"

	// GeoMatchConstraintValueTz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTz = "TZ"

	// GeoMatchConstraintValueTh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTh = "TH"

	// GeoMatchConstraintValueTl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTl = "TL"

	// GeoMatchConstraintValueTg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTg = "TG"

	// GeoMatchConstraintValueTk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTk = "TK"

	// GeoMatchConstraintValueTo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTo = "TO"

	// GeoMatchConstraintValueTt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTt = "TT"

	// GeoMatchConstraintValueTn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTn = "TN"

	// GeoMatchConstraintValueTr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTr = "TR"

	// GeoMatchConstraintValueTm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTm = "TM"

	// GeoMatchConstraintValueTc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTc = "TC"

	// GeoMatchConstraintValueTv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTv = "TV"

	// GeoMatchConstraintValueUg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUg = "UG"

	// GeoMatchConstraintValueUa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUa = "UA"

	// GeoMatchConstraintValueAe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAe = "AE"

	// GeoMatchConstraintValueGb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGb = "GB"

	// GeoMatchConstraintValueUs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUs = "US"

	// GeoMatchConstraintValueUm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUm = "UM"

	// GeoMatchConstraintValueUy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUy = "UY"

	// GeoMatchConstraintValueUz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUz = "UZ"

	// GeoMatchConstraintValueVu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVu = "VU"

	// GeoMatchConstraintValueVe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVe = "VE"

	// GeoMatchConstraintValueVn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVn = "VN"

	// GeoMatchConstraintValueVg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVg = "VG"

	// GeoMatchConstraintValueVi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVi = "VI"

	// GeoMatchConstraintValueWf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueWf = "WF"

	// GeoMatchConstraintValueEh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEh = "EH"

	// GeoMatchConstraintValueYe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueYe = "YE"

	// GeoMatchConstraintValueZm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueZm = "ZM"

	// GeoMatchConstraintValueZw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueZw = "ZW"
)

const (
	// IPSetDescriptorTypeIpv4 is a IPSetDescriptorType enum value
	IPSetDescriptorTypeIpv4 = "IPV4"

	// IPSetDescriptorTypeIpv6 is a IPSetDescriptorType enum value
	IPSetDescriptorTypeIpv6 = "IPV6"
)

const (
	// MatchFieldTypeUri is a MatchFieldType enum value
	MatchFieldTypeUri = "URI"

	// MatchFieldTypeQueryString is a MatchFieldType enum value
	MatchFieldTypeQueryString = "QUERY_STRING"

	// MatchFieldTypeHeader is a MatchFieldType enum value
	MatchFieldTypeHeader = "HEADER"

	// MatchFieldTypeMethod is a MatchFieldType enum value
	MatchFieldTypeMethod = "METHOD"

	// MatchFieldTypeBody is a MatchFieldType enum value
	MatchFieldTypeBody = "BODY"

	// MatchFieldTypeSingleQueryArg is a MatchFieldType enum value
	MatchFieldTypeSingleQueryArg = "SINGLE_QUERY_ARG"

	// MatchFieldTypeAllQueryArgs is a MatchFieldType enum value
	MatchFieldTypeAllQueryArgs = "ALL_QUERY_ARGS"
)

const (
	// ParameterExceptionFieldChangeAction is a ParameterExceptionField enum value
	ParameterExceptionFieldChangeAction = "CHANGE_ACTION"

	// ParameterExceptionFieldWafAction is a ParameterExceptionField enum value
	ParameterExceptionFieldWafAction = "WAF_ACTION"

	// ParameterExceptionFieldWafOverrideAction is a ParameterExceptionField enum value
	ParameterExceptionFieldWafOverrideAction = "WAF_OVERRIDE_ACTION"

	// ParameterExceptionFieldPredicateType is a ParameterExceptionField enum value
	ParameterExceptionFieldPredicateType = "PREDICATE_TYPE"

	// ParameterExceptionFieldIpsetType is a ParameterExceptionField enum value
	ParameterExceptionFieldIpsetType = "IPSET_TYPE"

	// ParameterExceptionFieldByteMatchFieldType is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchFieldType = "BYTE_MATCH_FIELD_TYPE"

	// ParameterExceptionFieldSqlInjectionMatchFieldType is a ParameterExceptionField enum value
	ParameterExceptionFieldSqlInjectionMatchFieldType = "SQL_INJECTION_MATCH_FIELD_TYPE"

	// ParameterExceptionFieldByteMatchTextTransformation is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchTextTransformation = "BYTE_MATCH_TEXT_TRANSFORMATION"

	// ParameterExceptionFieldByteMatchPositionalConstraint is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchPositionalConstraint = "BYTE_MATCH_POSITIONAL_CONSTRAINT"

	// ParameterExceptionFieldSizeConstraintComparisonOperator is a ParameterExceptionField enum value
	ParameterExceptionFieldSizeConstraintComparisonOperator = "SIZE_CONSTRAINT_COMPARISON_OPERATOR"

	// ParameterExceptionFieldGeoMatchLocationType is a ParameterExceptionField enum value
	ParameterExceptionFieldGeoMatchLocationType = "GEO_MATCH_LOCATION_TYPE"

	// ParameterExceptionFieldGeoMatchLocationValue is a ParameterExceptionField enum value
	ParameterExceptionFieldGeoMatchLocationValue = "GEO_MATCH_LOCATION_VALUE"

	// ParameterExceptionFieldRateKey is a ParameterExceptionField enum value
	ParameterExceptionFieldRateKey = "RATE_KEY"

	// ParameterExceptionFieldRuleType is a ParameterExceptionField enum value
	ParameterExceptionFieldRuleType = "RULE_TYPE"

	// ParameterExceptionFieldNextMarker is a ParameterExceptionField enum value
	ParameterExceptionFieldNextMarker = "NEXT_MARKER"

	// ParameterExceptionFieldResourceArn is a ParameterExceptionField enum value
	ParameterExceptionFieldResourceArn = "RESOURCE_ARN"
)

const (
	// ParameterExceptionReasonInvalidOption is a ParameterExceptionReason enum value
	ParameterExceptionReasonInvalidOption = "INVALID_OPTION"

	// ParameterExceptionReasonIllegalCombination is a ParameterExceptionReason enum value
	ParameterExceptionReasonIllegalCombination = "ILLEGAL_COMBINATION"

	// ParameterExceptionReasonIllegalArgument is a ParameterExceptionReason enum value
	ParameterExceptionReasonIllegalArgument = "ILLEGAL_ARGUMENT"
)

const (
	// PositionalConstraintExactly is a PositionalConstraint enum value
	PositionalConstraintExactly = "EXACTLY"

	// PositionalConstraintStartsWith is a PositionalConstraint enum value
	PositionalConstraintStartsWith = "STARTS_WITH"

	// PositionalConstraintEndsWith is a PositionalConstraint enum value
	PositionalConstraintEndsWith = "ENDS_WITH"

	// PositionalConstraintContains is a PositionalConstraint enum value
	PositionalConstraintContains = "CONTAINS"

	// PositionalConstraintContainsWord is a PositionalConstraint enum value
	PositionalConstraintContainsWord = "CONTAINS_WORD"
)

const (
	// PredicateTypeIpmatch is a PredicateType enum value
	PredicateTypeIpmatch = "IPMatch"

	// PredicateTypeByteMatch is a PredicateType enum value
	PredicateTypeByteMatch = "ByteMatch"

	// PredicateTypeSqlInjectionMatch is a PredicateType enum value
	PredicateTypeSqlInjectionMatch = "SqlInjectionMatch"

	// PredicateTypeGeoMatch is a PredicateType enum value
	PredicateTypeGeoMatch = "GeoMatch"

	// PredicateTypeSizeConstraint is a PredicateType enum value
	PredicateTypeSizeConstraint = "SizeConstraint"

	// PredicateTypeXssMatch is a PredicateType enum value
	PredicateTypeXssMatch = "XssMatch"

	// PredicateTypeRegexMatch is a PredicateType enum value
	PredicateTypeRegexMatch = "RegexMatch"
)

const (
	// RateKeyIp is a RateKey enum value
	RateKeyIp = "IP"
)

const (
	// ResourceTypeApplicationLoadBalancer is a ResourceType enum value
	ResourceTypeApplicationLoadBalancer = "APPLICATION_LOAD_BALANCER"

	// ResourceTypeApiGateway is a ResourceType enum value
	ResourceTypeApiGateway = "API_GATEWAY"
)

const (
	// TextTransformationNone is a TextTransformation enum value
	TextTransformationNone = "NONE"

	// TextTransformationCompressWhiteSpace is a TextTransformation enum value
	TextTransformationCompressWhiteSpace = "COMPRESS_WHITE_SPACE"

	// TextTransformationHtmlEntityDecode is a TextTransformation enum value
	TextTransformationHtmlEntityDecode = "HTML_ENTITY_DECODE"

	// TextTransformationLowercase is a TextTransformation enum value
	TextTransformationLowercase = "LOWERCASE"

	// TextTransformationCmdLine is a TextTransformation enum value
	TextTransformationCmdLine = "CMD_LINE"

	// TextTransformationUrlDecode is a TextTransformation enum value
	TextTransformationUrlDecode = "URL_DECODE"
)

const (
	// WafActionTypeBlock is a WafActionType enum value
	WafActionTypeBlock = "BLOCK"

	// WafActionTypeAllow is a WafActionType enum value
	WafActionTypeAllow = "ALLOW"

	// WafActionTypeCount is a WafActionType enum value
	WafActionTypeCount = "COUNT"
)

const (
	// WafOverrideActionTypeNone is a WafOverrideActionType enum value
	WafOverrideActionTypeNone = "NONE"

	// WafOverrideActionTypeCount is a WafOverrideActionType enum value
	WafOverrideActionTypeCount = "COUNT"
)

const (
	// WafRuleTypeRegular is a WafRuleType enum value
	WafRuleTypeRegular = "REGULAR"

	// WafRuleTypeRateBased is a WafRuleType enum value
	WafRuleTypeRateBased = "RATE_BASED"

	// WafRuleTypeGroup is a WafRuleType enum value
	WafRuleTypeGroup = "GROUP"
)
