// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/machine-config-operator/pkg/apis/machineconfiguration.openshift.io/v1"
	scheme "github.com/openshift/machine-config-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ControllerConfigsGetter has a method to return a ControllerConfigInterface.
// A group's client should implement this interface.
type ControllerConfigsGetter interface {
	ControllerConfigs() ControllerConfigInterface
}

// ControllerConfigInterface has methods to work with ControllerConfig resources.
type ControllerConfigInterface interface {
	Create(*v1.ControllerConfig) (*v1.ControllerConfig, error)
	Update(*v1.ControllerConfig) (*v1.ControllerConfig, error)
	UpdateStatus(*v1.ControllerConfig) (*v1.ControllerConfig, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ControllerConfig, error)
	List(opts metav1.ListOptions) (*v1.ControllerConfigList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ControllerConfig, err error)
	ControllerConfigExpansion
}

// controllerConfigs implements ControllerConfigInterface
type controllerConfigs struct {
	client rest.Interface
}

// newControllerConfigs returns a ControllerConfigs
func newControllerConfigs(c *MachineconfigurationV1Client) *controllerConfigs {
	return &controllerConfigs{
		client: c.RESTClient(),
	}
}

// Get takes name of the controllerConfig, and returns the corresponding controllerConfig object, and an error if there is any.
func (c *controllerConfigs) Get(name string, options metav1.GetOptions) (result *v1.ControllerConfig, err error) {
	result = &v1.ControllerConfig{}
	err = c.client.Get().
		Resource("controllerconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ControllerConfigs that match those selectors.
func (c *controllerConfigs) List(opts metav1.ListOptions) (result *v1.ControllerConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ControllerConfigList{}
	err = c.client.Get().
		Resource("controllerconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested controllerConfigs.
func (c *controllerConfigs) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("controllerconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a controllerConfig and creates it.  Returns the server's representation of the controllerConfig, and an error, if there is any.
func (c *controllerConfigs) Create(controllerConfig *v1.ControllerConfig) (result *v1.ControllerConfig, err error) {
	result = &v1.ControllerConfig{}
	err = c.client.Post().
		Resource("controllerconfigs").
		Body(controllerConfig).
		Do().
		Into(result)
	return
}

// Update takes the representation of a controllerConfig and updates it. Returns the server's representation of the controllerConfig, and an error, if there is any.
func (c *controllerConfigs) Update(controllerConfig *v1.ControllerConfig) (result *v1.ControllerConfig, err error) {
	result = &v1.ControllerConfig{}
	err = c.client.Put().
		Resource("controllerconfigs").
		Name(controllerConfig.Name).
		Body(controllerConfig).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *controllerConfigs) UpdateStatus(controllerConfig *v1.ControllerConfig) (result *v1.ControllerConfig, err error) {
	result = &v1.ControllerConfig{}
	err = c.client.Put().
		Resource("controllerconfigs").
		Name(controllerConfig.Name).
		SubResource("status").
		Body(controllerConfig).
		Do().
		Into(result)
	return
}

// Delete takes name of the controllerConfig and deletes it. Returns an error if one occurs.
func (c *controllerConfigs) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("controllerconfigs").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *controllerConfigs) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("controllerconfigs").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched controllerConfig.
func (c *controllerConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ControllerConfig, err error) {
	result = &v1.ControllerConfig{}
	err = c.client.Patch(pt).
		Resource("controllerconfigs").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
